/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JPanel;

public class ColorCalculator {
    private static final double[][] XYZtoRGBMatrix = new double[][]{{3.240479, -1.53715, -0.498535}, {-0.969256, 1.875992, 0.041556}, {0.055648, -0.204043, 1.057311}};
    private double[][] light = null;
    private double[][] color = null;
    double[][] CIEx = ColorCalculator.parseColor("CIEx");
    double[][] CIEy = ColorCalculator.parseColor("CIEy");
    double[][] CIEz = ColorCalculator.parseColor("CIEz");
    double[][] result = null;

    public ColorCalculator() {
        this.loadLight();
    }

    public void loadLight() {
        this.light = ColorCalculator.parseColor("D65.light");
    }

    public void loadAbsorbSpectrum(String string) {
        this.color = ColorCalculator.parseColor(string);
        this.color = ColorCalculator.interpolateColor(this.color);
    }

    public static double[][] interpolateColor(double[][] dArray) {
        int n;
        for (int i = 0; i < dArray.length - 1; ++i) {
            n = i;
            for (int j = i + 1; j < dArray.length; ++j) {
                if (!(dArray[j][0] < dArray[n][0])) continue;
                n = j;
            }
            double d = dArray[n][0];
            double d2 = dArray[n][1];
            dArray[n][0] = dArray[i][0];
            dArray[n][1] = dArray[i][1];
            dArray[i][0] = d;
            dArray[i][1] = d2;
        }
        double[][] dArray2 = new double[81][2];
        n = 0;
        int n2 = 0;
        for (int i = 0; i < 81; ++i) {
            dArray2[i][0] = 380 + i * 5;
        }
        double[] dArray3 = new double[]{0.0, 0.0};
        double[] dArray4 = new double[]{0.0, 0.0};
        for (int i = 0; i < dArray.length - 1; ++i) {
            dArray4 = dArray3;
            dArray3 = dArray[i];
            while (dArray3[0] >= dArray2[n2][0] && dArray4[0] < dArray2[n2][0]) {
                dArray2[n2][1] = ((dArray3[0] - dArray2[n2][0]) * dArray4[1] + (dArray2[n2][0] - dArray4[0]) * dArray3[1]) / (dArray3[0] - dArray4[0]);
                System.out.println(n2);
                System.out.println(i);
                System.out.println(dArray2[n2][0]);
                System.out.println(dArray3[0]);
                System.out.println(dArray4[0]);
                if (++n2 < 81) continue;
                n = 1;
                break;
            }
            if (n == 1) break;
        }
        return dArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[][] parseColor(String string) {
        byte[] byArray = new byte[(int)new File(string).length()];
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            bufferedInputStream.read(byArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        String string2 = new String(byArray);
        string2 = string2.replace("\t", " ");
        String[] stringArray = string2.split("\n");
        double[][] dArray = new double[stringArray.length][2];
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split(" ");
                dArray[i][0] = Double.parseDouble(stringArray2[0]);
                dArray[i][1] = Double.parseDouble(stringArray2[1]);
            }
        }
        catch (Exception exception) {
            System.err.println("ERROR READING " + string);
            exception.printStackTrace();
        }
        return dArray;
    }

    private static double findMax(double[][] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i][1] > d)) continue;
            d = dArray[i][1];
        }
        return d;
    }

    static double[] XYZtoRGB(double d, double d2, double d3, double[][] dArray) {
        double[] dArray2 = new double[]{dArray[0][0] * d + dArray[0][1] * d2 + dArray[0][2] * d3, dArray[1][0] * d + dArray[1][1] * d2 + dArray[1][2] * d3, dArray[2][0] * d + dArray[2][1] * d2 + dArray[2][2] * d3};
        return dArray2;
    }

    public static double[][] calcIntensitySpec(double[][] dArray, double[][] dArray2, double d) {
        double[][] dArray3 = new double[dArray.length][2];
        double d2 = ColorCalculator.findMax(dArray2);
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i][0] = dArray[i][0];
            dArray3[i][1] = dArray[i][1] * Math.exp(dArray2[i][1] * d / d2);
        }
        return dArray3;
    }

    public static double calcXYZ(double[][] dArray, double[][] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i][1] * dArray2[i][1];
        }
        return 5.0 * d;
    }

    public double[] calculateIlluminatedColor(double d, double d2) {
        if (this.color == null) {
            double[] dArray = new double[]{1.0, 1.0, 1.0};
            return dArray;
        }
        double[][] dArray = this.light;
        if (d == 0.0) {
            d = 1.0E-5;
        }
        double d3 = Math.log(d);
        double[][] dArray2 = ColorCalculator.calcIntensitySpec(dArray, this.color, d3);
        this.result = dArray2;
        double d4 = ColorCalculator.calcXYZ(dArray2, this.CIEx);
        double d5 = ColorCalculator.calcXYZ(dArray2, this.CIEy);
        double d6 = ColorCalculator.calcXYZ(dArray2, this.CIEz);
        double d7 = ColorCalculator.calcXYZ(dArray, this.CIEy);
        double[] dArray3 = ColorCalculator.XYZtoRGB(d4 /= d7, d5 /= d7, d6 /= d7, XYZtoRGBMatrix);
        System.out.println("R= " + dArray3[0] + ", G= " + dArray3[1] + ", B= " + dArray3[2]);
        return dArray3;
    }

    public static double[][] createGaussian(double d, double d2, double d3, double d4) {
        double[][] dArray = ColorCalculator.parseColor("D65.light");
        double[][] dArray2 = new double[dArray.length][2];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i][0] = dArray[i][0];
            dArray2[i][1] = Math.exp(-Math.pow((dArray[i][0] - d) / d2, 2.0)) + Math.exp(-Math.pow((dArray[i][0] - d3) / d4, 2.0));
        }
        return dArray2;
    }

    public JPanel createAbsorbptionGraph() {
        JPanel jPanel = null;
        if (this.color != null) {
            GraphFactory graphFactory = new GraphFactory("Absorbption Spectrum");
            graphFactory.addDataSet("Absorbption spectrum", this.color);
            jPanel = graphFactory.getGraph();
        } else {
            jPanel = new JPanel();
        }
        return jPanel;
    }

    public JPanel createResultLightGraph() {
        JPanel jPanel = null;
        if (this.result != null) {
            GraphFactory graphFactory = new GraphFactory("Result light Spectrum");
            graphFactory.addDataSet("visible spectrum", this.result);
            jPanel = graphFactory.getGraph();
        } else {
            jPanel = new JPanel();
        }
        return jPanel;
    }

    public JPanel createGraph() {
        JPanel jPanel = null;
        if (this.result != null && this.color != null) {
            GraphFactory graphFactory = new GraphFactory("");
            graphFactory.addDataSet("Absorbption spectrum", this.color);
            graphFactory.addDataSet("Visible spectrum", this.result);
            jPanel = graphFactory.getGraph();
        } else {
            jPanel = new JPanel();
        }
        return jPanel;
    }

    private static Double[][] toDouble(double[][] dArray) {
        Double[][] doubleArray = new Double[dArray.length][];
        for (int i = 0; i < dArray.length; ++i) {
            doubleArray[i] = new Double[dArray[i].length];
            for (int j = 0; j < dArray[i].length; ++j) {
                doubleArray[i][j] = new Double(dArray[i][j]);
            }
        }
        return doubleArray;
    }
}

