# encoding: utf-8
"""
icmp.py

Created by Thomas Mangin on 2010-01-15.
Copyright (c) 2009-2017 Exa Networks. All rights reserved.
License: 3-clause BSD. (See the COPYRIGHT file)
"""

from exabgp.protocol.resource import Resource


# ============================================================== ICMP Code Field
# https://www.iana.org/assignments/icmp-parameters

class Port (Resource):
	NAME = 'port'

	def __str__ (self):
		return str(int(self))

	def name (self):
		return self.names.get(self,'%d' % int(self))

	names = {
		1: 'tcpmux',
		2: 'compressnet',
		3: 'compressnet',
		4: 'echo',
		5: 'rje',
		6: 'zip',
		7: 'echo',
		9: 'discard',
		11: 'systat',
		13: 'daytime',
		17: 'qotd',
		18: 'msp',
		19: 'chargen',
		20: 'ftp-data',
		21: 'ftp',
		22: 'ssh',
		23: 'telnet',
		25: 'smtp',
		27: 'nsw-fe',
		29: 'msg-icp',
		31: 'msg-auth',
		33: 'dsp',
		37: 'time',
		38: 'rap',
		39: 'rlp',
		41: 'graphics',
		42: 'name',
		43: 'nicname',
		44: 'mpm-flags',
		45: 'mpm',
		46: 'mpm-snd',
		47: 'ni-ftp',
		48: 'auditd',
		49: 'tacacs',
		50: 're-mail-ck',
		51: 'la-maint',
		52: 'xns-time',
		53: 'domain',
		54: 'xns-ch',
		55: 'isi-gl',
		56: 'xns-auth',
		58: 'xns-mail',
		61: 'ni-mail',
		62: 'acas',
		63: 'whois++',
		64: 'covia',
		65: 'tacacs-ds',
		66: 'sql*net',
		67: 'bootps',
		68: 'bootpc',
		69: 'tftp',
		70: 'gopher',
		71: 'netrjs-1',
		72: 'netrjs-2',
		73: 'netrjs-3',
		74: 'netrjs-4',
		76: 'deos',
		78: 'vettcp',
		79: 'finger',
		80: 'http',
		81: 'hosts2-ns',
		82: 'xfer',
		83: 'mit-ml-dev',
		84: 'ctf',
		85: 'mit-ml-dev',
		86: 'mfcobol',
		88: 'kerberos',
		89: 'su-mit-tg',
		90: 'dnsix',
		91: 'mit-dov',
		92: 'npp',
		93: 'dcp',
		94: 'objcall',
		95: 'supdup',
		96: 'dixie',
		97: 'swift-rvf',
		98: 'tacnews',
		99: 'metagram',
		100: 'newacct',
		101: 'hostname',
		102: 'iso-tsap',
		103: 'gppitnp',
		104: 'acr-nema',
		105: 'csnet-ns',
		106: '3com-tsmux',
		107: 'rtelnet',
		108: 'snagas',
		109: 'pop2',
		110: 'pop3',
		111: 'sunrpc',
		112: 'mcidas',
		113: 'auth',
		114: 'audionews',
		115: 'sftp',
		116: 'ansanotify',
		117: 'uucp-path',
		118: 'sqlserv',
		119: 'nntp',
		120: 'cfdptkt',
		121: 'erpc',
		122: 'smakynet',
		123: 'ntp',
		124: 'ansatrader',
		125: 'locus-map',
		126: 'nxedit',
		127: 'locus-con',
		128: 'gss-xlicen',
		129: 'pwdgen',
		130: 'cisco-fna',
		131: 'cisco-tna',
		132: 'cisco-sys',
		133: 'statsrv',
		134: 'ingres-net',
		135: 'epmap',
		136: 'profile',
		137: 'netbios-ns',
		138: 'netbios-dgm',
		139: 'netbios-ssn',
		140: 'emfis-data',
		141: 'emfis-cntl',
		142: 'bl-idm',
		143: 'imap',
		144: 'uma',
		145: 'uaac',
		146: 'iso-tp0',
		147: 'iso-ip',
		148: 'jargon',
		149: 'aed-512',
		150: 'sql-net',
		151: 'hems',
		152: 'bftp',
		153: 'sgmp',
		154: 'netsc-prod',
		155: 'netsc-dev',
		156: 'sqlsrv',
		157: 'knet-cmp',
		158: 'pcmail-srv',
		159: 'nss-routing',
		160: 'sgmp-traps',
		161: 'snmp',
		162: 'snmptrap',
		163: 'cmip-man',
		164: 'cmip-agent',
		165: 'xns-courier',
		166: 's-net',
		167: 'namp',
		168: 'rsvd',
		169: 'send',
		170: 'print-srv',
		171: 'multiplex',
		172: 'cl/1',
		173: 'xyplex-mux',
		174: 'mailq',
		175: 'vmnet',
		176: 'genrad-mux',
		177: 'xdmcp',
		178: 'nextstep',
		179: 'bgp',
		180: 'ris',
		181: 'unify',
		182: 'audit',
		183: 'ocbinder',
		184: 'ocserver',
		185: 'remote-kis',
		186: 'kis',
		187: 'aci',
		188: 'mumps',
		189: 'qft',
		190: 'gacp',
		191: 'prospero',
		192: 'osu-nms',
		193: 'srmp',
		194: 'irc',
		195: 'dn6-nlm-aud',
		196: 'dn6-smm-red',
		197: 'dls',
		198: 'dls-mon',
		199: 'smux',
		200: 'src',
		201: 'at-rtmp',
		202: 'at-nbp',
		203: 'at-3',
		204: 'at-echo',
		205: 'at-5',
		206: 'at-zis',
		207: 'at-7',
		208: 'at-8',
		209: 'qmtp',
		210: 'z39.50',
		211: '914c/g',
		212: 'anet',
		213: 'ipx',
		214: 'vmpwscs',
		215: 'softpc',
		216: 'CAIlic',
		217: 'dbase',
		218: 'mpp',
		219: 'uarps',
		220: 'imap3',
		221: 'fln-spx',
		222: 'rsh-spx',
		223: 'cdc',
		224: 'masqdialer',
		242: 'direct',
		243: 'sur-meas',
		244: 'inbusiness',
		245: 'link',
		246: 'dsp3270',
		247: 'subntbcst_tftp',
		248: 'bhfhs',
		256: 'rap',
		257: 'set',
		258: 'yak-chat',
		259: 'esro-gen',
		260: 'openport',
		261: 'nsiiops',
		262: 'arcisdms',
		263: 'hdap',
		264: 'bgmp',
		265: 'x-bone-ctl',
		266: 'sst',
		267: 'td-service',
		268: 'td-replica',
		280: 'http-mgmt',
		281: 'personal-link',
		282: 'cableport-ax',
		283: 'rescap',
		284: 'corerjd',
		286: 'fxp-1',
		287: 'k-block',
		308: 'novastorbakcup',
		309: 'entrusttime',
		310: 'bhmds',
		311: 'asip-webadmin',
		312: 'vslmp',
		313: 'magenta-logic',
		314: 'opalis-robot',
		315: 'dpsi',
		316: 'decauth',
		317: 'zannet',
		318: 'pkix-timestamp',
		319: 'ptp-event',
		320: 'ptp-general',
		321: 'pip',
		322: 'rtsps',
		333: 'texar',
		344: 'pdap',
		345: 'pawserv',
		346: 'zserv',
		347: 'fatserv',
		348: 'csi-sgwp',
		349: 'mftp',
		350: 'matip-type-a',
		351: 'bhoetty',
		352: 'bhoedap4',
		353: 'ndsauth',
		354: 'bh611',
		355: 'datex-asn',
		356: 'cloanto-net-1',
		357: 'bhevent',
		358: 'shrinkwrap',
		359: 'nsrmp',
		360: 'scoi2odialog',
		361: 'semantix',
		362: 'srssend',
		363: 'rsvp_tunnel',
		364: 'aurora-cmgr',
		365: 'dtk',
		366: 'odmr',
		367: 'mortgageware',
		368: 'qbikgdp',
		369: 'rpc2portmap',
		370: 'codaauth2',
		371: 'clearcase',
		372: 'ulistproc',
		373: 'legent-1',
		374: 'legent-2',
		375: 'hassle',
		376: 'nip',
		377: 'tnETOS',
		378: 'dsETOS',
		379: 'is99c',
		380: 'is99s',
		381: 'hp-collector',
		382: 'hp-managed-node',
		383: 'hp-alarm-mgr',
		384: 'arns',
		385: 'ibm-app',
		386: 'asa',
		387: 'aurp',
		388: 'unidata-ldm',
		389: 'ldap',
		390: 'uis',
		391: 'synotics-relay',
		392: 'synotics-broker',
		393: 'meta5',
		394: 'embl-ndt',
		395: 'netcp',
		396: 'netware-ip',
		397: 'mptn',
		398: 'kryptolan',
		399: 'iso-tsap-c2',
		400: 'work-sol',
		401: 'ups',
		402: 'genie',
		403: 'decap',
		404: 'nced',
		405: 'ncld',
		406: 'imsp',
		407: 'timbuktu',
		408: 'prm-sm',
		409: 'prm-nm',
		410: 'decladebug',
		411: 'rmt',
		412: 'synoptics-trap',
		413: 'smsp',
		414: 'infoseek',
		415: 'bnet',
		416: 'silverplatter',
		417: 'onmux',
		418: 'hyper-g',
		419: 'ariel1',
		420: 'smpte',
		421: 'ariel2',
		422: 'ariel3',
		423: 'opc-job-start',
		424: 'opc-job-track',
		425: 'icad-el',
		426: 'smartsdp',
		427: 'svrloc',
		428: 'ocs_cmu',
		429: 'ocs_amu',
		430: 'utmpsd',
		431: 'utmpcd',
		432: 'iasd',
		433: 'nnsp',
		434: 'mobileip-agent',
		435: 'mobilip-mn',
		436: 'dna-cml',
		437: 'comscm',
		438: 'dsfgw',
		439: 'dasp',
		440: 'sgcp',
		441: 'decvms-sysmgt',
		442: 'cvc_hostd',
		443: 'https',
		444: 'snpp',
		445: 'microsoft-ds',
		446: 'ddm-rdb',
		447: 'ddm-dfm',
		448: 'ddm-ssl',
		449: 'as-servermap',
		450: 'tserver',
		451: 'sfs-smp-net',
		452: 'sfs-config',
		453: 'creativeserver',
		454: 'contentserver',
		455: 'creativepartnr',
		456: 'macon-tcp',
		457: 'scohelp',
		458: 'appleqtc',
		459: 'ampr-rcmd',
		460: 'skronk',
		461: 'datasurfsrv',
		462: 'datasurfsrvsec',
		463: 'alpes',
		464: 'kpasswd',
		465: 'urd',
		466: 'digital-vrc',
		467: 'mylex-mapd',
		468: 'photuris',
		469: 'rcp',
		470: 'scx-proxy',
		471: 'mondex',
		472: 'ljk-login',
		473: 'hybrid-pop',
		474: 'tn-tl-w1',
		475: 'tcpnethaspsrv',
		476: 'tn-tl-fd1',
		477: 'ss7ns',
		478: 'spsc',
		479: 'iafserver',
		480: 'iafdbase',
		481: 'ph',
		482: 'bgs-nsi',
		483: 'ulpnet',
		484: 'integra-sme',
		485: 'powerburst',
		486: 'avian',
		487: 'saft',
		488: 'gss-http',
		489: 'nest-protocol',
		490: 'micom-pfs',
		491: 'go-login',
		492: 'ticf-1',
		493: 'ticf-2',
		494: 'pov-ray',
		495: 'intecourier',
		496: 'pim-rp-disc',
		497: 'dantz',
		498: 'siam',
		499: 'iso-ill',
		500: 'isakmp',
		501: 'stmf',
		502: 'asa-appl-proto',
		503: 'intrinsa',
		504: 'citadel',
		505: 'mailbox-lm',
		506: 'ohimsrv',
		507: 'crs',
		508: 'xvttp',
		509: 'snare',
		510: 'fcp',
		511: 'passgo',
		512: 'comsat',
		513: 'who',
		514: 'syslog',
		515: 'printer',
		516: 'videotex',
		517: 'talk',
		518: 'ntalk',
		519: 'utime',
		520: 'efs',
		521: 'ripng',
		522: 'ulp',
		523: 'ibm-db2',
		524: 'ncp',
		525: 'timed',
		526: 'tempo',
		527: 'stx',
		528: 'custix',
		529: 'irc-serv',
		530: 'courier',
		531: 'conference',
		532: 'netnews',
		533: 'netwall',
		534: 'mm-admin',
		535: 'iiop',
		536: 'opalis-rdv',
		537: 'nmsp',
		538: 'gdomap',
		539: 'apertus-ldp',
		540: 'uucp',
		541: 'uucp-rlogin',
		542: 'commerce',
		543: 'klogin',
		544: 'kshell',
		545: 'appleqtcsrvr',
		546: 'dhcpv6-client',
		547: 'dhcpv6-server',
		548: 'afpovertcp',
		549: 'idfp',
		550: 'new-rwho',
		551: 'cybercash',
		552: 'devshr-nts',
		553: 'pirp',
		554: 'rtsp',
		555: 'dsf',
		556: 'remotefs',
		557: 'openvms-sysipc',
		558: 'sdnskmp',
		559: 'teedtap',
		560: 'rmonitor',
		561: 'monitor',
		562: 'chshell',
		563: 'nntps',
		564: '9pfs',
		565: 'whoami',
		566: 'streettalk',
		567: 'banyan-rpc',
		568: 'ms-shuttle',
		569: 'ms-rome',
		570: 'meter',
		571: 'meter',
		572: 'sonar',
		573: 'banyan-vip',
		574: 'ftp-agent',
		575: 'vemmi',
		576: 'ipcd',
		577: 'vnas',
		578: 'ipdd',
		579: 'decbsrv',
		580: 'sntp-heartbeat',
		581: 'bdp',
		582: 'scc-security',
		583: 'philips-vc',
		584: 'keyserver',
		585: 'imap4-ssl',
		586: 'password-chg',
		587: 'submission',
		588: 'cal',
		589: 'eyelink',
		590: 'tns-cml',
		591: 'http-alt',
		592: 'eudora-set',
		593: 'http-rpc-epmap',
		594: 'tpip',
		595: 'cab-protocol',
		596: 'smsd',
		597: 'ptcnameservice',
		598: 'sco-websrvrmg3',
		599: 'acp',
		600: 'ipcserver',
		601: 'syslog-conn',
		602: 'xmlrpc-beep',
		603: 'idxp',
		604: 'tunnel',
		605: 'soap-beep',
		606: 'urm',
		607: 'nqs',
		608: 'sift-uft',
		609: 'npmp-trap',
		610: 'npmp-local',
		611: 'npmp-gui',
		612: 'hmmp-ind',
		613: 'hmmp-op',
		614: 'sshell',
		615: 'sco-inetmgr',
		616: 'sco-sysmgr',
		617: 'sco-dtmgr',
		618: 'dei-icda',
		619: 'compaq-evm',
		620: 'sco-websrvrmgr',
		621: 'escp-ip',
		622: 'collaborator',
		623: 'asf-rmcp',
		624: 'cryptoadmin',
		625: 'dec_dlm',
		626: 'asia',
		627: 'passgo-tivoli',
		628: 'qmqp',
		629: '3com-amp3',
		630: 'rda',
		631: 'ipp',
		632: 'bmpp',
		633: 'servstat',
		634: 'ginad',
		635: 'rlzdbase',
		636: 'ldaps',
		637: 'lanserver',
		638: 'mcns-sec',
		639: 'msdp',
		640: 'entrust-sps',
		641: 'repcmd',
		642: 'esro-emsdp',
		643: 'sanity',
		644: 'dwr',
		645: 'pssc',
		646: 'ldp',
		647: 'dhcp-failover',
		648: 'rrp',
		649: 'cadview-3d',
		650: 'obex',
		651: 'ieee-mms',
		652: 'hello-port',
		653: 'repscmd',
		654: 'aodv',
		655: 'tinc',
		656: 'spmp',
		657: 'rmc',
		658: 'tenfold',
		660: 'mac-srvr-admin',
		661: 'hap',
		662: 'pftp',
		663: 'purenoise',
		664: 'asf-secure-rmcp',
		665: 'sun-dr',
		666: 'mdqs',
		667: 'disclose',
		668: 'mecomm',
		669: 'meregister',
		670: 'vacdsm-sws',
		671: 'vacdsm-app',
		672: 'vpps-qua',
		673: 'cimplex',
		674: 'acap',
		675: 'dctp',
		676: 'vpps-via',
		677: 'vpp',
		678: 'ggf-ncp',
		679: 'mrm',
		680: 'entrust-aaas',
		681: 'entrust-aams',
		682: 'xfr',
		683: 'corba-iiop',
		684: 'corba-iiop-ssl',
		685: 'mdc-portmapper',
		686: 'hcp-wismar',
		687: 'asipregistry',
		688: 'realm-rusd',
		689: 'nmap',
		690: 'vatp',
		691: 'msexch-routing',
		692: 'hyperwave-isp',
		693: 'connendp',
		694: 'ha-cluster',
		695: 'ieee-mms-ssl',
		696: 'rushd',
		697: 'uuidgen',
		698: 'olsr',
		699: 'accessnetwork',
		700: 'epp',
		701: 'lmp',
		702: 'iris-beep',
		704: 'elcsd',
		705: 'agentx',
		706: 'silc',
		707: 'borland-dsj',
		709: 'entrust-kmsh',
		710: 'entrust-ash',
		711: 'cisco-tdp',
		712: 'tbrpf',
		729: 'netviewdm1',
		730: 'netviewdm2',
		731: 'netviewdm3',
		741: 'netgw',
		742: 'netrcs',
		744: 'flexlm',
		747: 'fujitsu-dev',
		748: 'ris-cm',
		749: 'kerberos-adm',
		750: 'rfile',
		751: 'pump',
		752: 'qrh',
		753: 'rrh',
		754: 'tell',
		758: 'nlogin',
		759: 'con',
		760: 'ns',
		761: 'rxe',
		762: 'quotad',
		763: 'cycleserv',
		764: 'omserv',
		765: 'webster',
		767: 'phonebook',
		769: 'vid',
		770: 'cadlock',
		771: 'rtip',
		772: 'cycleserv2',
		773: 'submit',
		774: 'rpasswd',
		775: 'entomb',
		776: 'wpages',
		777: 'multiling-http',
		780: 'wpgs',
		800: 'mdbs_daemon',
		801: 'device',
		810: 'fcp-udp',
		828: 'itm-mcell-s',
		829: 'pkix-3-ca-ra',
		830: 'netconf-ssh',
		831: 'netconf-beep',
		832: 'netconfsoaphttp',
		833: 'netconfsoapbeep',
		847: 'dhcp-failover2',
		848: 'gdoi',
		860: 'iscsi',
		861: 'owamp-control',
		873: 'rsync',
		886: 'iclcnet-locate',
		887: 'iclcnet_svinfo',
		888: 'cddbp',
		900: 'omginitialrefs',
		901: 'smpnameres',
		902: 'ideafarm-chat',
		903: 'ideafarm-catch',
		910: 'kink',
		911: 'xact-backup',
		912: 'apex-mesh',
		913: 'apex-edge',
		989: 'ftps-data',
		990: 'ftps',
		991: 'nas',
		992: 'telnets',
		993: 'imaps',
		994: 'ircs',
		995: 'pop3s',
		996: 'vsinet',
		997: 'maitrd',
		998: 'busboy',
		999: 'garcon',
		1000: 'cadlock2',
		1010: 'surf',
		1021: 'exp1',
		1022: 'exp2',
		1025: 'blackjack',
		1026: 'cap',
		1027: 'exosee',
		1029: 'solid-mux',
		1030: 'iad1',
		1031: 'iad2',
		1032: 'iad3',
		1033: 'netinfo-local',
		1034: 'activesync',
		1035: 'mxxrlogin',
		1036: 'pcg-radar',
		1037: 'ams',
		1038: 'mtqp',
		1039: 'sbl',
		1040: 'netarx',
		1041: 'danf-ak2',
		1042: 'afrog',
		1043: 'boinc-client',
		1044: 'dcutility',
		1045: 'fpitp',
		1046: 'wfremotertm',
		1047: 'neod1',
		1048: 'neod2',
		1049: 'td-postman',
		1050: 'cma',
		1051: 'optima-vnet',
		1052: 'ddt',
		1053: 'remote-as',
		1054: 'brvread',
		1055: 'ansyslmd',
		1056: 'vfo',
		1057: 'startron',
		1058: 'nim',
		1059: 'nimreg',
		1060: 'polestar',
		1061: 'kiosk',
		1062: 'veracity',
		1063: 'kyoceranetdev',
		1064: 'jstel',
		1065: 'syscomlan',
		1066: 'fpo-fns',
		1067: 'instl_boots',
		1068: 'instl_bootc',
		1069: 'cognex-insight',
		1070: 'gmrupdateserv',
		1071: 'bsquare-voip',
		1072: 'cardax',
		1073: 'bridgecontrol',
		1074: 'fastechnologlm',
		1075: 'rdrmshc',
		1076: 'dab-sti-c',
		1077: 'imgames',
		1078: 'avocent-proxy',
		1079: 'asprovatalk',
		1080: 'socks',
		1081: 'pvuniwien',
		1082: 'amt-esd-prot',
		1083: 'ansoft-lm-1',
		1084: 'ansoft-lm-2',
		1085: 'webobjects',
		1086: 'cplscrambler-lg',
		1087: 'cplscrambler-in',
		1088: 'cplscrambler-al',
		1089: 'ff-annunc',
		1090: 'ff-fms',
		1091: 'ff-sm',
		1092: 'obrpd',
		1093: 'proofd',
		1094: 'rootd',
		1095: 'nicelink',
		1096: 'cnrprotocol',
		1097: 'sunclustermgr',
		1098: 'rmiactivation',
		1099: 'rmiregistry',
		1100: 'mctp',
		1101: 'pt2-discover',
		1102: 'adobeserver-1',
		1103: 'adobeserver-2',
		1104: 'xrl',
		1105: 'ftranhc',
		1106: 'isoipsigport-1',
		1107: 'isoipsigport-2',
		1108: 'ratio-adp',
		1110: 'nfsd-status',
		1111: 'lmsocialserver',
		1112: 'icp',
		1113: 'ltp-deepspace',
		1114: 'mini-sql',
		1115: 'ardus-trns',
		1116: 'ardus-cntl',
		1117: 'ardus-mtrns',
		1118: 'sacred',
		1119: 'bnetgame',
		1120: 'bnetfile',
		1121: 'rmpp',
		1122: 'availant-mgr',
		1123: 'murray',
		1124: 'hpvmmcontrol',
		1125: 'hpvmmagent',
		1126: 'hpvmmdata',
		1127: 'kwdb-commn',
		1128: 'saphostctrl',
		1129: 'saphostctrls',
		1130: 'casp',
		1131: 'caspssl',
		1132: 'kvm-via-ip',
		1133: 'dfn',
		1134: 'aplx',
		1135: 'omnivision',
		1136: 'hhb-gateway',
		1137: 'trim',
		1140: 'autonoc',
		1141: 'mxomss',
		1142: 'edtools',
		1143: 'imyx',
		1144: 'fuscript',
		1145: 'x9-icue',
		1146: 'audit-transfer',
		1147: 'capioverlan',
		1148: 'elfiq-repl',
		1149: 'bvtsonar',
		1150: 'blaze',
		1151: 'unizensus',
		1152: 'winpoplanmess',
		1153: 'c1222-acse',
		1154: 'resacommunity',
		1155: 'nfa',
		1156: 'iascontrol-oms',
		1157: 'iascontrol',
		1158: 'dbcontrol-oms',
		1159: 'oracle-oms',
		1160: 'olsv',
		1161: 'health-polling',
		1162: 'health-trap',
		1163: 'sddp',
		1164: 'qsm-proxy',
		1165: 'qsm-gui',
		1166: 'qsm-remote',
		1167: 'cisco-ipsla',
		1168: 'vchat',
		1169: 'tripwire',
		1170: 'atc-lm',
		1171: 'atc-appserver',
		1172: 'dnap',
		1173: 'd-cinema-rrp',
		1174: 'fnet-remote-ui',
		1175: 'dossier',
		1176: 'indigo-server',
		1177: 'dkmessenger',
		1178: 'sgi-storman',
		1179: 'b2n',
		1180: 'mc-client',
		1181: '3comnetman',
		1182: 'accelenet',
		1183: 'llsurfup-http',
		1184: 'llsurfup-https',
		1185: 'catchpole',
		1186: 'mysql-cluster',
		1187: 'alias',
		1188: 'hp-webadmin',
		1189: 'unet',
		1190: 'commlinx-avl',
		1191: 'gpfs',
		1192: 'caids-sensor',
		1193: 'fiveacross',
		1194: 'openvpn',
		1195: 'rsf-1',
		1196: 'netmagic',
		1197: 'carrius-rshell',
		1198: 'cajo-discovery',
		1199: 'dmidi',
		1200: 'scol',
		1201: 'nucleus-sand',
		1202: 'caiccipc',
		1203: 'ssslic-mgr',
		1204: 'ssslog-mgr',
		1205: 'accord-mgc',
		1206: 'anthony-data',
		1207: 'metasage',
		1208: 'seagull-ais',
		1209: 'ipcd3',
		1210: 'eoss',
		1211: 'groove-dpp',
		1212: 'lupa',
		1213: 'mpc-lifenet',
		1214: 'kazaa',
		1215: 'scanstat-1',
		1216: 'etebac5',
		1217: 'hpss-ndapi',
		1218: 'aeroflight-ads',
		1219: 'aeroflight-ret',
		1220: 'qt-serveradmin',
		1221: 'sweetware-apps',
		1222: 'nerv',
		1223: 'tgp',
		1224: 'vpnz',
		1225: 'slinkysearch',
		1226: 'stgxfws',
		1227: 'dns2go',
		1228: 'florence',
		1229: 'novell-zfs',
		1230: 'periscope',
		1231: 'menandmice-lpm',
		1233: 'univ-appserver',
		1234: 'search-agent',
		1235: 'mosaicsyssvc1',
		1236: 'bvcontrol',
		1237: 'tsdos390',
		1238: 'hacl-qs',
		1239: 'nmsd',
		1240: 'instantia',
		1241: 'nessus',
		1242: 'nmasoverip',
		1243: 'serialgateway',
		1244: 'isbconference1',
		1245: 'isbconference2',
		1246: 'payrouter',
		1247: 'visionpyramid',
		1248: 'hermes',
		1249: 'mesavistaco',
		1250: 'swldy-sias',
		1251: 'servergraph',
		1252: 'bspne-pcc',
		1253: 'q55-pcc',
		1254: 'de-noc',
		1255: 'de-cache-query',
		1256: 'de-server',
		1257: 'shockwave2',
		1258: 'opennl',
		1259: 'opennl-voice',
		1260: 'ibm-ssd',
		1261: 'mpshrsv',
		1262: 'qnts-orb',
		1263: 'dka',
		1264: 'prat',
		1265: 'dssiapi',
		1266: 'dellpwrappks',
		1267: 'epc',
		1268: 'propel-msgsys',
		1269: 'watilapp',
		1270: 'opsmgr',
		1271: 'dabew',
		1272: 'cspmlockmgr',
		1273: 'emc-gateway',
		1274: 't1distproc',
		1275: 'ivcollector',
		1276: 'ivmanager',
		1277: 'miva-mqs',
		1278: 'dellwebadmin-1',
		1279: 'dellwebadmin-2',
		1280: 'pictrography',
		1281: 'healthd',
		1282: 'emperion',
		1283: 'productinfo',
		1284: 'iee-qfx',
		1285: 'neoiface',
		1286: 'netuitive',
		1287: 'routematch',
		1288: 'navbuddy',
		1289: 'jwalkserver',
		1290: 'winjaserver',
		1291: 'seagulllms',
		1292: 'dsdn',
		1293: 'pkt-krb-ipsec',
		1294: 'cmmdriver',
		1295: 'ehtp',
		1296: 'dproxy',
		1297: 'sdproxy',
		1298: 'lpcp',
		1299: 'hp-sci',
		1300: 'h323hostcallsc',
		1301: 'ci3-software-1',
		1302: 'ci3-software-2',
		1303: 'sftsrv',
		1304: 'boomerang',
		1305: 'pe-mike',
		1306: 're-conn-proto',
		1307: 'pacmand',
		1308: 'odsi',
		1309: 'jtag-server',
		1310: 'husky',
		1311: 'rxmon',
		1312: 'sti-envision',
		1313: 'bmc_patroldb',
		1314: 'pdps',
		1315: 'els',
		1316: 'exbit-escp',
		1317: 'vrts-ipcserver',
		1318: 'krb5gatekeeper',
		1319: 'panja-icsp',
		1320: 'panja-axbnet',
		1321: 'pip',
		1322: 'novation',
		1323: 'brcd',
		1324: 'delta-mcp',
		1325: 'dx-instrument',
		1326: 'wimsic',
		1327: 'ultrex',
		1328: 'ewall',
		1329: 'netdb-export',
		1330: 'streetperfect',
		1331: 'intersan',
		1332: 'pcia-rxp-b',
		1333: 'passwrd-policy',
		1334: 'writesrv',
		1335: 'digital-notary',
		1336: 'ischat',
		1337: 'menandmice-dns',
		1338: 'wmc-log-svc',
		1339: 'kjtsiteserver',
		1340: 'naap',
		1341: 'qubes',
		1342: 'esbroker',
		1343: 're101',
		1344: 'icap',
		1345: 'vpjp',
		1346: 'alta-ana-lm',
		1347: 'bbn-mmc',
		1348: 'bbn-mmx',
		1349: 'sbook',
		1350: 'editbench',
		1351: 'equationbuilder',
		1352: 'lotusnote',
		1353: 'relief',
		1354: 'rightbrain',
		1355: 'intuitive-edge',
		1356: 'cuillamartin',
		1357: 'pegboard',
		1358: 'connlcli',
		1359: 'ftsrv',
		1360: 'mimer',
		1361: 'linx',
		1362: 'timeflies',
		1363: 'ndm-requester',
		1364: 'ndm-server',
		1365: 'adapt-sna',
		1366: 'netware-csp',
		1367: 'dcs',
		1368: 'screencast',
		1369: 'gv-us',
		1370: 'us-gv',
		1371: 'fc-cli',
		1372: 'fc-ser',
		1373: 'chromagrafx',
		1374: 'molly',
		1375: 'bytex',
		1376: 'ibm-pps',
		1377: 'cichlid',
		1378: 'elan',
		1379: 'dbreporter',
		1380: 'telesis-licman',
		1381: 'apple-licman',
		1382: 'udt_os',
		1383: 'gwha',
		1384: 'os-licman',
		1385: 'atex_elmd',
		1386: 'checksum',
		1387: 'cadsi-lm',
		1388: 'objective-dbc',
		1389: 'iclpv-dm',
		1390: 'iclpv-sc',
		1391: 'iclpv-sas',
		1392: 'iclpv-pm',
		1393: 'iclpv-nls',
		1394: 'iclpv-nlc',
		1395: 'iclpv-wsm',
		1396: 'dvl-activemail',
		1397: 'audio-activmail',
		1398: 'video-activmail',
		1399: 'cadkey-licman',
		1400: 'cadkey-tablet',
		1401: 'goldleaf-licman',
		1402: 'prm-sm-np',
		1403: 'prm-nm-np',
		1404: 'igi-lm',
		1405: 'ibm-res',
		1406: 'netlabs-lm',
		1407: 'dbsa-lm',
		1408: 'sophia-lm',
		1409: 'here-lm',
		1410: 'hiq',
		1411: 'af',
		1412: 'innosys',
		1413: 'innosys-acl',
		1414: 'ibm-mqseries',
		1415: 'dbstar',
		1416: 'novell-lu6.2',
		1417: 'timbuktu-srv1',
		1418: 'timbuktu-srv2',
		1419: 'timbuktu-srv3',
		1420: 'timbuktu-srv4',
		1421: 'gandalf-lm',
		1422: 'autodesk-lm',
		1423: 'essbase',
		1424: 'hybrid',
		1425: 'zion-lm',
		1426: 'sais',
		1427: 'mloadd',
		1428: 'informatik-lm',
		1429: 'nms',
		1430: 'tpdu',
		1431: 'rgtp',
		1432: 'blueberry-lm',
		1433: 'ms-sql-s',
		1434: 'ms-sql-m',
		1435: 'ibm-cics',
		1436: 'saism',
		1437: 'tabula',
		1438: 'eicon-server',
		1439: 'eicon-x25',
		1440: 'eicon-slp',
		1441: 'cadis-1',
		1442: 'cadis-2',
		1443: 'ies-lm',
		1444: 'marcam-lm',
		1445: 'proxima-lm',
		1446: 'ora-lm',
		1447: 'apri-lm',
		1448: 'oc-lm',
		1449: 'peport',
		1450: 'dwf',
		1451: 'infoman',
		1452: 'gtegsc-lm',
		1453: 'genie-lm',
		1454: 'interhdl_elmd',
		1455: 'esl-lm',
		1456: 'dca',
		1457: 'valisys-lm',
		1458: 'nrcabq-lm',
		1459: 'proshare1',
		1460: 'proshare2',
		1461: 'ibm_wrless_lan',
		1462: 'world-lm',
		1463: 'nucleus',
		1464: 'msl_lmd',
		1465: 'pipes',
		1466: 'oceansoft-lm',
		1467: 'csdmbase',
		1468: 'csdm',
		1469: 'aal-lm',
		1470: 'uaiact',
		1471: 'csdmbase',
		1472: 'csdm',
		1473: 'openmath',
		1474: 'telefinder',
		1475: 'taligent-lm',
		1476: 'clvm-cfg',
		1477: 'ms-sna-server',
		1478: 'ms-sna-base',
		1479: 'dberegister',
		1480: 'pacerforum',
		1481: 'airs',
		1482: 'miteksys-lm',
		1483: 'afs',
		1484: 'confluent',
		1485: 'lansource',
		1486: 'nms_topo_serv',
		1487: 'localinfosrvr',
		1488: 'docstor',
		1489: 'dmdocbroker',
		1490: 'insitu-conf',
		1491: 'anynetgateway',
		1492: 'stone-design-1',
		1493: 'netmap_lm',
		1494: 'ica',
		1495: 'cvc',
		1496: 'liberty-lm',
		1497: 'rfx-lm',
		1498: 'sybase-sqlany',
		1499: 'fhc',
		1500: 'vlsi-lm',
		1501: 'saiscm',
		1502: 'shivadiscovery',
		1503: 'imtc-mcs',
		1504: 'evb-elm',
		1505: 'funkproxy',
		1506: 'utcd',
		1507: 'symplex',
		1508: 'diagmond',
		1509: 'robcad-lm',
		1510: 'mvx-lm',
		1511: '3l-l1',
		1512: 'wins',
		1513: 'fujitsu-dtc',
		1514: 'fujitsu-dtcns',
		1515: 'ifor-protocol',
		1516: 'vpad',
		1517: 'vpac',
		1518: 'vpvd',
		1519: 'vpvc',
		1520: 'atm-zip-office',
		1521: 'ncube-lm',
		1522: 'ricardo-lm',
		1523: 'cichild-lm',
		1524: 'ingreslock',
		1525: 'orasrv',
		1526: 'pdap-np',
		1527: 'tlisrv',
		1528: 'mciautoreg',
		1529: 'coauthor',
		1530: 'rap-service',
		1531: 'rap-listen',
		1532: 'miroconnect',
		1533: 'virtual-places',
		1534: 'micromuse-lm',
		1535: 'ampr-info',
		1536: 'ampr-inter',
		1537: 'sdsc-lm',
		1538: '3ds-lm',
		1539: 'intellistor-lm',
		1540: 'rds',
		1541: 'rds2',
		1542: 'gridgen-elmd',
		1543: 'simba-cs',
		1544: 'aspeclmd',
		1545: 'vistium-share',
		1546: 'abbaccuray',
		1547: 'laplink',
		1548: 'axon-lm',
		1549: 'shivahose',
		1550: '3m-image-lm',
		1551: 'hecmtl-db',
		1552: 'pciarray',
		1553: 'sna-cs',
		1554: 'caci-lm',
		1555: 'livelan',
		1556: 'ashwin',
		1557: 'arbortext-lm',
		1558: 'xingmpeg',
		1559: 'web2host',
		1560: 'asci-val',
		1561: 'facilityview',
		1562: 'pconnectmgr',
		1563: 'cadabra-lm',
		1564: 'pay-per-view',
		1565: 'winddlb',
		1566: 'corelvideo',
		1567: 'jlicelmd',
		1568: 'tsspmap',
		1569: 'ets',
		1570: 'orbixd',
		1571: 'rdb-dbs-disp',
		1572: 'chip-lm',
		1573: 'itscomm-ns',
		1574: 'mvel-lm',
		1575: 'oraclenames',
		1576: 'moldflow-lm',
		1577: 'hypercube-lm',
		1578: 'jacobus-lm',
		1579: 'ioc-sea-lm',
		1580: 'tn-tl-r1',
		1581: 'mil-2045-47001',
		1582: 'msims',
		1583: 'simbaexpress',
		1584: 'tn-tl-fd2',
		1585: 'intv',
		1586: 'ibm-abtact',
		1587: 'pra_elmd',
		1588: 'triquest-lm',
		1589: 'vqp',
		1590: 'gemini-lm',
		1591: 'ncpm-pm',
		1592: 'commonspace',
		1593: 'mainsoft-lm',
		1594: 'sixtrak',
		1595: 'radio',
		1596: 'radio-sm',
		1597: 'orbplus-iiop',
		1598: 'picknfs',
		1599: 'simbaservices',
		1600: 'issd',
		1601: 'aas',
		1602: 'inspect',
		1603: 'picodbc',
		1604: 'icabrowser',
		1605: 'slp',
		1606: 'slm-api',
		1607: 'stt',
		1608: 'smart-lm',
		1609: 'isysg-lm',
		1610: 'taurus-wh',
		1611: 'ill',
		1612: 'netbill-trans',
		1613: 'netbill-keyrep',
		1614: 'netbill-cred',
		1615: 'netbill-auth',
		1616: 'netbill-prod',
		1617: 'nimrod-agent',
		1618: 'skytelnet',
		1619: 'xs-openstorage',
		1620: 'faxportwinport',
		1621: 'softdataphone',
		1622: 'ontime',
		1623: 'jaleosnd',
		1624: 'udp-sr-port',
		1625: 'svs-omagent',
		1626: 'shockwave',
		1627: 't128-gateway',
		1628: 'lontalk-norm',
		1629: 'lontalk-urgnt',
		1630: 'oraclenet8cman',
		1631: 'visitview',
		1632: 'pammratc',
		1633: 'pammrpc',
		1634: 'loaprobe',
		1635: 'edb-server1',
		1636: 'cncp',
		1637: 'cnap',
		1638: 'cnip',
		1639: 'cert-initiator',
		1640: 'cert-responder',
		1641: 'invision',
		1642: 'isis-am',
		1643: 'isis-ambc',
		1644: 'saiseh',
		1645: 'sightline',
		1646: 'sa-msg-port',
		1647: 'rsap',
		1648: 'concurrent-lm',
		1649: 'kermit',
		1650: 'nkd',
		1651: 'shiva_confsrvr',
		1652: 'xnmp',
		1653: 'alphatech-lm',
		1654: 'stargatealerts',
		1655: 'dec-mbadmin',
		1656: 'dec-mbadmin-h',
		1657: 'fujitsu-mmpdc',
		1658: 'sixnetudr',
		1659: 'sg-lm',
		1660: 'skip-mc-gikreq',
		1661: 'netview-aix-1',
		1662: 'netview-aix-2',
		1663: 'netview-aix-3',
		1664: 'netview-aix-4',
		1665: 'netview-aix-5',
		1666: 'netview-aix-6',
		1667: 'netview-aix-7',
		1668: 'netview-aix-8',
		1669: 'netview-aix-9',
		1670: 'netview-aix-10',
		1671: 'netview-aix-11',
		1672: 'netview-aix-12',
		1673: 'proshare-mc-1',
		1674: 'proshare-mc-2',
		1675: 'pdp',
		1676: 'netcomm1',
		1677: 'groupwise',
		1678: 'prolink',
		1679: 'darcorp-lm',
		1680: 'microcom-sbp',
		1681: 'sd-elmd',
		1682: 'lanyon-lantern',
		1683: 'ncpm-hip',
		1684: 'snaresecure',
		1685: 'n2nremote',
		1686: 'cvmon',
		1687: 'nsjtp-ctrl',
		1688: 'nsjtp-data',
		1689: 'firefox',
		1690: 'ng-umds',
		1691: 'empire-empuma',
		1692: 'sstsys-lm',
		1693: 'rrirtr',
		1694: 'rrimwm',
		1695: 'rrilwm',
		1696: 'rrifmm',
		1697: 'rrisat',
		1698: 'rsvp-encap-1',
		1699: 'rsvp-encap-2',
		1700: 'mps-raft',
		1701: 'l2f',
		1702: 'deskshare',
		1703: 'hb-engine',
		1704: 'bcs-broker',
		1705: 'slingshot',
		1706: 'jetform',
		1707: 'vdmplay',
		1708: 'gat-lmd',
		1709: 'centra',
		1710: 'impera',
		1711: 'pptconference',
		1712: 'registrar',
		1713: 'conferencetalk',
		1714: 'sesi-lm',
		1715: 'houdini-lm',
		1716: 'xmsg',
		1717: 'fj-hdnet',
		1718: 'h323gatedisc',
		1719: 'h323gatestat',
		1720: 'h323hostcall',
		1721: 'caicci',
		1722: 'hks-lm',
		1723: 'pptp',
		1724: 'csbphonemaster',
		1725: 'iden-ralp',
		1726: 'iberiagames',
		1727: 'winddx',
		1728: 'telindus',
		1729: 'citynl',
		1730: 'roketz',
		1731: 'msiccp',
		1732: 'proxim',
		1733: 'siipat',
		1734: 'cambertx-lm',
		1735: 'privatechat',
		1736: 'street-stream',
		1737: 'ultimad',
		1738: 'gamegen1',
		1739: 'webaccess',
		1740: 'encore',
		1741: 'cisco-net-mgmt',
		1742: '3Com-nsd',
		1743: 'cinegrfx-lm',
		1744: 'ncpm-ft',
		1745: 'remote-winsock',
		1746: 'ftrapid-1',
		1747: 'ftrapid-2',
		1748: 'oracle-em1',
		1749: 'aspen-services',
		1750: 'sslp',
		1751: 'swiftnet',
		1752: 'lofr-lm',
		1753: 'translogic-lm',
		1754: 'oracle-em2',
		1755: 'ms-streaming',
		1756: 'capfast-lmd',
		1757: 'cnhrp',
		1758: 'tftp-mcast',
		1759: 'spss-lm',
		1760: 'www-ldap-gw',
		1761: 'cft-0',
		1762: 'cft-1',
		1763: 'cft-2',
		1764: 'cft-3',
		1765: 'cft-4',
		1766: 'cft-5',
		1767: 'cft-6',
		1768: 'cft-7',
		1769: 'bmc-net-adm',
		1770: 'bmc-net-svc',
		1771: 'vaultbase',
		1772: 'essweb-gw',
		1773: 'kmscontrol',
		1774: 'global-dtserv',
		1776: 'femis',
		1777: 'powerguardian',
		1778: 'prodigy-intrnet',
		1779: 'pharmasoft',
		1780: 'dpkeyserv',
		1781: 'answersoft-lm',
		1782: 'hp-hcip',
		1784: 'finle-lm',
		1785: 'windlm',
		1786: 'funk-logger',
		1787: 'funk-license',
		1788: 'psmond',
		1789: 'hello',
		1790: 'nmsp',
		1791: 'ea1',
		1792: 'ibm-dt-2',
		1793: 'rsc-robot',
		1794: 'cera-bcm',
		1795: 'dpi-proxy',
		1796: 'vocaltec-admin',
		1797: 'uma',
		1798: 'etp',
		1799: 'netrisk',
		1800: 'ansys-lm',
		1801: 'msmq',
		1802: 'concomp1',
		1803: 'hp-hcip-gwy',
		1804: 'enl',
		1805: 'enl-name',
		1806: 'musiconline',
		1807: 'fhsp',
		1808: 'oracle-vp2',
		1809: 'oracle-vp1',
		1810: 'jerand-lm',
		1811: 'scientia-sdb',
		1812: 'radius',
		1813: 'radius-acct',
		1814: 'tdp-suite',
		1815: 'mmpft',
		1816: 'harp',
		1817: 'rkb-oscs',
		1818: 'etftp',
		1819: 'plato-lm',
		1820: 'mcagent',
		1821: 'donnyworld',
		1822: 'es-elmd',
		1823: 'unisys-lm',
		1824: 'metrics-pas',
		1825: 'direcpc-video',
		1826: 'ardt',
		1827: 'asi',
		1828: 'itm-mcell-u',
		1829: 'optika-emedia',
		1830: 'net8-cman',
		1831: 'myrtle',
		1832: 'tht-treasure',
		1833: 'udpradio',
		1834: 'ardusuni',
		1835: 'ardusmul',
		1836: 'ste-smsc',
		1837: 'csoft1',
		1838: 'talnet',
		1839: 'netopia-vo1',
		1840: 'netopia-vo2',
		1841: 'netopia-vo3',
		1842: 'netopia-vo4',
		1843: 'netopia-vo5',
		1844: 'direcpc-dll',
		1845: 'altalink',
		1846: 'tunstall-pnc',
		1847: 'slp-notify',
		1848: 'fjdocdist',
		1849: 'alpha-sms',
		1850: 'gsi',
		1851: 'ctcd',
		1852: 'virtual-time',
		1853: 'vids-avtp',
		1854: 'buddy-draw',
		1855: 'fiorano-rtrsvc',
		1856: 'fiorano-msgsvc',
		1857: 'datacaptor',
		1858: 'privateark',
		1859: 'gammafetchsvr',
		1860: 'sunscalar-svc',
		1861: 'lecroy-vicp',
		1862: 'techra-server',
		1863: 'msnp',
		1864: 'paradym-31port',
		1865: 'entp',
		1866: 'swrmi',
		1867: 'udrive',
		1868: 'viziblebrowser',
		1869: 'yestrader',
		1870: 'sunscalar-dns',
		1871: 'canocentral0',
		1872: 'canocentral1',
		1873: 'fjmpjps',
		1874: 'fjswapsnp',
		1875: 'westell-stats',
		1876: 'ewcappsrv',
		1877: 'hp-webqosdb',
		1878: 'drmsmc',
		1879: 'nettgain-nms',
		1880: 'vsat-control',
		1881: 'ibm-mqseries2',
		1882: 'ecsqdmn',
		1883: 'ibm-mqisdp',
		1884: 'idmaps',
		1885: 'vrtstrapserver',
		1886: 'leoip',
		1887: 'filex-lport',
		1888: 'ncconfig',
		1889: 'unify-adapter',
		1890: 'wilkenlistener',
		1891: 'childkey-notif',
		1892: 'childkey-ctrl',
		1893: 'elad',
		1894: 'o2server-port',
		1896: 'b-novative-ls',
		1897: 'metaagent',
		1898: 'cymtec-port',
		1899: 'mc2studios',
		1900: 'ssdp',
		1901: 'fjicl-tep-a',
		1902: 'fjicl-tep-b',
		1903: 'linkname',
		1904: 'fjicl-tep-c',
		1905: 'sugp',
		1906: 'tpmd',
		1907: 'intrastar',
		1908: 'dawn',
		1909: 'global-wlink',
		1910: 'ultrabac',
		1911: 'mtp',
		1912: 'rhp-iibp',
		1913: 'armadp',
		1914: 'elm-momentum',
		1915: 'facelink',
		1916: 'persona',
		1917: 'noagent',
		1918: 'can-nds',
		1919: 'can-dch',
		1920: 'can-ferret',
		1921: 'noadmin',
		1922: 'tapestry',
		1923: 'spice',
		1924: 'xiip',
		1925: 'discovery-port',
		1926: 'egs',
		1927: 'videte-cipc',
		1928: 'emsd-port',
		1929: 'bandwiz-system',
		1930: 'driveappserver',
		1931: 'amdsched',
		1932: 'ctt-broker',
		1933: 'xmapi',
		1934: 'xaapi',
		1935: 'macromedia-fcs',
		1936: 'jetcmeserver',
		1937: 'jwserver',
		1938: 'jwclient',
		1939: 'jvserver',
		1940: 'jvclient',
		1941: 'dic-aida',
		1942: 'res',
		1943: 'beeyond-media',
		1944: 'close-combat',
		1945: 'dialogic-elmd',
		1946: 'tekpls',
		1947: 'hlserver',
		1948: 'eye2eye',
		1949: 'ismaeasdaqlive',
		1950: 'ismaeasdaqtest',
		1951: 'bcs-lmserver',
		1952: 'mpnjsc',
		1953: 'rapidbase',
		1954: 'abr-basic',
		1955: 'abr-secure',
		1956: 'vrtl-vmf-ds',
		1957: 'unix-status',
		1958: 'dxadmind',
		1959: 'simp-all',
		1960: 'nasmanager',
		1961: 'bts-appserver',
		1962: 'biap-mp',
		1963: 'webmachine',
		1964: 'solid-e-engine',
		1965: 'tivoli-npm',
		1966: 'slush',
		1967: 'sns-quote',
		1968: 'lipsinc',
		1969: 'lipsinc1',
		1970: 'netop-rc',
		1971: 'netop-school',
		1972: 'intersys-cache',
		1973: 'dlsrap',
		1974: 'drp',
		1975: 'tcoflashagent',
		1976: 'tcoregagent',
		1977: 'tcoaddressbook',
		1978: 'unisql',
		1979: 'unisql-java',
		1980: 'pearldoc-xact',
		1981: 'p2pq',
		1982: 'estamp',
		1983: 'lhtp',
		1984: 'bb',
		1985: 'hsrp',
		1986: 'licensedaemon',
		1987: 'tr-rsrb-p1',
		1988: 'tr-rsrb-p2',
		1989: 'mshnet',
		1990: 'stun-p1',
		1991: 'stun-p2',
		1992: 'ipsendmsg',
		1993: 'snmp-tcp-port',
		1994: 'stun-port',
		1995: 'perf-port',
		1996: 'tr-rsrb-port',
		1997: 'gdp-port',
		1998: 'x25-svc-port',
		1999: 'tcp-id-port',
		2000: 'callbook',
		2001: 'dc',
		2002: 'globe',
		2004: 'mailbox',
		2005: 'berknet',
		2006: 'invokator',
		2007: 'dectalk',
		2008: 'conf',
		2009: 'news',
		2010: 'search',
		2011: 'raid-cc',
		2012: 'ttyinfo',
		2013: 'raid-am',
		2014: 'troff',
		2015: 'cypress',
		2016: 'bootserver',
		2017: 'cypress-stat',
		2018: 'terminaldb',
		2019: 'whosockami',
		2020: 'xinupageserver',
		2021: 'servexec',
		2022: 'down',
		2023: 'xinuexpansion3',
		2024: 'xinuexpansion4',
		2025: 'ellpack',
		2026: 'scrabble',
		2027: 'shadowserver',
		2028: 'submitserver',
		2029: 'hsrpv6',
		2030: 'device2',
		2031: 'mobrien-chat',
		2032: 'blackboard',
		2033: 'glogger',
		2034: 'scoremgr',
		2035: 'imsldoc',
		2036: 'e-dpnet',
		2037: 'p2plus',
		2038: 'objectmanager',
		2039: 'prizma',
		2040: 'lam',
		2041: 'interbase',
		2042: 'isis',
		2043: 'isis-bcast',
		2044: 'rimsl',
		2045: 'cdfunc',
		2046: 'sdfunc',
		2047: 'dls',
		2048: 'dls-monitor',
		2049: 'nfsd',
		2050: 'av-emb-config',
		2051: 'epnsdp',
		2052: 'clearvisn',
		2053: 'lot105-ds-upd',
		2054: 'weblogin',
		2055: 'iop',
		2056: 'omnisky',
		2057: 'rich-cp',
		2058: 'newwavesearch',
		2059: 'bmc-messaging',
		2060: 'teleniumdaemon',
		2061: 'netmount',
		2062: 'icg-swp',
		2063: 'icg-bridge',
		2064: 'icg-iprelay',
		2065: 'dlsrpn',
		2066: 'aura',
		2067: 'dlswpn',
		2068: 'avauthsrvprtcl',
		2069: 'event-port',
		2070: 'ah-esp-encap',
		2071: 'acp-port',
		2072: 'msync',
		2073: 'gxs-data-port',
		2074: 'vrtl-vmf-sa',
		2075: 'newlixengine',
		2076: 'newlixconfig',
		2077: 'trellisagt',
		2078: 'trellissvr',
		2079: 'idware-router',
		2080: 'autodesk-nlm',
		2081: 'kme-trap-port',
		2082: 'infowave',
		2083: 'radsec',
		2084: 'sunclustergeo',
		2085: 'ada-cip',
		2086: 'gnunet',
		2087: 'eli',
		2088: 'ip-blf',
		2089: 'sep',
		2090: 'lrp',
		2091: 'prp',
		2092: 'descent3',
		2093: 'nbx-cc',
		2094: 'nbx-au',
		2095: 'nbx-ser',
		2096: 'nbx-dir',
		2097: 'jetformpreview',
		2098: 'dialog-port',
		2099: 'h2250-annex-g',
		2100: 'amiganetfs',
		2101: 'rtcm-sc104',
		2102: 'zephyr-srv',
		2103: 'zephyr-clt',
		2104: 'zephyr-hm',
		2105: 'minipay',
		2106: 'mzap',
		2107: 'bintec-admin',
		2108: 'comcam',
		2109: 'ergolight',
		2110: 'umsp',
		2111: 'dsatp',
		2112: 'idonix-metanet',
		2113: 'hsl-storm',
		2114: 'newheights',
		2115: 'kdm',
		2116: 'ccowcmr',
		2117: 'mentaclient',
		2118: 'mentaserver',
		2119: 'gsigatekeeper',
		2120: 'qencp',
		2121: 'scientia-ssdb',
		2122: 'caupc-remote',
		2123: 'gtp-control',
		2124: 'elatelink',
		2125: 'lockstep',
		2126: 'pktcable-cops',
		2127: 'index-pc-wb',
		2128: 'net-steward',
		2129: 'cs-live',
		2130: 'swc-xds',
		2131: 'avantageb2b',
		2132: 'avail-epmap',
		2133: 'zymed-zpp',
		2134: 'avenue',
		2135: 'gris',
		2136: 'appworxsrv',
		2137: 'connect',
		2138: 'unbind-cluster',
		2139: 'ias-auth',
		2140: 'ias-reg',
		2141: 'ias-admind',
		2142: 'tdm-over-ip',
		2143: 'lv-jc',
		2144: 'lv-ffx',
		2145: 'lv-pici',
		2146: 'lv-not',
		2147: 'lv-auth',
		2148: 'veritas-ucl',
		2149: 'acptsys',
		2150: 'dynamic3d',
		2151: 'docent',
		2152: 'gtp-user',
		2159: 'gdbremote',
		2160: 'apc-2160',
		2161: 'apc-2161',
		2162: 'navisphere',
		2163: 'navisphere-sec',
		2164: 'ddns-v3',
		2165: 'x-bone-api',
		2166: 'iwserver',
		2167: 'raw-serial',
		2168: 'easy-soft-mux',
		2169: 'brain',
		2170: 'eyetv',
		2171: 'msfw-storage',
		2172: 'msfw-s-storage',
		2173: 'msfw-replica',
		2174: 'msfw-array',
		2175: 'airsync',
		2176: 'rapi',
		2177: 'qwave',
		2178: 'bitspeer',
		2180: 'mc-gt-srv',
		2181: 'eforward',
		2182: 'cgn-stat',
		2183: 'cgn-config',
		2184: 'nvd',
		2185: 'onbase-dds',
		2190: 'tivoconnect',
		2191: 'tvbus',
		2192: 'asdis',
		2197: 'mnp-exchange',
		2198: 'onehome-remote',
		2199: 'onehome-help',
		2200: 'ici',
		2201: 'ats',
		2202: 'imtc-map',
		2203: 'b2-runtime',
		2204: 'b2-license',
		2205: 'jps',
		2206: 'hpocbus',
		2207: 'hpssd',
		2208: 'hpiod',
		2213: 'kali',
		2214: 'rpi',
		2215: 'ipcore',
		2216: 'vtu-comms',
		2217: 'gotodevice',
		2218: 'bounzza',
		2219: 'netiq-ncap',
		2220: 'netiq',
		2221: 'rockwell-csp1',
		2222: 'rockwell-csp2',
		2223: 'rockwell-csp3',
		2224: 'efi-mg',
		2225: 'rcip-itu',
		2226: 'di-drm',
		2227: 'di-msg',
		2228: 'ehome-ms',
		2229: 'datalens',
		2230: 'queueadm',
		2231: 'wimaxasncp',
		2232: 'ivs-video',
		2233: 'infocrypt',
		2234: 'directplay',
		2235: 'sercomm-wlink',
		2236: 'nani',
		2237: 'optech-port1-lm',
		2238: 'aviva-sna',
		2239: 'imagequery',
		2240: 'recipe',
		2241: 'ivsd',
		2242: 'foliocorp',
		2243: 'magicom',
		2244: 'nmsserver',
		2245: 'hao',
		2246: 'pc-mta-addrmap',
		2247: 'antidotemgrsvr',
		2248: 'ums',
		2249: 'rfmp',
		2250: 'remote-collab',
		2251: 'dif-port',
		2252: 'njenet-ssl',
		2253: 'dtv-chan-req',
		2254: 'seispoc',
		2255: 'vrtp',
		2256: 'pcc-mfp',
		2257: 'simple-tx-rx',
		2258: 'rcts',
		2259: 'acd-pm',
		2260: 'apc-2260',
		2261: 'comotionmaster',
		2262: 'comotionback',
		2263: 'ecwcfg',
		2264: 'apx500api-1',
		2265: 'apx500api-2',
		2266: 'mfserver',
		2267: 'ontobroker',
		2268: 'amt',
		2269: 'mikey',
		2270: 'starschool',
		2271: 'mmcals',
		2272: 'mmcal',
		2273: 'mysql-im',
		2274: 'pcttunnell',
		2275: 'ibridge-data',
		2276: 'ibridge-mgmt',
		2277: 'bluectrlproxy',
		2278: 's3db',
		2279: 'xmquery',
		2280: 'lnvpoller',
		2281: 'lnvconsole',
		2282: 'lnvalarm',
		2283: 'lnvstatus',
		2284: 'lnvmaps',
		2285: 'lnvmailmon',
		2286: 'nas-metering',
		2287: 'dna',
		2288: 'netml',
		2289: 'dict-lookup',
		2290: 'sonus-logging',
		2291: 'eapsp',
		2292: 'mib-streaming',
		2293: 'npdbgmngr',
		2294: 'konshus-lm',
		2295: 'advant-lm',
		2296: 'theta-lm',
		2297: 'd2k-datamover1',
		2298: 'd2k-datamover2',
		2299: 'pc-telecommute',
		2300: 'cvmmon',
		2301: 'cpq-wbem',
		2302: 'binderysupport',
		2303: 'proxy-gateway',
		2304: 'attachmate-uts',
		2305: 'mt-scaleserver',
		2306: 'tappi-boxnet',
		2307: 'pehelp',
		2308: 'sdhelp',
		2309: 'sdserver',
		2310: 'sdclient',
		2311: 'messageservice',
		2312: 'wanscaler',
		2313: 'iapp',
		2314: 'cr-websystems',
		2315: 'precise-sft',
		2316: 'sent-lm',
		2317: 'attachmate-g32',
		2318: 'cadencecontrol',
		2319: 'infolibria',
		2320: 'siebel-ns',
		2321: 'rdlap',
		2322: 'ofsd',
		2323: '3d-nfsd',
		2324: 'cosmocall',
		2325: 'designspace-lm',
		2326: 'idcp',
		2327: 'xingcsm',
		2328: 'netrix-sftm',
		2329: 'nvd',
		2330: 'tscchat',
		2331: 'agentview',
		2332: 'rcc-host',
		2333: 'snapp',
		2334: 'ace-client',
		2335: 'ace-proxy',
		2336: 'appleugcontrol',
		2337: 'ideesrv',
		2338: 'norton-lambert',
		2339: '3com-webview',
		2340: 'wrs_registry',
		2341: 'xiostatus',
		2342: 'manage-exec',
		2343: 'nati-logos',
		2344: 'fcmsys',
		2345: 'dbm',
		2346: 'redstorm_join',
		2347: 'redstorm_find',
		2348: 'redstorm_info',
		2349: 'redstorm_diag',
		2350: 'psbserver',
		2351: 'psrserver',
		2352: 'pslserver',
		2353: 'pspserver',
		2354: 'psprserver',
		2355: 'psdbserver',
		2356: 'gxtelmd',
		2357: 'unihub-server',
		2358: 'futrix',
		2359: 'flukeserver',
		2360: 'nexstorindltd',
		2361: 'tl1',
		2362: 'digiman',
		2363: 'mediacntrlnfsd',
		2364: 'oi-2000',
		2365: 'dbref',
		2366: 'qip-login',
		2367: 'service-ctrl',
		2368: 'opentable',
		2369: 'acs2000-dsp',
		2370: 'l3-hbmon',
		2371: 'worldwire',
		2381: 'compaq-https',
		2382: 'ms-olap3',
		2383: 'ms-olap4',
		2384: 'sd-request',
		2385: 'sd-data',
		2386: 'virtualtape',
		2387: 'vsamredirector',
		2388: 'mynahautostart',
		2389: 'ovsessionmgr',
		2390: 'rsmtp',
		2391: '3com-net-mgmt',
		2392: 'tacticalauth',
		2393: 'ms-olap1',
		2394: 'ms-olap2',
		2395: 'lan900_remote',
		2396: 'wusage',
		2397: 'ncl',
		2398: 'orbiter',
		2399: 'fmpro-fdal',
		2400: 'opequus-server',
		2401: 'cvspserver',
		2402: 'taskmaster2000',
		2403: 'taskmaster2000',
		2404: 'iec-104',
		2405: 'trc-netpoll',
		2406: 'jediserver',
		2407: 'orion',
		2408: 'optimanet',
		2409: 'sns-protocol',
		2410: 'vrts-registry',
		2411: 'netwave-ap-mgmt',
		2412: 'cdn',
		2413: 'orion-rmi-reg',
		2414: 'beeyond',
		2415: 'codima-rtp',
		2416: 'rmtserver',
		2417: 'composit-server',
		2418: 'cas',
		2419: 'attachmate-s2s',
		2420: 'dslremote-mgmt',
		2421: 'g-talk',
		2422: 'crmsbits',
		2423: 'rnrp',
		2424: 'kofax-svr',
		2425: 'fjitsuappmgr',
		2427: 'mgcp-gateway',
		2428: 'ott',
		2429: 'ft-role',
		2430: 'venus',
		2431: 'venus-se',
		2432: 'codasrv',
		2433: 'codasrv-se',
		2434: 'pxc-epmap',
		2435: 'optilogic',
		2436: 'topx',
		2437: 'unicontrol',
		2438: 'msp',
		2439: 'sybasedbsynch',
		2440: 'spearway',
		2441: 'pvsw-inet',
		2442: 'netangel',
		2443: 'powerclientcsf',
		2444: 'btpp2sectrans',
		2445: 'dtn1',
		2446: 'bues_service',
		2447: 'ovwdb',
		2448: 'hpppssvr',
		2449: 'ratl',
		2450: 'netadmin',
		2451: 'netchat',
		2452: 'snifferclient',
		2453: 'madge-om',
		2454: 'indx-dds',
		2455: 'wago-io-system',
		2456: 'altav-remmgt',
		2457: 'rapido-ip',
		2458: 'griffin',
		2459: 'community',
		2460: 'ms-theater',
		2461: 'qadmifoper',
		2462: 'qadmifevent',
		2463: 'symbios-raid',
		2464: 'direcpc-si',
		2465: 'lbm',
		2466: 'lbf',
		2467: 'high-criteria',
		2468: 'qip-msgd',
		2469: 'mti-tcs-comm',
		2470: 'taskman-port',
		2471: 'seaodbc',
		2472: 'c3',
		2473: 'aker-cdp',
		2474: 'vitalanalysis',
		2475: 'ace-server',
		2476: 'ace-svr-prop',
		2477: 'ssm-cvs',
		2478: 'ssm-cssps',
		2479: 'ssm-els',
		2480: 'lingwood',
		2481: 'giop',
		2482: 'giop-ssl',
		2483: 'ttc',
		2484: 'ttc-ssl',
		2485: 'netobjects1',
		2486: 'netobjects2',
		2487: 'pns',
		2488: 'moy-corp',
		2489: 'tsilb',
		2490: 'qip-qdhcp',
		2491: 'conclave-cpp',
		2492: 'groove',
		2493: 'talarian-mqs',
		2494: 'bmc-ar',
		2495: 'fast-rem-serv',
		2496: 'dirgis',
		2497: 'quaddb',
		2498: 'odn-castraq',
		2499: 'unicontrol',
		2500: 'rtsserv',
		2501: 'rtsclient',
		2502: 'kentrox-prot',
		2503: 'nms-dpnss',
		2504: 'wlbs',
		2505: 'ppcontrol',
		2506: 'jbroker',
		2507: 'spock',
		2508: 'jdatastore',
		2509: 'fjmpss',
		2510: 'fjappmgrbulk',
		2511: 'metastorm',
		2512: 'citrixima',
		2513: 'citrixadmin',
		2514: 'facsys-ntp',
		2515: 'facsys-router',
		2516: 'maincontrol',
		2517: 'call-sig-trans',
		2518: 'willy',
		2519: 'globmsgsvc',
		2520: 'pvsw',
		2521: 'adaptecmgr',
		2522: 'windb',
		2523: 'qke-llc-v3',
		2524: 'optiwave-lm',
		2525: 'ms-v-worlds',
		2526: 'ema-sent-lm',
		2527: 'iqserver',
		2528: 'ncr_ccl',
		2529: 'utsftp',
		2530: 'vrcommerce',
		2531: 'ito-e-gui',
		2532: 'ovtopmd',
		2533: 'snifferserver',
		2534: 'combox-web-acc',
		2535: 'madcap',
		2536: 'btpp2audctr1',
		2537: 'upgrade',
		2538: 'vnwk-prapi',
		2539: 'vsiadmin',
		2540: 'lonworks',
		2541: 'lonworks2',
		2542: 'davinci',
		2543: 'reftek',
		2544: 'novell-zen',
		2545: 'sis-emt',
		2546: 'vytalvaultbrtp',
		2547: 'vytalvaultvsmp',
		2548: 'vytalvaultpipe',
		2549: 'ipass',
		2550: 'ads',
		2551: 'isg-uda-server',
		2552: 'call-logging',
		2553: 'efidiningport',
		2554: 'vcnet-link-v10',
		2555: 'compaq-wcp',
		2556: 'nicetec-nmsvc',
		2557: 'nicetec-mgmt',
		2558: 'pclemultimedia',
		2559: 'lstp',
		2560: 'labrat',
		2561: 'mosaixcc',
		2562: 'delibo',
		2563: 'cti-redwood',
		2564: 'hp-3000-telnet',
		2565: 'coord-svr',
		2566: 'pcs-pcw',
		2567: 'clp',
		2568: 'spamtrap',
		2569: 'sonuscallsig',
		2570: 'hs-port',
		2571: 'cecsvc',
		2572: 'ibp',
		2573: 'trustestablish',
		2574: 'blockade-bpsp',
		2575: 'hl7',
		2576: 'tclprodebugger',
		2577: 'scipticslsrvr',
		2578: 'rvs-isdn-dcp',
		2579: 'mpfoncl',
		2580: 'tributary',
		2581: 'argis-te',
		2582: 'argis-ds',
		2583: 'mon',
		2584: 'cyaserv',
		2585: 'netx-server',
		2586: 'netx-agent',
		2587: 'masc',
		2588: 'privilege',
		2589: 'quartus-tcl',
		2590: 'idotdist',
		2591: 'maytagshuffle',
		2592: 'netrek',
		2593: 'mns-mail',
		2594: 'dts',
		2595: 'worldfusion1',
		2596: 'worldfusion2',
		2597: 'homesteadglory',
		2598: 'citriximaclient',
		2599: 'snapd',
		2600: 'hpstgmgr',
		2601: 'discp-client',
		2602: 'discp-server',
		2603: 'servicemeter',
		2604: 'nsc-ccs',
		2605: 'nsc-posa',
		2606: 'netmon',
		2607: 'connection',
		2608: 'wag-service',
		2609: 'system-monitor',
		2610: 'versa-tek',
		2611: 'lionhead',
		2612: 'qpasa-agent',
		2613: 'smntubootstrap',
		2614: 'neveroffline',
		2615: 'firepower',
		2616: 'appswitch-emp',
		2617: 'cmadmin',
		2618: 'priority-e-com',
		2619: 'bruce',
		2620: 'lpsrecommender',
		2621: 'miles-apart',
		2622: 'metricadbc',
		2623: 'lmdp',
		2624: 'aria',
		2625: 'blwnkl-port',
		2626: 'gbjd816',
		2627: 'moshebeeri',
		2628: 'dict',
		2629: 'sitaraserver',
		2630: 'sitaramgmt',
		2631: 'sitaradir',
		2632: 'irdg-post',
		2633: 'interintelli',
		2634: 'pk-electronics',
		2635: 'backburner',
		2636: 'solve',
		2637: 'imdocsvc',
		2638: 'sybaseanywhere',
		2639: 'aminet',
		2640: 'sai_sentlm',
		2641: 'hdl-srv',
		2642: 'tragic',
		2643: 'gte-samp',
		2644: 'travsoft-ipx-t',
		2645: 'novell-ipx-cmd',
		2646: 'and-lm',
		2647: 'syncserver',
		2648: 'upsnotifyprot',
		2649: 'vpsipport',
		2650: 'eristwoguns',
		2651: 'ebinsite',
		2652: 'interpathpanel',
		2653: 'sonus',
		2654: 'corel_vncadmin',
		2655: 'unglue',
		2656: 'kana',
		2657: 'sns-dispatcher',
		2658: 'sns-admin',
		2659: 'sns-query',
		2660: 'gcmonitor',
		2661: 'olhost',
		2662: 'bintec-capi',
		2663: 'bintec-tapi',
		2664: 'patrol-mq-gm',
		2665: 'patrol-mq-nm',
		2666: 'extensis',
		2667: 'alarm-clock-s',
		2668: 'alarm-clock-c',
		2669: 'toad',
		2670: 'tve-announce',
		2671: 'newlixreg',
		2672: 'nhserver',
		2673: 'firstcall42',
		2674: 'ewnn',
		2675: 'ttc-etap',
		2676: 'simslink',
		2677: 'gadgetgate1way',
		2678: 'gadgetgate2way',
		2679: 'syncserverssl',
		2680: 'pxc-sapxom',
		2681: 'mpnjsomb',
		2683: 'ncdloadbalance',
		2684: 'mpnjsosv',
		2685: 'mpnjsocl',
		2686: 'mpnjsomg',
		2687: 'pq-lic-mgmt',
		2688: 'md-cg-http',
		2689: 'fastlynx',
		2690: 'hp-nnm-data',
		2691: 'itinternet',
		2692: 'admins-lms',
		2693: 'belarc-http',
		2694: 'pwrsevent',
		2695: 'vspread',
		2696: 'unifyadmin',
		2697: 'oce-snmp-trap',
		2698: 'mck-ivpip',
		2699: 'csoft-plusclnt',
		2700: 'tqdata',
		2701: 'sms-rcinfo',
		2702: 'sms-xfer',
		2703: 'sms-chat',
		2704: 'sms-remctrl',
		2705: 'sds-admin',
		2706: 'ncdmirroring',
		2707: 'emcsymapiport',
		2708: 'banyan-net',
		2709: 'supermon',
		2710: 'sso-service',
		2711: 'sso-control',
		2712: 'aocp',
		2713: 'raven1',
		2714: 'raven2',
		2715: 'hpstgmgr2',
		2716: 'inova-ip-disco',
		2717: 'pn-requester',
		2718: 'pn-requester2',
		2719: 'scan-change',
		2720: 'wkars',
		2721: 'smart-diagnose',
		2722: 'proactivesrvr',
		2723: 'watchdognt',
		2724: 'qotps',
		2725: 'msolap-ptp2',
		2726: 'tams',
		2727: 'mgcp-callagent',
		2728: 'sqdr',
		2729: 'tcim-control',
		2730: 'nec-raidplus',
		2731: 'fyre-messanger',
		2732: 'g5m',
		2733: 'signet-ctf',
		2734: 'ccs-software',
		2735: 'netiq-mc',
		2736: 'radwiz-nms-srv',
		2737: 'srp-feedback',
		2738: 'ndl-tcp-ois-gw',
		2739: 'tn-timing',
		2740: 'alarm',
		2741: 'tsb',
		2742: 'tsb2',
		2743: 'murx',
		2744: 'honyaku',
		2745: 'urbisnet',
		2746: 'cpudpencap',
		2747: 'fjippol-swrly',
		2748: 'fjippol-polsvr',
		2749: 'fjippol-cnsl',
		2750: 'fjippol-port1',
		2751: 'fjippol-port2',
		2752: 'rsisysaccess',
		2753: 'de-spot',
		2754: 'apollo-cc',
		2755: 'expresspay',
		2756: 'simplement-tie',
		2757: 'cnrp',
		2758: 'apollo-status',
		2759: 'apollo-gms',
		2760: 'sabams',
		2761: 'dicom-iscl',
		2762: 'dicom-tls',
		2763: 'desktop-dna',
		2764: 'data-insurance',
		2765: 'qip-audup',
		2766: 'compaq-scp',
		2767: 'uadtc',
		2768: 'uacs',
		2769: 'singlept-mvs',
		2770: 'veronica',
		2771: 'vergencecm',
		2772: 'auris',
		2773: 'rbakcup1',
		2774: 'rbakcup2',
		2775: 'smpp',
		2776: 'ridgeway1',
		2777: 'ridgeway2',
		2778: 'gwen-sonya',
		2779: 'lbc-sync',
		2780: 'lbc-control',
		2781: 'whosells',
		2782: 'everydayrc',
		2783: 'aises',
		2784: 'www-dev',
		2785: 'aic-np',
		2786: 'aic-oncrpc',
		2787: 'piccolo',
		2788: 'fryeserv',
		2789: 'media-agent',
		2790: 'plgproxy',
		2791: 'mtport-regist',
		2792: 'f5-globalsite',
		2793: 'initlsmsad',
		2794: 'aaftp',
		2795: 'livestats',
		2796: 'ac-tech',
		2797: 'esp-encap',
		2798: 'tmesis-upshot',
		2799: 'icon-discover',
		2800: 'acc-raid',
		2801: 'igcp',
		2802: 'veritas-tcp1',
		2803: 'btprjctrl',
		2804: 'telexis-vtu',
		2805: 'wta-wsp-s',
		2806: 'cspuni',
		2807: 'cspmulti',
		2808: 'j-lan-p',
		2809: 'corbaloc',
		2810: 'netsteward',
		2811: 'gsiftp',
		2812: 'atmtcp',
		2813: 'llm-pass',
		2814: 'llm-csv',
		2815: 'lbc-measure',
		2816: 'lbc-watchdog',
		2817: 'nmsigport',
		2818: 'rmlnk',
		2819: 'fc-faultnotify',
		2820: 'univision',
		2821: 'vrts-at-port',
		2822: 'ka0wuc',
		2823: 'cqg-netlan',
		2824: 'cqg-netlan-1',
		2826: 'slc-systemlog',
		2827: 'slc-ctrlrloops',
		2828: 'itm-lm',
		2829: 'silkp1',
		2830: 'silkp2',
		2831: 'silkp3',
		2832: 'silkp4',
		2833: 'glishd',
		2834: 'evtp',
		2835: 'evtp-data',
		2836: 'catalyst',
		2837: 'repliweb',
		2838: 'starbot',
		2839: 'nmsigport',
		2840: 'l3-exprt',
		2841: 'l3-ranger',
		2842: 'l3-hawk',
		2843: 'pdnet',
		2844: 'bpcp-poll',
		2845: 'bpcp-trap',
		2846: 'aimpp-hello',
		2847: 'aimpp-port-req',
		2848: 'amt-blc-port',
		2849: 'fxp',
		2850: 'metaconsole',
		2851: 'webemshttp',
		2852: 'bears-01',
		2853: 'ispipes',
		2854: 'infomover',
		2856: 'cesdinv',
		2857: 'simctlp',
		2858: 'ecnp',
		2859: 'activememory',
		2860: 'dialpad-voice1',
		2861: 'dialpad-voice2',
		2862: 'ttg-protocol',
		2863: 'sonardata',
		2864: 'astromed-main',
		2865: 'pit-vpn',
		2866: 'iwlistener',
		2867: 'esps-portal',
		2868: 'npep-messaging',
		2869: 'icslap',
		2870: 'daishi',
		2871: 'msi-selectplay',
		2872: 'radix',
		2873: 'paspar2-zoomin',
		2874: 'dxmessagebase1',
		2875: 'dxmessagebase2',
		2876: 'sps-tunnel',
		2877: 'bluelance',
		2878: 'aap',
		2879: 'ucentric-ds',
		2880: 'synapse',
		2881: 'ndsp',
		2882: 'ndtp',
		2883: 'ndnp',
		2884: 'flashmsg',
		2885: 'topflow',
		2886: 'responselogic',
		2887: 'aironetddp',
		2888: 'spcsdlobby',
		2889: 'rsom',
		2890: 'cspclmulti',
		2891: 'cinegrfx-elmd',
		2892: 'snifferdata',
		2893: 'vseconnector',
		2894: 'abacus-remote',
		2895: 'natuslink',
		2896: 'ecovisiong6-1',
		2897: 'citrix-rtmp',
		2898: 'appliance-cfg',
		2899: 'powergemplus',
		2900: 'quicksuite',
		2901: 'allstorcns',
		2902: 'netaspi',
		2903: 'suitcase',
		2904: 'm2ua',
		2905: 'm3ua',
		2906: 'caller9',
		2907: 'webmethods-b2b',
		2908: 'mao',
		2909: 'funk-dialout',
		2910: 'tdaccess',
		2911: 'blockade',
		2912: 'epicon',
		2913: 'boosterware',
		2914: 'gamelobby',
		2915: 'tksocket',
		2916: 'elvin_server',
		2917: 'elvin_client',
		2918: 'kastenchasepad',
		2919: 'roboer',
		2920: 'roboeda',
		2921: 'cesdcdman',
		2922: 'cesdcdtrn',
		2923: 'wta-wsp-wtp-s',
		2924: 'precise-vip',
		2926: 'mobile-file-dl',
		2927: 'unimobilectrl',
		2928: 'redstone-cpss',
		2929: 'amx-webadmin',
		2930: 'amx-weblinx',
		2931: 'circle-x',
		2932: 'incp',
		2933: '4-tieropmgw',
		2934: '4-tieropmcli',
		2935: 'qtp',
		2936: 'otpatch',
		2937: 'pnaconsult-lm',
		2938: 'sm-pas-1',
		2939: 'sm-pas-2',
		2940: 'sm-pas-3',
		2941: 'sm-pas-4',
		2942: 'sm-pas-5',
		2943: 'ttnrepository',
		2944: 'megaco-h248',
		2945: 'h248-binary',
		2946: 'fjsvmpor',
		2947: 'gpsd',
		2948: 'wap-push',
		2949: 'wap-pushsecure',
		2950: 'esip',
		2951: 'ottp',
		2952: 'mpfwsas',
		2953: 'ovalarmsrv',
		2954: 'ovalarmsrv-cmd',
		2955: 'csnotify',
		2956: 'ovrimosdbman',
		2957: 'jmact5',
		2958: 'jmact6',
		2959: 'rmopagt',
		2960: 'dfoxserver',
		2961: 'boldsoft-lm',
		2962: 'iph-policy-cli',
		2963: 'iph-policy-adm',
		2964: 'bullant-srap',
		2965: 'bullant-rap',
		2966: 'idp-infotrieve',
		2967: 'ssc-agent',
		2968: 'enpp',
		2969: 'essp',
		2970: 'index-net',
		2971: 'netclip',
		2972: 'pmsm-webrctl',
		2973: 'svnetworks',
		2974: 'signal',
		2975: 'fjmpcm',
		2976: 'cns-srv-port',
		2977: 'ttc-etap-ns',
		2978: 'ttc-etap-ds',
		2979: 'h263-video',
		2980: 'wimd',
		2981: 'mylxamport',
		2982: 'iwb-whiteboard',
		2983: 'netplan',
		2984: 'hpidsadmin',
		2985: 'hpidsagent',
		2986: 'stonefalls',
		2987: 'identify',
		2988: 'hippad',
		2989: 'zarkov',
		2990: 'boscap',
		2991: 'wkstn-mon',
		2992: 'itb301',
		2993: 'veritas-vis1',
		2994: 'veritas-vis2',
		2995: 'idrs',
		2996: 'vsixml',
		2997: 'rebol',
		2998: 'realsecure',
		2999: 'remoteware-un',
		3000: 'remoteware-cl',
		3001: 'redwood-broker',
		3002: 'remoteware-srv',
		3003: 'cgms',
		3004: 'csoftragent',
		3005: 'geniuslm',
		3006: 'ii-admin',
		3007: 'lotusmtap',
		3008: 'midnight-tech',
		3009: 'pxc-ntfy',
		3010: 'gw',
		3011: 'trusted-web',
		3012: 'twsdss',
		3013: 'gilatskysurfer',
		3014: 'broker_service',
		3015: 'nati-dstp',
		3016: 'notify_srvr',
		3017: 'event_listener',
		3018: 'srvc_registry',
		3019: 'resource_mgr',
		3020: 'cifs',
		3021: 'agriserver',
		3022: 'csregagent',
		3023: 'magicnotes',
		3024: 'nds_sso',
		3025: 'arepa-raft',
		3026: 'agri-gateway',
		3027: 'LiebDevMgmt_C',
		3028: 'LiebDevMgmt_DM',
		3029: 'LiebDevMgmt_A',
		3030: 'arepa-cas',
		3031: 'eppc',
		3032: 'redwood-chat',
		3033: 'pdb',
		3034: 'osmosis-aeea',
		3035: 'fjsv-gssagt',
		3036: 'hagel-dump',
		3037: 'hp-san-mgmt',
		3038: 'santak-ups',
		3039: 'cogitate',
		3040: 'tomato-springs',
		3041: 'di-traceware',
		3042: 'journee',
		3043: 'brp',
		3044: 'epp',
		3045: 'responsenet',
		3046: 'di-ase',
		3047: 'hlserver',
		3048: 'pctrader',
		3049: 'nsws',
		3050: 'gds_db',
		3051: 'galaxy-server',
		3052: 'apc-3052',
		3053: 'dsom-server',
		3054: 'amt-cnf-prot',
		3055: 'policyserver',
		3056: 'cdl-server',
		3057: 'goahead-fldup',
		3058: 'videobeans',
		3059: 'qsoft',
		3060: 'interserver',
		3061: 'cautcpd',
		3062: 'ncacn-ip-tcp',
		3063: 'ncadg-ip-udp',
		3064: 'rprt',
		3065: 'slinterbase',
		3066: 'netattachsdmp',
		3067: 'fjhpjp',
		3068: 'ls3bcast',
		3069: 'ls3',
		3070: 'mgxswitch',
		3071: 'csd-mgmt-port',
		3072: 'csd-monitor',
		3073: 'vcrp',
		3074: 'xbox',
		3075: 'orbix-locator',
		3076: 'orbix-config',
		3077: 'orbix-loc-ssl',
		3078: 'orbix-cfg-ssl',
		3079: 'lv-frontpanel',
		3080: 'stm_pproc',
		3081: 'tl1-lv',
		3082: 'tl1-raw',
		3083: 'tl1-telnet',
		3084: 'itm-mccs',
		3085: 'pcihreq',
		3086: 'jdl-dbkitchen',
		3087: 'asoki-sma',
		3088: 'xdtp',
		3089: 'ptk-alink',
		3090: 'rtss',
		3091: '1ci-smcs',
		3092: 'njfss',
		3093: 'rapidmq-center',
		3094: 'rapidmq-reg',
		3095: 'panasas',
		3096: 'ndl-aps',
		3097: 'itu-bicc-stc',
		3098: 'umm-port',
		3099: 'chmd',
		3100: 'opcon-xps',
		3101: 'hp-pxpib',
		3102: 'slslavemon',
		3103: 'autocuesmi',
		3104: 'autocuelog',
		3105: 'cardbox',
		3106: 'cardbox-http',
		3107: 'business',
		3108: 'geolocate',
		3109: 'personnel',
		3110: 'sim-control',
		3111: 'wsynch',
		3112: 'ksysguard',
		3113: 'cs-auth-svr',
		3114: 'ccmad',
		3115: 'mctet-master',
		3116: 'mctet-gateway',
		3117: 'mctet-jserv',
		3118: 'pkagent',
		3119: 'd2000kernel',
		3120: 'd2000webserver',
		3121: 'epp-temp',
		3122: 'vtr-emulator',
		3123: 'edix',
		3124: 'beacon-port',
		3125: 'a13-an',
		3126: 'ms-dotnetster',
		3127: 'ctx-bridge',
		3128: 'ndl-aas',
		3129: 'netport-id',
		3130: 'icpv2',
		3131: 'netbookmark',
		3132: 'ms-rule-engine',
		3133: 'prism-deploy',
		3134: 'ecp',
		3135: 'peerbook-port',
		3136: 'grubd',
		3137: 'rtnt-1',
		3138: 'rtnt-2',
		3139: 'incognitorv',
		3140: 'ariliamulti',
		3141: 'vmodem',
		3142: 'rdc-wh-eos',
		3143: 'seaview',
		3144: 'tarantella',
		3145: 'csi-lfap',
		3146: 'bears-02',
		3147: 'rfio',
		3148: 'nm-game-admin',
		3149: 'nm-game-server',
		3150: 'nm-asses-admin',
		3151: 'nm-assessor',
		3152: 'feitianrockey',
		3153: 's8-client-port',
		3154: 'ccmrmi',
		3155: 'jpegmpeg',
		3156: 'indura',
		3157: 'e3consultants',
		3158: 'stvp',
		3159: 'navegaweb-port',
		3160: 'tip-app-server',
		3161: 'doc1lm',
		3162: 'sflm',
		3163: 'res-sap',
		3164: 'imprs',
		3165: 'newgenpay',
		3166: 'qrepos',
		3167: 'poweroncontact',
		3168: 'poweronnud',
		3169: 'serverview-as',
		3170: 'serverview-asn',
		3171: 'serverview-gf',
		3172: 'serverview-rm',
		3173: 'serverview-icc',
		3174: 'armi-server',
		3175: 't1-e1-over-ip',
		3176: 'ars-master',
		3177: 'phonex-port',
		3178: 'radclientport',
		3179: 'h2gf-w-2m',
		3180: 'mc-brk-srv',
		3181: 'bmcpatrolagent',
		3182: 'bmcpatrolrnvu',
		3183: 'cops-tls',
		3184: 'apogeex-port',
		3185: 'smpppd',
		3186: 'iiw-port',
		3187: 'odi-port',
		3188: 'brcm-comm-port',
		3189: 'pcle-infex',
		3190: 'csvr-proxy',
		3191: 'csvr-sslproxy',
		3192: 'firemonrcc',
		3193: 'cordataport',
		3194: 'magbind',
		3195: 'ncu-1',
		3196: 'ncu-2',
		3197: 'embrace-dp-s',
		3198: 'embrace-dp-c',
		3199: 'dmod-workspace',
		3200: 'tick-port',
		3201: 'cpq-tasksmart',
		3202: 'intraintra',
		3203: 'netwatcher-mon',
		3204: 'netwatcher-db',
		3205: 'isns',
		3206: 'ironmail',
		3207: 'vx-auth-port',
		3208: 'pfu-prcallback',
		3209: 'netwkpathengine',
		3210: 'flamenco-proxy',
		3211: 'avsecuremgmt',
		3212: 'surveyinst',
		3213: 'neon24x7',
		3214: 'jmq-daemon-1',
		3215: 'jmq-daemon-2',
		3216: 'ferrari-foam',
		3217: 'unite',
		3218: 'smartpackets',
		3219: 'wms-messenger',
		3220: 'xnm-ssl',
		3221: 'xnm-clear-text',
		3222: 'glbp',
		3223: 'digivote',
		3224: 'aes-discovery',
		3225: 'fcip-port',
		3226: 'isi-irp',
		3227: 'dwnmshttp',
		3228: 'dwmsgserver',
		3229: 'global-cd-port',
		3230: 'sftdst-port',
		3231: 'dsnl',
		3232: 'mdtp',
		3233: 'whisker',
		3234: 'alchemy',
		3235: 'mdap-port',
		3236: 'apparenet-ts',
		3237: 'apparenet-tps',
		3238: 'apparenet-as',
		3239: 'apparenet-ui',
		3240: 'triomotion',
		3241: 'sysorb',
		3242: 'sdp-id-port',
		3243: 'timelot',
		3244: 'onesaf',
		3245: 'vieo-fe',
		3246: 'dvt-system',
		3247: 'dvt-data',
		3248: 'procos-lm',
		3249: 'ssp',
		3250: 'hicp',
		3251: 'sysscanner',
		3252: 'dhe',
		3253: 'pda-data',
		3254: 'pda-sys',
		3255: 'semaphore',
		3256: 'cpqrpm-agent',
		3257: 'cpqrpm-server',
		3258: 'ivecon-port',
		3259: 'epncdp2',
		3260: 'iscsi-target',
		3261: 'winshadow',
		3262: 'necp',
		3263: 'ecolor-imager',
		3264: 'ccmail',
		3265: 'altav-tunnel',
		3266: 'ns-cfg-server',
		3267: 'ibm-dial-out',
		3268: 'msft-gc',
		3269: 'msft-gc-ssl',
		3270: 'verismart',
		3271: 'csoft-prev',
		3272: 'user-manager',
		3273: 'sxmp',
		3274: 'ordinox-server',
		3275: 'samd',
		3276: 'maxim-asics',
		3277: 'awg-proxy',
		3278: 'lkcmserver',
		3279: 'admind',
		3280: 'vs-server',
		3281: 'sysopt',
		3282: 'datusorb',
		3283: 'net-assistant',
		3284: '4talk',
		3285: 'plato',
		3286: 'e-net',
		3287: 'directvdata',
		3288: 'cops',
		3289: 'enpc',
		3290: 'caps-lm',
		3291: 'sah-lm',
		3292: 'cart-o-rama',
		3293: 'fg-fps',
		3294: 'fg-gip',
		3295: 'dyniplookup',
		3296: 'rib-slm',
		3297: 'cytel-lm',
		3298: 'deskview',
		3299: 'pdrncs',
		3302: 'mcs-fastmail',
		3303: 'opsession-clnt',
		3304: 'opsession-srvr',
		3305: 'odette-ftp',
		3306: 'mysql',
		3307: 'opsession-prxy',
		3308: 'tns-server',
		3309: 'tns-adv',
		3310: 'dyna-access',
		3311: 'mcns-tel-ret',
		3312: 'appman-server',
		3313: 'uorb',
		3314: 'uohost',
		3315: 'cdid',
		3316: 'aicc-cmi',
		3317: 'vsaiport',
		3318: 'ssrip',
		3319: 'sdt-lmd',
		3320: 'officelink2000',
		3321: 'vnsstr',
		3326: 'sftu',
		3327: 'bbars',
		3328: 'egptlm',
		3329: 'hp-device-disc',
		3330: 'mcs-calypsoicf',
		3331: 'mcs-messaging',
		3332: 'mcs-mailsvr',
		3333: 'dec-notes',
		3334: 'directv-web',
		3335: 'directv-soft',
		3336: 'directv-tick',
		3337: 'directv-catlg',
		3338: 'anet-b',
		3339: 'anet-l',
		3340: 'anet-m',
		3341: 'anet-h',
		3342: 'webtie',
		3343: 'ms-cluster-net',
		3344: 'bnt-manager',
		3345: 'influence',
		3346: 'trnsprntproxy',
		3347: 'phoenix-rpc',
		3348: 'pangolin-laser',
		3349: 'chevinservices',
		3350: 'findviatv',
		3351: 'btrieve',
		3352: 'ssql',
		3353: 'fatpipe',
		3354: 'suitjd',
		3355: 'ordinox-dbase',
		3356: 'upnotifyps',
		3357: 'adtech-test',
		3358: 'mpsysrmsvr',
		3359: 'wg-netforce',
		3360: 'kv-server',
		3361: 'kv-agent',
		3362: 'dj-ilm',
		3363: 'nati-vi-server',
		3364: 'creativeserver',
		3365: 'contentserver',
		3366: 'creativepartnr',
		3372: 'tip2',
		3373: 'lavenir-lm',
		3374: 'cluster-disc',
		3375: 'vsnm-agent',
		3376: 'cdbroker',
		3377: 'cogsys-lm',
		3378: 'wsicopy',
		3379: 'socorfs',
		3380: 'sns-channels',
		3381: 'geneous',
		3382: 'fujitsu-neat',
		3383: 'esp-lm',
		3384: 'hp-clic',
		3385: 'qnxnetman',
		3386: 'gprs-data',
		3387: 'backroomnet',
		3388: 'cbserver',
		3389: 'ms-wbt-server',
		3390: 'dsc',
		3391: 'savant',
		3392: 'efi-lm',
		3393: 'd2k-tapestry1',
		3394: 'd2k-tapestry2',
		3395: 'dyna-lm',
		3396: 'printer_agent',
		3397: 'cloanto-lm',
		3398: 'mercantile',
		3399: 'csms',
		3400: 'csms2',
		3401: 'filecast',
		3402: 'fxaengine-net',
		3403: 'copysnap',
		3405: 'nokia-ann-ch1',
		3406: 'nokia-ann-ch2',
		3407: 'ldap-admin',
		3408: 'issapi',
		3409: 'networklens',
		3410: 'networklenss',
		3411: 'biolink-auth',
		3412: 'xmlblaster',
		3413: 'svnet',
		3414: 'wip-port',
		3415: 'bcinameservice',
		3416: 'commandport',
		3417: 'csvr',
		3418: 'rnmap',
		3419: 'softaudit',
		3420: 'ifcp-port',
		3421: 'bmap',
		3422: 'rusb-sys-port',
		3423: 'xtrm',
		3424: 'xtrms',
		3425: 'agps-port',
		3426: 'arkivio',
		3427: 'websphere-snmp',
		3428: 'twcss',
		3429: 'gcsp',
		3430: 'ssdispatch',
		3431: 'ndl-als',
		3432: 'osdcp',
		3433: 'alta-smp',
		3434: 'opencm',
		3435: 'pacom',
		3436: 'gc-config',
		3437: 'autocueds',
		3438: 'spiral-admin',
		3439: 'hri-port',
		3440: 'ans-console',
		3441: 'connect-client',
		3442: 'connect-server',
		3443: 'ov-nnm-websrv',
		3444: 'denali-server',
		3445: 'monp',
		3446: '3comfaxrpc',
		3447: 'cddn',
		3448: 'dnc-port',
		3449: 'hotu-chat',
		3450: 'castorproxy',
		3451: 'asam',
		3452: 'sabp-signal',
		3453: 'pscupd',
		3454: 'mira',
		3455: 'prsvp',
		3456: 'vat',
		3457: 'vat-control',
		3458: 'd3winosfi',
		3459: 'integral',
		3460: 'edm-manager',
		3461: 'edm-stager',
		3462: 'edm-std-notify',
		3463: 'edm-adm-notify',
		3464: 'edm-mgr-sync',
		3465: 'edm-mgr-cntrl',
		3466: 'workflow',
		3467: 'rcst',
		3468: 'ttcmremotectrl',
		3469: 'pluribus',
		3470: 'jt400',
		3471: 'jt400-ssl',
		3472: 'jaugsremotec-1',
		3473: 'jaugsremotec-2',
		3474: 'ttntspauto',
		3475: 'genisar-port',
		3476: 'nppmp',
		3477: 'ecomm',
		3478: 'nat-stun-port',
		3479: 'twrpc',
		3480: 'plethora',
		3481: 'cleanerliverc',
		3482: 'vulture',
		3483: 'slim-devices',
		3484: 'gbs-stp',
		3485: 'celatalk',
		3486: 'ifsf-hb-port',
		3487: 'ltctcp',
		3488: 'fs-rh-srv',
		3489: 'dtp-dia',
		3490: 'colubris',
		3491: 'swr-port',
		3492: 'tvdumtray-port',
		3493: 'nut',
		3494: 'ibm3494',
		3495: 'seclayer-tcp',
		3496: 'seclayer-tls',
		3497: 'ipether232port',
		3498: 'dashpas-port',
		3499: 'sccip-media',
		3500: 'rtmp-port',
		3501: 'isoft-p2p',
		3502: 'avinstalldisc',
		3503: 'lsp-ping',
		3504: 'ironstorm',
		3505: 'ccmcomm',
		3506: 'apc-3506',
		3507: 'nesh-broker',
		3508: 'interactionweb',
		3509: 'vt-ssl',
		3510: 'xss-port',
		3511: 'webmail-2',
		3512: 'aztec',
		3513: 'arcpd',
		3514: 'must-p2p',
		3515: 'must-backplane',
		3516: 'smartcard-port',
		3517: '802-11-iapp',
		3518: 'artifact-msg',
		3519: 'nvmsgd',
		3520: 'galileolog',
		3521: 'mc3ss',
		3522: 'nssocketport',
		3523: 'odeumservlink',
		3524: 'ecmport',
		3525: 'eisport',
		3526: 'starquiz-port',
		3527: 'beserver-msg-q',
		3528: 'jboss-iiop',
		3529: 'jboss-iiop-ssl',
		3530: 'gf',
		3531: 'joltid',
		3532: 'raven-rmp',
		3533: 'raven-rdp',
		3534: 'urld-port',
		3535: 'ms-la',
		3536: 'snac',
		3537: 'ni-visa-remote',
		3538: 'ibm-diradm',
		3539: 'ibm-diradm-ssl',
		3540: 'pnrp-port',
		3541: 'voispeed-port',
		3542: 'hacl-monitor',
		3543: 'qftest-lookup',
		3544: 'teredo',
		3545: 'camac',
		3547: 'symantec-sim',
		3548: 'interworld',
		3549: 'tellumat-nms',
		3550: 'ssmpp',
		3551: 'apcupsd',
		3552: 'taserver',
		3553: 'rbr-discovery',
		3554: 'questnotify',
		3555: 'razor',
		3556: 'sky-transport',
		3557: 'personalos-001',
		3558: 'mcp-port',
		3559: 'cctv-port',
		3560: 'iniserve-port',
		3561: 'bmc-onekey',
		3562: 'sdbproxy',
		3563: 'watcomdebug',
		3564: 'esimport',
		3565: 'm2pa',
		3566: 'quest-launcher',
		3567: 'emware-oft',
		3568: 'emware-epss',
		3569: 'mbg-ctrl',
		3570: 'mccwebsvr-port',
		3571: 'megardsvr-port',
		3572: 'megaregsvrport',
		3573: 'tag-ups-1',
		3574: 'dmaf-server',
		3575: 'ccm-port',
		3576: 'cmc-port',
		3577: 'config-port',
		3578: 'data-port',
		3579: 'ttat3lb',
		3580: 'nati-svrloc',
		3581: 'kfxaclicensing',
		3582: 'press',
		3583: 'canex-watch',
		3584: 'u-dbap',
		3585: 'emprise-lls',
		3586: 'emprise-lsc',
		3587: 'p2pgroup',
		3588: 'sentinel',
		3589: 'isomair',
		3590: 'wv-csp-sms',
		3591: 'gtrack-server',
		3592: 'gtrack-ne',
		3593: 'bpmd',
		3594: 'mediaspace',
		3595: 'shareapp',
		3596: 'iw-mmogame',
		3597: 'a14',
		3598: 'a15',
		3599: 'quasar-server',
		3600: 'trap-daemon',
		3601: 'visinet-gui',
		3602: 'infiniswitchcl',
		3603: 'int-rcv-cntrl',
		3604: 'bmc-jmx-port',
		3605: 'comcam-io',
		3606: 'splitlock',
		3607: 'precise-i3',
		3608: 'trendchip-dcp',
		3609: 'cpdi-pidas-cm',
		3610: 'echonet',
		3611: 'six-degrees',
		3612: 'hp-dataprotect',
		3613: 'alaris-disc',
		3614: 'sigma-port',
		3615: 'start-network',
		3616: 'cd3o-protocol',
		3617: 'sharp-server',
		3618: 'aairnet-1',
		3619: 'aairnet-2',
		3620: 'ep-pcp',
		3621: 'ep-nsp',
		3622: 'ff-lr-port',
		3623: 'haipe-discover',
		3624: 'dist-upgrade',
		3625: 'volley',
		3626: 'bvcdaemon-port',
		3627: 'jamserverport',
		3628: 'ept-machine',
		3629: 'escvpnet',
		3630: 'cs-remote-db',
		3631: 'cs-services',
		3632: 'distcc',
		3633: 'wacp',
		3634: 'hlibmgr',
		3635: 'sdo',
		3636: 'opscenter',
		3637: 'scservp',
		3638: 'ehp-backup',
		3639: 'xap-ha',
		3640: 'netplay-port1',
		3641: 'netplay-port2',
		3642: 'juxml-port',
		3643: 'audiojuggler',
		3644: 'ssowatch',
		3645: 'cyc',
		3646: 'xss-srv-port',
		3647: 'splitlock-gw',
		3648: 'fjcp',
		3649: 'nmmp',
		3650: 'prismiq-plugin',
		3651: 'xrpc-registry',
		3652: 'vxcrnbuport',
		3653: 'tsp',
		3654: 'vaprtm',
		3655: 'abatemgr',
		3656: 'abatjss',
		3657: 'immedianet-bcn',
		3658: 'ps-ams',
		3659: 'apple-sasl',
		3660: 'can-nds-ssl',
		3661: 'can-ferret-ssl',
		3662: 'pserver',
		3663: 'dtp',
		3664: 'ups-engine',
		3665: 'ent-engine',
		3666: 'eserver-pap',
		3667: 'infoexch',
		3668: 'dell-rm-port',
		3669: 'casanswmgmt',
		3670: 'smile',
		3671: 'efcp',
		3672: 'lispworks-orb',
		3673: 'mediavault-gui',
		3674: 'wininstall-ipc',
		3675: 'calltrax',
		3676: 'va-pacbase',
		3677: 'roverlog',
		3678: 'ipr-dglt',
		3679: 'newton-dock',
		3680: 'npds-tracker',
		3681: 'bts-x73',
		3682: 'cas-mapi',
		3683: 'bmc-ea',
		3684: 'faxstfx-port',
		3685: 'dsx-agent',
		3686: 'tnmpv2',
		3687: 'simple-push',
		3688: 'simple-push-s',
		3689: 'daap',
		3690: 'svn',
		3691: 'magaya-network',
		3692: 'intelsync',
		3693: 'gttp',
		3694: 'vpncpp',
		3695: 'bmc-data-coll',
		3696: 'telnetcpcd',
		3697: 'nw-license',
		3698: 'sagectlpanel',
		3699: 'kpn-icw',
		3700: 'lrs-paging',
		3701: 'netcelera',
		3702: 'upnp-discovery',
		3703: 'adobeserver-3',
		3704: 'adobeserver-4',
		3705: 'adobeserver-5',
		3706: 'rt-event',
		3707: 'rt-event-s',
		3708: 'sun-as-iiops',
		3709: 'ca-idms',
		3710: 'portgate-auth',
		3711: 'edb-server2',
		3712: 'sentinel-ent',
		3713: 'tftps',
		3714: 'delos-dms',
		3715: 'anoto-rendezv',
		3716: 'wv-csp-sms-cir',
		3717: 'wv-csp-udp-cir',
		3718: 'opus-services',
		3719: 'itelserverport',
		3720: 'ufastro-instr',
		3721: 'xsync',
		3722: 'xserveraid',
		3723: 'sychrond',
		3724: 'battlenet',
		3725: 'na-er-tip',
		3726: 'array-manager',
		3727: 'e-mdu',
		3728: 'e-woa',
		3729: 'fksp-audit',
		3730: 'client-ctrl',
		3731: 'smap',
		3732: 'm-wnn',
		3733: 'multip-msg',
		3734: 'synel-data',
		3735: 'pwdis',
		3736: 'rs-rmi',
		3738: 'versatalk',
		3739: 'launchbird-lm',
		3740: 'heartbeat',
		3741: 'wysdma',
		3742: 'cst-port',
		3743: 'ipcs-command',
		3744: 'sasg',
		3745: 'gw-call-port',
		3746: 'linktest',
		3747: 'linktest-s',
		3748: 'webdata',
		3749: 'cimtrak',
		3750: 'cbos-ip-port',
		3751: 'gprs-cube',
		3752: 'vipremoteagent',
		3753: 'nattyserver',
		3754: 'timestenbroker',
		3755: 'sas-remote-hlp',
		3756: 'canon-capt',
		3757: 'grf-port',
		3758: 'apw-registry',
		3759: 'exapt-lmgr',
		3760: 'adtempusclient',
		3761: 'gsakmp',
		3762: 'gbs-smp',
		3763: 'xo-wave',
		3764: 'mni-prot-rout',
		3765: 'rtraceroute',
		3767: 'listmgr-port',
		3768: 'rblcheckd',
		3769: 'haipe-otnk',
		3770: 'cindycollab',
		3771: 'paging-port',
		3772: 'ctp',
		3773: 'ctdhercules',
		3774: 'zicom',
		3775: 'ispmmgr',
		3776: 'dvcprov-port',
		3777: 'jibe-eb',
		3778: 'c-h-it-port',
		3779: 'cognima',
		3780: 'nnp',
		3781: 'abcvoice-port',
		3782: 'iso-tp0s',
		3783: 'bim-pem',
		3784: 'bfd-control',
		3785: 'bfd-echo',
		3786: 'upstriggervsw',
		3787: 'fintrx',
		3788: 'isrp-port',
		3789: 'remotedeploy',
		3790: 'quickbooksrds',
		3791: 'tvnetworkvideo',
		3792: 'sitewatch',
		3793: 'dcsoftware',
		3794: 'jaus',
		3795: 'myblast',
		3796: 'spw-dialer',
		3797: 'idps',
		3798: 'minilock',
		3799: 'radius-dynauth',
		3800: 'pwgpsi',
		3801: 'ibm-mgr',
		3802: 'vhd',
		3803: 'soniqsync',
		3804: 'iqnet-port',
		3805: 'tcpdataserver',
		3806: 'wsmlb',
		3807: 'spugna',
		3808: 'sun-as-iiops-ca',
		3809: 'apocd',
		3810: 'wlanauth',
		3811: 'amp',
		3812: 'neto-wol-server',
		3813: 'rap-ip',
		3814: 'neto-dcs',
		3815: 'lansurveyorxml',
		3816: 'sunlps-http',
		3817: 'tapeware',
		3818: 'crinis-hb',
		3819: 'epl-slp',
		3820: 'scp',
		3821: 'pmcp',
		3822: 'acp-discovery',
		3823: 'acp-conduit',
		3824: 'acp-policy',
		3831: 'dvapps',
		3832: 'xxnetserver',
		3833: 'aipn-auth',
		3834: 'spectardata',
		3835: 'spectardb',
		3836: 'markem-dcp',
		3837: 'mkm-discovery',
		3838: 'sos',
		3839: 'amx-rms',
		3840: 'flirtmitmir',
		3841: 'zfirm-shiprush3',
		3842: 'nhci',
		3843: 'quest-agent',
		3844: 'rnm',
		3845: 'v-one-spp',
		3846: 'an-pcp',
		3847: 'msfw-control',
		3848: 'item',
		3849: 'spw-dnspreload',
		3850: 'qtms-bootstrap',
		3851: 'spectraport',
		3852: 'sse-app-config',
		3853: 'sscan',
		3854: 'stryker-com',
		3855: 'opentrac',
		3856: 'informer',
		3857: 'trap-port',
		3858: 'trap-port-mom',
		3859: 'nav-port',
		3860: 'sasp',
		3861: 'winshadow-hd',
		3862: 'giga-pocket',
		3863: 'asap-udp',
		3864: 'asap-tcp-tls',
		3865: 'xpl',
		3866: 'dzdaemon',
		3867: 'dzoglserver',
		3868: 'diameter',
		3869: 'ovsam-mgmt',
		3870: 'ovsam-d-agent',
		3871: 'avocent-adsap',
		3872: 'oem-agent',
		3873: 'fagordnc',
		3874: 'sixxsconfig',
		3875: 'pnbscada',
		3876: 'dl_agent',
		3877: 'xmpcr-interface',
		3878: 'fotogcad',
		3879: 'appss-lm',
		3880: 'igrs',
		3881: 'idac',
		3882: 'msdts1',
		3883: 'vrpn',
		3884: 'softrack-meter',
		3885: 'topflow-ssl',
		3886: 'nei-management',
		3887: 'ciphire-data',
		3888: 'ciphire-serv',
		3889: 'dandv-tester',
		3890: 'ndsconnect',
		3891: 'rtc-pm-port',
		3892: 'pcc-image-port',
		3893: 'cgi-starapi',
		3894: 'syam-agent',
		3895: 'syam-smc',
		3896: 'sdo-tls',
		3897: 'sdo-ssh',
		3898: 'senip',
		3899: 'itv-control',
		3900: 'udt_os',
		3901: 'nimsh',
		3902: 'nimaux',
		3903: 'charsetmgr',
		3904: 'omnilink-port',
		3905: 'mupdate',
		3906: 'topovista-data',
		3907: 'imoguia-port',
		3908: 'hppronetman',
		3909: 'surfcontrolcpa',
		3910: 'prnrequest',
		3911: 'prnstatus',
		3912: 'gbmt-stars',
		3913: 'listcrt-port',
		3914: 'listcrt-port-2',
		3915: 'agcat',
		3916: 'wysdmc',
		3917: 'aftmux',
		3918: 'pktcablemmcops',
		3919: 'hyperip',
		3920: 'exasoftport1',
		3921: 'herodotus-net',
		3922: 'sor-update',
		3923: 'symb-sb-port',
		3924: 'mpl-gprs-port',
		3925: 'zmp',
		3926: 'winport',
		3927: 'natdataservice',
		3928: 'netboot-pxe',
		3929: 'smauth-port',
		3930: 'syam-webserver',
		3931: 'msr-plugin-port',
		3932: 'dyn-site',
		3933: 'plbserve-port',
		3934: 'sunfm-port',
		3935: 'sdp-portmapper',
		3936: 'mailprox',
		3937: 'dvbservdscport',
		3938: 'dbcontrol_agent',
		3939: 'aamp',
		3940: 'xecp-node',
		3941: 'homeportal-web',
		3942: 'srdp',
		3943: 'tig',
		3944: 'sops',
		3945: 'emcads',
		3946: 'backupedge',
		3947: 'ccp',
		3948: 'apdap',
		3949: 'drip',
		3950: 'namemunge',
		3951: 'pwgippfax',
		3952: 'i3-sessionmgr',
		3953: 'xmlink-connect',
		3954: 'adrep',
		3955: 'p2pcommunity',
		3956: 'gvcp',
		3957: 'mqe-broker',
		3958: 'mqe-agent',
		3959: 'treehopper',
		3960: 'bess',
		3961: 'proaxess',
		3962: 'sbi-agent',
		3963: 'thrp',
		3964: 'sasggprs',
		3965: 'ati-ip-to-ncpe',
		3966: 'bflckmgr',
		3967: 'ppsms',
		3968: 'ianywhere-dbns',
		3969: 'landmarks',
		3970: 'lanrevagent',
		3971: 'lanrevserver',
		3972: 'iconp',
		3973: 'progistics',
		3974: 'citysearch',
		3975: 'airshot',
		3976: 'opswagent',
		3977: 'opswmanager',
		3978: 'secure-cfg-svr',
		3979: 'smwan',
		3980: 'acms',
		3981: 'starfish',
		3982: 'eis',
		3983: 'eisp',
		3984: 'mapper-nodemgr',
		3985: 'mapper-mapethd',
		3986: 'mapper-ws_ethd',
		3987: 'centerline',
		3988: 'dcs-config',
		3989: 'bv-queryengine',
		3990: 'bv-is',
		3991: 'bv-smcsrv',
		3992: 'bv-ds',
		3993: 'bv-agent',
		3994: 'objserver',
		3995: 'iss-mgmt-ssl',
		3996: 'abscoftware',
		3997: 'agentsease-db',
		4000: 'terabase',
		4001: 'newoak',
		4002: 'pxc-spvr-ft',
		4003: 'pxc-splr-ft',
		4004: 'pxc-roid',
		4005: 'pxc-pin',
		4006: 'pxc-spvr',
		4007: 'pxc-splr',
		4008: 'netcheque',
		4009: 'chimera-hwm',
		4010: 'samsung-unidex',
		4011: 'altserviceboot',
		4012: 'pda-gate',
		4013: 'acl-manager',
		4014: 'taiclock',
		4015: 'talarian-mcast1',
		4016: 'talarian-mcast2',
		4017: 'talarian-mcast3',
		4018: 'talarian-mcast4',
		4019: 'talarian-mcast5',
		4020: 'trap',
		4021: 'nexus-portal',
		4022: 'dnox',
		4023: 'esnm-zoning',
		4024: 'tnp1-port',
		4025: 'partimage',
		4026: 'as-debug',
		4027: 'bxp',
		4028: 'dtserver-port',
		4029: 'ip-qsig',
		4030: 'jdmn-port',
		4031: 'suucp',
		4032: 'vrts-auth-port',
		4033: 'sanavigator',
		4034: 'ubxd',
		4035: 'wap-push-http',
		4036: 'wap-push-https',
		4037: 'ravehd',
		4038: 'fazzt-ptp',
		4039: 'fazzt-admin',
		4040: 'yo-main',
		4041: 'houston',
		4042: 'ldxp',
		4043: 'nirp',
		4044: 'ltp',
		4045: 'npp',
		4046: 'acp-proto',
		4047: 'ctp-state',
		4048: 'objadmin',
		4049: 'wafs',
		4050: 'cisco-wafs',
		4051: 'cppdp',
		4052: 'interact',
		4053: 'ccu-comm-1',
		4054: 'ccu-comm-2',
		4055: 'ccu-comm-3',
		4056: 'lms',
		4057: 'wfm',
		4058: 'kingfisher',
		4059: 'dlms-cosem',
		4060: 'dsmeter_iatc',
		4061: 'ice-location',
		4062: 'ice-slocation',
		4063: 'ice-router',
		4064: 'ice-srouter',
		4089: 'opencore',
		4090: 'omasgport',
		4091: 'ewinstaller',
		4092: 'ewdgs',
		4093: 'pvxpluscs',
		4094: 'sysrqd',
		4095: 'xtgui',
		4096: 'bre',
		4097: 'patrolview',
		4098: 'drmsfsd',
		4099: 'dpcp',
		4100: 'igo-incognito',
		4101: 'brlp-0',
		4102: 'brlp-1',
		4103: 'brlp-2',
		4104: 'brlp-3',
		4105: 'shofarplayer',
		4106: 'synchronite',
		4107: 'j-ac',
		4108: 'accel',
		4111: 'xgrid',
		4112: 'apple-vpns-rp',
		4113: 'aipn-reg',
		4114: 'jomamqmonitor',
		4115: 'cds',
		4116: 'smartcard-tls',
		4117: 'xmlivestream',
		4118: 'netscript',
		4119: 'assuria-slm',
		4120: 'xtreamx',
		4121: 'e-builder',
		4122: 'fprams',
		4132: 'nuts_dem',
		4133: 'nuts_bootp',
		4134: 'nifty-hmi',
		4135: 'cl-db-attach',
		4136: 'cl-db-request',
		4137: 'cl-db-remote',
		4138: 'nettest',
		4139: 'thrtx',
		4140: 'cedros_fds',
		4141: 'oirtgsvc',
		4142: 'oidocsvc',
		4143: 'oidsr',
		4145: 'vvr-control',
		4146: 'tgcconnect',
		4147: 'vrxpservman',
		4154: 'atlinks',
		4159: 'nss',
		4160: 'jini-discovery',
		4161: 'omscontact',
		4162: 'omstopology',
		4190: 'sieve',
		4199: 'eims-admin',
		4300: 'corelccam',
		4301: 'd-data',
		4302: 'd-data-control',
		4320: 'fdt-rcatp',
		4321: 'rwhois',
		4325: 'geognosisman',
		4326: 'geognosis',
		4343: 'unicall',
		4344: 'vinainstall',
		4345: 'm4-network-as',
		4346: 'elanlm',
		4347: 'lansurveyor',
		4348: 'itose',
		4349: 'fsportmap',
		4350: 'net-device',
		4351: 'plcy-net-svcs',
		4352: 'pjlink',
		4353: 'f5-iquery',
		4354: 'qsnet-trans',
		4355: 'qsnet-workst',
		4356: 'qsnet-assist',
		4357: 'qsnet-cond',
		4358: 'qsnet-nucl',
		4368: 'wxbrief',
		4369: 'epmd',
		4400: 'ds-srv',
		4401: 'ds-srvr',
		4402: 'ds-clnt',
		4403: 'ds-user',
		4404: 'ds-admin',
		4405: 'ds-mail',
		4406: 'ds-slp',
		4426: 'beacon-port-2',
		4442: 'saris',
		4443: 'pharos',
		4444: 'nv-video',
		4445: 'upnotifyp',
		4446: 'n1-fwp',
		4447: 'n1-rmgmt',
		4448: 'asc-slmd',
		4449: 'privatewire',
		4450: 'camp',
		4451: 'ctisystemmsg',
		4452: 'ctiprogramload',
		4453: 'nssalertmgr',
		4454: 'nssagentmgr',
		4455: 'prchat-user',
		4456: 'prchat-server',
		4457: 'prRegister',
		4458: 'mcp',
		4484: 'hpssmgmt',
		4500: 'ipsec-msft',
		4535: 'ehs',
		4536: 'ehs-ssl',
		4537: 'wssauthsvc',
		4538: 'isigate',
		4545: 'worldscores',
		4546: 'sf-lm',
		4547: 'lanner-lm',
		4548: 'synchromesh',
		4549: 'aegate',
		4550: 'gds-adppiw-db',
		4554: 'msfrs',
		4555: 'rsip',
		4556: 'dtn-bundle-udp',
		4559: 'hylafax',
		4566: 'kwtc',
		4567: 'tram',
		4568: 'bmc-reporting',
		4569: 'iax',
		4597: 'a21-an-1xbs',
		4598: 'a16-an-an',
		4599: 'a17-an-an',
		4600: 'piranha1',
		4601: 'piranha2',
		4658: 'playsta2-app',
		4659: 'playsta2-lob',
		4660: 'smaclmgr',
		4661: 'kar2ouche',
		4662: 'oms',
		4663: 'noteit',
		4664: 'ems',
		4665: 'contclientms',
		4666: 'eportcomm',
		4667: 'mmacomm',
		4668: 'mmaeds',
		4669: 'eportcommdata',
		4670: 'light',
		4671: 'acter',
		4672: 'rfa',
		4673: 'cxws',
		4674: 'appiq-mgmt',
		4675: 'dhct-status',
		4676: 'dhct-alerts',
		4677: 'bcs',
		4678: 'traversal',
		4679: 'mgesupervision',
		4680: 'mgemanagement',
		4681: 'parliant',
		4682: 'finisar',
		4683: 'spike',
		4684: 'rfid-rp1',
		4685: 'autopac',
		4686: 'msp-os',
		4687: 'nst',
		4688: 'mobile-p2p',
		4689: 'altovacentral',
		4690: 'prelude',
		4691: 'monotone',
		4692: 'conspiracy',
		4700: 'netxms-agent',
		4701: 'netxms-mgmt',
		4702: 'netxms-sync',
		4728: 'capmux',
		4737: 'ipdr-sp',
		4738: 'solera-lpn',
		4739: 'ipfix',
		4740: 'ipfixs',
		4742: 'sicct-sdp',
		4743: 'openhpid',
		4749: 'profilemac',
		4750: 'ssad',
		4751: 'spocp',
		4752: 'snap',
		4784: 'bfd-multi-ctl',
		4800: 'iims',
		4801: 'iwec',
		4802: 'ilss',
		4827: 'htcp',
		4837: 'varadero-0',
		4838: 'varadero-1',
		4839: 'varadero-2',
		4840: 'opcua-udp',
		4841: 'quosa',
		4842: 'gw-asv',
		4843: 'opcua-tls',
		4844: 'gw-log',
		4848: 'appserv-http',
		4849: 'appserv-https',
		4850: 'sun-as-nodeagt',
		4867: 'unify-debug',
		4868: 'phrelay',
		4869: 'phrelaydbg',
		4870: 'cc-tracking',
		4871: 'wired',
		4885: 'abbs',
		4894: 'lyskom',
		4899: 'radmin-port',
		4900: 'hfcs',
		4949: 'munin',
		4951: 'pwgwims',
		4952: 'sagxtsds',
		4969: 'ccss-qmm',
		4970: 'ccss-qsm',
		4983: 'att-intercom',
		4986: 'mrip',
		4987: 'smar-se-port1',
		4988: 'smar-se-port2',
		4989: 'parallel',
		4999: 'hfcs-manager',
		5000: 'commplex-main',
		5001: 'commplex-link',
		5002: 'rfe',
		5003: 'fmpro-internal',
		5004: 'avt-profile-1',
		5005: 'avt-profile-2',
		5006: 'wsm-server',
		5007: 'wsm-server-ssl',
		5008: 'synapsis-edge',
		5009: 'winfs',
		5010: 'telelpathstart',
		5011: 'telelpathattack',
		5020: 'zenginkyo-1',
		5021: 'zenginkyo-2',
		5022: 'mice',
		5023: 'htuilsrv',
		5024: 'scpi-telnet',
		5025: 'scpi-raw',
		5026: 'strexec-d',
		5027: 'strexec-s',
		5030: 'surfpass',
		5042: 'asnaacceler8db',
		5043: 'swxadmin',
		5044: 'lxi-evntsvc',
		5049: 'ivocalize',
		5050: 'mmcc',
		5051: 'ita-agent',
		5052: 'ita-manager',
		5055: 'unot',
		5056: 'intecom-ps1',
		5057: 'intecom-ps2',
		5059: 'sds',
		5060: 'sip',
		5061: 'sip-tls',
		5064: 'ca-1',
		5065: 'ca-2',
		5066: 'stanag-5066',
		5067: 'authentx',
		5069: 'i-net-2000-npr',
		5070: 'vtsas',
		5071: 'powerschool',
		5072: 'ayiya',
		5073: 'tag-pm',
		5074: 'alesquery',
		5081: 'sdl-ets',
		5084: 'llrp',
		5085: 'encrypted-llrp',
		5093: 'sentinel-lm',
		5099: 'sentlm-srv2srv',
		5100: 'socalia',
		5101: 'talarian-tcp',
		5102: 'oms-nonsecure',
		5112: 'pm-cmdsvr',
		5133: 'nbt-pc',
		5137: 'ctsd',
		5145: 'rmonitor_secure',
		5150: 'atmp',
		5151: 'esri_sde',
		5152: 'sde-discovery',
		5154: 'bzflag',
		5155: 'asctrl-agent',
		5165: 'ife_icorp',
		5166: 'winpcs',
		5167: 'scte104',
		5168: 'scte30',
		5190: 'aol',
		5191: 'aol-1',
		5192: 'aol-2',
		5193: 'aol-3',
		5200: 'targus-getdata',
		5201: 'targus-getdata1',
		5202: 'targus-getdata2',
		5203: 'targus-getdata3',
		5222: 'jabber-client',
		5225: 'hp-server',
		5226: 'hp-status',
		5234: 'eenet',
		5236: 'padl2sim',
		5250: 'igateway',
		5251: 'caevms',
		5252: 'movaz-ssc',
		5264: '3com-njack-1',
		5265: '3com-njack-2',
		5269: 'jabber-server',
		5272: 'pk',
		5282: 'transmit-port',
		5300: 'hacl-hb',
		5301: 'hacl-gs',
		5302: 'hacl-cfg',
		5303: 'hacl-probe',
		5304: 'hacl-local',
		5305: 'hacl-test',
		5306: 'sun-mc-grp',
		5307: 'sco-aip',
		5308: 'cfengine',
		5309: 'jprinter',
		5310: 'outlaws',
		5312: 'permabit-cs',
		5313: 'rrdp',
		5314: 'opalis-rbt-ipc',
		5315: 'hacl-poll',
		5343: 'kfserver',
		5344: 'xkotodrcp',
		5351: 'nat-pmp',
		5352: 'dns-llq',
		5353: 'mdns',
		5354: 'mdnsresponder',
		5355: 'llmnr',
		5356: 'ms-smlbiz',
		5357: 'wsdapi',
		5358: 'wsdapi-s',
		5397: 'stresstester',
		5398: 'elektron-admin',
		5399: 'securitychase',
		5400: 'excerpt',
		5401: 'excerpts',
		5402: 'mftp',
		5403: 'hpoms-ci-lstn',
		5404: 'hpoms-dps-lstn',
		5405: 'netsupport',
		5406: 'systemics-sox',
		5407: 'foresyte-clear',
		5408: 'foresyte-sec',
		5409: 'salient-dtasrv',
		5410: 'salient-usrmgr',
		5411: 'actnet',
		5412: 'continuus',
		5413: 'wwiotalk',
		5414: 'statusd',
		5415: 'ns-server',
		5416: 'sns-gateway',
		5417: 'sns-agent',
		5418: 'mcntp',
		5419: 'dj-ice',
		5420: 'cylink-c',
		5421: 'netsupport2',
		5422: 'salient-mux',
		5423: 'virtualuser',
		5424: 'beyond-remote',
		5425: 'br-channel',
		5426: 'devbasic',
		5427: 'sco-peer-tta',
		5428: 'telaconsole',
		5429: 'base',
		5430: 'radec-corp',
		5431: 'park-agent',
		5432: 'postgresql',
		5433: 'pyrrho',
		5434: 'sgi-arrayd',
		5435: 'dttl',
		5453: 'surebox',
		5454: 'apc-5454',
		5455: 'apc-5455',
		5456: 'apc-5456',
		5461: 'silkmeter',
		5462: 'ttl-publisher',
		5463: 'ttlpriceproxy',
		5464: 'quailnet',
		5465: 'netops-broker',
		5500: 'fcp-addr-srvr1',
		5501: 'fcp-addr-srvr2',
		5502: 'fcp-srvr-inst1',
		5503: 'fcp-srvr-inst2',
		5504: 'fcp-cics-gw1',
		5553: 'sgi-eventmond',
		5554: 'sgi-esphttp',
		5555: 'personal-agent',
		5556: 'freeciv',
		5566: 'udpplus',
		5567: 'm-oap',
		5568: 'sdt',
		5580: 'tmosms0',
		5581: 'tmosms1',
		5584: 'bis-web',
		5585: 'bis-sync',
		5597: 'ininmessaging',
		5598: 'mctfeed',
		5599: 'esinstall',
		5600: 'esmmanager',
		5601: 'esmagent',
		5602: 'a1-msc',
		5603: 'a1-bs',
		5604: 'a3-sdunode',
		5605: 'a4-sdunode',
		5627: 'ninaf',
		5629: 'symantec-sfdb',
		5630: 'precise-comm',
		5631: 'pcanywheredata',
		5632: 'pcanywherestat',
		5633: 'beorl',
		5672: 'amqp',
		5673: 'jms',
		5674: 'hyperscsi-port',
		5675: 'v5ua',
		5676: 'raadmin',
		5677: 'questdb2-lnchr',
		5678: 'rrac',
		5679: 'dccm',
		5680: 'auriga-router',
		5681: 'ncxcp',
		5688: 'ggz',
		5689: 'qmvideo',
		5713: 'proshareaudio',
		5714: 'prosharevideo',
		5715: 'prosharedata',
		5716: 'prosharerequest',
		5717: 'prosharenotify',
		5718: 'dpm',
		5719: 'dpm-agent',
		5720: 'ms-licensing',
		5721: 'dtpt',
		5722: 'msdfsr',
		5723: 'omhs',
		5724: 'omsdk',
		5729: 'openmail',
		5730: 'unieng',
		5741: 'ida-discover1',
		5742: 'ida-discover2',
		5743: 'watchdoc-pod',
		5744: 'watchdoc',
		5745: 'fcopy-server',
		5746: 'fcopys-server',
		5747: 'tunatic',
		5748: 'tunalyzer',
		5755: 'openmailg',
		5757: 'x500ms',
		5766: 'openmailns',
		5767: 's-openmail',
		5768: 'openmailpxy',
		5769: 'spramsca',
		5770: 'spramsd',
		5771: 'netagent',
		5777: 'dali-port',
		5813: 'icmpd',
		5814: 'spt-automation',
		5859: 'wherehoo',
		5863: 'ppsuitemsg',
		5900: 'rfb',
		5963: 'indy',
		5968: 'mppolicy-v5',
		5969: 'mppolicy-mgr',
		5985: 'wsman',
		5986: 'wsmans',
		5987: 'wbem-rmi',
		5988: 'wbem-http',
		5989: 'wbem-https',
		5990: 'wbem-exp-https',
		5991: 'nuxsl',
		5992: 'consul-insight',
		5999: 'cvsup',
		6064: 'ndl-ahp-svc',
		6065: 'winpharaoh',
		6066: 'ewctsp',
		6067: 'srb',
		6068: 'gsmp',
		6069: 'trip',
		6070: 'messageasap',
		6071: 'ssdtp',
		6072: 'diagnose-proc',
		6073: 'directplay8',
		6074: 'max',
		6085: 'konspire2b',
		6086: 'pdtp',
		6087: 'ldss',
		6100: 'synchronet-db',
		6101: 'synchronet-rtc',
		6102: 'synchronet-upd',
		6103: 'rets',
		6104: 'dbdb',
		6105: 'primaserver',
		6106: 'mpsserver',
		6107: 'etc-control',
		6108: 'sercomm-scadmin',
		6109: 'globecast-id',
		6110: 'softcm',
		6111: 'spc',
		6112: 'dtspcd',
		6122: 'bex-webadmin',
		6123: 'backup-express',
		6133: 'nbt-wol',
		6141: 'meta-corp',
		6142: 'aspentec-lm',
		6143: 'watershed-lm',
		6144: 'statsci1-lm',
		6145: 'statsci2-lm',
		6146: 'lonewolf-lm',
		6147: 'montage-lm',
		6148: 'ricardo-lm',
		6149: 'tal-pod',
		6161: 'patrol-ism',
		6162: 'patrol-coll',
		6163: 'pscribe',
		6200: 'lm-x',
		6222: 'radmind',
		6253: 'crip',
		6268: 'grid',
		6269: 'grid-alt',
		6300: 'bmc-grx',
		6301: 'bmc_ctd_ldap',
		6320: 'repsvc',
		6321: 'emp-server1',
		6322: 'emp-server2',
		6343: 'sflow',
		6346: 'gnutella-svc',
		6347: 'gnutella-rtr',
		6382: 'metatude-mds',
		6389: 'clariion-evr01',
		6417: 'faxcomservice',
		6420: 'nim-vdrshell',
		6421: 'nim-wan',
		6443: 'sun-sr-https',
		6444: 'sge_qmaster',
		6445: 'sge_execd',
		6455: 'skip-cert-recv',
		6456: 'skip-cert-send',
		6471: 'lvision-lm',
		6480: 'sun-sr-http',
		6484: 'sun-sr-jms',
		6485: 'sun-sr-iiop',
		6486: 'sun-sr-iiops',
		6487: 'sun-sr-iiop-aut',
		6488: 'sun-sr-jmx',
		6489: 'sun-sr-admin',
		6500: 'boks',
		6501: 'boks_servc',
		6502: 'boks_servm',
		6503: 'boks_clntd',
		6505: 'badm_priv',
		6506: 'badm_pub',
		6507: 'bdir_priv',
		6508: 'bdir_pub',
		6509: 'mgcs-mfp-port',
		6510: 'mcer-port',
		6543: 'lds-distrib',
		6544: 'lds-dump',
		6547: 'apc-6547',
		6548: 'apc-6548',
		6549: 'apc-6549',
		6550: 'fg-sysupdate',
		6558: 'xdsxdm',
		6566: 'sane-port',
		6579: 'affiliate',
		6580: 'parsec-master',
		6581: 'parsec-peer',
		6582: 'parsec-game',
		6583: 'joaJewelSuite',
		6619: 'odette-ftps',
		6620: 'kftp-data',
		6621: 'kftp',
		6622: 'mcftp',
		6623: 'ktelnet',
		6626: 'wago-service',
		6627: 'nexgen',
		6628: 'afesc-mc',
		6631: 'mach',
		6670: 'vocaltec-gold',
		6672: 'vision_server',
		6673: 'vision_elmd',
		6701: 'kti-icad-srvr',
		6702: 'e-design-net',
		6703: 'e-design-web',
		6714: 'ibprotocol',
		6715: 'fibotrader-com',
		6767: 'bmc-perf-agent',
		6768: 'bmc-perf-mgrd',
		6769: 'adi-gxp-srvprt',
		6770: 'plysrv-http',
		6771: 'plysrv-https',
		6785: 'dgpf-exchg',
		6786: 'smc-jmx',
		6787: 'smc-admin',
		6788: 'smc-http',
		6789: 'smc-https',
		6790: 'hnmp',
		6791: 'hnm',
		6831: 'ambit-lm',
		6841: 'netmo-default',
		6842: 'netmo-http',
		6850: 'iccrushmore',
		6888: 'muse',
		6936: 'xsmsvc',
		6946: 'bioserver',
		6951: 'otlp',
		6961: 'jmact3',
		6962: 'jmevt2',
		6963: 'swismgr1',
		6964: 'swismgr2',
		6965: 'swistrap',
		6966: 'swispol',
		6969: 'acmsoda',
		6998: 'iatp-highpri',
		6999: 'iatp-normalpri',
		7000: 'afs3-fileserver',
		7001: 'afs3-callback',
		7002: 'afs3-prserver',
		7003: 'afs3-vlserver',
		7004: 'afs3-kaserver',
		7005: 'afs3-volser',
		7006: 'afs3-errors',
		7007: 'afs3-bos',
		7008: 'afs3-update',
		7009: 'afs3-rmtsys',
		7010: 'ups-onlinet',
		7011: 'talon-disc',
		7012: 'talon-engine',
		7013: 'microtalon-dis',
		7014: 'microtalon-com',
		7015: 'talon-webserver',
		7020: 'dpserve',
		7021: 'dpserveadmin',
		7022: 'ctdp',
		7023: 'ct2nmcs',
		7024: 'vmsvc',
		7025: 'vmsvc-2',
		7030: 'op-probe',
		7070: 'arcp',
		7099: 'lazy-ptop',
		7100: 'font-service',
		7121: 'virprot-lm',
		7128: 'scenidm',
		7129: 'scenccs',
		7161: 'cabsm-comm',
		7162: 'caistoragemgr',
		7163: 'cacsambroker',
		7174: 'clutild',
		7200: 'fodms',
		7201: 'dlip',
		7227: 'ramp',
		7272: 'watchme-7272',
		7273: 'oma-rlp',
		7274: 'oma-rlp-s',
		7275: 'oma-ulp',
		7280: 'itactionserver1',
		7281: 'itactionserver2',
		7365: 'lcm-server',
		7391: 'mindfilesys',
		7392: 'mrssrendezvous',
		7393: 'nfoldman',
		7394: 'fse',
		7395: 'winqedit',
		7397: 'hexarc',
		7400: 'rtps-discovery',
		7401: 'rtps-dd-ut',
		7402: 'rtps-dd-mt',
		7410: 'ionixnetmon',
		7421: 'mtportmon',
		7426: 'pmdmgr',
		7427: 'oveadmgr',
		7428: 'ovladmgr',
		7429: 'opi-sock',
		7430: 'xmpv7',
		7431: 'pmd',
		7437: 'faximum',
		7443: 'oracleas-https',
		7491: 'telops-lmd',
		7500: 'silhouette',
		7501: 'ovbus',
		7510: 'ovhpas',
		7511: 'pafec-lm',
		7543: 'atul',
		7544: 'nta-ds',
		7545: 'nta-us',
		7546: 'cfs',
		7547: 'cwmp',
		7548: 'tidp',
		7549: 'nls-tl',
		7560: 'sncp',
		7566: 'vsi-omega',
		7570: 'aries-kfinder',
		7588: 'sun-lm',
		7624: 'indi',
		7626: 'simco',
		7627: 'soap-http',
		7628: 'zen-pawn',
		7629: 'xdas',
		7633: 'pmdfmgt',
		7648: 'cuseeme',
		7674: 'imqtunnels',
		7675: 'imqtunnel',
		7676: 'imqbrokerd',
		7677: 'sun-user-https',
		7697: 'klio',
		7707: 'sync-em7',
		7708: 'scinet',
		7720: 'medimageportal',
		7725: 'nitrogen',
		7726: 'freezexservice',
		7727: 'trident-data',
		7738: 'aiagent',
		7743: 'sstp-1',
		7744: 'raqmon-pdu',
		7777: 'cbt',
		7778: 'interwise',
		7779: 'vstat',
		7781: 'accu-lmgr',
		7786: 'minivend',
		7787: 'popup-reminders',
		7789: 'office-tools',
		7794: 'q3ade',
		7797: 'pnet-conn',
		7798: 'pnet-enc',
		7800: 'asr',
		7801: 'ssp-client',
		7845: 'apc-7845',
		7846: 'apc-7846',
		7887: 'ubroker',
		7900: 'mevent',
		7901: 'tnos-sp',
		7902: 'tnos-dp',
		7903: 'tnos-dps',
		7913: 'qo-secure',
		7932: 't2-drm',
		7933: 't2-brm',
		7967: 'supercell',
		7979: 'micromuse-ncps',
		7980: 'quest-vista',
		7999: 'irdmi2',
		8000: 'irdmi',
		8001: 'vcom-tunnel',
		8002: 'teradataordbms',
		8008: 'http-alt',
		8020: 'intu-ec-svcdisc',
		8021: 'intu-ec-client',
		8022: 'oa-system',
		8025: 'ca-audit-da',
		8026: 'ca-audit-ds',
		8032: 'pro-ed',
		8033: 'mindprint',
		8052: 'senomix01',
		8053: 'senomix02',
		8054: 'senomix03',
		8055: 'senomix04',
		8056: 'senomix05',
		8057: 'senomix06',
		8058: 'senomix07',
		8059: 'senomix08',
		8074: 'gadugadu',
		8080: 'http-alt',
		8081: 'sunproxyadmin',
		8082: 'us-cli',
		8083: 'us-srv',
		8088: 'radan-http',
		8097: 'sac',
		8100: 'xprint-server',
		8115: 'mtl8000-matrix',
		8116: 'cp-cluster',
		8118: 'privoxy',
		8121: 'apollo-data',
		8122: 'apollo-admin',
		8128: 'paycash-online',
		8129: 'paycash-wbp',
		8130: 'indigo-vrmi',
		8131: 'indigo-vbcp',
		8132: 'dbabble',
		8148: 'isdd',
		8160: 'patrol',
		8161: 'patrol-snmp',
		8192: 'spytechphone',
		8194: 'blp1',
		8195: 'blp2',
		8199: 'vvr-data',
		8200: 'trivnet1',
		8201: 'trivnet2',
		8204: 'lm-perfworks',
		8205: 'lm-instmgr',
		8206: 'lm-dta',
		8207: 'lm-sserver',
		8208: 'lm-webwatcher',
		8230: 'rexecj',
		8292: 'blp3',
		8294: 'blp4',
		8300: 'tmi',
		8301: 'amberon',
		8351: 'server-find',
		8376: 'cruise-enum',
		8377: 'cruise-swroute',
		8378: 'cruise-config',
		8379: 'cruise-diags',
		8380: 'cruise-update',
		8383: 'm2mservices',
		8400: 'cvd',
		8401: 'sabarsd',
		8402: 'abarsd',
		8403: 'admind',
		8416: 'espeech',
		8417: 'espeech-rtp',
		8443: 'pcsync-https',
		8444: 'pcsync-http',
		8450: 'npmp',
		8473: 'vp2p',
		8474: 'noteshare',
		8500: 'fmtp',
		8554: 'rtsp-alt',
		8555: 'd-fence',
		8668: 'natd',
		8567: 'oap-admin',
		8600: 'asterix',
		8611: 'canon-bjnp1',
		8612: 'canon-bjnp2',
		8613: 'canon-bjnp3',
		8614: 'canon-bjnp4',
		8686: 'sun-as-jmxrmi',
		8699: 'vnyx',
		8733: 'ibus',
		8763: 'mc-appserver',
		8764: 'openqueue',
		8765: 'ultraseek-http',
		8770: 'dpap',
		8786: 'msgclnt',
		8787: 'msgsrvr',
		8800: 'sunwebadmin',
		8804: 'truecm',
		8873: 'dxspider',
		8880: 'cddbp-alt',
		8888: 'ddi-tcp-1',
		8889: 'ddi-tcp-2',
		8890: 'ddi-tcp-3',
		8891: 'ddi-tcp-4',
		8892: 'ddi-tcp-5',
		8893: 'ddi-tcp-6',
		8894: 'ddi-tcp-7',
		8900: 'jmb-cds1',
		8901: 'jmb-cds2',
		8910: 'manyone-http',
		8911: 'manyone-xml',
		8912: 'wcbackup',
		8913: 'dragonfly',
		8954: 'cumulus-admin',
		8989: 'sunwebadmins',
		8999: 'bctp',
		9000: 'cslistener',
		9001: 'etlservicemgr',
		9002: 'dynamid',
		9009: 'pichat',
		9020: 'tambora',
		9021: 'panagolin-ident',
		9022: 'paragent',
		9023: 'swa-1',
		9024: 'swa-2',
		9025: 'swa-3',
		9026: 'swa-4',
		9080: 'glrpc',
		9088: 'sqlexec',
		9089: 'sqlexec-ssl',
		9090: 'websm',
		9091: 'xmltec-xmlmail',
		9092: 'XmlIpcRegSvc',
		9100: 'pdl-datastream',
		9101: 'bacula-dir',
		9102: 'bacula-fd',
		9103: 'bacula-sd',
		9104: 'peerwire',
		9119: 'mxit',
		9131: 'dddp',
		9160: 'netlock1',
		9161: 'netlock2',
		9162: 'netlock3',
		9163: 'netlock4',
		9164: 'netlock5',
		9191: 'sun-as-jpda',
		9200: 'wap-wsp',
		9201: 'wap-wsp-wtp',
		9202: 'wap-wsp-s',
		9203: 'wap-wsp-wtp-s',
		9204: 'wap-vcard',
		9205: 'wap-vcal',
		9206: 'wap-vcard-s',
		9207: 'wap-vcal-s',
		9208: 'rjcdb-vcards',
		9209: 'almobile-system',
		9210: 'lif-mlp',
		9211: 'lif-mlp-s',
		9212: 'serverviewdbms',
		9213: 'serverstart',
		9214: 'ipdcesgbs',
		9215: 'insis',
		9216: 'acme',
		9217: 'fsc-port',
		9222: 'teamcoherence',
		9281: 'swtp-port1',
		9282: 'swtp-port2',
		9283: 'callwaveiam',
		9284: 'visd',
		9285: 'n2h2server',
		9287: 'cumulus',
		9292: 'armtechdaemon',
		9293: 'storview',
		9294: 'armcenterhttp',
		9295: 'armcenterhttps',
		9300: 'vrace',
		9318: 'secure-ts',
		9321: 'guibase',
		9343: 'mpidcmgr',
		9344: 'mphlpdmc',
		9346: 'ctechlicensing',
		9374: 'fjdmimgr',
		9396: 'fjinvmgr',
		9397: 'mpidcagt',
		9418: 'git',
		9443: 'tungsten-https',
		9500: 'ismserver',
		9535: 'mngsuite',
		9555: 'trispen-sra',
		9592: 'ldgateway',
		9593: 'cba8',
		9594: 'msgsys',
		9595: 'pds',
		9596: 'mercury-disc',
		9597: 'pd-admin',
		9598: 'vscp',
		9599: 'robix',
		9600: 'micromuse-ncpw',
		9612: 'streamcomm-ds',
		9700: 'board-roar',
		9747: 'l5nas-parchan',
		9750: 'board-voip',
		9753: 'rasadv',
		9762: 'tungsten-http',
		9800: 'davsrc',
		9801: 'sstp-2',
		9802: 'davsrcs',
		9875: 'sapv1',
		9876: 'sd',
		9888: 'cyborg-systems',
		9898: 'monkeycom',
		9899: 'sctp-tunneling',
		9900: 'iua',
		9901: 'enrp',
		9909: 'domaintime',
		9911: 'sype-transport',
		9950: 'apc-9950',
		9951: 'apc-9951',
		9952: 'apc-9952',
		9953: 'acis',
		9966: 'odnsp',
		9987: 'dsm-scm-target',
		9990: 'osm-appsrvr',
		9991: 'osm-oev',
		9992: 'palace-1',
		9993: 'palace-2',
		9994: 'palace-3',
		9995: 'palace-4',
		9996: 'palace-5',
		9997: 'palace-6',
		9998: 'distinct32',
		9999: 'distinct',
		10000: 'ndmp',
		10001: 'scp-config',
		10007: 'mvs-capacity',
		10008: 'octopus',
		10009: 'swdtp-sv',
		10050: 'zabbix-agent',
		10051: 'zabbix-trapper',
		10080: 'amanda',
		10081: 'famdc',
		10100: 'itap-ddtp',
		10101: 'ezmeeting-2',
		10102: 'ezproxy-2',
		10103: 'ezrelay',
		10104: 'swdtp',
		10107: 'bctp-server',
		10113: 'netiq-endpoint',
		10114: 'netiq-qcheck',
		10115: 'netiq-endpt',
		10116: 'netiq-voipa',
		10128: 'bmc-perf-sd',
		10160: 'qb-db-server',
		10200: 'trisoap',
		10252: 'apollo-relay',
		10260: 'axis-wimp-port',
		10288: 'blocks',
		10800: 'gap',
		10805: 'lpdg',
		10990: 'rmiaux',
		11000: 'irisa',
		11001: 'metasys',
		11111: 'vce',
		11112: 'dicom',
		11161: 'suncacao-snmp',
		11162: 'suncacao-jmxmp',
		11163: 'suncacao-rmi',
		11164: 'suncacao-csa',
		11165: 'suncacao-websvc',
		11201: 'smsqp',
		11208: 'wifree',
		11319: 'imip',
		11320: 'imip-channels',
		11321: 'arena-server',
		11367: 'atm-uhas',
		11371: 'hkp',
		11600: 'tempest-port',
		11720: 'h323callsigalt',
		11751: 'intrepid-ssl',
		11967: 'sysinfo-sp',
		12000: 'entextxid',
		12001: 'entextnetwk',
		12002: 'entexthigh',
		12003: 'entextmed',
		12004: 'entextlow',
		12005: 'dbisamserver1',
		12006: 'dbisamserver2',
		12007: 'accuracer',
		12008: 'accuracer-dbms',
		12012: 'vipera',
		12109: 'rets-ssl',
		12121: 'nupaper-ss',
		12168: 'cawas',
		12172: 'hivep',
		12300: 'linogridengine',
		12321: 'warehouse-sss',
		12322: 'warehouse',
		12345: 'italk',
		12753: 'tsaf',
		13160: 'i-zipqd',
		13223: 'powwow-client',
		13224: 'powwow-server',
		13720: 'bprd',
		13721: 'bpdbm',
		13722: 'bpjava-msvc',
		13724: 'vnetd',
		13782: 'bpcd',
		13783: 'vopied',
		13785: 'nbdb',
		13786: 'nomdb',
		13818: 'dsmcc-config',
		13819: 'dsmcc-session',
		13820: 'dsmcc-passthru',
		13821: 'dsmcc-download',
		13822: 'dsmcc-ccp',
		14001: 'sua',
		14033: 'sage-best-com1',
		14034: 'sage-best-com2',
		14141: 'vcs-app',
		14142: 'icpp',
		14145: 'gcm-app',
		14149: 'vrts-tdd',
		14154: 'vad',
		14414: 'ca-web-update',
		14936: 'hde-lcesrvr-1',
		14937: 'hde-lcesrvr-2',
		15000: 'hydap',
		15345: 'xpilot',
		15363: '3link',
		15555: 'cisco-snat',
		15740: 'ptp',
		16161: 'sun-sea-port',
		16309: 'etb4j',
		16310: 'pduncs',
		16360: 'netserialext1',
		16361: 'netserialext2',
		16367: 'netserialext3',
		16368: 'netserialext4',
		16384: 'connected',
		16991: 'intel-rci-mp',
		16992: 'amt-soap-http',
		16993: 'amt-soap-https',
		16994: 'amt-redir-tcp',
		16995: 'amt-redir-tls',
		17007: 'isode-dua',
		17185: 'soundsvirtual',
		17219: 'chipper',
		17235: 'ssh-mgmt',
		17729: 'ea',
		17754: 'zep',
		17755: 'zigbee-ip',
		17756: 'zigbee-ips',
		18000: 'biimenu',
		18181: 'opsec-cvp',
		18182: 'opsec-ufp',
		18183: 'opsec-sam',
		18184: 'opsec-lea',
		18185: 'opsec-omi',
		18186: 'ohsc',
		18187: 'opsec-ela',
		18241: 'checkpoint-rtm',
		18463: 'ac-cluster',
		18769: 'ique',
		18881: 'infotos',
		18888: 'apc-necmp',
		19000: 'igrid',
		19191: 'opsec-uaa',
		19194: 'ua-secureagent',
		19283: 'keysrvr',
		19315: 'keyshadow',
		19398: 'mtrgtrans',
		19410: 'hp-sco',
		19411: 'hp-sca',
		19412: 'hp-sessmon',
		19539: 'fxuptp',
		19540: 'sxuptp',
		19541: 'jcp',
		20000: 'dnp',
		20001: 'microsan',
		20002: 'commtact-http',
		20003: 'commtact-https',
		20014: 'opendeploy',
		20034: 'nburn_id',
		20167: 'tolfab',
		20202: 'ipdtp-port',
		20222: 'ipulse-ics',
		20670: 'track',
		20999: 'athand-mmp',
		21000: 'irtrans',
		21554: 'dfserver',
		21590: 'vofr-gateway',
		21800: 'tvpm',
		21845: 'webphone',
		21846: 'netspeak-is',
		21847: 'netspeak-cs',
		21848: 'netspeak-acd',
		21849: 'netspeak-cps',
		22000: 'snapenetio',
		22001: 'optocontrol',
		22002: 'optohost002',
		22003: 'optohost003',
		22004: 'optohost004',
		22005: 'optohost004',
		22273: 'wnn6',
		22555: 'vocaltec-wconf',
		22763: 'talikaserver',
		22800: 'aws-brf',
		22951: 'brf-gw',
		23000: 'inovaport1',
		23001: 'inovaport2',
		23002: 'inovaport3',
		23003: 'inovaport4',
		23004: 'inovaport5',
		23005: 'inovaport6',
		23400: 'novar-dbase',
		23401: 'novar-alarm',
		23402: 'novar-global',
		24000: 'med-ltp',
		24001: 'med-fsp-rx',
		24002: 'med-fsp-tx',
		24003: 'med-supp',
		24004: 'med-ovw',
		24005: 'med-ci',
		24006: 'med-net-svc',
		24242: 'filesphere',
		24249: 'vista-4gl',
		24321: 'ild',
		24386: 'intel_rci',
		24554: 'binkp',
		24677: 'flashfiler',
		24678: 'proactivate',
		24680: 'tcc-http',
		24922: 'snip',
		25000: 'icl-twobase1',
		25001: 'icl-twobase2',
		25002: 'icl-twobase3',
		25003: 'icl-twobase4',
		25004: 'icl-twobase5',
		25005: 'icl-twobase6',
		25006: 'icl-twobase7',
		25007: 'icl-twobase8',
		25008: 'icl-twobase9',
		25009: 'icl-twobase10',
		25793: 'vocaltec-hos',
		25900: 'tasp-net',
		25901: 'niobserver',
		25903: 'niprobe',
		26000: 'quake',
		26208: 'wnn6-ds',
		26260: 'ezproxy',
		26261: 'ezmeeting',
		26262: 'k3software-svr',
		26263: 'k3software-cli',
		26264: 'gserver',
		26486: 'exoline-udp',
		26487: 'exoconfig',
		26489: 'exonet',
		27345: 'imagepump',
		27442: 'jesmsjc',
		27504: 'kopek-httphead',
		27782: 'ars-vista',
		27999: 'tw-auth-key',
		28000: 'nxlmd',
		28240: 'siemensgsm',
		29167: 'otmp',
		30001: 'pago-services1',
		30002: 'pago-services2',
		30999: 'ovobs',
		31416: 'xqosd',
		31457: 'tetrinet',
		31620: 'lm-mon',
		31765: 'gamesmith-port',
		31948: 'iceedcp_tx',
		31949: 'iceedcp_rx',
		32249: 't1distproc60',
		32483: 'apm-link',
		32635: 'sec-ntb-clnt',
		32767: 'filenet-powsrm',
		32768: 'filenet-tms',
		32769: 'filenet-rpc',
		32770: 'filenet-nch',
		32771: 'filenet-rmi',
		32772: 'filenet-pa',
		32773: 'filenet-cm',
		32774: 'filenet-re',
		32775: 'filenet-pch',
		32776: 'filenet-peior',
		32777: 'filenet-obrok',
		32896: 'idmgratm',
		33331: 'diamondport',
		33434: 'traceroute',
		33656: 'snip-slave',
		34249: 'turbonote-2',
		34378: 'p-net-local',
		34379: 'p-net-remote',
		34962: 'profinet-rt',
		34963: 'profinet-rtm',
		34964: 'profinet-cm',
		34980: 'ethercat',
		36865: 'kastenxpipe',
		37475: 'neckar',
		37654: 'unisys-eportal',
		38201: 'galaxy7-data',
		38202: 'fairview',
		38203: 'agpolicy',
		39681: 'turbonote-1',
		40000: 'safetynetp',
		40841: 'cscp',
		40842: 'csccredir',
		40843: 'csccfirewall',
		41111: 'fs-qos',
		41794: 'crestron-cip',
		41795: 'crestron-ctp',
		42508: 'candp',
		42509: 'candrp',
		42510: 'caerpc',
		43188: 'reachout',
		43189: 'ndm-agent-port',
		43190: 'ip-provision',
		43441: 'ciscocsdb',
		44321: 'pmcd',
		44322: 'pmcdproxy',
		44553: 'rbr-debug',
		44818: 'rockwell-encap',
		45054: 'invision-ag',
		45678: 'eba',
		45966: 'ssr-servermgr',
		46999: 'mediabox',
		47000: 'mbus',
		47557: 'dbbrowse',
		47624: 'directplaysrvr',
		47806: 'ap',
		47808: 'bacnet',
		48000: 'nimcontroller',
		48001: 'nimspooler',
		48002: 'nimhub',
		48003: 'nimgtw',
		48128: 'isnetserv',
		48129: 'blp5',
		48556: 'com-bardac-dw'
	}

	codes = dict([(r,l) for (l,r) in names.items()])

# try:
# 	with open('/etc/services','r') as services:
# 		for line in services:
# 			line = line.strip()
# 			print('line %s' % line)
# 			if line.startswith('#'):
# 				continue
# 			parts = line.split()
# 			if len(parts) < 2:
# 				import pdb; pdb.set_trace()
# 				continue
# 			name = parts[0]
# 			dest = parts[1].split('/')[0]
# 			if not dest.isdigit():
# 				import pdb; pdb.set_trace()
# 				continue
# 			port = int(dest)
# 			Port.codes[name] = port
# 			Port.names[port] = name
# except Exception:
# 	pass
