from .base import DeviceBase

class MPOD(DeviceBase):
    control_keys = [
        ('Logger/file/maxBackupIndex', 'u4', ()),
        ('Logger/file/maxFileSize', 'u4', ()),
        ('Logger/file/mode', 'u4', ()),
        ('autoRearm', 'u1', ()),
        ('boards/board_0/boardStatus/bitModuleIsEventActive', 'u1', ()),
        ('boards/board_0/boardStatus/bitModuleIsFineAdjustment', 'u1', ()),
        ('boards/board_0/boardStatus/bitModuleIsGood', 'u1', ()),
        ('boards/board_0/boardStatus/bitModuleIsHardwareLimitVoltageGood', 'u1', ()),
        ('boards/board_0/boardStatus/bitModuleIsInputError', 'u1', ()),
        ('boards/board_0/boardStatus/bitModuleIsKillEnable', 'u1', ()),
        ('boards/board_0/boardStatus/bitModuleIsLiveInsertion', 'u1', ()),
        ('boards/board_0/boardStatus/bitModuleIsNoRamp', 'u1', ()),
        ('boards/board_0/boardStatus/bitModuleIsNoSumError', 'u1', ()),
        ('boards/board_0/boardStatus/bitModuleIsSafetyLoopGood', 'u1', ()),
        ('boards/board_0/boardStatus/bitModuleIsSupplyGood', 'u1', ()),
        ('boards/board_0/boardStatus/bitModuleIsTemperatureGood', 'u1', ()),
        ('boards/board_0/boardStatus/bitModuleNeedService', 'u1', ()),
        ('boards/board_0/boardStatus/bitModuleReserved1', 'u1', ()),
        ('boards/board_0/boardStatus/bitModuleReserved2', 'u1', ()),
        ('boards/board_0/boardStatus/bitModuleReserved3', 'u1', ()),
        ('boards/board_0/status', 'i4', ()),
        ('crateNode/crate', 'u4', ()),
        ('crateNode/crateStatus/bitBusReset', 'u1', ()),
        ('crateNode/crateStatus/bitFanTrayFailure', 'u1', ()),
        ('crateNode/crateStatus/bitInputFailure', 'u1', ()),
        ('crateNode/crateStatus/bitLocalControlOnly', 'u1', ()),
        ('crateNode/crateStatus/bitMainInError', 'u1', ()),
        ('crateNode/crateStatus/bitMainInhibit', 'u1', ()),
        ('crateNode/crateStatus/bitMainOn', 'u1', ()),
        ('crateNode/crateStatus/bitOutputFailure', 'u1', ()),
        ('crateNode/crateStatus/bitPlugAndPlayIncompatible', 'u1', ()),
        ('crateNode/crateStatus/bitSensorFailure', 'u1', ()),
        ('crateNode/crateStatus/bitSupplyDerating', 'u1', ()),
        ('crateNode/crateStatus/bitSupplyDerating2', 'u1', ()),
        ('crateNode/crateStatus/bitSupplyFailure', 'u1', ()),
        ('crateNode/crateStatus/bitSupplyFailure2', 'u1', ()),
        ('crateNode/crateStatus/bitVmeSysfail', 'u1', ()),
        ('crateNode/expandChannelStatus', 'u1', ()),
        ('crateNode/fanNominalSpeed', 'i4', ()),
        ('crateNode/groupsSwitchIseg', 'i4', ()),
        ('crateNode/indexes', 'u4', ()),
        ('crateNode/output', 'u4', ()),
        ('crateNode/outputNumber', 'i4', ()),
        ('crateNode/pollPeriod', 'i4', ()),
        ('crateNode/psOperatingTime', 'i4', ()),
        ('crateNode/secureOperation', 'u1', ()),
        ('crateNode/settlePeriod', 'i4', ()),
        ('crateNode/snmpPort', 'i4', ()),
        ('crateNode/snmpThreshold', 'i4', ()),
        ('crateNode/sysHardwareReset', 'i4', ()),
        ('crateNode/sysMainSwitch', 'i4', ()),
        ('crateNode/sysStatus', 'u4', ()),
        ('crateNode/system', 'u4', ()),
    ] + sum(([
        ('channels/U%d/configMaxCurrent' % n, 'f4', ()),
        ('channels/U%d/configMaxSenseVoltage' % n, 'f4', ()),
        ('channels/U%d/configMaxTemperature' % n, 'i4', ()),
        ('channels/U%d/configMaxTerminalVoltage' % n, 'f4', ()),
        ('channels/U%d/current' % n, 'f4', ()),
        ('channels/U%d/currentFallRate' % n, 'f4', ()),
        ('channels/U%d/currentRiseRate' % n, 'f4', ()),
        ('channels/U%d/groupid' % n, 'i4', ()),
        ('channels/U%d/index' % n, 'i4', ()),
        ('channels/U%d/measurementCurrent' % n, 'f4', ()),
        ('channels/U%d/measurementSenseVoltage' % n, 'f4', ()),
        ('channels/U%d/measurementTemperature' % n, 'i4', ()),
        ('channels/U%d/measurementTerminalVoltage' % n, 'f4', ()),
        ('channels/U%d/status' % n, 'i4', ()),
        ('channels/U%d/supervisionBehavior' % n, 'i4', ()),
        ('channels/U%d/supervisionMaxCurrent' % n, 'f4', ()),
        ('channels/U%d/supervisionMaxPower' % n, 'f4', ()),
        ('channels/U%d/supervisionMaxSenseVoltage' % n, 'f4', ()),
        ('channels/U%d/supervisionMaxTemperature' % n, 'i4', ()),
        ('channels/U%d/supervisionMaxTerminalVoltage' % n, 'f4', ()),
        ('channels/U%d/supervisionMinSenseVoltage' % n, 'f4', ()),
        ('channels/U%d/switch' % n, 'i4', ()),
        ('channels/U%d/tripTimeMaxCurrent' % n, 'i4', ()),
        ('channels/U%d/voltage' % n, 'f4', ()),
        ('channels/U%d/voltageRampRate' % n, 'f4', ()),
    ] for n in range(8)), [])
