#!/usr/bin/env python
""" Feeding frenzy xml class """
import xml.dom.minidom
import xml.parsers.expat

class ffxml:
  def __init__(self):
    pass

  def gettext(self,xmlnode):
    """Get text data from node."""
    rc=''
    for subnode in xmlnode.childNodes:
      if subnode.nodeType == subnode.TEXT_NODE:
        rc = rc + subnode.data
    return rc.lstrip().rstrip()
  
  def settext(self,xmldoc,parent,name,text):
    node = xmldoc.createElement(name)
    node.appendChild(xmldoc.createTextNode(text))
    parent.appendChild(node)
 
  def get_element(self,document,name):
    """ Get a single element by tag name, all other nodes are discarded """
    nodes = document.getElementsByTagName(name)
    if (len(nodes) == 0):
      return None
    else:
      return nodes[0]
  def get_attribute(self,xmlnode,attrname,default):
    a = xmlnode.getAttribute(attrname)
    if a == '':
      return default
    return a

class ffconfigxml(ffxml):
  def __init__(self,configfile):
    ffxml.__init__(self)
    self.resolution = (800,600)
    self.hostname = None
# player = (id,"name",[keys])
    self.players = {}
    if (configfile == None):
      return

    try:
      dom = xml.dom.minidom.parse(configfile)
    except xml.parsers.expat.ExpatError,error:
      print "parsing config file failed: "  + str(error)
      return

    node  = self.get_element(dom,'resolution')
    if (node != None):
      self.resolution = (int(self.get_attribute(node,'x',800)),
                         int(self.get_attribute(node,'y',600)))

    node  = self.get_element(dom,'hostname')
    if (node != None):
       self.hostname = self.gettext(node)

    for pnode in dom.getElementsByTagName("player"):
      id = pnode.getAttribute("id")
      name = pnode.getAttribute("name")
      keys = []
      for anode in pnode.getElementsByTagName("action"):
        key = self.get_attribute(anode,'key',None)
        action = self.get_attribute(anode,'name',None)
        if key != None and action != None:
          keys.append((action,key))
      self.players[int(id)] = [name,keys]


  def toxml(self):
    dom = xml.dom.minidom.Document() 
    dom.appendChild(dom.createElement("ffrenzyconfig"))
#hostname
    if self.hostname != None:
      self.settext(dom,dom.firstChild,"hostname",self.hostname)
#resolution
    node = dom.createElement('resolution')
    node.setAttribute('x',str(self.resolution[0]))
    node.setAttribute('y',str(self.resolution[1]))
    dom.firstChild.appendChild(node)
#players
    for x,y in self.players.items():
      self.__createplayer(dom,dom.firstChild,str(x),y)

    return dom.toprettyxml()

 
  def get_playerids(self):
    return self.players.keys()

  def get_playerkeys(self,id,action):
    return filter((lambda x: x[0] == action),self.players[id][1]);

  def get_playername(self,id):
    return self.players[id][0]

  def set_playername(self,id,name):
    self.players[id][0] = name

  def add_player(self,id,name):
    self.players[id] = [name,[]]

  def del_player(self,id):
    del(self.players[id])

  def add_playerkey(self,id,keyt):
    if (type(keyt) != tuple and len(keyt) != 2):
      print "Invalid key tuple passed " + str(keyt)
      raise ValueError
    else:
      self.players[id][1].append(keyt)

  def del_playerkey(self,id,keyt):
    self.players[id][1].remove(keyt)

  def __createplayer(self,xmldoc,parent,id,player):
    node = xmldoc.createElement("player")
    node.setAttribute('id',id)
    node.setAttribute('name',player[0]);
    for x in player[1]:
      self.__createaction(xmldoc,node,x)
    parent.appendChild(node)

  def __createaction(self,xmldoc,parent,action):
    node = xmldoc.createElement("action")
    node.setAttribute('name',str(action[0]))
    node.setAttribute('key',str(action[1]))
    parent.appendChild(node)
