<?php
/**
 * Copyright (C) 2004 Aldo Boccacci
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the license, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * Visualizzatore delle statistiche di download
 *
 * Autore: Aldo Boccacci
 * E-Mail: doc4it(AT)altervista.org
 * Sito web: doc4it.altervista.org
 * data ultima modifica: 27/01/2006
 * versione: 0.7
 */

/**
 * Il file che contiene le statistiche di download
 */
$topdownloadsfile = "misc/fdplus/fd_top_download.php";



//-------------------
//FINE CONFIGURAZIONE
//-------------------
include_once("download/fd+.php");

global $lang,$newfiletime,$archivedir,$icon_style;
if (!isset($lang)) $lang="it";
//impostazione lingua
if ($lang=="en" or $lang=="es"){
    include_once ("languages/fd+lang/fd+en.php");
    include_once ("languages/$lang.php");
}
else if ($lang=="it"){
    include_once ("languages/fd+lang/fd+it.php");
    include_once ("languages/it.php");
}
else if ($lang=="de"){
    include_once ("languages/fd+lang/fd+de.php");
    include_once ("languages/de.php");
}
else if ($lang=="pt"){
    include_once ("languages/fd+lang/fd+pt.php");
    include_once ("languages/pt.php");
}
else {
    include_once ("languages/fd+lang/fd+en.php");
    include_once ("languages/$lang.php");
}

if(file_exists($topdownloadsfile)) {
	view($topdownloadsfile,$newfiletime,$archivedir,$icon_style);
} else return;


function view($topdownloadsfile,$newfiletime,$archivedir,$icon_style){
	echo "<div align=\"center\"><h2>Statistiche di Download</h2></div><br>";
	$statfile = fopen($topdownloadsfile,"r");
	$statstring = fread($statfile,filesize($topdownloadsfile));
	fclose($statfile);

	$statstring = get_xml_element("fd:topdownloads",$statstring);

	$files = get_xml_array("fd:file",$statstring);

	$archivedfiles = array();

	foreach ($files as $file){
		$filepath = get_xml_element("fd:path",$file);

		//verifico che il file esista
		if (!file_exists($filepath)) continue;

		$lastdir = strrchr(dirname($filepath),"/");
		if (eregi($archivedir,$lastdir)){
			$archivedfiles[] = $filepath;
			continue;
		}
		if (!file_exists($filepath)) continue;
// 		echo "$filepath<br><br>",
		show_file($filepath,$archivedir,$newfiletime,$icon_style);

	}

	echo "<div align=\"center\"><h2>File Archiviati</h2></div><br>";
// 	print_r($archivedfiles);
	if (count($archivedfiles)!=0){
		foreach ($archivedfiles as $archivedfile){
		show_file($archivedfile,$archivedir,$newfiletime,$icon_style);
// 			echo $archivedfile."<br>";
		}

	}


}


/**
 * Restituisce true se l'utente  di livello 10
 * (e dunque possiede i privilegi di amministrazione)
 */
/*function fdview_is_admin(){
include_once("shared.php");
if (!isset($_COOKIE['myforum'])) return false;

if ((getlevel($_COOKIE['myforum'],"home"))=="10" and versecid($_COOKIE['myforum'])) {
	return true;
}

else return false;

}*/

/**
 * Controlla l'esistenza del file $topdownloadsfile. Se non lo trova lo crea.
 * @param string il percorso del file
 * @author Aldo Boccacci
 */
function fdview_check_file($topdownloadsfile){
	if (!is_dir(dirname($topdownloadsfile))) mkdir(dirname($topdownloadsfile),0777);
	if (!file_exists($topdownloadsfile)){
		$tmpfile = fopen($topdownloadsfile,"w");
		fwrite($tmpfile,"<?xml version='1.0'?>\n<fd:topdownloads>\n</fd:topdownloads>");
		fclose($tmpfile);
	}
}


/**
 * Crea la tabella per mostrare il file
 * @param string $filepath il percorso del file da mostrare
 * @param string il set di icone da mostrare
 * @author Aldo Boccacci
 * @since 0.3
 */
function show_file($filepath,$archivedir,$newfiletime,$icon_style){
	$description  = load_description($filepath);
	if ($description['hide']=="true" and !is_admin()) return;
	//controllo se il livello dell'utente  adeguato a quello del file
		if ($description['level']!="-1"){
			if (isset($_COOKIE['myforum']) and versecid($_COOKIE['myforum'])){
				if ($description['level']>getLevel($_COOKIE['myforum'],"home")){

				return;
				}
			}
			else {
				return;
			}

		}
	
	//controllo se il livello dell'utente  adeguato a quello della sezione che ospita il file
	$mod="";
	$mod = eregi_replace("^.*sections/","",dirname($filepath));
	if (getlevel($_COOKIE['myforum'],"home")<getsectlevel($mod)) return;
	
	//MOSTRO IL FILE
// 	openTableTitle();
	echo "<table width=\"100%\" style=\"border:1px solid #000000;\">";

	//intestazione con il nome del file
	echo "	<thead><tr><th colspan=\"4\">";
	$path = pathinfo($filepath);
	echo getIcon($path['extension'],$icon_style);

	$mod = eregi_replace("sections/","",dirname($filepath));


	echo "<a href=\"index.php?mod=".rawurlencodepath($mod)."#".rawurlencode(basename($filepath))."\"";
	if ($description['hide']=="true") echo " style=\"color : #ff0000; text-decoration : line-through;\"";
	echo "title=\""._FDDOWNLOADFILE.basename($filepath)."\">".basename($filepath)."</a>";
	if (time()-filectime(get_xml_element("fd:path",$filepath))<($newfiletime*3600)){
		//controllo se ci troviamo in una dir di archivio
		$lastdir = strrchr(dirname($filepath),"/");
		if (!eregi($archivedir,$lastdir)){
			if (file_exists("images/mime/new.gif"))
			echo "&nbsp;<img src=\"images/mime/new.gif\" alt=\"new file!\">";
		}
	}
	echo "</th></tr></thead>";

	$hits = 0;
	if (trim($description['hits'])=="") $hits=0;
	else $hits =$description['hits'];

	//corpo
	echo "<tr><td width=\"8%\"><b>"._FDSECT.":</b></td><td><a href=\"index.php?mod=".rawurlencode(eregi_replace("^sections/","",dirname($filepath)))."\" title=\""._GOTOSECTION.": ".eregi_replace("^sections/","",dirname($filepath))."\">".eregi_replace("^sections/","",dirname($filepath))."</a></td>
	<td width=\"10%\"><b>"._FDHITS.":</b></td><td width=\"8%\"><b>$hits</b></td>
	</tr>";
	echo "<tr><td><b>"._FDDATE.":</b></td><td>".date(_FDDATEFORMAT,filectime($filepath))."</td>";
	echo "<td><b>"._FDSIZE.":</b></td><td>".round((filesize($filepath)/1024))."&nbsp;kb</td></tr>";
	echo "</table><br>";
// 	closeTableTitle();


}

?>