/*
 * Decompiled with CFR 0.152.
 */
import bemused.BemusedProtocol;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import protocol.MusicPlayer;
import protocol.ProtocolStatus;
import protocol.StatusUpdateListener;

public class Controller
implements StatusUpdateListener {
    Main owner;
    SearchForm searchForm;
    ControlForm controlForm;
    BrowseForm browseForm;
    TextForm textForm;
    MoreActionsForm moreActionsForm;
    NumericForm numericForm;
    Settings settings;
    StreamConnection currentConnection;
    BemusedProtocol protocol;

    public Controller(Main main) {
        this.owner = main;
        this.protocol = new BemusedProtocol(Display.getDisplay((MIDlet)main));
        this.protocol.registerStatusUpdateListener(this);
        this.settings = new Settings();
        this.searchForm = new SearchForm(this);
        this.controlForm = new ControlForm(this);
        this.browseForm = new BrowseForm(this);
        this.textForm = new TextForm(this);
        this.moreActionsForm = new MoreActionsForm(this);
        this.numericForm = new NumericForm(this);
    }

    Settings getSettings() {
        return this.settings;
    }

    public void start() {
        Display.getDisplay((MIDlet)this.owner).setCurrent((Displayable)this.searchForm);
    }

    public void showController() {
        Display.getDisplay((MIDlet)this.owner).setCurrent((Displayable)this.controlForm);
    }

    public void showTextForm() {
        this.textForm.setString("");
        Display.getDisplay((MIDlet)this.owner).setCurrent((Displayable)this.textForm);
    }

    public void showMoreActions() {
        Display.getDisplay((MIDlet)this.owner).setCurrent((Displayable)this.moreActionsForm);
    }

    public void showNumericForm() {
        Display.getDisplay((MIDlet)this.owner).setCurrent((Displayable)this.numericForm);
    }

    public void showBrowseForm() {
        this.showBrowser(true);
    }

    public void showBrowser(boolean bl) {
        if (bl) {
            this.protocol.fileBrowser.requestMenu();
        }
        Display.getDisplay((MIDlet)this.owner).setCurrent((Displayable)this.browseForm);
    }

    public void exit() {
        this.owner.destroyApp(false);
        this.owner.notifyDestroyed();
    }

    void destroy() {
        this.disconnect();
        this.settings.save();
        if (this.protocol != null) {
            this.protocol = null;
        }
    }

    void connectTo(String string, String string2) {
        this.settings.setLastUsedDevice(string, string2);
        this.settings.save();
        this.protocol.setConnectionURL(string);
    }

    void disconnect() {
        this.protocol.closeConnection();
    }

    public void bemusedStatusChanged(ProtocolStatus protocolStatus) {
        Display display = Display.getDisplay((MIDlet)this.owner);
        if (protocolStatus.connected && display.getCurrent() == this.searchForm) {
            display.setCurrent((Displayable)this.controlForm);
        } else if (!protocolStatus.connected && display.getCurrent() != this.searchForm) {
            display.setCurrent((Displayable)this.searchForm);
        }
        this.browseForm.updateDirList(this.protocol.fileBrowser.dirs(), this.protocol.fileBrowser.dirChanged());
        this.controlForm.setStatus(this.protocol.itemdata);
        this.numericForm.setStatus(this.protocol.itemdata);
        this.moreActionsForm.setStatus(this.protocol.itemdata);
    }

    MusicPlayer getPlayer() {
        return this.protocol;
    }
}

