/*
 * $Id: rk_read.c,v 1.2 2001/06/14 18:16:10 ura Exp $
 */

/*
 * FreeWnn is a network-extensible Kana-to-Kanji conversion system.
 * This file is part of FreeWnn.
 * 
 * Copyright Kyoto University Research Institute for Mathematical Sciences
 *                 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992, 1999
 * Copyright ASTEC, Inc. 1987, 1988, 1989, 1990, 1991, 1992
 *
 * Author: OMRON SOFTWARE Co., Ltd. <freewnn@rd.kyoto.omronsoft.co.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Emacs; see the file COPYING.  If not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Commentary:
 *
 * Change log:
 *
 * Last modified date: 8,Feb.1999
 *
 * Code:
 *
 */
/***********************************************************************
                        rk_read.c
                                                87.12. 9   

        rk_main.c ʡѴбɽɤ߹ߤô
***********************************************************************/
/*      Version 3.1     88/06/15        H.HASHIMOTO
 */
#ifndef OMRON_LIB
#include "rk_header.h"
#include "rk_extvars.h"
#ifdef  MULTI
#include "rk_multi.h"
#endif /*MULTI*/
#include <sys/types.h>
#include <sys/stat.h>
#endif
#include "rext.h"
/* 88/06/13 V3.1 */
#ifndef MULTI
static letter *ltrbufbgn;       /* letterΥХåեƬؤ */
#endif /*!MULTI */
static letter *ltrbufptr;
static letter *term;
static letter *dummy;


static dat *datptr;             /* V3.1 */
static letter *memptr;          /* V3.1 */

static letter *hen_iki;         /* V3.1 */

/* 顼åΤΤ */
#ifndef MULTI
static char *tcurdir;           /* бɽΥѥ */
static char *tcurfnm;           /* бɽΥե̾ */
static char *tcurread;          /* бɽθ߹bufؤΥݥ */
#endif /*!MULTI */

/* 88/06/02 V3.1 */
#define bit3(x, y, z) ((x) | ((y) << 1) | ((z) << 2))

/* Ȥ߹ߴؿݻstruct */
struct funstr
{
  char *fnname;                 /* ؿ̾ */
  char appear;                  /* ϥϥХåեĤ
                                   ˽񤱤뤫ɤΥե饰ӥå */
  char argnum;                  /* θĿ */
  char fntype;                  /* ̤Υ */
};

/* ؿɲäˤϤ mchevl(), evlis() 򤤤 */
static struct funstr func[] = {
/*                      ο-1Ĥ̤ѡ
          ̾                и       ס0:ʸؿ 1:ʸؿ
                                         2:üؿ 3:ǽ 4: */
  "defvar", bit3 (1, 0, 0), -1, 4,      /*  0 */
  "include", bit3 (1, 0, 0), -1, 4,
  "toupper", bit3 (1, 1, 1), 1, 0,
  "tolower", bit3 (1, 1, 1), 1, 0,
/*      "error",        bit3(0,1,0),  0, 3,*/
  "off", bit3 (0, 1, 0), -1, 2,
  "on", bit3 (0, 1, 0), -1, 2,  /*  5 */
  "switch", bit3 (0, 1, 0), -1, 2,
  "toupdown", bit3 (1, 1, 1), 1, 0,
  "tozenalpha", bit3 (1, 1, 1), 1, 0,
  "tohira", bit3 (1, 1, 1), 1, 0,
  "tokata", bit3 (1, 1, 1), 1, 0,       /* 10 */
  "tohankata", bit3 (1, 1, 1), 1, 1,
  "tozenhira", bit3 (1, 1, 1), 1, 0,
  "tozenkata", bit3 (1, 1, 1), 1, 0,
  "+", bit3 (1, 1, 1), 2, 0,
  "-", bit3 (1, 1, 1), 2, 0,    /* 15 */
  "*", bit3 (1, 1, 1), 2, 0,
  "/", bit3 (1, 1, 1), 2, 0,
  "%", bit3 (1, 1, 1), 2, 0,
  "last=", bit3 (1, 0, 0), 1, 2,        /* ľΥޥå==? */
  "if", bit3 (1, 0, 0), -1, 2,  /* 20 */
  "unless", bit3 (1, 0, 0), -1, 2,
  "restart", bit3 (0, 1, 0), 0, 3,
  "delchr", bit3 (1, 1, 1), 0, 0,       /* delchr֤ޥ */
  "alloff", bit3 (0, 1, 0), 0, 2,       /* ⡼ɤ򤤤äڤOFF */
  "allon", bit3 (0, 1, 0), 0, 2,        /* 25 */
  "bitand", bit3 (1, 1, 1), 2, 0,
  "bitor", bit3 (1, 1, 1), 2, 0,
  "bitnot", bit3 (1, 1, 1), 1, 0,
  "!", bit3 (0, 1, 0), 0, 2,    /* ΢ХåեŪꥢ */
  "atEOF", bit3 (1, 0, 0), 0, 2,        /* 30 */
  "todigit", bit3 (1, 1, 1), 2, 1,
  "dakuadd", bit3 (1, 1, 1), 1, 1,      /* ղ */
  "handakuadd", bit3 (1, 1, 1), 1, 1,   /* Ⱦղ */
  "value", bit3 (1, 1, 1), 1, 0,
  "error", bit3 (0, 1, 0), 0, 3,        /* 35 */
  "defconst", bit3 (1, 0, 0), -1, 4,
  "setmode", bit3 (0, 1, 0), -1, 2,
  "mode+", bit3 (0, 1, 0), -1, 2,
  "mode-", bit3 (0, 1, 0), -1, 2,
  "mode=", bit3 (1, 0, 0), -1, 2,       /* 40 */
  "mode!=", bit3 (1, 0, 0), -1, 2,
  "mode<", bit3 (1, 0, 0), -1, 2,
  "mode>", bit3 (1, 0, 0), -1, 2,
  "send", bit3 (0, 1, 0), 0, 1, /*  */
  NULL
};
        /* last=unless ϥɤΰ֤ˤ֤ʸؿʤΤ
           ܽɽˤ񤱤ʤ */
        /* +,-,*,/,bitand,bitor,bitnot 3Хʬα黻Ԥ */
        /* atEOF եǤưꤹ뤿ΤΡâ
           ưԴ */

static void readhyo (), rangeset (), vchk (), singleqscan (), doubleqscan (), listscan (), ERHOPN (), ERRLIN (), ERRHYO ();
static int evalandcpy (), eval1cpy (), evlis (), hensrc_tourk (), serfun (), termsscan (), atermscan (), partscan (), blankpass (), modsrcL ();
static letter onescan (), *rangekettei ();

extern letter *ltrgrow (), letterpick (), *ltr1cut ();
extern char *chrcat (), *strend ();

#define IHENSU (1 << 24)        /* ɽξ̣ХȤǡѿɽ */
#define IKANSU (2 << 24)        /*                         ؿɽ */
#define IMODNM (3 << 24)        /*                         ⡼̾ɽ */

#define ENDOF_NestFileArea ((FILE *)~0)

int tmp[64];

/* 88/06/01/ V3.1 */
 /** ʬΥݥ󥿤ʤ롣 */
static char *                   /* V3.1 */
readln_ustrtoltr (buf, ltrbuf)
     char *buf;
     fast letter *ltrbuf;
{
  fast int l;

  if (*buf == '\0')
    return (NULL);
  while ((l = letterpick (&buf), is_space (l)))
    ;
  if ((*ltrbuf++ = l) == EOLTTR)
    return (buf);
  while ((*ltrbuf++ = letterpick (&buf)) != EOLTTR);
  return (cur_rk_table->tcurread = buf);
}

/* 88/06/01/ V3.1 */
/** бɽɤ߹ߡбɽɤߤʤԿå롣бɽˤ
    ʸʳΥȥʸǤϺʤΤȤäƤ
    å롣*/
static int                      /* V3.1 */
readbuf (fp, ptr)
     fast FILE *fp;
     fast hyobuftable *ptr;
{
  fast char c, sv = '\0';
  fast int cnt = 0;             /* бɽιԿ */
  fast char *s = ptr->org;
  char *p;

  cur_rk_table->tcurread = ptr->org;
  while (fgets (ptr->tmp, ptr->size, fp))
    {
      p = ptr->tmp;
      sv = '\0';
      while (isspace (*p))
        p++;
      if (*p == ';')
        continue;
      while (c = *p)
        {
          if (is_cntrl (c) && !isspace (c))
            {
              fclose (fp);
              sprintf (cur_rk_table->tcurread, "\\%03o", c);
              ERRLIN (21);
            }
          else if (c == '\n')
            {
              p++;
              if (sv == '\0')
                continue;
              c = '\0';         /* '\n' --> '\0' */
              cnt++;
              cur_rk_table->tcurread = s + 1;
              *s++ = sv = c;
            }
          else
            {
              *s++ = sv = c;
              p++;
            }
        }
    }
  if (*(s - 1) != '\0')
    {
      cnt++;
      *s++ = '\0';              /* ƥȽüβԵǡΥեФͭ */
    }
  *s = '\0';
  return (cnt);
}

 /** ɽɤ߹ */
/* 88/06/03/ V3.1 */
#ifdef OMRON_LIB
static
#endif
  void
readdata (filename)
     char *filename;            /* ⡼ɽ̾ϤΥѥ̾äƤ */
{
  fast int i;                   /* V3.1 */
  fast int n;                   /* V3.1 */

  /* 88/06/09 V3.1 */
  malloc_for_modetable_struct (&(cur_rk_table->rk_path), RK_PATH_MAX_DEF, RK_PATH_MEM_DEF);
  malloc_for_modetable_struct (&(cur_rk_table->rk_taiouhyo), RK_TAIOUHYO_MAX_DEF, RK_TAIOUHYO_MEM_DEF);
  malloc_for_modetable_struct (&(cur_rk_table->rk_defmode), RK_DEFMODE_MAX_DEF, RK_DEFMODE_MEM_DEF);
  malloc_for_modetable_struct (&(cur_rk_table->rk_dspmode), RK_DSPMODE_MAX_DEF, RK_DSPMODE_MEM_DEF);
  malloc_for_modesw (&(cur_rk_table->rk_modesw), RK_DEFMODE_MAX_DEF);

  /* ⡼ɽɤ߹ */
  if ((n = readmode (filename)) != 0)
    {
                 /** ΰγ */
      malloc_for_hyo (&(cur_rk_table->rk_hyo), n);
      malloc_for_usehyo (&(cur_rk_table->rk_usehyo), n);
      malloc_for_hensuudef (&(cur_rk_table->rk_hensuudef), RK_HENSUUDEF_MAX_DEF);

      malloc_for_hensuu (&(cur_rk_table->rk_hensuu), RK_HENSUU_MAX_DEF, RK_HENSUU_MEM_DEF);

      malloc_for_hyobuf (&(cur_rk_table->rk_hyobuf), RK_HYO_SIZE_DEF);
      malloc_for_heniki (&(cur_rk_table->rk_heniki), (RK_HYO_SIZE_DEF / 2) + 1);

      /* 줾бɽɤ߹ */
      for (i = 0; i < n; i++)
        {
          readhyo (i);
        }
      for (i = 0; i < n; i++)
        {
          cur_rk_table->rk_hyo.point[i].hensudef = &cur_rk_table->rk_hensuudef.point[tmp[i]];
        }

                 /** ΰβ */
      free_for_heniki (&(cur_rk_table->rk_heniki));
      free_for_hyobuf (&(cur_rk_table->rk_hyobuf));

      free_for_hensuu (&(cur_rk_table->rk_hensuu));
    }

  /* 88/06/07 V3.1 */
  free_for_modetable_struct (&(cur_rk_table->rk_defmode));
  free_for_modetable_struct (&(cur_rk_table->rk_taiouhyo));
  free_for_modetable_struct (&(cur_rk_table->rk_path));

  /* 88/06/09 V3.1 */
  /*
     if ((n = cur_rk_table->rk_hensuudef.count) != 0)
     malloc_for_henmatch(&(cur_rk_table->rk_henmatch), n);

     choosehyo();
   */
}

/* 88/06/02 V3.1 */
 /**    ꤵ줿ʥѥ򸫤ɬפΤʤ˥ե̾ФƤ0
        ֤ߤΤȤ / ./ ../ Τɤ줫ǻϤޤΤȤƤ뤬ʺԤ
        ǡˡŬѤƤ褤strchr(s,'/')!=NULL Ȥɤ */
static int
fixednamep (s)
     char *s;
{
  return (!strncmp ("/", s, 1) || !strncmp ("./", s, 2) || !strncmp ("../", s, 3));
}

 /**  nameͿ줿̾Ѵбɽ򥪡ץ󤹤롣̾ȸʤʤ
      ̾fixednamep()ȡˤФƤϡѥ򸫤롣*/
/* 88/06/09 V3.1 */
static FILE *                   /* V3.1 */
trytoopen (n, size)
     int n;                     /* бɽֹ */
     int *size;
{
  fast char *name;              /* V3.1 */
/*fast  char    **src; *//* V3.1 */
  fast int i;                   /* V3.1 */
/*fast  int     cnt; *//* V3.1 */

  char taio_fnm[REALFN];
  struct stat statbuf;          /* V3.1 */
  FILE *fp;                     /* V3.1 */


  /* 88/06/10 V3.1 */
  if (fixednamep (cur_rk_table->tcurfnm = name = cur_rk_table->rk_taiouhyo.point[n]))
    {
      /* 88/06/09 V3.1 */
      cur_rk_table->tcurdir = "";       /* 顼 *//* V3.1 */
      if (stat (name, &statbuf) != 0)
        ERHOPN (1);
      if ((fp = fopen (name, "r")) == NULL)
        ERHOPN (2);
      /*
         if (cur_rk->flags & RK_VERBOS) {
         fprintf(stderr, "romkan: using Taio-hyo %s ...\r\n",
         name);
         }
       */
      *size = statbuf.st_size;
      return (fp);
    }
  else
    {
      /* 88/06/09 V3.1 */
      for (i = 0; i < cur_rk_table->rk_path.count; i++)
        {
          strcpy (taio_fnm, (cur_rk_table->tcurdir = cur_rk_table->rk_path.point[i]));
          strcat (taio_fnm, name);

          if (stat (taio_fnm, &statbuf) != 0 || (fp = fopen (taio_fnm, "r")) == NULL)
            continue;
          /* Now Taio-hyo found */
          /*
             if (cur_rk->flags & RK_VERBOS) {
             fprintf(stderr,
             "romkan: using Taio-hyo %s ...\r\n",
             taio_fnm);
             }
           */
          *size = statbuf.st_size;
          return (fp);
        }
      /* Taio-hyo not found */
#ifdef  nodef
      if (cur_rk->flags & RK_VERBOS)
        {
          fast char *p, *q;     /* V3.1 */

          fprintf (stderr, "no %s in", name);
          for (i = 0; i < cur_rk_table->rk_path.count; i++)
            {                   /* V3.1 */
              fputc (' ', stderr);
              p = q = cur_rk_table->rk_path.point[i];   /* V3.1 */
              if (*q == KUGIRI && *(q + 1) == '\0')
                q++;
              else
                q = strend (q);
              for (; p < q; p++)        /* V3.1 */
                fputc (*p, stderr);
            }
          fprintf (stderr, ".\n");
        }
#endif
      cur_rk_table->tcurdir = "";       /* V3.1 */
      ERHOPN (1);               /* V3.1 */
    }
  return (NULL);
}

#ifdef notdef
/* 88/06/02 V3.1 */
/******************************************************************************/
#ifndef OMRON
 /**    linbufäƤunsigned charletterˤltrbuf롣
        ɥޡEOLTTRˤʤ롣flg0λϡƬζʸФ*/
static                          /* V3.1 */
  void
ustrtoltr (linbuf, ltrbuf, flg)
     uns_chr *linbuf;
     int flg;
     fast letter *ltrbuf;       /* V3.1 */
{
  fast letter l;                /* V3.1 */

  if (flg)
    {
      while (l = letterpick (&linbuf), is_eolsp (l))
        {
          if (l == EOLTTR)
            {
              *ltrbuf = EOLTTR;
              return;
            }
        }
      *ltrbuf++ = l;
    }
  while ((*ltrbuf++ = letterpick (&linbuf)) != EOLTTR);
}
#endif
/******************************************************************************/
#endif

 /** letterʸ˥С */
void
ltr1tostr (l, sptr)
     fast char **sptr;
     fast letter l;
{
  fast int i;

  for (i = 0; i < 3 && 0 == (l & (0xff000000)); i++)
    l <<= 8;
  for (; i < 4; i++)
    {
      *(*sptr)++ = (char) (l >> 24);
      l <<= 8;
    }
}

 /** ѿΡָ߹ԴХե饰פƥꥢ */
static                          /* V3.1 */
  void
hen_useflgclr (hensu, n)
     fast hensuset *hensu;      /* V3.1 */
     fast int n;                /* V3.1 */
{
  for (; n > 0; n--)
    (hensu++)->curlinflg = 0;   /* ߹Ԥ̤ */
}

 /** бɽɤ߹ */
static                          /* V3.1 */
  void
readhyo (n)
     fast int n;                /* V3.1 */
{
  fast int i, j;                /* V3.1 */
  fast letter *lp;              /* V3.1 */
  fast int m;                   /* V3.1 */
  fast hensuset *hensuptr;      /* V3.1 */
  letter ltrbuf[LINSIZ];        /* V3.1 */
  letter termbuf[TRMSIZ], dummybuf[TRMSIZ];     /* V3.1 */
  int hyosw, rsltyp[3];

  FILE *fp;                     /* V3.1 */
  int size, lines;              /* V3.1 */
  fast RomkanTable *c_r_t = cur_rk_table;

  /* 88/06/11 V3.1 */
  /* бɽΥץ */
  fp = trytoopen (n, &size);
  check_and_realloc_for_hyobuf (&(c_r_t->rk_hyobuf), size);
  c_r_t->rk_hyobuf.next = c_r_t->rk_hyobuf.org;
  lines = readbuf (fp, &c_r_t->rk_hyobuf);
  fclose (fp);

  /* ѴǡΰγȽڤӡбɽμ̤ */
  malloc_for_hyo_area (&(c_r_t->rk_hyo), n, lines, size, &datptr, &memptr);
  hyosw = c_r_t->rk_hyo.point[n].hyoshu = filnamchk (c_r_t->rk_taiouhyo.point[n]);
  /*
     c_r_t->rk_hyo.point[n].hensudef = &c_r_t->rk_hensuudef.point[c_r_t->rk_hensuudef.count];
   */
  tmp[n] = c_r_t->rk_hensuudef.count;

  check_and_realloc_for_heniki (&(c_r_t->rk_heniki), (size / 2) + 1);
  *(hen_iki = c_r_t->rk_heniki.next = c_r_t->rk_heniki.org) = EOLTTR;

  /* 88/06/10 V3.1 */
  c_r_t->rk_hensuu.count = 0;
  *(c_r_t->rk_hensuu.next = c_r_t->rk_hensuu.org) = EOLTTR;

  c_r_t->ltrbufbgn = ltrbuf;
  dummy = dummybuf;

  /* 88/06/11/ V3.1 */
  c_r_t->rk_hyobuf.next = c_r_t->rk_hyobuf.org;
  while (c_r_t->rk_hyobuf.next = readln_ustrtoltr (c_r_t->rk_hyobuf.next, (ltrbufptr = ltrbuf)))
    {
      datptr->code[0] = NULL;   /* V3.1 */
      /*hen_useflgclr(c_r_t->rk_hensuu.org, c_r_t->rk_hensuu.count);   V3.1 */
      hen_useflgclr (c_r_t->rk_hensuu.point, c_r_t->rk_hensuu.count);   /* V3.1 */

      for (m = 0; termsscan (&ltrbufptr, term = termbuf, 1); m++)
        {
          /* mϡܤιܤ򸫤Ƥ뤫ɽ */
          if (*term == ';')
            break;              /*  */
          if (m == 3)
            ERRLIN (15);
          if (m != 0 && rsltyp[0] == 4)
            ERRLIN (12);

          datptr->code[m] = memptr;
          if ((rsltyp[m] = evalandcpy (&term, m)) == 4)
            {
              if (m)
                ERRLIN (14);
              /* Ϻǽιܤˤʤ
                 funstr[]appearե饰ǤåƤ뤬
                 Τ˰ˤåƤ */
            }
          else
            {
              /* λˤɽؤΥݥ󥿤Ͽʤʤ */
              totail (memptr);
              memptr++;
            }
        }

      if (m != 0 && rsltyp[0] != 4)
        {
          static letter nil[1] = { EOLTTR };    /* V3.1 */
          for ( /* m=? */ ; m < 3; m++)
            {
              datptr->code[m] = nil;
              rsltyp[m] = -1;   /* doesn't exist */
            }
          datptr++;

          /* rsltyp: 0=ʸ 1=ʸϢ 2=ǡϢ 3=ǽ 4= -1=¸ߤ */
          switch (hyosw)
            {
              /* ϡɽƤ¤롣򸡺 */
            case 1:
              if (!(rsltyp[0] == 0 && rsltyp[1] == 0 && rsltyp[2] == -1))
                ERRLIN (17);
              break;
            case 2:
              if (rsltyp[1] == 3 && rsltyp[2] != -1)
                ERRLIN (19);
              break;
            case 3:
              if (!(rsltyp[0] == 0 && (rsltyp[1] == 0 || rsltyp[1] == 1) && rsltyp[2] == -1))
                ERRLIN (18);
              break;
            default:
              BUGreport (10);
            }

        }
    }

  (datptr++)->code[0] = NULL;

  /* ѿϿǤޤȤƤ */
  for (lp = c_r_t->rk_heniki.org; lp < hen_iki;)
    *memptr++ = *lp++;

  for (i = 0, hensuptr = c_r_t->rk_hensuu.point; i < c_r_t->rk_hensuu.count; i++, hensuptr++)
    {
      if (hensuptr->regdflg == 0)
        ERRHYO (1);             /* V3.1 */

      check_and_realloc_for_hensuudef (&(c_r_t->rk_hensuudef), j = c_r_t->rk_hensuudef.count, RK_HENSUUDEF_MAX_LOT);
      c_r_t->rk_hensuudef.point[j] = memptr - (lp - hensuptr->range);
    }
}

 /**    ѴбɽιܰĤ򡢲ᤷơΥǡꥢ˥ԡ롣
        ֤ͤϡᤷܤʸʤ0ʳʸϢʤ1ʳ
        ǥǡϢʤ2ǽʤ3ʤ4ʳϥ顼*/
static                          /* V3.1 */
  int
evalandcpy (socp, m)
     fast letter **socp;        /* ܤؤΥݥ󥿡ʤؤΥݥ󥿡 *//* V3.1 */
     int m;                     /* бɽβܤιܤ򸫤Ƥ뤫ɽϥ
                                   ƤȤ0ϥʤ1ХåեĤʤ2 */
{
#define TYPMAX  5

  char exist[TYPMAX];           /* V3.1 */
  fast char total;              /* V3.1 */
  /* existϡ줾쥿04ινиΥե饰eval1cpy()ȡˡ
     totalΤȤƤνиե饰ɤ⡢1=̤ 2= ¾
     ϲ2ӥå0 */
  fast int type;                /* V3.1 */

#define TIME_0(flag) ((flag) == 1)
#define TIME_1(flag) ((flag) == 2)
#define TIME_n(flag) (((flag) & 3) == 0)

  total = 1;
  for (type = 0; type < TYPMAX; type++)
    exist[type] = 1;

  while (!is_eolsp (**socp))
    {
      if (!(0 <= (type = eval1cpy (socp, m, 0)) && type < TYPMAX))
        BUGreport (3);
      exist[type] <<= 1;
      total <<= 1;
    }

  if (TIME_0 (total))
    BUGreport (13);             /* ܤʤevalandcpyϼ¹ԤʤȦ */
  if (!TIME_0 (exist[3]) || !TIME_0 (exist[4]))
    {
      if (TIME_n (total))
        ERRLIN (9);
      return (type);            /* 34typeͤݻƤȦ */
    }
  if (TIME_1 (total) && TIME_1 (exist[0]))
    return (0);
  return (!TIME_0 (exist[2]) ? 2 : 1);
}

 /**    бɽιܤιĤᤷΥǡꥢ˥ԡ
        Υסʸ=0 ʸ=1 üؿ=2 ǽ=3 =4ˤ
        ֤flg0ʤ顢ƵŪ˸ƤФ줿Ȥ̣ξ硢
        ߹Ԥ̤Фѿ򸡽Ф饨顼ޤm0ΤȤϥ
        ʳν򸫤Ƥˤ⡢߹Ԥ̤Фѿ򸡽Ф饨顼*/
static                          /* V3.1 */
  int
eval1cpy (socp, m, flg)
     letter **socp;             /* flgʳΰΰ̣evalandcpyƱ */
     int m, flg;
{
  letter t1buf[TRMSIZ], *t1bufp;

  t1bufp = t1buf;

  *memptr = EOLTTR;
  switch (partscan (socp, t1bufp))
    {
    case 1:                     /* ñʸ */
      memptr = ltrgrow (memptr, t1bufp);
      *memptr = EOLTTR;
      return (0);
    case 2:                     /* ʸ */
      t1bufp++;
      *memptr++ = onescan (&t1bufp, dummy);
      *memptr = EOLTTR;
      return (0);
    case 3:                     /* ʸ */
      t1bufp++;
      while (*t1bufp != '"')
        {
          *memptr++ = onescan (&t1bufp, dummy);
        }
      *memptr = EOLTTR;
      return (1);
    case 0:                     /* ꥹ */
      return (evlis (m, &t1bufp, flg));
      /* evlis *memptr = EOLTTR; 򤷤Ƥ롣 */
    default:
      BUGreport (4);
     /*NOTREACHED*/}
  return (-1);
}

#define bitchk(x, n) ((x) & (1 << (n)))

#define get_ltr(lp) (*(lp)++)
#define unget_ltr(l, lp) (*--(lp) = (l))

 /** globalʥݥ󥿤ؤƤletter󤫤ʸäƤ롣*/
/* *INDENT-OFF* */
letter
get1ltr ()
/* *INDENT-ON* */
{
  return (get_ltr (lptr));
}

/* *INDENT-OFF* */
letter
unget1ltr (l)
   letter l;
/* *INDENT-ON* */

{
  return (unget_ltr (l, lptr));
}

int
int_get1ltr ()
{
  return ((int) (get1ltr ()));
}

int
int_unget1ltr (c)
     letter c;
{
  return ((int) (unget1ltr ((letter) c)));
}

 /** ȤξʤʤؿηcastǤʤΡ
    (int ()) get1ltrפȽ񤭤 */

 /**    includeե̾letterstring˼ФȤletterν
        ޤ³롣flg & 010ʤ顢'/'Ǥ⽪λ*/
/* *INDENT-OFF* */
letter
getfrom_dblq (socp, destp, flg)
     letter **socp;
     char **destp;
     int flg;
/* *INDENT-ON* */
{
  letter l;

  while (**socp != EOLTTR && !(flg & 01 && **socp == KUGIRI))
    {
      if (**socp == '\\')
        *(*destp)++ = '\\';
      l = onescan (socp, dummy);
      ltr1tostr (l, destp);
    }
  *(*destp)++ = '\0';
  return (**socp);
}

int
getfrom_lptr (sptr, flg)
     char **sptr;
     int flg;
{
  return ((int) getfrom_dblq (&lptr, sptr, flg));
}

 /**    ꥹȤᤷɽˤ롣ͤϡΥꥹȤΥפɽ
        ʸѿʸؿ:0 ʸؿ:1 üؿ:2
        ǽ:3 :4 */
static                          /* V3.1 */
  int
evlis (m, socp, flg)
     letter **socp;             /* ΰ̣eval1cpy򻲾 */
     int m, flg;
{
  fast int fnnum, hennum, i;    /* V3.1 */
  letter t1buf[TRMSIZ];

  (*socp)++;                    /* '('򥹥å */
  atermscan (socp, t1buf, 3);

  fnnum = serfun (t1buf);
  if (fnnum != -1 && !bitchk (func[fnnum].appear, m))
    ERRLIN (14);
  /* mͤˤäơƤϤʤؤνиɤƤ롣 */

  switch (fnnum)
    {                           /* defaultνʳ func[fnnum].argnumȤäƤʤ */
    case -1:                    /* ѿ */
      vchk (t1buf);
      atermscan (socp, dummy, 2);       /* ERR */
      hennum = hensrc_tourk (t1buf, ((m == 0 && !flg) ? 0 : 1));
      *memptr++ = hennum | IHENSU;
      break;

    case 0:                     /* fn No.0 defvar */
      atermscan (socp, t1buf, 3);
      if (*t1buf == '(')
        {
          letter *soc2, t1buf2[TRMSIZ], t1buf3[TRMSIZ];
          letter *common_hen;

          atermscan (socp, t1buf3, 3);

          soc2 = t1buf + 1;     /* skip '(' */

          atermscan (&soc2, t1buf2, 3);
          vchk (t1buf2);
          if (-1 != serfun (t1buf2))
            ERRLIN (11);
          hennum = hensrc_tourk (t1buf2, -1);
          common_hen = rangekettei (hennum, t1buf3);

          while (atermscan (&soc2, t1buf2, 0))
            {
              vchk (t1buf2);
              if (-1 != serfun (t1buf2))
                ERRLIN (11);
              hennum = hensrc_tourk (t1buf2, -1);
              rangeset (hennum, common_hen);
            }
        }
      else
        {
          vchk (t1buf);
          if (-1 != serfun (t1buf))
            ERRLIN (11);
          hennum = hensrc_tourk (t1buf, -1);
          /* defvarνʣ򤱤뤿 */
          atermscan (socp, t1buf, 3);
          rangekettei (hennum, t1buf);
        }
      atermscan (socp, dummy, 2);
      break;

    case 36:                    /* fn No.36 defconst */

      atermscan (socp, t1buf, 3);
      vchk (t1buf);
      if (-1 != serfun (t1buf))
        ERRLIN (11);

      hennum = hensrc_tourk (t1buf, 6);
      /* defvardefconstѿ̾ʣ򤱤뤿 */

      rangeset (hennum, hen_iki);

      blankpass (socp, 1);
      if (*(*socp)++ != '\'')
        ERRLIN (8);
      *hen_iki++ = onescan (socp, dummy);
      (*socp)++;                /*'פĤƤ뤳ȤθϺѤǤ */
      *hen_iki++ = EOLTTR;      /* needed? */
      *hen_iki = EOLTTR;

      atermscan (socp, dummy, 2);
      break;

    case 1:                     /* fn No.1 include */
      {
        char fnmtmparea[REALFN], *s, *dirnamptr;
        int dummyc = 0, err;

        blankpass (socp, 1);
        if (3 != partscan (socp, t1buf))
          ERRLIN (22);
        atermscan (socp, dummy, 2);
        /* ;ʬˤERR */

        ltr1cut (lptr = t1buf + 1);
        *(s = fnmtmparea) = '\0';
        err = readfnm (int_get1ltr, int_unget1ltr, getfrom_lptr, &s, &dummyc);

        if (err)
          {
            cur_rk_table->hcurread = s;
            switch (err)
              {
              case 1:
              case 3:
                ERRLIN (25);
              case 2:
                ERRLIN (26);
              case 4:
                ERRLIN (27);
              }
          }
        de_bcksla (fnmtmparea, fnmtmparea);

        if (*++(cur_rk_table->base) == ENDOF_NestFileArea)
          {
            (cur_rk_table->base)--;
            ERRLIN (23);
          }
        *(cur_rk_table->base) = trytoopen (fnmtmparea, &dirnamptr, &err);
        if (err)
          {
            switch (err)
              {
              case 1:
              case 3:
              case 2:
              case 4:
                (cur_rk_table->base)--;
                ERRLIN (24);
              }
          }
      }
      break;

      /* ⡼̾Ĥ˼ */
    case 4:                     /* fn No.46 off,on,switch */
    case 5:
    case 6:
    case 20:                    /* fn No.20,21 if,unless */
    case 21:
      *memptr++ = fnnum | IKANSU;
      atermscan (socp, t1buf, 3);
      *memptr++ = modsrcL (t1buf) | IMODNM;
      break;

      /* ⡼̾ʸ ĤĤ˼ */
    case 37:                    /* fn No.3743 setmodeʤ */
    case 38:
    case 39:
    case 40:
    case 41:
    case 42:
/*
                case 43:
                        {
                                int     err, n;
                                modetyp stat;

                                *memptr++ = fnnum | IKANSU;
                                atermscan(socp, t1buf, 3);
                                *memptr++ = (n = modsrcL(t1buf))| IMODNM;
                                atermscan(socp, t1buf, 3);
                                err = chkL_get_int(t1buf, &stat,
                                                         modesw[n] . moderng);
                                if(err != 0) ERRLIN(29);
                                *memptr++ = stat;
                                atermscan(socp, t1buf, 2);
                                break;
                        }
*/

      /* ̡ʰʤΤޤ */
    default:                    /* toupper,tolower */
      *memptr++ = fnnum | IKANSU;
      *memptr = EOLTTR;
      for (i = 0; i < func[fnnum].argnum; i++)
        {
          blankpass (socp, 1);
          if (eval1cpy (socp, m, 1) != 0)
            ERRLIN (13);
        }
      atermscan (socp, dummy, 2);       /* ;ʬˤERR */
      break;
    }
  *memptr = EOLTTR;
  return (fnnum == -1 ? 0 : func[fnnum].fntype);
}

 /** ʸΡ\פȴ */
void
de_bcksla (s, r)
     char *s, *r;
{
  for (; *s; *r++ = *s++)
    if (*s == '\\')
      s++;
  *r = '\0';
}

 /**    defvarshikiˤᤷơѿѰꤹ롣
        ѿκǸ˥ɥޡ롣ͤϡѰǼ
        ؤΥݥ󥿡*/
static                          /* V3.1 */
letter *
rangekettei (num, shiki)
     letter *shiki;
     int num;                   /* ѰꤷĤĤѿֹ */
{
  letter hyoukabuf[TRMSIZ];

  rangeset (num, hen_iki);
  *hen_iki = EOLTTR;

  if (*shiki++ != '(')
    ERRLIN (8);
  atermscan (&shiki, hyoukabuf, 1);

  if (!ltrstrcmp (hyoukabuf, "all"))
    {
      *hen_iki++ = VARRNG;
      *hen_iki++ = 0;
      *hen_iki++ = LTRHUG;      /* Ѱʸ */
      *hen_iki++ = EOLTTR;
      *hen_iki = EOLTTR;
      atermscan (&shiki, dummy, 2);     /* ;ʬˤERR */
    }
  else if (!ltrstrcmp (hyoukabuf, "between"))
    {
      int i;

      *hen_iki++ = VARRNG;
      while (blankpass (&shiki, 1), *shiki != ')')
        {
          for (i = 1; i <= 2; i++)
            {
              switch (*shiki)
                {
                case '\'':
                  shiki++;
                  *hen_iki++ = onescan (&shiki, dummy);
                  shiki++;
                  break;
                case ')':
                case '"':
                case '(':
                  ERRLIN (8);
                default:
                  *hen_iki++ = *shiki++;
                }
              if (i < 2)
                {
                  if (!is_eolsp (*shiki))
                    ERRLIN (8);
                  blankpass (&shiki, 1);
                }
            }
        }
      *hen_iki++ = EOLTTR;
      *hen_iki = EOLTTR;
    }
  else if (!ltrstrcmp (hyoukabuf, "list"))
    {
      while (blankpass (&shiki, 1), *shiki != ')')
        {
          switch (*shiki)
            {
            case '"':
            case '(':
              ERRLIN (8);
            case '\'':
              shiki++;
              *hen_iki++ = onescan (&shiki, dummy);
              shiki++;          /* ˡ'פĤƤ뤫
                                   ɤθϤ⤦ѤǤ롣 */
              break;
            default:
              *hen_iki++ = *shiki++;
            }
          if (!is_eolsp (*shiki))
            ERRLIN (8);
        }
      *hen_iki++ = EOLTTR;
      *hen_iki = EOLTTR;
    }
  else
    {
      ERRLIN (8);               /* Ϥ¾ιʸͽǤä */
    }

  return (cur_rk_table->rk_hensuu.point[num].range);    /* V3.1 */
}

 /**    numܤѿѰؤ٤ݥ󥿤λؤꤷѿ
        Ͽ֤ˤ롣*/
static                          /* V3.1 */
  void
rangeset (num, range)
     letter *range;             /* ѰΥݥ */
     int num;
{
  cur_rk_table->rk_hensuu.point[num].range = range;     /* V3.1 */
  cur_rk_table->rk_hensuu.point[num].regdflg = 1;       /* V3.1 */
}


 /**    nameǻꤵ줿̾ѿõʤϿѿ̾κǸ
        ɥޡ롣
        flg1λ̾ѿ߹Ԥ̤Фʤ饨顼ޤflg-1λ
        ̾ѿʤ饨顼defvarνʣåѡˡ*/
static                          /* V3.1 */
  int
hensrc_tourk (name, flg)
     letter *name;
     int flg;
{
  fast int n;                   /* V3.1 */
  fast hensuset *hensuptr;      /* V3.1 */
  fast hensuutable *hentptr = &cur_rk_table->rk_hensuu;

  /* 88/06/06 V3.1 */
  for (n = 0; n < hentptr->count; n++)
    {
      if (ltrcmp (hentptr->point[n].name, name))
        continue;
      /* found */
      if (flg == -1 && hentptr->point[n].regdflg != 0)
        ERRLIN (10);
      if (flg == 1 && hentptr->point[n].curlinflg == 0)
        ERRLIN (5);
      hentptr->point[n].curlinflg = 1;
      return (n);
    }

  /* 褿ȤȤϡФѿȸȡflg1ʤ
     顼 */
  if (flg == 1)
    ERRLIN (5);

  check_and_realloc_for_hensuu (hentptr, n, name, RK_HENSUU_MAX_LOT, RK_HENSUU_MEM_LOT);

  hensuptr = &hentptr->point[n];
  hensuptr->name = hentptr->next;
  hensuptr->curlinflg = 1;
  hensuptr->regdflg = 0;        /* Фrangedef̤Ȧ */
  hentptr->next = ltrgrow (hensuptr->name, name);
  *(++(hentptr->next)) = EOLTTR;
  return (n);
}

#define ltrtostr(lp, c) \
{ \
    for (;*lp != EOLTTR && *lp; *c++ = (char)(*lp++ & 0xff)); \
    *c = '\0'; \
}
 /** Ȥ߹ߴؿǽ̾ФƤϤֹ򡢤ǤʤΤʤ-1֤ */
static                          /* V3.1 */
  int
serfun (lp)
     fast letter *lp;           /* ؿǽ̾⤷ѿ̾ *//* V3.1 */
{
  fast int i;                   /* V3.1 */
  char tmp[32];
  fast char *c, *tmp_p = tmp;

  ltrtostr (lp, tmp_p);
  for (i = 0; c = func[i].fnname; i++)
    {
      if (!strcmp (tmp, c))
        return (i);
    }
/*
        for(i = 0; func[i] . fnname != NULL; i++){
                if(! ltrstrcmp(lp, func[i] . fnname)) return(i);
        }
*/
  return (-1);
}

 /** ѿ̾Υå ȥ顼 */
static                          /* V3.1 */
  void
vchk (lp)
     fast letter *lp;           /* V3.1 */
{
  if (is_digit (*lp))
    ERRLIN (3);
  for (; *lp != EOLTTR; lp++)
    {
      /*    if(is_lower(*lp)) *lp = to_upper(*lp);  */
      if (!is_alnum (*lp) && *lp != '_')
        ERRLIN (3);
    }
}

 /**    ܤФФ1֤flg0λϡ')'
        Ĥȥ顼';'Ϥǰܰ*/
static                          /* V3.1 */
  int
termsscan (socp, dest, flg)
     fast letter **socp, *dest; /* V3.1 */
         /* socpλؤƤݥ󥿤ؤƤ꤫Фdest롣
            θ塢socpؤƤݥ󥿤ʤ롣Υե **scan()
            ȤؿƤʤäƤ롣 */
     int flg;
{
  fast letter *bgn;             /* V3.1 */

  bgn = dest;

  if (blankpass (socp, 0) == 0)
    {
      if (flg && **socp == ';')
        {
          *dest++ = *(*socp)++;
        }
      else
        while (!is_eolsp (**socp))
          {
            if (**socp == ')')
              {
                if (flg)
                  ERRLIN (0);
                break;
              }
            else
              {
                partscan (socp, dest);
                totail (dest);
              }
          }
    }

  *dest = EOLTTR;
  return (bgn != dest);
}

 /**    ꥹȰĤñΰޤȤޤФ1֤
        flg1ΤȤ')'Ĥȥ顼
        flg2ΤȤФ饨顼
        flg3ΤȤФ˼Ԥ饨顼*/
static                          /* V3.1 */
  int
atermscan (socp, dest, flg)
     fast letter **socp, *dest; /* V3.1 */
     int flg;
{
  fast letter *bgn;             /* V3.1 */
  fast int found;               /* V3.1 */

  bgn = dest;

  if (blankpass (socp, 0) == 0)
    {
      if (**socp == '(')
        {
          listscan (socp, dest);
          totail (dest);
        }
      else
        {
          while (!is_eolsp (**socp) && **socp != '(')
            {
              if (**socp == ')')
                {
                  if (flg == 1)
                    ERRLIN (0);
                  break;
                }
              else
                {
                  partscan (socp, dest);
                  totail (dest);
                }
            }
        }
    }

  *dest = EOLTTR;

  found = (bgn != dest);
  if (!found && flg == 3 || found && flg == 2)
    ERRLIN (7);
  return (found);
}

 /**    ĤФФΤꥹȤʤͤ0ñʸʤ1
        ʸʤ2ʸʤ3*/
static                          /* V3.1 */
  int
partscan (socp, dest)
     fast letter **socp, *dest; /* V3.1 */
{
  switch (**socp)
    {
    case '(':
      listscan (socp, dest);
      return (0);
    case '\'':
      singleqscan (socp, dest);
      return (2);
    case '"':
      doubleqscan (socp, dest);
      return (3);
    default:
      *dest++ = *(*socp)++;
      *dest = EOLTTR;
      return (1);
    }
}

 /** 󥰥륯ɽĤФ*/
static                          /* V3.1 */
  void
singleqscan (socp, dest)
     fast letter **socp, *dest; /* V3.1 */
{
  *dest++ = *(*socp)++;
  onescan (socp, dest);
  totail (dest);
  if ((*dest++ = *(*socp)++) != '\'')
    ERRLIN (1);

  *dest = EOLTTR;
}

 /** ֥륯ɽĤФ*/
static                          /* V3.1 */
  void
doubleqscan (socp, dest)
     fast letter **socp, *dest; /* V3.1 */
{
  *dest++ = *(*socp)++;
  while (**socp != '"')
    {
      if (**socp == EOLTTR)
        ERRLIN (1);
      onescan (socp, dest);
      totail (dest);
    }
  *dest++ = *(*socp)++;

  *dest = EOLTTR;
}

 /**    81016ʥѥ饯ºݤΥɤľϤΥå
        ʸȿʳϤФƤñ0֤*/
#ifdef OMRON_LIB
static
#endif
  int
ltov (l)
     fast letter l;             /* V3.1 */
{
  if (is_upper (l))
    return (l - 'A' + 10);
  if (is_lower (l))
    return (l - 'a' + 10);
  if (is_digit (l))
    return (l - '0');
  else
    return (0);
}

 /** ltovε */
#ifdef OMRON_LIB
static
#endif
  letter
vtol (l)
     fast letter l;             /* V3.1 */
{
  if (BASEMX <= l)
    return ('*');
  return (l + (l < 10 ? '0' : 'A' - 10));
}

 /**    󥰥롦֥륯ȤǤΰʸФ
        ^פˤ륳ȥ륳ɽ\פˤ81016ɽˤ
        б\ɽϡ\odxϿ¤ӡ;ϡפǤ롣*/
static                          /* V3.1 */
  letter
onescan (socp, dest)
     fast letter **socp, *dest; /* V3.1 */
{
  fast letter l, realcode;      /* V3.1 */
  fast int digflg;              /* V3.1 */

  switch (realcode = *dest++ = *(*socp)++)
    {
    case '^':
      if (!(' ' <= (l = *(*socp)++) && l < '\177'))
        ERRLIN (2);
      realcode = ((*dest++ = l) == '?' ? '\177' : l & 0x1f);
      break;
    case '\\':
      digflg = 0;
      switch (**socp)
        {
        case 'n':
          *dest++ = *(*socp)++;
          realcode = '\n';
          break;
        case 't':
          *dest++ = *(*socp)++;
          realcode = '\t';
          break;
        case 'b':
          *dest++ = *(*socp)++;
          realcode = '\b';
          break;
        case 'r':
          *dest++ = *(*socp)++;
          realcode = '\r';
          break;
        case 'f':
          *dest++ = *(*socp)++;
          realcode = '\f';
          break;
        case 'e':
        case 'E':
          *dest++ = *(*socp)++;
          realcode = ESCCHR;
          break;
        case 'o':
          *dest++ = *(*socp)++;
          for (realcode = 0; is_octal (**socp);)
            {
              digflg = 1;
              realcode <<= 3;
              realcode += ltov (*dest++ = *(*socp)++);
            }
          if (!digflg)
            ERRLIN (2);
          if (**socp == ';')
            *dest++ = *(*socp)++;
          break;
        case 'x':
          *dest++ = *(*socp)++;
          for (realcode = 0; is_xdigit (**socp);)
            {
              digflg = 1;
              realcode <<= 4;
              realcode += ltov (*dest++ = *(*socp)++);
            }
          if (!digflg)
            ERRLIN (2);
          if (**socp == ';')
            *dest++ = *(*socp)++;
          break;
        case 'd':
          *dest++ = *(*socp)++;
          for (realcode = 0; is_digit (**socp);)
            {
              digflg = 1;
              realcode *= 10;
              realcode += ltov (*dest++ = *(*socp)++);
            }
          if (!digflg)
            ERRLIN (2);
          if (**socp == ';')
            *dest++ = *(*socp)++;
          break;
        default:
          if (is_octal (**socp))
            {
              for (realcode = 0; is_octal (**socp);)
                {
                  realcode <<= 3;
                  realcode += ltov (*dest++ = *(*socp)++);
                }
              if (**socp == ';')
                *dest++ = *(*socp)++;
            }
          else
            {
              realcode = *dest++ = *(*socp)++;
            }
        }
      break;
    default:;
    }
  *dest = EOLTTR;
  return (realcode);
}

 /**    letterƬˤ򥹥åפ롣
        ã顢flg0ΤȤ1֤Ǥʤȥ顼*/
static                          /* V3.1 */
  int
blankpass (pptr, flg)
     fast letter **pptr;        /* V3.1 */
         /* letterΥݥ󥿤ؤΥݥ󥿡줬ؤƤΤʤ */
     int flg;
{
  register letter *p = *pptr;

  while (is_space (*p))
    p = ++(*pptr);
  if (EOLTTR == *p)
    {
      if (flg)
        ERRLIN (4);
      return (1);
    }
/*
        while(is_eolsp(**pptr)){
                if(EOLTTR == **pptr){
                        if(flg) ERRLIN(4);
                        return(1);
                }
                (*pptr)++;
        }
*/
  return (0);
}

 /** ꥹȰļФ */
static                          /* V3.1 */
  void
listscan (socp, dest)
     fast letter **socp, *dest; /* V3.1 */
{
  fast int eofreach;            /* V3.1 */

  *dest++ = *(*socp)++;         /* = '(' */
  *dest++ = ' ';

  while (eofreach = blankpass (socp, 0), **socp != ')')
    {
      if (eofreach)
        {
          /* 88/06/02/ V3.1 */
          if ((cur_rk_table->rk_hyobuf.next = readln_ustrtoltr (cur_rk_table->rk_hyobuf.next, (*socp = cur_rk_table->ltrbufbgn))) == NULL)
            ERRLIN (20);
          /* listǹԤڤƤ硢ɲɤ߹ߤ
             롣uns_chrѤΥХåե⡢letterѤΤΤ⡢
             ʪƬѤƤΤաޤ
             顼硢 顼ΰ֤ˤ餺
             ߹ԤȤɽΤϡǸɤޤ줿ԤΤ */
        }
      else
        {
          termsscan (socp, dest, 0);
          totail (dest);
          *dest++ = ' ';
        }
    }
  *dest++ = *(*socp)++;         /* = ')' */
  *dest = EOLTTR;

}

 /** lpǻꤵ줿⡼̾õĤʤȥ顼 */
static                          /* V3.1 */
  int
modsrcL (lp)
     letter *lp;
{
  fast int n;                   /* V3.1 */

  /* 88/06/07 V3.1 */
  for (n = 0; n < cur_rk_table->rk_defmode.count; n++)
    if (!ltrstrcmp (lp, cur_rk_table->rk_defmode.point[n]))
      return (n);

  ERRLIN (16);
   /*NOTREACHED*/ return (0);
}

 /**    ϡɽɤ߹ߤǥä˷ٹ𤹤롼nϥ顼ɡ
        ermesȤѰդƤʤΤϡνꥨ顼å
        ĤʤΡξ票顼ɤ⺣ν0Τߡ
        ޤơromkan_initΥ顼ɤȤơlongjmpͳ
        1֤*/


static                          /* V3.1 */
  void
ERHOPN (n)                      /* ѴбɽץǤʤ */
     fast unsigned int n;       /* V3.1 */
{
  static char *ermes[] = {
    /*  0 */ "Unprintable error",
    "Taio-hyo doesn't exist",
    "Can't open Taio-hyo",
  };

  if (n >= numberof (ermes))
    n = 0;

  fprintf (stderr, "\r\nromkan: Taio-hyo %s%s ---\r\n", cur_rk_table->tcurdir, cur_rk_table->tcurfnm);
  fprintf (stderr, "\tError No.%d: %s.\r\n", n, ermes[n]);
  longjmp (cur_rk_table->env0, 1);
}


static                          /* V3.1 */
  void
ERRLIN (n)                      /* ѴбɽΥ顼 */
     fast unsigned int n;       /* V3.1 */
{
  static char *ermes[] = {
    /*  0 */ "')' mismatch",
    "Incomplete single-quote or double-quote expression",
    "Illegal ^,\\o,\\x or \\d expression",
    "Illegal variable name",
    "Incomplete line",
    /*  5 */ "Evaluation of unbound variable",
    "Unprintable error",
    "Too many or too few contents of list",
    "Illegal defvar",
    "Faculity or declaration joined other item(s)",
    /* 10 */ "Duplicate defvar",
    "Variable name conflicts with Function name",
    "A line contains both declaration and other output item(s)",
    "Argument isn't a letter",
    "Function, faculity or declaration in illegal place",
    /* 15 */ "More than 3 items",
    "Undefined mode",
    "Against the restriction of pre-transform table",
    "Against the restriction of after-transform table",
    "Item comes after faculity",
    /* 20 */ "Incomplete list",
    "Illegal character",
  };

  if (n >= numberof (ermes))
    n = 6;

  fprintf (stderr, "\r\nromkan: Taio-hyo %s%s ---\r\n%s\r\n", cur_rk_table->tcurdir, cur_rk_table->tcurfnm, cur_rk_table->tcurread);
  fprintf (stderr, "\tError No.%d: %s.\r\n", n, ermes[n]);
  longjmp (cur_rk_table->env0, 1);
}

/* 88/06/10 V3.1 */
static                          /* V3.1 */
  void
ERRHYO (n)                      /* ERRLINƱ͡бɽΥ顼ԤθǤʤ
                                   Τ򸫤ʤȤ狼ʤꡣ̤ѿνи */
     fast unsigned int n;       /* V3.1 */
{
  static char *ermes[] = {
    /*  0 */ "Unprintable error",
    "Undefined variable was found",
  };

  if (n >= numberof (ermes))
    n = 0;

  fprintf (stderr, "\r\nromkan: Taio-hyo %s%s ---\r\n", cur_rk_table->tcurdir, cur_rk_table->tcurfnm);
  fprintf (stderr, "Error No.%d: %s\r\n", n, ermes[n]);
  longjmp (cur_rk_table->env0, 1);
}
