      program     he5_za_writedimscaleF_32

      implicit    none

      include     'hdfeos5.inc'

      integer     status
      integer     i, j
      integer     he5_zaopen
      integer     he5_zaattach
      integer     he5_zawrfld
      integer     he5_zawrattr
      integer     he5_zawrgattr
      integer     he5_ehwrglatt
      integer     he5_zawrlattr 
      integer     he5_zadetach
      integer     he5_zaclose
      integer     HE5_ZAsetdimscale
      integer     HE5_ZAwritedscaleattr

      integer     zafid,zaid1
      integer*4   datbuf_i1(1) 
      integer*4   datbuf_i(15)
      integer     count(2)
      integer*4   nbands
      integer     bands(3)
      integer*4   datbuf_i2(2)
      integer     xdim, ydim, ntime
      integer     data(15)
      integer     FAIL
      parameter   (FAIL=-1)



!  /*
!   * We first open the HDF-EOS zaath file, "za.he5".  Because this file
!   * already exist and we wish to write to it, we use the H5F_ACC_RDWR access
!   * code in the open statement.  The HE5_ZAopen routine returns the zaath file
!   * id, zafid, which is used to identify the file in subsequent routines.
!   */ 
      nbands = 15
      do j=1,nbands
         data(j)=(j+1)*2
      enddo

      zafid = HE5_ZAopen("za.he5", HE5F_ACC_RDWR)
      write(*,*) 'File ID returned by he5_zaopen(): ',zafid
!  /*
!   * If the zaath file cannot be found, HE5_ZAopen will return -1 for the file
!   * handle (zafid).  We there check that this is not the case before
!   * proceeding with the other routines.
!   * 
!   * The HE5_ZAattach routine returns the handle to the existing zaath "ZA1",
!   * ZAid.  If the zaath is not found, HE5_ZAattach returns -1 for the handle.
!   */ 

      if (zafid .ne. FAIL) then
 
         ZAid1 = HE5_ZAattach(zafid, "ZA1")
         write(*,*) 'Za ID returned by he5_zaattach(): ',zaid1

!      /* the field Spectra has Bands,Res2tr,Res2xtr dimensions. 
!	 xdim = 120;
!	 ydim = 200;
!	 Time dim is set to 10
!      */

         if (ZAid1 .eq. -1) then
            
            write(*,*) 'Error: Cannot attach to zaath ZA1. Stpped.'
            status = HE5_ZAclose(zafid)
            stop
            
         endif
                  
         status = HE5_ZAsetdimscale(ZAid1, "Spectra", "Bands", nbands,
     1                               HE5T_NATIVE_INT, data)
         write(*,*) 'Status returned by HE5_ZAsetdimscale: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error: Cannot set Dimension Scale for Bands',
     1                 ' dimemnsion in field Vegetation'
            status = HE5_ZAdetach(ZAid1)
            status = HE5_ZAclose(zafid)
            stop
         endif

         count(1)= 12
         status = HE5_ZAwritedscaleattr(ZAid1, "Bands", "label", 
     1                         HE5T_NATIVE_CHAR, count, "Bands Dim")
         write(*,*) 'Status returned by HE5_ZAwritedscaleattr: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error:Cannot set Dimension Scale str for Bands',
     1                ' dimemnsion in field Spectra'
            status = HE5_ZAdetach(ZAid1)
            status = HE5_ZAclose(zafid)
            stop
         endif
         
         count(1)= 6
         status = HE5_ZAwritedscaleattr(ZAid1, "Bands", "unit", 
     1                              HE5T_NATIVE_CHAR, count, "None")
         write(*,*) 'Status returned by HE5_ZAwritedscaleattr: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error:Cannot set Dimension Scale str for Bands',
     1                 ' dimemnsion in field Spectra'
            status = HE5_ZAdetach(ZAid1)
            status = HE5_ZAclose(zafid)
            stop
         endif
         
         count(1)= 4
         status = HE5_ZAwritedscaleattr(ZAid1, "Bands", "format", 
     1                                 HE5T_NATIVE_CHAR, count, "I2")
         write(*,*) 'Status returned by HE5_ZAwritedscaleattr: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error:Cannot set Dimension Scale str for Bands',
     1                 ' dimemnsion in field Spectra'
            status = HE5_ZAdetach(ZAid1)
            status =  HE5_ZAclose(zafid)
            stop
         endif

         datbuf_i1(1) = -999
         count(1)= 1
         status = HE5_ZAwritedscaleattr(ZAid1, "Bands", "MissingValue",
     1                             HE5T_NATIVE_INT, count, datbuf_i1)
         write(*,*) 'Status returned by HE5_ZAwritedscaleattr: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error:Cannot set Dimension Scale str for Bands',
     1                 ' dimemnsion in field Spectra'
            status = HE5_ZAdetach(ZAid1)
            status = HE5_ZAclose(zafid)
            stop
         endif
         
         datbuf_i(1) =  -999
         datbuf_i(2) =  0
         datbuf_i(3) =  999


         count(1)= 3
         status = HE5_ZAwritedscaleattr(ZAid1, "Bands", "IntValues", 
     1                               HE5T_NATIVE_INT, count, datbuf_i)
         write(*,*) 'Status returned by HE5_ZAwritedscaleattr: ',status
         if (status .eq. -1) then
            
            write(*,*) 'Error:Cannot set Dimension Scale str for Bands',
     1         ' dimemnsion in field Spectra'
            status = HE5_ZAdetach(ZAid1)
            status = HE5_ZAclose(zafid)
            stop
         endif
         
         status = HE5_ZAdetach(ZAid1)
         write(*,*) 'Status returned by he5_zadetach(): ',status

         status = HE5_ZAclose(zafid)
         write(*,*) 'Status returned by he5_zaclose(): ',status

      endif
      stop
      end

