<?php

//    qryachecks.php
//    Shows a List of accessibility checks
//
//    Part of the ht://Check package
//
//    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
//    Author: Valentina Del Sapio - Prato - Italy
//
//    For copyright details, see the file COPYING in your distribution
//    or the GNU General Public License version 2 or later 
//    <http://www.gnu.org/copyleft/gpl.html>
//
//    $Id: qryachecks.php,v 1.5 2004/06/11 11:26:45 angusgb Exp $

///////
   //    Global settings
///////

include ("./include/global.inc.php");


if (!isset($dbname))
{
   // Error
   DisplayErrMsg($strErrorNoDBSelected);
   echo "<a href=\"index.php\">" . $strMainPage . "</A>";
   die;
}

$strSection=$strListAchecks;
$pagetitle = "Database: $dbname - " . $strSection;
eval("\$strhome = \"$strDBHome \";");
$linkbar = "<a href=\"index.php?dbname=". $dbname . "\">". $strhome."</A>";

// A database has been selected

include ("./include/header.inc.php");

if (isset ($cmd))
{

   if (!isset($initpage))
      $initpage=0;

   if (!isset($pagesize))
      $pagesize=30;

   $otherinfo = '&cmd=' . urlencode($cmd);
   $strwhere = " WHERE 1 ";
   
   if (isset($doctype) && $doctype!="AllDocTypes")
   {
      if ($doctype == 'NULL')
      {
         if ($whatdoctype == '!=')
            $whatdoctypetmp = 'not';
         $strwhere = $strwhere . " AND Url.DocType is $whatdoctypetmp $doctype ";
      }
      else
      {
         $strwheretmp = "Url.DocType $whatdoctype '$doctype'";
         if ($whatcharset == '!=')
            $strwhere .= " AND ($strwheretmp OR Url.DocType is NULL) ";
         else
            $strwhere .= " AND $strwheretmp ";
      }

      $otherinfo = $otherinfo . '&whatdoctype=' . urlencode($whatdoctype)
         . '&doctype=' . urlencode($doctype);
   }

   $num=count($url); // Count the elements

   // Set the URL filter   
   for ($i=0; $i<$num; $i++)
   {
      if (isset($url[$i]) && $url[$i] && strlen($url[$i]) > 0)
      {
         if(isset($whaturl[$i]))
         {
            $strwhere = $strwhere . " AND Url.Url " . $whaturl[$i]
               . " '" . $url[$i] . "' ";
            $otherinfo = $otherinfo . "&whaturl[$i]=" . urlencode($whaturl[$i])
               . "&url[$i]=" . urlencode ($url[$i]);
          }
      }
   }

   $num=count($acheckcode); // Count the elements

   // Set the Accessibility Code filter   
   // Codice dell'errore di accessibilit
   if (isset($acheckcode))
   {
      $strwhere .= " AND (";
      $a = 0;
      while (list($chiave, $valore) = each($acheckcode))
      {
         $a++;
         $strwhere .= " Accessibility.Code = $acheckcode[$chiave] ";
         $otherinfo .= "&acheckcode[$chiave]=" . $chiave;

         if ($a < $num)
            $strwhere .= " OR ";
         else
            $strwhere .= ") ";
      }
   }

   // Server
   if (!empty($server))
   {
      $strwhere .= " AND Url.IDServer = $server ";
      $otherinfo .= "&server=$server";
   }

   $strwhere .= " AND Url.IDUrl = Accessibility.IDUrl ";

   // Show all the URLs, retrieved ones as well as not
   $strGenSQL = "SELECT Accessibility.*, Statement, Url FROM Url, Accessibility "
      . "LEFT JOIN HtmlStatement USING (IDUrl, TagPosition) "
      . $strwhere
      . " ORDER BY Url.Url ASC"
      . " LIMIT " . $initpage . ", " . $pagesize;

   if (!isset($count))
   {
      $strCountSQL="select count(*) from Url, Accessibility "
         . "LEFT JOIN HtmlStatement USING (IDUrl, TagPosition) "
         . $strwhere;

      $count = $MyDB->CountEntries($strCountSQL,$dbname,true);
      if ($count<0)
      {
         DisplayErrMsg($MyDB->errmsg);
         return;
      }
      $MyDB->Free();
   }

// HTTP results
   
?>

<h4><?php echo $strSection; ?></h4>
<p>
<?
if ($count) printf ($strListPageInfo, number_format($initpage+1), number_format(($initpage+$pagesize)>$count?$count:$initpage+$pagesize), number_format($count));
?>  
<br>
<?php WritePageLink($initpage, $pagesize, $count, $dbname, $otherinfo); ?>
</p>

<?php

   $result=$MyDB->Query($dbname, $strGenSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows())
   {
      // At least one occurrence found
?>

<table>
<tr>
<th> N. </th>
<th> ID </th>
<th> Url \ <?php echo $strHTMLStatement; ?> </th>
<th> <?php echo $strAcheckError; ?> </th>
</tr>
      
<?php
      $i=0;
      while ($row = $MyDB->FetchArray())
      {
         // Get next row
         $i++;
         ($i % 2)? $trclass='odd':$trclass='even';
?>
<tr class="<?php echo $trclass; ?>">
   <td align="right"> <?php echo number_format($initpage+$i); ?> </td>
   <td align="right"> <?php echo number_format($row["IDUrl"]); ?> </td>
   <td class="url">
	<a href="showurl.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $row['IDUrl']; ?>"><?php echo GetURL($row['Url']); ?></a>
   <?php
   // HTML Statement
   if ($row['Statement'])
   { ?>
	   <br><strong><?php echo $strHTMLStatement; ?></strong>: &lt;<?php 
	   echo WriteHTML($row['Statement']); ?>&gt;<br>
	   <?php
   }
   ?>
   </td>
   <td align="center">
	<a href="./showacheck.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $row["IDUrl"]; ?>&TagPosition=<?php echo $row['TagPosition']; ?>&AttrPosition=<?php echo $row['AttrPosition']; ?>&acheckcode=<?php echo $row['Code']; ?>"><?php echo $strAchecks[$row['Code']]['error']; ?></a>
   </td>
</tr>
<?php         
      }

?>
</table>
<?php      
      // Page management

      WritePageLink($initpage, $pagesize, $count, $dbname,$otherinfo);
   }
   else
   {
?>
<p><?php echo $strNoOccurrencies; ?></p>

<?php
   }

   $MyDB->Free();

}
else
{
?>
<p><?php echo $strFilterUrls; ?>:</p>

<form action="<?php echo $PHP_SELF; ?>" method="GET">
<input type="hidden" name="dbname" value="<?php echo $dbname; ?>">
<table>

<tr>
<th>
  <?php echo $strUrl; ?> : 
</th>
</tr>

<?php 
$strSQL = "SELECT DISTINCT s.IDServer, s.Server FROM Accessibility a JOIN Url u USING (IDUrl) JOIN Server s USING (IDServer) ORDER BY Server ASC";
$result=$MyDB->Query($dbname, $strSQL);
if ($result == 0)
{
 ?>
<tr>
<td>
<label for="server"><strong><?php echo $strServer; ?></strong></label> :
 <select name="server" id="server">
 <option value="">--- <?php echo $strServer; ?> ---</option><?php
   if ($MyDB->NumRows())
   {
      $i=0;
      while ($row = $MyDB->FetchArray())
      {
        $i++;
        ?>
 <option value="<?php echo $row['IDServer']; ?>" <?php
        if ($server == $row['IDServer'])
           echo " selected";
        ?>><?php echo $row['Server']; ?></option>
 <?php
      }
      $MyDB->Free();
   }
   ?>
 </select>
</td>
</tr><?php
}

   for ($i=0; $i<$NumFilterRows; $i++)
   {
?>

<tr>
<td>
<select name="whaturl[<?php echo $i; ?>]">
 <option value="LIKE"><?php echo $strLike; ?></option>
 <option value="NOT LIKE"><?php echo $strNotLike; ?></option>
 <option value="REGEXP"><?php echo $strRegExp; ?></option>
 <option value="NOT REGEXP"><?php echo $strNotRegExp; ?></option>
</select>
<input name="url[<?php echo $i; ?>]" type="text" value="<?php echo $url[$i]; ?>"
   size="30" maxlength="255">
</td>
</tr>
<?php
   }

   // Retrieving all the DocTypes found
   $strSQL="SELECT count(*) as Count, DocType "
      . "FROM Url, Accessibility "
      . "WHERE Url.IDUrl = Accessibility.IDUrl "
      . "GROUP BY DocType "
      . "ORDER BY DocType ASC";

   $result=$MyDB->Query($dbname, $strSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows())
   {

?>
<tr>
<td>
<label for="whatdoctype"><strong><?php echo $strDocType; ?></strong></label> :
<select name="whatdoctype" id="whatdoctype">
 <option value="="><?php echo $strLike; ?></option>
 <option value="!="><?php echo $strNotLike; ?></option>
</select>
<select name="doctype">
 <option value="AllDocTypes"><?php echo $strAllDocTypes; ?></option>
<?php
      while ($row = $MyDB->FetchArray())
      {
          if (empty($row['DocType']))
          {
             $dt = 'NULL';
             $strdt = &$strNull;
          }
          else
          {
             $dt = &$row["DocType"];
             if ($dt == 'unknown')
                $strdt = &$strOther;
             else
                $strdt = &$dt;
          }
?>
 <option value="<?php echo $dt; ?>">
   <?php echo $strdt; ?> (<?php echo $row["Count"]; ?>)</option>
<?php
      }
?>
</select>
</td>
</tr>
  <?php
   }
   $MyDB->Free();

   // Retrieving all the Check codes found
   $strSQL="SELECT count(*) as Count, Code "
      . "FROM Accessibility GROUP BY Code "
      . "ORDER BY Code ASC";

   $result=$MyDB->Query($dbname, $strSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($MyDB->NumRows())
   {
?>
<tr>
<td>
<strong><?php echo $strSelectAchecks; ?></strong><br> 
<?php
      while ($row = $MyDB->FetchArray())
      { 
		$code = $row['Code'];
?>
	<input type="checkbox" name="acheckcode[<?php echo $code; ?>]" value="<?php echo $code; ?>"
	  title="<?php echo $strAcheckCode . " " . $code; ?>" id="acheckcode[<?php echo $code; ?>]">
        <label for="acheckcode[<?php echo $code; ?>]"><?php echo $strAchecks[$code]['error']; ?> (<?php echo $row['Count']; ?>)</label><br>
<?php
      } ?> 
</td>
</tr>
<?php
   }
   $MyDB->Free();
?>

<tr>
<td align="right">
  <input type="submit" name="cmd" value="<?php echo $strLinkSubmit; ?>">
</td>
</tr>
</form>
</table>

<p align="justify">
  <?php echo $strHelpOnString; ?>
</p>
<p align="justify">
  <?php echo $strHelpOnRegExp; ?>
</p>

<?php
}
?>
<br>
<?php include ("./include/footer.inc.php"); ?>
