/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IVOLUMEVIEWSUBJECT_H
#define IVOLUMEVIEWSUBJECT_H


#include "iviewsubject.h"


#include "iarray.h"
#include "icolor.h"


class iFunctionMapping;
class iHistogramMaker;
class iPiecewiseFunction;
class iReplicatedGridData;
class iReplicatedVolume;
class iVolumeDataConverter;
class iVolumeViewSubject;

class vtkAbstractVolumeMapper;
class vtkImageData;


//
//  Helper class
//
class iVolumeRenderingHelper
{

	friend class iVolumeViewSubject;

public:

	virtual bool IsUsingData(vtkDataSet *ds) = 0;
	virtual vtkAbstractVolumeMapper* GetMapper() = 0;

	virtual void SetVar(int){}
	virtual void SetBlendMode(int){}

	virtual float GetMemorySize() { return 0.0f; }

	void SetDataSpacing(double v);
	void SetImageDownsampleFactor(float v);
	void SetDepthDownsampleFactor(float v);

	inline bool IsAttachedDirectly() const { return mAttachedDirectly; }
	inline const iString& GetName() const { return mName; }
	
protected:
	
	iVolumeRenderingHelper(iVolumeViewSubject *parent, const iString &name, bool attachedDirectly);
	virtual ~iVolumeRenderingHelper();

	virtual void AdjustSpacing(){}

	double mDataSpacing;
	float mImageDownsampleFactor, mDepthDownsampleFactor;
	iVolumeViewSubject *mParent;

private:

	const bool mAttachedDirectly;
	const iString mName;

	iVolumeRenderingHelper();  // not implemented
};


class iVolumeViewSubject : public iViewSubject
{
	
	friend class iAbstractExtension;
	friend class iObjectFactory;

public:
	
	vtkTypeMacro(iVolumeViewSubject,iViewSubject);
	static const iObjectType& Type();
		
	IOBJECT_DECLARE_GETSET(Var,mVar,int);
//	virtual void SetVar(int v);
//	inline int GetVar() const { return mVar; }

	IOBJECT_DECLARE_GETSET1(Method,int);
//	virtual void SetMethod(int m);
//	inline int GetMethod() const { return mMethod; }
	static const iObjectKey& KeyMethodNames();

	IOBJECT_DECLARE_GETSET1(Palette,int);
//	virtual void SetPalette(int p);
//	inline int GetPalette() const { return mPalette; }

	IOBJECT_DECLARE_GETSET1(BlendMode,int);
//	virtual void SetBlendMode(int m);
//	inline int GetBlendMode() const { return mBlendMode; }

	IOBJECT_DECLARE_GETSET1(InterpolationType,int);
//	virtual void SetInterpolationType(bool m);
//	inline bool GetInterpolationType() const { return mInterpolationType; }
	
	IOBJECT_DECLARE_GETSET1(ImageDownsampleFactor,float);
//	virtual void SetImageDownsampleFactor(float m);
//	inline float GetImageDownsampleFactor() const { return mImageDownsampleFactor; }
	
	IOBJECT_DECLARE_GETSET1(DepthDownsampleFactor,float);
//	virtual void SetDepthDownsampleFactor(float m);
//	inline float GetDepthDownsampleFactor() const { return mDepthDownsampleFactor; }
	
	IOBJECT_DECLARE_GET2(OpacityFunction,iFunctionMapping * );
//	iFunctionMapping* GetOpacityFunction() const;

	inline iReplicatedVolume* GetVolume() const { return mVolume; }
	
	const iString& GetMethodName(int i) const;
	bool IsMethodAvailable(int i) const;

	//
	//  Inherited members
	//
	IVIEWSUBJECT_DECLARE_INHERITED_KEYS;
	IVIEWSUBJECT_DECLARE_INHERITED_MEMBERS;

	static void SetGPUMode(int m);
	static int GPUMode(){ return mGPUMode; }

protected:
	
	iVolumeViewSubject(iViewModule *vm, const iDataType &type, const iString &name);
	virtual ~iVolumeViewSubject();
	virtual void ConfigureBody();

	virtual void FinishInitialization();
	virtual void UpdateVar();

	int mVar, mPalette, mMethod;
	iPiecewiseFunction *mOpacityFunction;
	iFunctionMapping *mFunctionMappings;
	
	int mBlendMode, mInterpolationType; 
	float mImageDownsampleFactor, mDepthDownsampleFactor;

	static int mGPUMode;

	//
	//  VTK members
	//
	iReplicatedVolume *mVolume;
	iReplicatedGridData *mDataReplicated;
	iVolumeDataConverter *mDataConverter;
	iHistogramMaker *mHistogramMaker;
	iArray<iVolumeRenderingHelper*> mHelpers;
};

#endif // IVOLUMEVIEWSUBJECT_H
 
