/*
 * Copyright (c) 2012, 2015, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.text.resources.cldr.lt;

import java.util.ListResourceBundle;

public class FormatData_lt extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "MonthNames",
                new String[] {
                    "sausio",
                    "vasaris",
                    "kovas",
                    "balandis",
                    "gegu\u017e\u0117",
                    "bir\u017eelis",
                    "liepa",
                    "rugpj\u016btis",
                    "rugs\u0117jis",
                    "spalis",
                    "lapkritis",
                    "gruodis",
                    "",
                }
            },
            { "standalone.MonthNames",
                new String[] {
                    "Sausis",
                    "Vasaris",
                    "Kovas",
                    "Balandis",
                    "Gegu\u017e\u0117",
                    "Bir\u017eelis",
                    "Liepa",
                    "Rugpj\u016btis",
                    "Rugs\u0117jis",
                    "Spalis",
                    "Lapkritis",
                    "Gruodis",
                    "",
                }
            },
            { "MonthAbbreviations",
                new String[] {
                    "Saus.",
                    "Vas",
                    "Kov.",
                    "Bal.",
                    "Geg.",
                    "Bir.",
                    "Liep.",
                    "Rugp.",
                    "Rugs.",
                    "Spal.",
                    "Lapkr.",
                    "Gruod.",
                    "",
                }
            },
            { "standalone.MonthAbbreviations",
                new String[] {
                    "Saus.",
                    "Vas.",
                    "Kov.",
                    "Bal.",
                    "Geg.",
                    "Bir.",
                    "Liep.",
                    "Rugp.",
                    "Rugs.",
                    "Spal.",
                    "Lapkr.",
                    "Gruod.",
                    "",
                }
            },
            { "MonthNarrows",
                new String[] {
                    "S",
                    "V",
                    "K",
                    "B",
                    "G",
                    "B",
                    "L",
                    "R",
                    "R",
                    "S",
                    "L",
                    "G",
                    "",
                }
            },
            { "standalone.MonthNarrows",
                new String[] {
                    "S",
                    "V",
                    "K",
                    "B",
                    "G",
                    "B",
                    "L",
                    "R",
                    "R",
                    "S",
                    "L",
                    "G",
                    "",
                }
            },
            { "DayNames",
                new String[] {
                    "sekmadienis",
                    "pirmadienis",
                    "antradienis",
                    "tre\u010diadienis",
                    "ketvirtadienis",
                    "penktadienis",
                    "\u0161e\u0161tadienis",
                }
            },
            { "standalone.DayNames",
                new String[] {
                    "sekmadienis",
                    "pirmadienis",
                    "antradienis",
                    "tre\u010diadienis",
                    "ketvirtadienis",
                    "penktadienis",
                    "\u0161e\u0161tadienis",
                }
            },
            { "DayAbbreviations",
                new String[] {
                    "Sk",
                    "Pr",
                    "An",
                    "Tr",
                    "Kt",
                    "Pn",
                    "\u0160t",
                }
            },
            { "standalone.DayAbbreviations",
                new String[] {
                    "Sk",
                    "Pr",
                    "An",
                    "Tr",
                    "Kt",
                    "Pn",
                    "\u0160t",
                }
            },
            { "DayNarrows",
                new String[] {
                    "S",
                    "P",
                    "A",
                    "T",
                    "K",
                    "P",
                    "\u0160",
                }
            },
            { "standalone.DayNarrows",
                new String[] {
                    "S",
                    "P",
                    "A",
                    "T",
                    "K",
                    "P",
                    "\u0160",
                }
            },
            { "QuarterNames",
                new String[] {
                    "I ketvirtis",
                    "II ketvirtis",
                    "III ketvirtis",
                    "IV ketvirtis",
                }
            },
            { "standalone.QuarterNames",
                new String[] {
                    "I ketvirtis",
                    "II ketvirtis",
                    "III ketvirtis",
                    "IV ketvirtis",
                }
            },
            { "QuarterAbbreviations",
                new String[] {
                    "I k.",
                    "II k.",
                    "III k.",
                    "IV ketv.",
                }
            },
            { "standalone.QuarterAbbreviations",
                new String[] {
                    "I ketv.",
                    "II ketv.",
                    "III ketv.",
                    "IV ketv.",
                }
            },
            { "QuarterNarrows",
                new String[] {
                    "I",
                    "II",
                    "3",
                    "IV",
                }
            },
            { "standalone.QuarterNarrows",
                new String[] {
                    "I",
                    "II",
                    "3",
                    "IV",
                }
            },
            { "AmPmMarkers",
                new String[] {
                    "prie\u0161piet",
                    "popiet",
                }
            },
            { "long.Eras",
                new String[] {
                    "prie\u0161 Krist\u0173",
                    "po Kristaus",
                }
            },
            { "Eras",
                new String[] {
                    "pr. Kr.",
                    "po Kr.",
                }
            },
            { "field.era", "era" },
            { "field.year", "metai" },
            { "field.month", "m\u0117nuo" },
            { "field.week", "savait\u0117" },
            { "field.weekday", "savait\u0117s diena" },
            { "field.dayperiod", "dienos metas" },
            { "field.hour", "valanda" },
            { "field.minute", "minut\u0117" },
            { "field.second", "sekund\u0117" },
            { "field.zone", "laiko juosta" },
            { "TimePatterns",
                new String[] {
                    "HH:mm:ss zzzz",
                    "HH:mm:ss z",
                    "HH:mm:ss",
                    "HH:mm",
                }
            },
            { "DatePatterns",
                new String[] {
                    "y 'm'. MMMM d 'd'., EEEE",
                    "y 'm'. MMMM d 'd'.",
                    "y MMM d",
                    "yyyy-MM-dd",
                }
            },
            { "java.time.buddhist.DatePatterns",
                new String[] {
                    "y G, MMMM d, EEEE",
                    "G y MMMM d",
                    "G y MMM d",
                    "GGGGG yyyy-MM-dd",
                }
            },
            { "buddhist.DatePatterns",
                new String[] {
                    "y GGGG, MMMM d, EEEE",
                    "GGGG y MMMM d",
                    "GGGG y MMM d",
                    "G yyyy-MM-dd",
                }
            },
            { "calendarname.islamic-civil", "Pilietinis islamo kalendorius" },
            { "calendarname.islamicc", "Pilietinis islamo kalendorius" },
            { "calendarname.roc", "Kinijos Respublikos kalendorius" },
            { "calendarname.japanese", "Japon\u0173 kalendorius" },
            { "calendarname.islamic", "Islamo kalendorius" },
            { "calendarname.buddhist", "Budist\u0173 kalendorius" },
            { "calendarname.gregorian", "Grigaliaus kalendorius" },
            { "calendarname.gregory", "Grigaliaus kalendorius" },
            { "DefaultNumberingSystem", "latn" },
            { "latn.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "0",
                    "#",
                    "\u2212",
                    "\u00d710^",
                    "\u2030",
                    "\u221e",
                    "\u00a4\u00a4\u00a4",
                }
            },
            { "NumberPatterns",
                new String[] {
                    "#,##0.###",
                    "#,##0.00\u00a0\u00a4",
                    "#,##0\u00a0%",
                }
            },
        };
        return data;
    }
}
