/* IMSpector - Instant Messenger Transparent Proxy Service
 * http://www.imspector.org/
 * (c) Lawrence Manning <lawrence@aslak.net>, 2006
 *          
 * Released under the GPL v2. */

#include "imspector.h"

ProtocolPlugin::ProtocolPlugin()
{
	handle = NULL;
}

ProtocolPlugin::~ProtocolPlugin()
{
}

bool ProtocolPlugin::loadplugin(std::string filename)
{
	handle = dlopen(filename.c_str(), RTLD_LAZY);
	
	if (!handle)
	{
		syslog(LOG_ERR, "dlopen(): %s\n", dlerror());
		return false;
	}
	
	initprotocolplugin = (initprotocolplugintype) dlsym(handle, "initprotocolplugin");
	closeprotocolplugin = (closeprotocolplugintype) dlsym(handle, "closeprotocolplugin");
	processpacket = (processpackettype) dlsym(handle, "processpacket");
	generatemessagepacket = (generatemessagepackettype) dlsym(handle, "generatemessagepacket");
	
	if (!initprotocolplugin || !closeprotocolplugin || !processpacket)
	{
		syslog(LOG_ERR, "%s: dlsym(): %s\n", filename.c_str(), dlerror());
		return false;
	}
	
	return true;
}

bool ProtocolPlugin::unloadplugin(void)
{
	if (handle) dlclose(handle);
	
	return true;
}

bool ProtocolPlugin::callinitprotocolplugin(class Options &options, bool debugmode)
{
	return (*initprotocolplugin)(protocolplugininfo, options, debugmode);
}

void ProtocolPlugin::callcloseprotocolplugin(void)
{
	return (*closeprotocolplugin)();
}

int ProtocolPlugin::callprocesspacket(bool outgoing, class Socket &incomingsock, char *replybuffer,
	int *replybufferlength, std::vector<struct imevent> &imevents, std::string &clientaddress)
{
	return (*processpacket)(outgoing, incomingsock, replybuffer,
		replybufferlength, imevents, clientaddress);
}

int ProtocolPlugin::callgeneratemessagepacket(struct response &response, char *replybuffer,
	int *replybufferlength)
{
	if (generatemessagepacket)
		return (*generatemessagepacket)(response, replybuffer, replybufferlength);
	else
		return 1;
}
