/*****************************************************************************
 Copyright (c) 2024, Intel Corporation

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

     * Redistributions of source code must retain the above copyright notice,
       this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
     * Neither the name of Intel Corporation nor the names of its contributors
       may be used to endorse or promote products derived from this software
       without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*****************************************************************************/

/* SM4-CTR */
#include "cipher_test.h"
const struct cipher_test sm4_ctr_test_json[] = {
        /* Generated vectors by 3rd party library */
        { 128, 128, 1, "\xca\xa9\x35\x88\x36\x94\xf6\x7b\x8a\x58\x4d\xed\x0a\xa0\x42\xa3",
          "\x4f\xae\xca\xe5\x31\xaf\xc0\xed\x41\xf4\xaf\xe4\xb4\x3a\x68\xcd",
          "\xf1\x7b\xe7\x3b\x74\x08\x40\x66\xd1\x5f\x0f\x9e\xd6\xcf\x29\xd3\x25\xc1\xe9\xce\x6e\x61"
          "\xe7\xf4\x7c\xcf\x2c\xe7\x22\x04\xb5\x07\x83\x5a\xf3\x3e\xb1\x07\xa2\x71\x31\x4a\x65\x8c"
          "\x76\xbd\x53\xff\x7f\xbd\x03\x08\x25\x7f\x7e\x16\x0f\xd2\x41\x06\x07\x52\x06\xf3\xff\x36"
          "\x37\x68\x2e\x59\x33\xfd\xe3\x94\xea\x81\x82\x30\x16\x4b\xea\x28\xeb\x3d\x1f\x52\x3c\x62"
          "\x96\xcf\xee\x91\x4c\x54\x28\xda\xdd\x6a\xa9\xad\x88\x84\xce\xd3\x68\x2d\xd8\x4e\x3f\x89"
          "\x42\x20\xe2\x3d\x37\x4d\x51\x71\xc0\xf1\x11\xaa\xd7\xe3\xdd\x03\xfa\x65\x3e\xfa\x38\xe6"
          "\x6c\x2a\xf4\x2c\xb0\xca\x71\x5a\x54\xc5\xb5\xfc",
          "\xb6\x50\xbf\x08\x91\x0f\xd5\x96\xe0\xe2\x68\xeb\x3c\xfe\x92\x9e\x79\xb6\x6d\x74\x29\x8c"
          "\xc0\xe6\xe1\x55\x15\x1a\x44\x94\x92\x64\xc8\xe5\x58\xcb\x0a\xc8\x53\x62\xfd\x02\x91\x05"
          "\x4c\x66\x17\x51\xd9\xbb\xf8\xda\x1b\x36\x3e\xa2\xae\x47\x77\x7e\xde\x10\xad\xda\x51\x76"
          "\x7e\xae\x49\x1f\x64\xb8\xfb\xd6\x94\x4a\xac\x14\xb8\x32\xa4\x88\xaa\x63\x8a\xfd\x82\x68"
          "\x0d\xba\x05\x77\x3f\x10\x89\x4b\x6d\xb8\x08\xca\x55\x24\x42\x44\x69\x0e\xb8\x0d\x9b\xe4"
          "\xf0\xf6\xe7\x5b\x0d\xa8\xd9\x06\xa3\x94\x46\x62\x8e\xb7\x50\x2b\x0b\x63\x6d\xb6\xb0\x70"
          "\x43\x6f\xa2\xae\x68\x91\xbd\x8d\x55\xab\xd7\xa9",
          1, 1152 },
        { 128, 128, 2, "\xad\xbf\x8a\x12\x67\x86\xa5\x61\xb9\x03\xef\xa4\xfe\x8d\x97\xe4",
          "\x1c\x6a\x0c\xa0\x5d\x5d\xdc\xf1\x37\xf0\xca\xbe\xc2\x91\xe7\x14",
          "\xcc\x03\x2f\xf4\xfb\x25\x0e\x5d\xe9\xec\x00\x14\x57\x99\xb0\xc6\x05\xa0\xfa\x01\x8f\xcf"
          "\x82\xd8\xf0\x1e\x3a\xcd\x3b\xfd\x25\x71\xb4\x02\xa9\x5b\x17\xc4\x8b\x7a\x40\x2d\xc0\x4b"
          "\x26\xe4\x45\x47\x72\x08\x5f\x20\x7e\x8d\x02\x7a\xd5\x66\x06\x8f\xa7\xbc\x11\xb8\x59\x57"
          "\x39\x9a\xd4\xbd\xe5\xbb\xf4\xf1\xcc\x58\x6e\x3d\xce\x73\x73\xe9\x30\xf1\x83\x26\x7e\xeb"
          "\x8a\x16\xa5\xb6\x40\xa7\x92\xa1\x9b\x29\x15\x3b\x1b\xfc\x29\x6e\xc4\xc5\xa7\x1c\xef\xba"
          "\x2f\x10\x59\x2e\xd7\x19\x0e\xdf\xe5\xe0\x17\xfc\x7c\x0d\x61\x7c\x34\xc3\x91\x76\xf2\x0f"
          "\x64\xdd\x83\x7e\xb7\x4a\x98\x0a\x5e\xe0\xba\x48\xd4\xc7\x91\x86\xad\x94\x73\x37\x14\x2e"
          "\x60\x24\x28\xcf\xfd\x5b\x96\x89\x6f\xae\x4b\x9f\x16\x8a\x61\xa2\xef\x71\x7f\xee\xde\x61"
          "\xe2\xe4\x9a\x24\x4f\xe6\x1b\xcd\x3e\xbc\xd8\xba\xe4\x00\xa5\x08\x87\xc8\x7b\xa1\xc2\xf9"
          "\x58\x44\x19\x87\xd3\x43\xd9\x1a\x2f\xba\x3f\x2b\x3a\x8b\x4d\x61\x84\xe1\x36\xfe\x9e\x35"
          "\x79\x86\x37\x4a\x61\xea\x12\x4b\xa8\x0c\xc4\xf8\xd7\x20\xd6\x71\xc0\x5f\x13\x30\x2c\x6c"
          "\xac\xc4\xf1\x0c\x69\x23\xc2\x32\xfa\x82\xe1\x49\xda\x2e\x2c\x9a\xc4\x87\x4c\xdc\x45\x42"
          "\x0f\xc7\x27\xb8\x5a\x32\x09\x70\xe5\x46\x62\xa0\x34\xce\x5b\x8d\x57\x57\xd0\x1b\x8b\x96"
          "\xd7\x38\x25\x44\x51\xd6\x88\x10\x28\x5f\x76\xb3\xad\x45\x27\xce\x35\x78\x51\x8a\x38\x94"
          "\x21\xa4\xb3\x67\x3e\x4a\xac\x5b\x89\xec\x2a\x83\x2e\x7e\x93\x2b\x56\xb4\x0b\xce\xc6\x4d"
          "\x6a\xde\x76\xc6\xca\xe0\x57\x5e\x2c\xd0\xc3\xa6\x1f\xff\xe6\x36\x44\x6a\xc5\xc0\x87\xeb"
          "\x1a\xe5\x0d\xc4\x54\x60\x36\x14\xfa\x6b\xb3\x29\xaf\x6a\xe9\x8a\x50\x2d\x8f\x9b\x6b\xdd"
          "\x26\xa5\xa1\x7c\xab\xa6\x27\xf1\xcd\xf2\x83\xad\xa1\xf5\x55\x56\xdc\x72\x2b\x85\x74\x6a"
          "\xd0\x2b\x6c\x79\x4a\x93\x97\x39\xfc\xa1\x65\x96\x3f\xa7\x24\x18\x2e\xc1\xaf\xae\xe1\xb9"
          "\x70\x48\xa8\xbe\xf3\x0b\x73\x1e\xfb\x64\x9a\x28\x58\x55\x2c\xe2\x99\x4c\x33\x3d\x3e\x06"
          "\x69\x9f\x76\x42\x1f\x48\x99\x9f",
          "\xfd\x88\x21\x55\x93\x20\x3b\xcd\x31\x0f\xb3\x58\x10\xc7\x6a\x1b\xc1\x2d\x6f\xcb\xbc\x2c"
          "\xca\xc3\x32\x24\x47\xbf\x3a\x84\x2b\x4c\xae\x8f\xab\xad\xb9\x9f\x7b\xcb\xc7\x0a\x11\xe8"
          "\xbb\x1f\xf7\x49\xb3\x7a\xe1\x8a\xbb\x52\xaa\x19\x5e\x9e\x9a\x9e\xa6\x89\xeb\xbd\x19\x8d"
          "\x6d\x4e\xb8\x9d\x69\x86\xc9\x57\xc8\xc0\x5b\x69\x4d\xe7\xc9\x29\xde\x1d\x54\xd7\xd0\x68"
          "\xd4\x31\xf9\x48\x95\xde\x65\x9e\xf2\x29\x8d\x32\xa2\xbf\xf3\x94\x3b\xae\xc9\xe3\x60\x6e"
          "\xb7\xbf\x3d\xe9\x87\x65\x35\xfc\x3f\x80\xc2\xa4\x5f\x67\x84\x34\xad\x32\xff\x66\x1d\x00"
          "\xf4\xfc\x55\x62\xed\x44\x9a\x37\x7e\x44\x3c\x56\x9e\x10\xdd\xb8\x5d\xdd\x9c\xee\xf8\x62"
          "\xea\x96\x1a\x17\x6c\x7b\x47\x86\xb0\xfe\x64\xc1\x86\x98\x37\x37\x2d\x50\x74\x35\x57\x9c"
          "\x15\x28\x4a\x5e\x57\x6c\x02\x76\x40\xcc\x35\x2d\x30\x4e\x8e\x61\x80\x54\xc7\xbe\x00\x3d"
          "\xd4\xda\xc6\xb8\x0a\x9c\x45\x49\xee\x39\xd7\x6b\x84\xaf\x81\x84\xbe\xaf\xca\x73\x42\x45"
          "\x54\x80\x00\x64\xd9\x8b\xb0\xff\x23\x15\xf3\x85\x9f\xe7\xac\xfa\x0c\x24\x07\x0e\x1f\xec"
          "\x8b\xc8\xbf\xc8\x49\x4a\x41\x23\xe6\x90\x7e\xc7\x24\x81\x1f\x7e\x45\x16\x28\xf4\x43\xf8"
          "\x56\x3a\x65\x73\x33\xf5\x2e\x05\xd4\xbd\xea\xfd\x28\xe3\xc9\xdc\x2f\x0c\xa8\x77\xb7\xad"
          "\x5c\x6a\x43\x16\x85\xef\x04\xb4\x83\x64\x27\x57\x46\x18\xa5\x94\xfe\xde\x05\x6f\xca\x8d"
          "\xb5\x84\xbb\x6a\x66\xd9\x96\xd5\x21\xa1\xf2\x3e\x67\x72\x32\x3c\xc6\x06\x2f\x7e\xe5\xf3"
          "\xb3\xd2\xdb\x58\x2f\x5f\x1b\xea\x74\x80\xe1\x81\x62\x75\x7c\x28\x38\x57\xf8\x6b\xa7\x6f"
          "\xa7\xdd\x61\xce\x89\x64\xbb\x6e\x30\xaa\x1f\x88\x13\x57\xc3\xae\x00\xc0\x8f\xae\x04\x5b"
          "\x30\x0b\x63\xb9\x0b\xd6\xc6\x34\x56\xeb\xc7\x22\x61\x2e\xbb\x29\xce\x17\x6b\xbb\x47\x53"
          "\x40\x43\x06\x5d\xe5\xb3\x57\xa4\xcd\x9f\x29\x2c\x58\x67\xde\x8c\x61\xb8\xf0\xae\xfe\xbe"
          "\x30\x8d\xec\x79\x25\x13\xa4\x94\xf3\x3e\x0d\xac\x77\x7c\x62\x51\xdb\x9b\x87\x64\xe8\x66"
          "\xfb\x46\x21\x3d\xe6\xd5\xeb\x06",
          1, 3584 },
        { 128, 128, 3, "\x3f\xb0\x1d\x37\x23\x35\x05\xc7\xdb\xd5\xff\x66\xac\xd4\x0f\x8b",
          "\x5c\x18\x23\x68\xab\x42\xfd\x27\xee\x08\x42\xae\x63\x92\x42\x27",
          "\x97\xbb\x5b\x7d\x64\x31\x91\xfc\xaa\xb1\x12\x21\xc7\x43\x80\x95\xfb\x73\x21\xab\xfc\x1c"
          "\x16\x6a\x88\x32\xbb\xef\x16\x30\x81\xf7\x4b\x06\x74\xa8\xba\x9c\xac\x2e\x13\x62\x49\x33"
          "\x2f\xa4\xae\x63\x8f\xf8\x0e\xd5\x9a\xc9\x87\xbb\x30\x63\xad\x07\x4a\x1f\x44\x2a\x4f\x69"
          "\x29\x9b\x98\x84\x17\x2a\x9a\x6f\x4d\x7c\x6b\x5e\x35\x76\x32\xdd\x97\x86\x65\xf6\xf4\x70"
          "\x5c\xc4\xb4\xc9\xf2\xb3\x78\xe2\x1c\x46\xd6\xda\x0f\x33\x1a\x6a\xec\xdf\xda\xc3\xa6\x34"
          "\xce\xad\x93\xe5\x7b\x81\xcc\x57\xcb\xab\xd6\x59\xa1\xbe\x95\x0c\xf1\x94\xb1\xdf\x03\x24"
          "\x26\x42\xe3\xfc\x4f\xec\x4f\x6f\x8d\xf6\xbe\xe8\xc1\x8a\xb9\x0e\xfb\xa4\xae\xa9\x12\x40"
          "\x25\x5e\xab\x5c\x5b\x1a\xe5\x09\x40\x9e\x39\x67\x9b\xb7\xc1\x79\x21\x88\x6a\x55\x29\xf4"
          "\x68\x3d\x78\x61\x40\x52\xb7\x38\xf0\x66\x0b\xcf\x85\xf7\x3e\x48\xee\x7d\x7f\x47\xbf\x53"
          "\xc8\xd4\x49\xfe\xd7\x19\x15\x07\x31\x2c\x2b\xa7\xda\x0d\xc2\x2a\x5f\x1b\xbd\x06\xdd\xd9"
          "\xf3\x6e\x6e\xc3\x53\xbb\xa3\x04\x99\x22\x49\x92\x15\x37\x42\x3e\x20\xc2\xf7\xd3\x7f\x09"
          "\x45\xc4\xce\xab\x69\xc1\x6e\xbe\xc9\x2d\xa7\xaa\x1f\xc5\xbf\xa4\xa9\xc1\x17\xd5\xf0\xe6"
          "\x88\x41\xd0\x12\xa3\xe6\xe1\x8c\x10\xd3\x5d\xaa\x43\x86\xac\xea\xc8\x92\x0d\xf7\x8a\x42"
          "\xaa\xdb\x88\xa8\x4b\xe7\x5d\x27\x46\x5d\xc0\x18\xe3\xc9\x85\x55\xea\xa6\x52\xd1\xab\xda"
          "\xf2\xf4\x98\x44\x41\xcb\xaf\x68\xa7\xa6\x10\x5f\xa4\xd8\x8c\xf6\xd3\x2d\x58\x2a\xa9\xce"
          "\x34\x42\xde\x8e\x77\x3f",
          "\x05\x90\x6a\xb2\xc6\x73\x7f\x80\xf3\x4f\xae\x3a\xff\xe6\x6e\xd6\x71\xc1\x04\x1d\x1f\x36"
          "\xa0\x51\x53\x8b\xd1\x95\xa5\xc9\x38\x7d\xbc\x57\x89\xd6\x6e\xdf\x2c\xa2\x18\xa9\xe8\xea"
          "\xc1\x51\x93\x53\xb0\xe7\x4c\xe4\x5e\x1b\xeb\x19\x25\x90\x2a\xb4\x11\xd7\xe0\x7a\x35\xdf"
          "\xf8\xf9\x4f\x5e\x8f\xa6\xcc\x39\x7d\xbf\x0b\x15\x93\xf8\x3c\x38\xdb\x21\xe0\x86\x30\x4c"
          "\x37\x1b\x0f\x39\xec\x52\xa7\xc9\x8e\xd6\x3e\x8c\x0b\x0e\x44\x74\x50\x30\xbb\xaa\xa9\x81"
          "\xf7\xd8\xfa\xdd\x87\xf8\x9a\xef\x01\xa0\xf5\x34\xc9\x45\x00\x97\x8d\xd3\x73\x43\x40\x4e"
          "\x4e\x44\x12\xd1\x41\x86\x4f\x2c\xe5\x46\xf7\xfc\xad\xc3\x46\x12\x99\xff\x49\xaa\x63\x80"
          "\x2a\x6c\xef\xeb\x94\x6c\x4d\x39\x75\x6e\x22\x22\xeb\x57\x13\x42\xae\x50\xf8\xcc\xe2\x31"
          "\x55\xfc\x3b\x72\x8c\x18\x2f\x17\x65\x8a\x06\x4d\x0d\xe8\xc0\xb0\x98\xbc\xbd\x22\xb2\x50"
          "\x2f\xbb\xc0\xa8\xee\xb2\xb2\x74\x62\xc0\x29\x86\xf7\xea\x3f\x6b\x8a\x1e\xad\x68\x5b\x99"
          "\x53\x78\xf5\xde\xdc\x81\xd9\x01\xfa\x02\xf2\x2e\xf8\x61\xf4\x13\xf4\x98\xf5\x0f\xae\x2e"
          "\x70\x3c\x9d\x14\x76\xf4\xaa\x3d\xb4\x09\x3a\x87\x71\xda\x57\x17\xa4\xdc\x4e\x5c\xed\x7a"
          "\x70\x42\xad\xb3\x40\x5c\x81\xd7\xad\x82\x96\x27\xff\x61\x2d\xf6\x6e\x41\xf7\x55\x30\x07"
          "\xf4\xa3\x36\xe8\x09\x22\xc7\x23\x5d\x8b\xe5\x28\x2a\x17\xf4\x81\x70\x4e\x93\x1d\x2d\xc6"
          "\xe4\x30\x9c\x60\x75\x0a\x55\x56\x85\x21\x3d\xaa\x30\xee\x01\xf7\xa1\x71\xfb\x07\x8b\x2c"
          "\xc2\xcd\x92\xfe\x23\xd7",
          1, 2688 },
        { 128, 128, 4, "\x47\xf7\x0d\x29\xea\x26\x0b\xb2\x26\x87\x7e\xf8\xbc\x9c\x75\x2a",
          "\x7a\x84\xaa\xb9\x18\xb0\xb9\x47\xa4\x46\x43\x56\x9b\xfd\xe1\x52",
          "\x0f\x19\x17\x79\xda\xcd\x7a\xeb\xd0\x44\xef\xc0\x45\xc6\x07\xe7\x01\x31\x0a\xde\x61\x6f"
          "\x7b\x56\x06\x6d\x08\x95\xed\xc9\xcc\xb9\x0c\xa9\x11\x97\x46\x04\x0d\xee\xe7\xc0\x74\x07"
          "\xa2\x8c\x45\x06\x40\xec\x58\xd7\xd1\x19\xc4\x11\xa6\xb9\xe1\xe1\xdc\x0a\xbf\xfe\x08\x89"
          "\xb5\x7c\x5c\xca\x75\x85\x57\x77\x33\x81\x09\x32\x78\xca\xdd\x46\x95\x63\xe8\x85\x83\x35"
          "\x68\xb8\x8c\xd5\x17\x56\xe7\xfc\xe1\x3e\x2a\x4a\x44\x9a\x2c\x4b\xe2\xe8\x97\x46\xee\x6a"
          "\xa3\x4d\x3d\x08\xb4\x71\x44\xb7\x0a\x22\x2f\x6f\x6e\x87\x2a\x37\x52\xbf",
          "\x36\x81\xd8\x6f\x1e\xe3\xe9\xc8\x50\xe3\x7c\xfc\x24\xea\x1e\x34\x4d\x9c\x23\x1e\x0a\xf0"
          "\x51\x0e\xf2\xae\x26\xba\xf4\xb5\xcf\x24\xd2\x46\xb0\x65\x97\x1c\xc7\xab\x69\xfb\xf1\x73"
          "\x51\x53\xfc\xdc\x15\x65\x47\x70\x1c\x01\xef\x6b\xe4\xde\x56\xb6\xfd\x96\x44\x6f\x11\x60"
          "\x67\x6a\x79\xc8\xca\x6c\x8d\xbf\xd4\xc4\xb6\x97\x92\xc5\xc9\xff\xe0\xe3\x39\x89\xee\x57"
          "\xb7\x78\x1c\x67\x46\x6a\x97\xef\x0c\x21\xf4\xf1\x57\x5d\x35\x89\x9d\xdb\x37\x8c\xec\x09"
          "\x61\x88\xd1\xb9\xc7\xc3\xd4\x97\x6f\x45\x5b\x1a\x3e\x11\x93\x36\x6d\xf1",
          1, 1024 },
        { 128, 128, 5, "\x91\x86\xe6\x0e\x44\x18\x41\x86\x7d\x0a\xba\x03\xe7\x28\xc3\x9b",
          "\x05\x28\x94\x0d\x83\xd9\xe2\x78\xf1\x79\x1f\x20\x53\x29\x06\xa0",
          "\xbe\x44\xe8\xb9\x6a\xf2\x97\x5d\xb4\xe8\x20\x4c\x1a\x49\x0f\xb6\xb4\xcf\x31\x7b\x56\xbb"
          "\x53\xb6\xf4\x01\x2d\x02\xa2\x75\x7f\x1c\x51\x25\x27\xbb\xe5\x86\xe4\x0f\x3c\x63\x62\x21"
          "\x31\x68\x25\xca\xca\xa7\xc7\xaa\x7c\x34\xf9\xce\xb8\x95\xd5\x73\x04\x18\x40\x21\xdc\x79"
          "\x66\x64\x27\x9c\xc0\x34\x84\x3b\x74\xc0\xc8\x4c\x25\xaf\x0f\xa5\x57\x73\x48\xc6\x02\xb8"
          "\x33\x4f\xd9\x0d\x23\x4e\x7b\x91\x03\x3a\x5c\x34\x56\x51\xa2\xf1\x2c\x6e\x9b\x9f\x23\xf4"
          "\x1d\x55\x26\xee\x9d\xc6\xd0\xf4\x2b\xd5\x75\x45\x28\x17\x43\x17\x00\xf4\xa6\x05\xd4\x91"
          "\x76\xe9\xc7\x1b\x50\xea\x2c\xd6\x1d\xfd\x14\xa9\x70\x0b\xe9\xff\x7c\xad\x73\xb6\x62\x4a"
          "\xd2\x87\xcd\xb3\x6d\x98\xa2\x48\x85\x67\x98\xa9\xdd\x2e\xd9\x9d\x88\x3d\xee\xe9\x42\xcb"
          "\x17\x9d\xf1\x5e\x5e\x78\xaa\x33\x42\x2c\xdf\xe2\xa4\xba\xb9\x13\x44\x8d\xa9\x69\x03\x7f"
          "\x97\x67\x43\x30\x2c\x2f\x75\x46\x40\x3e\xfc\x5f\xab\xb1\x3c\x7d\x51\xdb\xd6\x3c\x29\x84"
          "\x99\xe3\xf1\x64\xdb\x3c\x80\x08\x50\xa7\x2c\x1e\xb5\x6c\x17\x20\x59\xf1\x46\xb7\xfe\xb7"
          "\x61\x65\x85\xd2\xc9\x68\x50\x7a\x91\xe6\x13\x77\x5c\x0d\x63\xd1\x07\x9d\x6e\x1e\xa7\x86"
          "\x2d\x34\x04\xa7\xe8\x08\x76\xd1\x3e\x99\x67\xa9\x21\xd0\xea\xa2\xdb\xf1\x58\xd9\x12\x06"
          "\xb1\x77\x66\x9c\xf5\xa1\x24\xea\xae\xed\x6d\x80\x79\x0c\xaf\xbe\x9a\xe5\x11\xb9\x8f\xec"
          "\x5d\x0e\x0b\x83\xb3\x32\x41\x99\x24\xa8\x7a\x26\x24\x5c\x0d\x23\xa5\xc5\x83\x1d\xc3\xda"
          "\x2b\x8e\x79\x6c\xd9\xfc",
          "\xc4\x6f\x5d\xae\x18\xed\x56\x46\x31\xa6\x4a\x98\x4a\x41\xd3\xa1\xd5\x78\x8a\x01\x87\x36"
          "\x44\xf7\xad\x52\x0a\x0a\xd5\xdc\x2d\x5c\x09\x69\xba\x32\xb4\x87\xa2\x05\xd4\xe7\x54\x4e"
          "\x01\x04\xd1\x31\xc9\xf3\xf2\x10\xa5\xcf\x0e\xd5\x5f\xeb\x37\xe8\x37\x65\x5b\xde\x32\x43"
          "\xfb\x4c\x9c\x04\x22\xcb\x23\x20\xcc\x74\xa6\xef\x5f\xcc\x6d\x18\x31\x4a\x39\x08\x06\x13"
          "\x12\xc7\x60\x62\x23\x48\xb4\x1f\x55\x00\x4f\x59\x28\x04\xcd\x0e\x7b\xd2\x6f\x96\xc8\x72"
          "\x81\x47\x07\xdb\xde\x7d\x91\x6c\x94\xeb\x6e\xa1\xbe\x7d\x1e\x9c\x8d\xd3\x21\xc9\xbd\xe4"
          "\x95\xd2\x81\x60\x2d\x19\x9c\xfa\x63\x8d\x2b\xb1\xae\xf3\x55\x71\xae\x89\x9b\x0e\xc0\x83"
          "\x2f\x7e\x8c\x3d\x39\xe4\x1c\x89\xf4\xf2\x50\x36\xcd\x9f\xf7\x3c\x89\xeb\x51\x42\x04\x4a"
          "\x98\xaf\x2b\xbf\xc7\xc0\xfc\xd3\x18\xe1\x76\xbd\xdd\xed\x27\xca\xe8\x3c\x82\x9b\x5e\x44"
          "\x55\x9c\x64\x54\x6f\xdc\x7b\x55\x5e\xe5\x7c\x6d\x51\x7e\xbc\x37\x30\x00\xa2\x3c\xc4\x15"
          "\x1c\x62\xe7\x77\xda\x09\xa0\xb6\x1e\xd0\x51\x6f\xa6\x17\x7d\xe1\x0c\xc6\xf4\xa9\x15\xe7"
          "\x99\x3e\x11\x8b\x1f\x77\xa1\x37\x12\x18\x01\x7d\x21\xf9\x9f\x1d\xe0\xbb\x1b\x64\xd1\x76"
          "\x6e\xf9\x4f\xb1\x36\x9b\x41\x1d\x02\x66\x4e\x49\x8e\x97\xda\xa5\x26\x11\xba\x8f\x85\x1a"
          "\x4f\x60\x3a\xc9\x33\x68\xeb\xfe\xbb\x9e\x60\x08\x29\x2a\x0d\x4a\xa4\x2c\x09\x80\x5c\x33"
          "\xdc\xc5\x98\x83\x2e\xaa\x24\xed\xa0\x0a\x52\x3d\x46\x6a\x78\x5b\xfb\x4b\xa2\x7d\x0c\xa6"
          "\xec\x7d\xc7\xc0\x17\x7a",
          1, 2688 },
        { 128, 128, 6, "\xb5\x0f\x19\x37\x04\xd9\x31\x23\x00\xc2\x4d\x18\xcf\x11\x34\xb0",
          "\x1d\x1e\xd8\x7c\x66\xb0\x27\x47\x30\x5c\x54\xc2\xc9\x41\x69\x75",
          "\xe7\x13\x76\x61\x90\xe4\x7f\xdf\x42\x72\xe1\x7d\xe3\x0a\xfd\xb4\x87\x6c\x2f\x13\x80\x62"
          "\x32\xfb\xd0\x61\xfe\x3e\x1c\x7f\x5b\x2a\x43\x9a\x63\xbc\x33\xca\x7d\xc0\xfa\x2b\x17\x79"
          "\x13\xf3\x1f\x10\xec\x42\x52\x8f\xe2\x17\x5d\xd1\x99\xdb\x9c\xbf\x85\x58\x59\x01\x2d\xf1"
          "\x10\x22\xbf\xd0\xa4\x05\x92\xb9\x0d\x08\x3b\xbd\x5e\xe1\xf0\x67\xd8\xef\xa5\xab\x1c\x9b"
          "\x9a\xfc\x6b\x2f\xee\x89\x2e\x42\x27\x17\x9c\x2a\xd0\x19\xba\x45\x82\x6b\x16\xa9\x29\xcf"
          "\xcb\xf9\x51\x21\xab\x47\x00\xa7\xa4\xe1\xe7\xe4\xc6\xde\x3a\x48\xe9\x64\x0f\xb9\x40\xbd"
          "\xb9\x30\x9c\x27\x5f\x59\x18\x1b\x72\xf3\x6e\xac\x5a\x57\x24\xab\x97\x4d\x72\x59\x24\x79"
          "\x8a\x33\xb3\xbe\xb3\x46\x6a\x0c\x11\x04\x9e\x56\x05\x7e\x1f\xe3\xc8\xc3\x70\x80\xd5\xf9"
          "\xdc\x32\x70\xa0\x4e\x43\xa5\x65\xd8\xb8\xb2\xd0\x45\x35\xd8\xfe\xfa\x6a\x4e\x90\xb3\x5e"
          "\x25\xe4\x26\xcc\xad\x7f\xd1\xa3\x7e\xa8\xa7\x07\x7a\x48\x06\xfd\x44\x16\xf4\x64\x8f\xbb"
          "\xc3\x7e\xbd\x8a\xb7\x00\x63\x5b\xcb\xd5\x23\x31\x76\x92\x77\x17\x7a\xdc\x5a\x32\xf5\xb2"
          "\x96\x5b\x9e\x50\xa2\x04\x3c\x13\x17\xde\xa4\xc3\x68\x4f\xfd\x9a\x59\x92\x26\x27\xc8\x57"
          "\x44\x80\xa0\x05\x42\xca\x79\x17\xde\x8c\x2f\x06\x43\x4b\x70\xb9\x62\x3c\x17\xae\x77\x1a"
          "\x67\x6a\x78\xb6\xc3\xd2\x78\x0d\x6a\x0a\x64\xfc\xb6\xc7\xc7\x0c\xb8\x4d\xae\x07\xd7\xe5"
          "\x77\xcd\xb9\x5a\x32\x57\x27\x21\x1c\x2c\x0e\x54\xb3\x09\x4e\xc2\x7a\x15\x15\xf0\xf6\xfe"
          "\x69\xed\x71\x26\xad\xbd",
          "\xf1\x87\xeb\xbb\xa2\x3a\x7e\x82\x4e\x13\x62\x34\x41\xe1\x88\x83\x37\xbd\x25\x34\x53\xbc"
          "\x3a\xd8\x73\xcf\x42\x8a\x5c\xa4\x2c\x02\x18\x93\xd1\x7b\x47\x43\x92\x73\x55\x3f\xd2\xf6"
          "\x2c\x14\xac\xa3\x73\xf6\xdc\x1a\x40\xfa\xce\xf5\xe5\x69\xc7\x32\x26\x92\xe9\xfd\x50\x84"
          "\x24\x9b\x8c\xf7\x55\x48\xab\xc8\x32\xa8\xa7\x25\x55\xdb\x00\x36\xaf\x3b\xef\xfe\x3b\x06"
          "\x45\x1b\x54\x87\x3c\xa1\x04\xc2\xc9\xcd\xa7\x95\x90\xba\xaa\xb6\xc0\x1b\x8c\xf1\xff\x2c"
          "\xcf\x1c\x27\xc4\x72\xc2\x87\x60\x07\xf2\xb8\x3b\xf3\x68\x22\x1c\xd6\xef\xb9\xbc\xfc\xca"
          "\x63\x51\xe4\xdf\x49\x20\x97\xc1\x82\x82\xb4\x57\x81\x2d\x4c\x78\x51\xed\x2f\x4b\xcb\xd2"
          "\xf6\x79\xff\xe9\xd8\x18\xf7\x8d\x0b\x2e\x38\x7a\xa0\xf1\x8b\x25\xe8\x51\xbb\x61\x70\x70"
          "\x58\x3a\x31\xc5\xe9\x45\xdd\x75\x71\xb7\xb6\xeb\x8a\x13\x84\x1b\x63\x7b\x66\x2a\x98\x43"
          "\x1d\x8c\xf9\x8d\xef\x6b\x81\x91\x05\x68\x13\x38\x67\x3c\xd6\x6a\x02\x05\xe6\xa3\x25\xbb"
          "\x96\xe7\xee\xba\xdd\x1f\x6f\x93\x9b\xf7\x29\x1d\x05\x73\x02\x91\x9d\x9a\x6e\x86\xa6\xed"
          "\xd7\x0d\x3f\x7d\x94\xe4\x32\xaf\x1a\xe2\x09\x9a\xd1\xa2\x95\x25\x1b\x9b\xcd\xd9\x54\x14"
          "\xdb\x89\xf5\x22\x31\x25\xcf\x91\x60\xcd\xdf\x1d\xfb\xb2\xe6\x74\x61\x34\xcf\xfc\xfe\x24"
          "\xe6\xf4\xd3\x3d\xe6\x41\x6a\xc7\xb9\xf4\xaf\xc6\xb0\xe4\xf9\xf7\x39\xc7\x21\x27\x8f\x6b"
          "\x46\x14\xdf\xa7\xed\xb7\x27\xc1\xd1\x0a\xc4\x8d\x5d\x30\x82\xdc\xe7\x2f\x93\x21\x9c\xa8"
          "\xd3\xe6\x75\xaa\x4d\x9e",
          1, 2688 },
        { 128, 128, 7, "\xb9\x23\xa6\xc3\x88\xd4\xc4\xa2\x9d\x17\x8a\x66\x3d\x06\xf4\xea",
          "\x7e\xc6\x12\x36\x38\xb2\x95\xaa\x77\x2c\xf3\xe4\x4b\xb8\x0c\x3a",
          "\xbb\x43\xda\x16\xbb\xac\x08\xcf\xf2\xa0\xdb\x50\x31\xdf\xd0\x5e\xc7\x24\xa2\x86\x6e\xd8"
          "\xac\x2a\x74\xe5\x74\x38\x3e\x50\xad\x44\x7a\x06\xac\xad\x8f\xc7\xbd\x45\xee\x0c\x50\xa8"
          "\x1f\x11\xd9\xec\x7c\x5b\x00\xd3\x3d\xa7\x64\x0e\xc9\x76\x6f\x12\xa1\x74\x75\x44\xa6\x9d"
          "\xd2\x64\x50\x51\x1d\x1d\xde\xe8\x88\x41\x36\x0b\xf8\x56\x9e\x29\x81\x71\x40\xf1\x61\x06"
          "\x72\xcf\xdc\xe4\x91\xdc\xb9\xf2\xf1\xe9\xe2\xf0\xa2\xd1\xc6\x89\xb5\xf6\xe4\xe3\xba\x4c"
          "\x50\xbf\x06\x97\x24\xa9\xdd\xdf\x5a\x60\x0b\x31\x51\x5d\x4f\x33\x8c\x0e",
          "\x4a\x8b\x38\xbe\x36\x8f\xc9\xda\x62\x43\x3a\x42\x32\x71\xd5\x43\x6a\x6b\x32\x30\xdb\x46"
          "\x7f\xc2\xa9\xcc\x26\xbf\xc6\x4c\x08\x7e\x42\xc5\x34\x0d\xac\x05\x0f\x64\x82\x73\xe6\xf8"
          "\xa8\x64\xa5\x7c\x13\xac\x8f\xca\x6e\x82\x8f\xa8\x1d\xc2\x3c\x85\xf5\x96\x70\x0f\x66\xc3"
          "\xfb\x49\x35\x11\xe8\xb3\xe8\xf5\x45\x4b\x73\x3b\xc7\xce\x37\x9c\x69\xf5\x58\x13\x02\x38"
          "\x0e\xed\x12\x22\x91\x89\xaf\x8d\x77\x93\x5a\x38\x72\x8f\x18\x93\xca\xd4\x54\xa2\x68\x57"
          "\x06\xc0\x19\xb6\xe1\x44\x1f\x7d\x61\x15\x81\x6d\x38\x0f\xdc\x8e\x06\x7f",
          1, 1024 },
        { 128, 128, 8, "\x37\xa4\xcb\xdc\xca\xc4\x12\x8e\x67\x37\x39\x38\x10\x1f\xe9\xa8",
          "\xb9\x6e\xf0\xb4\x4e\x8a\x46\x52\x62\x76\xcf\x57\xba\x07\xff\xff",
          "\xe6\x73\x12\x8a\xac\xdb\x6f\x5c\x8d\x37\xbd\x84\x7e\x08\xd7\x88\x91\xeb\x34\x58\x76\x1e"
          "\x39\x16\xa9\x8e\xe4\x26\x27\x01\xf8\x43\x7a\x82\x64\xac\x78\x16\x7c\x09\xd5\xb2\x18\x8b"
          "\x18\x7b\x15\x1e\xce\x5c\x04\xce\x0a\xd6\xa9\x23\xf5\xef\xc7\x99\x8e\x95\xcd\xb7\xc5\xc6"
          "\xbf\x11\x9a\x63\x18\x6a\xe6\x62\x64\xc6\x6b\x83\xd8\x9b\xf0\x6b\x7e\xa5\xe8\xcc\x0f\x45"
          "\x62\x09\x27\x57\xbd\xdb\x95\x9c\xdd\x19\x21\x3a\xc2\x6c\xfd\x11\x47\x18\x95\x84\xa1\xb8"
          "\xf6\x26\x30\x1c\x67\x4e\x5a\xeb\xdf\x7a\x1c\xce\x62\xe8\x64\xb9\xe4\x5f\x50\x5a\x9f\x69"
          "\x9a\x63\xcd\x2e\xcb\x8a\x04\x55\xf9\xb8\x62\xb6\xc8\x38\x8a\x66\x2c\xe4\xd3\x04\xb6\xae"
          "\x05\x90\x05\x32\xdf\x57\xec\xc0\x67\xd6\x43\xf7\x6b\x74\xc2\x8f\xb3\xc0\x28\x44\xa1\x17"
          "\x71\x80\xb4\xbc\xb6\x75\xa8\xe4\x9c\x99\x82\x7a\x93\xb0\x10\x53\xa3\x90\xea\xe5\x98\xf7"
          "\x4d\x38\x1e\x99\xd6\x1e\xd1\x7b\x50\x23\xc1\x69\xae\xb1\x24\xf3\x2b\xb9\x73\x0b\x97\x25"
          "\xc6\x7d\x94\x56\x4f\xb5\x58\x56\xd1\x51\xc3\x87\xb3\x1c\x20\x47\xcc\x1f\x82\x11\xa0\x2e"
          "\xfd\xdb\x6e\x7e\x66\x1c\x4b\xd1\x9e\xf5\x2d\x8b\x11\x47",
          "\x37\xa0\x64\x28\x2d\x37\x40\xfe\x18\x19\xab\x65\x8a\x80\xd2\x56\x2d\x72\x61\xe8\xa3\xd4"
          "\x83\xe2\xc1\x99\x66\x2d\x23\xfe\x75\xaa\x6b\x1f\xb2\xb5\x1d\xf6\x66\x73\x3d\x30\x46\xea"
          "\xdf\xd3\x27\x70\xc9\x6b\x9b\x82\xae\x08\x55\x83\xbe\x78\x35\x97\x3c\x2d\x83\x2d\x97\xbb"
          "\x03\xb9\xa7\x21\x81\x58\xe1\xb3\x31\x64\x90\x2b\x96\xa1\x10\x0b\xf2\xfd\xa8\x4d\xe9\x02"
          "\xa3\x23\x6c\xcd\x3b\x64\x11\x29\xcf\x60\x64\xeb\x77\x98\x63\xc9\xf1\xb6\x11\x14\x8e\x0d"
          "\xe6\x57\xdc\x96\xa9\xd2\x49\xa2\x30\x80\xf9\x3e\x73\x69\xd3\xb3\xe8\x44\xa9\xcd\xb2\x37"
          "\x58\x9c\xa1\x81\x34\xaa\xe6\x3f\x20\xba\xd7\x4a\x5d\x97\x1d\x86\x91\x3b\xe9\x68\x63\xb1"
          "\x6c\x56\x1a\x65\x5d\x82\xe4\x22\x16\xdf\x38\xc7\xc0\x35\x2e\xfc\x15\x62\xe9\xc2\x49\x76"
          "\x87\x65\xff\x1f\x62\xd2\x43\x31\xf7\xfd\xef\x16\x78\xbb\xf4\xe2\x59\x22\xca\xda\x28\x4d"
          "\xf6\x5e\x92\xbc\x4d\x22\x8f\xc8\xf7\x9b\xa0\xb4\x20\xf9\x4a\x5b\x8b\xe5\xa9\x1b\x47\x65"
          "\x72\xc2\xc5\xf4\x1d\x9e\x14\x26\xfe\x1c\xa3\x22\xd0\x5a\xdb\x3c\x50\x21\x58\x5a\xf5\xbd"
          "\xda\xc9\xcc\x8a\x17\x1e\xcb\x58\x25\x2c\x04\xc5\xbf\x87",
          1, 2048 },
        { 128, 128, 9, "\xa4\x5e\x0c\x69\x32\xad\x62\x55\x62\x14\x74\x87\x16\xdd\x34\x93",
          "\x92\x72\x45\xb7\xe1\x4a\x40\xd3\xf3\xf5\x17\x5d\xd3\xc3\x9a\x63",
          "\x6f\x10\x2c\x7c\x75\x35\x16\x87\xdb\x0b\x41\xb1\xbc\xb2\x71\xd2\xef\x8a\x56\x70\x38\x93"
          "\xe5\x79\xb9\x63\x2a\x09\xc3\x35\xe9\xf4\x8d\xb2\x32\xda\x37\x36\x50\x82\x1b\xef\x29\xc5"
          "\xf4\x71\xac\xfb\x7f\x8b\x65\x6d\xf0\xae\x1c\x83\xd0\x88\x72\x90\xc4\xb5\x60\x94\xf7\xcc"
          "\xd3\x8f\x23\x08\xe5\x25\x60\x5b\xd6\xab\xcc\x1a\x7d\x17\xa8\x46\x82\x26\x1c\x30\x13\x60"
          "\xfc\xa6\xca\x8b\x53\x26\x09\xb9\xb1\x0a\x3e\x4c\xb3\x27\x7c\x18\x58\x37\xc2\xd3\x77\x67"
          "\xed\xec\xe9\xd7\x40\xb0\x1a\x93\xb6\x7e\x31\xc7\xa4\x86\x63\x3a\xa3\x28\xb1\xc1\xb2\xb1"
          "\x3e\xe0\x7d\xfc\x14\x2d\xed\xc2\x47\xd3\xaf\xa7\xa8\x0f\x56\xca\xc3\x8b\x4e\x8d\x2b\xa1"
          "\x65\x71\xf9\x1e\xb3\xc5\x53\xd7\x91\x83\x9b\x0d\xf2\x2e\x83\x0e\xa6\x31\xb4\x63\x67\x34"
          "\x23\x3b\xac\x9f\x3d\x2a\xd6\x38\x52\x9a\xfc\x38\x18\x0f\x62\x4d\xe8\x4b\xb8\x7e\x45\x5f"
          "\x28\xfe\x44\xc4\x16\xf9\x1f\x03\x06\x67\xc9\x2b\x3d\x98\xd5\xff\xe6\xdb\x8b\x70\x0f\xaa"
          "\x02\x20\xe9\x83\xeb\x3a\x42\x8e\xc3\x90\x79\xb0\x07\xa3\xf6\x5e\xb9\xa9\xe3\x81\x3c\x4c"
          "\xc9\xec\xac\x10\x3f\xcb\x35\x46\x98\xf7\xab\xd0\x13\xbf\x75\x6b\x41\x90\xaa\x4c\xa0\x99"
          "\x06\x25\x5a\x31\x2a\x5a\xc3\x09\x08\x35\x2d\x80\x8d\xbd\x89\xe8\x7a\x10\x28\xe9\x47\x2d"
          "\xf7\xe5\x98\x5f\x73\x9b\xd9\x23\x41\xec\xb1\x28\xe5\x67\x81\xc1\x53\xc7\xbe\xa7\xfa\xb9"
          "\x0b\xf0\x6e\x73\xf5\x09\x3e\xe3\x90\xa5\x3a\x1c\xe8\x08\x28\x56\xb8\xbe\xe1\x38\xb1\x68"
          "\x09\xae\x25\x11\x28\x03\x0e\x7c\x38\xbd\x80\x8d\x0b\x7e\x46\x5e\x00\xa0\x70\x50\xac"
          "\x7c",
          "\x7d\xc3\x7c\x22\xdc\xdd\xe3\x19\x8c\xe0\x4a\xba\x6a\xd2\x39\x60\x71\x34\x0b\x2b\x28\x21"
          "\xb6\x68\x87\xeb\x56\xf1\xe0\x7a\x45\x68\x47\x61\x6e\xb8\xf3\xd9\x4d\xee\xbf\x99\x4a\x22"
          "\x0f\x24\x61\x80\x99\x9d\xe1\x3a\x83\x0d\x09\x89\xd4\xcf\x67\x36\x1a\x84\x0a\xbd\x21\xf9"
          "\x82\xd7\xc7\x19\x96\xe0\xa1\x59\x97\x5c\xff\x2d\xba\x8c\xa7\x01\xb6\x5a\x6a\x29\x89\x35"
          "\x27\xc1\xef\x3f\x83\x7e\x4e\x7c\xb8\xf1\x32\x45\xe0\x6c\x22\x01\xa0\x19\x3c\x4b\x89\x72"
          "\xff\xd2\xc7\xf1\x9b\xfc\xf7\xd7\x4a\x9e\xbe\x91\x2b\x3e\x7b\xa5\x1e\xbd\x55\x66\x72\x8e"
          "\xbb\x5c\x86\x93\xcd\xc8\x92\x05\x9a\x9b\x93\xdc\x47\x4a\x7a\xb5\xbd\x99\x63\x7c\x16\x5d"
          "\xad\x41\x58\xe5\x3e\xa9\x86\x8b\x11\xd6\x46\xd2\x5a\xe1\x5b\x94\x71\x77\x8e\xb5\x51\x90"
          "\xa6\x91\x11\xc1\xd4\x98\xe3\x67\x96\x8d\x31\x3b\xb9\x49\xc4\xa0\xb8\x64\x34\x65\x44\x8c"
          "\xf8\x64\xf3\xaf\x22\x9a\x44\x16\xbe\x7f\xcb\x0d\xed\x3c\x1e\x0b\x19\x7f\xc7\x19\xb6\x77"
          "\xef\x0b\x61\x29\x2a\x06\x16\x6b\x52\xcf\xe2\xb5\x32\xaa\x9b\xda\x71\x4c\x41\x99\xcb\x46"
          "\xe9\xff\xba\x06\x19\xed\x32\xbc\xe8\xb7\xb7\x1b\xf1\xb2\x00\x85\x2e\x0d\xab\x8f\x04\xab"
          "\x20\xca\xf1\xb1\x39\x2a\x45\x1d\xbe\x2b\xcc\xe0\x00\xb7\x1d\xcc\x49\x26\xa1\xf6\xeb\xd8"
          "\xa0\xda\x28\xf8\xe4\xcb\x50\x64\x6e\x97\xb4\x6b\xf2\xf6\xaf\x2c\xb4\x47\x4c\x73\x7c\x9a"
          "\x58\x78\x91\x97\x32\xd8\x99\x7d\x73\x92\xda\xa5\x4d\x69\xd1\x3d\x8d\xd6\x01\xa8\x95\xaf"
          "\x42\xfd\x75\x39\xa6\xe8\xbf\xab\x43\xa3\xf4\xd8\x2a\x47\xf4\x7d\x11\xd0\xd9\x70\xc5"
          "\x0e",
          1, 2816 },
        { 128, 128, 10, "\xeb\xcb\x01\xb1\x19\x2a\x67\xd5\x19\xf7\xea\x54\x16\x54\x0c\x42",
          "\x3e\x8e\xd8\x30\xd6\x68\x57\x2f\x4f\xd8\x81\x60\x09\x84\xb4\xd0",
          "\x6b\x44\xa6\x07\x77\x51\xa3\x86\xe6\x0b\xbf\xf6\xd9\x52\x3e\xa0\x06\x03\x4a\xbd\xac\xdb"
          "\x23\x79\x71\x6f\x4c\x0d\xfa\xe5\xa4\x2f\x71\xe3\xbf\x9d\x96\xff\xf2\x53\x0a\xec\xc8\x26"
          "\x90\xdc\x97\xba\xd7\xeb\xe1\x55\x49\x10\x5c\x3f\x30\x8f\xfc\x72\xd1\xcc\xc5\xcc\x58\x36"
          "\x60\xbf\xe0\xe2\x74\x53\xca\x06\xa0\x88\xbb\xf0\x6e\x25\x8b\xa2\x1e\xcf\x2e\xa3\x53\xd8"
          "\x6b\x4c\xaf\xa6\xe4\xfc\x01\xc0\x74\xb8\xea\x96\xd3\x1a\x49\x52\xdb\x1f\x49\x6c\xe5\xb4"
          "\x5c\xfa\x8d\xb0\xd1\x5d\x04\x76\xe2\xc4\x6d\x58\x50\x9e\x67\x3f\x60\x56\x4a\x26\x36\x20"
          "\xbc\x88\x72\x7f\xdd\xda\x28\xda\x21\x1a\x1d\x30\x3d\xe4\xb4\x8b\x95\xb7\x1e\x9c\xb0\x98"
          "\x41\xe2\x8c\xd7\x37\x76\x15\x5f\xb5\x93\x3b\x74\xc1\xca\x69\xfb\xcf\x06\x89\x76\xdb\xd0"
          "\x52\xc5\xf0\xac\xc5\xfb\x26\x74\x86\xca\x33\x31\xb8\x0b\xef\x64\x62\xa2\xdf\xcd\x06\x4a"
          "\xe3\xf3\x09\x5d\x8c\x7a\xca\xfd\xba\x52\x5b\x78\xa1\x22\xce\xc6\x66\x4b\xc8\x55\x54\xd7"
          "\xbf\xe3\x62\xa9\xb3\x3e\xb1\x19\xae\x8a\xf8\x95\x0e\xee\x88\x0f\x25\x2f\x08\x8a\x59\xab"
          "\xdf\x4a\xb9\xda\x9f\x9c\xce\x65\xd5\xa8\x94\xa3\x52\xe3\x6c\x60\x93\x0c\x76\x8a\x66\xf0"
          "\x06\x5d\x8a\x7e\x84\x6b\x88\xac\x46\xb5\x8e\x05\xa0\xa1\xf6\xe7\xd6\x42\xe8\x4d\xee\x67"
          "\xf7\x24\xfe\x5a\xc6\x67\x81\xe3\xc0\xf0\x07\x5a\x43\x09\x57\x5b\x5b\x02\x54\x5d\x8e\xcf"
          "\x6d\xab\x92\x6c\x47\x4b\x0f\xb1\xa8\xa7\x1b\x0c\x49\xfe\x3d\xc6\xa2\xcb\x12\xcd\xec\x66"
          "\x90\xc2\x76\xd7\x49\xfe\x77\x3e\xdf\x88\x0f\x39\x91\x60\x26\xc6\xff\xc0\x36\xdb\xd4\x4d"
          "\xe1\x90\xca\x96\x5e\x33\x85\x4f\x94\xb4\x42\x48\x42\xea\x06\x88",
          "\x97\xfb\x1f\x67\xc0\x18\x0b\x02\x52\xd2\xce\x2f\x13\x14\x02\xd7\xa2\x48\xa8\x53\xbc\xb1"
          "\xfe\xa8\xed\xbe\xf9\x4b\xa6\x55\x05\x42\x4f\xf0\x9f\x86\xb8\x45\x4a\xbe\xbc\x66\x07\x1e"
          "\x41\x35\x0e\x85\xbb\x0d\x3f\x73\x68\x6d\x9c\xac\xbd\xaa\xf8\xae\xd3\x42\x19\xf2\xf4\x41"
          "\xaa\xdc\x15\x53\xda\x41\x33\x6a\xfe\x1f\xd2\x14\xe4\x04\xdb\x07\xf0\xf6\x6d\x7c\x5b\xf3"
          "\xf4\x81\x8f\x4e\xe1\xbb\x4a\xd2\x6d\x90\x8a\xb0\x23\x15\xc6\x2c\xbd\x6d\xf1\x35\xce\x78"
          "\x25\x6c\x48\x8c\xfb\x0f\x31\xdc\x73\xd7\x05\xe3\x5d\x17\xbc\x1c\xd8\x75\xc3\x40\x3a\xd4"
          "\x2a\xfe\x5d\x14\xfd\xfe\xe0\xe9\x1f\x23\xe9\xbe\xf1\x2a\x05\x38\x94\x7f\x29\x1f\x55\x71"
          "\x2d\x43\x97\x4a\xd2\x2f\x42\xe7\x53\xc5\x94\x14\xc9\xdf\x9e\x61\xe4\xe7\x1d\xdf\x88\xe3"
          "\xc4\x7e\xf1\x66\x39\x65\xf2\x21\x37\x7f\x39\x0b\xce\x4f\xc5\x8d\x3c\x52\x83\xce\x70\xb7"
          "\x86\x3b\xe4\xf8\x53\xc4\x49\x9a\x45\xf6\x31\x5a\x0b\xe3\x47\x4f\x27\x69\xf7\xb4\x7d\xb3"
          "\xbe\xff\xfb\x46\xa1\x4a\xc2\x36\xce\x53\x0d\x9e\x29\x4b\xa4\x17\x3d\xd4\xf5\x57\xa3\x9a"
          "\x4a\x61\x7b\x97\x05\xbc\x9d\x07\xa0\x16\x35\x85\x67\x88\xb0\x16\x44\xb0\xac\xd3\x90\xb2"
          "\xbb\x7d\xf1\x73\x8e\x14\x4f\x96\x64\x75\x7f\xf7\x91\xcd\xff\x9c\x74\x0f\x6d\x8b\xc7\x94"
          "\xb2\xf7\x55\x88\xfe\xef\xc1\x94\x7b\x78\xe2\xe9\xe0\xa2\x3b\x57\x87\xb3\x75\x74\x09\xda"
          "\xa7\x85\xb7\xb4\xb2\x35\x3a\xce\x15\x0c\xc7\x69\x53\x5b\x48\x50\x6f\x5e\xc3\x83\x29\x56"
          "\xb6\x21\x3f\x38\xdd\xe8\x11\xe5\x29\x51\x99\x78\xcf\x30\x3a\xd4\xb2\x52\x3a\xe3\x1b\xba"
          "\x21\x7a\x57\x9a\x54\x1d\x34\xf5\xff\xda\xfb\x0f\xc7\x6c\x34\x5c",
          1, 2944 },
        { 128, 128, 11, "\x23\x92\xc5\x2e\x25\x7e\x7d\xd1\xf3\xa5\xd6\x4d\xac\xfc\xaa\x02",
          "\xb0\xdb\x14\x69\x98\xd2\xa2\x82\x42\x13\x3f\x0a\x42\xd8\xce\x9a",
          "\x4f\x49\x49\x72\x31\xd0\x36\xee\xad\xee\xce\x1b\x36\x96\x1c\x96\x7b\xce\x5a\xf6\xdf\x72"
          "\xe7\xbb\x8c\x33\x0f\x99\x14\x4d\x68\x37\x22\x8f\x1a\xa3\x49\xb9\xaa\x25\xf2\x3c\x7b\xcf"
          "\x46\x6f\x9f\xa7",
          "\xac\x16\xb4\xac\x05\xf7\x2d\x20\xea\x02\xcb\xb1\xac\xdf\xbf\x23\xb2\x17\xfb\x9e\x1b\x38"
          "\xa9\x71\xad\x5b\xc3\xe5\x8d\x93\x7d\xa4\x6b\x65\x70\x56\xdc\x08\xe4\xdd\x19\x0e\x93\x2e"
          "\x18\x5e\xfe\x28",
          1, 384 },
        { 128, 128, 12, "\x00\x82\x6a\x92\x09\x2f\x24\x77\x4d\x2b\x34\xc9\x23\x2b\x0b\x20",
          "\xf2\x6f\xf3\xed\xaa\xa2\xf1\xc4\x66\x68\x99\xf8\xb7\xaf\xbf\xaf",
          "\xf0\x0f\x43\xde\xe2\xb3\x9d\x33\x85\xf4\x62\xaf\x91\x7b\x6d\x4e\x4c\x48\x30\xc7\x93\x64"
          "\xac\x4c\xac\xb8\xc6\xc3\xbc\x2a\xfc\xae\xbb\xec\x4a\x33\xad\x6d\x2b\xb0\xc0\xec\xe1\xd1"
          "\x33\xcd\xd4\xbb\x2d\x87\xeb\xe4\x25\xdf\x74\xac\xf2\xd5\x4c\xf9\xc1\x93\x39\x31\x42\x71"
          "\x6b\x4d\x29\xcc\x18\x76\xe3\xb4\x8f\x96\x49\xb5\x66\x74\xb6\x7b\x39\x6a\xbd\x38\x1a\x53"
          "\x6a\xda\x22\x47\x2c\xe8\xcf\x7b\x35\x7e\x4d\xe7\xbc\x17\xc8\xc7\xb4\x8a\x71\x6b\x94\xbf"
          "\x09\x0d\x8a\x6f\x00\xf6\x87\x2a\xe2\xe7\x93\x1f\xab\x78\x9d\x44\x3d\xc4\xa1\x74\x60\x9f"
          "\x44\xb5\x61\x84\xc4\xe7\x1b\xed\xa8\x13\xc7\xc5\x84\x69\xaa\xa2\xb0\xf3\x0d\x31\x6d\x60"
          "\xd9\xef\x84\x44\xef\x4a\xc9\x73\x46\xa5\xdf\xed\x38\x43\xc7\x58\x33\x30\xa5\x2c\x1a\x69"
          "\x0b\x76\x8e\x9c\x1e\x65\x63\x2c\x8f\xe7\x23\x01\x6d\xf2\x6d\x3d\xcd\x44\x3e\x0d\xf8\xe4"
          "\x9d\x5f\x25\xc6\x16\x0b\x9b\x28\x52\x93\x97\x9a\x12\xd4\xec\x90\x95\x52\xdf\x00\x60\x02"
          "\x48\xe1\x8b\x36\x80\xc5\xc3\x22\x47\x52\x47\xce\x1e\x6c\x8e\xd3\x3c\x4d\x6b\xe1\x08\xdb"
          "\xf1\xa7\x17\xd2\x17\x32\x8c\x7b\x18\x26\x37\xf7\xaa\x93\xc6\xec\xd9\x69\x39\xd5\x61\x78"
          "\x85\x3a\xf6\x43\x43\x84\x0e\x38\x71\xc2\x03\x57\x05\xea\x37\xa0\x52\x48\x3b\x97\x2b\x33"
          "\x81\xe8",
          "\x76\xc3\x89\x5d\xe9\x88\x6c\x55\x94\xb1\xdd\x8a\x3f\x58\xc8\x2e\xc9\x40\xd5\x61\x4c\x2c"
          "\xae\x4d\x02\x73\x06\x6c\x29\x6b\x24\x03\x09\x9e\x3c\x8f\x84\xf9\x66\xef\xf2\x42\xf3\x39"
          "\x18\xd1\x47\x3c\x52\xbe\x67\x09\x5b\x9f\xa5\x0c\x3d\x4c\x1d\x68\x1a\x58\xa0\xa4\xf7\x36"
          "\xee\x5b\xea\x2d\xc3\x50\x55\x5d\x58\xdb\x94\x25\xb4\xcd\xc9\xd7\x4f\xc7\xb0\x98\xa7\xf4"
          "\xd1\x05\x46\x7a\x3f\xfa\x0d\xe8\x01\x72\xce\xfd\xe5\xf9\x40\x44\x85\xba\x82\xbb\x4a\x84"
          "\xbc\xe5\x7a\x7c\x0a\x80\xca\xb4\x1b\x5a\x28\x90\xf8\xca\x00\xfc\x2a\x65\xd1\x07\x8b\x33"
          "\x73\x87\xa9\xca\x5f\x46\x64\xca\xb8\xf5\xbe\x39\xf8\xf5\x21\xc0\x55\xe2\x3b\x45\xb5\xab"
          "\x9a\xc8\x29\xf0\x01\x51\x54\xc0\xd2\x15\xff\x7d\x4a\x14\xc8\xce\xa0\x03\xc4\xba\x49\xde"
          "\x4c\x63\x71\xee\x90\x26\x38\xaa\x13\x1e\xdb\x29\x0c\x35\x89\xc8\x0b\x81\x9b\xde\xac\xfc"
          "\x38\x9e\x57\xc6\x0f\x1e\x56\xf0\x54\x37\x67\x12\xc1\x0d\x53\xc9\x78\x17\xc2\x93\x78\x15"
          "\xe3\xcc\x96\xcb\x80\x70\x55\x06\x05\x9e\xef\xab\xd9\x3b\x14\xc0\xd0\xa3\xc4\x51\xb8\x9a"
          "\x98\x20\x89\xbe\x9d\x45\xeb\xe6\xe4\x20\x18\x98\x51\x23\xf3\x7c\x1c\x72\x61\x46\xaa\x1b"
          "\x9a\xe5\xf1\x64\xff\x47\xea\x0a\x92\x92\xdb\x4c\x26\xa2\x86\x88\x01\x70\xe8\xc4\xdd\x9f"
          "\xe9\x22",
          1, 2304 },
        { 128, 128, 13, "\x6f\x1e\x3a\xf9\xd9\xcc\x23\x6f\x77\x2c\x02\x52\xca\x40\xb5\x1f",
          "\x94\x30\x7d\x11\xa9\xb2\x60\x14\x40\x24\xad\x18\x25\xa5\x84\x87",
          "\x2d\x1b\x83\x67\x82\xdf\x23\xf8\xc4\x90\x10\x5b\x6e\x61\xa9\x33\x21\xe5\xd2\xbe\x88\xe0"
          "\x96\xb2\x14\xa2\xfd\xb9\x34\xbb\x62\xda\xb1\x06\x49\xed\xbe\xb7\x3b\xa7\x78\x22\xfe\xb6"
          "\x5a\x4a\xe6\xdd\x52\x6a\x8c\xdd\x00\xb0\xc1\x8b\xca\xce\x40\x17\x67\x21\x5b\x18\xf8\x66"
          "\x6b\xa4\xca\xb3\x92\x61\x92\x9d\xb0\xb1\x1f\x2d\x14\x86\x62\x57\x74\x2a\x30\xe7\x7e\xc7"
          "\xcf\xb6\x5b\xb3\x1b\x52\xf7\x83\x48\x08\x13\x2f\xae\x63\xbc\x0e\x06\x88\x0c\x21\xcc\xc7"
          "\x9a\x26\x99\xcc\xb3\x6c\xef\xd7\xf7\xe8\x23\x25\x59\xa1\xbd\x1e\x89\x45\x64\x32\xf7\x92"
          "\xee\x9e\xd8\x64\xd9\x54\xf4\xc0\x24\xa6\x95\xec\xf5\x1b\xed\x58\x75\x4f\x12\xc1\xdd\x4b"
          "\xc6\x40\xfd\x0f\xd8\x11",
          "\x9e\xca\x58\x9d\xd0\xae\x2c\x70\xbd\x7a\xe7\x25\xe3\xfa\x57\x3e\x79\x61\x73\xc2\x19\xe3"
          "\x88\x08\x0e\x41\x39\x90\x9c\x01\x50\x99\x2d\xfb\xdd\x0e\xd3\x3a\x01\xb7\xaa\x92\xe2\xcf"
          "\x70\x3f\xe9\x69\x6d\x19\x45\x41\xb2\xd8\x84\x0f\x36\x9f\x5d\x65\x0c\xda\x21\x42\xf1\xd1"
          "\x8c\x2d\xe8\x15\x07\x27\x9e\xaa\xe5\x8e\x68\x3b\x9d\x17\xea\x6d\x83\x97\x81\x00\xf1\x23"
          "\x66\x8b\x7c\x9b\xd2\x16\xa8\xc1\xcf\x5d\x10\xc5\x67\xc7\x74\x8e\x24\xc4\xda\x6b\x04\x48"
          "\x85\x5c\x9c\xd3\x0d\xc6\x03\x66\x1c\xe1\x9a\x97\x46\x2a\xf5\x14\x5a\xa9\xe4\xef\xe6\x4a"
          "\xb5\x9a\x32\x03\x56\x51\xd6\x09\xc4\xa4\xa8\x45\x94\x86\x38\xf6\x17\x84\xf3\xc8\xf3\x33"
          "\xfb\x79\xb3\x6a\x3e\x7a",
          1, 1280 },
        { 128, 128, 14, "\xa9\xd7\xdd\x48\xaf\x2c\xe4\xa3\x5a\x5a\x4e\x61\x02\x60\xcc\xde",
          "\x78\x85\xb2\x28\xbc\xdc\x45\x6e\xf7\x7d\x1a\xe7\x5b\x34\x11\x5b",
          "\xfd\xd7\x66\x37\x86\x80\xf6\xb7\x5e\xf1\x97\x07\xfa\xfd\x1f\x2c\xa3\x58\x03\xc8\x5a\x73"
          "\x0a\xa5\x43\x9b\x71\x83\x05\x8c\x06\x51\x6f\x48\xad\xc5\x5c\xcf\x9e\x72\x47\xad\x91\x06"
          "\x27\x19\x1d\x9e\x33\x33\x8f\x9a\x03\x2e\x22\xc5\x23\xc6\x2a\x04\x05\xb4\xaa\xdc\x44\x22"
          "\x49\x85\xa1\xfa\x91\x81\x50\x90\xe9\x7d\xb8\x3c\x17\x43\x23\x88\x73\xb2\xa0\xfc\x1a\x82"
          "\x40\x8c\x52\x73\x77\xde\x62\x43\x6b\x0d\x47\x19\xbd\x29\x97\x5e\xe1\xc6\x1d\x9a\xa1\x7b"
          "\xbc\x0f\x2a\x22\x4d\x37\x02\x8a\x37\x78\x65\x3e\xdb\x85\xca\x4c\xe3\xc2\x73\xe9\xc8\x36"
          "\xac\x69\x36\x7d\x62\x35\x7c\x4d\x0e\x7a\xec\xa9\x74\xfb\x65\x3d\xed\xa5\xf5\x51\xd9\x45"
          "\x21\xb4\xcd\x48\xbc\xc3\x2c\xc6\xd7\x1e\x9b\x76\x96\x9c\xa5\xd3\xc2\xcd\x21\xcf\x25\x0e"
          "\x25\x6e\xdc\x06\xc2\xa3\x47\x08\x00\xaa\x79\xe8\xfa\xbb\x6f\xd3\xea\x40\x88\x88\xf0\x4b"
          "\x0e\x00\xa6\xaa\xf8\xf3\x6d\x33\x73\x68\x02\xe2\xcd\x56\x22\x68\xee\xcd\xa6\x33\xec\x92"
          "\xff\x0f\x6d\xc0\xa9\x4a\xad\xfa\x42\x9a\xb5\x51\x1a\x78\x1e\x20\xef\xf9\xed\x7f\xe2\x0a"
          "\xec\xef\xfc\xad\x30\x3f\x38\x16\x98\x06\x60\x9b\x42\x4a\x35\xcc\x29\xe1\x3c\xfa\xeb\xac"
          "\x46\x0e\x2c\xe3\xde\x29\x0a\x5f\x64\xd0\x01\xac\xf9\x16\x2f\xb2\x77\x7c\xf7\xaa\xa2\xb2"
          "\x9a\x95\x11\xf6\xfa\x0c\xad\x14\xc1\xb4\x60\xa4\xc1\xea\x82\xf2\x11\x7a\x9a\x97\x44\xd9"
          "\xb7\x37\x50\x2c\xcb\x6c\x7c\xe8\xc9\x0b\xb6\x46\xed\xd9\x4e\x8f\x8c\x27\x54\x70\xd1\x8c"
          "\xdd\x86\x28\xbc\xed\x74\x40\x52\x1a\xf6\xaf\xd5\x35\xa5\xab\xee\xe2\xbd\x68\x6c\x28\x15"
          "\x14\x36\x67\xf2\x17\xae\x38\x8b\x59\x05\x9b\x85\xdd\xbf\xb2\xbf\xf4\xb7\xe7\x1e\x5a\x11"
          "\x0f\xa8\x5c\x1e\xdf\x92\xbd\x76\x9b\x78\x64\x93\x2a\x50\x90\xe9\x4a\xe2\x15\xa4\x66\x9b"
          "\x9d\x9a\xbf\xec\x72\xd4\x7b\x80\xc2\xc2\x1d\x16\x6e\xfc\xae\x2b\x32\x27\xbd\x00\x09\x73"
          "\xbf\x3c\x7f\x53\xf1\xb4\x89\xdc\x85\xbd\x09\xc2\x3d\x43\x6d\x1f\x91\xf7\xca\x5a\x89\x04"
          "\x3d\xd3\x3a\x30\xbe\x15\xd9\x58\xb6\x2e\xa8\xd7\x49\x26\xad\xfc\x90\xe8\x1a\x82\xb0\x8f"
          "\x12\x87\x67\xa7\x8f\x14\xe3\xc7\xf6\x79\xcf\xe9\x69\x96\x7c\x66\x2c\xf8",
          "\x78\x64\xb2\x3b\x8d\x27\xbc\x6c\x4a\xba\xba\x7f\x9f\xf4\x9e\x74\x60\x89\xf1\x70\x73\x73"
          "\x2f\x17\xca\x7b\xb7\x4f\x8f\x03\xea\x69\x15\xd1\xac\x92\x60\x40\xf9\x7f\x68\xba\x31\x4f"
          "\x16\x61\x0d\x00\xa4\xb8\x79\x4b\x96\x7d\x73\x51\x42\xd6\x96\xca\x90\x4e\x6b\x7e\xcf\xce"
          "\x53\xc1\x0b\x91\xd0\x5e\x5b\x91\x5e\x9b\x99\x19\x09\xe7\xb9\x3a\x5c\x73\x11\x1d\x4d\xe1"
          "\x8a\xe6\xd9\x19\x81\x31\x7d\x80\x70\x9e\x01\xd6\x50\x63\x96\xb8\x88\x84\xb2\x13\xca\xd5"
          "\xb1\x65\x21\x75\x27\xde\xf8\x7b\x9d\xf1\x50\xb3\xc3\xe2\x77\xae\x52\x28\x2d\x71\x03\x0d"
          "\x02\x72\x6e\x88\x76\xf7\xa4\x81\x42\xd7\xa7\xe2\x60\x77\xdf\x44\x4f\xda\xe9\xf1\x63\x68"
          "\x5a\x71\x2f\xb0\x4d\x5e\x5f\x07\x44\xf4\x1b\xdd\xb3\xb0\x9c\xd6\x7a\xc1\x10\x05\x71\x10"
          "\x5a\x00\x74\x5a\xbf\xa1\xcc\xf5\x1f\xc2\x4b\x47\x36\xe2\x3f\x42\x2c\x5f\x98\x33\xa8\xfe"
          "\xb2\xdd\x2c\x37\xaf\x16\x20\xe0\xb6\xfd\x13\x44\x46\x68\x81\x0f\x76\x5e\xd0\xe8\x4e\x6d"
          "\x9a\x95\x4d\x36\x15\xfc\x38\x66\xf6\x1c\xf5\x77\x04\x8b\xb2\x0a\x17\xed\xe0\xf9\xf3\x81"
          "\x86\x57\xb2\xe8\xa3\x21\xa7\x93\x38\x70\x65\xf7\x24\xd9\x9c\x50\x09\xef\xc4\xa0\x17\x35"
          "\x74\x6f\xc1\x84\xad\x52\x27\x48\xc2\x60\xd8\x2e\x4d\x29\x98\xb9\x4c\xc3\xef\xfc\xf5\x3a"
          "\xb3\xe3\x86\xa1\xb1\x4b\x9f\xe5\x0e\x9c\x8a\xae\x66\x13\x32\x37\x62\x06\x3f\xc2\x4f\x02"
          "\xe7\xfa\xa6\x8b\xb0\x95\xe0\xaf\x94\xdf\x64\x32\x92\xaf\x47\xe8\x4d\x66\x92\x2e\x6e\x7c"
          "\xd9\xf9\xe4\x51\x20\x80\x37\x18\xfb\x94\x95\xb1\x96\x18\xa6\xc5\x6d\xc2\xe0\x3c\x05\xdc"
          "\x0c\x3c\x6b\xf5\x26\x0d\x6d\xb2\x37\x25\x4f\x98\xa7\xa9\xb4\xf7\xd6\x95\x6d\xde\x08\xde"
          "\x6f\x38\xca\x4b\xb9\xd2\x5f\x62\x0b\xff\xc1\x0c\xb1\x2c\x84\x50\x9c\xcd\xa7\x93\xec\x38"
          "\x69\x3d\x36\x80\x18\xb6\x14\x41\x61\x7c\x78\x46\x9c\xbe\xbe\x15\xc1\x41\x39\x6b\x4c\x33"
          "\x02\x46\xfc\x58\xe6\x97\x9c\x9a\x68\x4d\x8a\x2c\x66\x5b\xcf\x44\xe0\x06\xdc\xde\xf4\x5b"
          "\xc2\x97\xd0\x82\x75\xa2\x81\xcb\x89\xc7\x2c\x45\x6b\x00\xbb\xa5\x5c\x39\x82\x6f\x94\x19"
          "\x08\xc7\xeb\xec\xc4\x4e\x62\x56\xdf\x13\x9e\x95\xde\x24\x8c\x79\x67\xbc",
          1, 3840 },
        { 128, 128, 15, "\xae\x10\xaf\xd3\xeb\xa4\x9a\xd7\x47\x7b\x54\x4d\x09\x4f\xd1\xeb",
          "\x65\x8c\x6b\x62\xc1\x9d\x45\x5e\x5e\x95\xbb\x14\xb3\xf7\x0f\x4a",
          "\x56\xd7\xcf\x68\xa5\x31\x3f\x14\x0a\xfc\xd2\x48\xb4\x25\x1e\xac\x6c\x58\x53\x43\x7c\xa5"
          "\x21\x34\x6d\xc8\x71\x80\x36\x0e\x1a\x3d\x40\xab\xac\x8f\xd8\x7a\xfa\xf8\x9d\xa0\xca\x14"
          "\x09\x93\x4a\x3f\xf3\x9b\x58\xe4\x5b\xfd\x02\x06\xe1\x71\x2e\x76\xfd\x81\xb8\x40",
          "\x4d\x47\xab\xf5\x41\xb9\x4e\xf7\xfb\xc2\xa7\x2d\x88\x95\xfd\x70\xd1\xac\x39\x34\x3d\xa5"
          "\x78\x1c\xc7\xc1\x18\x97\x0d\xa5\x70\xde\xac\x5f\xba\xb8\xf6\xac\x2a\xfe\x11\xdb\xec\xc0"
          "\xb4\x79\x4c\x1f\xa8\x26\xdf\x4a\xef\x75\xa9\x3c\x90\x1e\xed\xeb\x4a\x67\x57\xc6",
          1, 512 },
        { 128, 128, 16, "\x30\x4e\x57\x4d\x55\x26\x5d\xb8\x7e\xf2\x31\x09\xfe\x52\xb4\x48",
          "\x24\xcd\xf5\x71\x5c\x50\x75\x18\x4c\xd4\x1f\xd5\xd3\xe1\x14\x14",
          "\xbe\xc2\x85\x27\x7f\x0f\xc9\xfc\x90\x10\x6c\xa1\x93\x2f\xbb\x6e\xee\x86\x77\xd8\xbe\x4c"
          "\xf0\x5d\x4a\xe7\x46\xdb\xd6\xcd\x6b\x22\x66\x14\x95\xd0\x19\x40\x8d\x3d\xf8\x0e\x19\xaa"
          "\x40\xac\x4c\x0f\xdb\x02\xb8\x61\xa2\x42\xf7\xfe\x51\x6e\x49\x56\x1b\x6c\xb2\xfa\x00\xb8"
          "\xad\x11\x41\x24\x70\x68\x00\xc5\x18\x6e\x5a\xda\x49\x1e\xf6\x6a\x58\x83\x14\xf2\x2b\xd3"
          "\xc7\x40\xbe\x14\x45\x49\x28\xac\x41\x61\x48\xcb\xfb\x11\xf2\x29\xb8\x9e\x3a\xaa\x8d\x89"
          "\x95\xa1\x92\xb3\x95\xcd\x37\xde\x30\x6a\xa6\x63\x83\x00\xbe\x51\xca\x91\xa7\x5e\x88\x55"
          "\x59\x3b\x5d\x61\xe7\x01\x1f\x85\x6e\x80\x84\x6c\xc0\xd3\x79\xa0\xc7\x7e\x21\x60\x46\xcb"
          "\x87\x64\x94\x12\x89\xa6\xf7\x9e\xc2\xad\x05\x21\x1b\xd2\x2d\xd3\xef\xfd\x3e\x93\xc7\x62"
          "\xd9\x60\xe6\x5f\x4c\x2c\xa9\x46\xe1\x9b\xcb\xd3\x5c\x2c\x2e\xba\xe9\xdc\xfb\xd3\xd8\x0f"
          "\x05\x65\x61\xe3\x22\x4e\x45\xdc\x87\x27\xad\x11\x91\xdf\x9c\x33\x3e\x32\xd5\xa1\x16\x95"
          "\x32\xc0\x56\xdb\x4e\x04\x10\xc5\x35\x39\xb7\x1d\xb6\x34\x56\xf8\xd3\xc4\xd4\x7e\x30\xcb"
          "\x3b\x46\x43\x2f\xe5\x03\xfb\x42\x80\xb4\xc3\x1f\x50\x23\x30\xa1\xf1\xe4\x8b\xf5\x17\x59"
          "\x1a\xe0\xdb\x02\xcd\x76\x5d\x3f\xc3\x53\xf8\x02\x3c\x8f\xc5\x2f\xe8\xd6\x4e\xd1\x8f\x68"
          "\x2f\x10\x6a\x94\xb2\x7b\xa2\xf1\xf9\xeb\x11\x5d\xb7\xe2\xec\x0f\x0e\xc3\x5d\xb6\x7e\xd9"
          "\xef\xf6\x1c\xc8\x6b\x18\xf7\x41\xb4\xf5\xe4\x5a",
          "\xfd\x91\xa5\x2a\xf9\xf4\xeb\x44\xef\x8e\xf8\xc1\xa3\x4c\xca\x06\x14\x98\xe5\x05\x07\x6f"
          "\x91\xc8\x71\x92\x3f\x8d\x5e\x7c\xc8\x79\x79\x2e\x96\xf8\xdb\x80\x3e\x31\xda\xd0\x82\x10"
          "\x5b\x1a\xbf\xaf\x97\x91\x9f\x38\x9e\x7a\xa2\x50\x4e\x05\xa9\xdf\x05\xcd\x40\x70\x81\x34"
          "\x40\x7c\xae\xd6\xd1\x6b\x72\xe7\x0f\xbe\x2d\xc9\x62\x99\xb7\xc0\x4b\x0c\x0d\x7a\xad\xa7"
          "\x73\x01\x93\xe9\xd1\xf4\x81\x40\xef\x44\xb7\x5c\xcf\xf3\xf0\xaf\xd5\x50\xd9\x1b\xa7\x0f"
          "\xe7\xf5\x57\xb1\xd0\x8d\xa1\x19\x7d\xfc\x01\x26\xed\x66\xc5\x43\x6c\xbd\x60\x1c\x0a\xce"
          "\xe5\xa3\xa3\x37\x2e\xa1\xf7\xe3\x74\x81\x8f\x91\xa7\x72\x2e\x86\xae\x1e\xd0\xcb\x05\xe4"
          "\x42\x26\x27\xef\x68\x54\x5a\x81\x4e\xcf\x2b\x39\xf1\xc7\xc4\x40\xc6\x41\xc4\xe8\xe0\xc8"
          "\xa8\x91\xc6\x0a\x09\xfb\x35\x1a\xe8\x67\x8a\xb5\x1e\x10\x53\x79\x8f\x8f\x96\xad\x30\x80"
          "\x02\x85\xb7\xeb\xa4\xfa\x3d\xf5\x50\x07\xfe\xc4\x11\xfd\xb3\x4b\x86\x25\x16\x35\x46\x7e"
          "\x3a\x18\xfd\xaf\x13\x44\x16\x82\xaa\xcf\xcb\xd7\x64\x6e\xc9\x2d\xa8\xd6\x3f\x72\x9c\x80"
          "\x8d\x9e\x92\x51\x48\x41\xc2\x27\x15\xa7\xbd\x01\x3a\x9c\x46\x0e\x52\x80\x11\xd4\x10\x38"
          "\xbc\x28\x21\xb6\x2b\xb3\x56\x87\x3c\x43\x9c\xf4\x2c\x16\x79\x05\xeb\x5f\x62\xbd\x90\x44"
          "\x23\xd4\x7a\x01\xbe\x9e\x24\xdb\x15\x16\x17\xcb\x29\xbd\x24\x10\xb7\x6b\xa2\x09\x04\x23"
          "\x84\xb1\x53\x4c\x3f\x23\xfe\x1a\x49\x35\x28\x8b",
          1, 2560 },
        { 128, 128, 17, "\xcc\xe3\xfb\x93\x59\x62\x0a\x01\xd5\xc7\x31\xf3\x9a\xf0\x0e\x4b",
          "\xdf\x0e\x7e\x4c\xb3\xd8\x18\x37\x2d\x7e\xc2\x6e\x0b\x8d\x56\x6a",
          "\x13\xa1\xcb\x11\x53\xe9\xfe\xd8\x4d\x76\x03\xba\x68\x22\x6c\x35\x86\x81\x9f\xae\x58\x4a"
          "\x70\x93\x70\xa9\x21\xe5\x2d\x6b\x1e\x66\x56\x79\xe6\xd7\x95\x7e\x3e\x61\x55\x79\xbd\x18"
          "\xe3\x0e\x4d\x53\xe2\xa2\x43\x26\xb1\xb8\x3f\x81\x2d\xba\x6c\xd1\x40\xcf\x8a\x8d\xfd\x91"
          "\x06\x3d\x64\x13\x4c\x05\xcb\x7b\x42\xc5\xa6\xdb\x87\x7f\x53\x47\x86\x64\xd5\xa4\xe0\x54"
          "\x25\xf5\xff\xa0\x5b\x0a\x58\xa3\xdc\xdc\x13\xf6\xce\x0b\x6d\x89\xd2\x7c\x16\xd3\xb8\xf1"
          "\xdd\x7c\x52\x95\xd2\x78\xf6\xb0\xe4\x59\xce\xf1\xf0\xd5\x23\x1a\xe5\x7b\x53\xa8\x28\xe6"
          "\x69\x5f\x59\x4b\x9e\x95\x7f\x76\x2d\x58\x84\x1a\x3e\x8f\x9a\x6c\x81\x2c\x87\x6f\x8e\xb6"
          "\xbe\xe6\x39\xac\x53\x93\x86\xa2\x72\x01\x46\x7f\x07\xa8\x71\x19\x8f\xac\x66\xeb\xa1\x66"
          "\xc5\x50\x1d\x2c\x5c\x03\x0d\x4d\x9d\x5a\xb5\xc1\x4f\xdc\xde\x5e\xdb\xf9\x00\x33\x4f\x46"
          "\x2a\xfe\x9b\x10\x5b\x60\x40\x9d\x46\x46\x25\x94\x11\xa8\x13\xba\xbc\x5a\x59\xca\x6d\xf3"
          "\x05\xc6\x7a\xc2\xc4\xa6\xf5\xa8\xef\x6f\x98\xfe\x9d\x05\xac\x91\xb3\xc9\x27\x10\x0a\x3c"
          "\x4f\x0c\x40\x88\x99\xdb\x20\x1b\x62\xc1\x1a\xec\x67\x02\xd4\x83\xcd\xad\x1e\xc1\x41\xf6"
          "\x92\x7e\x89\x1e\xb5\x22\xc6\x94\x6a\xfb\xb4\xc6\x23\x75\xe1\x2f\x90\xe0\x03\x9a\x94\xe0"
          "\xb5\xfe\xad\x0c\xcf\xb3\x86\x4c\x8c\xb3\x2f\x9b\x1b\x04\x00\x84\x56\xa9\x26\x4f\x9b\xe0"
          "\xbf\x72\x40\xea\x32\x1e\xe4\xeb\xdf\x65\x9e\xdb\xda\xac\x4f\x28\x58\x9d\x6b\x44\x67\xb6"
          "\x12\x31\x67\x71\xda\x9e\x76\xca\x33\x4e\x0f\x94\x1f\xac\xa0\x72\x66\xe1\xdc\xa2\xd5\x83"
          "\xa9\xaf\x84\x62\xcb\x1d\x56\x55\x77\x63\xfe\x10\x2d\xc5\x97\xe2\x63\x45\x49\x6d\x23\xef"
          "\xac\x22\x90\x5e\x50\x1f\x68\x38\x6d\xc1\x3b\x29\x1a\xde\xab\x5d\x86\x11\x32\x62\x25\x4a"
          "\x4e\xa6\xcb\xdc\x31\x3d\x8a\x55\xf3\x3b\xf3\xb8\xb3\x8d\xc9\x48\x54\xb1\x06\x12\x5e\x17"
          "\xb8\x10\x8a\xce\x28\x51\x5e\x89\x16\x00\x8c\xd7\xe9\x52\x61\x44\x7b\x5b\xe4\x7e\xbf\xba"
          "\x89\xd1\x19\xc8\xc8\xcc\x05\x60",
          "\xf8\xbb\x10\x46\x95\x36\xf3\x15\x46\x8f\x02\xc8\x8e\x5b\x56\x01\x3e\x6b\xf0\xc4\x28\xfc"
          "\x7e\x29\x29\x4d\x8e\xbc\x34\x87\xc0\x81\xd3\x37\x76\x41\xa6\x98\x1e\x11\xa9\xea\x09\x1e"
          "\x4c\x95\x88\xec\x35\x7e\xaf\x6e\x2b\x53\xfe\x0e\xa1\xe9\x04\xd1\x99\xf7\x7e\x06\x46\x5e"
          "\xae\x44\x1f\x9b\xf7\x14\xed\xd8\x58\x83\xbe\x41\x10\xdc\x28\x18\x37\x7f\x09\xc7\x0c\x75"
          "\x9c\xda\xd2\x25\x1b\x85\xbf\xd3\xbf\x61\x40\x4c\xa9\x99\xc5\x1c\xd8\x54\xd8\xe3\xf4\x4e"
          "\x08\xb9\xb6\x7a\xe4\x17\x10\x1d\x8d\x9e\x0e\x4c\x7a\xec\xad\x16\x61\x64\x89\xac\x2f\x28"
          "\xc1\x51\x96\xf8\x83\x3b\x35\x1a\x9b\xc3\x13\x56\xed\x82\x60\x9c\x68\x23\xb7\xb8\x89\xc4"
          "\x46\x45\x89\xb8\xa4\xa5\x5b\x01\x2f\xb6\xb3\xe9\xd8\xe6\x75\x61\x97\xb4\x97\xf0\x7a\xb0"
          "\x8c\x35\x74\x11\xa5\x1c\xe4\xb4\x41\x03\x52\x87\x71\x4f\x5d\xbe\x83\xc2\xc3\x5f\x6b\x79"
          "\xea\xc1\xc8\x24\xeb\xe0\x2f\x28\xee\x9c\x0f\xd0\x5e\xaf\x5d\x0a\xdb\xf2\x4f\xa7\xbc\xaa"
          "\x9f\x89\x59\xd1\xfb\xac\x7a\x35\x34\xe6\xca\x0f\x49\x33\x99\xa1\x62\xcf\xd0\x1c\x80\xff"
          "\x35\xe5\x9c\x54\xd4\x0b\x39\xad\xaf\x26\x4f\x55\x24\xbd\x8f\x99\x33\xec\x41\x44\x63\x4b"
          "\xf7\x60\xf4\xe1\x8c\x66\xd2\x7a\x88\x53\xba\x53\x0e\xbf\x4e\x76\x66\x55\x1a\xb5\x1f\x2e"
          "\x29\x85\xac\xf0\xbd\xa6\xd6\x94\xa2\x54\x81\x57\xb5\x94\x41\x5d\xfc\x40\xc1\xce\x22\x85"
          "\x93\xdf\xe7\x1a\xa2\x30\x7a\x97\x9a\x1b\x2c\xa2\x6e\xe6\x0e\xb8\x53\xba\xcc\xd7\xa9\x2b"
          "\xf7\xa4\xb5\xdb\x11\xdb\x5b\x4e\xd3\xa5\x94\xb1\x5d\xb7\x21\x0f\xd6\x1e\x4d\xfa\x73\x59"
          "\x77\x18\x18\x81\x83\x30\x61\x6c\x93\xd7\x2f\x73\xb9\x03\xe5\x08\x9d\xba\x72\xaf\xc3\x62"
          "\xce\xc0\xa5\x63\xf8\x13\xfe\x08\x24\xf2\xd4\xad\xa8\xd2\x25\x1c\x96\x45\xd0\x98\x39\x01"
          "\x9d\x7a\xe9\x0f\xd1\x92\xda\x8c\xf5\x9c\xf3\x66\xb3\xc8\xb4\xb5\x0f\x2e\x75\x74\xe1\x2d"
          "\x80\x82\xd6\x09\x06\xe2\xc6\x55\x7b\x5a\xf6\x1d\x10\xf2\xa4\xaa\x7d\xa6\x09\x0b\xf0\xb3"
          "\x4e\x2b\xdd\x83\xf6\x9b\xc2\xd6",
          1, 3584 },
        { 128, 128, 18, "\xf2\xb0\xfb\x0c\xa1\xbc\x6f\x96\x34\x67\xb8\x80\x22\x46\xb5\xdc",
          "\x0c\xb1\x36\xc7\xd7\xa2\xff\x75\xbb\x78\x7d\x75\x3c\x27\x48\x53",
          "\xa6\x95\x7d\x52\x1a\x4a\x98\x38\x53\x95\x3d\x2d\x2a\xf8\x11\x81\x77\x0c\x10\xb3\xa9\x04"
          "\x59\x14\xb1\xca\xf4\x99\xde\x10\x14\x58\x61\x11\xc7\xa0\xb8\xe2\x15\x5b\x09\x99\x4b\x06"
          "\x53\xd7\x25\xc5\x34\x55\x28\xff\xc7\xb9\x6e\x59\xe3\x3a\xe0\x04\x0e\x9e\xf3\x31\xa3\xeb"
          "\xd1\xd2\x7a\xc6\xe5\x4f\x72\x00\xb0\xc4\xaf\xea\xcf\x93\x04\x81\xfd\x28\x48\x73\xd7\x7b"
          "\x3a\x14\x07\x75\x44\x5f\x5b\xdd\x6f\xb3\xf4\x81\xf1\xe0\x2a\xfc\x08\x96\x2f\x23\x95\x34"
          "\x37\x25\x40\xd7\x1e\xae\xe8\x06\xd0\x2f\x10\x96\xf4\xd1\x33\xa3\x78\xcb\x18\x3c\x1b\x32"
          "\x8b\xfe\x36\x16\x28\x44\x30\x8f\xab\x93\x63\x5f\xd3\x6e\x32\x23\x0f\x07\x4e\xba\x7c\xf1"
          "\x74\xfc\x16\x43\x76\x80\xdf\x80\xa6\x91\xb6\x1c\x3b\x33\xb9\x85\xb5\x72\x8b\x30\x73\x1a"
          "\xdc\x39\xd1\x86\xac\xba\x0a\xdc\x9b\x00\x81\x05\xe5\x88\x7f\xaa\xd1\x04\x45\x1f\x8c\x79"
          "\xb6\xbb\xcc\x72\x52\xa0\x50\x7b\x1c\xd5\x42\x16\x89\x68\x9d\xef\xbf\x4b\x4d\x20\x29\x69"
          "\xda\x63\xdd\x71\xee\x9e\x9d\x8c\x05\x1a\x7b\xce\x60\xd0\x62\xf4\x5d\x43\xcb\x2e\xe0\xc5"
          "\x91\x06\xfe\x6d\x41\x3e\xa5\x0a\xc3\x29\x8d\xce\xe3\xf5\xa0\xdf\x5b\xaf\xee\xea\x3c\x34"
          "\x3e\x86\xf5\x2b\x55\x9d\x09\x76\x68\x6f\x0f\x86\xd5\xd1\x85\x32\xbc\x3d\x3d\x7c\x87\x7c"
          "\xcf\x66\xf5\x98\x94\x33\x0b\xc9\x6b\x84\x81\xef\x0d\x35\x55\x8f\xb7\x8f\xc0\x6c\x07\x6e"
          "\x93\xae\xee\xd7\xc9\x9d\x68\x47\x76\x37\xaa\x63\x86\x1f\x26\xac\x6e\xc1\x00\x57\x0e\x17"
          "\x80\x25\x23\x2a\x74\x95\x39\xc9\x3b\x34\x84\x88\xee\xa5\xf0\xa9\x8e\x0e\xde\x63\x1b\x5c"
          "\xac\x25\x6d\x33\xd8\xa1\xea\x41\xb5\xcd\x49\x7b\x0a\xc4\x5a\xfe\x91\x1a\x89\x22\xa7\x62"
          "\xa5\xf7\x42\x42\x0b\x1c\x66\x09\x66\xbc\xc2\x77\x43\x25\x48\x84\x4d\x9d\x87\x32\x9c\xc0"
          "\x75\x7c\xcc\x24\x08\x3e\x7f\x2e\xe3\x46\xe1\x5c\x1b\x5e\x2e\x1d\x9d\x74\xe9\xfe\x50\x98"
          "\x8d\x1c\x55\xc1\x3b\x3e\x17\xaf\xf0\xb5\x0e\xe0\x5c\x9a\x8b\x53\x85\x86\x13\x1c\xf8\xaf"
          "\x2d\xc2\x8f\x26\x42\x63\x7a\x61\x07\x40\x02\x97\xf4\xdb\x36\x3b\x68\x8f\x80\x63\x45\x7e"
          "\xe3\x25",
          "\x9c\xd9\x4a\x14\xca\x1d\x94\xdc\x12\xd2\xce\x26\xb6\x5c\x65\x76\x44\xd9\x02\x4a\x8b\xb4"
          "\x0b\x50\xf0\xd0\xdb\x02\x1e\x68\xc2\xf0\x1a\xdb\xde\x76\xd4\x6c\x24\xd7\xa2\x3a\x9f\xfe"
          "\x98\xe9\xc4\x45\xc4\x4c\x8e\x49\x6d\xfb\x32\x4b\x89\x76\x2d\x34\x70\x0c\x0b\xf5\xe1\xd6"
          "\xcf\x02\x0b\x6f\x37\x07\x0c\xac\xb5\xe7\x0f\x35\x32\x9b\x98\x3a\xdf\x7e\x6c\xb4\x3b\x09"
          "\x80\xe0\x40\x87\x75\xa5\xee\x88\xb1\xc9\x3e\xd1\x0a\xe2\x59\x2a\xf0\x81\x23\x6e\x38\x05"
          "\xdf\x1c\xeb\x09\x14\x32\x1a\x53\xd2\xa2\xb9\x7b\xd3\x57\xf7\x8b\x29\xa5\xed\xb7\xcb\xff"
          "\x42\x97\x4e\x10\x66\xb8\x13\xc0\x26\x49\xd9\xcd\xcb\x1d\x63\xb7\xbd\xa8\x94\xb0\x98\xaf"
          "\xaa\x4a\xb1\xe0\x2b\x94\xe1\x20\x6e\xf7\x02\x4f\xcd\x62\x6b\x15\xac\x87\xbe\x37\x5a\x98"
          "\xc5\x05\x5d\xb5\x6f\x8f\x24\xa9\x69\x5a\x82\x78\x8f\x32\xda\x3d\x62\xa8\x72\x12\xd2\x33"
          "\xa0\xa6\xc8\xba\xfa\x1f\x5e\xd5\xcd\x77\x9b\xe9\x4d\x84\x92\x91\xfc\xc7\x0b\x14\xc4\xf3"
          "\xcb\x5d\xd6\xf5\xa3\x76\x7b\x2d\x91\x81\x8f\xb6\x6f\x8a\x45\x76\x4f\x73\x84\x15\x09\x52"
          "\x3d\x94\x6e\x83\x1a\x95\x54\x09\x49\xc0\xf7\xa7\x15\x6a\x36\xe5\x7c\xa7\xa0\x98\x86\x61"
          "\x13\x75\x57\xeb\x1a\x49\xda\x80\x2c\x26\x54\xc3\x39\xb4\xb1\xa8\xf6\x97\xf1\xfe\x82\x4a"
          "\x83\x3d\xc1\xbc\xd1\xa1\x0a\xd0\x82\x6a\x31\x78\xf3\x44\x6f\xe8\x56\xd3\xb8\xe0\x29\xaf"
          "\xc4\xea\xe0\xa7\x6b\x1f\x39\x1a\x15\xee\x41\x80\x5c\x1e\xa3\x32\x67\x72\xc2\x1e\x2f\xfb"
          "\xb3\xaf\x6a\x59\x42\xc3\x61\xab\x90\xff\x22\xef\x78\x0f\x95\x39\x91\x3b\xdc\xe2\x6a\xd8"
          "\x0d\x78\xaf\x2c\xc9\x77\xb8\x75\x06\x3f\xce\x9e\xe2\xa4\x2e\xde\x6a\x92\x90\xf3\x13\xe2"
          "\x22\xff\x8d\xee\xb1\x26\x49\x47\xa5\x5b\x4d\xa3\x22\xe8\xe8\xf9\x1b\x55\x73\x6f\x08\x54"
          "\x34\xf8\xee\xe0\x22\xc0\xf2\x0b\x51\x9f\xc3\x69\xea\xca\x0f\xcc\xdf\x78\x38\x7e\x04\xac"
          "\xfc\x0a\x04\x8c\x4a\x20\xc8\xc0\x95\x90\x87\x3b\xf2\xe9\x82\x28\xb8\x6c\xa7\x9b\xcb\x7a"
          "\xd7\x2c\x97\xc5\xc6\x46\xca\x1b\xba\x7e\x62\x25\x00\x1b\x39\x6c\x56\x42\x6a\xbe\x8b\x4c"
          "\x3b\x1f",
          1, 3712 },
        { 128, 128, 19, "\xeb\x8b\x7d\x20\xf9\xa4\x3f\x58\x9e\xde\xd2\xf1\xc2\x92\x56\xd1",
          "\xf0\x51\x82\x2f\x4d\x94\xe2\xad\x23\x25\x96\x45\xd3\xbe\x4a\x0f",
          "\xe3\x6a\x67\x5c\xdc\x16\xb4\xc9\x91\x37\xd9\xb2\xa4\xab\xce\x29\xc1\x80\xf3\x99\x61\x4f"
          "\xee\x43\x0b\xf5\xe4\x4c\x4c\xe3\x7a\x7f\x56\x9e\x67\xb0\xfe\x0b\x37\x08\xe3\x14\x2f\x59"
          "\x86\xb9\xd6\x75\x56\x44\xe0\x23\x79\x5e\xcc\x9a\x66\x6b\x30\xcf\xd7\x8f\xd4\x1e\x6a\x73"
          "\x91\x09\xcf\x25\x0b\x4a\x3e\x01\x3b\x2f\x50\xd9\xfe\x34\x13\xc8\xed\x82\x84\x85\x27\x19"
          "\x5f\xef\xe0\x8a\x7e\x63\x12\x44\x7a\x35\xa1\xec\xee\x40\x46\xc7\x1b\x0e\x56\x4d\x10\x55"
          "\x18\x10\x8d\x25\x19\xd0\xb9\x2c\x32\x39\xb1\x46\x25\xe8\x04\xef\x88\x31\xd3\x8f\x1e\xaa"
          "\x51\xc2\x3d\x20\x71\x55\x45\xd5\xa0\xcc\x88\xc4\xd6\xba\xc6\x66\xc3\x95\x77\x4d\xff\xad"
          "\xdf\xcd\x4c\x53\x7c\x8b\x85\x99\xa3\xf4\xe9\x5a\x00\x4e\x29\x41\x0b\x5a\x93\x85\xd0\xa0"
          "\x7b\x2f\xf5\x7f\xb2\x9e\x77\xb3\x43\x7e\xa0\xe1\xb8\x74\xe4\x38\x16\x7d\x19\x68\x13\x7a"
          "\x5e\x19\x10\xee\xa1\xcb\x39\x5f\xca\xa8\x66\x50\x5d\x65\x64\x7e\xf3\x5c\x98\xde\x10\xc7"
          "\x7a\x42\xf6\xeb\x96\x78\x0e\x42\xf0\x5f\x76\x3f\x04\x55\x21\xb3\x26\xf6\x63\x70\x72\xf2"
          "\x49\x2f\x82\x5c\x81\xfc\x96\x6f\x8c\x1e\x21\x8b\xe1\x1d\x60\xb4\x2f\x9b\xcc\x27\xfe\xd7"
          "\x1f\x9f\x4b\x66\x9e\x76\x26\x03\xbc\x5f\x35\x2b\x53\xcf\x09\x83\xe8\x18\x2b\x65\x10\xe8"
          "\xc4\x3c",
          "\x0d\xd0\x42\xd2\x8f\x30\x1d\x7b\x4d\xd3\xca\x3c\xd3\xc4\x1c\x78\xd3\x58\xd3\x8c\xac\x33"
          "\xd3\x3d\x16\x98\x78\xae\x98\xc2\x80\xec\x9a\x03\xf4\xfc\xa4\x6f\x72\xdb\x74\x42\x18\xee"
          "\x04\x44\xef\xba\xfd\x64\x1b\xcc\x76\x2f\x42\x2e\xa6\x6a\x70\x41\xf8\xd8\xde\xe2\xd9\x5e"
          "\x43\x86\x2f\xd7\x89\x8c\x0d\x47\xf4\x14\x12\x92\xe9\xc2\xa4\xa7\x3a\xe7\xf5\x71\x7d\x00"
          "\x9d\xf7\x70\x68\x22\xb4\x05\xbf\x2e\x33\x80\x4c\xe0\x0e\x15\xec\xca\x4b\x09\x85\x50\xaf"
          "\x2d\x02\xb0\x47\xc9\xd0\x63\x49\xdf\xef\xfa\x8d\xd7\xdf\x94\x69\xc3\xc1\xbb\x30\xdd\x0f"
          "\xbd\x7c\x0b\x9f\xb2\x7e\x4b\x41\x74\xdf\x3c\x96\x2c\x46\xaa\x15\x7e\x6a\xb7\x44\x6f\x0d"
          "\x1b\x90\x03\x49\xd0\x5b\xc8\xc5\x8d\x07\x1a\xba\xba\xd2\x81\xee\xd5\x36\x1f\xf2\x06\x53"
          "\xa4\x36\x15\xcf\xec\x04\x80\x95\x4e\x60\x23\x0e\x55\x9d\xcb\x69\x43\xb3\x1d\x62\xca\x49"
          "\xf1\xf8\x29\x47\x5b\xc5\x3c\x6c\x30\x63\x6e\x3f\x43\xa1\xb5\x58\xfe\x17\x33\x4c\x35\x89"
          "\xd1\xca\x67\x66\x7d\xd6\x5c\x03\x81\xe0\x4a\xdc\x64\xf2\xd2\x34\x7b\xaf\x71\xd9\xa3\xd0"
          "\x42\x02\x67\x80\x81\x10\x6c\x46\x0f\x6b\xbb\x7f\x7b\xa4\x8c\x1b\x1f\x4d\x9d\xca\x6a\x6c"
          "\x89\xd4\x91\x9b\x5b\x62\xb8\x6c\xd4\x06\xea\xe2\x6e\x5a\x22\x0b\x48\x7a\xf3\x4a\xab\xa6"
          "\x91\xba",
          1, 2304 },
        { 128, 128, 20, "\x1e\x69\xfd\x14\xca\x7f\x1b\xad\x99\x14\xac\x42\xf0\xb3\x27\x82",
          "\x28\xda\xa5\x2b\xab\x92\xb4\xd3\x04\xc2\xa9\x6f\x89\x88\xf8\xd7",
          "\x95\xc5\xbf\x47\x39\x9c\xfc\x40\xaa\xa0\xcb\x4e\xd5\xec\x9b\x52\xe2\xbc\xd0\xfe\x55\x91"
          "\x66\x3a\x36\xd0\xb6\x69\xf3\x3d\x1e\xa4\x56\x16\x8d\x93\x0a\x33\x5f\xb0\xf3\xe5\x02\xb7"
          "\x1a\x1b\x30\xd5\x9d\xec\xb0\xdd\xe9\xc6\xb4\x57\x6b\x35\x56\x1b\x3a\x30\xf0\x92\xa6\x96"
          "\x33\x4d\xdc\xa5\xfe\xca\xad\xcc\xe7\x5a\xcc\x00\xb7\x35\x41\xc0\x63\x34\x75\xaa\x6f\x5c"
          "\x6a\xaf\x82\x6d\x81\xa3\x41\x7d\x86\xb1\x5c\x6b\x77\x8b\xe9\x30\xcf\x05\xd5\xe1\x44\x6e"
          "\xee\x09\x78\x22\xb3\x44\xda\xdd\x0e\x86\xdb\x5f\x35\x3e\xbf\x2f\x63\x77\xfa\x45\xe9\x15"
          "\x1e\x2d\x02\x43\x3d\xa2\x4a\x8c\x88\x14\xd4\xa0\xb9\xdb\xbb\x0e\x93\xfb\xa1\x4d\xde\xd1"
          "\xbe\x3c\xac\x9b\xc8\x10\xe5\xe6\x5d\x2a\x1d\xd5\xfa\x37\x20\xcb\x88\x9c\x9e\x4a\x81\x1b"
          "\x38\x0d\x1a\xeb\x16\x66\x57\xdf\xe9\xa0\xbb\x0e\x30\x28\x63\x43",
          "\x2d\x94\x67\x14\xf3\xa6\xd8\x3f\x60\x12\x35\x07\x5f\x91\x9b\x7e\x42\x05\x47\x49\xd6\xc7"
          "\xd8\x0b\x61\xc2\xff\x94\x57\x76\xac\x26\x7e\xb5\xfb\xaf\x2c\x6c\xd8\x93\xc9\xcb\xa1\xd2"
          "\x72\xd5\xc1\xfc\xf3\x6a\x3a\x0e\x33\x9e\xec\x79\x0a\x48\xac\x92\x2b\x5f\x5b\xbe\x93\x6d"
          "\xc6\x94\x67\x92\x4e\x40\x08\x8f\x5c\x14\xd0\xf1\x5c\x5f\xbf\x0d\xdf\xe1\xa7\x59\xd0\x7f"
          "\x34\xc8\x0a\x47\xc9\x7d\x32\x9b\x1a\x54\x1e\xfa\x56\xd4\xc8\x17\x1f\xe9\xee\x7e\x36\x65"
          "\x7b\x2d\x96\xb1\xfe\x8a\x10\x15\xcb\xa2\x84\xa0\x56\x32\x7d\x4d\x20\xaf\x19\x25\xea\xe3"
          "\xf5\x2d\xe3\x24\xa0\x31\x29\x34\x60\xda\x3e\x73\x0b\xe9\xc8\x7f\x39\xa4\x9b\xcd\x57\x72"
          "\xa0\x1c\xa5\xbc\x11\xca\x9c\x98\x06\xc4\x82\x2f\x85\xd5\xdb\x54\x1b\x2b\x54\x0e\x1d\x4f"
          "\x59\x80\x91\x47\x94\x7c\x8e\x29\x15\x5f\x03\xf3\xca\x8d\x56\x9a",
          1, 1536 },
        { 128, 128, 21, "\x66\x6b\xba\xcb\xcb\xe2\x6e\x2c\xdf\x2b\x42\x73\x00\x5e\x51\x32",
          "\x6b\x26\x34\xfc\x87\xbd\xf7\x65\xe8\x2d\xf0\x67\x2d\xf3\x67\x60",
          "\x50\x03\x5e\x36\xeb\xe4\xca\xc4\x0c\x72\x8b\x91\x50\xec\xc1\x1c\x00\xb0\xf4\xf1\xed\x2c"
          "\xa0\x26\xe6\xb5\x28\xdc\x96\x83\x47\x0b\x44\x12\xb5\xc6\xdb\xd6\x41\x90\x4e\xec\xa3\xcc"
          "\xb7\x48\x4c\x5f\x8c\x17\x3b\x17\xb4\x4d\xfa\xce\x7c\xdf\xc4\x2a\x29\xd8\x00\xf5\x0c\x36"
          "\xea\xc2\x5f\x66\xde\xa7\x48\x73\x15\x90\x97\x11\xb7\x02\xaa\x69\xf8\x75\x56\x53\x21\xd2"
          "\xce\x3f\x15\xec\xb5\x90\xd1\x82\x7c\x10\x11\x7e\x6f\x43\x3c\x7e\x4e\x07\x6f\xe6\x9f\x45"
          "\x4c\x53\x31\x44\xb8\x1c\x14\xc6\x17\x0b\x48\xa6\x56\x53\x53\xbe\xfa\xaf\x98\xb8\x94\x94"
          "\x66\x6c\x6b\x37\x33\x61\x84\xdb\x1b\x8d\xdc\x27\xea\xc9\xfc\xb0\x91\x6d\x5a\x56\x5a\x7c"
          "\xee\xbb\x07\x50\xaf\xcb\xa5\xcb\x90\xeb\xaf\xe8\x9e\x8a\x7e\x82\xae\x5a\x0b\x55\x38\x00"
          "\xd7\xe4\xd5\x11\x07\x79\x66\x07\x7a\xab\xc7\xfd\x5c\x09\x4c\xee\xd3\x81\xd6\x9c\xd8\x18"
          "\x08\xd6\xe4\xe8\xe5\xb1\x41\x6f\x89\xa0\x2e\x86\x63\x57\xe5\x54\x43\x2e\xb7\x38\x5c\x8f"
          "\x5e\xe5\x06\xf6\x27\x45\x63\xaf\x52\x1b\x11\x64\xef\xea\xa5\x52\x5d\xd8\x4e\x4e\xad\x52"
          "\x25\xfa\x06\xda\x5e\x15\xee\x02\x23\x69\xd5\x85\x51\xff\x98\x48\xd3\x33\xc0\x3a\xaf\xff"
          "\x18\xf6\xb5\xd2\x06\x89\x2a\xb6\x60\xb0\x11\xf1\x4a\x25\x7c\xc8\x8e\xb1\x11\x77\x7f\xd5"
          "\xb0\xc4\x78\xba\xf8\x74\x52\x2c\xba\x34\x83\xd6\x9c\x0d\x6a\xa6\x35\x70\x0e\x02\x5a\x5d"
          "\x39\x96\x32\x6a\x9a\x2d\x85\xd4\xce\xca\xe9\x26\x54\xe0\xd8\x9b\x90\x50\x27\xa7\x77\x9f"
          "\xcf\x6f\x32\xac\x11\xda\xd0\x1a\x6b\xb4\x05\x12\x6a\x31\x41\x00\x37\xb7\xcd\xde\x4f\x7b"
          "\xb7\xda\x2b\x11\xeb\xaf\xf6\xef\xc8\x80\x31\x87\xdc\x50\xfd\xb8\xec\x91\x32\xa8\x5b\x57"
          "\xb9\x32\x4d\x1f\xc4\xc2\xde\x81\xf0\x3b\x75\xca\x61\x02\x51\xdb\xd7\xba\xed\x67\x71\x50"
          "\xd3\x13\xf3\xcb\xd8\xc4\xc5\x0b\x17\x07\x45\x44\xd1\x3a\x99\x5a\x5e\x43\x78\x59",
          "\x51\xd0\x6a\x8a\x43\xdc\x8e\x1c\x66\xe6\x80\xbb\x6f\xdb\xc5\xca\xb9\x5f\xf9\x73\x0d\x62"
          "\x2f\x58\x92\xf8\xff\x5c\xea\x10\xaa\x6b\x40\x68\x34\xac\x78\x62\xea\xa9\x6f\xa2\x42\x51"
          "\xa3\xf9\x21\x1f\xe8\x5d\xfb\x03\xd8\x25\xf0\x6f\x42\xce\xe4\xdd\x47\x88\x46\x12\x45\xdc"
          "\x93\xb6\x89\xb2\x92\xd0\xaf\xe9\x3d\xcd\x59\x94\xd7\xe4\x0e\x1b\xaf\x91\x0d\x85\x7d\xc9"
          "\xff\xa6\x19\x84\x69\x15\x5f\x30\x69\x31\x95\xbe\xc3\x43\x4a\x06\x59\x78\xce\x19\x94\x65"
          "\x81\x2b\x7f\x90\x09\xd4\x1c\xfd\x56\x07\xe0\x76\x9e\x8e\xfd\x4f\xc9\xc2\x13\x2e\x43\x62"
          "\xae\x3e\x73\x24\xa8\xd6\x72\xe7\xa9\x36\x2d\xaf\x78\xae\x1a\x16\xb8\xfd\x4d\xd5\xd5\xfa"
          "\xc1\xc7\xcd\x80\x09\x89\x59\xcf\xa0\xca\xfc\x76\x1d\x94\x80\x65\xfb\x7b\xa4\x2e\xe2\xed"
          "\xe8\x6d\xdd\x68\x07\x14\x48\xee\x28\x5b\xcc\x93\xd2\x1c\xa0\xcd\xae\xa1\x7a\x2d\x31\x23"
          "\xdc\xad\xa6\xae\x60\xdb\x1d\xef\x5e\x12\xfd\x57\x5e\x07\x85\xab\x48\xa6\x0d\xf1\x75\x4e"
          "\xb9\x35\x97\xb8\x00\x95\x4a\xcc\xd7\x1a\x5b\xaf\xf9\x86\xcb\x62\xe7\x8b\x54\xc4\xe1\x60"
          "\xf4\xa7\x20\xe7\xb6\xad\x3b\x2e\x13\x2f\xd1\x7c\xe4\xa6\xec\x3d\xfd\xe9\xcf\x69\xc6\xea"
          "\x03\x4f\xf9\x2f\x39\x29\x4a\x9c\x58\xe1\xea\xeb\xb9\x18\x8b\x39\xdf\x9b\x10\xc7\xd0\xb2"
          "\x73\x77\xdb\x77\x04\xf3\xb3\x0e\x61\xee\x89\xb7\x54\x72\x25\x15\x1b\xc2\xc5\x45\xfe\xb2"
          "\xce\x41\xc3\x32\x04\x62\xbc\x07\x1d\x19\xff\x29\x27\x4a\xc7\x7e\x19\x46\x1c\x35\x08\x71"
          "\xfd\x94\xb2\xac\xfc\xce\x8a\xa1\x45\xd5\xbf\xb0\xa8\x0e\x80\x8c\x21\x20\x37\x0c\x72\x55"
          "\x8b\x1b\x34\x42\xbb\x84\x71\x97\xce\xb5\x20\xc5\xf2\x71\x9d\x6b\x56\xc7\xd7\xf1\x0e\xa9"
          "\x9a\xe4\x09\x7a\xb6\xcd\x05\xb3\xaf\xba\x8d\xef\xdb\x80\x74\x15\x13\x2a\x6c\xed\xc3\x47"
          "\xcd\xe3\x25\x5f\x66\xf0\x72\x7f\x36\xa1\xd3\x1d\x3e\x25\x89\x85\x7f\x38\xa5\x96",
          1, 3328 },
        { 128, 128, 22, "\x57\x08\x26\xef\x18\x8e\x84\x50\x5f\x30\x24\x7e\x3f\x43\x85\xae",
          "\x60\xf6\x70\x1b\x64\x23\x9e\x82\xf6\x3c\x4e\xc9\x20\xb6\xce\xe4",
          "\x94\xd4\x02\x1b\xec\x59\xc2\xbb\xf6\x26\x0f\xa9\xab\x83\x79\x55\x1b\x8b\x1a\x41\x4f\xf1"
          "\xac\x22\x85\xde\xc8\xda\x41\x7d\xa3\x65\x3b\x51\x36\xda\x9c\xff\x1a\xd2\x93\xcf\x88\x75"
          "\xaf\x1c\x90\x9a\xf9\xe9\x95\x00\xc1\xc9\x0f\xa3\x47\xfc\x41\x61\x03\xa2\x02\x35\x76\xf6"
          "\x3b\x3f\xf2\x5f\xa0\x2b\xf8\x72\x8a\xe1\x29\xf5\xd9\x10\xa7\xad\xf6\x13\x64\xac\xe3\x17"
          "\x51\xb7\x93\xfc\x4d\x0b\x87\xad\x43\xf3\xa3\x24\xa5\xca\x16\x24\xfa\x11\xfb\xdb\x94\x54"
          "\xda\xf6\x0b\x73\x32\xe3\x0f\x83\xff\xed\x1e\x3b\xe9\x01\x4c\xca\x4d\x31\x89\x2a\xdf\xd2"
          "\x47\xaf\x95\x0f\xb2\x6f\xdd\x9b\xc3\xda\x29\x08\x8b\x49\xcf\x53\xc4\xd6\x24\x94\x2d\xfc"
          "\xf9\xf5\xf1\x92\x35\x48",
          "\x70\x31\x7d\xe6\xd1\xa1\x83\x0d\xc0\xca\x37\xa4\x57\xc0\xf2\x22\x83\xf4\x66\x45\x61\xb1"
          "\x30\xca\xba\xe8\xb9\xb8\x2e\xdb\xfb\xc2\xb5\x86\x55\x5d\x37\xbd\x98\xee\x3d\x35\x7d\x72"
          "\xb7\x5b\x60\x10\x87\x39\x59\xc1\xb7\xeb\xbc\x00\xc8\x91\xad\xc6\x62\x27\x59\x8c\x4f\xa4"
          "\xdc\xdf\xc5\xf1\x19\xfc\xeb\x65\x4f\x8c\x0b\xe6\x72\xf5\x0d\xee\xdf\xc3\x3c\x0c\x97\xf6"
          "\x88\x06\x8a\x9c\x5a\xc2\x51\xae\x13\x4d\x09\x10\x76\xb6\x21\x4d\xf6\xce\xd2\xd1\xc7\x65"
          "\x38\x60\x50\x3f\x29\xb8\xa1\x38\x8e\xab\xaa\xa3\x9f\xae\x0d\xd3\x35\xf7\xde\xc7\xce\x5c"
          "\xf8\x93\xc7\x1d\x90\xa2\xef\xe6\x6d\x07\xa4\xda\xc5\x0e\xad\xb6\x58\xa4\x71\x9d\x3c\x97"
          "\x6d\x6d\x40\x74\x8b\xa6",
          1, 1280 },
        { 128, 128, 23, "\xc6\x17\xae\x85\xa7\x7a\xc3\xf0\xdc\x29\xca\x6f\xcb\x82\x31\x26",
          "\x59\x20\x3e\x5e\x7f\x7a\xa8\x24\x4d\x27\xbc\x5c\x13\x4a\xbe\xbb",
          "\xc7\x56\x86\xf2\x2f\x10\xbd\xa9\x65\x65\x14\xd5\x9b\x81\xd1\x9b\xe7\x71\x93\x97\x15\x17"
          "\x62\x2b\x92\xf1\x19\x67\x78\x98\x93\xd5\xaa\xd9\x01\x83\x2c\xa9\x33\x9a\x0f\x18\xab\x92"
          "\x89\x37\x51\x69\xf3\x0e\x97\xd7\x92\xc1\x74\x49\xd3\x80\x4e\x74\x5f\x76\x5b\x7c\x0c\xe4"
          "\x0a\x2c\x84\x51\x13\x80\x76\xc5\x3d\x21\xaf\x7e\x7c\x6c\xac\x53\xd8\xa6\xb9\xdf\xcc\x27"
          "\x1a\x50\xf6\x3a\x11\x2b\xc1\x0f\xb9\xcc\xd7\x51\x23\x1a\x9f\xbf\x58\xfc\xda\x8f\xb9\x25"
          "\x2b\xb5\xa4\x1e\xdc\x76\x0d\x57\x8a\x81\x43\x63\x8a\xd3\xac\x02\xe9\xe9\x62\x09\xa8\x13"
          "\x0d\x48\xce\xa0\x6e\x69\x51\xcb\xd1\x4a\x14\xc9",
          "\xf2\xb4\xba\xda\xed\xc6\x0d\x42\x4d\x64\x44\xa1\x2d\xae\x8c\xc2\xe0\xe1\xae\x4e\x6e\x08"
          "\xcf\x80\xf6\x46\x2b\x66\x70\xb1\x0c\xe6\xee\x66\x80\x81\x94\xa9\x76\xdb\xdb\xb9\x52\xef"
          "\xb8\xa9\xdb\xe9\xf7\x63\xd2\xf4\xd5\xdb\x6e\x18\x1c\xbc\xe8\x65\x01\x04\xb8\xe7\xaf\xce"
          "\x29\x78\xfa\x38\xb8\xbb\x1f\x64\xc2\x89\xe1\xcc\x1e\x4e\xed\xb7\x9a\x2c\x27\xad\xf2\xce"
          "\x47\xd6\xa6\x86\x94\xd9\xaf\xe2\xc8\x5c\xcf\xb1\xc6\xab\x40\x53\xf6\x44\x42\xbc\xee\xd8"
          "\x3d\x89\x33\x3a\xc3\x9f\x03\xab\xa1\xbe\x1c\xd0\xab\x8f\x17\x3f\xdd\xb7\xc2\xe4\x93\xcf"
          "\x93\xe3\x9c\x1d\xdc\xe1\x53\x71\x28\xa2\x83\x16",
          1, 1152 },
        { 128, 128, 24, "\xd9\x57\xd6\xc3\xa8\xe2\x32\x83\x3a\xc4\x88\x33\xce\x67\xcc\x43",
          "\xdb\x75\x4e\x4a\xde\xfa\xa9\xa0\x90\x5e\x72\xf4\xf3\x3c\x65\x96",
          "\x86\x89\x63\xfc\xff\xf3\x7f\x82\x5b\xba\xd9\x47\xcc\x1f\x87\xcd\x8d\xde\xe9\xa1\xec\x7d"
          "\x29\x9e\xa8\x0d\x74\xbe\x28\xe8\x41\x4b\x8d\x0f\x82\x2d\x86\x5e\x5f\x92\x03\xfc\x9b\xf3"
          "\xc8\x85\xdc\x07\x9b\x9d\xc8\xf6\xe9\x69\x4d\x63\x66\x2e\x4c\x11\xdd\x37\xff\xfc\x14\xd9"
          "\xd8\xf4\xd4\x27\xc5\xa5\x32\xc7\x73\x88\x89\xc5\x31\xc8\xcb\x89\xc7\x20\xed\x68\xfe\xf2"
          "\x9c\x63\xd0\x94\x8b\x64\x1f\x4c\xae\x1a\xce\x36\x5d\x62\x50\x08\xb2\x1b\xf0\x2f\x00\x9d"
          "\xf0\x7b\x7e\x97\xd9\x80\xfb\x34\xa5\xca\x2c\xd3\x8d\xe3\x1d\x41\xf3\x55\x6b\xb2\x66\x2b"
          "\xf3\x4a\x3e\x09\x5a\xbd\xe1\x03\xa6\x60\x7f\xaf\xa1\xdd\x1f\x99\xd5\xbe\xda\xc9\x3b\xab"
          "\xa9\xe1\xd5\xf4\xcf\x85\x3d\x49\xf8\x49\x49\xb3\xcd\x18\x5d\x19\x8a\xaf\xc7\x2f\x79\x7b"
          "\xf6\x90\xde\x58\xc2\xb5\x74\x63\x43\x41\xb6\x94\x2f\xd6\xec\xb2\x28\x15\xa4\xd1\x31\xc6"
          "\xec\x98\xd2\xba\x09\xa7\xd4\x9e\x4f\x37\xe8\x6a\x96\x46\xe0\xa5\x8d\x42\xdc\xc7\x0d\xe8"
          "\x52\x60\xc6\x87\x69\x7e\x41\xfc\x3f\x96\xcb\xfe\x42\x53\xa2\x00\xcf\xbe\x92\xaa\x74\xc7"
          "\x1a\xa8\xea\x49\xb2\x10\x0a\xf2\x1a\xa0\x07\xfe\xbe\x77\x7d\xdb\xcd\x9d\xee\xb6\xbd\x94"
          "\xb7\xae\xd5\x2e\x82\x24\x2d\x60\xa7\xc3\x37\xad\xf8\xfe\x4b\x40\xcd\xe3\x00\x22\xbd\x93"
          "\xa3\x27\x1a\xd3\x06\x94\x98\x4f\x1e\x7b\x7c\x80\xd7\x5a\x51\xda\x80\x7c\xdf\x96\x07\x95"
          "\x47\x64\x5d\x7a\xa8\x6b\x59\x72\x77\x2f\x30\xa0\x35\xaf\x56\x20\xe3\x6a\x67\x35\x4b\x8b"
          "\xad\x5b\x94\xed\xf4\x16\x84\x99\xe1\xaa\x0e\x7d\xee\x0d\xe4\x24\x43\xf6\xdd\x33\x54\xf6"
          "\x01\x4d\x65\x6c\x53\xff\xaf\x94\xf3\x09\x2d\x76\x55\x55\x6d\xed\x34\xb5\xde\xf3\x24\xf6"
          "\x2d\x86\x32\xab\xab\xdd\x91\x66\xdc\xa9\x36\xe9\xf7\x87\x4a\x9a\xc6\x71\x78\x1b\x48\x98"
          "\xfa\x93\x33\xc9",
          "\x70\x93\x3c\xe2\xc4\xd5\x04\x47\xf4\xee\xef\xc9\x1b\xbb\x73\x5c\x17\xc3\x21\xae\x42\xbf"
          "\x84\x98\xf4\x86\xb2\x1b\x85\x1f\x6d\xfe\xf2\xb8\x94\xe4\x95\xf6\xab\x4b\xe5\x1d\xf2\xca"
          "\xbc\xee\x5f\xc7\x1f\x49\x1b\xec\x9e\x2b\xce\x6d\xc9\x06\xa8\x32\xb4\x0e\x0b\xf1\xdd\x7a"
          "\x57\x3d\x9d\x5e\x4a\x1d\x00\xb7\xc1\xbf\x94\xf2\x66\x3e\x5b\x36\x25\x53\x30\xc8\xa1\xa6"
          "\x41\x9d\xab\x33\x38\xdb\xf6\x9f\x2d\x74\xb9\xee\xb3\xfa\x96\x15\x54\x28\x87\xe9\x99\xbf"
          "\x7b\x63\x1a\x29\x35\xe3\x8d\x9d\x65\x9c\x7f\xe9\x64\x72\x91\xc5\xcb\x41\x39\x93\x93\xca"
          "\xe2\xf8\xf3\x96\x96\x17\x6d\xfe\xfe\x96\x1b\x1a\x10\x59\x05\xbf\xfa\xab\x79\x86\x9b\x34"
          "\xd7\xf6\x04\x37\xe2\x96\x5f\xe1\xcd\x66\x1d\x8c\x21\x06\x9f\x08\x77\x86\x1e\xbf\xee\x0a"
          "\x18\x3a\x8f\x58\x4f\xef\xf2\x59\xe4\x52\x7f\xab\x7b\x4a\x74\x4e\x46\xd8\x08\x2e\xd4\x28"
          "\xb1\xc2\x38\x8d\xe5\xa5\x8a\x4b\xc7\x79\x7a\x48\x21\xa1\x79\x56\x94\x85\xe0\xd7\xc8\x9a"
          "\xf2\x2c\xac\xfc\x36\xd2\x1e\xaa\xc3\x01\xa8\xeb\x92\x4b\xbd\x45\x53\xa5\xbd\x3b\xdd\xa4"
          "\x30\x13\xc3\xe2\x31\xc6\xfa\x6e\x74\xfa\x6d\xf7\xf4\x83\x8b\xdd\x71\x21\x70\xfc\xd0\xd5"
          "\xf5\x8d\x53\xbb\x6c\x69\x3d\x24\xbb\xd8\xec\x44\xa6\x4c\xe5\x2c\x79\x76\x8b\xd2\xcf\xa5"
          "\xae\xdf\x38\xf3\x4b\xa1\x7b\x11\x71\xf7\xec\x31\xca\xd1\xa7\x30\x3f\x3c\xd0\xa3\x61\x64"
          "\x93\xa6\x2c\x4c\x57\xdf\x60\xc6\x51\x62\x4f\xce\x67\x02\xd3\xff\x8e\xd9\x69\xc7\x43\x9a"
          "\x36\xd1\x61\xc0\xd9\x17\x32\xab\x02\x76\x5c\x7b\x40\x0e\x3a\x7b\xd5\xe7\xb0\xb5\xbf\x3d"
          "\x59\xac\x39\xf7\xe8\xf7\x3e\xfc\x2d\x18\x79\x40\xe1\x2b\x89\x43\x5f\x70\x4f\xd6\xed\xa4"
          "\x02\xa6\x2a\x9b\xda\x72\x52\xf7\x5a\x8f\x21\x46\x95\x18\xfa\x92\x85\x48\xc1\x58\x34\xd4"
          "\x39\x0a\xc6\x92",
          1, 3200 },
        { 128, 128, 25, "\x66\x96\x4f\x8f\x9b\xa4\x24\x9c\xa0\x24\x0e\xdb\x0a\xaa\xef\xe2",
          "\x78\x5a\x3e\xe0\x66\x48\x43\x07\xa2\xad\x18\xec\x7c\x9c\x8f\x4a",
          "\x08\x44\x02\x22\xe7\x65\x3c\x4c\x16\x33\xa6\xa1\x8d\xac\x02\x04\x8d\x8e\x66\x0f\xc2\x4e"
          "\xbf\x53\x6c\x61\xbe\x10\x7d\x59\xb6\x0f\xd0\xb1\xe5\x3b\x90\x75\x74\xfd\x71\xcf\x29\x1c"
          "\x84\xd8\xa7\x14\x63\xd6\x8e\xd3\x22\xa8\xe1\xca\x28\xea\xb1\x87\x37\x63\x01\xb1",
          "\xcc\x9b\x49\x79\x57\xa6\x57\x27\xa8\xd4\xd1\x1c\x4e\x92\x49\xc7\x36\x5a\x81\x7e\x57\x2e"
          "\xd8\xf5\x23\xe5\x01\xbf\x0d\x5d\xec\x2b\xa9\x45\xde\x1a\x41\x71\x66\x0c\x8b\x59\x0f\x20"
          "\xc1\x5e\x36\x56\xb9\x99\x3c\xb4\xce\x5a\xd8\x46\x4d\xf8\xf0\xa6\x9b\xbd\xf6\x96",
          1, 512 },
        { 128, 128, 26, "\x51\xe7\x1e\xae\x30\xd1\x3e\x2e\x38\x87\x7b\xe2\xb9\x26\xfc\x8c",
          "\x94\x57\x44\x51\x75\xd6\xb7\x70\x34\xcc\x9c\x64\x05\x3f\xe5\x18",
          "\x35\xe7\xa4\x7e\x7f\x27\x81\x91\x07\xde\x29\x75\x1c\xcf\x84\x24\xdf\xea\x59\x8d\xb2\x9b"
          "\x5e\x2b\x20\x1d\x7c\x23\x55\x22\x3e\x21\x4c\x6d\x47\x59\x31\x0a\x92\x8b\x00\x9b\x8a\x2a"
          "\x07\x2c\xa3\x1d",
          "\x7b\x5d\xd5\xbe\xbf\xdf\xc6\xb5\x4c\x7c\xfb\x27\xf9\x53\xe5\xbc\x60\xc1\x1a\xa3\xa7\xfe"
          "\x59\xa7\x56\x29\x6d\x41\x4b\x6e\x90\xfb\x23\x56\xca\x50\x80\x28\xa0\xfb\x5b\xc9\xe0\xe9"
          "\xc9\x02\x24\x7e",
          1, 384 },
        { 128, 128, 27, "\x91\x88\x58\x06\x3b\x1b\x0f\xc8\x20\x7c\xf8\xbc\x5f\xdc\x07\x3d",
          "\x18\x0f\xdc\x55\x61\x4d\x37\x44\x9e\x60\x18\x0c\x24\xa0\x61\x3e",
          "\xdf\x93\xb5\x13\x28\x23\xeb\x8f\xa3\xce\x47\xa1\x04\xd6\xc8\x37\x0e\xba\x95\x3c\xa2\x7e"
          "\xb4\x00\x98\x93\xdf\x43\x74\x80\xcf\xa8\xe9\xf2\x02\x04\xfa\x03\xa3\xc9\x08\x2c\x24\xeb"
          "\x2f\x56\x2a\x74\x1a\x2f\xcb\xbd\x13\xc5\xab\x74\x2f\x1b\x57\x65\x01\x83\x11\x3e\xc7\x91"
          "\xec\x76\xcb\x70\x65\x08\x13\xad\xef\x86\xef\xc8\xca\xc2\x5c\xf0\x13\x1a\x77\x2e\xb5\x47"
          "\xd7\xe2\x27\x24\x79\x43\xd0\xfc\x45\x26\xee\x0d\x18\xb0\xa8\xc9\xbb\xc8\x21\xed\x30\x2d"
          "\x61\x13\xe9\x57\x7e\x17\x92\x9d\x36\x25\x04\xf6\xb6\xe7\x70\x9b\xe4\x98\x65\x8e\x4c\x30"
          "\xb8\x32\x54\x90\xcc\x77\x58\x65\xac\x6e\x06\xcd\xb4\x21\xb4\x90\x74\x62\x50\x3e\xff\x96"
          "\xc0\x46\xcb\x8e\x86\x87\xa9\xa5\x96\xaa\x61\x2b\xaa\x21\xb1\xd5\x31\xa3\xec\xec\xd4\xb2"
          "\x52\x83\xbf\xbb\xd3\xf2\x79\x9c\x69\x6b\x41\x68\xa4\xd3\x1c\xbc",
          "\x17\x5d\x6c\x58\xa9\x1f\x9d\x61\xf2\xea\x17\x70\xba\x29\xcd\x6c\x37\x4b\xd9\xfb\xbe\x74"
          "\xc2\x3d\x5d\x87\x50\x87\x50\x36\x6c\x46\x5d\xa4\x90\xa6\x0c\xb5\x8e\x78\xf2\x90\x87\xfa"
          "\xbf\xae\xf6\xfc\xae\x8d\x82\x56\xea\xd6\x0c\x14\x7a\x0d\x9f\xc3\x50\xb2\x5e\x99\x16\x0f"
          "\x11\xa7\xcb\xde\x34\x2f\xea\xd5\x29\x8c\x6f\xce\x4b\x6d\x3e\x55\x0b\x2c\xf0\x82\x4e\xcc"
          "\xab\x1d\x96\x6f\x8b\x94\x18\x7d\xe8\x17\xdf\xf9\xce\x23\xbc\x94\xf2\x3f\x24\x94\x6f\x93"
          "\x01\xdd\xf2\x06\xb0\xa4\x6a\xb5\x5c\x90\x7e\x8e\x47\x3d\xdf\x45\xd7\x29\xb3\x96\x2c\xc5"
          "\x6c\x96\x51\xbb\xb0\x8a\xb8\x49\x06\x72\xaa\x15\x2a\xcc\xa4\x8a\x93\x7f\x06\x70\xa7\xeb"
          "\xb1\x23\x1b\x9f\xb0\x7d\x53\x7a\x68\x07\x49\x6c\x26\x87\x61\xfb\x16\x9e\xdf\xc5\x48\x15"
          "\xe7\x75\x9c\xc1\x78\xcd\xa0\x46\xbd\x2b\x0b\xfc\xac\x47\x64\x02",
          1, 1536 },
        { 128, 128, 28, "\x57\x22\x7f\x8b\xbc\x1a\xd7\x8d\xed\x0b\x5a\x3c\x4c\x84\x31\x0f",
          "\x95\x53\xc9\x2c\xea\x37\x00\xde\x74\x46\x2b\x41\xf6\x78\x72\xc2",
          "\x13\xed\x14\x1c\x52\xd6\x98\x76\x25\x5c\x4e\xb1\x58\x31\x15\x44\x23\x34\xaa\x79\x50\x52"
          "\xdb\x60\x28\x34\x38\xa1\xb2\xaa\x18\x3d\x36\xea\xfd\x3f\xf7\x2c\xdc\x8b\x4d\x77\x4c\x9c"
          "\x62\xff\xb1\x91\x96\x2a\xaf\xc9\xf8\xda\xdf\x7e\x8c\xaa\x7f\xb6\xf8\xa4\x3a\x1b\x30\x2e"
          "\x32\x1c\x77\xab\xcd\x79\x6f\x1e\xda\x9d\x1a\x5b\xb4\x69\x7a\x1c\x4b\xd3\x13\x34\x86\x36"
          "\xa1\x7b\x1f\x5f\x74\xf5\x9e\xc9\x44\x18\xaa\xe1\x08\xeb\xfc\xc5\x17\x7e\x79\x89\x9c\xfd"
          "\x71\xf1\x01\x16\x7b\xf0\x09\x37\x3a\x84\x05\x35\xda\x36\x96\x5d\x1d\xa7\x9e\xf4\xf0\xde"
          "\x43\xbd\xf4\xa3\x60\xe0\x2f\xf2\x4c\x77\x5a\x10\xa9\x64\x10\x78\x6a\x00\x08\x21\x70\xcc"
          "\xc5\x3a\x4d\xd4\x27\xfd\x5f\xee\xf0\xc1\x61\x21\xb5\xed\x00\x8e\x63\x92\x38\x39\x47\x8e"
          "\xc9\x04\x05\x6e\xd9\x58\xbd\x01\xac\x6c\xa7\x78\xfc\xda\xee\x6e\x5f\xd1\x9b\xae\x0b\x3a"
          "\xf3\xd8\xcb\xf5\x35\xa5\xc7\x65\x9b\x69\xd3\xc0\xf8\xd3\xc6\xc2\xd1\xca\x2a\x32\x67\xd0"
          "\xa1\x88\xbf\xb5\xca\x5b\xb9\xe1\xfb\x57\x91\xd5\xa4\x76\x83\x94\xe3\x49\x41\x13\x02\xc6"
          "\xa9\x2d\x5e\xe1\x5a\xb7\x84\x48\x35\xc8\x65\x4f\xa4\x24\x9c\xc1\x60\xb6\xf4\xa4\x82\xf6"
          "\x30\xb1\x0d\xd4\x8d\x5a\x60\xff\xd0\xb0\x25\xd2\x53\x24\xb8\x27\xff\x75\x2d\xfc\x4e\xfa"
          "\xcf\x94\x89\x39\x52\xeb\x79\xdb\x4e\x1e\x98\x45\x50\xe4\x9c\xda\x78\xea\x5b\x34\x02\x16"
          "\x96\x59\xaa\x61\xd8\x3a\xba\x0e\x75\x1b\x5e\xfb\xc7\x8b\x4f\x73\x44\xd6\xdd\xbf\x63\xe3"
          "\xb4\x9b\x88\xc3\x34\x53\x8a\x55\x60\x08\x1d\x95\x9e\xb6\x1a\x92\x48\x05\xba\x5f\x1c\xe4"
          "\x21\x4f\x35\x85\xb4\x88\x02\xef\x53\x9d\x09\x7b\xd9\xf1\x61\x5c\x38\x1d\x3d\xe3\x35\x38"
          "\x00\x88\x2b\xe0\x54\xbd\x02\xa1\x62\x28\x70\xc6\x5b\xce\x55\x89\x18\xf3\x16\xf7\x56\x62"
          "\x9d\xa1\x1f\xdd\x9c\x26\xc3\xd6\x66\x08\x4d\x3d\x88\x2a\xce\x32\xd5\x82\x0b\xc8\x24\xf3"
          "\x45\x4d\xa4\xa1\x70\x72\x35\xb7\xb5\x08\x80\xcf\xdc\x6a\x8e\x26\xd0\x48\xeb\xaa\x80\xa6"
          "\x70\xc3\x57\xd9\x93\x2b\xbd\x0e",
          "\x0d\x43\x3b\x71\xaf\x11\x6f\xcd\x33\x5a\xdc\x1c\xdb\x21\x70\xbe\x24\xc5\x79\x35\x71\xc3"
          "\xd5\x11\xb0\x4d\x6b\xa8\x9a\xb6\x8f\xc3\xe7\xa2\x1b\xe5\x01\x98\x38\x9d\x8c\x8d\x83\x7c"
          "\x2a\xf5\x37\xe3\x85\x89\x2a\x41\x69\x88\x03\xd5\xf6\x25\xfa\xb0\xbc\x4e\xc3\x0b\x39\x73"
          "\x63\x10\x6f\x30\xe3\x53\x8d\x27\x75\x2a\x90\x1a\x3e\x6e\xb7\xe7\xa8\x0d\x1c\x1f\x7d\xdf"
          "\x7e\xa5\xec\x4e\x0a\x2b\xe0\x4f\x52\x28\x6b\x07\x8b\xf7\xcc\xab\xeb\x5a\x8b\xd4\x9a\xfd"
          "\x61\xc0\x8e\xda\x80\x1c\x97\x7a\x0e\x5e\xc1\x73\x1c\x51\x8c\x85\x2b\x1a\x87\xb7\x97\xef"
          "\xc5\x16\x49\x67\x8a\x2a\x38\x43\x6e\x7e\xa5\xba\x55\x2e\xcc\xe8\x08\xb8\xb2\x57\x19\x0a"
          "\xae\xf6\x24\x16\x44\x8d\x4f\x17\x7c\x0e\x29\x12\x12\x67\x6a\x84\x51\xc9\x47\x10\x56\xfa"
          "\x29\x4a\xd1\x84\xa2\x5d\xf4\x3d\xc2\xf0\x3e\x4a\x83\xd5\x29\x28\x00\x95\xf6\x9e\x20\x30"
          "\x94\xdf\x88\x12\xfa\x86\xd1\x55\x88\x9d\x11\x22\xbf\x58\x7e\x99\x49\x07\xb1\x5a\x2c\x19"
          "\xcd\x12\xdc\x2c\x9c\x88\xb8\x03\x0f\x9a\xb1\xd8\x43\x25\x3d\x44\xec\x47\xbb\x76\xc1\x4f"
          "\x31\x11\x2a\x13\x6d\x8f\x26\xea\xdb\x82\xf1\x87\x87\x41\x9e\x74\x61\x49\x7d\xfa\xc8\x7f"
          "\x22\x89\x42\xf2\xd7\x02\xb2\xb3\x88\xf5\x82\xaa\x09\x55\xfe\x1a\x9f\xcc\x41\x12\xe8\xc9"
          "\xe2\xec\x89\xe1\x1f\x53\x35\xa0\x82\xbc\x39\xdb\x5e\xb6\xda\xef\x3a\x4f\x8b\xd1\x70\x8c"
          "\xb6\x9d\xcf\x84\x88\x34\x23\x08\x1c\xdb\xeb\x91\xd2\x56\xd7\x67\x35\x9a\xdd\x48\x4b\x09"
          "\xfa\xef\x0f\xcd\x11\x20\x65\x99\x6a\x97\x19\xc2\x69\xb7\x23\x36\xf0\x48\x18\xf9\x69\xb2"
          "\x09\x21\x1f\x0c\xe3\x7c\x5a\x29\x18\x1a\x9c\x35\xfb\x99\xae\x46\xa3\xf7\x99\x8a\xac\x56"
          "\xd1\x31\x02\x54\x17\xd1\x73\x66\x8c\xe2\xc8\xfe\x11\xb8\x7b\x5a\x9e\x17\x47\xd2\xc3\x4d"
          "\xef\x6c\x24\xb9\x9f\xec\x94\x2e\x5b\xda\xc0\x73\xa7\x4d\x04\x03\xbf\xe0\xf7\xb5\xeb\xec"
          "\xfb\xff\x52\x31\xf8\x79\xc1\x56\x5a\xc2\x3e\x63\x1b\xc4\x2e\x31\xc6\x5c\x76\x3d\xcf\x8f"
          "\xdf\x63\xaa\x73\x02\x95\xdf\x24",
          1, 3584 },
        { 128, 128, 29, "\x3a\x95\xb8\x71\x86\x18\x6e\x1b\x51\xb0\xc9\x19\x28\xe8\x2c\x25",
          "\x1a\x75\x0e\xea\x95\x6d\xea\xef\xf5\x74\xdb\x03\x83\x68\xba\x00",
          "\x79\xd2\x88\x9c\xe6\x58\x44\xfa\x9a\x04\xc4\x82\x02\x86\xb1\x1d\x4b\x80\xf2\x38\x01\x77"
          "\x9f\xb7\x38\x8a\xb5\xae\x85\x83\x2f\x5e\x71\x72\xe6\x3d\x2e\xb7\xe1\x4f\x2c\x62\x95\x75"
          "\x13\x85\xd6\xb5\x80\x95\xbd\x13\xc2\xe9\x20\x88\xc6\x9b\xaa\x82\x45\xe4\x74\xef\xa0\x8f"
          "\xab\x3b\x59\x38\x71\x3f\x52\x81\xd8\xa6\x9b\x69\x3c\x01\xcf\xa2\xc3\x03\x90\x2f\x3b\x17"
          "\x19\x9d\xd2\x89\x5b\xf4\x6e\x20\x27\x31\xdd\xc5\x18\x42\x8f\xbd\x7f\x62\xcc\x19\xbd\x83"
          "\x10\x60\x67\x97\xfa\x9c\xac\xe9\x2a\xa9\x81\x20\xbb\x8a\xbe\x06\xb3\xac\xfd\x80\x64\x62"
          "\xca\x75\x73\x1a\x00\x8c\x97\x37\x99\x08\x11\x74\x0c\x36\x20\x17\x01\xf9\xda\x18\x25\x41"
          "\xdb\xd1\xbf\x12\x48\x45\x1c\x1a\x1a\xb6\x74\xdf\xbe\xfb\xfd\x8b\x4a\xc7\xd7\x3a\x6a\xc2"
          "\x28\x25\xd2\x07\x50\xef\xd8\xb8\x1f\xf2\x73\x28\xfb\x96\x28\x51\x61\xd5\x9b\x25\x1c\x66"
          "\x1b\xec\x48\xc9\xec\xf4\x96\x65\x0a\xc6\x50\xe9\xcb\x56\xf3\x79\x3a\x09\xbf\xb3\x68\x06"
          "\xde\xfd\x76\xd3\x4c\x2c\x80\xee\xc2\x68\x62\xef\x8d\x84\x7f\xd5\x3a\x42\x52\xfe\x8d\x63"
          "\xfe\x07\xd7\x2a\x86\xe6\xf4\x38\x19\xa4\xdf\x10\x46\xbd\x67\x1e\x4f\xd2\xe8\x5b\x48\xa2"
          "\xa4\x8f\x3d\x5f\xab\xc9\xc8\xc6\xcf\x70\x6b\xad\x6a\x85\x13\x75\xf8\xb2\x52\xf9\x0e\xf4"
          "\xe3\xca\x9f\x30\xe3\xe7\x9d\x70\x7a\x92\x8a\x6e\x62\x53\x34\xa0\x92\x45\x20\xaf\xfe\x4e"
          "\xde\xa9\x6a\x37\xb3\xc8\xd5\x5d\x65\xb2\x0d\x8e\x6f\x8d\xfe\xfa\x9c\xca\x7c\xa1\x21\x8a"
          "\xa9\x73\x1c\x75\x94\x34\x92\xad\x68\x6e\xc6\xa6\xa0\x47\x92\xd5\x0a\x57\x1c\x0f\x92\x99"
          "\x17\x3b\x58\x8a\xf2\x0b\x04\xa7\x14\xb4\xf0\x99\x5b\x28\x4b\x72\x7b\xe9\x3b\x57\x65\xf9"
          "\x8a\xde\x0c\xb4\xcc\x5d\x1d\xf3\x14\x6f\xca\xc6\xb3\x17\x8e\xe5\x38\x44\x11\x9f\x00\x73"
          "\xa5\x47\x98\x2b\x8f\x2c\xbb\x66\x19\xa4\xc4\x8a\xc1\xc6\x90\xaf\x7e\x79\x29\x94\x43\xc2"
          "\xed\x09\x2f\xc2\x67\x35\x87\x23\x44\xc7\x61\x3d\xa6\x35\x1a\x46\x72\x80\x16\xa6\x85\x31"
          "\x06\xb6\x82\xc2\x35\xd3\x55\x21\x85\xf0\x2f\x6b\x1b\x25\xa1\x26\x53\x0f\x16\xf1\xd6\xca"
          "\x06\x48\x95\x93\x54\x78\xcc\x4a\x88\x6f\x1d\x67\x58\x12\xe6\x1d\x2b\xa9",
          "\x18\xbb\xd7\x60\x1a\x5a\x43\x01\xbc\x7e\x11\x86\x7b\xe7\x11\x42\xff\xa7\x2d\x9b\x85\x83"
          "\x46\x2f\x9f\xb8\x23\x22\x61\xb9\x9b\xc2\xdc\xce\x97\x11\xd3\x98\x21\x2f\x18\xcf\xe4\x31"
          "\xac\xde\x47\xa5\xdd\xd3\xae\xb0\xb9\x3b\x23\x8a\x2e\x72\xa1\x7b\xea\xab\xe5\xe9\x89\x7a"
          "\x12\x7b\xbf\x31\xc6\x31\x16\xec\xce\x41\xc6\x7e\xcf\xcd\x56\x73\xa2\x01\xa6\x82\x02\xf6"
          "\x1e\x03\x6c\x33\xcf\x01\x14\xe7\xc9\x41\x5e\x48\x5a\x5b\xa9\xce\x15\x00\x66\x64\x51\xb0"
          "\x77\x2c\x5b\x2d\x0b\x47\xf2\xf2\x9a\x92\x2c\xa8\xfc\xb1\xe4\x53\x2c\xb5\xe0\xb4\x96\x55"
          "\xba\x4a\x15\xdc\x0a\xed\x98\x91\x4c\x3c\x38\xe7\x2e\xfb\x4c\x75\x0a\x2e\x40\xea\xfe\xa7"
          "\x8c\xd3\xdb\x98\x98\x08\x68\xd9\x61\x73\x22\x48\x23\xd9\x07\x61\xc9\x79\x04\x45\x5e\x76"
          "\x31\x38\xe7\x91\x2b\xc4\x39\xf6\xb2\x0a\xf4\xb2\x09\xf3\x2f\x6a\xde\xcf\x1b\x1b\xb4\x09"
          "\xc9\x3c\xf5\x84\x4b\x99\x72\x8d\xa9\x73\x21\xa9\xc5\x7c\x5e\x57\x0b\x17\x59\xeb\x48\x1d"
          "\x05\xf4\x0c\xe3\x8b\x0d\xd7\x68\x5d\xb5\x1c\x29\x38\x27\x6a\x80\x46\x88\x1e\xf6\xb3\x49"
          "\x5a\x5a\xab\xf3\x23\xbb\x5a\x73\xbf\xf9\x92\xe5\x44\x63\x9c\x26\x4e\xa6\x3a\xea\x59\x66"
          "\xe7\x63\x43\x79\x60\x97\xae\x4f\x4f\xb9\x7b\xdf\x3a\x40\xa2\xf5\x01\x44\xf1\xed\x2a\x26"
          "\xc2\xbf\x9a\xa2\x26\x3c\xfc\xfc\x1e\xe0\xe8\x89\xd1\xb4\x82\xb2\xfd\x40\x0b\xec\x61\xdd"
          "\x6f\x65\x37\x50\xb5\x66\x8f\xc7\x78\x59\xb5\x88\x8b\x24\xfa\x43\x98\x36\x5c\xeb\x59\x9e"
          "\x14\x66\x47\xa4\xed\xb3\x14\x1b\xdb\xb7\xe2\x78\xb0\x02\xca\x4a\x10\x67\x1a\x58\xba\x45"
          "\xd0\xbc\x6c\x0f\x3d\xbd\x83\x34\x94\xbc\x99\x3f\x50\x49\x35\x2e\xbe\xeb\xb3\x6c\x84\x13"
          "\x47\xd6\xea\xe7\x64\x78\x33\xe5\xfc\xa1\x5c\x94\x57\x12\x0d\x19\xb6\x88\x19\x12\x19\x09"
          "\x4d\x78\xe7\xbf\x6a\xca\x27\x82\x84\x97\x62\x55\x4e\x4b\xb8\xe5\x5e\xaa\x7f\xdd\x0a\x90"
          "\x0a\x2a\xb4\x50\xf4\xe5\xd4\x07\xd9\xa4\xa7\x18\x0d\xbe\xbc\xaa\x1e\x1f\x52\x73\x2b\x2a"
          "\x62\xc9\x96\x8c\xaa\x49\x63\xfe\x48\x02\x58\x0c\x5d\xac\x19\xa4\xc5\xc0\xb1\x74\xc5\xbe"
          "\x10\x3d\xea\x6b\xe2\x6f\x59\xc3\xa3\xbd\x4d\xe3\xc1\xb7\x82\x8b\xe1\x1f",
          1, 3840 },
        { 128, 128, 30, "\x99\xfd\x0c\x36\xce\x13\x67\x66\x41\x0a\x3d\x8c\xcd\xb7\x96\xb2",
          "\xaa\x96\xc3\xbe\x3a\x1a\x91\x2b\xce\x62\x67\x65\xfb\x9b\x6e\x0e",
          "\xb7\x15\x85\xe1\xde\xf6\x7a\x2c\x95\xb2\x46\x08\x06\xd5\xac\x78\xc5\xf3\x09\x01\x9f\x1d"
          "\xe0\xe6\x2b\xa2\x5e\x01\x38\x02\xe3\xf4\x4f\x27\xb9\x1a\x68\x5b\xb3\xd2\x2d\x16\xb2\xa4"
          "\xda\x4b\x6a\x0e\xc9\x5d\xe4\x55\x1b\xad\x63\x5a\x56\x7d\x96\x7c\x76\x25\x5b\xa4\xc4\x78"
          "\x4d\xd8\xd7\xc0\xf5\xdb\x25\x65\x5a\x45\x78\xb8\xf3\xb7\x31\xce\x08\xe2\x42\x9c\x16\x94"
          "\xcf\x73\x89\xc4\x8e\x14\x84\x63\x4f\xf9\x93\xaf\x55\x50\x30\xe4\xc3\xc1\x79\x6a\x01\xb7"
          "\xe5\x98",
          "\x3f\x33\xb2\x0f\x92\x23\x6c\x80\xc8\x0f\xb4\x63\x8c\x6b\x32\x2f\x43\xe2\x59\x24\x91\x4b"
          "\x90\x8b\x14\xb3\xfa\x39\x18\x52\x7b\xbe\x2b\xa9\x8b\x1d\x9e\x72\x5d\xf6\x3e\x0c\x27\x47"
          "\x72\x0a\x99\x9b\xc1\xd0\x87\x25\xc0\x92\xdf\x83\xdf\xf6\xac\xb2\x5d\xb0\x49\xb5\x5b\x18"
          "\x31\x35\x33\x71\x80\xad\x5f\xb3\x47\x02\x3a\x5a\x80\x79\x75\x51\x9d\x47\xb2\xe7\x91\x26"
          "\x4c\x1b\xd8\xdb\xf4\xac\x1c\xd2\x84\x12\x80\xe3\xb8\x6b\x80\x62\x88\x51\x24\xd4\xf2\xdf"
          "\x2e\x22",
          1, 896 },
        { 128, 128, 31, "\xe4\x0f\x9c\x22\x00\x63\x60\x9b\x3a\xb2\xaf\x5e\xe2\x6d\x68\xa9",
          "\x10\xb6\x37\x5f\xec\xb9\x42\x82\x2f\xa2\x90\xc7\xaa\xa7\x66\xcd",
          "\x4e\x38\xf6\x57\xc8\x14\x97\xcc\x1f\xb8\xc0\xb4\x29\xa1\x8c\x42\xa9\xe0\xad\xf1\x24\x8c"
          "\x1f\xc8\xd2\x0c\x8c\x48\xe3\xd1\xd1\x94\xe2\x24\x29\x1c\xc3\x39\x3b\xc6\xb3\x62\xd1\x36"
          "\x4b\x4b\x05\xae\x3c\x2d\xc0\x85\x85\x31\x65\x45\x50\xcd\xba\xc8\x49\xc2\xeb\x4a\x86\xfa"
          "\x2a\xc8\x32\x92\x68\x62\xef\x56\x4e\xc1\x08\x9b\x45\x55\x82\x29\x7c\x05\x0f\x5c\x1b\x97"
          "\x15\x11\x9b\xe9\x91\x0d\x5e\x42\x33\xfa\xec\x54\x84\xd9\xe9\xb7\xb0\x41\x66\x1d\x61\x34"
          "\x6c\xa2\x2a\xd0\x30\xc8\x43\x33\x4b\x61\x34\xc4\x3d\xee\xa6\x69\x82\x92\x46\x5c\x8a\x9f"
          "\x4f\x0c\x26\x54\x4b\xda\x6e\xb7\x25\xa8\x37\x1b\xc7\x6c\xcf\x56\xb9\xe3\xde\x64\x9e\x52"
          "\x3f\xd8\x00\x6d\x7b\x3e\x12\x4f\x1b\xa4\x67\x14\x5f\xba\xb7\x93\x8b\xd1\x4b\x28\x74\xa2"
          "\x5e\x3b\x80\x33\x1b\x98\x0b\x09\x2d\x2b\xa6\x3b\xac\xb8\x58\x0e\x49\x1a\xfb\xbc\x64\x0f"
          "\x81\x45\xd8\xcd\x42\xe3\xea\x48\x44\x11",
          "\x62\x77\x7f\x53\x14\x8b\x34\x1d\xe5\xc6\x5c\xc2\x27\x3b\x69\x05\x34\x2e\x89\x9d\x05\xac"
          "\xf7\x5b\x7b\xb7\x38\x1c\xa3\x2a\x4b\x3d\x9e\x9f\xd8\xf9\x79\xc3\x46\xe9\x8b\xf5\x6c\xf3"
          "\x61\x13\x28\x20\x6e\x02\xa8\x7e\x25\xda\x9f\x4e\xaf\x30\x6b\xba\x9e\x60\x08\x5b\xc5\x55"
          "\xc3\x92\x6f\x9f\xa5\xcf\x5e\x4e\x70\xf7\x6a\x7d\x3a\x16\x73\x23\x6a\xf8\x4d\x2d\x83\x56"
          "\x0c\x46\x76\x6b\xdb\x69\x24\xa0\x03\xf8\xd2\x61\x1a\x11\xa9\x00\x3d\x49\x1b\xe5\xec\xef"
          "\x79\xd9\x6a\x43\x94\x4c\x4e\x7d\x20\xad\x41\xe4\x1e\xb3\x0e\x06\xea\xae\x59\xf4\xd5\xeb"
          "\x9d\xb5\x91\xe2\x79\xb9\xdb\xea\xf4\x23\x59\xc5\x4c\x73\xe2\x81\xc8\x18\x91\xaa\xb5\xfb"
          "\x91\xda\x02\x50\x63\x6d\x85\xc9\xde\xfa\x73\x01\xf5\x9d\x8a\xbf\xe3\x3d\x99\xcf\x2c\x4d"
          "\xf0\x43\xcd\x51\xc9\x41\xad\xd7\xa3\xd1\xf3\x8d\x90\xec\xde\x14\x84\x9c\x2d\x25\x1f\xf0"
          "\xa4\x35\x59\xac\x61\x48\xd1\xe6\x47\x0d",
          1, 1664 },
        /* Vectors from https://datatracker.ietf.org/doc/html/draft-ribose-cfrg-sm4-04 and
           https://datatracker.ietf.org/doc/html/draft-ribose-cfrg-sm4-10 */
        { 128, 128, 32, "\x01\x23\x45\x67\x89\xAB\xCD\xEF\xFE\xDC\xBA\x98\x76\x54\x32\x10",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0A\x0B\x0C\x0D\x0E\x0F",
          "\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB"
          "\xCC\xCC\xCC\xCC\xCC\xCC\xCC\xCC\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD"
          "\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF"
          "\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB",
          "\xAC\x32\x36\xCB\x97\x0C\xC2\x07\x91\x36\x4C\x39\x5A\x13\x42\xD1"
          "\xA3\xCB\xC1\x87\x8C\x6F\x30\xCD\x07\x4C\xCE\x38\x5C\xDD\x70\xC7"
          "\xF2\x34\xBC\x0E\x24\xC1\x19\x80\xFD\x12\x86\x31\x0C\xE3\x7B\x92"
          "\x6E\x02\xFC\xD0\xFA\xA0\xBA\xF3\x8B\x29\x33\x85\x1D\x82\x45\x14",
          1, 512 },
        { 128, 128, 33, "\xFE\xDC\xBA\x98\x76\x54\x32\x10\x01\x23\x45\x67\x89\xAB\xCD\xEF",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0A\x0B\x0C\x0D\x0E\x0F",
          "\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB"
          "\xCC\xCC\xCC\xCC\xCC\xCC\xCC\xCC\xDD\xDD\xDD\xDD\xDD\xDD\xDD\xDD"
          "\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF"
          "\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB",
          "\x5D\xCC\xCD\x25\xB9\x5A\xB0\x74\x17\xA0\x85\x12\xEE\x16\x0E\x2F"
          "\x8F\x66\x15\x21\xCB\xBA\xB4\x4C\xC8\x71\x38\x44\x5B\xC2\x9E\x5C"
          "\x0A\xE0\x29\x72\x05\xD6\x27\x04\x17\x3B\x21\x23\x9B\x88\x7F\x6C"
          "\x8C\xB5\xB8\x00\x91\x7A\x24\x88\x28\x4B\xDE\x9E\x16\xEA\x29\x06",
          1, 512 },
        { 0, 0, 0, NULL, NULL, NULL, NULL, 0, 0 }
};
