/*
 * Copyright 2000-2012 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.project.model.impl.module.dependencies;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.project.model.impl.module.JpsRootModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsDependencyElement;

/**
 * @author nik
 */
public abstract class JpsOrderEntry<E extends JpsDependencyElement> implements OrderEntry {
  protected final JpsRootModel myRootModel;
  protected final E myDependencyElement;

  protected JpsOrderEntry(JpsRootModel rootModel, E dependencyElement) {
    myRootModel = rootModel;
    myDependencyElement = dependencyElement;
  }

  @NotNull
  @Override
  public Module getOwnerModule() {
    return myRootModel.getModule();
  }

  @Override
  public boolean isSynthetic() {
    return false;
  }

  @Override
  public boolean isValid() {
    return true;
  }

  @Override
  public int compareTo(OrderEntry o) {
    throw new UnsupportedOperationException("'compareTo' not implemented in " + getClass().getName());
  }
}
