/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package org.apache.ivy.core.cache;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;

import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;

public interface ResolutionCacheManager {

    File getResolutionCacheRoot();

    File getResolvedIvyFileInCache(ModuleRevisionId mrid);

    File getResolvedIvyPropertiesInCache(ModuleRevisionId mrid);

    File getConfigurationResolveReportInCache(String resolveId, String conf);

    File[] getConfigurationResolveReportsInCache(final String resolveId);

    ModuleDescriptor getResolvedModuleDescriptor(ModuleRevisionId mrid) throws ParseException,
            IOException;

    void saveResolvedModuleDescriptor(ModuleDescriptor md) throws ParseException, IOException;

    /**
     * Cleans the whole cache.
     */
    void clean();
}
