/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2010-2011 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.jersey.server.impl.uri.rules;

import com.sun.jersey.server.impl.uri.PathPattern;
import com.sun.jersey.spi.uri.rules.UriRule;
import com.sun.jersey.spi.uri.rules.UriRuleContext;
import com.sun.jersey.spi.uri.rules.UriRules;
import com.sun.jersey.server.probes.UriRuleProbeProvider;
import java.util.Iterator;
import java.util.Map;

/**
 * The rule for accepting the root resource classes.
 * 
 * @author Paul.Sandoz@Sun.Com
 */
public final class RootResourceClassesRule implements UriRule {

    private final UriRules<UriRule> rules;

    /**
     * Public constructor
     * @param rulesMap Map of path patterns and URI rules
     */
    public RootResourceClassesRule(final Map<PathPattern, UriRule> rulesMap) {
        this.rules = UriRulesFactory.create(rulesMap);
    }

    /**
     * {@inheritDoc}
     */
    public boolean accept(CharSequence path, Object resource, UriRuleContext context) {
        UriRuleProbeProvider.ruleAccept(
            RootResourceClassesRule.class.getSimpleName(),
            path,
            resource
        );

        if (context.isTracingEnabled()) {
            context.trace("accept root resource classes: \"" + path + "\"");
        }

        final Iterator<UriRule> matches = rules.match(path, context);
        while(matches.hasNext())
            if(matches.next().accept(path, resource, context))
                return true;
        
        return false;
    }
}
