/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.util.bean;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.stripes.util.bean.Node;
import net.sourceforge.stripes.util.bean.ParseException;

public class PropertyExpression {
    private static final Pattern REGEX_INTEGER = Pattern.compile("^-?\\d+$");
    private static final Pattern REGEX_LONG = Pattern.compile("^(-?\\d+)L$", 2);
    private static final Pattern REGEX_DOUBLE = Pattern.compile("^-?\\d+\\.\\d+$");
    private static final Pattern REGEX_FLOAT = Pattern.compile("^(-?\\d+\\.?\\d+)F$", 2);
    private static final Pattern REGEX_BOOLEAN = Pattern.compile("^(true|false)$", 2);
    private static final String TERMINATOR_CHARS = ".[]";
    private static Map<String, PropertyExpression> expressions = new ConcurrentHashMap<String, PropertyExpression>();
    private String source;
    private Node root;
    private Node leaf;

    private PropertyExpression(String expression) throws ParseException {
        this.source = expression;
        this.parse(expression);
    }

    public Node getRootNode() {
        return this.root;
    }

    public String getSource() {
        return this.source;
    }

    public static PropertyExpression getExpression(String expression) throws ParseException {
        PropertyExpression parsed = expressions.get(expression);
        if (parsed == null) {
            parsed = new PropertyExpression(expression);
            expressions.put(expression, parsed);
        }
        return parsed;
    }

    protected void parse(String expression) throws ParseException {
        char[] chars = expression.toCharArray();
        StringBuilder builder = new StringBuilder();
        boolean inSingleQuotedString = false;
        boolean inDoubleQuotedString = false;
        boolean inSquareBrackets = false;
        boolean escapedChar = false;
        for (int i = 0; i < chars.length; ++i) {
            String value;
            char ch = chars[i];
            if (escapedChar) {
                builder.append(ch);
                escapedChar = false;
            } else if (ch == '\\') {
                escapedChar = true;
            } else if (!inSingleQuotedString && ch == '\'') {
                inSingleQuotedString = true;
            } else if (inSingleQuotedString && ch == '\'') {
                inSingleQuotedString = false;
                if (i != chars.length - 1 && TERMINATOR_CHARS.indexOf(chars[i + 1]) == -1) {
                    throw new ParseException("A quoted String must be terminated by a matching quote followed by either the end of the expression, a period or a square bracket character.", expression);
                }
                this.addNode(value, (value = builder.toString()).length() == 1 ? Character.valueOf(value.charAt(0)) : value);
                builder = new StringBuilder();
            } else if (inSingleQuotedString) {
                builder.append(ch);
            } else if (!inDoubleQuotedString && ch == '\"') {
                inDoubleQuotedString = true;
            } else if (inDoubleQuotedString && ch == '\"') {
                inDoubleQuotedString = false;
                if (i != chars.length - 1 && TERMINATOR_CHARS.indexOf(chars[i + 1]) == -1) {
                    throw new ParseException("A quoted String must be terminated by a matching quote followed by either the end of the expression, a period or a square bracket character.", expression);
                }
                value = builder.toString();
                this.addNode(value, value);
                builder = new StringBuilder();
            } else if (inDoubleQuotedString) {
                builder.append(ch);
            } else if (!inSquareBrackets && ch == '[') {
                if (builder.length() > 0) {
                    this.addNode(builder.toString(), null);
                    builder = new StringBuilder();
                }
                inSquareBrackets = true;
            } else if (inSquareBrackets) {
                if (ch == ']') {
                    inSquareBrackets = false;
                    if (builder.length() > 0) {
                        this.addNode(builder.toString(), null);
                        builder = new StringBuilder();
                    }
                } else {
                    builder.append(ch);
                }
            } else if (ch == '.') {
                if (builder.length() >= 1) {
                    this.addNode(builder.toString(), null);
                    builder = new StringBuilder();
                }
            } else {
                builder.append(ch);
            }
            if (i != chars.length - 1) continue;
            if (inSingleQuotedString) {
                throw new ParseException(expression, "Expression appears to terminate inside of single quoted string.");
            }
            if (inDoubleQuotedString) {
                throw new ParseException(expression, "Expression appears to terminate inside of double quoted string.");
            }
            if (inSquareBrackets) {
                throw new ParseException(expression, "Expression appears to terminate inside of square bracketed sub-expression.");
            }
            if (builder.length() <= 0) continue;
            this.addNode(builder.toString(), null);
        }
    }

    private void addNode(String nodeValue, Object typedValue) {
        if (typedValue == null) {
            Matcher matcher;
            if (REGEX_INTEGER.matcher(nodeValue).matches()) {
                typedValue = Integer.parseInt(nodeValue);
            } else if (REGEX_DOUBLE.matcher(nodeValue).matches()) {
                typedValue = Double.parseDouble(nodeValue);
            } else if (REGEX_LONG.matcher(nodeValue).matches()) {
                matcher = REGEX_LONG.matcher(nodeValue);
                matcher.matches();
                typedValue = Long.parseLong(matcher.group(1));
            } else if (REGEX_FLOAT.matcher(nodeValue).matches()) {
                matcher = REGEX_FLOAT.matcher(nodeValue);
                matcher.find();
                typedValue = Float.valueOf(Float.parseFloat(matcher.group(1)));
            } else {
                typedValue = REGEX_BOOLEAN.matcher(nodeValue).matches() ? Boolean.valueOf(Boolean.parseBoolean(nodeValue)) : nodeValue;
            }
        }
        Node node = new Node(nodeValue, typedValue);
        if (this.root == null) {
            this.root = this.leaf = node;
        } else {
            node.setPrevious(this.leaf);
            this.leaf.setNext(node);
            this.leaf = node;
        }
    }

    public String toString() {
        return this.source;
    }
}

