//---------------------------------------------------------------------------
//
// "" for ʳβʳβ
// ̾
//
//      Programed by Suikyo
//
//  2002.05.12  Phase 8.0.0   ʬΥ
//
//---------------------------------------------------------------------------
#ifndef KAWARI_NS_H
#define KAWARI_NS_H
//---------------------------------------------------------------------------
#include "config.h"
//---------------------------------------------------------------------------
#include <string>
#include <vector>
#include <map>
#include <set>
using namespace std;
//---------------------------------------------------------------------------
#include "libkawari/wordcollection.h"
#include "libkawari/kawari_log.h"
#include "libkawari/kawari_rc.h"
//---------------------------------------------------------------------------
// ñID
typedef unsigned int TWordID;
//---------------------------------------------------------------------------
// ȥID
typedef unsigned int TEntryID;
//---------------------------------------------------------------------------
// 
typedef map<TEntryID,vector<TWordID> > TDictionary;
// հ
typedef map<TWordID,multiset<TEntryID> > TRDictionary;
// ƥȥǥ쥯ȥ
typedef map<TEntryID,TEntryID> TParentEntryMap;
// ֥ȥǥ쥯ȥ
typedef multimap<TEntryID,TEntryID> TSubEntryMap;
//---------------------------------------------------------------------------
// ٥å쥯Υ󥿡ե
class TGarbageCollector {
public:
	// ñ˺ޡդ
	virtual void MarkWordForGC(TWordID id)=0;

	// ֤
	virtual TKawariLogger &GetLogger(void)=0;
};
//---------------------------------------------------------------------------
// ̾
// ȥ̾Ϲ˥ԥꥪ('.')ˤäƳŪ˴롣
class TNameSpace {
protected:
	// ȥꥳ쥯
	TWordCollection<string,less<string> > EntryCollection;
	// 
	TDictionary Dictionary;
	// հ
	TRDictionary ReverseDictionary;
	// ƥȥǥ쥯ȥ
	TParentEntryMap ParentEntry;
	// ֥ȥǥ쥯ȥ
	TSubEntryMap SubEntry;
	// ߶ػߤΥȥ
	set<TEntryID> ProtectedEntry;

	// Хʥ٥å쥯ؤλ
	TGarbageCollector *gc;

	// ꤵ줿ȥ꤫Ϥޤ륨ȥID
	unsigned int FindTree(TEntryID entry, vector<class TEntry>& entrycol);

public:
	TNameSpace(TGarbageCollector *col): gc(col) {}
	virtual ~TNameSpace();

	// WordCollectionΥҡפ
	void Reserve(unsigned int n);


	// [ API ]

	// ͭȥ
	unsigned int Size(void) const;


	// [ ȥ ]

	// ȥID
	// "."ϥ롼Ȥ򼨤
	//  : 1ꥸ󡢸Ĥʤ0֤
	class TEntry Get(const string& entry);

	// ȥ
	// ˥ȥ꤬¸ߤϡID֤
	// "."ϥ롼Ȥ򼨤
	//  : ȥID
	class TEntry Create(const string& entry);


	// [ ȥ ]

	// ƤΥȥ
	void ClearAllEntry(void);


	// [ API ]

	// ȥ
	//  : ȥθĿ
	unsigned int FindAllEntry(vector<class TEntry> &entrycol);

	// ȥ̾.פʬ򤹤
	static void SplitEntryName(const string& entryname,vector<string> &entryname_node);
	// ꤵ줿ñޤ२ȥ꤬¸ߤ뤫Ĵ٤
	//  : ¸ߤtrue
	bool ContainsWord(TWordID id) const;

	friend class TEntry;
};
//---------------------------------------------------------------------------
// ȥ
class TEntry {
private:
	TNameSpace * ns;
	TEntryID entry;

	// 񤭹ݸå
	//  : ݸоݤʤtrue
	bool AssertIfProtected(void);

public:
	TEntry(TNameSpace *space, TEntryID id) : ns(space), entry(id) {}

	TEntry(const TEntry& e) : ns(e.ns),entry(e.entry) {}
	TEntry &operator = (const TEntry& e) { ns=e.ns; entry=e.entry; return *this; }
	bool operator == (const TEntry& e) const {
		return ((ns==e.ns)&&(entry==e.entry));
	}
	bool operator != (const TEntry& e) const {
		return ((ns!=e.ns)||(entry!=e.entry));
	}
	bool operator < (const TEntry& r) const {
		if(ns<r.ns) return true;
		else if (ns>r.ns) return false;
		else return (entry<r.entry);
	}

	// ϰϳΥǥå
	static const unsigned int NPos;		// UINT_MAX
		// ơclassФconstϤξʤꤽ
		// ΤVC++6.0ΥХǡǰʤ餽⤤ʤ
		// ΥХϡͤ뤳ȤˤäƲǤ롣
		// ºݤͤɤʤäƤ뤫ϡβ򸫤Ƥ
		// ܤϲȡ(դ)
		// BUG: C2258 and C2252 on in Place Initialization of Static Const Members (Q241569)
		// http://support.microsoft.com/default.aspx?scid=kb;en-us;Q241569

	// Υȥä硢ٹ˻Ĥ
	// ޾줷ΤŪ
	//  : ξtrue
	bool AssertIfEmpty(const string& name);


	// [ API ]

	// ꤵ줿ȥñ
	//  : ñθĿ
	unsigned int Size(void) const;

	// ͭʥȥǤ뤫Ĵ٤
	//  : ͭʤ鿿
	bool IsValid(void) const { return ((ns!=NULL)&&(entry!=0)); }


	// [ IDѴ ]

	// ȥ̾
	//  : ȥ̾ʸ
	string GetName(void) const;

	// ID
	TEntryID GetID(void) const { return entry; }


	// [ ɲáAPI ]

	// ꤵ줿ȥˤ
	// ˶ȥñ줬Ĥ
	//  : true
	bool Clear(void);

	// ΥȥʲΥȥƶˤ
	// ˶ȥñ줬ĤäƤɤ
	void ClearTree(void);

	// ȥǸؤñɲ
	void Push(TWordID id);

	// ꤵ줿ȥˤƤñɲ
	// ȥѿŪѤ˻Ѥ
	void PushAfterClear(TWordID id);

	// ȥǸñκ
	//  : 줿ñ
	TWordID Pop(void);

	// ȥؤñ
	void Insert(unsigned int pos,TWordID id);

	// ȥñκ
	void Erase(unsigned int st,unsigned int end);

	// ȥñؤ
	//  : 줿ñ
	TWordID Replace(unsigned int pos,TWordID id);

	// ȥñؤ(ǥåϰϳξ硢id2ɲ)
	//  : 줿ñ
	TWordID Replace2(unsigned int pos,TWordID id,TWordID id2);

	// ȥؤν񤭹ߤػߤ
	void WriteProtect(void);


	// [ API ]

	// ꤵ줿ȥ꤬ޤޤ뤫ݤ֤
	//  : ޤޤtrue
//	bool Contains(TEntryID id) const;

	// ꤵ줿ȥλꤷ(0ꥸ)ñ֤
	//  : ñID
	TWordID Index(unsigned int index=0) const;

	// ꤵ줿ȥ⤫ꤷñ򸡺
	//  : ǥå(ĤʤNPos)
	unsigned int Find(TWordID id,unsigned int pos=0) const;

	// ꤵ줿ȥ⤫ꤷñ򸡺(ս)
	//  : ǥå(ĤʤNPos)
	unsigned int RFind(TWordID id,unsigned int pos=NPos) const;

	// ꤵ줿ȥñ
	//  : ñθĿ
	unsigned int FindAll(vector<TWordID> &wordcol) const;

	// ƥȥ
	//  : 1ꥸ󡢸Ĥʤ0֤
	TEntry GetParent(void) const;

	// ֥ȥ
	//  : ȥθĿ
	unsigned int FindAllSubEntry(vector<TEntry> &entrycol) const;

	// ꤵ줿ȥ̾Ϥޤ륨ȥ
	// Υȥ̵
	//  : ȥθĿ
	unsigned int FindTree(vector<TEntry> &entrycol) const;
};
//---------------------------------------------------------------------------
inline TNameSpace::~TNameSpace()
{
	ProtectedEntry.clear();
	ClearAllEntry();
}
//---------------------------------------------------------------------------
// ꤵ줿ȥ꤬ޤޤ뤫ݤ֤
//  : ޤޤtrue
#if 0
inline bool TNameSpace::Contains(TEntryID id) const
{
	return EntryCollection.Contains(id);
}
#endif
//---------------------------------------------------------------------------
// WordCollectionΥҡפ
inline void TNameSpace::Reserve(unsigned int n)
{
	EntryCollection.Reserve(n);
}
//---------------------------------------------------------------------------
// ͭȥ
inline unsigned int TNameSpace::Size(void) const
{
	return Dictionary.size();
}
//---------------------------------------------------------------------------
// ȥID
// "."ϥ롼Ȥ򼨤
//  : 1ꥸ󡢸Ĥʤ0֤
inline TEntry TNameSpace::Get(const string& entry)
{
	return((entry==".")?TEntry(this,0):TEntry(this, EntryCollection.Find(entry)));
}
//--------------------------------------------------------------------------
// ꤵ줿ñޤ२ȥ꤬¸ߤ뤫Ĵ٤
//  : ¸ߤtrue
inline bool TNameSpace::ContainsWord(TWordID id) const
{
	if (ReverseDictionary.count(id)==0) return false;
	TRDictionary::const_iterator it=ReverseDictionary.find(id);
	return (it->second.size()!=0);
}
//---------------------------------------------------------------------------
// ƥȥ
inline TEntry TEntry::GetParent(void) const
{
	map<TEntryID,TEntryID>::const_iterator it=ns->ParentEntry.find(entry);
	return((it!=ns->ParentEntry.end())?(TEntry(ns,it->second)):(TEntry(ns,0)));
}
//---------------------------------------------------------------------------
// ȥID饨ȥ̾Ѵ
//  : ȥ̾ʸ
inline string TEntry::GetName(void) const
{
	string const*entryname=ns->EntryCollection.Find(entry);
	if (!entryname) return("");
	else return (*entryname);
}
//--------------------------------------------------------------------------
// 񤭹ݸå
//  : ݸоݤʤtrue
inline bool TEntry::AssertIfProtected(void)
{
	if(IsValid()&&ns->ProtectedEntry.count(entry)){
		ns->gc->GetLogger().GetStream(kawari_log::LOG_ERROR)
			<< RC.S(kawari::resource::ERR_NS_ASSERT_PROTECTED_ENTRY1) << GetName()
			<< RC.S(kawari::resource::ERR_NS_ASSERT_PROTECTED_ENTRY2) << endl;
		return true;
	}else{
		return false;
	}
}
//---------------------------------------------------------------------------
// ꤵ줿ȥˤƤñɲ
// ȥѿŪѤ˻Ѥ
inline void TEntry::PushAfterClear(TWordID id)
{
	Clear();
	Push(id);
}
//--------------------------------------------------------------------------
// ȥؤν񤭹ߤػߤ
inline void TEntry::WriteProtect(void)
{
	if(IsValid()) ns->ProtectedEntry.insert(entry);
}
//--------------------------------------------------------------------------
// Υȥä硢ٹ˻Ĥ
// ޾줷ΤŪ
//  : ξtrue
inline bool TEntry::AssertIfEmpty(const string& name)
{
	if(((!IsValid())||(!Size()))&&ns->gc->GetLogger().Check(kawari_log::LOG_DECL)){
		ns->gc->GetLogger().GetStream() << RC.S(kawari::resource::WARN_NS_READ_EMPTY_ENTRY1) << name << RC.S(kawari::resource::WARN_NS_READ_EMPTY_ENTRY2) << endl;
		return true;
	}else{
		return false;
	}
}
//--------------------------------------------------------------------------
#endif
