#ifndef __obj_wire
#define __obj_wire

#ifdef WIN32
#pragma warning ( disable : 4800 4305 4267 ) // Disable warnings
#endif

#define render_wire { \
    glInterleavedArrays (GL_N3F_V3F, 0, wireInterleavedQuadStrips); \
    for (int i = 0; i < wireNumQuadStrips; i++) { \
        glDrawArrays (GL_QUAD_STRIP, wireQuadStripIndices[i]/6, \
                        (wireQuadStripIndices[i+1] - wireQuadStripIndices[i])/6); \
    } \
    glInterleavedArrays (GL_N3F_V3F, 0, wireInterleavedTriangleFans); \
    for (int ii = 0; ii < wireNumTriangleFans; ii++) { \
        glDrawArrays (GL_TRIANGLE_FAN, wireTriangleFanIndices[ii]/6, \
                        (wireTriangleFanIndices[ii+1] - wireTriangleFanIndices[ii])/6); \
    } \
}

static int wireNumQuadStrips = 2;

static int wireQuadStripIndices[3] = { 0, 120, 240 };

static float wireInterleavedQuadStrips[240] = {
-0.000,  0.723,  0.690, -0.000,  0.185,  0.002, -0.000,  0.581,  0.814, -0.000,  0.142,  0.047,
 0.511,  0.511,  0.690,  0.131,  0.131,  0.002, 
 0.411,  0.411,  0.814,  0.100,  0.100,  0.047, 
 0.723, -0.000,  0.690,  0.185,  0.000,  0.002, 
 0.581, -0.000,  0.814,  0.141,  0.000,  0.047, 
 0.511, -0.511,  0.690,  0.131, -0.130,  0.002, 
 0.411, -0.411,  0.814,  0.100, -0.100,  0.047, 
-0.000, -0.723,  0.690,  0.000, -0.184,  0.002, 
-0.000, -0.581,  0.814,  0.000, -0.141,  0.047, 
-0.511, -0.511,  0.690, -0.131, -0.130,  0.002, 
-0.411, -0.411,  0.814, -0.100, -0.100,  0.047, 
-0.723, -0.000,  0.690, -0.185,  0.000,  0.002, 
-0.581, -0.000,  0.814, -0.141,  0.000,  0.047, 
-0.511,  0.511,  0.690, -0.131,  0.131,  0.002, 
-0.411,  0.411,  0.814, -0.100,  0.100,  0.047, 
-0.000,  0.723,  0.690, -0.000,  0.185,  0.002, 
-0.000,  0.581,  0.814, -0.000,  0.142,  0.047, 
 0.511,  0.511,  0.690,  0.131,  0.131,  0.002, 
 0.411,  0.411,  0.814,  0.100,  0.100,  0.047, 
-0.000,  0.581,  0.814, -0.000,  0.142,  0.047, -0.000,  0.424,  0.906, -0.000,  0.077,  0.078,
 0.411,  0.411,  0.814,  0.100,  0.100,  0.047, 
 0.300,  0.300,  0.906,  0.054,  0.054,  0.078, 
 0.581, -0.000,  0.814,  0.141,  0.000,  0.047, 
 0.424, -0.000,  0.906,  0.077,  0.000,  0.078, 
 0.411, -0.411,  0.814,  0.100, -0.100,  0.047, 
 0.300, -0.300,  0.906,  0.054, -0.054,  0.078, 
-0.000, -0.581,  0.814,  0.000, -0.141,  0.047, 
 0.000, -0.424,  0.906,  0.000, -0.076,  0.078, 
-0.411, -0.411,  0.814, -0.100, -0.100,  0.047, 
-0.300, -0.300,  0.906, -0.054, -0.054,  0.078, 
-0.581, -0.000,  0.814, -0.141,  0.000,  0.047, 
-0.424, -0.000,  0.906, -0.077,  0.000,  0.078, 
-0.411,  0.411,  0.814, -0.100,  0.100,  0.047, 
-0.300,  0.300,  0.906, -0.054,  0.054,  0.078, 
-0.000,  0.581,  0.814, -0.000,  0.142,  0.047, 
-0.000,  0.424,  0.906, -0.000,  0.077,  0.078, 
 0.411,  0.411,  0.814,  0.100,  0.100,  0.047, 
 0.300,  0.300,  0.906,  0.054,  0.054,  0.078, 
};

static int wireNumTriangleFans = 1;

static int wireTriangleFanIndices[2] = { 0, 60 };

static float wireInterleavedTriangleFans[60] = {
 0.272, -0.656,  0.704,  0.000,  0.000,  0.006,  0.272, -0.656,  0.704, -0.000,  0.077,  0.078, 
 0.272, -0.656,  0.704, -0.054,  0.054,  0.078, 
 0.656, -0.272,  0.704, -0.077,  0.000,  0.078, 
 0.656,  0.272,  0.704, -0.054, -0.054,  0.078, 
 0.272,  0.656,  0.704,  0.000, -0.076,  0.078, 
-0.272,  0.656,  0.704,  0.054, -0.054,  0.078, 
-0.656,  0.272,  0.704,  0.077,  0.000,  0.078, 
-0.656, -0.272,  0.704,  0.054,  0.054,  0.078, 
-0.272, -0.656,  0.704, -0.000,  0.077,  0.078, 
};

#endif // __obj_wire

