/*
 * Copyright (C) 2023 Damir Porobic <damir.porobic@gmx.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "RectSizeHelper.h"

namespace kImageAnnotator {

QRectF RectSizeHelper::setSizeButKeepDirection(const QRectF &rect, const QSizeF &newSize)
{
	auto updatedRect = rect;

	updatedRect.setWidth(getSign(rect.width()) * newSize.width());
	updatedRect.setHeight(getSign(rect.height()) * newSize.height());

	return updatedRect;
}

QRectF RectSizeHelper::limitToSize(const QRectF &rect, const QSizeF &minSize)
{
	auto updatedRect = rect;

	if (qAbs(rect.width()) < minSize.width()) {
		updatedRect.setWidth(getSign(rect.width()) * minSize.width());
	}

	if (qAbs(rect.height()) < minSize.height()) {
		updatedRect.setHeight(getSign(rect.height()) * minSize.height());
	}

	return updatedRect;
}

qreal RectSizeHelper::getSign(const qreal &value)
{
	return value < 0 ? -1 : 1;
}

} // namespace kImageAnnotator