
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2019 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQCameraInfoControl.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QCameraInfoControl>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include "gsiDeclQtMultimediaTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QCameraInfoControl

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QCameraInfoControl::staticMetaObject);
}


// int QCameraInfoControl::cameraOrientation(const QString &deviceName)


static void _init_f_cameraOrientation_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("deviceName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_cameraOrientation_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<int > ((int)((QCameraInfoControl *)cls)->cameraOrientation (arg1));
}


// QCamera::Position QCameraInfoControl::cameraPosition(const QString &deviceName)


static void _init_f_cameraPosition_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("deviceName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QCamera::Position>::target_type > ();
}

static void _call_f_cameraPosition_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<qt_gsi::Converter<QCamera::Position>::target_type > ((qt_gsi::Converter<QCamera::Position>::target_type)qt_gsi::CppToQtAdaptor<QCamera::Position>(((QCameraInfoControl *)cls)->cameraPosition (arg1)));
}


// static QString QCameraInfoControl::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCameraInfoControl::tr (arg1, arg2, arg3));
}


// static QString QCameraInfoControl::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCameraInfoControl::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QCameraInfoControl () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("cameraOrientation", "@brief Method int QCameraInfoControl::cameraOrientation(const QString &deviceName)\n", true, &_init_f_cameraOrientation_c2025, &_call_f_cameraOrientation_c2025);
  methods += new qt_gsi::GenericMethod ("cameraPosition", "@brief Method QCamera::Position QCameraInfoControl::cameraPosition(const QString &deviceName)\n", true, &_init_f_cameraPosition_c2025, &_call_f_cameraPosition_c2025);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QCameraInfoControl::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCameraInfoControl::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCameraInfoControl::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QMediaControl> &qtdecl_QMediaControl ();

qt_gsi::QtNativeClass<QCameraInfoControl> decl_QCameraInfoControl (qtdecl_QMediaControl (), "QtMultimedia", "QCameraInfoControl_Native",
  methods_QCameraInfoControl (),
  "@hide\n@alias QCameraInfoControl");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QCameraInfoControl> &qtdecl_QCameraInfoControl () { return decl_QCameraInfoControl; }

}


class QCameraInfoControl_Adaptor : public QCameraInfoControl, public qt_gsi::QtObjectBase
{
public:

  virtual ~QCameraInfoControl_Adaptor();

  //  [adaptor ctor] QCameraInfoControl::QCameraInfoControl()
  QCameraInfoControl_Adaptor() : QCameraInfoControl()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QCameraInfoControl::isSignalConnected(const QMetaMethod &signal)
  bool fp_QCameraInfoControl_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QCameraInfoControl::isSignalConnected(signal);
  }

  //  [expose] int QCameraInfoControl::receivers(const char *signal)
  int fp_QCameraInfoControl_receivers_c1731 (const char *signal) const {
    return QCameraInfoControl::receivers(signal);
  }

  //  [expose] QObject *QCameraInfoControl::sender()
  QObject * fp_QCameraInfoControl_sender_c0 () const {
    return QCameraInfoControl::sender();
  }

  //  [expose] int QCameraInfoControl::senderSignalIndex()
  int fp_QCameraInfoControl_senderSignalIndex_c0 () const {
    return QCameraInfoControl::senderSignalIndex();
  }

  //  [adaptor impl] int QCameraInfoControl::cameraOrientation(const QString &deviceName)
  int cbs_cameraOrientation_c2025_0(const QString &deviceName) const
  {
    __SUPPRESS_UNUSED_WARNING (deviceName);
    throw qt_gsi::AbstractMethodCalledException("cameraOrientation");
  }

  virtual int cameraOrientation(const QString &deviceName) const
  {
    if (cb_cameraOrientation_c2025_0.can_issue()) {
      return cb_cameraOrientation_c2025_0.issue<QCameraInfoControl_Adaptor, int, const QString &>(&QCameraInfoControl_Adaptor::cbs_cameraOrientation_c2025_0, deviceName);
    } else {
      throw qt_gsi::AbstractMethodCalledException("cameraOrientation");
    }
  }

  //  [adaptor impl] QCamera::Position QCameraInfoControl::cameraPosition(const QString &deviceName)
  qt_gsi::Converter<QCamera::Position>::target_type cbs_cameraPosition_c2025_0(const QString &deviceName) const
  {
    __SUPPRESS_UNUSED_WARNING (deviceName);
    throw qt_gsi::AbstractMethodCalledException("cameraPosition");
  }

  virtual QCamera::Position cameraPosition(const QString &deviceName) const
  {
    if (cb_cameraPosition_c2025_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QCamera::Position>(cb_cameraPosition_c2025_0.issue<QCameraInfoControl_Adaptor, qt_gsi::Converter<QCamera::Position>::target_type, const QString &>(&QCameraInfoControl_Adaptor::cbs_cameraPosition_c2025_0, deviceName)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("cameraPosition");
    }
  }

  //  [emitter impl] void QCameraInfoControl::destroyed(QObject *)
  void emitter_QCameraInfoControl_destroyed_1302(QObject *arg1)
  {
    emit QCameraInfoControl::destroyed(arg1);
  }

  //  [adaptor impl] bool QCameraInfoControl::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QCameraInfoControl::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QCameraInfoControl_Adaptor, bool, QEvent *>(&QCameraInfoControl_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QCameraInfoControl::event(arg1);
    }
  }

  //  [adaptor impl] bool QCameraInfoControl::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QCameraInfoControl::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QCameraInfoControl_Adaptor, bool, QObject *, QEvent *>(&QCameraInfoControl_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QCameraInfoControl::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QCameraInfoControl::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QCameraInfoControl::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QCameraInfoControl_Adaptor, QChildEvent *>(&QCameraInfoControl_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QCameraInfoControl::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QCameraInfoControl::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QCameraInfoControl::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QCameraInfoControl_Adaptor, QEvent *>(&QCameraInfoControl_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QCameraInfoControl::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QCameraInfoControl::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QCameraInfoControl::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QCameraInfoControl_Adaptor, const QMetaMethod &>(&QCameraInfoControl_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QCameraInfoControl::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QCameraInfoControl::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QCameraInfoControl::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QCameraInfoControl_Adaptor, QTimerEvent *>(&QCameraInfoControl_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QCameraInfoControl::timerEvent(arg1);
    }
  }

  gsi::Callback cb_cameraOrientation_c2025_0;
  gsi::Callback cb_cameraPosition_c2025_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QCameraInfoControl_Adaptor::~QCameraInfoControl_Adaptor() { }

//  Constructor QCameraInfoControl::QCameraInfoControl() (adaptor class)

static void _init_ctor_QCameraInfoControl_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QCameraInfoControl_Adaptor> ();
}

static void _call_ctor_QCameraInfoControl_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCameraInfoControl_Adaptor *> (new QCameraInfoControl_Adaptor ());
}


// int QCameraInfoControl::cameraOrientation(const QString &deviceName)

static void _init_cbs_cameraOrientation_c2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("deviceName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_cameraOrientation_c2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<int > ((int)((QCameraInfoControl_Adaptor *)cls)->cbs_cameraOrientation_c2025_0 (arg1));
}

static void _set_callback_cbs_cameraOrientation_c2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraInfoControl_Adaptor *)cls)->cb_cameraOrientation_c2025_0 = cb;
}


// QCamera::Position QCameraInfoControl::cameraPosition(const QString &deviceName)

static void _init_cbs_cameraPosition_c2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("deviceName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QCamera::Position>::target_type > ();
}

static void _call_cbs_cameraPosition_c2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<qt_gsi::Converter<QCamera::Position>::target_type > ((qt_gsi::Converter<QCamera::Position>::target_type)((QCameraInfoControl_Adaptor *)cls)->cbs_cameraPosition_c2025_0 (arg1));
}

static void _set_callback_cbs_cameraPosition_c2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraInfoControl_Adaptor *)cls)->cb_cameraPosition_c2025_0 = cb;
}


// void QCameraInfoControl::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraInfoControl_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraInfoControl_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QCameraInfoControl::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraInfoControl_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraInfoControl_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QCameraInfoControl::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QCameraInfoControl_Adaptor *)cls)->emitter_QCameraInfoControl_destroyed_1302 (arg1);
}


// void QCameraInfoControl::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraInfoControl_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraInfoControl_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QCameraInfoControl::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCameraInfoControl_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraInfoControl_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QCameraInfoControl::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCameraInfoControl_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraInfoControl_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QCameraInfoControl::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QCameraInfoControl_Adaptor *)cls)->fp_QCameraInfoControl_isSignalConnected_c2394 (arg1));
}


// exposed int QCameraInfoControl::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QCameraInfoControl_Adaptor *)cls)->fp_QCameraInfoControl_receivers_c1731 (arg1));
}


// exposed QObject *QCameraInfoControl::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QCameraInfoControl_Adaptor *)cls)->fp_QCameraInfoControl_sender_c0 ());
}


// exposed int QCameraInfoControl::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCameraInfoControl_Adaptor *)cls)->fp_QCameraInfoControl_senderSignalIndex_c0 ());
}


// void QCameraInfoControl::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraInfoControl_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraInfoControl_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QCameraInfoControl> &qtdecl_QCameraInfoControl ();

static gsi::Methods methods_QCameraInfoControl_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCameraInfoControl::QCameraInfoControl()\nThis method creates an object of class QCameraInfoControl.", &_init_ctor_QCameraInfoControl_Adaptor_0, &_call_ctor_QCameraInfoControl_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("cameraOrientation", "@hide", true, &_init_cbs_cameraOrientation_c2025_0, &_call_cbs_cameraOrientation_c2025_0);
  methods += new qt_gsi::GenericMethod ("cameraOrientation", "@brief Virtual method int QCameraInfoControl::cameraOrientation(const QString &deviceName)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_cameraOrientation_c2025_0, &_call_cbs_cameraOrientation_c2025_0, &_set_callback_cbs_cameraOrientation_c2025_0);
  methods += new qt_gsi::GenericMethod ("cameraPosition", "@hide", true, &_init_cbs_cameraPosition_c2025_0, &_call_cbs_cameraPosition_c2025_0);
  methods += new qt_gsi::GenericMethod ("cameraPosition", "@brief Virtual method QCamera::Position QCameraInfoControl::cameraPosition(const QString &deviceName)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_cameraPosition_c2025_0, &_call_cbs_cameraPosition_c2025_0, &_set_callback_cbs_cameraPosition_c2025_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QCameraInfoControl::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QCameraInfoControl::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QCameraInfoControl::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QCameraInfoControl::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QCameraInfoControl::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QCameraInfoControl::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QCameraInfoControl::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QCameraInfoControl::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QCameraInfoControl::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QCameraInfoControl::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QCameraInfoControl::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QCameraInfoControl_Adaptor> decl_QCameraInfoControl_Adaptor (qtdecl_QCameraInfoControl (), "QtMultimedia", "QCameraInfoControl",
  methods_QCameraInfoControl_Adaptor (),
  "@qt\n@brief Binding of QCameraInfoControl");

}

