
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQBackingStore.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QBackingStore>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QBackingStore

//  Constructor QBackingStore::QBackingStore(QWindow *window)


static void _init_ctor_QBackingStore_1335 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("window");
  decl->add_arg<QWindow * > (argspec_0);
  decl->set_return_new<QBackingStore> ();
}

static void _call_ctor_QBackingStore_1335 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWindow *arg1 = gsi::arg_reader<QWindow * >() (args, heap);
  ret.write<QBackingStore *> (new QBackingStore (arg1));
}


// void QBackingStore::beginPaint(const QRegion &)


static void _init_f_beginPaint_2006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRegion & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_beginPaint_2006 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegion &arg1 = gsi::arg_reader<const QRegion & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QBackingStore *)cls)->beginPaint (arg1);
}


// void QBackingStore::endPaint()


static void _init_f_endPaint_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_endPaint_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QBackingStore *)cls)->endPaint ();
}


// void QBackingStore::flush(const QRegion &region, QWindow *window, const QPoint &offset)


static void _init_f_flush_5041 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("region");
  decl->add_arg<const QRegion & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("window", true, "0");
  decl->add_arg<QWindow * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("offset", true, "QPoint()");
  decl->add_arg<const QPoint & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_flush_5041 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegion &arg1 = gsi::arg_reader<const QRegion & >() (args, heap);
  QWindow *arg2 = args ? gsi::arg_reader<QWindow * >() (args, heap) : gsi::arg_maker<QWindow * >() (0, heap);
  const QPoint &arg3 = args ? gsi::arg_reader<const QPoint & >() (args, heap) : gsi::arg_maker<const QPoint & >() (QPoint(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QBackingStore *)cls)->flush (arg1, arg2, arg3);
}


// bool QBackingStore::hasStaticContents()


static void _init_f_hasStaticContents_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasStaticContents_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QBackingStore *)cls)->hasStaticContents ());
}


// QPaintDevice *QBackingStore::paintDevice()


static void _init_f_paintDevice_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintDevice * > ();
}

static void _call_f_paintDevice_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QBackingStore *)cls)->paintDevice ());
}


// void QBackingStore::resize(const QSize &size)


static void _init_f_resize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_resize_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QBackingStore *)cls)->resize (arg1);
}


// bool QBackingStore::scroll(const QRegion &area, int dx, int dy)


static void _init_f_scroll_3324 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("area");
  decl->add_arg<const QRegion & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dx");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("dy");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_scroll_3324 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegion &arg1 = gsi::arg_reader<const QRegion & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QBackingStore *)cls)->scroll (arg1, arg2, arg3));
}


// void QBackingStore::setStaticContents(const QRegion &region)


static void _init_f_setStaticContents_2006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("region");
  decl->add_arg<const QRegion & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStaticContents_2006 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegion &arg1 = gsi::arg_reader<const QRegion & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QBackingStore *)cls)->setStaticContents (arg1);
}


// QSize QBackingStore::size()


static void _init_f_size_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_size_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QBackingStore *)cls)->size ());
}


// QRegion QBackingStore::staticContents()


static void _init_f_staticContents_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRegion > ();
}

static void _call_f_staticContents_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRegion > ((QRegion)((QBackingStore *)cls)->staticContents ());
}


// QWindow *QBackingStore::window()


static void _init_f_window_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWindow * > ();
}

static void _call_f_window_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWindow * > ((QWindow *)((QBackingStore *)cls)->window ());
}



namespace gsi
{

static gsi::Methods methods_QBackingStore () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QBackingStore::QBackingStore(QWindow *window)\nThis method creates an object of class QBackingStore.", &_init_ctor_QBackingStore_1335, &_call_ctor_QBackingStore_1335);
  methods += new qt_gsi::GenericMethod ("beginPaint", "@brief Method void QBackingStore::beginPaint(const QRegion &)\n", false, &_init_f_beginPaint_2006, &_call_f_beginPaint_2006);
  methods += new qt_gsi::GenericMethod ("endPaint", "@brief Method void QBackingStore::endPaint()\n", false, &_init_f_endPaint_0, &_call_f_endPaint_0);
  methods += new qt_gsi::GenericMethod ("flush", "@brief Method void QBackingStore::flush(const QRegion &region, QWindow *window, const QPoint &offset)\n", false, &_init_f_flush_5041, &_call_f_flush_5041);
  methods += new qt_gsi::GenericMethod ("hasStaticContents", "@brief Method bool QBackingStore::hasStaticContents()\n", true, &_init_f_hasStaticContents_c0, &_call_f_hasStaticContents_c0);
  methods += new qt_gsi::GenericMethod ("paintDevice", "@brief Method QPaintDevice *QBackingStore::paintDevice()\n", false, &_init_f_paintDevice_0, &_call_f_paintDevice_0);
  methods += new qt_gsi::GenericMethod ("resize", "@brief Method void QBackingStore::resize(const QSize &size)\n", false, &_init_f_resize_1805, &_call_f_resize_1805);
  methods += new qt_gsi::GenericMethod ("scroll", "@brief Method bool QBackingStore::scroll(const QRegion &area, int dx, int dy)\n", false, &_init_f_scroll_3324, &_call_f_scroll_3324);
  methods += new qt_gsi::GenericMethod ("setStaticContents", "@brief Method void QBackingStore::setStaticContents(const QRegion &region)\n", false, &_init_f_setStaticContents_2006, &_call_f_setStaticContents_2006);
  methods += new qt_gsi::GenericMethod ("size", "@brief Method QSize QBackingStore::size()\n", true, &_init_f_size_c0, &_call_f_size_c0);
  methods += new qt_gsi::GenericMethod ("staticContents", "@brief Method QRegion QBackingStore::staticContents()\n", true, &_init_f_staticContents_c0, &_call_f_staticContents_c0);
  methods += new qt_gsi::GenericMethod ("window", "@brief Method QWindow *QBackingStore::window()\n", true, &_init_f_window_c0, &_call_f_window_c0);
  return methods;
}

gsi::Class<QBackingStore> decl_QBackingStore ("QtGui", "QBackingStore",
  methods_QBackingStore (),
  "@qt\n@brief Binding of QBackingStore");


GSI_QTGUI_PUBLIC gsi::Class<QBackingStore> &qtdecl_QBackingStore () { return decl_QBackingStore; }

}

