if(ENABLE_LLD)
  execute_process(COMMAND ${CMAKE_CXX_COMPILER} -fuse-ld=lld -Wl,--version ERROR_QUIET OUTPUT_VARIABLE LD_VERSION)
  if(LD_VERSION MATCHES "LLD")
    include(FindPackageHandleStandardArgs)
    find_program(LLD_EXECUTABLE lld)
    find_package_handle_standard_args(LLD REQUIRED_VARS LLD_EXECUTABLE)

    if(LLD_FOUND)
      set(CMAKE_LINKER ${LLD_EXECUTABLE})
      set(CMAKE_CXX_LINK_FLAGS -fuse-ld=lld)
      set(CMAKE_C_LINK_FLAGS -fuse-ld=lld)
      set(CMAKE_EXE_LINKER_FLAGS "${LD_FLAGS} -fuse-ld=lld")
      set(CMAKE_SHARED_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS}")
      set(CMAKE_MODULE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS}")
      message(STATUS "Linker: LLVM lld")
    endif()
    mark_as_advanced(LLD_EXECUTABLE CMAKE_LINKER)

  else()
    message(FATAL_ERROR "LLVM lld linker not found")
  endif()
endif()
