// $Id: lamarc_input_schema.h,v 1.20 2018/01/03 21:33:05 mkkuhner Exp $

/*
Copyright 2002-2005 Mary K. Kuhner, Peter Beerli, and Joseph Felsenstein

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

*/

/* Authors: Peter Beerli, Mary Kuhner, Jon Yamato and Joseph Felsenstein */


// NOTE -- this file is no longer used by lamarc. It is kept in the
// cvs archive since it is a useful reference. -- ewalkup

#ifndef LAMARC_INPUT_SCHEMA_H
#define LAMARC_INPUT_SCHEMA_H

#include <string>

const std::string XML_SCHEMA_CONTENTS =

    "<?xml version='1.0' encoding='UTF-8'?>\n"
    "<xsd:schema xmlns:xsd='http://www.w3.org/2001/XMLSchema'>\n"
    "\n"
    "<!-- This is lamarc_input_schema.xsd -->\n"
    "<!-- Please do not remove or alter this file. Lamarc places this file in the directory    -->\n"
    "<!-- you invoke lamarc from and then uses it to check that your xml input file is correct -->\n"
    "\n"
    "<xsd:element name='lamarc' type='lamarcFormat' />\n"
    "\n"
    "<xsd:complexType name='lamarcFormat'>\n"
    "    <xsd:all>\n"
    "        <xsd:element name='data'     type='Data'    minOccurs='1' maxOccurs='1'/>\n"
    "        <xsd:element name='forces'   type='Forces'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='chains'   type='Chains'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='format'   type='Format'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='model'    type='Model'   minOccurs='0' maxOccurs='1'/>\n"
    "    </xsd:all>\n"
    "</xsd:complexType>\n"
    "\n"
    "<xsd:complexType name='Chains'>\n"
    "    <xsd:all>\n"
    "        <xsd:element name='initial'  type='ChainInfo' minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='final'    type='ChainInfo' minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='heating'  minOccurs='0' maxOccurs='1'>\n"
    "            <xsd:complexType>\n"
    "                <xsd:all>\n"
    "                    <xsd:element name='temperatures' type='xsd:string' minOccurs='0' maxOccurs='1'/>\n"
    "                    <xsd:element name='swap-interval' type='xsd:positiveInteger' minOccurs='0' maxOccurs='1'/>\n"
    "                    <xsd:element name='adaptive' type='xsd:boolean' minOccurs='0' maxOccurs='1'/>\n"
    "                </xsd:all>\n"
    "            </xsd:complexType>\n"
    "        </xsd:element>\n"
    "        <xsd:element name='replicates' type='xsd:positiveInteger' minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='strategy'     minOccurs='0' maxOccurs='1'>\n"
    "            <xsd:complexType>\n"
    "                <xsd:all>\n"
    "                    <xsd:element name='haplotyping' type='xsd:decimal' minOccurs='0' maxOccurs='1'/>\n"
    "                    <xsd:element name='resimulating' type='xsd:decimal' minOccurs='0' maxOccurs='1'/>\n"
    "                </xsd:all>\n"
    "            </xsd:complexType>\n"
    "        </xsd:element>\n"
    "    </xsd:all>\n"
    "</xsd:complexType>\n"
    "\n"
    "<xsd:complexType name='ChainInfo'>\n"
    "    <xsd:all>\n"
    "        <xsd:element name='number'      type='xsd:nonNegativeInteger' minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='samples'     type='xsd:positiveInteger' minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='discard'     type='xsd:nonNegativeInteger' minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='interval'    type='xsd:positiveInteger' minOccurs='0' maxOccurs='1'/>\n"
    "    </xsd:all>\n"
    "</xsd:complexType>\n"
    "\n"
    "\n"
    "<xsd:complexType name='Data'>\n"
    "    <xsd:sequence>\n"
    "        <xsd:element name='region' minOccurs='1' maxOccurs='unbounded'>\n"
    "            <xsd:complexType>\n"
    "                <xsd:sequence>\n"
    "                    <xsd:element name='model' type='Model' minOccurs='0' maxOccurs='1'/>\n"
    "                    <xsd:element name='tree' minOccurs='0' maxOccurs='1'>\n"
    "                        <xsd:complexType>\n"
    "                            <xsd:simpleContent>\n"
    "                                <xsd:extension base='xsd:string'>\n"
    "                                    <xsd:attribute name='type' type='xsd:string'/>\n"
    "                                </xsd:extension>\n"
    "                            </xsd:simpleContent>\n"
    "                        </xsd:complexType>\n"
    "                    </xsd:element>\n"
    "                    <xsd:element name='spacing' minOccurs='0' maxOccurs='1'>\n"
    "                        <xsd:complexType>\n"
    "                            <xsd:sequence>\n"
    "                                <xsd:element name='block' type='Block' minOccurs='1' maxOccurs='unbounded'/>\n"
    "                            </xsd:sequence>\n"
    "                        </xsd:complexType>\n"
    "                    </xsd:element>\n"
    "                    <xsd:element name='population' type='Population' minOccurs='1' maxOccurs='unbounded'/>\n"
    "                </xsd:sequence>\n"
    "                <xsd:attribute name='name' type='xsd:string'/>\n"
    "            </xsd:complexType>\n"
    "        </xsd:element>\n"
    "    </xsd:sequence>\n"
    "</xsd:complexType>\n"
    "\n"
    "<xsd:complexType name='Block'>\n"
    "    <xsd:all>\n"
    "        <xsd:element name='map-position' type='xsd:nonNegativeInteger' minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='length' type='xsd:positiveInteger' minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='locations' type='xsd:string' minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='offset' type='xsd:nonNegativeInteger' minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='marker-weights' type='xsd:string' minOccurs='0' maxOccurs='1'/>\n"
    "    </xsd:all>\n"
    "</xsd:complexType>\n"
    "\n"
    "<xsd:complexType name='Population'>\n"
    "    <xsd:sequence>\n"
    "        <xsd:element name='individual' minOccurs='0' maxOccurs='unbounded'>\n"
    "            <xsd:complexType>\n"
    "                <xsd:sequence>\n"
    "                    <xsd:element name='phase' minOccurs='0' maxOccurs='unbounded'>\n"
    "                        <xsd:complexType>\n"
    "                            <xsd:simpleContent>\n"
    "                                <xsd:extension base='xsd:string'>\n"
    "                                    <xsd:attribute name='type' type='xsd:string'/>\n"
    "                                </xsd:extension>\n"
    "                            </xsd:simpleContent>\n"
    "                        </xsd:complexType>\n"
    "                    </xsd:element>\n"
    "                    <xsd:element name='sample' minOccurs='1' maxOccurs='unbounded'>\n"
    "                        <xsd:complexType>\n"
    "                            <xsd:sequence>\n"
    "                                <xsd:element name='datablock' minOccurs='1' maxOccurs='unbounded'>\n"
    "                                    <xsd:complexType>\n"
    "                                        <xsd:simpleContent>\n"
    "                                            <xsd:extension base='xsd:string'>\n"
    "                                                <xsd:attribute name='type' type='xsd:string'/>\n"
    "                                            </xsd:extension>\n"
    "                                        </xsd:simpleContent>\n"
    "                                    </xsd:complexType>\n"
    "                                </xsd:element>\n"
    "                                <xsd:element name='status' minOccurs='0' maxOccurs='1'>\n"
    "                                    <xsd:complexType>\n"
    "                                        <xsd:sequence>\n"
    "                                            <xsd:element name='disease-status' minOccurs='0' maxOccurs='unbounded'>\n"
    "                                                <xsd:complexType>\n"
    "                                                    <xsd:simpleContent>\n"
    "                                                        <xsd:extension base='xsd:string'/>\n"
    "                                                    </xsd:simpleContent>\n"
    "                                                </xsd:complexType>\n"
    "                                            </xsd:element>\n"
    "                                        </xsd:sequence>\n"
    "                                    </xsd:complexType>\n"
    "                                </xsd:element>\n"
    "                            </xsd:sequence>\n"
    "                            <xsd:attribute name='name' type='xsd:string'/>\n"
    "                        </xsd:complexType>\n"
    "                    </xsd:element>\n"
    "                </xsd:sequence>\n"
    "                <xsd:attribute name='name' type='xsd:string'/>\n"
    "            </xsd:complexType>\n"
    "        </xsd:element>\n"
    "    </xsd:sequence>\n"
    "    <xsd:attribute name='name' type='xsd:string'/>\n"
    "</xsd:complexType>\n"
    "\n"
    "<xsd:complexType name='Forces'>\n"
    "    <xsd:all>\n"
    "        <xsd:element name='coalescence'   type='ForceType'  minOccurs='1' maxOccurs='1'/>\n"
    "        <xsd:element name='migration'     type='ForceType'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='recombination' type='ForceType'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='growth'        type='ForceType'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='logistic-selection' type='ForceType'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='disease'       type='ForceType'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='gamma-over-regions'       type='ForceType'  minOccurs='0' maxOccurs='1'/>\n"
    "    </xsd:all>\n"
    "</xsd:complexType>\n"
    "\n"
    "<xsd:complexType name='ForceType'>\n"
    "    <xsd:all>\n"
    "        <xsd:element name='start-values'  type='xsd:string'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='method'        type='xsd:string'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='max-events'    type='xsd:nonNegativeInteger'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='profiles'      type='xsd:string'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='location'      type='xsd:integer' minOccurs='0' maxOccurs='1'/>\n"
    "    </xsd:all>\n"
    "    <xsd:attribute name='value' type='xsd:string'/>\n"
    "</xsd:complexType>\n"
    "\n"
    "\n"
    "<xsd:complexType name='Format'>\n"
    "    <xsd:all>\n"
    "        <xsd:element name='seed'  type='xsd:nonNegativeInteger'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='verbosity'  type='verbosity_type'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='progress-reports'  type='verbosity_type'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='echo'  type='xsd:boolean'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='parameter-file'  type='xsd:string'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='results-file'  type='xsd:string'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='summary-file'  type='xsd:string'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='use-in-summary'  type='xsd:string'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='in-summary-file'  type='xsd:string'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='use-out-summary'  type='xsd:string'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='out-summary-file'  type='xsd:string'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='out-xml-file'  type='xsd:string'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='plotting' minOccurs='0' maxOccurs='1'>\n"
    "            <xsd:complexType>\n"
    "                <xsd:all>\n"
    "                    <xsd:element name='profile' type='xsd:string' minOccurs='0' maxOccurs='1'/>\n"
    "                    <xsd:element name='posterior' type='xsd:string' minOccurs='0' maxOccurs='1'/>\n"
    "                </xsd:all>\n"
    "            </xsd:complexType>\n"
    "        </xsd:element>\n"
    "    </xsd:all>\n"
    "</xsd:complexType>\n"
    "\n"
    "<xsd:simpleType name='verbosity_type'>\n"
    "    <xsd:restriction base='xsd:string'>\n"
    "        <xsd:pattern value='\\s*(verbose|normal|concise|none)\\s*'/>\n"
    "    </xsd:restriction>\n"
    "</xsd:simpleType>\n"
    "\n"
    "<xsd:complexType name='Model'>\n"
    "    <xsd:all>\n"
    "        <xsd:element name='base-freqs'  type='xsd:string'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='gtr-rates'  type='xsd:string'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='ttratio'  type='xsd:decimal'  minOccurs='0' maxOccurs='1'/>\n"
    "        <xsd:element name='categories' minOccurs='0' maxOccurs='1'>\n"
    "            <xsd:complexType>\n"
    "                <xsd:all>\n"
    "                    <xsd:element name='num-categories' type='xsd:positiveInteger' minOccurs='0' maxOccurs='1'/>\n"
    "                    <xsd:element name='rates' type='xsd:string' minOccurs='0' maxOccurs='1'/>\n"
    "                    <xsd:element name='probabilities' type='xsd:string' minOccurs='0' maxOccurs='1'/>\n"
    "                    <xsd:element name='autocorrelation' type='xsd:decimal' minOccurs='0' maxOccurs='1'/>\n"
    "                </xsd:all>\n"
    "            </xsd:complexType>\n"
    "        </xsd:element>\n"
    "        <xsd:element name='normalize'  type='xsd:string'  minOccurs='0' maxOccurs='1'/>\n"
    "    </xsd:all>\n"
    "    <xsd:attribute name='name' type='xsd:string'/>\n"
    "</xsd:complexType>\n"
    "\n"
    "</xsd:schema>\n";

#endif // LAMARC_INPUT_SCHEMA_H

//____________________________________________________________________________________
