/* main_window_build_tools.c generated by valac 0.32.0.71-d187, the Vala compiler
 * generated from main_window_build_tools.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2012, 2014 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <latexila.h>
#include <gio/gio.h>
#include "config.h"
#include <gtksourceview/gtksource.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define TYPE_MAIN_WINDOW_BUILD_TOOLS (main_window_build_tools_get_type ())
#define MAIN_WINDOW_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildTools))
#define MAIN_WINDOW_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsClass))
#define IS_MAIN_WINDOW_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS))
#define IS_MAIN_WINDOW_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_BUILD_TOOLS))
#define MAIN_WINDOW_BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsClass))

typedef struct _MainWindowBuildTools MainWindowBuildTools;
typedef struct _MainWindowBuildToolsClass MainWindowBuildToolsClass;
typedef struct _MainWindowBuildToolsPrivate MainWindowBuildToolsPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_BOTTOM_PANEL (bottom_panel_get_type ())
#define BOTTOM_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOTTOM_PANEL, BottomPanel))
#define BOTTOM_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOTTOM_PANEL, BottomPanelClass))
#define IS_BOTTOM_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOTTOM_PANEL))
#define IS_BOTTOM_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOTTOM_PANEL))
#define BOTTOM_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOTTOM_PANEL, BottomPanelClass))

typedef struct _BottomPanel BottomPanel;
typedef struct _BottomPanelClass BottomPanelClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block23Data Block23Data;
#define _main_window_build_tools_unref0(var) ((var == NULL) ? NULL : (var = (main_window_build_tools_unref (var), NULL)))

#define TYPE_LATEXILA_APP (latexila_app_get_type ())
#define LATEXILA_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXILA_APP, LatexilaApp))
#define LATEXILA_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXILA_APP, LatexilaAppClass))
#define IS_LATEXILA_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXILA_APP))
#define IS_LATEXILA_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXILA_APP))
#define LATEXILA_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXILA_APP, LatexilaAppClass))

typedef struct _LatexilaApp LatexilaApp;
typedef struct _LatexilaAppClass LatexilaAppClass;

#define TYPE_MAIN_WINDOW_STRUCTURE (main_window_structure_get_type ())
#define MAIN_WINDOW_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructure))
#define MAIN_WINDOW_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructureClass))
#define IS_MAIN_WINDOW_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_STRUCTURE))
#define IS_MAIN_WINDOW_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_STRUCTURE))
#define MAIN_WINDOW_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructureClass))

typedef struct _MainWindowStructure MainWindowStructure;
typedef struct _MainWindowStructureClass MainWindowStructureClass;
#define _main_window_structure_unref0(var) ((var == NULL) ? NULL : (var = (main_window_structure_unref (var), NULL)))

#define TYPE_CLEAN_BUILD_FILES (clean_build_files_get_type ())
#define CLEAN_BUILD_FILES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLEAN_BUILD_FILES, CleanBuildFiles))
#define CLEAN_BUILD_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesClass))
#define IS_CLEAN_BUILD_FILES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLEAN_BUILD_FILES))
#define IS_CLEAN_BUILD_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLEAN_BUILD_FILES))
#define CLEAN_BUILD_FILES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesClass))

typedef struct _CleanBuildFiles CleanBuildFiles;
typedef struct _CleanBuildFilesClass CleanBuildFilesClass;
typedef struct _ParamSpecMainWindowBuildTools ParamSpecMainWindowBuildTools;

struct _MainWindowBuildTools {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MainWindowBuildToolsPrivate * priv;
};

struct _MainWindowBuildToolsClass {
	GTypeClass parent_class;
	void (*finalize) (MainWindowBuildTools *self);
};

struct _MainWindowBuildToolsPrivate {
	MainWindow* _main_window;
	GtkUIManager* _ui_manager;
	LatexilaBuildView* _build_view;
	BottomPanel* _bottom_panel;
	GCancellable* _cancellable;
	GAsyncResult* _build_tool_result;
	GtkActionGroup* _static_action_group;
	GtkActionGroup* _dynamic_action_group;
	guint _menu_ui_id;
};

struct _Block23Data {
	int _ref_count_;
	MainWindowBuildTools* self;
	LatexilaBuildTool* tool;
};

struct _ParamSpecMainWindowBuildTools {
	GParamSpec parent_instance;
};


static gpointer main_window_build_tools_parent_class = NULL;

gpointer main_window_build_tools_ref (gpointer instance);
void main_window_build_tools_unref (gpointer instance);
GParamSpec* param_spec_main_window_build_tools (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_main_window_build_tools (GValue* value, gpointer v_object);
void value_take_main_window_build_tools (GValue* value, gpointer v_object);
gpointer value_get_main_window_build_tools (const GValue* value);
GType main_window_build_tools_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType bottom_panel_get_type (void) G_GNUC_CONST;
#define MAIN_WINDOW_BUILD_TOOLS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsPrivate))
enum  {
	MAIN_WINDOW_BUILD_TOOLS_DUMMY_PROPERTY
};
void main_window_build_tools_on_clean (MainWindowBuildTools* self);
static void _main_window_build_tools_on_clean_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_build_tools_on_stop_execution (MainWindowBuildTools* self);
static void _main_window_build_tools_on_stop_execution_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_build_tools_on_view_log (MainWindowBuildTools* self);
static void _main_window_build_tools_on_view_log_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_build_tools_on_preferences (MainWindowBuildTools* self);
static void _main_window_build_tools_on_preferences_gtk_action_callback (GtkAction* action, gpointer self);
MainWindowBuildTools* main_window_build_tools_new (MainWindow* main_window, GtkUIManager* ui_manager);
MainWindowBuildTools* main_window_build_tools_construct (GType object_type, MainWindow* main_window, GtkUIManager* ui_manager);
static void main_window_build_tools_update_menu (MainWindowBuildTools* self);
static void __lambda28_ (MainWindowBuildTools* self);
static void ___lambda28__latexila_build_tools_modified (LatexilaBuildTools* _sender, gpointer self);
static void __lambda29_ (MainWindowBuildTools* self);
static void ___lambda29__latexila_build_tools_loaded (LatexilaBuildTools* _sender, gpointer self);
static void __lambda30_ (MainWindowBuildTools* self);
static void ___lambda30__latexila_build_tools_modified (LatexilaBuildTools* _sender, gpointer self);
static void __lambda31_ (MainWindowBuildTools* self);
static void ___lambda31__latexila_build_tools_loaded (LatexilaBuildTools* _sender, gpointer self);
void main_window_build_tools_set_build_view (MainWindowBuildTools* self, LatexilaBuildView* build_view);
static void main_window_build_tools_connect_toggle_actions (MainWindowBuildTools* self);
static void __lambda32_ (MainWindowBuildTools* self, GFile* file, gint start_line, gint end_line);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_open_document (MainWindow* self, GFile* location, gboolean jump_to);
void main_window_jump_to_file_position (MainWindow* self, GFile* file, gint start_line, gint end_line);
static void ___lambda32__latexila_build_view_jump_to_file (LatexilaBuildView* _sender, GFile* file, gint start_line, gint end_line, gpointer self);
void main_window_build_tools_set_bottom_panel (MainWindowBuildTools* self, BottomPanel* bottom_panel);
void main_window_build_tools_update_sensitivity (MainWindowBuildTools* self);
DocumentTab* main_window_get_active_tab (MainWindow* self);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
gboolean document_is_main_file_a_tex_file (Document* self);
static gchar* main_window_build_tools_get_default_build_tool_name (MainWindowBuildTools* self, gint tool_num);
static void main_window_build_tools_update_build_tool_sensitivity (MainWindowBuildTools* self, LatexilaBuildTool* tool, const gchar* action_name);
static gchar* main_window_build_tools_get_personal_build_tool_name (MainWindowBuildTools* self, gint tool_num);
static LatexilaBuildTool* main_window_build_tools_get_build_tool_from_name (MainWindowBuildTools* self, const gchar* action_name);
GFile* document_get_location (Document* self);
GFile* document_get_main_file (Document* self);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
void main_window_build_tools_save_state (MainWindowBuildTools* self);
static void main_window_build_tools_activate_dynamic_action (MainWindowBuildTools* self, GtkAction* action);
static void _main_window_build_tools_activate_dynamic_action_gtk_action_activate (GtkAction* _sender, gpointer self);
static void main_window_build_tools_add_dynamic_action (MainWindowBuildTools* self, LatexilaBuildTool* build_tool, const gchar* action_name, gint* accel_num);
static void main_window_build_tools_add_separator (MainWindowBuildTools* self);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
gboolean document_set_tmp_location (Document* self);
gint document_get_project_id (Document* self);
void document_save (Document* self, gboolean check_file_changed_on_disk, gboolean force);
GType latexila_app_get_type (void) G_GNUC_CONST;
LatexilaApp* latexila_app_get_instance (void);
GeeList* latexila_app_get_documents (LatexilaApp* self);
void utils_flush_queue (void);
static void __lambda27_ (Block23Data* _data23_, GObject* obj, GAsyncResult* _result_);
gpointer main_window_structure_ref (gpointer instance);
void main_window_structure_unref (gpointer instance);
GParamSpec* param_spec_main_window_structure (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_main_window_structure (GValue* value, gpointer v_object);
void value_take_main_window_structure (GValue* value, gpointer v_object);
gpointer value_get_main_window_structure (const GValue* value);
GType main_window_structure_get_type (void) G_GNUC_CONST;
MainWindowStructure* main_window_get_main_window_structure (MainWindow* self);
void main_window_structure_refresh (MainWindowStructure* self);
static void ___lambda27__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
GType clean_build_files_get_type (void) G_GNUC_CONST;
CleanBuildFiles* clean_build_files_new (MainWindow* main_window, Document* doc);
CleanBuildFiles* clean_build_files_construct (GType object_type, MainWindow* main_window, Document* doc);
void clean_build_files_clean (CleanBuildFiles* self);
Document* document_tab_get_document (DocumentTab* self);
void document_set_readonly (Document* self, gboolean value);
static void main_window_build_tools_finalize (MainWindowBuildTools* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GtkActionEntry MAIN_WINDOW_BUILD_TOOLS__action_entries[5] = {{"Build", NULL, "_Build"}, {"BuildClean", "edit-clear-all", "Cleanup Build _Files", NULL, "Clean-up build files (*.aux, *.log, *.out, *.toc, etc)", (GCallback) _main_window_build_tools_on_clean_gtk_action_callback}, {"BuildStopExecution", "process-stop", "_Stop Execution", NULL, "Stop Execution", (GCallback) _main_window_build_tools_on_stop_execution_gtk_action_callback}, {"BuildViewLog", "view_log", "View _Log", NULL, "View Log", (GCallback) _main_window_build_tools_on_view_log_gtk_action_callback}, {"BuildToolsPreferences", "preferences-system", "_Manage Build Tools", NULL, "Manage Build Tools", (GCallback) _main_window_build_tools_on_preferences_gtk_action_callback}};
static const GtkToggleActionEntry MAIN_WINDOW_BUILD_TOOLS__toggle_action_entries[3] = {{"BuildShowDetails", "zoom-in", "Show _Details", NULL, "Show Details", (GCallback) NULL}, {"BuildShowWarnings", "dialog-warning", "Show _Warnings", NULL, "Show Warnings", (GCallback) NULL}, {"BuildShowBadBoxes", "badbox", "Show _Bad Boxes", NULL, "Show Bad Boxes", (GCallback) NULL}};

static void _main_window_build_tools_on_clean_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_build_tools_on_clean ((MainWindowBuildTools*) self);
}


static void _main_window_build_tools_on_stop_execution_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_build_tools_on_stop_execution ((MainWindowBuildTools*) self);
}


static void _main_window_build_tools_on_view_log_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_build_tools_on_view_log ((MainWindowBuildTools*) self);
}


static void _main_window_build_tools_on_preferences_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_build_tools_on_preferences ((MainWindowBuildTools*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda28_ (MainWindowBuildTools* self) {
	main_window_build_tools_update_menu (self);
}


static void ___lambda28__latexila_build_tools_modified (LatexilaBuildTools* _sender, gpointer self) {
	__lambda28_ ((MainWindowBuildTools*) self);
}


static void __lambda29_ (MainWindowBuildTools* self) {
	main_window_build_tools_update_menu (self);
}


static void ___lambda29__latexila_build_tools_loaded (LatexilaBuildTools* _sender, gpointer self) {
	__lambda29_ ((MainWindowBuildTools*) self);
}


static void __lambda30_ (MainWindowBuildTools* self) {
	main_window_build_tools_update_menu (self);
}


static void ___lambda30__latexila_build_tools_modified (LatexilaBuildTools* _sender, gpointer self) {
	__lambda30_ ((MainWindowBuildTools*) self);
}


static void __lambda31_ (MainWindowBuildTools* self) {
	main_window_build_tools_update_menu (self);
}


static void ___lambda31__latexila_build_tools_loaded (LatexilaBuildTools* _sender, gpointer self) {
	__lambda31_ ((MainWindowBuildTools*) self);
}


MainWindowBuildTools* main_window_build_tools_construct (GType object_type, MainWindow* main_window, GtkUIManager* ui_manager) {
	MainWindowBuildTools* self = NULL;
	MainWindow* _tmp0_ = NULL;
	GtkUIManager* _tmp1_ = NULL;
	GtkUIManager* _tmp2_ = NULL;
	GtkActionGroup* _tmp3_ = NULL;
	GtkActionGroup* _tmp4_ = NULL;
	GtkActionGroup* _tmp5_ = NULL;
	GtkActionGroup* _tmp6_ = NULL;
	GtkAction* stop_exec = NULL;
	GtkActionGroup* _tmp7_ = NULL;
	GtkAction* _tmp8_ = NULL;
	GtkAction* _tmp9_ = NULL;
	GtkUIManager* _tmp10_ = NULL;
	GtkActionGroup* _tmp11_ = NULL;
	GtkActionGroup* _tmp12_ = NULL;
	GtkUIManager* _tmp13_ = NULL;
	GtkActionGroup* _tmp14_ = NULL;
	LatexilaBuildToolsPersonal* personal_build_tools = NULL;
	LatexilaBuildToolsPersonal* _tmp15_ = NULL;
	LatexilaBuildToolsPersonal* _tmp16_ = NULL;
	LatexilaBuildToolsDefault* default_build_tools = NULL;
	LatexilaBuildToolsDefault* _tmp17_ = NULL;
	LatexilaBuildToolsDefault* _tmp18_ = NULL;
	g_return_val_if_fail (main_window != NULL, NULL);
	g_return_val_if_fail (ui_manager != NULL, NULL);
	self = (MainWindowBuildTools*) g_type_create_instance (object_type);
	_tmp0_ = main_window;
	self->priv->_main_window = _tmp0_;
	_tmp1_ = ui_manager;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->_ui_manager);
	self->priv->_ui_manager = _tmp2_;
	_tmp3_ = gtk_action_group_new ("BuildMenuActionGroup");
	_g_object_unref0 (self->priv->_static_action_group);
	self->priv->_static_action_group = _tmp3_;
	_tmp4_ = self->priv->_static_action_group;
	gtk_action_group_set_translation_domain (_tmp4_, GETTEXT_PACKAGE);
	_tmp5_ = self->priv->_static_action_group;
	gtk_action_group_add_actions (_tmp5_, MAIN_WINDOW_BUILD_TOOLS__action_entries, G_N_ELEMENTS (MAIN_WINDOW_BUILD_TOOLS__action_entries), self);
	_tmp6_ = self->priv->_static_action_group;
	gtk_action_group_add_toggle_actions (_tmp6_, MAIN_WINDOW_BUILD_TOOLS__toggle_action_entries, G_N_ELEMENTS (MAIN_WINDOW_BUILD_TOOLS__toggle_action_entries), self);
	_tmp7_ = self->priv->_static_action_group;
	_tmp8_ = gtk_action_group_get_action (_tmp7_, "BuildStopExecution");
	_tmp9_ = _g_object_ref0 (_tmp8_);
	stop_exec = _tmp9_;
	gtk_action_set_sensitive (stop_exec, FALSE);
	_tmp10_ = ui_manager;
	_tmp11_ = self->priv->_static_action_group;
	gtk_ui_manager_insert_action_group (_tmp10_, _tmp11_, 0);
	_tmp12_ = gtk_action_group_new ("BuildToolsActions");
	_g_object_unref0 (self->priv->_dynamic_action_group);
	self->priv->_dynamic_action_group = _tmp12_;
	_tmp13_ = ui_manager;
	_tmp14_ = self->priv->_dynamic_action_group;
	gtk_ui_manager_insert_action_group (_tmp13_, _tmp14_, 0);
	main_window_build_tools_update_menu (self);
	_tmp15_ = latexila_build_tools_personal_get_instance ();
	_tmp16_ = _g_object_ref0 (_tmp15_);
	personal_build_tools = _tmp16_;
	g_signal_connect ((LatexilaBuildTools*) personal_build_tools, "modified", (GCallback) ___lambda28__latexila_build_tools_modified, self);
	g_signal_connect ((LatexilaBuildTools*) personal_build_tools, "loaded", (GCallback) ___lambda29__latexila_build_tools_loaded, self);
	_tmp17_ = latexila_build_tools_default_get_instance ();
	_tmp18_ = _g_object_ref0 (_tmp17_);
	default_build_tools = _tmp18_;
	g_signal_connect ((LatexilaBuildTools*) default_build_tools, "modified", (GCallback) ___lambda30__latexila_build_tools_modified, self);
	g_signal_connect ((LatexilaBuildTools*) default_build_tools, "loaded", (GCallback) ___lambda31__latexila_build_tools_loaded, self);
	_g_object_unref0 (default_build_tools);
	_g_object_unref0 (personal_build_tools);
	_g_object_unref0 (stop_exec);
	return self;
}


MainWindowBuildTools* main_window_build_tools_new (MainWindow* main_window, GtkUIManager* ui_manager) {
	return main_window_build_tools_construct (TYPE_MAIN_WINDOW_BUILD_TOOLS, main_window, ui_manager);
}


static void __lambda32_ (MainWindowBuildTools* self, GFile* file, gint start_line, gint end_line) {
	gint _tmp0_ = 0;
	g_return_if_fail (file != NULL);
	_tmp0_ = start_line;
	if (_tmp0_ == -1) {
		MainWindow* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		DocumentTab* _tmp3_ = NULL;
		DocumentTab* _tmp4_ = NULL;
		_tmp1_ = self->priv->_main_window;
		_tmp2_ = file;
		_tmp3_ = main_window_open_document (_tmp1_, _tmp2_, TRUE);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp4_);
	} else {
		MainWindow* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp5_ = self->priv->_main_window;
		_tmp6_ = file;
		_tmp7_ = start_line;
		_tmp8_ = end_line;
		main_window_jump_to_file_position (_tmp5_, _tmp6_, _tmp7_ - 1, _tmp8_ - 1);
	}
}


static void ___lambda32__latexila_build_view_jump_to_file (LatexilaBuildView* _sender, GFile* file, gint start_line, gint end_line, gpointer self) {
	__lambda32_ ((MainWindowBuildTools*) self, file, start_line, end_line);
}


void main_window_build_tools_set_build_view (MainWindowBuildTools* self, LatexilaBuildView* build_view) {
	LatexilaBuildView* _tmp0_ = NULL;
	LatexilaBuildView* _tmp1_ = NULL;
	LatexilaBuildView* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (build_view != NULL);
	_tmp0_ = build_view;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_build_view);
	self->priv->_build_view = _tmp1_;
	main_window_build_tools_connect_toggle_actions (self);
	_tmp2_ = self->priv->_build_view;
	g_signal_connect (_tmp2_, "jump-to-file", (GCallback) ___lambda32__latexila_build_view_jump_to_file, self);
}


void main_window_build_tools_set_bottom_panel (MainWindowBuildTools* self, BottomPanel* bottom_panel) {
	BottomPanel* _tmp0_ = NULL;
	BottomPanel* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bottom_panel != NULL);
	_tmp0_ = bottom_panel;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_bottom_panel);
	self->priv->_bottom_panel = _tmp1_;
}


void main_window_build_tools_update_sensitivity (MainWindowBuildTools* self) {
	gboolean build_tool_is_running = FALSE;
	GCancellable* _tmp0_ = NULL;
	GtkAction* stop_exec_action = NULL;
	GtkActionGroup* _tmp1_ = NULL;
	GtkAction* _tmp2_ = NULL;
	GtkAction* _tmp3_ = NULL;
	GtkAction* preferences_action = NULL;
	GtkActionGroup* _tmp4_ = NULL;
	GtkAction* _tmp5_ = NULL;
	GtkAction* _tmp6_ = NULL;
	GtkAction* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GtkAction* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GtkAction* clean_action = NULL;
	GtkActionGroup* _tmp11_ = NULL;
	GtkAction* _tmp12_ = NULL;
	GtkAction* _tmp13_ = NULL;
	GtkAction* view_log_action = NULL;
	GtkActionGroup* _tmp14_ = NULL;
	GtkAction* _tmp15_ = NULL;
	GtkAction* _tmp16_ = NULL;
	MainWindow* _tmp17_ = NULL;
	DocumentTab* _tmp18_ = NULL;
	DocumentTab* _tmp19_ = NULL;
	gboolean is_tex = FALSE;
	MainWindow* _tmp23_ = NULL;
	Document* _tmp24_ = NULL;
	Document* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	GtkAction* _tmp27_ = NULL;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	GtkActionGroup* _tmp32_ = NULL;
	GtkAction* _tmp33_ = NULL;
	gboolean _tmp34_ = FALSE;
	LatexilaBuildTools* build_tools = NULL;
	LatexilaBuildToolsDefault* _tmp35_ = NULL;
	LatexilaBuildTools* _tmp36_ = NULL;
	gint tool_num = 0;
	LatexilaBuildTools* _tmp37_ = NULL;
	GList* _tmp38_ = NULL;
	LatexilaBuildToolsPersonal* _tmp45_ = NULL;
	LatexilaBuildTools* _tmp46_ = NULL;
	LatexilaBuildTools* _tmp47_ = NULL;
	GList* _tmp48_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cancellable;
	build_tool_is_running = _tmp0_ != NULL;
	_tmp1_ = self->priv->_static_action_group;
	_tmp2_ = gtk_action_group_get_action (_tmp1_, "BuildStopExecution");
	_tmp3_ = _g_object_ref0 (_tmp2_);
	stop_exec_action = _tmp3_;
	_tmp4_ = self->priv->_static_action_group;
	_tmp5_ = gtk_action_group_get_action (_tmp4_, "BuildToolsPreferences");
	_tmp6_ = _g_object_ref0 (_tmp5_);
	preferences_action = _tmp6_;
	_tmp7_ = stop_exec_action;
	_tmp8_ = build_tool_is_running;
	gtk_action_set_sensitive (_tmp7_, _tmp8_);
	_tmp9_ = preferences_action;
	_tmp10_ = build_tool_is_running;
	gtk_action_set_sensitive (_tmp9_, !_tmp10_);
	_tmp11_ = self->priv->_static_action_group;
	_tmp12_ = gtk_action_group_get_action (_tmp11_, "BuildClean");
	_tmp13_ = _g_object_ref0 (_tmp12_);
	clean_action = _tmp13_;
	_tmp14_ = self->priv->_static_action_group;
	_tmp15_ = gtk_action_group_get_action (_tmp14_, "BuildViewLog");
	_tmp16_ = _g_object_ref0 (_tmp15_);
	view_log_action = _tmp16_;
	_tmp17_ = self->priv->_main_window;
	_tmp18_ = main_window_get_active_tab (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ == NULL) {
		GtkActionGroup* _tmp20_ = NULL;
		GtkAction* _tmp21_ = NULL;
		GtkAction* _tmp22_ = NULL;
		_tmp20_ = self->priv->_dynamic_action_group;
		gtk_action_group_set_sensitive (_tmp20_, FALSE);
		_tmp21_ = clean_action;
		gtk_action_set_sensitive (_tmp21_, FALSE);
		_tmp22_ = view_log_action;
		gtk_action_set_sensitive (_tmp22_, FALSE);
		_g_object_unref0 (view_log_action);
		_g_object_unref0 (clean_action);
		_g_object_unref0 (preferences_action);
		_g_object_unref0 (stop_exec_action);
		return;
	}
	_tmp23_ = self->priv->_main_window;
	_tmp24_ = main_window_get_active_document (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = document_is_main_file_a_tex_file (_tmp25_);
	is_tex = _tmp26_;
	_tmp27_ = view_log_action;
	_tmp28_ = is_tex;
	gtk_action_set_sensitive (_tmp27_, _tmp28_);
	_tmp29_ = build_tool_is_running;
	if (_tmp29_) {
		GtkActionGroup* _tmp30_ = NULL;
		GtkAction* _tmp31_ = NULL;
		_tmp30_ = self->priv->_dynamic_action_group;
		gtk_action_group_set_sensitive (_tmp30_, FALSE);
		_tmp31_ = clean_action;
		gtk_action_set_sensitive (_tmp31_, FALSE);
		_g_object_unref0 (view_log_action);
		_g_object_unref0 (clean_action);
		_g_object_unref0 (preferences_action);
		_g_object_unref0 (stop_exec_action);
		return;
	}
	_tmp32_ = self->priv->_dynamic_action_group;
	gtk_action_group_set_sensitive (_tmp32_, TRUE);
	_tmp33_ = clean_action;
	_tmp34_ = is_tex;
	gtk_action_set_sensitive (_tmp33_, _tmp34_);
	_tmp35_ = latexila_build_tools_default_get_instance ();
	_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp35_) : NULL);
	build_tools = _tmp36_;
	tool_num = 0;
	_tmp37_ = build_tools;
	_tmp38_ = _tmp37_->build_tools;
	{
		GList* tool_collection = NULL;
		GList* tool_it = NULL;
		tool_collection = _tmp38_;
		for (tool_it = tool_collection; tool_it != NULL; tool_it = tool_it->next) {
			LatexilaBuildTool* _tmp39_ = NULL;
			LatexilaBuildTool* tool = NULL;
			_tmp39_ = _g_object_ref0 ((LatexilaBuildTool*) tool_it->data);
			tool = _tmp39_;
			{
				gchar* action_name = NULL;
				gint _tmp40_ = 0;
				gchar* _tmp41_ = NULL;
				LatexilaBuildTool* _tmp42_ = NULL;
				const gchar* _tmp43_ = NULL;
				gint _tmp44_ = 0;
				_tmp40_ = tool_num;
				_tmp41_ = main_window_build_tools_get_default_build_tool_name (self, _tmp40_);
				action_name = _tmp41_;
				_tmp42_ = tool;
				_tmp43_ = action_name;
				main_window_build_tools_update_build_tool_sensitivity (self, _tmp42_, _tmp43_);
				_tmp44_ = tool_num;
				tool_num = _tmp44_ + 1;
				_g_free0 (action_name);
				_g_object_unref0 (tool);
			}
		}
	}
	_tmp45_ = latexila_build_tools_personal_get_instance ();
	_tmp46_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp45_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp45_) : NULL);
	_g_object_unref0 (build_tools);
	build_tools = _tmp46_;
	tool_num = 0;
	_tmp47_ = build_tools;
	_tmp48_ = _tmp47_->build_tools;
	{
		GList* tool_collection = NULL;
		GList* tool_it = NULL;
		tool_collection = _tmp48_;
		for (tool_it = tool_collection; tool_it != NULL; tool_it = tool_it->next) {
			LatexilaBuildTool* _tmp49_ = NULL;
			LatexilaBuildTool* tool = NULL;
			_tmp49_ = _g_object_ref0 ((LatexilaBuildTool*) tool_it->data);
			tool = _tmp49_;
			{
				gchar* action_name = NULL;
				gint _tmp50_ = 0;
				gchar* _tmp51_ = NULL;
				LatexilaBuildTool* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gint _tmp54_ = 0;
				_tmp50_ = tool_num;
				_tmp51_ = main_window_build_tools_get_personal_build_tool_name (self, _tmp50_);
				action_name = _tmp51_;
				_tmp52_ = tool;
				_tmp53_ = action_name;
				main_window_build_tools_update_build_tool_sensitivity (self, _tmp52_, _tmp53_);
				_tmp54_ = tool_num;
				tool_num = _tmp54_ + 1;
				_g_free0 (action_name);
				_g_object_unref0 (tool);
			}
		}
	}
	_g_object_unref0 (build_tools);
	_g_object_unref0 (view_log_action);
	_g_object_unref0 (clean_action);
	_g_object_unref0 (preferences_action);
	_g_object_unref0 (stop_exec_action);
}


static gchar* main_window_build_tools_get_default_build_tool_name (MainWindowBuildTools* self, gint tool_num) {
	gchar* result = NULL;
	gint _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tool_num;
	_tmp1_ = g_strdup_printf ("%i", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("DefaultBuildTool_", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static gchar* main_window_build_tools_get_personal_build_tool_name (MainWindowBuildTools* self, gint tool_num) {
	gchar* result = NULL;
	gint _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tool_num;
	_tmp1_ = g_strdup_printf ("%i", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("PersonalBuildTool_", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static LatexilaBuildTool* main_window_build_tools_get_build_tool_from_name (MainWindowBuildTools* self, const gchar* action_name) {
	LatexilaBuildTool* result = NULL;
	LatexilaBuildTools* build_tools = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar** name = NULL;
	const gchar* _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gint name_length1 = 0;
	gint _name_size_ = 0;
	gint tool_num = 0;
	const gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	LatexilaBuildTools* _tmp13_ = NULL;
	LatexilaBuildTool* _tmp14_ = NULL;
	LatexilaBuildTool* _tmp15_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (action_name != NULL, NULL);
	_tmp0_ = action_name;
	_tmp1_ = g_str_has_prefix (_tmp0_, "DefaultBuildTool_");
	if (_tmp1_) {
		LatexilaBuildToolsDefault* _tmp2_ = NULL;
		LatexilaBuildTools* _tmp3_ = NULL;
		_tmp2_ = latexila_build_tools_default_get_instance ();
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp2_) : NULL);
		_g_object_unref0 (build_tools);
		build_tools = _tmp3_;
	} else {
		const gchar* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = action_name;
		_tmp5_ = g_str_has_prefix (_tmp4_, "PersonalBuildTool_");
		if (_tmp5_) {
			LatexilaBuildToolsPersonal* _tmp6_ = NULL;
			LatexilaBuildTools* _tmp7_ = NULL;
			_tmp6_ = latexila_build_tools_personal_get_instance ();
			_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp6_) : NULL);
			_g_object_unref0 (build_tools);
			build_tools = _tmp7_;
		} else {
			g_return_val_if_reached (NULL);
		}
	}
	_tmp8_ = action_name;
	_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, "_", 0);
	name = _tmp10_;
	name_length1 = _vala_array_length (_tmp9_);
	_name_size_ = name_length1;
	g_return_val_if_fail (name_length1 == 2, NULL);
	_tmp11_ = name[1];
	_tmp12_ = atoi (_tmp11_);
	tool_num = _tmp12_;
	_tmp13_ = build_tools;
	_tmp14_ = latexila_build_tools_nth (_tmp13_, (guint) tool_num);
	_tmp15_ = _g_object_ref0 (_tmp14_);
	result = _tmp15_;
	name = (_vala_array_free (name, name_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (build_tools);
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void main_window_build_tools_update_build_tool_sensitivity (MainWindowBuildTools* self, LatexilaBuildTool* tool, const gchar* action_name) {
	LatexilaBuildTool* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkAction* action = NULL;
	GtkActionGroup* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkAction* _tmp5_ = NULL;
	GtkAction* _tmp6_ = NULL;
	Document* active_doc = NULL;
	MainWindow* _tmp7_ = NULL;
	Document* _tmp8_ = NULL;
	Document* _tmp9_ = NULL;
	Document* _tmp10_ = NULL;
	gboolean unsaved_doc = FALSE;
	Document* _tmp11_ = NULL;
	GFile* _tmp12_ = NULL;
	GFile* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	gchar* path = NULL;
	Document* _tmp18_ = NULL;
	GFile* _tmp19_ = NULL;
	GFile* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* ext = NULL;
	const gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar** extensions = NULL;
	LatexilaBuildTool* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar** _tmp29_ = NULL;
	gchar** _tmp30_ = NULL;
	gchar** _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	gint extensions_length1 = 0;
	gint _extensions_size_ = 0;
	gboolean _tmp32_ = FALSE;
	LatexilaBuildTool* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	gboolean _tmp39_ = FALSE;
	gboolean sensitive = FALSE;
	GtkAction* _tmp42_ = NULL;
	gboolean _tmp43_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tool != NULL);
	g_return_if_fail (action_name != NULL);
	_tmp0_ = tool;
	g_object_get (_tmp0_, "enabled", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->_dynamic_action_group;
	_tmp4_ = action_name;
	_tmp5_ = gtk_action_group_get_action (_tmp3_, _tmp4_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	action = _tmp6_;
	_tmp7_ = self->priv->_main_window;
	_tmp8_ = main_window_get_active_document (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	active_doc = _tmp10_;
	_tmp11_ = active_doc;
	_tmp12_ = document_get_location (_tmp11_);
	_tmp13_ = _tmp12_;
	unsaved_doc = _tmp13_ == NULL;
	_tmp14_ = unsaved_doc;
	if (_tmp14_) {
		GtkAction* _tmp15_ = NULL;
		LatexilaBuildTool* _tmp16_ = NULL;
		GList* _tmp17_ = NULL;
		_tmp15_ = action;
		_tmp16_ = tool;
		_tmp17_ = latexila_build_tool_get_jobs (_tmp16_);
		gtk_action_set_sensitive (_tmp15_, _tmp17_ != NULL);
		_g_object_unref0 (active_doc);
		_g_object_unref0 (action);
		return;
	}
	_tmp18_ = active_doc;
	_tmp19_ = document_get_main_file (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_file_get_parse_name (_tmp20_);
	_tmp22_ = _tmp21_;
	_g_object_unref0 (_tmp20_);
	path = _tmp22_;
	_tmp23_ = path;
	_tmp24_ = latexila_utils_get_extension (_tmp23_);
	ext = _tmp24_;
	_tmp25_ = tool;
	g_object_get (_tmp25_, "extensions", &_tmp26_, NULL);
	_tmp27_ = _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp30_ = _tmp29_ = g_strsplit (_tmp28_, " ", 0);
	_tmp31_ = _tmp30_;
	_tmp31__length1 = _vala_array_length (_tmp29_);
	_g_free0 (_tmp28_);
	extensions = _tmp31_;
	extensions_length1 = _tmp31__length1;
	_extensions_size_ = extensions_length1;
	_tmp33_ = tool;
	g_object_get (_tmp33_, "extensions", &_tmp34_, NULL);
	_tmp35_ = _tmp34_;
	_tmp36_ = _tmp35_;
	_tmp37_ = strlen (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = _tmp38_ == 0;
	_g_free0 (_tmp36_);
	if (_tmp39_) {
		_tmp32_ = TRUE;
	} else {
		const gchar* _tmp40_ = NULL;
		gchar** _tmp41_ = NULL;
		gint _tmp41__length1 = 0;
		_tmp40_ = ext;
		_tmp41_ = extensions;
		_tmp41__length1 = extensions_length1;
		_tmp32_ = _vala_string_array_contains (_tmp41_, _tmp41__length1, _tmp40_);
	}
	sensitive = _tmp32_;
	_tmp42_ = action;
	_tmp43_ = sensitive;
	gtk_action_set_sensitive (_tmp42_, _tmp43_);
	extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (ext);
	_g_free0 (path);
	_g_object_unref0 (active_doc);
	_g_object_unref0 (action);
}


void main_window_build_tools_save_state (MainWindowBuildTools* self) {
	GSettings* settings = NULL;
	GSettings* _tmp0_ = NULL;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp1_ = NULL;
	GtkAction* _tmp2_ = NULL;
	GtkToggleAction* _tmp3_ = NULL;
	GtkToggleAction* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GtkActionGroup* _tmp7_ = NULL;
	GtkAction* _tmp8_ = NULL;
	GtkToggleAction* _tmp9_ = NULL;
	GtkToggleAction* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.ui");
	settings = _tmp0_;
	_tmp1_ = self->priv->_static_action_group;
	_tmp2_ = gtk_action_group_get_action (_tmp1_, "BuildShowWarnings");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp2_) : NULL);
	action = _tmp3_;
	_tmp4_ = action;
	_tmp5_ = gtk_toggle_action_get_active (_tmp4_);
	_tmp6_ = _tmp5_;
	g_settings_set_boolean (settings, "show-build-warnings", _tmp6_);
	_tmp7_ = self->priv->_static_action_group;
	_tmp8_ = gtk_action_group_get_action (_tmp7_, "BuildShowBadBoxes");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp8_) : NULL);
	_g_object_unref0 (action);
	action = _tmp9_;
	_tmp10_ = action;
	_tmp11_ = gtk_toggle_action_get_active (_tmp10_);
	_tmp12_ = _tmp11_;
	g_settings_set_boolean (settings, "show-build-badboxes", _tmp12_);
	_g_object_unref0 (action);
	_g_object_unref0 (settings);
}


static void _main_window_build_tools_activate_dynamic_action_gtk_action_activate (GtkAction* _sender, gpointer self) {
	main_window_build_tools_activate_dynamic_action ((MainWindowBuildTools*) self, _sender);
}


static void main_window_build_tools_update_menu (MainWindowBuildTools* self) {
	GtkActionGroup* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GtkActionGroup* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	LatexilaBuildTools* default_build_tools = NULL;
	LatexilaBuildToolsDefault* _tmp11_ = NULL;
	LatexilaBuildTools* _tmp12_ = NULL;
	LatexilaBuildTools* personal_build_tools = NULL;
	LatexilaBuildToolsPersonal* _tmp13_ = NULL;
	LatexilaBuildTools* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	LatexilaBuildTools* _tmp16_ = NULL;
	GList* _tmp17_ = NULL;
	GtkUIManager* _tmp20_ = NULL;
	guint _tmp21_ = 0U;
	gint tool_num = 0;
	gint accel_num = 0;
	LatexilaBuildTools* _tmp22_ = NULL;
	GList* _tmp23_ = NULL;
	LatexilaBuildTools* _tmp30_ = NULL;
	GList* _tmp31_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_dynamic_action_group;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_menu_ui_id;
	if (_tmp1_ != ((guint) 0)) {
		GtkUIManager* _tmp2_ = NULL;
		guint _tmp3_ = 0U;
		_tmp2_ = self->priv->_ui_manager;
		_tmp3_ = self->priv->_menu_ui_id;
		gtk_ui_manager_remove_ui (_tmp2_, _tmp3_);
	}
	_tmp4_ = self->priv->_dynamic_action_group;
	_tmp5_ = gtk_action_group_list_actions (_tmp4_);
	{
		GList* action_collection = NULL;
		GList* action_it = NULL;
		action_collection = _tmp5_;
		for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
			GtkAction* _tmp6_ = NULL;
			GtkAction* action = NULL;
			_tmp6_ = _g_object_ref0 ((GtkAction*) action_it->data);
			action = _tmp6_;
			{
				GtkAction* _tmp7_ = NULL;
				guint _tmp8_ = 0U;
				GtkActionGroup* _tmp9_ = NULL;
				GtkAction* _tmp10_ = NULL;
				_tmp7_ = action;
				g_signal_parse_name ("activate", gtk_action_get_type (), &_tmp8_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _main_window_build_tools_activate_dynamic_action_gtk_action_activate, self);
				_tmp9_ = self->priv->_dynamic_action_group;
				_tmp10_ = action;
				gtk_action_group_remove_action (_tmp9_, _tmp10_);
				_g_object_unref0 (action);
			}
		}
		_g_list_free0 (action_collection);
	}
	_tmp11_ = latexila_build_tools_default_get_instance ();
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp11_) : NULL);
	default_build_tools = _tmp12_;
	_tmp13_ = latexila_build_tools_personal_get_instance ();
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp13_) : NULL);
	personal_build_tools = _tmp14_;
	_tmp16_ = default_build_tools;
	_tmp17_ = _tmp16_->build_tools;
	if (_tmp17_ == NULL) {
		LatexilaBuildTools* _tmp18_ = NULL;
		GList* _tmp19_ = NULL;
		_tmp18_ = personal_build_tools;
		_tmp19_ = _tmp18_->build_tools;
		_tmp15_ = _tmp19_ == NULL;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		self->priv->_menu_ui_id = (guint) 0;
		_g_object_unref0 (personal_build_tools);
		_g_object_unref0 (default_build_tools);
		return;
	}
	_tmp20_ = self->priv->_ui_manager;
	_tmp21_ = gtk_ui_manager_new_merge_id (_tmp20_);
	self->priv->_menu_ui_id = _tmp21_;
	tool_num = 0;
	accel_num = 2;
	_tmp22_ = default_build_tools;
	_tmp23_ = _tmp22_->build_tools;
	{
		GList* build_tool_collection = NULL;
		GList* build_tool_it = NULL;
		build_tool_collection = _tmp23_;
		for (build_tool_it = build_tool_collection; build_tool_it != NULL; build_tool_it = build_tool_it->next) {
			LatexilaBuildTool* _tmp24_ = NULL;
			LatexilaBuildTool* build_tool = NULL;
			_tmp24_ = _g_object_ref0 ((LatexilaBuildTool*) build_tool_it->data);
			build_tool = _tmp24_;
			{
				gchar* action_name = NULL;
				gint _tmp25_ = 0;
				gchar* _tmp26_ = NULL;
				LatexilaBuildTool* _tmp27_ = NULL;
				const gchar* _tmp28_ = NULL;
				gint _tmp29_ = 0;
				_tmp25_ = tool_num;
				_tmp26_ = main_window_build_tools_get_default_build_tool_name (self, _tmp25_);
				action_name = _tmp26_;
				_tmp27_ = build_tool;
				_tmp28_ = action_name;
				main_window_build_tools_add_dynamic_action (self, _tmp27_, _tmp28_, &accel_num);
				_tmp29_ = tool_num;
				tool_num = _tmp29_ + 1;
				_g_free0 (action_name);
				_g_object_unref0 (build_tool);
			}
		}
	}
	main_window_build_tools_add_separator (self);
	tool_num = 0;
	_tmp30_ = personal_build_tools;
	_tmp31_ = _tmp30_->build_tools;
	{
		GList* build_tool_collection = NULL;
		GList* build_tool_it = NULL;
		build_tool_collection = _tmp31_;
		for (build_tool_it = build_tool_collection; build_tool_it != NULL; build_tool_it = build_tool_it->next) {
			LatexilaBuildTool* _tmp32_ = NULL;
			LatexilaBuildTool* build_tool = NULL;
			_tmp32_ = _g_object_ref0 ((LatexilaBuildTool*) build_tool_it->data);
			build_tool = _tmp32_;
			{
				gchar* action_name = NULL;
				gint _tmp33_ = 0;
				gchar* _tmp34_ = NULL;
				LatexilaBuildTool* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				gint _tmp37_ = 0;
				_tmp33_ = tool_num;
				_tmp34_ = main_window_build_tools_get_personal_build_tool_name (self, _tmp33_);
				action_name = _tmp34_;
				_tmp35_ = build_tool;
				_tmp36_ = action_name;
				main_window_build_tools_add_dynamic_action (self, _tmp35_, _tmp36_, &accel_num);
				_tmp37_ = tool_num;
				tool_num = _tmp37_ + 1;
				_g_free0 (action_name);
				_g_object_unref0 (build_tool);
			}
		}
	}
	main_window_build_tools_update_sensitivity (self);
	_g_object_unref0 (personal_build_tools);
	_g_object_unref0 (default_build_tools);
}


static void main_window_build_tools_add_separator (MainWindowBuildTools* self) {
	GtkUIManager* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GtkUIManager* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_ui_manager;
	_tmp1_ = self->priv->_menu_ui_id;
	gtk_ui_manager_add_ui (_tmp0_, _tmp1_, "/MainMenu/BuildMenu/BuildToolsPlaceholderMenu", "BuildToolsSeparator", NULL, GTK_UI_MANAGER_SEPARATOR, FALSE);
	_tmp2_ = self->priv->_ui_manager;
	_tmp3_ = self->priv->_menu_ui_id;
	gtk_ui_manager_add_ui (_tmp2_, _tmp3_, "/MainToolbar/BuildToolsPlaceholderToolbar", "BuildToolsSeparator", NULL, GTK_UI_MANAGER_SEPARATOR, FALSE);
}


static void main_window_build_tools_add_dynamic_action (MainWindowBuildTools* self, LatexilaBuildTool* build_tool, const gchar* action_name, gint* accel_num) {
	LatexilaBuildTool* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkAction* action = NULL;
	const gchar* _tmp3_ = NULL;
	LatexilaBuildTool* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	LatexilaBuildTool* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkAction* _tmp10_ = NULL;
	GtkAction* _tmp11_ = NULL;
	GtkAction* _tmp12_ = NULL;
	LatexilaBuildTool* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	GtkAction* _tmp17_ = NULL;
	gchar* accel = NULL;
	gint _tmp18_ = 0;
	GtkActionGroup* _tmp23_ = NULL;
	GtkAction* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	GtkAction* _tmp26_ = NULL;
	GtkUIManager* _tmp27_ = NULL;
	guint _tmp28_ = 0U;
	const gchar* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	GtkUIManager* _tmp31_ = NULL;
	guint _tmp32_ = 0U;
	const gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (build_tool != NULL);
	g_return_if_fail (action_name != NULL);
	_tmp0_ = build_tool;
	g_object_get (_tmp0_, "enabled", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = action_name;
	_tmp4_ = build_tool;
	g_object_get (_tmp4_, "label", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = build_tool;
	_tmp9_ = latexila_build_tool_get_description (_tmp8_);
	_tmp10_ = gtk_action_new (_tmp3_, _tmp7_, _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp7_);
	action = _tmp11_;
	_tmp12_ = action;
	_tmp13_ = build_tool;
	g_object_get (_tmp13_, "icon", &_tmp14_, NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_;
	gtk_action_set_icon_name (_tmp12_, _tmp16_);
	_g_free0 (_tmp16_);
	_tmp17_ = action;
	gtk_action_set_always_show_image (_tmp17_, TRUE);
	accel = NULL;
	_tmp18_ = *accel_num;
	if (_tmp18_ <= 11) {
		gint _tmp19_ = 0;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		_tmp19_ = *accel_num;
		_tmp20_ = g_strdup_printf ("%i", _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat ("<Release>F", _tmp21_, NULL);
		_g_free0 (accel);
		accel = _tmp22_;
		_g_free0 (_tmp21_);
	}
	_tmp23_ = self->priv->_dynamic_action_group;
	_tmp24_ = action;
	_tmp25_ = accel;
	gtk_action_group_add_action_with_accel (_tmp23_, _tmp24_, _tmp25_);
	_tmp26_ = action;
	g_signal_connect (_tmp26_, "activate", (GCallback) _main_window_build_tools_activate_dynamic_action_gtk_action_activate, self);
	_tmp27_ = self->priv->_ui_manager;
	_tmp28_ = self->priv->_menu_ui_id;
	_tmp29_ = action_name;
	_tmp30_ = action_name;
	gtk_ui_manager_add_ui (_tmp27_, _tmp28_, "/MainMenu/BuildMenu/BuildToolsPlaceholderMenu", _tmp29_, _tmp30_, GTK_UI_MANAGER_MENUITEM, FALSE);
	_tmp31_ = self->priv->_ui_manager;
	_tmp32_ = self->priv->_menu_ui_id;
	_tmp33_ = action_name;
	_tmp34_ = action_name;
	gtk_ui_manager_add_ui (_tmp31_, _tmp32_, "/MainToolbar/BuildToolsPlaceholderToolbar", _tmp33_, _tmp34_, GTK_UI_MANAGER_TOOLITEM, FALSE);
	_tmp35_ = *accel_num;
	*accel_num = _tmp35_ + 1;
	_g_free0 (accel);
	_g_object_unref0 (action);
}


static Block23Data* block23_data_ref (Block23Data* _data23_) {
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}


static void block23_data_unref (void * _userdata_) {
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		MainWindowBuildTools* self;
		self = _data23_->self;
		_g_object_unref0 (_data23_->tool);
		_main_window_build_tools_unref0 (self);
		g_slice_free (Block23Data, _data23_);
	}
}


static void __lambda27_ (Block23Data* _data23_, GObject* obj, GAsyncResult* _result_) {
	MainWindowBuildTools* self;
	GAsyncResult* _tmp0_ = NULL;
	GAsyncResult* _tmp1_ = NULL;
	LatexilaBuildTool* _tmp2_ = NULL;
	GAsyncResult* _tmp3_ = NULL;
	MainWindow* _tmp4_ = NULL;
	MainWindowStructure* _tmp5_ = NULL;
	MainWindowStructure* _tmp6_ = NULL;
	self = _data23_->self;
	g_return_if_fail (_result_ != NULL);
	_tmp0_ = _result_;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_build_tool_result);
	self->priv->_build_tool_result = _tmp1_;
	_tmp2_ = _data23_->tool;
	_tmp3_ = _result_;
	latexila_build_tool_run_finish (_tmp2_, _tmp3_);
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = NULL;
	main_window_build_tools_update_sensitivity (self);
	_tmp4_ = self->priv->_main_window;
	_tmp5_ = main_window_get_main_window_structure (_tmp4_);
	_tmp6_ = _tmp5_;
	main_window_structure_refresh (_tmp6_);
	_main_window_structure_unref0 (_tmp6_);
}


static void ___lambda27__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda27_ (self, source_object, res);
	block23_data_unref (self);
}


static void main_window_build_tools_activate_dynamic_action (MainWindowBuildTools* self, GtkAction* action) {
	Block23Data* _data23_;
	MainWindow* _tmp0_ = NULL;
	DocumentTab* _tmp1_ = NULL;
	DocumentTab* _tmp2_ = NULL;
	LatexilaBuildView* _tmp3_ = NULL;
	BottomPanel* _tmp4_ = NULL;
	GtkAction* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	LatexilaBuildTool* _tmp8_ = NULL;
	LatexilaBuildTool* _tmp9_ = NULL;
	Document* active_doc = NULL;
	MainWindow* _tmp10_ = NULL;
	Document* _tmp11_ = NULL;
	Document* _tmp12_ = NULL;
	Document* _tmp13_ = NULL;
	LatexilaBuildTool* _tmp14_ = NULL;
	GList* _tmp15_ = NULL;
	LatexilaBuildTool* _tmp19_ = NULL;
	GList* _tmp20_ = NULL;
	GFile* main_file = NULL;
	Document* _tmp52_ = NULL;
	GFile* _tmp53_ = NULL;
	GCancellable* _tmp54_ = NULL;
	LatexilaBuildTool* _tmp55_ = NULL;
	LatexilaBuildView* _tmp56_ = NULL;
	GCancellable* _tmp57_ = NULL;
	BottomPanel* _tmp58_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_data23_ = g_slice_new0 (Block23Data);
	_data23_->_ref_count_ = 1;
	_data23_->self = main_window_build_tools_ref (self);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_build_view;
	g_return_if_fail (_tmp3_ != NULL);
	_tmp4_ = self->priv->_bottom_panel;
	g_return_if_fail (_tmp4_ != NULL);
	_tmp5_ = action;
	_tmp6_ = gtk_action_get_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = main_window_build_tools_get_build_tool_from_name (self, _tmp7_);
	_data23_->tool = _tmp8_;
	_tmp9_ = _data23_->tool;
	g_return_if_fail (_tmp9_ != NULL);
	_tmp10_ = self->priv->_main_window;
	_tmp11_ = main_window_get_active_document (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	active_doc = _tmp13_;
	_tmp14_ = _data23_->tool;
	_tmp15_ = latexila_build_tool_get_jobs (_tmp14_);
	if (_tmp15_ == NULL) {
		Document* _tmp16_ = NULL;
		GFile* _tmp17_ = NULL;
		GFile* _tmp18_ = NULL;
		_tmp16_ = active_doc;
		_tmp17_ = document_get_location (_tmp16_);
		_tmp18_ = _tmp17_;
		g_return_if_fail (_tmp18_ != NULL);
	}
	_tmp19_ = _data23_->tool;
	_tmp20_ = latexila_build_tool_get_jobs (_tmp19_);
	if (_tmp20_ != NULL) {
		Document* _tmp21_ = NULL;
		GFile* _tmp22_ = NULL;
		GFile* _tmp23_ = NULL;
		gint project_id = 0;
		Document* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		_tmp21_ = active_doc;
		_tmp22_ = document_get_location (_tmp21_);
		_tmp23_ = _tmp22_;
		if (_tmp23_ == NULL) {
			gboolean tmp_location_set = FALSE;
			Document* _tmp24_ = NULL;
			gboolean _tmp25_ = FALSE;
			gboolean _tmp26_ = FALSE;
			_tmp24_ = active_doc;
			_tmp25_ = document_set_tmp_location (_tmp24_);
			tmp_location_set = _tmp25_;
			_tmp26_ = tmp_location_set;
			g_return_if_fail (_tmp26_);
		}
		_tmp27_ = active_doc;
		_tmp28_ = document_get_project_id (_tmp27_);
		_tmp29_ = _tmp28_;
		project_id = _tmp29_;
		_tmp30_ = project_id;
		if (_tmp30_ == -1) {
			Document* _tmp31_ = NULL;
			_tmp31_ = active_doc;
			document_save (_tmp31_, TRUE, FALSE);
		} else {
			GeeList* docs = NULL;
			LatexilaApp* _tmp32_ = NULL;
			LatexilaApp* _tmp33_ = NULL;
			GeeList* _tmp34_ = NULL;
			GeeList* _tmp35_ = NULL;
			_tmp32_ = latexila_app_get_instance ();
			_tmp33_ = _tmp32_;
			_tmp34_ = latexila_app_get_documents (_tmp33_);
			_tmp35_ = _tmp34_;
			_g_object_unref0 (_tmp33_);
			docs = _tmp35_;
			{
				GeeList* _doc_list = NULL;
				GeeList* _tmp36_ = NULL;
				GeeList* _tmp37_ = NULL;
				gint _doc_size = 0;
				GeeList* _tmp38_ = NULL;
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
				gint _doc_index = 0;
				_tmp36_ = docs;
				_tmp37_ = _g_object_ref0 (_tmp36_);
				_doc_list = _tmp37_;
				_tmp38_ = _doc_list;
				_tmp39_ = gee_collection_get_size ((GeeCollection*) _tmp38_);
				_tmp40_ = _tmp39_;
				_doc_size = _tmp40_;
				_doc_index = -1;
				while (TRUE) {
					gint _tmp41_ = 0;
					gint _tmp42_ = 0;
					gint _tmp43_ = 0;
					Document* doc = NULL;
					GeeList* _tmp44_ = NULL;
					gint _tmp45_ = 0;
					gpointer _tmp46_ = NULL;
					Document* _tmp47_ = NULL;
					gint _tmp48_ = 0;
					gint _tmp49_ = 0;
					gint _tmp50_ = 0;
					_tmp41_ = _doc_index;
					_doc_index = _tmp41_ + 1;
					_tmp42_ = _doc_index;
					_tmp43_ = _doc_size;
					if (!(_tmp42_ < _tmp43_)) {
						break;
					}
					_tmp44_ = _doc_list;
					_tmp45_ = _doc_index;
					_tmp46_ = gee_list_get (_tmp44_, _tmp45_);
					doc = (Document*) _tmp46_;
					_tmp47_ = doc;
					_tmp48_ = document_get_project_id (_tmp47_);
					_tmp49_ = _tmp48_;
					_tmp50_ = project_id;
					if (_tmp49_ == _tmp50_) {
						Document* _tmp51_ = NULL;
						_tmp51_ = doc;
						document_save (_tmp51_, TRUE, FALSE);
					}
					_g_object_unref0 (doc);
				}
				_g_object_unref0 (_doc_list);
			}
			_g_object_unref0 (docs);
		}
		utils_flush_queue ();
	}
	_tmp52_ = active_doc;
	_tmp53_ = document_get_main_file (_tmp52_);
	main_file = _tmp53_;
	_tmp54_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp54_;
	_g_object_unref0 (self->priv->_build_tool_result);
	self->priv->_build_tool_result = NULL;
	main_window_build_tools_update_sensitivity (self);
	_tmp55_ = _data23_->tool;
	_tmp56_ = self->priv->_build_view;
	_tmp57_ = self->priv->_cancellable;
	latexila_build_tool_run_async (_tmp55_, main_file, _tmp56_, _tmp57_, ___lambda27__gasync_ready_callback, block23_data_ref (_data23_));
	_tmp58_ = self->priv->_bottom_panel;
	gtk_widget_show ((GtkWidget*) _tmp58_);
	_g_object_unref0 (main_file);
	_g_object_unref0 (active_doc);
	block23_data_unref (_data23_);
	_data23_ = NULL;
}


static void main_window_build_tools_connect_toggle_actions (MainWindowBuildTools* self) {
	LatexilaBuildView* _tmp0_ = NULL;
	GSettings* settings = NULL;
	GSettings* _tmp1_ = NULL;
	GtkToggleAction* action_details = NULL;
	GtkActionGroup* _tmp2_ = NULL;
	GtkAction* _tmp3_ = NULL;
	GtkToggleAction* _tmp4_ = NULL;
	LatexilaBuildView* _tmp5_ = NULL;
	LatexilaBuildView* _tmp6_ = NULL;
	GtkToggleAction* action_warnings = NULL;
	GtkActionGroup* _tmp7_ = NULL;
	GtkAction* _tmp8_ = NULL;
	GtkToggleAction* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	LatexilaBuildView* _tmp11_ = NULL;
	GtkToggleAction* action_badboxes = NULL;
	GtkActionGroup* _tmp12_ = NULL;
	GtkAction* _tmp13_ = NULL;
	GtkToggleAction* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	LatexilaBuildView* _tmp16_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_build_view;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = g_settings_new ("org.gnome.latexila.preferences.ui");
	settings = _tmp1_;
	_tmp2_ = self->priv->_static_action_group;
	_tmp3_ = gtk_action_group_get_action (_tmp2_, "BuildShowDetails");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp3_) : NULL);
	action_details = _tmp4_;
	gtk_toggle_action_set_active (action_details, FALSE);
	_tmp5_ = self->priv->_build_view;
	g_object_bind_property_with_closures ((GObject*) action_details, "active", (GObject*) _tmp5_, "show-details", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp6_ = self->priv->_build_view;
	g_object_bind_property_with_closures ((GObject*) _tmp6_, "has-details", (GObject*) action_details, "sensitive", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp7_ = self->priv->_static_action_group;
	_tmp8_ = gtk_action_group_get_action (_tmp7_, "BuildShowWarnings");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp8_) : NULL);
	action_warnings = _tmp9_;
	_tmp10_ = g_settings_get_boolean (settings, "show-build-warnings");
	gtk_toggle_action_set_active (action_warnings, _tmp10_);
	_tmp11_ = self->priv->_build_view;
	g_object_bind_property_with_closures ((GObject*) action_warnings, "active", (GObject*) _tmp11_, "show-warnings", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp12_ = self->priv->_static_action_group;
	_tmp13_ = gtk_action_group_get_action (_tmp12_, "BuildShowBadBoxes");
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp13_) : NULL);
	action_badboxes = _tmp14_;
	_tmp15_ = g_settings_get_boolean (settings, "show-build-badboxes");
	gtk_toggle_action_set_active (action_badboxes, _tmp15_);
	_tmp16_ = self->priv->_build_view;
	g_object_bind_property_with_closures ((GObject*) action_badboxes, "active", (GObject*) _tmp16_, "show-badboxes", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_g_object_unref0 (action_badboxes);
	_g_object_unref0 (action_warnings);
	_g_object_unref0 (action_details);
	_g_object_unref0 (settings);
}


void main_window_build_tools_on_stop_execution (MainWindowBuildTools* self) {
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_cancellable;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_cancellable;
	g_cancellable_cancel (_tmp1_);
}


void main_window_build_tools_on_clean (MainWindowBuildTools* self) {
	MainWindow* _tmp0_ = NULL;
	DocumentTab* _tmp1_ = NULL;
	DocumentTab* _tmp2_ = NULL;
	CleanBuildFiles* build_files = NULL;
	MainWindow* _tmp3_ = NULL;
	MainWindow* _tmp4_ = NULL;
	Document* _tmp5_ = NULL;
	Document* _tmp6_ = NULL;
	CleanBuildFiles* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_main_window;
	_tmp4_ = self->priv->_main_window;
	_tmp5_ = main_window_get_active_document (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = clean_build_files_new (_tmp3_, _tmp6_);
	build_files = _tmp7_;
	clean_build_files_clean (build_files);
	_g_object_unref0 (build_files);
}


void main_window_build_tools_on_view_log (MainWindowBuildTools* self) {
	MainWindow* _tmp0_ = NULL;
	DocumentTab* _tmp1_ = NULL;
	DocumentTab* _tmp2_ = NULL;
	MainWindow* _tmp3_ = NULL;
	Document* _tmp4_ = NULL;
	Document* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GFile* mainfile = NULL;
	MainWindow* _tmp7_ = NULL;
	Document* _tmp8_ = NULL;
	Document* _tmp9_ = NULL;
	GFile* _tmp10_ = NULL;
	GFile* directory = NULL;
	GFile* _tmp11_ = NULL;
	GFile* _tmp12_ = NULL;
	gchar* basename = NULL;
	GFile* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	GFile* file = NULL;
	GFile* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	GFile* _tmp22_ = NULL;
	DocumentTab* tab = NULL;
	MainWindow* _tmp23_ = NULL;
	GFile* _tmp24_ = NULL;
	DocumentTab* _tmp25_ = NULL;
	DocumentTab* _tmp26_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_main_window;
	_tmp4_ = main_window_get_active_document (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = document_is_main_file_a_tex_file (_tmp5_);
	g_return_if_fail (_tmp6_);
	_tmp7_ = self->priv->_main_window;
	_tmp8_ = main_window_get_active_document (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = document_get_main_file (_tmp9_);
	mainfile = _tmp10_;
	_tmp11_ = mainfile;
	_tmp12_ = g_file_get_parent (_tmp11_);
	directory = _tmp12_;
	_tmp13_ = mainfile;
	_tmp14_ = g_file_get_basename (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = latexila_utils_get_shortname (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp17_, ".log", NULL);
	_tmp19_ = _tmp18_;
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	basename = _tmp19_;
	_tmp20_ = directory;
	_tmp21_ = basename;
	_tmp22_ = g_file_get_child (_tmp20_, _tmp21_);
	file = _tmp22_;
	_tmp23_ = self->priv->_main_window;
	_tmp24_ = file;
	_tmp25_ = main_window_open_document (_tmp23_, _tmp24_, TRUE);
	tab = _tmp25_;
	_tmp26_ = tab;
	if (_tmp26_ == NULL) {
		g_warning ("main_window_build_tools.vala:476: Impossible to view log");
	} else {
		DocumentTab* _tmp27_ = NULL;
		Document* _tmp28_ = NULL;
		Document* _tmp29_ = NULL;
		_tmp27_ = tab;
		_tmp28_ = document_tab_get_document (_tmp27_);
		_tmp29_ = _tmp28_;
		document_set_readonly (_tmp29_, TRUE);
	}
	_g_object_unref0 (tab);
	_g_object_unref0 (file);
	_g_free0 (basename);
	_g_object_unref0 (directory);
	_g_object_unref0 (mainfile);
}


void main_window_build_tools_on_preferences (MainWindowBuildTools* self) {
	LatexilaApp* _tmp0_ = NULL;
	LatexilaApp* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = latexila_app_get_instance ();
	_tmp1_ = _tmp0_;
	g_action_group_activate_action ((GActionGroup*) _tmp1_, "manage-build-tools", NULL);
	_g_object_unref0 (_tmp1_);
}


static void value_main_window_build_tools_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_main_window_build_tools_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		main_window_build_tools_unref (value->data[0].v_pointer);
	}
}


static void value_main_window_build_tools_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = main_window_build_tools_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_main_window_build_tools_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_main_window_build_tools_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		MainWindowBuildTools* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = main_window_build_tools_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_main_window_build_tools_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	MainWindowBuildTools** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = main_window_build_tools_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_main_window_build_tools (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecMainWindowBuildTools* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MAIN_WINDOW_BUILD_TOOLS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_main_window_build_tools (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_BUILD_TOOLS), NULL);
	return value->data[0].v_pointer;
}


void value_set_main_window_build_tools (GValue* value, gpointer v_object) {
	MainWindowBuildTools* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_BUILD_TOOLS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_BUILD_TOOLS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		main_window_build_tools_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		main_window_build_tools_unref (old);
	}
}


void value_take_main_window_build_tools (GValue* value, gpointer v_object) {
	MainWindowBuildTools* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_BUILD_TOOLS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_BUILD_TOOLS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		main_window_build_tools_unref (old);
	}
}


static void main_window_build_tools_class_init (MainWindowBuildToolsClass * klass) {
	main_window_build_tools_parent_class = g_type_class_peek_parent (klass);
	((MainWindowBuildToolsClass *) klass)->finalize = main_window_build_tools_finalize;
	g_type_class_add_private (klass, sizeof (MainWindowBuildToolsPrivate));
}


static void main_window_build_tools_instance_init (MainWindowBuildTools * self) {
	self->priv = MAIN_WINDOW_BUILD_TOOLS_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void main_window_build_tools_finalize (MainWindowBuildTools* obj) {
	MainWindowBuildTools * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildTools);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->_ui_manager);
	_g_object_unref0 (self->priv->_build_view);
	_g_object_unref0 (self->priv->_bottom_panel);
	_g_object_unref0 (self->priv->_cancellable);
	_g_object_unref0 (self->priv->_build_tool_result);
	_g_object_unref0 (self->priv->_static_action_group);
	_g_object_unref0 (self->priv->_dynamic_action_group);
}


GType main_window_build_tools_get_type (void) {
	static volatile gsize main_window_build_tools_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_build_tools_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_main_window_build_tools_init, value_main_window_build_tools_free_value, value_main_window_build_tools_copy_value, value_main_window_build_tools_peek_pointer, "p", value_main_window_build_tools_collect_value, "p", value_main_window_build_tools_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (MainWindowBuildToolsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_build_tools_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindowBuildTools), 0, (GInstanceInitFunc) main_window_build_tools_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType main_window_build_tools_type_id;
		main_window_build_tools_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MainWindowBuildTools", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&main_window_build_tools_type_id__volatile, main_window_build_tools_type_id);
	}
	return main_window_build_tools_type_id__volatile;
}


gpointer main_window_build_tools_ref (gpointer instance) {
	MainWindowBuildTools* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void main_window_build_tools_unref (gpointer instance) {
	MainWindowBuildTools* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MAIN_WINDOW_BUILD_TOOLS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



