//******************************************************************************
//  Copyright (c) 2005-2013 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


unit qt5;

{ Version : 2.6Beta }

{$mode objfpc}{$H+}

interface

uses Types;

{$MINENUMSIZE 4}


const
  QT_VERSION = 5 shl 16 + 6 shl 8 + 1;
  ApplicationFlags = QT_VERSION or $1000000;

{DEFINE QT_5}
{DEFINE QT_5_6}
{DEFINE QT_5_6_1}
  
{$IFDEF MSWINDOWS}
  Qt5PasLib = 'Qt5Pas1.dll';
{$ELSE}
  {$IFDEF DARWIN}
    Qt5PasLib = '';
    {$LINKFRAMEWORK Qt5Pas}
  {$ELSE}
    Qt5PasLib = 'libQt5Pas.so.1';
    {$IF DEFINED(LINUX) or DEFINED(FREEBSD) or DEFINED(NETBSD)}
      {$DEFINE BINUX}
    {$ENDIF}
  {$ENDIF}
{$ENDIF}


type

  PLong = ^Long;
{$ifdef CPU64 and not WIN64}
   Long = Int64;
{$else}
   Long = LongInt;
{$endif}
  
  

  QHookH = TMethod;
  PQSizePolicy = ^TQSizePolicy;
  TQSizePolicy = packed record
    Data: Word;
  end;
  
  PQColor = ^TQColor;
  TQColor = packed record
    ColorSpec : LongInt;
    Alpha : word;
    r,g,b : word; 
    Pad : word;
   end;

  {$IFDEF DARWIN}
  {void*}
  QtHandle = PtrUInt;
  {$ELSE}
  {unsigned long on x11, dword on windows}
  QtHandle = LongWord;
  {$ENDIF}
  PQReal = ^QReal;
  QReal = double;

  PQRgb = ^QRgb;
  QRgb = longword;
  
  PPtrIntArray = ^TPtrIntArray;
  TPtrIntArray = array of PtrInt;
  
  PQRealArray = ^TQRealArray;
  TQRealArray = array of QReal;
  
  TQImageCleanupFunction = procedure (info : Pointer); cdecl;
  
  
  
const
  NilMethod : TMethod = (Code: nil; Data: nil); 

type

  PQtPoint = ^TQtPoint;
  TQtPoint = packed record
    x : LongInt;
    y : LongInt;
  end;

  PQtPointF = ^TQtPointF;
  TQtPointF = packed record 
    x : QReal;
    y : QReal;
  end;

  
{$IFDEF DARWIN}
    EventHandlerRef                     = ^LongInt;
    EventRef                            = ^LongInt;
    RgnHandle                           = ^LongInt;
    MenuHandle                          = ^LongInt;
    MenuRef                             = MenuHandle;
    EventHandlerCallRef                 = ^LongInt;
    CGImageRef                          = Pointer;    
{$ENDIF}


{$IFDEF MSWINDOWS}
  { Message structure }
  PMsg = ^tagMSG;
  tagMSG = packed record
    hwnd: LongWord;
    message: Cardinal;
    wParam: Longint;
    lParam: Longint;
    time: DWORD;
    pt: TPoint;
  end;

  // Extra Q to avoid name clash with other Pascal Units
  WINHANDLE = System.THandle;
  QHCURSOR = type WINHANDLE;
  QHPALETTE = type WINHANDLE;
  QHFONT = type WINHANDLE;
  QHDC = type WINHANDLE;
  QHBITMAP = type WINHANDLE;
  QHBRUSH = type WINHANDLE;
  QHPEN = type WINHANDLE;
  QHRGN = type WINHANDLE;
  QHICON = type WINHANDLE;
{$ENDIF}

{$IFDEF WIN32}
  Q_PID = type pointer;
{$ELSE}
  Q_PID = type int64;
{$ENDIF}

{$IFDEF QTACCESSIBILITY}
QAccessibleEventH = class(TObject) end;
QAccessibleInterfaceH = class(TObject) end;
  QAccessibleWidgetH = class(QAccessibleInterfaceH) end;
    QLCLAccessibleWidgetH = class(QAccessibleWidgetH) end;
{$ENDIF}

QAbstractNativeEventFilterH = class(TObject) end;
QAuthenticatorH = class(TObject) end;
QBackingStoreH = class(TObject) end;
QBitArrayH = class(TObject) end;
QBrushH = class(TObject) end;
QByteArrayH = class(TObject) end;
QCharH = class(TObject) end;
QColorH = class(TObject) end;
QCursorH = class(TObject) end;
QDataStreamH = class(TObject) end;
QDateH = class(TObject) end;
QDateTimeH = class(TObject) end;
QDesktopServicesH = class(TObject) end;
QDirH = class(TObject) end;
QEasingCurveH = class(TObject) end;
QEventH = class(TObject) end;
  QScreenOrientationChangeEventH = class(QEventH) end;
  QApplicationStateChangeEventH = class(QEventH) end;
  QLCLMessageEventH = class(QEventH) end;
  QActionEventH = class(QEventH) end;
  QChildEventH = class(QEventH) end;
  QCloseEventH = class(QEventH) end;
  QDragLeaveEventH = class(QEventH) end;
  QDropEventH = class(QEventH) end;
    QDragMoveEventH = class(QDropEventH) end;
      QDragEnterEventH = class(QDragMoveEventH) end;
  QDynamicPropertyChangeEventH = class(QEventH) end;
  QEnterEventH = class(QEventH) end;
  QExposeEventH = class(QEventH) end;
  QFileOpenEventH = class(QEventH) end;
  QFocusEventH = class(QEventH) end;
  QGestureEventH = class(QEventH) end;
  QHelpEventH = class(QEventH) end;
  QHideEventH = class(QEventH) end;
  QIconDragEventH = class(QEventH) end;
  QInputEventH = class(QEventH) end;
    QContextMenuEventH = class(QInputEventH) end;
    QHoverEventH = class(QInputEventH) end;
    QKeyEventH = class(QInputEventH) end;
    QMouseEventH = class(QInputEventH) end;
    QTabletEventH = class(QInputEventH) end;
    QTouchEventH = class(QInputEventH) end;
    QWheelEventH = class(QInputEventH) end;
  QInputMethodEventH = class(QEventH) end;
  QInputMethodQueryEventH = class(QEventH) end;
  QMoveEventH = class(QEventH) end;
  QPaintEventH = class(QEventH) end;
  QResizeEventH = class(QEventH) end;
  QScrollEventH = class(QEventH) end;
  QScrollPrepareEventH = class(QEventH) end;
  QShortcutEventH = class(QEventH) end;
  QShowEventH = class(QEventH) end;
  QStatusTipEventH = class(QEventH) end;
  QTimerEventH = class(QEventH) end;
  QWhatsThisClickedEventH = class(QEventH) end;
  QWindowStateChangeEventH = class(QEventH) end;
QEventLoopLockerH = class(TObject) end;
QFileIconProviderH = class(TObject) end;
QFileInfoH = class(TObject) end;
QFontH = class(TObject) end;
QFontDatabaseH = class(TObject) end;
QFontInfoH = class(TObject) end;
QFontMetricsH = class(TObject) end;
QFontMetricsFH = class(TObject) end;
QGenericArgumentH = class(TObject) end;
  QGenericReturnArgumentH = class(QGenericArgumentH) end;
QGestureRecognizerH = class(TObject) end;
QGlyphRunH = class(TObject) end;
QGradientH = class(TObject) end;
  QConicalGradientH = class(QGradientH) end;
  QLinearGradientH = class(QGradientH) end;
  QRadialGradientH = class(QGradientH) end;
QGraphicsItemH = class(TObject) end;
  QAbstractGraphicsShapeItemH = class(QGraphicsItemH) end;
    QGraphicsEllipseItemH = class(QAbstractGraphicsShapeItemH) end;
    QGraphicsPathItemH = class(QAbstractGraphicsShapeItemH) end;
    QGraphicsPolygonItemH = class(QAbstractGraphicsShapeItemH) end;
    QGraphicsRectItemH = class(QAbstractGraphicsShapeItemH) end;
    QGraphicsSimpleTextItemH = class(QAbstractGraphicsShapeItemH) end;
  QGraphicsItemGroupH = class(QGraphicsItemH) end;
  QGraphicsLineItemH = class(QGraphicsItemH) end;
  QGraphicsObjectH = class(QGraphicsItemH) end;
    QGraphicsTextItemH = class(QGraphicsObjectH) end;
    QGraphicsWidgetH = class(QGraphicsObjectH) end;
      QGraphicsProxyWidgetH = class(QGraphicsWidgetH) end;
  QGraphicsPixmapItemH = class(QGraphicsItemH) end;
QGraphicsLayoutItemH = class(TObject) end;
QHostAddressH = class(TObject) end;
QIconH = class(TObject) end;
QIconEngineH = class(TObject) end;
QImageIOHandlerH = class(TObject) end;
QImageReaderH = class(TObject) end;
QImageWriterH = class(TObject) end;
QItemEditorCreatorBaseH = class(TObject) end;
QItemEditorFactoryH = class(TObject) end;
QItemSelectionRangeH = class(TObject) end;
QJsonArrayH = class(TObject) end;
QJsonDocumentH = class(TObject) end;
QJsonObjectH = class(TObject) end;
QJsonValueH = class(TObject) end;
QKeySequenceH = class(TObject) end;
QLayoutItemH = class(TObject) end;
  QLayoutH = class(QLayoutItemH) end;
    QBoxLayoutH = class(QLayoutH) end;
      QHBoxLayoutH = class(QBoxLayoutH) end;
      QVBoxLayoutH = class(QBoxLayoutH) end;
    QGridLayoutH = class(QLayoutH) end;
    QStackedLayoutH = class(QLayoutH) end;
  QSpacerItemH = class(QLayoutItemH) end;
  QWidgetItemH = class(QLayoutItemH) end;
QLineH = class(TObject) end;
QLineFH = class(TObject) end;
QListH = class(TObject) end;
  QStringListH = class(QListH) end;
QListWidgetItemH = class(TObject) end;
QLocaleH = class(TObject) end;
QMarginsH = class(TObject) end;
QMatrixH = class(TObject) end;
QMetaClassInfoH = class(TObject) end;
QMetaEnumH = class(TObject) end;
QMetaMethodH = class(TObject) end;
QMetaObjectH = class(TObject) end;
QMetaPropertyH = class(TObject) end;
QModelIndexH = class(TObject) end;
QNetworkConfigurationH = class(TObject) end;
QNetworkCookieH = class(TObject) end;
QNetworkInterfaceH = class(TObject) end;
QNetworkProxyH = class(TObject) end;
QNetworkProxyFactoryH = class(TObject) end;
QNetworkProxyQueryH = class(TObject) end;
QNetworkRequestH = class(TObject) end;
QX11InfoH = class(TObject) end;
QObjectH = class(TObject) end;
  QAbstractEventDispatcherH = class(QObjectH) end;
  QAbstractItemDelegateH = class(QObjectH) end;
    QItemDelegateH = class(QAbstractItemDelegateH) end;
      QLCLItemDelegateH = class(QItemDelegateH) end;
    QStyledItemDelegateH = class(QAbstractItemDelegateH) end;
  QAbstractItemModelH = class(QObjectH) end;
    QAbstractListModelH = class(QAbstractItemModelH) end;
    QAbstractProxyModelH = class(QAbstractItemModelH) end;
    QAbstractTableModelH = class(QAbstractItemModelH) end;
    QStandardItemModelH = class(QAbstractItemModelH) end;
  QAbstractNetworkCacheH = class(QObjectH) end;
  QAbstractTextDocumentLayoutH = class(QObjectH) end;
    QPlainTextDocumentLayoutH = class(QAbstractTextDocumentLayoutH) end;
  QActionH = class(QObjectH) end;
  QActionGroupH = class(QObjectH) end;
  QButtonGroupH = class(QObjectH) end;
  QClipboardH = class(QObjectH) end;
  QCompleterH = class(QObjectH) end;
  QCoreApplicationH = class(QObjectH) end;
    QGuiApplicationH = class(QCoreApplicationH) end;
      QApplicationH = class(QGuiApplicationH) end;
  QDragH = class(QObjectH) end;
  QEventLoopH = class(QObjectH) end;
  QFileSystemWatcherH = class(QObjectH) end;
  QGestureH = class(QObjectH) end;
    QPanGestureH = class(QGestureH) end;
    QPinchGestureH = class(QGestureH) end;
    QSwipeGestureH = class(QGestureH) end;
    QTapAndHoldGestureH = class(QGestureH) end;
    QTapGestureH = class(QGestureH) end;
  QGraphicsEffectH = class(QObjectH) end;
  QGraphicsSceneH = class(QObjectH) end;
  QHttpMultiPartH = class(QObjectH) end;
  QIODeviceH = class(QObjectH) end;
    QAbstractSocketH = class(QIODeviceH) end;
      QTcpSocketH = class(QAbstractSocketH) end;
        QSslSocketH = class(QTcpSocketH) end;
      QUdpSocketH = class(QAbstractSocketH) end;
    QBufferH = class(QIODeviceH) end;
    QFileDeviceH = class(QIODeviceH) end;
      QFileH = class(QFileDeviceH) end;
    QNetworkReplyH = class(QIODeviceH) end;
    QProcessH = class(QIODeviceH) end;
  QInputMethodH = class(QObjectH) end;
  QItemSelectionModelH = class(QObjectH) end;
  QMimeDataH = class(QObjectH) end;
  QMovieH = class(QObjectH) end;
  QNetworkAccessManagerH = class(QObjectH) end;
  QNetworkCookieJarH = class(QObjectH) end;
  QScreenH = class(QObjectH) end;
{$ifndef QT_NO_SESSIONMANAGER}
  QSessionManagerH = class(QObjectH) end;
{$endif}
  QShortcutH = class(QObjectH) end;
  QSocketNotifierH = class(QObjectH) end;
  QStyleH = class(QObjectH) end;
  QStyleHintsH = class(QObjectH) end;
  QSystemTrayIconH = class(QObjectH) end;
  QTcpServerH = class(QObjectH) end;
  QTextDocumentH = class(QObjectH) end;
  QTextObjectH = class(QObjectH) end;
    QTextBlockGroupH = class(QTextObjectH) end;
      QTextListH = class(QTextBlockGroupH) end;
    QTextFrameH = class(QTextObjectH) end;
      QTextTableH = class(QTextFrameH) end;
  QThreadH = class(QObjectH) end;
    QLCLThreadH = class(QThreadH) end;
  QTimerH = class(QObjectH) end;
  QTranslatorH = class(QObjectH) end;
  QUndoStackH = class(QObjectH) end;
  QValidatorH = class(QObjectH) end;
    QDoubleValidatorH = class(QValidatorH) end;
    QIntValidatorH = class(QValidatorH) end;
    QRegExpValidatorH = class(QValidatorH) end;
    QRegularExpressionValidatorH = class(QValidatorH) end;
  QWidgetH = class(QObjectH) end;
    QAbstractButtonH = class(QWidgetH) end;
      QCheckBoxH = class(QAbstractButtonH) end;
      QPushButtonH = class(QAbstractButtonH) end;
      QRadioButtonH = class(QAbstractButtonH) end;
      QToolButtonH = class(QAbstractButtonH) end;
      QLCLOpenGLWidgetH = class(QWidgeth) end;
    QAbstractSliderH = class(QWidgetH) end;
      QScrollBarH = class(QAbstractSliderH) end;
      QSliderH = class(QAbstractSliderH) end;
    QAbstractSpinBoxH = class(QWidgetH) end;
      QLCLAbstractSpinBoxH = class(QAbstractSpinBoxH) end;
      QDoubleSpinBoxH = class(QAbstractSpinBoxH) end;
      QSpinBoxH = class(QAbstractSpinBoxH) end;
    QCalendarWidgetH = class(QWidgetH) end;
    QComboBoxH = class(QWidgetH) end;
      QFontComboBoxH = class(QComboBoxH) end;
    QDesktopWidgetH = class(QWidgetH) end;
    QDialogH = class(QWidgetH) end;
      QColorDialogH = class(QDialogH) end;
      QFileDialogH = class(QDialogH) end;
      QFontDialogH = class(QDialogH) end;
      QInputDialogH = class(QDialogH) end;
      QMessageBoxH = class(QDialogH) end;
      QProgressDialogH = class(QDialogH) end;
      QPageSetupDialogH = class(QDialogH) end;
      QAbstractPrintDialogH = class(QDialogH) end;
        QPrintDialogH = class(QAbstractPrintDialogH) end;      
    QDockWidgetH = class(QWidgetH) end;
    QFrameH = class(QWidgetH) end;
      QAbstractScrollAreaH = class(QFrameH) end;
        QLCLAbstractScrollAreaH = class(QAbstractScrollAreaH) end;
        QAbstractItemViewH = class(QAbstractScrollAreaH) end;
          QHeaderViewH = class(QAbstractItemViewH) end;
          QListViewH = class(QAbstractItemViewH) end;
            QListWidgetH = class(QListViewH) end;
          QTableViewH = class(QAbstractItemViewH) end;
            QTableWidgetH = class(QTableViewH) end;
          QTreeViewH = class(QAbstractItemViewH) end;
            QTreeWidgetH = class(QTreeViewH) end;
        QGraphicsViewH = class(QAbstractScrollAreaH) end;
        QMdiAreaH = class(QAbstractScrollAreaH) end;
        QPlainTextEditH = class(QAbstractScrollAreaH) end;
        QScrollAreaH = class(QAbstractScrollAreaH) end;
        QTextEditH = class(QAbstractScrollAreaH) end;
          QTextBrowserH = class(QTextEditH) end;
      QLCDNumberH = class(QFrameH) end;
      QLabelH = class(QFrameH) end;
      QSplitterH = class(QFrameH) end;
      QStackedWidgetH = class(QFrameH) end;
      QToolBoxH = class(QFrameH) end;
    QGroupBoxH = class(QWidgetH) end;
    QLineEditH = class(QWidgetH) end;
    QMainWindowH = class(QWidgetH) end;
    QMdiSubWindowH = class(QWidgetH) end;
    QMenuH = class(QWidgetH) end;
    QMenuBarH = class(QWidgetH) end;
    QProgressBarH = class(QWidgetH) end;
    QRubberBandH = class(QWidgetH) end;
    QSizeGripH = class(QWidgetH) end;
    QSplitterHandleH = class(QWidgetH) end;
    QStatusBarH = class(QWidgetH) end;
    QTabBarH = class(QWidgetH) end;
    QTabWidgetH = class(QWidgetH) end;
      QLCLTabWidgetH = class(QTabWidgetH) end;
    QToolBarH = class(QWidgetH) end;
  QWinEventNotifierH = class(QObjectH) end;
  QWindowH = class(QObjectH) end;
QPaintDeviceH = class(TObject) end;
  QImageH = class(QPaintDeviceH) end;
  QPagedPaintDeviceH = class(QPaintDeviceH) end;
    QPrinterH = class(QPagedPaintDeviceH) end;
  QPictureH = class(QPaintDeviceH) end;
  QPixmapH = class(QPaintDeviceH) end;
    QBitmapH = class(QPixmapH) end;
QPaintEngineH = class(TObject) end;
QPainterH = class(TObject) end;
QPainterPathH = class(TObject) end;
QPainterPathStrokerH = class(TObject) end;
QPaletteH = class(TObject) end;
QPenH = class(TObject) end;
QPersistentModelIndexH = class(TObject) end;
QPointH = class(TObject) end;
QPointFH = class(TObject) end;
QPrintEngineH = class(TObject) end;
QPrintPreviewDialogH = class(TObject) end;
QPrintPreviewWidgetH = class(TObject) end;
QPrinterInfoH = class(TObject) end;
QProcessEnvironmentH = class(TObject) end;
QRawFontH = class(TObject) end;
QRectH = class(TObject) end;
QRectFH = class(TObject) end;
QRegExpH = class(TObject) end;
QRegionH = class(TObject) end;
QRegularExpressionH = class(TObject) end;
QRegularExpressionMatchH = class(TObject) end;
QSizeH = class(TObject) end;
QSizeFH = class(TObject) end;
QSizePolicyH = class(TObject) end;
QSslCertificateH = class(TObject) end;
QSslCipherH = class(TObject) end;
QSslConfigurationH = class(TObject) end;
QSslErrorH = class(TObject) end;
QSslKeyH = class(TObject) end;
QStandardItemH = class(TObject) end;
QStaticTextH = class(TObject) end;
QStringH = class(TObject) end;
QStyleFactoryH = class(TObject) end;
QStyleHintReturnH = class(TObject) end;
  QStyleHintReturnMaskH = class(QStyleHintReturnH) end;
  QStyleHintReturnVariantH = class(QStyleHintReturnH) end;
QStyleOptionH = class(TObject) end;
  QStyleOptionButtonH = class(QStyleOptionH) end;
  QStyleOptionComplexH = class(QStyleOptionH) end;
    QStyleOptionComboBoxH = class(QStyleOptionComplexH) end;
    QStyleOptionGroupBoxH = class(QStyleOptionComplexH) end;
    QStyleOptionSizeGripH = class(QStyleOptionComplexH) end;
    QStyleOptionSliderH = class(QStyleOptionComplexH) end;
    QStyleOptionSpinBoxH = class(QStyleOptionComplexH) end;
    QStyleOptionTitleBarH = class(QStyleOptionComplexH) end;
    QStyleOptionToolButtonH = class(QStyleOptionComplexH) end;
  QStyleOptionDockWidgetH = class(QStyleOptionH) end;
  QStyleOptionFocusRectH = class(QStyleOptionH) end;
  QStyleOptionFrameH = class(QStyleOptionH) end;
  QStyleOptionGraphicsItemH = class(QStyleOptionH) end;
  QStyleOptionHeaderH = class(QStyleOptionH) end;
  QStyleOptionMenuItemH = class(QStyleOptionH) end;
  QStyleOptionProgressBarH = class(QStyleOptionH) end;
  QStyleOptionRubberBandH = class(QStyleOptionH) end;
  QStyleOptionTabH = class(QStyleOptionH) end;
  QStyleOptionTabBarBaseH = class(QStyleOptionH) end;
  QStyleOptionTabWidgetFrameH = class(QStyleOptionH) end;
  QStyleOptionToolBarH = class(QStyleOptionH) end;
  QStyleOptionToolBoxH = class(QStyleOptionH) end;
  QStyleOptionViewItemH = class(QStyleOptionH) end;
QSurfaceH = class(TObject) end;
QSurfaceFormatH = class(TObject) end;
QTableWidgetItemH = class(TObject) end;
QTableWidgetSelectionRangeH = class(TObject) end;
QTextBlockH = class(TObject) end;
QTextBlockUserDataH = class(TObject) end;
QTextCodecH = class(TObject) end;
QTextCursorH = class(TObject) end;
QTextDocumentFragmentH = class(TObject) end;
QTextDocumentWriterH = class(TObject) end;
QTextFormatH = class(TObject) end;
  QTextBlockFormatH = class(QTextFormatH) end;
  QTextCharFormatH = class(QTextFormatH) end;
    QTextImageFormatH = class(QTextCharFormatH) end;
    QTextTableCellFormatH = class(QTextCharFormatH) end;
  QTextFrameFormatH = class(QTextFormatH) end;
    QTextTableFormatH = class(QTextFrameFormatH) end;
  QTextListFormatH = class(QTextFormatH) end;
QTextFragmentH = class(TObject) end;
QTextInlineObjectH = class(TObject) end;
QTextLayoutH = class(TObject) end;
QTextLengthH = class(TObject) end;
QTextLineH = class(TObject) end;
QTextObjectInterfaceH = class(TObject) end;
QTextOptionH = class(TObject) end;
QTimeH = class(TObject) end;
QToolTipH = class(TObject) end;
QTouchDeviceH = class(TObject) end;
QTransformH = class(TObject) end;
QTreeWidgetItemH = class(TObject) end;
QUrlH = class(TObject) end;
QUrlQueryH = class(TObject) end;
QUuidH = class(TObject) end;
QVariantH = class(TObject) end;
QVectorH = class(TObject) end;
  QPolygonH = class(QVectorH) end;
  QPolygonFH = class(QVectorH) end;
QWhatsThisH = class(TObject) end;

QPainterPathElementH = class(TObject) end;
QObject_hookH = class(TObject) end;
QCoreApplication_hookH = class(QObject_hookH) end;
QTimer_hookH = class(QObject_hookH) end;
QSocketNotifier_hookH = class(QObject_hookH) end;
QModelIndex_hookH = class(QObject_hookH) end;
QPersistentModelIndex_hookH = class(QObject_hookH) end;
QAbstractItemModel_hookH = class(QObject_hookH) end;
QAbstractTableModel_hookH = class(QAbstractItemModel_hookH) end;
QAbstractListModel_hookH = class(QAbstractItemModel_hookH) end;
QItemSelectionRange_hookH = class(QObject_hookH) end;
QItemSelectionModel_hookH = class(QObject_hookH) end;
QThread_hookH = class(QObject_hookH) end;
QIODevice_hookH = class(QObject_hookH) end;
QProcessEnvironment_hookH = class(QObject_hookH) end;
QProcess_hookH = class(QIODevice_hookH) end;
QFileSystemWatcher_hookH = class(QObject_hookH) end;
QClipboard_hookH = class(QObject_hookH) end;
QDrag_hookH = class(QObject_hookH) end;
QGuiApplication_hookH = class(QCoreApplication_hookH) end;
QApplication_hookH = class(QGuiApplication_hookH) end;
QScreen_hookH = class(QObject_hookH) end;
QWindow_hookH = class(QObject_hookH) end;
QWidget_hookH = class(QObject_hookH) end;
QLayout_hookH = class(QObject_hookH) end;
QStackedLayout_hookH = class(QLayout_hookH) end;
QAction_hookH = class(QObject_hookH) end;
QActionGroup_hookH = class(QObject_hookH) end;
QDesktopWidget_hookH = class(QWidget_hookH) end;
QShortcut_hookH = class(QObject_hookH) end;
QAbstractTextDocumentLayout_hookH = class(QObject_hookH) end;
QTextObjectInterface_hookH = class(QObject_hookH) end;
QStandardItem_hookH = class(QObject_hookH) end;
QStandardItemModel_hookH = class(QAbstractItemModel_hookH) end;
QFrame_hookH = class(QWidget_hookH) end;
QStackedWidget_hookH = class(QFrame_hookH) end;
QAbstractScrollArea_hookH = class(QFrame_hookH) end;
QAbstractSlider_hookH = class(QWidget_hookH) end;
QScrollBar_hookH = class(QAbstractSlider_hookH) end;
QMenu_hookH = class(QWidget_hookH) end;
QMenuBar_hookH = class(QWidget_hookH) end;
QButtonGroup_hookH = class(QObject_hookH) end;
QAbstractButton_hookH = class(QWidget_hookH) end;
QPushButton_hookH = class(QAbstractButton_hookH) end;
QCompleter_hookH = class(QObject_hookH) end;
QLineEdit_hookH = class(QWidget_hookH) end;
QPlainTextEdit_hookH = class(QAbstractScrollArea_hookH) end;
QPlainTextDocumentLayout_hookH = class(QAbstractTextDocumentLayout_hookH) end;
QTextEdit_hookH = class(QAbstractScrollArea_hookH) end;
QTabWidget_hookH = class(QWidget_hookH) end;
QMainWindow_hookH = class(QWidget_hookH) end;
QToolBar_hookH = class(QWidget_hookH) end;
QLCDNumber_hookH = class(QFrame_hookH) end;
QAbstractSpinBox_hookH = class(QWidget_hookH) end;
QSpinBox_hookH = class(QAbstractSpinBox_hookH) end;
QDoubleSpinBox_hookH = class(QAbstractSpinBox_hookH) end;
QSplitter_hookH = class(QFrame_hookH) end;
QSplitterHandle_hookH = class(QWidget_hookH) end;
QComboBox_hookH = class(QWidget_hookH) end;
QCheckBox_hookH = class(QAbstractButton_hookH) end;
QSlider_hookH = class(QAbstractSlider_hookH) end;
QTextBrowser_hookH = class(QTextEdit_hookH) end;
QLabel_hookH = class(QFrame_hookH) end;
QGroupBox_hookH = class(QWidget_hookH) end;
QDockWidget_hookH = class(QWidget_hookH) end;
QTabBar_hookH = class(QWidget_hookH) end;
QProgressBar_hookH = class(QWidget_hookH) end;
QStatusBar_hookH = class(QWidget_hookH) end;
QToolBox_hookH = class(QFrame_hookH) end;
QToolButton_hookH = class(QAbstractButton_hookH) end;
QMdiArea_hookH = class(QAbstractScrollArea_hookH) end;
QMdiSubWindow_hookH = class(QWidget_hookH) end;
QCalendarWidget_hookH = class(QWidget_hookH) end;
QFontComboBox_hookH = class(QComboBox_hookH) end;
QAbstractItemView_hookH = class(QAbstractScrollArea_hookH) end;
QListView_hookH = class(QAbstractItemView_hookH) end;
QListWidgetItem_hookH = class(QObject_hookH) end;
QListWidget_hookH = class(QListView_hookH) end;
QTreeView_hookH = class(QAbstractItemView_hookH) end;
QTreeWidgetItem_hookH = class(QObject_hookH) end;
QTreeWidget_hookH = class(QTreeView_hookH) end;
QHeaderView_hookH = class(QAbstractItemView_hookH) end;
QAbstractItemDelegate_hookH = class(QObject_hookH) end;
QTableView_hookH = class(QAbstractItemView_hookH) end;
QTableWidgetSelectionRange_hookH = class(QObject_hookH) end;
QTableWidgetItem_hookH = class(QObject_hookH) end;
QTableWidget_hookH = class(QTableView_hookH) end;
QDialog_hookH = class(QWidget_hookH) end;
QFileDialog_hookH = class(QDialog_hookH) end;
QProgressDialog_hookH = class(QDialog_hookH) end;
QAbstractPrintDialog_hookH = class(QDialog_hookH) end;
QPrintDialog_hookH = class(QAbstractPrintDialog_hookH) end;
QPrintPreviewDialog_hookH = class(QDialog_hookH) end;
QPrintPreviewWidget_hookH = class(QWidget_hookH) end;
QSystemTrayIcon_hookH = class(QObject_hookH) end;
QGraphicsScene_hookH = class(QObject_hookH) end;
QAbstractSocket_hookH = class(QIODevice_hookH) end;
QUdpSocket_hookH = class(QAbstractSocket_hookH) end;
QTcpSocket_hookH = class(QAbstractSocket_hookH) end;
QTcpServer_hookH = class(QObject_hookH) end;
QNetworkAccessManager_hookH = class(QObject_hookH) end;
QNetworkReply_hookH = class(QIODevice_hookH) end;

QCoreApplicationEventFilter = function(Msg:PChar;Res:PLong):boolean cdecl;
QAbstractEventDispatcherEventFilter = function(Msg:PChar):boolean cdecl;
QLCLItemDelegate_sizeHint_Override = procedure (option: QStyleOptionViewItemH; index: QModelIndexH; Size: PSize) of object cdecl;
QLCLItemDelegate_paint_Override = procedure (painter : QPainterH; option: QStyleOptionViewItemH; index: QModelIndexH) of object cdecl;
QLCLItemDelegate_createEditor_Override = procedure (parent : QWidgetH; option: QStyleOptionViewItemH; index: QModelIndexH; out editor: QWidgetH) of object cdecl; 
QLCLItemDelegate_setEditorData_Override = procedure (editor : QWidgetH; index: QModelIndexH) of object cdecl;
QLCLItemDelegate_setModelData_Override = procedure (editor : QWidgetH; model: QAbstractItemModelH; index: QModelIndexH) of object cdecl;
QLCLItemDelegate_updateEditorGeometry_Override = procedure (editor : QWidgetH; option: QStyleOptionViewItemH; index: QModelIndexH) of object cdecl;
QLCLItemDelegate_editorEvent_Override = procedure (event : QEventH; model: QAbstractItemModelH; option: QStyleOptionViewItemH; index: QModelIndexH; retval: PBoolean) of object cdecl;
QLCLAbstractScrollArea_viewportEvent_Override = procedure (event: QEventH; retval: PBoolean) of object cdecl;
QLCLThread_run_Override = procedure of object cdecl;

type
  QObjectEventFilter = function (Sender:QObjectH; Event: QEventH):boolean of object cdecl;
  QObject_destroyed_Event = procedure of object; cdecl;
  function QtPoint(X,Y:integer): TQtPoint;
  function QtPointF(X,Y:QReal): TQtPointF;
  function QObject_hook_Create(handle : QObjectH) : QObject_hookH; cdecl; external Qt5PasLib name 'QObject_hook_Create';
  procedure QObject_hook_Destroy(handle : QObject_hookH ); cdecl; external Qt5PasLib name 'QObject_hook_Destroy';
  procedure QObject_hook_hook_events(handle : QObject_hookH; hook : QObjectEventFilter); cdecl; external Qt5PasLib name 'QObject_hook_hook_events';
  procedure QObject_hook_hook_destroyed(handle : QObject_hookH; hook : QObject_destroyed_Event); cdecl; external Qt5PasLib name 'QObject_hook_hook_destroyed';

type
  QtGlobalColor = ( // Qt::GlobalColor (1)
    Qtcolor0, Qtcolor1, Qtblack, Qtwhite, QtdarkGray, Qtgray, QtlightGray, Qtred, Qtgreen, Qtblue, Qtcyan, Qtmagenta, Qtyellow, QtdarkRed, QtdarkGreen, QtdarkBlue, QtdarkCyan, QtdarkMagenta, 
    QtdarkYellow, Qttransparent );

  QtSortOrder = ( // Qt::SortOrder (1)
    QtAscendingOrder, QtDescendingOrder );

  QtTileRule = ( // Qt::TileRule (1)
    QtStretchTile, QtRepeatTile, QtRoundTile );

  QtTextElideMode = ( // Qt::TextElideMode (1)
    QtElideLeft, QtElideRight, QtElideMiddle, QtElideNone );

  QtHitTestAccuracy = ( // Qt::HitTestAccuracy (1)
    QtExactHit, QtFuzzyHit );

  QtBGMode = ( // Qt::BGMode (1)
    QtTransparentMode, QtOpaqueMode );

  QtArrowType = ( // Qt::ArrowType (1)
    QtNoArrow, QtUpArrow, QtDownArrow, QtLeftArrow, QtRightArrow );

  QtPenStyle = ( // Qt::PenStyle (1)
    QtNoPen, QtSolidLine, QtDashLine, QtDotLine, QtDashDotLine, QtDashDotDotLine, QtCustomDashLine );

  QtSizeMode = ( // Qt::SizeMode (1)
    QtAbsoluteSize, QtRelativeSize );

  QtUIEffect = ( // Qt::UIEffect (1)
    QtUI_General, QtUI_AnimateMenu, QtUI_FadeMenu, QtUI_AnimateCombo, QtUI_AnimateTooltip, QtUI_FadeTooltip, QtUI_AnimateToolBox );

  QtTextFormat = ( // Qt::TextFormat (1)
    QtPlainText, QtRichText, QtAutoText );

  QtAspectRatioMode = ( // Qt::AspectRatioMode (1)
    QtIgnoreAspectRatio, QtKeepAspectRatio, QtKeepAspectRatioByExpanding );

  QtTimeSpec = ( // Qt::TimeSpec (1)
    QtLocalTime, QtUTC, QtOffsetFromUTC );

  QtScrollBarPolicy = ( // Qt::ScrollBarPolicy (1)
    QtScrollBarAsNeeded, QtScrollBarAlwaysOff, QtScrollBarAlwaysOn );

  QtCaseSensitivity = ( // Qt::CaseSensitivity (1)
    QtCaseInsensitive, QtCaseSensitive );

  QtShortcutContext = ( // Qt::ShortcutContext (1)
    QtWidgetShortcut, QtWindowShortcut, QtApplicationShortcut, QtWidgetWithChildrenShortcut );

  QtFillRule = ( // Qt::FillRule (1)
    QtOddEvenFill, QtWindingFill );

  QtMaskMode = ( // Qt::MaskMode (1)
    QtMaskInColor, QtMaskOutColor );

  QtClipOperation = ( // Qt::ClipOperation (1)
    QtNoClip, QtReplaceClip, QtIntersectClip );

  QtTransformationMode = ( // Qt::TransformationMode (1)
    QtFastTransformation, QtSmoothTransformation );

  QtAxis = ( // Qt::Axis (1)
    QtXAxis, QtYAxis, QtZAxis );

  QtFocusReason = ( // Qt::FocusReason (1)
    QtMouseFocusReason, QtTabFocusReason, QtBacktabFocusReason, QtActiveWindowFocusReason, QtPopupFocusReason, QtShortcutFocusReason, QtMenuBarFocusReason, QtOtherFocusReason, QtNoFocusReason );

  QtContextMenuPolicy = ( // Qt::ContextMenuPolicy (1)
    QtNoContextMenu, QtDefaultContextMenu, QtActionsContextMenu, QtCustomContextMenu, QtPreventContextMenu );

  QtToolButtonStyle = ( // Qt::ToolButtonStyle (1)
    QtToolButtonIconOnly, QtToolButtonTextOnly, QtToolButtonTextBesideIcon, QtToolButtonTextUnderIcon, QtToolButtonFollowStyle );

  QtLayoutDirection = ( // Qt::LayoutDirection (1)
    QtLeftToRight, QtRightToLeft, QtLayoutDirectionAuto );

  QtCheckState = ( // Qt::CheckState (1)
    QtUnchecked, QtPartiallyChecked, QtChecked );

  QtWindowModality = ( // Qt::WindowModality (1)
    QtNonModal, QtWindowModal, QtApplicationModal );

  QtSizeHint = ( // Qt::SizeHint (1)
    QtMinimumSize, QtPreferredSize, QtMaximumSize, QtMinimumDescent, QtNSizeHints );

  QtWindowFrameSection = ( // Qt::WindowFrameSection (1)
    QtNoSection, QtLeftSection, QtTopLeftSection, QtTopSection, QtTopRightSection, QtRightSection, QtBottomRightSection, QtBottomSection, QtBottomLeftSection, QtTitleBarArea );

  QtInitialization = ( // Qt::Initialization (1)
    QtUninitialized );

  QtCoordinateSystem = ( // Qt::CoordinateSystem (1)
    QtDeviceCoordinates, QtLogicalCoordinates );

  QtNavigationMode = ( // Qt::NavigationMode (1)
    QtNavigationModeNone, QtNavigationModeKeypadTabOrder, QtNavigationModeKeypadDirectional, QtNavigationModeCursorAuto, QtNavigationModeCursorForceVisible );

  QtCursorMoveStyle = ( // Qt::CursorMoveStyle (1)
    QtLogicalMoveStyle, QtVisualMoveStyle );

  QtTimerType = ( // Qt::TimerType (1)
    QtPreciseTimer, QtCoarseTimer, QtVeryCoarseTimer );

type
  QtKeyboardModifier = cardinal; // Qt::KeyboardModifier
  QtKeyboardModifiers = QtKeyboardModifier; //QFlags<> (3)
const
  QtNoModifier =   $00000000;
  QtShiftModifier =   $02000000;
  QtControlModifier =   $04000000;
  QtAltModifier =   $08000000;
  QtMetaModifier =   $10000000;
  QtKeypadModifier =   $20000000;
  QtGroupSwitchModifier =   $40000000;
  QtKeyboardModifierMask =   $fe000000;

type
  QtOrientation = cardinal; // Qt::Orientation
  QtOrientations = QtOrientation; //QFlags<> (3)
const
  QtHorizontal =   $1;
  QtVertical =   $2;


type
  QtWhiteSpaceMode = (  //Qt::WhiteSpaceMode (2)
    QtWhiteSpaceModeUndefined = -1,
    QtWhiteSpaceNormal,
    QtWhiteSpacePre,
    QtWhiteSpaceNoWrap );

type
  QtWindowState = cardinal; // Qt::WindowState
  QtWindowStates = QtWindowState; //QFlags<> (3)
const
  QtWindowNoState =   $00000000;
  QtWindowMinimized =   $00000001;
  QtWindowMaximized =   $00000002;
  QtWindowFullScreen =   $00000004;
  QtWindowActive =   $00000008;

type
  QtApplicationState = cardinal; // Qt::ApplicationState
  QtApplicationStates = QtApplicationState; //QFlags<> (3)
const
  QtApplicationSuspended =   $00000000;
  QtApplicationHidden =   $00000001;
  QtApplicationInactive =   $00000002;
  QtApplicationActive =   $00000004;

type
  QtScreenOrientation = cardinal; // Qt::ScreenOrientation
  QtScreenOrientations = QtScreenOrientation; //QFlags<> (3)
const
  QtPrimaryOrientation =   $00000000;
  QtPortraitOrientation =   $00000001;
  QtLandscapeOrientation =   $00000002;
  QtInvertedPortraitOrientation =   $00000004;
  QtInvertedLandscapeOrientation =   $00000008;


type
  QtApplicationAttribute = (  //Qt::ApplicationAttribute (2)
    QtAA_ImmediateWidgetCreation = 0,
    QtAA_MSWindowsUseDirect3DByDefault = 1,
    QtAA_DontShowIconsInMenus = 2,
    QtAA_NativeWindows = 3,
    QtAA_DontCreateNativeWidgetSiblings = 4,
    QtAA_MacPluginApplication = 5,
    QtAA_DontUseNativeMenuBar = 6,
    QtAA_MacDontSwapCtrlAndMeta = 7,
    QtAA_Use96Dpi = 8,
    QtAA_X11InitThreads = 10,
    QtAA_SynthesizeTouchForUnhandledMouseEvents = 11,
    QtAA_SynthesizeMouseForUnhandledTouchEvents = 12,
    QtAA_UseHighDpiPixmaps = 13,
    QtAA_ForceRasterWidgets = 14,
    QtAA_UseDesktopOpenGL = 15,
    QtAA_UseOpenGLES = 16,
    QtAA_UseSoftwareOpenGL = 17,
    QtAA_ShareOpenGLContexts = 18,
    QtAA_SetPalette = 19,
    QtAA_EnableHighDpiScaling = 20,
    QtAA_DisableHighDpiScaling = 21,
    QtAA_AttributeCount );

type
  QtImageConversionFlag = cardinal; // Qt::ImageConversionFlag
  QtImageConversionFlags = QtImageConversionFlag; //QFlags<> (3)
const
  QtColorMode_Mask =   $00000003;
  QtAutoColor =   $00000000;
  QtColorOnly =   $00000003;
  QtMonoOnly =   $00000002;
  QtAlphaDither_Mask =   $0000000c;
  QtThresholdAlphaDither =   $00000000;
  QtOrderedAlphaDither =   $00000004;
  QtDiffuseAlphaDither =   $00000008;
  QtNoAlpha =   $0000000c;
  QtDither_Mask =   $00000030;
  QtDiffuseDither =   $00000000;
  QtOrderedDither =   $00000010;
  QtThresholdDither =   $00000020;
  QtDitherMode_Mask =   $000000c0;
  QtAutoDither =   $00000000;
  QtPreferDither =   $00000040;
  QtAvoidDither =   $00000080;
  QtNoOpaqueDetection =   $00000100;
  QtNoFormatConversion =   $00000200;


type
  QtPenCapStyle = (  //Qt::PenCapStyle (2)
    QtFlatCap = $00,
    QtSquareCap = $10,
    QtRoundCap = $20,
    QtMPenCapStyle = $30 );

  QtPenJoinStyle = (  //Qt::PenJoinStyle (2)
    QtMiterJoin = $00,
    QtBevelJoin = $40,
    QtRoundJoin = $80,
    QtSvgMiterJoin = $100,
    QtMPenJoinStyle = $1c0 );

  QtBrushStyle = (  //Qt::BrushStyle (2)
    QtNoBrush,
    QtSolidPattern,
    QtDense1Pattern,
    QtDense2Pattern,
    QtDense3Pattern,
    QtDense4Pattern,
    QtDense5Pattern,
    QtDense6Pattern,
    QtDense7Pattern,
    QtHorPattern,
    QtVerPattern,
    QtCrossPattern,
    QtBDiagPattern,
    QtFDiagPattern,
    QtDiagCrossPattern,
    QtLinearGradientPattern,
    QtRadialGradientPattern,
    QtConicalGradientPattern,
    QtTexturePattern = 24 );

  QtDockWidgetAreaSizes = (  //Qt::DockWidgetAreaSizes (2)
    QtNDockWidgetAreas = 4 );

  QtToolBarAreaSizes = (  //Qt::ToolBarAreaSizes (2)
    QtNToolBarAreas = 4 );

  QtDayOfWeek = (  //Qt::DayOfWeek (2)
    QtMonday = 1,
    QtTuesday = 2,
    QtWednesday = 3,
    QtThursday = 4,
    QtFriday = 5,
    QtSaturday = 6,
    QtSunday = 7 );

  QtCorner = (  //Qt::Corner (2)
    QtTopLeftCorner = $00000,
    QtTopRightCorner = $00001,
    QtBottomLeftCorner = $00002,
    QtBottomRightCorner = $00003 );

  QtEdge = (  //Qt::Edge (2)
    QtTopEdge = $00001,
    QtLeftEdge = $00002,
    QtRightEdge = $00004,
    QtBottomEdge = $00008 );

  QtConnectionType = (  //Qt::ConnectionType (2)
    QtAutoConnection,
    QtDirectConnection,
    QtQueuedConnection,
    QtBlockingQueuedConnection,
    QtUniqueConnection = $80 );

  QtItemSelectionMode = (  //Qt::ItemSelectionMode (2)
    QtContainsItemShape = $0,
    QtIntersectsItemShape = $1,
    QtContainsItemBoundingRect = $2,
    QtIntersectsItemBoundingRect = $3 );

type
  QtInputMethodHint = cardinal; // Qt::InputMethodHint
  QtInputMethodHints = QtInputMethodHint; //QFlags<> (3)
const
  QtImhNone =   $0;
  QtImhHiddenText =   $1;
  QtImhSensitiveData =   $2;
  QtImhNoAutoUppercase =   $4;
  QtImhPreferNumbers =   $8;
  QtImhPreferUppercase =   $10;
  QtImhPreferLowercase =   $20;
  QtImhNoPredictiveText =   $40;
  QtImhDate =   $80;
  QtImhTime =   $100;
  QtImhPreferLatin =   $200;
  QtImhMultiLine =   $400;
  QtImhDigitsOnly =   $10000;
  QtImhFormattedNumbersOnly =   $20000;
  QtImhUppercaseOnly =   $40000;
  QtImhLowercaseOnly =   $80000;
  QtImhDialableCharactersOnly =   $100000;
  QtImhEmailCharactersOnly =   $200000;
  QtImhUrlCharactersOnly =   $400000;
  QtImhLatinOnly =   $800000;
  QtImhExclusiveInputMask =   $ffff0000;


type
  QtAnchorPoint = (  //Qt::AnchorPoint (2)
    QtAnchorLeft = 0,
    QtAnchorHorizontalCenter,
    QtAnchorRight,
    QtAnchorTop,
    QtAnchorVerticalCenter,
    QtAnchorBottom );

type
  QtFindChildOption = cardinal; // Qt::FindChildOption
  QtFindChildOptions = QtFindChildOption; //QFlags<> (3)
const
  QtFindDirectChildrenOnly =   $0;
  QtFindChildrenRecursively =   $1;

type
  QtDropAction = cardinal; // Qt::DropAction
  QtDropActions = QtDropAction; //QFlags<> (3)
const
  QtCopyAction =   $1;
  QtMoveAction =   $2;
  QtLinkAction =   $4;
  QtActionMask =   $ff;
  QtTargetMoveAction =   $8002;
  QtIgnoreAction =   $0;


type
  QtItemDataRole = (  //Qt::ItemDataRole (2)
    QtDisplayRole = 0,
    QtDecorationRole = 1,
    QtEditRole = 2,
    QtToolTipRole = 3,
    QtStatusTipRole = 4,
    QtWhatsThisRole = 5,
    QtFontRole = 6,
    QtTextAlignmentRole = 7,
    QtBackgroundColorRole = 8,
//  QtBackgroundRole = 8 {duplicate},
    QtForegroundRole = 9,
//  QtTextColorRole = 9 {duplicate},
    QtCheckStateRole = 10,
    QtAccessibleTextRole = 11,
    QtAccessibleDescriptionRole = 12,
    QtSizeHintRole = 13,
    QtInitialSortOrderRole = 14,
    QtDisplayPropertyRole = 27,
    QtDecorationPropertyRole = 28,
    QtToolTipPropertyRole = 29,
    QtStatusTipPropertyRole = 30,
    QtWhatsThisPropertyRole = 31,
    QtUserRole = $0100 );

type
  QtItemFlag = cardinal; // Qt::ItemFlag
  QtItemFlags = QtItemFlag; //QFlags<> (3)
const
  QtNoItemFlags =   0;
  QtItemIsSelectable =   1;
  QtItemIsEditable =   2;
  QtItemIsDragEnabled =   4;
  QtItemIsDropEnabled =   8;
  QtItemIsUserCheckable =   16;
  QtItemIsEnabled =   32;
  QtItemIsTristate =   64;
  QtItemNeverHasChildren =   128;

type
  QtMatchFlag = cardinal; // Qt::MatchFlag
  QtMatchFlags = QtMatchFlag; //QFlags<> (3)
const
  QtMatchExactly =   0;
  QtMatchContains =   1;
  QtMatchStartsWith =   2;
  QtMatchEndsWith =   3;
  QtMatchRegExp =   4;
  QtMatchWildcard =   5;
  QtMatchFixedString =   8;
  QtMatchCaseSensitive =   16;
  QtMatchWrap =   32;
  QtMatchRecursive =   64;


type
  QtEventPriority = (  //Qt::EventPriority (2)
    QtLowEventPriority = -1,
    QtNormalEventPriority = 0,
    QtHighEventPriority = 1 );

type
  QtTouchPointState = cardinal; // Qt::TouchPointState
  QtTouchPointStates = QtTouchPointState; //QFlags<> (3)
const
  QtTouchPointPressed =   $01;
  QtTouchPointMoved =   $02;
  QtTouchPointStationary =   $04;
  QtTouchPointReleased =   $08;


type
  QtGestureState = (  //Qt::GestureState (2)
    QtNoGesture,
    QtGestureStarted = 1,
    QtGestureUpdated = 2,
    QtGestureFinished = 3,
    QtGestureCanceled = 4 );

type
  QtGestureFlag = cardinal; // Qt::GestureFlag
  QtGestureFlags = QtGestureFlag; //QFlags<> (3)
const
  QtDontStartGestureOnChildren =   $01;
  QtReceivePartialGestures =   $02;
  QtIgnoredGesturesPropagateToParent =   $04;


type
  QInternalRelayoutType = ( // QInternal::RelayoutType (1)
    QInternalRelayoutNormal, QInternalRelayoutDragging, QInternalRelayoutDropped );

  QInternalDockPosition = ( // QInternal::DockPosition (1)
    QInternalLeftDock, QInternalRightDock, QInternalTopDock, QInternalBottomDock, QInternalDockCount );

  QInternalCallback = ( // QInternal::Callback (1)
    QInternalEventNotifyCallback, QInternalLastCallback );

  QInternalPaintDeviceFlags = (  //QInternal::PaintDeviceFlags (2)
    QInternalUnknownDevice = $00,
    QInternalWidget = $01,
    QInternalPixmap = $02,
    QInternalImage = $03,
    QInternalPrinter = $04,
    QInternalPicture = $05,
    QInternalPbuffer = $06,
    QInternalFramebufferObject = $07,
    QInternalCustomRaster = $08,
    QInternalMacQuartz = $09,
    QInternalPaintBuffer = $0a,
    QInternalOpenGL = $0b );

type
  QtModifier = cardinal; //  Qt::Modifier (4)

const
    QtMETA = 268435456 { $10000000 };
    QtSHIFT = 33554432 { $2000000 };
    QtCTRL = 67108864 { $4000000 };
    QtALT = 134217728 { $8000000 };
    QtMODIFIER_MASK = 4261412864 { $fe000000 };
    QtUNICODE_ACCEL = 0 { $0 };

type
  QtMouseButton = cardinal; //  Qt::MouseButton (4)
  QtMouseButtons = QtMouseButton; // QFlags<>

const
    QtNoButton = 0 { $0 };
    QtLeftButton = 1 { $1 };
    QtRightButton = 2 { $2 };
    QtMidButton = 4 { $4 };
    QtMiddleButton = 4 { $4 };
    QtBackButton = 8 { $8 };
    QtXButton1 = 8 { $8 };
    QtExtraButton1 = 8 { $8 };
    QtForwardButton = 16 { $10 };
    QtXButton2 = 16 { $10 };
    QtExtraButton2 = 16 { $10 };
    QtTaskButton = 32 { $20 };
    QtExtraButton3 = 32 { $20 };
    QtExtraButton4 = 64 { $40 };
    QtExtraButton5 = 128 { $80 };
    QtExtraButton6 = 256 { $100 };
    QtExtraButton7 = 512 { $200 };
    QtExtraButton8 = 1024 { $400 };
    QtExtraButton9 = 2048 { $800 };
    QtExtraButton10 = 4096 { $1000 };
    QtExtraButton11 = 8192 { $2000 };
    QtExtraButton12 = 16384 { $4000 };
    QtExtraButton13 = 32768 { $8000 };
    QtExtraButton14 = 65536 { $10000 };
    QtExtraButton15 = 131072 { $20000 };
    QtExtraButton16 = 262144 { $40000 };
    QtExtraButton17 = 524288 { $80000 };
    QtExtraButton18 = 1048576 { $100000 };
    QtExtraButton19 = 2097152 { $200000 };
    QtExtraButton20 = 4194304 { $400000 };
    QtExtraButton21 = 8388608 { $800000 };
    QtExtraButton22 = 16777216 { $1000000 };
    QtExtraButton23 = 33554432 { $2000000 };
    QtExtraButton24 = 67108864 { $4000000 };
    QtAllButtons = 134217727 { $7ffffff };
    QtMaxMouseButton = 67108864 { $4000000 };
    QtMouseButtonMask = 4294967295 { $ffffffff };

type
  QtFocusPolicy = cardinal; //  Qt::FocusPolicy (4)

const
    QtNoFocus = 0 { $0 };
    QtTabFocus = 1 { $1 };
    QtClickFocus = 2 { $2 };
    QtStrongFocus = 11 { $b };
    QtWheelFocus = 15 { $f };

type
  QtAlignmentFlag = cardinal; //  Qt::AlignmentFlag (4)
  QtAlignment = QtAlignmentFlag; // QFlags<>

const
    QtAlignLeft = 1 { $1 };
    QtAlignLeading = 1 { $1 };
    QtAlignRight = 2 { $2 };
    QtAlignTrailing = 2 { $2 };
    QtAlignHCenter = 4 { $4 };
    QtAlignJustify = 8 { $8 };
    QtAlignAbsolute = 16 { $10 };
    QtAlignHorizontal_Mask = 31 { $1f };
    QtAlignTop = 32 { $20 };
    QtAlignBottom = 64 { $40 };
    QtAlignVCenter = 128 { $80 };
    QtAlignVertical_Mask = 224 { $e0 };
    QtAlignCenter = 132 { $84 };

type
  QtWindowType = cardinal; //  Qt::WindowType (4)
  QtWindowFlags = QtWindowType; // QFlags<>

const
    QtWidget = 0 { $0 };
    QtWindow = 1 { $1 };
    QtDialog = 3 { $3 };
    QtSheet = 5 { $5 };
    QtDrawer = 7 { $7 };
    QtPopup = 9 { $9 };
    QtTool = 11 { $b };
    QtToolTip = 13 { $d };
    QtSplashScreen = 15 { $f };
    QtDesktop = 17 { $11 };
    QtSubWindow = 18 { $12 };
    QtForeignWindow = 33 { $21 };
    QtWindowType_Mask = 255 { $ff };
    QtMSWindowsFixedSizeDialogHint = 256 { $100 };
    QtMSWindowsOwnDC = 512 { $200 };
    QtBypassWindowManagerHint = 1024 { $400 };
    QtX11BypassWindowManagerHint = 1024 { $400 };
    QtFramelessWindowHint = 2048 { $800 };
    QtWindowTitleHint = 4096 { $1000 };
    QtWindowSystemMenuHint = 8192 { $2000 };
    QtWindowMinimizeButtonHint = 16384 { $4000 };
    QtWindowMaximizeButtonHint = 32768 { $8000 };
    QtWindowMinMaxButtonsHint = 49152 { $c000 };
    QtWindowContextHelpButtonHint = 65536 { $10000 };
    QtWindowShadeButtonHint = 131072 { $20000 };
    QtWindowStaysOnTopHint = 262144 { $40000 };
    QtWindowTransparentForInput = 524288 { $80000 };
    QtWindowOverridesSystemGestures = 1048576 { $100000 };
    QtWindowDoesNotAcceptFocus = 2097152 { $200000 };
    QtCustomizeWindowHint = 33554432 { $2000000 };
    QtWindowStaysOnBottomHint = 67108864 { $4000000 };
    QtWindowCloseButtonHint = 134217728 { $8000000 };
    QtMacWindowToolBarButtonHint = 268435456 { $10000000 };
    QtBypassGraphicsProxyWidget = 536870912 { $20000000 };
    QtWindowOkButtonHint = 524288 { $80000 };
    QtWindowCancelButtonHint = 1048576 { $100000 };
    QtNoDropShadowWindowHint = 1073741824 { $40000000 };
    QtWindowFullscreenButtonHint = 2147483648 { $80000000 };

type
  QtWidgetAttribute = cardinal; //  Qt::WidgetAttribute (4)

const
    QtWA_Disabled = 0 { $0 };
    QtWA_UnderMouse = 1 { $1 };
    QtWA_MouseTracking = 2 { $2 };
    QtWA_ContentsPropagated = 3 { $3 };
    QtWA_OpaquePaintEvent = 4 { $4 };
    QtWA_NoBackground = 4 { $4 };
    QtWA_StaticContents = 5 { $5 };
    QtWA_LaidOut = 7 { $7 };
    QtWA_PaintOnScreen = 8 { $8 };
    QtWA_NoSystemBackground = 9 { $9 };
    QtWA_UpdatesDisabled = 10 { $a };
    QtWA_Mapped = 11 { $b };
    QtWA_MacNoClickThrough = 12 { $c };
    QtWA_InputMethodEnabled = 14 { $e };
    QtWA_WState_Visible = 15 { $f };
    QtWA_WState_Hidden = 16 { $10 };
    QtWA_ForceDisabled = 32 { $20 };
    QtWA_KeyCompression = 33 { $21 };
    QtWA_PendingMoveEvent = 34 { $22 };
    QtWA_PendingResizeEvent = 35 { $23 };
    QtWA_SetPalette = 36 { $24 };
    QtWA_SetFont = 37 { $25 };
    QtWA_SetCursor = 38 { $26 };
    QtWA_NoChildEventsFromChildren = 39 { $27 };
    QtWA_WindowModified = 41 { $29 };
    QtWA_Resized = 42 { $2a };
    QtWA_Moved = 43 { $2b };
    QtWA_PendingUpdate = 44 { $2c };
    QtWA_InvalidSize = 45 { $2d };
    QtWA_MacBrushedMetal = 46 { $2e };
    QtWA_MacMetalStyle = 46 { $2e };
    QtWA_CustomWhatsThis = 47 { $2f };
    QtWA_LayoutOnEntireRect = 48 { $30 };
    QtWA_OutsideWSRange = 49 { $31 };
    QtWA_GrabbedShortcut = 50 { $32 };
    QtWA_TransparentForMouseEvents = 51 { $33 };
    QtWA_PaintUnclipped = 52 { $34 };
    QtWA_SetWindowIcon = 53 { $35 };
    QtWA_NoMouseReplay = 54 { $36 };
    QtWA_DeleteOnClose = 55 { $37 };
    QtWA_RightToLeft = 56 { $38 };
    QtWA_SetLayoutDirection = 57 { $39 };
    QtWA_NoChildEventsForParent = 58 { $3a };
    QtWA_ForceUpdatesDisabled = 59 { $3b };
    QtWA_WState_Created = 60 { $3c };
    QtWA_WState_CompressKeys = 61 { $3d };
    QtWA_WState_InPaintEvent = 62 { $3e };
    QtWA_WState_Reparented = 63 { $3f };
    QtWA_WState_ConfigPending = 64 { $40 };
    QtWA_WState_Polished = 66 { $42 };
    QtWA_WState_DND = 67 { $43 };
    QtWA_WState_OwnSizePolicy = 68 { $44 };
    QtWA_WState_ExplicitShowHide = 69 { $45 };
    QtWA_ShowModal = 70 { $46 };
    QtWA_MouseNoMask = 71 { $47 };
    QtWA_GroupLeader = 72 { $48 };
    QtWA_NoMousePropagation = 73 { $49 };
    QtWA_Hover = 74 { $4a };
    QtWA_InputMethodTransparent = 75 { $4b };
    QtWA_QuitOnClose = 76 { $4c };
    QtWA_KeyboardFocusChange = 77 { $4d };
    QtWA_AcceptDrops = 78 { $4e };
    QtWA_DropSiteRegistered = 79 { $4f };
    QtWA_ForceAcceptDrops = 79 { $4f };
    QtWA_WindowPropagation = 80 { $50 };
    QtWA_NoX11EventCompression = 81 { $51 };
    QtWA_TintedBackground = 82 { $52 };
    QtWA_X11OpenGLOverlay = 83 { $53 };
    QtWA_AlwaysShowToolTips = 84 { $54 };
    QtWA_MacOpaqueSizeGrip = 85 { $55 };
    QtWA_SetStyle = 86 { $56 };
    QtWA_SetLocale = 87 { $57 };
    QtWA_MacShowFocusRect = 88 { $58 };
    QtWA_MacNormalSize = 89 { $59 };
    QtWA_MacSmallSize = 90 { $5a };
    QtWA_MacMiniSize = 91 { $5b };
    QtWA_LayoutUsesWidgetRect = 92 { $5c };
    QtWA_StyledBackground = 93 { $5d };
    QtWA_MSWindowsUseDirect3D = 94 { $5e };
    QtWA_CanHostQMdiSubWindowTitleBar = 95 { $5f };
    QtWA_MacAlwaysShowToolWindow = 96 { $60 };
    QtWA_StyleSheet = 97 { $61 };
    QtWA_ShowWithoutActivating = 98 { $62 };
    QtWA_X11BypassTransientForHint = 99 { $63 };
    QtWA_NativeWindow = 100 { $64 };
    QtWA_DontCreateNativeAncestors = 101 { $65 };
    QtWA_MacVariableSize = 102 { $66 };
    QtWA_DontShowOnScreen = 103 { $67 };
    QtWA_X11NetWmWindowTypeDesktop = 104 { $68 };
    QtWA_X11NetWmWindowTypeDock = 105 { $69 };
    QtWA_X11NetWmWindowTypeToolBar = 106 { $6a };
    QtWA_X11NetWmWindowTypeMenu = 107 { $6b };
    QtWA_X11NetWmWindowTypeUtility = 108 { $6c };
    QtWA_X11NetWmWindowTypeSplash = 109 { $6d };
    QtWA_X11NetWmWindowTypeDialog = 110 { $6e };
    QtWA_X11NetWmWindowTypeDropDownMenu = 111 { $6f };
    QtWA_X11NetWmWindowTypePopupMenu = 112 { $70 };
    QtWA_X11NetWmWindowTypeToolTip = 113 { $71 };
    QtWA_X11NetWmWindowTypeNotification = 114 { $72 };
    QtWA_X11NetWmWindowTypeCombo = 115 { $73 };
    QtWA_X11NetWmWindowTypeDND = 116 { $74 };
    QtWA_MacFrameworkScaled = 117 { $75 };
    QtWA_SetWindowModality = 118 { $76 };
    QtWA_WState_WindowOpacitySet = 119 { $77 };
    QtWA_TranslucentBackground = 120 { $78 };
    QtWA_AcceptTouchEvents = 121 { $79 };
    QtWA_WState_AcceptedTouchBeginEvent = 122 { $7a };
    QtWA_TouchPadAcceptSingleTouchEvents = 123 { $7b };
    QtWA_X11DoNotAcceptFocus = 126 { $7e };
    QtWA_MacNoShadow = 127 { $7f };
    QtWA_AttributeCount = 128 { $80 };

type
  QtKey = cardinal; //  Qt::Key (4)

const
    QtKey_Escape = 16777216 { $1000000 };
    QtKey_Tab = 16777217 { $1000001 };
    QtKey_Backtab = 16777218 { $1000002 };
    QtKey_Backspace = 16777219 { $1000003 };
    QtKey_Return = 16777220 { $1000004 };
    QtKey_Enter = 16777221 { $1000005 };
    QtKey_Insert = 16777222 { $1000006 };
    QtKey_Delete = 16777223 { $1000007 };
    QtKey_Pause = 16777224 { $1000008 };
    QtKey_Print = 16777225 { $1000009 };
    QtKey_SysReq = 16777226 { $100000a };
    QtKey_Clear = 16777227 { $100000b };
    QtKey_Home = 16777232 { $1000010 };
    QtKey_End = 16777233 { $1000011 };
    QtKey_Left = 16777234 { $1000012 };
    QtKey_Up = 16777235 { $1000013 };
    QtKey_Right = 16777236 { $1000014 };
    QtKey_Down = 16777237 { $1000015 };
    QtKey_PageUp = 16777238 { $1000016 };
    QtKey_PageDown = 16777239 { $1000017 };
    QtKey_Shift = 16777248 { $1000020 };
    QtKey_Control = 16777249 { $1000021 };
    QtKey_Meta = 16777250 { $1000022 };
    QtKey_Alt = 16777251 { $1000023 };
    QtKey_CapsLock = 16777252 { $1000024 };
    QtKey_NumLock = 16777253 { $1000025 };
    QtKey_ScrollLock = 16777254 { $1000026 };
    QtKey_F1 = 16777264 { $1000030 };
    QtKey_F2 = 16777265 { $1000031 };
    QtKey_F3 = 16777266 { $1000032 };
    QtKey_F4 = 16777267 { $1000033 };
    QtKey_F5 = 16777268 { $1000034 };
    QtKey_F6 = 16777269 { $1000035 };
    QtKey_F7 = 16777270 { $1000036 };
    QtKey_F8 = 16777271 { $1000037 };
    QtKey_F9 = 16777272 { $1000038 };
    QtKey_F10 = 16777273 { $1000039 };
    QtKey_F11 = 16777274 { $100003a };
    QtKey_F12 = 16777275 { $100003b };
    QtKey_F13 = 16777276 { $100003c };
    QtKey_F14 = 16777277 { $100003d };
    QtKey_F15 = 16777278 { $100003e };
    QtKey_F16 = 16777279 { $100003f };
    QtKey_F17 = 16777280 { $1000040 };
    QtKey_F18 = 16777281 { $1000041 };
    QtKey_F19 = 16777282 { $1000042 };
    QtKey_F20 = 16777283 { $1000043 };
    QtKey_F21 = 16777284 { $1000044 };
    QtKey_F22 = 16777285 { $1000045 };
    QtKey_F23 = 16777286 { $1000046 };
    QtKey_F24 = 16777287 { $1000047 };
    QtKey_F25 = 16777288 { $1000048 };
    QtKey_F26 = 16777289 { $1000049 };
    QtKey_F27 = 16777290 { $100004a };
    QtKey_F28 = 16777291 { $100004b };
    QtKey_F29 = 16777292 { $100004c };
    QtKey_F30 = 16777293 { $100004d };
    QtKey_F31 = 16777294 { $100004e };
    QtKey_F32 = 16777295 { $100004f };
    QtKey_F33 = 16777296 { $1000050 };
    QtKey_F34 = 16777297 { $1000051 };
    QtKey_F35 = 16777298 { $1000052 };
    QtKey_Super_L = 16777299 { $1000053 };
    QtKey_Super_R = 16777300 { $1000054 };
    QtKey_Menu = 16777301 { $1000055 };
    QtKey_Hyper_L = 16777302 { $1000056 };
    QtKey_Hyper_R = 16777303 { $1000057 };
    QtKey_Help = 16777304 { $1000058 };
    QtKey_Direction_L = 16777305 { $1000059 };
    QtKey_Direction_R = 16777312 { $1000060 };
    QtKey_Space = 32 { $20 };
    QtKey_Any = 32 { $20 };
    QtKey_Exclam = 33 { $21 };
    QtKey_QuoteDbl = 34 { $22 };
    QtKey_NumberSign = 35 { $23 };
    QtKey_Dollar = 36 { $24 };
    QtKey_Percent = 37 { $25 };
    QtKey_Ampersand = 38 { $26 };
    QtKey_Apostrophe = 39 { $27 };
    QtKey_ParenLeft = 40 { $28 };
    QtKey_ParenRight = 41 { $29 };
    QtKey_Asterisk = 42 { $2a };
    QtKey_Plus = 43 { $2b };
    QtKey_Comma = 44 { $2c };
    QtKey_Minus = 45 { $2d };
    QtKey_Period = 46 { $2e };
    QtKey_Slash = 47 { $2f };
    QtKey_0 = 48 { $30 };
    QtKey_1 = 49 { $31 };
    QtKey_2 = 50 { $32 };
    QtKey_3 = 51 { $33 };
    QtKey_4 = 52 { $34 };
    QtKey_5 = 53 { $35 };
    QtKey_6 = 54 { $36 };
    QtKey_7 = 55 { $37 };
    QtKey_8 = 56 { $38 };
    QtKey_9 = 57 { $39 };
    QtKey_Colon = 58 { $3a };
    QtKey_Semicolon = 59 { $3b };
    QtKey_Less = 60 { $3c };
    QtKey_Equal = 61 { $3d };
    QtKey_Greater = 62 { $3e };
    QtKey_Question = 63 { $3f };
    QtKey_At = 64 { $40 };
    QtKey_A = 65 { $41 };
    QtKey_B = 66 { $42 };
    QtKey_C = 67 { $43 };
    QtKey_D = 68 { $44 };
    QtKey_E = 69 { $45 };
    QtKey_F = 70 { $46 };
    QtKey_G = 71 { $47 };
    QtKey_H = 72 { $48 };
    QtKey_I = 73 { $49 };
    QtKey_J = 74 { $4a };
    QtKey_K = 75 { $4b };
    QtKey_L = 76 { $4c };
    QtKey_M = 77 { $4d };
    QtKey_N = 78 { $4e };
    QtKey_O = 79 { $4f };
    QtKey_P = 80 { $50 };
    QtKey_Q = 81 { $51 };
    QtKey_R = 82 { $52 };
    QtKey_S = 83 { $53 };
    QtKey_T = 84 { $54 };
    QtKey_U = 85 { $55 };
    QtKey_V = 86 { $56 };
    QtKey_W = 87 { $57 };
    QtKey_X = 88 { $58 };
    QtKey_Y = 89 { $59 };
    QtKey_Z = 90 { $5a };
    QtKey_BracketLeft = 91 { $5b };
    QtKey_Backslash = 92 { $5c };
    QtKey_BracketRight = 93 { $5d };
    QtKey_AsciiCircum = 94 { $5e };
    QtKey_Underscore = 95 { $5f };
    QtKey_QuoteLeft = 96 { $60 };
    QtKey_BraceLeft = 123 { $7b };
    QtKey_Bar = 124 { $7c };
    QtKey_BraceRight = 125 { $7d };
    QtKey_AsciiTilde = 126 { $7e };
    QtKey_nobreakspace = 160 { $a0 };
    QtKey_exclamdown = 161 { $a1 };
    QtKey_cent = 162 { $a2 };
    QtKey_sterling = 163 { $a3 };
    QtKey_currency = 164 { $a4 };
    QtKey_yen = 165 { $a5 };
    QtKey_brokenbar = 166 { $a6 };
    QtKey_section = 167 { $a7 };
    QtKey_diaeresis = 168 { $a8 };
    QtKey_copyright = 169 { $a9 };
    QtKey_ordfeminine = 170 { $aa };
    QtKey_guillemotleft = 171 { $ab };
    QtKey_notsign = 172 { $ac };
    QtKey_hyphen = 173 { $ad };
    QtKey_registered = 174 { $ae };
    QtKey_macron = 175 { $af };
    QtKey_degree = 176 { $b0 };
    QtKey_plusminus = 177 { $b1 };
    QtKey_twosuperior = 178 { $b2 };
    QtKey_threesuperior = 179 { $b3 };
    QtKey_acute = 180 { $b4 };
    QtKey_mu = 181 { $b5 };
    QtKey_paragraph = 182 { $b6 };
    QtKey_periodcentered = 183 { $b7 };
    QtKey_cedilla = 184 { $b8 };
    QtKey_onesuperior = 185 { $b9 };
    QtKey_masculine = 186 { $ba };
    QtKey_guillemotright = 187 { $bb };
    QtKey_onequarter = 188 { $bc };
    QtKey_onehalf = 189 { $bd };
    QtKey_threequarters = 190 { $be };
    QtKey_questiondown = 191 { $bf };
    QtKey_Agrave = 192 { $c0 };
    QtKey_Aacute = 193 { $c1 };
    QtKey_Acircumflex = 194 { $c2 };
    QtKey_Atilde = 195 { $c3 };
    QtKey_Adiaeresis = 196 { $c4 };
    QtKey_Aring = 197 { $c5 };
    QtKey_AE = 198 { $c6 };
    QtKey_Ccedilla = 199 { $c7 };
    QtKey_Egrave = 200 { $c8 };
    QtKey_Eacute = 201 { $c9 };
    QtKey_Ecircumflex = 202 { $ca };
    QtKey_Ediaeresis = 203 { $cb };
    QtKey_Igrave = 204 { $cc };
    QtKey_Iacute = 205 { $cd };
    QtKey_Icircumflex = 206 { $ce };
    QtKey_Idiaeresis = 207 { $cf };
    QtKey_ETH = 208 { $d0 };
    QtKey_Ntilde = 209 { $d1 };
    QtKey_Ograve = 210 { $d2 };
    QtKey_Oacute = 211 { $d3 };
    QtKey_Ocircumflex = 212 { $d4 };
    QtKey_Otilde = 213 { $d5 };
    QtKey_Odiaeresis = 214 { $d6 };
    QtKey_multiply = 215 { $d7 };
    QtKey_Ooblique = 216 { $d8 };
    QtKey_Ugrave = 217 { $d9 };
    QtKey_Uacute = 218 { $da };
    QtKey_Ucircumflex = 219 { $db };
    QtKey_Udiaeresis = 220 { $dc };
    QtKey_Yacute = 221 { $dd };
    QtKey_THORN = 222 { $de };
    QtKey_ssharp = 223 { $df };
    QtKey_division = 247 { $f7 };
    QtKey_ydiaeresis = 255 { $ff };
    QtKey_AltGr = 16781571 { $1001103 };
    QtKey_Multi_key = 16781600 { $1001120 };
    QtKey_Codeinput = 16781623 { $1001137 };
    QtKey_SingleCandidate = 16781628 { $100113c };
    QtKey_MultipleCandidate = 16781629 { $100113d };
    QtKey_PreviousCandidate = 16781630 { $100113e };
    QtKey_Mode_switch = 16781694 { $100117e };
    QtKey_Kanji = 16781601 { $1001121 };
    QtKey_Muhenkan = 16781602 { $1001122 };
    QtKey_Henkan = 16781603 { $1001123 };
    QtKey_Romaji = 16781604 { $1001124 };
    QtKey_Hiragana = 16781605 { $1001125 };
    QtKey_Katakana = 16781606 { $1001126 };
    QtKey_Hiragana_Katakana = 16781607 { $1001127 };
    QtKey_Zenkaku = 16781608 { $1001128 };
    QtKey_Hankaku = 16781609 { $1001129 };
    QtKey_Zenkaku_Hankaku = 16781610 { $100112a };
    QtKey_Touroku = 16781611 { $100112b };
    QtKey_Massyo = 16781612 { $100112c };
    QtKey_Kana_Lock = 16781613 { $100112d };
    QtKey_Kana_Shift = 16781614 { $100112e };
    QtKey_Eisu_Shift = 16781615 { $100112f };
    QtKey_Eisu_toggle = 16781616 { $1001130 };
    QtKey_Hangul = 16781617 { $1001131 };
    QtKey_Hangul_Start = 16781618 { $1001132 };
    QtKey_Hangul_End = 16781619 { $1001133 };
    QtKey_Hangul_Hanja = 16781620 { $1001134 };
    QtKey_Hangul_Jamo = 16781621 { $1001135 };
    QtKey_Hangul_Romaja = 16781622 { $1001136 };
    QtKey_Hangul_Jeonja = 16781624 { $1001138 };
    QtKey_Hangul_Banja = 16781625 { $1001139 };
    QtKey_Hangul_PreHanja = 16781626 { $100113a };
    QtKey_Hangul_PostHanja = 16781627 { $100113b };
    QtKey_Hangul_Special = 16781631 { $100113f };
    QtKey_Dead_Grave = 16781904 { $1001250 };
    QtKey_Dead_Acute = 16781905 { $1001251 };
    QtKey_Dead_Circumflex = 16781906 { $1001252 };
    QtKey_Dead_Tilde = 16781907 { $1001253 };
    QtKey_Dead_Macron = 16781908 { $1001254 };
    QtKey_Dead_Breve = 16781909 { $1001255 };
    QtKey_Dead_Abovedot = 16781910 { $1001256 };
    QtKey_Dead_Diaeresis = 16781911 { $1001257 };
    QtKey_Dead_Abovering = 16781912 { $1001258 };
    QtKey_Dead_Doubleacute = 16781913 { $1001259 };
    QtKey_Dead_Caron = 16781914 { $100125a };
    QtKey_Dead_Cedilla = 16781915 { $100125b };
    QtKey_Dead_Ogonek = 16781916 { $100125c };
    QtKey_Dead_Iota = 16781917 { $100125d };
    QtKey_Dead_Voiced_Sound = 16781918 { $100125e };
    QtKey_Dead_Semivoiced_Sound = 16781919 { $100125f };
    QtKey_Dead_Belowdot = 16781920 { $1001260 };
    QtKey_Dead_Hook = 16781921 { $1001261 };
    QtKey_Dead_Horn = 16781922 { $1001262 };
    QtKey_Back = 16777313 { $1000061 };
    QtKey_Forward = 16777314 { $1000062 };
    QtKey_Stop = 16777315 { $1000063 };
    QtKey_Refresh = 16777316 { $1000064 };
    QtKey_VolumeDown = 16777328 { $1000070 };
    QtKey_VolumeMute = 16777329 { $1000071 };
    QtKey_VolumeUp = 16777330 { $1000072 };
    QtKey_BassBoost = 16777331 { $1000073 };
    QtKey_BassUp = 16777332 { $1000074 };
    QtKey_BassDown = 16777333 { $1000075 };
    QtKey_TrebleUp = 16777334 { $1000076 };
    QtKey_TrebleDown = 16777335 { $1000077 };
    QtKey_MediaPlay = 16777344 { $1000080 };
    QtKey_MediaStop = 16777345 { $1000081 };
    QtKey_MediaPrevious = 16777346 { $1000082 };
    QtKey_MediaNext = 16777347 { $1000083 };
    QtKey_MediaRecord = 16777348 { $1000084 };
    QtKey_MediaPause = 16777349 { $1000085 };
    QtKey_MediaTogglePlayPause = 16777350 { $1000086 };
    QtKey_HomePage = 16777360 { $1000090 };
    QtKey_Favorites = 16777361 { $1000091 };
    QtKey_Search = 16777362 { $1000092 };
    QtKey_Standby = 16777363 { $1000093 };
    QtKey_OpenUrl = 16777364 { $1000094 };
    QtKey_LaunchMail = 16777376 { $10000a0 };
    QtKey_LaunchMedia = 16777377 { $10000a1 };
    QtKey_Launch0 = 16777378 { $10000a2 };
    QtKey_Launch1 = 16777379 { $10000a3 };
    QtKey_Launch2 = 16777380 { $10000a4 };
    QtKey_Launch3 = 16777381 { $10000a5 };
    QtKey_Launch4 = 16777382 { $10000a6 };
    QtKey_Launch5 = 16777383 { $10000a7 };
    QtKey_Launch6 = 16777384 { $10000a8 };
    QtKey_Launch7 = 16777385 { $10000a9 };
    QtKey_Launch8 = 16777386 { $10000aa };
    QtKey_Launch9 = 16777387 { $10000ab };
    QtKey_LaunchA = 16777388 { $10000ac };
    QtKey_LaunchB = 16777389 { $10000ad };
    QtKey_LaunchC = 16777390 { $10000ae };
    QtKey_LaunchD = 16777391 { $10000af };
    QtKey_LaunchE = 16777392 { $10000b0 };
    QtKey_LaunchF = 16777393 { $10000b1 };
    QtKey_MonBrightnessUp = 16777394 { $10000b2 };
    QtKey_MonBrightnessDown = 16777395 { $10000b3 };
    QtKey_KeyboardLightOnOff = 16777396 { $10000b4 };
    QtKey_KeyboardBrightnessUp = 16777397 { $10000b5 };
    QtKey_KeyboardBrightnessDown = 16777398 { $10000b6 };
    QtKey_PowerOff = 16777399 { $10000b7 };
    QtKey_WakeUp = 16777400 { $10000b8 };
    QtKey_Eject = 16777401 { $10000b9 };
    QtKey_ScreenSaver = 16777402 { $10000ba };
    QtKey_WWW = 16777403 { $10000bb };
    QtKey_Memo = 16777404 { $10000bc };
    QtKey_LightBulb = 16777405 { $10000bd };
    QtKey_Shop = 16777406 { $10000be };
    QtKey_History = 16777407 { $10000bf };
    QtKey_AddFavorite = 16777408 { $10000c0 };
    QtKey_HotLinks = 16777409 { $10000c1 };
    QtKey_BrightnessAdjust = 16777410 { $10000c2 };
    QtKey_Finance = 16777411 { $10000c3 };
    QtKey_Community = 16777412 { $10000c4 };
    QtKey_AudioRewind = 16777413 { $10000c5 };
    QtKey_BackForward = 16777414 { $10000c6 };
    QtKey_ApplicationLeft = 16777415 { $10000c7 };
    QtKey_ApplicationRight = 16777416 { $10000c8 };
    QtKey_Book = 16777417 { $10000c9 };
    QtKey_CD = 16777418 { $10000ca };
    QtKey_Calculator = 16777419 { $10000cb };
    QtKey_ToDoList = 16777420 { $10000cc };
    QtKey_ClearGrab = 16777421 { $10000cd };
    QtKey_Close = 16777422 { $10000ce };
    QtKey_Copy = 16777423 { $10000cf };
    QtKey_Cut = 16777424 { $10000d0 };
    QtKey_Display = 16777425 { $10000d1 };
    QtKey_DOS = 16777426 { $10000d2 };
    QtKey_Documents = 16777427 { $10000d3 };
    QtKey_Excel = 16777428 { $10000d4 };
    QtKey_Explorer = 16777429 { $10000d5 };
    QtKey_Game = 16777430 { $10000d6 };
    QtKey_Go = 16777431 { $10000d7 };
    QtKey_iTouch = 16777432 { $10000d8 };
    QtKey_LogOff = 16777433 { $10000d9 };
    QtKey_Market = 16777434 { $10000da };
    QtKey_Meeting = 16777435 { $10000db };
    QtKey_MenuKB = 16777436 { $10000dc };
    QtKey_MenuPB = 16777437 { $10000dd };
    QtKey_MySites = 16777438 { $10000de };
    QtKey_News = 16777439 { $10000df };
    QtKey_OfficeHome = 16777440 { $10000e0 };
    QtKey_Option = 16777441 { $10000e1 };
    QtKey_Paste = 16777442 { $10000e2 };
    QtKey_Phone = 16777443 { $10000e3 };
    QtKey_Calendar = 16777444 { $10000e4 };
    QtKey_Reply = 16777445 { $10000e5 };
    QtKey_Reload = 16777446 { $10000e6 };
    QtKey_RotateWindows = 16777447 { $10000e7 };
    QtKey_RotationPB = 16777448 { $10000e8 };
    QtKey_RotationKB = 16777449 { $10000e9 };
    QtKey_Save = 16777450 { $10000ea };
    QtKey_Send = 16777451 { $10000eb };
    QtKey_Spell = 16777452 { $10000ec };
    QtKey_SplitScreen = 16777453 { $10000ed };
    QtKey_Support = 16777454 { $10000ee };
    QtKey_TaskPane = 16777455 { $10000ef };
    QtKey_Terminal = 16777456 { $10000f0 };
    QtKey_Tools = 16777457 { $10000f1 };
    QtKey_Travel = 16777458 { $10000f2 };
    QtKey_Video = 16777459 { $10000f3 };
    QtKey_Word = 16777460 { $10000f4 };
    QtKey_Xfer = 16777461 { $10000f5 };
    QtKey_ZoomIn = 16777462 { $10000f6 };
    QtKey_ZoomOut = 16777463 { $10000f7 };
    QtKey_Away = 16777464 { $10000f8 };
    QtKey_Messenger = 16777465 { $10000f9 };
    QtKey_WebCam = 16777466 { $10000fa };
    QtKey_MailForward = 16777467 { $10000fb };
    QtKey_Pictures = 16777468 { $10000fc };
    QtKey_Music = 16777469 { $10000fd };
    QtKey_Battery = 16777470 { $10000fe };
    QtKey_Bluetooth = 16777471 { $10000ff };
    QtKey_WLAN = 16777472 { $1000100 };
    QtKey_UWB = 16777473 { $1000101 };
    QtKey_AudioForward = 16777474 { $1000102 };
    QtKey_AudioRepeat = 16777475 { $1000103 };
    QtKey_AudioRandomPlay = 16777476 { $1000104 };
    QtKey_Subtitle = 16777477 { $1000105 };
    QtKey_AudioCycleTrack = 16777478 { $1000106 };
    QtKey_Time = 16777479 { $1000107 };
    QtKey_Hibernate = 16777480 { $1000108 };
    QtKey_View = 16777481 { $1000109 };
    QtKey_TopMenu = 16777482 { $100010a };
    QtKey_PowerDown = 16777483 { $100010b };
    QtKey_Suspend = 16777484 { $100010c };
    QtKey_ContrastAdjust = 16777485 { $100010d };
    QtKey_LaunchG = 16777486 { $100010e };
    QtKey_LaunchH = 16777487 { $100010f };
    QtKey_TouchpadToggle = 16777488 { $1000110 };
    QtKey_TouchpadOn = 16777489 { $1000111 };
    QtKey_TouchpadOff = 16777490 { $1000112 };
    QtKey_MicMute = 16777491 { $1000113 };
    QtKey_MediaLast = 16842751 { $100ffff };
    QtKey_Select = 16842752 { $1010000 };
    QtKey_Yes = 16842753 { $1010001 };
    QtKey_No = 16842754 { $1010002 };
    QtKey_Cancel = 16908289 { $1020001 };
    QtKey_Printer = 16908290 { $1020002 };
    QtKey_Execute = 16908291 { $1020003 };
    QtKey_Sleep = 16908292 { $1020004 };
    QtKey_Play = 16908293 { $1020005 };
    QtKey_Zoom = 16908294 { $1020006 };
    QtKey_Context1 = 17825792 { $1100000 };
    QtKey_Context2 = 17825793 { $1100001 };
    QtKey_Context3 = 17825794 { $1100002 };
    QtKey_Context4 = 17825795 { $1100003 };
    QtKey_Call = 17825796 { $1100004 };
    QtKey_Hangup = 17825797 { $1100005 };
    QtKey_Flip = 17825798 { $1100006 };
    QtKey_ToggleCallHangup = 17825799 { $1100007 };
    QtKey_VoiceDial = 17825800 { $1100008 };
    QtKey_LastNumberRedial = 17825801 { $1100009 };
    QtKey_Camera = 17825824 { $1100020 };
    QtKey_CameraFocus = 17825825 { $1100021 };
    QtKey_unknown = 33554431 { $1ffffff };

type
  QtCursorShape = cardinal; //  Qt::CursorShape (4)

const
    QtArrowCursor = 0 { $0 };
    QtUpArrowCursor = 1 { $1 };
    QtCrossCursor = 2 { $2 };
    QtWaitCursor = 3 { $3 };
    QtIBeamCursor = 4 { $4 };
    QtSizeVerCursor = 5 { $5 };
    QtSizeHorCursor = 6 { $6 };
    QtSizeBDiagCursor = 7 { $7 };
    QtSizeFDiagCursor = 8 { $8 };
    QtSizeAllCursor = 9 { $9 };
    QtBlankCursor = 10 { $a };
    QtSplitVCursor = 11 { $b };
    QtSplitHCursor = 12 { $c };
    QtPointingHandCursor = 13 { $d };
    QtForbiddenCursor = 14 { $e };
    QtWhatsThisCursor = 15 { $f };
    QtBusyCursor = 16 { $10 };
    QtOpenHandCursor = 17 { $11 };
    QtClosedHandCursor = 18 { $12 };
    QtDragCopyCursor = 19 { $13 };
    QtDragMoveCursor = 20 { $14 };
    QtDragLinkCursor = 21 { $15 };
    QtLastCursor = 21 { $15 };
    QtBitmapCursor = 24 { $18 };
    QtCustomCursor = 25 { $19 };

type
  QtDockWidgetArea = cardinal; //  Qt::DockWidgetArea (4)
  QtDockWidgetAreas = QtDockWidgetArea; // QFlags<>

const
    QtLeftDockWidgetArea = 1 { $1 };
    QtRightDockWidgetArea = 2 { $2 };
    QtTopDockWidgetArea = 4 { $4 };
    QtBottomDockWidgetArea = 8 { $8 };
    QtDockWidgetArea_Mask = 15 { $f };
    QtAllDockWidgetAreas = 15 { $f };
    QtNoDockWidgetArea = 0 { $0 };

type
  QtToolBarArea = cardinal; //  Qt::ToolBarArea (4)
  QtToolBarAreas = QtToolBarArea; // QFlags<>

const
    QtLeftToolBarArea = 1 { $1 };
    QtRightToolBarArea = 2 { $2 };
    QtTopToolBarArea = 4 { $4 };
    QtBottomToolBarArea = 8 { $8 };
    QtToolBarArea_Mask = 15 { $f };
    QtAllToolBarAreas = 15 { $f };
    QtNoToolBarArea = 0 { $0 };

type
  QtDateFormat = cardinal; //  Qt::DateFormat (4)

const
    QtTextDate = 0 { $0 };
    QtISODate = 1 { $1 };
    QtSystemLocaleDate = 2 { $2 };
    QtLocalDate = 2 { $2 };
    QtLocaleDate = 3 { $3 };
    QtSystemLocaleShortDate = 4 { $4 };
    QtSystemLocaleLongDate = 5 { $5 };
    QtDefaultLocaleShortDate = 6 { $6 };
    QtDefaultLocaleLongDate = 7 { $7 };

type
  QtInputMethodQuery = cardinal; //  Qt::InputMethodQuery (4)
  QtInputMethodQueries = QtInputMethodQuery; // QFlags<>

const
    QtImEnabled = 1 { $1 };
    QtImCursorRectangle = 2 { $2 };
    QtImMicroFocus = 2 { $2 };
    QtImFont = 4 { $4 };
    QtImCursorPosition = 8 { $8 };
    QtImSurroundingText = 16 { $10 };
    QtImCurrentSelection = 32 { $20 };
    QtImMaximumTextLength = 64 { $40 };
    QtImAnchorPosition = 128 { $80 };
    QtImHints = 256 { $100 };
    QtImPreferredLanguage = 512 { $200 };
    QtImPlatformData = 2147483648 { $80000000 };
    QtImQueryInput = 186 { $ba };
    QtImQueryAll = 4294967295 { $ffffffff };

type
  QtTextInteractionFlag = cardinal; //  Qt::TextInteractionFlag (4)
  QtTextInteractionFlags = QtTextInteractionFlag; // QFlags<>

const
    QtNoTextInteraction = 0 { $0 };
    QtTextSelectableByMouse = 1 { $1 };
    QtTextSelectableByKeyboard = 2 { $2 };
    QtLinksAccessibleByMouse = 4 { $4 };
    QtLinksAccessibleByKeyboard = 8 { $8 };
    QtTextEditable = 16 { $10 };
    QtTextEditorInteraction = 19 { $13 };
    QtTextBrowserInteraction = 13 { $d };

type
  QtGestureType = cardinal; //  Qt::GestureType (4)

const
    QtTapGesture = 1 { $1 };
    QtTapAndHoldGesture = 2 { $2 };
    QtPanGesture = 3 { $3 };
    QtPinchGesture = 4 { $4 };
    QtSwipeGesture = 5 { $5 };
    QtCustomGesture = 256 { $100 };
    QtLastGestureType = 4294967295 { $ffffffff };


function QObject_Create(parent: QObjectH = nil): QObjectH; cdecl; external Qt5PasLib name 'QObject_Create';
procedure QObject_Destroy(handle: QObjectH); cdecl; external Qt5PasLib name 'QObject_Destroy'; 
function QObject_event(handle: QObjectH; AnonParam1: QEventH): Boolean; cdecl; external Qt5PasLib name 'QObject_event';
function QObject_eventFilter(handle: QObjectH; AnonParam1: QObjectH; AnonParam2: QEventH): Boolean; cdecl; external Qt5PasLib name 'QObject_eventFilter';
procedure QObject_objectName(handle: QObjectH; retval: PWideString); cdecl; external Qt5PasLib name 'QObject_objectName';
procedure QObject_setObjectName(handle: QObjectH; name: PWideString); cdecl; external Qt5PasLib name 'QObject_setObjectName';
function QObject_isWidgetType(handle: QObjectH): Boolean; cdecl; external Qt5PasLib name 'QObject_isWidgetType';
function QObject_isWindowType(handle: QObjectH): Boolean; cdecl; external Qt5PasLib name 'QObject_isWindowType';
function QObject_signalsBlocked(handle: QObjectH): Boolean; cdecl; external Qt5PasLib name 'QObject_signalsBlocked';
function QObject_blockSignals(handle: QObjectH; b: Boolean): Boolean; cdecl; external Qt5PasLib name 'QObject_blockSignals';
function QObject_thread(handle: QObjectH): QThreadH; cdecl; external Qt5PasLib name 'QObject_thread';
procedure QObject_moveToThread(handle: QObjectH; thread: QThreadH); cdecl; external Qt5PasLib name 'QObject_moveToThread';
function QObject_startTimer(handle: QObjectH; interval: Integer; timerType: QtTimerType = QtCoarseTimer): Integer; cdecl; external Qt5PasLib name 'QObject_startTimer';
procedure QObject_killTimer(handle: QObjectH; id: Integer); cdecl; external Qt5PasLib name 'QObject_killTimer';
procedure QObject_children(handle: QObjectH; retval: PPtrIntArray); cdecl; external Qt5PasLib name 'QObject_children';
procedure QObject_setParent(handle: QObjectH; AnonParam1: QObjectH); cdecl; external Qt5PasLib name 'QObject_setParent';
procedure QObject_installEventFilter(handle: QObjectH; AnonParam1: QObjectH); cdecl; external Qt5PasLib name 'QObject_installEventFilter';
procedure QObject_removeEventFilter(handle: QObjectH; AnonParam1: QObjectH); cdecl; external Qt5PasLib name 'QObject_removeEventFilter';
procedure QObject_connect(sender: QObjectH; signal: PAnsiChar; receiver: QObjectH; member: PAnsiChar; AnonParam5: QtConnectionType = QtAutoConnection); cdecl; external Qt5PasLib name 'QObject_connect';
procedure QObject_connect(sender: QObjectH; signal: QMetaMethodH; receiver: QObjectH; method: QMetaMethodH; _type: QtConnectionType = QtAutoConnection); cdecl; external Qt5PasLib name 'QObject_connect2';
procedure QObject_connect(handle: QObjectH; sender: QObjectH; signal: PAnsiChar; member: PAnsiChar; _type: QtConnectionType = QtAutoConnection); cdecl; external Qt5PasLib name 'QObject_connect3';
function QObject_disconnect(sender: QObjectH; signal: PAnsiChar; receiver: QObjectH; member: PAnsiChar): Boolean; cdecl; external Qt5PasLib name 'QObject_disconnect';
function QObject_disconnect(sender: QObjectH; signal: QMetaMethodH; receiver: QObjectH; member: QMetaMethodH): Boolean; cdecl; external Qt5PasLib name 'QObject_disconnect2';
function QObject_disconnect(handle: QObjectH; receiver: QObjectH; member: PAnsiChar = nil): Boolean; cdecl; external Qt5PasLib name 'QObject_disconnect4';
procedure QObject_dumpObjectTree(handle: QObjectH); cdecl; external Qt5PasLib name 'QObject_dumpObjectTree';
procedure QObject_dumpObjectInfo(handle: QObjectH); cdecl; external Qt5PasLib name 'QObject_dumpObjectInfo';
function QObject_setProperty(handle: QObjectH; name: PAnsiChar; value: QVariantH): Boolean; cdecl; external Qt5PasLib name 'QObject_setProperty';
procedure QObject_property(handle: QObjectH; retval: QVariantH; name: PAnsiChar); cdecl; external Qt5PasLib name 'QObject_property';
function QObject_registerUserData(): LongWord; cdecl; external Qt5PasLib name 'QObject_registerUserData';
function QObject_parent(handle: QObjectH): QObjectH; cdecl; external Qt5PasLib name 'QObject_parent';
function QObject_inherits(handle: QObjectH; classname: PAnsiChar): Boolean; cdecl; external Qt5PasLib name 'QObject_inherits';
procedure QObject_deleteLater(handle: QObjectH); cdecl; external Qt5PasLib name 'QObject_deleteLater';


type
  QMetaObjectCall = ( // QMetaObject::Call (1)
    QMetaObjectInvokeMetaMethod, QMetaObjectReadProperty, QMetaObjectWriteProperty, QMetaObjectResetProperty, QMetaObjectQueryPropertyDesignable, QMetaObjectQueryPropertyScriptable, QMetaObjectQueryPropertyStored, 
    QMetaObjectQueryPropertyEditable, QMetaObjectQueryPropertyUser, QMetaObjectCreateInstance, QMetaObjectIndexOfMethod, QMetaObjectRegisterPropertyMetaType, QMetaObjectRegisterMethodArgumentMetaType );

function QGenericReturnArgument_Create(aName: PAnsiChar = nil; aData: Pointer = nil): QGenericReturnArgumentH; cdecl; external Qt5PasLib name 'QGenericReturnArgument_Create';
procedure QGenericReturnArgument_Destroy(handle: QGenericReturnArgumentH); cdecl; external Qt5PasLib name 'QGenericReturnArgument_Destroy'; 



function QMetaObject_className(handle: QMetaObjectH): PAnsiChar; cdecl; external Qt5PasLib name 'QMetaObject_className';
function QMetaObject_superClass(handle: QMetaObjectH): QMetaObjectH; cdecl; external Qt5PasLib name 'QMetaObject_superClass';
function QMetaObject_cast(handle: QMetaObjectH; obj: QObjectH): QObjectH; cdecl; external Qt5PasLib name 'QMetaObject_cast';
procedure QMetaObject_tr(handle: QMetaObjectH; retval: PWideString; s: PAnsiChar; c: PAnsiChar; n: Integer = -1); cdecl; external Qt5PasLib name 'QMetaObject_tr';
function QMetaObject_methodOffset(handle: QMetaObjectH): Integer; cdecl; external Qt5PasLib name 'QMetaObject_methodOffset';
function QMetaObject_enumeratorOffset(handle: QMetaObjectH): Integer; cdecl; external Qt5PasLib name 'QMetaObject_enumeratorOffset';
function QMetaObject_propertyOffset(handle: QMetaObjectH): Integer; cdecl; external Qt5PasLib name 'QMetaObject_propertyOffset';
function QMetaObject_classInfoOffset(handle: QMetaObjectH): Integer; cdecl; external Qt5PasLib name 'QMetaObject_classInfoOffset';
function QMetaObject_constructorCount(handle: QMetaObjectH): Integer; cdecl; external Qt5PasLib name 'QMetaObject_constructorCount';
function QMetaObject_methodCount(handle: QMetaObjectH): Integer; cdecl; external Qt5PasLib name 'QMetaObject_methodCount';
function QMetaObject_enumeratorCount(handle: QMetaObjectH): Integer; cdecl; external Qt5PasLib name 'QMetaObject_enumeratorCount';
function QMetaObject_propertyCount(handle: QMetaObjectH): Integer; cdecl; external Qt5PasLib name 'QMetaObject_propertyCount';
function QMetaObject_classInfoCount(handle: QMetaObjectH): Integer; cdecl; external Qt5PasLib name 'QMetaObject_classInfoCount';
function QMetaObject_indexOfConstructor(handle: QMetaObjectH; _constructor: PAnsiChar): Integer; cdecl; external Qt5PasLib name 'QMetaObject_indexOfConstructor';
function QMetaObject_indexOfMethod(handle: QMetaObjectH; method: PAnsiChar): Integer; cdecl; external Qt5PasLib name 'QMetaObject_indexOfMethod';
function QMetaObject_indexOfSignal(handle: QMetaObjectH; signal: PAnsiChar): Integer; cdecl; external Qt5PasLib name 'QMetaObject_indexOfSignal';
function QMetaObject_indexOfSlot(handle: QMetaObjectH; slot: PAnsiChar): Integer; cdecl; external Qt5PasLib name 'QMetaObject_indexOfSlot';
function QMetaObject_indexOfEnumerator(handle: QMetaObjectH; name: PAnsiChar): Integer; cdecl; external Qt5PasLib name 'QMetaObject_indexOfEnumerator';
function QMetaObject_indexOfProperty(handle: QMetaObjectH; name: PAnsiChar): Integer; cdecl; external Qt5PasLib name 'QMetaObject_indexOfProperty';
function QMetaObject_indexOfClassInfo(handle: QMetaObjectH; name: PAnsiChar): Integer; cdecl; external Qt5PasLib name 'QMetaObject_indexOfClassInfo';
procedure QMetaObject_constructor(handle: QMetaObjectH; retval: QMetaMethodH; index: Integer); cdecl; external Qt5PasLib name 'QMetaObject_constructor';
procedure QMetaObject_method(handle: QMetaObjectH; retval: QMetaMethodH; index: Integer); cdecl; external Qt5PasLib name 'QMetaObject_method';
procedure QMetaObject_enumerator(handle: QMetaObjectH; retval: QMetaEnumH; index: Integer); cdecl; external Qt5PasLib name 'QMetaObject_enumerator';
procedure QMetaObject_property(handle: QMetaObjectH; retval: QMetaPropertyH; index: Integer); cdecl; external Qt5PasLib name 'QMetaObject_property';
procedure QMetaObject_classInfo(handle: QMetaObjectH; retval: QMetaClassInfoH; index: Integer); cdecl; external Qt5PasLib name 'QMetaObject_classInfo';
procedure QMetaObject_userProperty(handle: QMetaObjectH; retval: QMetaPropertyH); cdecl; external Qt5PasLib name 'QMetaObject_userProperty';
function QMetaObject_checkConnectArgs(signal: PAnsiChar; method: PAnsiChar): Boolean; cdecl; external Qt5PasLib name 'QMetaObject_checkConnectArgs';
function QMetaObject_checkConnectArgs(signal: QMetaMethodH; method: QMetaMethodH): Boolean; cdecl; external Qt5PasLib name 'QMetaObject_checkConnectArgs2';
procedure QMetaObject_normalizedSignature(retval: QByteArrayH; method: PAnsiChar); cdecl; external Qt5PasLib name 'QMetaObject_normalizedSignature';
procedure QMetaObject_normalizedType(retval: QByteArrayH; _type: PAnsiChar); cdecl; external Qt5PasLib name 'QMetaObject_normalizedType';
function QMetaObject_disconnect(sender: QObjectH; signal_index: Integer; receiver: QObjectH; method_index: Integer): Boolean; cdecl; external Qt5PasLib name 'QMetaObject_disconnect';
function QMetaObject_disconnectOne(sender: QObjectH; signal_index: Integer; receiver: QObjectH; method_index: Integer): Boolean; cdecl; external Qt5PasLib name 'QMetaObject_disconnectOne';
procedure QMetaObject_connectSlotsByName(o: QObjectH); cdecl; external Qt5PasLib name 'QMetaObject_connectSlotsByName';
procedure QMetaObject_activate(sender: QObjectH; signal_index: Integer; argv: PPointer); cdecl; external Qt5PasLib name 'QMetaObject_activate';
procedure QMetaObject_activate(sender: QObjectH; AnonParam2: QMetaObjectH; local_signal_index: Integer; argv: PPointer); cdecl; external Qt5PasLib name 'QMetaObject_activate2';
procedure QMetaObject_activate(sender: QObjectH; signal_offset: Integer; local_signal_index: Integer; argv: PPointer); cdecl; external Qt5PasLib name 'QMetaObject_activate3';
function QMetaObject_static_metacall(handle: QMetaObjectH; AnonParam1: QMetaObjectCall; AnonParam2: Integer; AnonParam3: PPointer): Integer; cdecl; external Qt5PasLib name 'QMetaObject_static_metacall';
function QMetaObject_metacall(AnonParam1: QObjectH; AnonParam2: QMetaObjectCall; AnonParam3: Integer; AnonParam4: PPointer): Integer; cdecl; external Qt5PasLib name 'QMetaObject_metacall';


type
  QVariantType = cardinal; //  QVariant::Type (4)

const
    QVariantInvalid = 0 { $0 };
    QVariantBool = 1 { $1 };
    QVariantInt = 2 { $2 };
    QVariantUInt = 3 { $3 };
    QVariantLongLong = 4 { $4 };
    QVariantULongLong = 5 { $5 };
    QVariantDouble = 6 { $6 };
    QVariantChar = 7 { $7 };
    QVariantMap = 8 { $8 };
    QVariantList = 9 { $9 };
    QVariantString = 10 { $a };
    QVariantStringList = 11 { $b };
    QVariantByteArray = 12 { $c };
    QVariantBitArray = 13 { $d };
    QVariantDate = 14 { $e };
    QVariantTime = 15 { $f };
    QVariantDateTime = 16 { $10 };
    QVariantUrl = 17 { $11 };
    QVariantLocale = 18 { $12 };
    QVariantRect = 19 { $13 };
    QVariantRectF = 20 { $14 };
    QVariantSize = 21 { $15 };
    QVariantSizeF = 22 { $16 };
    QVariantLine = 23 { $17 };
    QVariantLineF = 24 { $18 };
    QVariantPoint = 25 { $19 };
    QVariantPointF = 26 { $1a };
    QVariantRegExp = 27 { $1b };
    QVariantRegularExpression = 44 { $2c };
    QVariantHash = 28 { $1c };
    QVariantEasingCurve = 29 { $1d };
    QVariantUuid = 30 { $1e };
    QVariantModelIndex = 42 { $2a };
    QVariantLastCoreType = 48 { $30 };
    QVariantFont = 64 { $40 };
    QVariantPixmap = 65 { $41 };
    QVariantBrush = 66 { $42 };
    QVariantColor = 67 { $43 };
    QVariantPalette = 68 { $44 };
    QVariantImage = 70 { $46 };
    QVariantPolygon = 71 { $47 };
    QVariantRegion = 72 { $48 };
    QVariantBitmap = 73 { $49 };
    QVariantCursor = 74 { $4a };
    QVariantKeySequence = 75 { $4b };
    QVariantPen = 76 { $4c };
    QVariantTextLength = 77 { $4d };
    QVariantTextFormat = 78 { $4e };
    QVariantMatrix = 79 { $4f };
    QVariantTransform = 80 { $50 };
    QVariantMatrix4x4 = 81 { $51 };
    QVariantVector2D = 82 { $52 };
    QVariantVector3D = 83 { $53 };
    QVariantVector4D = 84 { $54 };
    QVariantQuaternion = 85 { $55 };
    QVariantPolygonF = 86 { $56 };
    QVariantIcon = 69 { $45 };
    QVariantLastGuiType = 86 { $56 };
    QVariantSizePolicy = 121 { $79 };
    QVariantUserType = 1024 { $400 };
    QVariantLastType = 4294967295 { $ffffffff };



function QVariant_Create(): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create';
procedure QVariant_Destroy(handle: QVariantH); cdecl; external Qt5PasLib name 'QVariant_Destroy'; 
function QVariant_Create(typeId: Integer; copy: Pointer): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create3';
function QVariant_Create(typeId: Integer; copy: Pointer; flags: LongWord): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create4';
function QVariant_Create(other: QVariantH): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create5';
function QVariant_Create(s: QDataStreamH): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create6';
function QVariant_Create(ui: LongWord): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create8';
function QVariant_Create(ll: int64): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create9';
function QVariant_Create(ull: qword): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create10';
function QVariant_Create(b: Boolean): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create11';
function QVariant_Create(d: Double): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create12';
function QVariant_Create(f: Single): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create13';
function QVariant_Create(str: PAnsiChar): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create14';
function QVariant_Create(bytearray: QByteArrayH): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create15';
function QVariant_Create(bitarray: QBitArrayH): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create16';
function QVariant_Create(_string: PWideString): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create17';
function QVariant_Create(stringlist: QStringListH): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create18';
function QVariant_Create(qchar: PWideChar): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create19';
function QVariant_Create(date: QDateH): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create20';
function QVariant_Create(time: QTimeH): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create21';
function QVariant_Create(pt: PQtPoint): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create25';
function QVariant_Create(pt: PQtPointF): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create26';
function QVariant_Create(line: QLineH): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create27';
function QVariant_Create(line: QLineFH): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create28';
function QVariant_Create(rect: PRect): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create29';
function QVariant_Create(rect: QRectFH): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create30';
function QVariant_Create(locale: QLocaleH): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create31';
function QVariant_Create(regExp: QRegExpH): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create32';
function QVariant_Create(re: QRegularExpressionH): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create33';
function QVariant_Create(url: QUrlH): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create34';
function QVariant_Create(easing: QEasingCurveH): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create35';
function QVariant_Create(uuid: QUuidH): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create36';
function QVariant_Create(modelIndex: QModelIndexH): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create37';
function QVariant_Create(jsonValue: QJsonValueH): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create38';
function QVariant_Create(jsonObject: QJsonObjectH): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create39';
function QVariant_Create(jsonArray: QJsonArrayH): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create40';
function QVariant_Create(jsonDocument: QJsonDocumentH): QVariantH; cdecl; external Qt5PasLib name 'QVariant_Create41';
procedure QVariant_swap(handle: QVariantH; other: QVariantH); cdecl; external Qt5PasLib name 'QVariant_swap';
function QVariant_type(handle: QVariantH): QVariantType; cdecl; external Qt5PasLib name 'QVariant_type';
function QVariant_userType(handle: QVariantH): Integer; cdecl; external Qt5PasLib name 'QVariant_userType';
function QVariant_typeName(handle: QVariantH): PAnsiChar; cdecl; external Qt5PasLib name 'QVariant_typeName';
function QVariant_canConvert(handle: QVariantH; targetTypeId: Integer): Boolean; cdecl; external Qt5PasLib name 'QVariant_canConvert';
function QVariant_convert(handle: QVariantH; targetTypeId: Integer): Boolean; cdecl; external Qt5PasLib name 'QVariant_convert';
function QVariant_isValid(handle: QVariantH): Boolean; cdecl; external Qt5PasLib name 'QVariant_isValid';
function QVariant_isNull(handle: QVariantH): Boolean; cdecl; external Qt5PasLib name 'QVariant_isNull';
procedure QVariant_clear(handle: QVariantH); cdecl; external Qt5PasLib name 'QVariant_clear';
procedure QVariant_detach(handle: QVariantH); cdecl; external Qt5PasLib name 'QVariant_detach';
function QVariant_isDetached(handle: QVariantH): Boolean; cdecl; external Qt5PasLib name 'QVariant_isDetached';
function QVariant_toInt(handle: QVariantH; ok: PBoolean = nil): Integer; cdecl; external Qt5PasLib name 'QVariant_toInt';
function QVariant_toUInt(handle: QVariantH; ok: PBoolean = nil): LongWord; cdecl; external Qt5PasLib name 'QVariant_toUInt';
function QVariant_toLongLong(handle: QVariantH; ok: PBoolean = nil): int64; cdecl; external Qt5PasLib name 'QVariant_toLongLong';
function QVariant_toULongLong(handle: QVariantH; ok: PBoolean = nil): qword; cdecl; external Qt5PasLib name 'QVariant_toULongLong';
function QVariant_toBool(handle: QVariantH): Boolean; cdecl; external Qt5PasLib name 'QVariant_toBool';
function QVariant_toDouble(handle: QVariantH; ok: PBoolean = nil): Double; cdecl; external Qt5PasLib name 'QVariant_toDouble';
function QVariant_toFloat(handle: QVariantH; ok: PBoolean = nil): Single; cdecl; external Qt5PasLib name 'QVariant_toFloat';
function QVariant_toReal(handle: QVariantH; ok: PBoolean = nil): qreal; cdecl; external Qt5PasLib name 'QVariant_toReal';
procedure QVariant_toByteArray(handle: QVariantH; retval: QByteArrayH); cdecl; external Qt5PasLib name 'QVariant_toByteArray';
procedure QVariant_toBitArray(handle: QVariantH; retval: QBitArrayH); cdecl; external Qt5PasLib name 'QVariant_toBitArray';
procedure QVariant_toString(handle: QVariantH; retval: PWideString); cdecl; external Qt5PasLib name 'QVariant_toString';
procedure QVariant_toStringList(handle: QVariantH; retval: QStringListH); cdecl; external Qt5PasLib name 'QVariant_toStringList';
procedure QVariant_toChar(handle: QVariantH; retval: PWideChar); cdecl; external Qt5PasLib name 'QVariant_toChar';
procedure QVariant_toDate(handle: QVariantH; retval: QDateH); cdecl; external Qt5PasLib name 'QVariant_toDate';
procedure QVariant_toTime(handle: QVariantH; retval: QTimeH); cdecl; external Qt5PasLib name 'QVariant_toTime';
procedure QVariant_toDateTime(handle: QVariantH; retval: QDateTimeH); cdecl; external Qt5PasLib name 'QVariant_toDateTime';
procedure QVariant_toPoint(handle: QVariantH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QVariant_toPoint';
procedure QVariant_toPointF(handle: QVariantH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QVariant_toPointF';
procedure QVariant_toRect(handle: QVariantH; retval: PRect); cdecl; external Qt5PasLib name 'QVariant_toRect';
procedure QVariant_toSize(handle: QVariantH; retval: PSize); cdecl; external Qt5PasLib name 'QVariant_toSize';
procedure QVariant_toSizeF(handle: QVariantH; retval: QSizeFH); cdecl; external Qt5PasLib name 'QVariant_toSizeF';
procedure QVariant_toLine(handle: QVariantH; retval: QLineH); cdecl; external Qt5PasLib name 'QVariant_toLine';
procedure QVariant_toLineF(handle: QVariantH; retval: QLineFH); cdecl; external Qt5PasLib name 'QVariant_toLineF';
procedure QVariant_toRectF(handle: QVariantH; retval: QRectFH); cdecl; external Qt5PasLib name 'QVariant_toRectF';
procedure QVariant_toLocale(handle: QVariantH; retval: QLocaleH); cdecl; external Qt5PasLib name 'QVariant_toLocale';
procedure QVariant_toRegExp(handle: QVariantH; retval: QRegExpH); cdecl; external Qt5PasLib name 'QVariant_toRegExp';
procedure QVariant_toRegularExpression(handle: QVariantH; retval: QRegularExpressionH); cdecl; external Qt5PasLib name 'QVariant_toRegularExpression';
procedure QVariant_toUrl(handle: QVariantH; retval: QUrlH); cdecl; external Qt5PasLib name 'QVariant_toUrl';
procedure QVariant_toEasingCurve(handle: QVariantH; retval: QEasingCurveH); cdecl; external Qt5PasLib name 'QVariant_toEasingCurve';
procedure QVariant_toUuid(handle: QVariantH; retval: QUuidH); cdecl; external Qt5PasLib name 'QVariant_toUuid';
procedure QVariant_toModelIndex(handle: QVariantH; retval: QModelIndexH); cdecl; external Qt5PasLib name 'QVariant_toModelIndex';
procedure QVariant_toJsonValue(handle: QVariantH; retval: QJsonValueH); cdecl; external Qt5PasLib name 'QVariant_toJsonValue';
procedure QVariant_toJsonObject(handle: QVariantH; retval: QJsonObjectH); cdecl; external Qt5PasLib name 'QVariant_toJsonObject';
procedure QVariant_toJsonArray(handle: QVariantH; retval: QJsonArrayH); cdecl; external Qt5PasLib name 'QVariant_toJsonArray';
procedure QVariant_toJsonDocument(handle: QVariantH; retval: QJsonDocumentH); cdecl; external Qt5PasLib name 'QVariant_toJsonDocument';
procedure QVariant_load(handle: QVariantH; ds: QDataStreamH); cdecl; external Qt5PasLib name 'QVariant_load';
procedure QVariant_save(handle: QVariantH; ds: QDataStreamH); cdecl; external Qt5PasLib name 'QVariant_save';
function QVariant_typeToName(typeId: Integer): PAnsiChar; cdecl; external Qt5PasLib name 'QVariant_typeToName';
function QVariant_nameToType(name: PAnsiChar): QVariantType; cdecl; external Qt5PasLib name 'QVariant_nameToType';
function QVariant_constData(handle: QVariantH): Pointer; cdecl; external Qt5PasLib name 'QVariant_constData';



type
  QMetaMethodAccess = ( // QMetaMethod::Access (1)
    QMetaMethodPrivate, QMetaMethodProtected, QMetaMethodPublic );

  QMetaMethodMethodType = ( // QMetaMethod::MethodType (1)
    QMetaMethodMethod, QMetaMethodSignal, QMetaMethodSlot, QMetaMethodConstructor );

  QMetaMethodAttributes = (  //QMetaMethod::Attributes (2)
    QMetaMethodCompatibility = $1,
    QMetaMethodCloned = $2,
    QMetaMethodScriptable = $4 );

function QMetaMethod_Create(): QMetaMethodH; cdecl; external Qt5PasLib name 'QMetaMethod_Create';
procedure QMetaMethod_Destroy(handle: QMetaMethodH); cdecl; external Qt5PasLib name 'QMetaMethod_Destroy'; 
procedure QMetaMethod_methodSignature(handle: QMetaMethodH; retval: QByteArrayH); cdecl; external Qt5PasLib name 'QMetaMethod_methodSignature';
procedure QMetaMethod_name(handle: QMetaMethodH; retval: QByteArrayH); cdecl; external Qt5PasLib name 'QMetaMethod_name';
function QMetaMethod_typeName(handle: QMetaMethodH): PAnsiChar; cdecl; external Qt5PasLib name 'QMetaMethod_typeName';
function QMetaMethod_returnType(handle: QMetaMethodH): Integer; cdecl; external Qt5PasLib name 'QMetaMethod_returnType';
function QMetaMethod_parameterCount(handle: QMetaMethodH): Integer; cdecl; external Qt5PasLib name 'QMetaMethod_parameterCount';
function QMetaMethod_parameterType(handle: QMetaMethodH; index: Integer): Integer; cdecl; external Qt5PasLib name 'QMetaMethod_parameterType';
procedure QMetaMethod_getParameterTypes(handle: QMetaMethodH; types: PInteger); cdecl; external Qt5PasLib name 'QMetaMethod_getParameterTypes';
function QMetaMethod_tag(handle: QMetaMethodH): PAnsiChar; cdecl; external Qt5PasLib name 'QMetaMethod_tag';
function QMetaMethod_access(handle: QMetaMethodH): QMetaMethodAccess; cdecl; external Qt5PasLib name 'QMetaMethod_access';
function QMetaMethod_methodType(handle: QMetaMethodH): QMetaMethodMethodType; cdecl; external Qt5PasLib name 'QMetaMethod_methodType';
function QMetaMethod_attributes(handle: QMetaMethodH): Integer; cdecl; external Qt5PasLib name 'QMetaMethod_attributes';
function QMetaMethod_methodIndex(handle: QMetaMethodH): Integer; cdecl; external Qt5PasLib name 'QMetaMethod_methodIndex';
function QMetaMethod_revision(handle: QMetaMethodH): Integer; cdecl; external Qt5PasLib name 'QMetaMethod_revision';
function QMetaMethod_enclosingMetaObject(handle: QMetaMethodH): QMetaObjectH; cdecl; external Qt5PasLib name 'QMetaMethod_enclosingMetaObject';
function QMetaMethod_isValid(handle: QMetaMethodH): Boolean; cdecl; external Qt5PasLib name 'QMetaMethod_isValid';

function QMetaEnum_Create(): QMetaEnumH; cdecl; external Qt5PasLib name 'QMetaEnum_Create';
procedure QMetaEnum_Destroy(handle: QMetaEnumH); cdecl; external Qt5PasLib name 'QMetaEnum_Destroy'; 
function QMetaEnum_name(handle: QMetaEnumH): PAnsiChar; cdecl; external Qt5PasLib name 'QMetaEnum_name';
function QMetaEnum_isFlag(handle: QMetaEnumH): Boolean; cdecl; external Qt5PasLib name 'QMetaEnum_isFlag';
function QMetaEnum_keyCount(handle: QMetaEnumH): Integer; cdecl; external Qt5PasLib name 'QMetaEnum_keyCount';
function QMetaEnum_key(handle: QMetaEnumH; index: Integer): PAnsiChar; cdecl; external Qt5PasLib name 'QMetaEnum_key';
function QMetaEnum_value(handle: QMetaEnumH; index: Integer): Integer; cdecl; external Qt5PasLib name 'QMetaEnum_value';
function QMetaEnum_scope(handle: QMetaEnumH): PAnsiChar; cdecl; external Qt5PasLib name 'QMetaEnum_scope';
function QMetaEnum_keyToValue(handle: QMetaEnumH; key: PAnsiChar; ok: PBoolean = nil): Integer; cdecl; external Qt5PasLib name 'QMetaEnum_keyToValue';
function QMetaEnum_valueToKey(handle: QMetaEnumH; value: Integer): PAnsiChar; cdecl; external Qt5PasLib name 'QMetaEnum_valueToKey';
function QMetaEnum_keysToValue(handle: QMetaEnumH; keys: PAnsiChar; ok: PBoolean = nil): Integer; cdecl; external Qt5PasLib name 'QMetaEnum_keysToValue';
procedure QMetaEnum_valueToKeys(handle: QMetaEnumH; retval: QByteArrayH; value: Integer); cdecl; external Qt5PasLib name 'QMetaEnum_valueToKeys';
function QMetaEnum_enclosingMetaObject(handle: QMetaEnumH): QMetaObjectH; cdecl; external Qt5PasLib name 'QMetaEnum_enclosingMetaObject';
function QMetaEnum_isValid(handle: QMetaEnumH): Boolean; cdecl; external Qt5PasLib name 'QMetaEnum_isValid';

function QMetaProperty_Create(): QMetaPropertyH; cdecl; external Qt5PasLib name 'QMetaProperty_Create';
procedure QMetaProperty_Destroy(handle: QMetaPropertyH); cdecl; external Qt5PasLib name 'QMetaProperty_Destroy'; 
function QMetaProperty_name(handle: QMetaPropertyH): PAnsiChar; cdecl; external Qt5PasLib name 'QMetaProperty_name';
function QMetaProperty_typeName(handle: QMetaPropertyH): PAnsiChar; cdecl; external Qt5PasLib name 'QMetaProperty_typeName';
function QMetaProperty_type(handle: QMetaPropertyH): QVariantType; cdecl; external Qt5PasLib name 'QMetaProperty_type';
function QMetaProperty_userType(handle: QMetaPropertyH): Integer; cdecl; external Qt5PasLib name 'QMetaProperty_userType';
function QMetaProperty_propertyIndex(handle: QMetaPropertyH): Integer; cdecl; external Qt5PasLib name 'QMetaProperty_propertyIndex';
function QMetaProperty_isReadable(handle: QMetaPropertyH): Boolean; cdecl; external Qt5PasLib name 'QMetaProperty_isReadable';
function QMetaProperty_isWritable(handle: QMetaPropertyH): Boolean; cdecl; external Qt5PasLib name 'QMetaProperty_isWritable';
function QMetaProperty_isResettable(handle: QMetaPropertyH): Boolean; cdecl; external Qt5PasLib name 'QMetaProperty_isResettable';
function QMetaProperty_isDesignable(handle: QMetaPropertyH; obj: QObjectH = nil): Boolean; cdecl; external Qt5PasLib name 'QMetaProperty_isDesignable';
function QMetaProperty_isScriptable(handle: QMetaPropertyH; obj: QObjectH = nil): Boolean; cdecl; external Qt5PasLib name 'QMetaProperty_isScriptable';
function QMetaProperty_isStored(handle: QMetaPropertyH; obj: QObjectH = nil): Boolean; cdecl; external Qt5PasLib name 'QMetaProperty_isStored';
function QMetaProperty_isEditable(handle: QMetaPropertyH; obj: QObjectH = nil): Boolean; cdecl; external Qt5PasLib name 'QMetaProperty_isEditable';
function QMetaProperty_isUser(handle: QMetaPropertyH; obj: QObjectH = nil): Boolean; cdecl; external Qt5PasLib name 'QMetaProperty_isUser';
function QMetaProperty_isConstant(handle: QMetaPropertyH): Boolean; cdecl; external Qt5PasLib name 'QMetaProperty_isConstant';
function QMetaProperty_isFinal(handle: QMetaPropertyH): Boolean; cdecl; external Qt5PasLib name 'QMetaProperty_isFinal';
function QMetaProperty_isFlagType(handle: QMetaPropertyH): Boolean; cdecl; external Qt5PasLib name 'QMetaProperty_isFlagType';
function QMetaProperty_isEnumType(handle: QMetaPropertyH): Boolean; cdecl; external Qt5PasLib name 'QMetaProperty_isEnumType';
procedure QMetaProperty_enumerator(handle: QMetaPropertyH; retval: QMetaEnumH); cdecl; external Qt5PasLib name 'QMetaProperty_enumerator';
function QMetaProperty_hasNotifySignal(handle: QMetaPropertyH): Boolean; cdecl; external Qt5PasLib name 'QMetaProperty_hasNotifySignal';
procedure QMetaProperty_notifySignal(handle: QMetaPropertyH; retval: QMetaMethodH); cdecl; external Qt5PasLib name 'QMetaProperty_notifySignal';
function QMetaProperty_notifySignalIndex(handle: QMetaPropertyH): Integer; cdecl; external Qt5PasLib name 'QMetaProperty_notifySignalIndex';
function QMetaProperty_revision(handle: QMetaPropertyH): Integer; cdecl; external Qt5PasLib name 'QMetaProperty_revision';
procedure QMetaProperty_read(handle: QMetaPropertyH; retval: QVariantH; obj: QObjectH); cdecl; external Qt5PasLib name 'QMetaProperty_read';
function QMetaProperty_write(handle: QMetaPropertyH; obj: QObjectH; value: QVariantH): Boolean; cdecl; external Qt5PasLib name 'QMetaProperty_write';
function QMetaProperty_reset(handle: QMetaPropertyH; obj: QObjectH): Boolean; cdecl; external Qt5PasLib name 'QMetaProperty_reset';
function QMetaProperty_hasStdCppSet(handle: QMetaPropertyH): Boolean; cdecl; external Qt5PasLib name 'QMetaProperty_hasStdCppSet';
function QMetaProperty_isValid(handle: QMetaPropertyH): Boolean; cdecl; external Qt5PasLib name 'QMetaProperty_isValid';
function QMetaProperty_enclosingMetaObject(handle: QMetaPropertyH): QMetaObjectH; cdecl; external Qt5PasLib name 'QMetaProperty_enclosingMetaObject';

function QMetaClassInfo_Create(): QMetaClassInfoH; cdecl; external Qt5PasLib name 'QMetaClassInfo_Create';
procedure QMetaClassInfo_Destroy(handle: QMetaClassInfoH); cdecl; external Qt5PasLib name 'QMetaClassInfo_Destroy'; 
function QMetaClassInfo_name(handle: QMetaClassInfoH): PAnsiChar; cdecl; external Qt5PasLib name 'QMetaClassInfo_name';
function QMetaClassInfo_value(handle: QMetaClassInfoH): PAnsiChar; cdecl; external Qt5PasLib name 'QMetaClassInfo_value';
function QMetaClassInfo_enclosingMetaObject(handle: QMetaClassInfoH): QMetaObjectH; cdecl; external Qt5PasLib name 'QMetaClassInfo_enclosingMetaObject';

type
  QEventType = cardinal; //  QEvent::Type (4)

const
    QEventNone = 0 { $0 };
    QEventTimer = 1 { $1 };
    QEventMouseButtonPress = 2 { $2 };
    QEventMouseButtonRelease = 3 { $3 };
    QEventMouseButtonDblClick = 4 { $4 };
    QEventMouseMove = 5 { $5 };
    QEventKeyPress = 6 { $6 };
    QEventKeyRelease = 7 { $7 };
    QEventFocusIn = 8 { $8 };
    QEventFocusOut = 9 { $9 };
    QEventFocusAboutToChange = 23 { $17 };
    QEventEnter = 10 { $a };
    QEventLeave = 11 { $b };
    QEventPaint = 12 { $c };
    QEventMove = 13 { $d };
    QEventResize = 14 { $e };
    QEventCreate = 15 { $f };
    QEventDestroy = 16 { $10 };
    QEventShow = 17 { $11 };
    QEventHide = 18 { $12 };
    QEventClose = 19 { $13 };
    QEventQuit = 20 { $14 };
    QEventParentChange = 21 { $15 };
    QEventParentAboutToChange = 131 { $83 };
    QEventThreadChange = 22 { $16 };
    QEventWindowActivate = 24 { $18 };
    QEventWindowDeactivate = 25 { $19 };
    QEventShowToParent = 26 { $1a };
    QEventHideToParent = 27 { $1b };
    QEventWheel = 31 { $1f };
    QEventWindowTitleChange = 33 { $21 };
    QEventWindowIconChange = 34 { $22 };
    QEventApplicationWindowIconChange = 35 { $23 };
    QEventApplicationFontChange = 36 { $24 };
    QEventApplicationLayoutDirectionChange = 37 { $25 };
    QEventApplicationPaletteChange = 38 { $26 };
    QEventPaletteChange = 39 { $27 };
    QEventClipboard = 40 { $28 };
    QEventSpeech = 42 { $2a };
    QEventMetaCall = 43 { $2b };
    QEventSockAct = 50 { $32 };
    QEventWinEventAct = 132 { $84 };
    QEventDeferredDelete = 52 { $34 };
    QEventDragEnter = 60 { $3c };
    QEventDragMove = 61 { $3d };
    QEventDragLeave = 62 { $3e };
    QEventDrop = 63 { $3f };
    QEventDragResponse = 64 { $40 };
    QEventChildAdded = 68 { $44 };
    QEventChildPolished = 69 { $45 };
    QEventChildRemoved = 71 { $47 };
    QEventShowWindowRequest = 73 { $49 };
    QEventPolishRequest = 74 { $4a };
    QEventPolish = 75 { $4b };
    QEventLayoutRequest = 76 { $4c };
    QEventUpdateRequest = 77 { $4d };
    QEventUpdateLater = 78 { $4e };
    QEventEmbeddingControl = 79 { $4f };
    QEventActivateControl = 80 { $50 };
    QEventDeactivateControl = 81 { $51 };
    QEventContextMenu = 82 { $52 };
    QEventInputMethod = 83 { $53 };
    QEventTabletMove = 87 { $57 };
    QEventLocaleChange = 88 { $58 };
    QEventLanguageChange = 89 { $59 };
    QEventLayoutDirectionChange = 90 { $5a };
    QEventStyle = 91 { $5b };
    QEventTabletPress = 92 { $5c };
    QEventTabletRelease = 93 { $5d };
    QEventOkRequest = 94 { $5e };
    QEventHelpRequest = 95 { $5f };
    QEventIconDrag = 96 { $60 };
    QEventFontChange = 97 { $61 };
    QEventEnabledChange = 98 { $62 };
    QEventActivationChange = 99 { $63 };
    QEventStyleChange = 100 { $64 };
    QEventIconTextChange = 101 { $65 };
    QEventModifiedChange = 102 { $66 };
    QEventMouseTrackingChange = 109 { $6d };
    QEventWindowBlocked = 103 { $67 };
    QEventWindowUnblocked = 104 { $68 };
    QEventWindowStateChange = 105 { $69 };
    QEventToolTip = 110 { $6e };
    QEventWhatsThis = 111 { $6f };
    QEventStatusTip = 112 { $70 };
    QEventActionChanged = 113 { $71 };
    QEventActionAdded = 114 { $72 };
    QEventActionRemoved = 115 { $73 };
    QEventFileOpen = 116 { $74 };
    QEventShortcut = 117 { $75 };
    QEventShortcutOverride = 51 { $33 };
    QEventWhatsThisClicked = 118 { $76 };
    QEventToolBarChange = 120 { $78 };
    QEventApplicationActivate = 121 { $79 };
    QEventApplicationActivated = 121 { $79 };
    QEventApplicationDeactivate = 122 { $7a };
    QEventApplicationDeactivated = 122 { $7a };
    QEventQueryWhatsThis = 123 { $7b };
    QEventEnterWhatsThisMode = 124 { $7c };
    QEventLeaveWhatsThisMode = 125 { $7d };
    QEventZOrderChange = 126 { $7e };
    QEventHoverEnter = 127 { $7f };
    QEventHoverLeave = 128 { $80 };
    QEventHoverMove = 129 { $81 };
    QEventAcceptDropsChange = 152 { $98 };
    QEventZeroTimerEvent = 154 { $9a };
    QEventGraphicsSceneMouseMove = 155 { $9b };
    QEventGraphicsSceneMousePress = 156 { $9c };
    QEventGraphicsSceneMouseRelease = 157 { $9d };
    QEventGraphicsSceneMouseDoubleClick = 158 { $9e };
    QEventGraphicsSceneContextMenu = 159 { $9f };
    QEventGraphicsSceneHoverEnter = 160 { $a0 };
    QEventGraphicsSceneHoverMove = 161 { $a1 };
    QEventGraphicsSceneHoverLeave = 162 { $a2 };
    QEventGraphicsSceneHelp = 163 { $a3 };
    QEventGraphicsSceneDragEnter = 164 { $a4 };
    QEventGraphicsSceneDragMove = 165 { $a5 };
    QEventGraphicsSceneDragLeave = 166 { $a6 };
    QEventGraphicsSceneDrop = 167 { $a7 };
    QEventGraphicsSceneWheel = 168 { $a8 };
    QEventKeyboardLayoutChange = 169 { $a9 };
    QEventDynamicPropertyChange = 170 { $aa };
    QEventTabletEnterProximity = 171 { $ab };
    QEventTabletLeaveProximity = 172 { $ac };
    QEventNonClientAreaMouseMove = 173 { $ad };
    QEventNonClientAreaMouseButtonPress = 174 { $ae };
    QEventNonClientAreaMouseButtonRelease = 175 { $af };
    QEventNonClientAreaMouseButtonDblClick = 176 { $b0 };
    QEventMacSizeChange = 177 { $b1 };
    QEventContentsRectChange = 178 { $b2 };
    QEventMacGLWindowChange = 179 { $b3 };
    QEventFutureCallOut = 180 { $b4 };
    QEventGraphicsSceneResize = 181 { $b5 };
    QEventGraphicsSceneMove = 182 { $b6 };
    QEventCursorChange = 183 { $b7 };
    QEventToolTipChange = 184 { $b8 };
    QEventNetworkReplyUpdated = 185 { $b9 };
    QEventGrabMouse = 186 { $ba };
    QEventUngrabMouse = 187 { $bb };
    QEventGrabKeyboard = 188 { $bc };
    QEventUngrabKeyboard = 189 { $bd };
    QEventMacGLClearDrawable = 191 { $bf };
    QEventStateMachineSignal = 192 { $c0 };
    QEventStateMachineWrapped = 193 { $c1 };
    QEventTouchBegin = 194 { $c2 };
    QEventTouchUpdate = 195 { $c3 };
    QEventTouchEnd = 196 { $c4 };
    QEventNativeGesture = 197 { $c5 };
    QEventRequestSoftwareInputPanel = 199 { $c7 };
    QEventCloseSoftwareInputPanel = 200 { $c8 };
    QEventWinIdChange = 203 { $cb };
    QEventGesture = 198 { $c6 };
    QEventGestureOverride = 202 { $ca };
    QEventScrollPrepare = 204 { $cc };
    QEventScroll = 205 { $cd };
    QEventExpose = 206 { $ce };
    QEventInputMethodQuery = 207 { $cf };
    QEventOrientationChange = 208 { $d0 };
    QEventTouchCancel = 209 { $d1 };
    QEventThemeChange = 210 { $d2 };
    QEventSockClose = 211 { $d3 };
    QEventPlatformPanel = 212 { $d4 };
    QEventStyleAnimationUpdate = 213 { $d5 };
    QEventApplicationStateChange = 214 { $d6 };
    QEventUser = 1000 { $3e8 };
    QEventMaxUser = 65535 { $ffff };


function QEvent_Create(_type: QEventType): QEventH; cdecl; external Qt5PasLib name 'QEvent_Create';
procedure QEvent_Destroy(handle: QEventH); cdecl; external Qt5PasLib name 'QEvent_Destroy'; 
function QEvent_Create(other: QEventH): QEventH; cdecl; external Qt5PasLib name 'QEvent_Create2';
function QEvent_type(handle: QEventH): QEventType; cdecl; external Qt5PasLib name 'QEvent_type';
function QEvent_spontaneous(handle: QEventH): Boolean; cdecl; external Qt5PasLib name 'QEvent_spontaneous';
procedure QEvent_setAccepted(handle: QEventH; accepted: Boolean); cdecl; external Qt5PasLib name 'QEvent_setAccepted';
function QEvent_isAccepted(handle: QEventH): Boolean; cdecl; external Qt5PasLib name 'QEvent_isAccepted';
procedure QEvent_accept(handle: QEventH); cdecl; external Qt5PasLib name 'QEvent_accept';
procedure QEvent_ignore(handle: QEventH); cdecl; external Qt5PasLib name 'QEvent_ignore';
function QEvent_registerEventType(hint: Integer = -1): Integer; cdecl; external Qt5PasLib name 'QEvent_registerEventType';

function QTimerEvent_Create(timerId: Integer): QTimerEventH; cdecl; external Qt5PasLib name 'QTimerEvent_Create';
procedure QTimerEvent_Destroy(handle: QTimerEventH); cdecl; external Qt5PasLib name 'QTimerEvent_Destroy'; 
function QTimerEvent_timerId(handle: QTimerEventH): Integer; cdecl; external Qt5PasLib name 'QTimerEvent_timerId';

function QChildEvent_Create(_type: QEventType; child: QObjectH): QChildEventH; cdecl; external Qt5PasLib name 'QChildEvent_Create';
procedure QChildEvent_Destroy(handle: QChildEventH); cdecl; external Qt5PasLib name 'QChildEvent_Destroy'; 
function QChildEvent_child(handle: QChildEventH): QObjectH; cdecl; external Qt5PasLib name 'QChildEvent_child';
function QChildEvent_added(handle: QChildEventH): Boolean; cdecl; external Qt5PasLib name 'QChildEvent_added';
function QChildEvent_polished(handle: QChildEventH): Boolean; cdecl; external Qt5PasLib name 'QChildEvent_polished';
function QChildEvent_removed(handle: QChildEventH): Boolean; cdecl; external Qt5PasLib name 'QChildEvent_removed';

function QDynamicPropertyChangeEvent_Create(name: QByteArrayH): QDynamicPropertyChangeEventH; cdecl; external Qt5PasLib name 'QDynamicPropertyChangeEvent_Create';
procedure QDynamicPropertyChangeEvent_Destroy(handle: QDynamicPropertyChangeEventH); cdecl; external Qt5PasLib name 'QDynamicPropertyChangeEvent_Destroy'; 
procedure QDynamicPropertyChangeEvent_propertyName(handle: QDynamicPropertyChangeEventH; retval: QByteArrayH); cdecl; external Qt5PasLib name 'QDynamicPropertyChangeEvent_propertyName';

type
  QEventLoopProcessEventsFlag = cardinal; // QEventLoop::ProcessEventsFlag
  QEventLoopProcessEventsFlags = QEventLoopProcessEventsFlag; //QFlags<> (3)
const
  QEventLoopAllEvents =   $00;
  QEventLoopExcludeUserInputEvents =   $01;
  QEventLoopExcludeSocketNotifiers =   $02;
  QEventLoopWaitForMoreEvents =   $04;
  QEventLoopX11ExcludeTimers =   $08;
  QEventLoopEventLoopExec =   $20;
  QEventLoopDialogExec =   $40;

function QEventLoop_Create(parent: QObjectH = nil): QEventLoopH; cdecl; external Qt5PasLib name 'QEventLoop_Create';
procedure QEventLoop_Destroy(handle: QEventLoopH); cdecl; external Qt5PasLib name 'QEventLoop_Destroy'; 
function QEventLoop_processEvents(handle: QEventLoopH; flags: QEventLoopProcessEventsFlags = QEventLoopAllEvents): Boolean; cdecl; external Qt5PasLib name 'QEventLoop_processEvents';
procedure QEventLoop_processEvents(handle: QEventLoopH; flags: QEventLoopProcessEventsFlags; maximumTime: Integer); cdecl; external Qt5PasLib name 'QEventLoop_processEvents2';
function QEventLoop_exec(handle: QEventLoopH; flags: QEventLoopProcessEventsFlags = QEventLoopAllEvents): Integer; cdecl; external Qt5PasLib name 'QEventLoop_exec';
procedure QEventLoop_exit(handle: QEventLoopH; returnCode: Integer = 0); cdecl; external Qt5PasLib name 'QEventLoop_exit';
function QEventLoop_isRunning(handle: QEventLoopH): Boolean; cdecl; external Qt5PasLib name 'QEventLoop_isRunning';
procedure QEventLoop_wakeUp(handle: QEventLoopH); cdecl; external Qt5PasLib name 'QEventLoop_wakeUp';
function QEventLoop_event(handle: QEventLoopH; event: QEventH): Boolean; cdecl; external Qt5PasLib name 'QEventLoop_event';
procedure QEventLoop_quit(handle: QEventLoopH); cdecl; external Qt5PasLib name 'QEventLoop_quit';

function QEventLoopLocker_Create(): QEventLoopLockerH; cdecl; external Qt5PasLib name 'QEventLoopLocker_Create';
procedure QEventLoopLocker_Destroy(handle: QEventLoopLockerH); cdecl; external Qt5PasLib name 'QEventLoopLocker_Destroy'; 
function QEventLoopLocker_Create(loop: QEventLoopH): QEventLoopLockerH; cdecl; external Qt5PasLib name 'QEventLoopLocker_Create2';
function QEventLoopLocker_Create(thread: QThreadH): QEventLoopLockerH; cdecl; external Qt5PasLib name 'QEventLoopLocker_Create3';

function QCoreApplication_Create(argc: PInteger; argv: PPAnsiChar; AnonParam3: Integer = ApplicationFlags): QCoreApplicationH; cdecl; external Qt5PasLib name 'QCoreApplication_Create';
procedure QCoreApplication_Destroy(handle: QCoreApplicationH); cdecl; external Qt5PasLib name 'QCoreApplication_Destroy'; 
procedure QCoreApplication_arguments(retval: QStringListH); cdecl; external Qt5PasLib name 'QCoreApplication_arguments';
procedure QCoreApplication_setAttribute(attribute: QtApplicationAttribute; _on: Boolean = True); cdecl; external Qt5PasLib name 'QCoreApplication_setAttribute';
function QCoreApplication_testAttribute(attribute: QtApplicationAttribute): Boolean; cdecl; external Qt5PasLib name 'QCoreApplication_testAttribute';
procedure QCoreApplication_setOrganizationDomain(orgDomain: PWideString); cdecl; external Qt5PasLib name 'QCoreApplication_setOrganizationDomain';
procedure QCoreApplication_organizationDomain(retval: PWideString); cdecl; external Qt5PasLib name 'QCoreApplication_organizationDomain';
procedure QCoreApplication_setOrganizationName(orgName: PWideString); cdecl; external Qt5PasLib name 'QCoreApplication_setOrganizationName';
procedure QCoreApplication_organizationName(retval: PWideString); cdecl; external Qt5PasLib name 'QCoreApplication_organizationName';
procedure QCoreApplication_setApplicationName(application: PWideString); cdecl; external Qt5PasLib name 'QCoreApplication_setApplicationName';
procedure QCoreApplication_applicationName(retval: PWideString); cdecl; external Qt5PasLib name 'QCoreApplication_applicationName';
procedure QCoreApplication_setApplicationVersion(version: PWideString); cdecl; external Qt5PasLib name 'QCoreApplication_setApplicationVersion';
procedure QCoreApplication_applicationVersion(retval: PWideString); cdecl; external Qt5PasLib name 'QCoreApplication_applicationVersion';
function QCoreApplication_instance(): QCoreApplicationH; cdecl; external Qt5PasLib name 'QCoreApplication_instance';
function QCoreApplication_exec(): Integer; cdecl; external Qt5PasLib name 'QCoreApplication_exec';
procedure QCoreApplication_processEvents(flags: QEventLoopProcessEventsFlags = QEventLoopAllEvents); cdecl; external Qt5PasLib name 'QCoreApplication_processEvents';
procedure QCoreApplication_processEvents(flags: QEventLoopProcessEventsFlags; maxtime: Integer); cdecl; external Qt5PasLib name 'QCoreApplication_processEvents2';
procedure QCoreApplication_exit(retcode: Integer = 0); cdecl; external Qt5PasLib name 'QCoreApplication_exit';
function QCoreApplication_sendEvent(receiver: QObjectH; event: QEventH): Boolean; cdecl; external Qt5PasLib name 'QCoreApplication_sendEvent';
procedure QCoreApplication_postEvent(receiver: QObjectH; event: QEventH; priority: Integer = Integer(QtNormalEventPriority)); cdecl; external Qt5PasLib name 'QCoreApplication_postEvent';
procedure QCoreApplication_sendPostedEvents(receiver: QObjectH = nil; event_type: Integer = 0); cdecl; external Qt5PasLib name 'QCoreApplication_sendPostedEvents';
procedure QCoreApplication_removePostedEvents(receiver: QObjectH; eventType: Integer = 0); cdecl; external Qt5PasLib name 'QCoreApplication_removePostedEvents';
function QCoreApplication_hasPendingEvents(): Boolean; cdecl; external Qt5PasLib name 'QCoreApplication_hasPendingEvents';
function QCoreApplication_eventDispatcher(): QAbstractEventDispatcherH; cdecl; external Qt5PasLib name 'QCoreApplication_eventDispatcher';
procedure QCoreApplication_setEventDispatcher(eventDispatcher: QAbstractEventDispatcherH); cdecl; external Qt5PasLib name 'QCoreApplication_setEventDispatcher';
function QCoreApplication_notify(handle: QCoreApplicationH; AnonParam1: QObjectH; AnonParam2: QEventH): Boolean; cdecl; external Qt5PasLib name 'QCoreApplication_notify';
function QCoreApplication_startingUp(): Boolean; cdecl; external Qt5PasLib name 'QCoreApplication_startingUp';
function QCoreApplication_closingDown(): Boolean; cdecl; external Qt5PasLib name 'QCoreApplication_closingDown';
procedure QCoreApplication_applicationDirPath(retval: PWideString); cdecl; external Qt5PasLib name 'QCoreApplication_applicationDirPath';
procedure QCoreApplication_applicationFilePath(retval: PWideString); cdecl; external Qt5PasLib name 'QCoreApplication_applicationFilePath';
function QCoreApplication_applicationPid(): int64; cdecl; external Qt5PasLib name 'QCoreApplication_applicationPid';
procedure QCoreApplication_setLibraryPaths(AnonParam1: QStringListH); cdecl; external Qt5PasLib name 'QCoreApplication_setLibraryPaths';
procedure QCoreApplication_libraryPaths(retval: QStringListH); cdecl; external Qt5PasLib name 'QCoreApplication_libraryPaths';
procedure QCoreApplication_addLibraryPath(AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QCoreApplication_addLibraryPath';
procedure QCoreApplication_removeLibraryPath(AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QCoreApplication_removeLibraryPath';
function QCoreApplication_installTranslator(messageFile: QTranslatorH): Boolean; cdecl; external Qt5PasLib name 'QCoreApplication_installTranslator';
function QCoreApplication_removeTranslator(messageFile: QTranslatorH): Boolean; cdecl; external Qt5PasLib name 'QCoreApplication_removeTranslator';
procedure QCoreApplication_translate(retval: PWideString; context: PAnsiChar; key: PAnsiChar; disambiguation: PAnsiChar = nil; n: Integer = -1); cdecl; external Qt5PasLib name 'QCoreApplication_translate';
procedure QCoreApplication_flush(); cdecl; external Qt5PasLib name 'QCoreApplication_flush';
procedure QCoreApplication_installNativeEventFilter(handle: QCoreApplicationH; filterObj: QAbstractNativeEventFilterH); cdecl; external Qt5PasLib name 'QCoreApplication_installNativeEventFilter';
procedure QCoreApplication_removeNativeEventFilter(handle: QCoreApplicationH; filterObj: QAbstractNativeEventFilterH); cdecl; external Qt5PasLib name 'QCoreApplication_removeNativeEventFilter';
function QCoreApplication_isQuitLockEnabled(): Boolean; cdecl; external Qt5PasLib name 'QCoreApplication_isQuitLockEnabled';
procedure QCoreApplication_setQuitLockEnabled(enabled: Boolean); cdecl; external Qt5PasLib name 'QCoreApplication_setQuitLockEnabled';
procedure QCoreApplication_quit(); cdecl; external Qt5PasLib name 'QCoreApplication_quit';


type
  QCoreApplication_aboutToQuit_Event = procedure () of object cdecl;
  QCoreApplication_organizationNameChanged_Event = procedure () of object cdecl;
  QCoreApplication_organizationDomainChanged_Event = procedure () of object cdecl;
  QCoreApplication_applicationNameChanged_Event = procedure () of object cdecl;
  QCoreApplication_applicationVersionChanged_Event = procedure () of object cdecl;


function QTranslator_Create(parent: QObjectH = nil): QTranslatorH; cdecl; external Qt5PasLib name 'QTranslator_Create';
procedure QTranslator_Destroy(handle: QTranslatorH); cdecl; external Qt5PasLib name 'QTranslator_Destroy'; 
procedure QTranslator_translate(handle: QTranslatorH; retval: PWideString; context: PAnsiChar; sourceText: PAnsiChar; disambiguation: PAnsiChar = nil; n: Integer = -1); cdecl; external Qt5PasLib name 'QTranslator_translate';
function QTranslator_isEmpty(handle: QTranslatorH): Boolean; cdecl; external Qt5PasLib name 'QTranslator_isEmpty';
function QTranslator_load(handle: QTranslatorH; filename: PWideString; directory: PWideString = nil; search_delimiters: PWideString = nil; suffix: PWideString = nil): Boolean; cdecl; external Qt5PasLib name 'QTranslator_load';
function QTranslator_load(handle: QTranslatorH; locale: QLocaleH; filename: PWideString; prefix: PWideString = nil; directory: PWideString = nil; suffix: PWideString = nil): Boolean; cdecl; external Qt5PasLib name 'QTranslator_load2';
function QTranslator_load(handle: QTranslatorH; data: PByte; len: Integer; directory: PWideString = nil): Boolean; cdecl; external Qt5PasLib name 'QTranslator_load3';

type
  QTimer_timeout_Event = procedure () of object cdecl;

function QTimer_Create(parent: QObjectH = nil): QTimerH; cdecl; external Qt5PasLib name 'QTimer_Create';
procedure QTimer_Destroy(handle: QTimerH); cdecl; external Qt5PasLib name 'QTimer_Destroy'; 
function QTimer_isActive(handle: QTimerH): Boolean; cdecl; external Qt5PasLib name 'QTimer_isActive';
function QTimer_timerId(handle: QTimerH): Integer; cdecl; external Qt5PasLib name 'QTimer_timerId';
procedure QTimer_setInterval(handle: QTimerH; msec: Integer); cdecl; external Qt5PasLib name 'QTimer_setInterval';
function QTimer_interval(handle: QTimerH): Integer; cdecl; external Qt5PasLib name 'QTimer_interval';
function QTimer_remainingTime(handle: QTimerH): Integer; cdecl; external Qt5PasLib name 'QTimer_remainingTime';
procedure QTimer_setTimerType(handle: QTimerH; atype: QtTimerType); cdecl; external Qt5PasLib name 'QTimer_setTimerType';
function QTimer_timerType(handle: QTimerH): QtTimerType; cdecl; external Qt5PasLib name 'QTimer_timerType';
procedure QTimer_setSingleShot(handle: QTimerH; singleShot: Boolean); cdecl; external Qt5PasLib name 'QTimer_setSingleShot';
function QTimer_isSingleShot(handle: QTimerH): Boolean; cdecl; external Qt5PasLib name 'QTimer_isSingleShot';
procedure QTimer_singleShot(msec: Integer; receiver: QObjectH; member: PAnsiChar); cdecl; external Qt5PasLib name 'QTimer_singleShot';
procedure QTimer_singleShot(msec: Integer; timerType: QtTimerType; receiver: QObjectH; member: PAnsiChar); cdecl; external Qt5PasLib name 'QTimer_singleShot2';
procedure QTimer_singleShot(msec: Integer; timeoutEvent: QTimer_timeout_Event); cdecl; external Qt5PasLib name 'QTimer_singleShot3';
procedure QTimer_start(handle: QTimerH; msec: Integer); cdecl; external Qt5PasLib name 'QTimer_start';
procedure QTimer_start(handle: QTimerH); cdecl; external Qt5PasLib name 'QTimer_start2';
procedure QTimer_stop(handle: QTimerH); cdecl; external Qt5PasLib name 'QTimer_stop';


function QAbstractEventDispatcher_instance(thread: QThreadH = nil): QAbstractEventDispatcherH; cdecl; external Qt5PasLib name 'QAbstractEventDispatcher_instance';
function QAbstractEventDispatcher_processEvents(handle: QAbstractEventDispatcherH; flags: QEventLoopProcessEventsFlags): Boolean; cdecl; external Qt5PasLib name 'QAbstractEventDispatcher_processEvents';
function QAbstractEventDispatcher_hasPendingEvents(handle: QAbstractEventDispatcherH): Boolean; cdecl; external Qt5PasLib name 'QAbstractEventDispatcher_hasPendingEvents';
procedure QAbstractEventDispatcher_registerSocketNotifier(handle: QAbstractEventDispatcherH; notifier: QSocketNotifierH); cdecl; external Qt5PasLib name 'QAbstractEventDispatcher_registerSocketNotifier';
procedure QAbstractEventDispatcher_unregisterSocketNotifier(handle: QAbstractEventDispatcherH; notifier: QSocketNotifierH); cdecl; external Qt5PasLib name 'QAbstractEventDispatcher_unregisterSocketNotifier';
function QAbstractEventDispatcher_registerTimer(handle: QAbstractEventDispatcherH; interval: Integer; timerType: QtTimerType; _object: QObjectH): Integer; cdecl; external Qt5PasLib name 'QAbstractEventDispatcher_registerTimer';
procedure QAbstractEventDispatcher_registerTimer(handle: QAbstractEventDispatcherH; timerId: Integer; interval: Integer; timerType: QtTimerType; _object: QObjectH); cdecl; external Qt5PasLib name 'QAbstractEventDispatcher_registerTimer2';
function QAbstractEventDispatcher_unregisterTimer(handle: QAbstractEventDispatcherH; timerId: Integer): Boolean; cdecl; external Qt5PasLib name 'QAbstractEventDispatcher_unregisterTimer';
function QAbstractEventDispatcher_unregisterTimers(handle: QAbstractEventDispatcherH; _object: QObjectH): Boolean; cdecl; external Qt5PasLib name 'QAbstractEventDispatcher_unregisterTimers';
function QAbstractEventDispatcher_remainingTime(handle: QAbstractEventDispatcherH; timerId: Integer): Integer; cdecl; external Qt5PasLib name 'QAbstractEventDispatcher_remainingTime';
procedure QAbstractEventDispatcher_wakeUp(handle: QAbstractEventDispatcherH); cdecl; external Qt5PasLib name 'QAbstractEventDispatcher_wakeUp';
procedure QAbstractEventDispatcher_interrupt(handle: QAbstractEventDispatcherH); cdecl; external Qt5PasLib name 'QAbstractEventDispatcher_interrupt';
procedure QAbstractEventDispatcher_flush(handle: QAbstractEventDispatcherH); cdecl; external Qt5PasLib name 'QAbstractEventDispatcher_flush';
procedure QAbstractEventDispatcher_startingUp(handle: QAbstractEventDispatcherH); cdecl; external Qt5PasLib name 'QAbstractEventDispatcher_startingUp';
procedure QAbstractEventDispatcher_closingDown(handle: QAbstractEventDispatcherH); cdecl; external Qt5PasLib name 'QAbstractEventDispatcher_closingDown';
procedure QAbstractEventDispatcher_installNativeEventFilter(handle: QAbstractEventDispatcherH; filterObj: QAbstractNativeEventFilterH); cdecl; external Qt5PasLib name 'QAbstractEventDispatcher_installNativeEventFilter';
procedure QAbstractEventDispatcher_removeNativeEventFilter(handle: QAbstractEventDispatcherH; filterObj: QAbstractNativeEventFilterH); cdecl; external Qt5PasLib name 'QAbstractEventDispatcher_removeNativeEventFilter';
function QAbstractEventDispatcher_filterNativeEvent(handle: QAbstractEventDispatcherH; eventType: QByteArrayH; message: Pointer; result: PLong): Boolean; cdecl; external Qt5PasLib name 'QAbstractEventDispatcher_filterNativeEvent';
{$ifdef MSWINDOWS }
function QAbstractEventDispatcher_registerEventNotifier(handle: QAbstractEventDispatcherH; notifier: QWinEventNotifierH): Boolean; cdecl; external Qt5PasLib name 'QAbstractEventDispatcher_registerEventNotifier';
procedure QAbstractEventDispatcher_unregisterEventNotifier(handle: QAbstractEventDispatcherH; notifier: QWinEventNotifierH); cdecl; external Qt5PasLib name 'QAbstractEventDispatcher_unregisterEventNotifier';
{$endif}

function QMimeData_Create(): QMimeDataH; cdecl; external Qt5PasLib name 'QMimeData_Create';
procedure QMimeData_Destroy(handle: QMimeDataH); cdecl; external Qt5PasLib name 'QMimeData_Destroy'; 
function QMimeData_hasUrls(handle: QMimeDataH): Boolean; cdecl; external Qt5PasLib name 'QMimeData_hasUrls';
procedure QMimeData_text(handle: QMimeDataH; retval: PWideString); cdecl; external Qt5PasLib name 'QMimeData_text';
procedure QMimeData_setText(handle: QMimeDataH; text: PWideString); cdecl; external Qt5PasLib name 'QMimeData_setText';
function QMimeData_hasText(handle: QMimeDataH): Boolean; cdecl; external Qt5PasLib name 'QMimeData_hasText';
procedure QMimeData_html(handle: QMimeDataH; retval: PWideString); cdecl; external Qt5PasLib name 'QMimeData_html';
procedure QMimeData_setHtml(handle: QMimeDataH; html: PWideString); cdecl; external Qt5PasLib name 'QMimeData_setHtml';
function QMimeData_hasHtml(handle: QMimeDataH): Boolean; cdecl; external Qt5PasLib name 'QMimeData_hasHtml';
procedure QMimeData_imageData(handle: QMimeDataH; retval: QVariantH); cdecl; external Qt5PasLib name 'QMimeData_imageData';
procedure QMimeData_setImageData(handle: QMimeDataH; image: QVariantH); cdecl; external Qt5PasLib name 'QMimeData_setImageData';
function QMimeData_hasImage(handle: QMimeDataH): Boolean; cdecl; external Qt5PasLib name 'QMimeData_hasImage';
procedure QMimeData_colorData(handle: QMimeDataH; retval: QVariantH); cdecl; external Qt5PasLib name 'QMimeData_colorData';
procedure QMimeData_setColorData(handle: QMimeDataH; color: QVariantH); cdecl; external Qt5PasLib name 'QMimeData_setColorData';
function QMimeData_hasColor(handle: QMimeDataH): Boolean; cdecl; external Qt5PasLib name 'QMimeData_hasColor';
procedure QMimeData_data(handle: QMimeDataH; retval: QByteArrayH; mimetype: PWideString); cdecl; external Qt5PasLib name 'QMimeData_data';
procedure QMimeData_setData(handle: QMimeDataH; mimetype: PWideString; data: QByteArrayH); cdecl; external Qt5PasLib name 'QMimeData_setData';
procedure QMimeData_removeFormat(handle: QMimeDataH; mimetype: PWideString); cdecl; external Qt5PasLib name 'QMimeData_removeFormat';
function QMimeData_hasFormat(handle: QMimeDataH; mimetype: PWideString): Boolean; cdecl; external Qt5PasLib name 'QMimeData_hasFormat';
procedure QMimeData_formats(handle: QMimeDataH; retval: QStringListH); cdecl; external Qt5PasLib name 'QMimeData_formats';
procedure QMimeData_clear(handle: QMimeDataH); cdecl; external Qt5PasLib name 'QMimeData_clear';


type
  QSocketNotifierType = ( // QSocketNotifier::Type (1)
    QSocketNotifierRead, QSocketNotifierWrite, QSocketNotifierException );

function QSocketNotifier_Create(socket: PtrInt; AnonParam2: QSocketNotifierType; parent: QObjectH = nil): QSocketNotifierH; cdecl; external Qt5PasLib name 'QSocketNotifier_Create';
procedure QSocketNotifier_Destroy(handle: QSocketNotifierH); cdecl; external Qt5PasLib name 'QSocketNotifier_Destroy'; 
function QSocketNotifier_socket(handle: QSocketNotifierH): PtrInt; cdecl; external Qt5PasLib name 'QSocketNotifier_socket';
function QSocketNotifier_type(handle: QSocketNotifierH): QSocketNotifierType; cdecl; external Qt5PasLib name 'QSocketNotifier_type';
function QSocketNotifier_isEnabled(handle: QSocketNotifierH): Boolean; cdecl; external Qt5PasLib name 'QSocketNotifier_isEnabled';
procedure QSocketNotifier_setEnabled(handle: QSocketNotifierH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QSocketNotifier_setEnabled';


type
  QSocketNotifier_activated_Event = procedure (socket: Integer) of object cdecl;


function QModelIndex_Create(): QModelIndexH; cdecl; external Qt5PasLib name 'QModelIndex_Create';
procedure QModelIndex_Destroy(handle: QModelIndexH); cdecl; external Qt5PasLib name 'QModelIndex_Destroy'; 
function QModelIndex_row(handle: QModelIndexH): Integer; cdecl; external Qt5PasLib name 'QModelIndex_row';
function QModelIndex_column(handle: QModelIndexH): Integer; cdecl; external Qt5PasLib name 'QModelIndex_column';
function QModelIndex_internalId(handle: QModelIndexH): PtrUInt; cdecl; external Qt5PasLib name 'QModelIndex_internalId';
function QModelIndex_internalPointer(handle: QModelIndexH): Pointer; cdecl; external Qt5PasLib name 'QModelIndex_internalPointer';
procedure QModelIndex_parent(handle: QModelIndexH; retval: QModelIndexH); cdecl; external Qt5PasLib name 'QModelIndex_parent';
procedure QModelIndex_sibling(handle: QModelIndexH; retval: QModelIndexH; row: Integer; column: Integer); cdecl; external Qt5PasLib name 'QModelIndex_sibling';
procedure QModelIndex_child(handle: QModelIndexH; retval: QModelIndexH; row: Integer; column: Integer); cdecl; external Qt5PasLib name 'QModelIndex_child';
procedure QModelIndex_data(handle: QModelIndexH; retval: QVariantH; role: QtItemDataRole = QtDisplayRole); cdecl; external Qt5PasLib name 'QModelIndex_data';
function QModelIndex_flags(handle: QModelIndexH): QtItemFlags; cdecl; external Qt5PasLib name 'QModelIndex_flags';
function QModelIndex_model(handle: QModelIndexH): QAbstractItemModelH; cdecl; external Qt5PasLib name 'QModelIndex_model';
function QModelIndex_isValid(handle: QModelIndexH): Boolean; cdecl; external Qt5PasLib name 'QModelIndex_isValid';

function QPersistentModelIndex_Create(): QPersistentModelIndexH; cdecl; external Qt5PasLib name 'QPersistentModelIndex_Create';
procedure QPersistentModelIndex_Destroy(handle: QPersistentModelIndexH); cdecl; external Qt5PasLib name 'QPersistentModelIndex_Destroy'; 
function QPersistentModelIndex_Create(index: QModelIndexH): QPersistentModelIndexH; cdecl; external Qt5PasLib name 'QPersistentModelIndex_Create2';
function QPersistentModelIndex_Create(other: QPersistentModelIndexH): QPersistentModelIndexH; cdecl; external Qt5PasLib name 'QPersistentModelIndex_Create3';
procedure QPersistentModelIndex_swap(handle: QPersistentModelIndexH; other: QPersistentModelIndexH); cdecl; external Qt5PasLib name 'QPersistentModelIndex_swap';
function QPersistentModelIndex_row(handle: QPersistentModelIndexH): Integer; cdecl; external Qt5PasLib name 'QPersistentModelIndex_row';
function QPersistentModelIndex_column(handle: QPersistentModelIndexH): Integer; cdecl; external Qt5PasLib name 'QPersistentModelIndex_column';
function QPersistentModelIndex_internalPointer(handle: QPersistentModelIndexH): Pointer; cdecl; external Qt5PasLib name 'QPersistentModelIndex_internalPointer';
function QPersistentModelIndex_internalId(handle: QPersistentModelIndexH): PtrUInt; cdecl; external Qt5PasLib name 'QPersistentModelIndex_internalId';
procedure QPersistentModelIndex_parent(handle: QPersistentModelIndexH; retval: QModelIndexH); cdecl; external Qt5PasLib name 'QPersistentModelIndex_parent';
procedure QPersistentModelIndex_sibling(handle: QPersistentModelIndexH; retval: QModelIndexH; row: Integer; column: Integer); cdecl; external Qt5PasLib name 'QPersistentModelIndex_sibling';
procedure QPersistentModelIndex_child(handle: QPersistentModelIndexH; retval: QModelIndexH; row: Integer; column: Integer); cdecl; external Qt5PasLib name 'QPersistentModelIndex_child';
procedure QPersistentModelIndex_data(handle: QPersistentModelIndexH; retval: QVariantH; role: QtItemDataRole = QtDisplayRole); cdecl; external Qt5PasLib name 'QPersistentModelIndex_data';
function QPersistentModelIndex_flags(handle: QPersistentModelIndexH): QtItemFlags; cdecl; external Qt5PasLib name 'QPersistentModelIndex_flags';
function QPersistentModelIndex_model(handle: QPersistentModelIndexH): QAbstractItemModelH; cdecl; external Qt5PasLib name 'QPersistentModelIndex_model';
function QPersistentModelIndex_isValid(handle: QPersistentModelIndexH): Boolean; cdecl; external Qt5PasLib name 'QPersistentModelIndex_isValid';

function QAbstractItemModel_hasIndex(handle: QAbstractItemModelH; row: Integer; column: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemModel_hasIndex';
procedure QAbstractItemModel_index(handle: QAbstractItemModelH; retval: QModelIndexH; row: Integer; column: Integer; parent: QModelIndexH = nil); cdecl; external Qt5PasLib name 'QAbstractItemModel_index';
procedure QAbstractItemModel_parent(handle: QAbstractItemModelH; retval: QModelIndexH; child: QModelIndexH); cdecl; external Qt5PasLib name 'QAbstractItemModel_parent';
procedure QAbstractItemModel_sibling(handle: QAbstractItemModelH; retval: QModelIndexH; row: Integer; column: Integer; idx: QModelIndexH); cdecl; external Qt5PasLib name 'QAbstractItemModel_sibling';
function QAbstractItemModel_rowCount(handle: QAbstractItemModelH; parent: QModelIndexH = nil): Integer; cdecl; external Qt5PasLib name 'QAbstractItemModel_rowCount';
function QAbstractItemModel_columnCount(handle: QAbstractItemModelH; parent: QModelIndexH = nil): Integer; cdecl; external Qt5PasLib name 'QAbstractItemModel_columnCount';
function QAbstractItemModel_hasChildren(handle: QAbstractItemModelH; parent: QModelIndexH = nil): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemModel_hasChildren';
procedure QAbstractItemModel_data(handle: QAbstractItemModelH; retval: QVariantH; index: QModelIndexH; role: QtItemDataRole = QtDisplayRole); cdecl; external Qt5PasLib name 'QAbstractItemModel_data';
function QAbstractItemModel_setData(handle: QAbstractItemModelH; index: QModelIndexH; value: QVariantH; role: QtItemDataRole = QtEditRole): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemModel_setData';
procedure QAbstractItemModel_headerData(handle: QAbstractItemModelH; retval: QVariantH; section: Integer; orientation: QtOrientation; role: QtItemDataRole = QtDisplayRole); cdecl; external Qt5PasLib name 'QAbstractItemModel_headerData';
function QAbstractItemModel_setHeaderData(handle: QAbstractItemModelH; section: Integer; orientation: QtOrientation; value: QVariantH; role: QtItemDataRole = QtEditRole): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemModel_setHeaderData';
procedure QAbstractItemModel_mimeTypes(handle: QAbstractItemModelH; retval: QStringListH); cdecl; external Qt5PasLib name 'QAbstractItemModel_mimeTypes';
function QAbstractItemModel_canDropMimeData(handle: QAbstractItemModelH; data: QMimeDataH; action: QtDropAction; row: Integer; column: Integer; parent: QModelIndexH): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemModel_canDropMimeData';
function QAbstractItemModel_dropMimeData(handle: QAbstractItemModelH; data: QMimeDataH; action: QtDropAction; row: Integer; column: Integer; parent: QModelIndexH): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemModel_dropMimeData';
function QAbstractItemModel_supportedDropActions(handle: QAbstractItemModelH): QtDropActions; cdecl; external Qt5PasLib name 'QAbstractItemModel_supportedDropActions';
function QAbstractItemModel_supportedDragActions(handle: QAbstractItemModelH): QtDropActions; cdecl; external Qt5PasLib name 'QAbstractItemModel_supportedDragActions';
function QAbstractItemModel_insertRows(handle: QAbstractItemModelH; row: Integer; count: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemModel_insertRows';
function QAbstractItemModel_insertColumns(handle: QAbstractItemModelH; column: Integer; count: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemModel_insertColumns';
function QAbstractItemModel_removeRows(handle: QAbstractItemModelH; row: Integer; count: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemModel_removeRows';
function QAbstractItemModel_removeColumns(handle: QAbstractItemModelH; column: Integer; count: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemModel_removeColumns';
function QAbstractItemModel_moveRows(handle: QAbstractItemModelH; sourceParent: QModelIndexH; sourceRow: Integer; count: Integer; destinationParent: QModelIndexH; destinationChild: Integer): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemModel_moveRows';
function QAbstractItemModel_moveColumns(handle: QAbstractItemModelH; sourceParent: QModelIndexH; sourceColumn: Integer; count: Integer; destinationParent: QModelIndexH; destinationChild: Integer): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemModel_moveColumns';
function QAbstractItemModel_insertRow(handle: QAbstractItemModelH; row: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemModel_insertRow';
function QAbstractItemModel_insertColumn(handle: QAbstractItemModelH; column: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemModel_insertColumn';
function QAbstractItemModel_removeRow(handle: QAbstractItemModelH; row: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemModel_removeRow';
function QAbstractItemModel_removeColumn(handle: QAbstractItemModelH; column: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemModel_removeColumn';
function QAbstractItemModel_moveRow(handle: QAbstractItemModelH; sourceParent: QModelIndexH; sourceRow: Integer; destinationParent: QModelIndexH; destinationChild: Integer): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemModel_moveRow';
function QAbstractItemModel_moveColumn(handle: QAbstractItemModelH; sourceParent: QModelIndexH; sourceColumn: Integer; destinationParent: QModelIndexH; destinationChild: Integer): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemModel_moveColumn';
procedure QAbstractItemModel_fetchMore(handle: QAbstractItemModelH; parent: QModelIndexH); cdecl; external Qt5PasLib name 'QAbstractItemModel_fetchMore';
function QAbstractItemModel_canFetchMore(handle: QAbstractItemModelH; parent: QModelIndexH): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemModel_canFetchMore';
function QAbstractItemModel_flags(handle: QAbstractItemModelH; index: QModelIndexH): QtItemFlags; cdecl; external Qt5PasLib name 'QAbstractItemModel_flags';
procedure QAbstractItemModel_sort(handle: QAbstractItemModelH; column: Integer; order: QtSortOrder = QtAscendingOrder); cdecl; external Qt5PasLib name 'QAbstractItemModel_sort';
procedure QAbstractItemModel_buddy(handle: QAbstractItemModelH; retval: QModelIndexH; index: QModelIndexH); cdecl; external Qt5PasLib name 'QAbstractItemModel_buddy';
procedure QAbstractItemModel_match(handle: QAbstractItemModelH; retval: PPtrIntArray; start: QModelIndexH; role: Integer; value: QVariantH; hits: Integer; flags: QtMatchFlags); cdecl; external Qt5PasLib name 'QAbstractItemModel_match';
procedure QAbstractItemModel_span(handle: QAbstractItemModelH; retval: PSize; index: QModelIndexH); cdecl; external Qt5PasLib name 'QAbstractItemModel_span';
function QAbstractItemModel_submit(handle: QAbstractItemModelH): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemModel_submit';
procedure QAbstractItemModel_revert(handle: QAbstractItemModelH); cdecl; external Qt5PasLib name 'QAbstractItemModel_revert';

procedure QAbstractTableModel_index(handle: QAbstractTableModelH; retval: QModelIndexH; row: Integer; column: Integer; parent: QModelIndexH = nil); cdecl; external Qt5PasLib name 'QAbstractTableModel_index';
function QAbstractTableModel_dropMimeData(handle: QAbstractTableModelH; data: QMimeDataH; action: QtDropAction; row: Integer; column: Integer; parent: QModelIndexH): Boolean; cdecl; external Qt5PasLib name 'QAbstractTableModel_dropMimeData';
function QAbstractTableModel_flags(handle: QAbstractTableModelH; index: QModelIndexH): QtItemFlags; cdecl; external Qt5PasLib name 'QAbstractTableModel_flags';

procedure QAbstractListModel_index(handle: QAbstractListModelH; retval: QModelIndexH; row: Integer; column: Integer = 0; parent: QModelIndexH = nil); cdecl; external Qt5PasLib name 'QAbstractListModel_index';
function QAbstractListModel_dropMimeData(handle: QAbstractListModelH; data: QMimeDataH; action: QtDropAction; row: Integer; column: Integer; parent: QModelIndexH): Boolean; cdecl; external Qt5PasLib name 'QAbstractListModel_dropMimeData';
function QAbstractListModel_flags(handle: QAbstractListModelH; index: QModelIndexH): QtItemFlags; cdecl; external Qt5PasLib name 'QAbstractListModel_flags';


type
  QAbstractItemModel_dataChanged_Event = procedure (topLeft: QModelIndexH; bottomRight: QModelIndexH) of object cdecl;
  QAbstractItemModel_headerDataChanged_Event = procedure (orientation: QtOrientation; first: Integer; last: Integer) of object cdecl;
  QAbstractItemModel_layoutChanged_Event = procedure () of object cdecl;
  QAbstractItemModel_layoutAboutToBeChanged_Event = procedure () of object cdecl;
  QAbstractItemModel_rowsAboutToBeInserted_Event = procedure (parent: QModelIndexH; first: Integer; last: Integer) of object cdecl;
  QAbstractItemModel_rowsInserted_Event = procedure (parent: QModelIndexH; first: Integer; last: Integer) of object cdecl;
  QAbstractItemModel_rowsAboutToBeRemoved_Event = procedure (parent: QModelIndexH; first: Integer; last: Integer) of object cdecl;
  QAbstractItemModel_rowsRemoved_Event = procedure (parent: QModelIndexH; first: Integer; last: Integer) of object cdecl;
  QAbstractItemModel_columnsAboutToBeInserted_Event = procedure (parent: QModelIndexH; first: Integer; last: Integer) of object cdecl;
  QAbstractItemModel_columnsInserted_Event = procedure (parent: QModelIndexH; first: Integer; last: Integer) of object cdecl;
  QAbstractItemModel_columnsAboutToBeRemoved_Event = procedure (parent: QModelIndexH; first: Integer; last: Integer) of object cdecl;
  QAbstractItemModel_columnsRemoved_Event = procedure (parent: QModelIndexH; first: Integer; last: Integer) of object cdecl;
  QAbstractItemModel_modelAboutToBeReset_Event = procedure () of object cdecl;
  QAbstractItemModel_modelReset_Event = procedure () of object cdecl;
  QAbstractItemModel_rowsAboutToBeMoved_Event = procedure (sourceParent: QModelIndexH; sourceStart: Integer; sourceEnd: Integer; destinationParent: QModelIndexH; destinationRow: Integer) of object cdecl;
  QAbstractItemModel_rowsMoved_Event = procedure (parent: QModelIndexH; start: Integer; _end: Integer; destination: QModelIndexH; row: Integer) of object cdecl;
  QAbstractItemModel_columnsAboutToBeMoved_Event = procedure (sourceParent: QModelIndexH; sourceStart: Integer; sourceEnd: Integer; destinationParent: QModelIndexH; destinationColumn: Integer) of object cdecl;
  QAbstractItemModel_columnsMoved_Event = procedure (parent: QModelIndexH; start: Integer; _end: Integer; destination: QModelIndexH; column: Integer) of object cdecl;


type
  QItemSelectionModelSelectionFlag = cardinal; //  QItemSelectionModel::SelectionFlag (4)
  QItemSelectionModelSelectionFlags = QItemSelectionModelSelectionFlag; // QFlags<>

const
    QItemSelectionModelNoUpdate = 0 { $0 };
    QItemSelectionModelClear = 1 { $1 };
    QItemSelectionModelSelect = 2 { $2 };
    QItemSelectionModelDeselect = 4 { $4 };
    QItemSelectionModelToggle = 8 { $8 };
    QItemSelectionModelCurrent = 16 { $10 };
    QItemSelectionModelRows = 32 { $20 };
    QItemSelectionModelColumns = 64 { $40 };
    QItemSelectionModelSelectCurrent = 18 { $12 };
    QItemSelectionModelToggleCurrent = 24 { $18 };
    QItemSelectionModelClearAndSelect = 3 { $3 };


function QItemSelectionRange_Create(): QItemSelectionRangeH; cdecl; external Qt5PasLib name 'QItemSelectionRange_Create';
procedure QItemSelectionRange_Destroy(handle: QItemSelectionRangeH); cdecl; external Qt5PasLib name 'QItemSelectionRange_Destroy'; 
function QItemSelectionRange_Create(other: QItemSelectionRangeH): QItemSelectionRangeH; cdecl; external Qt5PasLib name 'QItemSelectionRange_Create2';
function QItemSelectionRange_Create(topLeft: QModelIndexH; bottomRight: QModelIndexH): QItemSelectionRangeH; cdecl; external Qt5PasLib name 'QItemSelectionRange_Create3';
function QItemSelectionRange_Create(index: QModelIndexH): QItemSelectionRangeH; cdecl; external Qt5PasLib name 'QItemSelectionRange_Create4';
function QItemSelectionRange_top(handle: QItemSelectionRangeH): Integer; cdecl; external Qt5PasLib name 'QItemSelectionRange_top';
function QItemSelectionRange_left(handle: QItemSelectionRangeH): Integer; cdecl; external Qt5PasLib name 'QItemSelectionRange_left';
function QItemSelectionRange_bottom(handle: QItemSelectionRangeH): Integer; cdecl; external Qt5PasLib name 'QItemSelectionRange_bottom';
function QItemSelectionRange_right(handle: QItemSelectionRangeH): Integer; cdecl; external Qt5PasLib name 'QItemSelectionRange_right';
function QItemSelectionRange_width(handle: QItemSelectionRangeH): Integer; cdecl; external Qt5PasLib name 'QItemSelectionRange_width';
function QItemSelectionRange_height(handle: QItemSelectionRangeH): Integer; cdecl; external Qt5PasLib name 'QItemSelectionRange_height';
function QItemSelectionRange_topLeft(handle: QItemSelectionRangeH): QPersistentModelIndexH; cdecl; external Qt5PasLib name 'QItemSelectionRange_topLeft';
function QItemSelectionRange_bottomRight(handle: QItemSelectionRangeH): QPersistentModelIndexH; cdecl; external Qt5PasLib name 'QItemSelectionRange_bottomRight';
procedure QItemSelectionRange_parent(handle: QItemSelectionRangeH; retval: QModelIndexH); cdecl; external Qt5PasLib name 'QItemSelectionRange_parent';
function QItemSelectionRange_model(handle: QItemSelectionRangeH): QAbstractItemModelH; cdecl; external Qt5PasLib name 'QItemSelectionRange_model';
function QItemSelectionRange_contains(handle: QItemSelectionRangeH; index: QModelIndexH): Boolean; cdecl; external Qt5PasLib name 'QItemSelectionRange_contains';
function QItemSelectionRange_contains(handle: QItemSelectionRangeH; row: Integer; column: Integer; parentIndex: QModelIndexH): Boolean; cdecl; external Qt5PasLib name 'QItemSelectionRange_contains2';
function QItemSelectionRange_intersects(handle: QItemSelectionRangeH; other: QItemSelectionRangeH): Boolean; cdecl; external Qt5PasLib name 'QItemSelectionRange_intersects';
procedure QItemSelectionRange_intersected(handle: QItemSelectionRangeH; retval: QItemSelectionRangeH; other: QItemSelectionRangeH); cdecl; external Qt5PasLib name 'QItemSelectionRange_intersected';
function QItemSelectionRange_isValid(handle: QItemSelectionRangeH): Boolean; cdecl; external Qt5PasLib name 'QItemSelectionRange_isValid';
function QItemSelectionRange_isEmpty(handle: QItemSelectionRangeH): Boolean; cdecl; external Qt5PasLib name 'QItemSelectionRange_isEmpty';
procedure QItemSelectionRange_indexes(handle: QItemSelectionRangeH; retval: PPtrIntArray); cdecl; external Qt5PasLib name 'QItemSelectionRange_indexes';

function QItemSelectionModel_Create(model: QAbstractItemModelH): QItemSelectionModelH; cdecl; external Qt5PasLib name 'QItemSelectionModel_Create';
procedure QItemSelectionModel_Destroy(handle: QItemSelectionModelH); cdecl; external Qt5PasLib name 'QItemSelectionModel_Destroy'; 
function QItemSelectionModel_Create(model: QAbstractItemModelH; parent: QObjectH): QItemSelectionModelH; cdecl; external Qt5PasLib name 'QItemSelectionModel_Create2';
procedure QItemSelectionModel_currentIndex(handle: QItemSelectionModelH; retval: QModelIndexH); cdecl; external Qt5PasLib name 'QItemSelectionModel_currentIndex';
function QItemSelectionModel_isSelected(handle: QItemSelectionModelH; index: QModelIndexH): Boolean; cdecl; external Qt5PasLib name 'QItemSelectionModel_isSelected';
function QItemSelectionModel_isRowSelected(handle: QItemSelectionModelH; row: Integer; parent: QModelIndexH): Boolean; cdecl; external Qt5PasLib name 'QItemSelectionModel_isRowSelected';
function QItemSelectionModel_isColumnSelected(handle: QItemSelectionModelH; column: Integer; parent: QModelIndexH): Boolean; cdecl; external Qt5PasLib name 'QItemSelectionModel_isColumnSelected';
function QItemSelectionModel_rowIntersectsSelection(handle: QItemSelectionModelH; row: Integer; parent: QModelIndexH): Boolean; cdecl; external Qt5PasLib name 'QItemSelectionModel_rowIntersectsSelection';
function QItemSelectionModel_columnIntersectsSelection(handle: QItemSelectionModelH; column: Integer; parent: QModelIndexH): Boolean; cdecl; external Qt5PasLib name 'QItemSelectionModel_columnIntersectsSelection';
function QItemSelectionModel_hasSelection(handle: QItemSelectionModelH): Boolean; cdecl; external Qt5PasLib name 'QItemSelectionModel_hasSelection';
procedure QItemSelectionModel_selectedIndexes(handle: QItemSelectionModelH; retval: PPtrIntArray); cdecl; external Qt5PasLib name 'QItemSelectionModel_selectedIndexes';
procedure QItemSelectionModel_selectedRows(handle: QItemSelectionModelH; retval: PPtrIntArray; column: Integer = 0); cdecl; external Qt5PasLib name 'QItemSelectionModel_selectedRows';
procedure QItemSelectionModel_selectedColumns(handle: QItemSelectionModelH; retval: PPtrIntArray; row: Integer = 0); cdecl; external Qt5PasLib name 'QItemSelectionModel_selectedColumns';
function QItemSelectionModel_model(handle: QItemSelectionModelH): QAbstractItemModelH; cdecl; external Qt5PasLib name 'QItemSelectionModel_model';
procedure QItemSelectionModel_setCurrentIndex(handle: QItemSelectionModelH; index: QModelIndexH; command: QItemSelectionModelSelectionFlags); cdecl; external Qt5PasLib name 'QItemSelectionModel_setCurrentIndex';
procedure QItemSelectionModel_select(handle: QItemSelectionModelH; index: QModelIndexH; command: QItemSelectionModelSelectionFlags); cdecl; external Qt5PasLib name 'QItemSelectionModel_select';
procedure QItemSelectionModel_clear(handle: QItemSelectionModelH); cdecl; external Qt5PasLib name 'QItemSelectionModel_clear';
procedure QItemSelectionModel_reset(handle: QItemSelectionModelH); cdecl; external Qt5PasLib name 'QItemSelectionModel_reset';
procedure QItemSelectionModel_clearSelection(handle: QItemSelectionModelH); cdecl; external Qt5PasLib name 'QItemSelectionModel_clearSelection';
procedure QItemSelectionModel_clearCurrentIndex(handle: QItemSelectionModelH); cdecl; external Qt5PasLib name 'QItemSelectionModel_clearCurrentIndex';


type
  QItemSelectionModel_currentChanged_Event = procedure (current: QModelIndexH; previous: QModelIndexH) of object cdecl;
  QItemSelectionModel_currentRowChanged_Event = procedure (current: QModelIndexH; previous: QModelIndexH) of object cdecl;
  QItemSelectionModel_currentColumnChanged_Event = procedure (current: QModelIndexH; previous: QModelIndexH) of object cdecl;



type
  QThreadPriority = ( // QThread::Priority (1)
    QThreadIdlePriority, QThreadLowestPriority, QThreadLowPriority, QThreadNormalPriority, QThreadHighPriority, QThreadHighestPriority, QThreadTimeCriticalPriority, QThreadInheritPriority );

function QThread_currentThreadId(): QtHANDLE; cdecl; external Qt5PasLib name 'QThread_currentThreadId';
function QThread_currentThread(): QThreadH; cdecl; external Qt5PasLib name 'QThread_currentThread';
function QThread_idealThreadCount(): Integer; cdecl; external Qt5PasLib name 'QThread_idealThreadCount';
procedure QThread_yieldCurrentThread(); cdecl; external Qt5PasLib name 'QThread_yieldCurrentThread';
function QThread_Create(parent: QObjectH = nil): QThreadH; cdecl; external Qt5PasLib name 'QThread_Create';
procedure QThread_Destroy(handle: QThreadH); cdecl; external Qt5PasLib name 'QThread_Destroy'; 
procedure QThread_setPriority(handle: QThreadH; priority: QThreadPriority); cdecl; external Qt5PasLib name 'QThread_setPriority';
function QThread_priority(handle: QThreadH): QThreadPriority; cdecl; external Qt5PasLib name 'QThread_priority';
function QThread_isFinished(handle: QThreadH): Boolean; cdecl; external Qt5PasLib name 'QThread_isFinished';
function QThread_isRunning(handle: QThreadH): Boolean; cdecl; external Qt5PasLib name 'QThread_isRunning';
procedure QThread_setStackSize(handle: QThreadH; stackSize: LongWord); cdecl; external Qt5PasLib name 'QThread_setStackSize';
function QThread_stackSize(handle: QThreadH): LongWord; cdecl; external Qt5PasLib name 'QThread_stackSize';
procedure QThread_exit(handle: QThreadH; retcode: Integer = 0); cdecl; external Qt5PasLib name 'QThread_exit';
function QThread_eventDispatcher(handle: QThreadH): QAbstractEventDispatcherH; cdecl; external Qt5PasLib name 'QThread_eventDispatcher';
procedure QThread_setEventDispatcher(handle: QThreadH; eventDispatcher: QAbstractEventDispatcherH); cdecl; external Qt5PasLib name 'QThread_setEventDispatcher';
function QThread_event(handle: QThreadH; event: QEventH): Boolean; cdecl; external Qt5PasLib name 'QThread_event';
procedure QThread_start(handle: QThreadH; AnonParam1: QThreadPriority = QThreadInheritPriority); cdecl; external Qt5PasLib name 'QThread_start';
procedure QThread_terminate(handle: QThreadH); cdecl; external Qt5PasLib name 'QThread_terminate';
procedure QThread_quit(handle: QThreadH); cdecl; external Qt5PasLib name 'QThread_quit';
function QThread_wait(handle: QThreadH; time: Longword): Boolean; cdecl; external Qt5PasLib name 'QThread_wait';
function QThread_loopLevel(handle: QThreadH): integer; cdecl; external Qt5PasLib name 'QThread_loopLevel';
procedure QThread_sleep(AnonParam1: Longword); cdecl; external Qt5PasLib name 'QThread_sleep';
procedure QThread_msleep(AnonParam1: Longword); cdecl; external Qt5PasLib name 'QThread_msleep';
procedure QThread_usleep(AnonParam1: Longword); cdecl; external Qt5PasLib name 'QThread_usleep';


type
  QThread_started_Event = procedure () of object cdecl;
  QThread_finished_Event = procedure () of object cdecl;


function QLCLThread_Create(parent: QObjectH = nil): QLCLThreadH; cdecl; external Qt5PasLib name 'QLCLThread_Create';
procedure QLCLThread_Destroy(handle: QLCLThreadH); cdecl; external Qt5PasLib name 'QLCLThread_Destroy'; 
procedure QLCLThread_override_run(handle: QLCLThreadH; hook: QLCLThread_run_Override); cdecl; external Qt5PasLib name 'QLCLThread_override_run';
function QLCLThread_exec(handle: QLCLThreadH): Integer; cdecl; external Qt5PasLib name 'QLCLThread_exec';


type
  QCharCategory = ( // QChar::Category (1)
    QCharMark_NonSpacing, QCharMark_SpacingCombining, QCharMark_Enclosing, QCharNumber_DecimalDigit, QCharNumber_Letter, QCharNumber_Other, QCharSeparator_Space, QCharSeparator_Line, QCharSeparator_Paragraph, 
    QCharOther_Control, QCharOther_Format, QCharOther_Surrogate, QCharOther_PrivateUse, QCharOther_NotAssigned, QCharLetter_Uppercase, QCharLetter_Lowercase, QCharLetter_Titlecase, QCharLetter_Modifier, 
    QCharLetter_Other, QCharPunctuation_Connector, QCharPunctuation_Dash, QCharPunctuation_Open, QCharPunctuation_Close, QCharPunctuation_InitialQuote, QCharPunctuation_FinalQuote, QCharPunctuation_Other, 
    QCharSymbol_Math, QCharSymbol_Currency, QCharSymbol_Modifier, QCharSymbol_Other );

  QCharScript = ( // QChar::Script (1)
    QCharScript_Unknown, QCharScript_Inherited, QCharScript_Common, QCharScript_Latin, QCharScript_Greek, QCharScript_Cyrillic, QCharScript_Armenian, QCharScript_Hebrew, QCharScript_Arabic, 
    QCharScript_Syriac, QCharScript_Thaana, QCharScript_Devanagari, QCharScript_Bengali, QCharScript_Gurmukhi, QCharScript_Gujarati, QCharScript_Oriya, QCharScript_Tamil, QCharScript_Telugu, 
    QCharScript_Kannada, QCharScript_Malayalam, QCharScript_Sinhala, QCharScript_Thai, QCharScript_Lao, QCharScript_Tibetan, QCharScript_Myanmar, QCharScript_Georgian, QCharScript_Hangul, 
    QCharScript_Ethiopic, QCharScript_Cherokee, QCharScript_CanadianAboriginal, QCharScript_Ogham, QCharScript_Runic, QCharScript_Khmer, QCharScript_Mongolian, QCharScript_Hiragana, QCharScript_Katakana, 
    QCharScript_Bopomofo, QCharScript_Han, QCharScript_Yi, QCharScript_OldItalic, QCharScript_Gothic, QCharScript_Deseret, QCharScript_Tagalog, QCharScript_Hanunoo, QCharScript_Buhid, QCharScript_Tagbanwa, 
    QCharScript_Coptic, QCharScript_Limbu, QCharScript_TaiLe, QCharScript_LinearB, QCharScript_Ugaritic, QCharScript_Shavian, QCharScript_Osmanya, QCharScript_Cypriot, QCharScript_Braille, 
    QCharScript_Buginese, QCharScript_NewTaiLue, QCharScript_Glagolitic, QCharScript_Tifinagh, QCharScript_SylotiNagri, QCharScript_OldPersian, QCharScript_Kharoshthi, QCharScript_Balinese, 
    QCharScript_Cuneiform, QCharScript_Phoenician, QCharScript_PhagsPa, QCharScript_Nko, QCharScript_Sundanese, QCharScript_Lepcha, QCharScript_OlChiki, QCharScript_Vai, QCharScript_Saurashtra, 
    QCharScript_KayahLi, QCharScript_Rejang, QCharScript_Lycian, QCharScript_Carian, QCharScript_Lydian, QCharScript_Cham, QCharScript_TaiTham, QCharScript_TaiViet, QCharScript_Avestan, 
    QCharScript_EgyptianHieroglyphs, QCharScript_Samaritan, QCharScript_Lisu, QCharScript_Bamum, QCharScript_Javanese, QCharScript_MeeteiMayek, QCharScript_ImperialAramaic, QCharScript_OldSouthArabian, 
    QCharScript_InscriptionalParthian, QCharScript_InscriptionalPahlavi, QCharScript_OldTurkic, QCharScript_Kaithi, QCharScript_Batak, QCharScript_Brahmi, QCharScript_Mandaic, QCharScript_Chakma, 
    QCharScript_MeroiticCursive, QCharScript_MeroiticHieroglyphs, QCharScript_Miao, QCharScript_Sharada, QCharScript_SoraSompeng, QCharScript_Takri, QCharScriptCount );

  QCharDirection = ( // QChar::Direction (1)
    QCharDirL, QCharDirR, QCharDirEN, QCharDirES, QCharDirET, QCharDirAN, QCharDirCS, QCharDirB, QCharDirS, QCharDirWS, QCharDirON, QCharDirLRE, QCharDirLRO, QCharDirAL, QCharDirRLE, QCharDirRLO, 
    QCharDirPDF, QCharDirNSM, QCharDirBN );

  QCharDecomposition = ( // QChar::Decomposition (1)
    QCharNoDecomposition, QCharCanonical, QCharFont, QCharNoBreak, QCharInitial, QCharMedial, QCharFinal, QCharIsolated, QCharCircle, QCharSuper, QCharSub, QCharVertical, QCharWide, QCharNarrow, 
    QCharSmall, QCharSquare, QCharCompat, QCharFraction );

  QCharJoining = ( // QChar::Joining (1)
    QCharOtherJoining, QCharDual, QCharRight, QCharCenter );

  QCharUnicodeVersion = ( // QChar::UnicodeVersion (1)
    QCharUnicode_Unassigned, QCharUnicode_1_1, QCharUnicode_2_0, QCharUnicode_2_1_2, QCharUnicode_3_0, QCharUnicode_3_1, QCharUnicode_3_2, QCharUnicode_4_0, QCharUnicode_4_1, QCharUnicode_5_0, 
    QCharUnicode_5_1, QCharUnicode_5_2, QCharUnicode_6_0, QCharUnicode_6_1, QCharUnicode_6_2 );

  QCharSpecialCharacter = (  //QChar::SpecialCharacter (2)
    QCharNull = $0000,
    QCharTabulation = $0009,
    QCharLineFeed = $000a,
    QCharCarriageReturn = $000d,
    QCharSpace = $0020,
    QCharNbsp = $00a0,
    QCharSoftHyphen = $00ad,
    QCharLineSeparator = $2028,
    QCharParagraphSeparator = $2029,
    QCharByteOrderMark = $feff,
    QCharObjectReplacementCharacter = $fffc,
    QCharReplacementCharacter = $fffd,
    QCharByteOrderSwapped = $fffe,
    QCharLastValidCodePoint = $10ffff );

  QCharCombiningClass = (  //QChar::CombiningClass (2)
    QCharCombining_BelowLeftAttached = 200,
    QCharCombining_BelowAttached = 202,
    QCharCombining_BelowRightAttached = 204,
    QCharCombining_LeftAttached = 208,
    QCharCombining_RightAttached = 210,
    QCharCombining_AboveLeftAttached = 212,
    QCharCombining_AboveAttached = 214,
    QCharCombining_AboveRightAttached = 216,
    QCharCombining_BelowLeft = 218,
    QCharCombining_Below = 220,
    QCharCombining_BelowRight = 222,
    QCharCombining_Left = 224,
    QCharCombining_Right = 226,
    QCharCombining_AboveLeft = 228,
    QCharCombining_Above = 230,
    QCharCombining_AboveRight = 232,
    QCharCombining_DoubleBelow = 233,
    QCharCombining_DoubleAbove = 234,
    QCharCombining_IotaSubscript = 240 );

function QChar_Create(): QCharH; cdecl; external Qt5PasLib name 'QChar_Create';
procedure QChar_Destroy(handle: QCharH); cdecl; external Qt5PasLib name 'QChar_Destroy'; 
function QChar_Create(rc: Word): QCharH; cdecl; external Qt5PasLib name 'QChar_Create2';
function QChar_Create(rc: ShortInt): QCharH; cdecl; external Qt5PasLib name 'QChar_Create4';
function QChar_Create(rc: LongWord): QCharH; cdecl; external Qt5PasLib name 'QChar_Create5';
function QChar_Create(rc: Integer): QCharH; cdecl; external Qt5PasLib name 'QChar_Create6';
function QChar_Create(s: QCharSpecialCharacter): QCharH; cdecl; external Qt5PasLib name 'QChar_Create7';
function QChar_Create(c: char): QCharH; cdecl; external Qt5PasLib name 'QChar_Create8';
function QChar_category(handle: QCharH): QCharCategory; cdecl; external Qt5PasLib name 'QChar_category';
function QChar_direction(handle: QCharH): QCharDirection; cdecl; external Qt5PasLib name 'QChar_direction';
function QChar_joining(handle: QCharH): QCharJoining; cdecl; external Qt5PasLib name 'QChar_joining';
function QChar_combiningClass(handle: QCharH): char; cdecl; external Qt5PasLib name 'QChar_combiningClass';
procedure QChar_mirroredChar(handle: QCharH; retval: PWideChar); cdecl; external Qt5PasLib name 'QChar_mirroredChar';
function QChar_hasMirrored(handle: QCharH): Boolean; cdecl; external Qt5PasLib name 'QChar_hasMirrored';
procedure QChar_decomposition(handle: QCharH; retval: PWideString); cdecl; external Qt5PasLib name 'QChar_decomposition';
function QChar_decompositionTag(handle: QCharH): QCharDecomposition; cdecl; external Qt5PasLib name 'QChar_decompositionTag';
function QChar_digitValue(handle: QCharH): Integer; cdecl; external Qt5PasLib name 'QChar_digitValue';
procedure QChar_toLower(handle: QCharH; retval: PWideChar); cdecl; external Qt5PasLib name 'QChar_toLower';
procedure QChar_toUpper(handle: QCharH; retval: PWideChar); cdecl; external Qt5PasLib name 'QChar_toUpper';
procedure QChar_toTitleCase(handle: QCharH; retval: PWideChar); cdecl; external Qt5PasLib name 'QChar_toTitleCase';
procedure QChar_toCaseFolded(handle: QCharH; retval: PWideChar); cdecl; external Qt5PasLib name 'QChar_toCaseFolded';
function QChar_script(handle: QCharH): QCharScript; cdecl; external Qt5PasLib name 'QChar_script';
function QChar_unicodeVersion(handle: QCharH): QCharUnicodeVersion; cdecl; external Qt5PasLib name 'QChar_unicodeVersion';
function QChar_toLatin1(handle: QCharH): char; cdecl; external Qt5PasLib name 'QChar_toLatin1';
function QChar_unicode(handle: QCharH): Word; cdecl; external Qt5PasLib name 'QChar_unicode';
procedure QChar_fromLatin1(retval: PWideChar; c: char); cdecl; external Qt5PasLib name 'QChar_fromLatin1';
function QChar_isNull(handle: QCharH): Boolean; cdecl; external Qt5PasLib name 'QChar_isNull';
function QChar_isPrint(handle: QCharH): Boolean; cdecl; external Qt5PasLib name 'QChar_isPrint';
function QChar_isSpace(handle: QCharH): Boolean; cdecl; external Qt5PasLib name 'QChar_isSpace';
function QChar_isMark(handle: QCharH): Boolean; cdecl; external Qt5PasLib name 'QChar_isMark';
function QChar_isPunct(handle: QCharH): Boolean; cdecl; external Qt5PasLib name 'QChar_isPunct';
function QChar_isSymbol(handle: QCharH): Boolean; cdecl; external Qt5PasLib name 'QChar_isSymbol';
function QChar_isLetter(handle: QCharH): Boolean; cdecl; external Qt5PasLib name 'QChar_isLetter';
function QChar_isNumber(handle: QCharH): Boolean; cdecl; external Qt5PasLib name 'QChar_isNumber';
function QChar_isLetterOrNumber(handle: QCharH): Boolean; cdecl; external Qt5PasLib name 'QChar_isLetterOrNumber';
function QChar_isDigit(handle: QCharH): Boolean; cdecl; external Qt5PasLib name 'QChar_isDigit';
function QChar_isLower(handle: QCharH): Boolean; cdecl; external Qt5PasLib name 'QChar_isLower';
function QChar_isUpper(handle: QCharH): Boolean; cdecl; external Qt5PasLib name 'QChar_isUpper';
function QChar_isTitleCase(handle: QCharH): Boolean; cdecl; external Qt5PasLib name 'QChar_isTitleCase';
function QChar_isNonCharacter(handle: QCharH): Boolean; cdecl; external Qt5PasLib name 'QChar_isNonCharacter';
function QChar_isHighSurrogate(handle: QCharH): Boolean; cdecl; external Qt5PasLib name 'QChar_isHighSurrogate';
function QChar_isLowSurrogate(handle: QCharH): Boolean; cdecl; external Qt5PasLib name 'QChar_isLowSurrogate';
function QChar_isSurrogate(handle: QCharH): Boolean; cdecl; external Qt5PasLib name 'QChar_isSurrogate';
function QChar_cell(handle: QCharH): char; cdecl; external Qt5PasLib name 'QChar_cell';
function QChar_row(handle: QCharH): char; cdecl; external Qt5PasLib name 'QChar_row';
procedure QChar_setCell(handle: QCharH; cell: char); cdecl; external Qt5PasLib name 'QChar_setCell';
procedure QChar_setRow(handle: QCharH; row: char); cdecl; external Qt5PasLib name 'QChar_setRow';
function QChar_isNonCharacter(ucs4: LongWord): Boolean; cdecl; external Qt5PasLib name 'QChar_isNonCharacter2';
function QChar_isHighSurrogate(ucs4: LongWord): Boolean; cdecl; external Qt5PasLib name 'QChar_isHighSurrogate2';
function QChar_isLowSurrogate(ucs4: LongWord): Boolean; cdecl; external Qt5PasLib name 'QChar_isLowSurrogate2';
function QChar_isSurrogate(ucs4: LongWord): Boolean; cdecl; external Qt5PasLib name 'QChar_isSurrogate2';
function QChar_requiresSurrogates(ucs4: LongWord): Boolean; cdecl; external Qt5PasLib name 'QChar_requiresSurrogates';
function QChar_surrogateToUcs4(high: Word; low: Word): LongWord; cdecl; external Qt5PasLib name 'QChar_surrogateToUcs4';
function QChar_surrogateToUcs4(high: PWideChar; low: PWideChar): LongWord; cdecl; external Qt5PasLib name 'QChar_surrogateToUcs42';
function QChar_highSurrogate(ucs4: LongWord): Word; cdecl; external Qt5PasLib name 'QChar_highSurrogate';
function QChar_lowSurrogate(ucs4: LongWord): Word; cdecl; external Qt5PasLib name 'QChar_lowSurrogate';
function QChar_isSpace(ucs4: LongWord): Boolean; cdecl; external Qt5PasLib name 'QChar_isSpace2';
function QChar_isLetter(ucs4: LongWord): Boolean; cdecl; external Qt5PasLib name 'QChar_isLetter2';
function QChar_isNumber(ucs4: LongWord): Boolean; cdecl; external Qt5PasLib name 'QChar_isNumber2';
function QChar_isLetterOrNumber(ucs4: LongWord): Boolean; cdecl; external Qt5PasLib name 'QChar_isLetterOrNumber2';
function QChar_isDigit(ucs4: LongWord): Boolean; cdecl; external Qt5PasLib name 'QChar_isDigit2';
function QChar_isLower(ucs4: LongWord): Boolean; cdecl; external Qt5PasLib name 'QChar_isLower2';
function QChar_isUpper(ucs4: LongWord): Boolean; cdecl; external Qt5PasLib name 'QChar_isUpper2';
function QChar_isTitleCase(ucs4: LongWord): Boolean; cdecl; external Qt5PasLib name 'QChar_isTitleCase2';

function QSize_Create(): QSizeH; cdecl; external Qt5PasLib name 'QSize_Create';
procedure QSize_Destroy(handle: QSizeH); cdecl; external Qt5PasLib name 'QSize_Destroy'; 
function QSize_Create(w: Integer; h: Integer): QSizeH; cdecl; external Qt5PasLib name 'QSize_Create2';
function QSize_isNull(handle: QSizeH): Boolean; cdecl; external Qt5PasLib name 'QSize_isNull';
function QSize_isEmpty(handle: QSizeH): Boolean; cdecl; external Qt5PasLib name 'QSize_isEmpty';
function QSize_isValid(handle: QSizeH): Boolean; cdecl; external Qt5PasLib name 'QSize_isValid';
function QSize_width(handle: QSizeH): Integer; cdecl; external Qt5PasLib name 'QSize_width';
function QSize_height(handle: QSizeH): Integer; cdecl; external Qt5PasLib name 'QSize_height';
procedure QSize_setWidth(handle: QSizeH; w: Integer); cdecl; external Qt5PasLib name 'QSize_setWidth';
procedure QSize_setHeight(handle: QSizeH; h: Integer); cdecl; external Qt5PasLib name 'QSize_setHeight';
procedure QSize_transpose(handle: QSizeH); cdecl; external Qt5PasLib name 'QSize_transpose';
procedure QSize_transposed(handle: QSizeH; retval: PSize); cdecl; external Qt5PasLib name 'QSize_transposed';
procedure QSize_scale(handle: QSizeH; w: Integer; h: Integer; mode: QtAspectRatioMode); cdecl; external Qt5PasLib name 'QSize_scale';
procedure QSize_scale(handle: QSizeH; s: PSize; mode: QtAspectRatioMode); cdecl; external Qt5PasLib name 'QSize_scale2';
procedure QSize_scaled(handle: QSizeH; retval: PSize; w: Integer; h: Integer; mode: QtAspectRatioMode); cdecl; external Qt5PasLib name 'QSize_scaled';
procedure QSize_scaled(handle: QSizeH; retval: PSize; s: PSize; mode: QtAspectRatioMode); cdecl; external Qt5PasLib name 'QSize_scaled2';
procedure QSize_expandedTo(handle: QSizeH; retval: PSize; AnonParam1: PSize); cdecl; external Qt5PasLib name 'QSize_expandedTo';
procedure QSize_boundedTo(handle: QSizeH; retval: PSize; AnonParam1: PSize); cdecl; external Qt5PasLib name 'QSize_boundedTo';
function QSize_rwidth(handle: QSizeH): PInteger; cdecl; external Qt5PasLib name 'QSize_rwidth';
function QSize_rheight(handle: QSizeH): PInteger; cdecl; external Qt5PasLib name 'QSize_rheight';

function QSizeF_Create(): QSizeFH; cdecl; external Qt5PasLib name 'QSizeF_Create';
procedure QSizeF_Destroy(handle: QSizeFH); cdecl; external Qt5PasLib name 'QSizeF_Destroy'; 
function QSizeF_Create(sz: PSize): QSizeFH; cdecl; external Qt5PasLib name 'QSizeF_Create2';
function QSizeF_Create(w: qreal; h: qreal): QSizeFH; cdecl; external Qt5PasLib name 'QSizeF_Create3';
function QSizeF_isNull(handle: QSizeFH): Boolean; cdecl; external Qt5PasLib name 'QSizeF_isNull';
function QSizeF_isEmpty(handle: QSizeFH): Boolean; cdecl; external Qt5PasLib name 'QSizeF_isEmpty';
function QSizeF_isValid(handle: QSizeFH): Boolean; cdecl; external Qt5PasLib name 'QSizeF_isValid';
function QSizeF_width(handle: QSizeFH): qreal; cdecl; external Qt5PasLib name 'QSizeF_width';
function QSizeF_height(handle: QSizeFH): qreal; cdecl; external Qt5PasLib name 'QSizeF_height';
procedure QSizeF_setWidth(handle: QSizeFH; w: qreal); cdecl; external Qt5PasLib name 'QSizeF_setWidth';
procedure QSizeF_setHeight(handle: QSizeFH; h: qreal); cdecl; external Qt5PasLib name 'QSizeF_setHeight';
procedure QSizeF_transpose(handle: QSizeFH); cdecl; external Qt5PasLib name 'QSizeF_transpose';
procedure QSizeF_transposed(handle: QSizeFH; retval: QSizeFH); cdecl; external Qt5PasLib name 'QSizeF_transposed';
procedure QSizeF_scale(handle: QSizeFH; w: qreal; h: qreal; mode: QtAspectRatioMode); cdecl; external Qt5PasLib name 'QSizeF_scale';
procedure QSizeF_scale(handle: QSizeFH; s: QSizeFH; mode: QtAspectRatioMode); cdecl; external Qt5PasLib name 'QSizeF_scale2';
procedure QSizeF_scaled(handle: QSizeFH; retval: QSizeFH; w: qreal; h: qreal; mode: QtAspectRatioMode); cdecl; external Qt5PasLib name 'QSizeF_scaled';
procedure QSizeF_scaled(handle: QSizeFH; retval: QSizeFH; s: QSizeFH; mode: QtAspectRatioMode); cdecl; external Qt5PasLib name 'QSizeF_scaled2';
procedure QSizeF_expandedTo(handle: QSizeFH; retval: QSizeFH; AnonParam1: QSizeFH); cdecl; external Qt5PasLib name 'QSizeF_expandedTo';
procedure QSizeF_boundedTo(handle: QSizeFH; retval: QSizeFH; AnonParam1: QSizeFH); cdecl; external Qt5PasLib name 'QSizeF_boundedTo';
function QSizeF_rwidth(handle: QSizeFH): PQReal; cdecl; external Qt5PasLib name 'QSizeF_rwidth';
function QSizeF_rheight(handle: QSizeFH): PQReal; cdecl; external Qt5PasLib name 'QSizeF_rheight';
procedure QSizeF_toSize(handle: QSizeFH; retval: PSize); cdecl; external Qt5PasLib name 'QSizeF_toSize';


type
  QStringSplitBehavior = ( // QString::SplitBehavior (1)
    QStringKeepEmptyParts, QStringSkipEmptyParts );

  QStringNormalizationForm = ( // QString::NormalizationForm (1)
    QStringNormalizationForm_D, QStringNormalizationForm_C, QStringNormalizationForm_KD, QStringNormalizationForm_KC );

type
  QStringSectionFlag = cardinal; // QString::SectionFlag
  QStringSectionFlags = QStringSectionFlag; //QFlags<> (3)
const
  QStringSectionDefault =   $00;
  QStringSectionSkipEmpty =   $01;
  QStringSectionIncludeLeadingSep =   $02;
  QStringSectionIncludeTrailingSep =   $04;
  QStringSectionCaseInsensitiveSeps =   $08;



function QString_Create(): QStringH; cdecl; external Qt5PasLib name 'QString_Create';
procedure QString_Destroy(handle: QStringH); cdecl; external Qt5PasLib name 'QString_Destroy'; 
function QString_Create(unicode: PWideChar; size: Integer = -1): QStringH; cdecl; external Qt5PasLib name 'QString_Create2';
function QString_Create(c: PWideChar): QStringH; cdecl; external Qt5PasLib name 'QString_Create3';
function QString_Create(AnonParam1: PWideString): QStringH; cdecl; external Qt5PasLib name 'QString_Create5';
procedure QString_swap(handle: QStringH; other: PWideString); cdecl; external Qt5PasLib name 'QString_swap';
function QString_size(handle: QStringH): Integer; cdecl; external Qt5PasLib name 'QString_size';
function QString_count(handle: QStringH): Integer; cdecl; external Qt5PasLib name 'QString_count';
function QString_length(handle: QStringH): Integer; cdecl; external Qt5PasLib name 'QString_length';
function QString_isEmpty(handle: QStringH): Boolean; cdecl; external Qt5PasLib name 'QString_isEmpty';
procedure QString_resize(handle: QStringH; size: Integer); cdecl; external Qt5PasLib name 'QString_resize';
procedure QString_fill(handle: QStringH; retval: PWideString; c: PWideChar; size: Integer = -1); cdecl; external Qt5PasLib name 'QString_fill';
procedure QString_truncate(handle: QStringH; pos: Integer); cdecl; external Qt5PasLib name 'QString_truncate';
procedure QString_chop(handle: QStringH; n: Integer); cdecl; external Qt5PasLib name 'QString_chop';
function QString_capacity(handle: QStringH): Integer; cdecl; external Qt5PasLib name 'QString_capacity';
procedure QString_reserve(handle: QStringH; size: Integer); cdecl; external Qt5PasLib name 'QString_reserve';
procedure QString_squeeze(handle: QStringH); cdecl; external Qt5PasLib name 'QString_squeeze';
function QString_unicode(handle: QStringH): PWideChar; cdecl; external Qt5PasLib name 'QString_unicode';
function QString_data(handle: QStringH): PWideChar; cdecl; external Qt5PasLib name 'QString_data';
function QString_constData(handle: QStringH): PWideChar; cdecl; external Qt5PasLib name 'QString_constData';
procedure QString_detach(handle: QStringH); cdecl; external Qt5PasLib name 'QString_detach';
function QString_isDetached(handle: QStringH): Boolean; cdecl; external Qt5PasLib name 'QString_isDetached';
function QString_isSharedWith(handle: QStringH; other: PWideString): Boolean; cdecl; external Qt5PasLib name 'QString_isSharedWith';
procedure QString_clear(handle: QStringH); cdecl; external Qt5PasLib name 'QString_clear';
procedure QString_at(handle: QStringH; retval: PWideChar; i: Integer); cdecl; external Qt5PasLib name 'QString_at';
procedure QString_arg(handle: QStringH; retval: PWideString; a: int64; fieldwidth: Integer; base: Integer; fillChar: PWideChar); cdecl; external Qt5PasLib name 'QString_arg';
procedure QString_arg(handle: QStringH; retval: PWideString; a: qword; fieldwidth: Integer; base: Integer; fillChar: PWideChar); cdecl; external Qt5PasLib name 'QString_arg2';
procedure QString_arg(handle: QStringH; retval: PWideString; a: Longword; fieldwidth: Integer; base: Integer; fillChar: PWideChar); cdecl; external Qt5PasLib name 'QString_arg4';
procedure QString_arg(handle: QStringH; retval: PWideString; a: ShortInt; fieldWidth: Integer; base: Integer; fillChar: PWideChar); cdecl; external Qt5PasLib name 'QString_arg7';
procedure QString_arg(handle: QStringH; retval: PWideString; a: Word; fieldWidth: Integer; base: Integer; fillChar: PWideChar); cdecl; external Qt5PasLib name 'QString_arg8';
procedure QString_arg(handle: QStringH; retval: PWideString; a: Double; fieldWidth: Integer; fmt: char; prec: Integer; fillChar: PWideChar); cdecl; external Qt5PasLib name 'QString_arg9';
procedure QString_arg(handle: QStringH; retval: PWideString; a: char; fieldWidth: Integer; fillChar: PWideChar); cdecl; external Qt5PasLib name 'QString_arg10';
procedure QString_arg(handle: QStringH; retval: PWideString; a: PWideChar; fieldWidth: Integer; fillChar: PWideChar); cdecl; external Qt5PasLib name 'QString_arg11';
procedure QString_arg(handle: QStringH; retval: PWideString; a: PWideString; fieldWidth: Integer; fillChar: PWideChar); cdecl; external Qt5PasLib name 'QString_arg12';
procedure QString_arg(handle: QStringH; retval: PWideString; a1: PWideString; a2: PWideString); cdecl; external Qt5PasLib name 'QString_arg13';
procedure QString_arg(handle: QStringH; retval: PWideString; a1: PWideString; a2: PWideString; a3: PWideString); cdecl; external Qt5PasLib name 'QString_arg14';
procedure QString_arg(handle: QStringH; retval: PWideString; a1: PWideString; a2: PWideString; a3: PWideString; a4: PWideString); cdecl; external Qt5PasLib name 'QString_arg15';
procedure QString_arg(handle: QStringH; retval: PWideString; a1: PWideString; a2: PWideString; a3: PWideString; a4: PWideString; a5: PWideString); cdecl; external Qt5PasLib name 'QString_arg16';
procedure QString_arg(handle: QStringH; retval: PWideString; a1: PWideString; a2: PWideString; a3: PWideString; a4: PWideString; a5: PWideString; a6: PWideString); cdecl; external Qt5PasLib name 'QString_arg17';
procedure QString_arg(handle: QStringH; retval: PWideString; a1: PWideString; a2: PWideString; a3: PWideString; a4: PWideString; a5: PWideString; a6: PWideString; a7: PWideString); cdecl; external Qt5PasLib name 'QString_arg18';
procedure QString_arg(handle: QStringH; retval: PWideString; a1: PWideString; a2: PWideString; a3: PWideString; a4: PWideString; a5: PWideString; a6: PWideString; a7: PWideString; a8: PWideString); cdecl; external Qt5PasLib name 'QString_arg19';
procedure QString_arg(handle: QStringH; retval: PWideString; a1: PWideString; a2: PWideString; a3: PWideString; a4: PWideString; a5: PWideString; a6: PWideString; a7: PWideString; a8: PWideString; a9: PWideString); cdecl; external Qt5PasLib name 'QString_arg20';
function QString_indexOf(handle: QStringH; c: PWideChar; from: Integer = 0; cs: QtCaseSensitivity = QtCaseSensitive): Integer; cdecl; external Qt5PasLib name 'QString_indexOf';
function QString_lastIndexOf(handle: QStringH; c: PWideChar; from: Integer = -1; cs: QtCaseSensitivity = QtCaseSensitive): Integer; cdecl; external Qt5PasLib name 'QString_lastIndexOf';
function QString_contains(handle: QStringH; c: PWideChar; cs: QtCaseSensitivity = QtCaseSensitive): Boolean; cdecl; external Qt5PasLib name 'QString_contains';
function QString_contains(handle: QStringH; s: PWideString; cs: QtCaseSensitivity = QtCaseSensitive): Boolean; cdecl; external Qt5PasLib name 'QString_contains2';
function QString_count(handle: QStringH; c: PWideChar; cs: QtCaseSensitivity = QtCaseSensitive): Integer; cdecl; external Qt5PasLib name 'QString_count2';
function QString_count(handle: QStringH; s: PWideString; cs: QtCaseSensitivity = QtCaseSensitive): Integer; cdecl; external Qt5PasLib name 'QString_count3';
function QString_indexOf(handle: QStringH; AnonParam1: QRegExpH; from: Integer = 0): Integer; cdecl; external Qt5PasLib name 'QString_indexOf3';
function QString_lastIndexOf(handle: QStringH; AnonParam1: QRegExpH; from: Integer = -1): Integer; cdecl; external Qt5PasLib name 'QString_lastIndexOf3';
function QString_contains(handle: QStringH; rx: QRegExpH): Boolean; cdecl; external Qt5PasLib name 'QString_contains3';
function QString_count(handle: QStringH; AnonParam1: QRegExpH): Integer; cdecl; external Qt5PasLib name 'QString_count4';
function QString_contains(handle: QStringH; re: QRegularExpressionH): Boolean; cdecl; external Qt5PasLib name 'QString_contains5';
function QString_contains(handle: QStringH; re: QRegularExpressionH; match: QRegularExpressionMatchH): Boolean; cdecl; external Qt5PasLib name 'QString_contains6';
function QString_count(handle: QStringH; re: QRegularExpressionH): Integer; cdecl; external Qt5PasLib name 'QString_count5';
procedure QString_section(handle: QStringH; retval: PWideString; sep: PWideChar; start: Integer; _end: Integer = -1; flags: QStringSectionFlags = QStringSectionDefault); cdecl; external Qt5PasLib name 'QString_section';
procedure QString_section(handle: QStringH; retval: PWideString; in_sep: PWideString; start: Integer; _end: Integer = -1; flags: QStringSectionFlags = QStringSectionDefault); cdecl; external Qt5PasLib name 'QString_section2';
procedure QString_section(handle: QStringH; retval: PWideString; reg: QRegExpH; start: Integer; _end: Integer = -1; flags: QStringSectionFlags = QStringSectionDefault); cdecl; external Qt5PasLib name 'QString_section3';
procedure QString_section(handle: QStringH; retval: PWideString; re: QRegularExpressionH; start: Integer; _end: Integer = -1; flags: QStringSectionFlags = QStringSectionDefault); cdecl; external Qt5PasLib name 'QString_section4';
procedure QString_left(handle: QStringH; retval: PWideString; n: Integer); cdecl; external Qt5PasLib name 'QString_left';
procedure QString_right(handle: QStringH; retval: PWideString; n: Integer); cdecl; external Qt5PasLib name 'QString_right';
procedure QString_mid(handle: QStringH; retval: PWideString; position: Integer; n: Integer = -1); cdecl; external Qt5PasLib name 'QString_mid';
function QString_startsWith(handle: QStringH; s: PWideString; cs: QtCaseSensitivity = QtCaseSensitive): Boolean; cdecl; external Qt5PasLib name 'QString_startsWith';
function QString_startsWith(handle: QStringH; c: PWideChar; cs: QtCaseSensitivity = QtCaseSensitive): Boolean; cdecl; external Qt5PasLib name 'QString_startsWith2';
function QString_endsWith(handle: QStringH; s: PWideString; cs: QtCaseSensitivity = QtCaseSensitive): Boolean; cdecl; external Qt5PasLib name 'QString_endsWith';
function QString_endsWith(handle: QStringH; c: PWideChar; cs: QtCaseSensitivity = QtCaseSensitive): Boolean; cdecl; external Qt5PasLib name 'QString_endsWith2';
procedure QString_leftJustified(handle: QStringH; retval: PWideString; width: Integer; fill: PWideChar; trunc: Boolean = False); cdecl; external Qt5PasLib name 'QString_leftJustified';
procedure QString_rightJustified(handle: QStringH; retval: PWideString; width: Integer; fill: PWideChar; trunc: Boolean = False); cdecl; external Qt5PasLib name 'QString_rightJustified';
procedure QString_toLower(handle: QStringH; retval: PWideString); cdecl; external Qt5PasLib name 'QString_toLower';
procedure QString_toUpper(handle: QStringH; retval: PWideString); cdecl; external Qt5PasLib name 'QString_toUpper';
procedure QString_toCaseFolded(handle: QStringH; retval: PWideString); cdecl; external Qt5PasLib name 'QString_toCaseFolded';
procedure QString_trimmed(handle: QStringH; retval: PWideString); cdecl; external Qt5PasLib name 'QString_trimmed';
procedure QString_simplified(handle: QStringH; retval: PWideString); cdecl; external Qt5PasLib name 'QString_simplified';
procedure QString_toHtmlEscaped(handle: QStringH; retval: PWideString); cdecl; external Qt5PasLib name 'QString_toHtmlEscaped';
procedure QString_insert(handle: QStringH; retval: PWideString; i: Integer; c: PWideChar); cdecl; external Qt5PasLib name 'QString_insert';
procedure QString_insert(handle: QStringH; retval: PWideString; i: Integer; uc: PWideChar; len: Integer); cdecl; external Qt5PasLib name 'QString_insert2';
procedure QString_insert(handle: QStringH; retval: PWideString; i: Integer; s: PWideString); cdecl; external Qt5PasLib name 'QString_insert3';
procedure QString_append(handle: QStringH; retval: PWideString; c: PWideChar); cdecl; external Qt5PasLib name 'QString_append';
procedure QString_append(handle: QStringH; retval: PWideString; uc: PWideChar; len: Integer); cdecl; external Qt5PasLib name 'QString_append2';
procedure QString_append(handle: QStringH; retval: PWideString; s: PWideString); cdecl; external Qt5PasLib name 'QString_append3';
procedure QString_prepend(handle: QStringH; retval: PWideString; c: PWideChar); cdecl; external Qt5PasLib name 'QString_prepend';
procedure QString_prepend(handle: QStringH; retval: PWideString; s: PWideString); cdecl; external Qt5PasLib name 'QString_prepend2';
procedure QString_remove(handle: QStringH; retval: PWideString; i: Integer; len: Integer); cdecl; external Qt5PasLib name 'QString_remove';
procedure QString_remove(handle: QStringH; retval: PWideString; c: PWideChar; cs: QtCaseSensitivity = QtCaseSensitive); cdecl; external Qt5PasLib name 'QString_remove2';
procedure QString_remove(handle: QStringH; retval: PWideString; s: PWideString; cs: QtCaseSensitivity = QtCaseSensitive); cdecl; external Qt5PasLib name 'QString_remove3';
procedure QString_replace(handle: QStringH; retval: PWideString; i: Integer; len: Integer; after: PWideChar); cdecl; external Qt5PasLib name 'QString_replace';
procedure QString_replace(handle: QStringH; retval: PWideString; i: Integer; len: Integer; s: PWideChar; slen: Integer); cdecl; external Qt5PasLib name 'QString_replace2';
procedure QString_replace(handle: QStringH; retval: PWideString; i: Integer; len: Integer; after: PWideString); cdecl; external Qt5PasLib name 'QString_replace3';
procedure QString_replace(handle: QStringH; retval: PWideString; before: PWideChar; after: PWideChar; cs: QtCaseSensitivity = QtCaseSensitive); cdecl; external Qt5PasLib name 'QString_replace4';
procedure QString_replace(handle: QStringH; retval: PWideString; before: PWideChar; blen: Integer; after: PWideChar; alen: Integer; cs: QtCaseSensitivity = QtCaseSensitive); cdecl; external Qt5PasLib name 'QString_replace5';
procedure QString_replace(handle: QStringH; retval: PWideString; before: PWideString; after: PWideString; cs: QtCaseSensitivity = QtCaseSensitive); cdecl; external Qt5PasLib name 'QString_replace6';
procedure QString_replace(handle: QStringH; retval: PWideString; c: PWideChar; after: PWideString; cs: QtCaseSensitivity = QtCaseSensitive); cdecl; external Qt5PasLib name 'QString_replace7';
procedure QString_replace(handle: QStringH; retval: PWideString; rx: QRegExpH; after: PWideString); cdecl; external Qt5PasLib name 'QString_replace8';
procedure QString_remove(handle: QStringH; retval: PWideString; rx: QRegExpH); cdecl; external Qt5PasLib name 'QString_remove4';
procedure QString_replace(handle: QStringH; retval: PWideString; re: QRegularExpressionH; after: PWideString); cdecl; external Qt5PasLib name 'QString_replace9';
procedure QString_remove(handle: QStringH; retval: PWideString; re: QRegularExpressionH); cdecl; external Qt5PasLib name 'QString_remove5';
procedure QString_split(handle: QStringH; retval: QStringListH; sep: PWideString; behavior: QStringSplitBehavior = QStringKeepEmptyParts; cs: QtCaseSensitivity = QtCaseSensitive); cdecl; external Qt5PasLib name 'QString_split';
procedure QString_split(handle: QStringH; retval: QStringListH; sep: PWideChar; behavior: QStringSplitBehavior = QStringKeepEmptyParts; cs: QtCaseSensitivity = QtCaseSensitive); cdecl; external Qt5PasLib name 'QString_split2';
procedure QString_split(handle: QStringH; retval: QStringListH; sep: QRegExpH; behavior: QStringSplitBehavior = QStringKeepEmptyParts); cdecl; external Qt5PasLib name 'QString_split3';
procedure QString_split(handle: QStringH; retval: QStringListH; sep: QRegularExpressionH; behavior: QStringSplitBehavior = QStringKeepEmptyParts); cdecl; external Qt5PasLib name 'QString_split4';
procedure QString_normalized(handle: QStringH; retval: PWideString; mode: QStringNormalizationForm; version: QCharUnicodeVersion = QCharUnicode_Unassigned); cdecl; external Qt5PasLib name 'QString_normalized';
procedure QString_repeated(handle: QStringH; retval: PWideString; times: Integer); cdecl; external Qt5PasLib name 'QString_repeated';
function QString_utf16(handle: QStringH): PWord; cdecl; external Qt5PasLib name 'QString_utf16';
procedure QString_toLatin1(handle: QStringH; retval: QByteArrayH); cdecl; external Qt5PasLib name 'QString_toLatin1';
procedure QString_toUtf8(handle: QStringH; retval: QByteArrayH); cdecl; external Qt5PasLib name 'QString_toUtf8';
procedure QString_toLocal8Bit(handle: QStringH; retval: QByteArrayH); cdecl; external Qt5PasLib name 'QString_toLocal8Bit';
procedure QString_fromLatin1(retval: PWideString; str: PAnsiChar; size: Integer = -1); cdecl; external Qt5PasLib name 'QString_fromLatin1';
procedure QString_fromUtf8(retval: PWideString; str: PAnsiChar; size: Integer = -1); cdecl; external Qt5PasLib name 'QString_fromUtf8';
procedure QString_fromLocal8Bit(retval: PWideString; str: PAnsiChar; size: Integer = -1); cdecl; external Qt5PasLib name 'QString_fromLocal8Bit';
procedure QString_fromLatin1(retval: PWideString; str: QByteArrayH); cdecl; external Qt5PasLib name 'QString_fromLatin12';
procedure QString_fromUtf8(retval: PWideString; str: QByteArrayH); cdecl; external Qt5PasLib name 'QString_fromUtf82';
procedure QString_fromLocal8Bit(retval: PWideString; str: QByteArrayH); cdecl; external Qt5PasLib name 'QString_fromLocal8Bit2';
procedure QString_fromUtf16(retval: PWideString; AnonParam1: PWord; size: Integer = -1); cdecl; external Qt5PasLib name 'QString_fromUtf16';
procedure QString_fromUcs4(retval: PWideString; AnonParam1: PLongWord; size: Integer = -1); cdecl; external Qt5PasLib name 'QString_fromUcs4';
procedure QString_fromRawData(retval: PWideString; AnonParam1: PWideChar; size: Integer); cdecl; external Qt5PasLib name 'QString_fromRawData';
function QString_toWCharArray(handle: QStringH; _array: PWideChar): Integer; cdecl; external Qt5PasLib name 'QString_toWCharArray';
procedure QString_fromWCharArray(retval: PWideString; _string: PWideChar; size: Integer = -1); cdecl; external Qt5PasLib name 'QString_fromWCharArray';
procedure QString_setRawData(handle: QStringH; retval: PWideString; unicode: PWideChar; size: Integer); cdecl; external Qt5PasLib name 'QString_setRawData';
procedure QString_setUnicode(handle: QStringH; retval: PWideString; unicode: PWideChar; size: Integer); cdecl; external Qt5PasLib name 'QString_setUnicode';
procedure QString_setUtf16(handle: QStringH; retval: PWideString; utf16: PWord; size: Integer); cdecl; external Qt5PasLib name 'QString_setUtf16';
function QString_compare(handle: QStringH; s: PWideString; cs: QtCaseSensitivity = QtCaseSensitive): Integer; cdecl; external Qt5PasLib name 'QString_compare';
function QString_compare(s1: PWideString; s2: PWideString; cs: QtCaseSensitivity = QtCaseSensitive): Integer; cdecl; external Qt5PasLib name 'QString_compare2';
function QString_localeAwareCompare(handle: QStringH; s: PWideString): Integer; cdecl; external Qt5PasLib name 'QString_localeAwareCompare';
function QString_localeAwareCompare(s1: PWideString; s2: PWideString): Integer; cdecl; external Qt5PasLib name 'QString_localeAwareCompare2';
function QString_toShort(handle: QStringH; ok: PBoolean = nil; base: Integer = 10): ShortInt; cdecl; external Qt5PasLib name 'QString_toShort';
function QString_toUShort(handle: QStringH; ok: PBoolean = nil; base: Integer = 10): Word; cdecl; external Qt5PasLib name 'QString_toUShort';
function QString_toInt(handle: QStringH; ok: PBoolean = nil; base: Integer = 10): Integer; cdecl; external Qt5PasLib name 'QString_toInt';
function QString_toUInt(handle: QStringH; ok: PBoolean = nil; base: Integer = 10): LongWord; cdecl; external Qt5PasLib name 'QString_toUInt';
function QString_toLong(handle: QStringH; ok: PBoolean = nil; base: Integer = 10): Long; cdecl; external Qt5PasLib name 'QString_toLong';
function QString_toULong(handle: QStringH; ok: PBoolean = nil; base: Integer = 10): Longword; cdecl; external Qt5PasLib name 'QString_toULong';
function QString_toLongLong(handle: QStringH; ok: PBoolean = nil; base: Integer = 10): int64; cdecl; external Qt5PasLib name 'QString_toLongLong';
function QString_toULongLong(handle: QStringH; ok: PBoolean = nil; base: Integer = 10): qword; cdecl; external Qt5PasLib name 'QString_toULongLong';
function QString_toFloat(handle: QStringH; ok: PBoolean = nil): Single; cdecl; external Qt5PasLib name 'QString_toFloat';
function QString_toDouble(handle: QStringH; ok: PBoolean = nil): Double; cdecl; external Qt5PasLib name 'QString_toDouble';
procedure QString_setNum(handle: QStringH; retval: PWideString; AnonParam1: ShortInt; base: Integer = 10); cdecl; external Qt5PasLib name 'QString_setNum';
procedure QString_setNum(handle: QStringH; retval: PWideString; AnonParam1: Word; base: Integer = 10); cdecl; external Qt5PasLib name 'QString_setNum2';
procedure QString_setNum(handle: QStringH; retval: PWideString; AnonParam1: Integer; base: Integer = 10); cdecl; external Qt5PasLib name 'QString_setNum3';
procedure QString_setNum(handle: QStringH; retval: PWideString; AnonParam1: LongWord; base: Integer = 10); cdecl; external Qt5PasLib name 'QString_setNum4';
procedure QString_setNum(handle: QStringH; retval: PWideString; AnonParam1: int64; base: Integer = 10); cdecl; external Qt5PasLib name 'QString_setNum7';
procedure QString_setNum(handle: QStringH; retval: PWideString; AnonParam1: qword; base: Integer = 10); cdecl; external Qt5PasLib name 'QString_setNum8';
procedure QString_setNum(handle: QStringH; retval: PWideString; AnonParam1: Single; f: char; prec: Integer = 6); cdecl; external Qt5PasLib name 'QString_setNum9';
procedure QString_setNum(handle: QStringH; retval: PWideString; AnonParam1: Double; f: char; prec: Integer = 6); cdecl; external Qt5PasLib name 'QString_setNum10';
procedure QString_number(retval: PWideString; AnonParam1: Integer; base: Integer = 10); cdecl; external Qt5PasLib name 'QString_number';
procedure QString_number(retval: PWideString; AnonParam1: LongWord; base: Integer = 10); cdecl; external Qt5PasLib name 'QString_number2';
procedure QString_number(retval: PWideString; AnonParam1: int64; base: Integer = 10); cdecl; external Qt5PasLib name 'QString_number5';
procedure QString_number(retval: PWideString; AnonParam1: qword; base: Integer = 10); cdecl; external Qt5PasLib name 'QString_number6';
procedure QString_number(retval: PWideString; AnonParam1: Double; f: char; prec: Integer = 6); cdecl; external Qt5PasLib name 'QString_number7';
function QString_Create(ch: PAnsiChar): QStringH; cdecl; external Qt5PasLib name 'QString_Create6';
function QString_Create(a: QByteArrayH): QStringH; cdecl; external Qt5PasLib name 'QString_Create7';
procedure QString_prepend(handle: QStringH; retval: PWideString; s: PAnsiChar); cdecl; external Qt5PasLib name 'QString_prepend3';
procedure QString_prepend(handle: QStringH; retval: PWideString; s: QByteArrayH); cdecl; external Qt5PasLib name 'QString_prepend4';
procedure QString_append(handle: QStringH; retval: PWideString; s: PAnsiChar); cdecl; external Qt5PasLib name 'QString_append4';
procedure QString_append(handle: QStringH; retval: PWideString; s: QByteArrayH); cdecl; external Qt5PasLib name 'QString_append5';
procedure QString_push_back(handle: QStringH; c: PWideChar); cdecl; external Qt5PasLib name 'QString_push_back';
procedure QString_push_back(handle: QStringH; s: PWideString); cdecl; external Qt5PasLib name 'QString_push_back2';
procedure QString_push_front(handle: QStringH; c: PWideChar); cdecl; external Qt5PasLib name 'QString_push_front';
procedure QString_push_front(handle: QStringH; s: PWideString); cdecl; external Qt5PasLib name 'QString_push_front2';
function QString_isNull(handle: QStringH): Boolean; cdecl; external Qt5PasLib name 'QString_isNull';
function QString_isSimpleText(handle: QStringH): Boolean; cdecl; external Qt5PasLib name 'QString_isSimpleText';
function QString_isRightToLeft(handle: QStringH): Boolean; cdecl; external Qt5PasLib name 'QString_isRightToLeft';
function QString_Create(size: Integer; AnonParam2: QtInitialization): QStringH; cdecl; external Qt5PasLib name 'QString_Create8';

function QStringList_Create(): QStringListH; cdecl; external Qt5PasLib name 'QStringList_Create';
procedure QStringList_Destroy(handle: QStringListH); cdecl; external Qt5PasLib name 'QStringList_Destroy'; 
function QStringList_Create(i: PWideString): QStringListH; cdecl; external Qt5PasLib name 'QStringList_Create2';
function QStringList_Create(l: QStringListH): QStringListH; cdecl; external Qt5PasLib name 'QStringList_Create3';
procedure QStringList_sort(handle: QStringListH; cs: QtCaseSensitivity = QtCaseSensitive); cdecl; external Qt5PasLib name 'QStringList_sort';
function QStringList_removeDuplicates(handle: QStringListH): Integer; cdecl; external Qt5PasLib name 'QStringList_removeDuplicates';
procedure QStringList_join(handle: QStringListH; retval: PWideString; sep: PWideString); cdecl; external Qt5PasLib name 'QStringList_join';
procedure QStringList_join(handle: QStringListH; retval: PWideString; sep: PWideChar); cdecl; external Qt5PasLib name 'QStringList_join2';
procedure QStringList_filter(handle: QStringListH; retval: QStringListH; str: PWideString; cs: QtCaseSensitivity = QtCaseSensitive); cdecl; external Qt5PasLib name 'QStringList_filter';
function QStringList_contains(handle: QStringListH; str: PWideString; cs: QtCaseSensitivity = QtCaseSensitive): Boolean; cdecl; external Qt5PasLib name 'QStringList_contains';
function QStringList_replaceInStrings(handle: QStringListH; before: PWideString; after: PWideString; cs: QtCaseSensitivity = QtCaseSensitive): QStringListH; cdecl; external Qt5PasLib name 'QStringList_replaceInStrings';
procedure QStringList_filter(handle: QStringListH; retval: QStringListH; rx: QRegExpH); cdecl; external Qt5PasLib name 'QStringList_filter2';
function QStringList_replaceInStrings(handle: QStringListH; rx: QRegExpH; after: PWideString): QStringListH; cdecl; external Qt5PasLib name 'QStringList_replaceInStrings2';
function QStringList_indexOf(handle: QStringListH; rx: QRegExpH; from: Integer = 0): Integer; cdecl; external Qt5PasLib name 'QStringList_indexOf';
function QStringList_lastIndexOf(handle: QStringListH; rx: QRegExpH; from: Integer = -1): Integer; cdecl; external Qt5PasLib name 'QStringList_lastIndexOf';
procedure QStringList_filter(handle: QStringListH; retval: QStringListH; re: QRegularExpressionH); cdecl; external Qt5PasLib name 'QStringList_filter3';
function QStringList_replaceInStrings(handle: QStringListH; re: QRegularExpressionH; after: PWideString): QStringListH; cdecl; external Qt5PasLib name 'QStringList_replaceInStrings3';
function QStringList_indexOf(handle: QStringListH; re: QRegularExpressionH; from: Integer = 0): Integer; cdecl; external Qt5PasLib name 'QStringList_indexOf3';
function QStringList_lastIndexOf(handle: QStringListH; re: QRegularExpressionH; from: Integer = -1): Integer; cdecl; external Qt5PasLib name 'QStringList_lastIndexOf3';
function QStringList_size(handle: QStringListH): Integer; cdecl; external Qt5PasLib name 'QStringList_size';
function QStringList_isEmpty(handle: QStringListH): Boolean; cdecl; external Qt5PasLib name 'QStringList_isEmpty';
procedure QStringList_clear(handle: QStringListH); cdecl; external Qt5PasLib name 'QStringList_clear';
procedure QStringList_at(handle: QStringListH; retval: PWideString; i: Integer); cdecl; external Qt5PasLib name 'QStringList_at';
procedure QStringList_append(handle: QStringListH; s: PWideString); cdecl; external Qt5PasLib name 'QStringList_append';
procedure QStringList_prepend(handle: QStringListH; s: PWideString); cdecl; external Qt5PasLib name 'QStringList_prepend';
procedure QStringList_insert(handle: QStringListH; i: Integer; s: PWideString); cdecl; external Qt5PasLib name 'QStringList_insert';
procedure QStringList_replace(handle: QStringListH; i: Integer; s: PWideString); cdecl; external Qt5PasLib name 'QStringList_replace';
procedure QStringList_removeAt(handle: QStringListH; i: Integer); cdecl; external Qt5PasLib name 'QStringList_removeAt';
function QStringList_removeAll(handle: QStringListH; s: PWideString): Integer; cdecl; external Qt5PasLib name 'QStringList_removeAll';
procedure QStringList_takeAt(handle: QStringListH; retval: PWideString; i: Integer); cdecl; external Qt5PasLib name 'QStringList_takeAt';
procedure QStringList_takeFirst(handle: QStringListH; retval: PWideString); cdecl; external Qt5PasLib name 'QStringList_takeFirst';
procedure QStringList_takeLast(handle: QStringListH; retval: PWideString); cdecl; external Qt5PasLib name 'QStringList_takeLast';
procedure QStringList_move(handle: QStringListH; from: Integer; _to: Integer); cdecl; external Qt5PasLib name 'QStringList_move';
procedure QStringList_swap(handle: QStringListH; i: Integer; j: Integer); cdecl; external Qt5PasLib name 'QStringList_swap';


function QMargins_Create(): QMarginsH; cdecl; external Qt5PasLib name 'QMargins_Create';
function QMargins_Create(left: integer; top: integer; right: integer; bottom: integer): QMarginsH; cdecl; external Qt5PasLib name 'QMargins_Create2';
procedure QMargins_Destroy(handle: QMarginsH); cdecl; external Qt5PasLib name 'QMargins_Destroy';
function QMargins_isNull(handle: QMarginsH): boolean; cdecl; external Qt5PasLib name 'QMargins_isNull';
function QMargins_left(handle: QMarginsH): integer; cdecl; external Qt5PasLib name 'QMargins_left';
function QMargins_top(handle: QMarginsH): integer; cdecl; external Qt5PasLib name 'QMargins_top';
function QMargins_right(handle: QMarginsH): integer; cdecl; external Qt5PasLib name 'QMargins_right';
function QMargins_bottom(handle: QMarginsH): integer; cdecl; external Qt5PasLib name 'QMargins_bottom';
procedure QMargins_setLeft(handle: QMarginsH; left: integer); cdecl; external Qt5PasLib name 'QMargins_setLeft';
procedure QMargins_setTop(handle: QMarginsH; top: integer); cdecl; external Qt5PasLib name 'QMargins_setTop';
procedure QMargins_setRight(handle: QMarginsH; right: integer); cdecl; external Qt5PasLib name 'QMargins_setRight';
procedure QMargins_setBottom(handle: QMarginsH; bottom: integer); cdecl; external Qt5PasLib name 'QMargins_setBottom';


function QRect_Create(): QRectH; cdecl; external Qt5PasLib name 'QRect_Create';
procedure QRect_Destroy(handle: QRectH); cdecl; external Qt5PasLib name 'QRect_Destroy'; 
function QRect_Create(topleft: PQtPoint; bottomright: PQtPoint): QRectH; cdecl; external Qt5PasLib name 'QRect_Create2';
function QRect_Create(topleft: PQtPoint; size: PSize): QRectH; cdecl; external Qt5PasLib name 'QRect_Create3';
function QRect_Create(left: Integer; top: Integer; width: Integer; height: Integer): QRectH; cdecl; external Qt5PasLib name 'QRect_Create4';
function QRect_isNull(handle: QRectH): Boolean; cdecl; external Qt5PasLib name 'QRect_isNull';
function QRect_isEmpty(handle: QRectH): Boolean; cdecl; external Qt5PasLib name 'QRect_isEmpty';
function QRect_isValid(handle: QRectH): Boolean; cdecl; external Qt5PasLib name 'QRect_isValid';
function QRect_left(handle: QRectH): Integer; cdecl; external Qt5PasLib name 'QRect_left';
function QRect_top(handle: QRectH): Integer; cdecl; external Qt5PasLib name 'QRect_top';
function QRect_right(handle: QRectH): Integer; cdecl; external Qt5PasLib name 'QRect_right';
function QRect_bottom(handle: QRectH): Integer; cdecl; external Qt5PasLib name 'QRect_bottom';
procedure QRect_normalized(handle: QRectH; retval: PRect); cdecl; external Qt5PasLib name 'QRect_normalized';
function QRect_x(handle: QRectH): Integer; cdecl; external Qt5PasLib name 'QRect_x';
function QRect_y(handle: QRectH): Integer; cdecl; external Qt5PasLib name 'QRect_y';
procedure QRect_setLeft(handle: QRectH; pos: Integer); cdecl; external Qt5PasLib name 'QRect_setLeft';
procedure QRect_setTop(handle: QRectH; pos: Integer); cdecl; external Qt5PasLib name 'QRect_setTop';
procedure QRect_setRight(handle: QRectH; pos: Integer); cdecl; external Qt5PasLib name 'QRect_setRight';
procedure QRect_setBottom(handle: QRectH; pos: Integer); cdecl; external Qt5PasLib name 'QRect_setBottom';
procedure QRect_setX(handle: QRectH; x: Integer); cdecl; external Qt5PasLib name 'QRect_setX';
procedure QRect_setY(handle: QRectH; y: Integer); cdecl; external Qt5PasLib name 'QRect_setY';
procedure QRect_setTopLeft(handle: QRectH; p: PQtPoint); cdecl; external Qt5PasLib name 'QRect_setTopLeft';
procedure QRect_setBottomRight(handle: QRectH; p: PQtPoint); cdecl; external Qt5PasLib name 'QRect_setBottomRight';
procedure QRect_setTopRight(handle: QRectH; p: PQtPoint); cdecl; external Qt5PasLib name 'QRect_setTopRight';
procedure QRect_setBottomLeft(handle: QRectH; p: PQtPoint); cdecl; external Qt5PasLib name 'QRect_setBottomLeft';
procedure QRect_topLeft(handle: QRectH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QRect_topLeft';
procedure QRect_bottomRight(handle: QRectH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QRect_bottomRight';
procedure QRect_topRight(handle: QRectH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QRect_topRight';
procedure QRect_bottomLeft(handle: QRectH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QRect_bottomLeft';
procedure QRect_center(handle: QRectH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QRect_center';
procedure QRect_moveLeft(handle: QRectH; pos: Integer); cdecl; external Qt5PasLib name 'QRect_moveLeft';
procedure QRect_moveTop(handle: QRectH; pos: Integer); cdecl; external Qt5PasLib name 'QRect_moveTop';
procedure QRect_moveRight(handle: QRectH; pos: Integer); cdecl; external Qt5PasLib name 'QRect_moveRight';
procedure QRect_moveBottom(handle: QRectH; pos: Integer); cdecl; external Qt5PasLib name 'QRect_moveBottom';
procedure QRect_moveTopLeft(handle: QRectH; p: PQtPoint); cdecl; external Qt5PasLib name 'QRect_moveTopLeft';
procedure QRect_moveBottomRight(handle: QRectH; p: PQtPoint); cdecl; external Qt5PasLib name 'QRect_moveBottomRight';
procedure QRect_moveTopRight(handle: QRectH; p: PQtPoint); cdecl; external Qt5PasLib name 'QRect_moveTopRight';
procedure QRect_moveBottomLeft(handle: QRectH; p: PQtPoint); cdecl; external Qt5PasLib name 'QRect_moveBottomLeft';
procedure QRect_moveCenter(handle: QRectH; p: PQtPoint); cdecl; external Qt5PasLib name 'QRect_moveCenter';
procedure QRect_translate(handle: QRectH; dx: Integer; dy: Integer); cdecl; external Qt5PasLib name 'QRect_translate';
procedure QRect_translate(handle: QRectH; p: PQtPoint); cdecl; external Qt5PasLib name 'QRect_translate2';
procedure QRect_translated(handle: QRectH; retval: PRect; dx: Integer; dy: Integer); cdecl; external Qt5PasLib name 'QRect_translated';
procedure QRect_translated(handle: QRectH; retval: PRect; p: PQtPoint); cdecl; external Qt5PasLib name 'QRect_translated2';
procedure QRect_moveTo(handle: QRectH; x: Integer; t: Integer); cdecl; external Qt5PasLib name 'QRect_moveTo';
procedure QRect_moveTo(handle: QRectH; p: PQtPoint); cdecl; external Qt5PasLib name 'QRect_moveTo2';
procedure QRect_setRect(handle: QRectH; x: Integer; y: Integer; w: Integer; h: Integer); cdecl; external Qt5PasLib name 'QRect_setRect';
procedure QRect_getRect(handle: QRectH; x: PInteger; y: PInteger; w: PInteger; h: PInteger); cdecl; external Qt5PasLib name 'QRect_getRect';
procedure QRect_setCoords(handle: QRectH; x1: Integer; y1: Integer; x2: Integer; y2: Integer); cdecl; external Qt5PasLib name 'QRect_setCoords';
procedure QRect_getCoords(handle: QRectH; x1: PInteger; y1: PInteger; x2: PInteger; y2: PInteger); cdecl; external Qt5PasLib name 'QRect_getCoords';
procedure QRect_adjust(handle: QRectH; x1: Integer; y1: Integer; x2: Integer; y2: Integer); cdecl; external Qt5PasLib name 'QRect_adjust';
procedure QRect_adjusted(handle: QRectH; retval: PRect; x1: Integer; y1: Integer; x2: Integer; y2: Integer); cdecl; external Qt5PasLib name 'QRect_adjusted';
procedure QRect_size(handle: QRectH; retval: PSize); cdecl; external Qt5PasLib name 'QRect_size';
function QRect_width(handle: QRectH): Integer; cdecl; external Qt5PasLib name 'QRect_width';
function QRect_height(handle: QRectH): Integer; cdecl; external Qt5PasLib name 'QRect_height';
procedure QRect_setWidth(handle: QRectH; w: Integer); cdecl; external Qt5PasLib name 'QRect_setWidth';
procedure QRect_setHeight(handle: QRectH; h: Integer); cdecl; external Qt5PasLib name 'QRect_setHeight';
procedure QRect_setSize(handle: QRectH; s: PSize); cdecl; external Qt5PasLib name 'QRect_setSize';
function QRect_contains(handle: QRectH; r: PRect; proper: Boolean = False): Boolean; cdecl; external Qt5PasLib name 'QRect_contains';
function QRect_contains(handle: QRectH; p: PQtPoint; proper: Boolean = False): Boolean; cdecl; external Qt5PasLib name 'QRect_contains2';
function QRect_contains(handle: QRectH; x: Integer; y: Integer): Boolean; cdecl; external Qt5PasLib name 'QRect_contains3';
function QRect_contains(handle: QRectH; x: Integer; y: Integer; proper: Boolean): Boolean; cdecl; external Qt5PasLib name 'QRect_contains4';
procedure QRect_united(handle: QRectH; retval: PRect; other: PRect); cdecl; external Qt5PasLib name 'QRect_united';
procedure QRect_intersected(handle: QRectH; retval: PRect; other: PRect); cdecl; external Qt5PasLib name 'QRect_intersected';
function QRect_intersects(handle: QRectH; r: PRect): Boolean; cdecl; external Qt5PasLib name 'QRect_intersects';
procedure QRect_marginsAdded(handle: QRectH; retval: PRect; margins: QMarginsH); cdecl; external Qt5PasLib name 'QRect_marginsAdded';
procedure QRect_marginsRemoved(handle: QRectH; retval: PRect; margins: QMarginsH); cdecl; external Qt5PasLib name 'QRect_marginsRemoved';

function QRectF_Create(): QRectFH; cdecl; external Qt5PasLib name 'QRectF_Create';
procedure QRectF_Destroy(handle: QRectFH); cdecl; external Qt5PasLib name 'QRectF_Destroy'; 
function QRectF_Create(topleft: PQtPointF; size: QSizeFH): QRectFH; cdecl; external Qt5PasLib name 'QRectF_Create2';
function QRectF_Create(topleft: PQtPointF; bottomRight: PQtPointF): QRectFH; cdecl; external Qt5PasLib name 'QRectF_Create3';
function QRectF_Create(left: qreal; top: qreal; width: qreal; height: qreal): QRectFH; cdecl; external Qt5PasLib name 'QRectF_Create4';
function QRectF_Create(rect: PRect): QRectFH; cdecl; external Qt5PasLib name 'QRectF_Create5';
function QRectF_isNull(handle: QRectFH): Boolean; cdecl; external Qt5PasLib name 'QRectF_isNull';
function QRectF_isEmpty(handle: QRectFH): Boolean; cdecl; external Qt5PasLib name 'QRectF_isEmpty';
function QRectF_isValid(handle: QRectFH): Boolean; cdecl; external Qt5PasLib name 'QRectF_isValid';
procedure QRectF_normalized(handle: QRectFH; retval: QRectFH); cdecl; external Qt5PasLib name 'QRectF_normalized';
function QRectF_left(handle: QRectFH): qreal; cdecl; external Qt5PasLib name 'QRectF_left';
function QRectF_top(handle: QRectFH): qreal; cdecl; external Qt5PasLib name 'QRectF_top';
function QRectF_right(handle: QRectFH): qreal; cdecl; external Qt5PasLib name 'QRectF_right';
function QRectF_bottom(handle: QRectFH): qreal; cdecl; external Qt5PasLib name 'QRectF_bottom';
function QRectF_x(handle: QRectFH): qreal; cdecl; external Qt5PasLib name 'QRectF_x';
function QRectF_y(handle: QRectFH): qreal; cdecl; external Qt5PasLib name 'QRectF_y';
procedure QRectF_setLeft(handle: QRectFH; pos: qreal); cdecl; external Qt5PasLib name 'QRectF_setLeft';
procedure QRectF_setTop(handle: QRectFH; pos: qreal); cdecl; external Qt5PasLib name 'QRectF_setTop';
procedure QRectF_setRight(handle: QRectFH; pos: qreal); cdecl; external Qt5PasLib name 'QRectF_setRight';
procedure QRectF_setBottom(handle: QRectFH; pos: qreal); cdecl; external Qt5PasLib name 'QRectF_setBottom';
procedure QRectF_setX(handle: QRectFH; pos: qreal); cdecl; external Qt5PasLib name 'QRectF_setX';
procedure QRectF_setY(handle: QRectFH; pos: qreal); cdecl; external Qt5PasLib name 'QRectF_setY';
procedure QRectF_topLeft(handle: QRectFH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QRectF_topLeft';
procedure QRectF_bottomRight(handle: QRectFH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QRectF_bottomRight';
procedure QRectF_topRight(handle: QRectFH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QRectF_topRight';
procedure QRectF_bottomLeft(handle: QRectFH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QRectF_bottomLeft';
procedure QRectF_center(handle: QRectFH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QRectF_center';
procedure QRectF_setTopLeft(handle: QRectFH; p: PQtPointF); cdecl; external Qt5PasLib name 'QRectF_setTopLeft';
procedure QRectF_setBottomRight(handle: QRectFH; p: PQtPointF); cdecl; external Qt5PasLib name 'QRectF_setBottomRight';
procedure QRectF_setTopRight(handle: QRectFH; p: PQtPointF); cdecl; external Qt5PasLib name 'QRectF_setTopRight';
procedure QRectF_setBottomLeft(handle: QRectFH; p: PQtPointF); cdecl; external Qt5PasLib name 'QRectF_setBottomLeft';
procedure QRectF_moveLeft(handle: QRectFH; pos: qreal); cdecl; external Qt5PasLib name 'QRectF_moveLeft';
procedure QRectF_moveTop(handle: QRectFH; pos: qreal); cdecl; external Qt5PasLib name 'QRectF_moveTop';
procedure QRectF_moveRight(handle: QRectFH; pos: qreal); cdecl; external Qt5PasLib name 'QRectF_moveRight';
procedure QRectF_moveBottom(handle: QRectFH; pos: qreal); cdecl; external Qt5PasLib name 'QRectF_moveBottom';
procedure QRectF_moveTopLeft(handle: QRectFH; p: PQtPointF); cdecl; external Qt5PasLib name 'QRectF_moveTopLeft';
procedure QRectF_moveBottomRight(handle: QRectFH; p: PQtPointF); cdecl; external Qt5PasLib name 'QRectF_moveBottomRight';
procedure QRectF_moveTopRight(handle: QRectFH; p: PQtPointF); cdecl; external Qt5PasLib name 'QRectF_moveTopRight';
procedure QRectF_moveBottomLeft(handle: QRectFH; p: PQtPointF); cdecl; external Qt5PasLib name 'QRectF_moveBottomLeft';
procedure QRectF_moveCenter(handle: QRectFH; p: PQtPointF); cdecl; external Qt5PasLib name 'QRectF_moveCenter';
procedure QRectF_translate(handle: QRectFH; dx: qreal; dy: qreal); cdecl; external Qt5PasLib name 'QRectF_translate';
procedure QRectF_translate(handle: QRectFH; p: PQtPointF); cdecl; external Qt5PasLib name 'QRectF_translate2';
procedure QRectF_translated(handle: QRectFH; retval: QRectFH; dx: qreal; dy: qreal); cdecl; external Qt5PasLib name 'QRectF_translated';
procedure QRectF_translated(handle: QRectFH; retval: QRectFH; p: PQtPointF); cdecl; external Qt5PasLib name 'QRectF_translated2';
procedure QRectF_moveTo(handle: QRectFH; x: qreal; t: qreal); cdecl; external Qt5PasLib name 'QRectF_moveTo';
procedure QRectF_moveTo(handle: QRectFH; p: PQtPointF); cdecl; external Qt5PasLib name 'QRectF_moveTo2';
procedure QRectF_setRect(handle: QRectFH; x: qreal; y: qreal; w: qreal; h: qreal); cdecl; external Qt5PasLib name 'QRectF_setRect';
procedure QRectF_getRect(handle: QRectFH; x: PQReal; y: PQReal; w: PQReal; h: PQReal); cdecl; external Qt5PasLib name 'QRectF_getRect';
procedure QRectF_setCoords(handle: QRectFH; x1: qreal; y1: qreal; x2: qreal; y2: qreal); cdecl; external Qt5PasLib name 'QRectF_setCoords';
procedure QRectF_getCoords(handle: QRectFH; x1: PQReal; y1: PQReal; x2: PQReal; y2: PQReal); cdecl; external Qt5PasLib name 'QRectF_getCoords';
procedure QRectF_adjust(handle: QRectFH; x1: qreal; y1: qreal; x2: qreal; y2: qreal); cdecl; external Qt5PasLib name 'QRectF_adjust';
procedure QRectF_adjusted(handle: QRectFH; retval: QRectFH; x1: qreal; y1: qreal; x2: qreal; y2: qreal); cdecl; external Qt5PasLib name 'QRectF_adjusted';
procedure QRectF_size(handle: QRectFH; retval: QSizeFH); cdecl; external Qt5PasLib name 'QRectF_size';
function QRectF_width(handle: QRectFH): qreal; cdecl; external Qt5PasLib name 'QRectF_width';
function QRectF_height(handle: QRectFH): qreal; cdecl; external Qt5PasLib name 'QRectF_height';
procedure QRectF_setWidth(handle: QRectFH; w: qreal); cdecl; external Qt5PasLib name 'QRectF_setWidth';
procedure QRectF_setHeight(handle: QRectFH; h: qreal); cdecl; external Qt5PasLib name 'QRectF_setHeight';
procedure QRectF_setSize(handle: QRectFH; s: QSizeFH); cdecl; external Qt5PasLib name 'QRectF_setSize';
function QRectF_contains(handle: QRectFH; r: QRectFH): Boolean; cdecl; external Qt5PasLib name 'QRectF_contains';
function QRectF_contains(handle: QRectFH; p: PQtPointF): Boolean; cdecl; external Qt5PasLib name 'QRectF_contains2';
function QRectF_contains(handle: QRectFH; x: qreal; y: qreal): Boolean; cdecl; external Qt5PasLib name 'QRectF_contains3';
procedure QRectF_united(handle: QRectFH; retval: QRectFH; other: QRectFH); cdecl; external Qt5PasLib name 'QRectF_united';
procedure QRectF_intersected(handle: QRectFH; retval: QRectFH; other: QRectFH); cdecl; external Qt5PasLib name 'QRectF_intersected';
function QRectF_intersects(handle: QRectFH; r: QRectFH): Boolean; cdecl; external Qt5PasLib name 'QRectF_intersects';
procedure QRectF_toRect(handle: QRectFH; retval: PRect); cdecl; external Qt5PasLib name 'QRectF_toRect';
procedure QRectF_toAlignedRect(handle: QRectFH; retval: PRect); cdecl; external Qt5PasLib name 'QRectF_toAlignedRect';


type
  QDateMonthNameType = (  //QDate::MonthNameType (2)
    QDateDateFormat = 0,
    QDateStandaloneFormat );

function QDate_Create(): QDateH; cdecl; external Qt5PasLib name 'QDate_Create';
procedure QDate_Destroy(handle: QDateH); cdecl; external Qt5PasLib name 'QDate_Destroy'; 
function QDate_Create(y: Integer; m: Integer; d: Integer): QDateH; cdecl; external Qt5PasLib name 'QDate_Create2';
function QDate_isNull(handle: QDateH): Boolean; cdecl; external Qt5PasLib name 'QDate_isNull';
function QDate_isValid(handle: QDateH): Boolean; cdecl; external Qt5PasLib name 'QDate_isValid';
function QDate_year(handle: QDateH): Integer; cdecl; external Qt5PasLib name 'QDate_year';
function QDate_month(handle: QDateH): Integer; cdecl; external Qt5PasLib name 'QDate_month';
function QDate_day(handle: QDateH): Integer; cdecl; external Qt5PasLib name 'QDate_day';
function QDate_dayOfWeek(handle: QDateH): Integer; cdecl; external Qt5PasLib name 'QDate_dayOfWeek';
function QDate_dayOfYear(handle: QDateH): Integer; cdecl; external Qt5PasLib name 'QDate_dayOfYear';
function QDate_daysInMonth(handle: QDateH): Integer; cdecl; external Qt5PasLib name 'QDate_daysInMonth';
function QDate_daysInYear(handle: QDateH): Integer; cdecl; external Qt5PasLib name 'QDate_daysInYear';
function QDate_weekNumber(handle: QDateH; yearNum: PInteger = nil): Integer; cdecl; external Qt5PasLib name 'QDate_weekNumber';
procedure QDate_shortMonthName(retval: PWideString; month: Integer; _type: QDateMonthNameType = QDateDateFormat); cdecl; external Qt5PasLib name 'QDate_shortMonthName';
procedure QDate_shortDayName(retval: PWideString; weekday: Integer; _type: QDateMonthNameType = QDateDateFormat); cdecl; external Qt5PasLib name 'QDate_shortDayName';
procedure QDate_longMonthName(retval: PWideString; month: Integer; _type: QDateMonthNameType = QDateDateFormat); cdecl; external Qt5PasLib name 'QDate_longMonthName';
procedure QDate_longDayName(retval: PWideString; weekday: Integer; _type: QDateMonthNameType = QDateDateFormat); cdecl; external Qt5PasLib name 'QDate_longDayName';
procedure QDate_toString(handle: QDateH; retval: PWideString; f: QtDateFormat = QtTextDate); cdecl; external Qt5PasLib name 'QDate_toString';
procedure QDate_toString(handle: QDateH; retval: PWideString; format: PWideString); cdecl; external Qt5PasLib name 'QDate_toString2';
function QDate_setDate(handle: QDateH; year: Integer; month: Integer; day: Integer): Boolean; cdecl; external Qt5PasLib name 'QDate_setDate';
procedure QDate_getDate(handle: QDateH; year: PInteger; month: PInteger; day: PInteger); cdecl; external Qt5PasLib name 'QDate_getDate';
procedure QDate_addDays(handle: QDateH; retval: QDateH; days: int64); cdecl; external Qt5PasLib name 'QDate_addDays';
procedure QDate_addMonths(handle: QDateH; retval: QDateH; months: Integer); cdecl; external Qt5PasLib name 'QDate_addMonths';
procedure QDate_addYears(handle: QDateH; retval: QDateH; years: Integer); cdecl; external Qt5PasLib name 'QDate_addYears';
function QDate_daysTo(handle: QDateH; AnonParam1: QDateH): int64; cdecl; external Qt5PasLib name 'QDate_daysTo';
procedure QDate_currentDate(retval: QDateH); cdecl; external Qt5PasLib name 'QDate_currentDate';
procedure QDate_fromString(retval: QDateH; s: PWideString; f: QtDateFormat = QtTextDate); cdecl; external Qt5PasLib name 'QDate_fromString';
procedure QDate_fromString(retval: QDateH; s: PWideString; format: PWideString); cdecl; external Qt5PasLib name 'QDate_fromString2';
function QDate_isValid(y: Integer; m: Integer; d: Integer): Boolean; cdecl; external Qt5PasLib name 'QDate_isValid2';
function QDate_isLeapYear(year: Integer): Boolean; cdecl; external Qt5PasLib name 'QDate_isLeapYear';
procedure QDate_fromJulianDay(retval: QDateH; jd: int64); cdecl; external Qt5PasLib name 'QDate_fromJulianDay';
function QDate_toJulianDay(handle: QDateH): int64; cdecl; external Qt5PasLib name 'QDate_toJulianDay';

function QTime_Create(): QTimeH; cdecl; external Qt5PasLib name 'QTime_Create';
procedure QTime_Destroy(handle: QTimeH); cdecl; external Qt5PasLib name 'QTime_Destroy'; 
function QTime_Create(h: Integer; m: Integer; s: Integer = 0; ms: Integer = 0): QTimeH; cdecl; external Qt5PasLib name 'QTime_Create2';
function QTime_isNull(handle: QTimeH): Boolean; cdecl; external Qt5PasLib name 'QTime_isNull';
function QTime_isValid(handle: QTimeH): Boolean; cdecl; external Qt5PasLib name 'QTime_isValid';
function QTime_hour(handle: QTimeH): Integer; cdecl; external Qt5PasLib name 'QTime_hour';
function QTime_minute(handle: QTimeH): Integer; cdecl; external Qt5PasLib name 'QTime_minute';
function QTime_second(handle: QTimeH): Integer; cdecl; external Qt5PasLib name 'QTime_second';
function QTime_msec(handle: QTimeH): Integer; cdecl; external Qt5PasLib name 'QTime_msec';
procedure QTime_toString(handle: QTimeH; retval: PWideString; f: QtDateFormat = QtTextDate); cdecl; external Qt5PasLib name 'QTime_toString';
procedure QTime_toString(handle: QTimeH; retval: PWideString; format: PWideString); cdecl; external Qt5PasLib name 'QTime_toString2';
function QTime_setHMS(handle: QTimeH; h: Integer; m: Integer; s: Integer; ms: Integer = 0): Boolean; cdecl; external Qt5PasLib name 'QTime_setHMS';
procedure QTime_addSecs(handle: QTimeH; retval: QTimeH; secs: Integer); cdecl; external Qt5PasLib name 'QTime_addSecs';
function QTime_secsTo(handle: QTimeH; AnonParam1: QTimeH): Integer; cdecl; external Qt5PasLib name 'QTime_secsTo';
procedure QTime_addMSecs(handle: QTimeH; retval: QTimeH; ms: Integer); cdecl; external Qt5PasLib name 'QTime_addMSecs';
function QTime_msecsTo(handle: QTimeH; AnonParam1: QTimeH): Integer; cdecl; external Qt5PasLib name 'QTime_msecsTo';
procedure QTime_currentTime(retval: QTimeH); cdecl; external Qt5PasLib name 'QTime_currentTime';
procedure QTime_fromString(retval: QTimeH; s: PWideString; f: QtDateFormat = QtTextDate); cdecl; external Qt5PasLib name 'QTime_fromString';
procedure QTime_fromString(retval: QTimeH; s: PWideString; format: PWideString); cdecl; external Qt5PasLib name 'QTime_fromString2';
function QTime_isValid(h: Integer; m: Integer; s: Integer; ms: Integer = 0): Boolean; cdecl; external Qt5PasLib name 'QTime_isValid2';
procedure QTime_start(handle: QTimeH); cdecl; external Qt5PasLib name 'QTime_start';
function QTime_restart(handle: QTimeH): Integer; cdecl; external Qt5PasLib name 'QTime_restart';
function QTime_elapsed(handle: QTimeH): Integer; cdecl; external Qt5PasLib name 'QTime_elapsed';

function QDateTime_Create(): QDateTimeH; cdecl; external Qt5PasLib name 'QDateTime_Create';
procedure QDateTime_Destroy(handle: QDateTimeH); cdecl; external Qt5PasLib name 'QDateTime_Destroy'; 
function QDateTime_Create(AnonParam1: QDateH): QDateTimeH; cdecl; external Qt5PasLib name 'QDateTime_Create2';
function QDateTime_Create(AnonParam1: QDateH; AnonParam2: QTimeH; spec: QtTimeSpec = QtLocalTime): QDateTimeH; cdecl; external Qt5PasLib name 'QDateTime_Create3';
function QDateTime_Create(other: QDateTimeH): QDateTimeH; cdecl; external Qt5PasLib name 'QDateTime_Create4';
procedure QDateTime_swap(handle: QDateTimeH; other: QDateTimeH); cdecl; external Qt5PasLib name 'QDateTime_swap';
function QDateTime_isNull(handle: QDateTimeH): Boolean; cdecl; external Qt5PasLib name 'QDateTime_isNull';
function QDateTime_isValid(handle: QDateTimeH): Boolean; cdecl; external Qt5PasLib name 'QDateTime_isValid';
procedure QDateTime_date(handle: QDateTimeH; retval: QDateH); cdecl; external Qt5PasLib name 'QDateTime_date';
procedure QDateTime_time(handle: QDateTimeH; retval: QTimeH); cdecl; external Qt5PasLib name 'QDateTime_time';
function QDateTime_timeSpec(handle: QDateTimeH): QtTimeSpec; cdecl; external Qt5PasLib name 'QDateTime_timeSpec';
function QDateTime_toMSecsSinceEpoch(handle: QDateTimeH): int64; cdecl; external Qt5PasLib name 'QDateTime_toMSecsSinceEpoch';
function QDateTime_toTime_t(handle: QDateTimeH): LongWord; cdecl; external Qt5PasLib name 'QDateTime_toTime_t';
procedure QDateTime_setDate(handle: QDateTimeH; date: QDateH); cdecl; external Qt5PasLib name 'QDateTime_setDate';
procedure QDateTime_setTime(handle: QDateTimeH; time: QTimeH); cdecl; external Qt5PasLib name 'QDateTime_setTime';
procedure QDateTime_setTimeSpec(handle: QDateTimeH; spec: QtTimeSpec); cdecl; external Qt5PasLib name 'QDateTime_setTimeSpec';
procedure QDateTime_setMSecsSinceEpoch(handle: QDateTimeH; msecs: int64); cdecl; external Qt5PasLib name 'QDateTime_setMSecsSinceEpoch';
procedure QDateTime_setTime_t(handle: QDateTimeH; secsSince1Jan1970UTC: LongWord); cdecl; external Qt5PasLib name 'QDateTime_setTime_t';
procedure QDateTime_toString(handle: QDateTimeH; retval: PWideString; f: QtDateFormat = QtTextDate); cdecl; external Qt5PasLib name 'QDateTime_toString';
procedure QDateTime_toString(handle: QDateTimeH; retval: PWideString; format: PWideString); cdecl; external Qt5PasLib name 'QDateTime_toString2';
procedure QDateTime_addDays(handle: QDateTimeH; retval: QDateTimeH; days: int64); cdecl; external Qt5PasLib name 'QDateTime_addDays';
procedure QDateTime_addMonths(handle: QDateTimeH; retval: QDateTimeH; months: Integer); cdecl; external Qt5PasLib name 'QDateTime_addMonths';
procedure QDateTime_addYears(handle: QDateTimeH; retval: QDateTimeH; years: Integer); cdecl; external Qt5PasLib name 'QDateTime_addYears';
procedure QDateTime_addSecs(handle: QDateTimeH; retval: QDateTimeH; secs: int64); cdecl; external Qt5PasLib name 'QDateTime_addSecs';
procedure QDateTime_addMSecs(handle: QDateTimeH; retval: QDateTimeH; msecs: int64); cdecl; external Qt5PasLib name 'QDateTime_addMSecs';
procedure QDateTime_toTimeSpec(handle: QDateTimeH; retval: QDateTimeH; spec: QtTimeSpec); cdecl; external Qt5PasLib name 'QDateTime_toTimeSpec';
procedure QDateTime_toLocalTime(handle: QDateTimeH; retval: QDateTimeH); cdecl; external Qt5PasLib name 'QDateTime_toLocalTime';
procedure QDateTime_toUTC(handle: QDateTimeH; retval: QDateTimeH); cdecl; external Qt5PasLib name 'QDateTime_toUTC';
function QDateTime_daysTo(handle: QDateTimeH; AnonParam1: QDateTimeH): int64; cdecl; external Qt5PasLib name 'QDateTime_daysTo';
function QDateTime_secsTo(handle: QDateTimeH; AnonParam1: QDateTimeH): int64; cdecl; external Qt5PasLib name 'QDateTime_secsTo';
function QDateTime_msecsTo(handle: QDateTimeH; AnonParam1: QDateTimeH): int64; cdecl; external Qt5PasLib name 'QDateTime_msecsTo';
procedure QDateTime_setUtcOffset(handle: QDateTimeH; seconds: Integer); cdecl; external Qt5PasLib name 'QDateTime_setUtcOffset';
function QDateTime_utcOffset(handle: QDateTimeH): Integer; cdecl; external Qt5PasLib name 'QDateTime_utcOffset';
procedure QDateTime_currentDateTime(retval: QDateTimeH); cdecl; external Qt5PasLib name 'QDateTime_currentDateTime';
procedure QDateTime_currentDateTimeUtc(retval: QDateTimeH); cdecl; external Qt5PasLib name 'QDateTime_currentDateTimeUtc';
procedure QDateTime_fromString(retval: QDateTimeH; s: PWideString; f: QtDateFormat = QtTextDate); cdecl; external Qt5PasLib name 'QDateTime_fromString';
procedure QDateTime_fromString(retval: QDateTimeH; s: PWideString; format: PWideString); cdecl; external Qt5PasLib name 'QDateTime_fromString2';
procedure QDateTime_fromTime_t(retval: QDateTimeH; secsSince1Jan1970UTC: LongWord); cdecl; external Qt5PasLib name 'QDateTime_fromTime_t';
procedure QDateTime_fromMSecsSinceEpoch(retval: QDateTimeH; msecs: int64); cdecl; external Qt5PasLib name 'QDateTime_fromMSecsSinceEpoch';
function QDateTime_currentMSecsSinceEpoch(): int64; cdecl; external Qt5PasLib name 'QDateTime_currentMSecsSinceEpoch';


function QByteArray_Create(): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_Create';
procedure QByteArray_Destroy(handle: QByteArrayH); cdecl; external Qt5PasLib name 'QByteArray_Destroy'; 
function QByteArray_Create(AnonParam1: PAnsiChar; size: Integer = -1): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_Create2';
function QByteArray_Create(size: Integer; c: char): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_Create3';
function QByteArray_Create(size: Integer; AnonParam2: QtInitialization): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_Create4';
function QByteArray_Create(AnonParam1: QByteArrayH): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_Create5';
procedure QByteArray_swap(handle: QByteArrayH; other: QByteArrayH); cdecl; external Qt5PasLib name 'QByteArray_swap';
function QByteArray_size(handle: QByteArrayH): Integer; cdecl; external Qt5PasLib name 'QByteArray_size';
function QByteArray_isEmpty(handle: QByteArrayH): Boolean; cdecl; external Qt5PasLib name 'QByteArray_isEmpty';
procedure QByteArray_resize(handle: QByteArrayH; size: Integer); cdecl; external Qt5PasLib name 'QByteArray_resize';
function QByteArray_fill(handle: QByteArrayH; c: char; size: Integer = -1): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_fill';
function QByteArray_capacity(handle: QByteArrayH): Integer; cdecl; external Qt5PasLib name 'QByteArray_capacity';
procedure QByteArray_reserve(handle: QByteArrayH; size: Integer); cdecl; external Qt5PasLib name 'QByteArray_reserve';
procedure QByteArray_squeeze(handle: QByteArrayH); cdecl; external Qt5PasLib name 'QByteArray_squeeze';
function QByteArray_data(handle: QByteArrayH): PAnsiChar; cdecl; external Qt5PasLib name 'QByteArray_data';
function QByteArray_constData(handle: QByteArrayH): PAnsiChar; cdecl; external Qt5PasLib name 'QByteArray_constData';
procedure QByteArray_detach(handle: QByteArrayH); cdecl; external Qt5PasLib name 'QByteArray_detach';
function QByteArray_isDetached(handle: QByteArrayH): Boolean; cdecl; external Qt5PasLib name 'QByteArray_isDetached';
function QByteArray_isSharedWith(handle: QByteArrayH; other: QByteArrayH): Boolean; cdecl; external Qt5PasLib name 'QByteArray_isSharedWith';
procedure QByteArray_clear(handle: QByteArrayH); cdecl; external Qt5PasLib name 'QByteArray_clear';
function QByteArray_at(handle: QByteArrayH; i: Integer): char; cdecl; external Qt5PasLib name 'QByteArray_at';
function QByteArray_indexOf(handle: QByteArrayH; c: char; from: Integer = 0): Integer; cdecl; external Qt5PasLib name 'QByteArray_indexOf';
function QByteArray_indexOf(handle: QByteArrayH; c: PAnsiChar; from: Integer = 0): Integer; cdecl; external Qt5PasLib name 'QByteArray_indexOf2';
function QByteArray_indexOf(handle: QByteArrayH; a: QByteArrayH; from: Integer = 0): Integer; cdecl; external Qt5PasLib name 'QByteArray_indexOf3';
function QByteArray_lastIndexOf(handle: QByteArrayH; c: char; from: Integer = -1): Integer; cdecl; external Qt5PasLib name 'QByteArray_lastIndexOf';
function QByteArray_lastIndexOf(handle: QByteArrayH; c: PAnsiChar; from: Integer = -1): Integer; cdecl; external Qt5PasLib name 'QByteArray_lastIndexOf2';
function QByteArray_lastIndexOf(handle: QByteArrayH; a: QByteArrayH; from: Integer = -1): Integer; cdecl; external Qt5PasLib name 'QByteArray_lastIndexOf3';
function QByteArray_contains(handle: QByteArrayH; c: char): Boolean; cdecl; external Qt5PasLib name 'QByteArray_contains';
function QByteArray_contains(handle: QByteArrayH; a: PAnsiChar): Boolean; cdecl; external Qt5PasLib name 'QByteArray_contains2';
function QByteArray_contains(handle: QByteArrayH; a: QByteArrayH): Boolean; cdecl; external Qt5PasLib name 'QByteArray_contains3';
function QByteArray_count(handle: QByteArrayH; c: char): Integer; cdecl; external Qt5PasLib name 'QByteArray_count';
function QByteArray_count(handle: QByteArrayH; a: PAnsiChar): Integer; cdecl; external Qt5PasLib name 'QByteArray_count2';
function QByteArray_count(handle: QByteArrayH; a: QByteArrayH): Integer; cdecl; external Qt5PasLib name 'QByteArray_count3';
procedure QByteArray_left(handle: QByteArrayH; retval: QByteArrayH; len: Integer); cdecl; external Qt5PasLib name 'QByteArray_left';
procedure QByteArray_right(handle: QByteArrayH; retval: QByteArrayH; len: Integer); cdecl; external Qt5PasLib name 'QByteArray_right';
procedure QByteArray_mid(handle: QByteArrayH; retval: QByteArrayH; index: Integer; len: Integer = -1); cdecl; external Qt5PasLib name 'QByteArray_mid';
function QByteArray_startsWith(handle: QByteArrayH; a: QByteArrayH): Boolean; cdecl; external Qt5PasLib name 'QByteArray_startsWith';
function QByteArray_startsWith(handle: QByteArrayH; c: char): Boolean; cdecl; external Qt5PasLib name 'QByteArray_startsWith2';
function QByteArray_startsWith(handle: QByteArrayH; c: PAnsiChar): Boolean; cdecl; external Qt5PasLib name 'QByteArray_startsWith3';
function QByteArray_endsWith(handle: QByteArrayH; a: QByteArrayH): Boolean; cdecl; external Qt5PasLib name 'QByteArray_endsWith';
function QByteArray_endsWith(handle: QByteArrayH; c: char): Boolean; cdecl; external Qt5PasLib name 'QByteArray_endsWith2';
function QByteArray_endsWith(handle: QByteArrayH; c: PAnsiChar): Boolean; cdecl; external Qt5PasLib name 'QByteArray_endsWith3';
procedure QByteArray_truncate(handle: QByteArrayH; pos: Integer); cdecl; external Qt5PasLib name 'QByteArray_truncate';
procedure QByteArray_chop(handle: QByteArrayH; n: Integer); cdecl; external Qt5PasLib name 'QByteArray_chop';
procedure QByteArray_toLower(handle: QByteArrayH; retval: QByteArrayH); cdecl; external Qt5PasLib name 'QByteArray_toLower';
procedure QByteArray_toUpper(handle: QByteArrayH; retval: QByteArrayH); cdecl; external Qt5PasLib name 'QByteArray_toUpper';
procedure QByteArray_trimmed(handle: QByteArrayH; retval: QByteArrayH); cdecl; external Qt5PasLib name 'QByteArray_trimmed';
procedure QByteArray_simplified(handle: QByteArrayH; retval: QByteArrayH); cdecl; external Qt5PasLib name 'QByteArray_simplified';
procedure QByteArray_leftJustified(handle: QByteArrayH; retval: QByteArrayH; width: Integer; fill: char; truncate: Boolean = False); cdecl; external Qt5PasLib name 'QByteArray_leftJustified';
procedure QByteArray_rightJustified(handle: QByteArrayH; retval: QByteArrayH; width: Integer; fill: char; truncate: Boolean = False); cdecl; external Qt5PasLib name 'QByteArray_rightJustified';
function QByteArray_prepend(handle: QByteArrayH; c: char): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_prepend';
function QByteArray_prepend(handle: QByteArrayH; s: PAnsiChar): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_prepend2';
function QByteArray_prepend(handle: QByteArrayH; s: PAnsiChar; len: Integer): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_prepend3';
function QByteArray_prepend(handle: QByteArrayH; a: QByteArrayH): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_prepend4';
function QByteArray_append(handle: QByteArrayH; c: char): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_append';
function QByteArray_append(handle: QByteArrayH; s: PAnsiChar): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_append2';
function QByteArray_append(handle: QByteArrayH; s: PAnsiChar; len: Integer): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_append3';
function QByteArray_append(handle: QByteArrayH; a: QByteArrayH): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_append4';
function QByteArray_insert(handle: QByteArrayH; i: Integer; c: char): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_insert';
function QByteArray_insert(handle: QByteArrayH; i: Integer; s: PAnsiChar): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_insert2';
function QByteArray_insert(handle: QByteArrayH; i: Integer; s: PAnsiChar; len: Integer): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_insert3';
function QByteArray_insert(handle: QByteArrayH; i: Integer; a: QByteArrayH): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_insert4';
function QByteArray_remove(handle: QByteArrayH; index: Integer; len: Integer): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_remove';
function QByteArray_replace(handle: QByteArrayH; index: Integer; len: Integer; s: PAnsiChar): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_replace';
function QByteArray_replace(handle: QByteArrayH; index: Integer; len: Integer; s: PAnsiChar; alen: Integer): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_replace2';
function QByteArray_replace(handle: QByteArrayH; index: Integer; len: Integer; s: QByteArrayH): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_replace3';
function QByteArray_replace(handle: QByteArrayH; before: char; after: PAnsiChar): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_replace4';
function QByteArray_replace(handle: QByteArrayH; before: char; after: QByteArrayH): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_replace5';
function QByteArray_replace(handle: QByteArrayH; before: PAnsiChar; after: PAnsiChar): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_replace6';
function QByteArray_replace(handle: QByteArrayH; before: PAnsiChar; bsize: Integer; after: PAnsiChar; asize: Integer): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_replace7';
function QByteArray_replace(handle: QByteArrayH; before: QByteArrayH; after: QByteArrayH): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_replace8';
function QByteArray_replace(handle: QByteArrayH; before: QByteArrayH; after: PAnsiChar): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_replace9';
function QByteArray_replace(handle: QByteArrayH; before: PAnsiChar; after: QByteArrayH): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_replace10';
function QByteArray_replace(handle: QByteArrayH; before: char; after: char): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_replace11';
procedure QByteArray_repeated(handle: QByteArrayH; retval: QByteArrayH; times: Integer); cdecl; external Qt5PasLib name 'QByteArray_repeated';
function QByteArray_append(handle: QByteArrayH; s: PWideString): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_append5';
function QByteArray_insert(handle: QByteArrayH; i: Integer; s: PWideString): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_insert5';
function QByteArray_replace(handle: QByteArrayH; before: PWideString; after: PAnsiChar): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_replace12';
function QByteArray_replace(handle: QByteArrayH; c: char; after: PWideString): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_replace13';
function QByteArray_replace(handle: QByteArrayH; before: PWideString; after: QByteArrayH): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_replace14';
function QByteArray_indexOf(handle: QByteArrayH; s: PWideString; from: Integer = 0): Integer; cdecl; external Qt5PasLib name 'QByteArray_indexOf4';
function QByteArray_lastIndexOf(handle: QByteArrayH; s: PWideString; from: Integer = -1): Integer; cdecl; external Qt5PasLib name 'QByteArray_lastIndexOf4';
function QByteArray_toShort(handle: QByteArrayH; ok: PBoolean = nil; base: Integer = 10): ShortInt; cdecl; external Qt5PasLib name 'QByteArray_toShort';
function QByteArray_toUShort(handle: QByteArrayH; ok: PBoolean = nil; base: Integer = 10): Word; cdecl; external Qt5PasLib name 'QByteArray_toUShort';
function QByteArray_toInt(handle: QByteArrayH; ok: PBoolean = nil; base: Integer = 10): Integer; cdecl; external Qt5PasLib name 'QByteArray_toInt';
function QByteArray_toUInt(handle: QByteArrayH; ok: PBoolean = nil; base: Integer = 10): LongWord; cdecl; external Qt5PasLib name 'QByteArray_toUInt';
function QByteArray_toLong(handle: QByteArrayH; ok: PBoolean = nil; base: Integer = 10): Long; cdecl; external Qt5PasLib name 'QByteArray_toLong';
function QByteArray_toULong(handle: QByteArrayH; ok: PBoolean = nil; base: Integer = 10): Longword; cdecl; external Qt5PasLib name 'QByteArray_toULong';
function QByteArray_toLongLong(handle: QByteArrayH; ok: PBoolean = nil; base: Integer = 10): int64; cdecl; external Qt5PasLib name 'QByteArray_toLongLong';
function QByteArray_toULongLong(handle: QByteArrayH; ok: PBoolean = nil; base: Integer = 10): qword; cdecl; external Qt5PasLib name 'QByteArray_toULongLong';
function QByteArray_toFloat(handle: QByteArrayH; ok: PBoolean = nil): Single; cdecl; external Qt5PasLib name 'QByteArray_toFloat';
function QByteArray_toDouble(handle: QByteArrayH; ok: PBoolean = nil): Double; cdecl; external Qt5PasLib name 'QByteArray_toDouble';
procedure QByteArray_toBase64(handle: QByteArrayH; retval: QByteArrayH); cdecl; external Qt5PasLib name 'QByteArray_toBase64';
procedure QByteArray_toHex(handle: QByteArrayH; retval: QByteArrayH); cdecl; external Qt5PasLib name 'QByteArray_toHex';
procedure QByteArray_toPercentEncoding(handle: QByteArrayH; retval: QByteArrayH; exclude: QByteArrayH; include: QByteArrayH; percent: char); cdecl; external Qt5PasLib name 'QByteArray_toPercentEncoding';
function QByteArray_setNum(handle: QByteArrayH; AnonParam1: ShortInt; base: Integer = 10): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_setNum';
function QByteArray_setNum(handle: QByteArrayH; AnonParam1: Word; base: Integer = 10): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_setNum2';
function QByteArray_setNum(handle: QByteArrayH; AnonParam1: Integer; base: Integer = 10): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_setNum3';
function QByteArray_setNum(handle: QByteArrayH; AnonParam1: LongWord; base: Integer = 10): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_setNum4';
function QByteArray_setNum(handle: QByteArrayH; AnonParam1: int64; base: Integer = 10): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_setNum5';
function QByteArray_setNum(handle: QByteArrayH; AnonParam1: qword; base: Integer = 10): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_setNum6';
function QByteArray_setNum(handle: QByteArrayH; AnonParam1: Single; f: char; prec: Integer = 6): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_setNum7';
function QByteArray_setNum(handle: QByteArrayH; AnonParam1: Double; f: char; prec: Integer = 6): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_setNum8';
function QByteArray_setRawData(handle: QByteArrayH; a: PAnsiChar; n: LongWord): QByteArrayH; cdecl; external Qt5PasLib name 'QByteArray_setRawData';
procedure QByteArray_number(retval: QByteArrayH; AnonParam1: Integer; base: Integer = 10); cdecl; external Qt5PasLib name 'QByteArray_number';
procedure QByteArray_number(retval: QByteArrayH; AnonParam1: LongWord; base: Integer = 10); cdecl; external Qt5PasLib name 'QByteArray_number2';
procedure QByteArray_number(retval: QByteArrayH; AnonParam1: int64; base: Integer = 10); cdecl; external Qt5PasLib name 'QByteArray_number3';
procedure QByteArray_number(retval: QByteArrayH; AnonParam1: qword; base: Integer = 10); cdecl; external Qt5PasLib name 'QByteArray_number4';
procedure QByteArray_number(retval: QByteArrayH; AnonParam1: Double; f: char; prec: Integer = 6); cdecl; external Qt5PasLib name 'QByteArray_number5';
procedure QByteArray_fromRawData(retval: QByteArrayH; AnonParam1: PAnsiChar; size: Integer); cdecl; external Qt5PasLib name 'QByteArray_fromRawData';
procedure QByteArray_fromBase64(retval: QByteArrayH; base64: QByteArrayH); cdecl; external Qt5PasLib name 'QByteArray_fromBase64';
procedure QByteArray_fromHex(retval: QByteArrayH; hexEncoded: QByteArrayH); cdecl; external Qt5PasLib name 'QByteArray_fromHex';
procedure QByteArray_fromPercentEncoding(retval: QByteArrayH; pctEncoded: QByteArrayH; percent: char); cdecl; external Qt5PasLib name 'QByteArray_fromPercentEncoding';
procedure QByteArray_push_back(handle: QByteArrayH; c: char); cdecl; external Qt5PasLib name 'QByteArray_push_back';
procedure QByteArray_push_back(handle: QByteArrayH; c: PAnsiChar); cdecl; external Qt5PasLib name 'QByteArray_push_back2';
procedure QByteArray_push_back(handle: QByteArrayH; a: QByteArrayH); cdecl; external Qt5PasLib name 'QByteArray_push_back3';
procedure QByteArray_push_front(handle: QByteArrayH; c: char); cdecl; external Qt5PasLib name 'QByteArray_push_front';
procedure QByteArray_push_front(handle: QByteArrayH; c: PAnsiChar); cdecl; external Qt5PasLib name 'QByteArray_push_front2';
procedure QByteArray_push_front(handle: QByteArrayH; a: QByteArrayH); cdecl; external Qt5PasLib name 'QByteArray_push_front3';
function QByteArray_count(handle: QByteArrayH): Integer; cdecl; external Qt5PasLib name 'QByteArray_count4';
function QByteArray_length(handle: QByteArrayH): Integer; cdecl; external Qt5PasLib name 'QByteArray_length';
function QByteArray_isNull(handle: QByteArrayH): Boolean; cdecl; external Qt5PasLib name 'QByteArray_isNull';



type
  QLocaleFormatType = ( // QLocale::FormatType (1)
    QLocaleLongFormat, QLocaleShortFormat, QLocaleNarrowFormat );

  QLocaleCurrencySymbolFormat = ( // QLocale::CurrencySymbolFormat (1)
    QLocaleCurrencyIsoCode, QLocaleCurrencySymbol, QLocaleCurrencyDisplayName );

  QLocaleQuotationStyle = ( // QLocale::QuotationStyle (1)
    QLocaleStandardQuotation, QLocaleAlternateQuotation );

type
  QLocaleNumberOption = cardinal; // QLocale::NumberOption
  QLocaleNumberOptions = QLocaleNumberOption; //QFlags<> (3)
const
  QLocaleOmitGroupSeparator =   $01;
  QLocaleRejectGroupSeparator =   $02;

type
  QLocaleLanguage = cardinal; //  QLocale::Language (4)

const
    QLocaleAnyLanguage = 0 { $0 };
    QLocaleC = 1 { $1 };
    QLocaleAbkhazian = 2 { $2 };
    QLocaleOromo = 3 { $3 };
    QLocaleAfar = 4 { $4 };
    QLocaleAfrikaans = 5 { $5 };
    QLocaleAlbanian = 6 { $6 };
    QLocaleAmharic = 7 { $7 };
    QLocaleArabic = 8 { $8 };
    QLocaleArmenian = 9 { $9 };
    QLocaleAssamese = 10 { $a };
    QLocaleAymara = 11 { $b };
    QLocaleAzerbaijani = 12 { $c };
    QLocaleBashkir = 13 { $d };
    QLocaleBasque = 14 { $e };
    QLocaleBengali = 15 { $f };
    QLocaleDzongkha = 16 { $10 };
    QLocaleBihari = 17 { $11 };
    QLocaleBislama = 18 { $12 };
    QLocaleBreton = 19 { $13 };
    QLocaleBulgarian = 20 { $14 };
    QLocaleBurmese = 21 { $15 };
    QLocaleBelarusian = 22 { $16 };
    QLocaleKhmer = 23 { $17 };
    QLocaleCatalan = 24 { $18 };
    QLocaleChinese = 25 { $19 };
    QLocaleCorsican = 26 { $1a };
    QLocaleCroatian = 27 { $1b };
    QLocaleCzech = 28 { $1c };
    QLocaleDanish = 29 { $1d };
    QLocaleDutch = 30 { $1e };
    QLocaleEnglish = 31 { $1f };
    QLocaleEsperanto = 32 { $20 };
    QLocaleEstonian = 33 { $21 };
    QLocaleFaroese = 34 { $22 };
    QLocaleFijian = 35 { $23 };
    QLocaleFinnish = 36 { $24 };
    QLocaleFrench = 37 { $25 };
    QLocaleWesternFrisian = 38 { $26 };
    QLocaleGaelic = 39 { $27 };
    QLocaleGalician = 40 { $28 };
    QLocaleGeorgian = 41 { $29 };
    QLocaleGerman = 42 { $2a };
    QLocaleGreek = 43 { $2b };
    QLocaleGreenlandic = 44 { $2c };
    QLocaleGuarani = 45 { $2d };
    QLocaleGujarati = 46 { $2e };
    QLocaleHausa = 47 { $2f };
    QLocaleHebrew = 48 { $30 };
    QLocaleHindi = 49 { $31 };
    QLocaleHungarian = 50 { $32 };
    QLocaleIcelandic = 51 { $33 };
    QLocaleIndonesian = 52 { $34 };
    QLocaleInterlingua = 53 { $35 };
    QLocaleInterlingue = 54 { $36 };
    QLocaleInuktitut = 55 { $37 };
    QLocaleInupiak = 56 { $38 };
    QLocaleIrish = 57 { $39 };
    QLocaleItalian = 58 { $3a };
    QLocaleJapanese = 59 { $3b };
    QLocaleJavanese = 60 { $3c };
    QLocaleKannada = 61 { $3d };
    QLocaleKashmiri = 62 { $3e };
    QLocaleKazakh = 63 { $3f };
    QLocaleKinyarwanda = 64 { $40 };
    QLocaleKirghiz = 65 { $41 };
    QLocaleKorean = 66 { $42 };
    QLocaleKurdish = 67 { $43 };
    QLocaleRundi = 68 { $44 };
    QLocaleLao = 69 { $45 };
    QLocaleLatin = 70 { $46 };
    QLocaleLatvian = 71 { $47 };
    QLocaleLingala = 72 { $48 };
    QLocaleLithuanian = 73 { $49 };
    QLocaleMacedonian = 74 { $4a };
    QLocaleMalagasy = 75 { $4b };
    QLocaleMalay = 76 { $4c };
    QLocaleMalayalam = 77 { $4d };
    QLocaleMaltese = 78 { $4e };
    QLocaleMaori = 79 { $4f };
    QLocaleMarathi = 80 { $50 };
    QLocaleMarshallese = 81 { $51 };
    QLocaleMongolian = 82 { $52 };
    QLocaleNauruLanguage = 83 { $53 };
    QLocaleNepali = 84 { $54 };
    QLocaleNorwegianBokmal = 85 { $55 };
    QLocaleOccitan = 86 { $56 };
    QLocaleOriya = 87 { $57 };
    QLocalePashto = 88 { $58 };
    QLocalePersian = 89 { $59 };
    QLocalePolish = 90 { $5a };
    QLocalePortuguese = 91 { $5b };
    QLocalePunjabi = 92 { $5c };
    QLocaleQuechua = 93 { $5d };
    QLocaleRomansh = 94 { $5e };
    QLocaleRomanian = 95 { $5f };
    QLocaleRussian = 96 { $60 };
    QLocaleSamoan = 97 { $61 };
    QLocaleSango = 98 { $62 };
    QLocaleSanskrit = 99 { $63 };
    QLocaleSerbian = 100 { $64 };
    QLocaleOssetic = 101 { $65 };
    QLocaleSouthernSotho = 102 { $66 };
    QLocaleTswana = 103 { $67 };
    QLocaleShona = 104 { $68 };
    QLocaleSindhi = 105 { $69 };
    QLocaleSinhala = 106 { $6a };
    QLocaleSwati = 107 { $6b };
    QLocaleSlovak = 108 { $6c };
    QLocaleSlovenian = 109 { $6d };
    QLocaleSomali = 110 { $6e };
    QLocaleSpanish = 111 { $6f };
    QLocaleSundanese = 112 { $70 };
    QLocaleSwahili = 113 { $71 };
    QLocaleSwedish = 114 { $72 };
    QLocaleSardinian = 115 { $73 };
    QLocaleTajik = 116 { $74 };
    QLocaleTamil = 117 { $75 };
    QLocaleTatar = 118 { $76 };
    QLocaleTelugu = 119 { $77 };
    QLocaleThai = 120 { $78 };
    QLocaleTibetan = 121 { $79 };
    QLocaleTigrinya = 122 { $7a };
    QLocaleTongan = 123 { $7b };
    QLocaleTsonga = 124 { $7c };
    QLocaleTurkish = 125 { $7d };
    QLocaleTurkmen = 126 { $7e };
    QLocaleTahitian = 127 { $7f };
    QLocaleUighur = 128 { $80 };
    QLocaleUkrainian = 129 { $81 };
    QLocaleUrdu = 130 { $82 };
    QLocaleUzbek = 131 { $83 };
    QLocaleVietnamese = 132 { $84 };
    QLocaleVolapuk = 133 { $85 };
    QLocaleWelsh = 134 { $86 };
    QLocaleWolof = 135 { $87 };
    QLocaleXhosa = 136 { $88 };
    QLocaleYiddish = 137 { $89 };
    QLocaleYoruba = 138 { $8a };
    QLocaleZhuang = 139 { $8b };
    QLocaleZulu = 140 { $8c };
    QLocaleNorwegianNynorsk = 141 { $8d };
    QLocaleBosnian = 142 { $8e };
    QLocaleDivehi = 143 { $8f };
    QLocaleManx = 144 { $90 };
    QLocaleCornish = 145 { $91 };
    QLocaleAkan = 146 { $92 };
    QLocaleKonkani = 147 { $93 };
    QLocaleGa = 148 { $94 };
    QLocaleIgbo = 149 { $95 };
    QLocaleKamba = 150 { $96 };
    QLocaleSyriac = 151 { $97 };
    QLocaleBlin = 152 { $98 };
    QLocaleGeez = 153 { $99 };
    QLocaleKoro = 154 { $9a };
    QLocaleSidamo = 155 { $9b };
    QLocaleAtsam = 156 { $9c };
    QLocaleTigre = 157 { $9d };
    QLocaleJju = 158 { $9e };
    QLocaleFriulian = 159 { $9f };
    QLocaleVenda = 160 { $a0 };
    QLocaleEwe = 161 { $a1 };
    QLocaleWalamo = 162 { $a2 };
    QLocaleHawaiian = 163 { $a3 };
    QLocaleTyap = 164 { $a4 };
    QLocaleNyanja = 165 { $a5 };
    QLocaleFilipino = 166 { $a6 };
    QLocaleSwissGerman = 167 { $a7 };
    QLocaleSichuanYi = 168 { $a8 };
    QLocaleKpelle = 169 { $a9 };
    QLocaleLowGerman = 170 { $aa };
    QLocaleSouthNdebele = 171 { $ab };
    QLocaleNorthernSotho = 172 { $ac };
    QLocaleNorthernSami = 173 { $ad };
    QLocaleTaroko = 174 { $ae };
    QLocaleGusii = 175 { $af };
    QLocaleTaita = 176 { $b0 };
    QLocaleFulah = 177 { $b1 };
    QLocaleKikuyu = 178 { $b2 };
    QLocaleSamburu = 179 { $b3 };
    QLocaleSena = 180 { $b4 };
    QLocaleNorthNdebele = 181 { $b5 };
    QLocaleRombo = 182 { $b6 };
    QLocaleTachelhit = 183 { $b7 };
    QLocaleKabyle = 184 { $b8 };
    QLocaleNyankole = 185 { $b9 };
    QLocaleBena = 186 { $ba };
    QLocaleVunjo = 187 { $bb };
    QLocaleBambara = 188 { $bc };
    QLocaleEmbu = 189 { $bd };
    QLocaleCherokee = 190 { $be };
    QLocaleMorisyen = 191 { $bf };
    QLocaleMakonde = 192 { $c0 };
    QLocaleLangi = 193 { $c1 };
    QLocaleGanda = 194 { $c2 };
    QLocaleBemba = 195 { $c3 };
    QLocaleKabuverdianu = 196 { $c4 };
    QLocaleMeru = 197 { $c5 };
    QLocaleKalenjin = 198 { $c6 };
    QLocaleNama = 199 { $c7 };
    QLocaleMachame = 200 { $c8 };
    QLocaleColognian = 201 { $c9 };
    QLocaleMasai = 202 { $ca };
    QLocaleSoga = 203 { $cb };
    QLocaleLuyia = 204 { $cc };
    QLocaleAsu = 205 { $cd };
    QLocaleTeso = 206 { $ce };
    QLocaleSaho = 207 { $cf };
    QLocaleKoyraChiini = 208 { $d0 };
    QLocaleRwa = 209 { $d1 };
    QLocaleLuo = 210 { $d2 };
    QLocaleChiga = 211 { $d3 };
    QLocaleCentralMoroccoTamazight = 212 { $d4 };
    QLocaleKoyraboroSenni = 213 { $d5 };
    QLocaleShambala = 214 { $d6 };
    QLocaleBodo = 215 { $d7 };
    QLocaleAvaric = 216 { $d8 };
    QLocaleChamorro = 217 { $d9 };
    QLocaleChechen = 218 { $da };
    QLocaleChurch = 219 { $db };
    QLocaleChuvash = 220 { $dc };
    QLocaleCree = 221 { $dd };
    QLocaleHaitian = 222 { $de };
    QLocaleHerero = 223 { $df };
    QLocaleHiriMotu = 224 { $e0 };
    QLocaleKanuri = 225 { $e1 };
    QLocaleKomi = 226 { $e2 };
    QLocaleKongo = 227 { $e3 };
    QLocaleKwanyama = 228 { $e4 };
    QLocaleLimburgish = 229 { $e5 };
    QLocaleLubaKatanga = 230 { $e6 };
    QLocaleLuxembourgish = 231 { $e7 };
    QLocaleNavaho = 232 { $e8 };
    QLocaleNdonga = 233 { $e9 };
    QLocaleOjibwa = 234 { $ea };
    QLocalePali = 235 { $eb };
    QLocaleWalloon = 236 { $ec };
    QLocaleAghem = 237 { $ed };
    QLocaleBasaa = 238 { $ee };
    QLocaleZarma = 239 { $ef };
    QLocaleDuala = 240 { $f0 };
    QLocaleJolaFonyi = 241 { $f1 };
    QLocaleEwondo = 242 { $f2 };
    QLocaleBafia = 243 { $f3 };
    QLocaleMakhuwaMeetto = 244 { $f4 };
    QLocaleMundang = 245 { $f5 };
    QLocaleKwasio = 246 { $f6 };
    QLocaleNuer = 247 { $f7 };
    QLocaleSakha = 248 { $f8 };
    QLocaleSangu = 249 { $f9 };
    QLocaleCongoSwahili = 250 { $fa };
    QLocaleTasawaq = 251 { $fb };
    QLocaleVai = 252 { $fc };
    QLocaleWalser = 253 { $fd };
    QLocaleYangben = 254 { $fe };
    QLocaleAvestan = 255 { $ff };
    QLocaleAsturian = 256 { $100 };
    QLocaleNgomba = 257 { $101 };
    QLocaleKako = 258 { $102 };
    QLocaleMeta = 259 { $103 };
    QLocaleNgiemboon = 260 { $104 };
    QLocaleAragonese = 261 { $105 };
    QLocaleAkkadian = 262 { $106 };
    QLocaleAncientEgyptian = 263 { $107 };
    QLocaleAncientGreek = 264 { $108 };
    QLocaleAramaic = 265 { $109 };
    QLocaleBalinese = 266 { $10a };
    QLocaleBamun = 267 { $10b };
    QLocaleBatakToba = 268 { $10c };
    QLocaleBuginese = 269 { $10d };
    QLocaleBuhid = 270 { $10e };
    QLocaleCarian = 271 { $10f };
    QLocaleChakma = 272 { $110 };
    QLocaleClassicalMandaic = 273 { $111 };
    QLocaleCoptic = 274 { $112 };
    QLocaleDogri = 275 { $113 };
    QLocaleEasternCham = 276 { $114 };
    QLocaleEasternKayah = 277 { $115 };
    QLocaleEtruscan = 278 { $116 };
    QLocaleGothic = 279 { $117 };
    QLocaleHanunoo = 280 { $118 };
    QLocaleIngush = 281 { $119 };
    QLocaleLargeFloweryMiao = 282 { $11a };
    QLocaleLepcha = 283 { $11b };
    QLocaleLimbu = 284 { $11c };
    QLocaleLisu = 285 { $11d };
    QLocaleLu = 286 { $11e };
    QLocaleLycian = 287 { $11f };
    QLocaleLydian = 288 { $120 };
    QLocaleMandingo = 289 { $121 };
    QLocaleManipuri = 290 { $122 };
    QLocaleMeroitic = 291 { $123 };
    QLocaleNorthernThai = 292 { $124 };
    QLocaleOldIrish = 293 { $125 };
    QLocaleOldNorse = 294 { $126 };
    QLocaleOldPersian = 295 { $127 };
    QLocaleOldTurkish = 296 { $128 };
    QLocalePahlavi = 297 { $129 };
    QLocaleParthian = 298 { $12a };
    QLocalePhoenician = 299 { $12b };
    QLocalePrakritLanguage = 300 { $12c };
    QLocaleRejang = 301 { $12d };
    QLocaleSabaean = 302 { $12e };
    QLocaleSamaritan = 303 { $12f };
    QLocaleSantali = 304 { $130 };
    QLocaleSaurashtra = 305 { $131 };
    QLocaleSora = 306 { $132 };
    QLocaleSylheti = 307 { $133 };
    QLocaleTagbanwa = 308 { $134 };
    QLocaleTaiDam = 309 { $135 };
    QLocaleTaiNua = 310 { $136 };
    QLocaleUgaritic = 311 { $137 };
    QLocaleNorwegian = 85 { $55 };
    QLocaleMoldavian = 95 { $5f };
    QLocaleSerboCroatian = 100 { $64 };
    QLocaleTagalog = 166 { $a6 };
    QLocaleTwi = 146 { $92 };
    QLocaleAfan = 3 { $3 };
    QLocaleByelorussian = 22 { $16 };
    QLocaleBhutani = 16 { $10 };
    QLocaleCambodian = 23 { $17 };
    QLocaleKurundi = 68 { $44 };
    QLocaleRhaetoRomance = 94 { $5e };
    QLocaleChewa = 165 { $a5 };
    QLocaleFrisian = 38 { $26 };
    QLocaleUigur = 128 { $80 };
    QLocaleLastLanguage = 311 { $137 };

type
  QLocaleScript = cardinal; //  QLocale::Script (4)

const
    QLocaleAnyScript = 0 { $0 };
    QLocaleArabicScript = 1 { $1 };
    QLocaleCyrillicScript = 2 { $2 };
    QLocaleDeseretScript = 3 { $3 };
    QLocaleGurmukhiScript = 4 { $4 };
    QLocaleSimplifiedHanScript = 5 { $5 };
    QLocaleTraditionalHanScript = 6 { $6 };
    QLocaleLatinScript = 7 { $7 };
    QLocaleMongolianScript = 8 { $8 };
    QLocaleTifinaghScript = 9 { $9 };
    QLocaleArmenianScript = 10 { $a };
    QLocaleBengaliScript = 11 { $b };
    QLocaleCherokeeScript = 12 { $c };
    QLocaleDevanagariScript = 13 { $d };
    QLocaleEthiopicScript = 14 { $e };
    QLocaleGeorgianScript = 15 { $f };
    QLocaleGreekScript = 16 { $10 };
    QLocaleGujaratiScript = 17 { $11 };
    QLocaleHebrewScript = 18 { $12 };
    QLocaleJapaneseScript = 19 { $13 };
    QLocaleKhmerScript = 20 { $14 };
    QLocaleKannadaScript = 21 { $15 };
    QLocaleKoreanScript = 22 { $16 };
    QLocaleLaoScript = 23 { $17 };
    QLocaleMalayalamScript = 24 { $18 };
    QLocaleMyanmarScript = 25 { $19 };
    QLocaleOriyaScript = 26 { $1a };
    QLocaleTamilScript = 27 { $1b };
    QLocaleTeluguScript = 28 { $1c };
    QLocaleThaanaScript = 29 { $1d };
    QLocaleThaiScript = 30 { $1e };
    QLocaleTibetanScript = 31 { $1f };
    QLocaleSinhalaScript = 32 { $20 };
    QLocaleSyriacScript = 33 { $21 };
    QLocaleYiScript = 34 { $22 };
    QLocaleVaiScript = 35 { $23 };
    QLocaleAvestanScript = 36 { $24 };
    QLocaleBalineseScript = 37 { $25 };
    QLocaleBamumScript = 38 { $26 };
    QLocaleBatakScript = 39 { $27 };
    QLocaleBopomofoScript = 40 { $28 };
    QLocaleBrahmiScript = 41 { $29 };
    QLocaleBugineseScript = 42 { $2a };
    QLocaleBuhidScript = 43 { $2b };
    QLocaleCanadianAboriginalScript = 44 { $2c };
    QLocaleCarianScript = 45 { $2d };
    QLocaleChakmaScript = 46 { $2e };
    QLocaleChamScript = 47 { $2f };
    QLocaleCopticScript = 48 { $30 };
    QLocaleCypriotScript = 49 { $31 };
    QLocaleEgyptianHieroglyphsScript = 50 { $32 };
    QLocaleFraserScript = 51 { $33 };
    QLocaleGlagoliticScript = 52 { $34 };
    QLocaleGothicScript = 53 { $35 };
    QLocaleHanScript = 54 { $36 };
    QLocaleHangulScript = 55 { $37 };
    QLocaleHanunooScript = 56 { $38 };
    QLocaleImperialAramaicScript = 57 { $39 };
    QLocaleInscriptionalPahlaviScript = 58 { $3a };
    QLocaleInscriptionalParthianScript = 59 { $3b };
    QLocaleJavaneseScript = 60 { $3c };
    QLocaleKaithiScript = 61 { $3d };
    QLocaleKatakanaScript = 62 { $3e };
    QLocaleKayahLiScript = 63 { $3f };
    QLocaleKharoshthiScript = 64 { $40 };
    QLocaleLannaScript = 65 { $41 };
    QLocaleLepchaScript = 66 { $42 };
    QLocaleLimbuScript = 67 { $43 };
    QLocaleLinearBScript = 68 { $44 };
    QLocaleLycianScript = 69 { $45 };
    QLocaleLydianScript = 70 { $46 };
    QLocaleMandaeanScript = 71 { $47 };
    QLocaleMeiteiMayekScript = 72 { $48 };
    QLocaleMeroiticScript = 73 { $49 };
    QLocaleMeroiticCursiveScript = 74 { $4a };
    QLocaleNkoScript = 75 { $4b };
    QLocaleNewTaiLueScript = 76 { $4c };
    QLocaleOghamScript = 77 { $4d };
    QLocaleOlChikiScript = 78 { $4e };
    QLocaleOldItalicScript = 79 { $4f };
    QLocaleOldPersianScript = 80 { $50 };
    QLocaleOldSouthArabianScript = 81 { $51 };
    QLocaleOrkhonScript = 82 { $52 };
    QLocaleOsmanyaScript = 83 { $53 };
    QLocalePhagsPaScript = 84 { $54 };
    QLocalePhoenicianScript = 85 { $55 };
    QLocalePollardPhoneticScript = 86 { $56 };
    QLocaleRejangScript = 87 { $57 };
    QLocaleRunicScript = 88 { $58 };
    QLocaleSamaritanScript = 89 { $59 };
    QLocaleSaurashtraScript = 90 { $5a };
    QLocaleSharadaScript = 91 { $5b };
    QLocaleShavianScript = 92 { $5c };
    QLocaleSoraSompengScript = 93 { $5d };
    QLocaleCuneiformScript = 94 { $5e };
    QLocaleSundaneseScript = 95 { $5f };
    QLocaleSylotiNagriScript = 96 { $60 };
    QLocaleTagalogScript = 97 { $61 };
    QLocaleTagbanwaScript = 98 { $62 };
    QLocaleTaiLeScript = 99 { $63 };
    QLocaleTaiVietScript = 100 { $64 };
    QLocaleTakriScript = 101 { $65 };
    QLocaleUgariticScript = 102 { $66 };
    QLocaleBrailleScript = 103 { $67 };
    QLocaleHiraganaScript = 104 { $68 };
    QLocaleSimplifiedChineseScript = 5 { $5 };
    QLocaleTraditionalChineseScript = 6 { $6 };
    QLocaleLastScript = 104 { $68 };

type
  QLocaleCountry = cardinal; //  QLocale::Country (4)

const
    QLocaleAnyCountry = 0 { $0 };
    QLocaleAfghanistan = 1 { $1 };
    QLocaleAlbania = 2 { $2 };
    QLocaleAlgeria = 3 { $3 };
    QLocaleAmericanSamoa = 4 { $4 };
    QLocaleAndorra = 5 { $5 };
    QLocaleAngola = 6 { $6 };
    QLocaleAnguilla = 7 { $7 };
    QLocaleAntarctica = 8 { $8 };
    QLocaleAntiguaAndBarbuda = 9 { $9 };
    QLocaleArgentina = 10 { $a };
    QLocaleArmenia = 11 { $b };
    QLocaleAruba = 12 { $c };
    QLocaleAustralia = 13 { $d };
    QLocaleAustria = 14 { $e };
    QLocaleAzerbaijan = 15 { $f };
    QLocaleBahamas = 16 { $10 };
    QLocaleBahrain = 17 { $11 };
    QLocaleBangladesh = 18 { $12 };
    QLocaleBarbados = 19 { $13 };
    QLocaleBelarus = 20 { $14 };
    QLocaleBelgium = 21 { $15 };
    QLocaleBelize = 22 { $16 };
    QLocaleBenin = 23 { $17 };
    QLocaleBermuda = 24 { $18 };
    QLocaleBhutan = 25 { $19 };
    QLocaleBolivia = 26 { $1a };
    QLocaleBosniaAndHerzegowina = 27 { $1b };
    QLocaleBotswana = 28 { $1c };
    QLocaleBouvetIsland = 29 { $1d };
    QLocaleBrazil = 30 { $1e };
    QLocaleBritishIndianOceanTerritory = 31 { $1f };
    QLocaleBrunei = 32 { $20 };
    QLocaleBulgaria = 33 { $21 };
    QLocaleBurkinaFaso = 34 { $22 };
    QLocaleBurundi = 35 { $23 };
    QLocaleCambodia = 36 { $24 };
    QLocaleCameroon = 37 { $25 };
    QLocaleCanada = 38 { $26 };
    QLocaleCapeVerde = 39 { $27 };
    QLocaleCaymanIslands = 40 { $28 };
    QLocaleCentralAfricanRepublic = 41 { $29 };
    QLocaleChad = 42 { $2a };
    QLocaleChile = 43 { $2b };
    QLocaleChina = 44 { $2c };
    QLocaleChristmasIsland = 45 { $2d };
    QLocaleCocosIslands = 46 { $2e };
    QLocaleColombia = 47 { $2f };
    QLocaleComoros = 48 { $30 };
    QLocaleCongoKinshasa = 49 { $31 };
    QLocaleCongoBrazzaville = 50 { $32 };
    QLocaleCookIslands = 51 { $33 };
    QLocaleCostaRica = 52 { $34 };
    QLocaleIvoryCoast = 53 { $35 };
    QLocaleCroatia = 54 { $36 };
    QLocaleCuba = 55 { $37 };
    QLocaleCyprus = 56 { $38 };
    QLocaleCzechRepublic = 57 { $39 };
    QLocaleDenmark = 58 { $3a };
    QLocaleDjibouti = 59 { $3b };
    QLocaleDominica = 60 { $3c };
    QLocaleDominicanRepublic = 61 { $3d };
    QLocaleEastTimor = 62 { $3e };
    QLocaleEcuador = 63 { $3f };
    QLocaleEgypt = 64 { $40 };
    QLocaleElSalvador = 65 { $41 };
    QLocaleEquatorialGuinea = 66 { $42 };
    QLocaleEritrea = 67 { $43 };
    QLocaleEstonia = 68 { $44 };
    QLocaleEthiopia = 69 { $45 };
    QLocaleFalklandIslands = 70 { $46 };
    QLocaleFaroeIslands = 71 { $47 };
    QLocaleFiji = 72 { $48 };
    QLocaleFinland = 73 { $49 };
    QLocaleFrance = 74 { $4a };
    QLocaleGuernsey = 75 { $4b };
    QLocaleFrenchGuiana = 76 { $4c };
    QLocaleFrenchPolynesia = 77 { $4d };
    QLocaleFrenchSouthernTerritories = 78 { $4e };
    QLocaleGabon = 79 { $4f };
    QLocaleGambia = 80 { $50 };
    QLocaleGeorgia = 81 { $51 };
    QLocaleGermany = 82 { $52 };
    QLocaleGhana = 83 { $53 };
    QLocaleGibraltar = 84 { $54 };
    QLocaleGreece = 85 { $55 };
    QLocaleGreenland = 86 { $56 };
    QLocaleGrenada = 87 { $57 };
    QLocaleGuadeloupe = 88 { $58 };
    QLocaleGuam = 89 { $59 };
    QLocaleGuatemala = 90 { $5a };
    QLocaleGuinea = 91 { $5b };
    QLocaleGuineaBissau = 92 { $5c };
    QLocaleGuyana = 93 { $5d };
    QLocaleHaiti = 94 { $5e };
    QLocaleHeardAndMcDonaldIslands = 95 { $5f };
    QLocaleHonduras = 96 { $60 };
    QLocaleHongKong = 97 { $61 };
    QLocaleHungary = 98 { $62 };
    QLocaleIceland = 99 { $63 };
    QLocaleIndia = 100 { $64 };
    QLocaleIndonesia = 101 { $65 };
    QLocaleIran = 102 { $66 };
    QLocaleIraq = 103 { $67 };
    QLocaleIreland = 104 { $68 };
    QLocaleIsrael = 105 { $69 };
    QLocaleItaly = 106 { $6a };
    QLocaleJamaica = 107 { $6b };
    QLocaleJapan = 108 { $6c };
    QLocaleJordan = 109 { $6d };
    QLocaleKazakhstan = 110 { $6e };
    QLocaleKenya = 111 { $6f };
    QLocaleKiribati = 112 { $70 };
    QLocaleNorthKorea = 113 { $71 };
    QLocaleSouthKorea = 114 { $72 };
    QLocaleKuwait = 115 { $73 };
    QLocaleKyrgyzstan = 116 { $74 };
    QLocaleLaos = 117 { $75 };
    QLocaleLatvia = 118 { $76 };
    QLocaleLebanon = 119 { $77 };
    QLocaleLesotho = 120 { $78 };
    QLocaleLiberia = 121 { $79 };
    QLocaleLibya = 122 { $7a };
    QLocaleLiechtenstein = 123 { $7b };
    QLocaleLithuania = 124 { $7c };
    QLocaleLuxembourg = 125 { $7d };
    QLocaleMacau = 126 { $7e };
    QLocaleMacedonia = 127 { $7f };
    QLocaleMadagascar = 128 { $80 };
    QLocaleMalawi = 129 { $81 };
    QLocaleMalaysia = 130 { $82 };
    QLocaleMaldives = 131 { $83 };
    QLocaleMali = 132 { $84 };
    QLocaleMalta = 133 { $85 };
    QLocaleMarshallIslands = 134 { $86 };
    QLocaleMartinique = 135 { $87 };
    QLocaleMauritania = 136 { $88 };
    QLocaleMauritius = 137 { $89 };
    QLocaleMayotte = 138 { $8a };
    QLocaleMexico = 139 { $8b };
    QLocaleMicronesia = 140 { $8c };
    QLocaleMoldova = 141 { $8d };
    QLocaleMonaco = 142 { $8e };
    QLocaleMongolia = 143 { $8f };
    QLocaleMontserrat = 144 { $90 };
    QLocaleMorocco = 145 { $91 };
    QLocaleMozambique = 146 { $92 };
    QLocaleMyanmar = 147 { $93 };
    QLocaleNamibia = 148 { $94 };
    QLocaleNauruCountry = 149 { $95 };
    QLocaleNepal = 150 { $96 };
    QLocaleNetherlands = 151 { $97 };
    QLocaleCuraSao = 152 { $98 };
    QLocaleNewCaledonia = 153 { $99 };
    QLocaleNewZealand = 154 { $9a };
    QLocaleNicaragua = 155 { $9b };
    QLocaleNiger = 156 { $9c };
    QLocaleNigeria = 157 { $9d };
    QLocaleNiue = 158 { $9e };
    QLocaleNorfolkIsland = 159 { $9f };
    QLocaleNorthernMarianaIslands = 160 { $a0 };
    QLocaleNorway = 161 { $a1 };
    QLocaleOman = 162 { $a2 };
    QLocalePakistan = 163 { $a3 };
    QLocalePalau = 164 { $a4 };
    QLocalePalestinianTerritories = 165 { $a5 };
    QLocalePanama = 166 { $a6 };
    QLocalePapuaNewGuinea = 167 { $a7 };
    QLocaleParaguay = 168 { $a8 };
    QLocalePeru = 169 { $a9 };
    QLocalePhilippines = 170 { $aa };
    QLocalePitcairn = 171 { $ab };
    QLocalePoland = 172 { $ac };
    QLocalePortugal = 173 { $ad };
    QLocalePuertoRico = 174 { $ae };
    QLocaleQatar = 175 { $af };
    QLocaleReunion = 176 { $b0 };
    QLocaleRomania = 177 { $b1 };
    QLocaleRussia = 178 { $b2 };
    QLocaleRwanda = 179 { $b3 };
    QLocaleSaintKittsAndNevis = 180 { $b4 };
    QLocaleSaintLucia = 181 { $b5 };
    QLocaleSaintVincentAndTheGrenadines = 182 { $b6 };
    QLocaleSamoa = 183 { $b7 };
    QLocaleSanMarino = 184 { $b8 };
    QLocaleSaoTomeAndPrincipe = 185 { $b9 };
    QLocaleSaudiArabia = 186 { $ba };
    QLocaleSenegal = 187 { $bb };
    QLocaleSeychelles = 188 { $bc };
    QLocaleSierraLeone = 189 { $bd };
    QLocaleSingapore = 190 { $be };
    QLocaleSlovakia = 191 { $bf };
    QLocaleSlovenia = 192 { $c0 };
    QLocaleSolomonIslands = 193 { $c1 };
    QLocaleSomalia = 194 { $c2 };
    QLocaleSouthAfrica = 195 { $c3 };
    QLocaleSouthGeorgiaAndTheSouthSandwichIslands = 196 { $c4 };
    QLocaleSpain = 197 { $c5 };
    QLocaleSriLanka = 198 { $c6 };
    QLocaleSaintHelena = 199 { $c7 };
    QLocaleSaintPierreAndMiquelon = 200 { $c8 };
    QLocaleSudan = 201 { $c9 };
    QLocaleSuriname = 202 { $ca };
    QLocaleSvalbardAndJanMayenIslands = 203 { $cb };
    QLocaleSwaziland = 204 { $cc };
    QLocaleSweden = 205 { $cd };
    QLocaleSwitzerland = 206 { $ce };
    QLocaleSyria = 207 { $cf };
    QLocaleTaiwan = 208 { $d0 };
    QLocaleTajikistan = 209 { $d1 };
    QLocaleTanzania = 210 { $d2 };
    QLocaleThailand = 211 { $d3 };
    QLocaleTogo = 212 { $d4 };
    QLocaleTokelau = 213 { $d5 };
    QLocaleTonga = 214 { $d6 };
    QLocaleTrinidadAndTobago = 215 { $d7 };
    QLocaleTunisia = 216 { $d8 };
    QLocaleTurkey = 217 { $d9 };
    QLocaleTurkmenistan = 218 { $da };
    QLocaleTurksAndCaicosIslands = 219 { $db };
    QLocaleTuvalu = 220 { $dc };
    QLocaleUganda = 221 { $dd };
    QLocaleUkraine = 222 { $de };
    QLocaleUnitedArabEmirates = 223 { $df };
    QLocaleUnitedKingdom = 224 { $e0 };
    QLocaleUnitedStates = 225 { $e1 };
    QLocaleUnitedStatesMinorOutlyingIslands = 226 { $e2 };
    QLocaleUruguay = 227 { $e3 };
    QLocaleUzbekistan = 228 { $e4 };
    QLocaleVanuatu = 229 { $e5 };
    QLocaleVaticanCityState = 230 { $e6 };
    QLocaleVenezuela = 231 { $e7 };
    QLocaleVietnam = 232 { $e8 };
    QLocaleBritishVirginIslands = 233 { $e9 };
    QLocaleUnitedStatesVirginIslands = 234 { $ea };
    QLocaleWallisAndFutunaIslands = 235 { $eb };
    QLocaleWesternSahara = 236 { $ec };
    QLocaleYemen = 237 { $ed };
    QLocaleCanaryIslands = 238 { $ee };
    QLocaleZambia = 239 { $ef };
    QLocaleZimbabwe = 240 { $f0 };
    QLocaleClippertonIsland = 241 { $f1 };
    QLocaleMontenegro = 242 { $f2 };
    QLocaleSerbia = 243 { $f3 };
    QLocaleSaintBarthelemy = 244 { $f4 };
    QLocaleSaintMartin = 245 { $f5 };
    QLocaleLatinAmericaAndTheCaribbean = 246 { $f6 };
    QLocaleAscensionIsland = 247 { $f7 };
    QLocaleAlandIslands = 248 { $f8 };
    QLocaleDiegoGarcia = 249 { $f9 };
    QLocaleCeutaAndMelilla = 250 { $fa };
    QLocaleIsleOfMan = 251 { $fb };
    QLocaleJersey = 252 { $fc };
    QLocaleTristanDaCunha = 253 { $fd };
    QLocaleSouthSudan = 254 { $fe };
    QLocaleBonaire = 255 { $ff };
    QLocaleSintMaarten = 256 { $100 };
    QLocaleDemocraticRepublicOfCongo = 49 { $31 };
    QLocalePeoplesRepublicOfCongo = 50 { $32 };
    QLocaleDemocraticRepublicOfKorea = 113 { $71 };
    QLocaleRepublicOfKorea = 114 { $72 };
    QLocaleRussianFederation = 178 { $b2 };
    QLocaleSyrianArabRepublic = 207 { $cf };
    QLocaleLastCountry = 256 { $100 };

type
  QLocaleMeasurementSystem = cardinal; //  QLocale::MeasurementSystem (4)

const
    QLocaleMetricSystem = 0 { $0 };
    QLocaleImperialUSSystem = 1 { $1 };
    QLocaleImperialUKSystem = 2 { $2 };
    QLocaleImperialSystem = 1 { $1 };


function QLocale_Create(): QLocaleH; cdecl; external Qt5PasLib name 'QLocale_Create';
procedure QLocale_Destroy(handle: QLocaleH); cdecl; external Qt5PasLib name 'QLocale_Destroy'; 
function QLocale_Create(name: PWideString): QLocaleH; cdecl; external Qt5PasLib name 'QLocale_Create2';
function QLocale_Create(language: QLocaleLanguage; country: QLocaleCountry = QLocaleAnyCountry): QLocaleH; cdecl; external Qt5PasLib name 'QLocale_Create3';
function QLocale_Create(language: QLocaleLanguage; script: QLocaleScript; country: QLocaleCountry): QLocaleH; cdecl; external Qt5PasLib name 'QLocale_Create4';
function QLocale_Create(other: QLocaleH): QLocaleH; cdecl; external Qt5PasLib name 'QLocale_Create5';
function QLocale_language(handle: QLocaleH): QLocaleLanguage; cdecl; external Qt5PasLib name 'QLocale_language';
function QLocale_script(handle: QLocaleH): QLocaleScript; cdecl; external Qt5PasLib name 'QLocale_script';
function QLocale_country(handle: QLocaleH): QLocaleCountry; cdecl; external Qt5PasLib name 'QLocale_country';
procedure QLocale_name(handle: QLocaleH; retval: PWideString); cdecl; external Qt5PasLib name 'QLocale_name';
procedure QLocale_bcp47Name(handle: QLocaleH; retval: PWideString); cdecl; external Qt5PasLib name 'QLocale_bcp47Name';
procedure QLocale_nativeLanguageName(handle: QLocaleH; retval: PWideString); cdecl; external Qt5PasLib name 'QLocale_nativeLanguageName';
procedure QLocale_nativeCountryName(handle: QLocaleH; retval: PWideString); cdecl; external Qt5PasLib name 'QLocale_nativeCountryName';
function QLocale_toShort(handle: QLocaleH; s: PWideString; ok: PBoolean = nil): ShortInt; cdecl; external Qt5PasLib name 'QLocale_toShort';
function QLocale_toUShort(handle: QLocaleH; s: PWideString; ok: PBoolean = nil): Word; cdecl; external Qt5PasLib name 'QLocale_toUShort';
function QLocale_toInt(handle: QLocaleH; s: PWideString; ok: PBoolean = nil): Integer; cdecl; external Qt5PasLib name 'QLocale_toInt';
function QLocale_toUInt(handle: QLocaleH; s: PWideString; ok: PBoolean = nil): LongWord; cdecl; external Qt5PasLib name 'QLocale_toUInt';
function QLocale_toLongLong(handle: QLocaleH; s: PWideString; ok: PBoolean = nil): int64; cdecl; external Qt5PasLib name 'QLocale_toLongLong';
function QLocale_toULongLong(handle: QLocaleH; s: PWideString; ok: PBoolean = nil): qword; cdecl; external Qt5PasLib name 'QLocale_toULongLong';
function QLocale_toFloat(handle: QLocaleH; s: PWideString; ok: PBoolean = nil): Single; cdecl; external Qt5PasLib name 'QLocale_toFloat';
function QLocale_toDouble(handle: QLocaleH; s: PWideString; ok: PBoolean = nil): Double; cdecl; external Qt5PasLib name 'QLocale_toDouble';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; i: int64); cdecl; external Qt5PasLib name 'QLocale_toString';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; i: qword); cdecl; external Qt5PasLib name 'QLocale_toString2';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; i: ShortInt); cdecl; external Qt5PasLib name 'QLocale_toString3';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; i: Word); cdecl; external Qt5PasLib name 'QLocale_toString4';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; i: Integer); cdecl; external Qt5PasLib name 'QLocale_toString5';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; i: LongWord); cdecl; external Qt5PasLib name 'QLocale_toString6';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; i: Double; f: char; prec: Integer = 6); cdecl; external Qt5PasLib name 'QLocale_toString7';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; i: Single; f: char; prec: Integer = 6); cdecl; external Qt5PasLib name 'QLocale_toString8';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; date: QDateH; formatStr: PWideString); cdecl; external Qt5PasLib name 'QLocale_toString9';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; date: QDateH; format: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt5PasLib name 'QLocale_toString10';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; time: QTimeH; formatStr: PWideString); cdecl; external Qt5PasLib name 'QLocale_toString11';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; time: QTimeH; format: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt5PasLib name 'QLocale_toString12';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; dateTime: QDateTimeH; format: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt5PasLib name 'QLocale_toString13';
procedure QLocale_toString(handle: QLocaleH; retval: PWideString; dateTime: QDateTimeH; format: PWideString); cdecl; external Qt5PasLib name 'QLocale_toString14';
procedure QLocale_dateFormat(handle: QLocaleH; retval: PWideString; format: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt5PasLib name 'QLocale_dateFormat';
procedure QLocale_timeFormat(handle: QLocaleH; retval: PWideString; format: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt5PasLib name 'QLocale_timeFormat';
procedure QLocale_dateTimeFormat(handle: QLocaleH; retval: PWideString; format: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt5PasLib name 'QLocale_dateTimeFormat';
procedure QLocale_toDate(handle: QLocaleH; retval: QDateH; _string: PWideString; AnonParam2: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt5PasLib name 'QLocale_toDate';
procedure QLocale_toTime(handle: QLocaleH; retval: QTimeH; _string: PWideString; AnonParam2: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt5PasLib name 'QLocale_toTime';
procedure QLocale_toDateTime(handle: QLocaleH; retval: QDateTimeH; _string: PWideString; format: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt5PasLib name 'QLocale_toDateTime';
procedure QLocale_toDate(handle: QLocaleH; retval: QDateH; _string: PWideString; format: PWideString); cdecl; external Qt5PasLib name 'QLocale_toDate2';
procedure QLocale_toTime(handle: QLocaleH; retval: QTimeH; _string: PWideString; format: PWideString); cdecl; external Qt5PasLib name 'QLocale_toTime2';
procedure QLocale_toDateTime(handle: QLocaleH; retval: QDateTimeH; _string: PWideString; format: PWideString); cdecl; external Qt5PasLib name 'QLocale_toDateTime2';
procedure QLocale_decimalPoint(handle: QLocaleH; retval: PWideChar); cdecl; external Qt5PasLib name 'QLocale_decimalPoint';
procedure QLocale_groupSeparator(handle: QLocaleH; retval: PWideChar); cdecl; external Qt5PasLib name 'QLocale_groupSeparator';
procedure QLocale_percent(handle: QLocaleH; retval: PWideChar); cdecl; external Qt5PasLib name 'QLocale_percent';
procedure QLocale_zeroDigit(handle: QLocaleH; retval: PWideChar); cdecl; external Qt5PasLib name 'QLocale_zeroDigit';
procedure QLocale_negativeSign(handle: QLocaleH; retval: PWideChar); cdecl; external Qt5PasLib name 'QLocale_negativeSign';
procedure QLocale_positiveSign(handle: QLocaleH; retval: PWideChar); cdecl; external Qt5PasLib name 'QLocale_positiveSign';
procedure QLocale_exponential(handle: QLocaleH; retval: PWideChar); cdecl; external Qt5PasLib name 'QLocale_exponential';
procedure QLocale_monthName(handle: QLocaleH; retval: PWideString; AnonParam1: Integer; format: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt5PasLib name 'QLocale_monthName';
procedure QLocale_standaloneMonthName(handle: QLocaleH; retval: PWideString; AnonParam1: Integer; format: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt5PasLib name 'QLocale_standaloneMonthName';
procedure QLocale_dayName(handle: QLocaleH; retval: PWideString; AnonParam1: Integer; format: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt5PasLib name 'QLocale_dayName';
procedure QLocale_standaloneDayName(handle: QLocaleH; retval: PWideString; AnonParam1: Integer; format: QLocaleFormatType = QLocaleLongFormat); cdecl; external Qt5PasLib name 'QLocale_standaloneDayName';
function QLocale_firstDayOfWeek(handle: QLocaleH): QtDayOfWeek; cdecl; external Qt5PasLib name 'QLocale_firstDayOfWeek';
procedure QLocale_weekdays(handle: QLocaleH; retval: PPtrIntArray); cdecl; external Qt5PasLib name 'QLocale_weekdays';
procedure QLocale_amText(handle: QLocaleH; retval: PWideString); cdecl; external Qt5PasLib name 'QLocale_amText';
procedure QLocale_pmText(handle: QLocaleH; retval: PWideString); cdecl; external Qt5PasLib name 'QLocale_pmText';
function QLocale_measurementSystem(handle: QLocaleH): QLocaleMeasurementSystem; cdecl; external Qt5PasLib name 'QLocale_measurementSystem';
function QLocale_textDirection(handle: QLocaleH): QtLayoutDirection; cdecl; external Qt5PasLib name 'QLocale_textDirection';
procedure QLocale_toUpper(handle: QLocaleH; retval: PWideString; str: PWideString); cdecl; external Qt5PasLib name 'QLocale_toUpper';
procedure QLocale_toLower(handle: QLocaleH; retval: PWideString; str: PWideString); cdecl; external Qt5PasLib name 'QLocale_toLower';
procedure QLocale_currencySymbol(handle: QLocaleH; retval: PWideString; AnonParam1: QLocaleCurrencySymbolFormat = QLocaleCurrencySymbol); cdecl; external Qt5PasLib name 'QLocale_currencySymbol';
procedure QLocale_toCurrencyString(handle: QLocaleH; retval: PWideString; AnonParam1: int64; symbol: PWideString = nil); cdecl; external Qt5PasLib name 'QLocale_toCurrencyString';
procedure QLocale_toCurrencyString(handle: QLocaleH; retval: PWideString; AnonParam1: qword; symbol: PWideString = nil); cdecl; external Qt5PasLib name 'QLocale_toCurrencyString2';
procedure QLocale_toCurrencyString(handle: QLocaleH; retval: PWideString; AnonParam1: ShortInt; symbol: PWideString = nil); cdecl; external Qt5PasLib name 'QLocale_toCurrencyString3';
procedure QLocale_toCurrencyString(handle: QLocaleH; retval: PWideString; AnonParam1: Word; symbol: PWideString = nil); cdecl; external Qt5PasLib name 'QLocale_toCurrencyString4';
procedure QLocale_toCurrencyString(handle: QLocaleH; retval: PWideString; AnonParam1: Integer; symbol: PWideString = nil); cdecl; external Qt5PasLib name 'QLocale_toCurrencyString5';
procedure QLocale_toCurrencyString(handle: QLocaleH; retval: PWideString; AnonParam1: LongWord; symbol: PWideString = nil); cdecl; external Qt5PasLib name 'QLocale_toCurrencyString6';
procedure QLocale_toCurrencyString(handle: QLocaleH; retval: PWideString; AnonParam1: Double; symbol: PWideString = nil); cdecl; external Qt5PasLib name 'QLocale_toCurrencyString7';
procedure QLocale_toCurrencyString(handle: QLocaleH; retval: PWideString; AnonParam1: Single; symbol: PWideString = nil); cdecl; external Qt5PasLib name 'QLocale_toCurrencyString8';
procedure QLocale_uiLanguages(handle: QLocaleH; retval: QStringListH); cdecl; external Qt5PasLib name 'QLocale_uiLanguages';
procedure QLocale_languageToString(retval: PWideString; language: QLocaleLanguage); cdecl; external Qt5PasLib name 'QLocale_languageToString';
procedure QLocale_countryToString(retval: PWideString; country: QLocaleCountry); cdecl; external Qt5PasLib name 'QLocale_countryToString';
procedure QLocale_scriptToString(retval: PWideString; script: QLocaleScript); cdecl; external Qt5PasLib name 'QLocale_scriptToString';
procedure QLocale_setDefault(locale: QLocaleH); cdecl; external Qt5PasLib name 'QLocale_setDefault';
procedure QLocale_c(retval: QLocaleH); cdecl; external Qt5PasLib name 'QLocale_c';
procedure QLocale_system(retval: QLocaleH); cdecl; external Qt5PasLib name 'QLocale_system';
procedure QLocale_matchingLocales(retval: PPtrIntArray; language: QLocaleLanguage; script: QLocaleScript; country: QLocaleCountry); cdecl; external Qt5PasLib name 'QLocale_matchingLocales';
procedure QLocale_setNumberOptions(handle: QLocaleH; options: QLocaleNumberOptions); cdecl; external Qt5PasLib name 'QLocale_setNumberOptions';
function QLocale_numberOptions(handle: QLocaleH): QLocaleNumberOptions; cdecl; external Qt5PasLib name 'QLocale_numberOptions';
procedure QLocale_quoteString(handle: QLocaleH; retval: PWideString; str: PWideString; style: QLocaleQuotationStyle = QLocaleStandardQuotation); cdecl; external Qt5PasLib name 'QLocale_quoteString';
procedure QLocale_createSeparatedList(handle: QLocaleH; retval: PWideString; strl: QStringListH); cdecl; external Qt5PasLib name 'QLocale_createSeparatedList';

type
  QIODeviceOpenModeFlag = cardinal; //  QIODevice::OpenModeFlag (4)
  QIODeviceOpenMode = QIODeviceOpenModeFlag; // QFlags<>

const
    QIODeviceNotOpen = 0 { $0 };
    QIODeviceReadOnly = 1 { $1 };
    QIODeviceWriteOnly = 2 { $2 };
    QIODeviceReadWrite = 3 { $3 };
    QIODeviceAppend = 4 { $4 };
    QIODeviceTruncate = 8 { $8 };
    QIODeviceText = 16 { $10 };
    QIODeviceUnbuffered = 32 { $20 };


function QIODevice_openMode(handle: QIODeviceH): QIODeviceOpenMode; cdecl; external Qt5PasLib name 'QIODevice_openMode';
procedure QIODevice_setTextModeEnabled(handle: QIODeviceH; enabled: Boolean); cdecl; external Qt5PasLib name 'QIODevice_setTextModeEnabled';
function QIODevice_isTextModeEnabled(handle: QIODeviceH): Boolean; cdecl; external Qt5PasLib name 'QIODevice_isTextModeEnabled';
function QIODevice_isOpen(handle: QIODeviceH): Boolean; cdecl; external Qt5PasLib name 'QIODevice_isOpen';
function QIODevice_isReadable(handle: QIODeviceH): Boolean; cdecl; external Qt5PasLib name 'QIODevice_isReadable';
function QIODevice_isWritable(handle: QIODeviceH): Boolean; cdecl; external Qt5PasLib name 'QIODevice_isWritable';
function QIODevice_isSequential(handle: QIODeviceH): Boolean; cdecl; external Qt5PasLib name 'QIODevice_isSequential';
function QIODevice_open(handle: QIODeviceH; mode: QIODeviceOpenMode): Boolean; cdecl; external Qt5PasLib name 'QIODevice_open';
procedure QIODevice_close(handle: QIODeviceH); cdecl; external Qt5PasLib name 'QIODevice_close';
function QIODevice_pos(handle: QIODeviceH): int64; cdecl; external Qt5PasLib name 'QIODevice_pos';
function QIODevice_size(handle: QIODeviceH): int64; cdecl; external Qt5PasLib name 'QIODevice_size';
function QIODevice_seek(handle: QIODeviceH; pos: int64): Boolean; cdecl; external Qt5PasLib name 'QIODevice_seek';
function QIODevice_atEnd(handle: QIODeviceH): Boolean; cdecl; external Qt5PasLib name 'QIODevice_atEnd';
function QIODevice_reset(handle: QIODeviceH): Boolean; cdecl; external Qt5PasLib name 'QIODevice_reset';
function QIODevice_bytesAvailable(handle: QIODeviceH): int64; cdecl; external Qt5PasLib name 'QIODevice_bytesAvailable';
function QIODevice_bytesToWrite(handle: QIODeviceH): int64; cdecl; external Qt5PasLib name 'QIODevice_bytesToWrite';
function QIODevice_read(handle: QIODeviceH; data: PAnsiChar; maxlen: int64): int64; cdecl; external Qt5PasLib name 'QIODevice_read';
procedure QIODevice_read(handle: QIODeviceH; retval: QByteArrayH; maxlen: int64); cdecl; external Qt5PasLib name 'QIODevice_read2';
procedure QIODevice_readAll(handle: QIODeviceH; retval: QByteArrayH); cdecl; external Qt5PasLib name 'QIODevice_readAll';
function QIODevice_readLine(handle: QIODeviceH; data: PAnsiChar; maxlen: int64): int64; cdecl; external Qt5PasLib name 'QIODevice_readLine';
procedure QIODevice_readLine(handle: QIODeviceH; retval: QByteArrayH; maxlen: int64 = 0); cdecl; external Qt5PasLib name 'QIODevice_readLine2';
function QIODevice_canReadLine(handle: QIODeviceH): Boolean; cdecl; external Qt5PasLib name 'QIODevice_canReadLine';
function QIODevice_write(handle: QIODeviceH; data: PAnsiChar; len: int64): int64; cdecl; external Qt5PasLib name 'QIODevice_write';
function QIODevice_write(handle: QIODeviceH; data: PAnsiChar): int64; cdecl; external Qt5PasLib name 'QIODevice_write2';
function QIODevice_write(handle: QIODeviceH; data: QByteArrayH): int64; cdecl; external Qt5PasLib name 'QIODevice_write3';
function QIODevice_peek(handle: QIODeviceH; data: PAnsiChar; maxlen: int64): int64; cdecl; external Qt5PasLib name 'QIODevice_peek';
procedure QIODevice_peek(handle: QIODeviceH; retval: QByteArrayH; maxlen: int64); cdecl; external Qt5PasLib name 'QIODevice_peek2';
function QIODevice_waitForReadyRead(handle: QIODeviceH; msecs: Integer): Boolean; cdecl; external Qt5PasLib name 'QIODevice_waitForReadyRead';
function QIODevice_waitForBytesWritten(handle: QIODeviceH; msecs: Integer): Boolean; cdecl; external Qt5PasLib name 'QIODevice_waitForBytesWritten';
procedure QIODevice_ungetChar(handle: QIODeviceH; c: char); cdecl; external Qt5PasLib name 'QIODevice_ungetChar';
function QIODevice_putChar(handle: QIODeviceH; c: char): Boolean; cdecl; external Qt5PasLib name 'QIODevice_putChar';
function QIODevice_getChar(handle: QIODeviceH; c: PAnsiChar): Boolean; cdecl; external Qt5PasLib name 'QIODevice_getChar';
procedure QIODevice_errorString(handle: QIODeviceH; retval: PWideString); cdecl; external Qt5PasLib name 'QIODevice_errorString';


type
  QIODevice_readyRead_Event = procedure () of object cdecl;
  QIODevice_bytesWritten_Event = procedure (bytes: int64) of object cdecl;
  QIODevice_aboutToClose_Event = procedure () of object cdecl;
  QIODevice_readChannelFinished_Event = procedure () of object cdecl;



type
  QProcessProcessError = ( // QProcess::ProcessError (1)
    QProcessFailedToStart, QProcessCrashed, QProcessTimedout, QProcessReadError, QProcessWriteError, QProcessUnknownError );

  QProcessProcessState = ( // QProcess::ProcessState (1)
    QProcessNotRunning, QProcessStarting, QProcessRunning );

  QProcessProcessChannel = ( // QProcess::ProcessChannel (1)
    QProcessStandardOutput, QProcessStandardError );

  QProcessProcessChannelMode = ( // QProcess::ProcessChannelMode (1)
    QProcessSeparateChannels, QProcessMergedChannels, QProcessForwardedChannels );

  QProcessExitStatus = ( // QProcess::ExitStatus (1)
    QProcessNormalExit, QProcessCrashExit );

function QProcessEnvironment_Create(): QProcessEnvironmentH; cdecl; external Qt5PasLib name 'QProcessEnvironment_Create';
procedure QProcessEnvironment_Destroy(handle: QProcessEnvironmentH); cdecl; external Qt5PasLib name 'QProcessEnvironment_Destroy'; 
function QProcessEnvironment_Create(other: QProcessEnvironmentH): QProcessEnvironmentH; cdecl; external Qt5PasLib name 'QProcessEnvironment_Create2';
procedure QProcessEnvironment_swap(handle: QProcessEnvironmentH; other: QProcessEnvironmentH); cdecl; external Qt5PasLib name 'QProcessEnvironment_swap';
function QProcessEnvironment_isEmpty(handle: QProcessEnvironmentH): Boolean; cdecl; external Qt5PasLib name 'QProcessEnvironment_isEmpty';
procedure QProcessEnvironment_clear(handle: QProcessEnvironmentH); cdecl; external Qt5PasLib name 'QProcessEnvironment_clear';
function QProcessEnvironment_contains(handle: QProcessEnvironmentH; name: PWideString): Boolean; cdecl; external Qt5PasLib name 'QProcessEnvironment_contains';
procedure QProcessEnvironment_insert(handle: QProcessEnvironmentH; name: PWideString; value: PWideString); cdecl; external Qt5PasLib name 'QProcessEnvironment_insert';
procedure QProcessEnvironment_remove(handle: QProcessEnvironmentH; name: PWideString); cdecl; external Qt5PasLib name 'QProcessEnvironment_remove';
procedure QProcessEnvironment_value(handle: QProcessEnvironmentH; retval: PWideString; name: PWideString; defaultValue: PWideString = nil); cdecl; external Qt5PasLib name 'QProcessEnvironment_value';
procedure QProcessEnvironment_toStringList(handle: QProcessEnvironmentH; retval: QStringListH); cdecl; external Qt5PasLib name 'QProcessEnvironment_toStringList';
procedure QProcessEnvironment_keys(handle: QProcessEnvironmentH; retval: QStringListH); cdecl; external Qt5PasLib name 'QProcessEnvironment_keys';
procedure QProcessEnvironment_insert(handle: QProcessEnvironmentH; e: QProcessEnvironmentH); cdecl; external Qt5PasLib name 'QProcessEnvironment_insert2';
procedure QProcessEnvironment_systemEnvironment(retval: QProcessEnvironmentH); cdecl; external Qt5PasLib name 'QProcessEnvironment_systemEnvironment';

function QProcess_Create(parent: QObjectH = nil): QProcessH; cdecl; external Qt5PasLib name 'QProcess_Create';
procedure QProcess_Destroy(handle: QProcessH); cdecl; external Qt5PasLib name 'QProcess_Destroy'; 
procedure QProcess_start(handle: QProcessH; _program: PWideString; arguments: QStringListH; mode: QIODeviceOpenMode); cdecl; external Qt5PasLib name 'QProcess_start';
procedure QProcess_start(handle: QProcessH; command: PWideString; mode: QIODeviceOpenMode); cdecl; external Qt5PasLib name 'QProcess_start2';
procedure QProcess_start(handle: QProcessH; mode: QIODeviceOpenMode); cdecl; external Qt5PasLib name 'QProcess_start3';
function QProcess_open(handle: QProcessH; mode: QIODeviceOpenMode): Boolean; cdecl; external Qt5PasLib name 'QProcess_open';
procedure QProcess_program(handle: QProcessH; retval: PWideString); cdecl; external Qt5PasLib name 'QProcess_program';
procedure QProcess_setProgram(handle: QProcessH; _program: PWideString); cdecl; external Qt5PasLib name 'QProcess_setProgram';
procedure QProcess_arguments(handle: QProcessH; retval: QStringListH); cdecl; external Qt5PasLib name 'QProcess_arguments';
procedure QProcess_setArguments(handle: QProcessH; arguments: QStringListH); cdecl; external Qt5PasLib name 'QProcess_setArguments';
function QProcess_readChannelMode(handle: QProcessH): QProcessProcessChannelMode; cdecl; external Qt5PasLib name 'QProcess_readChannelMode';
procedure QProcess_setReadChannelMode(handle: QProcessH; mode: QProcessProcessChannelMode); cdecl; external Qt5PasLib name 'QProcess_setReadChannelMode';
function QProcess_processChannelMode(handle: QProcessH): QProcessProcessChannelMode; cdecl; external Qt5PasLib name 'QProcess_processChannelMode';
procedure QProcess_setProcessChannelMode(handle: QProcessH; mode: QProcessProcessChannelMode); cdecl; external Qt5PasLib name 'QProcess_setProcessChannelMode';
function QProcess_readChannel(handle: QProcessH): QProcessProcessChannel; cdecl; external Qt5PasLib name 'QProcess_readChannel';
procedure QProcess_setReadChannel(handle: QProcessH; channel: QProcessProcessChannel); cdecl; external Qt5PasLib name 'QProcess_setReadChannel';
procedure QProcess_closeReadChannel(handle: QProcessH; channel: QProcessProcessChannel); cdecl; external Qt5PasLib name 'QProcess_closeReadChannel';
procedure QProcess_closeWriteChannel(handle: QProcessH); cdecl; external Qt5PasLib name 'QProcess_closeWriteChannel';
procedure QProcess_setStandardInputFile(handle: QProcessH; fileName: PWideString); cdecl; external Qt5PasLib name 'QProcess_setStandardInputFile';
procedure QProcess_setStandardOutputFile(handle: QProcessH; fileName: PWideString; mode: QIODeviceOpenMode); cdecl; external Qt5PasLib name 'QProcess_setStandardOutputFile';
procedure QProcess_setStandardErrorFile(handle: QProcessH; fileName: PWideString; mode: QIODeviceOpenMode); cdecl; external Qt5PasLib name 'QProcess_setStandardErrorFile';
procedure QProcess_setStandardOutputProcess(handle: QProcessH; destination: QProcessH); cdecl; external Qt5PasLib name 'QProcess_setStandardOutputProcess';
procedure QProcess_workingDirectory(handle: QProcessH; retval: PWideString); cdecl; external Qt5PasLib name 'QProcess_workingDirectory';
procedure QProcess_setWorkingDirectory(handle: QProcessH; dir: PWideString); cdecl; external Qt5PasLib name 'QProcess_setWorkingDirectory';
procedure QProcess_setEnvironment(handle: QProcessH; environment: QStringListH); cdecl; external Qt5PasLib name 'QProcess_setEnvironment';
procedure QProcess_environment(handle: QProcessH; retval: QStringListH); cdecl; external Qt5PasLib name 'QProcess_environment';
procedure QProcess_setProcessEnvironment(handle: QProcessH; environment: QProcessEnvironmentH); cdecl; external Qt5PasLib name 'QProcess_setProcessEnvironment';
procedure QProcess_processEnvironment(handle: QProcessH; retval: QProcessEnvironmentH); cdecl; external Qt5PasLib name 'QProcess_processEnvironment';
function QProcess_error(handle: QProcessH): QProcessProcessError; cdecl; external Qt5PasLib name 'QProcess_error';
function QProcess_state(handle: QProcessH): QProcessProcessState; cdecl; external Qt5PasLib name 'QProcess_state';
function QProcess_pid(handle: QProcessH): Q_PID; cdecl; external Qt5PasLib name 'QProcess_pid';
function QProcess_waitForStarted(handle: QProcessH; msecs: Integer = 30000): Boolean; cdecl; external Qt5PasLib name 'QProcess_waitForStarted';
function QProcess_waitForReadyRead(handle: QProcessH; msecs: Integer = 30000): Boolean; cdecl; external Qt5PasLib name 'QProcess_waitForReadyRead';
function QProcess_waitForBytesWritten(handle: QProcessH; msecs: Integer = 30000): Boolean; cdecl; external Qt5PasLib name 'QProcess_waitForBytesWritten';
function QProcess_waitForFinished(handle: QProcessH; msecs: Integer = 30000): Boolean; cdecl; external Qt5PasLib name 'QProcess_waitForFinished';
procedure QProcess_readAllStandardOutput(handle: QProcessH; retval: QByteArrayH); cdecl; external Qt5PasLib name 'QProcess_readAllStandardOutput';
procedure QProcess_readAllStandardError(handle: QProcessH; retval: QByteArrayH); cdecl; external Qt5PasLib name 'QProcess_readAllStandardError';
function QProcess_exitCode(handle: QProcessH): Integer; cdecl; external Qt5PasLib name 'QProcess_exitCode';
function QProcess_exitStatus(handle: QProcessH): QProcessExitStatus; cdecl; external Qt5PasLib name 'QProcess_exitStatus';
function QProcess_bytesAvailable(handle: QProcessH): int64; cdecl; external Qt5PasLib name 'QProcess_bytesAvailable';
function QProcess_bytesToWrite(handle: QProcessH): int64; cdecl; external Qt5PasLib name 'QProcess_bytesToWrite';
function QProcess_isSequential(handle: QProcessH): Boolean; cdecl; external Qt5PasLib name 'QProcess_isSequential';
function QProcess_canReadLine(handle: QProcessH): Boolean; cdecl; external Qt5PasLib name 'QProcess_canReadLine';
procedure QProcess_close(handle: QProcessH); cdecl; external Qt5PasLib name 'QProcess_close';
function QProcess_atEnd(handle: QProcessH): Boolean; cdecl; external Qt5PasLib name 'QProcess_atEnd';
function QProcess_execute(_program: PWideString; arguments: QStringListH): Integer; cdecl; external Qt5PasLib name 'QProcess_execute';
function QProcess_execute(_program: PWideString): Integer; cdecl; external Qt5PasLib name 'QProcess_execute2';
function QProcess_startDetached(_program: PWideString; arguments: QStringListH; workingDirectory: PWideString; pid: pint64 = nil): Boolean; cdecl; external Qt5PasLib name 'QProcess_startDetached';
function QProcess_startDetached(_program: PWideString; arguments: QStringListH): Boolean; cdecl; external Qt5PasLib name 'QProcess_startDetached2';
function QProcess_startDetached(_program: PWideString): Boolean; cdecl; external Qt5PasLib name 'QProcess_startDetached3';
procedure QProcess_systemEnvironment(retval: QStringListH); cdecl; external Qt5PasLib name 'QProcess_systemEnvironment';
procedure QProcess_terminate(handle: QProcessH); cdecl; external Qt5PasLib name 'QProcess_terminate';
procedure QProcess_kill(handle: QProcessH); cdecl; external Qt5PasLib name 'QProcess_kill';
{$ifdef MSWINDOWS }
procedure QProcess_nativeArguments(handle: QProcessH; retval: PWideString); cdecl; external Qt5PasLib name 'QProcess_nativeArguments';
procedure QProcess_setNativeArguments(handle: QProcessH; arguments: PWideString); cdecl; external Qt5PasLib name 'QProcess_setNativeArguments';
{$endif}


type
  QProcess_started_Event = procedure () of object cdecl;
  QProcess_finished_Event = procedure (exitCode: Integer) of object cdecl;
  QProcess_finished2_Event = procedure (exitCode: Integer; exitStatus: QProcessExitStatus) of object cdecl;
  QProcess_error_Event = procedure (error: QProcessProcessError) of object cdecl;
  QProcess_stateChanged_Event = procedure (state: QProcessProcessState) of object cdecl;
  QProcess_readyReadStandardOutput_Event = procedure () of object cdecl;
  QProcess_readyReadStandardError_Event = procedure () of object cdecl;



function QBuffer_Create(AParent: QObjectH = nil): QBufferH; cdecl; external Qt5PasLib name 'QBuffer_Create';
function QBuffer_Create2(ABuffer: QByteArrayH; AParent: QObjectH = nil): QBufferH; cdecl; external Qt5PasLib name 'QBuffer_Create2';
procedure QBuffer_Destroy(handle: QBufferH); cdecl; external Qt5PasLib name 'QBuffer_Destroy';
function QBuffer_buffer(handle: QBufferH): QByteArrayH; cdecl; external Qt5PasLib name 'QBuffer_buffer';
function QBuffer_constBuffer(handle: QBufferH): QByteArrayH; cdecl; external Qt5PasLib name 'QBuffer_constBuffer';
procedure QBuffer_setBuffer(handle: QBufferH); cdecl; external Qt5PasLib name 'QBuffer_setBuffer';
procedure QBuffer_setData(handle: QBufferH; AData: PChar; ADataSize: integer); cdecl; external Qt5PasLib name 'QBuffer_setData';
function QBuffer_open(handle: QBufferH; mode: QIODeviceOpenMode): Boolean; cdecl; external Qt5PasLib name 'QBuffer_open';
procedure QBuffer_close(handle: QBufferH); cdecl; external Qt5PasLib name 'QBuffer_close';
function QBuffer_pos(handle: QBufferH): int64; cdecl; external Qt5PasLib name 'QBuffer_pos';
function QBuffer_size(handle: QBufferH): int64; cdecl; external Qt5PasLib name 'QBuffer_size';
function QBuffer_seek(handle: QBufferH; pos: int64): Boolean; cdecl; external Qt5PasLib name 'QBuffer_seek';
function QBuffer_atEnd(handle: QBufferH): Boolean; cdecl; external Qt5PasLib name 'QBuffer_atEnd';
function QBuffer_canReadLine(handle: QBufferH): Boolean; cdecl; external Qt5PasLib name 'QBuffer_canReadLine';


type
  QFileDeviceFileError = (  //QFileDevice::FileError (2)
    QFileDeviceNoError = 0,
    QFileDeviceReadError = 1,
    QFileDeviceWriteError = 2,
    QFileDeviceFatalError = 3,
    QFileDeviceResourceError = 4,
    QFileDeviceOpenError = 5,
    QFileDeviceAbortError = 6,
    QFileDeviceTimeOutError = 7,
    QFileDeviceUnspecifiedError = 8,
    QFileDeviceRemoveError = 9,
    QFileDeviceRenameError = 10,
    QFileDevicePositionError = 11,
    QFileDeviceResizeError = 12,
    QFileDevicePermissionsError = 13,
    QFileDeviceCopyError = 14 );

type
  QFileDevicePermission = cardinal; // QFileDevice::Permission
  QFileDevicePermissions = QFileDevicePermission; //QFlags<> (3)
const
  QFileDeviceReadOwner =   $4000;
  QFileDeviceWriteOwner =   $2000;
  QFileDeviceExeOwner =   $1000;
  QFileDeviceReadUser =   $0400;
  QFileDeviceWriteUser =   $0200;
  QFileDeviceExeUser =   $0100;
  QFileDeviceReadGroup =   $0040;
  QFileDeviceWriteGroup =   $0020;
  QFileDeviceExeGroup =   $0010;
  QFileDeviceReadOther =   $0004;
  QFileDeviceWriteOther =   $0002;
  QFileDeviceExeOther =   $0001;

type
  QFileDeviceFileHandleFlag = cardinal; // QFileDevice::FileHandleFlag
  QFileDeviceFileHandleFlags = QFileDeviceFileHandleFlag; //QFlags<> (3)
const
  QFileDeviceAutoCloseHandle =   $0001;
  QFileDeviceDontCloseHandle =   0;


type
  QFileDeviceMemoryMapFlags = (  //QFileDevice::MemoryMapFlags (2)
    QFileDeviceNoOptions = 0 );

function QFileDevice_error(handle: QFileDeviceH): QFileDeviceFileError; cdecl; external Qt5PasLib name 'QFileDevice_error';
procedure QFileDevice_unsetError(handle: QFileDeviceH); cdecl; external Qt5PasLib name 'QFileDevice_unsetError';
procedure QFileDevice_close(handle: QFileDeviceH); cdecl; external Qt5PasLib name 'QFileDevice_close';
function QFileDevice_isSequential(handle: QFileDeviceH): Boolean; cdecl; external Qt5PasLib name 'QFileDevice_isSequential';
function QFileDevice_handle(handle: QFileDeviceH): Integer; cdecl; external Qt5PasLib name 'QFileDevice_handle';
procedure QFileDevice_fileName(handle: QFileDeviceH; retval: PWideString); cdecl; external Qt5PasLib name 'QFileDevice_fileName';
function QFileDevice_pos(handle: QFileDeviceH): int64; cdecl; external Qt5PasLib name 'QFileDevice_pos';
function QFileDevice_seek(handle: QFileDeviceH; offset: int64): Boolean; cdecl; external Qt5PasLib name 'QFileDevice_seek';
function QFileDevice_atEnd(handle: QFileDeviceH): Boolean; cdecl; external Qt5PasLib name 'QFileDevice_atEnd';
function QFileDevice_flush(handle: QFileDeviceH): Boolean; cdecl; external Qt5PasLib name 'QFileDevice_flush';
function QFileDevice_size(handle: QFileDeviceH): int64; cdecl; external Qt5PasLib name 'QFileDevice_size';
function QFileDevice_resize(handle: QFileDeviceH; sz: int64): Boolean; cdecl; external Qt5PasLib name 'QFileDevice_resize';
function QFileDevice_permissions(handle: QFileDeviceH): QFileDevicePermissions; cdecl; external Qt5PasLib name 'QFileDevice_permissions';
function QFileDevice_setPermissions(handle: QFileDeviceH; permissionSpec: QFileDevicePermissions): Boolean; cdecl; external Qt5PasLib name 'QFileDevice_setPermissions';
function QFileDevice_map(handle: QFileDeviceH; offset: int64; size: int64; flags: QFileDeviceMemoryMapFlags = QFileDeviceNoOptions): PByte; cdecl; external Qt5PasLib name 'QFileDevice_map';
function QFileDevice_unmap(handle: QFileDeviceH; address: PByte): Boolean; cdecl; external Qt5PasLib name 'QFileDevice_unmap';

function QFile_Create(): QFileH; cdecl; external Qt5PasLib name 'QFile_Create';
procedure QFile_Destroy(handle: QFileH); cdecl; external Qt5PasLib name 'QFile_Destroy'; 
function QFile_Create(name: PWideString): QFileH; cdecl; external Qt5PasLib name 'QFile_Create2';
function QFile_Create(parent: QObjectH): QFileH; cdecl; external Qt5PasLib name 'QFile_Create3';
function QFile_Create(name: PWideString; parent: QObjectH): QFileH; cdecl; external Qt5PasLib name 'QFile_Create4';
procedure QFile_fileName(handle: QFileH; retval: PWideString); cdecl; external Qt5PasLib name 'QFile_fileName';
procedure QFile_setFileName(handle: QFileH; name: PWideString); cdecl; external Qt5PasLib name 'QFile_setFileName';
procedure QFile_encodeName(retval: QByteArrayH; fileName: PWideString); cdecl; external Qt5PasLib name 'QFile_encodeName';
procedure QFile_decodeName(retval: PWideString; localFileName: QByteArrayH); cdecl; external Qt5PasLib name 'QFile_decodeName';
procedure QFile_decodeName(retval: PWideString; localFileName: PAnsiChar); cdecl; external Qt5PasLib name 'QFile_decodeName2';
function QFile_exists(handle: QFileH): Boolean; cdecl; external Qt5PasLib name 'QFile_exists';
function QFile_exists(fileName: PWideString): Boolean; cdecl; external Qt5PasLib name 'QFile_exists2';
procedure QFile_readLink(handle: QFileH; retval: PWideString); cdecl; external Qt5PasLib name 'QFile_readLink';
procedure QFile_readLink(retval: PWideString; fileName: PWideString); cdecl; external Qt5PasLib name 'QFile_readLink2';
procedure QFile_symLinkTarget(handle: QFileH; retval: PWideString); cdecl; external Qt5PasLib name 'QFile_symLinkTarget';
procedure QFile_symLinkTarget(retval: PWideString; fileName: PWideString); cdecl; external Qt5PasLib name 'QFile_symLinkTarget2';
function QFile_remove(handle: QFileH): Boolean; cdecl; external Qt5PasLib name 'QFile_remove';
function QFile_remove(fileName: PWideString): Boolean; cdecl; external Qt5PasLib name 'QFile_remove2';
function QFile_rename(handle: QFileH; newName: PWideString): Boolean; cdecl; external Qt5PasLib name 'QFile_rename';
function QFile_rename(oldName: PWideString; newName: PWideString): Boolean; cdecl; external Qt5PasLib name 'QFile_rename2';
function QFile_link(handle: QFileH; newName: PWideString): Boolean; cdecl; external Qt5PasLib name 'QFile_link';
function QFile_link(oldname: PWideString; newName: PWideString): Boolean; cdecl; external Qt5PasLib name 'QFile_link2';
function QFile_copy(handle: QFileH; newName: PWideString): Boolean; cdecl; external Qt5PasLib name 'QFile_copy';
function QFile_copy(fileName: PWideString; newName: PWideString): Boolean; cdecl; external Qt5PasLib name 'QFile_copy2';
function QFile_open(handle: QFileH; flags: QIODeviceOpenMode): Boolean; cdecl; external Qt5PasLib name 'QFile_open';
function QFile_open(handle: QFileH; fd: Integer; ioFlags: QIODeviceOpenMode; handleFlags: QFileDeviceFileHandleFlags): Boolean; cdecl; external Qt5PasLib name 'QFile_open2';
function QFile_size(handle: QFileH): int64; cdecl; external Qt5PasLib name 'QFile_size';
function QFile_resize(handle: QFileH; sz: int64): Boolean; cdecl; external Qt5PasLib name 'QFile_resize';
function QFile_resize(filename: PWideString; sz: int64): Boolean; cdecl; external Qt5PasLib name 'QFile_resize2';
function QFile_permissions(handle: QFileH): QFileDevicePermissions; cdecl; external Qt5PasLib name 'QFile_permissions';
function QFile_permissions(filename: PWideString): QFileDevicePermissions; cdecl; external Qt5PasLib name 'QFile_permissions2';
function QFile_setPermissions(handle: QFileH; permissionSpec: QFileDevicePermissions): Boolean; cdecl; external Qt5PasLib name 'QFile_setPermissions';
function QFile_setPermissions(filename: PWideString; permissionSpec: QFileDevicePermissions): Boolean; cdecl; external Qt5PasLib name 'QFile_setPermissions2';

function QFileInfo_Create(): QFileInfoH; cdecl; external Qt5PasLib name 'QFileInfo_Create';
procedure QFileInfo_Destroy(handle: QFileInfoH); cdecl; external Qt5PasLib name 'QFileInfo_Destroy'; 
function QFileInfo_Create(_file: PWideString): QFileInfoH; cdecl; external Qt5PasLib name 'QFileInfo_Create2';
function QFileInfo_Create(_file: QFileH): QFileInfoH; cdecl; external Qt5PasLib name 'QFileInfo_Create3';
function QFileInfo_Create(dir: QDirH; _file: PWideString): QFileInfoH; cdecl; external Qt5PasLib name 'QFileInfo_Create4';
function QFileInfo_Create(fileinfo: QFileInfoH): QFileInfoH; cdecl; external Qt5PasLib name 'QFileInfo_Create5';
procedure QFileInfo_swap(handle: QFileInfoH; other: QFileInfoH); cdecl; external Qt5PasLib name 'QFileInfo_swap';
procedure QFileInfo_setFile(handle: QFileInfoH; _file: PWideString); cdecl; external Qt5PasLib name 'QFileInfo_setFile';
procedure QFileInfo_setFile(handle: QFileInfoH; _file: QFileH); cdecl; external Qt5PasLib name 'QFileInfo_setFile2';
procedure QFileInfo_setFile(handle: QFileInfoH; dir: QDirH; _file: PWideString); cdecl; external Qt5PasLib name 'QFileInfo_setFile3';
function QFileInfo_exists(handle: QFileInfoH): Boolean; cdecl; external Qt5PasLib name 'QFileInfo_exists';
procedure QFileInfo_refresh(handle: QFileInfoH); cdecl; external Qt5PasLib name 'QFileInfo_refresh';
procedure QFileInfo_filePath(handle: QFileInfoH; retval: PWideString); cdecl; external Qt5PasLib name 'QFileInfo_filePath';
procedure QFileInfo_absoluteFilePath(handle: QFileInfoH; retval: PWideString); cdecl; external Qt5PasLib name 'QFileInfo_absoluteFilePath';
procedure QFileInfo_canonicalFilePath(handle: QFileInfoH; retval: PWideString); cdecl; external Qt5PasLib name 'QFileInfo_canonicalFilePath';
procedure QFileInfo_fileName(handle: QFileInfoH; retval: PWideString); cdecl; external Qt5PasLib name 'QFileInfo_fileName';
procedure QFileInfo_baseName(handle: QFileInfoH; retval: PWideString); cdecl; external Qt5PasLib name 'QFileInfo_baseName';
procedure QFileInfo_completeBaseName(handle: QFileInfoH; retval: PWideString); cdecl; external Qt5PasLib name 'QFileInfo_completeBaseName';
procedure QFileInfo_suffix(handle: QFileInfoH; retval: PWideString); cdecl; external Qt5PasLib name 'QFileInfo_suffix';
procedure QFileInfo_bundleName(handle: QFileInfoH; retval: PWideString); cdecl; external Qt5PasLib name 'QFileInfo_bundleName';
procedure QFileInfo_completeSuffix(handle: QFileInfoH; retval: PWideString); cdecl; external Qt5PasLib name 'QFileInfo_completeSuffix';
procedure QFileInfo_path(handle: QFileInfoH; retval: PWideString); cdecl; external Qt5PasLib name 'QFileInfo_path';
procedure QFileInfo_absolutePath(handle: QFileInfoH; retval: PWideString); cdecl; external Qt5PasLib name 'QFileInfo_absolutePath';
procedure QFileInfo_canonicalPath(handle: QFileInfoH; retval: PWideString); cdecl; external Qt5PasLib name 'QFileInfo_canonicalPath';
procedure QFileInfo_dir(handle: QFileInfoH; retval: QDirH); cdecl; external Qt5PasLib name 'QFileInfo_dir';
procedure QFileInfo_absoluteDir(handle: QFileInfoH; retval: QDirH); cdecl; external Qt5PasLib name 'QFileInfo_absoluteDir';
function QFileInfo_isReadable(handle: QFileInfoH): Boolean; cdecl; external Qt5PasLib name 'QFileInfo_isReadable';
function QFileInfo_isWritable(handle: QFileInfoH): Boolean; cdecl; external Qt5PasLib name 'QFileInfo_isWritable';
function QFileInfo_isExecutable(handle: QFileInfoH): Boolean; cdecl; external Qt5PasLib name 'QFileInfo_isExecutable';
function QFileInfo_isHidden(handle: QFileInfoH): Boolean; cdecl; external Qt5PasLib name 'QFileInfo_isHidden';
function QFileInfo_isNativePath(handle: QFileInfoH): Boolean; cdecl; external Qt5PasLib name 'QFileInfo_isNativePath';
function QFileInfo_isRelative(handle: QFileInfoH): Boolean; cdecl; external Qt5PasLib name 'QFileInfo_isRelative';
function QFileInfo_isAbsolute(handle: QFileInfoH): Boolean; cdecl; external Qt5PasLib name 'QFileInfo_isAbsolute';
function QFileInfo_makeAbsolute(handle: QFileInfoH): Boolean; cdecl; external Qt5PasLib name 'QFileInfo_makeAbsolute';
function QFileInfo_isFile(handle: QFileInfoH): Boolean; cdecl; external Qt5PasLib name 'QFileInfo_isFile';
function QFileInfo_isDir(handle: QFileInfoH): Boolean; cdecl; external Qt5PasLib name 'QFileInfo_isDir';
function QFileInfo_isSymLink(handle: QFileInfoH): Boolean; cdecl; external Qt5PasLib name 'QFileInfo_isSymLink';
function QFileInfo_isRoot(handle: QFileInfoH): Boolean; cdecl; external Qt5PasLib name 'QFileInfo_isRoot';
function QFileInfo_isBundle(handle: QFileInfoH): Boolean; cdecl; external Qt5PasLib name 'QFileInfo_isBundle';
procedure QFileInfo_readLink(handle: QFileInfoH; retval: PWideString); cdecl; external Qt5PasLib name 'QFileInfo_readLink';
procedure QFileInfo_symLinkTarget(handle: QFileInfoH; retval: PWideString); cdecl; external Qt5PasLib name 'QFileInfo_symLinkTarget';
procedure QFileInfo_owner(handle: QFileInfoH; retval: PWideString); cdecl; external Qt5PasLib name 'QFileInfo_owner';
function QFileInfo_ownerId(handle: QFileInfoH): LongWord; cdecl; external Qt5PasLib name 'QFileInfo_ownerId';
procedure QFileInfo_group(handle: QFileInfoH; retval: PWideString); cdecl; external Qt5PasLib name 'QFileInfo_group';
function QFileInfo_groupId(handle: QFileInfoH): LongWord; cdecl; external Qt5PasLib name 'QFileInfo_groupId';
function QFileInfo_permission(handle: QFileInfoH; permissions: QFileDevicePermissions): Boolean; cdecl; external Qt5PasLib name 'QFileInfo_permission';
function QFileInfo_permissions(handle: QFileInfoH): QFileDevicePermissions; cdecl; external Qt5PasLib name 'QFileInfo_permissions';
function QFileInfo_size(handle: QFileInfoH): int64; cdecl; external Qt5PasLib name 'QFileInfo_size';
procedure QFileInfo_created(handle: QFileInfoH; retval: QDateTimeH); cdecl; external Qt5PasLib name 'QFileInfo_created';
procedure QFileInfo_lastModified(handle: QFileInfoH; retval: QDateTimeH); cdecl; external Qt5PasLib name 'QFileInfo_lastModified';
procedure QFileInfo_lastRead(handle: QFileInfoH; retval: QDateTimeH); cdecl; external Qt5PasLib name 'QFileInfo_lastRead';
function QFileInfo_caching(handle: QFileInfoH): Boolean; cdecl; external Qt5PasLib name 'QFileInfo_caching';
procedure QFileInfo_setCaching(handle: QFileInfoH; _on: Boolean); cdecl; external Qt5PasLib name 'QFileInfo_setCaching';

type
  QDirSortFlag = cardinal; // QDir::SortFlag
  QDirSortFlags = QDirSortFlag; //QFlags<> (3)
const
  QDirName =   $00;
  QDirTime =   $01;
  QDirSize =   $02;
  QDirUnsorted =   $03;
  QDirSortByMask =   $03;
  QDirDirsFirst =   $04;
  QDirReversed =   $08;
  QDirIgnoreCase =   $10;
  QDirDirsLast =   $20;
  QDirLocaleAware =   $40;
  QDirType =   $80;
  QDirNoSort =   -1;

type
  QDirFilter = cardinal; //  QDir::Filter (4)
  QDirFilters = QDirFilter; // QFlags<>

const
    QDirDirs = 1 { $1 };
    QDirFiles = 2 { $2 };
    QDirDrives = 4 { $4 };
    QDirNoSymLinks = 8 { $8 };
    QDirAllEntries = 7 { $7 };
    QDirTypeMask = 15 { $f };
    QDirReadable = 16 { $10 };
    QDirWritable = 32 { $20 };
    QDirExecutable = 64 { $40 };
    QDirPermissionMask = 112 { $70 };
    QDirModified = 128 { $80 };
    QDirHidden = 256 { $100 };
    QDirSystem = 512 { $200 };
    QDirAccessMask = 1008 { $3f0 };
    QDirAllDirs = 1024 { $400 };
    QDirCaseSensitive = 2048 { $800 };
    QDirNoDot = 8192 { $2000 };
    QDirNoDotDot = 16384 { $4000 };
    QDirNoDotAndDotDot = 24576 { $6000 };
    QDirNoFilter = 4294967295 { $ffffffff };


function QDir_Create(AnonParam1: QDirH): QDirH; cdecl; external Qt5PasLib name 'QDir_Create';
procedure QDir_Destroy(handle: QDirH); cdecl; external Qt5PasLib name 'QDir_Destroy'; 
function QDir_Create(path: PWideString = nil): QDirH; cdecl; external Qt5PasLib name 'QDir_Create2';
function QDir_Create(path: PWideString; nameFilter: PWideString; sort: QDirSortFlags; filter: QDirFilters = QDirAllEntries): QDirH; cdecl; external Qt5PasLib name 'QDir_Create3';
procedure QDir_swap(handle: QDirH; other: QDirH); cdecl; external Qt5PasLib name 'QDir_swap';
procedure QDir_setPath(handle: QDirH; path: PWideString); cdecl; external Qt5PasLib name 'QDir_setPath';
procedure QDir_path(handle: QDirH; retval: PWideString); cdecl; external Qt5PasLib name 'QDir_path';
procedure QDir_absolutePath(handle: QDirH; retval: PWideString); cdecl; external Qt5PasLib name 'QDir_absolutePath';
procedure QDir_canonicalPath(handle: QDirH; retval: PWideString); cdecl; external Qt5PasLib name 'QDir_canonicalPath';
procedure QDir_addResourceSearchPath(path: PWideString); cdecl; external Qt5PasLib name 'QDir_addResourceSearchPath';
procedure QDir_setSearchPaths(prefix: PWideString; searchPaths: QStringListH); cdecl; external Qt5PasLib name 'QDir_setSearchPaths';
procedure QDir_addSearchPath(prefix: PWideString; path: PWideString); cdecl; external Qt5PasLib name 'QDir_addSearchPath';
procedure QDir_searchPaths(retval: QStringListH; prefix: PWideString); cdecl; external Qt5PasLib name 'QDir_searchPaths';
procedure QDir_dirName(handle: QDirH; retval: PWideString); cdecl; external Qt5PasLib name 'QDir_dirName';
procedure QDir_filePath(handle: QDirH; retval: PWideString; fileName: PWideString); cdecl; external Qt5PasLib name 'QDir_filePath';
procedure QDir_absoluteFilePath(handle: QDirH; retval: PWideString; fileName: PWideString); cdecl; external Qt5PasLib name 'QDir_absoluteFilePath';
procedure QDir_relativeFilePath(handle: QDirH; retval: PWideString; fileName: PWideString); cdecl; external Qt5PasLib name 'QDir_relativeFilePath';
procedure QDir_toNativeSeparators(retval: PWideString; pathName: PWideString); cdecl; external Qt5PasLib name 'QDir_toNativeSeparators';
procedure QDir_fromNativeSeparators(retval: PWideString; pathName: PWideString); cdecl; external Qt5PasLib name 'QDir_fromNativeSeparators';
function QDir_cd(handle: QDirH; dirName: PWideString): Boolean; cdecl; external Qt5PasLib name 'QDir_cd';
function QDir_cdUp(handle: QDirH): Boolean; cdecl; external Qt5PasLib name 'QDir_cdUp';
procedure QDir_nameFilters(handle: QDirH; retval: QStringListH); cdecl; external Qt5PasLib name 'QDir_nameFilters';
procedure QDir_setNameFilters(handle: QDirH; nameFilters: QStringListH); cdecl; external Qt5PasLib name 'QDir_setNameFilters';
function QDir_filter(handle: QDirH): QDirFilters; cdecl; external Qt5PasLib name 'QDir_filter';
procedure QDir_setFilter(handle: QDirH; filter: QDirFilters); cdecl; external Qt5PasLib name 'QDir_setFilter';
function QDir_sorting(handle: QDirH): QDirSortFlags; cdecl; external Qt5PasLib name 'QDir_sorting';
procedure QDir_setSorting(handle: QDirH; sort: QDirSortFlags); cdecl; external Qt5PasLib name 'QDir_setSorting';
function QDir_count(handle: QDirH): LongWord; cdecl; external Qt5PasLib name 'QDir_count';
procedure QDir_nameFiltersFromString(retval: QStringListH; nameFilter: PWideString); cdecl; external Qt5PasLib name 'QDir_nameFiltersFromString';
procedure QDir_entryList(handle: QDirH; retval: QStringListH; filters: QDirFilters = QDirNoFilter; sort: QDirSortFlags = QDirNoSort); cdecl; external Qt5PasLib name 'QDir_entryList';
procedure QDir_entryList(handle: QDirH; retval: QStringListH; nameFilters: QStringListH; filters: QDirFilters = QDirNoFilter; sort: QDirSortFlags = QDirNoSort); cdecl; external Qt5PasLib name 'QDir_entryList2';
procedure QDir_entryInfoList(handle: QDirH; retval: PPtrIntArray; filters: QDirFilters = QDirNoFilter; sort: QDirSortFlags = QDirNoSort); cdecl; external Qt5PasLib name 'QDir_entryInfoList';
procedure QDir_entryInfoList(handle: QDirH; retval: PPtrIntArray; nameFilters: QStringListH; filters: QDirFilters = QDirNoFilter; sort: QDirSortFlags = QDirNoSort); cdecl; external Qt5PasLib name 'QDir_entryInfoList2';
function QDir_mkdir(handle: QDirH; dirName: PWideString): Boolean; cdecl; external Qt5PasLib name 'QDir_mkdir';
function QDir_rmdir(handle: QDirH; dirName: PWideString): Boolean; cdecl; external Qt5PasLib name 'QDir_rmdir';
function QDir_mkpath(handle: QDirH; dirPath: PWideString): Boolean; cdecl; external Qt5PasLib name 'QDir_mkpath';
function QDir_rmpath(handle: QDirH; dirPath: PWideString): Boolean; cdecl; external Qt5PasLib name 'QDir_rmpath';
function QDir_removeRecursively(handle: QDirH): Boolean; cdecl; external Qt5PasLib name 'QDir_removeRecursively';
function QDir_isReadable(handle: QDirH): Boolean; cdecl; external Qt5PasLib name 'QDir_isReadable';
function QDir_exists(handle: QDirH): Boolean; cdecl; external Qt5PasLib name 'QDir_exists';
function QDir_isRoot(handle: QDirH): Boolean; cdecl; external Qt5PasLib name 'QDir_isRoot';
function QDir_isRelativePath(path: PWideString): Boolean; cdecl; external Qt5PasLib name 'QDir_isRelativePath';
function QDir_isAbsolutePath(path: PWideString): Boolean; cdecl; external Qt5PasLib name 'QDir_isAbsolutePath';
function QDir_isRelative(handle: QDirH): Boolean; cdecl; external Qt5PasLib name 'QDir_isRelative';
function QDir_isAbsolute(handle: QDirH): Boolean; cdecl; external Qt5PasLib name 'QDir_isAbsolute';
function QDir_makeAbsolute(handle: QDirH): Boolean; cdecl; external Qt5PasLib name 'QDir_makeAbsolute';
function QDir_remove(handle: QDirH; fileName: PWideString): Boolean; cdecl; external Qt5PasLib name 'QDir_remove';
function QDir_rename(handle: QDirH; oldName: PWideString; newName: PWideString): Boolean; cdecl; external Qt5PasLib name 'QDir_rename';
function QDir_exists(handle: QDirH; name: PWideString): Boolean; cdecl; external Qt5PasLib name 'QDir_exists2';
procedure QDir_drives(retval: PPtrIntArray); cdecl; external Qt5PasLib name 'QDir_drives';
procedure QDir_separator(retval: PWideChar); cdecl; external Qt5PasLib name 'QDir_separator';
function QDir_setCurrent(path: PWideString): Boolean; cdecl; external Qt5PasLib name 'QDir_setCurrent';
procedure QDir_current(retval: QDirH); cdecl; external Qt5PasLib name 'QDir_current';
procedure QDir_currentPath(retval: PWideString); cdecl; external Qt5PasLib name 'QDir_currentPath';
procedure QDir_home(retval: QDirH); cdecl; external Qt5PasLib name 'QDir_home';
procedure QDir_homePath(retval: PWideString); cdecl; external Qt5PasLib name 'QDir_homePath';
procedure QDir_root(retval: QDirH); cdecl; external Qt5PasLib name 'QDir_root';
procedure QDir_rootPath(retval: PWideString); cdecl; external Qt5PasLib name 'QDir_rootPath';
procedure QDir_temp(retval: QDirH); cdecl; external Qt5PasLib name 'QDir_temp';
procedure QDir_tempPath(retval: PWideString); cdecl; external Qt5PasLib name 'QDir_tempPath';
function QDir_match(filters: QStringListH; fileName: PWideString): Boolean; cdecl; external Qt5PasLib name 'QDir_match';
function QDir_match(filter: PWideString; fileName: PWideString): Boolean; cdecl; external Qt5PasLib name 'QDir_match2';
procedure QDir_cleanPath(retval: PWideString; path: PWideString); cdecl; external Qt5PasLib name 'QDir_cleanPath';
procedure QDir_refresh(handle: QDirH); cdecl; external Qt5PasLib name 'QDir_refresh';


type
  QUrlParsingMode = ( // QUrl::ParsingMode (1)
    QUrlTolerantMode, QUrlStrictMode, QUrlDecodedMode );

type
  QUrlUrlFormattingOption = cardinal; //  QUrl::UrlFormattingOption (4)
  QUrlFormattingOptions = QUrlUrlFormattingOption; // QFlags<>

const
    QUrlNone = 0 { $0 };
    QUrlRemoveScheme = 1 { $1 };
    QUrlRemovePassword = 2 { $2 };
    QUrlRemoveUserInfo = 6 { $6 };
    QUrlRemovePort = 8 { $8 };
    QUrlRemoveAuthority = 30 { $1e };
    QUrlRemovePath = 32 { $20 };
    QUrlRemoveQuery = 64 { $40 };
    QUrlRemoveFragment = 128 { $80 };
    QUrlPreferLocalFile = 512 { $200 };
    QUrlStripTrailingSlash = 1024 { $400 };

type
  QUrlComponentFormattingOption = cardinal; //  QUrl::ComponentFormattingOption (4)
  QUrlComponentFormattingOptions = QUrlComponentFormattingOption; // QFlags<>

const
    QUrlPrettyDecoded = 0 { $0 };
    QUrlEncodeSpaces = 1048576 { $100000 };
    QUrlEncodeUnicode = 2097152 { $200000 };
    QUrlEncodeDelimiters = 12582912 { $c00000 };
    QUrlEncodeReserved = 16777216 { $1000000 };
    QUrlDecodeReserved = 33554432 { $2000000 };
    QUrlFullyEncoded = 32505856 { $1f00000 };
    QUrlFullyDecoded = 133169152 { $7f00000 };


function QUrl_Create(): QUrlH; cdecl; external Qt5PasLib name 'QUrl_Create';
procedure QUrl_Destroy(handle: QUrlH); cdecl; external Qt5PasLib name 'QUrl_Destroy'; 
function QUrl_Create(copy: QUrlH): QUrlH; cdecl; external Qt5PasLib name 'QUrl_Create2';
function QUrl_Create(url: PWideString; mode: QUrlParsingMode = QUrlTolerantMode): QUrlH; cdecl; external Qt5PasLib name 'QUrl_Create3';
procedure QUrl_swap(handle: QUrlH; other: QUrlH); cdecl; external Qt5PasLib name 'QUrl_swap';
procedure QUrl_setUrl(handle: QUrlH; url: PWideString; mode: QUrlParsingMode = QUrlTolerantMode); cdecl; external Qt5PasLib name 'QUrl_setUrl';
procedure QUrl_url(handle: QUrlH; retval: PWideString; options: QUrlFormattingOptions); cdecl; external Qt5PasLib name 'QUrl_url';
procedure QUrl_toString(handle: QUrlH; retval: PWideString; options: QUrlFormattingOptions); cdecl; external Qt5PasLib name 'QUrl_toString';
procedure QUrl_toDisplayString(handle: QUrlH; retval: PWideString; options: QUrlFormattingOptions); cdecl; external Qt5PasLib name 'QUrl_toDisplayString';
procedure QUrl_toEncoded(handle: QUrlH; retval: QByteArrayH; options: QUrlFormattingOptions = QUrlFullyEncoded); cdecl; external Qt5PasLib name 'QUrl_toEncoded';
procedure QUrl_fromEncoded(retval: QUrlH; url: QByteArrayH; mode: QUrlParsingMode = QUrlTolerantMode); cdecl; external Qt5PasLib name 'QUrl_fromEncoded';
procedure QUrl_fromUserInput(retval: QUrlH; userInput: PWideString); cdecl; external Qt5PasLib name 'QUrl_fromUserInput';
function QUrl_isValid(handle: QUrlH): Boolean; cdecl; external Qt5PasLib name 'QUrl_isValid';
procedure QUrl_errorString(handle: QUrlH; retval: PWideString); cdecl; external Qt5PasLib name 'QUrl_errorString';
function QUrl_isEmpty(handle: QUrlH): Boolean; cdecl; external Qt5PasLib name 'QUrl_isEmpty';
procedure QUrl_clear(handle: QUrlH); cdecl; external Qt5PasLib name 'QUrl_clear';
procedure QUrl_setScheme(handle: QUrlH; scheme: PWideString); cdecl; external Qt5PasLib name 'QUrl_setScheme';
procedure QUrl_scheme(handle: QUrlH; retval: PWideString); cdecl; external Qt5PasLib name 'QUrl_scheme';
procedure QUrl_setAuthority(handle: QUrlH; authority: PWideString; mode: QUrlParsingMode = QUrlTolerantMode); cdecl; external Qt5PasLib name 'QUrl_setAuthority';
procedure QUrl_authority(handle: QUrlH; retval: PWideString; options: QUrlComponentFormattingOptions = QUrlPrettyDecoded); cdecl; external Qt5PasLib name 'QUrl_authority';
procedure QUrl_setUserInfo(handle: QUrlH; userInfo: PWideString; mode: QUrlParsingMode = QUrlTolerantMode); cdecl; external Qt5PasLib name 'QUrl_setUserInfo';
procedure QUrl_userInfo(handle: QUrlH; retval: PWideString; options: QUrlComponentFormattingOptions = QUrlPrettyDecoded); cdecl; external Qt5PasLib name 'QUrl_userInfo';
procedure QUrl_setUserName(handle: QUrlH; userName: PWideString; mode: QUrlParsingMode = QUrlTolerantMode); cdecl; external Qt5PasLib name 'QUrl_setUserName';
procedure QUrl_userName(handle: QUrlH; retval: PWideString; options: QUrlComponentFormattingOptions = QUrlPrettyDecoded); cdecl; external Qt5PasLib name 'QUrl_userName';
procedure QUrl_setPassword(handle: QUrlH; password: PWideString; mode: QUrlParsingMode = QUrlTolerantMode); cdecl; external Qt5PasLib name 'QUrl_setPassword';
procedure QUrl_password(handle: QUrlH; retval: PWideString; AnonParam1: QUrlComponentFormattingOptions = QUrlPrettyDecoded); cdecl; external Qt5PasLib name 'QUrl_password';
procedure QUrl_setHost(handle: QUrlH; host: PWideString; mode: QUrlParsingMode = QUrlTolerantMode); cdecl; external Qt5PasLib name 'QUrl_setHost';
procedure QUrl_host(handle: QUrlH; retval: PWideString; AnonParam1: QUrlComponentFormattingOptions = QUrlPrettyDecoded); cdecl; external Qt5PasLib name 'QUrl_host';
procedure QUrl_topLevelDomain(handle: QUrlH; retval: PWideString; options: QUrlComponentFormattingOptions = QUrlPrettyDecoded); cdecl; external Qt5PasLib name 'QUrl_topLevelDomain';
procedure QUrl_setPort(handle: QUrlH; port: Integer); cdecl; external Qt5PasLib name 'QUrl_setPort';
function QUrl_port(handle: QUrlH; defaultPort: Integer = -1): Integer; cdecl; external Qt5PasLib name 'QUrl_port';
procedure QUrl_setPath(handle: QUrlH; path: PWideString; mode: QUrlParsingMode = QUrlTolerantMode); cdecl; external Qt5PasLib name 'QUrl_setPath';
procedure QUrl_path(handle: QUrlH; retval: PWideString; options: QUrlComponentFormattingOptions = QUrlPrettyDecoded); cdecl; external Qt5PasLib name 'QUrl_path';
function QUrl_hasQuery(handle: QUrlH): Boolean; cdecl; external Qt5PasLib name 'QUrl_hasQuery';
procedure QUrl_setQuery(handle: QUrlH; query: PWideString; mode: QUrlParsingMode = QUrlTolerantMode); cdecl; external Qt5PasLib name 'QUrl_setQuery';
procedure QUrl_setQuery(handle: QUrlH; query: QUrlQueryH); cdecl; external Qt5PasLib name 'QUrl_setQuery2';
procedure QUrl_query(handle: QUrlH; retval: PWideString; AnonParam1: QUrlComponentFormattingOptions = QUrlPrettyDecoded); cdecl; external Qt5PasLib name 'QUrl_query';
function QUrl_hasFragment(handle: QUrlH): Boolean; cdecl; external Qt5PasLib name 'QUrl_hasFragment';
procedure QUrl_fragment(handle: QUrlH; retval: PWideString; options: QUrlComponentFormattingOptions = QUrlPrettyDecoded); cdecl; external Qt5PasLib name 'QUrl_fragment';
procedure QUrl_setFragment(handle: QUrlH; fragment: PWideString; mode: QUrlParsingMode = QUrlTolerantMode); cdecl; external Qt5PasLib name 'QUrl_setFragment';
procedure QUrl_resolved(handle: QUrlH; retval: QUrlH; relative: QUrlH); cdecl; external Qt5PasLib name 'QUrl_resolved';
function QUrl_isRelative(handle: QUrlH): Boolean; cdecl; external Qt5PasLib name 'QUrl_isRelative';
function QUrl_isParentOf(handle: QUrlH; url: QUrlH): Boolean; cdecl; external Qt5PasLib name 'QUrl_isParentOf';
function QUrl_isLocalFile(handle: QUrlH): Boolean; cdecl; external Qt5PasLib name 'QUrl_isLocalFile';
procedure QUrl_fromLocalFile(retval: QUrlH; localfile: PWideString); cdecl; external Qt5PasLib name 'QUrl_fromLocalFile';
procedure QUrl_toLocalFile(handle: QUrlH; retval: PWideString); cdecl; external Qt5PasLib name 'QUrl_toLocalFile';
procedure QUrl_detach(handle: QUrlH); cdecl; external Qt5PasLib name 'QUrl_detach';
function QUrl_isDetached(handle: QUrlH): Boolean; cdecl; external Qt5PasLib name 'QUrl_isDetached';
procedure QUrl_fromPercentEncoding(retval: PWideString; AnonParam1: QByteArrayH); cdecl; external Qt5PasLib name 'QUrl_fromPercentEncoding';
procedure QUrl_toPercentEncoding(retval: QByteArrayH; AnonParam1: PWideString; exclude: QByteArrayH = nil; include: QByteArrayH = nil); cdecl; external Qt5PasLib name 'QUrl_toPercentEncoding';
procedure QUrl_fromAce(retval: PWideString; AnonParam1: QByteArrayH); cdecl; external Qt5PasLib name 'QUrl_fromAce';
procedure QUrl_toAce(retval: QByteArrayH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QUrl_toAce';
procedure QUrl_idnWhitelist(retval: QStringListH); cdecl; external Qt5PasLib name 'QUrl_idnWhitelist';
procedure QUrl_setIdnWhitelist(AnonParam1: QStringListH); cdecl; external Qt5PasLib name 'QUrl_setIdnWhitelist';

function QFileSystemWatcher_Create(parent: QObjectH = nil): QFileSystemWatcherH; cdecl; external Qt5PasLib name 'QFileSystemWatcher_Create';
procedure QFileSystemWatcher_Destroy(handle: QFileSystemWatcherH); cdecl; external Qt5PasLib name 'QFileSystemWatcher_Destroy'; 
function QFileSystemWatcher_Create(paths: QStringListH; parent: QObjectH = nil): QFileSystemWatcherH; cdecl; external Qt5PasLib name 'QFileSystemWatcher_Create2';
function QFileSystemWatcher_addPath(handle: QFileSystemWatcherH; _file: PWideString): Boolean; cdecl; external Qt5PasLib name 'QFileSystemWatcher_addPath';
procedure QFileSystemWatcher_addPaths(handle: QFileSystemWatcherH; retval: QStringListH; files: QStringListH); cdecl; external Qt5PasLib name 'QFileSystemWatcher_addPaths';
function QFileSystemWatcher_removePath(handle: QFileSystemWatcherH; _file: PWideString): Boolean; cdecl; external Qt5PasLib name 'QFileSystemWatcher_removePath';
procedure QFileSystemWatcher_removePaths(handle: QFileSystemWatcherH; retval: QStringListH; files: QStringListH); cdecl; external Qt5PasLib name 'QFileSystemWatcher_removePaths';
procedure QFileSystemWatcher_files(handle: QFileSystemWatcherH; retval: QStringListH); cdecl; external Qt5PasLib name 'QFileSystemWatcher_files';
procedure QFileSystemWatcher_directories(handle: QFileSystemWatcherH; retval: QStringListH); cdecl; external Qt5PasLib name 'QFileSystemWatcher_directories';


type
  QFileSystemWatcher_fileChanged_Event = procedure (path: PWideString) of object cdecl;
  QFileSystemWatcher_directoryChanged_Event = procedure (path: PWideString) of object cdecl;


type
  QPaletteColorGroup = cardinal; //  QPalette::ColorGroup (4)

const
    QPaletteActive = 0 { $0 };
    QPaletteDisabled = 1 { $1 };
    QPaletteInactive = 2 { $2 };
    QPaletteNColorGroups = 3 { $3 };
    QPaletteCurrent = 4 { $4 };
    QPaletteAll = 5 { $5 };
    QPaletteNormal = 0 { $0 };

type
  QPaletteColorRole = cardinal; //  QPalette::ColorRole (4)

const
    QPaletteWindowText = 0 { $0 };
    QPaletteButton = 1 { $1 };
    QPaletteLight = 2 { $2 };
    QPaletteMidlight = 3 { $3 };
    QPaletteDark = 4 { $4 };
    QPaletteMid = 5 { $5 };
    QPaletteText = 6 { $6 };
    QPaletteBrightText = 7 { $7 };
    QPaletteButtonText = 8 { $8 };
    QPaletteBase = 9 { $9 };
    QPaletteWindow = 10 { $a };
    QPaletteShadow = 11 { $b };
    QPaletteHighlight = 12 { $c };
    QPaletteHighlightedText = 13 { $d };
    QPaletteLink = 14 { $e };
    QPaletteLinkVisited = 15 { $f };
    QPaletteAlternateBase = 16 { $10 };
    QPaletteNoRole = 17 { $11 };
    QPaletteToolTipBase = 18 { $12 };
    QPaletteToolTipText = 19 { $13 };
    QPaletteNColorRoles = 20 { $14 };
    QPaletteForeground = 0 { $0 };
    QPaletteBackground = 10 { $a };


function QPalette_Create(): QPaletteH; cdecl; external Qt5PasLib name 'QPalette_Create';
procedure QPalette_Destroy(handle: QPaletteH); cdecl; external Qt5PasLib name 'QPalette_Destroy'; 
function QPalette_Create(button: PQColor): QPaletteH; cdecl; external Qt5PasLib name 'QPalette_Create2';
function QPalette_Create(button: QtGlobalColor): QPaletteH; cdecl; external Qt5PasLib name 'QPalette_Create3';
function QPalette_Create(button: PQColor; window: PQColor): QPaletteH; cdecl; external Qt5PasLib name 'QPalette_Create4';
function QPalette_Create(windowText: QBrushH; button: QBrushH; light: QBrushH; dark: QBrushH; mid: QBrushH; text: QBrushH; bright_text: QBrushH; base: QBrushH; window: QBrushH): QPaletteH; cdecl; external Qt5PasLib name 'QPalette_Create5';
function QPalette_Create(windowText: PQColor; window: PQColor; light: PQColor; dark: PQColor; mid: PQColor; text: PQColor; base: PQColor): QPaletteH; cdecl; external Qt5PasLib name 'QPalette_Create6';
function QPalette_Create(palette: QPaletteH): QPaletteH; cdecl; external Qt5PasLib name 'QPalette_Create7';
procedure QPalette_swap(handle: QPaletteH; other: QPaletteH); cdecl; external Qt5PasLib name 'QPalette_swap';
function QPalette_currentColorGroup(handle: QPaletteH): QPaletteColorGroup; cdecl; external Qt5PasLib name 'QPalette_currentColorGroup';
procedure QPalette_setCurrentColorGroup(handle: QPaletteH; cg: QPaletteColorGroup); cdecl; external Qt5PasLib name 'QPalette_setCurrentColorGroup';
function QPalette_color(handle: QPaletteH; cg: QPaletteColorGroup; cr: QPaletteColorRole): PQColor; cdecl; external Qt5PasLib name 'QPalette_color';
function QPalette_brush(handle: QPaletteH; cg: QPaletteColorGroup; cr: QPaletteColorRole): QBrushH; cdecl; external Qt5PasLib name 'QPalette_brush';
procedure QPalette_setColor(handle: QPaletteH; cg: QPaletteColorGroup; cr: QPaletteColorRole; color: PQColor); cdecl; external Qt5PasLib name 'QPalette_setColor';
procedure QPalette_setColor(handle: QPaletteH; cr: QPaletteColorRole; color: PQColor); cdecl; external Qt5PasLib name 'QPalette_setColor2';
procedure QPalette_setBrush(handle: QPaletteH; cr: QPaletteColorRole; brush: QBrushH); cdecl; external Qt5PasLib name 'QPalette_setBrush';
function QPalette_isBrushSet(handle: QPaletteH; cg: QPaletteColorGroup; cr: QPaletteColorRole): Boolean; cdecl; external Qt5PasLib name 'QPalette_isBrushSet';
procedure QPalette_setBrush(handle: QPaletteH; cg: QPaletteColorGroup; cr: QPaletteColorRole; brush: QBrushH); cdecl; external Qt5PasLib name 'QPalette_setBrush2';
procedure QPalette_setColorGroup(handle: QPaletteH; cr: QPaletteColorGroup; windowText: QBrushH; button: QBrushH; light: QBrushH; dark: QBrushH; mid: QBrushH; text: QBrushH; bright_text: QBrushH; base: QBrushH; window: QBrushH); cdecl; external Qt5PasLib name 'QPalette_setColorGroup';
function QPalette_isEqual(handle: QPaletteH; cr1: QPaletteColorGroup; cr2: QPaletteColorGroup): Boolean; cdecl; external Qt5PasLib name 'QPalette_isEqual';
function QPalette_color(handle: QPaletteH; cr: QPaletteColorRole): PQColor; cdecl; external Qt5PasLib name 'QPalette_color2';
function QPalette_brush(handle: QPaletteH; cr: QPaletteColorRole): QBrushH; cdecl; external Qt5PasLib name 'QPalette_brush2';
function QPalette_foreground(handle: QPaletteH): QBrushH; cdecl; external Qt5PasLib name 'QPalette_foreground';
function QPalette_windowText(handle: QPaletteH): QBrushH; cdecl; external Qt5PasLib name 'QPalette_windowText';
function QPalette_button(handle: QPaletteH): QBrushH; cdecl; external Qt5PasLib name 'QPalette_button';
function QPalette_light(handle: QPaletteH): QBrushH; cdecl; external Qt5PasLib name 'QPalette_light';
function QPalette_dark(handle: QPaletteH): QBrushH; cdecl; external Qt5PasLib name 'QPalette_dark';
function QPalette_mid(handle: QPaletteH): QBrushH; cdecl; external Qt5PasLib name 'QPalette_mid';
function QPalette_text(handle: QPaletteH): QBrushH; cdecl; external Qt5PasLib name 'QPalette_text';
function QPalette_base(handle: QPaletteH): QBrushH; cdecl; external Qt5PasLib name 'QPalette_base';
function QPalette_alternateBase(handle: QPaletteH): QBrushH; cdecl; external Qt5PasLib name 'QPalette_alternateBase';
function QPalette_toolTipBase(handle: QPaletteH): QBrushH; cdecl; external Qt5PasLib name 'QPalette_toolTipBase';
function QPalette_toolTipText(handle: QPaletteH): QBrushH; cdecl; external Qt5PasLib name 'QPalette_toolTipText';
function QPalette_background(handle: QPaletteH): QBrushH; cdecl; external Qt5PasLib name 'QPalette_background';
function QPalette_window(handle: QPaletteH): QBrushH; cdecl; external Qt5PasLib name 'QPalette_window';
function QPalette_midlight(handle: QPaletteH): QBrushH; cdecl; external Qt5PasLib name 'QPalette_midlight';
function QPalette_brightText(handle: QPaletteH): QBrushH; cdecl; external Qt5PasLib name 'QPalette_brightText';
function QPalette_buttonText(handle: QPaletteH): QBrushH; cdecl; external Qt5PasLib name 'QPalette_buttonText';
function QPalette_shadow(handle: QPaletteH): QBrushH; cdecl; external Qt5PasLib name 'QPalette_shadow';
function QPalette_highlight(handle: QPaletteH): QBrushH; cdecl; external Qt5PasLib name 'QPalette_highlight';
function QPalette_highlightedText(handle: QPaletteH): QBrushH; cdecl; external Qt5PasLib name 'QPalette_highlightedText';
function QPalette_link(handle: QPaletteH): QBrushH; cdecl; external Qt5PasLib name 'QPalette_link';
function QPalette_linkVisited(handle: QPaletteH): QBrushH; cdecl; external Qt5PasLib name 'QPalette_linkVisited';
function QPalette_isCopyOf(handle: QPaletteH; p: QPaletteH): Boolean; cdecl; external Qt5PasLib name 'QPalette_isCopyOf';
function QPalette_cacheKey(handle: QPaletteH): int64; cdecl; external Qt5PasLib name 'QPalette_cacheKey';
procedure QPalette_resolve(handle: QPaletteH; retval: QPaletteH; AnonParam1: QPaletteH); cdecl; external Qt5PasLib name 'QPalette_resolve';
function QPalette_resolve(handle: QPaletteH): LongWord; cdecl; external Qt5PasLib name 'QPalette_resolve2';
procedure QPalette_resolve(handle: QPaletteH; mask: LongWord); cdecl; external Qt5PasLib name 'QPalette_resolve3';


type
  QKeySequenceStandardKey = ( // QKeySequence::StandardKey (1)
    QKeySequenceUnknownKey, QKeySequenceHelpContents, QKeySequenceWhatsThis, QKeySequenceOpen, QKeySequenceClose, QKeySequenceSave, QKeySequenceNew, QKeySequenceDelete, QKeySequenceCut, 
    QKeySequenceCopy, QKeySequencePaste, QKeySequenceUndo, QKeySequenceRedo, QKeySequenceBack, QKeySequenceForward, QKeySequenceRefresh, QKeySequenceZoomIn, QKeySequenceZoomOut, QKeySequencePrint, 
    QKeySequenceAddTab, QKeySequenceNextChild, QKeySequencePreviousChild, QKeySequenceFind, QKeySequenceFindNext, QKeySequenceFindPrevious, QKeySequenceReplace, QKeySequenceSelectAll, QKeySequenceBold, 
    QKeySequenceItalic, QKeySequenceUnderline, QKeySequenceMoveToNextChar, QKeySequenceMoveToPreviousChar, QKeySequenceMoveToNextWord, QKeySequenceMoveToPreviousWord, QKeySequenceMoveToNextLine, 
    QKeySequenceMoveToPreviousLine, QKeySequenceMoveToNextPage, QKeySequenceMoveToPreviousPage, QKeySequenceMoveToStartOfLine, QKeySequenceMoveToEndOfLine, QKeySequenceMoveToStartOfBlock, 
    QKeySequenceMoveToEndOfBlock, QKeySequenceMoveToStartOfDocument, QKeySequenceMoveToEndOfDocument, QKeySequenceSelectNextChar, QKeySequenceSelectPreviousChar, QKeySequenceSelectNextWord, 
    QKeySequenceSelectPreviousWord, QKeySequenceSelectNextLine, QKeySequenceSelectPreviousLine, QKeySequenceSelectNextPage, QKeySequenceSelectPreviousPage, QKeySequenceSelectStartOfLine, 
    QKeySequenceSelectEndOfLine, QKeySequenceSelectStartOfBlock, QKeySequenceSelectEndOfBlock, QKeySequenceSelectStartOfDocument, QKeySequenceSelectEndOfDocument, QKeySequenceDeleteStartOfWord, 
    QKeySequenceDeleteEndOfWord, QKeySequenceDeleteEndOfLine, QKeySequenceInsertParagraphSeparator, QKeySequenceInsertLineSeparator, QKeySequenceSaveAs, QKeySequencePreferences, QKeySequenceQuit, 
    QKeySequenceFullScreen, QKeySequenceDeselect );

  QKeySequenceSequenceFormat = ( // QKeySequence::SequenceFormat (1)
    QKeySequenceNativeText, QKeySequencePortableText );

  QKeySequenceSequenceMatch = ( // QKeySequence::SequenceMatch (1)
    QKeySequenceNoMatch, QKeySequencePartialMatch, QKeySequenceExactMatch );

function QKeySequence_Create(): QKeySequenceH; cdecl; external Qt5PasLib name 'QKeySequence_Create';
procedure QKeySequence_Destroy(handle: QKeySequenceH); cdecl; external Qt5PasLib name 'QKeySequence_Destroy'; 
function QKeySequence_Create(key: PWideString; format: QKeySequenceSequenceFormat = QKeySequenceNativeText): QKeySequenceH; cdecl; external Qt5PasLib name 'QKeySequence_Create2';
function QKeySequence_Create(k1: Integer; k2: Integer = 0; k3: Integer = 0; k4: Integer = 0): QKeySequenceH; cdecl; external Qt5PasLib name 'QKeySequence_Create3';
function QKeySequence_Create(ks: QKeySequenceH): QKeySequenceH; cdecl; external Qt5PasLib name 'QKeySequence_Create4';
function QKeySequence_Create(key: QKeySequenceStandardKey): QKeySequenceH; cdecl; external Qt5PasLib name 'QKeySequence_Create5';
function QKeySequence_count(handle: QKeySequenceH): Integer; cdecl; external Qt5PasLib name 'QKeySequence_count';
function QKeySequence_isEmpty(handle: QKeySequenceH): Boolean; cdecl; external Qt5PasLib name 'QKeySequence_isEmpty';
procedure QKeySequence_toString(handle: QKeySequenceH; retval: PWideString; format: QKeySequenceSequenceFormat = QKeySequencePortableText); cdecl; external Qt5PasLib name 'QKeySequence_toString';
procedure QKeySequence_fromString(retval: QKeySequenceH; str: PWideString; format: QKeySequenceSequenceFormat = QKeySequencePortableText); cdecl; external Qt5PasLib name 'QKeySequence_fromString';
function QKeySequence_matches(handle: QKeySequenceH; seq: QKeySequenceH): QKeySequenceSequenceMatch; cdecl; external Qt5PasLib name 'QKeySequence_matches';
procedure QKeySequence_mnemonic(retval: QKeySequenceH; text: PWideString); cdecl; external Qt5PasLib name 'QKeySequence_mnemonic';
procedure QKeySequence_swap(handle: QKeySequenceH; other: QKeySequenceH); cdecl; external Qt5PasLib name 'QKeySequence_swap';
function QKeySequence_isDetached(handle: QKeySequenceH): Boolean; cdecl; external Qt5PasLib name 'QKeySequence_isDetached';


type
  QTabletEventTabletDevice = ( // QTabletEvent::TabletDevice (1)
    QTabletEventNoDevice, QTabletEventPuck, QTabletEventStylus, QTabletEventAirbrush, QTabletEventFourDMouse, QTabletEventXFreeEraser, QTabletEventRotationStylus );

  QTabletEventPointerType = ( // QTabletEvent::PointerType (1)
    QTabletEventUnknownPointer, QTabletEventPen, QTabletEventCursor, QTabletEventEraser );


type
  QContextMenuEventReason = ( // QContextMenuEvent::Reason (1)
    QContextMenuEventMouse, QContextMenuEventKeyboard, QContextMenuEventOther );


type
  QInputMethodEventAttributeType = ( // QInputMethodEvent::AttributeType (1)
    QInputMethodEventTextFormat, QInputMethodEventCursor, QInputMethodEventLanguage, QInputMethodEventRuby, QInputMethodEventSelection );


type
  QScrollEventScrollState = ( // QScrollEvent::ScrollState (1)
    QScrollEventScrollStarted, QScrollEventScrollUpdated, QScrollEventScrollFinished );

function QInputEvent_Create(_type: QEventType; modifiers: QtKeyboardModifiers = QtNoModifier): QInputEventH; cdecl; external Qt5PasLib name 'QInputEvent_Create';
procedure QInputEvent_Destroy(handle: QInputEventH); cdecl; external Qt5PasLib name 'QInputEvent_Destroy'; 
function QInputEvent_modifiers(handle: QInputEventH): QtKeyboardModifiers; cdecl; external Qt5PasLib name 'QInputEvent_modifiers';
procedure QInputEvent_setModifiers(handle: QInputEventH; amodifiers: QtKeyboardModifiers); cdecl; external Qt5PasLib name 'QInputEvent_setModifiers';
function QInputEvent_timestamp(handle: QInputEventH): Longword; cdecl; external Qt5PasLib name 'QInputEvent_timestamp';
procedure QInputEvent_setTimestamp(handle: QInputEventH; atimestamp: Longword); cdecl; external Qt5PasLib name 'QInputEvent_setTimestamp';

function QEnterEvent_Create(localPos: PQtPointF; windowPos: PQtPointF; screenPos: PQtPointF): QEnterEventH; cdecl; external Qt5PasLib name 'QEnterEvent_Create';
procedure QEnterEvent_Destroy(handle: QEnterEventH); cdecl; external Qt5PasLib name 'QEnterEvent_Destroy'; 
procedure QEnterEvent_pos(handle: QEnterEventH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QEnterEvent_pos';
procedure QEnterEvent_globalPos(handle: QEnterEventH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QEnterEvent_globalPos';
function QEnterEvent_x(handle: QEnterEventH): Integer; cdecl; external Qt5PasLib name 'QEnterEvent_x';
function QEnterEvent_y(handle: QEnterEventH): Integer; cdecl; external Qt5PasLib name 'QEnterEvent_y';
function QEnterEvent_globalX(handle: QEnterEventH): Integer; cdecl; external Qt5PasLib name 'QEnterEvent_globalX';
function QEnterEvent_globalY(handle: QEnterEventH): Integer; cdecl; external Qt5PasLib name 'QEnterEvent_globalY';
function QEnterEvent_localPos(handle: QEnterEventH): PQtPointF; cdecl; external Qt5PasLib name 'QEnterEvent_localPos';
function QEnterEvent_windowPos(handle: QEnterEventH): PQtPointF; cdecl; external Qt5PasLib name 'QEnterEvent_windowPos';
function QEnterEvent_screenPos(handle: QEnterEventH): PQtPointF; cdecl; external Qt5PasLib name 'QEnterEvent_screenPos';

function QMouseEvent_Create(_type: QEventType; localPos: PQtPointF; button: QtMouseButton; buttons: QtMouseButtons; modifiers: QtKeyboardModifiers): QMouseEventH; cdecl; external Qt5PasLib name 'QMouseEvent_Create';
procedure QMouseEvent_Destroy(handle: QMouseEventH); cdecl; external Qt5PasLib name 'QMouseEvent_Destroy'; 
function QMouseEvent_Create(_type: QEventType; localPos: PQtPointF; screenPos: PQtPointF; button: QtMouseButton; buttons: QtMouseButtons; modifiers: QtKeyboardModifiers): QMouseEventH; cdecl; external Qt5PasLib name 'QMouseEvent_Create2';
function QMouseEvent_Create(_type: QEventType; localPos: PQtPointF; windowPos: PQtPointF; screenPos: PQtPointF; button: QtMouseButton; buttons: QtMouseButtons; modifiers: QtKeyboardModifiers): QMouseEventH; cdecl; external Qt5PasLib name 'QMouseEvent_Create3';
procedure QMouseEvent_pos(handle: QMouseEventH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QMouseEvent_pos';
procedure QMouseEvent_globalPos(handle: QMouseEventH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QMouseEvent_globalPos';
function QMouseEvent_x(handle: QMouseEventH): Integer; cdecl; external Qt5PasLib name 'QMouseEvent_x';
function QMouseEvent_y(handle: QMouseEventH): Integer; cdecl; external Qt5PasLib name 'QMouseEvent_y';
function QMouseEvent_globalX(handle: QMouseEventH): Integer; cdecl; external Qt5PasLib name 'QMouseEvent_globalX';
function QMouseEvent_globalY(handle: QMouseEventH): Integer; cdecl; external Qt5PasLib name 'QMouseEvent_globalY';
function QMouseEvent_localPos(handle: QMouseEventH): PQtPointF; cdecl; external Qt5PasLib name 'QMouseEvent_localPos';
function QMouseEvent_windowPos(handle: QMouseEventH): PQtPointF; cdecl; external Qt5PasLib name 'QMouseEvent_windowPos';
function QMouseEvent_screenPos(handle: QMouseEventH): PQtPointF; cdecl; external Qt5PasLib name 'QMouseEvent_screenPos';
function QMouseEvent_button(handle: QMouseEventH): QtMouseButton; cdecl; external Qt5PasLib name 'QMouseEvent_button';
function QMouseEvent_buttons(handle: QMouseEventH): QtMouseButtons; cdecl; external Qt5PasLib name 'QMouseEvent_buttons';

function QHoverEvent_Create(_type: QEventType; pos: PQtPointF; oldPos: PQtPointF; modifiers: QtKeyboardModifiers = QtNoModifier): QHoverEventH; cdecl; external Qt5PasLib name 'QHoverEvent_Create';
procedure QHoverEvent_Destroy(handle: QHoverEventH); cdecl; external Qt5PasLib name 'QHoverEvent_Destroy'; 
procedure QHoverEvent_pos(handle: QHoverEventH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QHoverEvent_pos';
procedure QHoverEvent_oldPos(handle: QHoverEventH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QHoverEvent_oldPos';
function QHoverEvent_posF(handle: QHoverEventH): PQtPointF; cdecl; external Qt5PasLib name 'QHoverEvent_posF';
function QHoverEvent_oldPosF(handle: QHoverEventH): PQtPointF; cdecl; external Qt5PasLib name 'QHoverEvent_oldPosF';

function QWheelEvent_Create(pos: PQtPointF; delta: Integer; buttons: QtMouseButtons; modifiers: QtKeyboardModifiers; orient: QtOrientation = QtVertical): QWheelEventH; cdecl; external Qt5PasLib name 'QWheelEvent_Create';
procedure QWheelEvent_Destroy(handle: QWheelEventH); cdecl; external Qt5PasLib name 'QWheelEvent_Destroy'; 
function QWheelEvent_Create(pos: PQtPointF; globalPos: PQtPointF; delta: Integer; buttons: QtMouseButtons; modifiers: QtKeyboardModifiers; orient: QtOrientation = QtVertical): QWheelEventH; cdecl; external Qt5PasLib name 'QWheelEvent_Create2';
function QWheelEvent_Create(pos: PQtPointF; globalPos: PQtPointF; pixelDelta: PQtPoint; angleDelta: PQtPoint; qt4Delta: Integer; qt4Orientation: QtOrientation; buttons: QtMouseButtons; modifiers: QtKeyboardModifiers): QWheelEventH; cdecl; external Qt5PasLib name 'QWheelEvent_Create3';
procedure QWheelEvent_pixelDelta(handle: QWheelEventH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QWheelEvent_pixelDelta';
procedure QWheelEvent_angleDelta(handle: QWheelEventH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QWheelEvent_angleDelta';
function QWheelEvent_delta(handle: QWheelEventH): Integer; cdecl; external Qt5PasLib name 'QWheelEvent_delta';
function QWheelEvent_orientation(handle: QWheelEventH): QtOrientation; cdecl; external Qt5PasLib name 'QWheelEvent_orientation';
procedure QWheelEvent_pos(handle: QWheelEventH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QWheelEvent_pos';
procedure QWheelEvent_globalPos(handle: QWheelEventH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QWheelEvent_globalPos';
function QWheelEvent_x(handle: QWheelEventH): Integer; cdecl; external Qt5PasLib name 'QWheelEvent_x';
function QWheelEvent_y(handle: QWheelEventH): Integer; cdecl; external Qt5PasLib name 'QWheelEvent_y';
function QWheelEvent_globalX(handle: QWheelEventH): Integer; cdecl; external Qt5PasLib name 'QWheelEvent_globalX';
function QWheelEvent_globalY(handle: QWheelEventH): Integer; cdecl; external Qt5PasLib name 'QWheelEvent_globalY';
function QWheelEvent_posF(handle: QWheelEventH): PQtPointF; cdecl; external Qt5PasLib name 'QWheelEvent_posF';
function QWheelEvent_globalPosF(handle: QWheelEventH): PQtPointF; cdecl; external Qt5PasLib name 'QWheelEvent_globalPosF';
function QWheelEvent_buttons(handle: QWheelEventH): QtMouseButtons; cdecl; external Qt5PasLib name 'QWheelEvent_buttons';

function QTabletEvent_Create(t: QEventType; pos: PQtPointF; globalPos: PQtPointF; device: Integer; pointerType: Integer; pressure: qreal; xTilt: Integer; yTilt: Integer; tangentialPressure: qreal; rotation: qreal; z: Integer; keyState: QtKeyboardModifiers; uniqueID: int64): QTabletEventH; cdecl; external Qt5PasLib name 'QTabletEvent_Create';
procedure QTabletEvent_Destroy(handle: QTabletEventH); cdecl; external Qt5PasLib name 'QTabletEvent_Destroy'; 
procedure QTabletEvent_pos(handle: QTabletEventH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QTabletEvent_pos';
procedure QTabletEvent_globalPos(handle: QTabletEventH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QTabletEvent_globalPos';
function QTabletEvent_posF(handle: QTabletEventH): PQtPointF; cdecl; external Qt5PasLib name 'QTabletEvent_posF';
function QTabletEvent_globalPosF(handle: QTabletEventH): PQtPointF; cdecl; external Qt5PasLib name 'QTabletEvent_globalPosF';
function QTabletEvent_x(handle: QTabletEventH): Integer; cdecl; external Qt5PasLib name 'QTabletEvent_x';
function QTabletEvent_y(handle: QTabletEventH): Integer; cdecl; external Qt5PasLib name 'QTabletEvent_y';
function QTabletEvent_globalX(handle: QTabletEventH): Integer; cdecl; external Qt5PasLib name 'QTabletEvent_globalX';
function QTabletEvent_globalY(handle: QTabletEventH): Integer; cdecl; external Qt5PasLib name 'QTabletEvent_globalY';
function QTabletEvent_hiResGlobalX(handle: QTabletEventH): qreal; cdecl; external Qt5PasLib name 'QTabletEvent_hiResGlobalX';
function QTabletEvent_hiResGlobalY(handle: QTabletEventH): qreal; cdecl; external Qt5PasLib name 'QTabletEvent_hiResGlobalY';
function QTabletEvent_device(handle: QTabletEventH): QTabletEventTabletDevice; cdecl; external Qt5PasLib name 'QTabletEvent_device';
function QTabletEvent_pointerType(handle: QTabletEventH): QTabletEventPointerType; cdecl; external Qt5PasLib name 'QTabletEvent_pointerType';
function QTabletEvent_uniqueId(handle: QTabletEventH): int64; cdecl; external Qt5PasLib name 'QTabletEvent_uniqueId';
function QTabletEvent_pressure(handle: QTabletEventH): qreal; cdecl; external Qt5PasLib name 'QTabletEvent_pressure';
function QTabletEvent_z(handle: QTabletEventH): Integer; cdecl; external Qt5PasLib name 'QTabletEvent_z';
function QTabletEvent_tangentialPressure(handle: QTabletEventH): qreal; cdecl; external Qt5PasLib name 'QTabletEvent_tangentialPressure';
function QTabletEvent_rotation(handle: QTabletEventH): qreal; cdecl; external Qt5PasLib name 'QTabletEvent_rotation';
function QTabletEvent_xTilt(handle: QTabletEventH): Integer; cdecl; external Qt5PasLib name 'QTabletEvent_xTilt';
function QTabletEvent_yTilt(handle: QTabletEventH): Integer; cdecl; external Qt5PasLib name 'QTabletEvent_yTilt';

function QKeyEvent_Create(_type: QEventType; key: Integer; modifiers: QtKeyboardModifiers; text: PWideString = nil; autorep: Boolean = False; count: Word = 1): QKeyEventH; cdecl; external Qt5PasLib name 'QKeyEvent_Create';
procedure QKeyEvent_Destroy(handle: QKeyEventH); cdecl; external Qt5PasLib name 'QKeyEvent_Destroy'; 
function QKeyEvent_Create(_type: QEventType; key: Integer; modifiers: QtKeyboardModifiers; nativeScanCode: LongWord; nativeVirtualKey: LongWord; nativeModifiers: LongWord; text: PWideString = nil; autorep: Boolean = False; count: Word = 1): QKeyEventH; cdecl; external Qt5PasLib name 'QKeyEvent_Create2';
function QKeyEvent_key(handle: QKeyEventH): Integer; cdecl; external Qt5PasLib name 'QKeyEvent_key';
function QKeyEvent_matches(handle: QKeyEventH; key: QKeySequenceStandardKey): Boolean; cdecl; external Qt5PasLib name 'QKeyEvent_matches';
function QKeyEvent_modifiers(handle: QKeyEventH): QtKeyboardModifiers; cdecl; external Qt5PasLib name 'QKeyEvent_modifiers';
procedure QKeyEvent_text(handle: QKeyEventH; retval: PWideString); cdecl; external Qt5PasLib name 'QKeyEvent_text';
function QKeyEvent_isAutoRepeat(handle: QKeyEventH): Boolean; cdecl; external Qt5PasLib name 'QKeyEvent_isAutoRepeat';
function QKeyEvent_count(handle: QKeyEventH): Integer; cdecl; external Qt5PasLib name 'QKeyEvent_count';
function QKeyEvent_nativeScanCode(handle: QKeyEventH): LongWord; cdecl; external Qt5PasLib name 'QKeyEvent_nativeScanCode';
function QKeyEvent_nativeVirtualKey(handle: QKeyEventH): LongWord; cdecl; external Qt5PasLib name 'QKeyEvent_nativeVirtualKey';
function QKeyEvent_nativeModifiers(handle: QKeyEventH): LongWord; cdecl; external Qt5PasLib name 'QKeyEvent_nativeModifiers';

function QFocusEvent_Create(_type: QEventType; reason: QtFocusReason = QtOtherFocusReason): QFocusEventH; cdecl; external Qt5PasLib name 'QFocusEvent_Create';
procedure QFocusEvent_Destroy(handle: QFocusEventH); cdecl; external Qt5PasLib name 'QFocusEvent_Destroy'; 
function QFocusEvent_gotFocus(handle: QFocusEventH): Boolean; cdecl; external Qt5PasLib name 'QFocusEvent_gotFocus';
function QFocusEvent_lostFocus(handle: QFocusEventH): Boolean; cdecl; external Qt5PasLib name 'QFocusEvent_lostFocus';
function QFocusEvent_reason(handle: QFocusEventH): QtFocusReason; cdecl; external Qt5PasLib name 'QFocusEvent_reason';

function QPaintEvent_Create(paintRegion: QRegionH): QPaintEventH; cdecl; external Qt5PasLib name 'QPaintEvent_Create';
procedure QPaintEvent_Destroy(handle: QPaintEventH); cdecl; external Qt5PasLib name 'QPaintEvent_Destroy'; 
function QPaintEvent_Create(paintRect: PRect): QPaintEventH; cdecl; external Qt5PasLib name 'QPaintEvent_Create2';
procedure QPaintEvent_rect(handle: QPaintEventH; retval: PRect); cdecl; external Qt5PasLib name 'QPaintEvent_rect';
function QPaintEvent_region(handle: QPaintEventH): QRegionH; cdecl; external Qt5PasLib name 'QPaintEvent_region';

function QMoveEvent_Create(pos: PQtPoint; oldPos: PQtPoint): QMoveEventH; cdecl; external Qt5PasLib name 'QMoveEvent_Create';
procedure QMoveEvent_Destroy(handle: QMoveEventH); cdecl; external Qt5PasLib name 'QMoveEvent_Destroy'; 
function QMoveEvent_pos(handle: QMoveEventH): PQtPoint; cdecl; external Qt5PasLib name 'QMoveEvent_pos';
function QMoveEvent_oldPos(handle: QMoveEventH): PQtPoint; cdecl; external Qt5PasLib name 'QMoveEvent_oldPos';

function QExposeEvent_Create(rgn: QRegionH): QExposeEventH; cdecl; external Qt5PasLib name 'QExposeEvent_Create';
procedure QExposeEvent_Destroy(handle: QExposeEventH); cdecl; external Qt5PasLib name 'QExposeEvent_Destroy'; 
function QExposeEvent_region(handle: QExposeEventH): QRegionH; cdecl; external Qt5PasLib name 'QExposeEvent_region';

function QResizeEvent_Create(size: PSize; oldSize: PSize): QResizeEventH; cdecl; external Qt5PasLib name 'QResizeEvent_Create';
procedure QResizeEvent_Destroy(handle: QResizeEventH); cdecl; external Qt5PasLib name 'QResizeEvent_Destroy'; 
function QResizeEvent_size(handle: QResizeEventH): PSize; cdecl; external Qt5PasLib name 'QResizeEvent_size';
function QResizeEvent_oldSize(handle: QResizeEventH): PSize; cdecl; external Qt5PasLib name 'QResizeEvent_oldSize';

function QCloseEvent_Create(): QCloseEventH; cdecl; external Qt5PasLib name 'QCloseEvent_Create';
procedure QCloseEvent_Destroy(handle: QCloseEventH); cdecl; external Qt5PasLib name 'QCloseEvent_Destroy'; 

function QIconDragEvent_Create(): QIconDragEventH; cdecl; external Qt5PasLib name 'QIconDragEvent_Create';
procedure QIconDragEvent_Destroy(handle: QIconDragEventH); cdecl; external Qt5PasLib name 'QIconDragEvent_Destroy'; 

function QShowEvent_Create(): QShowEventH; cdecl; external Qt5PasLib name 'QShowEvent_Create';
procedure QShowEvent_Destroy(handle: QShowEventH); cdecl; external Qt5PasLib name 'QShowEvent_Destroy'; 

function QHideEvent_Create(): QHideEventH; cdecl; external Qt5PasLib name 'QHideEvent_Create';
procedure QHideEvent_Destroy(handle: QHideEventH); cdecl; external Qt5PasLib name 'QHideEvent_Destroy'; 

function QContextMenuEvent_Create(reason: QContextMenuEventReason; pos: PQtPoint; globalPos: PQtPoint; modifiers: QtKeyboardModifiers): QContextMenuEventH; cdecl; external Qt5PasLib name 'QContextMenuEvent_Create';
procedure QContextMenuEvent_Destroy(handle: QContextMenuEventH); cdecl; external Qt5PasLib name 'QContextMenuEvent_Destroy'; 
function QContextMenuEvent_Create(reason: QContextMenuEventReason; pos: PQtPoint; globalPos: PQtPoint): QContextMenuEventH; cdecl; external Qt5PasLib name 'QContextMenuEvent_Create2';
function QContextMenuEvent_Create(reason: QContextMenuEventReason; pos: PQtPoint): QContextMenuEventH; cdecl; external Qt5PasLib name 'QContextMenuEvent_Create3';
function QContextMenuEvent_x(handle: QContextMenuEventH): Integer; cdecl; external Qt5PasLib name 'QContextMenuEvent_x';
function QContextMenuEvent_y(handle: QContextMenuEventH): Integer; cdecl; external Qt5PasLib name 'QContextMenuEvent_y';
function QContextMenuEvent_globalX(handle: QContextMenuEventH): Integer; cdecl; external Qt5PasLib name 'QContextMenuEvent_globalX';
function QContextMenuEvent_globalY(handle: QContextMenuEventH): Integer; cdecl; external Qt5PasLib name 'QContextMenuEvent_globalY';
function QContextMenuEvent_pos(handle: QContextMenuEventH): PQtPoint; cdecl; external Qt5PasLib name 'QContextMenuEvent_pos';
function QContextMenuEvent_globalPos(handle: QContextMenuEventH): PQtPoint; cdecl; external Qt5PasLib name 'QContextMenuEvent_globalPos';
function QContextMenuEvent_reason(handle: QContextMenuEventH): QContextMenuEventReason; cdecl; external Qt5PasLib name 'QContextMenuEvent_reason';

function QInputMethodEvent_Create(): QInputMethodEventH; cdecl; external Qt5PasLib name 'QInputMethodEvent_Create';
procedure QInputMethodEvent_Destroy(handle: QInputMethodEventH); cdecl; external Qt5PasLib name 'QInputMethodEvent_Destroy'; 
procedure QInputMethodEvent_setCommitString(handle: QInputMethodEventH; commitString: PWideString; replaceFrom: Integer = 0; replaceLength: Integer = 0); cdecl; external Qt5PasLib name 'QInputMethodEvent_setCommitString';
procedure QInputMethodEvent_preeditString(handle: QInputMethodEventH; retval: PWideString); cdecl; external Qt5PasLib name 'QInputMethodEvent_preeditString';
procedure QInputMethodEvent_commitString(handle: QInputMethodEventH; retval: PWideString); cdecl; external Qt5PasLib name 'QInputMethodEvent_commitString';
function QInputMethodEvent_replacementStart(handle: QInputMethodEventH): Integer; cdecl; external Qt5PasLib name 'QInputMethodEvent_replacementStart';
function QInputMethodEvent_replacementLength(handle: QInputMethodEventH): Integer; cdecl; external Qt5PasLib name 'QInputMethodEvent_replacementLength';
function QInputMethodEvent_Create(other: QInputMethodEventH): QInputMethodEventH; cdecl; external Qt5PasLib name 'QInputMethodEvent_Create3';

function QInputMethodQueryEvent_Create(queries: QtInputMethodQueries): QInputMethodQueryEventH; cdecl; external Qt5PasLib name 'QInputMethodQueryEvent_Create';
procedure QInputMethodQueryEvent_Destroy(handle: QInputMethodQueryEventH); cdecl; external Qt5PasLib name 'QInputMethodQueryEvent_Destroy'; 
function QInputMethodQueryEvent_queries(handle: QInputMethodQueryEventH): QtInputMethodQueries; cdecl; external Qt5PasLib name 'QInputMethodQueryEvent_queries';
procedure QInputMethodQueryEvent_setValue(handle: QInputMethodQueryEventH; query: QtInputMethodQuery; value: QVariantH); cdecl; external Qt5PasLib name 'QInputMethodQueryEvent_setValue';
procedure QInputMethodQueryEvent_value(handle: QInputMethodQueryEventH; retval: QVariantH; query: QtInputMethodQuery); cdecl; external Qt5PasLib name 'QInputMethodQueryEvent_value';

function QDropEvent_Create(pos: PQtPointF; actions: QtDropActions; data: QMimeDataH; buttons: QtMouseButtons; modifiers: QtKeyboardModifiers; _type: QEventType): QDropEventH; cdecl; external Qt5PasLib name 'QDropEvent_Create';
procedure QDropEvent_Destroy(handle: QDropEventH); cdecl; external Qt5PasLib name 'QDropEvent_Destroy'; 
procedure QDropEvent_pos(handle: QDropEventH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QDropEvent_pos';
function QDropEvent_posF(handle: QDropEventH): PQtPointF; cdecl; external Qt5PasLib name 'QDropEvent_posF';
function QDropEvent_mouseButtons(handle: QDropEventH): QtMouseButtons; cdecl; external Qt5PasLib name 'QDropEvent_mouseButtons';
function QDropEvent_keyboardModifiers(handle: QDropEventH): QtKeyboardModifiers; cdecl; external Qt5PasLib name 'QDropEvent_keyboardModifiers';
function QDropEvent_possibleActions(handle: QDropEventH): QtDropActions; cdecl; external Qt5PasLib name 'QDropEvent_possibleActions';
function QDropEvent_proposedAction(handle: QDropEventH): QtDropAction; cdecl; external Qt5PasLib name 'QDropEvent_proposedAction';
procedure QDropEvent_acceptProposedAction(handle: QDropEventH); cdecl; external Qt5PasLib name 'QDropEvent_acceptProposedAction';
function QDropEvent_dropAction(handle: QDropEventH): QtDropAction; cdecl; external Qt5PasLib name 'QDropEvent_dropAction';
procedure QDropEvent_setDropAction(handle: QDropEventH; action: QtDropAction); cdecl; external Qt5PasLib name 'QDropEvent_setDropAction';
function QDropEvent_source(handle: QDropEventH): QObjectH; cdecl; external Qt5PasLib name 'QDropEvent_source';
function QDropEvent_mimeData(handle: QDropEventH): QMimeDataH; cdecl; external Qt5PasLib name 'QDropEvent_mimeData';

function QDragMoveEvent_Create(pos: PQtPoint; actions: QtDropActions; data: QMimeDataH; buttons: QtMouseButtons; modifiers: QtKeyboardModifiers; _type: QEventType): QDragMoveEventH; cdecl; external Qt5PasLib name 'QDragMoveEvent_Create';
procedure QDragMoveEvent_Destroy(handle: QDragMoveEventH); cdecl; external Qt5PasLib name 'QDragMoveEvent_Destroy'; 
procedure QDragMoveEvent_answerRect(handle: QDragMoveEventH; retval: PRect); cdecl; external Qt5PasLib name 'QDragMoveEvent_answerRect';
procedure QDragMoveEvent_accept(handle: QDragMoveEventH); cdecl; external Qt5PasLib name 'QDragMoveEvent_accept';
procedure QDragMoveEvent_ignore(handle: QDragMoveEventH); cdecl; external Qt5PasLib name 'QDragMoveEvent_ignore';
procedure QDragMoveEvent_accept(handle: QDragMoveEventH; r: PRect); cdecl; external Qt5PasLib name 'QDragMoveEvent_accept2';
procedure QDragMoveEvent_ignore(handle: QDragMoveEventH; r: PRect); cdecl; external Qt5PasLib name 'QDragMoveEvent_ignore2';

function QDragEnterEvent_Create(pos: PQtPoint; actions: QtDropActions; data: QMimeDataH; buttons: QtMouseButtons; modifiers: QtKeyboardModifiers): QDragEnterEventH; cdecl; external Qt5PasLib name 'QDragEnterEvent_Create';
procedure QDragEnterEvent_Destroy(handle: QDragEnterEventH); cdecl; external Qt5PasLib name 'QDragEnterEvent_Destroy'; 

function QDragLeaveEvent_Create(): QDragLeaveEventH; cdecl; external Qt5PasLib name 'QDragLeaveEvent_Create';
procedure QDragLeaveEvent_Destroy(handle: QDragLeaveEventH); cdecl; external Qt5PasLib name 'QDragLeaveEvent_Destroy'; 

function QHelpEvent_Create(_type: QEventType; pos: PQtPoint; globalPos: PQtPoint): QHelpEventH; cdecl; external Qt5PasLib name 'QHelpEvent_Create';
procedure QHelpEvent_Destroy(handle: QHelpEventH); cdecl; external Qt5PasLib name 'QHelpEvent_Destroy'; 
function QHelpEvent_x(handle: QHelpEventH): Integer; cdecl; external Qt5PasLib name 'QHelpEvent_x';
function QHelpEvent_y(handle: QHelpEventH): Integer; cdecl; external Qt5PasLib name 'QHelpEvent_y';
function QHelpEvent_globalX(handle: QHelpEventH): Integer; cdecl; external Qt5PasLib name 'QHelpEvent_globalX';
function QHelpEvent_globalY(handle: QHelpEventH): Integer; cdecl; external Qt5PasLib name 'QHelpEvent_globalY';
function QHelpEvent_pos(handle: QHelpEventH): PQtPoint; cdecl; external Qt5PasLib name 'QHelpEvent_pos';
function QHelpEvent_globalPos(handle: QHelpEventH): PQtPoint; cdecl; external Qt5PasLib name 'QHelpEvent_globalPos';

function QStatusTipEvent_Create(tip: PWideString): QStatusTipEventH; cdecl; external Qt5PasLib name 'QStatusTipEvent_Create';
procedure QStatusTipEvent_Destroy(handle: QStatusTipEventH); cdecl; external Qt5PasLib name 'QStatusTipEvent_Destroy'; 
procedure QStatusTipEvent_tip(handle: QStatusTipEventH; retval: PWideString); cdecl; external Qt5PasLib name 'QStatusTipEvent_tip';

function QWhatsThisClickedEvent_Create(href: PWideString): QWhatsThisClickedEventH; cdecl; external Qt5PasLib name 'QWhatsThisClickedEvent_Create';
procedure QWhatsThisClickedEvent_Destroy(handle: QWhatsThisClickedEventH); cdecl; external Qt5PasLib name 'QWhatsThisClickedEvent_Destroy'; 
procedure QWhatsThisClickedEvent_href(handle: QWhatsThisClickedEventH; retval: PWideString); cdecl; external Qt5PasLib name 'QWhatsThisClickedEvent_href';

function QActionEvent_Create(_type: Integer; action: QActionH; before: QActionH = nil): QActionEventH; cdecl; external Qt5PasLib name 'QActionEvent_Create';
procedure QActionEvent_Destroy(handle: QActionEventH); cdecl; external Qt5PasLib name 'QActionEvent_Destroy'; 
function QActionEvent_action(handle: QActionEventH): QActionH; cdecl; external Qt5PasLib name 'QActionEvent_action';
function QActionEvent_before(handle: QActionEventH): QActionH; cdecl; external Qt5PasLib name 'QActionEvent_before';

function QFileOpenEvent_Create(_file: PWideString): QFileOpenEventH; cdecl; external Qt5PasLib name 'QFileOpenEvent_Create';
procedure QFileOpenEvent_Destroy(handle: QFileOpenEventH); cdecl; external Qt5PasLib name 'QFileOpenEvent_Destroy'; 
function QFileOpenEvent_Create(url: QUrlH): QFileOpenEventH; cdecl; external Qt5PasLib name 'QFileOpenEvent_Create2';
procedure QFileOpenEvent_file(handle: QFileOpenEventH; retval: PWideString); cdecl; external Qt5PasLib name 'QFileOpenEvent_file';
procedure QFileOpenEvent_url(handle: QFileOpenEventH; retval: QUrlH); cdecl; external Qt5PasLib name 'QFileOpenEvent_url';
function QFileOpenEvent_openFile(handle: QFileOpenEventH; _file: QFileH; flags: QIODeviceOpenMode): Boolean; cdecl; external Qt5PasLib name 'QFileOpenEvent_openFile';

function QShortcutEvent_Create(key: QKeySequenceH; id: Integer; ambiguous: Boolean = False): QShortcutEventH; cdecl; external Qt5PasLib name 'QShortcutEvent_Create';
procedure QShortcutEvent_Destroy(handle: QShortcutEventH); cdecl; external Qt5PasLib name 'QShortcutEvent_Destroy'; 
function QShortcutEvent_key(handle: QShortcutEventH): QKeySequenceH; cdecl; external Qt5PasLib name 'QShortcutEvent_key';
function QShortcutEvent_shortcutId(handle: QShortcutEventH): Integer; cdecl; external Qt5PasLib name 'QShortcutEvent_shortcutId';
function QShortcutEvent_isAmbiguous(handle: QShortcutEventH): Boolean; cdecl; external Qt5PasLib name 'QShortcutEvent_isAmbiguous';

function QWindowStateChangeEvent_Create(aOldState: QtWindowStates; isOverride: Boolean = False): QWindowStateChangeEventH; cdecl; external Qt5PasLib name 'QWindowStateChangeEvent_Create';
procedure QWindowStateChangeEvent_Destroy(handle: QWindowStateChangeEventH); cdecl; external Qt5PasLib name 'QWindowStateChangeEvent_Destroy'; 
function QWindowStateChangeEvent_oldState(handle: QWindowStateChangeEventH): QtWindowStates; cdecl; external Qt5PasLib name 'QWindowStateChangeEvent_oldState';
function QWindowStateChangeEvent_isOverride(handle: QWindowStateChangeEventH): Boolean; cdecl; external Qt5PasLib name 'QWindowStateChangeEvent_isOverride';

function QTouchEvent_window(handle: QTouchEventH): QWindowH; cdecl; external Qt5PasLib name 'QTouchEvent_window';
function QTouchEvent_target(handle: QTouchEventH): QObjectH; cdecl; external Qt5PasLib name 'QTouchEvent_target';
function QTouchEvent_touchPointStates(handle: QTouchEventH): QtTouchPointStates; cdecl; external Qt5PasLib name 'QTouchEvent_touchPointStates';
function QTouchEvent_device(handle: QTouchEventH): QTouchDeviceH; cdecl; external Qt5PasLib name 'QTouchEvent_device';
procedure QTouchEvent_setWindow(handle: QTouchEventH; awindow: QWindowH); cdecl; external Qt5PasLib name 'QTouchEvent_setWindow';
procedure QTouchEvent_setTarget(handle: QTouchEventH; atarget: QObjectH); cdecl; external Qt5PasLib name 'QTouchEvent_setTarget';
procedure QTouchEvent_setTouchPointStates(handle: QTouchEventH; aTouchPointStates: QtTouchPointStates); cdecl; external Qt5PasLib name 'QTouchEvent_setTouchPointStates';
procedure QTouchEvent_setDevice(handle: QTouchEventH; adevice: QTouchDeviceH); cdecl; external Qt5PasLib name 'QTouchEvent_setDevice';

function QScrollPrepareEvent_Create(startPos: PQtPointF): QScrollPrepareEventH; cdecl; external Qt5PasLib name 'QScrollPrepareEvent_Create';
procedure QScrollPrepareEvent_Destroy(handle: QScrollPrepareEventH); cdecl; external Qt5PasLib name 'QScrollPrepareEvent_Destroy'; 
procedure QScrollPrepareEvent_startPos(handle: QScrollPrepareEventH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QScrollPrepareEvent_startPos';
procedure QScrollPrepareEvent_viewportSize(handle: QScrollPrepareEventH; retval: QSizeFH); cdecl; external Qt5PasLib name 'QScrollPrepareEvent_viewportSize';
procedure QScrollPrepareEvent_contentPosRange(handle: QScrollPrepareEventH; retval: QRectFH); cdecl; external Qt5PasLib name 'QScrollPrepareEvent_contentPosRange';
procedure QScrollPrepareEvent_contentPos(handle: QScrollPrepareEventH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QScrollPrepareEvent_contentPos';
procedure QScrollPrepareEvent_setViewportSize(handle: QScrollPrepareEventH; size: QSizeFH); cdecl; external Qt5PasLib name 'QScrollPrepareEvent_setViewportSize';
procedure QScrollPrepareEvent_setContentPosRange(handle: QScrollPrepareEventH; rect: QRectFH); cdecl; external Qt5PasLib name 'QScrollPrepareEvent_setContentPosRange';
procedure QScrollPrepareEvent_setContentPos(handle: QScrollPrepareEventH; pos: PQtPointF); cdecl; external Qt5PasLib name 'QScrollPrepareEvent_setContentPos';

function QScrollEvent_Create(contentPos: PQtPointF; overshoot: PQtPointF; scrollState: QScrollEventScrollState): QScrollEventH; cdecl; external Qt5PasLib name 'QScrollEvent_Create';
procedure QScrollEvent_Destroy(handle: QScrollEventH); cdecl; external Qt5PasLib name 'QScrollEvent_Destroy'; 
procedure QScrollEvent_contentPos(handle: QScrollEventH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QScrollEvent_contentPos';
procedure QScrollEvent_overshootDistance(handle: QScrollEventH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QScrollEvent_overshootDistance';
function QScrollEvent_scrollState(handle: QScrollEventH): QScrollEventScrollState; cdecl; external Qt5PasLib name 'QScrollEvent_scrollState';

function QScreenOrientationChangeEvent_Create(screen: QScreenH; orientation: QtScreenOrientation): QScreenOrientationChangeEventH; cdecl; external Qt5PasLib name 'QScreenOrientationChangeEvent_Create';
procedure QScreenOrientationChangeEvent_Destroy(handle: QScreenOrientationChangeEventH); cdecl; external Qt5PasLib name 'QScreenOrientationChangeEvent_Destroy'; 
function QScreenOrientationChangeEvent_screen(handle: QScreenOrientationChangeEventH): QScreenH; cdecl; external Qt5PasLib name 'QScreenOrientationChangeEvent_screen';
function QScreenOrientationChangeEvent_orientation(handle: QScreenOrientationChangeEventH): QtScreenOrientation; cdecl; external Qt5PasLib name 'QScreenOrientationChangeEvent_orientation';

function QApplicationStateChangeEvent_Create(state: QtApplicationState): QApplicationStateChangeEventH; cdecl; external Qt5PasLib name 'QApplicationStateChangeEvent_Create';
procedure QApplicationStateChangeEvent_Destroy(handle: QApplicationStateChangeEventH); cdecl; external Qt5PasLib name 'QApplicationStateChangeEvent_Destroy'; 
function QApplicationStateChangeEvent_applicationState(handle: QApplicationStateChangeEventH): QtApplicationState; cdecl; external Qt5PasLib name 'QApplicationStateChangeEvent_applicationState';

function QLCLMessageEvent_Create(aType: QEventType): QLCLMessageEventH; cdecl; external Qt5PasLib name 'QLCLMessageEvent_Create';
procedure QLCLMessageEvent_Destroy(handle: QLCLMessageEventH); cdecl; external Qt5PasLib name 'QLCLMessageEvent_Destroy'; 
function QLCLMessageEvent_Create(aType: QEventType; aMsg: PTRUINT; aWParam: PTRUINT; aLParam: PTRUINT; aMsgResult: PTRUINT): QLCLMessageEventH; cdecl; external Qt5PasLib name 'QLCLMessageEvent_Create2';
function QLCLMessageEvent_getMsg(handle: QLCLMessageEventH): PTRUINT; cdecl; external Qt5PasLib name 'QLCLMessageEvent_getMsg';
function QLCLMessageEvent_getWParam(handle: QLCLMessageEventH): PTRUINT; cdecl; external Qt5PasLib name 'QLCLMessageEvent_getWParam';
function QLCLMessageEvent_getLParam(handle: QLCLMessageEventH): PTRUINT; cdecl; external Qt5PasLib name 'QLCLMessageEvent_getLParam';
function QLCLMessageEvent_getMsgResult(handle: QLCLMessageEventH): PTRUINT; cdecl; external Qt5PasLib name 'QLCLMessageEvent_getMsgResult';
procedure QLCLMessageEvent_setMsg(handle: QLCLMessageEventH; Value: PTRUINT); cdecl; external Qt5PasLib name 'QLCLMessageEvent_setMsg';
procedure QLCLMessageEvent_setWParam(handle: QLCLMessageEventH; Value: PTRUINT); cdecl; external Qt5PasLib name 'QLCLMessageEvent_setWParam';
procedure QLCLMessageEvent_setLParam(handle: QLCLMessageEventH; Value: PTRUINT); cdecl; external Qt5PasLib name 'QLCLMessageEvent_setLParam';
procedure QLCLMessageEvent_setMsgResult(handle: QLCLMessageEventH; Value: PTRUINT); cdecl; external Qt5PasLib name 'QLCLMessageEvent_setMsgResult';

function QCursor_Create(): QCursorH; cdecl; external Qt5PasLib name 'QCursor_Create';
procedure QCursor_Destroy(handle: QCursorH); cdecl; external Qt5PasLib name 'QCursor_Destroy'; 
function QCursor_Create(shape: QtCursorShape): QCursorH; cdecl; external Qt5PasLib name 'QCursor_Create2';
function QCursor_Create(bitmap: QBitmapH; mask: QBitmapH; hotX: Integer = -1; hotY: Integer = -1): QCursorH; cdecl; external Qt5PasLib name 'QCursor_Create3';
function QCursor_Create(pixmap: QPixmapH; hotX: Integer = -1; hotY: Integer = -1): QCursorH; cdecl; external Qt5PasLib name 'QCursor_Create4';
function QCursor_Create(cursor: QCursorH): QCursorH; cdecl; external Qt5PasLib name 'QCursor_Create5';
function QCursor_shape(handle: QCursorH): QtCursorShape; cdecl; external Qt5PasLib name 'QCursor_shape';
procedure QCursor_setShape(handle: QCursorH; newShape: QtCursorShape); cdecl; external Qt5PasLib name 'QCursor_setShape';
function QCursor_bitmap(handle: QCursorH): QBitmapH; cdecl; external Qt5PasLib name 'QCursor_bitmap';
function QCursor_mask(handle: QCursorH): QBitmapH; cdecl; external Qt5PasLib name 'QCursor_mask';
procedure QCursor_pixmap(handle: QCursorH; retval: QPixmapH); cdecl; external Qt5PasLib name 'QCursor_pixmap';
procedure QCursor_hotSpot(handle: QCursorH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QCursor_hotSpot';
procedure QCursor_pos(retval: PQtPoint); cdecl; external Qt5PasLib name 'QCursor_pos';
procedure QCursor_pos(retval: PQtPoint; screen: QScreenH); cdecl; external Qt5PasLib name 'QCursor_pos2';
procedure QCursor_setPos(x: Integer; y: Integer); cdecl; external Qt5PasLib name 'QCursor_setPos';
procedure QCursor_setPos(screen: QScreenH; x: Integer; y: Integer); cdecl; external Qt5PasLib name 'QCursor_setPos2';
procedure QCursor_setPos(p: PQtPoint); cdecl; external Qt5PasLib name 'QCursor_setPos3';
procedure QCursor_setPos(screen: QScreenH; p: PQtPoint); cdecl; external Qt5PasLib name 'QCursor_setPos4';

type
  QClipboardMode = cardinal; //  QClipboard::Mode (4)

const
    QClipboardClipboard = 0 { $0 };
    QClipboardSelection = 1 { $1 };
    QClipboardFindBuffer = 2 { $2 };
    QClipboardLastMode = 2 { $2 };


procedure QClipboard_clear(handle: QClipboardH; mode: QClipboardMode = QClipboardClipboard); cdecl; external Qt5PasLib name 'QClipboard_clear';
function QClipboard_supportsSelection(handle: QClipboardH): Boolean; cdecl; external Qt5PasLib name 'QClipboard_supportsSelection';
function QClipboard_supportsFindBuffer(handle: QClipboardH): Boolean; cdecl; external Qt5PasLib name 'QClipboard_supportsFindBuffer';
function QClipboard_ownsSelection(handle: QClipboardH): Boolean; cdecl; external Qt5PasLib name 'QClipboard_ownsSelection';
function QClipboard_ownsClipboard(handle: QClipboardH): Boolean; cdecl; external Qt5PasLib name 'QClipboard_ownsClipboard';
function QClipboard_ownsFindBuffer(handle: QClipboardH): Boolean; cdecl; external Qt5PasLib name 'QClipboard_ownsFindBuffer';
procedure QClipboard_text(handle: QClipboardH; retval: PWideString; mode: QClipboardMode = QClipboardClipboard); cdecl; external Qt5PasLib name 'QClipboard_text';
procedure QClipboard_text(handle: QClipboardH; retval: PWideString; subtype: PWideString; mode: QClipboardMode = QClipboardClipboard); cdecl; external Qt5PasLib name 'QClipboard_text2';
procedure QClipboard_setText(handle: QClipboardH; AnonParam1: PWideString; mode: QClipboardMode = QClipboardClipboard); cdecl; external Qt5PasLib name 'QClipboard_setText';
function QClipboard_mimeData(handle: QClipboardH; mode: QClipboardMode = QClipboardClipboard): QMimeDataH; cdecl; external Qt5PasLib name 'QClipboard_mimeData';
procedure QClipboard_setMimeData(handle: QClipboardH; data: QMimeDataH; mode: QClipboardMode = QClipboardClipboard); cdecl; external Qt5PasLib name 'QClipboard_setMimeData';
procedure QClipboard_image(handle: QClipboardH; retval: QImageH; mode: QClipboardMode = QClipboardClipboard); cdecl; external Qt5PasLib name 'QClipboard_image';
procedure QClipboard_pixmap(handle: QClipboardH; retval: QPixmapH; mode: QClipboardMode = QClipboardClipboard); cdecl; external Qt5PasLib name 'QClipboard_pixmap';
procedure QClipboard_setImage(handle: QClipboardH; AnonParam1: QImageH; mode: QClipboardMode = QClipboardClipboard); cdecl; external Qt5PasLib name 'QClipboard_setImage';
procedure QClipboard_setPixmap(handle: QClipboardH; AnonParam1: QPixmapH; mode: QClipboardMode = QClipboardClipboard); cdecl; external Qt5PasLib name 'QClipboard_setPixmap';


type
  QClipboard_changed_Event = procedure (mode: QClipboardMode) of object cdecl;
  QClipboard_selectionChanged_Event = procedure () of object cdecl;
  QClipboard_findBufferChanged_Event = procedure () of object cdecl;
  QClipboard_dataChanged_Event = procedure () of object cdecl;


{$ifdef BINUX }
function QX11Info_isPlatformX11(): Boolean; cdecl; external Qt5PasLib name 'QX11Info_isPlatformX11';
function QX11Info_display(): PDisplay; cdecl; external Qt5PasLib name 'QX11Info_display';
function QX11Info_appScreen(): Integer; cdecl; external Qt5PasLib name 'QX11Info_appScreen';
function QX11Info_appRootWindow(screen: Integer = -1): QtHANDLE; cdecl; external Qt5PasLib name 'QX11Info_appRootWindow';
function QX11Info_appDpiX(screen: Integer = -1): Integer; cdecl; external Qt5PasLib name 'QX11Info_appDpiX';
function QX11Info_appDpiY(screen: Integer = -1): Integer; cdecl; external Qt5PasLib name 'QX11Info_appDpiY';
procedure QX11Info_setAppDpiX(screen: Integer; dpi: Integer); cdecl; external Qt5PasLib name 'QX11Info_setAppDpiX';
procedure QX11Info_setAppDpiY(screen: Integer; dpi: Integer); cdecl; external Qt5PasLib name 'QX11Info_setAppDpiY';
function QX11Info_appTime(): Longword; cdecl; external Qt5PasLib name 'QX11Info_appTime';
function QX11Info_appUserTime(): Longword; cdecl; external Qt5PasLib name 'QX11Info_appUserTime';
procedure QX11Info_setAppTime(time: Longword); cdecl; external Qt5PasLib name 'QX11Info_setAppTime';
procedure QX11Info_setAppUserTime(time: Longword); cdecl; external Qt5PasLib name 'QX11Info_setAppUserTime';
// function QX11Info_isCompositingManagerRunning(): Boolean; cdecl; external Qt5PasLib name 'QX11Info_isCompositingManagerRunning';
{$endif}

function QDrag_Create(dragSource: QObjectH): QDragH; cdecl; external Qt5PasLib name 'QDrag_Create';
procedure QDrag_Destroy(handle: QDragH); cdecl; external Qt5PasLib name 'QDrag_Destroy'; 
procedure QDrag_setMimeData(handle: QDragH; data: QMimeDataH); cdecl; external Qt5PasLib name 'QDrag_setMimeData';
function QDrag_mimeData(handle: QDragH): QMimeDataH; cdecl; external Qt5PasLib name 'QDrag_mimeData';
procedure QDrag_setPixmap(handle: QDragH; AnonParam1: QPixmapH); cdecl; external Qt5PasLib name 'QDrag_setPixmap';
procedure QDrag_pixmap(handle: QDragH; retval: QPixmapH); cdecl; external Qt5PasLib name 'QDrag_pixmap';
procedure QDrag_setHotSpot(handle: QDragH; hotspot: PQtPoint); cdecl; external Qt5PasLib name 'QDrag_setHotSpot';
procedure QDrag_hotSpot(handle: QDragH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QDrag_hotSpot';
function QDrag_source(handle: QDragH): QObjectH; cdecl; external Qt5PasLib name 'QDrag_source';
function QDrag_target(handle: QDragH): QObjectH; cdecl; external Qt5PasLib name 'QDrag_target';
function QDrag_start(handle: QDragH; supportedActions: QtDropActions = QtCopyAction): QtDropAction; cdecl; external Qt5PasLib name 'QDrag_start';
function QDrag_exec(handle: QDragH; supportedActions: QtDropActions = QtMoveAction): QtDropAction; cdecl; external Qt5PasLib name 'QDrag_exec';
function QDrag_exec(handle: QDragH; supportedActions: QtDropActions; defaultAction: QtDropAction): QtDropAction; cdecl; external Qt5PasLib name 'QDrag_exec2';
procedure QDrag_setDragCursor(handle: QDragH; cursor: QPixmapH; action: QtDropAction); cdecl; external Qt5PasLib name 'QDrag_setDragCursor';
procedure QDrag_dragCursor(handle: QDragH; retval: QPixmapH; action: QtDropAction); cdecl; external Qt5PasLib name 'QDrag_dragCursor';
function QDrag_supportedActions(handle: QDragH): QtDropActions; cdecl; external Qt5PasLib name 'QDrag_supportedActions';
function QDrag_defaultAction(handle: QDragH): QtDropAction; cdecl; external Qt5PasLib name 'QDrag_defaultAction';


type
  QDrag_actionChanged_Event = procedure (action: QtDropAction) of object cdecl;
  QDrag_targetChanged_Event = procedure (newTarget: QObjectH) of object cdecl;

{$ifndef QT_NO_SESSIONMANAGER}
type
  QSessionManagerRestartHint = ( // QSessionManager::RestartHint (1)
    QSessionManagerRestartIfRunning, QSessionManagerRestartAnyway, QSessionManagerRestartImmediately, QSessionManagerRestartNever );

procedure QSessionManager_sessionId(handle: QSessionManagerH; retval: PWideString); cdecl; external Qt5PasLib name 'QSessionManager_sessionId';
procedure QSessionManager_sessionKey(handle: QSessionManagerH; retval: PWideString); cdecl; external Qt5PasLib name 'QSessionManager_sessionKey';
function QSessionManager_allowsInteraction(handle: QSessionManagerH): Boolean; cdecl; external Qt5PasLib name 'QSessionManager_allowsInteraction';
function QSessionManager_allowsErrorInteraction(handle: QSessionManagerH): Boolean; cdecl; external Qt5PasLib name 'QSessionManager_allowsErrorInteraction';
procedure QSessionManager_release(handle: QSessionManagerH); cdecl; external Qt5PasLib name 'QSessionManager_release';
procedure QSessionManager_cancel(handle: QSessionManagerH); cdecl; external Qt5PasLib name 'QSessionManager_cancel';
procedure QSessionManager_setRestartHint(handle: QSessionManagerH; AnonParam1: QSessionManagerRestartHint); cdecl; external Qt5PasLib name 'QSessionManager_setRestartHint';
function QSessionManager_restartHint(handle: QSessionManagerH): QSessionManagerRestartHint; cdecl; external Qt5PasLib name 'QSessionManager_restartHint';
procedure QSessionManager_setRestartCommand(handle: QSessionManagerH; AnonParam1: QStringListH); cdecl; external Qt5PasLib name 'QSessionManager_setRestartCommand';
procedure QSessionManager_restartCommand(handle: QSessionManagerH; retval: QStringListH); cdecl; external Qt5PasLib name 'QSessionManager_restartCommand';
procedure QSessionManager_setDiscardCommand(handle: QSessionManagerH; AnonParam1: QStringListH); cdecl; external Qt5PasLib name 'QSessionManager_setDiscardCommand';
procedure QSessionManager_discardCommand(handle: QSessionManagerH; retval: QStringListH); cdecl; external Qt5PasLib name 'QSessionManager_discardCommand';
procedure QSessionManager_setManagerProperty(handle: QSessionManagerH; name: PWideString; value: PWideString); cdecl; external Qt5PasLib name 'QSessionManager_setManagerProperty';
procedure QSessionManager_setManagerProperty(handle: QSessionManagerH; name: PWideString; value: QStringListH); cdecl; external Qt5PasLib name 'QSessionManager_setManagerProperty2';
function QSessionManager_isPhase2(handle: QSessionManagerH): Boolean; cdecl; external Qt5PasLib name 'QSessionManager_isPhase2';
procedure QSessionManager_requestPhase2(handle: QSessionManagerH); cdecl; external Qt5PasLib name 'QSessionManager_requestPhase2';
{$endif}

function QGuiApplication_Create(argc: PInteger; argv: PPAnsiChar; AnonParam3: Integer = ApplicationFlags): QGuiApplicationH; cdecl; external Qt5PasLib name 'QGuiApplication_Create';
procedure QGuiApplication_Destroy(handle: QGuiApplicationH); cdecl; external Qt5PasLib name 'QGuiApplication_Destroy'; 
procedure QGuiApplication_setApplicationDisplayName(name: PWideString); cdecl; external Qt5PasLib name 'QGuiApplication_setApplicationDisplayName';
procedure QGuiApplication_applicationDisplayName(retval: PWideString); cdecl; external Qt5PasLib name 'QGuiApplication_applicationDisplayName';
function QGuiApplication_applicationState(): QtApplicationState; cdecl; external Qt5PasLib name 'QGuiApplication_applicationState';
procedure QGuiApplication_allWindows(retval: PPtrIntArray); cdecl; external Qt5PasLib name 'QGuiApplication_allWindows';
procedure QGuiApplication_topLevelWindows(retval: PPtrIntArray); cdecl; external Qt5PasLib name 'QGuiApplication_topLevelWindows';
function QGuiApplication_topLevelAt(pos: PQtPoint): QWindowH; cdecl; external Qt5PasLib name 'QGuiApplication_topLevelAt';
procedure QGuiApplication_platformName(retval: PWideString); cdecl; external Qt5PasLib name 'QGuiApplication_platformName';
function QGuiApplication_modalWindow(): QWindowH; cdecl; external Qt5PasLib name 'QGuiApplication_modalWindow';
function QGuiApplication_focusWindow(): QWindowH; cdecl; external Qt5PasLib name 'QGuiApplication_focusWindow';
function QGuiApplication_focusObject(): QObjectH; cdecl; external Qt5PasLib name 'QGuiApplication_focusObject';
function QGuiApplication_primaryScreen(): QScreenH; cdecl; external Qt5PasLib name 'QGuiApplication_primaryScreen';
function QGuiApplication_devicePixelRatio(handle: QGuiApplicationH): qreal; cdecl; external Qt5PasLib name 'QGuiApplication_devicePixelRatio';
function QGuiApplication_overrideCursor(): QCursorH; cdecl; external Qt5PasLib name 'QGuiApplication_overrideCursor';
procedure QGuiApplication_setOverrideCursor(AnonParam1: QCursorH); cdecl; external Qt5PasLib name 'QGuiApplication_setOverrideCursor';
procedure QGuiApplication_changeOverrideCursor(AnonParam1: QCursorH); cdecl; external Qt5PasLib name 'QGuiApplication_changeOverrideCursor';
procedure QGuiApplication_restoreOverrideCursor(); cdecl; external Qt5PasLib name 'QGuiApplication_restoreOverrideCursor';
procedure QGuiApplication_font(retval: QFontH); cdecl; external Qt5PasLib name 'QGuiApplication_font';
procedure QGuiApplication_setFont(AnonParam1: QFontH); cdecl; external Qt5PasLib name 'QGuiApplication_setFont';
function QGuiApplication_clipboard(): QClipboardH; cdecl; external Qt5PasLib name 'QGuiApplication_clipboard';
procedure QGuiApplication_palette(retval: QPaletteH); cdecl; external Qt5PasLib name 'QGuiApplication_palette';
procedure QGuiApplication_setPalette(pal: QPaletteH); cdecl; external Qt5PasLib name 'QGuiApplication_setPalette';
function QGuiApplication_keyboardModifiers(): QtKeyboardModifiers; cdecl; external Qt5PasLib name 'QGuiApplication_keyboardModifiers';
function QGuiApplication_queryKeyboardModifiers(): QtKeyboardModifiers; cdecl; external Qt5PasLib name 'QGuiApplication_queryKeyboardModifiers';
function QGuiApplication_mouseButtons(): QtMouseButtons; cdecl; external Qt5PasLib name 'QGuiApplication_mouseButtons';
procedure QGuiApplication_setLayoutDirection(direction: QtLayoutDirection); cdecl; external Qt5PasLib name 'QGuiApplication_setLayoutDirection';
function QGuiApplication_layoutDirection(): QtLayoutDirection; cdecl; external Qt5PasLib name 'QGuiApplication_layoutDirection';
function QGuiApplication_isRightToLeft(): Boolean; cdecl; external Qt5PasLib name 'QGuiApplication_isRightToLeft';
function QGuiApplication_isLeftToRight(): Boolean; cdecl; external Qt5PasLib name 'QGuiApplication_isLeftToRight';
function QGuiApplication_styleHints(): QStyleHintsH; cdecl; external Qt5PasLib name 'QGuiApplication_styleHints';
procedure QGuiApplication_setDesktopSettingsAware(_on: Boolean); cdecl; external Qt5PasLib name 'QGuiApplication_setDesktopSettingsAware';
function QGuiApplication_desktopSettingsAware(): Boolean; cdecl; external Qt5PasLib name 'QGuiApplication_desktopSettingsAware';
function QGuiApplication_inputMethod(): QInputMethodH; cdecl; external Qt5PasLib name 'QGuiApplication_inputMethod';
procedure QGuiApplication_setQuitOnLastWindowClosed(quit: Boolean); cdecl; external Qt5PasLib name 'QGuiApplication_setQuitOnLastWindowClosed';
function QGuiApplication_quitOnLastWindowClosed(): Boolean; cdecl; external Qt5PasLib name 'QGuiApplication_quitOnLastWindowClosed';
function QGuiApplication_exec(): Integer; cdecl; external Qt5PasLib name 'QGuiApplication_exec';
function QGuiApplication_notify(handle: QGuiApplicationH; AnonParam1: QObjectH; AnonParam2: QEventH): Boolean; cdecl; external Qt5PasLib name 'QGuiApplication_notify';
function QGuiApplication_isSessionRestored(handle: QGuiApplicationH): Boolean; cdecl; external Qt5PasLib name 'QGuiApplication_isSessionRestored';
procedure QGuiApplication_sessionId(handle: QGuiApplicationH; retval: PWideString); cdecl; external Qt5PasLib name 'QGuiApplication_sessionId';
procedure QGuiApplication_sessionKey(handle: QGuiApplicationH; retval: PWideString); cdecl; external Qt5PasLib name 'QGuiApplication_sessionKey';
function QGuiApplication_isSavingSession(handle: QGuiApplicationH): Boolean; cdecl; external Qt5PasLib name 'QGuiApplication_isSavingSession';
{$IFNDEF QT_NO_SESSIONMANAGER}
function QGuiApplication_isFallbackSessionManagementEnabled(): Boolean; cdecl; external Qt5PasLib name 'QGuiApplication_isFallbackSessionManagementEnabled';
procedure QGuiApplication_setFallbackSessionManagementEnabled(AEnabled: boolean); cdecl; external Qt5PasLib name 'QGuiApplication_setFallbackSessionManagementEnabled';
{$ENDIF}

type
  QGuiApplication_fontDatabaseChanged_Event = procedure () of object cdecl;
  QGuiApplication_screenAdded_Event = procedure (screen: QScreenH) of object cdecl;
  QGuiApplication_lastWindowClosed_Event = procedure () of object cdecl;
  QGuiApplication_focusObjectChanged_Event = procedure (focusObject: QObjectH) of object cdecl;
  QGuiApplication_focusWindowChanged_Event = procedure (focusWindow: QWindowH) of object cdecl;
  {$ifndef QT_NO_SESSIONMANAGER}
  QGuiApplication_commitDataRequest_Event = procedure (sessionManager: QSessionManagerH) of object cdecl;
  QGuiApplication_saveStateRequest_Event = procedure (sessionManager: QSessionManagerH) of object cdecl;
  {$endif}


type
  QApplicationColorSpec = (  //QApplication::ColorSpec (2)
    QApplicationNormalColor = 0,
    QApplicationCustomColor = 1,
    QApplicationManyColor = 2 );

function QApplication_Create(argc: PInteger; argv: PPAnsiChar; AnonParam3: Integer = ApplicationFlags): QApplicationH; cdecl; external Qt5PasLib name 'QApplication_Create';
procedure QApplication_Destroy(handle: QApplicationH); cdecl; external Qt5PasLib name 'QApplication_Destroy'; 
function QApplication_style(): QStyleH; cdecl; external Qt5PasLib name 'QApplication_style';
procedure QApplication_setStyle(AnonParam1: QStyleH); cdecl; external Qt5PasLib name 'QApplication_setStyle';
function QApplication_setStyle(AnonParam1: PWideString): QStyleH; cdecl; external Qt5PasLib name 'QApplication_setStyle2';
function QApplication_colorSpec(): Integer; cdecl; external Qt5PasLib name 'QApplication_colorSpec';
procedure QApplication_setColorSpec(AnonParam1: Integer); cdecl; external Qt5PasLib name 'QApplication_setColorSpec';
procedure QApplication_palette(retval: QPaletteH; AnonParam1: QWidgetH); cdecl; external Qt5PasLib name 'QApplication_palette';
procedure QApplication_palette(retval: QPaletteH; className: PAnsiChar); cdecl; external Qt5PasLib name 'QApplication_palette2';
procedure QApplication_setPalette(AnonParam1: QPaletteH; className: PAnsiChar = nil); cdecl; external Qt5PasLib name 'QApplication_setPalette';
procedure QApplication_font(retval: QFontH); cdecl; external Qt5PasLib name 'QApplication_font';
procedure QApplication_font(retval: QFontH; AnonParam1: QWidgetH); cdecl; external Qt5PasLib name 'QApplication_font2';
procedure QApplication_font(retval: QFontH; className: PAnsiChar); cdecl; external Qt5PasLib name 'QApplication_font3';
procedure QApplication_setFont(AnonParam1: QFontH; className: PAnsiChar = nil); cdecl; external Qt5PasLib name 'QApplication_setFont';
procedure QApplication_fontMetrics(retval: QFontMetricsH); cdecl; external Qt5PasLib name 'QApplication_fontMetrics';
procedure QApplication_setWindowIcon(icon: QIconH); cdecl; external Qt5PasLib name 'QApplication_setWindowIcon';
procedure QApplication_windowIcon(retval: QIconH); cdecl; external Qt5PasLib name 'QApplication_windowIcon';
function QApplication_desktop(): QDesktopWidgetH; cdecl; external Qt5PasLib name 'QApplication_desktop';
function QApplication_activePopupWidget(): QWidgetH; cdecl; external Qt5PasLib name 'QApplication_activePopupWidget';
function QApplication_activeModalWidget(): QWidgetH; cdecl; external Qt5PasLib name 'QApplication_activeModalWidget';
function QApplication_focusWidget(): QWidgetH; cdecl; external Qt5PasLib name 'QApplication_focusWidget';
function QApplication_activeWindow(): QWidgetH; cdecl; external Qt5PasLib name 'QApplication_activeWindow';
procedure QApplication_setActiveWindow(act: QWidgetH); cdecl; external Qt5PasLib name 'QApplication_setActiveWindow';
function QApplication_widgetAt(p: PQtPoint): QWidgetH; cdecl; external Qt5PasLib name 'QApplication_widgetAt';
function QApplication_widgetAt(x: Integer; y: Integer): QWidgetH; cdecl; external Qt5PasLib name 'QApplication_widgetAt2';
function QApplication_topLevelAt(p: PQtPoint): QWidgetH; cdecl; external Qt5PasLib name 'QApplication_topLevelAt';
function QApplication_topLevelAt(x: Integer; y: Integer): QWidgetH; cdecl; external Qt5PasLib name 'QApplication_topLevelAt2';
procedure QApplication_beep(); cdecl; external Qt5PasLib name 'QApplication_beep';
procedure QApplication_alert(widget: QWidgetH; duration: Integer = 0); cdecl; external Qt5PasLib name 'QApplication_alert';
procedure QApplication_setCursorFlashTime(AnonParam1: Integer); cdecl; external Qt5PasLib name 'QApplication_setCursorFlashTime';
function QApplication_cursorFlashTime(): Integer; cdecl; external Qt5PasLib name 'QApplication_cursorFlashTime';
procedure QApplication_setDoubleClickInterval(AnonParam1: Integer); cdecl; external Qt5PasLib name 'QApplication_setDoubleClickInterval';
function QApplication_doubleClickInterval(): Integer; cdecl; external Qt5PasLib name 'QApplication_doubleClickInterval';
procedure QApplication_setKeyboardInputInterval(AnonParam1: Integer); cdecl; external Qt5PasLib name 'QApplication_setKeyboardInputInterval';
function QApplication_keyboardInputInterval(): Integer; cdecl; external Qt5PasLib name 'QApplication_keyboardInputInterval';
procedure QApplication_setWheelScrollLines(AnonParam1: Integer); cdecl; external Qt5PasLib name 'QApplication_setWheelScrollLines';
function QApplication_wheelScrollLines(): Integer; cdecl; external Qt5PasLib name 'QApplication_wheelScrollLines';
procedure QApplication_setGlobalStrut(AnonParam1: PSize); cdecl; external Qt5PasLib name 'QApplication_setGlobalStrut';
procedure QApplication_globalStrut(retval: PSize); cdecl; external Qt5PasLib name 'QApplication_globalStrut';
procedure QApplication_setStartDragTime(ms: Integer); cdecl; external Qt5PasLib name 'QApplication_setStartDragTime';
function QApplication_startDragTime(): Integer; cdecl; external Qt5PasLib name 'QApplication_startDragTime';
procedure QApplication_setStartDragDistance(l: Integer); cdecl; external Qt5PasLib name 'QApplication_setStartDragDistance';
function QApplication_startDragDistance(): Integer; cdecl; external Qt5PasLib name 'QApplication_startDragDistance';
function QApplication_isEffectEnabled(AnonParam1: QtUIEffect): Boolean; cdecl; external Qt5PasLib name 'QApplication_isEffectEnabled';
procedure QApplication_setEffectEnabled(AnonParam1: QtUIEffect; enable: Boolean = True); cdecl; external Qt5PasLib name 'QApplication_setEffectEnabled';
function QApplication_exec(): Integer; cdecl; external Qt5PasLib name 'QApplication_exec';
function QApplication_notify(handle: QApplicationH; AnonParam1: QObjectH; AnonParam2: QEventH): Boolean; cdecl; external Qt5PasLib name 'QApplication_notify';
procedure QApplication_styleSheet(handle: QApplicationH; retval: PWideString); cdecl; external Qt5PasLib name 'QApplication_styleSheet';
procedure QApplication_setStyleSheet(handle: QApplicationH; sheet: PWideString); cdecl; external Qt5PasLib name 'QApplication_setStyleSheet';
procedure QApplication_setAutoSipEnabled(handle: QApplicationH; enabled: Boolean); cdecl; external Qt5PasLib name 'QApplication_setAutoSipEnabled';
function QApplication_autoSipEnabled(handle: QApplicationH): Boolean; cdecl; external Qt5PasLib name 'QApplication_autoSipEnabled';
procedure QApplication_closeAllWindows(); cdecl; external Qt5PasLib name 'QApplication_closeAllWindows';
procedure QApplication_aboutQt(); cdecl; external Qt5PasLib name 'QApplication_aboutQt';


type
  QApplication_focusChanged_Event = procedure (old: QWidgetH; now: QWidgetH) of object cdecl;


procedure QWhatsThis_enterWhatsThisMode(); cdecl; external Qt5PasLib name 'QWhatsThis_enterWhatsThisMode';
function QWhatsThis_inWhatsThisMode(): Boolean; cdecl; external Qt5PasLib name 'QWhatsThis_inWhatsThisMode';
procedure QWhatsThis_leaveWhatsThisMode(); cdecl; external Qt5PasLib name 'QWhatsThis_leaveWhatsThisMode';
procedure QWhatsThis_showText(pos: PQtPoint; text: PWideString; w: QWidgetH = nil); cdecl; external Qt5PasLib name 'QWhatsThis_showText';
procedure QWhatsThis_hideText(); cdecl; external Qt5PasLib name 'QWhatsThis_hideText';
function QWhatsThis_createAction(parent: QObjectH = nil): QActionH; cdecl; external Qt5PasLib name 'QWhatsThis_createAction';


type
  QSizePolicyPolicyFlag = (  //QSizePolicy::PolicyFlag (2)
    QSizePolicyGrowFlag = 1,
    QSizePolicyExpandFlag = 2,
    QSizePolicyShrinkFlag = 4,
    QSizePolicyIgnoreFlag = 8 );

type
  QSizePolicyControlType = cardinal; // QSizePolicy::ControlType
  QSizePolicyControlTypes = QSizePolicyControlType; //QFlags<> (3)
const
  QSizePolicyDefaultType =   $00000001;
  QSizePolicyButtonBox =   $00000002;
  QSizePolicyCheckBox =   $00000004;
  QSizePolicyComboBox =   $00000008;
  QSizePolicyFrame =   $00000010;
  QSizePolicyGroupBox =   $00000020;
  QSizePolicyLabel =   $00000040;
  QSizePolicyLine =   $00000080;
  QSizePolicyLineEdit =   $00000100;
  QSizePolicyPushButton =   $00000200;
  QSizePolicyRadioButton =   $00000400;
  QSizePolicySlider =   $00000800;
  QSizePolicySpinBox =   $00001000;
  QSizePolicyTabWidget =   $00002000;
  QSizePolicyToolButton =   $00004000;

type
  QSizePolicyPolicy = cardinal; //  QSizePolicy::Policy (4)

const
    QSizePolicyFixed = 0 { $0 };
    QSizePolicyMinimum = 1 { $1 };
    QSizePolicyMaximum = 4 { $4 };
    QSizePolicyPreferred = 5 { $5 };
    QSizePolicyMinimumExpanding = 3 { $3 };
    QSizePolicyExpanding = 7 { $7 };
    QSizePolicyIgnored = 13 { $d };


function QSizePolicy_Create(): QSizePolicyH; cdecl; external Qt5PasLib name 'QSizePolicy_Create';
procedure QSizePolicy_Destroy(handle: QSizePolicyH); cdecl; external Qt5PasLib name 'QSizePolicy_Destroy'; 
function QSizePolicy_Create(horizontal: QSizePolicyPolicy; vertical: QSizePolicyPolicy; _type: QSizePolicyControlType = QSizePolicyDefaultType): QSizePolicyH; cdecl; external Qt5PasLib name 'QSizePolicy_Create2';
function QSizePolicy_horizontalPolicy(handle: QSizePolicyH): QSizePolicyPolicy; cdecl; external Qt5PasLib name 'QSizePolicy_horizontalPolicy';
function QSizePolicy_verticalPolicy(handle: QSizePolicyH): QSizePolicyPolicy; cdecl; external Qt5PasLib name 'QSizePolicy_verticalPolicy';
function QSizePolicy_controlType(handle: QSizePolicyH): QSizePolicyControlType; cdecl; external Qt5PasLib name 'QSizePolicy_controlType';
procedure QSizePolicy_setHorizontalPolicy(handle: QSizePolicyH; d: QSizePolicyPolicy); cdecl; external Qt5PasLib name 'QSizePolicy_setHorizontalPolicy';
procedure QSizePolicy_setVerticalPolicy(handle: QSizePolicyH; d: QSizePolicyPolicy); cdecl; external Qt5PasLib name 'QSizePolicy_setVerticalPolicy';
procedure QSizePolicy_setControlType(handle: QSizePolicyH; _type: QSizePolicyControlType); cdecl; external Qt5PasLib name 'QSizePolicy_setControlType';
function QSizePolicy_expandingDirections(handle: QSizePolicyH): QtOrientations; cdecl; external Qt5PasLib name 'QSizePolicy_expandingDirections';
procedure QSizePolicy_setHeightForWidth(handle: QSizePolicyH; b: Boolean); cdecl; external Qt5PasLib name 'QSizePolicy_setHeightForWidth';
function QSizePolicy_hasHeightForWidth(handle: QSizePolicyH): Boolean; cdecl; external Qt5PasLib name 'QSizePolicy_hasHeightForWidth';
procedure QSizePolicy_setWidthForHeight(handle: QSizePolicyH; b: Boolean); cdecl; external Qt5PasLib name 'QSizePolicy_setWidthForHeight';
function QSizePolicy_hasWidthForHeight(handle: QSizePolicyH): Boolean; cdecl; external Qt5PasLib name 'QSizePolicy_hasWidthForHeight';
function QSizePolicy_horizontalStretch(handle: QSizePolicyH): Integer; cdecl; external Qt5PasLib name 'QSizePolicy_horizontalStretch';
function QSizePolicy_verticalStretch(handle: QSizePolicyH): Integer; cdecl; external Qt5PasLib name 'QSizePolicy_verticalStretch';
procedure QSizePolicy_setHorizontalStretch(handle: QSizePolicyH; stretchFactor: Integer); cdecl; external Qt5PasLib name 'QSizePolicy_setHorizontalStretch';
procedure QSizePolicy_setVerticalStretch(handle: QSizePolicyH; stretchFactor: Integer); cdecl; external Qt5PasLib name 'QSizePolicy_setVerticalStretch';
procedure QSizePolicy_transpose(handle: QSizePolicyH); cdecl; external Qt5PasLib name 'QSizePolicy_transpose';


function QBackingStore_Create(window: QWindowH): QBackingStoreH; cdecl; external Qt5PasLib name 'QBackingStore_Create';
procedure QBackingStore_Destroy(handle: QBackingStoreH); cdecl; external Qt5PasLib name 'QBackingStore_Destroy';
function QBackingStore_window(handle: QBackingStoreH): QWindowH; cdecl; external Qt5PasLib name 'QBackingStore_window';
function QBackingStore_paintDevice(handle: QBackingStoreH): QPaintDeviceH; cdecl; external Qt5PasLib name 'QBackingStore_paintDevice';
procedure QBackingStore_flush(handle: QBackingStoreH; region: QRegionH; window: QWindowH; offset: PQtPoint); cdecl; external Qt5PasLib name 'QBackingStore_flush';
procedure QBackingStore_resize(handle: QBackingStoreH; AnonParam1: PSize); cdecl; external Qt5PasLib name 'QBackingStore_resize';
procedure QBackingStore_size(handle: QBackingStoreH; retval: PSize); cdecl; external Qt5PasLib name 'QBackingStore_size';
function QBackingStore_scroll(handle: QBackingStoreH; area: QRegionH; dx: integer; dy: integer): boolean; cdecl; external Qt5PasLib name 'QBackingStore_scroll';
procedure QBackingStore_beginPaint(handle: QBackingStoreH; AnonParam1: QRegionH); cdecl; external Qt5PasLib name 'QBackingStore_beginPaint';
procedure QBackingStore_endPaint(handle: QBackingStoreH); cdecl; external Qt5PasLib name 'QBackingStore_endPaint';
procedure QBackingStore_setStaticContents(handle: QBackingStoreH; AnonParam1: QRegionH); cdecl; external Qt5PasLib name 'QBackingStore_setStaticContents';
procedure QBackingStore_staticContents(handle: QBackingStoreH; retval: QRegionH); cdecl; external Qt5PasLib name 'QBackingStore_staticContents';
function QBackingStore_hasStaticContents(handle: QBackingStoreH): boolean; cdecl; external Qt5PasLib name 'QBackingStore_hasStaticContents';


type
  QSurfaceSurfaceClass = (QSurfaceSurfaceClassWindow, QSurfaceSurfaceClassOffscreen);
  QSurfaceSurfaceType = (QSurfaceSurfaceTypeRasterSurface, QSurfaceSurfaceTypeOpenGLSurface, QSurfaceSurfaceTypeRasterGLSurface);


procedure QSurface_Destroy(handle: QSurfaceH); cdecl; external Qt5PasLib name 'QSurface_Destroy';
procedure QSurface_size(handle: QSurfaceH; retval: PSize); cdecl; external Qt5PasLib name 'QSurface_size';
function QSurface_supportsOpenGL(handle: QSurfaceH): boolean; cdecl; external Qt5PasLib name 'QSurface_supportsOpenGL';
function QSurface_surfaceClass(handle: QSurfaceH): QSurfaceSurfaceClass; cdecl; external Qt5PasLib name 'QSurface_surfaceClass';
function QSurface_surfaceType(handle: QSurfaceH): QSurfaceSurfaceType; cdecl; external Qt5PasLib name 'QSurface_surfaceType';
procedure QSurface_format(handle: QSurfaceH; retval: QSurfaceFormatH); cdecl; external Qt5PasLib name 'QSurface_format';


type
  QSurfaceFormatFormatOptions = cardinal;
  QSurfaceFormatFormatOption = cardinal;

const
  QSurfaceFormatOptionStereoBuffers = $0001;
  QSurfaceFormatOptionDebugContext = $0002;
  QSurfaceFormatOptionDeprecatedFunctions = $0004;
  QSurfaceFormatOptionResetNotification = $0008;

type
  QSurfaceSwapBehavior = (QSurfaceSwapBehaviorDefaultSwapBehavior,
        QSurfaceSwapBehaviorSingleBuffer, QSurfaceSwapBehaviorDoubleBuffer,
        QSurfaceSwapBehaviorTripleBuffer);

 QSurfaceFormatOpenGLContextProfile = (QSurfaceFormatOpenGLContextProfileNoProfile,
   QSurfaceFormatOpenGLContextProfileCoreProfile,
   QSurfaceFormatOpenGLContextProfileCompatibilityProfile);

 QSurfaceFormatRenderableType = (QSurfaceFormatRenderableTypeDefaultRenderableType = $0,
 QSurfaceFormatRenderableTypeOpenGL = $1, QSurfaceFormatRenderableTypeOpenGLES = $2,
 QSurfaceFormatRenderableTypeOpenVG = $4);

function QSurfaceFormat_Create(): QSurfaceFormatH; cdecl; external Qt5PasLib name 'QSurfaceFormat_Create';
function QSurfaceFormat_Create(options: QSurfaceFormatFormatOptions):QSurfaceFormatH; cdecl; external Qt5PasLib name 'QSurfaceFormat_Create2';
procedure QSurfaceFormat_Destroy(handle: QSurfaceFormatH); cdecl; external Qt5PasLib name 'QSurfaceFormat_Destroy';
procedure QSurfaceFormat_setDepthBufferSize(handle: QSurfaceFormatH; asize: integer); cdecl; external Qt5PasLib name 'QSurfaceFormat_setDepthBufferSize';
function QSurfaceFormat_depthBufferSize(handle: QSurfaceFormatH): integer; cdecl; external Qt5PasLib name 'QSurfaceFormat_depthBufferSize';
procedure QSurfaceFormat_setStencilBufferSize(handle: QSurfaceFormatH; asize: integer); cdecl; external Qt5PasLib name 'QSurfaceFormat_setStencilBufferSize';
function QSurfaceFormat_stencilBufferSize(handle: QSurfaceFormatH): integer; cdecl; external Qt5PasLib name 'QSurfaceFormat_stencilBufferSize';
procedure QSurfaceFormat_setRedBufferSize(handle: QSurfaceFormatH; asize: integer); cdecl; external Qt5PasLib name 'QSurfaceFormat_setRedBufferSize';
function QSurfaceFormat_redBufferSize(handle: QSurfaceFormatH): integer; cdecl; external Qt5PasLib name 'QSurfaceFormat_redBufferSize';
procedure QSurfaceFormat_setGreenBufferSize(handle: QSurfaceFormatH; asize: integer); cdecl; external Qt5PasLib name 'QSurfaceFormat_setGreenBufferSize';
function QSurfaceFormat_greenBufferSize(handle: QSurfaceFormatH): integer; cdecl; external Qt5PasLib name 'QSurfaceFormat_greenBufferSize';
procedure QSurfaceFormat_setBlueBufferSize(handle: QSurfaceFormatH; asize: integer); cdecl; external Qt5PasLib name 'QSurfaceFormat_setBlueBufferSize';
function QSurfaceFormat_blueBufferSize(handle: QSurfaceFormatH): integer; cdecl; external Qt5PasLib name 'QSurfaceFormat_blueBufferSize';
procedure QSurfaceFormat_setAlphaBufferSize(handle: QSurfaceFormatH; asize: integer); cdecl; external Qt5PasLib name 'QSurfaceFormat_setAlphaBufferSize';
function QSurfaceFormat_alphaBufferSize(handle: QSurfaceFormatH): integer; cdecl; external Qt5PasLib name 'QSurfaceFormat_alphaBufferSize';
procedure QSurfaceFormat_setSamples(handle: QSurfaceFormatH; numSamples: integer); cdecl; external Qt5PasLib name 'QSurfaceFormat_setSamples';
function QSurfaceFormat_samples(handle: QSurfaceFormatH): integer; cdecl; external Qt5PasLib name 'QSurfaceFormat_samples';
procedure QSurfaceFormat_setSwapBehavior(handle: QSurfaceFormatH; behavior: QSurfaceSwapBehavior); cdecl; external Qt5PasLib name 'QSurfaceFormat_setSwapBehavior';
function QSurfaceFormat_swapBehavior(handle: QSurfaceFormatH): QSurfaceSwapBehavior; cdecl; external Qt5PasLib name 'QSurfaceFormat_swapBehavior';
function QSurfaceFormat_hasAlpha(handle: QSurfaceFormatH): boolean; cdecl; external Qt5PasLib name 'QSurfaceFormat_hasAlpha';
procedure QSurfaceFormat_setProfile(handle: QSurfaceFormatH; profile: QSurfaceFormatOpenGLContextProfile); cdecl; external Qt5PasLib name 'QSurfaceFormat_setProfile';
function QSurfaceFormat_profile(handle: QSurfaceFormatH): QSurfaceFormatOpenGLContextProfile; cdecl; external Qt5PasLib name 'QSurfaceFormat_profile';
procedure QSurfaceFormat_setRenderableType(handle: QSurfaceFormatH; atype: QSurfaceFormatRenderableType); cdecl; external Qt5PasLib name 'QSurfaceFormat_setRenderableType';
function QSurfaceFormat_renderableType(handle: QSurfaceFormatH): QSurfaceFormatRenderableType; cdecl; external Qt5PasLib name 'QSurfaceFormat_renderableType';
procedure QSurfaceFormat_setMajorVersion(handle: QSurfaceFormatH; majorVersion: integer); cdecl; external Qt5PasLib name 'QSurfaceFormat_setMajorVersion';
function QSurfaceFormat_majorVersion(handle: QSurfaceFormatH): integer; cdecl; external Qt5PasLib name 'QSurfaceFormat_majorVersion';
procedure QSurfaceFormat_setMinorVersion(handle: QSurfaceFormatH; minorVersion: integer); cdecl; external Qt5PasLib name 'QSurfaceFormat_setMinorVersion';
function QSurfaceFormat_minorVersion(handle: QSurfaceFormatH): integer; cdecl; external Qt5PasLib name 'QSurfaceFormat_minorVersion';
function QSurfaceFormat_stereo(handle: QSurfaceFormatH): boolean; cdecl; external Qt5PasLib name 'QSurfaceFormat_stereo';
procedure QSurfaceFormat_setStereo(handle: QSurfaceFormatH; enable: boolean); cdecl; external Qt5PasLib name 'QSurfaceFormat_setStereo';
procedure QSurfaceFormat_setOptions(handle: QSurfaceFormatH; options: QSurfaceFormatFormatOptions); cdecl; external Qt5PasLib name 'QSurfaceFormat_setOptions';
procedure QSurfaceFormat_setOption(handle: QSurfaceFormatH; option: QSurfaceFormatFormatOption; AOn: boolean = True); cdecl; external Qt5PasLib name 'QSurfaceFormat_setOption';
function QSurfaceFormat_testOption(handle: QSurfaceFormatH; option: QSurfaceFormatFormatOption): boolean; cdecl; external Qt5PasLib name 'QSurfaceFormat_testOption';
function QSurfaceFormat_options(handle: QSurfaceFormatH): QSurfaceFormatFormatOptions; cdecl; external Qt5PasLib name 'QSurfaceFormat_options';
function QSurfaceFormat_swapInterval(handle: QSurfaceFormatH): integer; cdecl; external Qt5PasLib name 'QSurfaceFormat_swapInterval';
procedure QSurfaceFormat_setSwapInterval(handle: QSurfaceFormatH; interval: integer); cdecl; external Qt5PasLib name 'QSurfaceFormat_setSwapInterval';
procedure QSurfaceFormat_setDefaultFormat(format: QSurfaceFormatH); cdecl; external Qt5PasLib name 'QSurfaceFormat_setDefaultFormat';
procedure QSurfaceFormat_defaultFormat(retval: QSurfaceFormatH); cdecl; external Qt5PasLib name 'QSurfaceFormat_defaultFormat';

type
  QWindowVisibility = (QWindowVisibilityHidden,
    QWindowVisibilityAutomaticVisibility, QWindowVisibilityWindowed, QWindowVisibilityMinimized,
    QWindowVisibilityMaximized, QWindowVisibilityFullScreen);

  QWindowAncestorMode = (QWindowAncestorModeExcludeTransients,
    QWindowAncestorModeIncludeTransients);

function QWindow_Create(parent: QWindowH = nil): QWindowH; cdecl; external Qt5PasLib name 'QWindow_Create';
function QWindow_Create(screen: QScreenH = nil): QWindowH; cdecl; external Qt5PasLib name 'QWindow_Create2';
procedure QWindow_Destroy(handle: QWindowH); cdecl; external Qt5PasLib name 'QWindow_Destroy';
procedure QWindow_setSurfaceType(handle: QWindowH; surfaceType: QSurfaceSurfaceType); cdecl; external Qt5PasLib name 'QWindow_setSurfaceType';
function QWindow_surfaceType(handle: QWindowH): QSurfaceSurfaceType; cdecl; external Qt5PasLib name 'QWindow_surfaceType';
function QWindow_isVisible(handle: QWindowH): boolean; cdecl; external Qt5PasLib name 'QWindow_isVisible';
function QWindow_visibility(handle: QWindowH): QWindowVisibility; cdecl; external Qt5PasLib name 'QWindow_visibility';
procedure QWindow_setVisibility(handle: QWindowH; v: QWindowVisibility); cdecl; external Qt5PasLib name 'QWindow_setVisibility';
procedure QWindow_createPlatformResources(handle: QWindowH); cdecl; external Qt5PasLib name 'QWindow_createPlatformResources';
procedure QWindow_destroyPlatformResources(handle: QWindowH); cdecl; external Qt5PasLib name 'QWindow_destroyPlatformResources';
function QWindow_winId(handle: QWindowH): PtrUInt; cdecl; external Qt5PasLib name 'QWindow_winId';
function QWindow_parent(handle: QWindowH): QWindowH; cdecl; external Qt5PasLib name 'QWindow_parent';
procedure QWindow_setParent(handle: QWindowH; parent: QWindowH); cdecl; external Qt5PasLib name 'QWindow_setParent';
function QWindow_isTopLevel(handle: QWindowH): boolean; cdecl; external Qt5PasLib name 'QWindow_isTopLevel';
function QWindow_isModal(handle: QWindowH): boolean; cdecl; external Qt5PasLib name 'QWindow_isModal';
function QWindow_modality(handle: QWindowH): QtWindowModality; cdecl; external Qt5PasLib name 'QWindow_modality';
procedure QWindow_setModality(handle: QWindowH; windowModality: QtWindowModality); cdecl; external Qt5PasLib name 'QWindow_setModality';
procedure QWindow_setFormat(handle: QWindowH; format: QSurfaceFormatH); cdecl; external Qt5PasLib name 'QWindow_setFormat';
procedure QWindow_format(handle: QWindowH; retval: QSurfaceFormatH); cdecl; external Qt5PasLib name 'QWindow_format';
procedure QWindow_requestedFormat(handle: QWindowH; retval: QSurfaceFormatH); cdecl; external Qt5PasLib name 'QWindow_requestedFormat';
procedure QWindow_setFlags(handle: QWindowH; flags: QtWindowFlags); cdecl; external Qt5PasLib name 'QWindow_setFlags';
function QWindow_flags(handle: QWindowH): LongWord; cdecl; external Qt5PasLib name 'QWindow_flags';
function QWindow_type(handle: QWindowH): QtWindowType; cdecl; external Qt5PasLib name 'QWindow_type';
procedure QWindow_title(handle: QWindowH; retval: PWideString); cdecl; external Qt5PasLib name 'QWindow_title';
procedure QWindow_setOpacity(handle: QWindowH; level: qreal); cdecl; external Qt5PasLib name 'QWindow_setOpacity';
function QWindow_opacity(handle: QWindowH): qreal; cdecl; external Qt5PasLib name 'QWindow_opacity';
procedure QWindow_setMask(handle: QWindowH; AnonParam1: QRegionH); cdecl; external Qt5PasLib name 'QWindow_setMask';
procedure QWindow_mask(handle: QWindowH; retval: QRegionH); cdecl; external Qt5PasLib name 'QWindow_mask';
function QWindow_isActive(handle: QWindowH): boolean; cdecl; external Qt5PasLib name 'QWindow_isActive';
procedure QWindow_reportContentOrientationChange(handle: QWindowH; orientation: QtScreenOrientation); cdecl; external Qt5PasLib name 'QWindow_reportContentOrientationChange';
function QWindow_contentOrientation(handle: QWindowH): QtScreenOrientation; cdecl; external Qt5PasLib name 'QWindow_contentOrientation';
function QWindow_devicePixelRatio(handle: QWindowH): qreal; cdecl; external Qt5PasLib name 'QWindow_devicePixelRatio';
function QWindow_windowState(handle: QWindowH): QtWindowState; cdecl; external Qt5PasLib name 'QWindow_windowState';
procedure QWindow_setWindowState(handle: QWindowH; state: QtWindowState); cdecl; external Qt5PasLib name 'QWindow_setWindowState';
procedure QWindow_setTransientParent(handle: QWindowH; parent: QWindowH); cdecl; external Qt5PasLib name 'QWindow_setTransientParent';
function QWindow_transientParent(handle: QWindowH): QWindowH; cdecl; external Qt5PasLib name 'QWindow_transientParent';
function QWindow_isAncestorOf(handle: QWindowH; child: QWindowH; mode: QWindowAncestorMode = QWindowAncestorModeIncludeTransients): boolean; cdecl; external Qt5PasLib name 'QWindow_isAncestorOf';
function QWindow_isExposed(handle: QWindowH): boolean; cdecl; external Qt5PasLib name 'QWindow_isExposed';
function QWindow_minimumWidth(handle: QWindowH): integer; cdecl; external Qt5PasLib name 'QWindow_minimumWidth';
function QWindow_minimumHeight(handle: QWindowH): integer; cdecl; external Qt5PasLib name 'QWindow_minimumHeight';
function QWindow_maximumWidth(handle: QWindowH): integer; cdecl; external Qt5PasLib name 'QWindow_maximumWidth';
function QWindow_maximumHeight(handle: QWindowH): integer; cdecl; external Qt5PasLib name 'QWindow_maximumHeight';
procedure QWindow_minimumSize(handle: QWindowH; retval: PSize); cdecl; external Qt5PasLib name 'QWindow_minimumSize';
procedure QWindow_maximumSize(handle: QWindowH; retval: PSize); cdecl; external Qt5PasLib name 'QWindow_maximumSize';
procedure QWindow_baseSize(handle: QWindowH; retval: PSize); cdecl; external Qt5PasLib name 'QWindow_baseSize';
procedure QWindow_sizeIncrement(handle: QWindowH; retval: PSize); cdecl; external Qt5PasLib name 'QWindow_sizeIncrement';
procedure QWindow_setMinimumSize(handle: QWindowH; AnonParam1: QSizeH); cdecl; external Qt5PasLib name 'QWindow_setMinimumSize';
procedure QWindow_setMaximumSize(handle: QWindowH; AnonParam1: QSizeH); cdecl; external Qt5PasLib name 'QWindow_setMaximumSize';
procedure QWindow_setBaseSize(handle: QWindowH; AnonParam1: QSizeH); cdecl; external Qt5PasLib name 'QWindow_setBaseSize';
procedure QWindow_setSizeIncrement(handle: QWindowH; AnonParam1: QSizeH); cdecl; external Qt5PasLib name 'QWindow_setSizeIncrement';
procedure QWindow_setGeometry(handle: QWindowH; x: integer; y: integer; w: integer; h: integer); cdecl; external Qt5PasLib name 'QWindow_setGeometry';
procedure QWindow_setGeometry(handle: QWindowH; AnonParam1: PRect); cdecl; external Qt5PasLib name 'QWindow_setGeometry2';
procedure QWindow_geometry(handle: QWindowH; retval: PRect); cdecl; external Qt5PasLib name 'QWindow_geometry';
procedure QWindow_frameMargins(handle: QWindowH; retval: QMarginsH); cdecl; external Qt5PasLib name 'QWindow_frameMargins';
procedure QWindow_frameGeometry(handle: QWindowH; retval: PRect); cdecl; external Qt5PasLib name 'QWindow_frameGeometry';
procedure QWindow_framePosition(handle: QWindowH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QWindow_framePosition';
procedure QWindow_setFramePosition(handle: QWindowH; AnonParam1: PQtPoint); cdecl; external Qt5PasLib name 'QWindow_setFramePosition';
function QWindow_width(handle: QWindowH): integer; cdecl; external Qt5PasLib name 'QWindow_width';
function QWindow_height(handle: QWindowH): integer; cdecl; external Qt5PasLib name 'QWindow_height';
function QWindow_x(handle: QWindowH): integer; cdecl; external Qt5PasLib name 'QWindow_x';
function QWindow_y(handle: QWindowH): integer; cdecl; external Qt5PasLib name 'QWindow_y';
procedure QWindow_size(handle: QWindowH; retval: PSize); cdecl; external Qt5PasLib name 'QWindow_size';
procedure QWindow_position(handle: QWindowH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QWindow_position';
procedure QWindow_setPosition(handle: QWindowH; AnonParam1: PQtPoint); cdecl; external Qt5PasLib name 'QWindow_setPosition';
procedure QWindow_setPosition(handle: QWindowH; posx: integer; posy: integer); cdecl; external Qt5PasLib name 'QWindow_setPosition2';
procedure QWindow_resize(handle: QWindowH; AnonParam1: QSizeH); cdecl; external Qt5PasLib name 'QWindow_resize';
procedure QWindow_resize(handle: QWindowH; w: integer; h: integer); cdecl; external Qt5PasLib name 'QWindow_resize2';
procedure QWindow_setFilePath(handle: QWindowH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QWindow_setFilePath';
procedure QWindow_filePath(handle: QWindowH; retval: PWideString); cdecl; external Qt5PasLib name 'QWindow_filePath';
procedure QWindow_setIcon(handle: QWindowH; icon: QIconH); cdecl; external Qt5PasLib name 'QWindow_setIcon';
procedure QWindow_icon(handle: QWindowH; retval: QIconH); cdecl; external Qt5PasLib name 'QWindow_icon';
function QWindow_screen(handle: QWindowH): QScreenH; cdecl; external Qt5PasLib name 'QWindow_screen';
procedure QWindow_setScreen(handle: QWindowH; screen: QScreenH); cdecl; external Qt5PasLib name 'QWindow_setScreen';
function QWindow_setKeyboardGrabEnabled(handle: QWindowH; grab: boolean): boolean; cdecl; external Qt5PasLib name 'QWindow_setKeyboardGrabEnabled';
function QWindow_setMouseGrabEnabled(handle: QWindowH; grab: boolean): boolean; cdecl; external Qt5PasLib name 'QWindow_setMouseGrabEnabled';
procedure QWindow_mapToGlobal(handle: QWindowH; retval: PQtPoint; AnonParam1: PQtPoint); cdecl; external Qt5PasLib name 'QWindow_mapToGlobal';
procedure QWindow_mapFromGlobal(handle: QWindowH; retval: PQtPoint; AnonParam1: PQtPoint); cdecl; external Qt5PasLib name 'QWindow_mapFromGlobal';
procedure QWindow_cursor(handle: QWindowH; retval: QCursorH); cdecl; external Qt5PasLib name 'QWindow_cursor';
procedure QWindow_setCursor(handle: QWindowH; AnonParam1: QCursorH); cdecl; external Qt5PasLib name 'QWindow_setCursor';
procedure QWindow_unsetCursor(handle: QWindowH); cdecl; external Qt5PasLib name 'QWindow_unsetCursor';
function QWindow_focusObject(handle: QWindowH): QObjectH; cdecl; external Qt5PasLib name 'QWindow_focusObject';
function QWindow_fromWinID(id: PtrUInt): QWindowH; cdecl; external Qt5PasLib name 'QWindow_fromWinID';
procedure QWindow_requestActivate(handle: QWindowH); cdecl; external Qt5PasLib name 'QWindow_requestActivate';
procedure QWindow_setVisible(handle: QWindowH; visible: boolean); cdecl; external Qt5PasLib name 'QWindow_setVisible';
procedure QWindow_show(handle: QWindowH); cdecl; external Qt5PasLib name 'QWindow_show';
procedure QWindow_hide(handle: QWindowH); cdecl; external Qt5PasLib name 'QWindow_hide';
procedure QWindow_showMinimized(handle: QWindowH); cdecl; external Qt5PasLib name 'QWindow_showMinimized';
procedure QWindow_showMaximized(handle: QWindowH); cdecl; external Qt5PasLib name 'QWindow_showMaximized';
procedure QWindow_showFullScreen(handle: QWindowH); cdecl; external Qt5PasLib name 'QWindow_showFullScreen';
procedure QWindow_showNormal(handle: QWindowH); cdecl; external Qt5PasLib name 'QWindow_showNormal';
function QWindow_close(handle: QWindowH): boolean; cdecl; external Qt5PasLib name 'QWindow_close';
procedure QWindow_raise(handle: QWindowH); cdecl; external Qt5PasLib name 'QWindow_raise';
procedure QWindow_lower(handle: QWindowH); cdecl; external Qt5PasLib name 'QWindow_lower';
procedure QWindow_setTitle(handle: QWindowH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QWindow_setTitle';
procedure QWindow_setX(handle: QWindowH; x: integer); cdecl; external Qt5PasLib name 'QWindow_setX';
procedure QWindow_setY(handle: QWindowH; y: integer); cdecl; external Qt5PasLib name 'QWindow_setY';
procedure QWindow_setWidth(handle: QWindowH; w: integer); cdecl; external Qt5PasLib name 'QWindow_setWidth';
procedure QWindow_setHeight(handle: QWindowH; h: integer); cdecl; external Qt5PasLib name 'QWindow_setHeight';
procedure QWindow_setMinimumWidth(handle: QWindowH; w: integer); cdecl; external Qt5PasLib name 'QWindow_setMinimumWidth';
procedure QWindow_setMinimumHeight(handle: QWindowH; h: integer); cdecl; external Qt5PasLib name 'QWindow_setMinimumHeight';
procedure QWindow_setMaximumWidth(handle: QWindowH; w: integer); cdecl; external Qt5PasLib name 'QWindow_setMaximumWidth';
procedure QWindow_setMaximumHeight(handle: QWindowH; h: integer); cdecl; external Qt5PasLib name 'QWindow_setMaximumHeight';
procedure QWindow_alert(handle: QWindowH; msec: integer); cdecl; external Qt5PasLib name 'QWindow_alert';
procedure QWindow_requestUpdate(handle: QWindowH); cdecl; external Qt5PasLib name 'QWindow_requestUpdate';

type
  QWindow_screenChanged_Event = procedure (screen: QScreenH) of object cdecl;
  QWindow_modalityChanged_Event = procedure (modality: QtWindowModality) of object cdecl;
  QWindow_windowStateChanged_Event = procedure (windowstate: QtWindowState) of object cdecl;
  QWindow_windowTitleChanged_Event = procedure (AnonParam1: PWideString) of object cdecl;
  QWindow_xChanged_Event = procedure (x: integer) of object cdecl;
  QWindow_yChanged_Event = procedure (y: integer) of object cdecl;
  QWindow_widthChanged_Event = procedure (w: integer) of object cdecl;
  QWindow_heightChanged_Event = procedure (h: integer) of object cdecl;
  QWindow_minimumWidthChanged_Event = procedure (mw: integer) of object cdecl;
  QWindow_minimumHeightChanged_Event = procedure (mh: integer) of object cdecl;
  QWindow_maximumWidthChanged_Event = procedure (mw: integer) of object cdecl;
  QWindow_maximumHeightChanged_Event = procedure (mh: integer) of object cdecl;
  QWindow_visibleChanged_Event = procedure (vis: boolean) of object cdecl;
  QWindow_visibilityChanged_Event = procedure (vis: QWindowVisibility) of object cdecl;
  QWindow_activeChanged_event = procedure() of object cdecl;
  QWindow_contentOrientationChanged_event = procedure(orientation: QtOrientation) of object cdecl;
  QWindow_focusObjectChanged_event = procedure(AObj: QObjectH) of object cdecl;
  QWindow_opacityChanged_event = procedure(opacity: qreal) of object cdecl;


type
  QWidgetRenderFlag = cardinal; // QWidget::RenderFlag
  QWidgetRenderFlags = QWidgetRenderFlag; //QFlags<> (3)
const
  QWidgetDrawWindowBackground =   $1;
  QWidgetDrawChildren =   $2;
  QWidgetIgnoreMask =   $4;


function QWidget_Create(parent: QWidgetH = nil; f: QtWindowFlags = 0): QWidgetH; cdecl; external Qt5PasLib name 'QWidget_Create';
procedure QWidget_Destroy(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_Destroy'; 
function QWidget_devType(handle: QWidgetH): Integer; cdecl; external Qt5PasLib name 'QWidget_devType';
function QWidget_winId(handle: QWidgetH): PtrUInt; cdecl; external Qt5PasLib name 'QWidget_winId';
procedure QWidget_createWinId(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_createWinId';
function QWidget_internalWinId(handle: QWidgetH): PtrUInt; cdecl; external Qt5PasLib name 'QWidget_internalWinId';
function QWidget_effectiveWinId(handle: QWidgetH): PtrUInt; cdecl; external Qt5PasLib name 'QWidget_effectiveWinId';
function QWidget_style(handle: QWidgetH): QStyleH; cdecl; external Qt5PasLib name 'QWidget_style';
procedure QWidget_setStyle(handle: QWidgetH; AnonParam1: QStyleH); cdecl; external Qt5PasLib name 'QWidget_setStyle';
function QWidget_isTopLevel(handle: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_isTopLevel';
function QWidget_isWindow(handle: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_isWindow';
function QWidget_isModal(handle: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_isModal';
function QWidget_windowModality(handle: QWidgetH): QtWindowModality; cdecl; external Qt5PasLib name 'QWidget_windowModality';
procedure QWidget_setWindowModality(handle: QWidgetH; windowModality: QtWindowModality); cdecl; external Qt5PasLib name 'QWidget_setWindowModality';
function QWidget_isEnabled(handle: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_isEnabled';
function QWidget_isEnabledTo(handle: QWidgetH; AnonParam1: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_isEnabledTo';
function QWidget_isEnabledToTLW(handle: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_isEnabledToTLW';
procedure QWidget_setEnabled(handle: QWidgetH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QWidget_setEnabled';
procedure QWidget_setDisabled(handle: QWidgetH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QWidget_setDisabled';
procedure QWidget_setWindowModified(handle: QWidgetH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QWidget_setWindowModified';
procedure QWidget_frameGeometry(handle: QWidgetH; retval: PRect); cdecl; external Qt5PasLib name 'QWidget_frameGeometry';
procedure QWidget_geometry(handle: QWidgetH; retval: PRect); cdecl; external Qt5PasLib name 'QWidget_geometry';
procedure QWidget_normalGeometry(handle: QWidgetH; retval: PRect); cdecl; external Qt5PasLib name 'QWidget_normalGeometry';
function QWidget_x(handle: QWidgetH): Integer; cdecl; external Qt5PasLib name 'QWidget_x';
function QWidget_y(handle: QWidgetH): Integer; cdecl; external Qt5PasLib name 'QWidget_y';
procedure QWidget_pos(handle: QWidgetH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QWidget_pos';
procedure QWidget_frameSize(handle: QWidgetH; retval: PSize); cdecl; external Qt5PasLib name 'QWidget_frameSize';
procedure QWidget_size(handle: QWidgetH; retval: PSize); cdecl; external Qt5PasLib name 'QWidget_size';
function QWidget_width(handle: QWidgetH): Integer; cdecl; external Qt5PasLib name 'QWidget_width';
function QWidget_height(handle: QWidgetH): Integer; cdecl; external Qt5PasLib name 'QWidget_height';
procedure QWidget_rect(handle: QWidgetH; retval: PRect); cdecl; external Qt5PasLib name 'QWidget_rect';
procedure QWidget_childrenRect(handle: QWidgetH; retval: PRect); cdecl; external Qt5PasLib name 'QWidget_childrenRect';
procedure QWidget_childrenRegion(handle: QWidgetH; retval: QRegionH); cdecl; external Qt5PasLib name 'QWidget_childrenRegion';
procedure QWidget_minimumSize(handle: QWidgetH; retval: PSize); cdecl; external Qt5PasLib name 'QWidget_minimumSize';
procedure QWidget_maximumSize(handle: QWidgetH; retval: PSize); cdecl; external Qt5PasLib name 'QWidget_maximumSize';
function QWidget_minimumWidth(handle: QWidgetH): Integer; cdecl; external Qt5PasLib name 'QWidget_minimumWidth';
function QWidget_minimumHeight(handle: QWidgetH): Integer; cdecl; external Qt5PasLib name 'QWidget_minimumHeight';
function QWidget_maximumWidth(handle: QWidgetH): Integer; cdecl; external Qt5PasLib name 'QWidget_maximumWidth';
function QWidget_maximumHeight(handle: QWidgetH): Integer; cdecl; external Qt5PasLib name 'QWidget_maximumHeight';
procedure QWidget_setMinimumSize(handle: QWidgetH; AnonParam1: PSize); cdecl; external Qt5PasLib name 'QWidget_setMinimumSize';
procedure QWidget_setMinimumSize(handle: QWidgetH; minw: Integer; minh: Integer); cdecl; external Qt5PasLib name 'QWidget_setMinimumSize2';
procedure QWidget_setMaximumSize(handle: QWidgetH; AnonParam1: PSize); cdecl; external Qt5PasLib name 'QWidget_setMaximumSize';
procedure QWidget_setMaximumSize(handle: QWidgetH; maxw: Integer; maxh: Integer); cdecl; external Qt5PasLib name 'QWidget_setMaximumSize2';
procedure QWidget_setMinimumWidth(handle: QWidgetH; minw: Integer); cdecl; external Qt5PasLib name 'QWidget_setMinimumWidth';
procedure QWidget_setMinimumHeight(handle: QWidgetH; minh: Integer); cdecl; external Qt5PasLib name 'QWidget_setMinimumHeight';
procedure QWidget_setMaximumWidth(handle: QWidgetH; maxw: Integer); cdecl; external Qt5PasLib name 'QWidget_setMaximumWidth';
procedure QWidget_setMaximumHeight(handle: QWidgetH; maxh: Integer); cdecl; external Qt5PasLib name 'QWidget_setMaximumHeight';
procedure QWidget_sizeIncrement(handle: QWidgetH; retval: PSize); cdecl; external Qt5PasLib name 'QWidget_sizeIncrement';
procedure QWidget_setSizeIncrement(handle: QWidgetH; AnonParam1: PSize); cdecl; external Qt5PasLib name 'QWidget_setSizeIncrement';
procedure QWidget_setSizeIncrement(handle: QWidgetH; w: Integer; h: Integer); cdecl; external Qt5PasLib name 'QWidget_setSizeIncrement2';
procedure QWidget_baseSize(handle: QWidgetH; retval: PSize); cdecl; external Qt5PasLib name 'QWidget_baseSize';
procedure QWidget_setBaseSize(handle: QWidgetH; AnonParam1: PSize); cdecl; external Qt5PasLib name 'QWidget_setBaseSize';
procedure QWidget_setBaseSize(handle: QWidgetH; basew: Integer; baseh: Integer); cdecl; external Qt5PasLib name 'QWidget_setBaseSize2';
procedure QWidget_setFixedSize(handle: QWidgetH; AnonParam1: PSize); cdecl; external Qt5PasLib name 'QWidget_setFixedSize';
procedure QWidget_setFixedSize(handle: QWidgetH; w: Integer; h: Integer); cdecl; external Qt5PasLib name 'QWidget_setFixedSize2';
procedure QWidget_setFixedWidth(handle: QWidgetH; w: Integer); cdecl; external Qt5PasLib name 'QWidget_setFixedWidth';
procedure QWidget_setFixedHeight(handle: QWidgetH; h: Integer); cdecl; external Qt5PasLib name 'QWidget_setFixedHeight';
procedure QWidget_mapToGlobal(handle: QWidgetH; retval: PQtPoint; AnonParam1: PQtPoint); cdecl; external Qt5PasLib name 'QWidget_mapToGlobal';
procedure QWidget_mapFromGlobal(handle: QWidgetH; retval: PQtPoint; AnonParam1: PQtPoint); cdecl; external Qt5PasLib name 'QWidget_mapFromGlobal';
procedure QWidget_mapToParent(handle: QWidgetH; retval: PQtPoint; AnonParam1: PQtPoint); cdecl; external Qt5PasLib name 'QWidget_mapToParent';
procedure QWidget_mapFromParent(handle: QWidgetH; retval: PQtPoint; AnonParam1: PQtPoint); cdecl; external Qt5PasLib name 'QWidget_mapFromParent';
procedure QWidget_mapTo(handle: QWidgetH; retval: PQtPoint; AnonParam1: QWidgetH; AnonParam2: PQtPoint); cdecl; external Qt5PasLib name 'QWidget_mapTo';
procedure QWidget_mapFrom(handle: QWidgetH; retval: PQtPoint; AnonParam1: QWidgetH; AnonParam2: PQtPoint); cdecl; external Qt5PasLib name 'QWidget_mapFrom';
function QWidget_window(handle: QWidgetH): QWidgetH; cdecl; external Qt5PasLib name 'QWidget_window';
function QWidget_nativeParentWidget(handle: QWidgetH): QWidgetH; cdecl; external Qt5PasLib name 'QWidget_nativeParentWidget';
function QWidget_topLevelWidget(handle: QWidgetH): QWidgetH; cdecl; external Qt5PasLib name 'QWidget_topLevelWidget';
function QWidget_palette(handle: QWidgetH): QPaletteH; cdecl; external Qt5PasLib name 'QWidget_palette';
procedure QWidget_setPalette(handle: QWidgetH; AnonParam1: QPaletteH); cdecl; external Qt5PasLib name 'QWidget_setPalette';
procedure QWidget_setBackgroundRole(handle: QWidgetH; AnonParam1: QPaletteColorRole); cdecl; external Qt5PasLib name 'QWidget_setBackgroundRole';
function QWidget_backgroundRole(handle: QWidgetH): QPaletteColorRole; cdecl; external Qt5PasLib name 'QWidget_backgroundRole';
procedure QWidget_setForegroundRole(handle: QWidgetH; AnonParam1: QPaletteColorRole); cdecl; external Qt5PasLib name 'QWidget_setForegroundRole';
function QWidget_foregroundRole(handle: QWidgetH): QPaletteColorRole; cdecl; external Qt5PasLib name 'QWidget_foregroundRole';
function QWidget_font(handle: QWidgetH): QFontH; cdecl; external Qt5PasLib name 'QWidget_font';
procedure QWidget_setFont(handle: QWidgetH; AnonParam1: QFontH); cdecl; external Qt5PasLib name 'QWidget_setFont';
procedure QWidget_fontMetrics(handle: QWidgetH; retval: QFontMetricsH); cdecl; external Qt5PasLib name 'QWidget_fontMetrics';
procedure QWidget_fontInfo(handle: QWidgetH; retval: QFontInfoH); cdecl; external Qt5PasLib name 'QWidget_fontInfo';
procedure QWidget_cursor(handle: QWidgetH; retval: QCursorH); cdecl; external Qt5PasLib name 'QWidget_cursor';
procedure QWidget_setCursor(handle: QWidgetH; AnonParam1: QCursorH); cdecl; external Qt5PasLib name 'QWidget_setCursor';
procedure QWidget_unsetCursor(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_unsetCursor';
procedure QWidget_setMouseTracking(handle: QWidgetH; enable: Boolean); cdecl; external Qt5PasLib name 'QWidget_setMouseTracking';
function QWidget_hasMouseTracking(handle: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_hasMouseTracking';
function QWidget_underMouse(handle: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_underMouse';
procedure QWidget_setMask(handle: QWidgetH; AnonParam1: QBitmapH); cdecl; external Qt5PasLib name 'QWidget_setMask';
procedure QWidget_setMask(handle: QWidgetH; AnonParam1: QRegionH); cdecl; external Qt5PasLib name 'QWidget_setMask2';
procedure QWidget_mask(handle: QWidgetH; retval: QRegionH); cdecl; external Qt5PasLib name 'QWidget_mask';
procedure QWidget_clearMask(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_clearMask';
procedure QWidget_render(handle: QWidgetH; target: QPaintDeviceH; targetOffset: PQtPoint; sourceRegion: QRegionH; renderFlags: QWidgetRenderFlags); cdecl; external Qt5PasLib name 'QWidget_render';
procedure QWidget_render(handle: QWidgetH; painter: QPainterH; targetOffset: PQtPoint; sourceRegion: QRegionH; renderFlags: QWidgetRenderFlags); cdecl; external Qt5PasLib name 'QWidget_render2';
procedure QWidget_grab(handle: QWidgetH; retval: QPixmapH; rectangle: PRect); cdecl; external Qt5PasLib name 'QWidget_grab';
function QWidget_graphicsEffect(handle: QWidgetH): QGraphicsEffectH; cdecl; external Qt5PasLib name 'QWidget_graphicsEffect';
procedure QWidget_setGraphicsEffect(handle: QWidgetH; effect: QGraphicsEffectH); cdecl; external Qt5PasLib name 'QWidget_setGraphicsEffect';
procedure QWidget_grabGesture(handle: QWidgetH; _type: QtGestureType; flags: QtGestureFlags); cdecl; external Qt5PasLib name 'QWidget_grabGesture';
procedure QWidget_ungrabGesture(handle: QWidgetH; _type: QtGestureType); cdecl; external Qt5PasLib name 'QWidget_ungrabGesture';
procedure QWidget_setWindowTitle(handle: QWidgetH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QWidget_setWindowTitle';
procedure QWidget_setStyleSheet(handle: QWidgetH; styleSheet: PWideString); cdecl; external Qt5PasLib name 'QWidget_setStyleSheet';
procedure QWidget_styleSheet(handle: QWidgetH; retval: PWideString); cdecl; external Qt5PasLib name 'QWidget_styleSheet';
procedure QWidget_windowTitle(handle: QWidgetH; retval: PWideString); cdecl; external Qt5PasLib name 'QWidget_windowTitle';
procedure QWidget_setWindowIcon(handle: QWidgetH; icon: QIconH); cdecl; external Qt5PasLib name 'QWidget_setWindowIcon';
procedure QWidget_windowIcon(handle: QWidgetH; retval: QIconH); cdecl; external Qt5PasLib name 'QWidget_windowIcon';
procedure QWidget_setWindowIconText(handle: QWidgetH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QWidget_setWindowIconText';
procedure QWidget_windowIconText(handle: QWidgetH; retval: PWideString); cdecl; external Qt5PasLib name 'QWidget_windowIconText';
procedure QWidget_setWindowRole(handle: QWidgetH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QWidget_setWindowRole';
procedure QWidget_windowRole(handle: QWidgetH; retval: PWideString); cdecl; external Qt5PasLib name 'QWidget_windowRole';
procedure QWidget_setWindowFilePath(handle: QWidgetH; filePath: PWideString); cdecl; external Qt5PasLib name 'QWidget_setWindowFilePath';
procedure QWidget_windowFilePath(handle: QWidgetH; retval: PWideString); cdecl; external Qt5PasLib name 'QWidget_windowFilePath';
procedure QWidget_setWindowOpacity(handle: QWidgetH; level: qreal); cdecl; external Qt5PasLib name 'QWidget_setWindowOpacity';
function QWidget_windowOpacity(handle: QWidgetH): qreal; cdecl; external Qt5PasLib name 'QWidget_windowOpacity';
function QWidget_isWindowModified(handle: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_isWindowModified';
procedure QWidget_setToolTip(handle: QWidgetH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QWidget_setToolTip';
procedure QWidget_toolTip(handle: QWidgetH; retval: PWideString); cdecl; external Qt5PasLib name 'QWidget_toolTip';
procedure QWidget_setStatusTip(handle: QWidgetH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QWidget_setStatusTip';
procedure QWidget_statusTip(handle: QWidgetH; retval: PWideString); cdecl; external Qt5PasLib name 'QWidget_statusTip';
procedure QWidget_setWhatsThis(handle: QWidgetH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QWidget_setWhatsThis';
procedure QWidget_whatsThis(handle: QWidgetH; retval: PWideString); cdecl; external Qt5PasLib name 'QWidget_whatsThis';
procedure QWidget_accessibleName(handle: QWidgetH; retval: PWideString); cdecl; external Qt5PasLib name 'QWidget_accessibleName';
procedure QWidget_setAccessibleName(handle: QWidgetH; name: PWideString); cdecl; external Qt5PasLib name 'QWidget_setAccessibleName';
procedure QWidget_accessibleDescription(handle: QWidgetH; retval: PWideString); cdecl; external Qt5PasLib name 'QWidget_accessibleDescription';
procedure QWidget_setAccessibleDescription(handle: QWidgetH; description: PWideString); cdecl; external Qt5PasLib name 'QWidget_setAccessibleDescription';
procedure QWidget_setLayoutDirection(handle: QWidgetH; direction: QtLayoutDirection); cdecl; external Qt5PasLib name 'QWidget_setLayoutDirection';
function QWidget_layoutDirection(handle: QWidgetH): QtLayoutDirection; cdecl; external Qt5PasLib name 'QWidget_layoutDirection';
procedure QWidget_unsetLayoutDirection(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_unsetLayoutDirection';
procedure QWidget_setLocale(handle: QWidgetH; locale: QLocaleH); cdecl; external Qt5PasLib name 'QWidget_setLocale';
procedure QWidget_locale(handle: QWidgetH; retval: QLocaleH); cdecl; external Qt5PasLib name 'QWidget_locale';
procedure QWidget_unsetLocale(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_unsetLocale';
function QWidget_isRightToLeft(handle: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_isRightToLeft';
function QWidget_isLeftToRight(handle: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_isLeftToRight';
procedure QWidget_setFocus(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_setFocus';
function QWidget_isActiveWindow(handle: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_isActiveWindow';
procedure QWidget_activateWindow(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_activateWindow';
procedure QWidget_clearFocus(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_clearFocus';
procedure QWidget_setFocus(handle: QWidgetH; reason: QtFocusReason); cdecl; external Qt5PasLib name 'QWidget_setFocus2';
function QWidget_focusPolicy(handle: QWidgetH): QtFocusPolicy; cdecl; external Qt5PasLib name 'QWidget_focusPolicy';
procedure QWidget_setFocusPolicy(handle: QWidgetH; policy: QtFocusPolicy); cdecl; external Qt5PasLib name 'QWidget_setFocusPolicy';
function QWidget_hasFocus(handle: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_hasFocus';
procedure QWidget_setTabOrder(AnonParam1: QWidgetH; AnonParam2: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_setTabOrder';
procedure QWidget_setFocusProxy(handle: QWidgetH; AnonParam1: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_setFocusProxy';
function QWidget_focusProxy(handle: QWidgetH): QWidgetH; cdecl; external Qt5PasLib name 'QWidget_focusProxy';
function QWidget_contextMenuPolicy(handle: QWidgetH): QtContextMenuPolicy; cdecl; external Qt5PasLib name 'QWidget_contextMenuPolicy';
procedure QWidget_setContextMenuPolicy(handle: QWidgetH; policy: QtContextMenuPolicy); cdecl; external Qt5PasLib name 'QWidget_setContextMenuPolicy';
procedure QWidget_grabMouse(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_grabMouse';
procedure QWidget_grabMouse(handle: QWidgetH; AnonParam1: QCursorH); cdecl; external Qt5PasLib name 'QWidget_grabMouse2';
procedure QWidget_releaseMouse(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_releaseMouse';
procedure QWidget_grabKeyboard(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_grabKeyboard';
procedure QWidget_releaseKeyboard(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_releaseKeyboard';
function QWidget_grabShortcut(handle: QWidgetH; key: QKeySequenceH; context: QtShortcutContext = QtWindowShortcut): Integer; cdecl; external Qt5PasLib name 'QWidget_grabShortcut';
procedure QWidget_releaseShortcut(handle: QWidgetH; id: Integer); cdecl; external Qt5PasLib name 'QWidget_releaseShortcut';
procedure QWidget_setShortcutEnabled(handle: QWidgetH; id: Integer; enable: Boolean = True); cdecl; external Qt5PasLib name 'QWidget_setShortcutEnabled';
procedure QWidget_setShortcutAutoRepeat(handle: QWidgetH; id: Integer; enable: Boolean = True); cdecl; external Qt5PasLib name 'QWidget_setShortcutAutoRepeat';
function QWidget_mouseGrabber(): QWidgetH; cdecl; external Qt5PasLib name 'QWidget_mouseGrabber';
function QWidget_keyboardGrabber(): QWidgetH; cdecl; external Qt5PasLib name 'QWidget_keyboardGrabber';
function QWidget_updatesEnabled(handle: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_updatesEnabled';
procedure QWidget_setUpdatesEnabled(handle: QWidgetH; enable: Boolean); cdecl; external Qt5PasLib name 'QWidget_setUpdatesEnabled';
function QWidget_graphicsProxyWidget(handle: QWidgetH): QGraphicsProxyWidgetH; cdecl; external Qt5PasLib name 'QWidget_graphicsProxyWidget';
procedure QWidget_update(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_update';
procedure QWidget_repaint(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_repaint';
procedure QWidget_update(handle: QWidgetH; x: Integer; y: Integer; w: Integer; h: Integer); cdecl; external Qt5PasLib name 'QWidget_update2';
procedure QWidget_update(handle: QWidgetH; AnonParam1: PRect); cdecl; external Qt5PasLib name 'QWidget_update3';
procedure QWidget_update(handle: QWidgetH; AnonParam1: QRegionH); cdecl; external Qt5PasLib name 'QWidget_update4';
procedure QWidget_repaint(handle: QWidgetH; x: Integer; y: Integer; w: Integer; h: Integer); cdecl; external Qt5PasLib name 'QWidget_repaint2';
procedure QWidget_repaint(handle: QWidgetH; AnonParam1: PRect); cdecl; external Qt5PasLib name 'QWidget_repaint3';
procedure QWidget_repaint(handle: QWidgetH; AnonParam1: QRegionH); cdecl; external Qt5PasLib name 'QWidget_repaint4';
procedure QWidget_setVisible(handle: QWidgetH; visible: Boolean); cdecl; external Qt5PasLib name 'QWidget_setVisible';
procedure QWidget_setHidden(handle: QWidgetH; hidden: Boolean); cdecl; external Qt5PasLib name 'QWidget_setHidden';
procedure QWidget_show(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_show';
procedure QWidget_hide(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_hide';
procedure QWidget_showMinimized(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_showMinimized';
procedure QWidget_showMaximized(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_showMaximized';
procedure QWidget_showFullScreen(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_showFullScreen';
procedure QWidget_showNormal(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_showNormal';
function QWidget_close(handle: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_close';
procedure QWidget_raise(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_raise';
procedure QWidget_lower(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_lower';
procedure QWidget_stackUnder(handle: QWidgetH; AnonParam1: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_stackUnder';
procedure QWidget_move(handle: QWidgetH; x: Integer; y: Integer); cdecl; external Qt5PasLib name 'QWidget_move';
procedure QWidget_move(handle: QWidgetH; AnonParam1: PQtPoint); cdecl; external Qt5PasLib name 'QWidget_move2';
procedure QWidget_resize(handle: QWidgetH; w: Integer; h: Integer); cdecl; external Qt5PasLib name 'QWidget_resize';
procedure QWidget_resize(handle: QWidgetH; AnonParam1: PSize); cdecl; external Qt5PasLib name 'QWidget_resize2';
procedure QWidget_setGeometry(handle: QWidgetH; x: Integer; y: Integer; w: Integer; h: Integer); cdecl; external Qt5PasLib name 'QWidget_setGeometry';
procedure QWidget_setGeometry(handle: QWidgetH; AnonParam1: PRect); cdecl; external Qt5PasLib name 'QWidget_setGeometry2';
procedure QWidget_saveGeometry(handle: QWidgetH; retval: QByteArrayH); cdecl; external Qt5PasLib name 'QWidget_saveGeometry';
function QWidget_restoreGeometry(handle: QWidgetH; geometry: QByteArrayH): Boolean; cdecl; external Qt5PasLib name 'QWidget_restoreGeometry';
procedure QWidget_adjustSize(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_adjustSize';
function QWidget_isVisible(handle: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_isVisible';
function QWidget_isVisibleTo(handle: QWidgetH; AnonParam1: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_isVisibleTo';
function QWidget_isHidden(handle: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_isHidden';
function QWidget_isMinimized(handle: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_isMinimized';
function QWidget_isMaximized(handle: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_isMaximized';
function QWidget_isFullScreen(handle: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_isFullScreen';
function QWidget_windowState(handle: QWidgetH): QtWindowStates; cdecl; external Qt5PasLib name 'QWidget_windowState';
procedure QWidget_setWindowState(handle: QWidgetH; state: QtWindowStates); cdecl; external Qt5PasLib name 'QWidget_setWindowState';
procedure QWidget_overrideWindowState(handle: QWidgetH; state: QtWindowStates); cdecl; external Qt5PasLib name 'QWidget_overrideWindowState';
procedure QWidget_sizeHint(handle: QWidgetH; retval: PSize); cdecl; external Qt5PasLib name 'QWidget_sizeHint';
procedure QWidget_minimumSizeHint(handle: QWidgetH; retval: PSize); cdecl; external Qt5PasLib name 'QWidget_minimumSizeHint';
procedure QWidget_sizePolicy(handle: QWidgetH; retval: PQSizePolicy); cdecl; external Qt5PasLib name 'QWidget_sizePolicy';
procedure QWidget_setSizePolicy(handle: QWidgetH; AnonParam1: PQSizePolicy); cdecl; external Qt5PasLib name 'QWidget_setSizePolicy';
procedure QWidget_setSizePolicy(handle: QWidgetH; horizontal: QSizePolicyPolicy; vertical: QSizePolicyPolicy); cdecl; external Qt5PasLib name 'QWidget_setSizePolicy2';
function QWidget_heightForWidth(handle: QWidgetH; AnonParam1: Integer): Integer; cdecl; external Qt5PasLib name 'QWidget_heightForWidth';
function QWidget_hasHeightForWidth(handle: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_hasHeightForWidth';
procedure QWidget_visibleRegion(handle: QWidgetH; retval: QRegionH); cdecl; external Qt5PasLib name 'QWidget_visibleRegion';
procedure QWidget_setContentsMargins(handle: QWidgetH; left: Integer; top: Integer; right: Integer; bottom: Integer); cdecl; external Qt5PasLib name 'QWidget_setContentsMargins';
procedure QWidget_setContentsMargins(handle: QWidgetH; margins: QMarginsH); cdecl; external Qt5PasLib name 'QWidget_setContentsMargins2';
procedure QWidget_getContentsMargins(handle: QWidgetH; left: PInteger; top: PInteger; right: PInteger; bottom: PInteger); cdecl; external Qt5PasLib name 'QWidget_getContentsMargins';
procedure QWidget_contentsMargins(handle: QWidgetH; retval: QMarginsH); cdecl; external Qt5PasLib name 'QWidget_contentsMargins';
procedure QWidget_contentsRect(handle: QWidgetH; retval: PRect); cdecl; external Qt5PasLib name 'QWidget_contentsRect';
function QWidget_layout(handle: QWidgetH): QLayoutH; cdecl; external Qt5PasLib name 'QWidget_layout';
procedure QWidget_setLayout(handle: QWidgetH; AnonParam1: QLayoutH); cdecl; external Qt5PasLib name 'QWidget_setLayout';
procedure QWidget_updateGeometry(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_updateGeometry';
procedure QWidget_setParent(handle: QWidgetH; parent: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_setParent';
procedure QWidget_setParent(handle: QWidgetH; parent: QWidgetH; f: QtWindowFlags); cdecl; external Qt5PasLib name 'QWidget_setParent2';
procedure QWidget_scroll(handle: QWidgetH; dx: Integer; dy: Integer); cdecl; external Qt5PasLib name 'QWidget_scroll';
procedure QWidget_scroll(handle: QWidgetH; dx: Integer; dy: Integer; AnonParam3: PRect); cdecl; external Qt5PasLib name 'QWidget_scroll2';
function QWidget_focusWidget(handle: QWidgetH): QWidgetH; cdecl; external Qt5PasLib name 'QWidget_focusWidget';
function QWidget_nextInFocusChain(handle: QWidgetH): QWidgetH; cdecl; external Qt5PasLib name 'QWidget_nextInFocusChain';
function QWidget_previousInFocusChain(handle: QWidgetH): QWidgetH; cdecl; external Qt5PasLib name 'QWidget_previousInFocusChain';
function QWidget_acceptDrops(handle: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_acceptDrops';
procedure QWidget_setAcceptDrops(handle: QWidgetH; _on: Boolean); cdecl; external Qt5PasLib name 'QWidget_setAcceptDrops';
procedure QWidget_addAction(handle: QWidgetH; action: QActionH); cdecl; external Qt5PasLib name 'QWidget_addAction';
procedure QWidget_addActions(handle: QWidgetH; actions: PPtrIntArray); cdecl; external Qt5PasLib name 'QWidget_addActions';
procedure QWidget_insertAction(handle: QWidgetH; before: QActionH; action: QActionH); cdecl; external Qt5PasLib name 'QWidget_insertAction';
procedure QWidget_insertActions(handle: QWidgetH; before: QActionH; actions: PPtrIntArray); cdecl; external Qt5PasLib name 'QWidget_insertActions';
procedure QWidget_removeAction(handle: QWidgetH; action: QActionH); cdecl; external Qt5PasLib name 'QWidget_removeAction';
procedure QWidget_actions(handle: QWidgetH; retval: PPtrIntArray); cdecl; external Qt5PasLib name 'QWidget_actions';
function QWidget_parentWidget(handle: QWidgetH): QWidgetH; cdecl; external Qt5PasLib name 'QWidget_parentWidget';
procedure QWidget_setWindowFlags(handle: QWidgetH; _type: QtWindowFlags); cdecl; external Qt5PasLib name 'QWidget_setWindowFlags';
function QWidget_windowFlags(handle: QWidgetH): QtWindowFlags; cdecl; external Qt5PasLib name 'QWidget_windowFlags';
procedure QWidget_overrideWindowFlags(handle: QWidgetH; _type: QtWindowFlags); cdecl; external Qt5PasLib name 'QWidget_overrideWindowFlags';
function QWidget_windowType(handle: QWidgetH): QtWindowType; cdecl; external Qt5PasLib name 'QWidget_windowType';
function QWidget_find(AnonParam1: PtrUInt): QWidgetH; cdecl; external Qt5PasLib name 'QWidget_find';
function QWidget_childAt(handle: QWidgetH; x: Integer; y: Integer): QWidgetH; cdecl; external Qt5PasLib name 'QWidget_childAt';
function QWidget_childAt(handle: QWidgetH; p: PQtPoint): QWidgetH; cdecl; external Qt5PasLib name 'QWidget_childAt2';
procedure QWidget_setAttribute(handle: QWidgetH; AnonParam1: QtWidgetAttribute; _on: Boolean = True); cdecl; external Qt5PasLib name 'QWidget_setAttribute';
function QWidget_testAttribute(handle: QWidgetH; AnonParam1: QtWidgetAttribute): Boolean; cdecl; external Qt5PasLib name 'QWidget_testAttribute';
function QWidget_paintEngine(handle: QWidgetH): QPaintEngineH; cdecl; external Qt5PasLib name 'QWidget_paintEngine';
procedure QWidget_ensurePolished(handle: QWidgetH); cdecl; external Qt5PasLib name 'QWidget_ensurePolished';
function QWidget_isAncestorOf(handle: QWidgetH; child: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_isAncestorOf';
function QWidget_autoFillBackground(handle: QWidgetH): Boolean; cdecl; external Qt5PasLib name 'QWidget_autoFillBackground';
procedure QWidget_setAutoFillBackground(handle: QWidgetH; enabled: Boolean); cdecl; external Qt5PasLib name 'QWidget_setAutoFillBackground';
function QWidget_backingStore(handle: QWidgetH): QBackingStoreH; cdecl; external Qt5PasLib name 'QWidget_backingStore';
function QWidget_windowHandle(handle: QWidgetH): QWindowH; cdecl; external Qt5PasLib name 'QWidget_windowHandle';
function QWidget_createWindowContainer(window: QWindowH; parent: QWidgetH = nil; flags: QtWindowFlags = 0): QWidgetH; cdecl; external Qt5PasLib name 'QWidget_createWindowContainer';
procedure QWidget_inputMethodQuery(handle: QWidgetH; retval: QVariantH; AnonParam1: QtInputMethodQuery); cdecl; external Qt5PasLib name 'QWidget_inputMethodQuery';
function QWidget_inputMethodHints(handle: QWidgetH): QtInputMethodHints; cdecl; external Qt5PasLib name 'QWidget_inputMethodHints';
procedure QWidget_setInputMethodHints(handle: QWidgetH; hints: QtInputMethodHints); cdecl; external Qt5PasLib name 'QWidget_setInputMethodHints';
function QWidget_to_QPaintDevice(handle: QWidgetH): QPaintDeviceH; cdecl; external Qt5PasLib name 'QWidget_to_QPaintDevice';

type
  QWidget_customContextMenuRequested_Event = procedure (pos: PQtPoint) of object cdecl;


procedure QLayoutItem_sizeHint(handle: QLayoutItemH; retval: PSize); cdecl; external Qt5PasLib name 'QLayoutItem_sizeHint';
procedure QLayoutItem_minimumSize(handle: QLayoutItemH; retval: PSize); cdecl; external Qt5PasLib name 'QLayoutItem_minimumSize';
procedure QLayoutItem_maximumSize(handle: QLayoutItemH; retval: PSize); cdecl; external Qt5PasLib name 'QLayoutItem_maximumSize';
function QLayoutItem_expandingDirections(handle: QLayoutItemH): QtOrientations; cdecl; external Qt5PasLib name 'QLayoutItem_expandingDirections';
procedure QLayoutItem_setGeometry(handle: QLayoutItemH; AnonParam1: PRect); cdecl; external Qt5PasLib name 'QLayoutItem_setGeometry';
procedure QLayoutItem_geometry(handle: QLayoutItemH; retval: PRect); cdecl; external Qt5PasLib name 'QLayoutItem_geometry';
function QLayoutItem_isEmpty(handle: QLayoutItemH): Boolean; cdecl; external Qt5PasLib name 'QLayoutItem_isEmpty';
function QLayoutItem_hasHeightForWidth(handle: QLayoutItemH): Boolean; cdecl; external Qt5PasLib name 'QLayoutItem_hasHeightForWidth';
function QLayoutItem_heightForWidth(handle: QLayoutItemH; AnonParam1: Integer): Integer; cdecl; external Qt5PasLib name 'QLayoutItem_heightForWidth';
function QLayoutItem_minimumHeightForWidth(handle: QLayoutItemH; AnonParam1: Integer): Integer; cdecl; external Qt5PasLib name 'QLayoutItem_minimumHeightForWidth';
procedure QLayoutItem_invalidate(handle: QLayoutItemH); cdecl; external Qt5PasLib name 'QLayoutItem_invalidate';
function QLayoutItem_widget(handle: QLayoutItemH): QWidgetH; cdecl; external Qt5PasLib name 'QLayoutItem_widget';
function QLayoutItem_layout(handle: QLayoutItemH): QLayoutH; cdecl; external Qt5PasLib name 'QLayoutItem_layout';
function QLayoutItem_spacerItem(handle: QLayoutItemH): QSpacerItemH; cdecl; external Qt5PasLib name 'QLayoutItem_spacerItem';
function QLayoutItem_alignment(handle: QLayoutItemH): QtAlignment; cdecl; external Qt5PasLib name 'QLayoutItem_alignment';
procedure QLayoutItem_setAlignment(handle: QLayoutItemH; a: QtAlignment); cdecl; external Qt5PasLib name 'QLayoutItem_setAlignment';
function QLayoutItem_controlTypes(handle: QLayoutItemH): QSizePolicyControlTypes; cdecl; external Qt5PasLib name 'QLayoutItem_controlTypes';

function QSpacerItem_Create(w: Integer; h: Integer; hData: QSizePolicyPolicy = QSizePolicyMinimum; vData: QSizePolicyPolicy = QSizePolicyMinimum): QSpacerItemH; cdecl; external Qt5PasLib name 'QSpacerItem_Create';
procedure QSpacerItem_Destroy(handle: QSpacerItemH); cdecl; external Qt5PasLib name 'QSpacerItem_Destroy'; 
procedure QSpacerItem_changeSize(handle: QSpacerItemH; w: Integer; h: Integer; hData: QSizePolicyPolicy = QSizePolicyMinimum; vData: QSizePolicyPolicy = QSizePolicyMinimum); cdecl; external Qt5PasLib name 'QSpacerItem_changeSize';
procedure QSpacerItem_sizeHint(handle: QSpacerItemH; retval: PSize); cdecl; external Qt5PasLib name 'QSpacerItem_sizeHint';
procedure QSpacerItem_minimumSize(handle: QSpacerItemH; retval: PSize); cdecl; external Qt5PasLib name 'QSpacerItem_minimumSize';
procedure QSpacerItem_maximumSize(handle: QSpacerItemH; retval: PSize); cdecl; external Qt5PasLib name 'QSpacerItem_maximumSize';
function QSpacerItem_expandingDirections(handle: QSpacerItemH): QtOrientations; cdecl; external Qt5PasLib name 'QSpacerItem_expandingDirections';
function QSpacerItem_isEmpty(handle: QSpacerItemH): Boolean; cdecl; external Qt5PasLib name 'QSpacerItem_isEmpty';
procedure QSpacerItem_setGeometry(handle: QSpacerItemH; AnonParam1: PRect); cdecl; external Qt5PasLib name 'QSpacerItem_setGeometry';
procedure QSpacerItem_geometry(handle: QSpacerItemH; retval: PRect); cdecl; external Qt5PasLib name 'QSpacerItem_geometry';
function QSpacerItem_spacerItem(handle: QSpacerItemH): QSpacerItemH; cdecl; external Qt5PasLib name 'QSpacerItem_spacerItem';

function QWidgetItem_Create(w: QWidgetH): QWidgetItemH; cdecl; external Qt5PasLib name 'QWidgetItem_Create';
procedure QWidgetItem_Destroy(handle: QWidgetItemH); cdecl; external Qt5PasLib name 'QWidgetItem_Destroy'; 
procedure QWidgetItem_sizeHint(handle: QWidgetItemH; retval: PSize); cdecl; external Qt5PasLib name 'QWidgetItem_sizeHint';
procedure QWidgetItem_minimumSize(handle: QWidgetItemH; retval: PSize); cdecl; external Qt5PasLib name 'QWidgetItem_minimumSize';
procedure QWidgetItem_maximumSize(handle: QWidgetItemH; retval: PSize); cdecl; external Qt5PasLib name 'QWidgetItem_maximumSize';
function QWidgetItem_expandingDirections(handle: QWidgetItemH): QtOrientations; cdecl; external Qt5PasLib name 'QWidgetItem_expandingDirections';
function QWidgetItem_isEmpty(handle: QWidgetItemH): Boolean; cdecl; external Qt5PasLib name 'QWidgetItem_isEmpty';
procedure QWidgetItem_setGeometry(handle: QWidgetItemH; AnonParam1: PRect); cdecl; external Qt5PasLib name 'QWidgetItem_setGeometry';
procedure QWidgetItem_geometry(handle: QWidgetItemH; retval: PRect); cdecl; external Qt5PasLib name 'QWidgetItem_geometry';
function QWidgetItem_widget(handle: QWidgetItemH): QWidgetH; cdecl; external Qt5PasLib name 'QWidgetItem_widget';
function QWidgetItem_hasHeightForWidth(handle: QWidgetItemH): Boolean; cdecl; external Qt5PasLib name 'QWidgetItem_hasHeightForWidth';
function QWidgetItem_heightForWidth(handle: QWidgetItemH; AnonParam1: Integer): Integer; cdecl; external Qt5PasLib name 'QWidgetItem_heightForWidth';
function QWidgetItem_controlTypes(handle: QWidgetItemH): QSizePolicyControlTypes; cdecl; external Qt5PasLib name 'QWidgetItem_controlTypes';


type
  QLayoutSizeConstraint = ( // QLayout::SizeConstraint (1)
    QLayoutSetDefaultConstraint, QLayoutSetNoConstraint, QLayoutSetMinimumSize, QLayoutSetFixedSize, QLayoutSetMaximumSize, QLayoutSetMinAndMaxSize );

function QLayout_margin(handle: QLayoutH): Integer; cdecl; external Qt5PasLib name 'QLayout_margin';
function QLayout_spacing(handle: QLayoutH): Integer; cdecl; external Qt5PasLib name 'QLayout_spacing';
procedure QLayout_setMargin(handle: QLayoutH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QLayout_setMargin';
procedure QLayout_setSpacing(handle: QLayoutH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QLayout_setSpacing';
procedure QLayout_setContentsMargins(handle: QLayoutH; left: Integer; top: Integer; right: Integer; bottom: Integer); cdecl; external Qt5PasLib name 'QLayout_setContentsMargins';
procedure QLayout_setContentsMargins(handle: QLayoutH; margins: QMarginsH); cdecl; external Qt5PasLib name 'QLayout_setContentsMargins2';
procedure QLayout_getContentsMargins(handle: QLayoutH; left: PInteger; top: PInteger; right: PInteger; bottom: PInteger); cdecl; external Qt5PasLib name 'QLayout_getContentsMargins';
procedure QLayout_contentsMargins(handle: QLayoutH; retval: QMarginsH); cdecl; external Qt5PasLib name 'QLayout_contentsMargins';
procedure QLayout_contentsRect(handle: QLayoutH; retval: PRect); cdecl; external Qt5PasLib name 'QLayout_contentsRect';
function QLayout_setAlignment(handle: QLayoutH; w: QWidgetH; alignment: QtAlignment): Boolean; cdecl; external Qt5PasLib name 'QLayout_setAlignment';
function QLayout_setAlignment(handle: QLayoutH; l: QLayoutH; alignment: QtAlignment): Boolean; cdecl; external Qt5PasLib name 'QLayout_setAlignment2';
procedure QLayout_setSizeConstraint(handle: QLayoutH; AnonParam1: QLayoutSizeConstraint); cdecl; external Qt5PasLib name 'QLayout_setSizeConstraint';
function QLayout_sizeConstraint(handle: QLayoutH): QLayoutSizeConstraint; cdecl; external Qt5PasLib name 'QLayout_sizeConstraint';
procedure QLayout_setMenuBar(handle: QLayoutH; w: QWidgetH); cdecl; external Qt5PasLib name 'QLayout_setMenuBar';
function QLayout_menuBar(handle: QLayoutH): QWidgetH; cdecl; external Qt5PasLib name 'QLayout_menuBar';
function QLayout_parentWidget(handle: QLayoutH): QWidgetH; cdecl; external Qt5PasLib name 'QLayout_parentWidget';
procedure QLayout_invalidate(handle: QLayoutH); cdecl; external Qt5PasLib name 'QLayout_invalidate';
procedure QLayout_geometry(handle: QLayoutH; retval: PRect); cdecl; external Qt5PasLib name 'QLayout_geometry';
function QLayout_activate(handle: QLayoutH): Boolean; cdecl; external Qt5PasLib name 'QLayout_activate';
procedure QLayout_update(handle: QLayoutH); cdecl; external Qt5PasLib name 'QLayout_update';
procedure QLayout_addWidget(handle: QLayoutH; w: QWidgetH); cdecl; external Qt5PasLib name 'QLayout_addWidget';
procedure QLayout_addItem(handle: QLayoutH; AnonParam1: QLayoutItemH); cdecl; external Qt5PasLib name 'QLayout_addItem';
procedure QLayout_removeWidget(handle: QLayoutH; w: QWidgetH); cdecl; external Qt5PasLib name 'QLayout_removeWidget';
procedure QLayout_removeItem(handle: QLayoutH; AnonParam1: QLayoutItemH); cdecl; external Qt5PasLib name 'QLayout_removeItem';
function QLayout_expandingDirections(handle: QLayoutH): QtOrientations; cdecl; external Qt5PasLib name 'QLayout_expandingDirections';
procedure QLayout_minimumSize(handle: QLayoutH; retval: PSize); cdecl; external Qt5PasLib name 'QLayout_minimumSize';
procedure QLayout_maximumSize(handle: QLayoutH; retval: PSize); cdecl; external Qt5PasLib name 'QLayout_maximumSize';
procedure QLayout_setGeometry(handle: QLayoutH; AnonParam1: PRect); cdecl; external Qt5PasLib name 'QLayout_setGeometry';
function QLayout_itemAt(handle: QLayoutH; index: Integer): QLayoutItemH; cdecl; external Qt5PasLib name 'QLayout_itemAt';
function QLayout_takeAt(handle: QLayoutH; index: Integer): QLayoutItemH; cdecl; external Qt5PasLib name 'QLayout_takeAt';
function QLayout_indexOf(handle: QLayoutH; AnonParam1: QWidgetH): Integer; cdecl; external Qt5PasLib name 'QLayout_indexOf';
function QLayout_count(handle: QLayoutH): Integer; cdecl; external Qt5PasLib name 'QLayout_count';
function QLayout_isEmpty(handle: QLayoutH): Boolean; cdecl; external Qt5PasLib name 'QLayout_isEmpty';
function QLayout_controlTypes(handle: QLayoutH): QSizePolicyControlTypes; cdecl; external Qt5PasLib name 'QLayout_controlTypes';
function QLayout_totalHeightForWidth(handle: QLayoutH; w: Integer): Integer; cdecl; external Qt5PasLib name 'QLayout_totalHeightForWidth';
procedure QLayout_totalMinimumSize(handle: QLayoutH; retval: PSize); cdecl; external Qt5PasLib name 'QLayout_totalMinimumSize';
procedure QLayout_totalMaximumSize(handle: QLayoutH; retval: PSize); cdecl; external Qt5PasLib name 'QLayout_totalMaximumSize';
procedure QLayout_totalSizeHint(handle: QLayoutH; retval: PSize); cdecl; external Qt5PasLib name 'QLayout_totalSizeHint';
function QLayout_layout(handle: QLayoutH): QLayoutH; cdecl; external Qt5PasLib name 'QLayout_layout';
procedure QLayout_setEnabled(handle: QLayoutH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QLayout_setEnabled';
function QLayout_isEnabled(handle: QLayoutH): Boolean; cdecl; external Qt5PasLib name 'QLayout_isEnabled';
procedure QLayout_closestAcceptableSize(retval: PSize; w: QWidgetH; s: PSize); cdecl; external Qt5PasLib name 'QLayout_closestAcceptableSize';
function QLayout_to_QLayoutItem(handle: QLayoutH): QLayoutItemH; cdecl; external Qt5PasLib name 'QLayout_to_QLayoutItem';
type
  QBoxLayoutDirection = cardinal; //  QBoxLayout::Direction (4)

const
    QBoxLayoutLeftToRight = 0 { $0 };
    QBoxLayoutRightToLeft = 1 { $1 };
    QBoxLayoutTopToBottom = 2 { $2 };
    QBoxLayoutBottomToTop = 3 { $3 };
    QBoxLayoutDown = 2 { $2 };
    QBoxLayoutUp = 3 { $3 };


function QBoxLayout_Create(AnonParam1: QBoxLayoutDirection; parent: QWidgetH = nil): QBoxLayoutH; cdecl; external Qt5PasLib name 'QBoxLayout_Create';
procedure QBoxLayout_Destroy(handle: QBoxLayoutH); cdecl; external Qt5PasLib name 'QBoxLayout_Destroy'; 
function QBoxLayout_direction(handle: QBoxLayoutH): QBoxLayoutDirection; cdecl; external Qt5PasLib name 'QBoxLayout_direction';
procedure QBoxLayout_setDirection(handle: QBoxLayoutH; AnonParam1: QBoxLayoutDirection); cdecl; external Qt5PasLib name 'QBoxLayout_setDirection';
procedure QBoxLayout_addSpacing(handle: QBoxLayoutH; size: Integer); cdecl; external Qt5PasLib name 'QBoxLayout_addSpacing';
procedure QBoxLayout_addStretch(handle: QBoxLayoutH; stretch: Integer = 0); cdecl; external Qt5PasLib name 'QBoxLayout_addStretch';
procedure QBoxLayout_addSpacerItem(handle: QBoxLayoutH; spacerItem: QSpacerItemH); cdecl; external Qt5PasLib name 'QBoxLayout_addSpacerItem';
procedure QBoxLayout_addWidget(handle: QBoxLayoutH; AnonParam1: QWidgetH; stretch: Integer = 0; alignment: QtAlignment = 0); cdecl; external Qt5PasLib name 'QBoxLayout_addWidget';
procedure QBoxLayout_addLayout(handle: QBoxLayoutH; layout: QLayoutH; stretch: Integer = 0); cdecl; external Qt5PasLib name 'QBoxLayout_addLayout';
procedure QBoxLayout_addStrut(handle: QBoxLayoutH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QBoxLayout_addStrut';
procedure QBoxLayout_addItem(handle: QBoxLayoutH; AnonParam1: QLayoutItemH); cdecl; external Qt5PasLib name 'QBoxLayout_addItem';
procedure QBoxLayout_insertSpacing(handle: QBoxLayoutH; index: Integer; size: Integer); cdecl; external Qt5PasLib name 'QBoxLayout_insertSpacing';
procedure QBoxLayout_insertStretch(handle: QBoxLayoutH; index: Integer; stretch: Integer = 0); cdecl; external Qt5PasLib name 'QBoxLayout_insertStretch';
procedure QBoxLayout_insertSpacerItem(handle: QBoxLayoutH; index: Integer; spacerItem: QSpacerItemH); cdecl; external Qt5PasLib name 'QBoxLayout_insertSpacerItem';
procedure QBoxLayout_insertWidget(handle: QBoxLayoutH; index: Integer; widget: QWidgetH; stretch: Integer = 0; alignment: QtAlignment = 0); cdecl; external Qt5PasLib name 'QBoxLayout_insertWidget';
procedure QBoxLayout_insertLayout(handle: QBoxLayoutH; index: Integer; layout: QLayoutH; stretch: Integer = 0); cdecl; external Qt5PasLib name 'QBoxLayout_insertLayout';
procedure QBoxLayout_insertItem(handle: QBoxLayoutH; index: Integer; AnonParam2: QLayoutItemH); cdecl; external Qt5PasLib name 'QBoxLayout_insertItem';
function QBoxLayout_spacing(handle: QBoxLayoutH): Integer; cdecl; external Qt5PasLib name 'QBoxLayout_spacing';
procedure QBoxLayout_setSpacing(handle: QBoxLayoutH; spacing: Integer); cdecl; external Qt5PasLib name 'QBoxLayout_setSpacing';
function QBoxLayout_setStretchFactor(handle: QBoxLayoutH; w: QWidgetH; stretch: Integer): Boolean; cdecl; external Qt5PasLib name 'QBoxLayout_setStretchFactor';
function QBoxLayout_setStretchFactor(handle: QBoxLayoutH; l: QLayoutH; stretch: Integer): Boolean; cdecl; external Qt5PasLib name 'QBoxLayout_setStretchFactor2';
procedure QBoxLayout_setStretch(handle: QBoxLayoutH; index: Integer; stretch: Integer); cdecl; external Qt5PasLib name 'QBoxLayout_setStretch';
function QBoxLayout_stretch(handle: QBoxLayoutH; index: Integer): Integer; cdecl; external Qt5PasLib name 'QBoxLayout_stretch';
procedure QBoxLayout_sizeHint(handle: QBoxLayoutH; retval: PSize); cdecl; external Qt5PasLib name 'QBoxLayout_sizeHint';
procedure QBoxLayout_minimumSize(handle: QBoxLayoutH; retval: PSize); cdecl; external Qt5PasLib name 'QBoxLayout_minimumSize';
procedure QBoxLayout_maximumSize(handle: QBoxLayoutH; retval: PSize); cdecl; external Qt5PasLib name 'QBoxLayout_maximumSize';
function QBoxLayout_hasHeightForWidth(handle: QBoxLayoutH): Boolean; cdecl; external Qt5PasLib name 'QBoxLayout_hasHeightForWidth';
function QBoxLayout_heightForWidth(handle: QBoxLayoutH; AnonParam1: Integer): Integer; cdecl; external Qt5PasLib name 'QBoxLayout_heightForWidth';
function QBoxLayout_minimumHeightForWidth(handle: QBoxLayoutH; AnonParam1: Integer): Integer; cdecl; external Qt5PasLib name 'QBoxLayout_minimumHeightForWidth';
function QBoxLayout_expandingDirections(handle: QBoxLayoutH): QtOrientations; cdecl; external Qt5PasLib name 'QBoxLayout_expandingDirections';
procedure QBoxLayout_invalidate(handle: QBoxLayoutH); cdecl; external Qt5PasLib name 'QBoxLayout_invalidate';
function QBoxLayout_itemAt(handle: QBoxLayoutH; AnonParam1: Integer): QLayoutItemH; cdecl; external Qt5PasLib name 'QBoxLayout_itemAt';
function QBoxLayout_takeAt(handle: QBoxLayoutH; AnonParam1: Integer): QLayoutItemH; cdecl; external Qt5PasLib name 'QBoxLayout_takeAt';
function QBoxLayout_count(handle: QBoxLayoutH): Integer; cdecl; external Qt5PasLib name 'QBoxLayout_count';
procedure QBoxLayout_setGeometry(handle: QBoxLayoutH; AnonParam1: PRect); cdecl; external Qt5PasLib name 'QBoxLayout_setGeometry';

function QHBoxLayout_Create(): QHBoxLayoutH; cdecl; external Qt5PasLib name 'QHBoxLayout_Create';
procedure QHBoxLayout_Destroy(handle: QHBoxLayoutH); cdecl; external Qt5PasLib name 'QHBoxLayout_Destroy'; 
function QHBoxLayout_Create(parent: QWidgetH): QHBoxLayoutH; cdecl; external Qt5PasLib name 'QHBoxLayout_Create2';

function QVBoxLayout_Create(): QVBoxLayoutH; cdecl; external Qt5PasLib name 'QVBoxLayout_Create';
procedure QVBoxLayout_Destroy(handle: QVBoxLayoutH); cdecl; external Qt5PasLib name 'QVBoxLayout_Destroy'; 
function QVBoxLayout_Create(parent: QWidgetH): QVBoxLayoutH; cdecl; external Qt5PasLib name 'QVBoxLayout_Create2';


type
  QStackedLayoutStackingMode = ( // QStackedLayout::StackingMode (1)
    QStackedLayoutStackOne, QStackedLayoutStackAll );

function QStackedLayout_Create(): QStackedLayoutH; cdecl; external Qt5PasLib name 'QStackedLayout_Create';
procedure QStackedLayout_Destroy(handle: QStackedLayoutH); cdecl; external Qt5PasLib name 'QStackedLayout_Destroy'; 
function QStackedLayout_Create(parent: QWidgetH): QStackedLayoutH; cdecl; external Qt5PasLib name 'QStackedLayout_Create2';
function QStackedLayout_Create(parentLayout: QLayoutH): QStackedLayoutH; cdecl; external Qt5PasLib name 'QStackedLayout_Create3';
function QStackedLayout_addWidget(handle: QStackedLayoutH; w: QWidgetH): Integer; cdecl; external Qt5PasLib name 'QStackedLayout_addWidget';
function QStackedLayout_insertWidget(handle: QStackedLayoutH; index: Integer; w: QWidgetH): Integer; cdecl; external Qt5PasLib name 'QStackedLayout_insertWidget';
function QStackedLayout_currentWidget(handle: QStackedLayoutH): QWidgetH; cdecl; external Qt5PasLib name 'QStackedLayout_currentWidget';
function QStackedLayout_currentIndex(handle: QStackedLayoutH): Integer; cdecl; external Qt5PasLib name 'QStackedLayout_currentIndex';
function QStackedLayout_widget(handle: QStackedLayoutH; AnonParam1: Integer): QWidgetH; cdecl; external Qt5PasLib name 'QStackedLayout_widget';
function QStackedLayout_count(handle: QStackedLayoutH): Integer; cdecl; external Qt5PasLib name 'QStackedLayout_count';
function QStackedLayout_stackingMode(handle: QStackedLayoutH): QStackedLayoutStackingMode; cdecl; external Qt5PasLib name 'QStackedLayout_stackingMode';
procedure QStackedLayout_setStackingMode(handle: QStackedLayoutH; stackingMode: QStackedLayoutStackingMode); cdecl; external Qt5PasLib name 'QStackedLayout_setStackingMode';
procedure QStackedLayout_addItem(handle: QStackedLayoutH; item: QLayoutItemH); cdecl; external Qt5PasLib name 'QStackedLayout_addItem';
procedure QStackedLayout_sizeHint(handle: QStackedLayoutH; retval: PSize); cdecl; external Qt5PasLib name 'QStackedLayout_sizeHint';
procedure QStackedLayout_minimumSize(handle: QStackedLayoutH; retval: PSize); cdecl; external Qt5PasLib name 'QStackedLayout_minimumSize';
function QStackedLayout_itemAt(handle: QStackedLayoutH; AnonParam1: Integer): QLayoutItemH; cdecl; external Qt5PasLib name 'QStackedLayout_itemAt';
function QStackedLayout_takeAt(handle: QStackedLayoutH; AnonParam1: Integer): QLayoutItemH; cdecl; external Qt5PasLib name 'QStackedLayout_takeAt';
procedure QStackedLayout_setGeometry(handle: QStackedLayoutH; rect: PRect); cdecl; external Qt5PasLib name 'QStackedLayout_setGeometry';
function QStackedLayout_hasHeightForWidth(handle: QStackedLayoutH): Boolean; cdecl; external Qt5PasLib name 'QStackedLayout_hasHeightForWidth';
function QStackedLayout_heightForWidth(handle: QStackedLayoutH; width: Integer): Integer; cdecl; external Qt5PasLib name 'QStackedLayout_heightForWidth';
procedure QStackedLayout_setCurrentIndex(handle: QStackedLayoutH; index: Integer); cdecl; external Qt5PasLib name 'QStackedLayout_setCurrentIndex';
procedure QStackedLayout_setCurrentWidget(handle: QStackedLayoutH; w: QWidgetH); cdecl; external Qt5PasLib name 'QStackedLayout_setCurrentWidget';


type
  QStackedLayout_widgetRemoved_Event = procedure (index: Integer) of object cdecl;
  QStackedLayout_currentChanged_Event = procedure (index: Integer) of object cdecl;



type
  QActionActionEvent = ( // QAction::ActionEvent (1)
    QActionTrigger, QActionHover );

  QActionMenuRole = (  //QAction::MenuRole (2)
    QActionNoRole = 0,
    QActionTextHeuristicRole,
    QActionApplicationSpecificRole,
    QActionAboutQtRole,
    QActionAboutRole,
    QActionPreferencesRole,
    QActionQuitRole );

  QActionPriority = (  //QAction::Priority (2)
    QActionLowPriority = 0,
    QActionNormalPriority = 128,
    QActionHighPriority = 256 );

function QAction_Create(parent: QObjectH): QActionH; cdecl; external Qt5PasLib name 'QAction_Create';
procedure QAction_Destroy(handle: QActionH); cdecl; external Qt5PasLib name 'QAction_Destroy'; 
function QAction_Create(text: PWideString; parent: QObjectH): QActionH; cdecl; external Qt5PasLib name 'QAction_Create2';
function QAction_Create(icon: QIconH; text: PWideString; parent: QObjectH): QActionH; cdecl; external Qt5PasLib name 'QAction_Create3';
procedure QAction_setActionGroup(handle: QActionH; group: QActionGroupH); cdecl; external Qt5PasLib name 'QAction_setActionGroup';
function QAction_actionGroup(handle: QActionH): QActionGroupH; cdecl; external Qt5PasLib name 'QAction_actionGroup';
procedure QAction_setIcon(handle: QActionH; icon: QIconH); cdecl; external Qt5PasLib name 'QAction_setIcon';
procedure QAction_icon(handle: QActionH; retval: QIconH); cdecl; external Qt5PasLib name 'QAction_icon';
procedure QAction_setText(handle: QActionH; text: PWideString); cdecl; external Qt5PasLib name 'QAction_setText';
procedure QAction_text(handle: QActionH; retval: PWideString); cdecl; external Qt5PasLib name 'QAction_text';
procedure QAction_setIconText(handle: QActionH; text: PWideString); cdecl; external Qt5PasLib name 'QAction_setIconText';
procedure QAction_iconText(handle: QActionH; retval: PWideString); cdecl; external Qt5PasLib name 'QAction_iconText';
procedure QAction_setToolTip(handle: QActionH; tip: PWideString); cdecl; external Qt5PasLib name 'QAction_setToolTip';
procedure QAction_toolTip(handle: QActionH; retval: PWideString); cdecl; external Qt5PasLib name 'QAction_toolTip';
procedure QAction_setStatusTip(handle: QActionH; statusTip: PWideString); cdecl; external Qt5PasLib name 'QAction_setStatusTip';
procedure QAction_statusTip(handle: QActionH; retval: PWideString); cdecl; external Qt5PasLib name 'QAction_statusTip';
procedure QAction_setWhatsThis(handle: QActionH; what: PWideString); cdecl; external Qt5PasLib name 'QAction_setWhatsThis';
procedure QAction_whatsThis(handle: QActionH; retval: PWideString); cdecl; external Qt5PasLib name 'QAction_whatsThis';
procedure QAction_setPriority(handle: QActionH; priority: QActionPriority); cdecl; external Qt5PasLib name 'QAction_setPriority';
function QAction_priority(handle: QActionH): QActionPriority; cdecl; external Qt5PasLib name 'QAction_priority';
function QAction_menu(handle: QActionH): QMenuH; cdecl; external Qt5PasLib name 'QAction_menu';
procedure QAction_setMenu(handle: QActionH; menu: QMenuH); cdecl; external Qt5PasLib name 'QAction_setMenu';
procedure QAction_setSeparator(handle: QActionH; b: Boolean); cdecl; external Qt5PasLib name 'QAction_setSeparator';
function QAction_isSeparator(handle: QActionH): Boolean; cdecl; external Qt5PasLib name 'QAction_isSeparator';
procedure QAction_setShortcut(handle: QActionH; shortcut: QKeySequenceH); cdecl; external Qt5PasLib name 'QAction_setShortcut';
procedure QAction_shortcut(handle: QActionH; retval: QKeySequenceH); cdecl; external Qt5PasLib name 'QAction_shortcut';
procedure QAction_setShortcutContext(handle: QActionH; context: QtShortcutContext); cdecl; external Qt5PasLib name 'QAction_setShortcutContext';
function QAction_shortcutContext(handle: QActionH): QtShortcutContext; cdecl; external Qt5PasLib name 'QAction_shortcutContext';
procedure QAction_setAutoRepeat(handle: QActionH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QAction_setAutoRepeat';
function QAction_autoRepeat(handle: QActionH): Boolean; cdecl; external Qt5PasLib name 'QAction_autoRepeat';
procedure QAction_setFont(handle: QActionH; font: QFontH); cdecl; external Qt5PasLib name 'QAction_setFont';
procedure QAction_font(handle: QActionH; retval: QFontH); cdecl; external Qt5PasLib name 'QAction_font';
procedure QAction_setCheckable(handle: QActionH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QAction_setCheckable';
function QAction_isCheckable(handle: QActionH): Boolean; cdecl; external Qt5PasLib name 'QAction_isCheckable';
procedure QAction_data(handle: QActionH; retval: QVariantH); cdecl; external Qt5PasLib name 'QAction_data';
procedure QAction_setData(handle: QActionH; _var: QVariantH); cdecl; external Qt5PasLib name 'QAction_setData';
function QAction_isChecked(handle: QActionH): Boolean; cdecl; external Qt5PasLib name 'QAction_isChecked';
function QAction_isEnabled(handle: QActionH): Boolean; cdecl; external Qt5PasLib name 'QAction_isEnabled';
function QAction_isVisible(handle: QActionH): Boolean; cdecl; external Qt5PasLib name 'QAction_isVisible';
procedure QAction_activate(handle: QActionH; event: QActionActionEvent); cdecl; external Qt5PasLib name 'QAction_activate';
function QAction_showStatusText(handle: QActionH; widget: QWidgetH = nil): Boolean; cdecl; external Qt5PasLib name 'QAction_showStatusText';
procedure QAction_setMenuRole(handle: QActionH; menuRole: QActionMenuRole); cdecl; external Qt5PasLib name 'QAction_setMenuRole';
function QAction_menuRole(handle: QActionH): QActionMenuRole; cdecl; external Qt5PasLib name 'QAction_menuRole';
procedure QAction_setIconVisibleInMenu(handle: QActionH; visible: Boolean); cdecl; external Qt5PasLib name 'QAction_setIconVisibleInMenu';
function QAction_isIconVisibleInMenu(handle: QActionH): Boolean; cdecl; external Qt5PasLib name 'QAction_isIconVisibleInMenu';
function QAction_parentWidget(handle: QActionH): QWidgetH; cdecl; external Qt5PasLib name 'QAction_parentWidget';
procedure QAction_associatedWidgets(handle: QActionH; retval: PPtrIntArray); cdecl; external Qt5PasLib name 'QAction_associatedWidgets';
procedure QAction_associatedGraphicsWidgets(handle: QActionH; retval: PPtrIntArray); cdecl; external Qt5PasLib name 'QAction_associatedGraphicsWidgets';
procedure QAction_trigger(handle: QActionH); cdecl; external Qt5PasLib name 'QAction_trigger';
procedure QAction_hover(handle: QActionH); cdecl; external Qt5PasLib name 'QAction_hover';
procedure QAction_setChecked(handle: QActionH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QAction_setChecked';
procedure QAction_toggle(handle: QActionH); cdecl; external Qt5PasLib name 'QAction_toggle';
procedure QAction_setEnabled(handle: QActionH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QAction_setEnabled';
procedure QAction_setDisabled(handle: QActionH; b: Boolean); cdecl; external Qt5PasLib name 'QAction_setDisabled';
procedure QAction_setVisible(handle: QActionH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QAction_setVisible';


type
  QAction_changed_Event = procedure () of object cdecl;
  QAction_triggered_Event = procedure (checked: Boolean = False) of object cdecl;
  QAction_triggered2_Event = procedure () of object cdecl;
  QAction_hovered_Event = procedure () of object cdecl;
  QAction_toggled_Event = procedure (AnonParam1: Boolean) of object cdecl;


function QActionGroup_Create(parent: QObjectH): QActionGroupH; cdecl; external Qt5PasLib name 'QActionGroup_Create';
procedure QActionGroup_Destroy(handle: QActionGroupH); cdecl; external Qt5PasLib name 'QActionGroup_Destroy'; 
function QActionGroup_addAction(handle: QActionGroupH; a: QActionH): QActionH; cdecl; external Qt5PasLib name 'QActionGroup_addAction';
function QActionGroup_addAction(handle: QActionGroupH; text: PWideString): QActionH; cdecl; external Qt5PasLib name 'QActionGroup_addAction2';
function QActionGroup_addAction(handle: QActionGroupH; icon: QIconH; text: PWideString): QActionH; cdecl; external Qt5PasLib name 'QActionGroup_addAction3';
procedure QActionGroup_removeAction(handle: QActionGroupH; a: QActionH); cdecl; external Qt5PasLib name 'QActionGroup_removeAction';
procedure QActionGroup_actions(handle: QActionGroupH; retval: PPtrIntArray); cdecl; external Qt5PasLib name 'QActionGroup_actions';
function QActionGroup_checkedAction(handle: QActionGroupH): QActionH; cdecl; external Qt5PasLib name 'QActionGroup_checkedAction';
function QActionGroup_isExclusive(handle: QActionGroupH): Boolean; cdecl; external Qt5PasLib name 'QActionGroup_isExclusive';
function QActionGroup_isEnabled(handle: QActionGroupH): Boolean; cdecl; external Qt5PasLib name 'QActionGroup_isEnabled';
function QActionGroup_isVisible(handle: QActionGroupH): Boolean; cdecl; external Qt5PasLib name 'QActionGroup_isVisible';
procedure QActionGroup_setEnabled(handle: QActionGroupH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QActionGroup_setEnabled';
procedure QActionGroup_setDisabled(handle: QActionGroupH; b: Boolean); cdecl; external Qt5PasLib name 'QActionGroup_setDisabled';
procedure QActionGroup_setVisible(handle: QActionGroupH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QActionGroup_setVisible';
procedure QActionGroup_setExclusive(handle: QActionGroupH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QActionGroup_setExclusive';


type
  QActionGroup_triggered_Event = procedure (AnonParam1: QActionH) of object cdecl;
  QActionGroup_hovered_Event = procedure (AnonParam1: QActionH) of object cdecl;


function QGridLayout_Create(parent: QWidgetH): QGridLayoutH; cdecl; external Qt5PasLib name 'QGridLayout_Create';
procedure QGridLayout_Destroy(handle: QGridLayoutH); cdecl; external Qt5PasLib name 'QGridLayout_Destroy'; 
function QGridLayout_Create(): QGridLayoutH; cdecl; external Qt5PasLib name 'QGridLayout_Create2';
procedure QGridLayout_sizeHint(handle: QGridLayoutH; retval: PSize); cdecl; external Qt5PasLib name 'QGridLayout_sizeHint';
procedure QGridLayout_minimumSize(handle: QGridLayoutH; retval: PSize); cdecl; external Qt5PasLib name 'QGridLayout_minimumSize';
procedure QGridLayout_maximumSize(handle: QGridLayoutH; retval: PSize); cdecl; external Qt5PasLib name 'QGridLayout_maximumSize';
procedure QGridLayout_setHorizontalSpacing(handle: QGridLayoutH; spacing: Integer); cdecl; external Qt5PasLib name 'QGridLayout_setHorizontalSpacing';
function QGridLayout_horizontalSpacing(handle: QGridLayoutH): Integer; cdecl; external Qt5PasLib name 'QGridLayout_horizontalSpacing';
procedure QGridLayout_setVerticalSpacing(handle: QGridLayoutH; spacing: Integer); cdecl; external Qt5PasLib name 'QGridLayout_setVerticalSpacing';
function QGridLayout_verticalSpacing(handle: QGridLayoutH): Integer; cdecl; external Qt5PasLib name 'QGridLayout_verticalSpacing';
procedure QGridLayout_setSpacing(handle: QGridLayoutH; spacing: Integer); cdecl; external Qt5PasLib name 'QGridLayout_setSpacing';
function QGridLayout_spacing(handle: QGridLayoutH): Integer; cdecl; external Qt5PasLib name 'QGridLayout_spacing';
procedure QGridLayout_setRowStretch(handle: QGridLayoutH; row: Integer; stretch: Integer); cdecl; external Qt5PasLib name 'QGridLayout_setRowStretch';
procedure QGridLayout_setColumnStretch(handle: QGridLayoutH; column: Integer; stretch: Integer); cdecl; external Qt5PasLib name 'QGridLayout_setColumnStretch';
function QGridLayout_rowStretch(handle: QGridLayoutH; row: Integer): Integer; cdecl; external Qt5PasLib name 'QGridLayout_rowStretch';
function QGridLayout_columnStretch(handle: QGridLayoutH; column: Integer): Integer; cdecl; external Qt5PasLib name 'QGridLayout_columnStretch';
procedure QGridLayout_setRowMinimumHeight(handle: QGridLayoutH; row: Integer; minSize: Integer); cdecl; external Qt5PasLib name 'QGridLayout_setRowMinimumHeight';
procedure QGridLayout_setColumnMinimumWidth(handle: QGridLayoutH; column: Integer; minSize: Integer); cdecl; external Qt5PasLib name 'QGridLayout_setColumnMinimumWidth';
function QGridLayout_rowMinimumHeight(handle: QGridLayoutH; row: Integer): Integer; cdecl; external Qt5PasLib name 'QGridLayout_rowMinimumHeight';
function QGridLayout_columnMinimumWidth(handle: QGridLayoutH; column: Integer): Integer; cdecl; external Qt5PasLib name 'QGridLayout_columnMinimumWidth';
function QGridLayout_columnCount(handle: QGridLayoutH): Integer; cdecl; external Qt5PasLib name 'QGridLayout_columnCount';
function QGridLayout_rowCount(handle: QGridLayoutH): Integer; cdecl; external Qt5PasLib name 'QGridLayout_rowCount';
procedure QGridLayout_cellRect(handle: QGridLayoutH; retval: PRect; row: Integer; column: Integer); cdecl; external Qt5PasLib name 'QGridLayout_cellRect';
function QGridLayout_hasHeightForWidth(handle: QGridLayoutH): Boolean; cdecl; external Qt5PasLib name 'QGridLayout_hasHeightForWidth';
function QGridLayout_heightForWidth(handle: QGridLayoutH; AnonParam1: Integer): Integer; cdecl; external Qt5PasLib name 'QGridLayout_heightForWidth';
function QGridLayout_minimumHeightForWidth(handle: QGridLayoutH; AnonParam1: Integer): Integer; cdecl; external Qt5PasLib name 'QGridLayout_minimumHeightForWidth';
function QGridLayout_expandingDirections(handle: QGridLayoutH): QtOrientations; cdecl; external Qt5PasLib name 'QGridLayout_expandingDirections';
procedure QGridLayout_invalidate(handle: QGridLayoutH); cdecl; external Qt5PasLib name 'QGridLayout_invalidate';
procedure QGridLayout_addWidget(handle: QGridLayoutH; w: QWidgetH); cdecl; external Qt5PasLib name 'QGridLayout_addWidget';
procedure QGridLayout_addWidget(handle: QGridLayoutH; AnonParam1: QWidgetH; row: Integer; column: Integer; AnonParam4: QtAlignment = 0); cdecl; external Qt5PasLib name 'QGridLayout_addWidget2';
procedure QGridLayout_addWidget(handle: QGridLayoutH; AnonParam1: QWidgetH; row: Integer; column: Integer; rowSpan: Integer; columnSpan: Integer; AnonParam6: QtAlignment = 0); cdecl; external Qt5PasLib name 'QGridLayout_addWidget3';
procedure QGridLayout_addLayout(handle: QGridLayoutH; AnonParam1: QLayoutH; row: Integer; column: Integer; AnonParam4: QtAlignment = 0); cdecl; external Qt5PasLib name 'QGridLayout_addLayout';
procedure QGridLayout_addLayout(handle: QGridLayoutH; AnonParam1: QLayoutH; row: Integer; column: Integer; rowSpan: Integer; columnSpan: Integer; AnonParam6: QtAlignment = 0); cdecl; external Qt5PasLib name 'QGridLayout_addLayout2';
procedure QGridLayout_setOriginCorner(handle: QGridLayoutH; AnonParam1: QtCorner); cdecl; external Qt5PasLib name 'QGridLayout_setOriginCorner';
function QGridLayout_originCorner(handle: QGridLayoutH): QtCorner; cdecl; external Qt5PasLib name 'QGridLayout_originCorner';
function QGridLayout_itemAt(handle: QGridLayoutH; index: Integer): QLayoutItemH; cdecl; external Qt5PasLib name 'QGridLayout_itemAt';
function QGridLayout_itemAtPosition(handle: QGridLayoutH; row: Integer; column: Integer): QLayoutItemH; cdecl; external Qt5PasLib name 'QGridLayout_itemAtPosition';
function QGridLayout_takeAt(handle: QGridLayoutH; index: Integer): QLayoutItemH; cdecl; external Qt5PasLib name 'QGridLayout_takeAt';
function QGridLayout_count(handle: QGridLayoutH): Integer; cdecl; external Qt5PasLib name 'QGridLayout_count';
procedure QGridLayout_setGeometry(handle: QGridLayoutH; AnonParam1: PRect); cdecl; external Qt5PasLib name 'QGridLayout_setGeometry';
procedure QGridLayout_addItem(handle: QGridLayoutH; item: QLayoutItemH; row: Integer; column: Integer; rowSpan: Integer = 1; columnSpan: Integer = 1; AnonParam6: QtAlignment = 0); cdecl; external Qt5PasLib name 'QGridLayout_addItem';
procedure QGridLayout_setDefaultPositioning(handle: QGridLayoutH; n: Integer; orient: QtOrientation); cdecl; external Qt5PasLib name 'QGridLayout_setDefaultPositioning';
procedure QGridLayout_getItemPosition(handle: QGridLayoutH; idx: Integer; row: PInteger; column: PInteger; rowSpan: PInteger; columnSpan: PInteger); cdecl; external Qt5PasLib name 'QGridLayout_getItemPosition';

procedure QScreen_Destroy(handle: QScreenH); cdecl; external Qt5PasLib name 'QScreen_Destroy';
procedure QScreen_name(handle: QScreenH; retval: PWideString); cdecl; external Qt5PasLib name 'QScreen_name';
function QScreen_depth(handle: QScreenH): integer; cdecl; external Qt5PasLib name 'QScreen_depth';
procedure QScreen_size(handle: QScreenH; retval: PSize); cdecl; external Qt5PasLib name 'QScreen_size';
procedure QScreen_geometry(handle: QScreenH; retval: PRect); cdecl; external Qt5PasLib name 'QScreen_geometry';
{screen's physical size in millimeters}
procedure QScreen_physicalSize(handle: QScreenH; retval: QSizeFH); cdecl; external Qt5PasLib name 'QScreen_physicalSize';
function QScreen_physicalDotsPerInchX(handle: QScreenH): qreal; cdecl; external Qt5PasLib name 'QScreen_physicalDotsPerInchX';
function QScreen_physicalDotsPerInchY(handle: QScreenH): qreal; cdecl; external Qt5PasLib name 'QScreen_physicalDotsPerInchY';
function QScreen_physicalDotsPerInch(handle: QScreenH): qreal; cdecl; external Qt5PasLib name 'QScreen_physicalDotsPerInch';
function QScreen_logicalDotsPerInchX(handle: QScreenH): qreal; cdecl; external Qt5PasLib name 'QScreen_logicalDotsPerInchX';
function QScreen_logicalDotsPerInchY(handle: QScreenH): qreal; cdecl; external Qt5PasLib name 'QScreen_logicalDotsPerInchY';
function QScreen_logicalDotsPerInch(handle: QScreenH): qreal; cdecl; external Qt5PasLib name 'QScreen_logicalDotsPerInch';
function QScreen_devicePixelRatio(handle: QScreenH): qreal; cdecl; external Qt5PasLib name 'QScreen_devicePixelRatio';
procedure QScreen_availableSize(handle: QScreenH; retval: PSize); cdecl; external Qt5PasLib name 'QScreen_availableSize';
procedure QScreen_availableGeometry(handle: QScreenH; retval: PRect); cdecl; external Qt5PasLib name 'QScreen_availableGeometry';
procedure QScreen_virtualSize(handle: QScreenH; retval: PSize); cdecl; external Qt5PasLib name 'QScreen_virtualSize';
procedure QScreen_virtualGeometry(handle: QScreenH; retval: PRect); cdecl; external Qt5PasLib name 'QScreen_virtualGeometry';
function QScreen_primaryOrientation(handle: QScreenH): QtScreenOrientation; cdecl; external Qt5PasLib name 'QScreen_primaryOrientation';
function QScreen_orientation(handle: QScreenH): QtScreenOrientation; cdecl; external Qt5PasLib name 'QScreen_orientation';
function QScreen_nativeOrientation(handle: QScreenH): QtScreenOrientation; cdecl; external Qt5PasLib name 'QScreen_nativeOrientation';
function QScreen_orientationUpdateMask(handle: QScreenH): QtScreenOrientations; cdecl; external Qt5PasLib name 'QScreen_orientationUpdateMask';
procedure QScreen_setOrientationUpdateMask(handle: QScreenH; mask: QtScreenOrientations); cdecl; external Qt5PasLib name 'QScreen_setOrientationUpdateMask';
function QScreen_angleBetween(handle: QScreenH; a: QtScreenOrientation; b: QtScreenOrientation): integer; cdecl; external Qt5PasLib name 'QScreen_angleBetween';
procedure QScreen_virtualSiblings(handle: QScreenH; retval: PPtrIntArray); cdecl; external Qt5PasLib name 'QScreen_virtualSiblings';
procedure QScreen_transformBetween(handle: QScreenH; retval: QTransformH; a: QtScreenOrientation; b: QtScreenOrientation; AnonParam1: PRect); cdecl; external Qt5PasLib name 'QScreen_transformBetween';
procedure QScreen_mapBetween(handle: QScreenH; retval: PRect; a: QtScreenOrientation; b: QtScreenOrientation; AnonParam1: PRect); cdecl; external Qt5PasLib name 'QScreen_mapBetween';
function QScreen_isPortrait(handle: QScreenH; orientation: QtScreenOrientation): boolean; cdecl; external Qt5PasLib name 'QScreen_isPortrait';
function QScreen_isLandscape(handle: QScreenH; orientation: QtScreenOrientation): boolean; cdecl; external Qt5PasLib name 'QScreen_isLandscape';
procedure QScreen_grabWindow(handle: QScreenH; retval: QPixmapH; window: PtrUInt; x: integer = 0; y: integer = 0; w: integer = -1; h: integer = -1); cdecl; external Qt5PasLib name 'QScreen_grabWindow';
function QScreen_refreshRate(handle: QScreenH): qreal; cdecl; external Qt5PasLib name 'QScreen_refreshRate';

type
  QScreen_geometryChanged_event = procedure (geom: PRect) of object cdecl;
  QScreen_availableGeometryChanged_event = procedure (geom: PRect) of object cdecl;
  QScreen_physicalSizeChanged_event = procedure (asize: QSizeFH) of object cdecl;
  QScreen_physicalDotsPerInchChanged_event = procedure (adpi: qreal) of object cdecl;
  QScreen_logicalDotsPerInchChanged_event = procedure (adpi: qreal) of object cdecl;
  QScreen_virtualGeometryChanged_event = procedure (geom: PRect) of object cdecl;
  QScreen_primaryOrientationChanged_event = procedure (orientation: QtOrientation) of object cdecl;
  QScreen_orientationChanged_event = procedure (orientation: QtOrientation) of object cdecl;
  QScreen_refreshRateChanged_event = procedure (refreshRate: qreal) of object cdecl;

function QDesktopWidget_Create(): QDesktopWidgetH; cdecl; external Qt5PasLib name 'QDesktopWidget_Create';
procedure QDesktopWidget_Destroy(handle: QDesktopWidgetH); cdecl; external Qt5PasLib name 'QDesktopWidget_Destroy'; 
function QDesktopWidget_isVirtualDesktop(handle: QDesktopWidgetH): Boolean; cdecl; external Qt5PasLib name 'QDesktopWidget_isVirtualDesktop';
function QDesktopWidget_numScreens(handle: QDesktopWidgetH): Integer; cdecl; external Qt5PasLib name 'QDesktopWidget_numScreens';
function QDesktopWidget_screenCount(handle: QDesktopWidgetH): Integer; cdecl; external Qt5PasLib name 'QDesktopWidget_screenCount';
function QDesktopWidget_primaryScreen(handle: QDesktopWidgetH): Integer; cdecl; external Qt5PasLib name 'QDesktopWidget_primaryScreen';
function QDesktopWidget_screenNumber(handle: QDesktopWidgetH; widget: QWidgetH = nil): Integer; cdecl; external Qt5PasLib name 'QDesktopWidget_screenNumber';
function QDesktopWidget_screenNumber(handle: QDesktopWidgetH; AnonParam1: PQtPoint): Integer; cdecl; external Qt5PasLib name 'QDesktopWidget_screenNumber2';
function QDesktopWidget_screen(handle: QDesktopWidgetH; screen: Integer = -1): QWidgetH; cdecl; external Qt5PasLib name 'QDesktopWidget_screen';
procedure QDesktopWidget_screenGeometry(handle: QDesktopWidgetH; retval: PRect; screen: Integer = -1); cdecl; external Qt5PasLib name 'QDesktopWidget_screenGeometry';
procedure QDesktopWidget_screenGeometry(handle: QDesktopWidgetH; retval: PRect; widget: QWidgetH); cdecl; external Qt5PasLib name 'QDesktopWidget_screenGeometry2';
procedure QDesktopWidget_screenGeometry(handle: QDesktopWidgetH; retval: PRect; point: PQtPoint); cdecl; external Qt5PasLib name 'QDesktopWidget_screenGeometry3';
procedure QDesktopWidget_availableGeometry(handle: QDesktopWidgetH; retval: PRect; screen: Integer = -1); cdecl; external Qt5PasLib name 'QDesktopWidget_availableGeometry';
procedure QDesktopWidget_availableGeometry(handle: QDesktopWidgetH; retval: PRect; widget: QWidgetH); cdecl; external Qt5PasLib name 'QDesktopWidget_availableGeometry2';
procedure QDesktopWidget_availableGeometry(handle: QDesktopWidgetH; retval: PRect; point: PQtPoint); cdecl; external Qt5PasLib name 'QDesktopWidget_availableGeometry3';


type
  QDesktopWidget_resized_Event = procedure (AnonParam1: Integer) of object cdecl;
  QDesktopWidget_workAreaResized_Event = procedure (AnonParam1: Integer) of object cdecl;
  QDesktopWidget_screenCountChanged_Event = procedure (AnonParam1: Integer) of object cdecl;


procedure QToolTip_showText(pos: PQtPoint; text: PWideString; w: QWidgetH = nil); cdecl; external Qt5PasLib name 'QToolTip_showText';
procedure QToolTip_showText(pos: PQtPoint; text: PWideString; w: QWidgetH; rect: PRect); cdecl; external Qt5PasLib name 'QToolTip_showText2';
procedure QToolTip_hideText(); cdecl; external Qt5PasLib name 'QToolTip_hideText';
function QToolTip_isVisible(): Boolean; cdecl; external Qt5PasLib name 'QToolTip_isVisible';
procedure QToolTip_text(retval: PWideString); cdecl; external Qt5PasLib name 'QToolTip_text';
procedure QToolTip_palette(retval: QPaletteH); cdecl; external Qt5PasLib name 'QToolTip_palette';
procedure QToolTip_setPalette(AnonParam1: QPaletteH); cdecl; external Qt5PasLib name 'QToolTip_setPalette';
procedure QToolTip_font(retval: QFontH); cdecl; external Qt5PasLib name 'QToolTip_font';
procedure QToolTip_setFont(AnonParam1: QFontH); cdecl; external Qt5PasLib name 'QToolTip_setFont';

function QShortcut_Create(parent: QWidgetH): QShortcutH; cdecl; external Qt5PasLib name 'QShortcut_Create';
procedure QShortcut_Destroy(handle: QShortcutH); cdecl; external Qt5PasLib name 'QShortcut_Destroy'; 
function QShortcut_Create(key: QKeySequenceH; parent: QWidgetH; member: PAnsiChar = nil; ambiguousMember: PAnsiChar = nil; context: QtShortcutContext = QtWindowShortcut): QShortcutH; cdecl; external Qt5PasLib name 'QShortcut_Create2';
procedure QShortcut_setKey(handle: QShortcutH; key: QKeySequenceH); cdecl; external Qt5PasLib name 'QShortcut_setKey';
procedure QShortcut_key(handle: QShortcutH; retval: QKeySequenceH); cdecl; external Qt5PasLib name 'QShortcut_key';
procedure QShortcut_setEnabled(handle: QShortcutH; enable: Boolean); cdecl; external Qt5PasLib name 'QShortcut_setEnabled';
function QShortcut_isEnabled(handle: QShortcutH): Boolean; cdecl; external Qt5PasLib name 'QShortcut_isEnabled';
procedure QShortcut_setContext(handle: QShortcutH; context: QtShortcutContext); cdecl; external Qt5PasLib name 'QShortcut_setContext';
function QShortcut_context(handle: QShortcutH): QtShortcutContext; cdecl; external Qt5PasLib name 'QShortcut_context';
procedure QShortcut_setWhatsThis(handle: QShortcutH; text: PWideString); cdecl; external Qt5PasLib name 'QShortcut_setWhatsThis';
procedure QShortcut_whatsThis(handle: QShortcutH; retval: PWideString); cdecl; external Qt5PasLib name 'QShortcut_whatsThis';
procedure QShortcut_setAutoRepeat(handle: QShortcutH; _on: Boolean); cdecl; external Qt5PasLib name 'QShortcut_setAutoRepeat';
function QShortcut_autoRepeat(handle: QShortcutH): Boolean; cdecl; external Qt5PasLib name 'QShortcut_autoRepeat';
function QShortcut_id(handle: QShortcutH): Integer; cdecl; external Qt5PasLib name 'QShortcut_id';
function QShortcut_parentWidget(handle: QShortcutH): QWidgetH; cdecl; external Qt5PasLib name 'QShortcut_parentWidget';


type
  QShortcut_activated_Event = procedure () of object cdecl;
  QShortcut_activatedAmbiguously_Event = procedure () of object cdecl;



type
  QGestureGestureCancelPolicy = (  //QGesture::GestureCancelPolicy (2)
    QGestureCancelNone = 0,
    QGestureCancelAllInContext );

type
  QPinchGestureChangeFlag = cardinal; // QPinchGesture::ChangeFlag
  QPinchGestureChangeFlags = QPinchGestureChangeFlag; //QFlags<> (3)
const
  QPinchGestureScaleFactorChanged =   $1;
  QPinchGestureRotationAngleChanged =   $2;
  QPinchGestureCenterPointChanged =   $4;


type
  QSwipeGestureSwipeDirection = ( // QSwipeGesture::SwipeDirection (1)
    QSwipeGestureNoDirection, QSwipeGestureLeft, QSwipeGestureRight, QSwipeGestureUp, QSwipeGestureDown );

function QGesture_Create(parent: QObjectH = nil): QGestureH; cdecl; external Qt5PasLib name 'QGesture_Create';
procedure QGesture_Destroy(handle: QGestureH); cdecl; external Qt5PasLib name 'QGesture_Destroy'; 
function QGesture_gestureType(handle: QGestureH): QtGestureType; cdecl; external Qt5PasLib name 'QGesture_gestureType';
function QGesture_state(handle: QGestureH): QtGestureState; cdecl; external Qt5PasLib name 'QGesture_state';
procedure QGesture_hotSpot(handle: QGestureH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QGesture_hotSpot';
procedure QGesture_setHotSpot(handle: QGestureH; value: PQtPointF); cdecl; external Qt5PasLib name 'QGesture_setHotSpot';
function QGesture_hasHotSpot(handle: QGestureH): Boolean; cdecl; external Qt5PasLib name 'QGesture_hasHotSpot';
procedure QGesture_unsetHotSpot(handle: QGestureH); cdecl; external Qt5PasLib name 'QGesture_unsetHotSpot';
procedure QGesture_setGestureCancelPolicy(handle: QGestureH; policy: QGestureGestureCancelPolicy); cdecl; external Qt5PasLib name 'QGesture_setGestureCancelPolicy';
function QGesture_gestureCancelPolicy(handle: QGestureH): QGestureGestureCancelPolicy; cdecl; external Qt5PasLib name 'QGesture_gestureCancelPolicy';

function QPanGesture_Create(parent: QObjectH = nil): QPanGestureH; cdecl; external Qt5PasLib name 'QPanGesture_Create';
procedure QPanGesture_Destroy(handle: QPanGestureH); cdecl; external Qt5PasLib name 'QPanGesture_Destroy'; 
procedure QPanGesture_lastOffset(handle: QPanGestureH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QPanGesture_lastOffset';
procedure QPanGesture_offset(handle: QPanGestureH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QPanGesture_offset';
procedure QPanGesture_delta(handle: QPanGestureH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QPanGesture_delta';
function QPanGesture_acceleration(handle: QPanGestureH): qreal; cdecl; external Qt5PasLib name 'QPanGesture_acceleration';
procedure QPanGesture_setLastOffset(handle: QPanGestureH; value: PQtPointF); cdecl; external Qt5PasLib name 'QPanGesture_setLastOffset';
procedure QPanGesture_setOffset(handle: QPanGestureH; value: PQtPointF); cdecl; external Qt5PasLib name 'QPanGesture_setOffset';
procedure QPanGesture_setAcceleration(handle: QPanGestureH; value: qreal); cdecl; external Qt5PasLib name 'QPanGesture_setAcceleration';

function QPinchGesture_Create(parent: QObjectH = nil): QPinchGestureH; cdecl; external Qt5PasLib name 'QPinchGesture_Create';
procedure QPinchGesture_Destroy(handle: QPinchGestureH); cdecl; external Qt5PasLib name 'QPinchGesture_Destroy'; 
function QPinchGesture_totalChangeFlags(handle: QPinchGestureH): QPinchGestureChangeFlags; cdecl; external Qt5PasLib name 'QPinchGesture_totalChangeFlags';
procedure QPinchGesture_setTotalChangeFlags(handle: QPinchGestureH; value: QPinchGestureChangeFlags); cdecl; external Qt5PasLib name 'QPinchGesture_setTotalChangeFlags';
function QPinchGesture_changeFlags(handle: QPinchGestureH): QPinchGestureChangeFlags; cdecl; external Qt5PasLib name 'QPinchGesture_changeFlags';
procedure QPinchGesture_setChangeFlags(handle: QPinchGestureH; value: QPinchGestureChangeFlags); cdecl; external Qt5PasLib name 'QPinchGesture_setChangeFlags';
procedure QPinchGesture_startCenterPoint(handle: QPinchGestureH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QPinchGesture_startCenterPoint';
procedure QPinchGesture_lastCenterPoint(handle: QPinchGestureH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QPinchGesture_lastCenterPoint';
procedure QPinchGesture_centerPoint(handle: QPinchGestureH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QPinchGesture_centerPoint';
procedure QPinchGesture_setStartCenterPoint(handle: QPinchGestureH; value: PQtPointF); cdecl; external Qt5PasLib name 'QPinchGesture_setStartCenterPoint';
procedure QPinchGesture_setLastCenterPoint(handle: QPinchGestureH; value: PQtPointF); cdecl; external Qt5PasLib name 'QPinchGesture_setLastCenterPoint';
procedure QPinchGesture_setCenterPoint(handle: QPinchGestureH; value: PQtPointF); cdecl; external Qt5PasLib name 'QPinchGesture_setCenterPoint';
function QPinchGesture_totalScaleFactor(handle: QPinchGestureH): qreal; cdecl; external Qt5PasLib name 'QPinchGesture_totalScaleFactor';
function QPinchGesture_lastScaleFactor(handle: QPinchGestureH): qreal; cdecl; external Qt5PasLib name 'QPinchGesture_lastScaleFactor';
function QPinchGesture_scaleFactor(handle: QPinchGestureH): qreal; cdecl; external Qt5PasLib name 'QPinchGesture_scaleFactor';
procedure QPinchGesture_setTotalScaleFactor(handle: QPinchGestureH; value: qreal); cdecl; external Qt5PasLib name 'QPinchGesture_setTotalScaleFactor';
procedure QPinchGesture_setLastScaleFactor(handle: QPinchGestureH; value: qreal); cdecl; external Qt5PasLib name 'QPinchGesture_setLastScaleFactor';
procedure QPinchGesture_setScaleFactor(handle: QPinchGestureH; value: qreal); cdecl; external Qt5PasLib name 'QPinchGesture_setScaleFactor';
function QPinchGesture_totalRotationAngle(handle: QPinchGestureH): qreal; cdecl; external Qt5PasLib name 'QPinchGesture_totalRotationAngle';
function QPinchGesture_lastRotationAngle(handle: QPinchGestureH): qreal; cdecl; external Qt5PasLib name 'QPinchGesture_lastRotationAngle';
function QPinchGesture_rotationAngle(handle: QPinchGestureH): qreal; cdecl; external Qt5PasLib name 'QPinchGesture_rotationAngle';
procedure QPinchGesture_setTotalRotationAngle(handle: QPinchGestureH; value: qreal); cdecl; external Qt5PasLib name 'QPinchGesture_setTotalRotationAngle';
procedure QPinchGesture_setLastRotationAngle(handle: QPinchGestureH; value: qreal); cdecl; external Qt5PasLib name 'QPinchGesture_setLastRotationAngle';
procedure QPinchGesture_setRotationAngle(handle: QPinchGestureH; value: qreal); cdecl; external Qt5PasLib name 'QPinchGesture_setRotationAngle';

function QSwipeGesture_Create(parent: QObjectH = nil): QSwipeGestureH; cdecl; external Qt5PasLib name 'QSwipeGesture_Create';
procedure QSwipeGesture_Destroy(handle: QSwipeGestureH); cdecl; external Qt5PasLib name 'QSwipeGesture_Destroy'; 
function QSwipeGesture_horizontalDirection(handle: QSwipeGestureH): QSwipeGestureSwipeDirection; cdecl; external Qt5PasLib name 'QSwipeGesture_horizontalDirection';
function QSwipeGesture_verticalDirection(handle: QSwipeGestureH): QSwipeGestureSwipeDirection; cdecl; external Qt5PasLib name 'QSwipeGesture_verticalDirection';
function QSwipeGesture_swipeAngle(handle: QSwipeGestureH): qreal; cdecl; external Qt5PasLib name 'QSwipeGesture_swipeAngle';
procedure QSwipeGesture_setSwipeAngle(handle: QSwipeGestureH; value: qreal); cdecl; external Qt5PasLib name 'QSwipeGesture_setSwipeAngle';

function QTapGesture_Create(parent: QObjectH = nil): QTapGestureH; cdecl; external Qt5PasLib name 'QTapGesture_Create';
procedure QTapGesture_Destroy(handle: QTapGestureH); cdecl; external Qt5PasLib name 'QTapGesture_Destroy'; 
procedure QTapGesture_position(handle: QTapGestureH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QTapGesture_position';
procedure QTapGesture_setPosition(handle: QTapGestureH; pos: PQtPointF); cdecl; external Qt5PasLib name 'QTapGesture_setPosition';

function QTapAndHoldGesture_Create(parent: QObjectH = nil): QTapAndHoldGestureH; cdecl; external Qt5PasLib name 'QTapAndHoldGesture_Create';
procedure QTapAndHoldGesture_Destroy(handle: QTapAndHoldGestureH); cdecl; external Qt5PasLib name 'QTapAndHoldGesture_Destroy'; 
procedure QTapAndHoldGesture_position(handle: QTapAndHoldGestureH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QTapAndHoldGesture_position';
procedure QTapAndHoldGesture_setPosition(handle: QTapAndHoldGestureH; pos: PQtPointF); cdecl; external Qt5PasLib name 'QTapAndHoldGesture_setPosition';
procedure QTapAndHoldGesture_setTimeout(msecs: Integer); cdecl; external Qt5PasLib name 'QTapAndHoldGesture_setTimeout';
function QTapAndHoldGesture_timeout(): Integer; cdecl; external Qt5PasLib name 'QTapAndHoldGesture_timeout';

function QGestureEvent_Create(gestures: PPtrIntArray): QGestureEventH; cdecl; external Qt5PasLib name 'QGestureEvent_Create';
procedure QGestureEvent_Destroy(handle: QGestureEventH); cdecl; external Qt5PasLib name 'QGestureEvent_Destroy'; 
procedure QGestureEvent_gestures(handle: QGestureEventH; retval: PPtrIntArray); cdecl; external Qt5PasLib name 'QGestureEvent_gestures';
function QGestureEvent_gesture(handle: QGestureEventH; _type: QtGestureType): QGestureH; cdecl; external Qt5PasLib name 'QGestureEvent_gesture';
procedure QGestureEvent_activeGestures(handle: QGestureEventH; retval: PPtrIntArray); cdecl; external Qt5PasLib name 'QGestureEvent_activeGestures';
procedure QGestureEvent_canceledGestures(handle: QGestureEventH; retval: PPtrIntArray); cdecl; external Qt5PasLib name 'QGestureEvent_canceledGestures';
procedure QGestureEvent_setAccepted(handle: QGestureEventH; AnonParam1: QGestureH; AnonParam2: Boolean); cdecl; external Qt5PasLib name 'QGestureEvent_setAccepted';
procedure QGestureEvent_accept(handle: QGestureEventH; AnonParam1: QGestureH); cdecl; external Qt5PasLib name 'QGestureEvent_accept';
procedure QGestureEvent_ignore(handle: QGestureEventH; AnonParam1: QGestureH); cdecl; external Qt5PasLib name 'QGestureEvent_ignore';
function QGestureEvent_isAccepted(handle: QGestureEventH; AnonParam1: QGestureH): Boolean; cdecl; external Qt5PasLib name 'QGestureEvent_isAccepted';
procedure QGestureEvent_setAccepted(handle: QGestureEventH; AnonParam1: QtGestureType; AnonParam2: Boolean); cdecl; external Qt5PasLib name 'QGestureEvent_setAccepted2';
procedure QGestureEvent_accept(handle: QGestureEventH; AnonParam1: QtGestureType); cdecl; external Qt5PasLib name 'QGestureEvent_accept2';
procedure QGestureEvent_ignore(handle: QGestureEventH; AnonParam1: QtGestureType); cdecl; external Qt5PasLib name 'QGestureEvent_ignore2';
function QGestureEvent_isAccepted(handle: QGestureEventH; AnonParam1: QtGestureType): Boolean; cdecl; external Qt5PasLib name 'QGestureEvent_isAccepted2';
procedure QGestureEvent_setWidget(handle: QGestureEventH; widget: QWidgetH); cdecl; external Qt5PasLib name 'QGestureEvent_setWidget';
function QGestureEvent_widget(handle: QGestureEventH): QWidgetH; cdecl; external Qt5PasLib name 'QGestureEvent_widget';
procedure QGestureEvent_mapToGraphicsScene(handle: QGestureEventH; retval: PQtPointF; gesturePoint: PQtPointF); cdecl; external Qt5PasLib name 'QGestureEvent_mapToGraphicsScene';

type
  QGestureRecognizerResultFlag = cardinal; // QGestureRecognizer::ResultFlag
  QGestureRecognizerResult = QGestureRecognizerResultFlag; //QFlags<> (3)
const
  QGestureRecognizerIgnore =   $0001;
  QGestureRecognizerMayBeGesture =   $0002;
  QGestureRecognizerTriggerGesture =   $0004;
  QGestureRecognizerFinishGesture =   $0008;
  QGestureRecognizerCancelGesture =   $0010;
  QGestureRecognizerResultState_Mask =   $00ff;
  QGestureRecognizerConsumeEventHint =   $0100;
  QGestureRecognizerResultHint_Mask =   $ff00;

function QGestureRecognizer_create(handle: QGestureRecognizerH; target: QObjectH): QGestureH; cdecl; external Qt5PasLib name 'QGestureRecognizer_create';
function QGestureRecognizer_recognize(handle: QGestureRecognizerH; state: QGestureH; watched: QObjectH; event: QEventH): QGestureRecognizerResult; cdecl; external Qt5PasLib name 'QGestureRecognizer_recognize';
procedure QGestureRecognizer_reset(handle: QGestureRecognizerH; state: QGestureH); cdecl; external Qt5PasLib name 'QGestureRecognizer_reset';
function QGestureRecognizer_registerRecognizer(recognizer: QGestureRecognizerH): QtGestureType; cdecl; external Qt5PasLib name 'QGestureRecognizer_registerRecognizer';
procedure QGestureRecognizer_unregisterRecognizer(_type: QtGestureType); cdecl; external Qt5PasLib name 'QGestureRecognizer_unregisterRecognizer';


type
  QColorSpec = ( // QColor::Spec (1)
    QColorInvalid, QColorRgb, QColorHsv, QColorCmyk, QColorHsl );

function QColor_Create(): QColorH; cdecl; external Qt5PasLib name 'QColor_Create';
procedure QColor_Destroy(handle: QColorH); cdecl; external Qt5PasLib name 'QColor_Destroy'; 
function QColor_Create(color: QtGlobalColor): QColorH; cdecl; external Qt5PasLib name 'QColor_Create2';
function QColor_Create(r: Integer; g: Integer; b: Integer; a: Integer = 255): QColorH; cdecl; external Qt5PasLib name 'QColor_Create3';
function QColor_Create(rgb: QRgb): QColorH; cdecl; external Qt5PasLib name 'QColor_Create4';
function QColor_Create(name: PWideString): QColorH; cdecl; external Qt5PasLib name 'QColor_Create5';
function QColor_Create(name: PAnsiChar): QColorH; cdecl; external Qt5PasLib name 'QColor_Create6';
function QColor_Create(color: PQColor): QColorH; cdecl; external Qt5PasLib name 'QColor_Create7';
function QColor_Create(spec: QColorSpec): QColorH; cdecl; external Qt5PasLib name 'QColor_Create8';
function QColor_isValid(handle: QColorH): Boolean; cdecl; external Qt5PasLib name 'QColor_isValid';
procedure QColor_name(handle: QColorH; retval: PWideString); cdecl; external Qt5PasLib name 'QColor_name';
procedure QColor_setNamedColor(handle: QColorH; name: PWideString); cdecl; external Qt5PasLib name 'QColor_setNamedColor';
procedure QColor_colorNames(retval: QStringListH); cdecl; external Qt5PasLib name 'QColor_colorNames';
function QColor_spec(handle: QColorH): QColorSpec; cdecl; external Qt5PasLib name 'QColor_spec';
function QColor_alpha(handle: QColorH): Integer; cdecl; external Qt5PasLib name 'QColor_alpha';
procedure QColor_setAlpha(handle: QColorH; alpha: Integer); cdecl; external Qt5PasLib name 'QColor_setAlpha';
function QColor_alphaF(handle: QColorH): qreal; cdecl; external Qt5PasLib name 'QColor_alphaF';
procedure QColor_setAlphaF(handle: QColorH; alpha: qreal); cdecl; external Qt5PasLib name 'QColor_setAlphaF';
function QColor_red(handle: QColorH): Integer; cdecl; external Qt5PasLib name 'QColor_red';
function QColor_green(handle: QColorH): Integer; cdecl; external Qt5PasLib name 'QColor_green';
function QColor_blue(handle: QColorH): Integer; cdecl; external Qt5PasLib name 'QColor_blue';
procedure QColor_setRed(handle: QColorH; red: Integer); cdecl; external Qt5PasLib name 'QColor_setRed';
procedure QColor_setGreen(handle: QColorH; green: Integer); cdecl; external Qt5PasLib name 'QColor_setGreen';
procedure QColor_setBlue(handle: QColorH; blue: Integer); cdecl; external Qt5PasLib name 'QColor_setBlue';
function QColor_redF(handle: QColorH): qreal; cdecl; external Qt5PasLib name 'QColor_redF';
function QColor_greenF(handle: QColorH): qreal; cdecl; external Qt5PasLib name 'QColor_greenF';
function QColor_blueF(handle: QColorH): qreal; cdecl; external Qt5PasLib name 'QColor_blueF';
procedure QColor_setRedF(handle: QColorH; red: qreal); cdecl; external Qt5PasLib name 'QColor_setRedF';
procedure QColor_setGreenF(handle: QColorH; green: qreal); cdecl; external Qt5PasLib name 'QColor_setGreenF';
procedure QColor_setBlueF(handle: QColorH; blue: qreal); cdecl; external Qt5PasLib name 'QColor_setBlueF';
procedure QColor_getRgb(handle: QColorH; r: PInteger; g: PInteger; b: PInteger; a: PInteger = nil); cdecl; external Qt5PasLib name 'QColor_getRgb';
procedure QColor_setRgb(handle: QColorH; r: Integer; g: Integer; b: Integer; a: Integer = 255); cdecl; external Qt5PasLib name 'QColor_setRgb';
procedure QColor_getRgbF(handle: QColorH; r: PQReal; g: PQReal; b: PQReal; a: PQReal = nil); cdecl; external Qt5PasLib name 'QColor_getRgbF';
procedure QColor_setRgbF(handle: QColorH; r: qreal; g: qreal; b: qreal; a: qreal = 1.0); cdecl; external Qt5PasLib name 'QColor_setRgbF';
function QColor_rgba(handle: QColorH): QRgb; cdecl; external Qt5PasLib name 'QColor_rgba';
procedure QColor_setRgba(handle: QColorH; rgba: QRgb); cdecl; external Qt5PasLib name 'QColor_setRgba';
function QColor_rgb(handle: QColorH): QRgb; cdecl; external Qt5PasLib name 'QColor_rgb';
procedure QColor_setRgb(handle: QColorH; rgb: QRgb); cdecl; external Qt5PasLib name 'QColor_setRgb2';
function QColor_hue(handle: QColorH): Integer; cdecl; external Qt5PasLib name 'QColor_hue';
function QColor_saturation(handle: QColorH): Integer; cdecl; external Qt5PasLib name 'QColor_saturation';
function QColor_hsvHue(handle: QColorH): Integer; cdecl; external Qt5PasLib name 'QColor_hsvHue';
function QColor_hsvSaturation(handle: QColorH): Integer; cdecl; external Qt5PasLib name 'QColor_hsvSaturation';
function QColor_value(handle: QColorH): Integer; cdecl; external Qt5PasLib name 'QColor_value';
function QColor_hueF(handle: QColorH): qreal; cdecl; external Qt5PasLib name 'QColor_hueF';
function QColor_saturationF(handle: QColorH): qreal; cdecl; external Qt5PasLib name 'QColor_saturationF';
function QColor_hsvHueF(handle: QColorH): qreal; cdecl; external Qt5PasLib name 'QColor_hsvHueF';
function QColor_hsvSaturationF(handle: QColorH): qreal; cdecl; external Qt5PasLib name 'QColor_hsvSaturationF';
function QColor_valueF(handle: QColorH): qreal; cdecl; external Qt5PasLib name 'QColor_valueF';
procedure QColor_getHsv(handle: QColorH; h: PInteger; s: PInteger; v: PInteger; a: PInteger = nil); cdecl; external Qt5PasLib name 'QColor_getHsv';
procedure QColor_setHsv(handle: QColorH; h: Integer; s: Integer; v: Integer; a: Integer = 255); cdecl; external Qt5PasLib name 'QColor_setHsv';
procedure QColor_getHsvF(handle: QColorH; h: PQReal; s: PQReal; v: PQReal; a: PQReal = nil); cdecl; external Qt5PasLib name 'QColor_getHsvF';
procedure QColor_setHsvF(handle: QColorH; h: qreal; s: qreal; v: qreal; a: qreal = 1.0); cdecl; external Qt5PasLib name 'QColor_setHsvF';
function QColor_cyan(handle: QColorH): Integer; cdecl; external Qt5PasLib name 'QColor_cyan';
function QColor_magenta(handle: QColorH): Integer; cdecl; external Qt5PasLib name 'QColor_magenta';
function QColor_yellow(handle: QColorH): Integer; cdecl; external Qt5PasLib name 'QColor_yellow';
function QColor_black(handle: QColorH): Integer; cdecl; external Qt5PasLib name 'QColor_black';
function QColor_cyanF(handle: QColorH): qreal; cdecl; external Qt5PasLib name 'QColor_cyanF';
function QColor_magentaF(handle: QColorH): qreal; cdecl; external Qt5PasLib name 'QColor_magentaF';
function QColor_yellowF(handle: QColorH): qreal; cdecl; external Qt5PasLib name 'QColor_yellowF';
function QColor_blackF(handle: QColorH): qreal; cdecl; external Qt5PasLib name 'QColor_blackF';
procedure QColor_getCmyk(handle: QColorH; c: PInteger; m: PInteger; y: PInteger; k: PInteger; a: PInteger = nil); cdecl; external Qt5PasLib name 'QColor_getCmyk';
procedure QColor_setCmyk(handle: QColorH; c: Integer; m: Integer; y: Integer; k: Integer; a: Integer = 255); cdecl; external Qt5PasLib name 'QColor_setCmyk';
procedure QColor_getCmykF(handle: QColorH; c: PQReal; m: PQReal; y: PQReal; k: PQReal; a: PQReal = nil); cdecl; external Qt5PasLib name 'QColor_getCmykF';
procedure QColor_setCmykF(handle: QColorH; c: qreal; m: qreal; y: qreal; k: qreal; a: qreal = 1.0); cdecl; external Qt5PasLib name 'QColor_setCmykF';
function QColor_hslHue(handle: QColorH): Integer; cdecl; external Qt5PasLib name 'QColor_hslHue';
function QColor_hslSaturation(handle: QColorH): Integer; cdecl; external Qt5PasLib name 'QColor_hslSaturation';
function QColor_lightness(handle: QColorH): Integer; cdecl; external Qt5PasLib name 'QColor_lightness';
function QColor_hslHueF(handle: QColorH): qreal; cdecl; external Qt5PasLib name 'QColor_hslHueF';
function QColor_hslSaturationF(handle: QColorH): qreal; cdecl; external Qt5PasLib name 'QColor_hslSaturationF';
function QColor_lightnessF(handle: QColorH): qreal; cdecl; external Qt5PasLib name 'QColor_lightnessF';
procedure QColor_getHsl(handle: QColorH; h: PInteger; s: PInteger; l: PInteger; a: PInteger = nil); cdecl; external Qt5PasLib name 'QColor_getHsl';
procedure QColor_setHsl(handle: QColorH; h: Integer; s: Integer; l: Integer; a: Integer = 255); cdecl; external Qt5PasLib name 'QColor_setHsl';
procedure QColor_getHslF(handle: QColorH; h: PQReal; s: PQReal; l: PQReal; a: PQReal = nil); cdecl; external Qt5PasLib name 'QColor_getHslF';
procedure QColor_setHslF(handle: QColorH; h: qreal; s: qreal; l: qreal; a: qreal = 1.0); cdecl; external Qt5PasLib name 'QColor_setHslF';
procedure QColor_toRgb(handle: QColorH; retval: PQColor); cdecl; external Qt5PasLib name 'QColor_toRgb';
procedure QColor_toHsv(handle: QColorH; retval: PQColor); cdecl; external Qt5PasLib name 'QColor_toHsv';
procedure QColor_toCmyk(handle: QColorH; retval: PQColor); cdecl; external Qt5PasLib name 'QColor_toCmyk';
procedure QColor_toHsl(handle: QColorH; retval: PQColor); cdecl; external Qt5PasLib name 'QColor_toHsl';
procedure QColor_convertTo(handle: QColorH; retval: PQColor; colorSpec: QColorSpec); cdecl; external Qt5PasLib name 'QColor_convertTo';
procedure QColor_fromRgb(retval: PQColor; rgb: QRgb); cdecl; external Qt5PasLib name 'QColor_fromRgb';
procedure QColor_fromRgba(retval: PQColor; rgba: QRgb); cdecl; external Qt5PasLib name 'QColor_fromRgba';
procedure QColor_fromRgb(retval: PQColor; r: Integer; g: Integer; b: Integer; a: Integer = 255); cdecl; external Qt5PasLib name 'QColor_fromRgb2';
procedure QColor_fromRgbF(retval: PQColor; r: qreal; g: qreal; b: qreal; a: qreal = 1.0); cdecl; external Qt5PasLib name 'QColor_fromRgbF';
procedure QColor_fromHsv(retval: PQColor; h: Integer; s: Integer; v: Integer; a: Integer = 255); cdecl; external Qt5PasLib name 'QColor_fromHsv';
procedure QColor_fromHsvF(retval: PQColor; h: qreal; s: qreal; v: qreal; a: qreal = 1.0); cdecl; external Qt5PasLib name 'QColor_fromHsvF';
procedure QColor_fromCmyk(retval: PQColor; c: Integer; m: Integer; y: Integer; k: Integer; a: Integer = 255); cdecl; external Qt5PasLib name 'QColor_fromCmyk';
procedure QColor_fromCmykF(retval: PQColor; c: qreal; m: qreal; y: qreal; k: qreal; a: qreal = 1.0); cdecl; external Qt5PasLib name 'QColor_fromCmykF';
procedure QColor_fromHsl(retval: PQColor; h: Integer; s: Integer; l: Integer; a: Integer = 255); cdecl; external Qt5PasLib name 'QColor_fromHsl';
procedure QColor_fromHslF(retval: PQColor; h: qreal; s: qreal; l: qreal; a: qreal = 1.0); cdecl; external Qt5PasLib name 'QColor_fromHslF';
procedure QColor_light(handle: QColorH; retval: PQColor; f: Integer = 150); cdecl; external Qt5PasLib name 'QColor_light';
procedure QColor_lighter(handle: QColorH; retval: PQColor; f: Integer = 150); cdecl; external Qt5PasLib name 'QColor_lighter';
procedure QColor_dark(handle: QColorH; retval: PQColor; f: Integer = 200); cdecl; external Qt5PasLib name 'QColor_dark';
procedure QColor_darker(handle: QColorH; retval: PQColor; f: Integer = 200); cdecl; external Qt5PasLib name 'QColor_darker';
function QColor_isValidColor(name: PWideString): Boolean; cdecl; external Qt5PasLib name 'QColor_isValidColor';

function QMatrix_Create(AnonParam1: QtInitialization): QMatrixH; cdecl; external Qt5PasLib name 'QMatrix_Create';
procedure QMatrix_Destroy(handle: QMatrixH); cdecl; external Qt5PasLib name 'QMatrix_Destroy'; 
function QMatrix_Create(): QMatrixH; cdecl; external Qt5PasLib name 'QMatrix_Create2';
function QMatrix_Create(m11: qreal; m12: qreal; m21: qreal; m22: qreal; dx: qreal; dy: qreal): QMatrixH; cdecl; external Qt5PasLib name 'QMatrix_Create3';
function QMatrix_Create(matrix: QMatrixH): QMatrixH; cdecl; external Qt5PasLib name 'QMatrix_Create4';
procedure QMatrix_setMatrix(handle: QMatrixH; m11: qreal; m12: qreal; m21: qreal; m22: qreal; dx: qreal; dy: qreal); cdecl; external Qt5PasLib name 'QMatrix_setMatrix';
function QMatrix_m11(handle: QMatrixH): qreal; cdecl; external Qt5PasLib name 'QMatrix_m11';
function QMatrix_m12(handle: QMatrixH): qreal; cdecl; external Qt5PasLib name 'QMatrix_m12';
function QMatrix_m21(handle: QMatrixH): qreal; cdecl; external Qt5PasLib name 'QMatrix_m21';
function QMatrix_m22(handle: QMatrixH): qreal; cdecl; external Qt5PasLib name 'QMatrix_m22';
function QMatrix_dx(handle: QMatrixH): qreal; cdecl; external Qt5PasLib name 'QMatrix_dx';
function QMatrix_dy(handle: QMatrixH): qreal; cdecl; external Qt5PasLib name 'QMatrix_dy';
procedure QMatrix_map(handle: QMatrixH; x: Integer; y: Integer; tx: PInteger; ty: PInteger); cdecl; external Qt5PasLib name 'QMatrix_map';
procedure QMatrix_map(handle: QMatrixH; x: qreal; y: qreal; tx: PQReal; ty: PQReal); cdecl; external Qt5PasLib name 'QMatrix_map2';
procedure QMatrix_mapRect(handle: QMatrixH; retval: PRect; AnonParam1: PRect); cdecl; external Qt5PasLib name 'QMatrix_mapRect';
procedure QMatrix_mapRect(handle: QMatrixH; retval: QRectFH; AnonParam1: QRectFH); cdecl; external Qt5PasLib name 'QMatrix_mapRect2';
procedure QMatrix_map(handle: QMatrixH; retval: PQtPoint; p: PQtPoint); cdecl; external Qt5PasLib name 'QMatrix_map3';
procedure QMatrix_map(handle: QMatrixH; retval: PQtPointF; p: PQtPointF); cdecl; external Qt5PasLib name 'QMatrix_map4';
procedure QMatrix_map(handle: QMatrixH; retval: QLineH; l: QLineH); cdecl; external Qt5PasLib name 'QMatrix_map5';
procedure QMatrix_map(handle: QMatrixH; retval: QLineFH; l: QLineFH); cdecl; external Qt5PasLib name 'QMatrix_map6';
procedure QMatrix_map(handle: QMatrixH; retval: QPolygonFH; a: QPolygonFH); cdecl; external Qt5PasLib name 'QMatrix_map7';
procedure QMatrix_map(handle: QMatrixH; retval: QPolygonH; a: QPolygonH); cdecl; external Qt5PasLib name 'QMatrix_map8';
procedure QMatrix_map(handle: QMatrixH; retval: QRegionH; r: QRegionH); cdecl; external Qt5PasLib name 'QMatrix_map9';
procedure QMatrix_map(handle: QMatrixH; retval: QPainterPathH; p: QPainterPathH); cdecl; external Qt5PasLib name 'QMatrix_map10';
procedure QMatrix_mapToPolygon(handle: QMatrixH; retval: QPolygonH; r: PRect); cdecl; external Qt5PasLib name 'QMatrix_mapToPolygon';
procedure QMatrix_reset(handle: QMatrixH); cdecl; external Qt5PasLib name 'QMatrix_reset';
function QMatrix_isIdentity(handle: QMatrixH): Boolean; cdecl; external Qt5PasLib name 'QMatrix_isIdentity';
function QMatrix_translate(handle: QMatrixH; dx: qreal; dy: qreal): QMatrixH; cdecl; external Qt5PasLib name 'QMatrix_translate';
function QMatrix_scale(handle: QMatrixH; sx: qreal; sy: qreal): QMatrixH; cdecl; external Qt5PasLib name 'QMatrix_scale';
function QMatrix_shear(handle: QMatrixH; sh: qreal; sv: qreal): QMatrixH; cdecl; external Qt5PasLib name 'QMatrix_shear';
function QMatrix_rotate(handle: QMatrixH; a: qreal): QMatrixH; cdecl; external Qt5PasLib name 'QMatrix_rotate';
function QMatrix_isInvertible(handle: QMatrixH): Boolean; cdecl; external Qt5PasLib name 'QMatrix_isInvertible';
function QMatrix_determinant(handle: QMatrixH): qreal; cdecl; external Qt5PasLib name 'QMatrix_determinant';
procedure QMatrix_inverted(handle: QMatrixH; retval: QMatrixH; invertible: PBoolean = nil); cdecl; external Qt5PasLib name 'QMatrix_inverted';


type
  QGradientType = ( // QGradient::Type (1)
    QGradientLinearGradient, QGradientRadialGradient, QGradientConicalGradient, QGradientNoGradient );

  QGradientSpread = ( // QGradient::Spread (1)
    QGradientPadSpread, QGradientReflectSpread, QGradientRepeatSpread );

  QGradientCoordinateMode = ( // QGradient::CoordinateMode (1)
    QGradientLogicalMode, QGradientStretchToDeviceMode, QGradientObjectBoundingMode );

  QGradientInterpolationMode = ( // QGradient::InterpolationMode (1)
    QGradientColorInterpolation, QGradientComponentInterpolation );

function QBrush_Create(): QBrushH; cdecl; external Qt5PasLib name 'QBrush_Create';
procedure QBrush_Destroy(handle: QBrushH); cdecl; external Qt5PasLib name 'QBrush_Destroy'; 
function QBrush_Create(bs: QtBrushStyle): QBrushH; cdecl; external Qt5PasLib name 'QBrush_Create2';
function QBrush_Create(color: PQColor; bs: QtBrushStyle = QtSolidPattern): QBrushH; cdecl; external Qt5PasLib name 'QBrush_Create3';
function QBrush_Create(color: QtGlobalColor; bs: QtBrushStyle = QtSolidPattern): QBrushH; cdecl; external Qt5PasLib name 'QBrush_Create4';
function QBrush_Create(color: PQColor; pixmap: QPixmapH): QBrushH; cdecl; external Qt5PasLib name 'QBrush_Create5';
function QBrush_Create(color: QtGlobalColor; pixmap: QPixmapH): QBrushH; cdecl; external Qt5PasLib name 'QBrush_Create6';
function QBrush_Create(pixmap: QPixmapH): QBrushH; cdecl; external Qt5PasLib name 'QBrush_Create7';
function QBrush_Create(image: QImageH): QBrushH; cdecl; external Qt5PasLib name 'QBrush_Create8';
function QBrush_Create(brush: QBrushH): QBrushH; cdecl; external Qt5PasLib name 'QBrush_Create9';
function QBrush_Create(gradient: QGradientH): QBrushH; cdecl; external Qt5PasLib name 'QBrush_Create10';
procedure QBrush_swap(handle: QBrushH; other: QBrushH); cdecl; external Qt5PasLib name 'QBrush_swap';
function QBrush_style(handle: QBrushH): QtBrushStyle; cdecl; external Qt5PasLib name 'QBrush_style';
procedure QBrush_setStyle(handle: QBrushH; AnonParam1: QtBrushStyle); cdecl; external Qt5PasLib name 'QBrush_setStyle';
function QBrush_matrix(handle: QBrushH): QMatrixH; cdecl; external Qt5PasLib name 'QBrush_matrix';
procedure QBrush_setMatrix(handle: QBrushH; mat: QMatrixH); cdecl; external Qt5PasLib name 'QBrush_setMatrix';
procedure QBrush_transform(handle: QBrushH; retval: QTransformH); cdecl; external Qt5PasLib name 'QBrush_transform';
procedure QBrush_setTransform(handle: QBrushH; AnonParam1: QTransformH); cdecl; external Qt5PasLib name 'QBrush_setTransform';
procedure QBrush_texture(handle: QBrushH; retval: QPixmapH); cdecl; external Qt5PasLib name 'QBrush_texture';
procedure QBrush_setTexture(handle: QBrushH; pixmap: QPixmapH); cdecl; external Qt5PasLib name 'QBrush_setTexture';
procedure QBrush_textureImage(handle: QBrushH; retval: QImageH); cdecl; external Qt5PasLib name 'QBrush_textureImage';
procedure QBrush_setTextureImage(handle: QBrushH; image: QImageH); cdecl; external Qt5PasLib name 'QBrush_setTextureImage';
function QBrush_color(handle: QBrushH): PQColor; cdecl; external Qt5PasLib name 'QBrush_color';
procedure QBrush_setColor(handle: QBrushH; color: PQColor); cdecl; external Qt5PasLib name 'QBrush_setColor';
procedure QBrush_setColor(handle: QBrushH; color: QtGlobalColor); cdecl; external Qt5PasLib name 'QBrush_setColor2';
function QBrush_gradient(handle: QBrushH): QGradientH; cdecl; external Qt5PasLib name 'QBrush_gradient';
function QBrush_isOpaque(handle: QBrushH): Boolean; cdecl; external Qt5PasLib name 'QBrush_isOpaque';
function QBrush_isDetached(handle: QBrushH): Boolean; cdecl; external Qt5PasLib name 'QBrush_isDetached';

function QGradient_Create(): QGradientH; cdecl; external Qt5PasLib name 'QGradient_Create';
procedure QGradient_Destroy(handle: QGradientH); cdecl; external Qt5PasLib name 'QGradient_Destroy'; 
function QGradient_type(handle: QGradientH): QGradientType; cdecl; external Qt5PasLib name 'QGradient_type';
procedure QGradient_setSpread(handle: QGradientH; spread: QGradientSpread); cdecl; external Qt5PasLib name 'QGradient_setSpread';
function QGradient_spread(handle: QGradientH): QGradientSpread; cdecl; external Qt5PasLib name 'QGradient_spread';
procedure QGradient_setColorAt(handle: QGradientH; pos: qreal; color: PQColor); cdecl; external Qt5PasLib name 'QGradient_setColorAt';
function QGradient_coordinateMode(handle: QGradientH): QGradientCoordinateMode; cdecl; external Qt5PasLib name 'QGradient_coordinateMode';
procedure QGradient_setCoordinateMode(handle: QGradientH; mode: QGradientCoordinateMode); cdecl; external Qt5PasLib name 'QGradient_setCoordinateMode';
function QGradient_interpolationMode(handle: QGradientH): QGradientInterpolationMode; cdecl; external Qt5PasLib name 'QGradient_interpolationMode';
procedure QGradient_setInterpolationMode(handle: QGradientH; mode: QGradientInterpolationMode); cdecl; external Qt5PasLib name 'QGradient_setInterpolationMode';

function QLinearGradient_Create(): QLinearGradientH; cdecl; external Qt5PasLib name 'QLinearGradient_Create';
procedure QLinearGradient_Destroy(handle: QLinearGradientH); cdecl; external Qt5PasLib name 'QLinearGradient_Destroy'; 
function QLinearGradient_Create(start: PQtPointF; finalStop: PQtPointF): QLinearGradientH; cdecl; external Qt5PasLib name 'QLinearGradient_Create2';
function QLinearGradient_Create(xStart: qreal; yStart: qreal; xFinalStop: qreal; yFinalStop: qreal): QLinearGradientH; cdecl; external Qt5PasLib name 'QLinearGradient_Create3';
procedure QLinearGradient_start(handle: QLinearGradientH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QLinearGradient_start';
procedure QLinearGradient_setStart(handle: QLinearGradientH; start: PQtPointF); cdecl; external Qt5PasLib name 'QLinearGradient_setStart';
procedure QLinearGradient_setStart(handle: QLinearGradientH; x: qreal; y: qreal); cdecl; external Qt5PasLib name 'QLinearGradient_setStart2';
procedure QLinearGradient_finalStop(handle: QLinearGradientH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QLinearGradient_finalStop';
procedure QLinearGradient_setFinalStop(handle: QLinearGradientH; stop: PQtPointF); cdecl; external Qt5PasLib name 'QLinearGradient_setFinalStop';
procedure QLinearGradient_setFinalStop(handle: QLinearGradientH; x: qreal; y: qreal); cdecl; external Qt5PasLib name 'QLinearGradient_setFinalStop2';

function QRadialGradient_Create(): QRadialGradientH; cdecl; external Qt5PasLib name 'QRadialGradient_Create';
procedure QRadialGradient_Destroy(handle: QRadialGradientH); cdecl; external Qt5PasLib name 'QRadialGradient_Destroy'; 
function QRadialGradient_Create(center: PQtPointF; radius: qreal; focalPoint: PQtPointF): QRadialGradientH; cdecl; external Qt5PasLib name 'QRadialGradient_Create2';
function QRadialGradient_Create(cx: qreal; cy: qreal; radius: qreal; fx: qreal; fy: qreal): QRadialGradientH; cdecl; external Qt5PasLib name 'QRadialGradient_Create3';
function QRadialGradient_Create(center: PQtPointF; radius: qreal): QRadialGradientH; cdecl; external Qt5PasLib name 'QRadialGradient_Create4';
function QRadialGradient_Create(cx: qreal; cy: qreal; radius: qreal): QRadialGradientH; cdecl; external Qt5PasLib name 'QRadialGradient_Create5';
function QRadialGradient_Create(center: PQtPointF; centerRadius: qreal; focalPoint: PQtPointF; focalRadius: qreal): QRadialGradientH; cdecl; external Qt5PasLib name 'QRadialGradient_Create6';
function QRadialGradient_Create(cx: qreal; cy: qreal; centerRadius: qreal; fx: qreal; fy: qreal; focalRadius: qreal): QRadialGradientH; cdecl; external Qt5PasLib name 'QRadialGradient_Create7';
procedure QRadialGradient_center(handle: QRadialGradientH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QRadialGradient_center';
procedure QRadialGradient_setCenter(handle: QRadialGradientH; center: PQtPointF); cdecl; external Qt5PasLib name 'QRadialGradient_setCenter';
procedure QRadialGradient_setCenter(handle: QRadialGradientH; x: qreal; y: qreal); cdecl; external Qt5PasLib name 'QRadialGradient_setCenter2';
procedure QRadialGradient_focalPoint(handle: QRadialGradientH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QRadialGradient_focalPoint';
procedure QRadialGradient_setFocalPoint(handle: QRadialGradientH; focalPoint: PQtPointF); cdecl; external Qt5PasLib name 'QRadialGradient_setFocalPoint';
procedure QRadialGradient_setFocalPoint(handle: QRadialGradientH; x: qreal; y: qreal); cdecl; external Qt5PasLib name 'QRadialGradient_setFocalPoint2';
function QRadialGradient_radius(handle: QRadialGradientH): qreal; cdecl; external Qt5PasLib name 'QRadialGradient_radius';
procedure QRadialGradient_setRadius(handle: QRadialGradientH; radius: qreal); cdecl; external Qt5PasLib name 'QRadialGradient_setRadius';
function QRadialGradient_centerRadius(handle: QRadialGradientH): qreal; cdecl; external Qt5PasLib name 'QRadialGradient_centerRadius';
procedure QRadialGradient_setCenterRadius(handle: QRadialGradientH; radius: qreal); cdecl; external Qt5PasLib name 'QRadialGradient_setCenterRadius';
function QRadialGradient_focalRadius(handle: QRadialGradientH): qreal; cdecl; external Qt5PasLib name 'QRadialGradient_focalRadius';
procedure QRadialGradient_setFocalRadius(handle: QRadialGradientH; radius: qreal); cdecl; external Qt5PasLib name 'QRadialGradient_setFocalRadius';

function QConicalGradient_Create(): QConicalGradientH; cdecl; external Qt5PasLib name 'QConicalGradient_Create';
procedure QConicalGradient_Destroy(handle: QConicalGradientH); cdecl; external Qt5PasLib name 'QConicalGradient_Destroy'; 
function QConicalGradient_Create(center: PQtPointF; startAngle: qreal): QConicalGradientH; cdecl; external Qt5PasLib name 'QConicalGradient_Create2';
function QConicalGradient_Create(cx: qreal; cy: qreal; startAngle: qreal): QConicalGradientH; cdecl; external Qt5PasLib name 'QConicalGradient_Create3';
procedure QConicalGradient_center(handle: QConicalGradientH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QConicalGradient_center';
procedure QConicalGradient_setCenter(handle: QConicalGradientH; center: PQtPointF); cdecl; external Qt5PasLib name 'QConicalGradient_setCenter';
procedure QConicalGradient_setCenter(handle: QConicalGradientH; x: qreal; y: qreal); cdecl; external Qt5PasLib name 'QConicalGradient_setCenter2';
function QConicalGradient_angle(handle: QConicalGradientH): qreal; cdecl; external Qt5PasLib name 'QConicalGradient_angle';
procedure QConicalGradient_setAngle(handle: QConicalGradientH; angle: qreal); cdecl; external Qt5PasLib name 'QConicalGradient_setAngle';

function QPen_Create(): QPenH; cdecl; external Qt5PasLib name 'QPen_Create';
procedure QPen_Destroy(handle: QPenH); cdecl; external Qt5PasLib name 'QPen_Destroy'; 
function QPen_Create(AnonParam1: QtPenStyle): QPenH; cdecl; external Qt5PasLib name 'QPen_Create2';
function QPen_Create(color: PQColor): QPenH; cdecl; external Qt5PasLib name 'QPen_Create3';
function QPen_Create(brush: QBrushH; width: qreal; s: QtPenStyle = QtSolidLine; c: QtPenCapStyle = QtSquareCap; j: QtPenJoinStyle = QtBevelJoin): QPenH; cdecl; external Qt5PasLib name 'QPen_Create4';
function QPen_Create(pen: QPenH): QPenH; cdecl; external Qt5PasLib name 'QPen_Create5';
procedure QPen_swap(handle: QPenH; other: QPenH); cdecl; external Qt5PasLib name 'QPen_swap';
function QPen_style(handle: QPenH): QtPenStyle; cdecl; external Qt5PasLib name 'QPen_style';
procedure QPen_setStyle(handle: QPenH; AnonParam1: QtPenStyle); cdecl; external Qt5PasLib name 'QPen_setStyle';
procedure QPen_dashPattern(handle: QPenH; retval: PQRealArray); cdecl; external Qt5PasLib name 'QPen_dashPattern';
procedure QPen_setDashPattern(handle: QPenH; pattern: PQRealArray); cdecl; external Qt5PasLib name 'QPen_setDashPattern';
function QPen_dashOffset(handle: QPenH): qreal; cdecl; external Qt5PasLib name 'QPen_dashOffset';
procedure QPen_setDashOffset(handle: QPenH; doffset: qreal); cdecl; external Qt5PasLib name 'QPen_setDashOffset';
function QPen_miterLimit(handle: QPenH): qreal; cdecl; external Qt5PasLib name 'QPen_miterLimit';
procedure QPen_setMiterLimit(handle: QPenH; limit: qreal); cdecl; external Qt5PasLib name 'QPen_setMiterLimit';
function QPen_widthF(handle: QPenH): qreal; cdecl; external Qt5PasLib name 'QPen_widthF';
procedure QPen_setWidthF(handle: QPenH; width: qreal); cdecl; external Qt5PasLib name 'QPen_setWidthF';
function QPen_width(handle: QPenH): Integer; cdecl; external Qt5PasLib name 'QPen_width';
procedure QPen_setWidth(handle: QPenH; width: Integer); cdecl; external Qt5PasLib name 'QPen_setWidth';
procedure QPen_color(handle: QPenH; retval: PQColor); cdecl; external Qt5PasLib name 'QPen_color';
procedure QPen_setColor(handle: QPenH; color: PQColor); cdecl; external Qt5PasLib name 'QPen_setColor';
procedure QPen_brush(handle: QPenH; retval: QBrushH); cdecl; external Qt5PasLib name 'QPen_brush';
procedure QPen_setBrush(handle: QPenH; brush: QBrushH); cdecl; external Qt5PasLib name 'QPen_setBrush';
function QPen_isSolid(handle: QPenH): Boolean; cdecl; external Qt5PasLib name 'QPen_isSolid';
function QPen_capStyle(handle: QPenH): QtPenCapStyle; cdecl; external Qt5PasLib name 'QPen_capStyle';
procedure QPen_setCapStyle(handle: QPenH; pcs: QtPenCapStyle); cdecl; external Qt5PasLib name 'QPen_setCapStyle';
function QPen_joinStyle(handle: QPenH): QtPenJoinStyle; cdecl; external Qt5PasLib name 'QPen_joinStyle';
procedure QPen_setJoinStyle(handle: QPenH; pcs: QtPenJoinStyle); cdecl; external Qt5PasLib name 'QPen_setJoinStyle';
function QPen_isCosmetic(handle: QPenH): Boolean; cdecl; external Qt5PasLib name 'QPen_isCosmetic';
procedure QPen_setCosmetic(handle: QPenH; cosmetic: Boolean); cdecl; external Qt5PasLib name 'QPen_setCosmetic';
function QPen_isDetached(handle: QPenH): Boolean; cdecl; external Qt5PasLib name 'QPen_isDetached';

function QPolygon_Create(): QPolygonH; cdecl; external Qt5PasLib name 'QPolygon_Create';
procedure QPolygon_Destroy(handle: QPolygonH); cdecl; external Qt5PasLib name 'QPolygon_Destroy'; 
function QPolygon_Create(size: Integer): QPolygonH; cdecl; external Qt5PasLib name 'QPolygon_Create2';
function QPolygon_Create(a: QPolygonH): QPolygonH; cdecl; external Qt5PasLib name 'QPolygon_Create3';
function QPolygon_Create(r: PRect; closed: Boolean = False): QPolygonH; cdecl; external Qt5PasLib name 'QPolygon_Create4';
function QPolygon_Create(nPoints: Integer; points: PInteger): QPolygonH; cdecl; external Qt5PasLib name 'QPolygon_Create5';
procedure QPolygon_swap(handle: QPolygonH; other: QPolygonH); cdecl; external Qt5PasLib name 'QPolygon_swap';
procedure QPolygon_translate(handle: QPolygonH; dx: Integer; dy: Integer); cdecl; external Qt5PasLib name 'QPolygon_translate';
procedure QPolygon_translate(handle: QPolygonH; offset: PQtPoint); cdecl; external Qt5PasLib name 'QPolygon_translate2';
procedure QPolygon_translated(handle: QPolygonH; retval: QPolygonH; dx: Integer; dy: Integer); cdecl; external Qt5PasLib name 'QPolygon_translated';
procedure QPolygon_translated(handle: QPolygonH; retval: QPolygonH; offset: PQtPoint); cdecl; external Qt5PasLib name 'QPolygon_translated2';
procedure QPolygon_boundingRect(handle: QPolygonH; retval: PRect); cdecl; external Qt5PasLib name 'QPolygon_boundingRect';
procedure QPolygon_point(handle: QPolygonH; i: Integer; x: PInteger; y: PInteger); cdecl; external Qt5PasLib name 'QPolygon_point';
procedure QPolygon_point(handle: QPolygonH; retval: PQtPoint; i: Integer); cdecl; external Qt5PasLib name 'QPolygon_point2';
procedure QPolygon_setPoint(handle: QPolygonH; index: Integer; x: Integer; y: Integer); cdecl; external Qt5PasLib name 'QPolygon_setPoint';
procedure QPolygon_setPoint(handle: QPolygonH; index: Integer; p: PQtPoint); cdecl; external Qt5PasLib name 'QPolygon_setPoint2';
procedure QPolygon_setPoints(handle: QPolygonH; nPoints: Integer; points: PInteger); cdecl; external Qt5PasLib name 'QPolygon_setPoints';
procedure QPolygon_putPoints(handle: QPolygonH; index: Integer; nPoints: Integer; points: PInteger); cdecl; external Qt5PasLib name 'QPolygon_putPoints';
procedure QPolygon_putPoints(handle: QPolygonH; index: Integer; nPoints: Integer; from: QPolygonH; fromIndex: Integer = 0); cdecl; external Qt5PasLib name 'QPolygon_putPoints3';
function QPolygon_containsPoint(handle: QPolygonH; pt: PQtPoint; fillRule: QtFillRule): Boolean; cdecl; external Qt5PasLib name 'QPolygon_containsPoint';
procedure QPolygon_united(handle: QPolygonH; retval: QPolygonH; r: QPolygonH); cdecl; external Qt5PasLib name 'QPolygon_united';
procedure QPolygon_intersected(handle: QPolygonH; retval: QPolygonH; r: QPolygonH); cdecl; external Qt5PasLib name 'QPolygon_intersected';
procedure QPolygon_subtracted(handle: QPolygonH; retval: QPolygonH; r: QPolygonH); cdecl; external Qt5PasLib name 'QPolygon_subtracted';

function QPolygonF_Create(): QPolygonFH; cdecl; external Qt5PasLib name 'QPolygonF_Create';
procedure QPolygonF_Destroy(handle: QPolygonFH); cdecl; external Qt5PasLib name 'QPolygonF_Destroy'; 
function QPolygonF_Create(size: Integer): QPolygonFH; cdecl; external Qt5PasLib name 'QPolygonF_Create2';
function QPolygonF_Create(a: QPolygonFH): QPolygonFH; cdecl; external Qt5PasLib name 'QPolygonF_Create3';
function QPolygonF_Create(r: QRectFH): QPolygonFH; cdecl; external Qt5PasLib name 'QPolygonF_Create4';
function QPolygonF_Create(a: QPolygonH): QPolygonFH; cdecl; external Qt5PasLib name 'QPolygonF_Create5';
procedure QPolygonF_swap(handle: QPolygonFH; other: QPolygonFH); cdecl; external Qt5PasLib name 'QPolygonF_swap';
procedure QPolygonF_translate(handle: QPolygonFH; dx: qreal; dy: qreal); cdecl; external Qt5PasLib name 'QPolygonF_translate';
procedure QPolygonF_translate(handle: QPolygonFH; offset: PQtPointF); cdecl; external Qt5PasLib name 'QPolygonF_translate2';
procedure QPolygonF_translated(handle: QPolygonFH; retval: QPolygonFH; dx: qreal; dy: qreal); cdecl; external Qt5PasLib name 'QPolygonF_translated';
procedure QPolygonF_translated(handle: QPolygonFH; retval: QPolygonFH; offset: PQtPointF); cdecl; external Qt5PasLib name 'QPolygonF_translated2';
procedure QPolygonF_toPolygon(handle: QPolygonFH; retval: QPolygonH); cdecl; external Qt5PasLib name 'QPolygonF_toPolygon';
function QPolygonF_isClosed(handle: QPolygonFH): Boolean; cdecl; external Qt5PasLib name 'QPolygonF_isClosed';
procedure QPolygonF_boundingRect(handle: QPolygonFH; retval: QRectFH); cdecl; external Qt5PasLib name 'QPolygonF_boundingRect';
function QPolygonF_containsPoint(handle: QPolygonFH; pt: PQtPointF; fillRule: QtFillRule): Boolean; cdecl; external Qt5PasLib name 'QPolygonF_containsPoint';
procedure QPolygonF_united(handle: QPolygonFH; retval: QPolygonFH; r: QPolygonFH); cdecl; external Qt5PasLib name 'QPolygonF_united';
procedure QPolygonF_intersected(handle: QPolygonFH; retval: QPolygonFH; r: QPolygonFH); cdecl; external Qt5PasLib name 'QPolygonF_intersected';
procedure QPolygonF_subtracted(handle: QPolygonFH; retval: QPolygonFH; r: QPolygonFH); cdecl; external Qt5PasLib name 'QPolygonF_subtracted';


type
  QPainterCompositionMode = ( // QPainter::CompositionMode (1)
    QPainterCompositionMode_SourceOver, QPainterCompositionMode_DestinationOver, QPainterCompositionMode_Clear, QPainterCompositionMode_Source, QPainterCompositionMode_Destination, QPainterCompositionMode_SourceIn, 
    QPainterCompositionMode_DestinationIn, QPainterCompositionMode_SourceOut, QPainterCompositionMode_DestinationOut, QPainterCompositionMode_SourceAtop, QPainterCompositionMode_DestinationAtop, 
    QPainterCompositionMode_Xor, QPainterCompositionMode_Plus, QPainterCompositionMode_Multiply, QPainterCompositionMode_Screen, QPainterCompositionMode_Overlay, QPainterCompositionMode_Darken, 
    QPainterCompositionMode_Lighten, QPainterCompositionMode_ColorDodge, QPainterCompositionMode_ColorBurn, QPainterCompositionMode_HardLight, QPainterCompositionMode_SoftLight, QPainterCompositionMode_Difference, 
    QPainterCompositionMode_Exclusion, QPainterRasterOp_SourceOrDestination, QPainterRasterOp_SourceAndDestination, QPainterRasterOp_SourceXorDestination, QPainterRasterOp_NotSourceAndNotDestination, 
    QPainterRasterOp_NotSourceOrNotDestination, QPainterRasterOp_NotSourceXorDestination, QPainterRasterOp_NotSource, QPainterRasterOp_NotSourceAndDestination, QPainterRasterOp_SourceAndNotDestination, 
    QPainterRasterOp_NotSourceOrDestination, QPainterRasterOp_SourceOrNotDestination, QPainterRasterOp_ClearDestination, QPainterRasterOp_SetDestination, QPainterRasterOp_NotDestination );

type
  QPainterRenderHint = cardinal; // QPainter::RenderHint
  QPainterRenderHints = QPainterRenderHint; //QFlags<> (3)
const
  QPainterAntialiasing =   $01;
  QPainterTextAntialiasing =   $02;
  QPainterSmoothPixmapTransform =   $04;
  QPainterHighQualityAntialiasing =   $08;
  QPainterNonCosmeticDefaultPen =   $10;
  QPainterQt4CompatiblePainting =   $20;

type
  QPainterPixmapFragmentHint = cardinal; // QPainter::PixmapFragmentHint
  QPainterPixmapFragmentHints = QPainterPixmapFragmentHint; //QFlags<> (3)
const
  QPainterOpaqueHint =   $01;

function QPainter_Create(): QPainterH; cdecl; external Qt5PasLib name 'QPainter_Create';
procedure QPainter_Destroy(handle: QPainterH); cdecl; external Qt5PasLib name 'QPainter_Destroy'; 
function QPainter_Create(AnonParam1: QPaintDeviceH): QPainterH; cdecl; external Qt5PasLib name 'QPainter_Create2';
function QPainter_device(handle: QPainterH): QPaintDeviceH; cdecl; external Qt5PasLib name 'QPainter_device';
function QPainter_begin(handle: QPainterH; AnonParam1: QPaintDeviceH): Boolean; cdecl; external Qt5PasLib name 'QPainter_begin';
function QPainter_end(handle: QPainterH): Boolean; cdecl; external Qt5PasLib name 'QPainter_end';
function QPainter_isActive(handle: QPainterH): Boolean; cdecl; external Qt5PasLib name 'QPainter_isActive';
procedure QPainter_initFrom(handle: QPainterH; device: QPaintDeviceH); cdecl; external Qt5PasLib name 'QPainter_initFrom';
procedure QPainter_setCompositionMode(handle: QPainterH; mode: QPainterCompositionMode); cdecl; external Qt5PasLib name 'QPainter_setCompositionMode';
function QPainter_compositionMode(handle: QPainterH): QPainterCompositionMode; cdecl; external Qt5PasLib name 'QPainter_compositionMode';
function QPainter_font(handle: QPainterH): QFontH; cdecl; external Qt5PasLib name 'QPainter_font';
procedure QPainter_setFont(handle: QPainterH; f: QFontH); cdecl; external Qt5PasLib name 'QPainter_setFont';
procedure QPainter_fontMetrics(handle: QPainterH; retval: QFontMetricsH); cdecl; external Qt5PasLib name 'QPainter_fontMetrics';
procedure QPainter_fontInfo(handle: QPainterH; retval: QFontInfoH); cdecl; external Qt5PasLib name 'QPainter_fontInfo';
procedure QPainter_setPen(handle: QPainterH; color: PQColor); cdecl; external Qt5PasLib name 'QPainter_setPen';
procedure QPainter_setPen(handle: QPainterH; pen: QPenH); cdecl; external Qt5PasLib name 'QPainter_setPen2';
procedure QPainter_setPen(handle: QPainterH; style: QtPenStyle); cdecl; external Qt5PasLib name 'QPainter_setPen3';
function QPainter_pen(handle: QPainterH): QPenH; cdecl; external Qt5PasLib name 'QPainter_pen';
procedure QPainter_setBrush(handle: QPainterH; brush: QBrushH); cdecl; external Qt5PasLib name 'QPainter_setBrush';
procedure QPainter_setBrush(handle: QPainterH; style: QtBrushStyle); cdecl; external Qt5PasLib name 'QPainter_setBrush2';
function QPainter_brush(handle: QPainterH): QBrushH; cdecl; external Qt5PasLib name 'QPainter_brush';
procedure QPainter_setBackgroundMode(handle: QPainterH; mode: QtBGMode); cdecl; external Qt5PasLib name 'QPainter_setBackgroundMode';
function QPainter_backgroundMode(handle: QPainterH): QtBGMode; cdecl; external Qt5PasLib name 'QPainter_backgroundMode';
procedure QPainter_brushOrigin(handle: QPainterH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QPainter_brushOrigin';
procedure QPainter_setBrushOrigin(handle: QPainterH; x: Integer; y: Integer); cdecl; external Qt5PasLib name 'QPainter_setBrushOrigin';
procedure QPainter_setBrushOrigin(handle: QPainterH; AnonParam1: PQtPoint); cdecl; external Qt5PasLib name 'QPainter_setBrushOrigin2';
procedure QPainter_setBrushOrigin(handle: QPainterH; AnonParam1: PQtPointF); cdecl; external Qt5PasLib name 'QPainter_setBrushOrigin3';
procedure QPainter_setBackground(handle: QPainterH; bg: QBrushH); cdecl; external Qt5PasLib name 'QPainter_setBackground';
function QPainter_background(handle: QPainterH): QBrushH; cdecl; external Qt5PasLib name 'QPainter_background';
function QPainter_opacity(handle: QPainterH): qreal; cdecl; external Qt5PasLib name 'QPainter_opacity';
procedure QPainter_setOpacity(handle: QPainterH; opacity: qreal); cdecl; external Qt5PasLib name 'QPainter_setOpacity';
procedure QPainter_clipRegion(handle: QPainterH; retval: QRegionH); cdecl; external Qt5PasLib name 'QPainter_clipRegion';
procedure QPainter_clipPath(handle: QPainterH; retval: QPainterPathH); cdecl; external Qt5PasLib name 'QPainter_clipPath';
procedure QPainter_setClipRect(handle: QPainterH; AnonParam1: QRectFH; op: QtClipOperation = QtReplaceClip); cdecl; external Qt5PasLib name 'QPainter_setClipRect';
procedure QPainter_setClipRect(handle: QPainterH; AnonParam1: PRect; op: QtClipOperation = QtReplaceClip); cdecl; external Qt5PasLib name 'QPainter_setClipRect2';
procedure QPainter_setClipRect(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; op: QtClipOperation = QtReplaceClip); cdecl; external Qt5PasLib name 'QPainter_setClipRect3';
procedure QPainter_setClipRegion(handle: QPainterH; AnonParam1: QRegionH; op: QtClipOperation = QtReplaceClip); cdecl; external Qt5PasLib name 'QPainter_setClipRegion';
procedure QPainter_setClipPath(handle: QPainterH; path: QPainterPathH; op: QtClipOperation = QtReplaceClip); cdecl; external Qt5PasLib name 'QPainter_setClipPath';
procedure QPainter_setClipping(handle: QPainterH; enable: Boolean); cdecl; external Qt5PasLib name 'QPainter_setClipping';
function QPainter_hasClipping(handle: QPainterH): Boolean; cdecl; external Qt5PasLib name 'QPainter_hasClipping';
procedure QPainter_clipBoundingRect(handle: QPainterH; retval: QRectFH); cdecl; external Qt5PasLib name 'QPainter_clipBoundingRect';
procedure QPainter_save(handle: QPainterH); cdecl; external Qt5PasLib name 'QPainter_save';
procedure QPainter_restore(handle: QPainterH); cdecl; external Qt5PasLib name 'QPainter_restore';
procedure QPainter_setMatrix(handle: QPainterH; matrix: QMatrixH; combine: Boolean = False); cdecl; external Qt5PasLib name 'QPainter_setMatrix';
function QPainter_matrix(handle: QPainterH): QMatrixH; cdecl; external Qt5PasLib name 'QPainter_matrix';
function QPainter_deviceMatrix(handle: QPainterH): QMatrixH; cdecl; external Qt5PasLib name 'QPainter_deviceMatrix';
procedure QPainter_resetMatrix(handle: QPainterH); cdecl; external Qt5PasLib name 'QPainter_resetMatrix';
procedure QPainter_setTransform(handle: QPainterH; transform: QTransformH; combine: Boolean = False); cdecl; external Qt5PasLib name 'QPainter_setTransform';
function QPainter_transform(handle: QPainterH): QTransformH; cdecl; external Qt5PasLib name 'QPainter_transform';
function QPainter_deviceTransform(handle: QPainterH): QTransformH; cdecl; external Qt5PasLib name 'QPainter_deviceTransform';
procedure QPainter_resetTransform(handle: QPainterH); cdecl; external Qt5PasLib name 'QPainter_resetTransform';
procedure QPainter_setWorldMatrix(handle: QPainterH; matrix: QMatrixH; combine: Boolean = False); cdecl; external Qt5PasLib name 'QPainter_setWorldMatrix';
function QPainter_worldMatrix(handle: QPainterH): QMatrixH; cdecl; external Qt5PasLib name 'QPainter_worldMatrix';
procedure QPainter_setWorldTransform(handle: QPainterH; matrix: QTransformH; combine: Boolean = False); cdecl; external Qt5PasLib name 'QPainter_setWorldTransform';
function QPainter_worldTransform(handle: QPainterH): QTransformH; cdecl; external Qt5PasLib name 'QPainter_worldTransform';
procedure QPainter_combinedMatrix(handle: QPainterH; retval: QMatrixH); cdecl; external Qt5PasLib name 'QPainter_combinedMatrix';
procedure QPainter_combinedTransform(handle: QPainterH; retval: QTransformH); cdecl; external Qt5PasLib name 'QPainter_combinedTransform';
procedure QPainter_setMatrixEnabled(handle: QPainterH; enabled: Boolean); cdecl; external Qt5PasLib name 'QPainter_setMatrixEnabled';
function QPainter_matrixEnabled(handle: QPainterH): Boolean; cdecl; external Qt5PasLib name 'QPainter_matrixEnabled';
procedure QPainter_setWorldMatrixEnabled(handle: QPainterH; enabled: Boolean); cdecl; external Qt5PasLib name 'QPainter_setWorldMatrixEnabled';
function QPainter_worldMatrixEnabled(handle: QPainterH): Boolean; cdecl; external Qt5PasLib name 'QPainter_worldMatrixEnabled';
procedure QPainter_scale(handle: QPainterH; sx: qreal; sy: qreal); cdecl; external Qt5PasLib name 'QPainter_scale';
procedure QPainter_shear(handle: QPainterH; sh: qreal; sv: qreal); cdecl; external Qt5PasLib name 'QPainter_shear';
procedure QPainter_rotate(handle: QPainterH; a: qreal); cdecl; external Qt5PasLib name 'QPainter_rotate';
procedure QPainter_translate(handle: QPainterH; offset: PQtPointF); cdecl; external Qt5PasLib name 'QPainter_translate';
procedure QPainter_translate(handle: QPainterH; offset: PQtPoint); cdecl; external Qt5PasLib name 'QPainter_translate2';
procedure QPainter_translate(handle: QPainterH; dx: qreal; dy: qreal); cdecl; external Qt5PasLib name 'QPainter_translate3';
procedure QPainter_window(handle: QPainterH; retval: PRect); cdecl; external Qt5PasLib name 'QPainter_window';
procedure QPainter_setWindow(handle: QPainterH; window: PRect); cdecl; external Qt5PasLib name 'QPainter_setWindow';
procedure QPainter_setWindow(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer); cdecl; external Qt5PasLib name 'QPainter_setWindow2';
procedure QPainter_viewport(handle: QPainterH; retval: PRect); cdecl; external Qt5PasLib name 'QPainter_viewport';
procedure QPainter_setViewport(handle: QPainterH; viewport: PRect); cdecl; external Qt5PasLib name 'QPainter_setViewport';
procedure QPainter_setViewport(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer); cdecl; external Qt5PasLib name 'QPainter_setViewport2';
procedure QPainter_setViewTransformEnabled(handle: QPainterH; enable: Boolean); cdecl; external Qt5PasLib name 'QPainter_setViewTransformEnabled';
function QPainter_viewTransformEnabled(handle: QPainterH): Boolean; cdecl; external Qt5PasLib name 'QPainter_viewTransformEnabled';
procedure QPainter_strokePath(handle: QPainterH; path: QPainterPathH; pen: QPenH); cdecl; external Qt5PasLib name 'QPainter_strokePath';
procedure QPainter_fillPath(handle: QPainterH; path: QPainterPathH; brush: QBrushH); cdecl; external Qt5PasLib name 'QPainter_fillPath';
procedure QPainter_drawPath(handle: QPainterH; path: QPainterPathH); cdecl; external Qt5PasLib name 'QPainter_drawPath';
procedure QPainter_drawPoint(handle: QPainterH; pt: PQtPointF); cdecl; external Qt5PasLib name 'QPainter_drawPoint';
procedure QPainter_drawPoint(handle: QPainterH; p: PQtPoint); cdecl; external Qt5PasLib name 'QPainter_drawPoint2';
procedure QPainter_drawPoint(handle: QPainterH; x: Integer; y: Integer); cdecl; external Qt5PasLib name 'QPainter_drawPoint3';
procedure QPainter_drawPoints(handle: QPainterH; points: PQtPointF; pointCount: Integer); cdecl; external Qt5PasLib name 'QPainter_drawPoints';
procedure QPainter_drawPoints(handle: QPainterH; points: QPolygonFH); cdecl; external Qt5PasLib name 'QPainter_drawPoints2';
procedure QPainter_drawPoints(handle: QPainterH; points: PQtPoint; pointCount: Integer); cdecl; external Qt5PasLib name 'QPainter_drawPoints3';
procedure QPainter_drawPoints(handle: QPainterH; points: QPolygonH); cdecl; external Qt5PasLib name 'QPainter_drawPoints4';
procedure QPainter_drawLine(handle: QPainterH; line: QLineFH); cdecl; external Qt5PasLib name 'QPainter_drawLine';
procedure QPainter_drawLine(handle: QPainterH; line: QLineH); cdecl; external Qt5PasLib name 'QPainter_drawLine2';
procedure QPainter_drawLine(handle: QPainterH; x1: Integer; y1: Integer; x2: Integer; y2: Integer); cdecl; external Qt5PasLib name 'QPainter_drawLine3';
procedure QPainter_drawLine(handle: QPainterH; p1: PQtPoint; p2: PQtPoint); cdecl; external Qt5PasLib name 'QPainter_drawLine4';
procedure QPainter_drawLine(handle: QPainterH; p1: PQtPointF; p2: PQtPointF); cdecl; external Qt5PasLib name 'QPainter_drawLine5';
procedure QPainter_drawLines(handle: QPainterH; lines: QLineFH; lineCount: Integer); cdecl; external Qt5PasLib name 'QPainter_drawLines';
procedure QPainter_drawLines(handle: QPainterH; pointPairs: PQtPointF; lineCount: Integer); cdecl; external Qt5PasLib name 'QPainter_drawLines2';
procedure QPainter_drawLines(handle: QPainterH; lines: QLineH; lineCount: Integer); cdecl; external Qt5PasLib name 'QPainter_drawLines3';
procedure QPainter_drawLines(handle: QPainterH; pointPairs: PQtPoint; lineCount: Integer); cdecl; external Qt5PasLib name 'QPainter_drawLines4';
procedure QPainter_drawRect(handle: QPainterH; rect: QRectFH); cdecl; external Qt5PasLib name 'QPainter_drawRect';
procedure QPainter_drawRect(handle: QPainterH; x1: Integer; y1: Integer; w: Integer; h: Integer); cdecl; external Qt5PasLib name 'QPainter_drawRect2';
procedure QPainter_drawRect(handle: QPainterH; rect: PRect); cdecl; external Qt5PasLib name 'QPainter_drawRect3';
procedure QPainter_drawRects(handle: QPainterH; rects: QRectFH; rectCount: Integer); cdecl; external Qt5PasLib name 'QPainter_drawRects';
procedure QPainter_drawRects(handle: QPainterH; rects: PRect; rectCount: Integer); cdecl; external Qt5PasLib name 'QPainter_drawRects2';
procedure QPainter_drawEllipse(handle: QPainterH; r: QRectFH); cdecl; external Qt5PasLib name 'QPainter_drawEllipse';
procedure QPainter_drawEllipse(handle: QPainterH; r: PRect); cdecl; external Qt5PasLib name 'QPainter_drawEllipse2';
procedure QPainter_drawEllipse(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer); cdecl; external Qt5PasLib name 'QPainter_drawEllipse3';
procedure QPainter_drawEllipse(handle: QPainterH; center: PQtPointF; rx: qreal; ry: qreal); cdecl; external Qt5PasLib name 'QPainter_drawEllipse4';
procedure QPainter_drawEllipse(handle: QPainterH; center: PQtPoint; rx: Integer; ry: Integer); cdecl; external Qt5PasLib name 'QPainter_drawEllipse5';
procedure QPainter_drawPolyline(handle: QPainterH; points: PQtPointF; pointCount: Integer); cdecl; external Qt5PasLib name 'QPainter_drawPolyline';
procedure QPainter_drawPolyline(handle: QPainterH; polyline: QPolygonFH); cdecl; external Qt5PasLib name 'QPainter_drawPolyline2';
procedure QPainter_drawPolyline(handle: QPainterH; points: PQtPoint; pointCount: Integer); cdecl; external Qt5PasLib name 'QPainter_drawPolyline3';
procedure QPainter_drawPolyline(handle: QPainterH; polygon: QPolygonH); cdecl; external Qt5PasLib name 'QPainter_drawPolyline4';
procedure QPainter_drawPolygon(handle: QPainterH; points: PQtPointF; pointCount: Integer; fillRule: QtFillRule = QtOddEvenFill); cdecl; external Qt5PasLib name 'QPainter_drawPolygon';
procedure QPainter_drawPolygon(handle: QPainterH; polygon: QPolygonFH; fillRule: QtFillRule = QtOddEvenFill); cdecl; external Qt5PasLib name 'QPainter_drawPolygon2';
procedure QPainter_drawPolygon(handle: QPainterH; points: PQtPoint; pointCount: Integer; fillRule: QtFillRule = QtOddEvenFill); cdecl; external Qt5PasLib name 'QPainter_drawPolygon3';
procedure QPainter_drawPolygon(handle: QPainterH; polygon: QPolygonH; fillRule: QtFillRule = QtOddEvenFill); cdecl; external Qt5PasLib name 'QPainter_drawPolygon4';
procedure QPainter_drawConvexPolygon(handle: QPainterH; points: PQtPointF; pointCount: Integer); cdecl; external Qt5PasLib name 'QPainter_drawConvexPolygon';
procedure QPainter_drawConvexPolygon(handle: QPainterH; polygon: QPolygonFH); cdecl; external Qt5PasLib name 'QPainter_drawConvexPolygon2';
procedure QPainter_drawConvexPolygon(handle: QPainterH; points: PQtPoint; pointCount: Integer); cdecl; external Qt5PasLib name 'QPainter_drawConvexPolygon3';
procedure QPainter_drawConvexPolygon(handle: QPainterH; polygon: QPolygonH); cdecl; external Qt5PasLib name 'QPainter_drawConvexPolygon4';
procedure QPainter_drawArc(handle: QPainterH; rect: QRectFH; a: Integer; alen: Integer); cdecl; external Qt5PasLib name 'QPainter_drawArc';
procedure QPainter_drawArc(handle: QPainterH; AnonParam1: PRect; a: Integer; alen: Integer); cdecl; external Qt5PasLib name 'QPainter_drawArc2';
procedure QPainter_drawArc(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; a: Integer; alen: Integer); cdecl; external Qt5PasLib name 'QPainter_drawArc3';
procedure QPainter_drawPie(handle: QPainterH; rect: QRectFH; a: Integer; alen: Integer); cdecl; external Qt5PasLib name 'QPainter_drawPie';
procedure QPainter_drawPie(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; a: Integer; alen: Integer); cdecl; external Qt5PasLib name 'QPainter_drawPie2';
procedure QPainter_drawPie(handle: QPainterH; AnonParam1: PRect; a: Integer; alen: Integer); cdecl; external Qt5PasLib name 'QPainter_drawPie3';
procedure QPainter_drawChord(handle: QPainterH; rect: QRectFH; a: Integer; alen: Integer); cdecl; external Qt5PasLib name 'QPainter_drawChord';
procedure QPainter_drawChord(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; a: Integer; alen: Integer); cdecl; external Qt5PasLib name 'QPainter_drawChord2';
procedure QPainter_drawChord(handle: QPainterH; AnonParam1: PRect; a: Integer; alen: Integer); cdecl; external Qt5PasLib name 'QPainter_drawChord3';
procedure QPainter_drawRoundedRect(handle: QPainterH; rect: QRectFH; xRadius: qreal; yRadius: qreal; mode: QtSizeMode = QtAbsoluteSize); cdecl; external Qt5PasLib name 'QPainter_drawRoundedRect';
procedure QPainter_drawRoundedRect(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; xRadius: qreal; yRadius: qreal; mode: QtSizeMode = QtAbsoluteSize); cdecl; external Qt5PasLib name 'QPainter_drawRoundedRect2';
procedure QPainter_drawRoundedRect(handle: QPainterH; rect: PRect; xRadius: qreal; yRadius: qreal; mode: QtSizeMode = QtAbsoluteSize); cdecl; external Qt5PasLib name 'QPainter_drawRoundedRect3';
procedure QPainter_drawRoundRect(handle: QPainterH; r: QRectFH; xround: Integer = 25; yround: Integer = 25); cdecl; external Qt5PasLib name 'QPainter_drawRoundRect';
procedure QPainter_drawRoundRect(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; AnonParam5: Integer = 25; AnonParam6: Integer = 25); cdecl; external Qt5PasLib name 'QPainter_drawRoundRect2';
procedure QPainter_drawRoundRect(handle: QPainterH; r: PRect; xround: Integer = 25; yround: Integer = 25); cdecl; external Qt5PasLib name 'QPainter_drawRoundRect3';
procedure QPainter_drawTiledPixmap(handle: QPainterH; rect: QRectFH; pm: QPixmapH; offset: PQtPointF = nil); cdecl; external Qt5PasLib name 'QPainter_drawTiledPixmap';
procedure QPainter_drawTiledPixmap(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; AnonParam5: QPixmapH; sx: Integer = 0; sy: Integer = 0); cdecl; external Qt5PasLib name 'QPainter_drawTiledPixmap2';
procedure QPainter_drawTiledPixmap(handle: QPainterH; AnonParam1: PRect; AnonParam2: QPixmapH; AnonParam3: PQtPoint = nil); cdecl; external Qt5PasLib name 'QPainter_drawTiledPixmap3';
procedure QPainter_drawPicture(handle: QPainterH; p: PQtPointF; picture: QPictureH); cdecl; external Qt5PasLib name 'QPainter_drawPicture';
procedure QPainter_drawPicture(handle: QPainterH; x: Integer; y: Integer; picture: QPictureH); cdecl; external Qt5PasLib name 'QPainter_drawPicture2';
procedure QPainter_drawPicture(handle: QPainterH; p: PQtPoint; picture: QPictureH); cdecl; external Qt5PasLib name 'QPainter_drawPicture3';
procedure QPainter_drawPixmap(handle: QPainterH; targetRect: QRectFH; pixmap: QPixmapH; sourceRect: QRectFH); cdecl; external Qt5PasLib name 'QPainter_drawPixmap';
procedure QPainter_drawPixmap(handle: QPainterH; targetRect: PRect; pixmap: QPixmapH; sourceRect: PRect); cdecl; external Qt5PasLib name 'QPainter_drawPixmap2';
procedure QPainter_drawPixmap(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; pm: QPixmapH; sx: Integer; sy: Integer; sw: Integer; sh: Integer); cdecl; external Qt5PasLib name 'QPainter_drawPixmap3';
procedure QPainter_drawPixmap(handle: QPainterH; x: Integer; y: Integer; pm: QPixmapH; sx: Integer; sy: Integer; sw: Integer; sh: Integer); cdecl; external Qt5PasLib name 'QPainter_drawPixmap4';
procedure QPainter_drawPixmap(handle: QPainterH; p: PQtPointF; pm: QPixmapH; sr: QRectFH); cdecl; external Qt5PasLib name 'QPainter_drawPixmap5';
procedure QPainter_drawPixmap(handle: QPainterH; p: PQtPoint; pm: QPixmapH; sr: PRect); cdecl; external Qt5PasLib name 'QPainter_drawPixmap6';
procedure QPainter_drawPixmap(handle: QPainterH; p: PQtPointF; pm: QPixmapH); cdecl; external Qt5PasLib name 'QPainter_drawPixmap7';
procedure QPainter_drawPixmap(handle: QPainterH; p: PQtPoint; pm: QPixmapH); cdecl; external Qt5PasLib name 'QPainter_drawPixmap8';
procedure QPainter_drawPixmap(handle: QPainterH; x: Integer; y: Integer; pm: QPixmapH); cdecl; external Qt5PasLib name 'QPainter_drawPixmap9';
procedure QPainter_drawPixmap(handle: QPainterH; r: PRect; pm: QPixmapH); cdecl; external Qt5PasLib name 'QPainter_drawPixmap10';
procedure QPainter_drawPixmap(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; pm: QPixmapH); cdecl; external Qt5PasLib name 'QPainter_drawPixmap11';
procedure QPainter_drawImage(handle: QPainterH; targetRect: QRectFH; image: QImageH; sourceRect: QRectFH; flags: QtImageConversionFlags = QtAutoColor); cdecl; external Qt5PasLib name 'QPainter_drawImage';
procedure QPainter_drawImage(handle: QPainterH; targetRect: PRect; image: QImageH; sourceRect: PRect; flags: QtImageConversionFlags = QtAutoColor); cdecl; external Qt5PasLib name 'QPainter_drawImage2';
procedure QPainter_drawImage(handle: QPainterH; p: PQtPointF; image: QImageH; sr: QRectFH; flags: QtImageConversionFlags = QtAutoColor); cdecl; external Qt5PasLib name 'QPainter_drawImage3';
procedure QPainter_drawImage(handle: QPainterH; p: PQtPoint; image: QImageH; sr: PRect; flags: QtImageConversionFlags = QtAutoColor); cdecl; external Qt5PasLib name 'QPainter_drawImage4';
procedure QPainter_drawImage(handle: QPainterH; r: QRectFH; image: QImageH); cdecl; external Qt5PasLib name 'QPainter_drawImage5';
procedure QPainter_drawImage(handle: QPainterH; r: PRect; image: QImageH); cdecl; external Qt5PasLib name 'QPainter_drawImage6';
procedure QPainter_drawImage(handle: QPainterH; p: PQtPointF; image: QImageH); cdecl; external Qt5PasLib name 'QPainter_drawImage7';
procedure QPainter_drawImage(handle: QPainterH; p: PQtPoint; image: QImageH); cdecl; external Qt5PasLib name 'QPainter_drawImage8';
procedure QPainter_drawImage(handle: QPainterH; x: Integer; y: Integer; image: QImageH; sx: Integer = 0; sy: Integer = 0; sw: Integer = -1; sh: Integer = -1; flags: QtImageConversionFlags = QtAutoColor); cdecl; external Qt5PasLib name 'QPainter_drawImage9';
procedure QPainter_setLayoutDirection(handle: QPainterH; direction: QtLayoutDirection); cdecl; external Qt5PasLib name 'QPainter_setLayoutDirection';
function QPainter_layoutDirection(handle: QPainterH): QtLayoutDirection; cdecl; external Qt5PasLib name 'QPainter_layoutDirection';
procedure QPainter_drawGlyphRun(handle: QPainterH; position: PQtPointF; glyphRun: QGlyphRunH); cdecl; external Qt5PasLib name 'QPainter_drawGlyphRun';
procedure QPainter_drawStaticText(handle: QPainterH; topLeftPosition: PQtPointF; staticText: QStaticTextH); cdecl; external Qt5PasLib name 'QPainter_drawStaticText';
procedure QPainter_drawStaticText(handle: QPainterH; topLeftPosition: PQtPoint; staticText: QStaticTextH); cdecl; external Qt5PasLib name 'QPainter_drawStaticText2';
procedure QPainter_drawStaticText(handle: QPainterH; left: Integer; top: Integer; staticText: QStaticTextH); cdecl; external Qt5PasLib name 'QPainter_drawStaticText3';
procedure QPainter_drawText(handle: QPainterH; p: PQtPointF; s: PWideString); cdecl; external Qt5PasLib name 'QPainter_drawText';
procedure QPainter_drawText(handle: QPainterH; p: PQtPoint; s: PWideString); cdecl; external Qt5PasLib name 'QPainter_drawText2';
procedure QPainter_drawText(handle: QPainterH; x: Integer; y: Integer; s: PWideString); cdecl; external Qt5PasLib name 'QPainter_drawText3';
procedure QPainter_drawText(handle: QPainterH; p: PQtPointF; str: PWideString; tf: Integer; justificationPadding: Integer); cdecl; external Qt5PasLib name 'QPainter_drawText4';
procedure QPainter_drawText(handle: QPainterH; r: QRectFH; flags: Integer; text: PWideString; br: QRectFH = nil); cdecl; external Qt5PasLib name 'QPainter_drawText5';
procedure QPainter_drawText(handle: QPainterH; r: PRect; flags: Integer; text: PWideString; br: PRect = nil); cdecl; external Qt5PasLib name 'QPainter_drawText6';
procedure QPainter_drawText(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; flags: Integer; text: PWideString; br: PRect = nil); cdecl; external Qt5PasLib name 'QPainter_drawText7';
procedure QPainter_drawText(handle: QPainterH; r: QRectFH; text: PWideString; o: QTextOptionH = nil); cdecl; external Qt5PasLib name 'QPainter_drawText8';
procedure QPainter_boundingRect(handle: QPainterH; retval: QRectFH; rect: QRectFH; flags: Integer; text: PWideString); cdecl; external Qt5PasLib name 'QPainter_boundingRect';
procedure QPainter_boundingRect(handle: QPainterH; retval: PRect; rect: PRect; flags: Integer; text: PWideString); cdecl; external Qt5PasLib name 'QPainter_boundingRect2';
procedure QPainter_boundingRect(handle: QPainterH; retval: PRect; x: Integer; y: Integer; w: Integer; h: Integer; flags: Integer; text: PWideString); cdecl; external Qt5PasLib name 'QPainter_boundingRect3';
procedure QPainter_boundingRect(handle: QPainterH; retval: QRectFH; rect: QRectFH; text: PWideString; o: QTextOptionH = nil); cdecl; external Qt5PasLib name 'QPainter_boundingRect4';
procedure QPainter_fillRect(handle: QPainterH; AnonParam1: QRectFH; AnonParam2: QBrushH); cdecl; external Qt5PasLib name 'QPainter_fillRect';
procedure QPainter_fillRect(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; AnonParam5: QBrushH); cdecl; external Qt5PasLib name 'QPainter_fillRect2';
procedure QPainter_fillRect(handle: QPainterH; AnonParam1: PRect; AnonParam2: QBrushH); cdecl; external Qt5PasLib name 'QPainter_fillRect3';
procedure QPainter_fillRect(handle: QPainterH; AnonParam1: QRectFH; color: PQColor); cdecl; external Qt5PasLib name 'QPainter_fillRect4';
procedure QPainter_fillRect(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; color: PQColor); cdecl; external Qt5PasLib name 'QPainter_fillRect5';
procedure QPainter_fillRect(handle: QPainterH; AnonParam1: PRect; color: PQColor); cdecl; external Qt5PasLib name 'QPainter_fillRect6';
procedure QPainter_fillRect(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; c: QtGlobalColor); cdecl; external Qt5PasLib name 'QPainter_fillRect7';
procedure QPainter_fillRect(handle: QPainterH; r: PRect; c: QtGlobalColor); cdecl; external Qt5PasLib name 'QPainter_fillRect8';
procedure QPainter_fillRect(handle: QPainterH; r: QRectFH; c: QtGlobalColor); cdecl; external Qt5PasLib name 'QPainter_fillRect9';
procedure QPainter_fillRect(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; style: QtBrushStyle); cdecl; external Qt5PasLib name 'QPainter_fillRect10';
procedure QPainter_fillRect(handle: QPainterH; r: PRect; style: QtBrushStyle); cdecl; external Qt5PasLib name 'QPainter_fillRect11';
procedure QPainter_fillRect(handle: QPainterH; r: QRectFH; style: QtBrushStyle); cdecl; external Qt5PasLib name 'QPainter_fillRect12';
procedure QPainter_eraseRect(handle: QPainterH; AnonParam1: QRectFH); cdecl; external Qt5PasLib name 'QPainter_eraseRect';
procedure QPainter_eraseRect(handle: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer); cdecl; external Qt5PasLib name 'QPainter_eraseRect2';
procedure QPainter_eraseRect(handle: QPainterH; AnonParam1: PRect); cdecl; external Qt5PasLib name 'QPainter_eraseRect3';
procedure QPainter_setRenderHint(handle: QPainterH; hint: QPainterRenderHint; _on: Boolean = True); cdecl; external Qt5PasLib name 'QPainter_setRenderHint';
procedure QPainter_setRenderHints(handle: QPainterH; hints: QPainterRenderHints; _on: Boolean = True); cdecl; external Qt5PasLib name 'QPainter_setRenderHints';
function QPainter_renderHints(handle: QPainterH): QPainterRenderHints; cdecl; external Qt5PasLib name 'QPainter_renderHints';
function QPainter_testRenderHint(handle: QPainterH; hint: QPainterRenderHint): Boolean; cdecl; external Qt5PasLib name 'QPainter_testRenderHint';
function QPainter_paintEngine(handle: QPainterH): QPaintEngineH; cdecl; external Qt5PasLib name 'QPainter_paintEngine';
procedure QPainter_setRedirected(device: QPaintDeviceH; replacement: QPaintDeviceH; offset: PQtPoint = nil); cdecl; external Qt5PasLib name 'QPainter_setRedirected';
function QPainter_redirected(device: QPaintDeviceH; offset: PQtPoint = nil): QPaintDeviceH; cdecl; external Qt5PasLib name 'QPainter_redirected';
procedure QPainter_restoreRedirected(device: QPaintDeviceH); cdecl; external Qt5PasLib name 'QPainter_restoreRedirected';
procedure QPainter_beginNativePainting(handle: QPainterH); cdecl; external Qt5PasLib name 'QPainter_beginNativePainting';
procedure QPainter_endNativePainting(handle: QPainterH); cdecl; external Qt5PasLib name 'QPainter_endNativePainting';


type
  QPaintEnginePolygonDrawMode = ( // QPaintEngine::PolygonDrawMode (1)
    QPaintEngineOddEvenMode, QPaintEngineWindingMode, QPaintEngineConvexMode, QPaintEnginePolylineMode );

type
  QPaintEnginePaintEngineFeature = cardinal; // QPaintEngine::PaintEngineFeature
  QPaintEnginePaintEngineFeatures = QPaintEnginePaintEngineFeature; //QFlags<> (3)
const
  QPaintEnginePrimitiveTransform =   $00000001;
  QPaintEnginePatternTransform =   $00000002;
  QPaintEnginePixmapTransform =   $00000004;
  QPaintEnginePatternBrush =   $00000008;
  QPaintEngineLinearGradientFill =   $00000010;
  QPaintEngineRadialGradientFill =   $00000020;
  QPaintEngineConicalGradientFill =   $00000040;
  QPaintEngineAlphaBlend =   $00000080;
  QPaintEnginePorterDuff =   $00000100;
  QPaintEnginePainterPaths =   $00000200;
  QPaintEngineAntialiasing =   $00000400;
  QPaintEngineBrushStroke =   $00000800;
  QPaintEngineConstantOpacity =   $00001000;
  QPaintEngineMaskedBrush =   $00002000;
  QPaintEnginePerspectiveTransform =   $00004000;
  QPaintEngineBlendModes =   $00008000;
  QPaintEngineObjectBoundingModeGradients =   $00010000;
  QPaintEngineRasterOpModes =   $00020000;
  QPaintEnginePaintOutsidePaintEvent =   $20000000;
  QPaintEngineAllFeatures =   $ffffffff;

type
  QPaintEngineDirtyFlag = cardinal; // QPaintEngine::DirtyFlag
  QPaintEngineDirtyFlags = QPaintEngineDirtyFlag; //QFlags<> (3)
const
  QPaintEngineDirtyPen =   $0001;
  QPaintEngineDirtyBrush =   $0002;
  QPaintEngineDirtyBrushOrigin =   $0004;
  QPaintEngineDirtyFont =   $0008;
  QPaintEngineDirtyBackground =   $0010;
  QPaintEngineDirtyBackgroundMode =   $0020;
  QPaintEngineDirtyTransform =   $0040;
  QPaintEngineDirtyClipRegion =   $0080;
  QPaintEngineDirtyClipPath =   $0100;
  QPaintEngineDirtyHints =   $0200;
  QPaintEngineDirtyCompositionMode =   $0400;
  QPaintEngineDirtyClipEnabled =   $0800;
  QPaintEngineDirtyOpacity =   $1000;
  QPaintEngineAllDirty =   $ffff;


type
  QPaintEngineType = (  //QPaintEngine::Type (2)
    QPaintEngineX11,
    QPaintEngineWindows,
    QPaintEngineQuickDraw,
    QPaintEngineCoreGraphics,
    QPaintEngineMacPrinter,
    QPaintEngineQWindowSystem,
    QPaintEnginePostScript,
    QPaintEngineOpenGL,
    QPaintEnginePicture,
    QPaintEngineSVG,
    QPaintEngineRaster,
    QPaintEngineDirect3D,
    QPaintEnginePdf,
    QPaintEngineOpenVG,
    QPaintEngineOpenGL2,
    QPaintEnginePaintBuffer,
    QPaintEngineBlitter,
    QPaintEngineUser = 50,
    QPaintEngineMaxUser = 100 );

function QPaintEngine_isActive(handle: QPaintEngineH): Boolean; cdecl; external Qt5PasLib name 'QPaintEngine_isActive';
procedure QPaintEngine_setActive(handle: QPaintEngineH; newState: Boolean); cdecl; external Qt5PasLib name 'QPaintEngine_setActive';
function QPaintEngine_begin(handle: QPaintEngineH; pdev: QPaintDeviceH): Boolean; cdecl; external Qt5PasLib name 'QPaintEngine_begin';
function QPaintEngine_end(handle: QPaintEngineH): Boolean; cdecl; external Qt5PasLib name 'QPaintEngine_end';
procedure QPaintEngine_drawRects(handle: QPaintEngineH; rects: PRect; rectCount: Integer); cdecl; external Qt5PasLib name 'QPaintEngine_drawRects';
procedure QPaintEngine_drawRects(handle: QPaintEngineH; rects: QRectFH; rectCount: Integer); cdecl; external Qt5PasLib name 'QPaintEngine_drawRects2';
procedure QPaintEngine_drawLines(handle: QPaintEngineH; lines: QLineH; lineCount: Integer); cdecl; external Qt5PasLib name 'QPaintEngine_drawLines';
procedure QPaintEngine_drawLines(handle: QPaintEngineH; lines: QLineFH; lineCount: Integer); cdecl; external Qt5PasLib name 'QPaintEngine_drawLines2';
procedure QPaintEngine_drawEllipse(handle: QPaintEngineH; r: QRectFH); cdecl; external Qt5PasLib name 'QPaintEngine_drawEllipse';
procedure QPaintEngine_drawEllipse(handle: QPaintEngineH; r: PRect); cdecl; external Qt5PasLib name 'QPaintEngine_drawEllipse2';
procedure QPaintEngine_drawPath(handle: QPaintEngineH; path: QPainterPathH); cdecl; external Qt5PasLib name 'QPaintEngine_drawPath';
procedure QPaintEngine_drawPoints(handle: QPaintEngineH; points: PQtPointF; pointCount: Integer); cdecl; external Qt5PasLib name 'QPaintEngine_drawPoints';
procedure QPaintEngine_drawPoints(handle: QPaintEngineH; points: PQtPoint; pointCount: Integer); cdecl; external Qt5PasLib name 'QPaintEngine_drawPoints2';
procedure QPaintEngine_drawPolygon(handle: QPaintEngineH; points: PQtPointF; pointCount: Integer; mode: QPaintEnginePolygonDrawMode); cdecl; external Qt5PasLib name 'QPaintEngine_drawPolygon';
procedure QPaintEngine_drawPolygon(handle: QPaintEngineH; points: PQtPoint; pointCount: Integer; mode: QPaintEnginePolygonDrawMode); cdecl; external Qt5PasLib name 'QPaintEngine_drawPolygon2';
procedure QPaintEngine_drawPixmap(handle: QPaintEngineH; r: QRectFH; pm: QPixmapH; sr: QRectFH); cdecl; external Qt5PasLib name 'QPaintEngine_drawPixmap';
procedure QPaintEngine_drawTiledPixmap(handle: QPaintEngineH; r: QRectFH; pixmap: QPixmapH; s: PQtPointF); cdecl; external Qt5PasLib name 'QPaintEngine_drawTiledPixmap';
procedure QPaintEngine_drawImage(handle: QPaintEngineH; r: QRectFH; pm: QImageH; sr: QRectFH; flags: QtImageConversionFlags = QtAutoColor); cdecl; external Qt5PasLib name 'QPaintEngine_drawImage';
procedure QPaintEngine_setPaintDevice(handle: QPaintEngineH; device: QPaintDeviceH); cdecl; external Qt5PasLib name 'QPaintEngine_setPaintDevice';
function QPaintEngine_paintDevice(handle: QPaintEngineH): QPaintDeviceH; cdecl; external Qt5PasLib name 'QPaintEngine_paintDevice';
procedure QPaintEngine_setSystemClip(handle: QPaintEngineH; baseClip: QRegionH); cdecl; external Qt5PasLib name 'QPaintEngine_setSystemClip';
procedure QPaintEngine_systemClip(handle: QPaintEngineH; retval: QRegionH); cdecl; external Qt5PasLib name 'QPaintEngine_systemClip';
procedure QPaintEngine_setSystemRect(handle: QPaintEngineH; rect: PRect); cdecl; external Qt5PasLib name 'QPaintEngine_setSystemRect';
procedure QPaintEngine_systemRect(handle: QPaintEngineH; retval: PRect); cdecl; external Qt5PasLib name 'QPaintEngine_systemRect';
procedure QPaintEngine_coordinateOffset(handle: QPaintEngineH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QPaintEngine_coordinateOffset';
function QPaintEngine_type(handle: QPaintEngineH): QPaintEngineType; cdecl; external Qt5PasLib name 'QPaintEngine_type';
procedure QPaintEngine_fix_neg_rect(handle: QPaintEngineH; x: PInteger; y: PInteger; w: PInteger; h: PInteger); cdecl; external Qt5PasLib name 'QPaintEngine_fix_neg_rect';
function QPaintEngine_testDirty(handle: QPaintEngineH; df: QPaintEngineDirtyFlags): Boolean; cdecl; external Qt5PasLib name 'QPaintEngine_testDirty';
procedure QPaintEngine_setDirty(handle: QPaintEngineH; df: QPaintEngineDirtyFlags); cdecl; external Qt5PasLib name 'QPaintEngine_setDirty';
procedure QPaintEngine_clearDirty(handle: QPaintEngineH; df: QPaintEngineDirtyFlags); cdecl; external Qt5PasLib name 'QPaintEngine_clearDirty';
function QPaintEngine_hasFeature(handle: QPaintEngineH; feature: QPaintEnginePaintEngineFeatures): Boolean; cdecl; external Qt5PasLib name 'QPaintEngine_hasFeature';
function QPaintEngine_painter(handle: QPaintEngineH): QPainterH; cdecl; external Qt5PasLib name 'QPaintEngine_painter';
procedure QPaintEngine_syncState(handle: QPaintEngineH); cdecl; external Qt5PasLib name 'QPaintEngine_syncState';
function QPaintEngine_isExtended(handle: QPaintEngineH): Boolean; cdecl; external Qt5PasLib name 'QPaintEngine_isExtended';


type
  QPaintDevicePaintDeviceMetric = (  //QPaintDevice::PaintDeviceMetric (2)
    QPaintDevicePdmWidth = 1,
    QPaintDevicePdmHeight,
    QPaintDevicePdmWidthMM,
    QPaintDevicePdmHeightMM,
    QPaintDevicePdmNumColors,
    QPaintDevicePdmDepth,
    QPaintDevicePdmDpiX,
    QPaintDevicePdmDpiY,
    QPaintDevicePdmPhysicalDpiX,
    QPaintDevicePdmPhysicalDpiY,
    QPaintDevicePdmDevicePixelRatio );

function QPaintDevice_devType(handle: QPaintDeviceH): Integer; cdecl; external Qt5PasLib name 'QPaintDevice_devType';
function QPaintDevice_paintingActive(handle: QPaintDeviceH): Boolean; cdecl; external Qt5PasLib name 'QPaintDevice_paintingActive';
function QPaintDevice_paintEngine(handle: QPaintDeviceH): QPaintEngineH; cdecl; external Qt5PasLib name 'QPaintDevice_paintEngine';
function QPaintDevice_width(handle: QPaintDeviceH): Integer; cdecl; external Qt5PasLib name 'QPaintDevice_width';
function QPaintDevice_height(handle: QPaintDeviceH): Integer; cdecl; external Qt5PasLib name 'QPaintDevice_height';
function QPaintDevice_widthMM(handle: QPaintDeviceH): Integer; cdecl; external Qt5PasLib name 'QPaintDevice_widthMM';
function QPaintDevice_heightMM(handle: QPaintDeviceH): Integer; cdecl; external Qt5PasLib name 'QPaintDevice_heightMM';
function QPaintDevice_logicalDpiX(handle: QPaintDeviceH): Integer; cdecl; external Qt5PasLib name 'QPaintDevice_logicalDpiX';
function QPaintDevice_logicalDpiY(handle: QPaintDeviceH): Integer; cdecl; external Qt5PasLib name 'QPaintDevice_logicalDpiY';
function QPaintDevice_physicalDpiX(handle: QPaintDeviceH): Integer; cdecl; external Qt5PasLib name 'QPaintDevice_physicalDpiX';
function QPaintDevice_physicalDpiY(handle: QPaintDeviceH): Integer; cdecl; external Qt5PasLib name 'QPaintDevice_physicalDpiY';
function QPaintDevice_devicePixelRatio(handle: QPaintDeviceH): Integer; cdecl; external Qt5PasLib name 'QPaintDevice_devicePixelRatio';
function QPaintDevice_devicePixelRatioF(handle: QPaintDeviceH): double; cdecl; external Qt5PasLib name 'QPaintDevice_devicePixelRatioF';
function QPaintDevice_colorCount(handle: QPaintDeviceH): Integer; cdecl; external Qt5PasLib name 'QPaintDevice_colorCount';
function QPaintDevice_depth(handle: QPaintDeviceH): Integer; cdecl; external Qt5PasLib name 'QPaintDevice_depth';


type
  QRegionRegionType = ( // QRegion::RegionType (1)
    QRegionRectangle, QRegionEllipse );

function QRegion_Create(): QRegionH; cdecl; external Qt5PasLib name 'QRegion_Create';
procedure QRegion_Destroy(handle: QRegionH); cdecl; external Qt5PasLib name 'QRegion_Destroy'; 
function QRegion_Create(x: Integer; y: Integer; w: Integer; h: Integer; t: QRegionRegionType = QRegionRectangle): QRegionH; cdecl; external Qt5PasLib name 'QRegion_Create2';
function QRegion_Create(r: PRect; t: QRegionRegionType = QRegionRectangle): QRegionH; cdecl; external Qt5PasLib name 'QRegion_Create3';
function QRegion_Create(pa: QPolygonH; fillRule: QtFillRule = QtOddEvenFill): QRegionH; cdecl; external Qt5PasLib name 'QRegion_Create4';
function QRegion_Create(region: QRegionH): QRegionH; cdecl; external Qt5PasLib name 'QRegion_Create5';
function QRegion_Create(bitmap: QBitmapH): QRegionH; cdecl; external Qt5PasLib name 'QRegion_Create6';
procedure QRegion_swap(handle: QRegionH; other: QRegionH); cdecl; external Qt5PasLib name 'QRegion_swap';
function QRegion_isEmpty(handle: QRegionH): Boolean; cdecl; external Qt5PasLib name 'QRegion_isEmpty';
function QRegion_isNull(handle: QRegionH): Boolean; cdecl; external Qt5PasLib name 'QRegion_isNull';
function QRegion_contains(handle: QRegionH; p: PQtPoint): Boolean; cdecl; external Qt5PasLib name 'QRegion_contains';
function QRegion_contains(handle: QRegionH; r: PRect): Boolean; cdecl; external Qt5PasLib name 'QRegion_contains2';
procedure QRegion_translate(handle: QRegionH; dx: Integer; dy: Integer); cdecl; external Qt5PasLib name 'QRegion_translate';
procedure QRegion_translate(handle: QRegionH; p: PQtPoint); cdecl; external Qt5PasLib name 'QRegion_translate2';
procedure QRegion_translated(handle: QRegionH; retval: QRegionH; dx: Integer; dy: Integer); cdecl; external Qt5PasLib name 'QRegion_translated';
procedure QRegion_translated(handle: QRegionH; retval: QRegionH; p: PQtPoint); cdecl; external Qt5PasLib name 'QRegion_translated2';
procedure QRegion_united(handle: QRegionH; retval: QRegionH; r: QRegionH); cdecl; external Qt5PasLib name 'QRegion_united';
procedure QRegion_united(handle: QRegionH; retval: QRegionH; r: PRect); cdecl; external Qt5PasLib name 'QRegion_united2';
procedure QRegion_intersected(handle: QRegionH; retval: QRegionH; r: QRegionH); cdecl; external Qt5PasLib name 'QRegion_intersected';
procedure QRegion_intersected(handle: QRegionH; retval: QRegionH; r: PRect); cdecl; external Qt5PasLib name 'QRegion_intersected2';
procedure QRegion_subtracted(handle: QRegionH; retval: QRegionH; r: QRegionH); cdecl; external Qt5PasLib name 'QRegion_subtracted';
procedure QRegion_xored(handle: QRegionH; retval: QRegionH; r: QRegionH); cdecl; external Qt5PasLib name 'QRegion_xored';
function QRegion_intersects(handle: QRegionH; r: QRegionH): Boolean; cdecl; external Qt5PasLib name 'QRegion_intersects';
function QRegion_intersects(handle: QRegionH; r: PRect): Boolean; cdecl; external Qt5PasLib name 'QRegion_intersects2';
procedure QRegion_boundingRect(handle: QRegionH; retval: PRect); cdecl; external Qt5PasLib name 'QRegion_boundingRect';
procedure QRegion_setRects(handle: QRegionH; rect: PRect; num: Integer); cdecl; external Qt5PasLib name 'QRegion_setRects';
function QRegion_rectCount(handle: QRegionH): Integer; cdecl; external Qt5PasLib name 'QRegion_rectCount';


type
  QPainterPathElementType = ( // QPainterPath::ElementType (1)
    QPainterPathMoveToElement, QPainterPathLineToElement, QPainterPathCurveToElement, QPainterPathCurveToDataElement );

function QPainterPath_Create(): QPainterPathH; cdecl; external Qt5PasLib name 'QPainterPath_Create';
procedure QPainterPath_Destroy(handle: QPainterPathH); cdecl; external Qt5PasLib name 'QPainterPath_Destroy'; 
function QPainterPath_Create(startPoint: PQtPointF): QPainterPathH; cdecl; external Qt5PasLib name 'QPainterPath_Create2';
function QPainterPath_Create(other: QPainterPathH): QPainterPathH; cdecl; external Qt5PasLib name 'QPainterPath_Create3';
procedure QPainterPath_swap(handle: QPainterPathH; other: QPainterPathH); cdecl; external Qt5PasLib name 'QPainterPath_swap';
procedure QPainterPath_closeSubpath(handle: QPainterPathH); cdecl; external Qt5PasLib name 'QPainterPath_closeSubpath';
procedure QPainterPath_moveTo(handle: QPainterPathH; p: PQtPointF); cdecl; external Qt5PasLib name 'QPainterPath_moveTo';
procedure QPainterPath_moveTo(handle: QPainterPathH; x: qreal; y: qreal); cdecl; external Qt5PasLib name 'QPainterPath_moveTo2';
procedure QPainterPath_lineTo(handle: QPainterPathH; p: PQtPointF); cdecl; external Qt5PasLib name 'QPainterPath_lineTo';
procedure QPainterPath_lineTo(handle: QPainterPathH; x: qreal; y: qreal); cdecl; external Qt5PasLib name 'QPainterPath_lineTo2';
procedure QPainterPath_arcMoveTo(handle: QPainterPathH; rect: QRectFH; angle: qreal); cdecl; external Qt5PasLib name 'QPainterPath_arcMoveTo';
procedure QPainterPath_arcMoveTo(handle: QPainterPathH; x: qreal; y: qreal; w: qreal; h: qreal; angle: qreal); cdecl; external Qt5PasLib name 'QPainterPath_arcMoveTo2';
procedure QPainterPath_arcTo(handle: QPainterPathH; rect: QRectFH; startAngle: qreal; arcLength: qreal); cdecl; external Qt5PasLib name 'QPainterPath_arcTo';
procedure QPainterPath_arcTo(handle: QPainterPathH; x: qreal; y: qreal; w: qreal; h: qreal; startAngle: qreal; arcLength: qreal); cdecl; external Qt5PasLib name 'QPainterPath_arcTo2';
procedure QPainterPath_cubicTo(handle: QPainterPathH; ctrlPt1: PQtPointF; ctrlPt2: PQtPointF; endPt: PQtPointF); cdecl; external Qt5PasLib name 'QPainterPath_cubicTo';
procedure QPainterPath_cubicTo(handle: QPainterPathH; ctrlPt1x: qreal; ctrlPt1y: qreal; ctrlPt2x: qreal; ctrlPt2y: qreal; endPtx: qreal; endPty: qreal); cdecl; external Qt5PasLib name 'QPainterPath_cubicTo2';
procedure QPainterPath_quadTo(handle: QPainterPathH; ctrlPt: PQtPointF; endPt: PQtPointF); cdecl; external Qt5PasLib name 'QPainterPath_quadTo';
procedure QPainterPath_quadTo(handle: QPainterPathH; ctrlPtx: qreal; ctrlPty: qreal; endPtx: qreal; endPty: qreal); cdecl; external Qt5PasLib name 'QPainterPath_quadTo2';
procedure QPainterPath_currentPosition(handle: QPainterPathH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QPainterPath_currentPosition';
procedure QPainterPath_addRect(handle: QPainterPathH; rect: QRectFH); cdecl; external Qt5PasLib name 'QPainterPath_addRect';
procedure QPainterPath_addRect(handle: QPainterPathH; x: qreal; y: qreal; w: qreal; h: qreal); cdecl; external Qt5PasLib name 'QPainterPath_addRect2';
procedure QPainterPath_addEllipse(handle: QPainterPathH; rect: QRectFH); cdecl; external Qt5PasLib name 'QPainterPath_addEllipse';
procedure QPainterPath_addEllipse(handle: QPainterPathH; x: qreal; y: qreal; w: qreal; h: qreal); cdecl; external Qt5PasLib name 'QPainterPath_addEllipse2';
procedure QPainterPath_addEllipse(handle: QPainterPathH; center: PQtPointF; rx: qreal; ry: qreal); cdecl; external Qt5PasLib name 'QPainterPath_addEllipse3';
procedure QPainterPath_addPolygon(handle: QPainterPathH; polygon: QPolygonFH); cdecl; external Qt5PasLib name 'QPainterPath_addPolygon';
procedure QPainterPath_addText(handle: QPainterPathH; point: PQtPointF; f: QFontH; text: PWideString); cdecl; external Qt5PasLib name 'QPainterPath_addText';
procedure QPainterPath_addText(handle: QPainterPathH; x: qreal; y: qreal; f: QFontH; text: PWideString); cdecl; external Qt5PasLib name 'QPainterPath_addText2';
procedure QPainterPath_addPath(handle: QPainterPathH; path: QPainterPathH); cdecl; external Qt5PasLib name 'QPainterPath_addPath';
procedure QPainterPath_addRegion(handle: QPainterPathH; region: QRegionH); cdecl; external Qt5PasLib name 'QPainterPath_addRegion';
procedure QPainterPath_addRoundedRect(handle: QPainterPathH; rect: QRectFH; xRadius: qreal; yRadius: qreal; mode: QtSizeMode = QtAbsoluteSize); cdecl; external Qt5PasLib name 'QPainterPath_addRoundedRect';
procedure QPainterPath_addRoundedRect(handle: QPainterPathH; x: qreal; y: qreal; w: qreal; h: qreal; xRadius: qreal; yRadius: qreal; mode: QtSizeMode = QtAbsoluteSize); cdecl; external Qt5PasLib name 'QPainterPath_addRoundedRect2';
procedure QPainterPath_addRoundRect(handle: QPainterPathH; rect: QRectFH; xRnd: Integer; yRnd: Integer); cdecl; external Qt5PasLib name 'QPainterPath_addRoundRect';
procedure QPainterPath_addRoundRect(handle: QPainterPathH; x: qreal; y: qreal; w: qreal; h: qreal; xRnd: Integer; yRnd: Integer); cdecl; external Qt5PasLib name 'QPainterPath_addRoundRect2';
procedure QPainterPath_addRoundRect(handle: QPainterPathH; rect: QRectFH; roundness: Integer); cdecl; external Qt5PasLib name 'QPainterPath_addRoundRect3';
procedure QPainterPath_addRoundRect(handle: QPainterPathH; x: qreal; y: qreal; w: qreal; h: qreal; roundness: Integer); cdecl; external Qt5PasLib name 'QPainterPath_addRoundRect4';
procedure QPainterPath_connectPath(handle: QPainterPathH; path: QPainterPathH); cdecl; external Qt5PasLib name 'QPainterPath_connectPath';
function QPainterPath_contains(handle: QPainterPathH; pt: PQtPointF): Boolean; cdecl; external Qt5PasLib name 'QPainterPath_contains';
function QPainterPath_contains(handle: QPainterPathH; rect: QRectFH): Boolean; cdecl; external Qt5PasLib name 'QPainterPath_contains2';
function QPainterPath_intersects(handle: QPainterPathH; rect: QRectFH): Boolean; cdecl; external Qt5PasLib name 'QPainterPath_intersects';
procedure QPainterPath_translate(handle: QPainterPathH; dx: qreal; dy: qreal); cdecl; external Qt5PasLib name 'QPainterPath_translate';
procedure QPainterPath_translate(handle: QPainterPathH; offset: PQtPointF); cdecl; external Qt5PasLib name 'QPainterPath_translate2';
procedure QPainterPath_translated(handle: QPainterPathH; retval: QPainterPathH; dx: qreal; dy: qreal); cdecl; external Qt5PasLib name 'QPainterPath_translated';
procedure QPainterPath_translated(handle: QPainterPathH; retval: QPainterPathH; offset: PQtPointF); cdecl; external Qt5PasLib name 'QPainterPath_translated2';
procedure QPainterPath_boundingRect(handle: QPainterPathH; retval: QRectFH); cdecl; external Qt5PasLib name 'QPainterPath_boundingRect';
procedure QPainterPath_controlPointRect(handle: QPainterPathH; retval: QRectFH); cdecl; external Qt5PasLib name 'QPainterPath_controlPointRect';
function QPainterPath_fillRule(handle: QPainterPathH): QtFillRule; cdecl; external Qt5PasLib name 'QPainterPath_fillRule';
procedure QPainterPath_setFillRule(handle: QPainterPathH; fillRule: QtFillRule); cdecl; external Qt5PasLib name 'QPainterPath_setFillRule';
function QPainterPath_isEmpty(handle: QPainterPathH): Boolean; cdecl; external Qt5PasLib name 'QPainterPath_isEmpty';
procedure QPainterPath_toReversed(handle: QPainterPathH; retval: QPainterPathH); cdecl; external Qt5PasLib name 'QPainterPath_toReversed';
procedure QPainterPath_toFillPolygon(handle: QPainterPathH; retval: QPolygonFH; matrix: QMatrixH = nil); cdecl; external Qt5PasLib name 'QPainterPath_toFillPolygon';
procedure QPainterPath_toFillPolygon(handle: QPainterPathH; retval: QPolygonFH; matrix: QTransformH); cdecl; external Qt5PasLib name 'QPainterPath_toFillPolygon2';
function QPainterPath_elementCount(handle: QPainterPathH): Integer; cdecl; external Qt5PasLib name 'QPainterPath_elementCount';
procedure QPainterPath_setElementPositionAt(handle: QPainterPathH; i: Integer; x: qreal; y: qreal); cdecl; external Qt5PasLib name 'QPainterPath_setElementPositionAt';
function QPainterPath_length(handle: QPainterPathH): qreal; cdecl; external Qt5PasLib name 'QPainterPath_length';
function QPainterPath_percentAtLength(handle: QPainterPathH; t: qreal): qreal; cdecl; external Qt5PasLib name 'QPainterPath_percentAtLength';
procedure QPainterPath_pointAtPercent(handle: QPainterPathH; retval: PQtPointF; t: qreal); cdecl; external Qt5PasLib name 'QPainterPath_pointAtPercent';
function QPainterPath_angleAtPercent(handle: QPainterPathH; t: qreal): qreal; cdecl; external Qt5PasLib name 'QPainterPath_angleAtPercent';
function QPainterPath_slopeAtPercent(handle: QPainterPathH; t: qreal): qreal; cdecl; external Qt5PasLib name 'QPainterPath_slopeAtPercent';
function QPainterPath_intersects(handle: QPainterPathH; p: QPainterPathH): Boolean; cdecl; external Qt5PasLib name 'QPainterPath_intersects2';
function QPainterPath_contains(handle: QPainterPathH; p: QPainterPathH): Boolean; cdecl; external Qt5PasLib name 'QPainterPath_contains3';
procedure QPainterPath_united(handle: QPainterPathH; retval: QPainterPathH; r: QPainterPathH); cdecl; external Qt5PasLib name 'QPainterPath_united';
procedure QPainterPath_intersected(handle: QPainterPathH; retval: QPainterPathH; r: QPainterPathH); cdecl; external Qt5PasLib name 'QPainterPath_intersected';
procedure QPainterPath_subtracted(handle: QPainterPathH; retval: QPainterPathH; r: QPainterPathH); cdecl; external Qt5PasLib name 'QPainterPath_subtracted';
procedure QPainterPath_subtractedInverted(handle: QPainterPathH; retval: QPainterPathH; r: QPainterPathH); cdecl; external Qt5PasLib name 'QPainterPath_subtractedInverted';
procedure QPainterPath_simplified(handle: QPainterPathH; retval: QPainterPathH); cdecl; external Qt5PasLib name 'QPainterPath_simplified';

function QPainterPathStroker_Create(): QPainterPathStrokerH; cdecl; external Qt5PasLib name 'QPainterPathStroker_Create';
procedure QPainterPathStroker_Destroy(handle: QPainterPathStrokerH); cdecl; external Qt5PasLib name 'QPainterPathStroker_Destroy'; 
procedure QPainterPathStroker_setWidth(handle: QPainterPathStrokerH; width: qreal); cdecl; external Qt5PasLib name 'QPainterPathStroker_setWidth';
function QPainterPathStroker_width(handle: QPainterPathStrokerH): qreal; cdecl; external Qt5PasLib name 'QPainterPathStroker_width';
procedure QPainterPathStroker_setCapStyle(handle: QPainterPathStrokerH; style: QtPenCapStyle); cdecl; external Qt5PasLib name 'QPainterPathStroker_setCapStyle';
function QPainterPathStroker_capStyle(handle: QPainterPathStrokerH): QtPenCapStyle; cdecl; external Qt5PasLib name 'QPainterPathStroker_capStyle';
procedure QPainterPathStroker_setJoinStyle(handle: QPainterPathStrokerH; style: QtPenJoinStyle); cdecl; external Qt5PasLib name 'QPainterPathStroker_setJoinStyle';
function QPainterPathStroker_joinStyle(handle: QPainterPathStrokerH): QtPenJoinStyle; cdecl; external Qt5PasLib name 'QPainterPathStroker_joinStyle';
procedure QPainterPathStroker_setMiterLimit(handle: QPainterPathStrokerH; length: qreal); cdecl; external Qt5PasLib name 'QPainterPathStroker_setMiterLimit';
function QPainterPathStroker_miterLimit(handle: QPainterPathStrokerH): qreal; cdecl; external Qt5PasLib name 'QPainterPathStroker_miterLimit';
procedure QPainterPathStroker_setCurveThreshold(handle: QPainterPathStrokerH; threshold: qreal); cdecl; external Qt5PasLib name 'QPainterPathStroker_setCurveThreshold';
function QPainterPathStroker_curveThreshold(handle: QPainterPathStrokerH): qreal; cdecl; external Qt5PasLib name 'QPainterPathStroker_curveThreshold';
procedure QPainterPathStroker_setDashPattern(handle: QPainterPathStrokerH; AnonParam1: QtPenStyle); cdecl; external Qt5PasLib name 'QPainterPathStroker_setDashPattern';
procedure QPainterPathStroker_setDashPattern(handle: QPainterPathStrokerH; dashPattern: PQRealArray); cdecl; external Qt5PasLib name 'QPainterPathStroker_setDashPattern2';
procedure QPainterPathStroker_dashPattern(handle: QPainterPathStrokerH; retval: PQRealArray); cdecl; external Qt5PasLib name 'QPainterPathStroker_dashPattern';
procedure QPainterPathStroker_setDashOffset(handle: QPainterPathStrokerH; offset: qreal); cdecl; external Qt5PasLib name 'QPainterPathStroker_setDashOffset';
function QPainterPathStroker_dashOffset(handle: QPainterPathStrokerH): qreal; cdecl; external Qt5PasLib name 'QPainterPathStroker_dashOffset';
procedure QPainterPathStroker_createStroke(handle: QPainterPathStrokerH; retval: QPainterPathH; path: QPainterPathH); cdecl; external Qt5PasLib name 'QPainterPathStroker_createStroke';


type
  QTransformTransformationType = (  //QTransform::TransformationType (2)
    QTransformTxNone = $00,
    QTransformTxTranslate = $01,
    QTransformTxScale = $02,
    QTransformTxRotate = $04,
    QTransformTxShear = $08,
    QTransformTxProject = $10 );

function QTransform_Create(AnonParam1: QtInitialization): QTransformH; cdecl; external Qt5PasLib name 'QTransform_Create';
procedure QTransform_Destroy(handle: QTransformH); cdecl; external Qt5PasLib name 'QTransform_Destroy'; 
function QTransform_Create(): QTransformH; cdecl; external Qt5PasLib name 'QTransform_Create2';
function QTransform_Create(h11: qreal; h12: qreal; h13: qreal; h21: qreal; h22: qreal; h23: qreal; h31: qreal; h32: qreal; h33: qreal = 1.0): QTransformH; cdecl; external Qt5PasLib name 'QTransform_Create3';
function QTransform_Create(h11: qreal; h12: qreal; h21: qreal; h22: qreal; dx: qreal; dy: qreal): QTransformH; cdecl; external Qt5PasLib name 'QTransform_Create4';
function QTransform_Create(mtx: QMatrixH): QTransformH; cdecl; external Qt5PasLib name 'QTransform_Create5';
function QTransform_isAffine(handle: QTransformH): Boolean; cdecl; external Qt5PasLib name 'QTransform_isAffine';
function QTransform_isIdentity(handle: QTransformH): Boolean; cdecl; external Qt5PasLib name 'QTransform_isIdentity';
function QTransform_isInvertible(handle: QTransformH): Boolean; cdecl; external Qt5PasLib name 'QTransform_isInvertible';
function QTransform_isScaling(handle: QTransformH): Boolean; cdecl; external Qt5PasLib name 'QTransform_isScaling';
function QTransform_isRotating(handle: QTransformH): Boolean; cdecl; external Qt5PasLib name 'QTransform_isRotating';
function QTransform_isTranslating(handle: QTransformH): Boolean; cdecl; external Qt5PasLib name 'QTransform_isTranslating';
function QTransform_type(handle: QTransformH): QTransformTransformationType; cdecl; external Qt5PasLib name 'QTransform_type';
function QTransform_determinant(handle: QTransformH): qreal; cdecl; external Qt5PasLib name 'QTransform_determinant';
function QTransform_det(handle: QTransformH): qreal; cdecl; external Qt5PasLib name 'QTransform_det';
function QTransform_m11(handle: QTransformH): qreal; cdecl; external Qt5PasLib name 'QTransform_m11';
function QTransform_m12(handle: QTransformH): qreal; cdecl; external Qt5PasLib name 'QTransform_m12';
function QTransform_m13(handle: QTransformH): qreal; cdecl; external Qt5PasLib name 'QTransform_m13';
function QTransform_m21(handle: QTransformH): qreal; cdecl; external Qt5PasLib name 'QTransform_m21';
function QTransform_m22(handle: QTransformH): qreal; cdecl; external Qt5PasLib name 'QTransform_m22';
function QTransform_m23(handle: QTransformH): qreal; cdecl; external Qt5PasLib name 'QTransform_m23';
function QTransform_m31(handle: QTransformH): qreal; cdecl; external Qt5PasLib name 'QTransform_m31';
function QTransform_m32(handle: QTransformH): qreal; cdecl; external Qt5PasLib name 'QTransform_m32';
function QTransform_m33(handle: QTransformH): qreal; cdecl; external Qt5PasLib name 'QTransform_m33';
function QTransform_dx(handle: QTransformH): qreal; cdecl; external Qt5PasLib name 'QTransform_dx';
function QTransform_dy(handle: QTransformH): qreal; cdecl; external Qt5PasLib name 'QTransform_dy';
procedure QTransform_setMatrix(handle: QTransformH; m11: qreal; m12: qreal; m13: qreal; m21: qreal; m22: qreal; m23: qreal; m31: qreal; m32: qreal; m33: qreal); cdecl; external Qt5PasLib name 'QTransform_setMatrix';
procedure QTransform_inverted(handle: QTransformH; retval: QTransformH; invertible: PBoolean = nil); cdecl; external Qt5PasLib name 'QTransform_inverted';
procedure QTransform_adjoint(handle: QTransformH; retval: QTransformH); cdecl; external Qt5PasLib name 'QTransform_adjoint';
procedure QTransform_transposed(handle: QTransformH; retval: QTransformH); cdecl; external Qt5PasLib name 'QTransform_transposed';
function QTransform_translate(handle: QTransformH; dx: qreal; dy: qreal): QTransformH; cdecl; external Qt5PasLib name 'QTransform_translate';
function QTransform_scale(handle: QTransformH; sx: qreal; sy: qreal): QTransformH; cdecl; external Qt5PasLib name 'QTransform_scale';
function QTransform_shear(handle: QTransformH; sh: qreal; sv: qreal): QTransformH; cdecl; external Qt5PasLib name 'QTransform_shear';
function QTransform_rotate(handle: QTransformH; a: qreal; axis: QtAxis = QtZAxis): QTransformH; cdecl; external Qt5PasLib name 'QTransform_rotate';
function QTransform_rotateRadians(handle: QTransformH; a: qreal; axis: QtAxis = QtZAxis): QTransformH; cdecl; external Qt5PasLib name 'QTransform_rotateRadians';
function QTransform_squareToQuad(square: QPolygonFH; result: QTransformH): Boolean; cdecl; external Qt5PasLib name 'QTransform_squareToQuad';
function QTransform_quadToSquare(quad: QPolygonFH; result: QTransformH): Boolean; cdecl; external Qt5PasLib name 'QTransform_quadToSquare';
function QTransform_quadToQuad(one: QPolygonFH; two: QPolygonFH; result: QTransformH): Boolean; cdecl; external Qt5PasLib name 'QTransform_quadToQuad';
procedure QTransform_reset(handle: QTransformH); cdecl; external Qt5PasLib name 'QTransform_reset';
procedure QTransform_map(handle: QTransformH; retval: PQtPoint; p: PQtPoint); cdecl; external Qt5PasLib name 'QTransform_map';
procedure QTransform_map(handle: QTransformH; retval: PQtPointF; p: PQtPointF); cdecl; external Qt5PasLib name 'QTransform_map2';
procedure QTransform_map(handle: QTransformH; retval: QLineH; l: QLineH); cdecl; external Qt5PasLib name 'QTransform_map3';
procedure QTransform_map(handle: QTransformH; retval: QLineFH; l: QLineFH); cdecl; external Qt5PasLib name 'QTransform_map4';
procedure QTransform_map(handle: QTransformH; retval: QPolygonFH; a: QPolygonFH); cdecl; external Qt5PasLib name 'QTransform_map5';
procedure QTransform_map(handle: QTransformH; retval: QPolygonH; a: QPolygonH); cdecl; external Qt5PasLib name 'QTransform_map6';
procedure QTransform_map(handle: QTransformH; retval: QRegionH; r: QRegionH); cdecl; external Qt5PasLib name 'QTransform_map7';
procedure QTransform_map(handle: QTransformH; retval: QPainterPathH; p: QPainterPathH); cdecl; external Qt5PasLib name 'QTransform_map8';
procedure QTransform_mapToPolygon(handle: QTransformH; retval: QPolygonH; r: PRect); cdecl; external Qt5PasLib name 'QTransform_mapToPolygon';
procedure QTransform_mapRect(handle: QTransformH; retval: PRect; AnonParam1: PRect); cdecl; external Qt5PasLib name 'QTransform_mapRect';
procedure QTransform_mapRect(handle: QTransformH; retval: QRectFH; AnonParam1: QRectFH); cdecl; external Qt5PasLib name 'QTransform_mapRect2';
procedure QTransform_map(handle: QTransformH; x: Integer; y: Integer; tx: PInteger; ty: PInteger); cdecl; external Qt5PasLib name 'QTransform_map9';
procedure QTransform_map(handle: QTransformH; x: qreal; y: qreal; tx: PQReal; ty: PQReal); cdecl; external Qt5PasLib name 'QTransform_map10';
function QTransform_toAffine(handle: QTransformH): QMatrixH; cdecl; external Qt5PasLib name 'QTransform_toAffine';
procedure QTransform_fromTranslate(retval: QTransformH; dx: qreal; dy: qreal); cdecl; external Qt5PasLib name 'QTransform_fromTranslate';
procedure QTransform_fromScale(retval: QTransformH; dx: qreal; dy: qreal); cdecl; external Qt5PasLib name 'QTransform_fromScale';

type
  QPagedPaintDevicePageSize = cardinal; //  QPagedPaintDevice::PageSize (4)

const
    QPagedPaintDeviceA4 = 0 { $0 };
    QPagedPaintDeviceB5 = 1 { $1 };
    QPagedPaintDeviceLetter = 2 { $2 };
    QPagedPaintDeviceLegal = 3 { $3 };
    QPagedPaintDeviceExecutive = 4 { $4 };
    QPagedPaintDeviceA0 = 5 { $5 };
    QPagedPaintDeviceA1 = 6 { $6 };
    QPagedPaintDeviceA2 = 7 { $7 };
    QPagedPaintDeviceA3 = 8 { $8 };
    QPagedPaintDeviceA5 = 9 { $9 };
    QPagedPaintDeviceA6 = 10 { $a };
    QPagedPaintDeviceA7 = 11 { $b };
    QPagedPaintDeviceA8 = 12 { $c };
    QPagedPaintDeviceA9 = 13 { $d };
    QPagedPaintDeviceB0 = 14 { $e };
    QPagedPaintDeviceB1 = 15 { $f };
    QPagedPaintDeviceB10 = 16 { $10 };
    QPagedPaintDeviceB2 = 17 { $11 };
    QPagedPaintDeviceB3 = 18 { $12 };
    QPagedPaintDeviceB4 = 19 { $13 };
    QPagedPaintDeviceB6 = 20 { $14 };
    QPagedPaintDeviceB7 = 21 { $15 };
    QPagedPaintDeviceB8 = 22 { $16 };
    QPagedPaintDeviceB9 = 23 { $17 };
    QPagedPaintDeviceC5E = 24 { $18 };
    QPagedPaintDeviceComm10E = 25 { $19 };
    QPagedPaintDeviceDLE = 26 { $1a };
    QPagedPaintDeviceFolio = 27 { $1b };
    QPagedPaintDeviceLedger = 28 { $1c };
    QPagedPaintDeviceTabloid = 29 { $1d };
    QPagedPaintDeviceCustom = 30 { $1e };
    QPagedPaintDeviceNPageSize = 30 { $1e };


function QPagedPaintDevice_newPage(handle: QPagedPaintDeviceH): Boolean; cdecl; external Qt5PasLib name 'QPagedPaintDevice_newPage';
procedure QPagedPaintDevice_setPageSize(handle: QPagedPaintDeviceH; size: QPagedPaintDevicePageSize); cdecl; external Qt5PasLib name 'QPagedPaintDevice_setPageSize';
function QPagedPaintDevice_pageSize(handle: QPagedPaintDeviceH): QPagedPaintDevicePageSize; cdecl; external Qt5PasLib name 'QPagedPaintDevice_pageSize';
procedure QPagedPaintDevice_setPageSizeMM(handle: QPagedPaintDeviceH; size: QSizeFH); cdecl; external Qt5PasLib name 'QPagedPaintDevice_setPageSizeMM';
procedure QPagedPaintDevice_pageSizeMM(handle: QPagedPaintDeviceH; retval: QSizeFH); cdecl; external Qt5PasLib name 'QPagedPaintDevice_pageSizeMM';


type
  QPrinterPrinterMode = ( // QPrinter::PrinterMode (1)
    QPrinterScreenResolution, QPrinterPrinterResolution, QPrinterHighResolution );

  QPrinterOrientation = ( // QPrinter::Orientation (1)
    QPrinterPortrait, QPrinterLandscape );

  QPrinterPageOrder = ( // QPrinter::PageOrder (1)
    QPrinterFirstPageFirst, QPrinterLastPageFirst );

  QPrinterColorMode = ( // QPrinter::ColorMode (1)
    QPrinterGrayScale, QPrinterColor );

  QPrinterPaperSource = ( // QPrinter::PaperSource (1)
    QPrinterOnlyOne, QPrinterLower, QPrinterMiddle, QPrinterManual, QPrinterEnvelope, QPrinterEnvelopeManual, QPrinterAuto, QPrinterTractor, QPrinterSmallFormat, QPrinterLargeFormat, QPrinterLargeCapacity, 
    QPrinterCassette, QPrinterFormSource, QPrinterMaxPageSource );

  QPrinterPrinterState = ( // QPrinter::PrinterState (1)
    QPrinterIdle, QPrinterActive, QPrinterAborted, QPrinterError );

  QPrinterOutputFormat = ( // QPrinter::OutputFormat (1)
    QPrinterNativeFormat, QPrinterPdfFormat );

  QPrinterPrintRange = ( // QPrinter::PrintRange (1)
    QPrinterAllPages, QPrinterSelection, QPrinterPageRange, QPrinterCurrentPage );

  QPrinterUnit = ( // QPrinter::Unit (1)
    QPrinterMillimeter, QPrinterPoint, QPrinterInch, QPrinterPica, QPrinterDidot, QPrinterCicero, QPrinterDevicePixel );

  QPrinterDuplexMode = (  //QPrinter::DuplexMode (2)
    QPrinterDuplexNone = 0,
    QPrinterDuplexAuto,
    QPrinterDuplexLongSide,
    QPrinterDuplexShortSide );

function QPrinter_Create(mode: QPrinterPrinterMode = QPrinterScreenResolution): QPrinterH; cdecl; external Qt5PasLib name 'QPrinter_Create';
procedure QPrinter_Destroy(handle: QPrinterH); cdecl; external Qt5PasLib name 'QPrinter_Destroy'; 
function QPrinter_Create(printer: QPrinterInfoH; mode: QPrinterPrinterMode = QPrinterScreenResolution): QPrinterH; cdecl; external Qt5PasLib name 'QPrinter_Create2';
function QPrinter_devType(handle: QPrinterH): Integer; cdecl; external Qt5PasLib name 'QPrinter_devType';
procedure QPrinter_setOutputFormat(handle: QPrinterH; format: QPrinterOutputFormat); cdecl; external Qt5PasLib name 'QPrinter_setOutputFormat';
function QPrinter_outputFormat(handle: QPrinterH): QPrinterOutputFormat; cdecl; external Qt5PasLib name 'QPrinter_outputFormat';
procedure QPrinter_setPrinterName(handle: QPrinterH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QPrinter_setPrinterName';
procedure QPrinter_printerName(handle: QPrinterH; retval: PWideString); cdecl; external Qt5PasLib name 'QPrinter_printerName';
function QPrinter_isValid(handle: QPrinterH): Boolean; cdecl; external Qt5PasLib name 'QPrinter_isValid';
procedure QPrinter_setOutputFileName(handle: QPrinterH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QPrinter_setOutputFileName';
procedure QPrinter_outputFileName(handle: QPrinterH; retval: PWideString); cdecl; external Qt5PasLib name 'QPrinter_outputFileName';
procedure QPrinter_setPrintProgram(handle: QPrinterH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QPrinter_setPrintProgram';
procedure QPrinter_printProgram(handle: QPrinterH; retval: PWideString); cdecl; external Qt5PasLib name 'QPrinter_printProgram';
procedure QPrinter_setDocName(handle: QPrinterH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QPrinter_setDocName';
procedure QPrinter_docName(handle: QPrinterH; retval: PWideString); cdecl; external Qt5PasLib name 'QPrinter_docName';
procedure QPrinter_setCreator(handle: QPrinterH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QPrinter_setCreator';
procedure QPrinter_creator(handle: QPrinterH; retval: PWideString); cdecl; external Qt5PasLib name 'QPrinter_creator';
procedure QPrinter_setOrientation(handle: QPrinterH; AnonParam1: QPrinterOrientation); cdecl; external Qt5PasLib name 'QPrinter_setOrientation';
function QPrinter_orientation(handle: QPrinterH): QPrinterOrientation; cdecl; external Qt5PasLib name 'QPrinter_orientation';
procedure QPrinter_setPageSizeMM(handle: QPrinterH; size: QSizeFH); cdecl; external Qt5PasLib name 'QPrinter_setPageSizeMM';
procedure QPrinter_setPaperSize(handle: QPrinterH; AnonParam1: QPagedPaintDevicePageSize); cdecl; external Qt5PasLib name 'QPrinter_setPaperSize';
function QPrinter_paperSize(handle: QPrinterH): QPagedPaintDevicePageSize; cdecl; external Qt5PasLib name 'QPrinter_paperSize';
procedure QPrinter_setPaperSize(handle: QPrinterH; paperSize: QSizeFH; _unit: QPrinterUnit); cdecl; external Qt5PasLib name 'QPrinter_setPaperSize2';
procedure QPrinter_paperSize(handle: QPrinterH; retval: QSizeFH; _unit: QPrinterUnit); cdecl; external Qt5PasLib name 'QPrinter_paperSize2';
procedure QPrinter_setPaperName(handle: QPrinterH; paperName: PWideString); cdecl; external Qt5PasLib name 'QPrinter_setPaperName';
procedure QPrinter_paperName(handle: QPrinterH; retval: PWideString); cdecl; external Qt5PasLib name 'QPrinter_paperName';
procedure QPrinter_setPageOrder(handle: QPrinterH; AnonParam1: QPrinterPageOrder); cdecl; external Qt5PasLib name 'QPrinter_setPageOrder';
function QPrinter_pageOrder(handle: QPrinterH): QPrinterPageOrder; cdecl; external Qt5PasLib name 'QPrinter_pageOrder';
procedure QPrinter_setResolution(handle: QPrinterH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QPrinter_setResolution';
function QPrinter_resolution(handle: QPrinterH): Integer; cdecl; external Qt5PasLib name 'QPrinter_resolution';
procedure QPrinter_setColorMode(handle: QPrinterH; AnonParam1: QPrinterColorMode); cdecl; external Qt5PasLib name 'QPrinter_setColorMode';
function QPrinter_colorMode(handle: QPrinterH): QPrinterColorMode; cdecl; external Qt5PasLib name 'QPrinter_colorMode';
procedure QPrinter_setCollateCopies(handle: QPrinterH; collate: Boolean); cdecl; external Qt5PasLib name 'QPrinter_setCollateCopies';
function QPrinter_collateCopies(handle: QPrinterH): Boolean; cdecl; external Qt5PasLib name 'QPrinter_collateCopies';
procedure QPrinter_setFullPage(handle: QPrinterH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QPrinter_setFullPage';
function QPrinter_fullPage(handle: QPrinterH): Boolean; cdecl; external Qt5PasLib name 'QPrinter_fullPage';
procedure QPrinter_setNumCopies(handle: QPrinterH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QPrinter_setNumCopies';
function QPrinter_numCopies(handle: QPrinterH): Integer; cdecl; external Qt5PasLib name 'QPrinter_numCopies';
function QPrinter_actualNumCopies(handle: QPrinterH): Integer; cdecl; external Qt5PasLib name 'QPrinter_actualNumCopies';
procedure QPrinter_setCopyCount(handle: QPrinterH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QPrinter_setCopyCount';
function QPrinter_copyCount(handle: QPrinterH): Integer; cdecl; external Qt5PasLib name 'QPrinter_copyCount';
function QPrinter_supportsMultipleCopies(handle: QPrinterH): Boolean; cdecl; external Qt5PasLib name 'QPrinter_supportsMultipleCopies';
procedure QPrinter_setPaperSource(handle: QPrinterH; AnonParam1: QPrinterPaperSource); cdecl; external Qt5PasLib name 'QPrinter_setPaperSource';
function QPrinter_paperSource(handle: QPrinterH): QPrinterPaperSource; cdecl; external Qt5PasLib name 'QPrinter_paperSource';
procedure QPrinter_setDuplex(handle: QPrinterH; duplex: QPrinterDuplexMode); cdecl; external Qt5PasLib name 'QPrinter_setDuplex';
function QPrinter_duplex(handle: QPrinterH): QPrinterDuplexMode; cdecl; external Qt5PasLib name 'QPrinter_duplex';
procedure QPrinter_supportedResolutions(handle: QPrinterH; retval: PPtrIntArray); cdecl; external Qt5PasLib name 'QPrinter_supportedResolutions';
procedure QPrinter_setFontEmbeddingEnabled(handle: QPrinterH; enable: Boolean); cdecl; external Qt5PasLib name 'QPrinter_setFontEmbeddingEnabled';
function QPrinter_fontEmbeddingEnabled(handle: QPrinterH): Boolean; cdecl; external Qt5PasLib name 'QPrinter_fontEmbeddingEnabled';
procedure QPrinter_setDoubleSidedPrinting(handle: QPrinterH; enable: Boolean); cdecl; external Qt5PasLib name 'QPrinter_setDoubleSidedPrinting';
function QPrinter_doubleSidedPrinting(handle: QPrinterH): Boolean; cdecl; external Qt5PasLib name 'QPrinter_doubleSidedPrinting';
procedure QPrinter_paperRect(handle: QPrinterH; retval: PRect); cdecl; external Qt5PasLib name 'QPrinter_paperRect';
procedure QPrinter_pageRect(handle: QPrinterH; retval: PRect); cdecl; external Qt5PasLib name 'QPrinter_pageRect';
procedure QPrinter_paperRect(handle: QPrinterH; retval: QRectFH; AnonParam1: QPrinterUnit); cdecl; external Qt5PasLib name 'QPrinter_paperRect2';
procedure QPrinter_pageRect(handle: QPrinterH; retval: QRectFH; AnonParam1: QPrinterUnit); cdecl; external Qt5PasLib name 'QPrinter_pageRect2';
{$ifdef BINUX or DARWIN }
procedure QPrinter_printerSelectionOption(handle: QPrinterH; retval: PWideString); cdecl; external Qt5PasLib name 'QPrinter_printerSelectionOption';
procedure QPrinter_setPrinterSelectionOption(handle: QPrinterH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QPrinter_setPrinterSelectionOption';
{$endif}
function QPrinter_newPage(handle: QPrinterH): Boolean; cdecl; external Qt5PasLib name 'QPrinter_newPage';
function QPrinter_abort(handle: QPrinterH): Boolean; cdecl; external Qt5PasLib name 'QPrinter_abort';
function QPrinter_printerState(handle: QPrinterH): QPrinterPrinterState; cdecl; external Qt5PasLib name 'QPrinter_printerState';
function QPrinter_paintEngine(handle: QPrinterH): QPaintEngineH; cdecl; external Qt5PasLib name 'QPrinter_paintEngine';
function QPrinter_printEngine(handle: QPrinterH): QPrintEngineH; cdecl; external Qt5PasLib name 'QPrinter_printEngine';
procedure QPrinter_setFromTo(handle: QPrinterH; fromPage: Integer; toPage: Integer); cdecl; external Qt5PasLib name 'QPrinter_setFromTo';
function QPrinter_fromPage(handle: QPrinterH): Integer; cdecl; external Qt5PasLib name 'QPrinter_fromPage';
function QPrinter_toPage(handle: QPrinterH): Integer; cdecl; external Qt5PasLib name 'QPrinter_toPage';
procedure QPrinter_setPrintRange(handle: QPrinterH; range: QPrinterPrintRange); cdecl; external Qt5PasLib name 'QPrinter_setPrintRange';
function QPrinter_printRange(handle: QPrinterH): QPrinterPrintRange; cdecl; external Qt5PasLib name 'QPrinter_printRange';
procedure QPrinter_setPageMargins(handle: QPrinterH; left: qreal; top: qreal; right: qreal; bottom: qreal; _unit: QPrinterUnit); cdecl; external Qt5PasLib name 'QPrinter_setPageMargins';
procedure QPrinter_getPageMargins(handle: QPrinterH; left: PQReal; top: PQReal; right: PQReal; bottom: PQReal; _unit: QPrinterUnit); cdecl; external Qt5PasLib name 'QPrinter_getPageMargins';
{$ifdef MSWINDOWS }
procedure QPrinter_setWinPageSize(handle: QPrinterH; winPageSize: Integer); cdecl; external Qt5PasLib name 'QPrinter_setWinPageSize';
function QPrinter_winPageSize(handle: QPrinterH): Integer; cdecl; external Qt5PasLib name 'QPrinter_winPageSize';
{$endif}

function QPrinterInfo_Create(): QPrinterInfoH; cdecl; external Qt5PasLib name 'QPrinterInfo_Create';
procedure QPrinterInfo_Destroy(handle: QPrinterInfoH); cdecl; external Qt5PasLib name 'QPrinterInfo_Destroy'; 
function QPrinterInfo_Create(other: QPrinterInfoH): QPrinterInfoH; cdecl; external Qt5PasLib name 'QPrinterInfo_Create2';
function QPrinterInfo_Create(printer: QPrinterH): QPrinterInfoH; cdecl; external Qt5PasLib name 'QPrinterInfo_Create3';
procedure QPrinterInfo_printerName(handle: QPrinterInfoH; retval: PWideString); cdecl; external Qt5PasLib name 'QPrinterInfo_printerName';
procedure QPrinterInfo_description(handle: QPrinterInfoH; retval: PWideString); cdecl; external Qt5PasLib name 'QPrinterInfo_description';
procedure QPrinterInfo_location(handle: QPrinterInfoH; retval: PWideString); cdecl; external Qt5PasLib name 'QPrinterInfo_location';
procedure QPrinterInfo_makeAndModel(handle: QPrinterInfoH; retval: PWideString); cdecl; external Qt5PasLib name 'QPrinterInfo_makeAndModel';
function QPrinterInfo_isNull(handle: QPrinterInfoH): Boolean; cdecl; external Qt5PasLib name 'QPrinterInfo_isNull';
function QPrinterInfo_isDefault(handle: QPrinterInfoH): Boolean; cdecl; external Qt5PasLib name 'QPrinterInfo_isDefault';
procedure QPrinterInfo_supportedPaperSizes(handle: QPrinterInfoH; retval: PPtrIntArray); cdecl; external Qt5PasLib name 'QPrinterInfo_supportedPaperSizes';
procedure QPrinterInfo_availablePrinters(retval: PPtrIntArray); cdecl; external Qt5PasLib name 'QPrinterInfo_availablePrinters';
procedure QPrinterInfo_availablePrinterNames(retval: QStringListH); cdecl; external Qt5PasLib name 'QPrinterInfo_availablePrinterNames';
procedure QPrinterInfo_defaultPrinter(retval: QPrinterInfoH); cdecl; external Qt5PasLib name 'QPrinterInfo_defaultPrinter';
procedure QPrinterInfo_printerInfo(retval: QPrinterInfoH; printerName: PWideString); cdecl; external Qt5PasLib name 'QPrinterInfo_printerInfo';


type
  QFontStyle = ( // QFont::Style (1)
    QFontStyleNormal, QFontStyleItalic, QFontStyleOblique );

  QFontCapitalization = ( // QFont::Capitalization (1)
    QFontMixedCase, QFontAllUppercase, QFontAllLowercase, QFontSmallCaps, QFontCapitalize );

  QFontSpacingType = ( // QFont::SpacingType (1)
    QFontPercentageSpacing, QFontAbsoluteSpacing );

  QFontStyleStrategy = (  //QFont::StyleStrategy (2)
    QFontPreferDefault = $0001,
    QFontPreferBitmap = $0002,
    QFontPreferDevice = $0004,
    QFontPreferOutline = $0008,
    QFontForceOutline = $0010,
    QFontPreferMatch = $0020,
    QFontPreferQuality = $0040,
    QFontPreferAntialias = $0080,
    QFontNoAntialias = $0100,
    QFontOpenGLCompatible = $0200,
    QFontForceIntegerMetrics = $0400,
    QFontNoFontMerging = $8000 );

  QFontHintingPreference = (  //QFont::HintingPreference (2)
    QFontPreferDefaultHinting = 0,
    QFontPreferNoHinting = 1,
    QFontPreferVerticalHinting = 2,
    QFontPreferFullHinting = 3 );

  QFontWeight = (  //QFont::Weight (2)
    QFontLight = 25,
    QFontNormal = 50,
    QFontDemiBold = 63,
    QFontBold = 75,
    QFontBlack = 87 );

  QFontStretch = (  //QFont::Stretch (2)
    QFontUltraCondensed = 50,
    QFontExtraCondensed = 62,
    QFontCondensed = 75,
    QFontSemiCondensed = 87,
    QFontUnstretched = 100,
    QFontSemiExpanded = 112,
    QFontExpanded = 125,
    QFontExtraExpanded = 150,
    QFontUltraExpanded = 200 );

  QFontResolveProperties = (  //QFont::ResolveProperties (2)
    QFontFamilyResolved = $0001,
    QFontSizeResolved = $0002,
    QFontStyleHintResolved = $0004,
    QFontStyleStrategyResolved = $0008,
    QFontWeightResolved = $0010,
    QFontStyleResolved = $0020,
    QFontUnderlineResolved = $0040,
    QFontOverlineResolved = $0080,
    QFontStrikeOutResolved = $0100,
    QFontFixedPitchResolved = $0200,
    QFontStretchResolved = $0400,
    QFontKerningResolved = $0800,
    QFontCapitalizationResolved = $1000,
    QFontLetterSpacingResolved = $2000,
    QFontWordSpacingResolved = $4000,
    QFontHintingPreferenceResolved = $8000,
    QFontStyleNameResolved = $10000,
    QFontAllPropertiesResolved = $1ffff );

type
  QFontStyleHint = cardinal; //  QFont::StyleHint (4)

const
    QFontHelvetica = 0 { $0 };
    QFontSansSerif = 0 { $0 };
    QFontTimes = 1 { $1 };
    QFontSerif = 1 { $1 };
    QFontCourier = 2 { $2 };
    QFontTypeWriter = 2 { $2 };
    QFontOldEnglish = 3 { $3 };
    QFontDecorative = 3 { $3 };
    QFontSystem = 4 { $4 };
    QFontAnyStyle = 5 { $5 };
    QFontCursive = 6 { $6 };
    QFontMonospace = 7 { $7 };
    QFontFantasy = 8 { $8 };


function QFont_Create(): QFontH; cdecl; external Qt5PasLib name 'QFont_Create';
procedure QFont_Destroy(handle: QFontH); cdecl; external Qt5PasLib name 'QFont_Destroy'; 
function QFont_Create(family: PWideString; pointSize: Integer = -1; weight: Integer = -1; italic: Boolean = False): QFontH; cdecl; external Qt5PasLib name 'QFont_Create2';
function QFont_Create(AnonParam1: QFontH; pd: QPaintDeviceH): QFontH; cdecl; external Qt5PasLib name 'QFont_Create3';
function QFont_Create(AnonParam1: QFontH): QFontH; cdecl; external Qt5PasLib name 'QFont_Create4';
procedure QFont_swap(handle: QFontH; other: QFontH); cdecl; external Qt5PasLib name 'QFont_swap';
procedure QFont_family(handle: QFontH; retval: PWideString); cdecl; external Qt5PasLib name 'QFont_family';
procedure QFont_setFamily(handle: QFontH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QFont_setFamily';
procedure QFont_styleName(handle: QFontH; retval: PWideString); cdecl; external Qt5PasLib name 'QFont_styleName';
procedure QFont_setStyleName(handle: QFontH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QFont_setStyleName';
function QFont_pointSize(handle: QFontH): Integer; cdecl; external Qt5PasLib name 'QFont_pointSize';
procedure QFont_setPointSize(handle: QFontH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QFont_setPointSize';
function QFont_pointSizeF(handle: QFontH): qreal; cdecl; external Qt5PasLib name 'QFont_pointSizeF';
procedure QFont_setPointSizeF(handle: QFontH; AnonParam1: qreal); cdecl; external Qt5PasLib name 'QFont_setPointSizeF';
function QFont_pixelSize(handle: QFontH): Integer; cdecl; external Qt5PasLib name 'QFont_pixelSize';
procedure QFont_setPixelSize(handle: QFontH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QFont_setPixelSize';
function QFont_weight(handle: QFontH): Integer; cdecl; external Qt5PasLib name 'QFont_weight';
procedure QFont_setWeight(handle: QFontH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QFont_setWeight';
function QFont_bold(handle: QFontH): Boolean; cdecl; external Qt5PasLib name 'QFont_bold';
procedure QFont_setBold(handle: QFontH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QFont_setBold';
procedure QFont_setStyle(handle: QFontH; style: QFontStyle); cdecl; external Qt5PasLib name 'QFont_setStyle';
function QFont_style(handle: QFontH): QFontStyle; cdecl; external Qt5PasLib name 'QFont_style';
function QFont_italic(handle: QFontH): Boolean; cdecl; external Qt5PasLib name 'QFont_italic';
procedure QFont_setItalic(handle: QFontH; b: Boolean); cdecl; external Qt5PasLib name 'QFont_setItalic';
function QFont_underline(handle: QFontH): Boolean; cdecl; external Qt5PasLib name 'QFont_underline';
procedure QFont_setUnderline(handle: QFontH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QFont_setUnderline';
function QFont_overline(handle: QFontH): Boolean; cdecl; external Qt5PasLib name 'QFont_overline';
procedure QFont_setOverline(handle: QFontH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QFont_setOverline';
function QFont_strikeOut(handle: QFontH): Boolean; cdecl; external Qt5PasLib name 'QFont_strikeOut';
procedure QFont_setStrikeOut(handle: QFontH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QFont_setStrikeOut';
function QFont_fixedPitch(handle: QFontH): Boolean; cdecl; external Qt5PasLib name 'QFont_fixedPitch';
procedure QFont_setFixedPitch(handle: QFontH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QFont_setFixedPitch';
function QFont_kerning(handle: QFontH): Boolean; cdecl; external Qt5PasLib name 'QFont_kerning';
procedure QFont_setKerning(handle: QFontH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QFont_setKerning';
function QFont_styleHint(handle: QFontH): QFontStyleHint; cdecl; external Qt5PasLib name 'QFont_styleHint';
function QFont_styleStrategy(handle: QFontH): QFontStyleStrategy; cdecl; external Qt5PasLib name 'QFont_styleStrategy';
procedure QFont_setStyleHint(handle: QFontH; AnonParam1: QFontStyleHint; AnonParam2: QFontStyleStrategy = QFontPreferDefault); cdecl; external Qt5PasLib name 'QFont_setStyleHint';
procedure QFont_setStyleStrategy(handle: QFontH; s: QFontStyleStrategy); cdecl; external Qt5PasLib name 'QFont_setStyleStrategy';
function QFont_stretch(handle: QFontH): Integer; cdecl; external Qt5PasLib name 'QFont_stretch';
procedure QFont_setStretch(handle: QFontH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QFont_setStretch';
function QFont_letterSpacing(handle: QFontH): qreal; cdecl; external Qt5PasLib name 'QFont_letterSpacing';
function QFont_letterSpacingType(handle: QFontH): QFontSpacingType; cdecl; external Qt5PasLib name 'QFont_letterSpacingType';
procedure QFont_setLetterSpacing(handle: QFontH; _type: QFontSpacingType; spacing: qreal); cdecl; external Qt5PasLib name 'QFont_setLetterSpacing';
function QFont_wordSpacing(handle: QFontH): qreal; cdecl; external Qt5PasLib name 'QFont_wordSpacing';
procedure QFont_setWordSpacing(handle: QFontH; spacing: qreal); cdecl; external Qt5PasLib name 'QFont_setWordSpacing';
procedure QFont_setCapitalization(handle: QFontH; AnonParam1: QFontCapitalization); cdecl; external Qt5PasLib name 'QFont_setCapitalization';
function QFont_capitalization(handle: QFontH): QFontCapitalization; cdecl; external Qt5PasLib name 'QFont_capitalization';
procedure QFont_setHintingPreference(handle: QFontH; hintingPreference: QFontHintingPreference); cdecl; external Qt5PasLib name 'QFont_setHintingPreference';
function QFont_hintingPreference(handle: QFontH): QFontHintingPreference; cdecl; external Qt5PasLib name 'QFont_hintingPreference';
function QFont_rawMode(handle: QFontH): Boolean; cdecl; external Qt5PasLib name 'QFont_rawMode';
procedure QFont_setRawMode(handle: QFontH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QFont_setRawMode';
function QFont_exactMatch(handle: QFontH): Boolean; cdecl; external Qt5PasLib name 'QFont_exactMatch';
function QFont_isCopyOf(handle: QFontH; AnonParam1: QFontH): Boolean; cdecl; external Qt5PasLib name 'QFont_isCopyOf';
procedure QFont_setRawName(handle: QFontH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QFont_setRawName';
procedure QFont_rawName(handle: QFontH; retval: PWideString); cdecl; external Qt5PasLib name 'QFont_rawName';
procedure QFont_key(handle: QFontH; retval: PWideString); cdecl; external Qt5PasLib name 'QFont_key';
procedure QFont_toString(handle: QFontH; retval: PWideString); cdecl; external Qt5PasLib name 'QFont_toString';
function QFont_fromString(handle: QFontH; AnonParam1: PWideString): Boolean; cdecl; external Qt5PasLib name 'QFont_fromString';
procedure QFont_substitute(retval: PWideString; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QFont_substitute';
procedure QFont_substitutes(retval: QStringListH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QFont_substitutes';
procedure QFont_substitutions(retval: QStringListH); cdecl; external Qt5PasLib name 'QFont_substitutions';
procedure QFont_insertSubstitution(AnonParam1: PWideString; AnonParam2: PWideString); cdecl; external Qt5PasLib name 'QFont_insertSubstitution';
procedure QFont_insertSubstitutions(AnonParam1: PWideString; AnonParam2: QStringListH); cdecl; external Qt5PasLib name 'QFont_insertSubstitutions';
procedure QFont_removeSubstitutions(AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QFont_removeSubstitutions';
procedure QFont_initialize(); cdecl; external Qt5PasLib name 'QFont_initialize';
procedure QFont_cleanup(); cdecl; external Qt5PasLib name 'QFont_cleanup';
procedure QFont_cacheStatistics(); cdecl; external Qt5PasLib name 'QFont_cacheStatistics';
procedure QFont_defaultFamily(handle: QFontH; retval: PWideString); cdecl; external Qt5PasLib name 'QFont_defaultFamily';
procedure QFont_lastResortFamily(handle: QFontH; retval: PWideString); cdecl; external Qt5PasLib name 'QFont_lastResortFamily';
procedure QFont_lastResortFont(handle: QFontH; retval: PWideString); cdecl; external Qt5PasLib name 'QFont_lastResortFont';
procedure QFont_resolve(handle: QFontH; retval: QFontH; AnonParam1: QFontH); cdecl; external Qt5PasLib name 'QFont_resolve';
function QFont_resolve(handle: QFontH): LongWord; cdecl; external Qt5PasLib name 'QFont_resolve2';
procedure QFont_resolve(handle: QFontH; mask: LongWord); cdecl; external Qt5PasLib name 'QFont_resolve3';

type
  QFontDatabaseWritingSystem = cardinal; //  QFontDatabase::WritingSystem (4)

const
    QFontDatabaseAny = 0 { $0 };
    QFontDatabaseLatin = 1 { $1 };
    QFontDatabaseGreek = 2 { $2 };
    QFontDatabaseCyrillic = 3 { $3 };
    QFontDatabaseArmenian = 4 { $4 };
    QFontDatabaseHebrew = 5 { $5 };
    QFontDatabaseArabic = 6 { $6 };
    QFontDatabaseSyriac = 7 { $7 };
    QFontDatabaseThaana = 8 { $8 };
    QFontDatabaseDevanagari = 9 { $9 };
    QFontDatabaseBengali = 10 { $a };
    QFontDatabaseGurmukhi = 11 { $b };
    QFontDatabaseGujarati = 12 { $c };
    QFontDatabaseOriya = 13 { $d };
    QFontDatabaseTamil = 14 { $e };
    QFontDatabaseTelugu = 15 { $f };
    QFontDatabaseKannada = 16 { $10 };
    QFontDatabaseMalayalam = 17 { $11 };
    QFontDatabaseSinhala = 18 { $12 };
    QFontDatabaseThai = 19 { $13 };
    QFontDatabaseLao = 20 { $14 };
    QFontDatabaseTibetan = 21 { $15 };
    QFontDatabaseMyanmar = 22 { $16 };
    QFontDatabaseGeorgian = 23 { $17 };
    QFontDatabaseKhmer = 24 { $18 };
    QFontDatabaseSimplifiedChinese = 25 { $19 };
    QFontDatabaseTraditionalChinese = 26 { $1a };
    QFontDatabaseJapanese = 27 { $1b };
    QFontDatabaseKorean = 28 { $1c };
    QFontDatabaseVietnamese = 29 { $1d };
    QFontDatabaseSymbol = 30 { $1e };
    QFontDatabaseOther = 30 { $1e };
    QFontDatabaseOgham = 31 { $1f };
    QFontDatabaseRunic = 32 { $20 };
    QFontDatabaseNko = 33 { $21 };
    QFontDatabaseWritingSystemsCount = 34 { $22 };


procedure QFontDatabase_standardSizes(retval: PPtrIntArray); cdecl; external Qt5PasLib name 'QFontDatabase_standardSizes';
function QFontDatabase_Create(): QFontDatabaseH; cdecl; external Qt5PasLib name 'QFontDatabase_Create';
procedure QFontDatabase_Destroy(handle: QFontDatabaseH); cdecl; external Qt5PasLib name 'QFontDatabase_Destroy'; 
procedure QFontDatabase_writingSystems(handle: QFontDatabaseH; retval: PPtrIntArray); cdecl; external Qt5PasLib name 'QFontDatabase_writingSystems';
procedure QFontDatabase_writingSystems(handle: QFontDatabaseH; retval: PPtrIntArray; family: PWideString); cdecl; external Qt5PasLib name 'QFontDatabase_writingSystems2';
procedure QFontDatabase_families(handle: QFontDatabaseH; retval: QStringListH; writingSystem: QFontDatabaseWritingSystem = QFontDatabaseAny); cdecl; external Qt5PasLib name 'QFontDatabase_families';
procedure QFontDatabase_styles(handle: QFontDatabaseH; retval: QStringListH; family: PWideString); cdecl; external Qt5PasLib name 'QFontDatabase_styles';
procedure QFontDatabase_pointSizes(handle: QFontDatabaseH; retval: PPtrIntArray; family: PWideString; style: PWideString = nil); cdecl; external Qt5PasLib name 'QFontDatabase_pointSizes';
procedure QFontDatabase_smoothSizes(handle: QFontDatabaseH; retval: PPtrIntArray; family: PWideString; style: PWideString); cdecl; external Qt5PasLib name 'QFontDatabase_smoothSizes';
procedure QFontDatabase_styleString(handle: QFontDatabaseH; retval: PWideString; font: QFontH); cdecl; external Qt5PasLib name 'QFontDatabase_styleString';
procedure QFontDatabase_styleString(handle: QFontDatabaseH; retval: PWideString; fontInfo: QFontInfoH); cdecl; external Qt5PasLib name 'QFontDatabase_styleString2';
procedure QFontDatabase_font(handle: QFontDatabaseH; retval: QFontH; family: PWideString; style: PWideString; pointSize: Integer); cdecl; external Qt5PasLib name 'QFontDatabase_font';
function QFontDatabase_isBitmapScalable(handle: QFontDatabaseH; family: PWideString; style: PWideString = nil): Boolean; cdecl; external Qt5PasLib name 'QFontDatabase_isBitmapScalable';
function QFontDatabase_isSmoothlyScalable(handle: QFontDatabaseH; family: PWideString; style: PWideString = nil): Boolean; cdecl; external Qt5PasLib name 'QFontDatabase_isSmoothlyScalable';
function QFontDatabase_isScalable(handle: QFontDatabaseH; family: PWideString; style: PWideString = nil): Boolean; cdecl; external Qt5PasLib name 'QFontDatabase_isScalable';
function QFontDatabase_isFixedPitch(handle: QFontDatabaseH; family: PWideString; style: PWideString = nil): Boolean; cdecl; external Qt5PasLib name 'QFontDatabase_isFixedPitch';
function QFontDatabase_italic(handle: QFontDatabaseH; family: PWideString; style: PWideString): Boolean; cdecl; external Qt5PasLib name 'QFontDatabase_italic';
function QFontDatabase_bold(handle: QFontDatabaseH; family: PWideString; style: PWideString): Boolean; cdecl; external Qt5PasLib name 'QFontDatabase_bold';
function QFontDatabase_weight(handle: QFontDatabaseH; family: PWideString; style: PWideString): Integer; cdecl; external Qt5PasLib name 'QFontDatabase_weight';
function QFontDatabase_hasFamily(handle: QFontDatabaseH; family: PWideString): Boolean; cdecl; external Qt5PasLib name 'QFontDatabase_hasFamily';
procedure QFontDatabase_writingSystemName(retval: PWideString; writingSystem: QFontDatabaseWritingSystem); cdecl; external Qt5PasLib name 'QFontDatabase_writingSystemName';
procedure QFontDatabase_writingSystemSample(retval: PWideString; writingSystem: QFontDatabaseWritingSystem); cdecl; external Qt5PasLib name 'QFontDatabase_writingSystemSample';
function QFontDatabase_addApplicationFont(fileName: PWideString): Integer; cdecl; external Qt5PasLib name 'QFontDatabase_addApplicationFont';
function QFontDatabase_addApplicationFontFromData(fontData: QByteArrayH): Integer; cdecl; external Qt5PasLib name 'QFontDatabase_addApplicationFontFromData';
procedure QFontDatabase_applicationFontFamilies(retval: QStringListH; id: Integer); cdecl; external Qt5PasLib name 'QFontDatabase_applicationFontFamilies';
function QFontDatabase_removeApplicationFont(id: Integer): Boolean; cdecl; external Qt5PasLib name 'QFontDatabase_removeApplicationFont';
function QFontDatabase_removeAllApplicationFonts(): Boolean; cdecl; external Qt5PasLib name 'QFontDatabase_removeAllApplicationFonts';
function QFontDatabase_supportsThreadedFontRendering(): Boolean; cdecl; external Qt5PasLib name 'QFontDatabase_supportsThreadedFontRendering';


type
  QTextLengthType = (  //QTextLength::Type (2)
    QTextLengthVariableLength = 0,
    QTextLengthFixedLength,
    QTextLengthPercentageLength );


type
  QTextFormatFormatType = (  //QTextFormat::FormatType (2)
    QTextFormatInvalidFormat = -1,
    QTextFormatBlockFormat = 1,
    QTextFormatCharFormat = 2,
    QTextFormatListFormat = 3,
    QTextFormatTableFormat = 4,
    QTextFormatFrameFormat = 5,
    QTextFormatUserFormat = 100 );

  QTextFormatObjectTypes = (  //QTextFormat::ObjectTypes (2)
    QTextFormatNoObject,
    QTextFormatImageObject,
    QTextFormatTableObject,
    QTextFormatTableCellObject,
    QTextFormatUserObject = $1000 );

type
  QTextFormatPageBreakFlag = cardinal; // QTextFormat::PageBreakFlag
  QTextFormatPageBreakFlags = QTextFormatPageBreakFlag; //QFlags<> (3)
const
  QTextFormatPageBreak_Auto =   0;
  QTextFormatPageBreak_AlwaysBefore =   $001;
  QTextFormatPageBreak_AlwaysAfter =   $010;


type
  QTextCharFormatUnderlineStyle = ( // QTextCharFormat::UnderlineStyle (1)
    QTextCharFormatNoUnderline, QTextCharFormatSingleUnderline, QTextCharFormatDashUnderline, QTextCharFormatDotLine, QTextCharFormatDashDotLine, QTextCharFormatDashDotDotLine, QTextCharFormatWaveUnderline, 
    QTextCharFormatSpellCheckUnderline );

  QTextCharFormatVerticalAlignment = (  //QTextCharFormat::VerticalAlignment (2)
    QTextCharFormatAlignNormal = 0,
    QTextCharFormatAlignSuperScript,
    QTextCharFormatAlignSubScript,
    QTextCharFormatAlignMiddle,
    QTextCharFormatAlignTop,
    QTextCharFormatAlignBottom,
    QTextCharFormatAlignBaseline );


type
  QTextBlockFormatLineHeightTypes = (  //QTextBlockFormat::LineHeightTypes (2)
    QTextBlockFormatSingleHeight = 0,
    QTextBlockFormatProportionalHeight = 1,
    QTextBlockFormatFixedHeight = 2,
    QTextBlockFormatMinimumHeight = 3,
    QTextBlockFormatLineDistanceHeight = 4 );


type
  QTextListFormatStyle = (  //QTextListFormat::Style (2)
    QTextListFormatListUpperRoman = -8,
    QTextListFormatListLowerRoman = -7,
    QTextListFormatListUpperAlpha = -6,
    QTextListFormatListLowerAlpha = -5,
    QTextListFormatListDecimal = -4,
    QTextListFormatListSquare = -3,
    QTextListFormatListCircle = -2,
    QTextListFormatListDisc = -1,
    QTextListFormatListStyleUndefined = 0 );


type
  QTextFrameFormatPosition = ( // QTextFrameFormat::Position (1)
    QTextFrameFormatInFlow, QTextFrameFormatFloatLeft, QTextFrameFormatFloatRight );

  QTextFrameFormatBorderStyle = ( // QTextFrameFormat::BorderStyle (1)
    QTextFrameFormatBorderStyle_None, QTextFrameFormatBorderStyle_Dotted, QTextFrameFormatBorderStyle_Dashed, QTextFrameFormatBorderStyle_Solid, QTextFrameFormatBorderStyle_Double, QTextFrameFormatBorderStyle_DotDash, 
    QTextFrameFormatBorderStyle_DotDotDash, QTextFrameFormatBorderStyle_Groove, QTextFrameFormatBorderStyle_Ridge, QTextFrameFormatBorderStyle_Inset, QTextFrameFormatBorderStyle_Outset );

type
  QTextFormatProperty = cardinal; //  QTextFormat::Property (4)

const
    QTextFormatObjectIndex = 0 { $0 };
    QTextFormatCssFloat = 2048 { $800 };
    QTextFormatLayoutDirection = 2049 { $801 };
    QTextFormatOutlinePen = 2064 { $810 };
    QTextFormatBackgroundBrush = 2080 { $820 };
    QTextFormatForegroundBrush = 2081 { $821 };
    QTextFormatBackgroundImageUrl = 2083 { $823 };
    QTextFormatBlockAlignment = 4112 { $1010 };
    QTextFormatBlockTopMargin = 4144 { $1030 };
    QTextFormatBlockBottomMargin = 4145 { $1031 };
    QTextFormatBlockLeftMargin = 4146 { $1032 };
    QTextFormatBlockRightMargin = 4147 { $1033 };
    QTextFormatTextIndent = 4148 { $1034 };
    QTextFormatTabPositions = 4149 { $1035 };
    QTextFormatBlockIndent = 4160 { $1040 };
    QTextFormatLineHeight = 4168 { $1048 };
    QTextFormatLineHeightType = 4169 { $1049 };
    QTextFormatBlockNonBreakableLines = 4176 { $1050 };
    QTextFormatBlockTrailingHorizontalRulerWidth = 4192 { $1060 };
    QTextFormatFirstFontProperty = 8160 { $1fe0 };
    QTextFormatFontCapitalization = 8160 { $1fe0 };
    QTextFormatFontLetterSpacingType = 8243 { $2033 };
    QTextFormatFontLetterSpacing = 8161 { $1fe1 };
    QTextFormatFontWordSpacing = 8162 { $1fe2 };
    QTextFormatFontStretch = 8244 { $2034 };
    QTextFormatFontStyleHint = 8163 { $1fe3 };
    QTextFormatFontStyleStrategy = 8164 { $1fe4 };
    QTextFormatFontKerning = 8165 { $1fe5 };
    QTextFormatFontHintingPreference = 8166 { $1fe6 };
    QTextFormatFontFamily = 8192 { $2000 };
    QTextFormatFontPointSize = 8193 { $2001 };
    QTextFormatFontSizeAdjustment = 8194 { $2002 };
    QTextFormatFontSizeIncrement = 8194 { $2002 };
    QTextFormatFontWeight = 8195 { $2003 };
    QTextFormatFontItalic = 8196 { $2004 };
    QTextFormatFontUnderline = 8197 { $2005 };
    QTextFormatFontOverline = 8198 { $2006 };
    QTextFormatFontStrikeOut = 8199 { $2007 };
    QTextFormatFontFixedPitch = 8200 { $2008 };
    QTextFormatFontPixelSize = 8201 { $2009 };
    QTextFormatLastFontProperty = 8201 { $2009 };
    QTextFormatTextUnderlineColor = 8208 { $2010 };
    QTextFormatTextVerticalAlignment = 8225 { $2021 };
    QTextFormatTextOutline = 8226 { $2022 };
    QTextFormatTextUnderlineStyle = 8227 { $2023 };
    QTextFormatTextToolTip = 8228 { $2024 };
    QTextFormatIsAnchor = 8240 { $2030 };
    QTextFormatAnchorHref = 8241 { $2031 };
    QTextFormatAnchorName = 8242 { $2032 };
    QTextFormatObjectType = 12032 { $2f00 };
    QTextFormatListStyle = 12288 { $3000 };
    QTextFormatListIndent = 12289 { $3001 };
    QTextFormatListNumberPrefix = 12290 { $3002 };
    QTextFormatListNumberSuffix = 12291 { $3003 };
    QTextFormatFrameBorder = 16384 { $4000 };
    QTextFormatFrameMargin = 16385 { $4001 };
    QTextFormatFramePadding = 16386 { $4002 };
    QTextFormatFrameWidth = 16387 { $4003 };
    QTextFormatFrameHeight = 16388 { $4004 };
    QTextFormatFrameTopMargin = 16389 { $4005 };
    QTextFormatFrameBottomMargin = 16390 { $4006 };
    QTextFormatFrameLeftMargin = 16391 { $4007 };
    QTextFormatFrameRightMargin = 16392 { $4008 };
    QTextFormatFrameBorderBrush = 16393 { $4009 };
    QTextFormatFrameBorderStyle = 16400 { $4010 };
    QTextFormatTableColumns = 16640 { $4100 };
    QTextFormatTableColumnWidthConstraints = 16641 { $4101 };
    QTextFormatTableCellSpacing = 16642 { $4102 };
    QTextFormatTableCellPadding = 16643 { $4103 };
    QTextFormatTableHeaderRowCount = 16644 { $4104 };
    QTextFormatTableCellRowSpan = 18448 { $4810 };
    QTextFormatTableCellColumnSpan = 18449 { $4811 };
    QTextFormatTableCellTopPadding = 18450 { $4812 };
    QTextFormatTableCellBottomPadding = 18451 { $4813 };
    QTextFormatTableCellLeftPadding = 18452 { $4814 };
    QTextFormatTableCellRightPadding = 18453 { $4815 };
    QTextFormatImageName = 20480 { $5000 };
    QTextFormatImageWidth = 20496 { $5010 };
    QTextFormatImageHeight = 20497 { $5011 };
    QTextFormatFullWidthSelection = 24576 { $6000 };
    QTextFormatPageBreakPolicy = 28672 { $7000 };
    QTextFormatUserProperty = 1048576 { $100000 };


function QTextLength_Create(): QTextLengthH; cdecl; external Qt5PasLib name 'QTextLength_Create';
procedure QTextLength_Destroy(handle: QTextLengthH); cdecl; external Qt5PasLib name 'QTextLength_Destroy'; 
function QTextLength_Create(_type: QTextLengthType; value: qreal): QTextLengthH; cdecl; external Qt5PasLib name 'QTextLength_Create2';
function QTextLength_type(handle: QTextLengthH): QTextLengthType; cdecl; external Qt5PasLib name 'QTextLength_type';
function QTextLength_value(handle: QTextLengthH; maximumLength: qreal): qreal; cdecl; external Qt5PasLib name 'QTextLength_value';
function QTextLength_rawValue(handle: QTextLengthH): qreal; cdecl; external Qt5PasLib name 'QTextLength_rawValue';

function QTextFormat_Create(): QTextFormatH; cdecl; external Qt5PasLib name 'QTextFormat_Create';
procedure QTextFormat_Destroy(handle: QTextFormatH); cdecl; external Qt5PasLib name 'QTextFormat_Destroy'; 
function QTextFormat_Create(_type: Integer): QTextFormatH; cdecl; external Qt5PasLib name 'QTextFormat_Create2';
function QTextFormat_Create(rhs: QTextFormatH): QTextFormatH; cdecl; external Qt5PasLib name 'QTextFormat_Create3';
procedure QTextFormat_swap(handle: QTextFormatH; other: QTextFormatH); cdecl; external Qt5PasLib name 'QTextFormat_swap';
procedure QTextFormat_merge(handle: QTextFormatH; other: QTextFormatH); cdecl; external Qt5PasLib name 'QTextFormat_merge';
function QTextFormat_isEmpty(handle: QTextFormatH): Boolean; cdecl; external Qt5PasLib name 'QTextFormat_isEmpty';
function QTextFormat_isValid(handle: QTextFormatH): Boolean; cdecl; external Qt5PasLib name 'QTextFormat_isValid';
function QTextFormat_type(handle: QTextFormatH): Integer; cdecl; external Qt5PasLib name 'QTextFormat_type';
function QTextFormat_objectIndex(handle: QTextFormatH): Integer; cdecl; external Qt5PasLib name 'QTextFormat_objectIndex';
procedure QTextFormat_setObjectIndex(handle: QTextFormatH; _object: Integer); cdecl; external Qt5PasLib name 'QTextFormat_setObjectIndex';
procedure QTextFormat_property(handle: QTextFormatH; retval: QVariantH; propertyId: Integer); cdecl; external Qt5PasLib name 'QTextFormat_property';
procedure QTextFormat_setProperty(handle: QTextFormatH; propertyId: Integer; value: QVariantH); cdecl; external Qt5PasLib name 'QTextFormat_setProperty';
procedure QTextFormat_clearProperty(handle: QTextFormatH; propertyId: Integer); cdecl; external Qt5PasLib name 'QTextFormat_clearProperty';
function QTextFormat_hasProperty(handle: QTextFormatH; propertyId: Integer): Boolean; cdecl; external Qt5PasLib name 'QTextFormat_hasProperty';
function QTextFormat_boolProperty(handle: QTextFormatH; propertyId: Integer): Boolean; cdecl; external Qt5PasLib name 'QTextFormat_boolProperty';
function QTextFormat_intProperty(handle: QTextFormatH; propertyId: Integer): Integer; cdecl; external Qt5PasLib name 'QTextFormat_intProperty';
function QTextFormat_doubleProperty(handle: QTextFormatH; propertyId: Integer): qreal; cdecl; external Qt5PasLib name 'QTextFormat_doubleProperty';
procedure QTextFormat_stringProperty(handle: QTextFormatH; retval: PWideString; propertyId: Integer); cdecl; external Qt5PasLib name 'QTextFormat_stringProperty';
procedure QTextFormat_colorProperty(handle: QTextFormatH; retval: PQColor; propertyId: Integer); cdecl; external Qt5PasLib name 'QTextFormat_colorProperty';
procedure QTextFormat_penProperty(handle: QTextFormatH; retval: QPenH; propertyId: Integer); cdecl; external Qt5PasLib name 'QTextFormat_penProperty';
procedure QTextFormat_brushProperty(handle: QTextFormatH; retval: QBrushH; propertyId: Integer); cdecl; external Qt5PasLib name 'QTextFormat_brushProperty';
procedure QTextFormat_lengthProperty(handle: QTextFormatH; retval: QTextLengthH; propertyId: Integer); cdecl; external Qt5PasLib name 'QTextFormat_lengthProperty';
function QTextFormat_propertyCount(handle: QTextFormatH): Integer; cdecl; external Qt5PasLib name 'QTextFormat_propertyCount';
procedure QTextFormat_setObjectType(handle: QTextFormatH; _type: Integer); cdecl; external Qt5PasLib name 'QTextFormat_setObjectType';
function QTextFormat_objectType(handle: QTextFormatH): Integer; cdecl; external Qt5PasLib name 'QTextFormat_objectType';
function QTextFormat_isCharFormat(handle: QTextFormatH): Boolean; cdecl; external Qt5PasLib name 'QTextFormat_isCharFormat';
function QTextFormat_isBlockFormat(handle: QTextFormatH): Boolean; cdecl; external Qt5PasLib name 'QTextFormat_isBlockFormat';
function QTextFormat_isListFormat(handle: QTextFormatH): Boolean; cdecl; external Qt5PasLib name 'QTextFormat_isListFormat';
function QTextFormat_isFrameFormat(handle: QTextFormatH): Boolean; cdecl; external Qt5PasLib name 'QTextFormat_isFrameFormat';
function QTextFormat_isImageFormat(handle: QTextFormatH): Boolean; cdecl; external Qt5PasLib name 'QTextFormat_isImageFormat';
function QTextFormat_isTableFormat(handle: QTextFormatH): Boolean; cdecl; external Qt5PasLib name 'QTextFormat_isTableFormat';
function QTextFormat_isTableCellFormat(handle: QTextFormatH): Boolean; cdecl; external Qt5PasLib name 'QTextFormat_isTableCellFormat';
procedure QTextFormat_toBlockFormat(handle: QTextFormatH; retval: QTextBlockFormatH); cdecl; external Qt5PasLib name 'QTextFormat_toBlockFormat';
procedure QTextFormat_toCharFormat(handle: QTextFormatH; retval: QTextCharFormatH); cdecl; external Qt5PasLib name 'QTextFormat_toCharFormat';
procedure QTextFormat_toListFormat(handle: QTextFormatH; retval: QTextListFormatH); cdecl; external Qt5PasLib name 'QTextFormat_toListFormat';
procedure QTextFormat_toTableFormat(handle: QTextFormatH; retval: QTextTableFormatH); cdecl; external Qt5PasLib name 'QTextFormat_toTableFormat';
procedure QTextFormat_toFrameFormat(handle: QTextFormatH; retval: QTextFrameFormatH); cdecl; external Qt5PasLib name 'QTextFormat_toFrameFormat';
procedure QTextFormat_toImageFormat(handle: QTextFormatH; retval: QTextImageFormatH); cdecl; external Qt5PasLib name 'QTextFormat_toImageFormat';
procedure QTextFormat_toTableCellFormat(handle: QTextFormatH; retval: QTextTableCellFormatH); cdecl; external Qt5PasLib name 'QTextFormat_toTableCellFormat';
procedure QTextFormat_setLayoutDirection(handle: QTextFormatH; direction: QtLayoutDirection); cdecl; external Qt5PasLib name 'QTextFormat_setLayoutDirection';
function QTextFormat_layoutDirection(handle: QTextFormatH): QtLayoutDirection; cdecl; external Qt5PasLib name 'QTextFormat_layoutDirection';
procedure QTextFormat_setBackground(handle: QTextFormatH; brush: QBrushH); cdecl; external Qt5PasLib name 'QTextFormat_setBackground';
procedure QTextFormat_background(handle: QTextFormatH; retval: QBrushH); cdecl; external Qt5PasLib name 'QTextFormat_background';
procedure QTextFormat_clearBackground(handle: QTextFormatH); cdecl; external Qt5PasLib name 'QTextFormat_clearBackground';
procedure QTextFormat_setForeground(handle: QTextFormatH; brush: QBrushH); cdecl; external Qt5PasLib name 'QTextFormat_setForeground';
procedure QTextFormat_foreground(handle: QTextFormatH; retval: QBrushH); cdecl; external Qt5PasLib name 'QTextFormat_foreground';
procedure QTextFormat_clearForeground(handle: QTextFormatH); cdecl; external Qt5PasLib name 'QTextFormat_clearForeground';

function QTextCharFormat_Create(): QTextCharFormatH; cdecl; external Qt5PasLib name 'QTextCharFormat_Create';
procedure QTextCharFormat_Destroy(handle: QTextCharFormatH); cdecl; external Qt5PasLib name 'QTextCharFormat_Destroy'; 
function QTextCharFormat_isValid(handle: QTextCharFormatH): Boolean; cdecl; external Qt5PasLib name 'QTextCharFormat_isValid';
procedure QTextCharFormat_setFont(handle: QTextCharFormatH; font: QFontH); cdecl; external Qt5PasLib name 'QTextCharFormat_setFont';
procedure QTextCharFormat_font(handle: QTextCharFormatH; retval: QFontH); cdecl; external Qt5PasLib name 'QTextCharFormat_font';
procedure QTextCharFormat_setFontFamily(handle: QTextCharFormatH; family: PWideString); cdecl; external Qt5PasLib name 'QTextCharFormat_setFontFamily';
procedure QTextCharFormat_fontFamily(handle: QTextCharFormatH; retval: PWideString); cdecl; external Qt5PasLib name 'QTextCharFormat_fontFamily';
procedure QTextCharFormat_setFontPointSize(handle: QTextCharFormatH; size: qreal); cdecl; external Qt5PasLib name 'QTextCharFormat_setFontPointSize';
function QTextCharFormat_fontPointSize(handle: QTextCharFormatH): qreal; cdecl; external Qt5PasLib name 'QTextCharFormat_fontPointSize';
procedure QTextCharFormat_setFontWeight(handle: QTextCharFormatH; weight: Integer); cdecl; external Qt5PasLib name 'QTextCharFormat_setFontWeight';
function QTextCharFormat_fontWeight(handle: QTextCharFormatH): Integer; cdecl; external Qt5PasLib name 'QTextCharFormat_fontWeight';
procedure QTextCharFormat_setFontItalic(handle: QTextCharFormatH; italic: Boolean); cdecl; external Qt5PasLib name 'QTextCharFormat_setFontItalic';
function QTextCharFormat_fontItalic(handle: QTextCharFormatH): Boolean; cdecl; external Qt5PasLib name 'QTextCharFormat_fontItalic';
procedure QTextCharFormat_setFontCapitalization(handle: QTextCharFormatH; capitalization: QFontCapitalization); cdecl; external Qt5PasLib name 'QTextCharFormat_setFontCapitalization';
function QTextCharFormat_fontCapitalization(handle: QTextCharFormatH): QFontCapitalization; cdecl; external Qt5PasLib name 'QTextCharFormat_fontCapitalization';
procedure QTextCharFormat_setFontLetterSpacingType(handle: QTextCharFormatH; letterSpacingType: QFontSpacingType); cdecl; external Qt5PasLib name 'QTextCharFormat_setFontLetterSpacingType';
function QTextCharFormat_fontLetterSpacingType(handle: QTextCharFormatH): QFontSpacingType; cdecl; external Qt5PasLib name 'QTextCharFormat_fontLetterSpacingType';
procedure QTextCharFormat_setFontLetterSpacing(handle: QTextCharFormatH; spacing: qreal); cdecl; external Qt5PasLib name 'QTextCharFormat_setFontLetterSpacing';
function QTextCharFormat_fontLetterSpacing(handle: QTextCharFormatH): qreal; cdecl; external Qt5PasLib name 'QTextCharFormat_fontLetterSpacing';
procedure QTextCharFormat_setFontWordSpacing(handle: QTextCharFormatH; spacing: qreal); cdecl; external Qt5PasLib name 'QTextCharFormat_setFontWordSpacing';
function QTextCharFormat_fontWordSpacing(handle: QTextCharFormatH): qreal; cdecl; external Qt5PasLib name 'QTextCharFormat_fontWordSpacing';
procedure QTextCharFormat_setFontUnderline(handle: QTextCharFormatH; underline: Boolean); cdecl; external Qt5PasLib name 'QTextCharFormat_setFontUnderline';
function QTextCharFormat_fontUnderline(handle: QTextCharFormatH): Boolean; cdecl; external Qt5PasLib name 'QTextCharFormat_fontUnderline';
procedure QTextCharFormat_setFontOverline(handle: QTextCharFormatH; overline: Boolean); cdecl; external Qt5PasLib name 'QTextCharFormat_setFontOverline';
function QTextCharFormat_fontOverline(handle: QTextCharFormatH): Boolean; cdecl; external Qt5PasLib name 'QTextCharFormat_fontOverline';
procedure QTextCharFormat_setFontStrikeOut(handle: QTextCharFormatH; strikeOut: Boolean); cdecl; external Qt5PasLib name 'QTextCharFormat_setFontStrikeOut';
function QTextCharFormat_fontStrikeOut(handle: QTextCharFormatH): Boolean; cdecl; external Qt5PasLib name 'QTextCharFormat_fontStrikeOut';
procedure QTextCharFormat_setUnderlineColor(handle: QTextCharFormatH; color: PQColor); cdecl; external Qt5PasLib name 'QTextCharFormat_setUnderlineColor';
procedure QTextCharFormat_underlineColor(handle: QTextCharFormatH; retval: PQColor); cdecl; external Qt5PasLib name 'QTextCharFormat_underlineColor';
procedure QTextCharFormat_setFontFixedPitch(handle: QTextCharFormatH; fixedPitch: Boolean); cdecl; external Qt5PasLib name 'QTextCharFormat_setFontFixedPitch';
function QTextCharFormat_fontFixedPitch(handle: QTextCharFormatH): Boolean; cdecl; external Qt5PasLib name 'QTextCharFormat_fontFixedPitch';
procedure QTextCharFormat_setFontStretch(handle: QTextCharFormatH; factor: Integer); cdecl; external Qt5PasLib name 'QTextCharFormat_setFontStretch';
function QTextCharFormat_fontStretch(handle: QTextCharFormatH): Integer; cdecl; external Qt5PasLib name 'QTextCharFormat_fontStretch';
procedure QTextCharFormat_setFontStyleHint(handle: QTextCharFormatH; hint: QFontStyleHint; strategy: QFontStyleStrategy = QFontPreferDefault); cdecl; external Qt5PasLib name 'QTextCharFormat_setFontStyleHint';
procedure QTextCharFormat_setFontStyleStrategy(handle: QTextCharFormatH; strategy: QFontStyleStrategy); cdecl; external Qt5PasLib name 'QTextCharFormat_setFontStyleStrategy';
function QTextCharFormat_fontStyleHint(handle: QTextCharFormatH): QFontStyleHint; cdecl; external Qt5PasLib name 'QTextCharFormat_fontStyleHint';
function QTextCharFormat_fontStyleStrategy(handle: QTextCharFormatH): QFontStyleStrategy; cdecl; external Qt5PasLib name 'QTextCharFormat_fontStyleStrategy';
procedure QTextCharFormat_setFontHintingPreference(handle: QTextCharFormatH; hintingPreference: QFontHintingPreference); cdecl; external Qt5PasLib name 'QTextCharFormat_setFontHintingPreference';
function QTextCharFormat_fontHintingPreference(handle: QTextCharFormatH): QFontHintingPreference; cdecl; external Qt5PasLib name 'QTextCharFormat_fontHintingPreference';
procedure QTextCharFormat_setFontKerning(handle: QTextCharFormatH; enable: Boolean); cdecl; external Qt5PasLib name 'QTextCharFormat_setFontKerning';
function QTextCharFormat_fontKerning(handle: QTextCharFormatH): Boolean; cdecl; external Qt5PasLib name 'QTextCharFormat_fontKerning';
procedure QTextCharFormat_setUnderlineStyle(handle: QTextCharFormatH; style: QTextCharFormatUnderlineStyle); cdecl; external Qt5PasLib name 'QTextCharFormat_setUnderlineStyle';
function QTextCharFormat_underlineStyle(handle: QTextCharFormatH): QTextCharFormatUnderlineStyle; cdecl; external Qt5PasLib name 'QTextCharFormat_underlineStyle';
procedure QTextCharFormat_setVerticalAlignment(handle: QTextCharFormatH; alignment: QTextCharFormatVerticalAlignment); cdecl; external Qt5PasLib name 'QTextCharFormat_setVerticalAlignment';
function QTextCharFormat_verticalAlignment(handle: QTextCharFormatH): QTextCharFormatVerticalAlignment; cdecl; external Qt5PasLib name 'QTextCharFormat_verticalAlignment';
procedure QTextCharFormat_setTextOutline(handle: QTextCharFormatH; pen: QPenH); cdecl; external Qt5PasLib name 'QTextCharFormat_setTextOutline';
procedure QTextCharFormat_textOutline(handle: QTextCharFormatH; retval: QPenH); cdecl; external Qt5PasLib name 'QTextCharFormat_textOutline';
procedure QTextCharFormat_setToolTip(handle: QTextCharFormatH; tip: PWideString); cdecl; external Qt5PasLib name 'QTextCharFormat_setToolTip';
procedure QTextCharFormat_toolTip(handle: QTextCharFormatH; retval: PWideString); cdecl; external Qt5PasLib name 'QTextCharFormat_toolTip';
procedure QTextCharFormat_setAnchor(handle: QTextCharFormatH; anchor: Boolean); cdecl; external Qt5PasLib name 'QTextCharFormat_setAnchor';
function QTextCharFormat_isAnchor(handle: QTextCharFormatH): Boolean; cdecl; external Qt5PasLib name 'QTextCharFormat_isAnchor';
procedure QTextCharFormat_setAnchorHref(handle: QTextCharFormatH; value: PWideString); cdecl; external Qt5PasLib name 'QTextCharFormat_setAnchorHref';
procedure QTextCharFormat_anchorHref(handle: QTextCharFormatH; retval: PWideString); cdecl; external Qt5PasLib name 'QTextCharFormat_anchorHref';
procedure QTextCharFormat_setAnchorNames(handle: QTextCharFormatH; names: QStringListH); cdecl; external Qt5PasLib name 'QTextCharFormat_setAnchorNames';
procedure QTextCharFormat_anchorNames(handle: QTextCharFormatH; retval: QStringListH); cdecl; external Qt5PasLib name 'QTextCharFormat_anchorNames';
procedure QTextCharFormat_setTableCellRowSpan(handle: QTextCharFormatH; tableCellRowSpan: Integer); cdecl; external Qt5PasLib name 'QTextCharFormat_setTableCellRowSpan';
function QTextCharFormat_tableCellRowSpan(handle: QTextCharFormatH): Integer; cdecl; external Qt5PasLib name 'QTextCharFormat_tableCellRowSpan';
procedure QTextCharFormat_setTableCellColumnSpan(handle: QTextCharFormatH; tableCellColumnSpan: Integer); cdecl; external Qt5PasLib name 'QTextCharFormat_setTableCellColumnSpan';
function QTextCharFormat_tableCellColumnSpan(handle: QTextCharFormatH): Integer; cdecl; external Qt5PasLib name 'QTextCharFormat_tableCellColumnSpan';

function QTextBlockFormat_Create(): QTextBlockFormatH; cdecl; external Qt5PasLib name 'QTextBlockFormat_Create';
procedure QTextBlockFormat_Destroy(handle: QTextBlockFormatH); cdecl; external Qt5PasLib name 'QTextBlockFormat_Destroy'; 
function QTextBlockFormat_isValid(handle: QTextBlockFormatH): Boolean; cdecl; external Qt5PasLib name 'QTextBlockFormat_isValid';
procedure QTextBlockFormat_setAlignment(handle: QTextBlockFormatH; alignment: QtAlignment); cdecl; external Qt5PasLib name 'QTextBlockFormat_setAlignment';
function QTextBlockFormat_alignment(handle: QTextBlockFormatH): QtAlignment; cdecl; external Qt5PasLib name 'QTextBlockFormat_alignment';
procedure QTextBlockFormat_setTopMargin(handle: QTextBlockFormatH; margin: qreal); cdecl; external Qt5PasLib name 'QTextBlockFormat_setTopMargin';
function QTextBlockFormat_topMargin(handle: QTextBlockFormatH): qreal; cdecl; external Qt5PasLib name 'QTextBlockFormat_topMargin';
procedure QTextBlockFormat_setBottomMargin(handle: QTextBlockFormatH; margin: qreal); cdecl; external Qt5PasLib name 'QTextBlockFormat_setBottomMargin';
function QTextBlockFormat_bottomMargin(handle: QTextBlockFormatH): qreal; cdecl; external Qt5PasLib name 'QTextBlockFormat_bottomMargin';
procedure QTextBlockFormat_setLeftMargin(handle: QTextBlockFormatH; margin: qreal); cdecl; external Qt5PasLib name 'QTextBlockFormat_setLeftMargin';
function QTextBlockFormat_leftMargin(handle: QTextBlockFormatH): qreal; cdecl; external Qt5PasLib name 'QTextBlockFormat_leftMargin';
procedure QTextBlockFormat_setRightMargin(handle: QTextBlockFormatH; margin: qreal); cdecl; external Qt5PasLib name 'QTextBlockFormat_setRightMargin';
function QTextBlockFormat_rightMargin(handle: QTextBlockFormatH): qreal; cdecl; external Qt5PasLib name 'QTextBlockFormat_rightMargin';
procedure QTextBlockFormat_setTextIndent(handle: QTextBlockFormatH; aindent: qreal); cdecl; external Qt5PasLib name 'QTextBlockFormat_setTextIndent';
function QTextBlockFormat_textIndent(handle: QTextBlockFormatH): qreal; cdecl; external Qt5PasLib name 'QTextBlockFormat_textIndent';
procedure QTextBlockFormat_setIndent(handle: QTextBlockFormatH; indent: Integer); cdecl; external Qt5PasLib name 'QTextBlockFormat_setIndent';
function QTextBlockFormat_indent(handle: QTextBlockFormatH): Integer; cdecl; external Qt5PasLib name 'QTextBlockFormat_indent';
procedure QTextBlockFormat_setLineHeight(handle: QTextBlockFormatH; height: qreal; heightType: Integer); cdecl; external Qt5PasLib name 'QTextBlockFormat_setLineHeight';
function QTextBlockFormat_lineHeight(handle: QTextBlockFormatH; scriptLineHeight: qreal; scaling: qreal): qreal; cdecl; external Qt5PasLib name 'QTextBlockFormat_lineHeight';
function QTextBlockFormat_lineHeight(handle: QTextBlockFormatH): qreal; cdecl; external Qt5PasLib name 'QTextBlockFormat_lineHeight2';
function QTextBlockFormat_lineHeightType(handle: QTextBlockFormatH): Integer; cdecl; external Qt5PasLib name 'QTextBlockFormat_lineHeightType';
procedure QTextBlockFormat_setNonBreakableLines(handle: QTextBlockFormatH; b: Boolean); cdecl; external Qt5PasLib name 'QTextBlockFormat_setNonBreakableLines';
function QTextBlockFormat_nonBreakableLines(handle: QTextBlockFormatH): Boolean; cdecl; external Qt5PasLib name 'QTextBlockFormat_nonBreakableLines';
procedure QTextBlockFormat_setPageBreakPolicy(handle: QTextBlockFormatH; flags: QTextFormatPageBreakFlags); cdecl; external Qt5PasLib name 'QTextBlockFormat_setPageBreakPolicy';
function QTextBlockFormat_pageBreakPolicy(handle: QTextBlockFormatH): QTextFormatPageBreakFlags; cdecl; external Qt5PasLib name 'QTextBlockFormat_pageBreakPolicy';

function QTextListFormat_Create(): QTextListFormatH; cdecl; external Qt5PasLib name 'QTextListFormat_Create';
procedure QTextListFormat_Destroy(handle: QTextListFormatH); cdecl; external Qt5PasLib name 'QTextListFormat_Destroy'; 
function QTextListFormat_isValid(handle: QTextListFormatH): Boolean; cdecl; external Qt5PasLib name 'QTextListFormat_isValid';
procedure QTextListFormat_setStyle(handle: QTextListFormatH; style: QTextListFormatStyle); cdecl; external Qt5PasLib name 'QTextListFormat_setStyle';
function QTextListFormat_style(handle: QTextListFormatH): QTextListFormatStyle; cdecl; external Qt5PasLib name 'QTextListFormat_style';
procedure QTextListFormat_setIndent(handle: QTextListFormatH; indent: Integer); cdecl; external Qt5PasLib name 'QTextListFormat_setIndent';
function QTextListFormat_indent(handle: QTextListFormatH): Integer; cdecl; external Qt5PasLib name 'QTextListFormat_indent';
procedure QTextListFormat_setNumberPrefix(handle: QTextListFormatH; numberPrefix: PWideString); cdecl; external Qt5PasLib name 'QTextListFormat_setNumberPrefix';
procedure QTextListFormat_numberPrefix(handle: QTextListFormatH; retval: PWideString); cdecl; external Qt5PasLib name 'QTextListFormat_numberPrefix';
procedure QTextListFormat_setNumberSuffix(handle: QTextListFormatH; numberSuffix: PWideString); cdecl; external Qt5PasLib name 'QTextListFormat_setNumberSuffix';
procedure QTextListFormat_numberSuffix(handle: QTextListFormatH; retval: PWideString); cdecl; external Qt5PasLib name 'QTextListFormat_numberSuffix';

function QTextImageFormat_Create(): QTextImageFormatH; cdecl; external Qt5PasLib name 'QTextImageFormat_Create';
procedure QTextImageFormat_Destroy(handle: QTextImageFormatH); cdecl; external Qt5PasLib name 'QTextImageFormat_Destroy'; 
function QTextImageFormat_isValid(handle: QTextImageFormatH): Boolean; cdecl; external Qt5PasLib name 'QTextImageFormat_isValid';
procedure QTextImageFormat_setName(handle: QTextImageFormatH; name: PWideString); cdecl; external Qt5PasLib name 'QTextImageFormat_setName';
procedure QTextImageFormat_name(handle: QTextImageFormatH; retval: PWideString); cdecl; external Qt5PasLib name 'QTextImageFormat_name';
procedure QTextImageFormat_setWidth(handle: QTextImageFormatH; width: qreal); cdecl; external Qt5PasLib name 'QTextImageFormat_setWidth';
function QTextImageFormat_width(handle: QTextImageFormatH): qreal; cdecl; external Qt5PasLib name 'QTextImageFormat_width';
procedure QTextImageFormat_setHeight(handle: QTextImageFormatH; height: qreal); cdecl; external Qt5PasLib name 'QTextImageFormat_setHeight';
function QTextImageFormat_height(handle: QTextImageFormatH): qreal; cdecl; external Qt5PasLib name 'QTextImageFormat_height';

function QTextFrameFormat_Create(): QTextFrameFormatH; cdecl; external Qt5PasLib name 'QTextFrameFormat_Create';
procedure QTextFrameFormat_Destroy(handle: QTextFrameFormatH); cdecl; external Qt5PasLib name 'QTextFrameFormat_Destroy'; 
function QTextFrameFormat_isValid(handle: QTextFrameFormatH): Boolean; cdecl; external Qt5PasLib name 'QTextFrameFormat_isValid';
procedure QTextFrameFormat_setPosition(handle: QTextFrameFormatH; f: QTextFrameFormatPosition); cdecl; external Qt5PasLib name 'QTextFrameFormat_setPosition';
function QTextFrameFormat_position(handle: QTextFrameFormatH): QTextFrameFormatPosition; cdecl; external Qt5PasLib name 'QTextFrameFormat_position';
procedure QTextFrameFormat_setBorder(handle: QTextFrameFormatH; border: qreal); cdecl; external Qt5PasLib name 'QTextFrameFormat_setBorder';
function QTextFrameFormat_border(handle: QTextFrameFormatH): qreal; cdecl; external Qt5PasLib name 'QTextFrameFormat_border';
procedure QTextFrameFormat_setBorderBrush(handle: QTextFrameFormatH; brush: QBrushH); cdecl; external Qt5PasLib name 'QTextFrameFormat_setBorderBrush';
procedure QTextFrameFormat_borderBrush(handle: QTextFrameFormatH; retval: QBrushH); cdecl; external Qt5PasLib name 'QTextFrameFormat_borderBrush';
procedure QTextFrameFormat_setBorderStyle(handle: QTextFrameFormatH; style: QTextFrameFormatBorderStyle); cdecl; external Qt5PasLib name 'QTextFrameFormat_setBorderStyle';
function QTextFrameFormat_borderStyle(handle: QTextFrameFormatH): QTextFrameFormatBorderStyle; cdecl; external Qt5PasLib name 'QTextFrameFormat_borderStyle';
procedure QTextFrameFormat_setMargin(handle: QTextFrameFormatH; margin: qreal); cdecl; external Qt5PasLib name 'QTextFrameFormat_setMargin';
function QTextFrameFormat_margin(handle: QTextFrameFormatH): qreal; cdecl; external Qt5PasLib name 'QTextFrameFormat_margin';
procedure QTextFrameFormat_setTopMargin(handle: QTextFrameFormatH; margin: qreal); cdecl; external Qt5PasLib name 'QTextFrameFormat_setTopMargin';
function QTextFrameFormat_topMargin(handle: QTextFrameFormatH): qreal; cdecl; external Qt5PasLib name 'QTextFrameFormat_topMargin';
procedure QTextFrameFormat_setBottomMargin(handle: QTextFrameFormatH; margin: qreal); cdecl; external Qt5PasLib name 'QTextFrameFormat_setBottomMargin';
function QTextFrameFormat_bottomMargin(handle: QTextFrameFormatH): qreal; cdecl; external Qt5PasLib name 'QTextFrameFormat_bottomMargin';
procedure QTextFrameFormat_setLeftMargin(handle: QTextFrameFormatH; margin: qreal); cdecl; external Qt5PasLib name 'QTextFrameFormat_setLeftMargin';
function QTextFrameFormat_leftMargin(handle: QTextFrameFormatH): qreal; cdecl; external Qt5PasLib name 'QTextFrameFormat_leftMargin';
procedure QTextFrameFormat_setRightMargin(handle: QTextFrameFormatH; margin: qreal); cdecl; external Qt5PasLib name 'QTextFrameFormat_setRightMargin';
function QTextFrameFormat_rightMargin(handle: QTextFrameFormatH): qreal; cdecl; external Qt5PasLib name 'QTextFrameFormat_rightMargin';
procedure QTextFrameFormat_setPadding(handle: QTextFrameFormatH; padding: qreal); cdecl; external Qt5PasLib name 'QTextFrameFormat_setPadding';
function QTextFrameFormat_padding(handle: QTextFrameFormatH): qreal; cdecl; external Qt5PasLib name 'QTextFrameFormat_padding';
procedure QTextFrameFormat_setWidth(handle: QTextFrameFormatH; width: qreal); cdecl; external Qt5PasLib name 'QTextFrameFormat_setWidth';
procedure QTextFrameFormat_setWidth(handle: QTextFrameFormatH; length: QTextLengthH); cdecl; external Qt5PasLib name 'QTextFrameFormat_setWidth2';
procedure QTextFrameFormat_width(handle: QTextFrameFormatH; retval: QTextLengthH); cdecl; external Qt5PasLib name 'QTextFrameFormat_width';
procedure QTextFrameFormat_setHeight(handle: QTextFrameFormatH; height: qreal); cdecl; external Qt5PasLib name 'QTextFrameFormat_setHeight';
procedure QTextFrameFormat_setHeight(handle: QTextFrameFormatH; height: QTextLengthH); cdecl; external Qt5PasLib name 'QTextFrameFormat_setHeight2';
procedure QTextFrameFormat_height(handle: QTextFrameFormatH; retval: QTextLengthH); cdecl; external Qt5PasLib name 'QTextFrameFormat_height';
procedure QTextFrameFormat_setPageBreakPolicy(handle: QTextFrameFormatH; flags: QTextFormatPageBreakFlags); cdecl; external Qt5PasLib name 'QTextFrameFormat_setPageBreakPolicy';
function QTextFrameFormat_pageBreakPolicy(handle: QTextFrameFormatH): QTextFormatPageBreakFlags; cdecl; external Qt5PasLib name 'QTextFrameFormat_pageBreakPolicy';

function QTextTableFormat_Create(): QTextTableFormatH; cdecl; external Qt5PasLib name 'QTextTableFormat_Create';
procedure QTextTableFormat_Destroy(handle: QTextTableFormatH); cdecl; external Qt5PasLib name 'QTextTableFormat_Destroy'; 
function QTextTableFormat_isValid(handle: QTextTableFormatH): Boolean; cdecl; external Qt5PasLib name 'QTextTableFormat_isValid';
function QTextTableFormat_columns(handle: QTextTableFormatH): Integer; cdecl; external Qt5PasLib name 'QTextTableFormat_columns';
procedure QTextTableFormat_setColumns(handle: QTextTableFormatH; columns: Integer); cdecl; external Qt5PasLib name 'QTextTableFormat_setColumns';
procedure QTextTableFormat_clearColumnWidthConstraints(handle: QTextTableFormatH); cdecl; external Qt5PasLib name 'QTextTableFormat_clearColumnWidthConstraints';
function QTextTableFormat_cellSpacing(handle: QTextTableFormatH): qreal; cdecl; external Qt5PasLib name 'QTextTableFormat_cellSpacing';
procedure QTextTableFormat_setCellSpacing(handle: QTextTableFormatH; spacing: qreal); cdecl; external Qt5PasLib name 'QTextTableFormat_setCellSpacing';
function QTextTableFormat_cellPadding(handle: QTextTableFormatH): qreal; cdecl; external Qt5PasLib name 'QTextTableFormat_cellPadding';
procedure QTextTableFormat_setCellPadding(handle: QTextTableFormatH; padding: qreal); cdecl; external Qt5PasLib name 'QTextTableFormat_setCellPadding';
procedure QTextTableFormat_setAlignment(handle: QTextTableFormatH; alignment: QtAlignment); cdecl; external Qt5PasLib name 'QTextTableFormat_setAlignment';
function QTextTableFormat_alignment(handle: QTextTableFormatH): QtAlignment; cdecl; external Qt5PasLib name 'QTextTableFormat_alignment';
procedure QTextTableFormat_setHeaderRowCount(handle: QTextTableFormatH; count: Integer); cdecl; external Qt5PasLib name 'QTextTableFormat_setHeaderRowCount';
function QTextTableFormat_headerRowCount(handle: QTextTableFormatH): Integer; cdecl; external Qt5PasLib name 'QTextTableFormat_headerRowCount';

function QTextTableCellFormat_Create(): QTextTableCellFormatH; cdecl; external Qt5PasLib name 'QTextTableCellFormat_Create';
procedure QTextTableCellFormat_Destroy(handle: QTextTableCellFormatH); cdecl; external Qt5PasLib name 'QTextTableCellFormat_Destroy'; 
function QTextTableCellFormat_isValid(handle: QTextTableCellFormatH): Boolean; cdecl; external Qt5PasLib name 'QTextTableCellFormat_isValid';
procedure QTextTableCellFormat_setTopPadding(handle: QTextTableCellFormatH; padding: qreal); cdecl; external Qt5PasLib name 'QTextTableCellFormat_setTopPadding';
function QTextTableCellFormat_topPadding(handle: QTextTableCellFormatH): qreal; cdecl; external Qt5PasLib name 'QTextTableCellFormat_topPadding';
procedure QTextTableCellFormat_setBottomPadding(handle: QTextTableCellFormatH; padding: qreal); cdecl; external Qt5PasLib name 'QTextTableCellFormat_setBottomPadding';
function QTextTableCellFormat_bottomPadding(handle: QTextTableCellFormatH): qreal; cdecl; external Qt5PasLib name 'QTextTableCellFormat_bottomPadding';
procedure QTextTableCellFormat_setLeftPadding(handle: QTextTableCellFormatH; padding: qreal); cdecl; external Qt5PasLib name 'QTextTableCellFormat_setLeftPadding';
function QTextTableCellFormat_leftPadding(handle: QTextTableCellFormatH): qreal; cdecl; external Qt5PasLib name 'QTextTableCellFormat_leftPadding';
procedure QTextTableCellFormat_setRightPadding(handle: QTextTableCellFormatH; padding: qreal); cdecl; external Qt5PasLib name 'QTextTableCellFormat_setRightPadding';
function QTextTableCellFormat_rightPadding(handle: QTextTableCellFormatH): qreal; cdecl; external Qt5PasLib name 'QTextTableCellFormat_rightPadding';
procedure QTextTableCellFormat_setPadding(handle: QTextTableCellFormatH; padding: qreal); cdecl; external Qt5PasLib name 'QTextTableCellFormat_setPadding';


type
  QTextCursorMoveMode = ( // QTextCursor::MoveMode (1)
    QTextCursorMoveAnchor, QTextCursorKeepAnchor );

  QTextCursorMoveOperation = ( // QTextCursor::MoveOperation (1)
    QTextCursorNoMove, QTextCursorStart, QTextCursorUp, QTextCursorStartOfLine, QTextCursorStartOfBlock, QTextCursorStartOfWord, QTextCursorPreviousBlock, QTextCursorPreviousCharacter, 
    QTextCursorPreviousWord, QTextCursorLeft, QTextCursorWordLeft, QTextCursorEnd, QTextCursorDown, QTextCursorEndOfLine, QTextCursorEndOfWord, QTextCursorEndOfBlock, QTextCursorNextBlock, 
    QTextCursorNextCharacter, QTextCursorNextWord, QTextCursorRight, QTextCursorWordRight, QTextCursorNextCell, QTextCursorPreviousCell, QTextCursorNextRow, QTextCursorPreviousRow );

  QTextCursorSelectionType = ( // QTextCursor::SelectionType (1)
    QTextCursorWordUnderCursor, QTextCursorLineUnderCursor, QTextCursorBlockUnderCursor, QTextCursorDocument );

function QTextCursor_Create(): QTextCursorH; cdecl; external Qt5PasLib name 'QTextCursor_Create';
procedure QTextCursor_Destroy(handle: QTextCursorH); cdecl; external Qt5PasLib name 'QTextCursor_Destroy'; 
function QTextCursor_Create(document: QTextDocumentH): QTextCursorH; cdecl; external Qt5PasLib name 'QTextCursor_Create2';
function QTextCursor_Create(frame: QTextFrameH): QTextCursorH; cdecl; external Qt5PasLib name 'QTextCursor_Create3';
function QTextCursor_Create(block: QTextBlockH): QTextCursorH; cdecl; external Qt5PasLib name 'QTextCursor_Create4';
function QTextCursor_Create(cursor: QTextCursorH): QTextCursorH; cdecl; external Qt5PasLib name 'QTextCursor_Create6';
procedure QTextCursor_swap(handle: QTextCursorH; other: QTextCursorH); cdecl; external Qt5PasLib name 'QTextCursor_swap';
function QTextCursor_isNull(handle: QTextCursorH): Boolean; cdecl; external Qt5PasLib name 'QTextCursor_isNull';
procedure QTextCursor_setPosition(handle: QTextCursorH; pos: Integer; mode: QTextCursorMoveMode = QTextCursorMoveAnchor); cdecl; external Qt5PasLib name 'QTextCursor_setPosition';
function QTextCursor_position(handle: QTextCursorH): Integer; cdecl; external Qt5PasLib name 'QTextCursor_position';
function QTextCursor_positionInBlock(handle: QTextCursorH): Integer; cdecl; external Qt5PasLib name 'QTextCursor_positionInBlock';
function QTextCursor_anchor(handle: QTextCursorH): Integer; cdecl; external Qt5PasLib name 'QTextCursor_anchor';
procedure QTextCursor_insertText(handle: QTextCursorH; text: PWideString); cdecl; external Qt5PasLib name 'QTextCursor_insertText';
procedure QTextCursor_insertText(handle: QTextCursorH; text: PWideString; format: QTextCharFormatH); cdecl; external Qt5PasLib name 'QTextCursor_insertText2';
function QTextCursor_movePosition(handle: QTextCursorH; op: QTextCursorMoveOperation; AnonParam2: QTextCursorMoveMode = QTextCursorMoveAnchor; n: Integer = 1): Boolean; cdecl; external Qt5PasLib name 'QTextCursor_movePosition';
function QTextCursor_visualNavigation(handle: QTextCursorH): Boolean; cdecl; external Qt5PasLib name 'QTextCursor_visualNavigation';
procedure QTextCursor_setVisualNavigation(handle: QTextCursorH; b: Boolean); cdecl; external Qt5PasLib name 'QTextCursor_setVisualNavigation';
procedure QTextCursor_setVerticalMovementX(handle: QTextCursorH; x: Integer); cdecl; external Qt5PasLib name 'QTextCursor_setVerticalMovementX';
function QTextCursor_verticalMovementX(handle: QTextCursorH): Integer; cdecl; external Qt5PasLib name 'QTextCursor_verticalMovementX';
procedure QTextCursor_setKeepPositionOnInsert(handle: QTextCursorH; b: Boolean); cdecl; external Qt5PasLib name 'QTextCursor_setKeepPositionOnInsert';
function QTextCursor_keepPositionOnInsert(handle: QTextCursorH): Boolean; cdecl; external Qt5PasLib name 'QTextCursor_keepPositionOnInsert';
procedure QTextCursor_deleteChar(handle: QTextCursorH); cdecl; external Qt5PasLib name 'QTextCursor_deleteChar';
procedure QTextCursor_deletePreviousChar(handle: QTextCursorH); cdecl; external Qt5PasLib name 'QTextCursor_deletePreviousChar';
procedure QTextCursor_select(handle: QTextCursorH; selection: QTextCursorSelectionType); cdecl; external Qt5PasLib name 'QTextCursor_select';
function QTextCursor_hasSelection(handle: QTextCursorH): Boolean; cdecl; external Qt5PasLib name 'QTextCursor_hasSelection';
function QTextCursor_hasComplexSelection(handle: QTextCursorH): Boolean; cdecl; external Qt5PasLib name 'QTextCursor_hasComplexSelection';
procedure QTextCursor_removeSelectedText(handle: QTextCursorH); cdecl; external Qt5PasLib name 'QTextCursor_removeSelectedText';
procedure QTextCursor_clearSelection(handle: QTextCursorH); cdecl; external Qt5PasLib name 'QTextCursor_clearSelection';
function QTextCursor_selectionStart(handle: QTextCursorH): Integer; cdecl; external Qt5PasLib name 'QTextCursor_selectionStart';
function QTextCursor_selectionEnd(handle: QTextCursorH): Integer; cdecl; external Qt5PasLib name 'QTextCursor_selectionEnd';
procedure QTextCursor_selectedText(handle: QTextCursorH; retval: PWideString); cdecl; external Qt5PasLib name 'QTextCursor_selectedText';
procedure QTextCursor_selection(handle: QTextCursorH; retval: QTextDocumentFragmentH); cdecl; external Qt5PasLib name 'QTextCursor_selection';
procedure QTextCursor_selectedTableCells(handle: QTextCursorH; firstRow: PInteger; numRows: PInteger; firstColumn: PInteger; numColumns: PInteger); cdecl; external Qt5PasLib name 'QTextCursor_selectedTableCells';
procedure QTextCursor_block(handle: QTextCursorH; retval: QTextBlockH); cdecl; external Qt5PasLib name 'QTextCursor_block';
procedure QTextCursor_charFormat(handle: QTextCursorH; retval: QTextCharFormatH); cdecl; external Qt5PasLib name 'QTextCursor_charFormat';
procedure QTextCursor_setCharFormat(handle: QTextCursorH; format: QTextCharFormatH); cdecl; external Qt5PasLib name 'QTextCursor_setCharFormat';
procedure QTextCursor_mergeCharFormat(handle: QTextCursorH; modifier: QTextCharFormatH); cdecl; external Qt5PasLib name 'QTextCursor_mergeCharFormat';
procedure QTextCursor_blockFormat(handle: QTextCursorH; retval: QTextBlockFormatH); cdecl; external Qt5PasLib name 'QTextCursor_blockFormat';
procedure QTextCursor_setBlockFormat(handle: QTextCursorH; format: QTextBlockFormatH); cdecl; external Qt5PasLib name 'QTextCursor_setBlockFormat';
procedure QTextCursor_mergeBlockFormat(handle: QTextCursorH; modifier: QTextBlockFormatH); cdecl; external Qt5PasLib name 'QTextCursor_mergeBlockFormat';
procedure QTextCursor_blockCharFormat(handle: QTextCursorH; retval: QTextCharFormatH); cdecl; external Qt5PasLib name 'QTextCursor_blockCharFormat';
procedure QTextCursor_setBlockCharFormat(handle: QTextCursorH; format: QTextCharFormatH); cdecl; external Qt5PasLib name 'QTextCursor_setBlockCharFormat';
procedure QTextCursor_mergeBlockCharFormat(handle: QTextCursorH; modifier: QTextCharFormatH); cdecl; external Qt5PasLib name 'QTextCursor_mergeBlockCharFormat';
function QTextCursor_atBlockStart(handle: QTextCursorH): Boolean; cdecl; external Qt5PasLib name 'QTextCursor_atBlockStart';
function QTextCursor_atBlockEnd(handle: QTextCursorH): Boolean; cdecl; external Qt5PasLib name 'QTextCursor_atBlockEnd';
function QTextCursor_atStart(handle: QTextCursorH): Boolean; cdecl; external Qt5PasLib name 'QTextCursor_atStart';
function QTextCursor_atEnd(handle: QTextCursorH): Boolean; cdecl; external Qt5PasLib name 'QTextCursor_atEnd';
procedure QTextCursor_insertBlock(handle: QTextCursorH); cdecl; external Qt5PasLib name 'QTextCursor_insertBlock';
procedure QTextCursor_insertBlock(handle: QTextCursorH; format: QTextBlockFormatH); cdecl; external Qt5PasLib name 'QTextCursor_insertBlock2';
procedure QTextCursor_insertBlock(handle: QTextCursorH; format: QTextBlockFormatH; charFormat: QTextCharFormatH); cdecl; external Qt5PasLib name 'QTextCursor_insertBlock3';
function QTextCursor_insertList(handle: QTextCursorH; format: QTextListFormatH): QTextListH; cdecl; external Qt5PasLib name 'QTextCursor_insertList';
function QTextCursor_insertList(handle: QTextCursorH; style: QTextListFormatStyle): QTextListH; cdecl; external Qt5PasLib name 'QTextCursor_insertList2';
function QTextCursor_createList(handle: QTextCursorH; format: QTextListFormatH): QTextListH; cdecl; external Qt5PasLib name 'QTextCursor_createList';
function QTextCursor_createList(handle: QTextCursorH; style: QTextListFormatStyle): QTextListH; cdecl; external Qt5PasLib name 'QTextCursor_createList2';
function QTextCursor_currentList(handle: QTextCursorH): QTextListH; cdecl; external Qt5PasLib name 'QTextCursor_currentList';
function QTextCursor_insertTable(handle: QTextCursorH; rows: Integer; cols: Integer; format: QTextTableFormatH): QTextTableH; cdecl; external Qt5PasLib name 'QTextCursor_insertTable';
function QTextCursor_insertTable(handle: QTextCursorH; rows: Integer; cols: Integer): QTextTableH; cdecl; external Qt5PasLib name 'QTextCursor_insertTable2';
function QTextCursor_currentTable(handle: QTextCursorH): QTextTableH; cdecl; external Qt5PasLib name 'QTextCursor_currentTable';
function QTextCursor_insertFrame(handle: QTextCursorH; format: QTextFrameFormatH): QTextFrameH; cdecl; external Qt5PasLib name 'QTextCursor_insertFrame';
function QTextCursor_currentFrame(handle: QTextCursorH): QTextFrameH; cdecl; external Qt5PasLib name 'QTextCursor_currentFrame';
procedure QTextCursor_insertFragment(handle: QTextCursorH; fragment: QTextDocumentFragmentH); cdecl; external Qt5PasLib name 'QTextCursor_insertFragment';
procedure QTextCursor_insertHtml(handle: QTextCursorH; html: PWideString); cdecl; external Qt5PasLib name 'QTextCursor_insertHtml';
procedure QTextCursor_insertImage(handle: QTextCursorH; format: QTextImageFormatH; alignment: QTextFrameFormatPosition); cdecl; external Qt5PasLib name 'QTextCursor_insertImage';
procedure QTextCursor_insertImage(handle: QTextCursorH; format: QTextImageFormatH); cdecl; external Qt5PasLib name 'QTextCursor_insertImage2';
procedure QTextCursor_insertImage(handle: QTextCursorH; name: PWideString); cdecl; external Qt5PasLib name 'QTextCursor_insertImage3';
procedure QTextCursor_insertImage(handle: QTextCursorH; image: QImageH; name: PWideString = nil); cdecl; external Qt5PasLib name 'QTextCursor_insertImage4';
procedure QTextCursor_beginEditBlock(handle: QTextCursorH); cdecl; external Qt5PasLib name 'QTextCursor_beginEditBlock';
procedure QTextCursor_joinPreviousEditBlock(handle: QTextCursorH); cdecl; external Qt5PasLib name 'QTextCursor_joinPreviousEditBlock';
procedure QTextCursor_endEditBlock(handle: QTextCursorH); cdecl; external Qt5PasLib name 'QTextCursor_endEditBlock';
function QTextCursor_isCopyOf(handle: QTextCursorH; other: QTextCursorH): Boolean; cdecl; external Qt5PasLib name 'QTextCursor_isCopyOf';
function QTextCursor_blockNumber(handle: QTextCursorH): Integer; cdecl; external Qt5PasLib name 'QTextCursor_blockNumber';
function QTextCursor_columnNumber(handle: QTextCursorH): Integer; cdecl; external Qt5PasLib name 'QTextCursor_columnNumber';
function QTextCursor_document(handle: QTextCursorH): QTextDocumentH; cdecl; external Qt5PasLib name 'QTextCursor_document';


type
  QTextOptionTabType = ( // QTextOption::TabType (1)
    QTextOptionLeftTab, QTextOptionRightTab, QTextOptionCenterTab, QTextOptionDelimiterTab );

  QTextOptionWrapMode = ( // QTextOption::WrapMode (1)
    QTextOptionNoWrap, QTextOptionWordWrap, QTextOptionManualWrap, QTextOptionWrapAnywhere, QTextOptionWrapAtWordBoundaryOrAnywhere );

type
  QTextOptionFlag = cardinal; // QTextOption::Flag
  QTextOptionFlags = QTextOptionFlag; //QFlags<> (3)
const
  QTextOptionShowTabsAndSpaces =   $1;
  QTextOptionShowLineAndParagraphSeparators =   $2;
  QTextOptionAddSpaceForLineAndParagraphSeparators =   $4;
  QTextOptionSuppressColors =   $8;
  QTextOptionIncludeTrailingSpaces =   $80000000;

function QTextOption_Create(): QTextOptionH; cdecl; external Qt5PasLib name 'QTextOption_Create';
procedure QTextOption_Destroy(handle: QTextOptionH); cdecl; external Qt5PasLib name 'QTextOption_Destroy'; 
function QTextOption_Create(alignment: QtAlignment): QTextOptionH; cdecl; external Qt5PasLib name 'QTextOption_Create2';
function QTextOption_Create(o: QTextOptionH): QTextOptionH; cdecl; external Qt5PasLib name 'QTextOption_Create3';
procedure QTextOption_setAlignment(handle: QTextOptionH; alignment: QtAlignment); cdecl; external Qt5PasLib name 'QTextOption_setAlignment';
function QTextOption_alignment(handle: QTextOptionH): QtAlignment; cdecl; external Qt5PasLib name 'QTextOption_alignment';
procedure QTextOption_setTextDirection(handle: QTextOptionH; aDirection: QtLayoutDirection); cdecl; external Qt5PasLib name 'QTextOption_setTextDirection';
function QTextOption_textDirection(handle: QTextOptionH): QtLayoutDirection; cdecl; external Qt5PasLib name 'QTextOption_textDirection';
procedure QTextOption_setWrapMode(handle: QTextOptionH; wrap: QTextOptionWrapMode); cdecl; external Qt5PasLib name 'QTextOption_setWrapMode';
function QTextOption_wrapMode(handle: QTextOptionH): QTextOptionWrapMode; cdecl; external Qt5PasLib name 'QTextOption_wrapMode';
procedure QTextOption_setFlags(handle: QTextOptionH; flags: QTextOptionFlags); cdecl; external Qt5PasLib name 'QTextOption_setFlags';
function QTextOption_flags(handle: QTextOptionH): QTextOptionFlags; cdecl; external Qt5PasLib name 'QTextOption_flags';
procedure QTextOption_setTabStop(handle: QTextOptionH; tabStop: qreal); cdecl; external Qt5PasLib name 'QTextOption_setTabStop';
function QTextOption_tabStop(handle: QTextOptionH): qreal; cdecl; external Qt5PasLib name 'QTextOption_tabStop';
procedure QTextOption_setTabArray(handle: QTextOptionH; tabStops: PPtrIntArray); cdecl; external Qt5PasLib name 'QTextOption_setTabArray';
procedure QTextOption_tabArray(handle: QTextOptionH; retval: PPtrIntArray); cdecl; external Qt5PasLib name 'QTextOption_tabArray';
procedure QTextOption_setUseDesignMetrics(handle: QTextOptionH; b: Boolean); cdecl; external Qt5PasLib name 'QTextOption_setUseDesignMetrics';
function QTextOption_useDesignMetrics(handle: QTextOptionH): Boolean; cdecl; external Qt5PasLib name 'QTextOption_useDesignMetrics';

function QFontMetrics_Create(AnonParam1: QFontH): QFontMetricsH; cdecl; external Qt5PasLib name 'QFontMetrics_Create';
procedure QFontMetrics_Destroy(handle: QFontMetricsH); cdecl; external Qt5PasLib name 'QFontMetrics_Destroy'; 
function QFontMetrics_Create(AnonParam1: QFontH; pd: QPaintDeviceH): QFontMetricsH; cdecl; external Qt5PasLib name 'QFontMetrics_Create2';
function QFontMetrics_Create(AnonParam1: QFontMetricsH): QFontMetricsH; cdecl; external Qt5PasLib name 'QFontMetrics_Create3';
procedure QFontMetrics_swap(handle: QFontMetricsH; other: QFontMetricsH); cdecl; external Qt5PasLib name 'QFontMetrics_swap';
function QFontMetrics_ascent(handle: QFontMetricsH): Integer; cdecl; external Qt5PasLib name 'QFontMetrics_ascent';
function QFontMetrics_descent(handle: QFontMetricsH): Integer; cdecl; external Qt5PasLib name 'QFontMetrics_descent';
function QFontMetrics_height(handle: QFontMetricsH): Integer; cdecl; external Qt5PasLib name 'QFontMetrics_height';
function QFontMetrics_leading(handle: QFontMetricsH): Integer; cdecl; external Qt5PasLib name 'QFontMetrics_leading';
function QFontMetrics_lineSpacing(handle: QFontMetricsH): Integer; cdecl; external Qt5PasLib name 'QFontMetrics_lineSpacing';
function QFontMetrics_minLeftBearing(handle: QFontMetricsH): Integer; cdecl; external Qt5PasLib name 'QFontMetrics_minLeftBearing';
function QFontMetrics_minRightBearing(handle: QFontMetricsH): Integer; cdecl; external Qt5PasLib name 'QFontMetrics_minRightBearing';
function QFontMetrics_maxWidth(handle: QFontMetricsH): Integer; cdecl; external Qt5PasLib name 'QFontMetrics_maxWidth';
function QFontMetrics_xHeight(handle: QFontMetricsH): Integer; cdecl; external Qt5PasLib name 'QFontMetrics_xHeight';
function QFontMetrics_averageCharWidth(handle: QFontMetricsH): Integer; cdecl; external Qt5PasLib name 'QFontMetrics_averageCharWidth';
function QFontMetrics_inFont(handle: QFontMetricsH; AnonParam1: PWideChar): Boolean; cdecl; external Qt5PasLib name 'QFontMetrics_inFont';
function QFontMetrics_inFontUcs4(handle: QFontMetricsH; ucs4: LongWord): Boolean; cdecl; external Qt5PasLib name 'QFontMetrics_inFontUcs4';
function QFontMetrics_leftBearing(handle: QFontMetricsH; AnonParam1: PWideChar): Integer; cdecl; external Qt5PasLib name 'QFontMetrics_leftBearing';
function QFontMetrics_rightBearing(handle: QFontMetricsH; AnonParam1: PWideChar): Integer; cdecl; external Qt5PasLib name 'QFontMetrics_rightBearing';
function QFontMetrics_width(handle: QFontMetricsH; AnonParam1: PWideString; len: Integer = -1): Integer; cdecl; external Qt5PasLib name 'QFontMetrics_width';
function QFontMetrics_width(handle: QFontMetricsH; AnonParam1: PWideString; len: Integer; flags: Integer): Integer; cdecl; external Qt5PasLib name 'QFontMetrics_width2';
function QFontMetrics_width(handle: QFontMetricsH; AnonParam1: PWideChar): Integer; cdecl; external Qt5PasLib name 'QFontMetrics_width3';
function QFontMetrics_charWidth(handle: QFontMetricsH; str: PWideString; pos: Integer): Integer; cdecl; external Qt5PasLib name 'QFontMetrics_charWidth';
procedure QFontMetrics_boundingRect(handle: QFontMetricsH; retval: PRect; AnonParam1: PWideChar); cdecl; external Qt5PasLib name 'QFontMetrics_boundingRect';
procedure QFontMetrics_boundingRect(handle: QFontMetricsH; retval: PRect; text: PWideString); cdecl; external Qt5PasLib name 'QFontMetrics_boundingRect2';
procedure QFontMetrics_boundingRect(handle: QFontMetricsH; retval: PRect; r: PRect; flags: Integer; text: PWideString; tabstops: Integer = 0; tabarray: PInteger = nil); cdecl; external Qt5PasLib name 'QFontMetrics_boundingRect3';
procedure QFontMetrics_boundingRect(handle: QFontMetricsH; retval: PRect; x: Integer; y: Integer; w: Integer; h: Integer; flags: Integer; text: PWideString; tabstops: Integer = 0; tabarray: PInteger = nil); cdecl; external Qt5PasLib name 'QFontMetrics_boundingRect4';
procedure QFontMetrics_size(handle: QFontMetricsH; retval: PSize; flags: Integer; str: PWideString; tabstops: Integer = 0; tabarray: PInteger = nil); cdecl; external Qt5PasLib name 'QFontMetrics_size';
procedure QFontMetrics_tightBoundingRect(handle: QFontMetricsH; retval: PRect; text: PWideString); cdecl; external Qt5PasLib name 'QFontMetrics_tightBoundingRect';
procedure QFontMetrics_elidedText(handle: QFontMetricsH; retval: PWideString; text: PWideString; mode: QtTextElideMode; width: Integer; flags: Integer = 0); cdecl; external Qt5PasLib name 'QFontMetrics_elidedText';
function QFontMetrics_underlinePos(handle: QFontMetricsH): Integer; cdecl; external Qt5PasLib name 'QFontMetrics_underlinePos';
function QFontMetrics_overlinePos(handle: QFontMetricsH): Integer; cdecl; external Qt5PasLib name 'QFontMetrics_overlinePos';
function QFontMetrics_strikeOutPos(handle: QFontMetricsH): Integer; cdecl; external Qt5PasLib name 'QFontMetrics_strikeOutPos';
function QFontMetrics_lineWidth(handle: QFontMetricsH): Integer; cdecl; external Qt5PasLib name 'QFontMetrics_lineWidth';

function QFontMetricsF_Create(AnonParam1: QFontH): QFontMetricsFH; cdecl; external Qt5PasLib name 'QFontMetricsF_Create';
procedure QFontMetricsF_Destroy(handle: QFontMetricsFH); cdecl; external Qt5PasLib name 'QFontMetricsF_Destroy'; 
function QFontMetricsF_Create(AnonParam1: QFontH; pd: QPaintDeviceH): QFontMetricsFH; cdecl; external Qt5PasLib name 'QFontMetricsF_Create2';
function QFontMetricsF_Create(AnonParam1: QFontMetricsFH): QFontMetricsFH; cdecl; external Qt5PasLib name 'QFontMetricsF_Create4';
procedure QFontMetricsF_swap(handle: QFontMetricsFH; other: QFontMetricsFH); cdecl; external Qt5PasLib name 'QFontMetricsF_swap';
function QFontMetricsF_ascent(handle: QFontMetricsFH): qreal; cdecl; external Qt5PasLib name 'QFontMetricsF_ascent';
function QFontMetricsF_descent(handle: QFontMetricsFH): qreal; cdecl; external Qt5PasLib name 'QFontMetricsF_descent';
function QFontMetricsF_height(handle: QFontMetricsFH): qreal; cdecl; external Qt5PasLib name 'QFontMetricsF_height';
function QFontMetricsF_leading(handle: QFontMetricsFH): qreal; cdecl; external Qt5PasLib name 'QFontMetricsF_leading';
function QFontMetricsF_lineSpacing(handle: QFontMetricsFH): qreal; cdecl; external Qt5PasLib name 'QFontMetricsF_lineSpacing';
function QFontMetricsF_minLeftBearing(handle: QFontMetricsFH): qreal; cdecl; external Qt5PasLib name 'QFontMetricsF_minLeftBearing';
function QFontMetricsF_minRightBearing(handle: QFontMetricsFH): qreal; cdecl; external Qt5PasLib name 'QFontMetricsF_minRightBearing';
function QFontMetricsF_maxWidth(handle: QFontMetricsFH): qreal; cdecl; external Qt5PasLib name 'QFontMetricsF_maxWidth';
function QFontMetricsF_xHeight(handle: QFontMetricsFH): qreal; cdecl; external Qt5PasLib name 'QFontMetricsF_xHeight';
function QFontMetricsF_averageCharWidth(handle: QFontMetricsFH): qreal; cdecl; external Qt5PasLib name 'QFontMetricsF_averageCharWidth';
function QFontMetricsF_inFont(handle: QFontMetricsFH; AnonParam1: PWideChar): Boolean; cdecl; external Qt5PasLib name 'QFontMetricsF_inFont';
function QFontMetricsF_inFontUcs4(handle: QFontMetricsFH; ucs4: LongWord): Boolean; cdecl; external Qt5PasLib name 'QFontMetricsF_inFontUcs4';
function QFontMetricsF_leftBearing(handle: QFontMetricsFH; AnonParam1: PWideChar): qreal; cdecl; external Qt5PasLib name 'QFontMetricsF_leftBearing';
function QFontMetricsF_rightBearing(handle: QFontMetricsFH; AnonParam1: PWideChar): qreal; cdecl; external Qt5PasLib name 'QFontMetricsF_rightBearing';
function QFontMetricsF_width(handle: QFontMetricsFH; _string: PWideString): qreal; cdecl; external Qt5PasLib name 'QFontMetricsF_width';
function QFontMetricsF_width(handle: QFontMetricsFH; AnonParam1: PWideChar): qreal; cdecl; external Qt5PasLib name 'QFontMetricsF_width2';
procedure QFontMetricsF_boundingRect(handle: QFontMetricsFH; retval: QRectFH; _string: PWideString); cdecl; external Qt5PasLib name 'QFontMetricsF_boundingRect';
procedure QFontMetricsF_boundingRect(handle: QFontMetricsFH; retval: QRectFH; AnonParam1: PWideChar); cdecl; external Qt5PasLib name 'QFontMetricsF_boundingRect2';
procedure QFontMetricsF_boundingRect(handle: QFontMetricsFH; retval: QRectFH; r: QRectFH; flags: Integer; _string: PWideString; tabstops: Integer = 0; tabarray: PInteger = nil); cdecl; external Qt5PasLib name 'QFontMetricsF_boundingRect3';
procedure QFontMetricsF_size(handle: QFontMetricsFH; retval: QSizeFH; flags: Integer; str: PWideString; tabstops: Integer = 0; tabarray: PInteger = nil); cdecl; external Qt5PasLib name 'QFontMetricsF_size';
procedure QFontMetricsF_tightBoundingRect(handle: QFontMetricsFH; retval: QRectFH; text: PWideString); cdecl; external Qt5PasLib name 'QFontMetricsF_tightBoundingRect';
procedure QFontMetricsF_elidedText(handle: QFontMetricsFH; retval: PWideString; text: PWideString; mode: QtTextElideMode; width: qreal; flags: Integer = 0); cdecl; external Qt5PasLib name 'QFontMetricsF_elidedText';
function QFontMetricsF_underlinePos(handle: QFontMetricsFH): qreal; cdecl; external Qt5PasLib name 'QFontMetricsF_underlinePos';
function QFontMetricsF_overlinePos(handle: QFontMetricsFH): qreal; cdecl; external Qt5PasLib name 'QFontMetricsF_overlinePos';
function QFontMetricsF_strikeOutPos(handle: QFontMetricsFH): qreal; cdecl; external Qt5PasLib name 'QFontMetricsF_strikeOutPos';
function QFontMetricsF_lineWidth(handle: QFontMetricsFH): qreal; cdecl; external Qt5PasLib name 'QFontMetricsF_lineWidth';

function QFontInfo_Create(AnonParam1: QFontH): QFontInfoH; cdecl; external Qt5PasLib name 'QFontInfo_Create';
procedure QFontInfo_Destroy(handle: QFontInfoH); cdecl; external Qt5PasLib name 'QFontInfo_Destroy'; 
function QFontInfo_Create(AnonParam1: QFontInfoH): QFontInfoH; cdecl; external Qt5PasLib name 'QFontInfo_Create2';
procedure QFontInfo_swap(handle: QFontInfoH; other: QFontInfoH); cdecl; external Qt5PasLib name 'QFontInfo_swap';
procedure QFontInfo_family(handle: QFontInfoH; retval: PWideString); cdecl; external Qt5PasLib name 'QFontInfo_family';
procedure QFontInfo_styleName(handle: QFontInfoH; retval: PWideString); cdecl; external Qt5PasLib name 'QFontInfo_styleName';
function QFontInfo_pixelSize(handle: QFontInfoH): Integer; cdecl; external Qt5PasLib name 'QFontInfo_pixelSize';
function QFontInfo_pointSize(handle: QFontInfoH): Integer; cdecl; external Qt5PasLib name 'QFontInfo_pointSize';
function QFontInfo_pointSizeF(handle: QFontInfoH): qreal; cdecl; external Qt5PasLib name 'QFontInfo_pointSizeF';
function QFontInfo_italic(handle: QFontInfoH): Boolean; cdecl; external Qt5PasLib name 'QFontInfo_italic';
function QFontInfo_style(handle: QFontInfoH): QFontStyle; cdecl; external Qt5PasLib name 'QFontInfo_style';
function QFontInfo_weight(handle: QFontInfoH): Integer; cdecl; external Qt5PasLib name 'QFontInfo_weight';
function QFontInfo_bold(handle: QFontInfoH): Boolean; cdecl; external Qt5PasLib name 'QFontInfo_bold';
function QFontInfo_underline(handle: QFontInfoH): Boolean; cdecl; external Qt5PasLib name 'QFontInfo_underline';
function QFontInfo_overline(handle: QFontInfoH): Boolean; cdecl; external Qt5PasLib name 'QFontInfo_overline';
function QFontInfo_strikeOut(handle: QFontInfoH): Boolean; cdecl; external Qt5PasLib name 'QFontInfo_strikeOut';
function QFontInfo_fixedPitch(handle: QFontInfoH): Boolean; cdecl; external Qt5PasLib name 'QFontInfo_fixedPitch';
function QFontInfo_styleHint(handle: QFontInfoH): QFontStyleHint; cdecl; external Qt5PasLib name 'QFontInfo_styleHint';
function QFontInfo_rawMode(handle: QFontInfoH): Boolean; cdecl; external Qt5PasLib name 'QFontInfo_rawMode';
function QFontInfo_exactMatch(handle: QFontInfoH): Boolean; cdecl; external Qt5PasLib name 'QFontInfo_exactMatch';


type
  QTextDocumentMetaInformation = ( // QTextDocument::MetaInformation (1)
    QTextDocumentDocumentTitle, QTextDocumentDocumentUrl );

type
  QTextDocumentFindFlag = cardinal; // QTextDocument::FindFlag
  QTextDocumentFindFlags = QTextDocumentFindFlag; //QFlags<> (3)
const
  QTextDocumentFindBackward =   $00001;
  QTextDocumentFindCaseSensitively =   $00002;
  QTextDocumentFindWholeWords =   $00004;


type
  QTextDocumentResourceType = (  //QTextDocument::ResourceType (2)
    QTextDocumentHtmlResource = 1,
    QTextDocumentImageResource = 2,
    QTextDocumentStyleSheetResource = 3,
    QTextDocumentUserResource = 100 );

type
  QTextDocumentStacks = cardinal; //  QTextDocument::Stacks (4)

const
    QTextDocumentUndoStack = 1 { $1 };
    QTextDocumentRedoStack = 2 { $2 };
    QTextDocumentUndoAndRedoStacks = 3 { $3 };


function QTextDocument_Create(parent: QObjectH = nil): QTextDocumentH; cdecl; external Qt5PasLib name 'QTextDocument_Create';
procedure QTextDocument_Destroy(handle: QTextDocumentH); cdecl; external Qt5PasLib name 'QTextDocument_Destroy'; 
function QTextDocument_Create(text: PWideString; parent: QObjectH = nil): QTextDocumentH; cdecl; external Qt5PasLib name 'QTextDocument_Create2';
function QTextDocument_clone(handle: QTextDocumentH; parent: QObjectH = nil): QTextDocumentH; cdecl; external Qt5PasLib name 'QTextDocument_clone';
function QTextDocument_isEmpty(handle: QTextDocumentH): Boolean; cdecl; external Qt5PasLib name 'QTextDocument_isEmpty';
procedure QTextDocument_clear(handle: QTextDocumentH); cdecl; external Qt5PasLib name 'QTextDocument_clear';
procedure QTextDocument_setUndoRedoEnabled(handle: QTextDocumentH; enable: Boolean); cdecl; external Qt5PasLib name 'QTextDocument_setUndoRedoEnabled';
function QTextDocument_isUndoRedoEnabled(handle: QTextDocumentH): Boolean; cdecl; external Qt5PasLib name 'QTextDocument_isUndoRedoEnabled';
function QTextDocument_isUndoAvailable(handle: QTextDocumentH): Boolean; cdecl; external Qt5PasLib name 'QTextDocument_isUndoAvailable';
function QTextDocument_isRedoAvailable(handle: QTextDocumentH): Boolean; cdecl; external Qt5PasLib name 'QTextDocument_isRedoAvailable';
function QTextDocument_availableUndoSteps(handle: QTextDocumentH): Integer; cdecl; external Qt5PasLib name 'QTextDocument_availableUndoSteps';
function QTextDocument_availableRedoSteps(handle: QTextDocumentH): Integer; cdecl; external Qt5PasLib name 'QTextDocument_availableRedoSteps';
function QTextDocument_revision(handle: QTextDocumentH): Integer; cdecl; external Qt5PasLib name 'QTextDocument_revision';
procedure QTextDocument_setDocumentLayout(handle: QTextDocumentH; layout: QAbstractTextDocumentLayoutH); cdecl; external Qt5PasLib name 'QTextDocument_setDocumentLayout';
function QTextDocument_documentLayout(handle: QTextDocumentH): QAbstractTextDocumentLayoutH; cdecl; external Qt5PasLib name 'QTextDocument_documentLayout';
procedure QTextDocument_setMetaInformation(handle: QTextDocumentH; info: QTextDocumentMetaInformation; AnonParam2: PWideString); cdecl; external Qt5PasLib name 'QTextDocument_setMetaInformation';
procedure QTextDocument_metaInformation(handle: QTextDocumentH; retval: PWideString; info: QTextDocumentMetaInformation); cdecl; external Qt5PasLib name 'QTextDocument_metaInformation';
procedure QTextDocument_toHtml(handle: QTextDocumentH; retval: PWideString; encoding: QByteArrayH = nil); cdecl; external Qt5PasLib name 'QTextDocument_toHtml';
procedure QTextDocument_setHtml(handle: QTextDocumentH; html: PWideString); cdecl; external Qt5PasLib name 'QTextDocument_setHtml';
procedure QTextDocument_toPlainText(handle: QTextDocumentH; retval: PWideString); cdecl; external Qt5PasLib name 'QTextDocument_toPlainText';
procedure QTextDocument_setPlainText(handle: QTextDocumentH; text: PWideString); cdecl; external Qt5PasLib name 'QTextDocument_setPlainText';
procedure QTextDocument_characterAt(handle: QTextDocumentH; retval: PWideChar; pos: Integer); cdecl; external Qt5PasLib name 'QTextDocument_characterAt';
procedure QTextDocument_find(handle: QTextDocumentH; retval: QTextCursorH; subString: PWideString; from: Integer = 0; options: QTextDocumentFindFlags = 0); cdecl; external Qt5PasLib name 'QTextDocument_find';
procedure QTextDocument_find(handle: QTextDocumentH; retval: QTextCursorH; subString: PWideString; from: QTextCursorH; options: QTextDocumentFindFlags = 0); cdecl; external Qt5PasLib name 'QTextDocument_find2';
procedure QTextDocument_find(handle: QTextDocumentH; retval: QTextCursorH; expr: QRegExpH; from: Integer = 0; options: QTextDocumentFindFlags = 0); cdecl; external Qt5PasLib name 'QTextDocument_find3';
procedure QTextDocument_find(handle: QTextDocumentH; retval: QTextCursorH; expr: QRegExpH; from: QTextCursorH; options: QTextDocumentFindFlags = 0); cdecl; external Qt5PasLib name 'QTextDocument_find4';
function QTextDocument_frameAt(handle: QTextDocumentH; pos: Integer): QTextFrameH; cdecl; external Qt5PasLib name 'QTextDocument_frameAt';
function QTextDocument_rootFrame(handle: QTextDocumentH): QTextFrameH; cdecl; external Qt5PasLib name 'QTextDocument_rootFrame';
function QTextDocument_object(handle: QTextDocumentH; objectIndex: Integer): QTextObjectH; cdecl; external Qt5PasLib name 'QTextDocument_object';
function QTextDocument_objectForFormat(handle: QTextDocumentH; AnonParam1: QTextFormatH): QTextObjectH; cdecl; external Qt5PasLib name 'QTextDocument_objectForFormat';
procedure QTextDocument_findBlock(handle: QTextDocumentH; retval: QTextBlockH; pos: Integer); cdecl; external Qt5PasLib name 'QTextDocument_findBlock';
procedure QTextDocument_findBlockByNumber(handle: QTextDocumentH; retval: QTextBlockH; blockNumber: Integer); cdecl; external Qt5PasLib name 'QTextDocument_findBlockByNumber';
procedure QTextDocument_findBlockByLineNumber(handle: QTextDocumentH; retval: QTextBlockH; blockNumber: Integer); cdecl; external Qt5PasLib name 'QTextDocument_findBlockByLineNumber';
procedure QTextDocument_begin(handle: QTextDocumentH; retval: QTextBlockH); cdecl; external Qt5PasLib name 'QTextDocument_begin';
procedure QTextDocument_end(handle: QTextDocumentH; retval: QTextBlockH); cdecl; external Qt5PasLib name 'QTextDocument_end';
procedure QTextDocument_firstBlock(handle: QTextDocumentH; retval: QTextBlockH); cdecl; external Qt5PasLib name 'QTextDocument_firstBlock';
procedure QTextDocument_lastBlock(handle: QTextDocumentH; retval: QTextBlockH); cdecl; external Qt5PasLib name 'QTextDocument_lastBlock';
procedure QTextDocument_setPageSize(handle: QTextDocumentH; size: QSizeFH); cdecl; external Qt5PasLib name 'QTextDocument_setPageSize';
procedure QTextDocument_pageSize(handle: QTextDocumentH; retval: QSizeFH); cdecl; external Qt5PasLib name 'QTextDocument_pageSize';
procedure QTextDocument_setDefaultFont(handle: QTextDocumentH; font: QFontH); cdecl; external Qt5PasLib name 'QTextDocument_setDefaultFont';
procedure QTextDocument_defaultFont(handle: QTextDocumentH; retval: QFontH); cdecl; external Qt5PasLib name 'QTextDocument_defaultFont';
function QTextDocument_pageCount(handle: QTextDocumentH): Integer; cdecl; external Qt5PasLib name 'QTextDocument_pageCount';
function QTextDocument_isModified(handle: QTextDocumentH): Boolean; cdecl; external Qt5PasLib name 'QTextDocument_isModified';
procedure QTextDocument_print(handle: QTextDocumentH; printer: QPagedPaintDeviceH); cdecl; external Qt5PasLib name 'QTextDocument_print';
procedure QTextDocument_resource(handle: QTextDocumentH; retval: QVariantH; _type: Integer; name: QUrlH); cdecl; external Qt5PasLib name 'QTextDocument_resource';
procedure QTextDocument_addResource(handle: QTextDocumentH; _type: Integer; name: QUrlH; resource: QVariantH); cdecl; external Qt5PasLib name 'QTextDocument_addResource';
procedure QTextDocument_markContentsDirty(handle: QTextDocumentH; from: Integer; length: Integer); cdecl; external Qt5PasLib name 'QTextDocument_markContentsDirty';
procedure QTextDocument_setUseDesignMetrics(handle: QTextDocumentH; b: Boolean); cdecl; external Qt5PasLib name 'QTextDocument_setUseDesignMetrics';
function QTextDocument_useDesignMetrics(handle: QTextDocumentH): Boolean; cdecl; external Qt5PasLib name 'QTextDocument_useDesignMetrics';
procedure QTextDocument_drawContents(handle: QTextDocumentH; painter: QPainterH; rect: QRectFH = nil); cdecl; external Qt5PasLib name 'QTextDocument_drawContents';
procedure QTextDocument_setTextWidth(handle: QTextDocumentH; width: qreal); cdecl; external Qt5PasLib name 'QTextDocument_setTextWidth';
function QTextDocument_textWidth(handle: QTextDocumentH): qreal; cdecl; external Qt5PasLib name 'QTextDocument_textWidth';
function QTextDocument_idealWidth(handle: QTextDocumentH): qreal; cdecl; external Qt5PasLib name 'QTextDocument_idealWidth';
function QTextDocument_indentWidth(handle: QTextDocumentH): qreal; cdecl; external Qt5PasLib name 'QTextDocument_indentWidth';
procedure QTextDocument_setIndentWidth(handle: QTextDocumentH; width: qreal); cdecl; external Qt5PasLib name 'QTextDocument_setIndentWidth';
function QTextDocument_documentMargin(handle: QTextDocumentH): qreal; cdecl; external Qt5PasLib name 'QTextDocument_documentMargin';
procedure QTextDocument_setDocumentMargin(handle: QTextDocumentH; margin: qreal); cdecl; external Qt5PasLib name 'QTextDocument_setDocumentMargin';
procedure QTextDocument_adjustSize(handle: QTextDocumentH); cdecl; external Qt5PasLib name 'QTextDocument_adjustSize';
procedure QTextDocument_size(handle: QTextDocumentH; retval: QSizeFH); cdecl; external Qt5PasLib name 'QTextDocument_size';
function QTextDocument_blockCount(handle: QTextDocumentH): Integer; cdecl; external Qt5PasLib name 'QTextDocument_blockCount';
function QTextDocument_lineCount(handle: QTextDocumentH): Integer; cdecl; external Qt5PasLib name 'QTextDocument_lineCount';
function QTextDocument_characterCount(handle: QTextDocumentH): Integer; cdecl; external Qt5PasLib name 'QTextDocument_characterCount';
procedure QTextDocument_setDefaultStyleSheet(handle: QTextDocumentH; sheet: PWideString); cdecl; external Qt5PasLib name 'QTextDocument_setDefaultStyleSheet';
procedure QTextDocument_defaultStyleSheet(handle: QTextDocumentH; retval: PWideString); cdecl; external Qt5PasLib name 'QTextDocument_defaultStyleSheet';
procedure QTextDocument_undo(handle: QTextDocumentH; cursor: QTextCursorH); cdecl; external Qt5PasLib name 'QTextDocument_undo';
procedure QTextDocument_redo(handle: QTextDocumentH; cursor: QTextCursorH); cdecl; external Qt5PasLib name 'QTextDocument_redo';
procedure QTextDocument_clearUndoRedoStacks(handle: QTextDocumentH; historyToClear: QTextDocumentStacks = QTextDocumentUndoAndRedoStacks); cdecl; external Qt5PasLib name 'QTextDocument_clearUndoRedoStacks';
function QTextDocument_maximumBlockCount(handle: QTextDocumentH): Integer; cdecl; external Qt5PasLib name 'QTextDocument_maximumBlockCount';
procedure QTextDocument_setMaximumBlockCount(handle: QTextDocumentH; maximum: Integer); cdecl; external Qt5PasLib name 'QTextDocument_setMaximumBlockCount';
procedure QTextDocument_defaultTextOption(handle: QTextDocumentH; retval: QTextOptionH); cdecl; external Qt5PasLib name 'QTextDocument_defaultTextOption';
procedure QTextDocument_setDefaultTextOption(handle: QTextDocumentH; option: QTextOptionH); cdecl; external Qt5PasLib name 'QTextDocument_setDefaultTextOption';
function QTextDocument_defaultCursorMoveStyle(handle: QTextDocumentH): QtCursorMoveStyle; cdecl; external Qt5PasLib name 'QTextDocument_defaultCursorMoveStyle';
procedure QTextDocument_setDefaultCursorMoveStyle(handle: QTextDocumentH; style: QtCursorMoveStyle); cdecl; external Qt5PasLib name 'QTextDocument_setDefaultCursorMoveStyle';
procedure QTextDocument_undo(handle: QTextDocumentH); cdecl; external Qt5PasLib name 'QTextDocument_undo2';
procedure QTextDocument_redo(handle: QTextDocumentH); cdecl; external Qt5PasLib name 'QTextDocument_redo2';
procedure QTextDocument_setModified(handle: QTextDocumentH; m: Boolean = True); cdecl; external Qt5PasLib name 'QTextDocument_setModified';

function QAbstractTextDocumentLayout_hitTest(handle: QAbstractTextDocumentLayoutH; point: PQtPointF; accuracy: QtHitTestAccuracy): Integer; cdecl; external Qt5PasLib name 'QAbstractTextDocumentLayout_hitTest';
procedure QAbstractTextDocumentLayout_anchorAt(handle: QAbstractTextDocumentLayoutH; retval: PWideString; pos: PQtPointF); cdecl; external Qt5PasLib name 'QAbstractTextDocumentLayout_anchorAt';
function QAbstractTextDocumentLayout_pageCount(handle: QAbstractTextDocumentLayoutH): Integer; cdecl; external Qt5PasLib name 'QAbstractTextDocumentLayout_pageCount';
procedure QAbstractTextDocumentLayout_documentSize(handle: QAbstractTextDocumentLayoutH; retval: QSizeFH); cdecl; external Qt5PasLib name 'QAbstractTextDocumentLayout_documentSize';
procedure QAbstractTextDocumentLayout_frameBoundingRect(handle: QAbstractTextDocumentLayoutH; retval: QRectFH; frame: QTextFrameH); cdecl; external Qt5PasLib name 'QAbstractTextDocumentLayout_frameBoundingRect';
procedure QAbstractTextDocumentLayout_blockBoundingRect(handle: QAbstractTextDocumentLayoutH; retval: QRectFH; block: QTextBlockH); cdecl; external Qt5PasLib name 'QAbstractTextDocumentLayout_blockBoundingRect';
procedure QAbstractTextDocumentLayout_setPaintDevice(handle: QAbstractTextDocumentLayoutH; device: QPaintDeviceH); cdecl; external Qt5PasLib name 'QAbstractTextDocumentLayout_setPaintDevice';
function QAbstractTextDocumentLayout_paintDevice(handle: QAbstractTextDocumentLayoutH): QPaintDeviceH; cdecl; external Qt5PasLib name 'QAbstractTextDocumentLayout_paintDevice';
function QAbstractTextDocumentLayout_document(handle: QAbstractTextDocumentLayoutH): QTextDocumentH; cdecl; external Qt5PasLib name 'QAbstractTextDocumentLayout_document';
procedure QAbstractTextDocumentLayout_registerHandler(handle: QAbstractTextDocumentLayoutH; objectType: Integer; component: QObjectH); cdecl; external Qt5PasLib name 'QAbstractTextDocumentLayout_registerHandler';
function QAbstractTextDocumentLayout_handlerForObject(handle: QAbstractTextDocumentLayoutH; objectType: Integer): QTextObjectInterfaceH; cdecl; external Qt5PasLib name 'QAbstractTextDocumentLayout_handlerForObject';

procedure QTextObjectInterface_intrinsicSize(handle: QTextObjectInterfaceH; retval: QSizeFH; doc: QTextDocumentH; posInDocument: Integer; format: QTextFormatH); cdecl; external Qt5PasLib name 'QTextObjectInterface_intrinsicSize';
procedure QTextObjectInterface_drawObject(handle: QTextObjectInterfaceH; painter: QPainterH; rect: QRectFH; doc: QTextDocumentH; posInDocument: Integer; format: QTextFormatH); cdecl; external Qt5PasLib name 'QTextObjectInterface_drawObject';


type
  QAbstractTextDocumentLayout_update_Event = procedure (AnonParam1: QRectFH) of object cdecl;
  QAbstractTextDocumentLayout_update2_Event = procedure () of object cdecl;
  QAbstractTextDocumentLayout_updateBlock_Event = procedure (block: QTextBlockH) of object cdecl;
  QAbstractTextDocumentLayout_documentSizeChanged_Event = procedure (newSize: QSizeFH) of object cdecl;
  QAbstractTextDocumentLayout_pageCountChanged_Event = procedure (newPages: Integer) of object cdecl;



type
  QTextLayoutCursorMode = ( // QTextLayout::CursorMode (1)
    QTextLayoutSkipCharacters, QTextLayoutSkipWords );


type
  QTextLineEdge = ( // QTextLine::Edge (1)
    QTextLineLeading, QTextLineTrailing );

  QTextLineCursorPosition = ( // QTextLine::CursorPosition (1)
    QTextLineCursorBetweenCharacters, QTextLineCursorOnCharacter );

  PQTextLayoutFormat = ^TQTextLayoutFormat;
  TQTextLayoutFormat = packed record
    start: longint;
    length: longint;
    format: QTextCharFormatH;
  end;

function QTextInlineObject_Create(): QTextInlineObjectH; cdecl; external Qt5PasLib name 'QTextInlineObject_Create';
procedure QTextInlineObject_Destroy(handle: QTextInlineObjectH); cdecl; external Qt5PasLib name 'QTextInlineObject_Destroy'; 
function QTextInlineObject_isValid(handle: QTextInlineObjectH): Boolean; cdecl; external Qt5PasLib name 'QTextInlineObject_isValid';
procedure QTextInlineObject_rect(handle: QTextInlineObjectH; retval: QRectFH); cdecl; external Qt5PasLib name 'QTextInlineObject_rect';
function QTextInlineObject_width(handle: QTextInlineObjectH): qreal; cdecl; external Qt5PasLib name 'QTextInlineObject_width';
function QTextInlineObject_ascent(handle: QTextInlineObjectH): qreal; cdecl; external Qt5PasLib name 'QTextInlineObject_ascent';
function QTextInlineObject_descent(handle: QTextInlineObjectH): qreal; cdecl; external Qt5PasLib name 'QTextInlineObject_descent';
function QTextInlineObject_height(handle: QTextInlineObjectH): qreal; cdecl; external Qt5PasLib name 'QTextInlineObject_height';
function QTextInlineObject_textDirection(handle: QTextInlineObjectH): QtLayoutDirection; cdecl; external Qt5PasLib name 'QTextInlineObject_textDirection';
procedure QTextInlineObject_setWidth(handle: QTextInlineObjectH; w: qreal); cdecl; external Qt5PasLib name 'QTextInlineObject_setWidth';
procedure QTextInlineObject_setAscent(handle: QTextInlineObjectH; a: qreal); cdecl; external Qt5PasLib name 'QTextInlineObject_setAscent';
procedure QTextInlineObject_setDescent(handle: QTextInlineObjectH; d: qreal); cdecl; external Qt5PasLib name 'QTextInlineObject_setDescent';
function QTextInlineObject_textPosition(handle: QTextInlineObjectH): Integer; cdecl; external Qt5PasLib name 'QTextInlineObject_textPosition';
function QTextInlineObject_formatIndex(handle: QTextInlineObjectH): Integer; cdecl; external Qt5PasLib name 'QTextInlineObject_formatIndex';
procedure QTextInlineObject_format(handle: QTextInlineObjectH; retval: QTextFormatH); cdecl; external Qt5PasLib name 'QTextInlineObject_format';

type
  TTextRange = packed record
    start : longint;
    length : longint;
  end;
  PTextRange = ^TTextRange;
  TTextRangeArray = array[word] of TTextRange;
  PTextRangeArray = ^TTextRangeArray;

function QTextLayout_Create(): QTextLayoutH; cdecl; external Qt5PasLib name 'QTextLayout_Create';
procedure QTextLayout_Destroy(handle: QTextLayoutH); cdecl; external Qt5PasLib name 'QTextLayout_Destroy'; 
function QTextLayout_Create(text: PWideString): QTextLayoutH; cdecl; external Qt5PasLib name 'QTextLayout_Create2';
function QTextLayout_Create(text: PWideString; font: QFontH; paintdevice: QPaintDeviceH = nil): QTextLayoutH; cdecl; external Qt5PasLib name 'QTextLayout_Create3';
function QTextLayout_Create(b: QTextBlockH): QTextLayoutH; cdecl; external Qt5PasLib name 'QTextLayout_Create4';
procedure QTextLayout_setFont(handle: QTextLayoutH; f: QFontH); cdecl; external Qt5PasLib name 'QTextLayout_setFont';
procedure QTextLayout_font(handle: QTextLayoutH; retval: QFontH); cdecl; external Qt5PasLib name 'QTextLayout_font';
procedure QTextLayout_setRawFont(handle: QTextLayoutH; rawFont: QRawFontH); cdecl; external Qt5PasLib name 'QTextLayout_setRawFont';
procedure QTextLayout_setText(handle: QTextLayoutH; _string: PWideString); cdecl; external Qt5PasLib name 'QTextLayout_setText';
procedure QTextLayout_text(handle: QTextLayoutH; retval: PWideString); cdecl; external Qt5PasLib name 'QTextLayout_text';
procedure QTextLayout_setTextOption(handle: QTextLayoutH; option: QTextOptionH); cdecl; external Qt5PasLib name 'QTextLayout_setTextOption';
function QTextLayout_textOption(handle: QTextLayoutH): QTextOptionH; cdecl; external Qt5PasLib name 'QTextLayout_textOption';
procedure QTextLayout_setPreeditArea(handle: QTextLayoutH; position: Integer; text: PWideString); cdecl; external Qt5PasLib name 'QTextLayout_setPreeditArea';
function QTextLayout_preeditAreaPosition(handle: QTextLayoutH): Integer; cdecl; external Qt5PasLib name 'QTextLayout_preeditAreaPosition';
procedure QTextLayout_preeditAreaText(handle: QTextLayoutH; retval: PWideString); cdecl; external Qt5PasLib name 'QTextLayout_preeditAreaText';
procedure QTextLayout_setCacheEnabled(handle: QTextLayoutH; enable: Boolean); cdecl; external Qt5PasLib name 'QTextLayout_setCacheEnabled';
function QTextLayout_cacheEnabled(handle: QTextLayoutH): Boolean; cdecl; external Qt5PasLib name 'QTextLayout_cacheEnabled';
procedure QTextLayout_setCursorMoveStyle(handle: QTextLayoutH; style: QtCursorMoveStyle); cdecl; external Qt5PasLib name 'QTextLayout_setCursorMoveStyle';
function QTextLayout_cursorMoveStyle(handle: QTextLayoutH): QtCursorMoveStyle; cdecl; external Qt5PasLib name 'QTextLayout_cursorMoveStyle';
procedure QTextLayout_beginLayout(handle: QTextLayoutH); cdecl; external Qt5PasLib name 'QTextLayout_beginLayout';
procedure QTextLayout_endLayout(handle: QTextLayoutH); cdecl; external Qt5PasLib name 'QTextLayout_endLayout';
procedure QTextLayout_clearLayout(handle: QTextLayoutH); cdecl; external Qt5PasLib name 'QTextLayout_clearLayout';
procedure QTextLayout_createLine(handle: QTextLayoutH; retval: QTextLineH); cdecl; external Qt5PasLib name 'QTextLayout_createLine';
function QTextLayout_lineCount(handle: QTextLayoutH): Integer; cdecl; external Qt5PasLib name 'QTextLayout_lineCount';
procedure QTextLayout_lineAt(handle: QTextLayoutH; retval: QTextLineH; i: Integer); cdecl; external Qt5PasLib name 'QTextLayout_lineAt';
procedure QTextLayout_lineForTextPosition(handle: QTextLayoutH; retval: QTextLineH; pos: Integer); cdecl; external Qt5PasLib name 'QTextLayout_lineForTextPosition';
function QTextLayout_isValidCursorPosition(handle: QTextLayoutH; pos: Integer): Boolean; cdecl; external Qt5PasLib name 'QTextLayout_isValidCursorPosition';
function QTextLayout_nextCursorPosition(handle: QTextLayoutH; oldPos: Integer; mode: QTextLayoutCursorMode = QTextLayoutSkipCharacters): Integer; cdecl; external Qt5PasLib name 'QTextLayout_nextCursorPosition';
function QTextLayout_previousCursorPosition(handle: QTextLayoutH; oldPos: Integer; mode: QTextLayoutCursorMode = QTextLayoutSkipCharacters): Integer; cdecl; external Qt5PasLib name 'QTextLayout_previousCursorPosition';
function QTextLayout_leftCursorPosition(handle: QTextLayoutH; oldPos: Integer): Integer; cdecl; external Qt5PasLib name 'QTextLayout_leftCursorPosition';
function QTextLayout_rightCursorPosition(handle: QTextLayoutH; oldPos: Integer): Integer; cdecl; external Qt5PasLib name 'QTextLayout_rightCursorPosition';
procedure QTextLayout_drawCursor(handle: QTextLayoutH; p: QPainterH; pos: PQtPointF; cursorPosition: Integer); cdecl; external Qt5PasLib name 'QTextLayout_drawCursor';
procedure QTextLayout_drawCursor(handle: QTextLayoutH; p: QPainterH; pos: PQtPointF; cursorPosition: Integer; width: Integer); cdecl; external Qt5PasLib name 'QTextLayout_drawCursor2';
procedure QTextLayout_position(handle: QTextLayoutH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QTextLayout_position';
procedure QTextLayout_setPosition(handle: QTextLayoutH; p: PQtPointF); cdecl; external Qt5PasLib name 'QTextLayout_setPosition';
procedure QTextLayout_boundingRect(handle: QTextLayoutH; retval: QRectFH); cdecl; external Qt5PasLib name 'QTextLayout_boundingRect';
function QTextLayout_minimumWidth(handle: QTextLayoutH): qreal; cdecl; external Qt5PasLib name 'QTextLayout_minimumWidth';
function QTextLayout_maximumWidth(handle: QTextLayoutH): qreal; cdecl; external Qt5PasLib name 'QTextLayout_maximumWidth';
procedure QTextLayout_glyphRuns(handle: QTextLayoutH; retval: PPtrIntArray; from: Integer = -1; length: Integer = -1); cdecl; external Qt5PasLib name 'QTextLayout_glyphRuns';
procedure QTextLayout_setFlags(handle: QTextLayoutH; flags: Integer); cdecl; external Qt5PasLib name 'QTextLayout_setFlags';

procedure QTextLayout_clearFormats(handle: QTextLayoutH); cdecl; external Qt5PasLib name 'QTextLayout_clearFormats';
function QTextLayout_formatsCount(handle: QTextLayoutH): longint; cdecl; external Qt5PasLib name 'QTextLayout_formatsCount';
function QTextLayout_formatsRanges(handle: QTextLayoutH; ranges: PTextRangeArray; longint: integer): longint; cdecl; external Qt5PasLib name 'QTextLayout_formatsRanges';

function QTextLine_Create(): QTextLineH; cdecl; external Qt5PasLib name 'QTextLine_Create';
procedure QTextLine_Destroy(handle: QTextLineH); cdecl; external Qt5PasLib name 'QTextLine_Destroy'; 
function QTextLine_isValid(handle: QTextLineH): Boolean; cdecl; external Qt5PasLib name 'QTextLine_isValid';
procedure QTextLine_rect(handle: QTextLineH; retval: QRectFH); cdecl; external Qt5PasLib name 'QTextLine_rect';
function QTextLine_x(handle: QTextLineH): qreal; cdecl; external Qt5PasLib name 'QTextLine_x';
function QTextLine_y(handle: QTextLineH): qreal; cdecl; external Qt5PasLib name 'QTextLine_y';
function QTextLine_width(handle: QTextLineH): qreal; cdecl; external Qt5PasLib name 'QTextLine_width';
function QTextLine_ascent(handle: QTextLineH): qreal; cdecl; external Qt5PasLib name 'QTextLine_ascent';
function QTextLine_descent(handle: QTextLineH): qreal; cdecl; external Qt5PasLib name 'QTextLine_descent';
function QTextLine_height(handle: QTextLineH): qreal; cdecl; external Qt5PasLib name 'QTextLine_height';
function QTextLine_leading(handle: QTextLineH): qreal; cdecl; external Qt5PasLib name 'QTextLine_leading';
procedure QTextLine_setLeadingIncluded(handle: QTextLineH; included: Boolean); cdecl; external Qt5PasLib name 'QTextLine_setLeadingIncluded';
function QTextLine_leadingIncluded(handle: QTextLineH): Boolean; cdecl; external Qt5PasLib name 'QTextLine_leadingIncluded';
function QTextLine_naturalTextWidth(handle: QTextLineH): qreal; cdecl; external Qt5PasLib name 'QTextLine_naturalTextWidth';
function QTextLine_horizontalAdvance(handle: QTextLineH): qreal; cdecl; external Qt5PasLib name 'QTextLine_horizontalAdvance';
procedure QTextLine_naturalTextRect(handle: QTextLineH; retval: QRectFH); cdecl; external Qt5PasLib name 'QTextLine_naturalTextRect';
function QTextLine_cursorToX(handle: QTextLineH; cursorPos: PInteger; edge: QTextLineEdge = QTextLineLeading): qreal; cdecl; external Qt5PasLib name 'QTextLine_cursorToX';
function QTextLine_cursorToX(handle: QTextLineH; cursorPos: Integer; edge: QTextLineEdge = QTextLineLeading): qreal; cdecl; external Qt5PasLib name 'QTextLine_cursorToX2';
function QTextLine_xToCursor(handle: QTextLineH; x: qreal; AnonParam2: QTextLineCursorPosition = QTextLineCursorBetweenCharacters): Integer; cdecl; external Qt5PasLib name 'QTextLine_xToCursor';
procedure QTextLine_setLineWidth(handle: QTextLineH; width: qreal); cdecl; external Qt5PasLib name 'QTextLine_setLineWidth';
procedure QTextLine_setNumColumns(handle: QTextLineH; columns: Integer); cdecl; external Qt5PasLib name 'QTextLine_setNumColumns';
procedure QTextLine_setNumColumns(handle: QTextLineH; columns: Integer; alignmentWidth: qreal); cdecl; external Qt5PasLib name 'QTextLine_setNumColumns2';
procedure QTextLine_setPosition(handle: QTextLineH; pos: PQtPointF); cdecl; external Qt5PasLib name 'QTextLine_setPosition';
procedure QTextLine_position(handle: QTextLineH; retval: PQtPointF); cdecl; external Qt5PasLib name 'QTextLine_position';
function QTextLine_textStart(handle: QTextLineH): Integer; cdecl; external Qt5PasLib name 'QTextLine_textStart';
function QTextLine_textLength(handle: QTextLineH): Integer; cdecl; external Qt5PasLib name 'QTextLine_textLength';
function QTextLine_lineNumber(handle: QTextLineH): Integer; cdecl; external Qt5PasLib name 'QTextLine_lineNumber';
procedure QTextLine_glyphRuns(handle: QTextLineH; retval: PPtrIntArray; from: Integer = -1; length: Integer = -1); cdecl; external Qt5PasLib name 'QTextLine_glyphRuns';

procedure QTextObject_format(handle: QTextObjectH; retval: QTextFormatH); cdecl; external Qt5PasLib name 'QTextObject_format';
function QTextObject_formatIndex(handle: QTextObjectH): Integer; cdecl; external Qt5PasLib name 'QTextObject_formatIndex';
function QTextObject_document(handle: QTextObjectH): QTextDocumentH; cdecl; external Qt5PasLib name 'QTextObject_document';
function QTextObject_objectIndex(handle: QTextObjectH): Integer; cdecl; external Qt5PasLib name 'QTextObject_objectIndex';


function QTextFrame_Create(doc: QTextDocumentH): QTextFrameH; cdecl; external Qt5PasLib name 'QTextFrame_Create';
procedure QTextFrame_Destroy(handle: QTextFrameH); cdecl; external Qt5PasLib name 'QTextFrame_Destroy'; 
procedure QTextFrame_setFrameFormat(handle: QTextFrameH; format: QTextFrameFormatH); cdecl; external Qt5PasLib name 'QTextFrame_setFrameFormat';
procedure QTextFrame_frameFormat(handle: QTextFrameH; retval: QTextFrameFormatH); cdecl; external Qt5PasLib name 'QTextFrame_frameFormat';
procedure QTextFrame_firstCursorPosition(handle: QTextFrameH; retval: QTextCursorH); cdecl; external Qt5PasLib name 'QTextFrame_firstCursorPosition';
procedure QTextFrame_lastCursorPosition(handle: QTextFrameH; retval: QTextCursorH); cdecl; external Qt5PasLib name 'QTextFrame_lastCursorPosition';
function QTextFrame_firstPosition(handle: QTextFrameH): Integer; cdecl; external Qt5PasLib name 'QTextFrame_firstPosition';
function QTextFrame_lastPosition(handle: QTextFrameH): Integer; cdecl; external Qt5PasLib name 'QTextFrame_lastPosition';
procedure QTextFrame_childFrames(handle: QTextFrameH; retval: PPtrIntArray); cdecl; external Qt5PasLib name 'QTextFrame_childFrames';
function QTextFrame_parentFrame(handle: QTextFrameH): QTextFrameH; cdecl; external Qt5PasLib name 'QTextFrame_parentFrame';


function QTextBlock_Create(): QTextBlockH; cdecl; external Qt5PasLib name 'QTextBlock_Create';
procedure QTextBlock_Destroy(handle: QTextBlockH); cdecl; external Qt5PasLib name 'QTextBlock_Destroy'; 
function QTextBlock_Create(o: QTextBlockH): QTextBlockH; cdecl; external Qt5PasLib name 'QTextBlock_Create2';
function QTextBlock_isValid(handle: QTextBlockH): Boolean; cdecl; external Qt5PasLib name 'QTextBlock_isValid';
function QTextBlock_position(handle: QTextBlockH): Integer; cdecl; external Qt5PasLib name 'QTextBlock_position';
function QTextBlock_length(handle: QTextBlockH): Integer; cdecl; external Qt5PasLib name 'QTextBlock_length';
function QTextBlock_contains(handle: QTextBlockH; position: Integer): Boolean; cdecl; external Qt5PasLib name 'QTextBlock_contains';
function QTextBlock_layout(handle: QTextBlockH): QTextLayoutH; cdecl; external Qt5PasLib name 'QTextBlock_layout';
procedure QTextBlock_clearLayout(handle: QTextBlockH); cdecl; external Qt5PasLib name 'QTextBlock_clearLayout';
procedure QTextBlock_blockFormat(handle: QTextBlockH; retval: QTextBlockFormatH); cdecl; external Qt5PasLib name 'QTextBlock_blockFormat';
function QTextBlock_blockFormatIndex(handle: QTextBlockH): Integer; cdecl; external Qt5PasLib name 'QTextBlock_blockFormatIndex';
procedure QTextBlock_charFormat(handle: QTextBlockH; retval: QTextCharFormatH); cdecl; external Qt5PasLib name 'QTextBlock_charFormat';
function QTextBlock_charFormatIndex(handle: QTextBlockH): Integer; cdecl; external Qt5PasLib name 'QTextBlock_charFormatIndex';
function QTextBlock_textDirection(handle: QTextBlockH): QtLayoutDirection; cdecl; external Qt5PasLib name 'QTextBlock_textDirection';
procedure QTextBlock_text(handle: QTextBlockH; retval: PWideString); cdecl; external Qt5PasLib name 'QTextBlock_text';
function QTextBlock_document(handle: QTextBlockH): QTextDocumentH; cdecl; external Qt5PasLib name 'QTextBlock_document';
function QTextBlock_textList(handle: QTextBlockH): QTextListH; cdecl; external Qt5PasLib name 'QTextBlock_textList';
function QTextBlock_userData(handle: QTextBlockH): QTextBlockUserDataH; cdecl; external Qt5PasLib name 'QTextBlock_userData';
procedure QTextBlock_setUserData(handle: QTextBlockH; data: QTextBlockUserDataH); cdecl; external Qt5PasLib name 'QTextBlock_setUserData';
function QTextBlock_userState(handle: QTextBlockH): Integer; cdecl; external Qt5PasLib name 'QTextBlock_userState';
procedure QTextBlock_setUserState(handle: QTextBlockH; state: Integer); cdecl; external Qt5PasLib name 'QTextBlock_setUserState';
function QTextBlock_revision(handle: QTextBlockH): Integer; cdecl; external Qt5PasLib name 'QTextBlock_revision';
procedure QTextBlock_setRevision(handle: QTextBlockH; rev: Integer); cdecl; external Qt5PasLib name 'QTextBlock_setRevision';
function QTextBlock_isVisible(handle: QTextBlockH): Boolean; cdecl; external Qt5PasLib name 'QTextBlock_isVisible';
procedure QTextBlock_setVisible(handle: QTextBlockH; visible: Boolean); cdecl; external Qt5PasLib name 'QTextBlock_setVisible';
function QTextBlock_blockNumber(handle: QTextBlockH): Integer; cdecl; external Qt5PasLib name 'QTextBlock_blockNumber';
function QTextBlock_firstLineNumber(handle: QTextBlockH): Integer; cdecl; external Qt5PasLib name 'QTextBlock_firstLineNumber';
procedure QTextBlock_setLineCount(handle: QTextBlockH; count: Integer); cdecl; external Qt5PasLib name 'QTextBlock_setLineCount';
function QTextBlock_lineCount(handle: QTextBlockH): Integer; cdecl; external Qt5PasLib name 'QTextBlock_lineCount';
procedure QTextBlock_next(handle: QTextBlockH; retval: QTextBlockH); cdecl; external Qt5PasLib name 'QTextBlock_next';
procedure QTextBlock_previous(handle: QTextBlockH; retval: QTextBlockH); cdecl; external Qt5PasLib name 'QTextBlock_previous';
function QTextBlock_fragmentIndex(handle: QTextBlockH): Integer; cdecl; external Qt5PasLib name 'QTextBlock_fragmentIndex';

function QTextBlock_textFormatsCount(handle: QTextBlockH): longint; cdecl; external Qt5PasLib name 'QTextBlock_textFormatsCount';
function QTextBlock_textFormatsRanges(handle: QTextBlockH; ranges: PTextRangeArray; longint: integer): longint; cdecl; external Qt5PasLib name 'QTextBlock_textFormatsRanges';

function QTextFragment_Create(): QTextFragmentH; cdecl; external Qt5PasLib name 'QTextFragment_Create';
procedure QTextFragment_Destroy(handle: QTextFragmentH); cdecl; external Qt5PasLib name 'QTextFragment_Destroy'; 
function QTextFragment_Create(o: QTextFragmentH): QTextFragmentH; cdecl; external Qt5PasLib name 'QTextFragment_Create2';
function QTextFragment_isValid(handle: QTextFragmentH): Boolean; cdecl; external Qt5PasLib name 'QTextFragment_isValid';
function QTextFragment_position(handle: QTextFragmentH): Integer; cdecl; external Qt5PasLib name 'QTextFragment_position';
function QTextFragment_length(handle: QTextFragmentH): Integer; cdecl; external Qt5PasLib name 'QTextFragment_length';
function QTextFragment_contains(handle: QTextFragmentH; position: Integer): Boolean; cdecl; external Qt5PasLib name 'QTextFragment_contains';
procedure QTextFragment_charFormat(handle: QTextFragmentH; retval: QTextCharFormatH); cdecl; external Qt5PasLib name 'QTextFragment_charFormat';
function QTextFragment_charFormatIndex(handle: QTextFragmentH): Integer; cdecl; external Qt5PasLib name 'QTextFragment_charFormatIndex';
procedure QTextFragment_text(handle: QTextFragmentH; retval: PWideString); cdecl; external Qt5PasLib name 'QTextFragment_text';
procedure QTextFragment_glyphRuns(handle: QTextFragmentH; retval: PPtrIntArray; from: Integer = -1; length: Integer = -1); cdecl; external Qt5PasLib name 'QTextFragment_glyphRuns';

function QTextDocumentWriter_Create(): QTextDocumentWriterH; cdecl; external Qt5PasLib name 'QTextDocumentWriter_Create';
procedure QTextDocumentWriter_Destroy(handle: QTextDocumentWriterH); cdecl; external Qt5PasLib name 'QTextDocumentWriter_Destroy'; 
function QTextDocumentWriter_Create(device: QIODeviceH; format: QByteArrayH): QTextDocumentWriterH; cdecl; external Qt5PasLib name 'QTextDocumentWriter_Create2';
function QTextDocumentWriter_Create(fileName: PWideString; format: QByteArrayH = nil): QTextDocumentWriterH; cdecl; external Qt5PasLib name 'QTextDocumentWriter_Create3';
procedure QTextDocumentWriter_setFormat(handle: QTextDocumentWriterH; format: QByteArrayH); cdecl; external Qt5PasLib name 'QTextDocumentWriter_setFormat';
procedure QTextDocumentWriter_format(handle: QTextDocumentWriterH; retval: QByteArrayH); cdecl; external Qt5PasLib name 'QTextDocumentWriter_format';
procedure QTextDocumentWriter_setDevice(handle: QTextDocumentWriterH; device: QIODeviceH); cdecl; external Qt5PasLib name 'QTextDocumentWriter_setDevice';
function QTextDocumentWriter_device(handle: QTextDocumentWriterH): QIODeviceH; cdecl; external Qt5PasLib name 'QTextDocumentWriter_device';
procedure QTextDocumentWriter_setFileName(handle: QTextDocumentWriterH; fileName: PWideString); cdecl; external Qt5PasLib name 'QTextDocumentWriter_setFileName';
procedure QTextDocumentWriter_fileName(handle: QTextDocumentWriterH; retval: PWideString); cdecl; external Qt5PasLib name 'QTextDocumentWriter_fileName';
function QTextDocumentWriter_write(handle: QTextDocumentWriterH; document: QTextDocumentH): Boolean; cdecl; external Qt5PasLib name 'QTextDocumentWriter_write';
function QTextDocumentWriter_write(handle: QTextDocumentWriterH; fragment: QTextDocumentFragmentH): Boolean; cdecl; external Qt5PasLib name 'QTextDocumentWriter_write2';
procedure QTextDocumentWriter_setCodec(handle: QTextDocumentWriterH; codec: QTextCodecH); cdecl; external Qt5PasLib name 'QTextDocumentWriter_setCodec';
function QTextDocumentWriter_codec(handle: QTextDocumentWriterH): QTextCodecH; cdecl; external Qt5PasLib name 'QTextDocumentWriter_codec';


type
  QIconMode = ( // QIcon::Mode (1)
    QIconNormal, QIconDisabled, QIconActive, QIconSelected );

  QIconState = ( // QIcon::State (1)
    QIconOn, QIconOff );

function QIcon_Create(): QIconH; cdecl; external Qt5PasLib name 'QIcon_Create';
procedure QIcon_Destroy(handle: QIconH); cdecl; external Qt5PasLib name 'QIcon_Destroy'; 
function QIcon_Create(pixmap: QPixmapH): QIconH; cdecl; external Qt5PasLib name 'QIcon_Create2';
function QIcon_Create(other: QIconH): QIconH; cdecl; external Qt5PasLib name 'QIcon_Create3';
function QIcon_Create(fileName: PWideString): QIconH; cdecl; external Qt5PasLib name 'QIcon_Create4';
function QIcon_Create(engine: QIconEngineH): QIconH; cdecl; external Qt5PasLib name 'QIcon_Create5';
procedure QIcon_swap(handle: QIconH; other: QIconH); cdecl; external Qt5PasLib name 'QIcon_swap';
procedure QIcon_pixmap(handle: QIconH; retval: QPixmapH; size: PSize; mode: QIconMode = QIconNormal; state: QIconState = QIconOff); cdecl; external Qt5PasLib name 'QIcon_pixmap';
procedure QIcon_pixmap(handle: QIconH; retval: QPixmapH; w: Integer; h: Integer; mode: QIconMode = QIconNormal; state: QIconState = QIconOff); cdecl; external Qt5PasLib name 'QIcon_pixmap2';
procedure QIcon_pixmap(handle: QIconH; retval: QPixmapH; extent: Integer; mode: QIconMode = QIconNormal; state: QIconState = QIconOff); cdecl; external Qt5PasLib name 'QIcon_pixmap3';
procedure QIcon_pixmap(handle: QIconH; retval: QPixmapH; window: QWindowH; size: PSize; mode: QIconMode = QIconNormal; state: QIconState = QIconOff); cdecl; external Qt5PasLib name 'QIcon_pixmap4';
procedure QIcon_actualSize(handle: QIconH; retval: PSize; size: PSize; mode: QIconMode = QIconNormal; state: QIconState = QIconOff); cdecl; external Qt5PasLib name 'QIcon_actualSize';
procedure QIcon_actualSize(handle: QIconH; retval: PSize; window: QWindowH; size: PSize; mode: QIconMode = QIconNormal; state: QIconState = QIconOff); cdecl; external Qt5PasLib name 'QIcon_actualSize2';
procedure QIcon_name(handle: QIconH; retval: PWideString); cdecl; external Qt5PasLib name 'QIcon_name';
procedure QIcon_paint(handle: QIconH; painter: QPainterH; rect: PRect; alignment: QtAlignment = QtAlignCenter; mode: QIconMode = QIconNormal; state: QIconState = QIconOff); cdecl; external Qt5PasLib name 'QIcon_paint';
procedure QIcon_paint(handle: QIconH; painter: QPainterH; x: Integer; y: Integer; w: Integer; h: Integer; alignment: QtAlignment = QtAlignCenter; mode: QIconMode = QIconNormal; state: QIconState = QIconOff); cdecl; external Qt5PasLib name 'QIcon_paint2';
function QIcon_isNull(handle: QIconH): Boolean; cdecl; external Qt5PasLib name 'QIcon_isNull';
function QIcon_isDetached(handle: QIconH): Boolean; cdecl; external Qt5PasLib name 'QIcon_isDetached';
procedure QIcon_detach(handle: QIconH); cdecl; external Qt5PasLib name 'QIcon_detach';
function QIcon_cacheKey(handle: QIconH): int64; cdecl; external Qt5PasLib name 'QIcon_cacheKey';
procedure QIcon_addPixmap(handle: QIconH; pixmap: QPixmapH; mode: QIconMode = QIconNormal; state: QIconState = QIconOff); cdecl; external Qt5PasLib name 'QIcon_addPixmap';
procedure QIcon_addFile(handle: QIconH; fileName: PWideString; size: PSize = nil; mode: QIconMode = QIconNormal; state: QIconState = QIconOff); cdecl; external Qt5PasLib name 'QIcon_addFile';
procedure QIcon_fromTheme(retval: QIconH; name: PWideString; fallback: QIconH = nil); cdecl; external Qt5PasLib name 'QIcon_fromTheme';
function QIcon_hasThemeIcon(name: PWideString): Boolean; cdecl; external Qt5PasLib name 'QIcon_hasThemeIcon';
procedure QIcon_themeSearchPaths(retval: QStringListH); cdecl; external Qt5PasLib name 'QIcon_themeSearchPaths';
procedure QIcon_setThemeSearchPaths(searchpath: QStringListH); cdecl; external Qt5PasLib name 'QIcon_setThemeSearchPaths';
procedure QIcon_themeName(retval: PWideString); cdecl; external Qt5PasLib name 'QIcon_themeName';
procedure QIcon_setThemeName(path: PWideString); cdecl; external Qt5PasLib name 'QIcon_setThemeName';

procedure QPixmapCache_Clear(); cdecl; external Qt5PasLib name 'QPixmapCache_Clear';

function QPixmap_Create(): QPixmapH; cdecl; external Qt5PasLib name 'QPixmap_Create';
procedure QPixmap_Destroy(handle: QPixmapH); cdecl; external Qt5PasLib name 'QPixmap_Destroy'; 
function QPixmap_Create(w: Integer; h: Integer): QPixmapH; cdecl; external Qt5PasLib name 'QPixmap_Create2';
function QPixmap_Create(AnonParam1: PSize): QPixmapH; cdecl; external Qt5PasLib name 'QPixmap_Create3';
function QPixmap_Create(fileName: PWideString; format: PAnsiChar = nil; flags: QtImageConversionFlags = QtAutoColor): QPixmapH; cdecl; external Qt5PasLib name 'QPixmap_Create4';
function QPixmap_Create(xpm: PAnsiChar): QPixmapH; cdecl; external Qt5PasLib name 'QPixmap_Create5';
function QPixmap_Create(AnonParam1: QPixmapH): QPixmapH; cdecl; external Qt5PasLib name 'QPixmap_Create6';
procedure QPixmap_swap(handle: QPixmapH; other: QPixmapH); cdecl; external Qt5PasLib name 'QPixmap_swap';
function QPixmap_isNull(handle: QPixmapH): Boolean; cdecl; external Qt5PasLib name 'QPixmap_isNull';
function QPixmap_devType(handle: QPixmapH): Integer; cdecl; external Qt5PasLib name 'QPixmap_devType';
function QPixmap_width(handle: QPixmapH): Integer; cdecl; external Qt5PasLib name 'QPixmap_width';
function QPixmap_height(handle: QPixmapH): Integer; cdecl; external Qt5PasLib name 'QPixmap_height';
procedure QPixmap_size(handle: QPixmapH; retval: PSize); cdecl; external Qt5PasLib name 'QPixmap_size';
procedure QPixmap_rect(handle: QPixmapH; retval: PRect); cdecl; external Qt5PasLib name 'QPixmap_rect';
function QPixmap_depth(handle: QPixmapH): Integer; cdecl; external Qt5PasLib name 'QPixmap_depth';
function QPixmap_defaultDepth(): Integer; cdecl; external Qt5PasLib name 'QPixmap_defaultDepth';
procedure QPixmap_fill(handle: QPixmapH; fillColor: PQColor); cdecl; external Qt5PasLib name 'QPixmap_fill';
procedure QPixmap_fill(handle: QPixmapH; device: QPaintDeviceH; ofs: PQtPoint); cdecl; external Qt5PasLib name 'QPixmap_fill2';
procedure QPixmap_fill(handle: QPixmapH; device: QPaintDeviceH; xofs: Integer; yofs: Integer); cdecl; external Qt5PasLib name 'QPixmap_fill3';
procedure QPixmap_mask(handle: QPixmapH; retval: QBitmapH); cdecl; external Qt5PasLib name 'QPixmap_mask';
procedure QPixmap_setMask(handle: QPixmapH; AnonParam1: QBitmapH); cdecl; external Qt5PasLib name 'QPixmap_setMask';
function QPixmap_devicePixelRatio(handle: QPixmapH): qreal; cdecl; external Qt5PasLib name 'QPixmap_devicePixelRatio';
procedure QPixmap_setDevicePixelRatio(handle: QPixmapH; scaleFactor: qreal); cdecl; external Qt5PasLib name 'QPixmap_setDevicePixelRatio';
function QPixmap_hasAlpha(handle: QPixmapH): Boolean; cdecl; external Qt5PasLib name 'QPixmap_hasAlpha';
function QPixmap_hasAlphaChannel(handle: QPixmapH): Boolean; cdecl; external Qt5PasLib name 'QPixmap_hasAlphaChannel';
procedure QPixmap_createHeuristicMask(handle: QPixmapH; retval: QBitmapH; clipTight: Boolean = True); cdecl; external Qt5PasLib name 'QPixmap_createHeuristicMask';
procedure QPixmap_createMaskFromColor(handle: QPixmapH; retval: QBitmapH; maskColor: PQColor; mode: QtMaskMode = QtMaskInColor); cdecl; external Qt5PasLib name 'QPixmap_createMaskFromColor';
procedure QPixmap_grabWindow(retval: QPixmapH; AnonParam1: PtrUInt; x: Integer = 0; y: Integer = 0; w: Integer = -1; h: Integer = -1); cdecl; external Qt5PasLib name 'QPixmap_grabWindow';
procedure QPixmap_grabWidget(retval: QPixmapH; widget: QObjectH; rect: PRect); cdecl; external Qt5PasLib name 'QPixmap_grabWidget';
procedure QPixmap_grabWidget(retval: QPixmapH; widget: QObjectH; x: Integer = 0; y: Integer = 0; w: Integer = -1; h: Integer = -1); cdecl; external Qt5PasLib name 'QPixmap_grabWidget2';
procedure QPixmap_scaled(handle: QPixmapH; retval: QPixmapH; w: Integer; h: Integer; aspectMode: QtAspectRatioMode = QtIgnoreAspectRatio; mode: QtTransformationMode = QtFastTransformation); cdecl; external Qt5PasLib name 'QPixmap_scaled';
procedure QPixmap_scaled(handle: QPixmapH; retval: QPixmapH; s: PSize; aspectMode: QtAspectRatioMode = QtIgnoreAspectRatio; mode: QtTransformationMode = QtFastTransformation); cdecl; external Qt5PasLib name 'QPixmap_scaled2';
procedure QPixmap_scaledToWidth(handle: QPixmapH; retval: QPixmapH; w: Integer; mode: QtTransformationMode = QtFastTransformation); cdecl; external Qt5PasLib name 'QPixmap_scaledToWidth';
procedure QPixmap_scaledToHeight(handle: QPixmapH; retval: QPixmapH; h: Integer; mode: QtTransformationMode = QtFastTransformation); cdecl; external Qt5PasLib name 'QPixmap_scaledToHeight';
procedure QPixmap_transformed(handle: QPixmapH; retval: QPixmapH; AnonParam1: QMatrixH; mode: QtTransformationMode = QtFastTransformation); cdecl; external Qt5PasLib name 'QPixmap_transformed';
procedure QPixmap_trueMatrix(retval: QMatrixH; m: QMatrixH; w: Integer; h: Integer); cdecl; external Qt5PasLib name 'QPixmap_trueMatrix';
procedure QPixmap_transformed(handle: QPixmapH; retval: QPixmapH; AnonParam1: QTransformH; mode: QtTransformationMode = QtFastTransformation); cdecl; external Qt5PasLib name 'QPixmap_transformed2';
procedure QPixmap_trueMatrix(retval: QTransformH; m: QTransformH; w: Integer; h: Integer); cdecl; external Qt5PasLib name 'QPixmap_trueMatrix2';
procedure QPixmap_toImage(handle: QPixmapH; retval: QImageH); cdecl; external Qt5PasLib name 'QPixmap_toImage';
procedure QPixmap_fromImage(retval: QPixmapH; image: QImageH; flags: QtImageConversionFlags = QtAutoColor); cdecl; external Qt5PasLib name 'QPixmap_fromImage';
procedure QPixmap_fromImageReader(retval: QPixmapH; imageReader: QImageReaderH; flags: QtImageConversionFlags = QtAutoColor); cdecl; external Qt5PasLib name 'QPixmap_fromImageReader';
function QPixmap_load(handle: QPixmapH; fileName: PWideString; format: PAnsiChar = nil; flags: QtImageConversionFlags = QtAutoColor): Boolean; cdecl; external Qt5PasLib name 'QPixmap_load';
function QPixmap_loadFromData(handle: QPixmapH; buf: PByte; len: LongWord; format: PAnsiChar = nil; flags: QtImageConversionFlags = QtAutoColor): Boolean; cdecl; external Qt5PasLib name 'QPixmap_loadFromData';
function QPixmap_loadFromData(handle: QPixmapH; data: QByteArrayH; format: PAnsiChar = nil; flags: QtImageConversionFlags = QtAutoColor): Boolean; cdecl; external Qt5PasLib name 'QPixmap_loadFromData2';
function QPixmap_save(handle: QPixmapH; fileName: PWideString; format: PAnsiChar = nil; quality: Integer = -1): Boolean; cdecl; external Qt5PasLib name 'QPixmap_save';
function QPixmap_save(handle: QPixmapH; device: QIODeviceH; format: PAnsiChar = nil; quality: Integer = -1): Boolean; cdecl; external Qt5PasLib name 'QPixmap_save2';
function QPixmap_convertFromImage(handle: QPixmapH; img: QImageH; flags: QtImageConversionFlags = QtAutoColor): Boolean; cdecl; external Qt5PasLib name 'QPixmap_convertFromImage';
procedure QPixmap_copy(handle: QPixmapH; retval: QPixmapH; x: Integer; y: Integer; width: Integer; height: Integer); cdecl; external Qt5PasLib name 'QPixmap_copy';
procedure QPixmap_copy(handle: QPixmapH; retval: QPixmapH; rect: PRect = nil); cdecl; external Qt5PasLib name 'QPixmap_copy2';
procedure QPixmap_scroll(handle: QPixmapH; dx: Integer; dy: Integer; x: Integer; y: Integer; width: Integer; height: Integer; exposed: QRegionH = nil); cdecl; external Qt5PasLib name 'QPixmap_scroll';
procedure QPixmap_scroll(handle: QPixmapH; dx: Integer; dy: Integer; rect: PRect; exposed: QRegionH = nil); cdecl; external Qt5PasLib name 'QPixmap_scroll2';
function QPixmap_cacheKey(handle: QPixmapH): int64; cdecl; external Qt5PasLib name 'QPixmap_cacheKey';
function QPixmap_isDetached(handle: QPixmapH): Boolean; cdecl; external Qt5PasLib name 'QPixmap_isDetached';
procedure QPixmap_detach(handle: QPixmapH); cdecl; external Qt5PasLib name 'QPixmap_detach';
function QPixmap_isQBitmap(handle: QPixmapH): Boolean; cdecl; external Qt5PasLib name 'QPixmap_isQBitmap';
function QPixmap_paintEngine(handle: QPixmapH): QPaintEngineH; cdecl; external Qt5PasLib name 'QPixmap_paintEngine';


type
  QImageInvertMode = ( // QImage::InvertMode (1)
    QImageInvertRgb, QImageInvertRgba );

  QImageFormat = ( // QImage::Format (1)
    QImageFormat_Invalid, QImageFormat_Mono, QImageFormat_MonoLSB, QImageFormat_Indexed8, QImageFormat_RGB32, QImageFormat_ARGB32, QImageFormat_ARGB32_Premultiplied, QImageFormat_RGB16, 
    QImageFormat_ARGB8565_Premultiplied, QImageFormat_RGB666, QImageFormat_ARGB6666_Premultiplied, QImageFormat_RGB555, QImageFormat_ARGB8555_Premultiplied, QImageFormat_RGB888, QImageFormat_RGB444, 
    QImageFormat_ARGB4444_Premultiplied, QImageNImageFormats );

function QImage_Create(): QImageH; cdecl; external Qt5PasLib name 'QImage_Create';
procedure QImage_Destroy(handle: QImageH); cdecl; external Qt5PasLib name 'QImage_Destroy'; 
function QImage_Create(size: PSize; format: QImageFormat): QImageH; cdecl; external Qt5PasLib name 'QImage_Create2';
function QImage_Create(width: Integer; height: Integer; format: QImageFormat): QImageH; cdecl; external Qt5PasLib name 'QImage_Create3';
function QImage_Create(data: PByte; width: Integer; height: Integer; format: QImageFormat; cleanupFunction: TQImageCleanupFunction = nil; cleanupInfo: Pointer = nil): QImageH; cdecl; external Qt5PasLib name 'QImage_Create4';
function QImage_Create(data: PByte; width: Integer; height: Integer; bytesPerLine: Integer; format: QImageFormat; cleanupFunction: TQImageCleanupFunction = nil; cleanupInfo: Pointer = nil): QImageH; cdecl; external Qt5PasLib name 'QImage_Create6';
function QImage_Create(xpm: PAnsiChar): QImageH; cdecl; external Qt5PasLib name 'QImage_Create8';
function QImage_Create(fileName: PWideString; format: PAnsiChar = nil): QImageH; cdecl; external Qt5PasLib name 'QImage_Create9';
function QImage_Create(AnonParam1: QImageH): QImageH; cdecl; external Qt5PasLib name 'QImage_Create10';
procedure QImage_swap(handle: QImageH; other: QImageH); cdecl; external Qt5PasLib name 'QImage_swap';
function QImage_isNull(handle: QImageH): Boolean; cdecl; external Qt5PasLib name 'QImage_isNull';
function QImage_devType(handle: QImageH): Integer; cdecl; external Qt5PasLib name 'QImage_devType';
procedure QImage_detach(handle: QImageH); cdecl; external Qt5PasLib name 'QImage_detach';
function QImage_isDetached(handle: QImageH): Boolean; cdecl; external Qt5PasLib name 'QImage_isDetached';
procedure QImage_copy(handle: QImageH; retval: QImageH; rect: PRect = nil); cdecl; external Qt5PasLib name 'QImage_copy';
procedure QImage_copy(handle: QImageH; retval: QImageH; x: Integer; y: Integer; w: Integer; h: Integer); cdecl; external Qt5PasLib name 'QImage_copy2';
function QImage_format(handle: QImageH): QImageFormat; cdecl; external Qt5PasLib name 'QImage_format';
procedure QImage_convertToFormat(handle: QImageH; retval: QImageH; f: QImageFormat; flags: QtImageConversionFlags = QtAutoColor); cdecl; external Qt5PasLib name 'QImage_convertToFormat';
function QImage_width(handle: QImageH): Integer; cdecl; external Qt5PasLib name 'QImage_width';
function QImage_height(handle: QImageH): Integer; cdecl; external Qt5PasLib name 'QImage_height';
procedure QImage_size(handle: QImageH; retval: PSize); cdecl; external Qt5PasLib name 'QImage_size';
procedure QImage_rect(handle: QImageH; retval: PRect); cdecl; external Qt5PasLib name 'QImage_rect';
function QImage_depth(handle: QImageH): Integer; cdecl; external Qt5PasLib name 'QImage_depth';
function QImage_colorCount(handle: QImageH): Integer; cdecl; external Qt5PasLib name 'QImage_colorCount';
function QImage_bitPlaneCount(handle: QImageH): Integer; cdecl; external Qt5PasLib name 'QImage_bitPlaneCount';
function QImage_color(handle: QImageH; i: Integer): QRgb; cdecl; external Qt5PasLib name 'QImage_color';
procedure QImage_setColor(handle: QImageH; i: Integer; c: QRgb); cdecl; external Qt5PasLib name 'QImage_setColor';
procedure QImage_setColorCount(handle: QImageH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QImage_setColorCount';
function QImage_allGray(handle: QImageH): Boolean; cdecl; external Qt5PasLib name 'QImage_allGray';
function QImage_isGrayscale(handle: QImageH): Boolean; cdecl; external Qt5PasLib name 'QImage_isGrayscale';
function QImage_bits(handle: QImageH): PByte; cdecl; external Qt5PasLib name 'QImage_bits';
function QImage_constBits(handle: QImageH): PByte; cdecl; external Qt5PasLib name 'QImage_constBits';
function QImage_byteCount(handle: QImageH): Integer; cdecl; external Qt5PasLib name 'QImage_byteCount';
function QImage_scanLine(handle: QImageH; AnonParam1: Integer): PByte; cdecl; external Qt5PasLib name 'QImage_scanLine';
function QImage_constScanLine(handle: QImageH; AnonParam1: Integer): PByte; cdecl; external Qt5PasLib name 'QImage_constScanLine';
function QImage_bytesPerLine(handle: QImageH): Integer; cdecl; external Qt5PasLib name 'QImage_bytesPerLine';
function QImage_valid(handle: QImageH; x: Integer; y: Integer): Boolean; cdecl; external Qt5PasLib name 'QImage_valid';
function QImage_valid(handle: QImageH; pt: PQtPoint): Boolean; cdecl; external Qt5PasLib name 'QImage_valid2';
function QImage_pixelIndex(handle: QImageH; x: Integer; y: Integer): Integer; cdecl; external Qt5PasLib name 'QImage_pixelIndex';
function QImage_pixelIndex(handle: QImageH; pt: PQtPoint): Integer; cdecl; external Qt5PasLib name 'QImage_pixelIndex2';
function QImage_pixel(handle: QImageH; x: Integer; y: Integer): QRgb; cdecl; external Qt5PasLib name 'QImage_pixel';
function QImage_pixel(handle: QImageH; pt: PQtPoint): QRgb; cdecl; external Qt5PasLib name 'QImage_pixel2';
procedure QImage_setPixel(handle: QImageH; x: Integer; y: Integer; index_or_rgb: LongWord); cdecl; external Qt5PasLib name 'QImage_setPixel';
procedure QImage_setPixel(handle: QImageH; pt: PQtPoint; index_or_rgb: LongWord); cdecl; external Qt5PasLib name 'QImage_setPixel2';
function QImage_devicePixelRatio(handle: QImageH): qreal; cdecl; external Qt5PasLib name 'QImage_devicePixelRatio';
procedure QImage_setDevicePixelRatio(handle: QImageH; scaleFactor: qreal); cdecl; external Qt5PasLib name 'QImage_setDevicePixelRatio';
procedure QImage_fill(handle: QImageH; pixel: LongWord); cdecl; external Qt5PasLib name 'QImage_fill';
procedure QImage_fill(handle: QImageH; color: PQColor); cdecl; external Qt5PasLib name 'QImage_fill2';
procedure QImage_fill(handle: QImageH; color: QtGlobalColor); cdecl; external Qt5PasLib name 'QImage_fill3';
function QImage_hasAlphaChannel(handle: QImageH): Boolean; cdecl; external Qt5PasLib name 'QImage_hasAlphaChannel';
procedure QImage_setAlphaChannel(handle: QImageH; alphaChannel: QImageH); cdecl; external Qt5PasLib name 'QImage_setAlphaChannel';
procedure QImage_alphaChannel(handle: QImageH; retval: QImageH); cdecl; external Qt5PasLib name 'QImage_alphaChannel';
procedure QImage_createAlphaMask(handle: QImageH; retval: QImageH; flags: QtImageConversionFlags = QtAutoColor); cdecl; external Qt5PasLib name 'QImage_createAlphaMask';
procedure QImage_createHeuristicMask(handle: QImageH; retval: QImageH; clipTight: Boolean = True); cdecl; external Qt5PasLib name 'QImage_createHeuristicMask';
procedure QImage_createMaskFromColor(handle: QImageH; retval: QImageH; color: QRgb; mode: QtMaskMode = QtMaskInColor); cdecl; external Qt5PasLib name 'QImage_createMaskFromColor';
procedure QImage_scaled(handle: QImageH; retval: QImageH; w: Integer; h: Integer; aspectMode: QtAspectRatioMode = QtIgnoreAspectRatio; mode: QtTransformationMode = QtFastTransformation); cdecl; external Qt5PasLib name 'QImage_scaled';
procedure QImage_scaled(handle: QImageH; retval: QImageH; s: PSize; aspectMode: QtAspectRatioMode = QtIgnoreAspectRatio; mode: QtTransformationMode = QtFastTransformation); cdecl; external Qt5PasLib name 'QImage_scaled2';
procedure QImage_scaledToWidth(handle: QImageH; retval: QImageH; w: Integer; mode: QtTransformationMode = QtFastTransformation); cdecl; external Qt5PasLib name 'QImage_scaledToWidth';
procedure QImage_scaledToHeight(handle: QImageH; retval: QImageH; h: Integer; mode: QtTransformationMode = QtFastTransformation); cdecl; external Qt5PasLib name 'QImage_scaledToHeight';
procedure QImage_transformed(handle: QImageH; retval: QImageH; matrix: QMatrixH; mode: QtTransformationMode = QtFastTransformation); cdecl; external Qt5PasLib name 'QImage_transformed';
procedure QImage_trueMatrix(retval: QMatrixH; AnonParam1: QMatrixH; w: Integer; h: Integer); cdecl; external Qt5PasLib name 'QImage_trueMatrix';
procedure QImage_transformed(handle: QImageH; retval: QImageH; matrix: QTransformH; mode: QtTransformationMode = QtFastTransformation); cdecl; external Qt5PasLib name 'QImage_transformed2';
procedure QImage_trueMatrix(retval: QTransformH; AnonParam1: QTransformH; w: Integer; h: Integer); cdecl; external Qt5PasLib name 'QImage_trueMatrix2';
procedure QImage_mirrored(handle: QImageH; retval: QImageH; horizontally: Boolean = False; vertically: Boolean = True); cdecl; external Qt5PasLib name 'QImage_mirrored';
procedure QImage_rgbSwapped(handle: QImageH; retval: QImageH); cdecl; external Qt5PasLib name 'QImage_rgbSwapped';
procedure QImage_invertPixels(handle: QImageH; AnonParam1: QImageInvertMode = QImageInvertRgb); cdecl; external Qt5PasLib name 'QImage_invertPixels';
function QImage_load(handle: QImageH; device: QIODeviceH; format: PAnsiChar): Boolean; cdecl; external Qt5PasLib name 'QImage_load';
function QImage_load(handle: QImageH; fileName: PWideString; format: PAnsiChar = nil): Boolean; cdecl; external Qt5PasLib name 'QImage_load2';
function QImage_loadFromData(handle: QImageH; buf: PByte; len: Integer; format: PAnsiChar = nil): Boolean; cdecl; external Qt5PasLib name 'QImage_loadFromData';
function QImage_loadFromData(handle: QImageH; data: QByteArrayH; aformat: PAnsiChar = nil): Boolean; cdecl; external Qt5PasLib name 'QImage_loadFromData2';
function QImage_save(handle: QImageH; fileName: PWideString; format: PAnsiChar = nil; quality: Integer = -1): Boolean; cdecl; external Qt5PasLib name 'QImage_save';
function QImage_save(handle: QImageH; device: QIODeviceH; format: PAnsiChar = nil; quality: Integer = -1): Boolean; cdecl; external Qt5PasLib name 'QImage_save2';
procedure QImage_fromData(retval: QImageH; data: PByte; size: Integer; format: PAnsiChar = nil); cdecl; external Qt5PasLib name 'QImage_fromData';
procedure QImage_fromData(retval: QImageH; data: QByteArrayH; format: PAnsiChar = nil); cdecl; external Qt5PasLib name 'QImage_fromData2';
function QImage_cacheKey(handle: QImageH): int64; cdecl; external Qt5PasLib name 'QImage_cacheKey';
function QImage_paintEngine(handle: QImageH): QPaintEngineH; cdecl; external Qt5PasLib name 'QImage_paintEngine';
function QImage_dotsPerMeterX(handle: QImageH): Integer; cdecl; external Qt5PasLib name 'QImage_dotsPerMeterX';
function QImage_dotsPerMeterY(handle: QImageH): Integer; cdecl; external Qt5PasLib name 'QImage_dotsPerMeterY';
procedure QImage_setDotsPerMeterX(handle: QImageH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QImage_setDotsPerMeterX';
procedure QImage_setDotsPerMeterY(handle: QImageH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QImage_setDotsPerMeterY';
procedure QImage_offset(handle: QImageH; retval: PQtPoint); cdecl; external Qt5PasLib name 'QImage_offset';
procedure QImage_setOffset(handle: QImageH; AnonParam1: PQtPoint); cdecl; external Qt5PasLib name 'QImage_setOffset';
procedure QImage_textKeys(handle: QImageH; retval: QStringListH); cdecl; external Qt5PasLib name 'QImage_textKeys';
procedure QImage_text(handle: QImageH; retval: PWideString; key: PWideString = nil); cdecl; external Qt5PasLib name 'QImage_text';
procedure QImage_setText(handle: QImageH; key: PWideString; value: PWideString); cdecl; external Qt5PasLib name 'QImage_setText';

function QBitmap_Create(): QBitmapH; cdecl; external Qt5PasLib name 'QBitmap_Create';
procedure QBitmap_Destroy(handle: QBitmapH); cdecl; external Qt5PasLib name 'QBitmap_Destroy'; 
function QBitmap_Create(AnonParam1: QPixmapH): QBitmapH; cdecl; external Qt5PasLib name 'QBitmap_Create2';
function QBitmap_Create(w: Integer; h: Integer): QBitmapH; cdecl; external Qt5PasLib name 'QBitmap_Create3';
function QBitmap_Create(AnonParam1: PSize): QBitmapH; cdecl; external Qt5PasLib name 'QBitmap_Create4';
function QBitmap_Create(fileName: PWideString; format: PAnsiChar = nil): QBitmapH; cdecl; external Qt5PasLib name 'QBitmap_Create5';
procedure QBitmap_swap(handle: QBitmapH; other: QBitmapH); cdecl; external Qt5PasLib name 'QBitmap_swap';
procedure QBitmap_clear(handle: QBitmapH); cdecl; external Qt5PasLib name 'QBitmap_clear';
procedure QBitmap_fromImage(retval: QBitmapH; image: QImageH; flags: QtImageConversionFlags = QtAutoColor); cdecl; external Qt5PasLib name 'QBitmap_fromImage';
procedure QBitmap_fromData(retval: QBitmapH; size: PSize; bits: PByte; monoFormat: QImageFormat = QImageFormat_MonoLSB); cdecl; external Qt5PasLib name 'QBitmap_fromData';
procedure QBitmap_transformed(handle: QBitmapH; retval: QBitmapH; AnonParam1: QMatrixH); cdecl; external Qt5PasLib name 'QBitmap_transformed';
procedure QBitmap_transformed(handle: QBitmapH; retval: QBitmapH; matrix: QTransformH); cdecl; external Qt5PasLib name 'QBitmap_transformed2';

function QPicture_Create(formatVersion: Integer = -1): QPictureH; cdecl; external Qt5PasLib name 'QPicture_Create';
procedure QPicture_Destroy(handle: QPictureH); cdecl; external Qt5PasLib name 'QPicture_Destroy'; 
function QPicture_Create(AnonParam1: QPictureH): QPictureH; cdecl; external Qt5PasLib name 'QPicture_Create2';
function QPicture_isNull(handle: QPictureH): Boolean; cdecl; external Qt5PasLib name 'QPicture_isNull';
function QPicture_devType(handle: QPictureH): Integer; cdecl; external Qt5PasLib name 'QPicture_devType';
function QPicture_size(handle: QPictureH): LongWord; cdecl; external Qt5PasLib name 'QPicture_size';
function QPicture_data(handle: QPictureH): PAnsiChar; cdecl; external Qt5PasLib name 'QPicture_data';
procedure QPicture_setData(handle: QPictureH; data: PAnsiChar; size: LongWord); cdecl; external Qt5PasLib name 'QPicture_setData';
function QPicture_play(handle: QPictureH; p: QPainterH): Boolean; cdecl; external Qt5PasLib name 'QPicture_play';
function QPicture_load(handle: QPictureH; dev: QIODeviceH; format: PAnsiChar = nil): Boolean; cdecl; external Qt5PasLib name 'QPicture_load';
function QPicture_load(handle: QPictureH; fileName: PWideString; format: PAnsiChar = nil): Boolean; cdecl; external Qt5PasLib name 'QPicture_load2';
function QPicture_save(handle: QPictureH; dev: QIODeviceH; format: PAnsiChar = nil): Boolean; cdecl; external Qt5PasLib name 'QPicture_save';
function QPicture_save(handle: QPictureH; fileName: PWideString; format: PAnsiChar = nil): Boolean; cdecl; external Qt5PasLib name 'QPicture_save2';
procedure QPicture_boundingRect(handle: QPictureH; retval: PRect); cdecl; external Qt5PasLib name 'QPicture_boundingRect';
procedure QPicture_setBoundingRect(handle: QPictureH; r: PRect); cdecl; external Qt5PasLib name 'QPicture_setBoundingRect';
procedure QPicture_swap(handle: QPictureH; other: QPictureH); cdecl; external Qt5PasLib name 'QPicture_swap';
procedure QPicture_detach(handle: QPictureH); cdecl; external Qt5PasLib name 'QPicture_detach';
function QPicture_isDetached(handle: QPictureH): Boolean; cdecl; external Qt5PasLib name 'QPicture_isDetached';
function QPicture_pictureFormat(fileName: PWideString): PAnsiChar; cdecl; external Qt5PasLib name 'QPicture_pictureFormat';
procedure QPicture_inputFormatList(retval: QStringListH); cdecl; external Qt5PasLib name 'QPicture_inputFormatList';
procedure QPicture_outputFormatList(retval: QStringListH); cdecl; external Qt5PasLib name 'QPicture_outputFormatList';
function QPicture_paintEngine(handle: QPictureH): QPaintEngineH; cdecl; external Qt5PasLib name 'QPicture_paintEngine';


type
  QImageIOHandlerImageOption = ( // QImageIOHandler::ImageOption (1)
    QImageIOHandlerSize, QImageIOHandlerClipRect, QImageIOHandlerDescription, QImageIOHandlerScaledClipRect, QImageIOHandlerScaledSize, QImageIOHandlerCompressionRatio, QImageIOHandlerGamma, 
    QImageIOHandlerQuality, QImageIOHandlerName, QImageIOHandlerSubType, QImageIOHandlerIncrementalReading, QImageIOHandlerEndianness, QImageIOHandlerAnimation, QImageIOHandlerBackgroundColor, 
    QImageIOHandlerImageFormat );

procedure QImageIOHandler_setDevice(handle: QImageIOHandlerH; device: QIODeviceH); cdecl; external Qt5PasLib name 'QImageIOHandler_setDevice';
function QImageIOHandler_device(handle: QImageIOHandlerH): QIODeviceH; cdecl; external Qt5PasLib name 'QImageIOHandler_device';
procedure QImageIOHandler_setFormat(handle: QImageIOHandlerH; format: QByteArrayH); cdecl; external Qt5PasLib name 'QImageIOHandler_setFormat';
procedure QImageIOHandler_format(handle: QImageIOHandlerH; retval: QByteArrayH); cdecl; external Qt5PasLib name 'QImageIOHandler_format';
procedure QImageIOHandler_name(handle: QImageIOHandlerH; retval: QByteArrayH); cdecl; external Qt5PasLib name 'QImageIOHandler_name';
function QImageIOHandler_canRead(handle: QImageIOHandlerH): Boolean; cdecl; external Qt5PasLib name 'QImageIOHandler_canRead';
function QImageIOHandler_read(handle: QImageIOHandlerH; image: QImageH): Boolean; cdecl; external Qt5PasLib name 'QImageIOHandler_read';
function QImageIOHandler_write(handle: QImageIOHandlerH; image: QImageH): Boolean; cdecl; external Qt5PasLib name 'QImageIOHandler_write';
procedure QImageIOHandler_option(handle: QImageIOHandlerH; retval: QVariantH; option: QImageIOHandlerImageOption); cdecl; external Qt5PasLib name 'QImageIOHandler_option';
procedure QImageIOHandler_setOption(handle: QImageIOHandlerH; option: QImageIOHandlerImageOption; value: QVariantH); cdecl; external Qt5PasLib name 'QImageIOHandler_setOption';
function QImageIOHandler_supportsOption(handle: QImageIOHandlerH; option: QImageIOHandlerImageOption): Boolean; cdecl; external Qt5PasLib name 'QImageIOHandler_supportsOption';
function QImageIOHandler_jumpToNextImage(handle: QImageIOHandlerH): Boolean; cdecl; external Qt5PasLib name 'QImageIOHandler_jumpToNextImage';
function QImageIOHandler_jumpToImage(handle: QImageIOHandlerH; imageNumber: Integer): Boolean; cdecl; external Qt5PasLib name 'QImageIOHandler_jumpToImage';
function QImageIOHandler_loopCount(handle: QImageIOHandlerH): Integer; cdecl; external Qt5PasLib name 'QImageIOHandler_loopCount';
function QImageIOHandler_imageCount(handle: QImageIOHandlerH): Integer; cdecl; external Qt5PasLib name 'QImageIOHandler_imageCount';
function QImageIOHandler_nextImageDelay(handle: QImageIOHandlerH): Integer; cdecl; external Qt5PasLib name 'QImageIOHandler_nextImageDelay';
function QImageIOHandler_currentImageNumber(handle: QImageIOHandlerH): Integer; cdecl; external Qt5PasLib name 'QImageIOHandler_currentImageNumber';
procedure QImageIOHandler_currentImageRect(handle: QImageIOHandlerH; retval: PRect); cdecl; external Qt5PasLib name 'QImageIOHandler_currentImageRect';


type
  QImageReaderImageReaderError = ( // QImageReader::ImageReaderError (1)
    QImageReaderUnknownError, QImageReaderFileNotFoundError, QImageReaderDeviceError, QImageReaderUnsupportedFormatError, QImageReaderInvalidDataError );

function QImageReader_Create(): QImageReaderH; cdecl; external Qt5PasLib name 'QImageReader_Create';
procedure QImageReader_Destroy(handle: QImageReaderH); cdecl; external Qt5PasLib name 'QImageReader_Destroy'; 
function QImageReader_Create(device: QIODeviceH; format: QByteArrayH = nil): QImageReaderH; cdecl; external Qt5PasLib name 'QImageReader_Create2';
function QImageReader_Create(fileName: PWideString; format: QByteArrayH = nil): QImageReaderH; cdecl; external Qt5PasLib name 'QImageReader_Create3';
procedure QImageReader_setFormat(handle: QImageReaderH; format: QByteArrayH); cdecl; external Qt5PasLib name 'QImageReader_setFormat';
procedure QImageReader_format(handle: QImageReaderH; retval: QByteArrayH); cdecl; external Qt5PasLib name 'QImageReader_format';
procedure QImageReader_setAutoDetectImageFormat(handle: QImageReaderH; enabled: Boolean); cdecl; external Qt5PasLib name 'QImageReader_setAutoDetectImageFormat';
function QImageReader_autoDetectImageFormat(handle: QImageReaderH): Boolean; cdecl; external Qt5PasLib name 'QImageReader_autoDetectImageFormat';
procedure QImageReader_setDecideFormatFromContent(handle: QImageReaderH; ignored: Boolean); cdecl; external Qt5PasLib name 'QImageReader_setDecideFormatFromContent';
function QImageReader_decideFormatFromContent(handle: QImageReaderH): Boolean; cdecl; external Qt5PasLib name 'QImageReader_decideFormatFromContent';
procedure QImageReader_setDevice(handle: QImageReaderH; device: QIODeviceH); cdecl; external Qt5PasLib name 'QImageReader_setDevice';
function QImageReader_device(handle: QImageReaderH): QIODeviceH; cdecl; external Qt5PasLib name 'QImageReader_device';
procedure QImageReader_setFileName(handle: QImageReaderH; fileName: PWideString); cdecl; external Qt5PasLib name 'QImageReader_setFileName';
procedure QImageReader_fileName(handle: QImageReaderH; retval: PWideString); cdecl; external Qt5PasLib name 'QImageReader_fileName';
procedure QImageReader_size(handle: QImageReaderH; retval: PSize); cdecl; external Qt5PasLib name 'QImageReader_size';
function QImageReader_imageFormat(handle: QImageReaderH): QImageFormat; cdecl; external Qt5PasLib name 'QImageReader_imageFormat';
procedure QImageReader_textKeys(handle: QImageReaderH; retval: QStringListH); cdecl; external Qt5PasLib name 'QImageReader_textKeys';
procedure QImageReader_text(handle: QImageReaderH; retval: PWideString; key: PWideString); cdecl; external Qt5PasLib name 'QImageReader_text';
procedure QImageReader_setClipRect(handle: QImageReaderH; rect: PRect); cdecl; external Qt5PasLib name 'QImageReader_setClipRect';
procedure QImageReader_clipRect(handle: QImageReaderH; retval: PRect); cdecl; external Qt5PasLib name 'QImageReader_clipRect';
procedure QImageReader_setScaledSize(handle: QImageReaderH; size: PSize); cdecl; external Qt5PasLib name 'QImageReader_setScaledSize';
procedure QImageReader_scaledSize(handle: QImageReaderH; retval: PSize); cdecl; external Qt5PasLib name 'QImageReader_scaledSize';
procedure QImageReader_setQuality(handle: QImageReaderH; quality: Integer); cdecl; external Qt5PasLib name 'QImageReader_setQuality';
function QImageReader_quality(handle: QImageReaderH): Integer; cdecl; external Qt5PasLib name 'QImageReader_quality';
procedure QImageReader_setScaledClipRect(handle: QImageReaderH; rect: PRect); cdecl; external Qt5PasLib name 'QImageReader_setScaledClipRect';
procedure QImageReader_scaledClipRect(handle: QImageReaderH; retval: PRect); cdecl; external Qt5PasLib name 'QImageReader_scaledClipRect';
procedure QImageReader_setBackgroundColor(handle: QImageReaderH; color: PQColor); cdecl; external Qt5PasLib name 'QImageReader_setBackgroundColor';
procedure QImageReader_backgroundColor(handle: QImageReaderH; retval: PQColor); cdecl; external Qt5PasLib name 'QImageReader_backgroundColor';
function QImageReader_supportsAnimation(handle: QImageReaderH): Boolean; cdecl; external Qt5PasLib name 'QImageReader_supportsAnimation';
function QImageReader_canRead(handle: QImageReaderH): Boolean; cdecl; external Qt5PasLib name 'QImageReader_canRead';
procedure QImageReader_read(handle: QImageReaderH; retval: QImageH); cdecl; external Qt5PasLib name 'QImageReader_read';
function QImageReader_jumpToNextImage(handle: QImageReaderH): Boolean; cdecl; external Qt5PasLib name 'QImageReader_jumpToNextImage';
function QImageReader_jumpToImage(handle: QImageReaderH; imageNumber: Integer): Boolean; cdecl; external Qt5PasLib name 'QImageReader_jumpToImage';
function QImageReader_loopCount(handle: QImageReaderH): Integer; cdecl; external Qt5PasLib name 'QImageReader_loopCount';
function QImageReader_imageCount(handle: QImageReaderH): Integer; cdecl; external Qt5PasLib name 'QImageReader_imageCount';
function QImageReader_nextImageDelay(handle: QImageReaderH): Integer; cdecl; external Qt5PasLib name 'QImageReader_nextImageDelay';
function QImageReader_currentImageNumber(handle: QImageReaderH): Integer; cdecl; external Qt5PasLib name 'QImageReader_currentImageNumber';
procedure QImageReader_currentImageRect(handle: QImageReaderH; retval: PRect); cdecl; external Qt5PasLib name 'QImageReader_currentImageRect';
function QImageReader_error(handle: QImageReaderH): QImageReaderImageReaderError; cdecl; external Qt5PasLib name 'QImageReader_error';
procedure QImageReader_errorString(handle: QImageReaderH; retval: PWideString); cdecl; external Qt5PasLib name 'QImageReader_errorString';
function QImageReader_supportsOption(handle: QImageReaderH; option: QImageIOHandlerImageOption): Boolean; cdecl; external Qt5PasLib name 'QImageReader_supportsOption';
procedure QImageReader_imageFormat(retval: QByteArrayH; fileName: PWideString); cdecl; external Qt5PasLib name 'QImageReader_imageFormat2';
procedure QImageReader_imageFormat(retval: QByteArrayH; device: QIODeviceH); cdecl; external Qt5PasLib name 'QImageReader_imageFormat3';


type
  QImageWriterImageWriterError = ( // QImageWriter::ImageWriterError (1)
    QImageWriterUnknownError, QImageWriterDeviceError, QImageWriterUnsupportedFormatError );

function QImageWriter_Create(): QImageWriterH; cdecl; external Qt5PasLib name 'QImageWriter_Create';
procedure QImageWriter_Destroy(handle: QImageWriterH); cdecl; external Qt5PasLib name 'QImageWriter_Destroy'; 
function QImageWriter_Create(device: QIODeviceH; format: QByteArrayH): QImageWriterH; cdecl; external Qt5PasLib name 'QImageWriter_Create2';
function QImageWriter_Create(fileName: PWideString; format: QByteArrayH = nil): QImageWriterH; cdecl; external Qt5PasLib name 'QImageWriter_Create3';
procedure QImageWriter_setFormat(handle: QImageWriterH; format: QByteArrayH); cdecl; external Qt5PasLib name 'QImageWriter_setFormat';
procedure QImageWriter_format(handle: QImageWriterH; retval: QByteArrayH); cdecl; external Qt5PasLib name 'QImageWriter_format';
procedure QImageWriter_setDevice(handle: QImageWriterH; device: QIODeviceH); cdecl; external Qt5PasLib name 'QImageWriter_setDevice';
function QImageWriter_device(handle: QImageWriterH): QIODeviceH; cdecl; external Qt5PasLib name 'QImageWriter_device';
procedure QImageWriter_setFileName(handle: QImageWriterH; fileName: PWideString); cdecl; external Qt5PasLib name 'QImageWriter_setFileName';
procedure QImageWriter_fileName(handle: QImageWriterH; retval: PWideString); cdecl; external Qt5PasLib name 'QImageWriter_fileName';
procedure QImageWriter_setQuality(handle: QImageWriterH; quality: Integer); cdecl; external Qt5PasLib name 'QImageWriter_setQuality';
function QImageWriter_quality(handle: QImageWriterH): Integer; cdecl; external Qt5PasLib name 'QImageWriter_quality';
procedure QImageWriter_setCompression(handle: QImageWriterH; compression: Integer); cdecl; external Qt5PasLib name 'QImageWriter_setCompression';
function QImageWriter_compression(handle: QImageWriterH): Integer; cdecl; external Qt5PasLib name 'QImageWriter_compression';
procedure QImageWriter_setGamma(handle: QImageWriterH; gamma: Single); cdecl; external Qt5PasLib name 'QImageWriter_setGamma';
function QImageWriter_gamma(handle: QImageWriterH): Single; cdecl; external Qt5PasLib name 'QImageWriter_gamma';
procedure QImageWriter_setDescription(handle: QImageWriterH; description: PWideString); cdecl; external Qt5PasLib name 'QImageWriter_setDescription';
procedure QImageWriter_description(handle: QImageWriterH; retval: PWideString); cdecl; external Qt5PasLib name 'QImageWriter_description';
procedure QImageWriter_setText(handle: QImageWriterH; key: PWideString; text: PWideString); cdecl; external Qt5PasLib name 'QImageWriter_setText';
function QImageWriter_canWrite(handle: QImageWriterH): Boolean; cdecl; external Qt5PasLib name 'QImageWriter_canWrite';
function QImageWriter_write(handle: QImageWriterH; image: QImageH): Boolean; cdecl; external Qt5PasLib name 'QImageWriter_write';
function QImageWriter_error(handle: QImageWriterH): QImageWriterImageWriterError; cdecl; external Qt5PasLib name 'QImageWriter_error';
procedure QImageWriter_errorString(handle: QImageWriterH; retval: PWideString); cdecl; external Qt5PasLib name 'QImageWriter_errorString';
function QImageWriter_supportsOption(handle: QImageWriterH; option: QImageIOHandlerImageOption): Boolean; cdecl; external Qt5PasLib name 'QImageWriter_supportsOption';


type
  QValidatorState = ( // QValidator::State (1)
    QValidatorInvalid, QValidatorIntermediate, QValidatorAcceptable );


type
  QDoubleValidatorNotation = ( // QDoubleValidator::Notation (1)
    QDoubleValidatorStandardNotation, QDoubleValidatorScientificNotation );

procedure QValidator_setLocale(handle: QValidatorH; locale: QLocaleH); cdecl; external Qt5PasLib name 'QValidator_setLocale';
procedure QValidator_locale(handle: QValidatorH; retval: QLocaleH); cdecl; external Qt5PasLib name 'QValidator_locale';
function QValidator_validate(handle: QValidatorH; AnonParam1: PWideString; AnonParam2: PInteger): QValidatorState; cdecl; external Qt5PasLib name 'QValidator_validate';
procedure QValidator_fixup(handle: QValidatorH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QValidator_fixup';

function QIntValidator_Create(parent: QObjectH = nil): QIntValidatorH; cdecl; external Qt5PasLib name 'QIntValidator_Create';
procedure QIntValidator_Destroy(handle: QIntValidatorH); cdecl; external Qt5PasLib name 'QIntValidator_Destroy'; 
function QIntValidator_Create(bottom: Integer; top: Integer; parent: QObjectH = nil): QIntValidatorH; cdecl; external Qt5PasLib name 'QIntValidator_Create2';
function QIntValidator_validate(handle: QIntValidatorH; AnonParam1: PWideString; AnonParam2: PInteger): QValidatorState; cdecl; external Qt5PasLib name 'QIntValidator_validate';
procedure QIntValidator_fixup(handle: QIntValidatorH; input: PWideString); cdecl; external Qt5PasLib name 'QIntValidator_fixup';
procedure QIntValidator_setBottom(handle: QIntValidatorH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QIntValidator_setBottom';
procedure QIntValidator_setTop(handle: QIntValidatorH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QIntValidator_setTop';
procedure QIntValidator_setRange(handle: QIntValidatorH; bottom: Integer; top: Integer); cdecl; external Qt5PasLib name 'QIntValidator_setRange';
function QIntValidator_bottom(handle: QIntValidatorH): Integer; cdecl; external Qt5PasLib name 'QIntValidator_bottom';
function QIntValidator_top(handle: QIntValidatorH): Integer; cdecl; external Qt5PasLib name 'QIntValidator_top';

function QDoubleValidator_Create(parent: QObjectH = nil): QDoubleValidatorH; cdecl; external Qt5PasLib name 'QDoubleValidator_Create';
procedure QDoubleValidator_Destroy(handle: QDoubleValidatorH); cdecl; external Qt5PasLib name 'QDoubleValidator_Destroy'; 
function QDoubleValidator_Create(bottom: Double; top: Double; decimals: Integer; parent: QObjectH = nil): QDoubleValidatorH; cdecl; external Qt5PasLib name 'QDoubleValidator_Create2';
function QDoubleValidator_validate(handle: QDoubleValidatorH; AnonParam1: PWideString; AnonParam2: PInteger): QValidatorState; cdecl; external Qt5PasLib name 'QDoubleValidator_validate';
procedure QDoubleValidator_setRange(handle: QDoubleValidatorH; bottom: Double; top: Double; decimals: Integer = 0); cdecl; external Qt5PasLib name 'QDoubleValidator_setRange';
procedure QDoubleValidator_setBottom(handle: QDoubleValidatorH; AnonParam1: Double); cdecl; external Qt5PasLib name 'QDoubleValidator_setBottom';
procedure QDoubleValidator_setTop(handle: QDoubleValidatorH; AnonParam1: Double); cdecl; external Qt5PasLib name 'QDoubleValidator_setTop';
procedure QDoubleValidator_setDecimals(handle: QDoubleValidatorH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QDoubleValidator_setDecimals';
procedure QDoubleValidator_setNotation(handle: QDoubleValidatorH; AnonParam1: QDoubleValidatorNotation); cdecl; external Qt5PasLib name 'QDoubleValidator_setNotation';
function QDoubleValidator_bottom(handle: QDoubleValidatorH): Double; cdecl; external Qt5PasLib name 'QDoubleValidator_bottom';
function QDoubleValidator_top(handle: QDoubleValidatorH): Double; cdecl; external Qt5PasLib name 'QDoubleValidator_top';
function QDoubleValidator_decimals(handle: QDoubleValidatorH): Integer; cdecl; external Qt5PasLib name 'QDoubleValidator_decimals';
function QDoubleValidator_notation(handle: QDoubleValidatorH): QDoubleValidatorNotation; cdecl; external Qt5PasLib name 'QDoubleValidator_notation';

function QRegExpValidator_Create(parent: QObjectH = nil): QRegExpValidatorH; cdecl; external Qt5PasLib name 'QRegExpValidator_Create';
procedure QRegExpValidator_Destroy(handle: QRegExpValidatorH); cdecl; external Qt5PasLib name 'QRegExpValidator_Destroy'; 
function QRegExpValidator_Create(rx: QRegExpH; parent: QObjectH = nil): QRegExpValidatorH; cdecl; external Qt5PasLib name 'QRegExpValidator_Create2';
function QRegExpValidator_validate(handle: QRegExpValidatorH; input: PWideString; pos: PInteger): QValidatorState; cdecl; external Qt5PasLib name 'QRegExpValidator_validate';
procedure QRegExpValidator_setRegExp(handle: QRegExpValidatorH; rx: QRegExpH); cdecl; external Qt5PasLib name 'QRegExpValidator_setRegExp';
function QRegExpValidator_regExp(handle: QRegExpValidatorH): QRegExpH; cdecl; external Qt5PasLib name 'QRegExpValidator_regExp';

function QRegularExpressionValidator_Create(parent: QObjectH = nil): QRegularExpressionValidatorH; cdecl; external Qt5PasLib name 'QRegularExpressionValidator_Create';
procedure QRegularExpressionValidator_Destroy(handle: QRegularExpressionValidatorH); cdecl; external Qt5PasLib name 'QRegularExpressionValidator_Destroy'; 
function QRegularExpressionValidator_Create(re: QRegularExpressionH; parent: QObjectH = nil): QRegularExpressionValidatorH; cdecl; external Qt5PasLib name 'QRegularExpressionValidator_Create2';
function QRegularExpressionValidator_validate(handle: QRegularExpressionValidatorH; input: PWideString; pos: PInteger): QValidatorState; cdecl; external Qt5PasLib name 'QRegularExpressionValidator_validate';
procedure QRegularExpressionValidator_regularExpression(handle: QRegularExpressionValidatorH; retval: QRegularExpressionH); cdecl; external Qt5PasLib name 'QRegularExpressionValidator_regularExpression';
procedure QRegularExpressionValidator_setRegularExpression(handle: QRegularExpressionValidatorH; re: QRegularExpressionH); cdecl; external Qt5PasLib name 'QRegularExpressionValidator_setRegularExpression';


type
  QStandardItemItemType = (  //QStandardItem::ItemType (2)
    QStandardItemType = 0,
    QStandardItemUserType = 1000 );

function QStandardItem_Create(): QStandardItemH; cdecl; external Qt5PasLib name 'QStandardItem_Create';
procedure QStandardItem_Destroy(handle: QStandardItemH); cdecl; external Qt5PasLib name 'QStandardItem_Destroy'; 
function QStandardItem_Create(text: PWideString): QStandardItemH; cdecl; external Qt5PasLib name 'QStandardItem_Create2';
function QStandardItem_Create(icon: QIconH; text: PWideString): QStandardItemH; cdecl; external Qt5PasLib name 'QStandardItem_Create3';
function QStandardItem_Create(rows: Integer; columns: Integer = 1): QStandardItemH; cdecl; external Qt5PasLib name 'QStandardItem_Create4';
procedure QStandardItem_data(handle: QStandardItemH; retval: QVariantH; role: QtItemDataRole); cdecl; external Qt5PasLib name 'QStandardItem_data';
procedure QStandardItem_setData(handle: QStandardItemH; value: QVariantH; role: QtItemDataRole); cdecl; external Qt5PasLib name 'QStandardItem_setData';
procedure QStandardItem_text(handle: QStandardItemH; retval: PWideString); cdecl; external Qt5PasLib name 'QStandardItem_text';
procedure QStandardItem_setText(handle: QStandardItemH; text: PWideString); cdecl; external Qt5PasLib name 'QStandardItem_setText';
procedure QStandardItem_icon(handle: QStandardItemH; retval: QIconH); cdecl; external Qt5PasLib name 'QStandardItem_icon';
procedure QStandardItem_setIcon(handle: QStandardItemH; icon: QIconH); cdecl; external Qt5PasLib name 'QStandardItem_setIcon';
procedure QStandardItem_toolTip(handle: QStandardItemH; retval: PWideString); cdecl; external Qt5PasLib name 'QStandardItem_toolTip';
procedure QStandardItem_setToolTip(handle: QStandardItemH; toolTip: PWideString); cdecl; external Qt5PasLib name 'QStandardItem_setToolTip';
procedure QStandardItem_statusTip(handle: QStandardItemH; retval: PWideString); cdecl; external Qt5PasLib name 'QStandardItem_statusTip';
procedure QStandardItem_setStatusTip(handle: QStandardItemH; statusTip: PWideString); cdecl; external Qt5PasLib name 'QStandardItem_setStatusTip';
procedure QStandardItem_whatsThis(handle: QStandardItemH; retval: PWideString); cdecl; external Qt5PasLib name 'QStandardItem_whatsThis';
procedure QStandardItem_setWhatsThis(handle: QStandardItemH; whatsThis: PWideString); cdecl; external Qt5PasLib name 'QStandardItem_setWhatsThis';
procedure QStandardItem_sizeHint(handle: QStandardItemH; retval: PSize); cdecl; external Qt5PasLib name 'QStandardItem_sizeHint';
procedure QStandardItem_setSizeHint(handle: QStandardItemH; sizeHint: PSize); cdecl; external Qt5PasLib name 'QStandardItem_setSizeHint';
procedure QStandardItem_font(handle: QStandardItemH; retval: QFontH); cdecl; external Qt5PasLib name 'QStandardItem_font';
procedure QStandardItem_setFont(handle: QStandardItemH; font: QFontH); cdecl; external Qt5PasLib name 'QStandardItem_setFont';
function QStandardItem_textAlignment(handle: QStandardItemH): QtAlignment; cdecl; external Qt5PasLib name 'QStandardItem_textAlignment';
procedure QStandardItem_setTextAlignment(handle: QStandardItemH; textAlignment: QtAlignment); cdecl; external Qt5PasLib name 'QStandardItem_setTextAlignment';
procedure QStandardItem_background(handle: QStandardItemH; retval: QBrushH); cdecl; external Qt5PasLib name 'QStandardItem_background';
procedure QStandardItem_setBackground(handle: QStandardItemH; brush: QBrushH); cdecl; external Qt5PasLib name 'QStandardItem_setBackground';
procedure QStandardItem_foreground(handle: QStandardItemH; retval: QBrushH); cdecl; external Qt5PasLib name 'QStandardItem_foreground';
procedure QStandardItem_setForeground(handle: QStandardItemH; brush: QBrushH); cdecl; external Qt5PasLib name 'QStandardItem_setForeground';
function QStandardItem_checkState(handle: QStandardItemH): QtCheckState; cdecl; external Qt5PasLib name 'QStandardItem_checkState';
procedure QStandardItem_setCheckState(handle: QStandardItemH; checkState: QtCheckState); cdecl; external Qt5PasLib name 'QStandardItem_setCheckState';
procedure QStandardItem_accessibleText(handle: QStandardItemH; retval: PWideString); cdecl; external Qt5PasLib name 'QStandardItem_accessibleText';
procedure QStandardItem_setAccessibleText(handle: QStandardItemH; accessibleText: PWideString); cdecl; external Qt5PasLib name 'QStandardItem_setAccessibleText';
procedure QStandardItem_accessibleDescription(handle: QStandardItemH; retval: PWideString); cdecl; external Qt5PasLib name 'QStandardItem_accessibleDescription';
procedure QStandardItem_setAccessibleDescription(handle: QStandardItemH; accessibleDescription: PWideString); cdecl; external Qt5PasLib name 'QStandardItem_setAccessibleDescription';
function QStandardItem_flags(handle: QStandardItemH): QtItemFlags; cdecl; external Qt5PasLib name 'QStandardItem_flags';
procedure QStandardItem_setFlags(handle: QStandardItemH; flags: QtItemFlags); cdecl; external Qt5PasLib name 'QStandardItem_setFlags';
function QStandardItem_isEnabled(handle: QStandardItemH): Boolean; cdecl; external Qt5PasLib name 'QStandardItem_isEnabled';
procedure QStandardItem_setEnabled(handle: QStandardItemH; enabled: Boolean); cdecl; external Qt5PasLib name 'QStandardItem_setEnabled';
function QStandardItem_isEditable(handle: QStandardItemH): Boolean; cdecl; external Qt5PasLib name 'QStandardItem_isEditable';
procedure QStandardItem_setEditable(handle: QStandardItemH; editable: Boolean); cdecl; external Qt5PasLib name 'QStandardItem_setEditable';
function QStandardItem_isSelectable(handle: QStandardItemH): Boolean; cdecl; external Qt5PasLib name 'QStandardItem_isSelectable';
procedure QStandardItem_setSelectable(handle: QStandardItemH; selectable: Boolean); cdecl; external Qt5PasLib name 'QStandardItem_setSelectable';
function QStandardItem_isCheckable(handle: QStandardItemH): Boolean; cdecl; external Qt5PasLib name 'QStandardItem_isCheckable';
procedure QStandardItem_setCheckable(handle: QStandardItemH; checkable: Boolean); cdecl; external Qt5PasLib name 'QStandardItem_setCheckable';
function QStandardItem_isTristate(handle: QStandardItemH): Boolean; cdecl; external Qt5PasLib name 'QStandardItem_isTristate';
procedure QStandardItem_setTristate(handle: QStandardItemH; tristate: Boolean); cdecl; external Qt5PasLib name 'QStandardItem_setTristate';
function QStandardItem_isDragEnabled(handle: QStandardItemH): Boolean; cdecl; external Qt5PasLib name 'QStandardItem_isDragEnabled';
procedure QStandardItem_setDragEnabled(handle: QStandardItemH; dragEnabled: Boolean); cdecl; external Qt5PasLib name 'QStandardItem_setDragEnabled';
function QStandardItem_isDropEnabled(handle: QStandardItemH): Boolean; cdecl; external Qt5PasLib name 'QStandardItem_isDropEnabled';
procedure QStandardItem_setDropEnabled(handle: QStandardItemH; dropEnabled: Boolean); cdecl; external Qt5PasLib name 'QStandardItem_setDropEnabled';
function QStandardItem_parent(handle: QStandardItemH): QStandardItemH; cdecl; external Qt5PasLib name 'QStandardItem_parent';
function QStandardItem_row(handle: QStandardItemH): Integer; cdecl; external Qt5PasLib name 'QStandardItem_row';
function QStandardItem_column(handle: QStandardItemH): Integer; cdecl; external Qt5PasLib name 'QStandardItem_column';
procedure QStandardItem_index(handle: QStandardItemH; retval: QModelIndexH); cdecl; external Qt5PasLib name 'QStandardItem_index';
function QStandardItem_model(handle: QStandardItemH): QStandardItemModelH; cdecl; external Qt5PasLib name 'QStandardItem_model';
function QStandardItem_rowCount(handle: QStandardItemH): Integer; cdecl; external Qt5PasLib name 'QStandardItem_rowCount';
procedure QStandardItem_setRowCount(handle: QStandardItemH; rows: Integer); cdecl; external Qt5PasLib name 'QStandardItem_setRowCount';
function QStandardItem_columnCount(handle: QStandardItemH): Integer; cdecl; external Qt5PasLib name 'QStandardItem_columnCount';
procedure QStandardItem_setColumnCount(handle: QStandardItemH; columns: Integer); cdecl; external Qt5PasLib name 'QStandardItem_setColumnCount';
function QStandardItem_hasChildren(handle: QStandardItemH): Boolean; cdecl; external Qt5PasLib name 'QStandardItem_hasChildren';
function QStandardItem_child(handle: QStandardItemH; row: Integer; column: Integer = 0): QStandardItemH; cdecl; external Qt5PasLib name 'QStandardItem_child';
procedure QStandardItem_setChild(handle: QStandardItemH; row: Integer; column: Integer; item: QStandardItemH); cdecl; external Qt5PasLib name 'QStandardItem_setChild';
procedure QStandardItem_setChild(handle: QStandardItemH; row: Integer; item: QStandardItemH); cdecl; external Qt5PasLib name 'QStandardItem_setChild2';
procedure QStandardItem_insertRow(handle: QStandardItemH; row: Integer; items: PPtrIntArray); cdecl; external Qt5PasLib name 'QStandardItem_insertRow';
procedure QStandardItem_insertColumn(handle: QStandardItemH; column: Integer; items: PPtrIntArray); cdecl; external Qt5PasLib name 'QStandardItem_insertColumn';
procedure QStandardItem_insertRows(handle: QStandardItemH; row: Integer; items: PPtrIntArray); cdecl; external Qt5PasLib name 'QStandardItem_insertRows';
procedure QStandardItem_insertRows(handle: QStandardItemH; row: Integer; count: Integer); cdecl; external Qt5PasLib name 'QStandardItem_insertRows2';
procedure QStandardItem_insertColumns(handle: QStandardItemH; column: Integer; count: Integer); cdecl; external Qt5PasLib name 'QStandardItem_insertColumns';
procedure QStandardItem_removeRow(handle: QStandardItemH; row: Integer); cdecl; external Qt5PasLib name 'QStandardItem_removeRow';
procedure QStandardItem_removeColumn(handle: QStandardItemH; column: Integer); cdecl; external Qt5PasLib name 'QStandardItem_removeColumn';
procedure QStandardItem_removeRows(handle: QStandardItemH; row: Integer; count: Integer); cdecl; external Qt5PasLib name 'QStandardItem_removeRows';
procedure QStandardItem_removeColumns(handle: QStandardItemH; column: Integer; count: Integer); cdecl; external Qt5PasLib name 'QStandardItem_removeColumns';
procedure QStandardItem_appendRow(handle: QStandardItemH; items: PPtrIntArray); cdecl; external Qt5PasLib name 'QStandardItem_appendRow';
procedure QStandardItem_appendRows(handle: QStandardItemH; items: PPtrIntArray); cdecl; external Qt5PasLib name 'QStandardItem_appendRows';
procedure QStandardItem_appendColumn(handle: QStandardItemH; items: PPtrIntArray); cdecl; external Qt5PasLib name 'QStandardItem_appendColumn';
procedure QStandardItem_insertRow(handle: QStandardItemH; row: Integer; item: QStandardItemH); cdecl; external Qt5PasLib name 'QStandardItem_insertRow2';
procedure QStandardItem_appendRow(handle: QStandardItemH; item: QStandardItemH); cdecl; external Qt5PasLib name 'QStandardItem_appendRow2';
function QStandardItem_takeChild(handle: QStandardItemH; row: Integer; column: Integer = 0): QStandardItemH; cdecl; external Qt5PasLib name 'QStandardItem_takeChild';
procedure QStandardItem_takeRow(handle: QStandardItemH; retval: PPtrIntArray; row: Integer); cdecl; external Qt5PasLib name 'QStandardItem_takeRow';
procedure QStandardItem_takeColumn(handle: QStandardItemH; retval: PPtrIntArray; column: Integer); cdecl; external Qt5PasLib name 'QStandardItem_takeColumn';
procedure QStandardItem_sortChildren(handle: QStandardItemH; column: Integer; order: QtSortOrder = QtAscendingOrder); cdecl; external Qt5PasLib name 'QStandardItem_sortChildren';
function QStandardItem_clone(handle: QStandardItemH): QStandardItemH; cdecl; external Qt5PasLib name 'QStandardItem_clone';
function QStandardItem_type(handle: QStandardItemH): Integer; cdecl; external Qt5PasLib name 'QStandardItem_type';
procedure QStandardItem_read(handle: QStandardItemH; _in: QDataStreamH); cdecl; external Qt5PasLib name 'QStandardItem_read';
procedure QStandardItem_write(handle: QStandardItemH; _out: QDataStreamH); cdecl; external Qt5PasLib name 'QStandardItem_write';

function QStandardItemModel_Create(parent: QObjectH = nil): QStandardItemModelH; cdecl; external Qt5PasLib name 'QStandardItemModel_Create';
procedure QStandardItemModel_Destroy(handle: QStandardItemModelH); cdecl; external Qt5PasLib name 'QStandardItemModel_Destroy'; 
function QStandardItemModel_Create(rows: Integer; columns: Integer; parent: QObjectH = nil): QStandardItemModelH; cdecl; external Qt5PasLib name 'QStandardItemModel_Create2';
procedure QStandardItemModel_index(handle: QStandardItemModelH; retval: QModelIndexH; row: Integer; column: Integer; parent: QModelIndexH = nil); cdecl; external Qt5PasLib name 'QStandardItemModel_index';
procedure QStandardItemModel_parent(handle: QStandardItemModelH; retval: QModelIndexH; child: QModelIndexH); cdecl; external Qt5PasLib name 'QStandardItemModel_parent';
function QStandardItemModel_rowCount(handle: QStandardItemModelH; parent: QModelIndexH = nil): Integer; cdecl; external Qt5PasLib name 'QStandardItemModel_rowCount';
function QStandardItemModel_columnCount(handle: QStandardItemModelH; parent: QModelIndexH = nil): Integer; cdecl; external Qt5PasLib name 'QStandardItemModel_columnCount';
function QStandardItemModel_hasChildren(handle: QStandardItemModelH; parent: QModelIndexH = nil): Boolean; cdecl; external Qt5PasLib name 'QStandardItemModel_hasChildren';
procedure QStandardItemModel_sibling(handle: QStandardItemModelH; retval: QModelIndexH; row: Integer; column: Integer; idx: QModelIndexH); cdecl; external Qt5PasLib name 'QStandardItemModel_sibling';
procedure QStandardItemModel_data(handle: QStandardItemModelH; retval: QVariantH; index: QModelIndexH; role: QtItemDataRole = QtDisplayRole); cdecl; external Qt5PasLib name 'QStandardItemModel_data';
function QStandardItemModel_setData(handle: QStandardItemModelH; index: QModelIndexH; value: QVariantH; role: QtItemDataRole = QtEditRole): Boolean; cdecl; external Qt5PasLib name 'QStandardItemModel_setData';
procedure QStandardItemModel_headerData(handle: QStandardItemModelH; retval: QVariantH; section: Integer; orientation: QtOrientation; role: QtItemDataRole = QtDisplayRole); cdecl; external Qt5PasLib name 'QStandardItemModel_headerData';
function QStandardItemModel_setHeaderData(handle: QStandardItemModelH; section: Integer; orientation: QtOrientation; value: QVariantH; role: QtItemDataRole = QtEditRole): Boolean; cdecl; external Qt5PasLib name 'QStandardItemModel_setHeaderData';
function QStandardItemModel_insertRows(handle: QStandardItemModelH; row: Integer; count: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt5PasLib name 'QStandardItemModel_insertRows';
function QStandardItemModel_insertColumns(handle: QStandardItemModelH; column: Integer; count: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt5PasLib name 'QStandardItemModel_insertColumns';
function QStandardItemModel_removeRows(handle: QStandardItemModelH; row: Integer; count: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt5PasLib name 'QStandardItemModel_removeRows';
function QStandardItemModel_removeColumns(handle: QStandardItemModelH; column: Integer; count: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt5PasLib name 'QStandardItemModel_removeColumns';
function QStandardItemModel_flags(handle: QStandardItemModelH; index: QModelIndexH): QtItemFlags; cdecl; external Qt5PasLib name 'QStandardItemModel_flags';
function QStandardItemModel_supportedDropActions(handle: QStandardItemModelH): QtDropActions; cdecl; external Qt5PasLib name 'QStandardItemModel_supportedDropActions';
procedure QStandardItemModel_clear(handle: QStandardItemModelH); cdecl; external Qt5PasLib name 'QStandardItemModel_clear';
procedure QStandardItemModel_sort(handle: QStandardItemModelH; column: Integer; order: QtSortOrder = QtAscendingOrder); cdecl; external Qt5PasLib name 'QStandardItemModel_sort';
function QStandardItemModel_itemFromIndex(handle: QStandardItemModelH; index: QModelIndexH): QStandardItemH; cdecl; external Qt5PasLib name 'QStandardItemModel_itemFromIndex';
procedure QStandardItemModel_indexFromItem(handle: QStandardItemModelH; retval: QModelIndexH; item: QStandardItemH); cdecl; external Qt5PasLib name 'QStandardItemModel_indexFromItem';
function QStandardItemModel_item(handle: QStandardItemModelH; row: Integer; column: Integer = 0): QStandardItemH; cdecl; external Qt5PasLib name 'QStandardItemModel_item';
procedure QStandardItemModel_setItem(handle: QStandardItemModelH; row: Integer; column: Integer; item: QStandardItemH); cdecl; external Qt5PasLib name 'QStandardItemModel_setItem';
procedure QStandardItemModel_setItem(handle: QStandardItemModelH; row: Integer; item: QStandardItemH); cdecl; external Qt5PasLib name 'QStandardItemModel_setItem2';
function QStandardItemModel_invisibleRootItem(handle: QStandardItemModelH): QStandardItemH; cdecl; external Qt5PasLib name 'QStandardItemModel_invisibleRootItem';
function QStandardItemModel_horizontalHeaderItem(handle: QStandardItemModelH; column: Integer): QStandardItemH; cdecl; external Qt5PasLib name 'QStandardItemModel_horizontalHeaderItem';
procedure QStandardItemModel_setHorizontalHeaderItem(handle: QStandardItemModelH; column: Integer; item: QStandardItemH); cdecl; external Qt5PasLib name 'QStandardItemModel_setHorizontalHeaderItem';
function QStandardItemModel_verticalHeaderItem(handle: QStandardItemModelH; row: Integer): QStandardItemH; cdecl; external Qt5PasLib name 'QStandardItemModel_verticalHeaderItem';
procedure QStandardItemModel_setVerticalHeaderItem(handle: QStandardItemModelH; row: Integer; item: QStandardItemH); cdecl; external Qt5PasLib name 'QStandardItemModel_setVerticalHeaderItem';
procedure QStandardItemModel_setHorizontalHeaderLabels(handle: QStandardItemModelH; labels: QStringListH); cdecl; external Qt5PasLib name 'QStandardItemModel_setHorizontalHeaderLabels';
procedure QStandardItemModel_setVerticalHeaderLabels(handle: QStandardItemModelH; labels: QStringListH); cdecl; external Qt5PasLib name 'QStandardItemModel_setVerticalHeaderLabels';
procedure QStandardItemModel_setRowCount(handle: QStandardItemModelH; rows: Integer); cdecl; external Qt5PasLib name 'QStandardItemModel_setRowCount';
procedure QStandardItemModel_setColumnCount(handle: QStandardItemModelH; columns: Integer); cdecl; external Qt5PasLib name 'QStandardItemModel_setColumnCount';
procedure QStandardItemModel_appendRow(handle: QStandardItemModelH; items: PPtrIntArray); cdecl; external Qt5PasLib name 'QStandardItemModel_appendRow';
procedure QStandardItemModel_appendColumn(handle: QStandardItemModelH; items: PPtrIntArray); cdecl; external Qt5PasLib name 'QStandardItemModel_appendColumn';
procedure QStandardItemModel_appendRow(handle: QStandardItemModelH; item: QStandardItemH); cdecl; external Qt5PasLib name 'QStandardItemModel_appendRow2';
procedure QStandardItemModel_insertRow(handle: QStandardItemModelH; row: Integer; items: PPtrIntArray); cdecl; external Qt5PasLib name 'QStandardItemModel_insertRow';
procedure QStandardItemModel_insertColumn(handle: QStandardItemModelH; column: Integer; items: PPtrIntArray); cdecl; external Qt5PasLib name 'QStandardItemModel_insertColumn';
procedure QStandardItemModel_insertRow(handle: QStandardItemModelH; row: Integer; item: QStandardItemH); cdecl; external Qt5PasLib name 'QStandardItemModel_insertRow2';
function QStandardItemModel_insertRow(handle: QStandardItemModelH; row: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt5PasLib name 'QStandardItemModel_insertRow3';
function QStandardItemModel_insertColumn(handle: QStandardItemModelH; column: Integer; parent: QModelIndexH = nil): Boolean; cdecl; external Qt5PasLib name 'QStandardItemModel_insertColumn2';
function QStandardItemModel_takeItem(handle: QStandardItemModelH; row: Integer; column: Integer = 0): QStandardItemH; cdecl; external Qt5PasLib name 'QStandardItemModel_takeItem';
procedure QStandardItemModel_takeRow(handle: QStandardItemModelH; retval: PPtrIntArray; row: Integer); cdecl; external Qt5PasLib name 'QStandardItemModel_takeRow';
procedure QStandardItemModel_takeColumn(handle: QStandardItemModelH; retval: PPtrIntArray; column: Integer); cdecl; external Qt5PasLib name 'QStandardItemModel_takeColumn';
function QStandardItemModel_takeHorizontalHeaderItem(handle: QStandardItemModelH; column: Integer): QStandardItemH; cdecl; external Qt5PasLib name 'QStandardItemModel_takeHorizontalHeaderItem';
function QStandardItemModel_takeVerticalHeaderItem(handle: QStandardItemModelH; row: Integer): QStandardItemH; cdecl; external Qt5PasLib name 'QStandardItemModel_takeVerticalHeaderItem';
function QStandardItemModel_itemPrototype(handle: QStandardItemModelH): QStandardItemH; cdecl; external Qt5PasLib name 'QStandardItemModel_itemPrototype';
procedure QStandardItemModel_setItemPrototype(handle: QStandardItemModelH; item: QStandardItemH); cdecl; external Qt5PasLib name 'QStandardItemModel_setItemPrototype';
procedure QStandardItemModel_findItems(handle: QStandardItemModelH; retval: PPtrIntArray; text: PWideString; flags: QtMatchFlags = QtMatchExactly; column: Integer = 0); cdecl; external Qt5PasLib name 'QStandardItemModel_findItems';
function QStandardItemModel_sortRole(handle: QStandardItemModelH): Integer; cdecl; external Qt5PasLib name 'QStandardItemModel_sortRole';
procedure QStandardItemModel_setSortRole(handle: QStandardItemModelH; role: Integer); cdecl; external Qt5PasLib name 'QStandardItemModel_setSortRole';
procedure QStandardItemModel_mimeTypes(handle: QStandardItemModelH; retval: QStringListH); cdecl; external Qt5PasLib name 'QStandardItemModel_mimeTypes';
function QStandardItemModel_dropMimeData(handle: QStandardItemModelH; data: QMimeDataH; action: QtDropAction; row: Integer; column: Integer; parent: QModelIndexH): Boolean; cdecl; external Qt5PasLib name 'QStandardItemModel_dropMimeData';


type
  QStandardItemModel_itemChanged_Event = procedure (item: QStandardItemH) of object cdecl;



type
  QFrameShape = (  //QFrame::Shape (2)
    QFrameNoFrame = 0,
    QFrameBox = $0001,
    QFramePanel = $0002,
    QFrameWinPanel = $0003,
    QFrameHLine = $0004,
    QFrameVLine = $0005,
    QFrameStyledPanel = $0006 );

  QFrameShadow = (  //QFrame::Shadow (2)
    QFramePlain = $0010,
    QFrameRaised = $0020,
    QFrameSunken = $0030 );

  QFrameStyleMask = (  //QFrame::StyleMask (2)
    QFrameShape_Mask = $000f,
    QFrameShadow_Mask = $00f0 );

function QFrame_Create(parent: QWidgetH = nil; f: QtWindowFlags = 0): QFrameH; cdecl; external Qt5PasLib name 'QFrame_Create';
procedure QFrame_Destroy(handle: QFrameH); cdecl; external Qt5PasLib name 'QFrame_Destroy'; 
function QFrame_frameStyle(handle: QFrameH): Integer; cdecl; external Qt5PasLib name 'QFrame_frameStyle';
procedure QFrame_setFrameStyle(handle: QFrameH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QFrame_setFrameStyle';
function QFrame_frameWidth(handle: QFrameH): Integer; cdecl; external Qt5PasLib name 'QFrame_frameWidth';
procedure QFrame_sizeHint(handle: QFrameH; retval: PSize); cdecl; external Qt5PasLib name 'QFrame_sizeHint';
function QFrame_frameShape(handle: QFrameH): QFrameShape; cdecl; external Qt5PasLib name 'QFrame_frameShape';
procedure QFrame_setFrameShape(handle: QFrameH; AnonParam1: QFrameShape); cdecl; external Qt5PasLib name 'QFrame_setFrameShape';
function QFrame_frameShadow(handle: QFrameH): QFrameShadow; cdecl; external Qt5PasLib name 'QFrame_frameShadow';
procedure QFrame_setFrameShadow(handle: QFrameH; AnonParam1: QFrameShadow); cdecl; external Qt5PasLib name 'QFrame_setFrameShadow';
function QFrame_lineWidth(handle: QFrameH): Integer; cdecl; external Qt5PasLib name 'QFrame_lineWidth';
procedure QFrame_setLineWidth(handle: QFrameH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QFrame_setLineWidth';
function QFrame_midLineWidth(handle: QFrameH): Integer; cdecl; external Qt5PasLib name 'QFrame_midLineWidth';
procedure QFrame_setMidLineWidth(handle: QFrameH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QFrame_setMidLineWidth';
procedure QFrame_frameRect(handle: QFrameH; retval: PRect); cdecl; external Qt5PasLib name 'QFrame_frameRect';
procedure QFrame_setFrameRect(handle: QFrameH; AnonParam1: PRect); cdecl; external Qt5PasLib name 'QFrame_setFrameRect';

function QStackedWidget_Create(parent: QWidgetH = nil): QStackedWidgetH; cdecl; external Qt5PasLib name 'QStackedWidget_Create';
procedure QStackedWidget_Destroy(handle: QStackedWidgetH); cdecl; external Qt5PasLib name 'QStackedWidget_Destroy'; 
function QStackedWidget_addWidget(handle: QStackedWidgetH; w: QWidgetH): Integer; cdecl; external Qt5PasLib name 'QStackedWidget_addWidget';
function QStackedWidget_insertWidget(handle: QStackedWidgetH; index: Integer; w: QWidgetH): Integer; cdecl; external Qt5PasLib name 'QStackedWidget_insertWidget';
procedure QStackedWidget_removeWidget(handle: QStackedWidgetH; w: QWidgetH); cdecl; external Qt5PasLib name 'QStackedWidget_removeWidget';
function QStackedWidget_currentWidget(handle: QStackedWidgetH): QWidgetH; cdecl; external Qt5PasLib name 'QStackedWidget_currentWidget';
function QStackedWidget_currentIndex(handle: QStackedWidgetH): Integer; cdecl; external Qt5PasLib name 'QStackedWidget_currentIndex';
function QStackedWidget_indexOf(handle: QStackedWidgetH; AnonParam1: QWidgetH): Integer; cdecl; external Qt5PasLib name 'QStackedWidget_indexOf';
function QStackedWidget_widget(handle: QStackedWidgetH; AnonParam1: Integer): QWidgetH; cdecl; external Qt5PasLib name 'QStackedWidget_widget';
function QStackedWidget_count(handle: QStackedWidgetH): Integer; cdecl; external Qt5PasLib name 'QStackedWidget_count';
procedure QStackedWidget_setCurrentIndex(handle: QStackedWidgetH; index: Integer); cdecl; external Qt5PasLib name 'QStackedWidget_setCurrentIndex';
procedure QStackedWidget_setCurrentWidget(handle: QStackedWidgetH; w: QWidgetH); cdecl; external Qt5PasLib name 'QStackedWidget_setCurrentWidget';


type
  QStackedWidget_currentChanged_Event = procedure (AnonParam1: Integer) of object cdecl;
  QStackedWidget_widgetRemoved_Event = procedure (index: Integer) of object cdecl;


function QAbstractScrollArea_Create(parent: QWidgetH = nil): QAbstractScrollAreaH; cdecl; external Qt5PasLib name 'QAbstractScrollArea_Create';
procedure QAbstractScrollArea_Destroy(handle: QAbstractScrollAreaH); cdecl; external Qt5PasLib name 'QAbstractScrollArea_Destroy'; 
function QAbstractScrollArea_verticalScrollBarPolicy(handle: QAbstractScrollAreaH): QtScrollBarPolicy; cdecl; external Qt5PasLib name 'QAbstractScrollArea_verticalScrollBarPolicy';
procedure QAbstractScrollArea_setVerticalScrollBarPolicy(handle: QAbstractScrollAreaH; AnonParam1: QtScrollBarPolicy); cdecl; external Qt5PasLib name 'QAbstractScrollArea_setVerticalScrollBarPolicy';
function QAbstractScrollArea_verticalScrollBar(handle: QAbstractScrollAreaH): QScrollBarH; cdecl; external Qt5PasLib name 'QAbstractScrollArea_verticalScrollBar';
procedure QAbstractScrollArea_setVerticalScrollBar(handle: QAbstractScrollAreaH; scrollbar: QScrollBarH); cdecl; external Qt5PasLib name 'QAbstractScrollArea_setVerticalScrollBar';
function QAbstractScrollArea_horizontalScrollBarPolicy(handle: QAbstractScrollAreaH): QtScrollBarPolicy; cdecl; external Qt5PasLib name 'QAbstractScrollArea_horizontalScrollBarPolicy';
procedure QAbstractScrollArea_setHorizontalScrollBarPolicy(handle: QAbstractScrollAreaH; AnonParam1: QtScrollBarPolicy); cdecl; external Qt5PasLib name 'QAbstractScrollArea_setHorizontalScrollBarPolicy';
function QAbstractScrollArea_horizontalScrollBar(handle: QAbstractScrollAreaH): QScrollBarH; cdecl; external Qt5PasLib name 'QAbstractScrollArea_horizontalScrollBar';
procedure QAbstractScrollArea_setHorizontalScrollBar(handle: QAbstractScrollAreaH; scrollbar: QScrollBarH); cdecl; external Qt5PasLib name 'QAbstractScrollArea_setHorizontalScrollBar';
function QAbstractScrollArea_cornerWidget(handle: QAbstractScrollAreaH): QWidgetH; cdecl; external Qt5PasLib name 'QAbstractScrollArea_cornerWidget';
procedure QAbstractScrollArea_setCornerWidget(handle: QAbstractScrollAreaH; widget: QWidgetH); cdecl; external Qt5PasLib name 'QAbstractScrollArea_setCornerWidget';
procedure QAbstractScrollArea_addScrollBarWidget(handle: QAbstractScrollAreaH; widget: QWidgetH; alignment: QtAlignment); cdecl; external Qt5PasLib name 'QAbstractScrollArea_addScrollBarWidget';
procedure QAbstractScrollArea_scrollBarWidgets(handle: QAbstractScrollAreaH; retval: PPtrIntArray; alignment: QtAlignment); cdecl; external Qt5PasLib name 'QAbstractScrollArea_scrollBarWidgets';
function QAbstractScrollArea_viewport(handle: QAbstractScrollAreaH): QWidgetH; cdecl; external Qt5PasLib name 'QAbstractScrollArea_viewport';
procedure QAbstractScrollArea_setViewport(handle: QAbstractScrollAreaH; widget: QWidgetH); cdecl; external Qt5PasLib name 'QAbstractScrollArea_setViewport';
procedure QAbstractScrollArea_maximumViewportSize(handle: QAbstractScrollAreaH; retval: PSize); cdecl; external Qt5PasLib name 'QAbstractScrollArea_maximumViewportSize';
procedure QAbstractScrollArea_minimumSizeHint(handle: QAbstractScrollAreaH; retval: PSize); cdecl; external Qt5PasLib name 'QAbstractScrollArea_minimumSizeHint';
procedure QAbstractScrollArea_sizeHint(handle: QAbstractScrollAreaH; retval: PSize); cdecl; external Qt5PasLib name 'QAbstractScrollArea_sizeHint';
procedure QAbstractScrollArea_setupViewport(handle: QAbstractScrollAreaH; viewport: QWidgetH); cdecl; external Qt5PasLib name 'QAbstractScrollArea_setupViewport';

function QLCLAbstractScrollArea_Create(parent: QWidgetH = nil): QLCLAbstractScrollAreaH; cdecl; external Qt5PasLib name 'QLCLAbstractScrollArea_Create';
procedure QLCLAbstractScrollArea_Destroy(handle: QLCLAbstractScrollAreaH); cdecl; external Qt5PasLib name 'QLCLAbstractScrollArea_Destroy'; 
procedure QLCLAbstractScrollArea_override_viewportEvent(handle: QLCLAbstractScrollAreaH; hook: QLCLAbstractScrollArea_viewportEvent_Override); cdecl; external Qt5PasLib name 'QLCLAbstractScrollArea_override_viewportEvent';
function QLCLAbstractScrollArea_InheritedViewportEvent(handle: QLCLAbstractScrollAreaH; event: QEventH): Boolean; cdecl; external Qt5PasLib name 'QLCLAbstractScrollArea_InheritedViewportEvent';


type
  QAbstractSliderSliderAction = ( // QAbstractSlider::SliderAction (1)
    QAbstractSliderSliderNoAction, QAbstractSliderSliderSingleStepAdd, QAbstractSliderSliderSingleStepSub, QAbstractSliderSliderPageStepAdd, QAbstractSliderSliderPageStepSub, QAbstractSliderSliderToMinimum, 
    QAbstractSliderSliderToMaximum, QAbstractSliderSliderMove );

function QAbstractSlider_Create(parent: QWidgetH = nil): QAbstractSliderH; cdecl; external Qt5PasLib name 'QAbstractSlider_Create';
procedure QAbstractSlider_Destroy(handle: QAbstractSliderH); cdecl; external Qt5PasLib name 'QAbstractSlider_Destroy'; 
function QAbstractSlider_orientation(handle: QAbstractSliderH): QtOrientation; cdecl; external Qt5PasLib name 'QAbstractSlider_orientation';
procedure QAbstractSlider_setMinimum(handle: QAbstractSliderH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QAbstractSlider_setMinimum';
function QAbstractSlider_minimum(handle: QAbstractSliderH): Integer; cdecl; external Qt5PasLib name 'QAbstractSlider_minimum';
procedure QAbstractSlider_setMaximum(handle: QAbstractSliderH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QAbstractSlider_setMaximum';
function QAbstractSlider_maximum(handle: QAbstractSliderH): Integer; cdecl; external Qt5PasLib name 'QAbstractSlider_maximum';
procedure QAbstractSlider_setSingleStep(handle: QAbstractSliderH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QAbstractSlider_setSingleStep';
function QAbstractSlider_singleStep(handle: QAbstractSliderH): Integer; cdecl; external Qt5PasLib name 'QAbstractSlider_singleStep';
procedure QAbstractSlider_setPageStep(handle: QAbstractSliderH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QAbstractSlider_setPageStep';
function QAbstractSlider_pageStep(handle: QAbstractSliderH): Integer; cdecl; external Qt5PasLib name 'QAbstractSlider_pageStep';
procedure QAbstractSlider_setTracking(handle: QAbstractSliderH; enable: Boolean); cdecl; external Qt5PasLib name 'QAbstractSlider_setTracking';
function QAbstractSlider_hasTracking(handle: QAbstractSliderH): Boolean; cdecl; external Qt5PasLib name 'QAbstractSlider_hasTracking';
procedure QAbstractSlider_setSliderDown(handle: QAbstractSliderH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QAbstractSlider_setSliderDown';
function QAbstractSlider_isSliderDown(handle: QAbstractSliderH): Boolean; cdecl; external Qt5PasLib name 'QAbstractSlider_isSliderDown';
procedure QAbstractSlider_setSliderPosition(handle: QAbstractSliderH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QAbstractSlider_setSliderPosition';
function QAbstractSlider_sliderPosition(handle: QAbstractSliderH): Integer; cdecl; external Qt5PasLib name 'QAbstractSlider_sliderPosition';
procedure QAbstractSlider_setInvertedAppearance(handle: QAbstractSliderH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QAbstractSlider_setInvertedAppearance';
function QAbstractSlider_invertedAppearance(handle: QAbstractSliderH): Boolean; cdecl; external Qt5PasLib name 'QAbstractSlider_invertedAppearance';
procedure QAbstractSlider_setInvertedControls(handle: QAbstractSliderH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QAbstractSlider_setInvertedControls';
function QAbstractSlider_invertedControls(handle: QAbstractSliderH): Boolean; cdecl; external Qt5PasLib name 'QAbstractSlider_invertedControls';
function QAbstractSlider_value(handle: QAbstractSliderH): Integer; cdecl; external Qt5PasLib name 'QAbstractSlider_value';
procedure QAbstractSlider_triggerAction(handle: QAbstractSliderH; action: QAbstractSliderSliderAction); cdecl; external Qt5PasLib name 'QAbstractSlider_triggerAction';
procedure QAbstractSlider_setValue(handle: QAbstractSliderH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QAbstractSlider_setValue';
procedure QAbstractSlider_setOrientation(handle: QAbstractSliderH; AnonParam1: QtOrientation); cdecl; external Qt5PasLib name 'QAbstractSlider_setOrientation';
procedure QAbstractSlider_setRange(handle: QAbstractSliderH; min: Integer; max: Integer); cdecl; external Qt5PasLib name 'QAbstractSlider_setRange';


type
  QAbstractSlider_valueChanged_Event = procedure (value: Integer) of object cdecl;
  QAbstractSlider_sliderPressed_Event = procedure () of object cdecl;
  QAbstractSlider_sliderMoved_Event = procedure (position: Integer) of object cdecl;
  QAbstractSlider_sliderReleased_Event = procedure () of object cdecl;
  QAbstractSlider_rangeChanged_Event = procedure (min: Integer; max: Integer) of object cdecl;
  QAbstractSlider_actionTriggered_Event = procedure (action: Integer) of object cdecl;


function QScrollBar_Create(parent: QWidgetH = nil): QScrollBarH; cdecl; external Qt5PasLib name 'QScrollBar_Create';
procedure QScrollBar_Destroy(handle: QScrollBarH); cdecl; external Qt5PasLib name 'QScrollBar_Destroy'; 
function QScrollBar_Create(AnonParam1: QtOrientation; parent: QWidgetH = nil): QScrollBarH; cdecl; external Qt5PasLib name 'QScrollBar_Create2';
procedure QScrollBar_sizeHint(handle: QScrollBarH; retval: PSize); cdecl; external Qt5PasLib name 'QScrollBar_sizeHint';
function QScrollBar_event(handle: QScrollBarH; event: QEventH): Boolean; cdecl; external Qt5PasLib name 'QScrollBar_event';

function QMenu_Create(parent: QWidgetH = nil): QMenuH; cdecl; external Qt5PasLib name 'QMenu_Create';
procedure QMenu_Destroy(handle: QMenuH); cdecl; external Qt5PasLib name 'QMenu_Destroy'; 
function QMenu_Create(title: PWideString; parent: QWidgetH = nil): QMenuH; cdecl; external Qt5PasLib name 'QMenu_Create2';
function QMenu_addAction(handle: QMenuH; text: PWideString): QActionH; cdecl; external Qt5PasLib name 'QMenu_addAction';
function QMenu_addAction(handle: QMenuH; icon: QIconH; text: PWideString): QActionH; cdecl; external Qt5PasLib name 'QMenu_addAction2';
function QMenu_addAction(handle: QMenuH; text: PWideString; receiver: QObjectH; member: PAnsiChar; shortcut: QKeySequenceH = nil): QActionH; cdecl; external Qt5PasLib name 'QMenu_addAction3';
function QMenu_addAction(handle: QMenuH; icon: QIconH; text: PWideString; receiver: QObjectH; member: PAnsiChar; shortcut: QKeySequenceH = nil): QActionH; cdecl; external Qt5PasLib name 'QMenu_addAction4';
function QMenu_addMenu(handle: QMenuH; menu: QMenuH): QActionH; cdecl; external Qt5PasLib name 'QMenu_addMenu';
function QMenu_addMenu(handle: QMenuH; title: PWideString): QMenuH; cdecl; external Qt5PasLib name 'QMenu_addMenu2';
function QMenu_addMenu(handle: QMenuH; icon: QIconH; title: PWideString): QMenuH; cdecl; external Qt5PasLib name 'QMenu_addMenu3';
function QMenu_addSeparator(handle: QMenuH): QActionH; cdecl; external Qt5PasLib name 'QMenu_addSeparator';
function QMenu_addSection(handle: QMenuH; text: PWideString): QActionH; cdecl; external Qt5PasLib name 'QMenu_addSection';
function QMenu_addSection(handle: QMenuH; icon: QIconH; text: PWideString): QActionH; cdecl; external Qt5PasLib name 'QMenu_addSection2';
function QMenu_insertMenu(handle: QMenuH; before: QActionH; menu: QMenuH): QActionH; cdecl; external Qt5PasLib name 'QMenu_insertMenu';
function QMenu_insertSeparator(handle: QMenuH; before: QActionH): QActionH; cdecl; external Qt5PasLib name 'QMenu_insertSeparator';
function QMenu_insertSection(handle: QMenuH; before: QActionH; text: PWideString): QActionH; cdecl; external Qt5PasLib name 'QMenu_insertSection';
function QMenu_insertSection(handle: QMenuH; before: QActionH; icon: QIconH; text: PWideString): QActionH; cdecl; external Qt5PasLib name 'QMenu_insertSection2';
function QMenu_isEmpty(handle: QMenuH): Boolean; cdecl; external Qt5PasLib name 'QMenu_isEmpty';
procedure QMenu_clear(handle: QMenuH); cdecl; external Qt5PasLib name 'QMenu_clear';
procedure QMenu_setTearOffEnabled(handle: QMenuH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QMenu_setTearOffEnabled';
function QMenu_isTearOffEnabled(handle: QMenuH): Boolean; cdecl; external Qt5PasLib name 'QMenu_isTearOffEnabled';
function QMenu_isTearOffMenuVisible(handle: QMenuH): Boolean; cdecl; external Qt5PasLib name 'QMenu_isTearOffMenuVisible';
procedure QMenu_hideTearOffMenu(handle: QMenuH); cdecl; external Qt5PasLib name 'QMenu_hideTearOffMenu';
procedure QMenu_setDefaultAction(handle: QMenuH; AnonParam1: QActionH); cdecl; external Qt5PasLib name 'QMenu_setDefaultAction';
function QMenu_defaultAction(handle: QMenuH): QActionH; cdecl; external Qt5PasLib name 'QMenu_defaultAction';
procedure QMenu_setActiveAction(handle: QMenuH; act: QActionH); cdecl; external Qt5PasLib name 'QMenu_setActiveAction';
function QMenu_activeAction(handle: QMenuH): QActionH; cdecl; external Qt5PasLib name 'QMenu_activeAction';
procedure QMenu_popup(handle: QMenuH; pos: PQtPoint; at: QActionH = nil); cdecl; external Qt5PasLib name 'QMenu_popup';
function QMenu_exec(handle: QMenuH): QActionH; cdecl; external Qt5PasLib name 'QMenu_exec';
function QMenu_exec(handle: QMenuH; pos: PQtPoint; at: QActionH = nil): QActionH; cdecl; external Qt5PasLib name 'QMenu_exec2';
function QMenu_exec(actions: PPtrIntArray; pos: PQtPoint; at: QActionH = nil; parent: QWidgetH = nil): QActionH; cdecl; external Qt5PasLib name 'QMenu_exec3';
procedure QMenu_sizeHint(handle: QMenuH; retval: PSize); cdecl; external Qt5PasLib name 'QMenu_sizeHint';
procedure QMenu_actionGeometry(handle: QMenuH; retval: PRect; AnonParam1: QActionH); cdecl; external Qt5PasLib name 'QMenu_actionGeometry';
function QMenu_actionAt(handle: QMenuH; AnonParam1: PQtPoint): QActionH; cdecl; external Qt5PasLib name 'QMenu_actionAt';
function QMenu_menuAction(handle: QMenuH): QActionH; cdecl; external Qt5PasLib name 'QMenu_menuAction';
procedure QMenu_title(handle: QMenuH; retval: PWideString); cdecl; external Qt5PasLib name 'QMenu_title';
procedure QMenu_setTitle(handle: QMenuH; title: PWideString); cdecl; external Qt5PasLib name 'QMenu_setTitle';
procedure QMenu_icon(handle: QMenuH; retval: QIconH); cdecl; external Qt5PasLib name 'QMenu_icon';
procedure QMenu_setIcon(handle: QMenuH; icon: QIconH); cdecl; external Qt5PasLib name 'QMenu_setIcon';
procedure QMenu_setNoReplayFor(handle: QMenuH; widget: QWidgetH); cdecl; external Qt5PasLib name 'QMenu_setNoReplayFor';
function QMenu_separatorsCollapsible(handle: QMenuH): Boolean; cdecl; external Qt5PasLib name 'QMenu_separatorsCollapsible';
procedure QMenu_setSeparatorsCollapsible(handle: QMenuH; collapse: Boolean); cdecl; external Qt5PasLib name 'QMenu_setSeparatorsCollapsible';
function QMenu_toolTipsVisible(handle: QMenuH): Boolean; cdecl; external Qt5PasLib name 'QMenu_toolTipsVisible';
procedure QMenu_setToolTipsVisible(handle: QMenuH; visible: Boolean); cdecl; external Qt5PasLib name 'QMenu_setToolTipsVisible';


type
  QMenu_aboutToShow_Event = procedure () of object cdecl;
  QMenu_aboutToHide_Event = procedure () of object cdecl;
  QMenu_triggered_Event = procedure (action: QActionH) of object cdecl;
  QMenu_hovered_Event = procedure (action: QActionH) of object cdecl;


function QMenuBar_Create(parent: QWidgetH = nil): QMenuBarH; cdecl; external Qt5PasLib name 'QMenuBar_Create';
procedure QMenuBar_Destroy(handle: QMenuBarH); cdecl; external Qt5PasLib name 'QMenuBar_Destroy'; 
function QMenuBar_addAction(handle: QMenuBarH; text: PWideString): QActionH; cdecl; external Qt5PasLib name 'QMenuBar_addAction';
function QMenuBar_addAction(handle: QMenuBarH; text: PWideString; receiver: QObjectH; member: PAnsiChar): QActionH; cdecl; external Qt5PasLib name 'QMenuBar_addAction2';
function QMenuBar_addMenu(handle: QMenuBarH; menu: QMenuH): QActionH; cdecl; external Qt5PasLib name 'QMenuBar_addMenu';
function QMenuBar_addMenu(handle: QMenuBarH; title: PWideString): QMenuH; cdecl; external Qt5PasLib name 'QMenuBar_addMenu2';
function QMenuBar_addMenu(handle: QMenuBarH; icon: QIconH; title: PWideString): QMenuH; cdecl; external Qt5PasLib name 'QMenuBar_addMenu3';
function QMenuBar_addSeparator(handle: QMenuBarH): QActionH; cdecl; external Qt5PasLib name 'QMenuBar_addSeparator';
function QMenuBar_insertSeparator(handle: QMenuBarH; before: QActionH): QActionH; cdecl; external Qt5PasLib name 'QMenuBar_insertSeparator';
function QMenuBar_insertMenu(handle: QMenuBarH; before: QActionH; menu: QMenuH): QActionH; cdecl; external Qt5PasLib name 'QMenuBar_insertMenu';
procedure QMenuBar_clear(handle: QMenuBarH); cdecl; external Qt5PasLib name 'QMenuBar_clear';
function QMenuBar_activeAction(handle: QMenuBarH): QActionH; cdecl; external Qt5PasLib name 'QMenuBar_activeAction';
procedure QMenuBar_setActiveAction(handle: QMenuBarH; action: QActionH); cdecl; external Qt5PasLib name 'QMenuBar_setActiveAction';
procedure QMenuBar_setDefaultUp(handle: QMenuBarH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QMenuBar_setDefaultUp';
function QMenuBar_isDefaultUp(handle: QMenuBarH): Boolean; cdecl; external Qt5PasLib name 'QMenuBar_isDefaultUp';
procedure QMenuBar_sizeHint(handle: QMenuBarH; retval: PSize); cdecl; external Qt5PasLib name 'QMenuBar_sizeHint';
procedure QMenuBar_minimumSizeHint(handle: QMenuBarH; retval: PSize); cdecl; external Qt5PasLib name 'QMenuBar_minimumSizeHint';
function QMenuBar_heightForWidth(handle: QMenuBarH; AnonParam1: Integer): Integer; cdecl; external Qt5PasLib name 'QMenuBar_heightForWidth';
procedure QMenuBar_actionGeometry(handle: QMenuBarH; retval: PRect; AnonParam1: QActionH); cdecl; external Qt5PasLib name 'QMenuBar_actionGeometry';
function QMenuBar_actionAt(handle: QMenuBarH; AnonParam1: PQtPoint): QActionH; cdecl; external Qt5PasLib name 'QMenuBar_actionAt';
procedure QMenuBar_setCornerWidget(handle: QMenuBarH; w: QWidgetH; corner: QtCorner = QtTopRightCorner); cdecl; external Qt5PasLib name 'QMenuBar_setCornerWidget';
function QMenuBar_cornerWidget(handle: QMenuBarH; corner: QtCorner = QtTopRightCorner): QWidgetH; cdecl; external Qt5PasLib name 'QMenuBar_cornerWidget';
function QMenuBar_isNativeMenuBar(handle: QMenuBarH): Boolean; cdecl; external Qt5PasLib name 'QMenuBar_isNativeMenuBar';
procedure QMenuBar_setNativeMenuBar(handle: QMenuBarH; nativeMenuBar: Boolean); cdecl; external Qt5PasLib name 'QMenuBar_setNativeMenuBar';
procedure QMenuBar_setVisible(handle: QMenuBarH; visible: Boolean); cdecl; external Qt5PasLib name 'QMenuBar_setVisible';


type
  QMenuBar_triggered_Event = procedure (action: QActionH) of object cdecl;
  QMenuBar_hovered_Event = procedure (action: QActionH) of object cdecl;


function QButtonGroup_Create(parent: QObjectH = nil): QButtonGroupH; cdecl; external Qt5PasLib name 'QButtonGroup_Create';
procedure QButtonGroup_Destroy(handle: QButtonGroupH); cdecl; external Qt5PasLib name 'QButtonGroup_Destroy'; 
procedure QButtonGroup_setExclusive(handle: QButtonGroupH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QButtonGroup_setExclusive';
function QButtonGroup_exclusive(handle: QButtonGroupH): Boolean; cdecl; external Qt5PasLib name 'QButtonGroup_exclusive';
procedure QButtonGroup_addButton(handle: QButtonGroupH; AnonParam1: QAbstractButtonH; id: Integer = -1); cdecl; external Qt5PasLib name 'QButtonGroup_addButton';
procedure QButtonGroup_removeButton(handle: QButtonGroupH; AnonParam1: QAbstractButtonH); cdecl; external Qt5PasLib name 'QButtonGroup_removeButton';
procedure QButtonGroup_buttons(handle: QButtonGroupH; retval: PPtrIntArray); cdecl; external Qt5PasLib name 'QButtonGroup_buttons';
function QButtonGroup_checkedButton(handle: QButtonGroupH): QAbstractButtonH; cdecl; external Qt5PasLib name 'QButtonGroup_checkedButton';
function QButtonGroup_button(handle: QButtonGroupH; id: Integer): QAbstractButtonH; cdecl; external Qt5PasLib name 'QButtonGroup_button';
procedure QButtonGroup_setId(handle: QButtonGroupH; button: QAbstractButtonH; id: Integer); cdecl; external Qt5PasLib name 'QButtonGroup_setId';
function QButtonGroup_id(handle: QButtonGroupH; button: QAbstractButtonH): Integer; cdecl; external Qt5PasLib name 'QButtonGroup_id';
function QButtonGroup_checkedId(handle: QButtonGroupH): Integer; cdecl; external Qt5PasLib name 'QButtonGroup_checkedId';


type
  QButtonGroup_buttonClicked_Event = procedure (AnonParam1: QAbstractButtonH) of object cdecl;
  QButtonGroup_buttonClicked2_Event = procedure (AnonParam1: Integer) of object cdecl;
  QButtonGroup_buttonPressed_Event = procedure (AnonParam1: QAbstractButtonH) of object cdecl;
  QButtonGroup_buttonPressed2_Event = procedure (AnonParam1: Integer) of object cdecl;
  QButtonGroup_buttonReleased_Event = procedure (AnonParam1: QAbstractButtonH) of object cdecl;
  QButtonGroup_buttonReleased2_Event = procedure (AnonParam1: Integer) of object cdecl;


procedure QAbstractButton_setText(handle: QAbstractButtonH; text: PWideString); cdecl; external Qt5PasLib name 'QAbstractButton_setText';
procedure QAbstractButton_text(handle: QAbstractButtonH; retval: PWideString); cdecl; external Qt5PasLib name 'QAbstractButton_text';
procedure QAbstractButton_setIcon(handle: QAbstractButtonH; icon: QIconH); cdecl; external Qt5PasLib name 'QAbstractButton_setIcon';
procedure QAbstractButton_icon(handle: QAbstractButtonH; retval: QIconH); cdecl; external Qt5PasLib name 'QAbstractButton_icon';
procedure QAbstractButton_iconSize(handle: QAbstractButtonH; retval: PSize); cdecl; external Qt5PasLib name 'QAbstractButton_iconSize';
procedure QAbstractButton_setShortcut(handle: QAbstractButtonH; key: QKeySequenceH); cdecl; external Qt5PasLib name 'QAbstractButton_setShortcut';
procedure QAbstractButton_shortcut(handle: QAbstractButtonH; retval: QKeySequenceH); cdecl; external Qt5PasLib name 'QAbstractButton_shortcut';
procedure QAbstractButton_setCheckable(handle: QAbstractButtonH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QAbstractButton_setCheckable';
function QAbstractButton_isCheckable(handle: QAbstractButtonH): Boolean; cdecl; external Qt5PasLib name 'QAbstractButton_isCheckable';
function QAbstractButton_isChecked(handle: QAbstractButtonH): Boolean; cdecl; external Qt5PasLib name 'QAbstractButton_isChecked';
procedure QAbstractButton_setDown(handle: QAbstractButtonH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QAbstractButton_setDown';
function QAbstractButton_isDown(handle: QAbstractButtonH): Boolean; cdecl; external Qt5PasLib name 'QAbstractButton_isDown';
procedure QAbstractButton_setAutoRepeat(handle: QAbstractButtonH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QAbstractButton_setAutoRepeat';
function QAbstractButton_autoRepeat(handle: QAbstractButtonH): Boolean; cdecl; external Qt5PasLib name 'QAbstractButton_autoRepeat';
procedure QAbstractButton_setAutoRepeatDelay(handle: QAbstractButtonH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QAbstractButton_setAutoRepeatDelay';
function QAbstractButton_autoRepeatDelay(handle: QAbstractButtonH): Integer; cdecl; external Qt5PasLib name 'QAbstractButton_autoRepeatDelay';
procedure QAbstractButton_setAutoRepeatInterval(handle: QAbstractButtonH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QAbstractButton_setAutoRepeatInterval';
function QAbstractButton_autoRepeatInterval(handle: QAbstractButtonH): Integer; cdecl; external Qt5PasLib name 'QAbstractButton_autoRepeatInterval';
procedure QAbstractButton_setAutoExclusive(handle: QAbstractButtonH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QAbstractButton_setAutoExclusive';
function QAbstractButton_autoExclusive(handle: QAbstractButtonH): Boolean; cdecl; external Qt5PasLib name 'QAbstractButton_autoExclusive';
function QAbstractButton_group(handle: QAbstractButtonH): QButtonGroupH; cdecl; external Qt5PasLib name 'QAbstractButton_group';
procedure QAbstractButton_setIconSize(handle: QAbstractButtonH; size: PSize); cdecl; external Qt5PasLib name 'QAbstractButton_setIconSize';
procedure QAbstractButton_animateClick(handle: QAbstractButtonH; msec: Integer = 100); cdecl; external Qt5PasLib name 'QAbstractButton_animateClick';
procedure QAbstractButton_click(handle: QAbstractButtonH); cdecl; external Qt5PasLib name 'QAbstractButton_click';
procedure QAbstractButton_toggle(handle: QAbstractButtonH); cdecl; external Qt5PasLib name 'QAbstractButton_toggle';
procedure QAbstractButton_setChecked(handle: QAbstractButtonH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QAbstractButton_setChecked';


type
  QAbstractButton_pressed_Event = procedure () of object cdecl;
  QAbstractButton_released_Event = procedure () of object cdecl;
  QAbstractButton_clicked_Event = procedure (checked: Boolean = False) of object cdecl;
  QAbstractButton_clicked2_Event = procedure () of object cdecl;
  QAbstractButton_toggled_Event = procedure (checked: Boolean) of object cdecl;


function QPushButton_Create(parent: QWidgetH = nil): QPushButtonH; cdecl; external Qt5PasLib name 'QPushButton_Create';
procedure QPushButton_Destroy(handle: QPushButtonH); cdecl; external Qt5PasLib name 'QPushButton_Destroy'; 
function QPushButton_Create(text: PWideString; parent: QWidgetH = nil): QPushButtonH; cdecl; external Qt5PasLib name 'QPushButton_Create2';
function QPushButton_Create(icon: QIconH; text: PWideString; parent: QWidgetH = nil): QPushButtonH; cdecl; external Qt5PasLib name 'QPushButton_Create3';
procedure QPushButton_sizeHint(handle: QPushButtonH; retval: PSize); cdecl; external Qt5PasLib name 'QPushButton_sizeHint';
procedure QPushButton_minimumSizeHint(handle: QPushButtonH; retval: PSize); cdecl; external Qt5PasLib name 'QPushButton_minimumSizeHint';
function QPushButton_autoDefault(handle: QPushButtonH): Boolean; cdecl; external Qt5PasLib name 'QPushButton_autoDefault';
procedure QPushButton_setAutoDefault(handle: QPushButtonH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QPushButton_setAutoDefault';
function QPushButton_isDefault(handle: QPushButtonH): Boolean; cdecl; external Qt5PasLib name 'QPushButton_isDefault';
procedure QPushButton_setDefault(handle: QPushButtonH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QPushButton_setDefault';
procedure QPushButton_setMenu(handle: QPushButtonH; menu: QMenuH); cdecl; external Qt5PasLib name 'QPushButton_setMenu';
function QPushButton_menu(handle: QPushButtonH): QMenuH; cdecl; external Qt5PasLib name 'QPushButton_menu';
procedure QPushButton_setFlat(handle: QPushButtonH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QPushButton_setFlat';
function QPushButton_isFlat(handle: QPushButtonH): Boolean; cdecl; external Qt5PasLib name 'QPushButton_isFlat';
procedure QPushButton_showMenu(handle: QPushButtonH); cdecl; external Qt5PasLib name 'QPushButton_showMenu';

function QRadioButton_Create(parent: QWidgetH = nil): QRadioButtonH; cdecl; external Qt5PasLib name 'QRadioButton_Create';
procedure QRadioButton_Destroy(handle: QRadioButtonH); cdecl; external Qt5PasLib name 'QRadioButton_Destroy'; 
function QRadioButton_Create(text: PWideString; parent: QWidgetH = nil): QRadioButtonH; cdecl; external Qt5PasLib name 'QRadioButton_Create2';
procedure QRadioButton_sizeHint(handle: QRadioButtonH; retval: PSize); cdecl; external Qt5PasLib name 'QRadioButton_sizeHint';
procedure QRadioButton_minimumSizeHint(handle: QRadioButtonH; retval: PSize); cdecl; external Qt5PasLib name 'QRadioButton_minimumSizeHint';

type
  QCompleter_activated_Event = procedure (aIndex: QModelIndexH) of object cdecl;
  QCompleter_activated2_Event = procedure (aText: PWideString) of object cdecl;
  QCompleter_highlighted_Event = procedure (aIndex: QModelIndexH) of object cdecl;
  QCompleter_highlighted2_Event = procedure (aText: PWideString) of object cdecl;

type
  QCompleterCompletionMode = (QCompleterPopupCompletion, QCompleterUnfilteredPopupCompletion, QCompleterInlineCompletion);
  QCompleterModelSorting = (QCompleterUnsortedModel, QCompleterCaseSensitiveSortedModel, QCompleterCaseInsensitivelySortedModel);

function QCompleter_Create(): QCompleterH; cdecl; external Qt5PasLib name 'QCompleter_Create';
function QCompleter_Create2(parent: QObjectH): QCompleterH; cdecl; external Qt5PasLib name 'QCompleter_Create2';
function QCompleter_Create3(model: QAbstractItemModelH; parent: QObjectH): QCompleterH; cdecl; external Qt5PasLib name 'QCompleter_Create3';
function QCompleter_Create4(list: QStringListH; parent: QObjectH): QCompleterH; cdecl; external Qt5PasLib name 'QCompleter_Create4';
procedure QCompleter_Destroy(handle: QCompleterH); cdecl; external Qt5PasLib name 'QCompleter_Destroy';
function QCompleter_caseSensitivity(handle: QCompleterH): QtCaseSensitivity; cdecl; external Qt5PasLib name 'QCompleter_caseSensitivity';
function QCompleter_completionColumn(handle: QCompleterH): integer; cdecl; external Qt5PasLib name 'QCompleter_completionColumn';
function QCompleter_completionCount(handle: QCompleterH): integer; cdecl; external Qt5PasLib name 'QCompleter_completionCount';
function QCompleter_completionMode(handle: QCompleterH): QCompleterCompletionMode; cdecl; external Qt5PasLib name 'QCompleter_completionMode';
function QCompleter_completionModel(handle: QCompleterH): QAbstractItemModelH; cdecl; external Qt5PasLib name 'QCompleter_completionModel';
procedure QCompleter_completionPrefix(handle: QCompleterH; retval: PWideString); cdecl; external Qt5PasLib name 'QCompleter_completionPrefix';
function QCompleter_completionRole(handle: QCompleterH): integer; cdecl; external Qt5PasLib name 'QCompleter_completionRole';
procedure QCompleter_currentCompletion(handle: QCompleterH; retval: PWideString); cdecl; external Qt5PasLib name 'QCompleter_currentCompletion';
procedure QCompleter_currentIndex(handle: QCompleterH; retval: QModelIndexH); cdecl; external Qt5PasLib name 'QCompleter_currentIndex';
function QCompleter_currentRow(handle: QCompleterH): integer; cdecl; external Qt5PasLib name 'QCompleter_currentRow';
function QCompleter_filterMode(handle: QCompleterH): QtMatchFlags; cdecl; external Qt5PasLib name 'QCompleter_filterMode';
function QCompleter_maxVisibleItems(handle: QCompleterH): integer; cdecl; external Qt5PasLib name 'QCompleter_maxVisibleItems';
function QCompleter_model(handle: QCompleterH): QAbstractItemModelH; cdecl; external Qt5PasLib name 'QCompleter_model';
function QCompleter_modelSorting(handle: QCompleterH): QCompleterModelSorting; cdecl; external Qt5PasLib name 'QCompleter_modelSorting';
procedure QCompleter_pathFromIndex(handle: QCompleterH; aModel: QModelIndexH; retval: PWideString); cdecl; external Qt5PasLib name 'QCompleter_pathFromIndex';
function QCompleter_popup(handle: QCompleterH): QAbstractItemViewH; cdecl; external Qt5PasLib name 'QCompleter_popup';
procedure QCompleter_setCaseSensitivity(handle: QCompleterH; aCaseSensitivity: QtCaseSensitivity); cdecl; external Qt5PasLib name 'setCaseSensitivity';
procedure QCompleter_setCompletionColumn(handle: QCompleterH; aColumn: integer); cdecl; external Qt5PasLib name 'QCompleter_setCompletionColumn';
procedure QCompleter_setCompletionMode(handle: QCompleterH; aMode: QCompleterCompletionMode); cdecl; external Qt5PasLib name 'QCompleter_setCompletionMode';
procedure QCompleter_setCompletionRole(handle: QCompleterH; aRole: integer); cdecl; external Qt5PasLib name 'QCompleter_setCompletionRole';
procedure QCompleter_setCurrentRow(handle: QCompleterH; aRow: integer); cdecl; external Qt5PasLib name 'QCompleter_setCurrentRow';
procedure QCompleter_setFilterMode(handle: QCompleterH; aFilterMode: QtMatchFlags); cdecl; external Qt5PasLib name 'QCompleter_setFilterMode';
procedure QCompleter_setMaxVisibleItems(handle: QCompleterH; aMaxItems: integer); cdecl; external Qt5PasLib name 'QCompleter_setMaxVisibleItems';
procedure QCompleter_setModel(handle: QCompleterH; aModel: QAbstractItemModelH); cdecl; external Qt5PasLib name 'QCompleter_setModel';
procedure QCompleter_setModelSorting(handle: QCompleterH; aSorting: QCompleterModelSorting); cdecl; external Qt5PasLib name 'QCompleter_setModelSorting';
procedure QCompleter_setPopup(handle: QCompleterH; aPopup: QAbstractItemViewH); cdecl; external Qt5PasLib name 'QCompleter_setPopup';
procedure QCompleter_setWidget(handle: QCompleterH; aWidget: QWidgetH); cdecl; external Qt5PasLib name 'QCompleter_setWidget';
procedure QCompleter_splitPath(handle: QCompleterH; aPath: PWideString; retval: QStringListH); cdecl; external Qt5PasLib name 'QCompleter_splitPath';
function QCompleter_widget(handle: QCompleterH):QWidgetH; cdecl; external Qt5PasLib name 'QCompleter_widget';
function QCompleter_wrapAround(handle: QCompleterH): boolean; cdecl; external Qt5PasLib name 'QCompleter_wrapAround';
procedure QCompleter_complete(handle: QCompleterH; r: PRect); cdecl; external Qt5PasLib name 'QCompleter_complete';
procedure QCompleter_setCompletionPrefix(handle: QCompleterH; aPrefix: PWideString); cdecl; external Qt5PasLib name 'QCompleter_setCompletionPrefix';
procedure QCompleter_setWrapAround(handle: QCompleterH; aWrap: boolean); cdecl; external Qt5PasLib name 'QCompleter_setWrapAround';

type
  QLineEditEchoMode = ( // QLineEdit::EchoMode (1)
    QLineEditNormal, QLineEditNoEcho, QLineEditPassword, QLineEditPasswordEchoOnEdit );

function QLineEdit_Create(parent: QWidgetH = nil): QLineEditH; cdecl; external Qt5PasLib name 'QLineEdit_Create';
procedure QLineEdit_Destroy(handle: QLineEditH); cdecl; external Qt5PasLib name 'QLineEdit_Destroy'; 
function QLineEdit_Create(AnonParam1: PWideString; parent: QWidgetH = nil): QLineEditH; cdecl; external Qt5PasLib name 'QLineEdit_Create2';
procedure QLineEdit_text(handle: QLineEditH; retval: PWideString); cdecl; external Qt5PasLib name 'QLineEdit_text';
procedure QLineEdit_displayText(handle: QLineEditH; retval: PWideString); cdecl; external Qt5PasLib name 'QLineEdit_displayText';
procedure QLineEdit_placeholderText(handle: QLineEditH; retval: PWideString); cdecl; external Qt5PasLib name 'QLineEdit_placeholderText';
procedure QLineEdit_setPlaceholderText(handle: QLineEditH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QLineEdit_setPlaceholderText';
function QLineEdit_maxLength(handle: QLineEditH): Integer; cdecl; external Qt5PasLib name 'QLineEdit_maxLength';
procedure QLineEdit_setMaxLength(handle: QLineEditH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QLineEdit_setMaxLength';
procedure QLineEdit_setFrame(handle: QLineEditH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QLineEdit_setFrame';
function QLineEdit_hasFrame(handle: QLineEditH): Boolean; cdecl; external Qt5PasLib name 'QLineEdit_hasFrame';
function QLineEdit_echoMode(handle: QLineEditH): QLineEditEchoMode; cdecl; external Qt5PasLib name 'QLineEdit_echoMode';
procedure QLineEdit_setEchoMode(handle: QLineEditH; AnonParam1: QLineEditEchoMode); cdecl; external Qt5PasLib name 'QLineEdit_setEchoMode';
function QLineEdit_isReadOnly(handle: QLineEditH): Boolean; cdecl; external Qt5PasLib name 'QLineEdit_isReadOnly';
procedure QLineEdit_setReadOnly(handle: QLineEditH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QLineEdit_setReadOnly';
procedure QLineEdit_setValidator(handle: QLineEditH; AnonParam1: QValidatorH); cdecl; external Qt5PasLib name 'QLineEdit_setValidator';
function QLineEdit_validator(handle: QLineEditH): QValidatorH; cdecl; external Qt5PasLib name 'QLineEdit_validator';
procedure QLineEdit_setCompleter(handle: QLineEditH; completer: QCompleterH); cdecl; external Qt5PasLib name 'QLineEdit_setCompleter';
function QLineEdit_completer(handle: QLineEditH): QCompleterH; cdecl; external Qt5PasLib name 'QLineEdit_completer';
procedure QLineEdit_sizeHint(handle: QLineEditH; retval: PSize); cdecl; external Qt5PasLib name 'QLineEdit_sizeHint';
procedure QLineEdit_minimumSizeHint(handle: QLineEditH; retval: PSize); cdecl; external Qt5PasLib name 'QLineEdit_minimumSizeHint';
function QLineEdit_cursorPosition(handle: QLineEditH): Integer; cdecl; external Qt5PasLib name 'QLineEdit_cursorPosition';
procedure QLineEdit_setCursorPosition(handle: QLineEditH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QLineEdit_setCursorPosition';
function QLineEdit_cursorPositionAt(handle: QLineEditH; pos: PQtPoint): Integer; cdecl; external Qt5PasLib name 'QLineEdit_cursorPositionAt';
procedure QLineEdit_setAlignment(handle: QLineEditH; flag: QtAlignment); cdecl; external Qt5PasLib name 'QLineEdit_setAlignment';
function QLineEdit_alignment(handle: QLineEditH): QtAlignment; cdecl; external Qt5PasLib name 'QLineEdit_alignment';
procedure QLineEdit_cursorForward(handle: QLineEditH; mark: Boolean; steps: Integer = 1); cdecl; external Qt5PasLib name 'QLineEdit_cursorForward';
procedure QLineEdit_cursorBackward(handle: QLineEditH; mark: Boolean; steps: Integer = 1); cdecl; external Qt5PasLib name 'QLineEdit_cursorBackward';
procedure QLineEdit_cursorWordForward(handle: QLineEditH; mark: Boolean); cdecl; external Qt5PasLib name 'QLineEdit_cursorWordForward';
procedure QLineEdit_cursorWordBackward(handle: QLineEditH; mark: Boolean); cdecl; external Qt5PasLib name 'QLineEdit_cursorWordBackward';
procedure QLineEdit_backspace(handle: QLineEditH); cdecl; external Qt5PasLib name 'QLineEdit_backspace';
procedure QLineEdit_del(handle: QLineEditH); cdecl; external Qt5PasLib name 'QLineEdit_del';
procedure QLineEdit_home(handle: QLineEditH; mark: Boolean); cdecl; external Qt5PasLib name 'QLineEdit_home';
procedure QLineEdit_end(handle: QLineEditH; mark: Boolean); cdecl; external Qt5PasLib name 'QLineEdit_end';
function QLineEdit_isModified(handle: QLineEditH): Boolean; cdecl; external Qt5PasLib name 'QLineEdit_isModified';
procedure QLineEdit_setModified(handle: QLineEditH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QLineEdit_setModified';
procedure QLineEdit_setSelection(handle: QLineEditH; AnonParam1: Integer; AnonParam2: Integer); cdecl; external Qt5PasLib name 'QLineEdit_setSelection';
function QLineEdit_hasSelectedText(handle: QLineEditH): Boolean; cdecl; external Qt5PasLib name 'QLineEdit_hasSelectedText';
procedure QLineEdit_selectedText(handle: QLineEditH; retval: PWideString); cdecl; external Qt5PasLib name 'QLineEdit_selectedText';
function QLineEdit_selectionStart(handle: QLineEditH): Integer; cdecl; external Qt5PasLib name 'QLineEdit_selectionStart';
function QLineEdit_isUndoAvailable(handle: QLineEditH): Boolean; cdecl; external Qt5PasLib name 'QLineEdit_isUndoAvailable';
function QLineEdit_isRedoAvailable(handle: QLineEditH): Boolean; cdecl; external Qt5PasLib name 'QLineEdit_isRedoAvailable';
procedure QLineEdit_setDragEnabled(handle: QLineEditH; b: Boolean); cdecl; external Qt5PasLib name 'QLineEdit_setDragEnabled';
function QLineEdit_dragEnabled(handle: QLineEditH): Boolean; cdecl; external Qt5PasLib name 'QLineEdit_dragEnabled';
procedure QLineEdit_setCursorMoveStyle(handle: QLineEditH; style: QtCursorMoveStyle); cdecl; external Qt5PasLib name 'QLineEdit_setCursorMoveStyle';
function QLineEdit_cursorMoveStyle(handle: QLineEditH): QtCursorMoveStyle; cdecl; external Qt5PasLib name 'QLineEdit_cursorMoveStyle';
procedure QLineEdit_inputMask(handle: QLineEditH; retval: PWideString); cdecl; external Qt5PasLib name 'QLineEdit_inputMask';
procedure QLineEdit_setInputMask(handle: QLineEditH; inputMask: PWideString); cdecl; external Qt5PasLib name 'QLineEdit_setInputMask';
function QLineEdit_hasAcceptableInput(handle: QLineEditH): Boolean; cdecl; external Qt5PasLib name 'QLineEdit_hasAcceptableInput';
procedure QLineEdit_setTextMargins(handle: QLineEditH; left: Integer; top: Integer; right: Integer; bottom: Integer); cdecl; external Qt5PasLib name 'QLineEdit_setTextMargins';
procedure QLineEdit_setTextMargins(handle: QLineEditH; margins: QMarginsH); cdecl; external Qt5PasLib name 'QLineEdit_setTextMargins2';
procedure QLineEdit_getTextMargins(handle: QLineEditH; left: PInteger; top: PInteger; right: PInteger; bottom: PInteger); cdecl; external Qt5PasLib name 'QLineEdit_getTextMargins';
procedure QLineEdit_textMargins(handle: QLineEditH; retval: QMarginsH); cdecl; external Qt5PasLib name 'QLineEdit_textMargins';
procedure QLineEdit_setText(handle: QLineEditH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QLineEdit_setText';
procedure QLineEdit_clear(handle: QLineEditH); cdecl; external Qt5PasLib name 'QLineEdit_clear';
procedure QLineEdit_selectAll(handle: QLineEditH); cdecl; external Qt5PasLib name 'QLineEdit_selectAll';
procedure QLineEdit_undo(handle: QLineEditH); cdecl; external Qt5PasLib name 'QLineEdit_undo';
procedure QLineEdit_redo(handle: QLineEditH); cdecl; external Qt5PasLib name 'QLineEdit_redo';
procedure QLineEdit_cut(handle: QLineEditH); cdecl; external Qt5PasLib name 'QLineEdit_cut';
procedure QLineEdit_copy(handle: QLineEditH); cdecl; external Qt5PasLib name 'QLineEdit_copy';
procedure QLineEdit_paste(handle: QLineEditH); cdecl; external Qt5PasLib name 'QLineEdit_paste';
procedure QLineEdit_deselect(handle: QLineEditH); cdecl; external Qt5PasLib name 'QLineEdit_deselect';
procedure QLineEdit_insert(handle: QLineEditH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QLineEdit_insert';
function QLineEdit_createStandardContextMenu(handle: QLineEditH): QMenuH; cdecl; external Qt5PasLib name 'QLineEdit_createStandardContextMenu';
procedure QLineEdit_inputMethodQuery(handle: QLineEditH; retval: QVariantH; AnonParam1: QtInputMethodQuery); cdecl; external Qt5PasLib name 'QLineEdit_inputMethodQuery';
function QLineEdit_event(handle: QLineEditH; AnonParam1: QEventH): Boolean; cdecl; external Qt5PasLib name 'QLineEdit_event';


type
  QLineEdit_textChanged_Event = procedure (AnonParam1: PWideString) of object cdecl;
  QLineEdit_textEdited_Event = procedure (AnonParam1: PWideString) of object cdecl;
  QLineEdit_cursorPositionChanged_Event = procedure (AnonParam1: Integer; AnonParam2: Integer) of object cdecl;
  QLineEdit_returnPressed_Event = procedure () of object cdecl;
  QLineEdit_editingFinished_Event = procedure () of object cdecl;
  QLineEdit_selectionChanged_Event = procedure () of object cdecl;



type
  QPlainTextEditLineWrapMode = ( // QPlainTextEdit::LineWrapMode (1)
    QPlainTextEditNoWrap, QPlainTextEditWidgetWidth );

function QPlainTextEdit_Create(parent: QWidgetH = nil): QPlainTextEditH; cdecl; external Qt5PasLib name 'QPlainTextEdit_Create';
procedure QPlainTextEdit_Destroy(handle: QPlainTextEditH); cdecl; external Qt5PasLib name 'QPlainTextEdit_Destroy'; 
function QPlainTextEdit_Create(text: PWideString; parent: QWidgetH = nil): QPlainTextEditH; cdecl; external Qt5PasLib name 'QPlainTextEdit_Create2';
procedure QPlainTextEdit_setDocument(handle: QPlainTextEditH; document: QTextDocumentH); cdecl; external Qt5PasLib name 'QPlainTextEdit_setDocument';
function QPlainTextEdit_document(handle: QPlainTextEditH): QTextDocumentH; cdecl; external Qt5PasLib name 'QPlainTextEdit_document';
procedure QPlainTextEdit_setTextCursor(handle: QPlainTextEditH; cursor: QTextCursorH); cdecl; external Qt5PasLib name 'QPlainTextEdit_setTextCursor';
procedure QPlainTextEdit_textCursor(handle: QPlainTextEditH; retval: QTextCursorH); cdecl; external Qt5PasLib name 'QPlainTextEdit_textCursor';
function QPlainTextEdit_isReadOnly(handle: QPlainTextEditH): Boolean; cdecl; external Qt5PasLib name 'QPlainTextEdit_isReadOnly';
procedure QPlainTextEdit_setReadOnly(handle: QPlainTextEditH; ro: Boolean); cdecl; external Qt5PasLib name 'QPlainTextEdit_setReadOnly';
procedure QPlainTextEdit_setTextInteractionFlags(handle: QPlainTextEditH; flags: QtTextInteractionFlags); cdecl; external Qt5PasLib name 'QPlainTextEdit_setTextInteractionFlags';
function QPlainTextEdit_textInteractionFlags(handle: QPlainTextEditH): QtTextInteractionFlags; cdecl; external Qt5PasLib name 'QPlainTextEdit_textInteractionFlags';
procedure QPlainTextEdit_mergeCurrentCharFormat(handle: QPlainTextEditH; modifier: QTextCharFormatH); cdecl; external Qt5PasLib name 'QPlainTextEdit_mergeCurrentCharFormat';
procedure QPlainTextEdit_setCurrentCharFormat(handle: QPlainTextEditH; format: QTextCharFormatH); cdecl; external Qt5PasLib name 'QPlainTextEdit_setCurrentCharFormat';
procedure QPlainTextEdit_currentCharFormat(handle: QPlainTextEditH; retval: QTextCharFormatH); cdecl; external Qt5PasLib name 'QPlainTextEdit_currentCharFormat';
function QPlainTextEdit_tabChangesFocus(handle: QPlainTextEditH): Boolean; cdecl; external Qt5PasLib name 'QPlainTextEdit_tabChangesFocus';
procedure QPlainTextEdit_setTabChangesFocus(handle: QPlainTextEditH; b: Boolean); cdecl; external Qt5PasLib name 'QPlainTextEdit_setTabChangesFocus';
procedure QPlainTextEdit_setDocumentTitle(handle: QPlainTextEditH; title: PWideString); cdecl; external Qt5PasLib name 'QPlainTextEdit_setDocumentTitle';
procedure QPlainTextEdit_documentTitle(handle: QPlainTextEditH; retval: PWideString); cdecl; external Qt5PasLib name 'QPlainTextEdit_documentTitle';
function QPlainTextEdit_isUndoRedoEnabled(handle: QPlainTextEditH): Boolean; cdecl; external Qt5PasLib name 'QPlainTextEdit_isUndoRedoEnabled';
procedure QPlainTextEdit_setUndoRedoEnabled(handle: QPlainTextEditH; enable: Boolean); cdecl; external Qt5PasLib name 'QPlainTextEdit_setUndoRedoEnabled';
procedure QPlainTextEdit_setMaximumBlockCount(handle: QPlainTextEditH; maximum: Integer); cdecl; external Qt5PasLib name 'QPlainTextEdit_setMaximumBlockCount';
function QPlainTextEdit_maximumBlockCount(handle: QPlainTextEditH): Integer; cdecl; external Qt5PasLib name 'QPlainTextEdit_maximumBlockCount';
function QPlainTextEdit_lineWrapMode(handle: QPlainTextEditH): QPlainTextEditLineWrapMode; cdecl; external Qt5PasLib name 'QPlainTextEdit_lineWrapMode';
procedure QPlainTextEdit_setLineWrapMode(handle: QPlainTextEditH; mode: QPlainTextEditLineWrapMode); cdecl; external Qt5PasLib name 'QPlainTextEdit_setLineWrapMode';
function QPlainTextEdit_wordWrapMode(handle: QPlainTextEditH): QTextOptionWrapMode; cdecl; external Qt5PasLib name 'QPlainTextEdit_wordWrapMode';
procedure QPlainTextEdit_setWordWrapMode(handle: QPlainTextEditH; policy: QTextOptionWrapMode); cdecl; external Qt5PasLib name 'QPlainTextEdit_setWordWrapMode';
procedure QPlainTextEdit_setBackgroundVisible(handle: QPlainTextEditH; visible: Boolean); cdecl; external Qt5PasLib name 'QPlainTextEdit_setBackgroundVisible';
function QPlainTextEdit_backgroundVisible(handle: QPlainTextEditH): Boolean; cdecl; external Qt5PasLib name 'QPlainTextEdit_backgroundVisible';
procedure QPlainTextEdit_setCenterOnScroll(handle: QPlainTextEditH; enabled: Boolean); cdecl; external Qt5PasLib name 'QPlainTextEdit_setCenterOnScroll';
function QPlainTextEdit_centerOnScroll(handle: QPlainTextEditH): Boolean; cdecl; external Qt5PasLib name 'QPlainTextEdit_centerOnScroll';
function QPlainTextEdit_find(handle: QPlainTextEditH; exp: PWideString; options: QTextDocumentFindFlags = 0): Boolean; cdecl; external Qt5PasLib name 'QPlainTextEdit_find';
procedure QPlainTextEdit_toPlainText(handle: QPlainTextEditH; retval: PWideString); cdecl; external Qt5PasLib name 'QPlainTextEdit_toPlainText';
procedure QPlainTextEdit_ensureCursorVisible(handle: QPlainTextEditH); cdecl; external Qt5PasLib name 'QPlainTextEdit_ensureCursorVisible';
procedure QPlainTextEdit_loadResource(handle: QPlainTextEditH; retval: QVariantH; _type: Integer; name: QUrlH); cdecl; external Qt5PasLib name 'QPlainTextEdit_loadResource';
function QPlainTextEdit_createStandardContextMenu(handle: QPlainTextEditH): QMenuH; cdecl; external Qt5PasLib name 'QPlainTextEdit_createStandardContextMenu';
procedure QPlainTextEdit_cursorForPosition(handle: QPlainTextEditH; retval: QTextCursorH; pos: PQtPoint); cdecl; external Qt5PasLib name 'QPlainTextEdit_cursorForPosition';
procedure QPlainTextEdit_cursorRect(handle: QPlainTextEditH; retval: PRect; cursor: QTextCursorH); cdecl; external Qt5PasLib name 'QPlainTextEdit_cursorRect';
procedure QPlainTextEdit_cursorRect(handle: QPlainTextEditH; retval: PRect); cdecl; external Qt5PasLib name 'QPlainTextEdit_cursorRect2';
procedure QPlainTextEdit_anchorAt(handle: QPlainTextEditH; retval: PWideString; pos: PQtPoint); cdecl; external Qt5PasLib name 'QPlainTextEdit_anchorAt';
function QPlainTextEdit_overwriteMode(handle: QPlainTextEditH): Boolean; cdecl; external Qt5PasLib name 'QPlainTextEdit_overwriteMode';
procedure QPlainTextEdit_setOverwriteMode(handle: QPlainTextEditH; overwrite: Boolean); cdecl; external Qt5PasLib name 'QPlainTextEdit_setOverwriteMode';
function QPlainTextEdit_tabStopWidth(handle: QPlainTextEditH): Integer; cdecl; external Qt5PasLib name 'QPlainTextEdit_tabStopWidth';
procedure QPlainTextEdit_setTabStopWidth(handle: QPlainTextEditH; width: Integer); cdecl; external Qt5PasLib name 'QPlainTextEdit_setTabStopWidth';
function QPlainTextEdit_cursorWidth(handle: QPlainTextEditH): Integer; cdecl; external Qt5PasLib name 'QPlainTextEdit_cursorWidth';
procedure QPlainTextEdit_setCursorWidth(handle: QPlainTextEditH; width: Integer); cdecl; external Qt5PasLib name 'QPlainTextEdit_setCursorWidth';
procedure QPlainTextEdit_moveCursor(handle: QPlainTextEditH; operation: QTextCursorMoveOperation; mode: QTextCursorMoveMode = QTextCursorMoveAnchor); cdecl; external Qt5PasLib name 'QPlainTextEdit_moveCursor';
function QPlainTextEdit_canPaste(handle: QPlainTextEditH): Boolean; cdecl; external Qt5PasLib name 'QPlainTextEdit_canPaste';
procedure QPlainTextEdit_print(handle: QPlainTextEditH; printer: QPagedPaintDeviceH); cdecl; external Qt5PasLib name 'QPlainTextEdit_print';
function QPlainTextEdit_blockCount(handle: QPlainTextEditH): Integer; cdecl; external Qt5PasLib name 'QPlainTextEdit_blockCount';
procedure QPlainTextEdit_inputMethodQuery(handle: QPlainTextEditH; retval: QVariantH; _property: QtInputMethodQuery); cdecl; external Qt5PasLib name 'QPlainTextEdit_inputMethodQuery';
procedure QPlainTextEdit_setPlainText(handle: QPlainTextEditH; text: PWideString); cdecl; external Qt5PasLib name 'QPlainTextEdit_setPlainText';
procedure QPlainTextEdit_cut(handle: QPlainTextEditH); cdecl; external Qt5PasLib name 'QPlainTextEdit_cut';
procedure QPlainTextEdit_copy(handle: QPlainTextEditH); cdecl; external Qt5PasLib name 'QPlainTextEdit_copy';
procedure QPlainTextEdit_paste(handle: QPlainTextEditH); cdecl; external Qt5PasLib name 'QPlainTextEdit_paste';
procedure QPlainTextEdit_undo(handle: QPlainTextEditH); cdecl; external Qt5PasLib name 'QPlainTextEdit_undo';
procedure QPlainTextEdit_redo(handle: QPlainTextEditH); cdecl; external Qt5PasLib name 'QPlainTextEdit_redo';
procedure QPlainTextEdit_clear(handle: QPlainTextEditH); cdecl; external Qt5PasLib name 'QPlainTextEdit_clear';
procedure QPlainTextEdit_selectAll(handle: QPlainTextEditH); cdecl; external Qt5PasLib name 'QPlainTextEdit_selectAll';
procedure QPlainTextEdit_insertPlainText(handle: QPlainTextEditH; text: PWideString); cdecl; external Qt5PasLib name 'QPlainTextEdit_insertPlainText';
procedure QPlainTextEdit_appendPlainText(handle: QPlainTextEditH; text: PWideString); cdecl; external Qt5PasLib name 'QPlainTextEdit_appendPlainText';
procedure QPlainTextEdit_appendHtml(handle: QPlainTextEditH; html: PWideString); cdecl; external Qt5PasLib name 'QPlainTextEdit_appendHtml';
procedure QPlainTextEdit_centerCursor(handle: QPlainTextEditH); cdecl; external Qt5PasLib name 'QPlainTextEdit_centerCursor';
procedure QPlainTextEdit_zoomIn(handle: QPlainTextEditH; range: Integer = 1); cdecl; external Qt5PasLib name 'QPlainTextEdit_zoomIn';
procedure QPlainTextEdit_zoomOut(handle: QPlainTextEditH; range: Integer = 1); cdecl; external Qt5PasLib name 'QPlainTextEdit_zoomOut';
procedure QPlainTextEdit_placeholderText(handle: QPlainTextEditH; retval: PWideString); cdecl; external Qt5PasLib name 'QPlainTextEdit_placeholderText';
procedure QPlainTextEdit_setPlaceholderText(handle: QPlainTextEditH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QPlainTextEdit_setPlaceholderText';

function QPlainTextDocumentLayout_Create(document: QTextDocumentH): QPlainTextDocumentLayoutH; cdecl; external Qt5PasLib name 'QPlainTextDocumentLayout_Create';
procedure QPlainTextDocumentLayout_Destroy(handle: QPlainTextDocumentLayoutH); cdecl; external Qt5PasLib name 'QPlainTextDocumentLayout_Destroy'; 
function QPlainTextDocumentLayout_hitTest(handle: QPlainTextDocumentLayoutH; AnonParam1: PQtPointF; AnonParam2: QtHitTestAccuracy): Integer; cdecl; external Qt5PasLib name 'QPlainTextDocumentLayout_hitTest';
function QPlainTextDocumentLayout_pageCount(handle: QPlainTextDocumentLayoutH): Integer; cdecl; external Qt5PasLib name 'QPlainTextDocumentLayout_pageCount';
procedure QPlainTextDocumentLayout_documentSize(handle: QPlainTextDocumentLayoutH; retval: QSizeFH); cdecl; external Qt5PasLib name 'QPlainTextDocumentLayout_documentSize';
procedure QPlainTextDocumentLayout_frameBoundingRect(handle: QPlainTextDocumentLayoutH; retval: QRectFH; AnonParam1: QTextFrameH); cdecl; external Qt5PasLib name 'QPlainTextDocumentLayout_frameBoundingRect';
procedure QPlainTextDocumentLayout_blockBoundingRect(handle: QPlainTextDocumentLayoutH; retval: QRectFH; block: QTextBlockH); cdecl; external Qt5PasLib name 'QPlainTextDocumentLayout_blockBoundingRect';
procedure QPlainTextDocumentLayout_ensureBlockLayout(handle: QPlainTextDocumentLayoutH; block: QTextBlockH); cdecl; external Qt5PasLib name 'QPlainTextDocumentLayout_ensureBlockLayout';
procedure QPlainTextDocumentLayout_setCursorWidth(handle: QPlainTextDocumentLayoutH; width: Integer); cdecl; external Qt5PasLib name 'QPlainTextDocumentLayout_setCursorWidth';
function QPlainTextDocumentLayout_cursorWidth(handle: QPlainTextDocumentLayoutH): Integer; cdecl; external Qt5PasLib name 'QPlainTextDocumentLayout_cursorWidth';
procedure QPlainTextDocumentLayout_requestUpdate(handle: QPlainTextDocumentLayoutH); cdecl; external Qt5PasLib name 'QPlainTextDocumentLayout_requestUpdate';


type
  QPlainTextEdit_textChanged_Event = procedure () of object cdecl;
  QPlainTextEdit_undoAvailable_Event = procedure (b: Boolean) of object cdecl;
  QPlainTextEdit_redoAvailable_Event = procedure (b: Boolean) of object cdecl;
  QPlainTextEdit_copyAvailable_Event = procedure (b: Boolean) of object cdecl;
  QPlainTextEdit_selectionChanged_Event = procedure () of object cdecl;
  QPlainTextEdit_cursorPositionChanged_Event = procedure () of object cdecl;
  QPlainTextEdit_updateRequest_Event = procedure (rect: PRect; dy: Integer) of object cdecl;
  QPlainTextEdit_blockCountChanged_Event = procedure (newBlockCount: Integer) of object cdecl;
  QPlainTextEdit_modificationChanged_Event = procedure (AnonParam1: Boolean) of object cdecl;



type
  QTextEditLineWrapMode = ( // QTextEdit::LineWrapMode (1)
    QTextEditNoWrap, QTextEditWidgetWidth, QTextEditFixedPixelWidth, QTextEditFixedColumnWidth );

type
  QTextEditAutoFormattingFlag = cardinal; // QTextEdit::AutoFormattingFlag
  QTextEditAutoFormatting = QTextEditAutoFormattingFlag; //QFlags<> (3)
const
  QTextEditAutoNone =   0;
  QTextEditAutoBulletList =   $00000001;
  QTextEditAutoAll =   $ffffffff;

function QTextEdit_Create(parent: QWidgetH = nil): QTextEditH; cdecl; external Qt5PasLib name 'QTextEdit_Create';
procedure QTextEdit_Destroy(handle: QTextEditH); cdecl; external Qt5PasLib name 'QTextEdit_Destroy'; 
function QTextEdit_Create(text: PWideString; parent: QWidgetH = nil): QTextEditH; cdecl; external Qt5PasLib name 'QTextEdit_Create2';
procedure QTextEdit_setDocument(handle: QTextEditH; document: QTextDocumentH); cdecl; external Qt5PasLib name 'QTextEdit_setDocument';
function QTextEdit_document(handle: QTextEditH): QTextDocumentH; cdecl; external Qt5PasLib name 'QTextEdit_document';
procedure QTextEdit_setTextCursor(handle: QTextEditH; cursor: QTextCursorH); cdecl; external Qt5PasLib name 'QTextEdit_setTextCursor';
procedure QTextEdit_textCursor(handle: QTextEditH; retval: QTextCursorH); cdecl; external Qt5PasLib name 'QTextEdit_textCursor';
function QTextEdit_isReadOnly(handle: QTextEditH): Boolean; cdecl; external Qt5PasLib name 'QTextEdit_isReadOnly';
procedure QTextEdit_setReadOnly(handle: QTextEditH; ro: Boolean); cdecl; external Qt5PasLib name 'QTextEdit_setReadOnly';
procedure QTextEdit_setTextInteractionFlags(handle: QTextEditH; flags: QtTextInteractionFlags); cdecl; external Qt5PasLib name 'QTextEdit_setTextInteractionFlags';
function QTextEdit_textInteractionFlags(handle: QTextEditH): QtTextInteractionFlags; cdecl; external Qt5PasLib name 'QTextEdit_textInteractionFlags';
function QTextEdit_fontPointSize(handle: QTextEditH): qreal; cdecl; external Qt5PasLib name 'QTextEdit_fontPointSize';
procedure QTextEdit_fontFamily(handle: QTextEditH; retval: PWideString); cdecl; external Qt5PasLib name 'QTextEdit_fontFamily';
function QTextEdit_fontWeight(handle: QTextEditH): Integer; cdecl; external Qt5PasLib name 'QTextEdit_fontWeight';
function QTextEdit_fontUnderline(handle: QTextEditH): Boolean; cdecl; external Qt5PasLib name 'QTextEdit_fontUnderline';
function QTextEdit_fontItalic(handle: QTextEditH): Boolean; cdecl; external Qt5PasLib name 'QTextEdit_fontItalic';
procedure QTextEdit_textColor(handle: QTextEditH; retval: PQColor); cdecl; external Qt5PasLib name 'QTextEdit_textColor';
procedure QTextEdit_textBackgroundColor(handle: QTextEditH; retval: PQColor); cdecl; external Qt5PasLib name 'QTextEdit_textBackgroundColor';
procedure QTextEdit_currentFont(handle: QTextEditH; retval: QFontH); cdecl; external Qt5PasLib name 'QTextEdit_currentFont';
function QTextEdit_alignment(handle: QTextEditH): QtAlignment; cdecl; external Qt5PasLib name 'QTextEdit_alignment';
procedure QTextEdit_mergeCurrentCharFormat(handle: QTextEditH; modifier: QTextCharFormatH); cdecl; external Qt5PasLib name 'QTextEdit_mergeCurrentCharFormat';
procedure QTextEdit_setCurrentCharFormat(handle: QTextEditH; format: QTextCharFormatH); cdecl; external Qt5PasLib name 'QTextEdit_setCurrentCharFormat';
procedure QTextEdit_currentCharFormat(handle: QTextEditH; retval: QTextCharFormatH); cdecl; external Qt5PasLib name 'QTextEdit_currentCharFormat';
function QTextEdit_autoFormatting(handle: QTextEditH): QTextEditAutoFormatting; cdecl; external Qt5PasLib name 'QTextEdit_autoFormatting';
procedure QTextEdit_setAutoFormatting(handle: QTextEditH; features: QTextEditAutoFormatting); cdecl; external Qt5PasLib name 'QTextEdit_setAutoFormatting';
function QTextEdit_tabChangesFocus(handle: QTextEditH): Boolean; cdecl; external Qt5PasLib name 'QTextEdit_tabChangesFocus';
procedure QTextEdit_setTabChangesFocus(handle: QTextEditH; b: Boolean); cdecl; external Qt5PasLib name 'QTextEdit_setTabChangesFocus';
procedure QTextEdit_setDocumentTitle(handle: QTextEditH; title: PWideString); cdecl; external Qt5PasLib name 'QTextEdit_setDocumentTitle';
procedure QTextEdit_documentTitle(handle: QTextEditH; retval: PWideString); cdecl; external Qt5PasLib name 'QTextEdit_documentTitle';
function QTextEdit_isUndoRedoEnabled(handle: QTextEditH): Boolean; cdecl; external Qt5PasLib name 'QTextEdit_isUndoRedoEnabled';
procedure QTextEdit_setUndoRedoEnabled(handle: QTextEditH; enable: Boolean); cdecl; external Qt5PasLib name 'QTextEdit_setUndoRedoEnabled';
function QTextEdit_lineWrapMode(handle: QTextEditH): QTextEditLineWrapMode; cdecl; external Qt5PasLib name 'QTextEdit_lineWrapMode';
procedure QTextEdit_setLineWrapMode(handle: QTextEditH; mode: QTextEditLineWrapMode); cdecl; external Qt5PasLib name 'QTextEdit_setLineWrapMode';
function QTextEdit_lineWrapColumnOrWidth(handle: QTextEditH): Integer; cdecl; external Qt5PasLib name 'QTextEdit_lineWrapColumnOrWidth';
procedure QTextEdit_setLineWrapColumnOrWidth(handle: QTextEditH; w: Integer); cdecl; external Qt5PasLib name 'QTextEdit_setLineWrapColumnOrWidth';
function QTextEdit_wordWrapMode(handle: QTextEditH): QTextOptionWrapMode; cdecl; external Qt5PasLib name 'QTextEdit_wordWrapMode';
procedure QTextEdit_setWordWrapMode(handle: QTextEditH; policy: QTextOptionWrapMode); cdecl; external Qt5PasLib name 'QTextEdit_setWordWrapMode';
function QTextEdit_find(handle: QTextEditH; exp: PWideString; options: QTextDocumentFindFlags = 0): Boolean; cdecl; external Qt5PasLib name 'QTextEdit_find';
procedure QTextEdit_toPlainText(handle: QTextEditH; retval: PWideString); cdecl; external Qt5PasLib name 'QTextEdit_toPlainText';
procedure QTextEdit_toHtml(handle: QTextEditH; retval: PWideString); cdecl; external Qt5PasLib name 'QTextEdit_toHtml';
procedure QTextEdit_ensureCursorVisible(handle: QTextEditH); cdecl; external Qt5PasLib name 'QTextEdit_ensureCursorVisible';
procedure QTextEdit_loadResource(handle: QTextEditH; retval: QVariantH; _type: Integer; name: QUrlH); cdecl; external Qt5PasLib name 'QTextEdit_loadResource';
function QTextEdit_createStandardContextMenu(handle: QTextEditH): QMenuH; cdecl; external Qt5PasLib name 'QTextEdit_createStandardContextMenu';
function QTextEdit_createStandardContextMenu(handle: QTextEditH; position: PQtPoint): QMenuH; cdecl; external Qt5PasLib name 'QTextEdit_createStandardContextMenu2';
procedure QTextEdit_cursorForPosition(handle: QTextEditH; retval: QTextCursorH; pos: PQtPoint); cdecl; external Qt5PasLib name 'QTextEdit_cursorForPosition';
procedure QTextEdit_cursorRect(handle: QTextEditH; retval: PRect; cursor: QTextCursorH); cdecl; external Qt5PasLib name 'QTextEdit_cursorRect';
procedure QTextEdit_cursorRect(handle: QTextEditH; retval: PRect); cdecl; external Qt5PasLib name 'QTextEdit_cursorRect2';
procedure QTextEdit_anchorAt(handle: QTextEditH; retval: PWideString; pos: PQtPoint); cdecl; external Qt5PasLib name 'QTextEdit_anchorAt';
function QTextEdit_overwriteMode(handle: QTextEditH): Boolean; cdecl; external Qt5PasLib name 'QTextEdit_overwriteMode';
procedure QTextEdit_setOverwriteMode(handle: QTextEditH; overwrite: Boolean); cdecl; external Qt5PasLib name 'QTextEdit_setOverwriteMode';
function QTextEdit_tabStopWidth(handle: QTextEditH): Integer; cdecl; external Qt5PasLib name 'QTextEdit_tabStopWidth';
procedure QTextEdit_setTabStopWidth(handle: QTextEditH; width: Integer); cdecl; external Qt5PasLib name 'QTextEdit_setTabStopWidth';
function QTextEdit_cursorWidth(handle: QTextEditH): Integer; cdecl; external Qt5PasLib name 'QTextEdit_cursorWidth';
procedure QTextEdit_setCursorWidth(handle: QTextEditH; width: Integer); cdecl; external Qt5PasLib name 'QTextEdit_setCursorWidth';
function QTextEdit_acceptRichText(handle: QTextEditH): Boolean; cdecl; external Qt5PasLib name 'QTextEdit_acceptRichText';
procedure QTextEdit_setAcceptRichText(handle: QTextEditH; accept: Boolean); cdecl; external Qt5PasLib name 'QTextEdit_setAcceptRichText';
procedure QTextEdit_moveCursor(handle: QTextEditH; operation: QTextCursorMoveOperation; mode: QTextCursorMoveMode = QTextCursorMoveAnchor); cdecl; external Qt5PasLib name 'QTextEdit_moveCursor';
function QTextEdit_canPaste(handle: QTextEditH): Boolean; cdecl; external Qt5PasLib name 'QTextEdit_canPaste';
procedure QTextEdit_print(handle: QTextEditH; printer: QPagedPaintDeviceH); cdecl; external Qt5PasLib name 'QTextEdit_print';
procedure QTextEdit_inputMethodQuery(handle: QTextEditH; retval: QVariantH; _property: QtInputMethodQuery); cdecl; external Qt5PasLib name 'QTextEdit_inputMethodQuery';
procedure QTextEdit_setFontPointSize(handle: QTextEditH; s: qreal); cdecl; external Qt5PasLib name 'QTextEdit_setFontPointSize';
procedure QTextEdit_setFontFamily(handle: QTextEditH; fontFamily: PWideString); cdecl; external Qt5PasLib name 'QTextEdit_setFontFamily';
procedure QTextEdit_setFontWeight(handle: QTextEditH; w: Integer); cdecl; external Qt5PasLib name 'QTextEdit_setFontWeight';
procedure QTextEdit_setFontUnderline(handle: QTextEditH; b: Boolean); cdecl; external Qt5PasLib name 'QTextEdit_setFontUnderline';
procedure QTextEdit_setFontItalic(handle: QTextEditH; b: Boolean); cdecl; external Qt5PasLib name 'QTextEdit_setFontItalic';
procedure QTextEdit_setTextColor(handle: QTextEditH; c: PQColor); cdecl; external Qt5PasLib name 'QTextEdit_setTextColor';
procedure QTextEdit_setTextBackgroundColor(handle: QTextEditH; c: PQColor); cdecl; external Qt5PasLib name 'QTextEdit_setTextBackgroundColor';
procedure QTextEdit_setCurrentFont(handle: QTextEditH; f: QFontH); cdecl; external Qt5PasLib name 'QTextEdit_setCurrentFont';
procedure QTextEdit_setAlignment(handle: QTextEditH; a: QtAlignment); cdecl; external Qt5PasLib name 'QTextEdit_setAlignment';
procedure QTextEdit_setPlainText(handle: QTextEditH; text: PWideString); cdecl; external Qt5PasLib name 'QTextEdit_setPlainText';
procedure QTextEdit_setHtml(handle: QTextEditH; text: PWideString); cdecl; external Qt5PasLib name 'QTextEdit_setHtml';
procedure QTextEdit_setText(handle: QTextEditH; text: PWideString); cdecl; external Qt5PasLib name 'QTextEdit_setText';
procedure QTextEdit_cut(handle: QTextEditH); cdecl; external Qt5PasLib name 'QTextEdit_cut';
procedure QTextEdit_copy(handle: QTextEditH); cdecl; external Qt5PasLib name 'QTextEdit_copy';
procedure QTextEdit_paste(handle: QTextEditH); cdecl; external Qt5PasLib name 'QTextEdit_paste';
procedure QTextEdit_undo(handle: QTextEditH); cdecl; external Qt5PasLib name 'QTextEdit_undo';
procedure QTextEdit_redo(handle: QTextEditH); cdecl; external Qt5PasLib name 'QTextEdit_redo';
procedure QTextEdit_clear(handle: QTextEditH); cdecl; external Qt5PasLib name 'QTextEdit_clear';
procedure QTextEdit_selectAll(handle: QTextEditH); cdecl; external Qt5PasLib name 'QTextEdit_selectAll';
procedure QTextEdit_insertPlainText(handle: QTextEditH; text: PWideString); cdecl; external Qt5PasLib name 'QTextEdit_insertPlainText';
procedure QTextEdit_insertHtml(handle: QTextEditH; text: PWideString); cdecl; external Qt5PasLib name 'QTextEdit_insertHtml';
procedure QTextEdit_append(handle: QTextEditH; text: PWideString); cdecl; external Qt5PasLib name 'QTextEdit_append';
procedure QTextEdit_scrollToAnchor(handle: QTextEditH; name: PWideString); cdecl; external Qt5PasLib name 'QTextEdit_scrollToAnchor';
procedure QTextEdit_zoomIn(handle: QTextEditH; range: Integer = 1); cdecl; external Qt5PasLib name 'QTextEdit_zoomIn';
procedure QTextEdit_zoomOut(handle: QTextEditH; range: Integer = 1); cdecl; external Qt5PasLib name 'QTextEdit_zoomOut';
procedure QTextEdit_placeholderText(handle: QTextEditH; retval: PWideString); cdecl; external Qt5PasLib name 'QTextEdit_placeholderText';
procedure QTextEdit_setPlaceholderText(handle: QTextEditH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QTextEdit_setPlaceholderText';

type
  QTextEdit_textChanged_Event = procedure () of object cdecl;
  QTextEdit_undoAvailable_Event = procedure (b: Boolean) of object cdecl;
  QTextEdit_redoAvailable_Event = procedure (b: Boolean) of object cdecl;
  QTextEdit_currentCharFormatChanged_Event = procedure (format: QTextCharFormatH) of object cdecl;
  QTextEdit_copyAvailable_Event = procedure (b: Boolean) of object cdecl;
  QTextEdit_selectionChanged_Event = procedure () of object cdecl;
  QTextEdit_cursorPositionChanged_Event = procedure () of object cdecl;



type
  QTabWidgetTabPosition = ( // QTabWidget::TabPosition (1)
    QTabWidgetNorth, QTabWidgetSouth, QTabWidgetWest, QTabWidgetEast );

  QTabWidgetTabShape = ( // QTabWidget::TabShape (1)
    QTabWidgetRounded, QTabWidgetTriangular );

function QTabWidget_Create(parent: QWidgetH = nil): QTabWidgetH; cdecl; external Qt5PasLib name 'QTabWidget_Create';
procedure QTabWidget_Destroy(handle: QTabWidgetH); cdecl; external Qt5PasLib name 'QTabWidget_Destroy'; 
function QTabWidget_addTab(handle: QTabWidgetH; widget: QWidgetH; AnonParam2: PWideString): Integer; cdecl; external Qt5PasLib name 'QTabWidget_addTab';
function QTabWidget_addTab(handle: QTabWidgetH; widget: QWidgetH; icon: QIconH; _label: PWideString): Integer; cdecl; external Qt5PasLib name 'QTabWidget_addTab2';
function QTabWidget_insertTab(handle: QTabWidgetH; index: Integer; widget: QWidgetH; AnonParam3: PWideString): Integer; cdecl; external Qt5PasLib name 'QTabWidget_insertTab';
function QTabWidget_insertTab(handle: QTabWidgetH; index: Integer; widget: QWidgetH; icon: QIconH; _label: PWideString): Integer; cdecl; external Qt5PasLib name 'QTabWidget_insertTab2';
procedure QTabWidget_removeTab(handle: QTabWidgetH; index: Integer); cdecl; external Qt5PasLib name 'QTabWidget_removeTab';
function QTabWidget_isTabEnabled(handle: QTabWidgetH; index: Integer): Boolean; cdecl; external Qt5PasLib name 'QTabWidget_isTabEnabled';
procedure QTabWidget_setTabEnabled(handle: QTabWidgetH; index: Integer; AnonParam2: Boolean); cdecl; external Qt5PasLib name 'QTabWidget_setTabEnabled';
procedure QTabWidget_tabText(handle: QTabWidgetH; retval: PWideString; index: Integer); cdecl; external Qt5PasLib name 'QTabWidget_tabText';
procedure QTabWidget_setTabText(handle: QTabWidgetH; index: Integer; AnonParam2: PWideString); cdecl; external Qt5PasLib name 'QTabWidget_setTabText';
procedure QTabWidget_tabIcon(handle: QTabWidgetH; retval: QIconH; index: Integer); cdecl; external Qt5PasLib name 'QTabWidget_tabIcon';
procedure QTabWidget_setTabIcon(handle: QTabWidgetH; index: Integer; icon: QIconH); cdecl; external Qt5PasLib name 'QTabWidget_setTabIcon';
procedure QTabWidget_setTabToolTip(handle: QTabWidgetH; index: Integer; tip: PWideString); cdecl; external Qt5PasLib name 'QTabWidget_setTabToolTip';
procedure QTabWidget_tabToolTip(handle: QTabWidgetH; retval: PWideString; index: Integer); cdecl; external Qt5PasLib name 'QTabWidget_tabToolTip';
procedure QTabWidget_setTabWhatsThis(handle: QTabWidgetH; index: Integer; text: PWideString); cdecl; external Qt5PasLib name 'QTabWidget_setTabWhatsThis';
procedure QTabWidget_tabWhatsThis(handle: QTabWidgetH; retval: PWideString; index: Integer); cdecl; external Qt5PasLib name 'QTabWidget_tabWhatsThis';
function QTabWidget_currentIndex(handle: QTabWidgetH): Integer; cdecl; external Qt5PasLib name 'QTabWidget_currentIndex';
function QTabWidget_currentWidget(handle: QTabWidgetH): QWidgetH; cdecl; external Qt5PasLib name 'QTabWidget_currentWidget';
function QTabWidget_widget(handle: QTabWidgetH; index: Integer): QWidgetH; cdecl; external Qt5PasLib name 'QTabWidget_widget';
function QTabWidget_indexOf(handle: QTabWidgetH; widget: QWidgetH): Integer; cdecl; external Qt5PasLib name 'QTabWidget_indexOf';
function QTabWidget_count(handle: QTabWidgetH): Integer; cdecl; external Qt5PasLib name 'QTabWidget_count';
function QTabWidget_tabPosition(handle: QTabWidgetH): QTabWidgetTabPosition; cdecl; external Qt5PasLib name 'QTabWidget_tabPosition';
procedure QTabWidget_setTabPosition(handle: QTabWidgetH; AnonParam1: QTabWidgetTabPosition); cdecl; external Qt5PasLib name 'QTabWidget_setTabPosition';
function QTabWidget_tabsClosable(handle: QTabWidgetH): Boolean; cdecl; external Qt5PasLib name 'QTabWidget_tabsClosable';
procedure QTabWidget_setTabsClosable(handle: QTabWidgetH; closeable: Boolean); cdecl; external Qt5PasLib name 'QTabWidget_setTabsClosable';
function QTabWidget_isMovable(handle: QTabWidgetH): Boolean; cdecl; external Qt5PasLib name 'QTabWidget_isMovable';
procedure QTabWidget_setMovable(handle: QTabWidgetH; movable: Boolean); cdecl; external Qt5PasLib name 'QTabWidget_setMovable';
function QTabWidget_tabShape(handle: QTabWidgetH): QTabWidgetTabShape; cdecl; external Qt5PasLib name 'QTabWidget_tabShape';
procedure QTabWidget_setTabShape(handle: QTabWidgetH; s: QTabWidgetTabShape); cdecl; external Qt5PasLib name 'QTabWidget_setTabShape';
procedure QTabWidget_sizeHint(handle: QTabWidgetH; retval: PSize); cdecl; external Qt5PasLib name 'QTabWidget_sizeHint';
procedure QTabWidget_minimumSizeHint(handle: QTabWidgetH; retval: PSize); cdecl; external Qt5PasLib name 'QTabWidget_minimumSizeHint';
function QTabWidget_heightForWidth(handle: QTabWidgetH; width: Integer): Integer; cdecl; external Qt5PasLib name 'QTabWidget_heightForWidth';
function QTabWidget_hasHeightForWidth(handle: QTabWidgetH): Boolean; cdecl; external Qt5PasLib name 'QTabWidget_hasHeightForWidth';
procedure QTabWidget_setCornerWidget(handle: QTabWidgetH; w: QWidgetH; corner: QtCorner = QtTopRightCorner); cdecl; external Qt5PasLib name 'QTabWidget_setCornerWidget';
function QTabWidget_cornerWidget(handle: QTabWidgetH; corner: QtCorner = QtTopRightCorner): QWidgetH; cdecl; external Qt5PasLib name 'QTabWidget_cornerWidget';
function QTabWidget_elideMode(handle: QTabWidgetH): QtTextElideMode; cdecl; external Qt5PasLib name 'QTabWidget_elideMode';
procedure QTabWidget_setElideMode(handle: QTabWidgetH; AnonParam1: QtTextElideMode); cdecl; external Qt5PasLib name 'QTabWidget_setElideMode';
procedure QTabWidget_iconSize(handle: QTabWidgetH; retval: PSize); cdecl; external Qt5PasLib name 'QTabWidget_iconSize';
procedure QTabWidget_setIconSize(handle: QTabWidgetH; size: PSize); cdecl; external Qt5PasLib name 'QTabWidget_setIconSize';
function QTabWidget_usesScrollButtons(handle: QTabWidgetH): Boolean; cdecl; external Qt5PasLib name 'QTabWidget_usesScrollButtons';
procedure QTabWidget_setUsesScrollButtons(handle: QTabWidgetH; useButtons: Boolean); cdecl; external Qt5PasLib name 'QTabWidget_setUsesScrollButtons';
function QTabWidget_documentMode(handle: QTabWidgetH): Boolean; cdecl; external Qt5PasLib name 'QTabWidget_documentMode';
procedure QTabWidget_setDocumentMode(handle: QTabWidgetH; _set: Boolean); cdecl; external Qt5PasLib name 'QTabWidget_setDocumentMode';
procedure QTabWidget_clear(handle: QTabWidgetH); cdecl; external Qt5PasLib name 'QTabWidget_clear';
function QTabWidget_tabBar(handle: QTabWidgetH): QTabBarH; cdecl; external Qt5PasLib name 'QTabWidget_tabBar';
procedure QTabWidget_setCurrentIndex(handle: QTabWidgetH; index: Integer); cdecl; external Qt5PasLib name 'QTabWidget_setCurrentIndex';
procedure QTabWidget_setCurrentWidget(handle: QTabWidgetH; widget: QWidgetH); cdecl; external Qt5PasLib name 'QTabWidget_setCurrentWidget';


type
  QTabWidget_currentChanged_Event = procedure (index: Integer) of object cdecl;
  QTabWidget_tabCloseRequested_Event = procedure (index: Integer) of object cdecl;


function QLCLTabWidget_tabBarHandle(protectedhandle: QTabWidgetH): QTabBarH; cdecl; external Qt5PasLib name 'QLCLTabWidget_tabBarHandle';

type
  QMainWindowDockOption = cardinal; // QMainWindow::DockOption
  QMainWindowDockOptions = QMainWindowDockOption; //QFlags<> (3)
const
  QMainWindowAnimatedDocks =   $01;
  QMainWindowAllowNestedDocks =   $02;
  QMainWindowAllowTabbedDocks =   $04;
  QMainWindowForceTabbedDocks =   $08;
  QMainWindowVerticalTabs =   $10;

function QMainWindow_Create(parent: QWidgetH = nil; flags: QtWindowFlags = 0): QMainWindowH; cdecl; external Qt5PasLib name 'QMainWindow_Create';
procedure QMainWindow_Destroy(handle: QMainWindowH); cdecl; external Qt5PasLib name 'QMainWindow_Destroy'; 
procedure QMainWindow_iconSize(handle: QMainWindowH; retval: PSize); cdecl; external Qt5PasLib name 'QMainWindow_iconSize';
procedure QMainWindow_setIconSize(handle: QMainWindowH; iconSize: PSize); cdecl; external Qt5PasLib name 'QMainWindow_setIconSize';
function QMainWindow_toolButtonStyle(handle: QMainWindowH): QtToolButtonStyle; cdecl; external Qt5PasLib name 'QMainWindow_toolButtonStyle';
procedure QMainWindow_setToolButtonStyle(handle: QMainWindowH; toolButtonStyle: QtToolButtonStyle); cdecl; external Qt5PasLib name 'QMainWindow_setToolButtonStyle';
function QMainWindow_isAnimated(handle: QMainWindowH): Boolean; cdecl; external Qt5PasLib name 'QMainWindow_isAnimated';
function QMainWindow_isDockNestingEnabled(handle: QMainWindowH): Boolean; cdecl; external Qt5PasLib name 'QMainWindow_isDockNestingEnabled';
function QMainWindow_documentMode(handle: QMainWindowH): Boolean; cdecl; external Qt5PasLib name 'QMainWindow_documentMode';
procedure QMainWindow_setDocumentMode(handle: QMainWindowH; enabled: Boolean); cdecl; external Qt5PasLib name 'QMainWindow_setDocumentMode';
function QMainWindow_tabShape(handle: QMainWindowH): QTabWidgetTabShape; cdecl; external Qt5PasLib name 'QMainWindow_tabShape';
procedure QMainWindow_setTabShape(handle: QMainWindowH; tabShape: QTabWidgetTabShape); cdecl; external Qt5PasLib name 'QMainWindow_setTabShape';
function QMainWindow_tabPosition(handle: QMainWindowH; area: QtDockWidgetArea): QTabWidgetTabPosition; cdecl; external Qt5PasLib name 'QMainWindow_tabPosition';
procedure QMainWindow_setTabPosition(handle: QMainWindowH; areas: QtDockWidgetAreas; tabPosition: QTabWidgetTabPosition); cdecl; external Qt5PasLib name 'QMainWindow_setTabPosition';
procedure QMainWindow_setDockOptions(handle: QMainWindowH; options: QMainWindowDockOptions); cdecl; external Qt5PasLib name 'QMainWindow_setDockOptions';
function QMainWindow_dockOptions(handle: QMainWindowH): QMainWindowDockOptions; cdecl; external Qt5PasLib name 'QMainWindow_dockOptions';
function QMainWindow_isSeparator(handle: QMainWindowH; pos: PQtPoint): Boolean; cdecl; external Qt5PasLib name 'QMainWindow_isSeparator';
function QMainWindow_menuBar(handle: QMainWindowH): QMenuBarH; cdecl; external Qt5PasLib name 'QMainWindow_menuBar';
procedure QMainWindow_setMenuBar(handle: QMainWindowH; menubar: QMenuBarH); cdecl; external Qt5PasLib name 'QMainWindow_setMenuBar';
function QMainWindow_menuWidget(handle: QMainWindowH): QWidgetH; cdecl; external Qt5PasLib name 'QMainWindow_menuWidget';
procedure QMainWindow_setMenuWidget(handle: QMainWindowH; menubar: QWidgetH); cdecl; external Qt5PasLib name 'QMainWindow_setMenuWidget';
function QMainWindow_statusBar(handle: QMainWindowH): QStatusBarH; cdecl; external Qt5PasLib name 'QMainWindow_statusBar';
procedure QMainWindow_setStatusBar(handle: QMainWindowH; statusbar: QStatusBarH); cdecl; external Qt5PasLib name 'QMainWindow_setStatusBar';
function QMainWindow_centralWidget(handle: QMainWindowH): QWidgetH; cdecl; external Qt5PasLib name 'QMainWindow_centralWidget';
procedure QMainWindow_setCentralWidget(handle: QMainWindowH; widget: QWidgetH); cdecl; external Qt5PasLib name 'QMainWindow_setCentralWidget';
procedure QMainWindow_setCorner(handle: QMainWindowH; corner: QtCorner; area: QtDockWidgetArea); cdecl; external Qt5PasLib name 'QMainWindow_setCorner';
function QMainWindow_corner(handle: QMainWindowH; corner: QtCorner): QtDockWidgetArea; cdecl; external Qt5PasLib name 'QMainWindow_corner';
procedure QMainWindow_addToolBarBreak(handle: QMainWindowH; area: QtToolBarArea = QtTopToolBarArea); cdecl; external Qt5PasLib name 'QMainWindow_addToolBarBreak';
procedure QMainWindow_insertToolBarBreak(handle: QMainWindowH; before: QToolBarH); cdecl; external Qt5PasLib name 'QMainWindow_insertToolBarBreak';
procedure QMainWindow_addToolBar(handle: QMainWindowH; area: QtToolBarArea; toolbar: QToolBarH); cdecl; external Qt5PasLib name 'QMainWindow_addToolBar';
procedure QMainWindow_addToolBar(handle: QMainWindowH; toolbar: QToolBarH); cdecl; external Qt5PasLib name 'QMainWindow_addToolBar2';
function QMainWindow_addToolBar(handle: QMainWindowH; title: PWideString): QToolBarH; cdecl; external Qt5PasLib name 'QMainWindow_addToolBar3';
procedure QMainWindow_insertToolBar(handle: QMainWindowH; before: QToolBarH; toolbar: QToolBarH); cdecl; external Qt5PasLib name 'QMainWindow_insertToolBar';
procedure QMainWindow_removeToolBar(handle: QMainWindowH; toolbar: QToolBarH); cdecl; external Qt5PasLib name 'QMainWindow_removeToolBar';
procedure QMainWindow_removeToolBarBreak(handle: QMainWindowH; before: QToolBarH); cdecl; external Qt5PasLib name 'QMainWindow_removeToolBarBreak';
procedure QMainWindow_setUnifiedTitleAndToolBarOnMac(handle: QMainWindowH; _set: Boolean); cdecl; external Qt5PasLib name 'QMainWindow_setUnifiedTitleAndToolBarOnMac';
function QMainWindow_unifiedTitleAndToolBarOnMac(handle: QMainWindowH): Boolean; cdecl; external Qt5PasLib name 'QMainWindow_unifiedTitleAndToolBarOnMac';
function QMainWindow_toolBarArea(handle: QMainWindowH; toolbar: QToolBarH): QtToolBarArea; cdecl; external Qt5PasLib name 'QMainWindow_toolBarArea';
function QMainWindow_toolBarBreak(handle: QMainWindowH; toolbar: QToolBarH): Boolean; cdecl; external Qt5PasLib name 'QMainWindow_toolBarBreak';
procedure QMainWindow_addDockWidget(handle: QMainWindowH; area: QtDockWidgetArea; dockwidget: QDockWidgetH); cdecl; external Qt5PasLib name 'QMainWindow_addDockWidget';
procedure QMainWindow_addDockWidget(handle: QMainWindowH; area: QtDockWidgetArea; dockwidget: QDockWidgetH; orientation: QtOrientation); cdecl; external Qt5PasLib name 'QMainWindow_addDockWidget2';
procedure QMainWindow_splitDockWidget(handle: QMainWindowH; after: QDockWidgetH; dockwidget: QDockWidgetH; orientation: QtOrientation); cdecl; external Qt5PasLib name 'QMainWindow_splitDockWidget';
procedure QMainWindow_tabifyDockWidget(handle: QMainWindowH; first: QDockWidgetH; second: QDockWidgetH); cdecl; external Qt5PasLib name 'QMainWindow_tabifyDockWidget';
procedure QMainWindow_tabifiedDockWidgets(handle: QMainWindowH; retval: PPtrIntArray; dockwidget: QDockWidgetH); cdecl; external Qt5PasLib name 'QMainWindow_tabifiedDockWidgets';
procedure QMainWindow_removeDockWidget(handle: QMainWindowH; dockwidget: QDockWidgetH); cdecl; external Qt5PasLib name 'QMainWindow_removeDockWidget';
function QMainWindow_restoreDockWidget(handle: QMainWindowH; dockwidget: QDockWidgetH): Boolean; cdecl; external Qt5PasLib name 'QMainWindow_restoreDockWidget';
function QMainWindow_dockWidgetArea(handle: QMainWindowH; dockwidget: QDockWidgetH): QtDockWidgetArea; cdecl; external Qt5PasLib name 'QMainWindow_dockWidgetArea';
procedure QMainWindow_saveState(handle: QMainWindowH; retval: QByteArrayH; version: Integer = 0); cdecl; external Qt5PasLib name 'QMainWindow_saveState';
function QMainWindow_restoreState(handle: QMainWindowH; state: QByteArrayH; version: Integer = 0): Boolean; cdecl; external Qt5PasLib name 'QMainWindow_restoreState';
function QMainWindow_createPopupMenu(handle: QMainWindowH): QMenuH; cdecl; external Qt5PasLib name 'QMainWindow_createPopupMenu';
procedure QMainWindow_setAnimated(handle: QMainWindowH; enabled: Boolean); cdecl; external Qt5PasLib name 'QMainWindow_setAnimated';
procedure QMainWindow_setDockNestingEnabled(handle: QMainWindowH; enabled: Boolean); cdecl; external Qt5PasLib name 'QMainWindow_setDockNestingEnabled';


type
  QMainWindow_iconSizeChanged_Event = procedure (iconSize: PSize) of object cdecl;
  QMainWindow_toolButtonStyleChanged_Event = procedure (toolButtonStyle: QtToolButtonStyle) of object cdecl;


function QToolBar_Create(title: PWideString; parent: QWidgetH = nil): QToolBarH; cdecl; external Qt5PasLib name 'QToolBar_Create';
procedure QToolBar_Destroy(handle: QToolBarH); cdecl; external Qt5PasLib name 'QToolBar_Destroy'; 
function QToolBar_Create(parent: QWidgetH = nil): QToolBarH; cdecl; external Qt5PasLib name 'QToolBar_Create2';
procedure QToolBar_setMovable(handle: QToolBarH; movable: Boolean); cdecl; external Qt5PasLib name 'QToolBar_setMovable';
function QToolBar_isMovable(handle: QToolBarH): Boolean; cdecl; external Qt5PasLib name 'QToolBar_isMovable';
procedure QToolBar_setAllowedAreas(handle: QToolBarH; areas: QtToolBarAreas); cdecl; external Qt5PasLib name 'QToolBar_setAllowedAreas';
function QToolBar_allowedAreas(handle: QToolBarH): QtToolBarAreas; cdecl; external Qt5PasLib name 'QToolBar_allowedAreas';
function QToolBar_isAreaAllowed(handle: QToolBarH; area: QtToolBarArea): Boolean; cdecl; external Qt5PasLib name 'QToolBar_isAreaAllowed';
procedure QToolBar_setOrientation(handle: QToolBarH; orientation: QtOrientation); cdecl; external Qt5PasLib name 'QToolBar_setOrientation';
function QToolBar_orientation(handle: QToolBarH): QtOrientation; cdecl; external Qt5PasLib name 'QToolBar_orientation';
procedure QToolBar_clear(handle: QToolBarH); cdecl; external Qt5PasLib name 'QToolBar_clear';
function QToolBar_addAction(handle: QToolBarH; text: PWideString): QActionH; cdecl; external Qt5PasLib name 'QToolBar_addAction';
function QToolBar_addAction(handle: QToolBarH; icon: QIconH; text: PWideString): QActionH; cdecl; external Qt5PasLib name 'QToolBar_addAction2';
function QToolBar_addAction(handle: QToolBarH; text: PWideString; receiver: QObjectH; member: PAnsiChar): QActionH; cdecl; external Qt5PasLib name 'QToolBar_addAction3';
function QToolBar_addAction(handle: QToolBarH; icon: QIconH; text: PWideString; receiver: QObjectH; member: PAnsiChar): QActionH; cdecl; external Qt5PasLib name 'QToolBar_addAction4';
function QToolBar_addSeparator(handle: QToolBarH): QActionH; cdecl; external Qt5PasLib name 'QToolBar_addSeparator';
function QToolBar_insertSeparator(handle: QToolBarH; before: QActionH): QActionH; cdecl; external Qt5PasLib name 'QToolBar_insertSeparator';
function QToolBar_addWidget(handle: QToolBarH; widget: QWidgetH): QActionH; cdecl; external Qt5PasLib name 'QToolBar_addWidget';
function QToolBar_insertWidget(handle: QToolBarH; before: QActionH; widget: QWidgetH): QActionH; cdecl; external Qt5PasLib name 'QToolBar_insertWidget';
procedure QToolBar_actionGeometry(handle: QToolBarH; retval: PRect; action: QActionH); cdecl; external Qt5PasLib name 'QToolBar_actionGeometry';
function QToolBar_actionAt(handle: QToolBarH; p: PQtPoint): QActionH; cdecl; external Qt5PasLib name 'QToolBar_actionAt';
function QToolBar_actionAt(handle: QToolBarH; x: Integer; y: Integer): QActionH; cdecl; external Qt5PasLib name 'QToolBar_actionAt2';
function QToolBar_toggleViewAction(handle: QToolBarH): QActionH; cdecl; external Qt5PasLib name 'QToolBar_toggleViewAction';
procedure QToolBar_iconSize(handle: QToolBarH; retval: PSize); cdecl; external Qt5PasLib name 'QToolBar_iconSize';
function QToolBar_toolButtonStyle(handle: QToolBarH): QtToolButtonStyle; cdecl; external Qt5PasLib name 'QToolBar_toolButtonStyle';
function QToolBar_widgetForAction(handle: QToolBarH; action: QActionH): QWidgetH; cdecl; external Qt5PasLib name 'QToolBar_widgetForAction';
function QToolBar_isFloatable(handle: QToolBarH): Boolean; cdecl; external Qt5PasLib name 'QToolBar_isFloatable';
procedure QToolBar_setFloatable(handle: QToolBarH; floatable: Boolean); cdecl; external Qt5PasLib name 'QToolBar_setFloatable';
function QToolBar_isFloating(handle: QToolBarH): Boolean; cdecl; external Qt5PasLib name 'QToolBar_isFloating';
procedure QToolBar_setIconSize(handle: QToolBarH; iconSize: PSize); cdecl; external Qt5PasLib name 'QToolBar_setIconSize';
procedure QToolBar_setToolButtonStyle(handle: QToolBarH; toolButtonStyle: QtToolButtonStyle); cdecl; external Qt5PasLib name 'QToolBar_setToolButtonStyle';


type
  QToolBar_actionTriggered_Event = procedure (action: QActionH) of object cdecl;
  QToolBar_movableChanged_Event = procedure (movable: Boolean) of object cdecl;
  QToolBar_allowedAreasChanged_Event = procedure (allowedAreas: QtToolBarAreas) of object cdecl;
  QToolBar_orientationChanged_Event = procedure (orientation: QtOrientation) of object cdecl;
  QToolBar_iconSizeChanged_Event = procedure (iconSize: PSize) of object cdecl;
  QToolBar_toolButtonStyleChanged_Event = procedure (toolButtonStyle: QtToolButtonStyle) of object cdecl;
  QToolBar_topLevelChanged_Event = procedure (topLevel: Boolean) of object cdecl;
  QToolBar_visibilityChanged_Event = procedure (visible: Boolean) of object cdecl;


function QSizeGrip_Create(parent: QWidgetH): QSizeGripH; cdecl; external Qt5PasLib name 'QSizeGrip_Create';
procedure QSizeGrip_Destroy(handle: QSizeGripH); cdecl; external Qt5PasLib name 'QSizeGrip_Destroy'; 
procedure QSizeGrip_sizeHint(handle: QSizeGripH; retval: PSize); cdecl; external Qt5PasLib name 'QSizeGrip_sizeHint';
procedure QSizeGrip_setVisible(handle: QSizeGripH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QSizeGrip_setVisible';


type
  QLCDNumberMode = ( // QLCDNumber::Mode (1)
    QLCDNumberHex, QLCDNumberDec, QLCDNumberOct, QLCDNumberBin );

  QLCDNumberSegmentStyle = ( // QLCDNumber::SegmentStyle (1)
    QLCDNumberOutline, QLCDNumberFilled, QLCDNumberFlat );

function QLCDNumber_Create(parent: QWidgetH = nil): QLCDNumberH; cdecl; external Qt5PasLib name 'QLCDNumber_Create';
procedure QLCDNumber_Destroy(handle: QLCDNumberH); cdecl; external Qt5PasLib name 'QLCDNumber_Destroy'; 
function QLCDNumber_Create(numDigits: LongWord; parent: QWidgetH = nil): QLCDNumberH; cdecl; external Qt5PasLib name 'QLCDNumber_Create2';
function QLCDNumber_smallDecimalPoint(handle: QLCDNumberH): Boolean; cdecl; external Qt5PasLib name 'QLCDNumber_smallDecimalPoint';
function QLCDNumber_digitCount(handle: QLCDNumberH): Integer; cdecl; external Qt5PasLib name 'QLCDNumber_digitCount';
procedure QLCDNumber_setDigitCount(handle: QLCDNumberH; nDigits: Integer); cdecl; external Qt5PasLib name 'QLCDNumber_setDigitCount';
function QLCDNumber_checkOverflow(handle: QLCDNumberH; num: Double): Boolean; cdecl; external Qt5PasLib name 'QLCDNumber_checkOverflow';
function QLCDNumber_checkOverflow(handle: QLCDNumberH; num: Integer): Boolean; cdecl; external Qt5PasLib name 'QLCDNumber_checkOverflow2';
function QLCDNumber_mode(handle: QLCDNumberH): QLCDNumberMode; cdecl; external Qt5PasLib name 'QLCDNumber_mode';
procedure QLCDNumber_setMode(handle: QLCDNumberH; AnonParam1: QLCDNumberMode); cdecl; external Qt5PasLib name 'QLCDNumber_setMode';
function QLCDNumber_segmentStyle(handle: QLCDNumberH): QLCDNumberSegmentStyle; cdecl; external Qt5PasLib name 'QLCDNumber_segmentStyle';
procedure QLCDNumber_setSegmentStyle(handle: QLCDNumberH; AnonParam1: QLCDNumberSegmentStyle); cdecl; external Qt5PasLib name 'QLCDNumber_setSegmentStyle';
function QLCDNumber_value(handle: QLCDNumberH): Double; cdecl; external Qt5PasLib name 'QLCDNumber_value';
function QLCDNumber_intValue(handle: QLCDNumberH): Integer; cdecl; external Qt5PasLib name 'QLCDNumber_intValue';
procedure QLCDNumber_sizeHint(handle: QLCDNumberH; retval: PSize); cdecl; external Qt5PasLib name 'QLCDNumber_sizeHint';
procedure QLCDNumber_display(handle: QLCDNumberH; str: PWideString); cdecl; external Qt5PasLib name 'QLCDNumber_display';
procedure QLCDNumber_display(handle: QLCDNumberH; num: Integer); cdecl; external Qt5PasLib name 'QLCDNumber_display2';
procedure QLCDNumber_display(handle: QLCDNumberH; num: Double); cdecl; external Qt5PasLib name 'QLCDNumber_display3';
procedure QLCDNumber_setHexMode(handle: QLCDNumberH); cdecl; external Qt5PasLib name 'QLCDNumber_setHexMode';
procedure QLCDNumber_setDecMode(handle: QLCDNumberH); cdecl; external Qt5PasLib name 'QLCDNumber_setDecMode';
procedure QLCDNumber_setOctMode(handle: QLCDNumberH); cdecl; external Qt5PasLib name 'QLCDNumber_setOctMode';
procedure QLCDNumber_setBinMode(handle: QLCDNumberH); cdecl; external Qt5PasLib name 'QLCDNumber_setBinMode';
procedure QLCDNumber_setSmallDecimalPoint(handle: QLCDNumberH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QLCDNumber_setSmallDecimalPoint';


type
  QLCDNumber_overflow_Event = procedure () of object cdecl;



type
  QAbstractSpinBoxButtonSymbols = ( // QAbstractSpinBox::ButtonSymbols (1)
    QAbstractSpinBoxUpDownArrows, QAbstractSpinBoxPlusMinus, QAbstractSpinBoxNoButtons );

  QAbstractSpinBoxCorrectionMode = ( // QAbstractSpinBox::CorrectionMode (1)
    QAbstractSpinBoxCorrectToPreviousValue, QAbstractSpinBoxCorrectToNearestValue );

type
  QAbstractSpinBoxStepEnabledFlag = cardinal; // QAbstractSpinBox::StepEnabledFlag
  QAbstractSpinBoxStepEnabled = QAbstractSpinBoxStepEnabledFlag; //QFlags<> (3)
const
  QAbstractSpinBoxStepNone =   $00;
  QAbstractSpinBoxStepUpEnabled =   $01;
  QAbstractSpinBoxStepDownEnabled =   $02;

function QAbstractSpinBox_Create(parent: QWidgetH = nil): QAbstractSpinBoxH; cdecl; external Qt5PasLib name 'QAbstractSpinBox_Create';
procedure QAbstractSpinBox_Destroy(handle: QAbstractSpinBoxH); cdecl; external Qt5PasLib name 'QAbstractSpinBox_Destroy'; 
function QAbstractSpinBox_buttonSymbols(handle: QAbstractSpinBoxH): QAbstractSpinBoxButtonSymbols; cdecl; external Qt5PasLib name 'QAbstractSpinBox_buttonSymbols';
procedure QAbstractSpinBox_setButtonSymbols(handle: QAbstractSpinBoxH; bs: QAbstractSpinBoxButtonSymbols); cdecl; external Qt5PasLib name 'QAbstractSpinBox_setButtonSymbols';
procedure QAbstractSpinBox_setCorrectionMode(handle: QAbstractSpinBoxH; cm: QAbstractSpinBoxCorrectionMode); cdecl; external Qt5PasLib name 'QAbstractSpinBox_setCorrectionMode';
function QAbstractSpinBox_correctionMode(handle: QAbstractSpinBoxH): QAbstractSpinBoxCorrectionMode; cdecl; external Qt5PasLib name 'QAbstractSpinBox_correctionMode';
function QAbstractSpinBox_hasAcceptableInput(handle: QAbstractSpinBoxH): Boolean; cdecl; external Qt5PasLib name 'QAbstractSpinBox_hasAcceptableInput';
procedure QAbstractSpinBox_text(handle: QAbstractSpinBoxH; retval: PWideString); cdecl; external Qt5PasLib name 'QAbstractSpinBox_text';
procedure QAbstractSpinBox_specialValueText(handle: QAbstractSpinBoxH; retval: PWideString); cdecl; external Qt5PasLib name 'QAbstractSpinBox_specialValueText';
procedure QAbstractSpinBox_setSpecialValueText(handle: QAbstractSpinBoxH; txt: PWideString); cdecl; external Qt5PasLib name 'QAbstractSpinBox_setSpecialValueText';
function QAbstractSpinBox_wrapping(handle: QAbstractSpinBoxH): Boolean; cdecl; external Qt5PasLib name 'QAbstractSpinBox_wrapping';
procedure QAbstractSpinBox_setWrapping(handle: QAbstractSpinBoxH; w: Boolean); cdecl; external Qt5PasLib name 'QAbstractSpinBox_setWrapping';
procedure QAbstractSpinBox_setReadOnly(handle: QAbstractSpinBoxH; r: Boolean); cdecl; external Qt5PasLib name 'QAbstractSpinBox_setReadOnly';
function QAbstractSpinBox_isReadOnly(handle: QAbstractSpinBoxH): Boolean; cdecl; external Qt5PasLib name 'QAbstractSpinBox_isReadOnly';
procedure QAbstractSpinBox_setKeyboardTracking(handle: QAbstractSpinBoxH; kt: Boolean); cdecl; external Qt5PasLib name 'QAbstractSpinBox_setKeyboardTracking';
function QAbstractSpinBox_keyboardTracking(handle: QAbstractSpinBoxH): Boolean; cdecl; external Qt5PasLib name 'QAbstractSpinBox_keyboardTracking';
procedure QAbstractSpinBox_setAlignment(handle: QAbstractSpinBoxH; flag: QtAlignment); cdecl; external Qt5PasLib name 'QAbstractSpinBox_setAlignment';
function QAbstractSpinBox_alignment(handle: QAbstractSpinBoxH): QtAlignment; cdecl; external Qt5PasLib name 'QAbstractSpinBox_alignment';
procedure QAbstractSpinBox_setFrame(handle: QAbstractSpinBoxH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QAbstractSpinBox_setFrame';
function QAbstractSpinBox_hasFrame(handle: QAbstractSpinBoxH): Boolean; cdecl; external Qt5PasLib name 'QAbstractSpinBox_hasFrame';
procedure QAbstractSpinBox_setAccelerated(handle: QAbstractSpinBoxH; _on: Boolean); cdecl; external Qt5PasLib name 'QAbstractSpinBox_setAccelerated';
function QAbstractSpinBox_isAccelerated(handle: QAbstractSpinBoxH): Boolean; cdecl; external Qt5PasLib name 'QAbstractSpinBox_isAccelerated';
procedure QAbstractSpinBox_sizeHint(handle: QAbstractSpinBoxH; retval: PSize); cdecl; external Qt5PasLib name 'QAbstractSpinBox_sizeHint';
procedure QAbstractSpinBox_minimumSizeHint(handle: QAbstractSpinBoxH; retval: PSize); cdecl; external Qt5PasLib name 'QAbstractSpinBox_minimumSizeHint';
procedure QAbstractSpinBox_interpretText(handle: QAbstractSpinBoxH); cdecl; external Qt5PasLib name 'QAbstractSpinBox_interpretText';
function QAbstractSpinBox_event(handle: QAbstractSpinBoxH; event: QEventH): Boolean; cdecl; external Qt5PasLib name 'QAbstractSpinBox_event';
procedure QAbstractSpinBox_inputMethodQuery(handle: QAbstractSpinBoxH; retval: QVariantH; AnonParam1: QtInputMethodQuery); cdecl; external Qt5PasLib name 'QAbstractSpinBox_inputMethodQuery';
function QAbstractSpinBox_validate(handle: QAbstractSpinBoxH; input: PWideString; pos: PInteger): QValidatorState; cdecl; external Qt5PasLib name 'QAbstractSpinBox_validate';
procedure QAbstractSpinBox_fixup(handle: QAbstractSpinBoxH; input: PWideString); cdecl; external Qt5PasLib name 'QAbstractSpinBox_fixup';
procedure QAbstractSpinBox_stepBy(handle: QAbstractSpinBoxH; steps: Integer); cdecl; external Qt5PasLib name 'QAbstractSpinBox_stepBy';
procedure QAbstractSpinBox_stepUp(handle: QAbstractSpinBoxH); cdecl; external Qt5PasLib name 'QAbstractSpinBox_stepUp';
procedure QAbstractSpinBox_stepDown(handle: QAbstractSpinBoxH); cdecl; external Qt5PasLib name 'QAbstractSpinBox_stepDown';
procedure QAbstractSpinBox_selectAll(handle: QAbstractSpinBoxH); cdecl; external Qt5PasLib name 'QAbstractSpinBox_selectAll';
procedure QAbstractSpinBox_clear(handle: QAbstractSpinBoxH); cdecl; external Qt5PasLib name 'QAbstractSpinBox_clear';


type
  QAbstractSpinBox_editingFinished_Event = procedure () of object cdecl;


function QLCLAbstractSpinBox_lineEditHandle(protectedhandle: QAbstractSpinBoxH): QLineEditH; cdecl; external Qt5PasLib name 'QLCLAbstractSpinBox_lineEditHandle';

function QSpinBox_Create(parent: QWidgetH = nil): QSpinBoxH; cdecl; external Qt5PasLib name 'QSpinBox_Create';
procedure QSpinBox_Destroy(handle: QSpinBoxH); cdecl; external Qt5PasLib name 'QSpinBox_Destroy'; 
function QSpinBox_value(handle: QSpinBoxH): Integer; cdecl; external Qt5PasLib name 'QSpinBox_value';
procedure QSpinBox_prefix(handle: QSpinBoxH; retval: PWideString); cdecl; external Qt5PasLib name 'QSpinBox_prefix';
procedure QSpinBox_setPrefix(handle: QSpinBoxH; prefix: PWideString); cdecl; external Qt5PasLib name 'QSpinBox_setPrefix';
procedure QSpinBox_suffix(handle: QSpinBoxH; retval: PWideString); cdecl; external Qt5PasLib name 'QSpinBox_suffix';
procedure QSpinBox_setSuffix(handle: QSpinBoxH; suffix: PWideString); cdecl; external Qt5PasLib name 'QSpinBox_setSuffix';
procedure QSpinBox_cleanText(handle: QSpinBoxH; retval: PWideString); cdecl; external Qt5PasLib name 'QSpinBox_cleanText';
function QSpinBox_singleStep(handle: QSpinBoxH): Integer; cdecl; external Qt5PasLib name 'QSpinBox_singleStep';
procedure QSpinBox_setSingleStep(handle: QSpinBoxH; val: Integer); cdecl; external Qt5PasLib name 'QSpinBox_setSingleStep';
function QSpinBox_minimum(handle: QSpinBoxH): Integer; cdecl; external Qt5PasLib name 'QSpinBox_minimum';
procedure QSpinBox_setMinimum(handle: QSpinBoxH; min: Integer); cdecl; external Qt5PasLib name 'QSpinBox_setMinimum';
function QSpinBox_maximum(handle: QSpinBoxH): Integer; cdecl; external Qt5PasLib name 'QSpinBox_maximum';
procedure QSpinBox_setMaximum(handle: QSpinBoxH; max: Integer); cdecl; external Qt5PasLib name 'QSpinBox_setMaximum';
procedure QSpinBox_setRange(handle: QSpinBoxH; min: Integer; max: Integer); cdecl; external Qt5PasLib name 'QSpinBox_setRange';
procedure QSpinBox_setValue(handle: QSpinBoxH; val: Integer); cdecl; external Qt5PasLib name 'QSpinBox_setValue';

function QDoubleSpinBox_Create(parent: QWidgetH = nil): QDoubleSpinBoxH; cdecl; external Qt5PasLib name 'QDoubleSpinBox_Create';
procedure QDoubleSpinBox_Destroy(handle: QDoubleSpinBoxH); cdecl; external Qt5PasLib name 'QDoubleSpinBox_Destroy'; 
function QDoubleSpinBox_value(handle: QDoubleSpinBoxH): Double; cdecl; external Qt5PasLib name 'QDoubleSpinBox_value';
procedure QDoubleSpinBox_prefix(handle: QDoubleSpinBoxH; retval: PWideString); cdecl; external Qt5PasLib name 'QDoubleSpinBox_prefix';
procedure QDoubleSpinBox_setPrefix(handle: QDoubleSpinBoxH; prefix: PWideString); cdecl; external Qt5PasLib name 'QDoubleSpinBox_setPrefix';
procedure QDoubleSpinBox_suffix(handle: QDoubleSpinBoxH; retval: PWideString); cdecl; external Qt5PasLib name 'QDoubleSpinBox_suffix';
procedure QDoubleSpinBox_setSuffix(handle: QDoubleSpinBoxH; suffix: PWideString); cdecl; external Qt5PasLib name 'QDoubleSpinBox_setSuffix';
procedure QDoubleSpinBox_cleanText(handle: QDoubleSpinBoxH; retval: PWideString); cdecl; external Qt5PasLib name 'QDoubleSpinBox_cleanText';
function QDoubleSpinBox_singleStep(handle: QDoubleSpinBoxH): Double; cdecl; external Qt5PasLib name 'QDoubleSpinBox_singleStep';
procedure QDoubleSpinBox_setSingleStep(handle: QDoubleSpinBoxH; val: Double); cdecl; external Qt5PasLib name 'QDoubleSpinBox_setSingleStep';
function QDoubleSpinBox_minimum(handle: QDoubleSpinBoxH): Double; cdecl; external Qt5PasLib name 'QDoubleSpinBox_minimum';
procedure QDoubleSpinBox_setMinimum(handle: QDoubleSpinBoxH; min: Double); cdecl; external Qt5PasLib name 'QDoubleSpinBox_setMinimum';
function QDoubleSpinBox_maximum(handle: QDoubleSpinBoxH): Double; cdecl; external Qt5PasLib name 'QDoubleSpinBox_maximum';
procedure QDoubleSpinBox_setMaximum(handle: QDoubleSpinBoxH; max: Double); cdecl; external Qt5PasLib name 'QDoubleSpinBox_setMaximum';
procedure QDoubleSpinBox_setRange(handle: QDoubleSpinBoxH; min: Double; max: Double); cdecl; external Qt5PasLib name 'QDoubleSpinBox_setRange';
function QDoubleSpinBox_decimals(handle: QDoubleSpinBoxH): Integer; cdecl; external Qt5PasLib name 'QDoubleSpinBox_decimals';
procedure QDoubleSpinBox_setDecimals(handle: QDoubleSpinBoxH; prec: Integer); cdecl; external Qt5PasLib name 'QDoubleSpinBox_setDecimals';
function QDoubleSpinBox_validate(handle: QDoubleSpinBoxH; input: PWideString; pos: PInteger): QValidatorState; cdecl; external Qt5PasLib name 'QDoubleSpinBox_validate';
function QDoubleSpinBox_valueFromText(handle: QDoubleSpinBoxH; text: PWideString): Double; cdecl; external Qt5PasLib name 'QDoubleSpinBox_valueFromText';
procedure QDoubleSpinBox_textFromValue(handle: QDoubleSpinBoxH; retval: PWideString; val: Double); cdecl; external Qt5PasLib name 'QDoubleSpinBox_textFromValue';
procedure QDoubleSpinBox_fixup(handle: QDoubleSpinBoxH; str: PWideString); cdecl; external Qt5PasLib name 'QDoubleSpinBox_fixup';
procedure QDoubleSpinBox_setValue(handle: QDoubleSpinBoxH; val: Double); cdecl; external Qt5PasLib name 'QDoubleSpinBox_setValue';


type
  QSpinBox_valueChanged_Event = procedure (AnonParam1: Integer) of object cdecl;
  QSpinBox_valueChanged2_Event = procedure (AnonParam1: PWideString) of object cdecl;



type
  QDoubleSpinBox_valueChanged_Event = procedure (AnonParam1: Double) of object cdecl;
  QDoubleSpinBox_valueChanged2_Event = procedure (AnonParam1: PWideString) of object cdecl;


function QSplitter_Create(parent: QWidgetH = nil): QSplitterH; cdecl; external Qt5PasLib name 'QSplitter_Create';
procedure QSplitter_Destroy(handle: QSplitterH); cdecl; external Qt5PasLib name 'QSplitter_Destroy'; 
function QSplitter_Create(AnonParam1: QtOrientation; parent: QWidgetH = nil): QSplitterH; cdecl; external Qt5PasLib name 'QSplitter_Create2';
procedure QSplitter_addWidget(handle: QSplitterH; widget: QWidgetH); cdecl; external Qt5PasLib name 'QSplitter_addWidget';
procedure QSplitter_insertWidget(handle: QSplitterH; index: Integer; widget: QWidgetH); cdecl; external Qt5PasLib name 'QSplitter_insertWidget';
procedure QSplitter_setOrientation(handle: QSplitterH; AnonParam1: QtOrientation); cdecl; external Qt5PasLib name 'QSplitter_setOrientation';
function QSplitter_orientation(handle: QSplitterH): QtOrientation; cdecl; external Qt5PasLib name 'QSplitter_orientation';
procedure QSplitter_setChildrenCollapsible(handle: QSplitterH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QSplitter_setChildrenCollapsible';
function QSplitter_childrenCollapsible(handle: QSplitterH): Boolean; cdecl; external Qt5PasLib name 'QSplitter_childrenCollapsible';
procedure QSplitter_setCollapsible(handle: QSplitterH; index: Integer; AnonParam2: Boolean); cdecl; external Qt5PasLib name 'QSplitter_setCollapsible';
function QSplitter_isCollapsible(handle: QSplitterH; index: Integer): Boolean; cdecl; external Qt5PasLib name 'QSplitter_isCollapsible';
procedure QSplitter_setOpaqueResize(handle: QSplitterH; opaque: Boolean = True); cdecl; external Qt5PasLib name 'QSplitter_setOpaqueResize';
function QSplitter_opaqueResize(handle: QSplitterH): Boolean; cdecl; external Qt5PasLib name 'QSplitter_opaqueResize';
procedure QSplitter_refresh(handle: QSplitterH); cdecl; external Qt5PasLib name 'QSplitter_refresh';
procedure QSplitter_sizeHint(handle: QSplitterH; retval: PSize); cdecl; external Qt5PasLib name 'QSplitter_sizeHint';
procedure QSplitter_minimumSizeHint(handle: QSplitterH; retval: PSize); cdecl; external Qt5PasLib name 'QSplitter_minimumSizeHint';
procedure QSplitter_sizes(handle: QSplitterH; retval: PPtrIntArray); cdecl; external Qt5PasLib name 'QSplitter_sizes';
procedure QSplitter_setSizes(handle: QSplitterH; list: PPtrIntArray); cdecl; external Qt5PasLib name 'QSplitter_setSizes';
procedure QSplitter_saveState(handle: QSplitterH; retval: QByteArrayH); cdecl; external Qt5PasLib name 'QSplitter_saveState';
function QSplitter_restoreState(handle: QSplitterH; state: QByteArrayH): Boolean; cdecl; external Qt5PasLib name 'QSplitter_restoreState';
function QSplitter_handleWidth(handle: QSplitterH): Integer; cdecl; external Qt5PasLib name 'QSplitter_handleWidth';
procedure QSplitter_setHandleWidth(handle: QSplitterH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QSplitter_setHandleWidth';
function QSplitter_indexOf(handle: QSplitterH; w: QWidgetH): Integer; cdecl; external Qt5PasLib name 'QSplitter_indexOf';
function QSplitter_widget(handle: QSplitterH; index: Integer): QWidgetH; cdecl; external Qt5PasLib name 'QSplitter_widget';
function QSplitter_count(handle: QSplitterH): Integer; cdecl; external Qt5PasLib name 'QSplitter_count';
procedure QSplitter_getRange(handle: QSplitterH; index: Integer; AnonParam2: PInteger; AnonParam3: PInteger); cdecl; external Qt5PasLib name 'QSplitter_getRange';
function QSplitter_handle(handle: QSplitterH; index: Integer): QSplitterHandleH; cdecl; external Qt5PasLib name 'QSplitter_handle';
procedure QSplitter_setStretchFactor(handle: QSplitterH; index: Integer; stretch: Integer); cdecl; external Qt5PasLib name 'QSplitter_setStretchFactor';

function QSplitterHandle_Create(o: QtOrientation; parent: QSplitterH): QSplitterHandleH; cdecl; external Qt5PasLib name 'QSplitterHandle_Create';
procedure QSplitterHandle_Destroy(handle: QSplitterHandleH); cdecl; external Qt5PasLib name 'QSplitterHandle_Destroy'; 
procedure QSplitterHandle_setOrientation(handle: QSplitterHandleH; o: QtOrientation); cdecl; external Qt5PasLib name 'QSplitterHandle_setOrientation';
function QSplitterHandle_orientation(handle: QSplitterHandleH): QtOrientation; cdecl; external Qt5PasLib name 'QSplitterHandle_orientation';
function QSplitterHandle_opaqueResize(handle: QSplitterHandleH): Boolean; cdecl; external Qt5PasLib name 'QSplitterHandle_opaqueResize';
function QSplitterHandle_splitter(handle: QSplitterHandleH): QSplitterH; cdecl; external Qt5PasLib name 'QSplitterHandle_splitter';
procedure QSplitterHandle_sizeHint(handle: QSplitterHandleH; retval: PSize); cdecl; external Qt5PasLib name 'QSplitterHandle_sizeHint';


type
  QSplitter_splitterMoved_Event = procedure (pos: Integer; index: Integer) of object cdecl;



type
  QComboBoxInsertPolicy = ( // QComboBox::InsertPolicy (1)
    QComboBoxNoInsert, QComboBoxInsertAtTop, QComboBoxInsertAtCurrent, QComboBoxInsertAtBottom, QComboBoxInsertAfterCurrent, QComboBoxInsertBeforeCurrent, QComboBoxInsertAlphabetically );

  QComboBoxSizeAdjustPolicy = ( // QComboBox::SizeAdjustPolicy (1)
    QComboBoxAdjustToContents, QComboBoxAdjustToContentsOnFirstShow, QComboBoxAdjustToMinimumContentsLength, QComboBoxAdjustToMinimumContentsLengthWithIcon );

function QComboBox_Create(parent: QWidgetH = nil): QComboBoxH; cdecl; external Qt5PasLib name 'QComboBox_Create';
procedure QComboBox_Destroy(handle: QComboBoxH); cdecl; external Qt5PasLib name 'QComboBox_Destroy'; 
function QComboBox_maxVisibleItems(handle: QComboBoxH): Integer; cdecl; external Qt5PasLib name 'QComboBox_maxVisibleItems';
procedure QComboBox_setMaxVisibleItems(handle: QComboBoxH; maxItems: Integer); cdecl; external Qt5PasLib name 'QComboBox_setMaxVisibleItems';
function QComboBox_count(handle: QComboBoxH): Integer; cdecl; external Qt5PasLib name 'QComboBox_count';
procedure QComboBox_setMaxCount(handle: QComboBoxH; max: Integer); cdecl; external Qt5PasLib name 'QComboBox_setMaxCount';
function QComboBox_maxCount(handle: QComboBoxH): Integer; cdecl; external Qt5PasLib name 'QComboBox_maxCount';
function QComboBox_autoCompletion(handle: QComboBoxH): Boolean; cdecl; external Qt5PasLib name 'QComboBox_autoCompletion';
procedure QComboBox_setAutoCompletion(handle: QComboBoxH; enable: Boolean); cdecl; external Qt5PasLib name 'QComboBox_setAutoCompletion';
function QComboBox_autoCompletionCaseSensitivity(handle: QComboBoxH): QtCaseSensitivity; cdecl; external Qt5PasLib name 'QComboBox_autoCompletionCaseSensitivity';
procedure QComboBox_setAutoCompletionCaseSensitivity(handle: QComboBoxH; sensitivity: QtCaseSensitivity); cdecl; external Qt5PasLib name 'QComboBox_setAutoCompletionCaseSensitivity';
function QComboBox_duplicatesEnabled(handle: QComboBoxH): Boolean; cdecl; external Qt5PasLib name 'QComboBox_duplicatesEnabled';
procedure QComboBox_setDuplicatesEnabled(handle: QComboBoxH; enable: Boolean); cdecl; external Qt5PasLib name 'QComboBox_setDuplicatesEnabled';
procedure QComboBox_setFrame(handle: QComboBoxH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QComboBox_setFrame';
function QComboBox_hasFrame(handle: QComboBoxH): Boolean; cdecl; external Qt5PasLib name 'QComboBox_hasFrame';
function QComboBox_findText(handle: QComboBoxH; text: PWideString; flags: QtMatchFlags): Integer; cdecl; external Qt5PasLib name 'QComboBox_findText';
function QComboBox_findData(handle: QComboBoxH; data: QVariantH; role: QtItemDataRole; flags: QtMatchFlags): Integer; cdecl; external Qt5PasLib name 'QComboBox_findData';
function QComboBox_insertPolicy(handle: QComboBoxH): QComboBoxInsertPolicy; cdecl; external Qt5PasLib name 'QComboBox_insertPolicy';
procedure QComboBox_setInsertPolicy(handle: QComboBoxH; policy: QComboBoxInsertPolicy); cdecl; external Qt5PasLib name 'QComboBox_setInsertPolicy';
function QComboBox_sizeAdjustPolicy(handle: QComboBoxH): QComboBoxSizeAdjustPolicy; cdecl; external Qt5PasLib name 'QComboBox_sizeAdjustPolicy';
procedure QComboBox_setSizeAdjustPolicy(handle: QComboBoxH; policy: QComboBoxSizeAdjustPolicy); cdecl; external Qt5PasLib name 'QComboBox_setSizeAdjustPolicy';
function QComboBox_minimumContentsLength(handle: QComboBoxH): Integer; cdecl; external Qt5PasLib name 'QComboBox_minimumContentsLength';
procedure QComboBox_setMinimumContentsLength(handle: QComboBoxH; characters: Integer); cdecl; external Qt5PasLib name 'QComboBox_setMinimumContentsLength';
procedure QComboBox_iconSize(handle: QComboBoxH; retval: PSize); cdecl; external Qt5PasLib name 'QComboBox_iconSize';
procedure QComboBox_setIconSize(handle: QComboBoxH; size: PSize); cdecl; external Qt5PasLib name 'QComboBox_setIconSize';
function QComboBox_isEditable(handle: QComboBoxH): Boolean; cdecl; external Qt5PasLib name 'QComboBox_isEditable';
procedure QComboBox_setEditable(handle: QComboBoxH; editable: Boolean); cdecl; external Qt5PasLib name 'QComboBox_setEditable';
procedure QComboBox_setLineEdit(handle: QComboBoxH; edit: QLineEditH); cdecl; external Qt5PasLib name 'QComboBox_setLineEdit';
function QComboBox_lineEdit(handle: QComboBoxH): QLineEditH; cdecl; external Qt5PasLib name 'QComboBox_lineEdit';
procedure QComboBox_setValidator(handle: QComboBoxH; v: QValidatorH); cdecl; external Qt5PasLib name 'QComboBox_setValidator';
function QComboBox_validator(handle: QComboBoxH): QValidatorH; cdecl; external Qt5PasLib name 'QComboBox_validator';
procedure QComboBox_setCompleter(handle: QComboBoxH; c: QCompleterH); cdecl; external Qt5PasLib name 'QComboBox_setCompleter';
function QComboBox_completer(handle: QComboBoxH): QCompleterH; cdecl; external Qt5PasLib name 'QComboBox_completer';
function QComboBox_itemDelegate(handle: QComboBoxH): QAbstractItemDelegateH; cdecl; external Qt5PasLib name 'QComboBox_itemDelegate';
procedure QComboBox_setItemDelegate(handle: QComboBoxH; delegate: QAbstractItemDelegateH); cdecl; external Qt5PasLib name 'QComboBox_setItemDelegate';
function QComboBox_model(handle: QComboBoxH): QAbstractItemModelH; cdecl; external Qt5PasLib name 'QComboBox_model';
procedure QComboBox_setModel(handle: QComboBoxH; model: QAbstractItemModelH); cdecl; external Qt5PasLib name 'QComboBox_setModel';
procedure QComboBox_rootModelIndex(handle: QComboBoxH; retval: QModelIndexH); cdecl; external Qt5PasLib name 'QComboBox_rootModelIndex';
procedure QComboBox_setRootModelIndex(handle: QComboBoxH; index: QModelIndexH); cdecl; external Qt5PasLib name 'QComboBox_setRootModelIndex';
function QComboBox_modelColumn(handle: QComboBoxH): Integer; cdecl; external Qt5PasLib name 'QComboBox_modelColumn';
procedure QComboBox_setModelColumn(handle: QComboBoxH; visibleColumn: Integer); cdecl; external Qt5PasLib name 'QComboBox_setModelColumn';
function QComboBox_currentIndex(handle: QComboBoxH): Integer; cdecl; external Qt5PasLib name 'QComboBox_currentIndex';
procedure QComboBox_currentText(handle: QComboBoxH; retval: PWideString); cdecl; external Qt5PasLib name 'QComboBox_currentText';
procedure QComboBox_itemText(handle: QComboBoxH; retval: PWideString; index: Integer); cdecl; external Qt5PasLib name 'QComboBox_itemText';
procedure QComboBox_itemIcon(handle: QComboBoxH; retval: QIconH; index: Integer); cdecl; external Qt5PasLib name 'QComboBox_itemIcon';
procedure QComboBox_itemData(handle: QComboBoxH; retval: QVariantH; index: Integer; role: QtItemDataRole = QtUserRole); cdecl; external Qt5PasLib name 'QComboBox_itemData';
procedure QComboBox_addItem(handle: QComboBoxH; text: PWideString; userData: QVariantH = nil); cdecl; external Qt5PasLib name 'QComboBox_addItem';
procedure QComboBox_addItem(handle: QComboBoxH; icon: QIconH; text: PWideString; userData: QVariantH = nil); cdecl; external Qt5PasLib name 'QComboBox_addItem2';
procedure QComboBox_addItems(handle: QComboBoxH; texts: QStringListH); cdecl; external Qt5PasLib name 'QComboBox_addItems';
procedure QComboBox_insertItem(handle: QComboBoxH; index: Integer; text: PWideString; userData: QVariantH = nil); cdecl; external Qt5PasLib name 'QComboBox_insertItem';
procedure QComboBox_insertItem(handle: QComboBoxH; index: Integer; icon: QIconH; text: PWideString; userData: QVariantH = nil); cdecl; external Qt5PasLib name 'QComboBox_insertItem2';
procedure QComboBox_insertItems(handle: QComboBoxH; index: Integer; texts: QStringListH); cdecl; external Qt5PasLib name 'QComboBox_insertItems';
procedure QComboBox_insertSeparator(handle: QComboBoxH; index: Integer); cdecl; external Qt5PasLib name 'QComboBox_insertSeparator';
procedure QComboBox_removeItem(handle: QComboBoxH; index: Integer); cdecl; external Qt5PasLib name 'QComboBox_removeItem';
procedure QComboBox_setItemText(handle: QComboBoxH; index: Integer; text: PWideString); cdecl; external Qt5PasLib name 'QComboBox_setItemText';
procedure QComboBox_setItemIcon(handle: QComboBoxH; index: Integer; icon: QIconH); cdecl; external Qt5PasLib name 'QComboBox_setItemIcon';
procedure QComboBox_setItemData(handle: QComboBoxH; index: Integer; value: QVariantH; role: QtItemDataRole = QtUserRole); cdecl; external Qt5PasLib name 'QComboBox_setItemData';
function QComboBox_view(handle: QComboBoxH): QAbstractItemViewH; cdecl; external Qt5PasLib name 'QComboBox_view';
procedure QComboBox_setView(handle: QComboBoxH; itemView: QAbstractItemViewH); cdecl; external Qt5PasLib name 'QComboBox_setView';
procedure QComboBox_sizeHint(handle: QComboBoxH; retval: PSize); cdecl; external Qt5PasLib name 'QComboBox_sizeHint';
procedure QComboBox_minimumSizeHint(handle: QComboBoxH; retval: PSize); cdecl; external Qt5PasLib name 'QComboBox_minimumSizeHint';
procedure QComboBox_showPopup(handle: QComboBoxH); cdecl; external Qt5PasLib name 'QComboBox_showPopup';
procedure QComboBox_hidePopup(handle: QComboBoxH); cdecl; external Qt5PasLib name 'QComboBox_hidePopup';
function QComboBox_event(handle: QComboBoxH; event: QEventH): Boolean; cdecl; external Qt5PasLib name 'QComboBox_event';
procedure QComboBox_inputMethodQuery(handle: QComboBoxH; retval: QVariantH; AnonParam1: QtInputMethodQuery); cdecl; external Qt5PasLib name 'QComboBox_inputMethodQuery';
procedure QComboBox_clear(handle: QComboBoxH); cdecl; external Qt5PasLib name 'QComboBox_clear';
procedure QComboBox_clearEditText(handle: QComboBoxH); cdecl; external Qt5PasLib name 'QComboBox_clearEditText';
procedure QComboBox_setEditText(handle: QComboBoxH; text: PWideString); cdecl; external Qt5PasLib name 'QComboBox_setEditText';
procedure QComboBox_setCurrentIndex(handle: QComboBoxH; index: Integer); cdecl; external Qt5PasLib name 'QComboBox_setCurrentIndex';
procedure QComboBox_setCurrentText(handle: QComboBoxH; text: PWideString); cdecl; external Qt5PasLib name 'QComboBox_setCurrentText';


type
  QComboBox_editTextChanged_Event = procedure (AnonParam1: PWideString) of object cdecl;
  QComboBox_activated_Event = procedure (index: Integer) of object cdecl;
  QComboBox_activated2_Event = procedure (AnonParam1: PWideString) of object cdecl;
  QComboBox_highlighted_Event = procedure (index: Integer) of object cdecl;
  QComboBox_highlighted2_Event = procedure (AnonParam1: PWideString) of object cdecl;
  QComboBox_currentIndexChanged_Event = procedure (index: Integer) of object cdecl;
  QComboBox_currentIndexChanged2_Event = procedure (AnonParam1: PWideString) of object cdecl;
  QComboBox_currentTextChanged_Event = procedure (AnonParam1: PWideString) of object cdecl;


function QCheckBox_Create(parent: QWidgetH = nil): QCheckBoxH; cdecl; external Qt5PasLib name 'QCheckBox_Create';
procedure QCheckBox_Destroy(handle: QCheckBoxH); cdecl; external Qt5PasLib name 'QCheckBox_Destroy'; 
function QCheckBox_Create(text: PWideString; parent: QWidgetH = nil): QCheckBoxH; cdecl; external Qt5PasLib name 'QCheckBox_Create2';
procedure QCheckBox_sizeHint(handle: QCheckBoxH; retval: PSize); cdecl; external Qt5PasLib name 'QCheckBox_sizeHint';
procedure QCheckBox_minimumSizeHint(handle: QCheckBoxH; retval: PSize); cdecl; external Qt5PasLib name 'QCheckBox_minimumSizeHint';
procedure QCheckBox_setTristate(handle: QCheckBoxH; y: Boolean = True); cdecl; external Qt5PasLib name 'QCheckBox_setTristate';
function QCheckBox_isTristate(handle: QCheckBoxH): Boolean; cdecl; external Qt5PasLib name 'QCheckBox_isTristate';
function QCheckBox_checkState(handle: QCheckBoxH): QtCheckState; cdecl; external Qt5PasLib name 'QCheckBox_checkState';
procedure QCheckBox_setCheckState(handle: QCheckBoxH; state: QtCheckState); cdecl; external Qt5PasLib name 'QCheckBox_setCheckState';


type
  QCheckBox_stateChanged_Event = procedure (AnonParam1: Integer) of object cdecl;


type
  QSliderTickPosition = cardinal; //  QSlider::TickPosition (4)

const
    QSliderNoTicks = 0 { $0 };
    QSliderTicksAbove = 1 { $1 };
    QSliderTicksLeft = 1 { $1 };
    QSliderTicksBelow = 2 { $2 };
    QSliderTicksRight = 2 { $2 };
    QSliderTicksBothSides = 3 { $3 };


function QSlider_Create(parent: QWidgetH = nil): QSliderH; cdecl; external Qt5PasLib name 'QSlider_Create';
procedure QSlider_Destroy(handle: QSliderH); cdecl; external Qt5PasLib name 'QSlider_Destroy'; 
function QSlider_Create(orientation: QtOrientation; parent: QWidgetH = nil): QSliderH; cdecl; external Qt5PasLib name 'QSlider_Create2';
procedure QSlider_sizeHint(handle: QSliderH; retval: PSize); cdecl; external Qt5PasLib name 'QSlider_sizeHint';
procedure QSlider_minimumSizeHint(handle: QSliderH; retval: PSize); cdecl; external Qt5PasLib name 'QSlider_minimumSizeHint';
procedure QSlider_setTickPosition(handle: QSliderH; position: QSliderTickPosition); cdecl; external Qt5PasLib name 'QSlider_setTickPosition';
function QSlider_tickPosition(handle: QSliderH): QSliderTickPosition; cdecl; external Qt5PasLib name 'QSlider_tickPosition';
procedure QSlider_setTickInterval(handle: QSliderH; ti: Integer); cdecl; external Qt5PasLib name 'QSlider_setTickInterval';
function QSlider_tickInterval(handle: QSliderH): Integer; cdecl; external Qt5PasLib name 'QSlider_tickInterval';
function QSlider_event(handle: QSliderH; event: QEventH): Boolean; cdecl; external Qt5PasLib name 'QSlider_event';

function QTextBrowser_Create(parent: QWidgetH = nil): QTextBrowserH; cdecl; external Qt5PasLib name 'QTextBrowser_Create';
procedure QTextBrowser_Destroy(handle: QTextBrowserH); cdecl; external Qt5PasLib name 'QTextBrowser_Destroy'; 
procedure QTextBrowser_source(handle: QTextBrowserH; retval: QUrlH); cdecl; external Qt5PasLib name 'QTextBrowser_source';
procedure QTextBrowser_searchPaths(handle: QTextBrowserH; retval: QStringListH); cdecl; external Qt5PasLib name 'QTextBrowser_searchPaths';
procedure QTextBrowser_setSearchPaths(handle: QTextBrowserH; paths: QStringListH); cdecl; external Qt5PasLib name 'QTextBrowser_setSearchPaths';
procedure QTextBrowser_loadResource(handle: QTextBrowserH; retval: QVariantH; _type: Integer; name: QUrlH); cdecl; external Qt5PasLib name 'QTextBrowser_loadResource';
function QTextBrowser_isBackwardAvailable(handle: QTextBrowserH): Boolean; cdecl; external Qt5PasLib name 'QTextBrowser_isBackwardAvailable';
function QTextBrowser_isForwardAvailable(handle: QTextBrowserH): Boolean; cdecl; external Qt5PasLib name 'QTextBrowser_isForwardAvailable';
procedure QTextBrowser_clearHistory(handle: QTextBrowserH); cdecl; external Qt5PasLib name 'QTextBrowser_clearHistory';
procedure QTextBrowser_historyTitle(handle: QTextBrowserH; retval: PWideString; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QTextBrowser_historyTitle';
procedure QTextBrowser_historyUrl(handle: QTextBrowserH; retval: QUrlH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QTextBrowser_historyUrl';
function QTextBrowser_backwardHistoryCount(handle: QTextBrowserH): Integer; cdecl; external Qt5PasLib name 'QTextBrowser_backwardHistoryCount';
function QTextBrowser_forwardHistoryCount(handle: QTextBrowserH): Integer; cdecl; external Qt5PasLib name 'QTextBrowser_forwardHistoryCount';
function QTextBrowser_openExternalLinks(handle: QTextBrowserH): Boolean; cdecl; external Qt5PasLib name 'QTextBrowser_openExternalLinks';
procedure QTextBrowser_setOpenExternalLinks(handle: QTextBrowserH; open: Boolean); cdecl; external Qt5PasLib name 'QTextBrowser_setOpenExternalLinks';
function QTextBrowser_openLinks(handle: QTextBrowserH): Boolean; cdecl; external Qt5PasLib name 'QTextBrowser_openLinks';
procedure QTextBrowser_setOpenLinks(handle: QTextBrowserH; open: Boolean); cdecl; external Qt5PasLib name 'QTextBrowser_setOpenLinks';
procedure QTextBrowser_setSource(handle: QTextBrowserH; name: QUrlH); cdecl; external Qt5PasLib name 'QTextBrowser_setSource';
procedure QTextBrowser_backward(handle: QTextBrowserH); cdecl; external Qt5PasLib name 'QTextBrowser_backward';
procedure QTextBrowser_forward(handle: QTextBrowserH); cdecl; external Qt5PasLib name 'QTextBrowser_forward';
procedure QTextBrowser_home(handle: QTextBrowserH); cdecl; external Qt5PasLib name 'QTextBrowser_home';
procedure QTextBrowser_reload(handle: QTextBrowserH); cdecl; external Qt5PasLib name 'QTextBrowser_reload';


type
  QTextBrowser_backwardAvailable_Event = procedure (AnonParam1: Boolean) of object cdecl;
  QTextBrowser_forwardAvailable_Event = procedure (AnonParam1: Boolean) of object cdecl;
  QTextBrowser_historyChanged_Event = procedure () of object cdecl;
  QTextBrowser_sourceChanged_Event = procedure (AnonParam1: QUrlH) of object cdecl;
  QTextBrowser_highlighted_Event = procedure (AnonParam1: QUrlH) of object cdecl;
  QTextBrowser_highlighted2_Event = procedure (AnonParam1: PWideString) of object cdecl;
  QTextBrowser_anchorClicked_Event = procedure (AnonParam1: QUrlH) of object cdecl;


function QLabel_Create(parent: QWidgetH = nil; f: QtWindowFlags = 0): QLabelH; cdecl; external Qt5PasLib name 'QLabel_Create';
procedure QLabel_Destroy(handle: QLabelH); cdecl; external Qt5PasLib name 'QLabel_Destroy'; 
function QLabel_Create(text: PWideString; parent: QWidgetH = nil; f: QtWindowFlags = 0): QLabelH; cdecl; external Qt5PasLib name 'QLabel_Create2';
procedure QLabel_text(handle: QLabelH; retval: PWideString); cdecl; external Qt5PasLib name 'QLabel_text';
function QLabel_pixmap(handle: QLabelH): QPixmapH; cdecl; external Qt5PasLib name 'QLabel_pixmap';
function QLabel_picture(handle: QLabelH): QPictureH; cdecl; external Qt5PasLib name 'QLabel_picture';
function QLabel_movie(handle: QLabelH): QMovieH; cdecl; external Qt5PasLib name 'QLabel_movie';
function QLabel_textFormat(handle: QLabelH): QtTextFormat; cdecl; external Qt5PasLib name 'QLabel_textFormat';
procedure QLabel_setTextFormat(handle: QLabelH; AnonParam1: QtTextFormat); cdecl; external Qt5PasLib name 'QLabel_setTextFormat';
function QLabel_alignment(handle: QLabelH): QtAlignment; cdecl; external Qt5PasLib name 'QLabel_alignment';
procedure QLabel_setAlignment(handle: QLabelH; AnonParam1: QtAlignment); cdecl; external Qt5PasLib name 'QLabel_setAlignment';
procedure QLabel_setWordWrap(handle: QLabelH; _on: Boolean); cdecl; external Qt5PasLib name 'QLabel_setWordWrap';
function QLabel_wordWrap(handle: QLabelH): Boolean; cdecl; external Qt5PasLib name 'QLabel_wordWrap';
function QLabel_indent(handle: QLabelH): Integer; cdecl; external Qt5PasLib name 'QLabel_indent';
procedure QLabel_setIndent(handle: QLabelH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QLabel_setIndent';
function QLabel_margin(handle: QLabelH): Integer; cdecl; external Qt5PasLib name 'QLabel_margin';
procedure QLabel_setMargin(handle: QLabelH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QLabel_setMargin';
function QLabel_hasScaledContents(handle: QLabelH): Boolean; cdecl; external Qt5PasLib name 'QLabel_hasScaledContents';
procedure QLabel_setScaledContents(handle: QLabelH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QLabel_setScaledContents';
procedure QLabel_sizeHint(handle: QLabelH; retval: PSize); cdecl; external Qt5PasLib name 'QLabel_sizeHint';
procedure QLabel_minimumSizeHint(handle: QLabelH; retval: PSize); cdecl; external Qt5PasLib name 'QLabel_minimumSizeHint';
procedure QLabel_setBuddy(handle: QLabelH; AnonParam1: QWidgetH); cdecl; external Qt5PasLib name 'QLabel_setBuddy';
function QLabel_buddy(handle: QLabelH): QWidgetH; cdecl; external Qt5PasLib name 'QLabel_buddy';
function QLabel_heightForWidth(handle: QLabelH; AnonParam1: Integer): Integer; cdecl; external Qt5PasLib name 'QLabel_heightForWidth';
function QLabel_openExternalLinks(handle: QLabelH): Boolean; cdecl; external Qt5PasLib name 'QLabel_openExternalLinks';
procedure QLabel_setOpenExternalLinks(handle: QLabelH; open: Boolean); cdecl; external Qt5PasLib name 'QLabel_setOpenExternalLinks';
procedure QLabel_setTextInteractionFlags(handle: QLabelH; flags: QtTextInteractionFlags); cdecl; external Qt5PasLib name 'QLabel_setTextInteractionFlags';
function QLabel_textInteractionFlags(handle: QLabelH): QtTextInteractionFlags; cdecl; external Qt5PasLib name 'QLabel_textInteractionFlags';
procedure QLabel_setSelection(handle: QLabelH; AnonParam1: Integer; AnonParam2: Integer); cdecl; external Qt5PasLib name 'QLabel_setSelection';
function QLabel_hasSelectedText(handle: QLabelH): Boolean; cdecl; external Qt5PasLib name 'QLabel_hasSelectedText';
procedure QLabel_selectedText(handle: QLabelH; retval: PWideString); cdecl; external Qt5PasLib name 'QLabel_selectedText';
function QLabel_selectionStart(handle: QLabelH): Integer; cdecl; external Qt5PasLib name 'QLabel_selectionStart';
procedure QLabel_setText(handle: QLabelH; AnonParam1: PWideString); cdecl; external Qt5PasLib name 'QLabel_setText';
procedure QLabel_setPixmap(handle: QLabelH; AnonParam1: QPixmapH); cdecl; external Qt5PasLib name 'QLabel_setPixmap';
procedure QLabel_setPicture(handle: QLabelH; AnonParam1: QPictureH); cdecl; external Qt5PasLib name 'QLabel_setPicture';
procedure QLabel_setMovie(handle: QLabelH; movie: QMovieH); cdecl; external Qt5PasLib name 'QLabel_setMovie';
procedure QLabel_setNum(handle: QLabelH; AnonParam1: Integer); cdecl; external Qt5PasLib name 'QLabel_setNum';
procedure QLabel_setNum(handle: QLabelH; AnonParam1: Double); cdecl; external Qt5PasLib name 'QLabel_setNum2';
procedure QLabel_clear(handle: QLabelH); cdecl; external Qt5PasLib name 'QLabel_clear';


type
  QLabel_linkActivated_Event = procedure (link: PWideString) of object cdecl;
  QLabel_linkHovered_Event = procedure (link: PWideString) of object cdecl;


function QGroupBox_Create(parent: QWidgetH = nil): QGroupBoxH; cdecl; external Qt5PasLib name 'QGroupBox_Create';
procedure QGroupBox_Destroy(handle: QGroupBoxH); cdecl; external Qt5PasLib name 'QGroupBox_Destroy'; 
function QGroupBox_Create(title: PWideString; parent: QWidgetH = nil): QGroupBoxH; cdecl; external Qt5PasLib name 'QGroupBox_Create2';
procedure QGroupBox_title(handle: QGroupBoxH; retval: PWideString); cdecl; external Qt5PasLib name 'QGroupBox_title';
procedure QGroupBox_setTitle(handle: QGroupBoxH; title: PWideString); cdecl; external Qt5PasLib name 'QGroupBox_setTitle';
function QGroupBox_alignment(handle: QGroupBoxH): QtAlignment; cdecl; external Qt5PasLib name 'QGroupBox_alignment';
procedure QGroupBox_setAlignment(handle: QGroupBoxH; alignment: Integer); cdecl; external Qt5PasLib name 'QGroupBox_setAlignment';
procedure QGroupBox_minimumSizeHint(handle: QGroupBoxH; retval: PSize); cdecl; external Qt5PasLib name 'QGroupBox_minimumSizeHint';
function QGroupBox_isFlat(handle: QGroupBoxH): Boolean; cdecl; external Qt5PasLib name 'QGroupBox_isFlat';
procedure QGroupBox_setFlat(handle: QGroupBoxH; flat: Boolean); cdecl; external Qt5PasLib name 'QGroupBox_setFlat';
function QGroupBox_isCheckable(handle: QGroupBoxH): Boolean; cdecl; external Qt5PasLib name 'QGroupBox_isCheckable';
procedure QGroupBox_setCheckable(handle: QGroupBoxH; checkable: Boolean); cdecl; external Qt5PasLib name 'QGroupBox_setCheckable';
function QGroupBox_isChecked(handle: QGroupBoxH): Boolean; cdecl; external Qt5PasLib name 'QGroupBox_isChecked';
procedure QGroupBox_setChecked(handle: QGroupBoxH; checked: Boolean); cdecl; external Qt5PasLib name 'QGroupBox_setChecked';


type
  QGroupBox_clicked_Event = procedure (checked: Boolean = False) of object cdecl;
  QGroupBox_clicked2_Event = procedure () of object cdecl;
  QGroupBox_toggled_Event = procedure (AnonParam1: Boolean) of object cdecl;


type
  QDockWidgetDockWidgetFeature = cardinal; //  QDockWidget::DockWidgetFeature (4)
  QDockWidgetDockWidgetFeatures = QDockWidgetDockWidgetFeature; // QFlags<>

const
    QDockWidgetDockWidgetClosable = 1 { $1 };
    QDockWidgetDockWidgetMovable = 2 { $2 };
    QDockWidgetDockWidgetFloatable = 4 { $4 };
    QDockWidgetDockWidgetVerticalTitleBar = 8 { $8 };
    QDockWidgetDockWidgetFeatureMask = 15 { $f };
    QDockWidgetAllDockWidgetFeatures = 7 { $7 };
    QDockWidgetNoDockWidgetFeatures = 0 { $0 };
    QDockWidgetReserved = 255 { $ff };


function QDockWidget_Create(title: PWideString; parent: QWidgetH = nil; flags: QtWindowFlags = 0): QDockWidgetH; cdecl; external Qt5PasLib name 'QDockWidget_Create';
procedure QDockWidget_Destroy(handle: QDockWidgetH); cdecl; external Qt5PasLib name 'QDockWidget_Destroy'; 
function QDockWidget_Create(parent: QWidgetH = nil; flags: QtWindowFlags = 0): QDockWidgetH; cdecl; external Qt5PasLib name 'QDockWidget_Create2';
function QDockWidget_widget(handle: QDockWidgetH): QWidgetH; cdecl; external Qt5PasLib name 'QDockWidget_widget';
procedure QDockWidget_setWidget(handle: QDockWidgetH; widget: QWidgetH); cdecl; external Qt5PasLib name 'QDockWidget_setWidget';
procedure QDockWidget_setFeatures(handle: QDockWidgetH; features: QDockWidgetDockWidgetFeatures); cdecl; external Qt5PasLib name 'QDockWidget_setFeatures';
function QDockWidget_features(handle: QDockWidgetH): QDockWidgetDockWidgetFeatures; cdecl; external Qt5PasLib name 'QDockWidget_features';
procedure QDockWidget_setFloating(handle: QDockWidgetH; floating: Boolean); cdecl; external Qt5PasLib name 'QDockWidget_setFloating';
function QDockWidget_isFloating(handle: QDockWidgetH): Boolean; cdecl; external Qt5PasLib name 'QDockWidget_isFloating';
procedure QDockWidget_setAllowedAreas(handle: QDockWidgetH; areas: QtDockWidgetAreas); cdecl; external Qt5PasLib name 'QDockWidget_setAllowedAreas';
function QDockWidget_allowedAreas(handle: QDockWidgetH): QtDockWidgetAreas; cdecl; external Qt5PasLib name 'QDockWidget_allowedAreas';
procedure QDockWidget_setTitleBarWidget(handle: QDockWidgetH; widget: QWidgetH); cdecl; external Qt5PasLib name 'QDockWidget_setTitleBarWidget';
function QDockWidget_titleBarWidget(handle: QDockWidgetH): QWidgetH; cdecl; external Qt5PasLib name 'QDockWidget_titleBarWidget';
function QDockWidget_isAreaAllowed(handle: QDockWidgetH; area: QtDockWidgetArea): Boolean; cdecl; external Qt5PasLib name 'QDockWidget_isAreaAllowed';
function QDockWidget_toggleViewAction(handle: QDockWidgetH): QActionH; cdecl; external Qt5PasLib name 'QDockWidget_toggleViewAction';


type
  QDockWidget_featuresChanged_Event = procedure (features: QDockWidgetDockWidgetFeatures) of object cdecl;
  QDockWidget_topLevelChanged_Event = procedure (topLevel: Boolean) of object cdecl;
  QDockWidget_allowedAreasChanged_Event = procedure (allowedAreas: QtDockWidgetAreas) of object cdecl;
  QDockWidget_visibilityChanged_Event = procedure (visible: Boolean) of object cdecl;
  QDockWidget_dockLocationChanged_Event = procedure (area: QtDockWidgetArea) of object cdecl;



type
  QTabBarShape = ( // QTabBar::Shape (1)
    QTabBarRoundedNorth, QTabBarRoundedSouth, QTabBarRoundedWest, QTabBarRoundedEast, QTabBarTriangularNorth, QTabBarTriangularSouth, QTabBarTriangularWest, QTabBarTriangularEast );

  QTabBarButtonPosition = ( // QTabBar::ButtonPosition (1)
    QTabBarLeftSide, QTabBarRightSide );

  QTabBarSelectionBehavior = ( // QTabBar::SelectionBehavior (1)
    QTabBarSelectLeftTab, QTabBarSelectRightTab, QTabBarSelectPreviousTab );

function QTabBar_Create(parent: QWidgetH = nil): QTabBarH; cdecl; external Qt5PasLib name 'QTabBar_Create';
procedure QTabBar_Destroy(handle: QTabBarH); cdecl; external Qt5PasLib name 'QTabBar_Destroy'; 
function QTabBar_shape(handle: QTabBarH): QTabBarShape; cdecl; external Qt5PasLib name 'QTabBar_shape';
procedure QTabBar_setShape(handle: QTabBarH; shape: QTabBarShape); cdecl; external Qt5PasLib name 'QTabBar_setShape';
function QTabBar_addTab(handle: QTabBarH; text: PWideString): Integer; cdecl; external Qt5PasLib name 'QTabBar_addTab';
function QTabBar_addTab(handle: QTabBarH; icon: QIconH; text: PWideString): Integer; cdecl; external Qt5PasLib name 'QTabBar_addTab2';
function QTabBar_insertTab(handle: QTabBarH; index: Integer; text: PWideString): Integer; cdecl; external Qt5PasLib name 'QTabBar_insertTab';
function QTabBar_insertTab(handle: QTabBarH; index: Integer; icon: QIconH; text: PWideString): Integer; cdecl; external Qt5PasLib name 'QTabBar_insertTab2';
procedure QTabBar_removeTab(handle: QTabBarH; index: Integer); cdecl; external Qt5PasLib name 'QTabBar_removeTab';
procedure QTabBar_moveTab(handle: QTabBarH; from: Integer; _to: Integer); cdecl; external Qt5PasLib name 'QTabBar_moveTab';
function QTabBar_isTabEnabled(handle: QTabBarH; index: Integer): Boolean; cdecl; external Qt5PasLib name 'QTabBar_isTabEnabled';
procedure QTabBar_setTabEnabled(handle: QTabBarH; index: Integer; AnonParam2: Boolean); cdecl; external Qt5PasLib name 'QTabBar_setTabEnabled';
procedure QTabBar_tabText(handle: QTabBarH; retval: PWideString; index: Integer); cdecl; external Qt5PasLib name 'QTabBar_tabText';
procedure QTabBar_setTabText(handle: QTabBarH; index: Integer; text: PWideString); cdecl; external Qt5PasLib name 'QTabBar_setTabText';
procedure QTabBar_tabTextColor(handle: QTabBarH; retval: PQColor; index: Integer); cdecl; external Qt5PasLib name 'QTabBar_tabTextColor';
procedure QTabBar_setTabTextColor(handle: QTabBarH; index: Integer; color: PQColor); cdecl; external Qt5PasLib name 'QTabBar_setTabTextColor';
procedure QTabBar_tabIcon(handle: QTabBarH; retval: QIconH; index: Integer); cdecl; external Qt5PasLib name 'QTabBar_tabIcon';
procedure QTabBar_setTabIcon(handle: QTabBarH; index: Integer; icon: QIconH); cdecl; external Qt5PasLib name 'QTabBar_setTabIcon';
function QTabBar_elideMode(handle: QTabBarH): QtTextElideMode; cdecl; external Qt5PasLib name 'QTabBar_elideMode';
procedure QTabBar_setElideMode(handle: QTabBarH; AnonParam1: QtTextElideMode); cdecl; external Qt5PasLib name 'QTabBar_setElideMode';
procedure QTabBar_setTabToolTip(handle: QTabBarH; index: Integer; tip: PWideString); cdecl; external Qt5PasLib name 'QTabBar_setTabToolTip';
procedure QTabBar_tabToolTip(handle: QTabBarH; retval: PWideString; index: Integer); cdecl; external Qt5PasLib name 'QTabBar_tabToolTip';
procedure QTabBar_setTabWhatsThis(handle: QTabBarH; index: Integer; text: PWideString); cdecl; external Qt5PasLib name 'QTabBar_setTabWhatsThis';
procedure QTabBar_tabWhatsThis(handle: QTabBarH; retval: PWideString; index: Integer); cdecl; external Qt5PasLib name 'QTabBar_tabWhatsThis';
procedure QTabBar_setTabData(handle: QTabBarH; index: Integer; data: QVariantH); cdecl; external Qt5PasLib name 'QTabBar_setTabData';
procedure QTabBar_tabData(handle: QTabBarH; retval: QVariantH; index: Integer); cdecl; external Qt5PasLib name 'QTabBar_tabData';
procedure QTabBar_tabRect(handle: QTabBarH; retval: PRect; index: Integer); cdecl; external Qt5PasLib name 'QTabBar_tabRect';
function QTabBar_tabAt(handle: QTabBarH; pos: PQtPoint): Integer; cdecl; external Qt5PasLib name 'QTabBar_tabAt';
function QTabBar_currentIndex(handle: QTabBarH): Integer; cdecl; external Qt5PasLib name 'QTabBar_currentIndex';
function QTabBar_count(handle: QTabBarH): Integer; cdecl; external Qt5PasLib name 'QTabBar_count';
procedure QTabBar_sizeHint(handle: QTabBarH; retval: PSize); cdecl; external Qt5PasLib name 'QTabBar_sizeHint';
procedure QTabBar_minimumSizeHint(handle: QTabBarH; retval: PSize); cdecl; external Qt5PasLib name 'QTabBar_minimumSizeHint';
procedure QTabBar_setDrawBase(handle: QTabBarH; drawTheBase: Boolean); cdecl; external Qt5PasLib name 'QTabBar_setDrawBase';
function QTabBar_drawBase(handle: QTabBarH): Boolean; cdecl; external Qt5PasLib name 'QTabBar_drawBase';
procedure QTabBar_iconSize(handle: QTabBarH; retval: PSize); cdecl; external Qt5PasLib name 'QTabBar_iconSize';
procedure QTabBar_setIconSize(handle: QTabBarH; size: PSize); cdecl; external Qt5PasLib name 'QTabBar_setIconSize';
function QTabBar_usesScrollButtons(handle: QTabBarH): Boolean; cdecl; external Qt5PasLib name 'QTabBar_usesScrollButtons';
procedure QTabBar_setUsesScrollButtons(handle: QTabBarH; useButtons: Boolean); cdecl; external Qt5PasLib name 'QTabBar_setUsesScrollButtons';
function QTabBar_tabsClosable(handle: QTabBarH): Boolean; cdecl; external Qt5PasLib name 'QTabBar_tabsClosable';
procedure QTabBar_setTabsClosable(handle: QTabBarH; closable: Boolean); cdecl; external Qt5PasLib name 'QTabBar_setTabsClosable';
procedure QTabBar_setTabButton(handle: QTabBarH; index: Integer; position: QTabBarButtonPosition; widget: QWidgetH); cdecl; external Qt5PasLib name 'QTabBar_setTabButton';
function QTabBar_tabButton(handle: QTabBarH; index: Integer; position: QTabBarButtonPosition): QWidgetH; cdecl; external Qt5PasLib name 'QTabBar_tabButton';
function QTabBar_selectionBehaviorOnRemove(handle: QTabBarH): QTabBarSelectionBehavior; cdecl; external Qt5PasLib name 'QTabBar_selectionBehaviorOnRemove';
procedure QTabBar_setSelectionBehaviorOnRemove(handle: QTabBarH; behavior: QTabBarSelectionBehavior); cdecl; external Qt5PasLib name 'QTabBar_setSelectionBehaviorOnRemove';
function QTabBar_expanding(handle: QTabBarH): Boolean; cdecl; external Qt5PasLib name 'QTabBar_expanding';
procedure QTabBar_setExpanding(handle: QTabBarH; enabled: Boolean); cdecl; external Qt5PasLib name 'QTabBar_setExpanding';
function QTabBar_isMovable(handle: QTabBarH): Boolean; cdecl; external Qt5PasLib name 'QTabBar_isMovable';
procedure QTabBar_setMovable(handle: QTabBarH; movable: Boolean); cdecl; external Qt5PasLib name 'QTabBar_setMovable';
function QTabBar_documentMode(handle: QTabBarH): Boolean; cdecl; external Qt5PasLib name 'QTabBar_documentMode';
procedure QTabBar_setDocumentMode(handle: QTabBarH; _set: Boolean); cdecl; external Qt5PasLib name 'QTabBar_setDocumentMode';
procedure QTabBar_setCurrentIndex(handle: QTabBarH; index: Integer); cdecl; external Qt5PasLib name 'QTabBar_setCurrentIndex';


type
  QTabBar_currentChanged_Event = procedure (index: Integer) of object cdecl;
  QTabBar_tabCloseRequested_Event = procedure (index: Integer) of object cdecl;
  QTabBar_tabMoved_Event = procedure (from: Integer; _to: Integer) of object cdecl;



type
  QProgressBarDirection = ( // QProgressBar::Direction (1)
    QProgressBarTopToBottom, QProgressBarBottomToTop );

function QProgressBar_Create(parent: QWidgetH = nil): QProgressBarH; cdecl; external Qt5PasLib name 'QProgressBar_Create';
procedure QProgressBar_Destroy(handle: QProgressBarH); cdecl; external Qt5PasLib name 'QProgressBar_Destroy'; 
function QProgressBar_minimum(handle: QProgressBarH): Integer; cdecl; external Qt5PasLib name 'QProgressBar_minimum';
function QProgressBar_maximum(handle: QProgressBarH): Integer; cdecl; external Qt5PasLib name 'QProgressBar_maximum';
function QProgressBar_value(handle: QProgressBarH): Integer; cdecl; external Qt5PasLib name 'QProgressBar_value';
procedure QProgressBar_text(handle: QProgressBarH; retval: PWideString); cdecl; external Qt5PasLib name 'QProgressBar_text';
procedure QProgressBar_setTextVisible(handle: QProgressBarH; visible: Boolean); cdecl; external Qt5PasLib name 'QProgressBar_setTextVisible';
function QProgressBar_isTextVisible(handle: QProgressBarH): Boolean; cdecl; external Qt5PasLib name 'QProgressBar_isTextVisible';
function QProgressBar_alignment(handle: QProgressBarH): QtAlignment; cdecl; external Qt5PasLib name 'QProgressBar_alignment';
procedure QProgressBar_setAlignment(handle: QProgressBarH; alignment: QtAlignment); cdecl; external Qt5PasLib name 'QProgressBar_setAlignment';
procedure QProgressBar_sizeHint(handle: QProgressBarH; retval: PSize); cdecl; external Qt5PasLib name 'QProgressBar_sizeHint';
procedure QProgressBar_minimumSizeHint(handle: QProgressBarH; retval: PSize); cdecl; external Qt5PasLib name 'QProgressBar_minimumSizeHint';
function QProgressBar_orientation(handle: QProgressBarH): QtOrientation; cdecl; external Qt5PasLib name 'QProgressBar_orientation';
procedure QProgressBar_setInvertedAppearance(handle: QProgressBarH; invert: Boolean); cdecl; external Qt5PasLib name 'QProgressBar_setInvertedAppearance';
function QProgressBar_invertedAppearance(handle: QProgressBarH): Boolean; cdecl; external Qt5PasLib name 'QProgressBar_invertedAppearance';
procedure QProgressBar_setTextDirection(handle: QProgressBarH; textDirection: QProgressBarDirection); cdecl; external Qt5PasLib name 'QProgressBar_setTextDirection';
function QProgressBar_textDirection(handle: QProgressBarH): QProgressBarDirection; cdecl; external Qt5PasLib name 'QProgressBar_textDirection';
procedure QProgressBar_setFormat(handle: QProgressBarH; format: PWideString); cdecl; external Qt5PasLib name 'QProgressBar_setFormat';
procedure QProgressBar_resetFormat(handle: QProgressBarH); cdecl; external Qt5PasLib name 'QProgressBar_resetFormat';
procedure QProgressBar_format(handle: QProgressBarH; retval: PWideString); cdecl; external Qt5PasLib name 'QProgressBar_format';
procedure QProgressBar_reset(handle: QProgressBarH); cdecl; external Qt5PasLib name 'QProgressBar_reset';
procedure QProgressBar_setRange(handle: QProgressBarH; minimum: Integer; maximum: Integer); cdecl; external Qt5PasLib name 'QProgressBar_setRange';
procedure QProgressBar_setMinimum(handle: QProgressBarH; minimum: Integer); cdecl; external Qt5PasLib name 'QProgressBar_setMinimum';
procedure QProgressBar_setMaximum(handle: QProgressBarH; maximum: Integer); cdecl; external Qt5PasLib name 'QProgressBar_setMaximum';
procedure QProgressBar_setValue(handle: QProgressBarH; value: Integer); cdecl; external Qt5PasLib name 'QProgressBar_setValue';
procedure QProgressBar_setOrientation(handle: QProgressBarH; AnonParam1: QtOrientation); cdecl; external Qt5PasLib name 'QProgressBar_setOrientation';


type
  QProgressBar_valueChanged_Event = procedure (value: Integer) of object cdecl;


function QStatusBar_Create(parent: QWidgetH = nil): QStatusBarH; cdecl; external Qt5PasLib name 'QStatusBar_Create';
procedure QStatusBar_Destroy(handle: QStatusBarH); cdecl; external Qt5PasLib name 'QStatusBar_Destroy'; 
procedure QStatusBar_addWidget(handle: QStatusBarH; widget: QWidgetH; stretch: Integer = 0); cdecl; external Qt5PasLib name 'QStatusBar_addWidget';
function QStatusBar_insertWidget(handle: QStatusBarH; index: Integer; widget: QWidgetH; stretch: Integer = 0): Integer; cdecl; external Qt5PasLib name 'QStatusBar_insertWidget';
procedure QStatusBar_addPermanentWidget(handle: QStatusBarH; widget: QWidgetH; stretch: Integer = 0); cdecl; external Qt5PasLib name 'QStatusBar_addPermanentWidget';
function QStatusBar_insertPermanentWidget(handle: QStatusBarH; index: Integer; widget: QWidgetH; stretch: Integer = 0): Integer; cdecl; external Qt5PasLib name 'QStatusBar_insertPermanentWidget';
procedure QStatusBar_removeWidget(handle: QStatusBarH; widget: QWidgetH); cdecl; external Qt5PasLib name 'QStatusBar_removeWidget';
procedure QStatusBar_setSizeGripEnabled(handle: QStatusBarH; AnonParam1: Boolean); cdecl; external Qt5PasLib name 'QStatusBar_setSizeGripEnabled';
function QStatusBar_isSizeGripEnabled(handle: QStatusBarH): Boolean; cdecl; external Qt5PasLib name 'QStatusBar_isSizeGripEnabled';
procedure QStatusBar_currentMessage(handle: QStatusBarH; retval: PWideString); cdecl; external Qt5PasLib name 'QStatusBar_currentMessage';
procedure QStatusBar_showMessage(handle: QStatusBarH; text: PWideString; timeout: Integer = 0); cdecl; external Qt5PasLib name 'QStatusBar_showMessage';
procedure QStatusBar_clearMessage(handle: QStatusBarH); cdecl; external Qt5PasLib name 'QStatusBar_clearMessage';


type
  QStatusBar_messageChanged_Event = procedure (text: PWideString) of object cdecl;


function QToolBox_Create(parent: QWidgetH = nil; f: QtWindowFlags = 0): QToolBoxH; cdecl; external Qt5PasLib name 'QToolBox_Create';
procedure QToolBox_Destroy(handle: QToolBoxH); cdecl; external Qt5PasLib name 'QToolBox_Destroy'; 
function QToolBox_addItem(handle: QToolBoxH; widget: QWidgetH; text: PWideString): Integer; cdecl; external Qt5PasLib name 'QToolBox_addItem';
function QToolBox_addItem(handle: QToolBoxH; widget: QWidgetH; icon: QIconH; text: PWideString): Integer; cdecl; external Qt5PasLib name 'QToolBox_addItem2';
function QToolBox_insertItem(handle: QToolBoxH; index: Integer; widget: QWidgetH; text: PWideString): Integer; cdecl; external Qt5PasLib name 'QToolBox_insertItem';
function QToolBox_insertItem(handle: QToolBoxH; index: Integer; widget: QWidgetH; icon: QIconH; text: PWideString): Integer; cdecl; external Qt5PasLib name 'QToolBox_insertItem2';
procedure QToolBox_removeItem(handle: QToolBoxH; index: Integer); cdecl; external Qt5PasLib name 'QToolBox_removeItem';
procedure QToolBox_setItemEnabled(handle: QToolBoxH; index: Integer; enabled: Boolean); cdecl; external Qt5PasLib name 'QToolBox_setItemEnabled';
function QToolBox_isItemEnabled(handle: QToolBoxH; index: Integer): Boolean; cdecl; external Qt5PasLib name 'QToolBox_isItemEnabled';
procedure QToolBox_setItemText(handle: QToolBoxH; index: Integer; text: PWideString); cdecl; external Qt5PasLib name 'QToolBox_setItemText';
procedure QToolBox_itemText(handle: QToolBoxH; retval: PWideString; index: Integer); cdecl; external Qt5PasLib name 'QToolBox_itemText';
procedure QToolBox_setItemIcon(handle: QToolBoxH; index: Integer; icon: QIconH); cdecl; external Qt5PasLib name 'QToolBox_setItemIcon';
procedure QToolBox_itemIcon(handle: QToolBoxH; retval: QIconH; index: Integer); cdecl; external Qt5PasLib name 'QToolBox_itemIcon';
procedure QToolBox_setItemToolTip(handle: QToolBoxH; index: Integer; toolTip: PWideString); cdecl; external Qt5PasLib name 'QToolBox_setItemToolTip';
procedure QToolBox_itemToolTip(handle: QToolBoxH; retval: PWideString; index: Integer); cdecl; external Qt5PasLib name 'QToolBox_itemToolTip';
function QToolBox_currentIndex(handle: QToolBoxH): Integer; cdecl; external Qt5PasLib name 'QToolBox_currentIndex';
function QToolBox_currentWidget(handle: QToolBoxH): QWidgetH; cdecl; external Qt5PasLib name 'QToolBox_currentWidget';
function QToolBox_widget(handle: QToolBoxH; index: Integer): QWidgetH; cdecl; external Qt5PasLib name 'QToolBox_widget';
function QToolBox_indexOf(handle: QToolBoxH; widget: QWidgetH): Integer; cdecl; external Qt5PasLib name 'QToolBox_indexOf';
function QToolBox_count(handle: QToolBoxH): Integer; cdecl; external Qt5PasLib name 'QToolBox_count';
procedure QToolBox_setCurrentIndex(handle: QToolBoxH; index: Integer); cdecl; external Qt5PasLib name 'QToolBox_setCurrentIndex';
procedure QToolBox_setCurrentWidget(handle: QToolBoxH; widget: QWidgetH); cdecl; external Qt5PasLib name 'QToolBox_setCurrentWidget';


type
  QToolBox_currentChanged_Event = procedure (index: Integer) of object cdecl;



type
  QToolButtonToolButtonPopupMode = ( // QToolButton::ToolButtonPopupMode (1)
    QToolButtonDelayedPopup, QToolButtonMenuButtonPopup, QToolButtonInstantPopup );

function QToolButton_Create(parent: QWidgetH = nil): QToolButtonH; cdecl; external Qt5PasLib name 'QToolButton_Create';
procedure QToolButton_Destroy(handle: QToolButtonH); cdecl; external Qt5PasLib name 'QToolButton_Destroy'; 
procedure QToolButton_sizeHint(handle: QToolButtonH; retval: PSize); cdecl; external Qt5PasLib name 'QToolButton_sizeHint';
procedure QToolButton_minimumSizeHint(handle: QToolButtonH; retval: PSize); cdecl; external Qt5PasLib name 'QToolButton_minimumSizeHint';
function QToolButton_toolButtonStyle(handle: QToolButtonH): QtToolButtonStyle; cdecl; external Qt5PasLib name 'QToolButton_toolButtonStyle';
function QToolButton_arrowType(handle: QToolButtonH): QtArrowType; cdecl; external Qt5PasLib name 'QToolButton_arrowType';
procedure QToolButton_setArrowType(handle: QToolButtonH; _type: QtArrowType); cdecl; external Qt5PasLib name 'QToolButton_setArrowType';
procedure QToolButton_setMenu(handle: QToolButtonH; menu: QMenuH); cdecl; external Qt5PasLib name 'QToolButton_setMenu';
function QToolButton_menu(handle: QToolButtonH): QMenuH; cdecl; external Qt5PasLib name 'QToolButton_menu';
procedure QToolButton_setPopupMode(handle: QToolButtonH; mode: QToolButtonToolButtonPopupMode); cdecl; external Qt5PasLib name 'QToolButton_setPopupMode';
function QToolButton_popupMode(handle: QToolButtonH): QToolButtonToolButtonPopupMode; cdecl; external Qt5PasLib name 'QToolButton_popupMode';
function QToolButton_defaultAction(handle: QToolButtonH): QActionH; cdecl; external Qt5PasLib name 'QToolButton_defaultAction';
procedure QToolButton_setAutoRaise(handle: QToolButtonH; enable: Boolean); cdecl; external Qt5PasLib name 'QToolButton_setAutoRaise';
function QToolButton_autoRaise(handle: QToolButtonH): Boolean; cdecl; external Qt5PasLib name 'QToolButton_autoRaise';
procedure QToolButton_showMenu(handle: QToolButtonH); cdecl; external Qt5PasLib name 'QToolButton_showMenu';
procedure QToolButton_setToolButtonStyle(handle: QToolButtonH; style: QtToolButtonStyle); cdecl; external Qt5PasLib name 'QToolButton_setToolButtonStyle';
procedure QToolButton_setDefaultAction(handle: QToolButtonH; AnonParam1: QActionH); cdecl; external Qt5PasLib name 'QToolButton_setDefaultAction';


type
  QToolButton_triggered_Event = procedure (AnonParam1: QActionH) of object cdecl;


function QScrollArea_Create(parent: QWidgetH = nil): QScrollAreaH; cdecl; external Qt5PasLib name 'QScrollArea_Create';
procedure QScrollArea_Destroy(handle: QScrollAreaH); cdecl; external Qt5PasLib name 'QScrollArea_Destroy'; 
function QScrollArea_widget(handle: QScrollAreaH): QWidgetH; cdecl; external Qt5PasLib name 'QScrollArea_widget';
procedure QScrollArea_setWidget(handle: QScrollAreaH; widget: QWidgetH); cdecl; external Qt5PasLib name 'QScrollArea_setWidget';
function QScrollArea_takeWidget(handle: QScrollAreaH): QWidgetH; cdecl; external Qt5PasLib name 'QScrollArea_takeWidget';
function QScrollArea_widgetResizable(handle: QScrollAreaH): Boolean; cdecl; external Qt5PasLib name 'QScrollArea_widgetResizable';
procedure QScrollArea_setWidgetResizable(handle: QScrollAreaH; resizable: Boolean); cdecl; external Qt5PasLib name 'QScrollArea_setWidgetResizable';
procedure QScrollArea_sizeHint(handle: QScrollAreaH; retval: PSize); cdecl; external Qt5PasLib name 'QScrollArea_sizeHint';
function QScrollArea_focusNextPrevChild(handle: QScrollAreaH; next: Boolean): Boolean; cdecl; external Qt5PasLib name 'QScrollArea_focusNextPrevChild';
function QScrollArea_alignment(handle: QScrollAreaH): QtAlignment; cdecl; external Qt5PasLib name 'QScrollArea_alignment';
procedure QScrollArea_setAlignment(handle: QScrollAreaH; AnonParam1: QtAlignment); cdecl; external Qt5PasLib name 'QScrollArea_setAlignment';
procedure QScrollArea_ensureVisible(handle: QScrollAreaH; x: Integer; y: Integer; xmargin: Integer = 50; ymargin: Integer = 50); cdecl; external Qt5PasLib name 'QScrollArea_ensureVisible';
procedure QScrollArea_ensureWidgetVisible(handle: QScrollAreaH; childWidget: QWidgetH; xmargin: Integer = 50; ymargin: Integer = 50); cdecl; external Qt5PasLib name 'QScrollArea_ensureWidgetVisible';


type
  QMdiAreaWindowOrder = ( // QMdiArea::WindowOrder (1)
    QMdiAreaCreationOrder, QMdiAreaStackingOrder, QMdiAreaActivationHistoryOrder );

  QMdiAreaViewMode = ( // QMdiArea::ViewMode (1)
    QMdiAreaSubWindowView, QMdiAreaTabbedView );

type
  QMdiAreaAreaOption = cardinal; // QMdiArea::AreaOption
  QMdiAreaAreaOptions = QMdiAreaAreaOption; //QFlags<> (3)
const
  QMdiAreaDontMaximizeSubWindowOnActivation =   $1;

function QMdiArea_Create(parent: QWidgetH = nil): QMdiAreaH; cdecl; external Qt5PasLib name 'QMdiArea_Create';
procedure QMdiArea_Destroy(handle: QMdiAreaH); cdecl; external Qt5PasLib name 'QMdiArea_Destroy'; 
procedure QMdiArea_sizeHint(handle: QMdiAreaH; retval: PSize); cdecl; external Qt5PasLib name 'QMdiArea_sizeHint';
procedure QMdiArea_minimumSizeHint(handle: QMdiAreaH; retval: PSize); cdecl; external Qt5PasLib name 'QMdiArea_minimumSizeHint';
function QMdiArea_currentSubWindow(handle: QMdiAreaH): QMdiSubWindowH; cdecl; external Qt5PasLib name 'QMdiArea_currentSubWindow';
function QMdiArea_activeSubWindow(handle: QMdiAreaH): QMdiSubWindowH; cdecl; external Qt5PasLib name 'QMdiArea_activeSubWindow';
procedure QMdiArea_subWindowList(handle: QMdiAreaH; retval: PPtrIntArray; order: QMdiAreaWindowOrder = QMdiAreaCreationOrder); cdecl; external Qt5PasLib name 'QMdiArea_subWindowList';
function QMdiArea_addSubWindow(handle: QMdiAreaH; widget: QWidgetH; flags: QtWindowFlags = 0): QMdiSubWindowH; cdecl; external Qt5PasLib name 'QMdiArea_addSubWindow';
procedure QMdiArea_removeSubWindow(handle: QMdiAreaH; widget: QWidgetH); cdecl; external Qt5PasLib name 'QMdiArea_removeSubWindow';
procedure QMdiArea_background(handle: QMdiAreaH; retval: QBrushH); cdecl; external Qt5PasLib name 'QMdiArea_background';
procedure QMdiArea_setBackground(handle: QMdiAreaH; background: QBrushH); cdecl; external Qt5PasLib name 'QMdiArea_setBackground';
function QMdiArea_activationOrder(handle: QMdiAreaH): QMdiAreaWindowOrder; cdecl; external Qt5PasLib name 'QMdiArea_activationOrder';
procedure QMdiArea_setActivationOrder(handle: QMdiAreaH; order: QMdiAreaWindowOrder); cdecl; external Qt5PasLib name 'QMdiArea_setActivationOrder';
procedure QMdiArea_setOption(handle: QMdiAreaH; option: QMdiAreaAreaOption; _on: Boolean = True); cdecl; external Qt5PasLib name 'QMdiArea_setOption';
function QMdiArea_testOption(handle: QMdiAreaH; opton: QMdiAreaAreaOption): Boolean; cdecl; external Qt5PasLib name 'QMdiArea_testOption';
procedure QMdiArea_setViewMode(handle: QMdiAreaH; mode: QMdiAreaViewMode); cdecl; external Qt5PasLib name 'QMdiArea_setViewMode';
function QMdiArea_viewMode(handle: QMdiAreaH): QMdiAreaViewMode; cdecl; external Qt5PasLib name 'QMdiArea_viewMode';
function QMdiArea_documentMode(handle: QMdiAreaH): Boolean; cdecl; external Qt5PasLib name 'QMdiArea_documentMode';
procedure QMdiArea_setDocumentMode(handle: QMdiAreaH; enabled: Boolean); cdecl; external Qt5PasLib name 'QMdiArea_setDocumentMode';
procedure QMdiArea_setTabsClosable(handle: QMdiAreaH; closable: Boolean); cdecl; external Qt5PasLib name 'QMdiArea_setTabsClosable';
function QMdiArea_tabsClosable(handle: QMdiAreaH): Boolean; cdecl; external Qt5PasLib name 'QMdiArea_tabsClosable';
procedure QMdiArea_setTabsMovable(handle: QMdiAreaH; movable: Boolean); cdecl; external Qt5PasLib name 'QMdiArea_setTabsMovable';
function QMdiArea_tabsMovable(handle: QMdiAreaH): Boolean; cdecl; external Qt5PasLib name 'QMdiArea_tabsMovable';
procedure QMdiArea_setTabShape(handle: QMdiAreaH; shape: QTabWidgetTabShape); cdecl; external Qt5PasLib name 'QMdiArea_setTabShape';
function QMdiArea_tabShape(handle: QMdiAreaH): QTabWidgetTabShape; cdecl; external Qt5PasLib name 'QMdiArea_tabShape';
procedure QMdiArea_setTabPosition(handle: QMdiAreaH; position: QTabWidgetTabPosition); cdecl; external Qt5PasLib name 'QMdiArea_setTabPosition';
function QMdiArea_tabPosition(handle: QMdiAreaH): QTabWidgetTabPosition; cdecl; external Qt5PasLib name 'QMdiArea_tabPosition';
procedure QMdiArea_setActiveSubWindow(handle: QMdiAreaH; window: QMdiSubWindowH); cdecl; external Qt5PasLib name 'QMdiArea_setActiveSubWindow';
procedure QMdiArea_tileSubWindows(handle: QMdiAreaH); cdecl; external Qt5PasLib name 'QMdiArea_tileSubWindows';
procedure QMdiArea_cascadeSubWindows(handle: QMdiAreaH); cdecl; external Qt5PasLib name 'QMdiArea_cascadeSubWindows';
procedure QMdiArea_closeActiveSubWindow(handle: QMdiAreaH); cdecl; external Qt5PasLib name 'QMdiArea_closeActiveSubWindow';
procedure QMdiArea_closeAllSubWindows(handle: QMdiAreaH); cdecl; external Qt5PasLib name 'QMdiArea_closeAllSubWindows';
procedure QMdiArea_activateNextSubWindow(handle: QMdiAreaH); cdecl; external Qt5PasLib name 'QMdiArea_activateNextSubWindow';
procedure QMdiArea_activatePreviousSubWindow(handle: QMdiAreaH); cdecl; external Qt5PasLib name 'QMdiArea_activatePreviousSubWindow';


type
  QMdiArea_subWindowActivated_Event = procedure (AnonParam1: QMdiSubWindowH) of object cdecl;


type
  QMdiSubWindowSubWindowOption = cardinal; // QMdiSubWindow::SubWindowOption
  QMdiSubWindowSubWindowOptions = QMdiSubWindowSubWindowOption; //QFlags<> (3)
const
  QMdiSubWindowAllowOutsideAreaHorizontally =   $1;
  QMdiSubWindowAllowOutsideAreaVertically =   $2;
  QMdiSubWindowRubberBandResize =   $4;
  QMdiSubWindowRubberBandMove =   $8;

function QMdiSubWindow_Create(parent: QWidgetH = nil; flags: QtWindowFlags = 0): QMdiSubWindowH; cdecl; external Qt5PasLib name 'QMdiSubWindow_Create';
procedure QMdiSubWindow_Destroy(handle: QMdiSubWindowH); cdecl; external Qt5PasLib name 'QMdiSubWindow_Destroy'; 
procedure QMdiSubWindow_sizeHint(handle: QMdiSubWindowH; retval: PSize); cdecl; external Qt5PasLib name 'QMdiSubWindow_sizeHint';
procedure QMdiSubWindow_minimumSizeHint(handle: QMdiSubWindowH; retval: PSize); cdecl; external Qt5PasLib name 'QMdiSubWindow_minimumSizeHint';
procedure QMdiSubWindow_setWidget(handle: QMdiSubWindowH; widget: QWidgetH); cdecl; external Qt5PasLib name 'QMdiSubWindow_setWidget';
function QMdiSubWindow_widget(handle: QMdiSubWindowH): QWidgetH; cdecl; external Qt5PasLib name 'QMdiSubWindow_widget';
function QMdiSubWindow_maximizedButtonsWidget(handle: QMdiSubWindowH): QWidgetH; cdecl; external Qt5PasLib name 'QMdiSubWindow_maximizedButtonsWidget';
function QMdiSubWindow_maximizedSystemMenuIconWidget(handle: QMdiSubWindowH): QWidgetH; cdecl; external Qt5PasLib name 'QMdiSubWindow_maximizedSystemMenuIconWidget';
function QMdiSubWindow_isShaded(handle: QMdiSubWindowH): Boolean; cdecl; external Qt5PasLib name 'QMdiSubWindow_isShaded';
procedure QMdiSubWindow_setOption(handle: QMdiSubWindowH; option: QMdiSubWindowSubWindowOption; _on: Boolean = True); cdecl; external Qt5PasLib name 'QMdiSubWindow_setOption';
function QMdiSubWindow_testOption(handle: QMdiSubWindowH; AnonParam1: QMdiSubWindowSubWindowOption): Boolean; cdecl; external Qt5PasLib name 'QMdiSubWindow_testOption';
procedure QMdiSubWindow_setKeyboardSingleStep(handle: QMdiSubWindowH; step: Integer); cdecl; external Qt5PasLib name 'QMdiSubWindow_setKeyboardSingleStep';
function QMdiSubWindow_keyboardSingleStep(handle: QMdiSubWindowH): Integer; cdecl; external Qt5PasLib name 'QMdiSubWindow_keyboardSingleStep';
procedure QMdiSubWindow_setKeyboardPageStep(handle: QMdiSubWindowH; step: Integer); cdecl; external Qt5PasLib name 'QMdiSubWindow_setKeyboardPageStep';
function QMdiSubWindow_keyboardPageStep(handle: QMdiSubWindowH): Integer; cdecl; external Qt5PasLib name 'QMdiSubWindow_keyboardPageStep';
procedure QMdiSubWindow_setSystemMenu(handle: QMdiSubWindowH; systemMenu: QMenuH); cdecl; external Qt5PasLib name 'QMdiSubWindow_setSystemMenu';
function QMdiSubWindow_systemMenu(handle: QMdiSubWindowH): QMenuH; cdecl; external Qt5PasLib name 'QMdiSubWindow_systemMenu';
function QMdiSubWindow_mdiArea(handle: QMdiSubWindowH): QMdiAreaH; cdecl; external Qt5PasLib name 'QMdiSubWindow_mdiArea';
procedure QMdiSubWindow_showSystemMenu(handle: QMdiSubWindowH); cdecl; external Qt5PasLib name 'QMdiSubWindow_showSystemMenu';
procedure QMdiSubWindow_showShaded(handle: QMdiSubWindowH); cdecl; external Qt5PasLib name 'QMdiSubWindow_showShaded';


type
  QMdiSubWindow_windowStateChanged_Event = procedure (oldState: QtWindowStates; newState: QtWindowStates) of object cdecl;
  QMdiSubWindow_aboutToActivate_Event = procedure () of object cdecl;



type
  QCalendarWidgetHorizontalHeaderFormat = ( // QCalendarWidget::HorizontalHeaderFormat (1)
    QCalendarWidgetNoHorizontalHeader, QCalendarWidgetSingleLetterDayNames, QCalendarWidgetShortDayNames, QCalendarWidgetLongDayNames );

  QCalendarWidgetVerticalHeaderFormat = ( // QCalendarWidget::VerticalHeaderFormat (1)
    QCalendarWidgetNoVerticalHeader, QCalendarWidgetISOWeekNumbers );

  QCalendarWidgetSelectionMode = ( // QCalendarWidget::SelectionMode (1)
    QCalendarWidgetNoSelection, QCalendarWidgetSingleSelection );

function QCalendarWidget_Create(parent: QWidgetH = nil): QCalendarWidgetH; cdecl; external Qt5PasLib name 'QCalendarWidget_Create';
procedure QCalendarWidget_Destroy(handle: QCalendarWidgetH); cdecl; external Qt5PasLib name 'QCalendarWidget_Destroy'; 
procedure QCalendarWidget_sizeHint(handle: QCalendarWidgetH; retval: PSize); cdecl; external Qt5PasLib name 'QCalendarWidget_sizeHint';
procedure QCalendarWidget_minimumSizeHint(handle: QCalendarWidgetH; retval: PSize); cdecl; external Qt5PasLib name 'QCalendarWidget_minimumSizeHint';
procedure QCalendarWidget_selectedDate(handle: QCalendarWidgetH; retval: QDateH); cdecl; external Qt5PasLib name 'QCalendarWidget_selectedDate';
function QCalendarWidget_yearShown(handle: QCalendarWidgetH): Integer; cdecl; external Qt5PasLib name 'QCalendarWidget_yearShown';
function QCalendarWidget_monthShown(handle: QCalendarWidgetH): Integer; cdecl; external Qt5PasLib name 'QCalendarWidget_monthShown';
procedure QCalendarWidget_minimumDate(handle: QCalendarWidgetH; retval: QDateH); cdecl; external Qt5PasLib name 'QCalendarWidget_minimumDate';
procedure QCalendarWidget_setMinimumDate(handle: QCalendarWidgetH; date: QDateH); cdecl; external Qt5PasLib name 'QCalendarWidget_setMinimumDate';
procedure QCalendarWidget_maximumDate(handle: QCalendarWidgetH; retval: QDateH); cdecl; external Qt5PasLib name 'QCalendarWidget_maximumDate';
procedure QCalendarWidget_setMaximumDate(handle: QCalendarWidgetH; date: QDateH); cdecl; external Qt5PasLib name 'QCalendarWidget_setMaximumDate';
function QCalendarWidget_firstDayOfWeek(handle: QCalendarWidgetH): QtDayOfWeek; cdecl; external Qt5PasLib name 'QCalendarWidget_firstDayOfWeek';
procedure QCalendarWidget_setFirstDayOfWeek(handle: QCalendarWidgetH; dayOfWeek: QtDayOfWeek); cdecl; external Qt5PasLib name 'QCalendarWidget_setFirstDayOfWeek';
function QCalendarWidget_isNavigationBarVisible(handle: QCalendarWidgetH): Boolean; cdecl; external Qt5PasLib name 'QCalendarWidget_isNavigationBarVisible';
function QCalendarWidget_isGridVisible(handle: QCalendarWidgetH): Boolean; cdecl; external Qt5PasLib name 'QCalendarWidget_isGridVisible';
function QCalendarWidget_selectionMode(handle: QCalendarWidgetH): QCalendarWidgetSelectionMode; cdecl; external Qt5PasLib name 'QCalendarWidget_selectionMode';
procedure QCalendarWidget_setSelectionMode(handle: QCalendarWidgetH; mode: QCalendarWidgetSelectionMode); cdecl; external Qt5PasLib name 'QCalendarWidget_setSelectionMode';
function QCalendarWidget_horizontalHeaderFormat(handle: QCalendarWidgetH): QCalendarWidgetHorizontalHeaderFormat; cdecl; external Qt5PasLib name 'QCalendarWidget_horizontalHeaderFormat';
procedure QCalendarWidget_setHorizontalHeaderFormat(handle: QCalendarWidgetH; format: QCalendarWidgetHorizontalHeaderFormat); cdecl; external Qt5PasLib name 'QCalendarWidget_setHorizontalHeaderFormat';
function QCalendarWidget_verticalHeaderFormat(handle: QCalendarWidgetH): QCalendarWidgetVerticalHeaderFormat; cdecl; external Qt5PasLib name 'QCalendarWidget_verticalHeaderFormat';
procedure QCalendarWidget_setVerticalHeaderFormat(handle: QCalendarWidgetH; format: QCalendarWidgetVerticalHeaderFormat); cdecl; external Qt5PasLib name 'QCalendarWidget_setVerticalHeaderFormat';
procedure QCalendarWidget_headerTextFormat(handle: QCalendarWidgetH; retval: QTextCharFormatH); cdecl; external Qt5PasLib name 'QCalendarWidget_headerTextFormat';
procedure QCalendarWidget_setHeaderTextFormat(handle: QCalendarWidgetH; format: QTextCharFormatH); cdecl; external Qt5PasLib name 'QCalendarWidget_setHeaderTextFormat';
procedure QCalendarWidget_weekdayTextFormat(handle: QCalendarWidgetH; retval: QTextCharFormatH; dayOfWeek: QtDayOfWeek); cdecl; external Qt5PasLib name 'QCalendarWidget_weekdayTextFormat';
procedure QCalendarWidget_setWeekdayTextFormat(handle: QCalendarWidgetH; dayOfWeek: QtDayOfWeek; format: QTextCharFormatH); cdecl; external Qt5PasLib name 'QCalendarWidget_setWeekdayTextFormat';
procedure QCalendarWidget_dateTextFormat(handle: QCalendarWidgetH; retval: QTextCharFormatH; date: QDateH); cdecl; external Qt5PasLib name 'QCalendarWidget_dateTextFormat2';
procedure QCalendarWidget_setDateTextFormat(handle: QCalendarWidgetH; date: QDateH; format: QTextCharFormatH); cdecl; external Qt5PasLib name 'QCalendarWidget_setDateTextFormat';
function QCalendarWidget_isDateEditEnabled(handle: QCalendarWidgetH): Boolean; cdecl; external Qt5PasLib name 'QCalendarWidget_isDateEditEnabled';
procedure QCalendarWidget_setDateEditEnabled(handle: QCalendarWidgetH; enable: Boolean); cdecl; external Qt5PasLib name 'QCalendarWidget_setDateEditEnabled';
function QCalendarWidget_dateEditAcceptDelay(handle: QCalendarWidgetH): Integer; cdecl; external Qt5PasLib name 'QCalendarWidget_dateEditAcceptDelay';
procedure QCalendarWidget_setDateEditAcceptDelay(handle: QCalendarWidgetH; delay: Integer); cdecl; external Qt5PasLib name 'QCalendarWidget_setDateEditAcceptDelay';
procedure QCalendarWidget_setSelectedDate(handle: QCalendarWidgetH; date: QDateH); cdecl; external Qt5PasLib name 'QCalendarWidget_setSelectedDate';
procedure QCalendarWidget_setDateRange(handle: QCalendarWidgetH; min: QDateH; max: QDateH); cdecl; external Qt5PasLib name 'QCalendarWidget_setDateRange';
procedure QCalendarWidget_setCurrentPage(handle: QCalendarWidgetH; year: Integer; month: Integer); cdecl; external Qt5PasLib name 'QCalendarWidget_setCurrentPage';
procedure QCalendarWidget_setGridVisible(handle: QCalendarWidgetH; show: Boolean); cdecl; external Qt5PasLib name 'QCalendarWidget_setGridVisible';
procedure QCalendarWidget_setNavigationBarVisible(handle: QCalendarWidgetH; visible: Boolean); cdecl; external Qt5PasLib name 'QCalendarWidget_setNavigationBarVisible';
procedure QCalendarWidget_showNextMonth(handle: QCalendarWidgetH); cdecl; external Qt5PasLib name 'QCalendarWidget_showNextMonth';
procedure QCalendarWidget_showPreviousMonth(handle: QCalendarWidgetH); cdecl; external Qt5PasLib name 'QCalendarWidget_showPreviousMonth';
procedure QCalendarWidget_showNextYear(handle: QCalendarWidgetH); cdecl; external Qt5PasLib name 'QCalendarWidget_showNextYear';
procedure QCalendarWidget_showPreviousYear(handle: QCalendarWidgetH); cdecl; external Qt5PasLib name 'QCalendarWidget_showPreviousYear';
procedure QCalendarWidget_showSelectedDate(handle: QCalendarWidgetH); cdecl; external Qt5PasLib name 'QCalendarWidget_showSelectedDate';
procedure QCalendarWidget_showToday(handle: QCalendarWidgetH); cdecl; external Qt5PasLib name 'QCalendarWidget_showToday';


type
  QCalendarWidget_selectionChanged_Event = procedure () of object cdecl;
  QCalendarWidget_clicked_Event = procedure (date: QDateH) of object cdecl;
  QCalendarWidget_activated_Event = procedure (date: QDateH) of object cdecl;
  QCalendarWidget_currentPageChanged_Event = procedure (year: Integer; month: Integer) of object cdecl;



type
  QRubberBandShape = ( // QRubberBand::Shape (1)
    QRubberBandLine, QRubberBandRectangle );

function QRubberBand_Create(AnonParam1: QRubberBandShape; AnonParam2: QWidgetH = nil): QRubberBandH; cdecl; external Qt5PasLib name 'QRubberBand_Create';
procedure QRubberBand_Destroy(handle: QRubberBandH); cdecl; external Qt5PasLib name 'QRubberBand_Destroy'; 
function QRubberBand_shape(handle: QRubberBandH): QRubberBandShape; cdecl; external Qt5PasLib name 'QRubberBand_shape';
procedure QRubberBand_setGeometry(handle: QRubberBandH; r: PRect); cdecl; external Qt5PasLib name 'QRubberBand_setGeometry';
procedure QRubberBand_setGeometry(handle: QRubberBandH; x: Integer; y: Integer; w: Integer; h: Integer); cdecl; external Qt5PasLib name 'QRubberBand_setGeometry2';
procedure QRubberBand_move(handle: QRubberBandH; x: Integer; y: Integer); cdecl; external Qt5PasLib name 'QRubberBand_move';
procedure QRubberBand_move(handle: QRubberBandH; p: PQtPoint); cdecl; external Qt5PasLib name 'QRubberBand_move2';
procedure QRubberBand_resize(handle: QRubberBandH; w: Integer; h: Integer); cdecl; external Qt5PasLib name 'QRubberBand_resize';
procedure QRubberBand_resize(handle: QRubberBandH; s: PSize); cdecl; external Qt5PasLib name 'QRubberBand_resize2';

type
  QFontComboBoxFontFilter = cardinal; // QFontComboBox::FontFilter
  QFontComboBoxFontFilters = QFontComboBoxFontFilter; //QFlags<> (3)
const
  QFontComboBoxAllFonts =   0;
  QFontComboBoxScalableFonts =   $1;
  QFontComboBoxNonScalableFonts =   $2;
  QFontComboBoxMonospacedFonts =   $4;
  QFontComboBoxProportionalFonts =   $8;

function QFontComboBox_Create(parent: QWidgetH = nil): QFontComboBoxH; cdecl; external Qt5PasLib name 'QFontComboBox_Create';
procedure QFontComboBox_Destroy(handle: QFontComboBoxH); cdecl; external Qt5PasLib name 'QFontComboBox_Destroy'; 
procedure QFontComboBox_setWritingSystem(handle: QFontComboBoxH; AnonParam1: QFontDatabaseWritingSystem); cdecl; external Qt5PasLib name 'QFontComboBox_setWritingSystem';
function QFontComboBox_writingSystem(handle: QFontComboBoxH): QFontDatabaseWritingSystem; cdecl; external Qt5PasLib name 'QFontComboBox_writingSystem';
procedure QFontComboBox_setFontFilters(handle: QFontComboBoxH; filters: QFontComboBoxFontFilters); cdecl; external Qt5PasLib name 'QFontComboBox_setFontFilters';
function QFontComboBox_fontFilters(handle: QFontComboBoxH): QFontComboBoxFontFilters; cdecl; external Qt5PasLib name 'QFontComboBox_fontFilters';
procedure QFontComboBox_currentFont(handle: QFontComboBoxH; retval: QFontH); cdecl; external Qt5PasLib name 'QFontComboBox_currentFont';
procedure QFontComboBox_sizeHint(handle: QFontComboBoxH; retval: PSize); cdecl; external Qt5PasLib name 'QFontComboBox_sizeHint';
procedure QFontComboBox_setCurrentFont(handle: QFontComboBoxH; f: QFontH); cdecl; external Qt5PasLib name 'QFontComboBox_setCurrentFont';


type
  QFontComboBox_currentFontChanged_Event = procedure (f: QFontH) of object cdecl;



type
  QAbstractItemViewSelectionMode = ( // QAbstractItemView::SelectionMode (1)
    QAbstractItemViewNoSelection, QAbstractItemViewSingleSelection, QAbstractItemViewMultiSelection, QAbstractItemViewExtendedSelection, QAbstractItemViewContiguousSelection );

  QAbstractItemViewSelectionBehavior = ( // QAbstractItemView::SelectionBehavior (1)
    QAbstractItemViewSelectItems, QAbstractItemViewSelectRows, QAbstractItemViewSelectColumns );

  QAbstractItemViewScrollHint = ( // QAbstractItemView::ScrollHint (1)
    QAbstractItemViewEnsureVisible, QAbstractItemViewPositionAtTop, QAbstractItemViewPositionAtBottom, QAbstractItemViewPositionAtCenter );

  QAbstractItemViewScrollMode = ( // QAbstractItemView::ScrollMode (1)
    QAbstractItemViewScrollPerItem, QAbstractItemViewScrollPerPixel );

  QAbstractItemViewDragDropMode = ( // QAbstractItemView::DragDropMode (1)
    QAbstractItemViewNoDragDrop, QAbstractItemViewDragOnly, QAbstractItemViewDropOnly, QAbstractItemViewDragDrop, QAbstractItemViewInternalMove );

type
  QAbstractItemViewEditTrigger = cardinal; // QAbstractItemView::EditTrigger
  QAbstractItemViewEditTriggers = QAbstractItemViewEditTrigger; //QFlags<> (3)
const
  QAbstractItemViewNoEditTriggers =   0;
  QAbstractItemViewCurrentChanged =   1;
  QAbstractItemViewDoubleClicked =   2;
  QAbstractItemViewSelectedClicked =   4;
  QAbstractItemViewEditKeyPressed =   8;
  QAbstractItemViewAnyKeyPressed =   16;
  QAbstractItemViewAllEditTriggers =   31;

procedure QAbstractItemView_setModel(handle: QAbstractItemViewH; model: QAbstractItemModelH); cdecl; external Qt5PasLib name 'QAbstractItemView_setModel';
function QAbstractItemView_model(handle: QAbstractItemViewH): QAbstractItemModelH; cdecl; external Qt5PasLib name 'QAbstractItemView_model';
procedure QAbstractItemView_setSelectionModel(handle: QAbstractItemViewH; selectionModel: QItemSelectionModelH); cdecl; external Qt5PasLib name 'QAbstractItemView_setSelectionModel';
function QAbstractItemView_selectionModel(handle: QAbstractItemViewH): QItemSelectionModelH; cdecl; external Qt5PasLib name 'QAbstractItemView_selectionModel';
procedure QAbstractItemView_setItemDelegate(handle: QAbstractItemViewH; delegate: QAbstractItemDelegateH); cdecl; external Qt5PasLib name 'QAbstractItemView_setItemDelegate';
function QAbstractItemView_itemDelegate(handle: QAbstractItemViewH): QAbstractItemDelegateH; cdecl; external Qt5PasLib name 'QAbstractItemView_itemDelegate';
procedure QAbstractItemView_setSelectionMode(handle: QAbstractItemViewH; mode: QAbstractItemViewSelectionMode); cdecl; external Qt5PasLib name 'QAbstractItemView_setSelectionMode';
function QAbstractItemView_selectionMode(handle: QAbstractItemViewH): QAbstractItemViewSelectionMode; cdecl; external Qt5PasLib name 'QAbstractItemView_selectionMode';
procedure QAbstractItemView_setSelectionBehavior(handle: QAbstractItemViewH; behavior: QAbstractItemViewSelectionBehavior); cdecl; external Qt5PasLib name 'QAbstractItemView_setSelectionBehavior';
function QAbstractItemView_selectionBehavior(handle: QAbstractItemViewH): QAbstractItemViewSelectionBehavior; cdecl; external Qt5PasLib name 'QAbstractItemView_selectionBehavior';
procedure QAbstractItemView_currentIndex(handle: QAbstractItemViewH; retval: QModelIndexH); cdecl; external Qt5PasLib name 'QAbstractItemView_currentIndex';
procedure QAbstractItemView_rootIndex(handle: QAbstractItemViewH; retval: QModelIndexH); cdecl; external Qt5PasLib name 'QAbstractItemView_rootIndex';
procedure QAbstractItemView_setEditTriggers(handle: QAbstractItemViewH; triggers: QAbstractItemViewEditTriggers); cdecl; external Qt5PasLib name 'QAbstractItemView_setEditTriggers';
function QAbstractItemView_editTriggers(handle: QAbstractItemViewH): QAbstractItemViewEditTriggers; cdecl; external Qt5PasLib name 'QAbstractItemView_editTriggers';
procedure QAbstractItemView_setVerticalScrollMode(handle: QAbstractItemViewH; mode: QAbstractItemViewScrollMode); cdecl; external Qt5PasLib name 'QAbstractItemView_setVerticalScrollMode';
function QAbstractItemView_verticalScrollMode(handle: QAbstractItemViewH): QAbstractItemViewScrollMode; cdecl; external Qt5PasLib name 'QAbstractItemView_verticalScrollMode';
procedure QAbstractItemView_setHorizontalScrollMode(handle: QAbstractItemViewH; mode: QAbstractItemViewScrollMode); cdecl; external Qt5PasLib name 'QAbstractItemView_setHorizontalScrollMode';
function QAbstractItemView_horizontalScrollMode(handle: QAbstractItemViewH): QAbstractItemViewScrollMode; cdecl; external Qt5PasLib name 'QAbstractItemView_horizontalScrollMode';
procedure QAbstractItemView_setAutoScroll(handle: QAbstractItemViewH; enable: Boolean); cdecl; external Qt5PasLib name 'QAbstractItemView_setAutoScroll';
function QAbstractItemView_hasAutoScroll(handle: QAbstractItemViewH): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemView_hasAutoScroll';
procedure QAbstractItemView_setAutoScrollMargin(handle: QAbstractItemViewH; margin: Integer); cdecl; external Qt5PasLib name 'QAbstractItemView_setAutoScrollMargin';
function QAbstractItemView_autoScrollMargin(handle: QAbstractItemViewH): Integer; cdecl; external Qt5PasLib name 'QAbstractItemView_autoScrollMargin';
procedure QAbstractItemView_setTabKeyNavigation(handle: QAbstractItemViewH; enable: Boolean); cdecl; external Qt5PasLib name 'QAbstractItemView_setTabKeyNavigation';
function QAbstractItemView_tabKeyNavigation(handle: QAbstractItemViewH): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemView_tabKeyNavigation';
procedure QAbstractItemView_setDropIndicatorShown(handle: QAbstractItemViewH; enable: Boolean); cdecl; external Qt5PasLib name 'QAbstractItemView_setDropIndicatorShown';
function QAbstractItemView_showDropIndicator(handle: QAbstractItemViewH): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemView_showDropIndicator';
procedure QAbstractItemView_setDragEnabled(handle: QAbstractItemViewH; enable: Boolean); cdecl; external Qt5PasLib name 'QAbstractItemView_setDragEnabled';
function QAbstractItemView_dragEnabled(handle: QAbstractItemViewH): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemView_dragEnabled';
procedure QAbstractItemView_setDragDropOverwriteMode(handle: QAbstractItemViewH; overwrite: Boolean); cdecl; external Qt5PasLib name 'QAbstractItemView_setDragDropOverwriteMode';
function QAbstractItemView_dragDropOverwriteMode(handle: QAbstractItemViewH): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemView_dragDropOverwriteMode';
procedure QAbstractItemView_setDragDropMode(handle: QAbstractItemViewH; behavior: QAbstractItemViewDragDropMode); cdecl; external Qt5PasLib name 'QAbstractItemView_setDragDropMode';
function QAbstractItemView_dragDropMode(handle: QAbstractItemViewH): QAbstractItemViewDragDropMode; cdecl; external Qt5PasLib name 'QAbstractItemView_dragDropMode';
procedure QAbstractItemView_setDefaultDropAction(handle: QAbstractItemViewH; dropAction: QtDropAction); cdecl; external Qt5PasLib name 'QAbstractItemView_setDefaultDropAction';
function QAbstractItemView_defaultDropAction(handle: QAbstractItemViewH): QtDropAction; cdecl; external Qt5PasLib name 'QAbstractItemView_defaultDropAction';
procedure QAbstractItemView_setAlternatingRowColors(handle: QAbstractItemViewH; enable: Boolean); cdecl; external Qt5PasLib name 'QAbstractItemView_setAlternatingRowColors';
function QAbstractItemView_alternatingRowColors(handle: QAbstractItemViewH): Boolean; cdecl; external Qt5PasLib name 'QAbstractItemView_alternatingRowColors';
procedure QAbstractItemView_setIconSize(handle: QAbstractItemViewH; size: PSize); cdecl; external Qt5PasLib name 'QAbstractItemView_setIconSize';
procedure QAbstractItemView_iconSize(handle: QAbstractItemViewH; retval: PSize); cdecl; external Qt5PasLib name 'QAbstractItemView_iconSize';
procedure QAbstractItemView_setTextElideMode(handle: QAbstractItemViewH; mode: QtTextElideMode); cdecl; external Qt5PasLib name 'QAbstractItemView_setTextElideMode';
function QAbstractItemView_textElideMode(handle: QAbstractItemViewH): QtTextElideMode; cdecl; external Qt5PasLib name 'QAbstractItemView_textElideMode';
procedure QAbstractItemView_keyboardSearch(handle: QAbstractItemViewH; search: PWideString); cdecl; external Qt5PasLib name 'QAbstractItemView_keyboardSearch';
procedure QAbstractItemView_visualRect(handle: QAbstractItemViewH; retval: PRect; index: QModelIndexH); cdecl; external Qt5PasLib name 'QAbstractItemView_visualRect';
procedure QAbstractItemView_scrollTo(handle: QAbstractItemViewH; index: QModelIndexH; hint: QAbstractItemViewScrollHint = QAbstractItemViewEnsureVisible); cdecl; external Qt5PasLib name 'QAbstractItemView_scrollTo';
procedure QAbstractItemView_indexAt(handle: QAbstractItemViewH; retval: QModelIndexH; point: PQtPoint); cdecl; external Qt5PasLib name 'QAbstractItemView_indexAt';
procedure QAbstractItemView_sizeHintForIndex(handle: QAbstractItemViewH; retval: PSize; index: QModelIndexH); cdecl; external Qt5PasLib name 'QAbstractItemView_sizeHintForIndex';
function QAbstractItemView_sizeHintForRow(handle: QAbstractItemViewH; row: Integer): Integer; cdecl; external Qt5PasLib name 'QAbstractItemView_sizeHintForRow';
function QAbstractItemView_sizeHintForColumn(handle: QAbstractItemViewH; column: Integer): Integer; cdecl; external Qt5PasLib name 'QAbstractItemView_sizeHintForColumn';
procedure QAbstractItemView_openPersistentEditor(handle: QAbstractItemViewH; index: QModelIndexH); cdecl; external Qt5PasLib name 'QAbstractItemView_openPersistentEditor';
proced