/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Gerben Venekamp <venekamp@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


/*!
    \file   lcmaps_types.h
    \brief  Public header file with typedefs for LCMAPS
    \author Martijn Steenbakkers for the EU DataGrid.
    \ingroup APIforLcmapsPlugins

    Last change: support for VOMS' generic attributes  (Placi Flury flury@switch.ch)
*/

#ifndef LCMAPS_TYPES_H
#define LCMAPS_TYPES_H

/******************************************************************************
                             Include header files
******************************************************************************/

#include <sys/types.h>
#include <pwd.h>

/******************************************************************************
                               Type definitions
******************************************************************************/

/*!
    \typedef lcmaps_request_t
    \brief Type of the LCMAPS request expressed in RSL/JDL

    (Internal) just a string.
*/
typedef char *lcmaps_request_t;


typedef struct lcmaps_fqan_unix_s
{
    char * fqan;
    uid_t  uid;
    gid_t  gid;
}
lcmaps_fqan_unix_t;


typedef struct lcmaps_voms_generic_attr_s{  /*!< basically same fields as in the voms_apic.h*/
    char * name;
    char * value;
    char * qualifier;
}
lcmaps_voms_generic_attr_t;


typedef struct lcmaps_voms_s
{
    char *                       user_dn;           /*!< the User DN */
    char *                       user_ca;           /*!< the User CA */
    char *                       voms_issuer_dn;    /*!< the VOMS ACs Issuer (DN) */
    char *                       voms_issuer_ca;    /*!< the VOMS ACs Issuer (CA) */
    char *                       uri;               /*!< the VOMS uri */
    char *                       date1;             /*!< valid begin and end date per VOMS section */
    char *                       date2;             /*!< valid begin and end date per VOMS section */

    char *                       voname;            /*!< The VO name, not in FQAN format, just the name at the server */

    lcmaps_fqan_unix_t *         fqan_unix;         /*!< the list of FQANs mapped with Unix UID and/or Unix GID */
    int                          nfqan;             /*!< the number of FQANs */
    lcmaps_voms_generic_attr_t * attr_list;         /*!< the list of generic voms attributes (name,value) pairs */
    int                          nattr;             /*!< the number of generic voms attributes */
}
lcmaps_voms_t;


typedef struct lcmaps_vomsdata_s
{
    lcmaps_voms_t        *        voms;
    int                           nvoms;
    char                 *        workvo;
    char                 *        extra_data;
}
lcmaps_vomsdata_t;


#endif /* LCMAPS_TYPES_H */

/******************************************************************************
CVS Information:
    $Source: /srv/home/dennisvd/svn/mw-security/lcmaps/interface/lcmaps_types.h,v $
    $Date: 2011-03-04 21:55:13 +0100 (Fri, 04 Mar 2011) $
    $Revision: 14868 $
    $Author: dennisvd $
******************************************************************************/
