
#!/usr/bin/python
# -*- coding: utf-8 -*-
### BEGIN LICENSE
# Copyright (C) 2009 Jono Bacon <jono@ubuntu.com>
# Copyright (C) 2010 Michael Budde <mbudde@gmail.com>
#
#This program is free software: you can redistribute it and/or modify it
#under the terms of the GNU General Public License version 3, as published
#by the Free Software Foundation.
#
#This program is distributed in the hope that it will be useful, but
#WITHOUT ANY WARRANTY; without even the implied warranties of
#MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
#PURPOSE.  See the GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License along
#with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import gtk
try:
    import vte
    VTE_SUPPORT = True
except ImportError:
    VTE_SUPPORT = False

from lernid.widgets.Widget import Widget

class Terminal(Widget):

    __gtype_name__ = 'LernidTerminal'

    def __init__(self):
        Widget.__init__(self, 'terminal')
        scroll = gtk.ScrolledWindow()
        scroll.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self._terminal = vte.Terminal()
        self._terminal.fork_command()
        def refork(terminal):
            terminal.fork_command()
        self._terminal.connect('child-exited', refork)
        def paste(terminal, event):
            if not (event.state & gtk.gdk.CONTROL_MASK):
                return
            if event.keyval == ord('V'):
                self._terminal.paste_clipboard()
            return True
        self._terminal.add_events(gtk.gdk.KEY_RELEASE_MASK)
        self.connect('key-release-event', paste)
        scroll.add(self._terminal)
        self.add(scroll)
