program intrinsics_209
    use, intrinsic :: iso_fortran_env, only: dp => real64, sp => real32
    integer :: i
    real(sp) :: q,y,z
    real(dp) :: k,l,m
    real(dp) :: w(19)
    real(dp) :: large(38)
    real(sp) :: x(19)
    real(dp) :: expected_w(19)
    real(sp) :: expected_x(19)
    real(dp) :: expected_large(38)

    real(dp), parameter :: comp(38) = atand([988.522977022977_dp, 989.021978021978_dp, 989.520979020979_dp, &
    990.01998001998_dp , 990.518981018981_dp, 991.017982017982_dp, 991.516983016983_dp, 992.015984015984_dp, &
    992.514985014985_dp, 993.013986013986_dp, 993.512987012987_dp, 994.011988011988_dp, &
    994.510989010989_dp, 995.00999000999_dp, 995.508991008991_dp, 996.007992007992_dp, &
    996.506993006993_dp, 997.005994005994_dp, 997.504995004995_dp, &
    -988.522977022977_dp, -989.021978021978_dp, -989.520979020979_dp, -990.01998001998_dp , & 
    -990.518981018981_dp, -991.017982017982_dp, -991.516983016983_dp, -992.015984015984_dp, &
    -992.514985014985_dp, -993.013986013986_dp, -993.512987012987_dp, -994.011988011988_dp, &
    -994.510989010989_dp, -995.00999000999_dp, -995.508991008991_dp, -996.007992007992_dp, &
    -996.506993006993_dp, -997.005994005994_dp, -997.504995004995_dp])
         
    real(dp), parameter :: res(19) = atand([0.321_dp, 0.526_dp, 0.728_dp, -0.321_dp, -0.526_dp, -0.728_dp, &
    -1.0_dp, -0.9995004995004995_dp, -0.999000999000999_dp, &
    -0.9985014985014985_dp, -0.998001998001998_dp, -0.9975024975024975_dp, &
    -0.997002997002997_dp, -0.9965034965034965_dp, -0.996003996003996_dp, &
    -0.9955044955044955_dp, -0.995004995004995_dp, -0.9945054945054945_dp, &
    -0.994005994005994_dp])
    real(sp), parameter :: res_x(19) = atand([0.321_sp, 0.526_sp, 0.728_sp, -0.321_sp, -0.526_sp, -0.728_sp, &
    -1.0_sp, -0.999_sp, -0.999_sp, -0.998_sp, -0.998_sp, -0.997_sp, &
    -0.997_sp, -0.996_sp, -0.996_sp, -0.995_sp, -0.995_sp, -0.994_sp, -0.994_sp])

    w = [0.321_dp, 0.526_dp, 0.728_dp, -0.321_dp, -0.526_dp, -0.728_dp, &
         -1.0_dp, -0.9995004995004995_dp, -0.999000999000999_dp, &
         -0.9985014985014985_dp, -0.998001998001998_dp, -0.9975024975024975_dp, &
         -0.997002997002997_dp, -0.9965034965034965_dp, -0.996003996003996_dp, &
         -0.9955044955044955_dp, -0.995004995004995_dp, -0.9945054945054945_dp, &
         -0.994005994005994_dp]

    x = [0.321_sp, 0.526_sp, 0.728_sp, -0.321_sp, -0.526_sp, -0.728_sp, &
         -1.0_sp, -0.999_sp, -0.999_sp, -0.998_sp, -0.998_sp, -0.997_sp, &
         -0.997_sp, -0.996_sp, -0.996_sp, -0.995_sp, -0.995_sp, -0.994_sp, -0.994_sp]

    large = [988.522977022977_dp, 989.021978021978_dp, 989.520979020979_dp ,990.01998001998_dp , & 
            990.518981018981_dp, 991.017982017982_dp, 991.516983016983_dp, 992.015984015984_dp, &
            992.514985014985_dp, 993.013986013986_dp, 993.512987012987_dp, 994.011988011988_dp, &
            994.510989010989_dp, 995.00999000999_dp, 995.508991008991_dp, 996.007992007992_dp, &
            996.506993006993_dp, 997.005994005994_dp, 997.504995004995_dp, &
            -988.522977022977_dp, -989.021978021978_dp, -989.520979020979_dp, -990.01998001998_dp , & 
            -990.518981018981_dp, -991.017982017982_dp, -991.516983016983_dp, -992.015984015984_dp, &
            -992.514985014985_dp, -993.013986013986_dp, -993.512987012987_dp, -994.011988011988_dp, &
            -994.510989010989_dp, -995.00999000999_dp, -995.508991008991_dp, -996.007992007992_dp, &
            -996.506993006993_dp, -997.005994005994_dp, -997.504995004995_dp]

    expected_w = [17.796630203668819_dp, 27.744370169482565_dp, 36.054618166461040_dp, &
                  -17.796630203668819_dp, -27.744370169482565_dp, -36.054618166461040_dp, &
                  -45.000000000000000_dp, -44.985686790326952_dp, -44.971366429413692_dp, &
                  -44.957038913689956_dp, -44.942704239585503_dp, -44.928362403530095_dp, &
                  -44.914013401953525_dp, -44.899657231285609_dp, -44.885293887956209_dp, &
                  -44.870923368395196_dp, -44.856545669032499_dp, -44.842160786298116_dp, &
                  -44.827768716622060_dp]

    expected_x = [17.7966309_sp, 27.7443714_sp, 36.0546188_sp, -17.7966309_sp, &
        -27.7443714_sp, -36.0546188_sp, -45.0000000_sp, -44.9713364_sp, -44.9713364_sp, &
        -44.9426460_sp, -44.9426460_sp, -44.9139252_sp, -44.9139252_sp, -44.8851776_sp, &
        -44.8851776_sp, -44.8564034_sp, -44.8564034_sp, -44.8275948_sp, -44.8275948_sp]

    expected_large = [89.942039020538502_dp, 89.942068264142364_dp, 89.942097478252023_dp, 89.942126662912045_dp, &     
    89.942155818166967_dp, 89.942184944061196_dp, 89.942214040639058_dp, 89.942243107944805_dp, &    
    89.942272146022574_dp, 89.942301154916436_dp, 89.942330134670371_dp, 89.942359085328249_dp, &    
    89.942388006933868_dp, 89.942416899530954_dp, 89.942445763163107_dp, 89.942474597873883_dp, &    
    89.942503403706695_dp, 89.942532180704944_dp, 89.942560928911888_dp, &
    -89.942039020538502_dp, -89.942068264142364_dp, -89.942097478252023_dp, -89.942126662912045_dp, &     
    -89.942155818166967_dp, -89.942184944061196_dp, -89.942214040639058_dp, -89.942243107944805_dp, &    
    -89.942272146022574_dp, -89.942301154916436_dp, -89.942330134670371_dp, -89.942359085328249_dp, &    
    -89.942388006933868_dp, -89.942416899530954_dp, -89.942445763163107_dp, -89.942474597873883_dp, &    
    -89.942503403706695_dp, -89.942532180704944_dp, -89.942560928911888_dp]

    do i = 1, size(res)
        print *, res(i)
        if (abs(res(i) - expected_w(i)) > 1e-12_dp) error stop
    end do

    do i = 1, size(w)
        print *, atand(w(i))
        if (abs(atand(w(i)) - expected_w(i)) > 1e-12_dp) error stop
    end do

    do i = 1, size(x)
        print *, atand(x(i))
        if (abs(atand(x(i)) - expected_x(i)) > 1e-5_sp) error stop
    end do

    do i = 1, size(res_x)
        print *, res_x(i)
        if (abs(res_x(i) - expected_x(i)) > 1e-5_sp) error stop
    end do

    do i = 1, size(large)
        print *, atand(large(i))
        if (abs(atand(large(i)) - expected_large(i)) > 1e-12_dp) error stop
    end do

    do i = 1, size(comp)
        print *, comp(i)
        if (abs(comp(i) - expected_large(i)) > 1e-5_sp) error stop
    end do

    q = 0.123
    y = 0.876
    z = 0.542

    k = 0.1237382_dp
    l = 0.8767382_dp
    m = 0.5427382_dp

    print *, atand(q)
    if (atand(q) - 7.01215982_sp > 1e-5) error stop

    print *, atand(y)
    if (atand(y) - 41.2183571_sp > 1e-5) error stop

    print *, atand(z)
    if (atand(z) - 28.4576912_sp > 1e-5) error stop

    print *, atand(0.123_sp)
    if (atand(0.123_sp) - 7.01216030_sp > 1e-5) error stop

    print *, atand(0.876_sp)
    if (atand(0.876_sp) - 41.2183571_sp > 1e-5) error stop

    print *, atand(0.542_sp)
    if (atand(0.542_sp) - 28.4576931_sp > 1e-5) error stop

    print *, atand(k)
    if (atand(k) - 7.0538217578390441_dp > 1e-12) error stop

    print *, atand(l)
    if (atand(l) - 41.242282419755384_dp > 1e-12) error stop

    print *, atand(m)
    if (atand(m) - 28.490374622093171_dp > 1e-12) error stop

    print *, atand(0.1237382_dp)
    if (atand(0.1237382_dp) - 7.0538217578390441_dp > 1e-12) error stop

    print *, atand(0.8767382_dp)
    if (atand(0.8767382_dp) - 41.242282419755391_dp > 1e-12) error stop

    print *, atand(0.5427382_dp)
    if (atand(0.5427382_dp) - 528.490374622093171_dp > 1e-12) error stop

    q = -0.123
    y = -0.876
    z = -0.542

    k = -0.1237382_dp
    l = -0.8767382_dp
    m = -0.5427382_dp

    print *, atand(q)
    if (atand(q) - (-7.01215982_sp) > 1e-5) error stop

    print *, atand(y)
    if (atand(y) - (-41.2183571_sp) > 1e-5) error stop

    print *, atand(z)
    if (atand(z) - (-28.4576912_sp) > 1e-5) error stop

    print *, atand(-0.123_sp)
    if (atand(-0.123_sp) - (-7.01216030_sp) > 1e-5) error stop

    print *, atand(-0.876_sp)
    if (atand(-0.876_sp) - (-41.2183571_sp) > 1e-5) error stop

    print *, atand(-0.542_sp)
    if (atand(-0.542_sp) - (-28.4576931_sp) > 1e-5) error stop

    print *, atand(k)
    if (atand(k) - (-7.0538217578390441_sp) > 1e-12) error stop

    print *, atand(l)
    if (atand(l) - (-41.242282419755384_dp) > 1e-12) error stop

    print *, atand(m)
    if (atand(m) - (-28.490374622093171_dp) > 1e-12) error stop

end program
