/*
 * DaVinci interrupt controller definitions
 *
 *  Copyright (C) 2006 Texas Instruments.
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __ASM_ARCH_IRQS_H
#define __ASM_ARCH_IRQS_H

/* DA8XX interrupts */
#define IRQ_DA8XX_COMMTX		0
#define IRQ_DA8XX_COMMRX		1
#define IRQ_DA8XX_NINT			2
#define IRQ_DA8XX_EVTOUT0		3
#define IRQ_DA8XX_EVTOUT1		4
#define IRQ_DA8XX_EVTOUT2		5
#define IRQ_DA8XX_EVTOUT3		6
#define IRQ_DA8XX_EVTOUT4		7
#define IRQ_DA8XX_EVTOUT5		8
#define IRQ_DA8XX_EVTOUT6		9
#define IRQ_DA8XX_EVTOUT7		10
#define IRQ_DA8XX_CCINT0		11
#define IRQ_DA8XX_CCERRINT		12
#define IRQ_DA8XX_TCERRINT0		13
#define IRQ_DA8XX_AEMIFINT		14
#define IRQ_DA8XX_I2CINT0		15
#define IRQ_DA8XX_MMCSDINT0		16
#define IRQ_DA8XX_MMCSDINT1		17
#define IRQ_DA8XX_ALLINT0		18
#define IRQ_DA8XX_RTC			19
#define IRQ_DA8XX_SPINT0		20
#define IRQ_DA8XX_TINT12_0		21
#define IRQ_DA8XX_TINT34_0		22
#define IRQ_DA8XX_TINT12_1		23
#define IRQ_DA8XX_TINT34_1		24
#define IRQ_DA8XX_UARTINT0		25
#define IRQ_DA8XX_KEYMGRINT		26
#define IRQ_DA8XX_SECINT		26
#define IRQ_DA8XX_SECKEYERR		26
#define IRQ_DA8XX_CHIPINT0		28
#define IRQ_DA8XX_CHIPINT1		29
#define IRQ_DA8XX_CHIPINT2		30
#define IRQ_DA8XX_CHIPINT3		31
#define IRQ_DA8XX_TCERRINT1		32
#define IRQ_DA8XX_C0_RX_THRESH_PULSE	33
#define IRQ_DA8XX_C0_RX_PULSE		34
#define IRQ_DA8XX_C0_TX_PULSE		35
#define IRQ_DA8XX_C0_MISC_PULSE		36
#define IRQ_DA8XX_C1_RX_THRESH_PULSE	37
#define IRQ_DA8XX_C1_RX_PULSE		38
#define IRQ_DA8XX_C1_TX_PULSE		39
#define IRQ_DA8XX_C1_MISC_PULSE		40
#define IRQ_DA8XX_MEMERR		41
#define IRQ_DA8XX_GPIO0			42
#define IRQ_DA8XX_GPIO1			43
#define IRQ_DA8XX_GPIO2			44
#define IRQ_DA8XX_GPIO3			45
#define IRQ_DA8XX_GPIO4			46
#define IRQ_DA8XX_GPIO5			47
#define IRQ_DA8XX_GPIO6			48
#define IRQ_DA8XX_GPIO7			49
#define IRQ_DA8XX_GPIO8			50
#define IRQ_DA8XX_I2CINT1		51
#define IRQ_DA8XX_LCDINT		52
#define IRQ_DA8XX_UARTINT1		53
#define IRQ_DA8XX_MCASPINT		54
#define IRQ_DA8XX_ALLINT1		55
#define IRQ_DA8XX_SPINT1		56
#define IRQ_DA8XX_UHPI_INT1		57
#define IRQ_DA8XX_USB_INT		58
#define IRQ_DA8XX_IRQN			59
#define IRQ_DA8XX_RWAKEUP		60
#define IRQ_DA8XX_UARTINT2		61
#define IRQ_DA8XX_DFTSSINT		62
#define IRQ_DA8XX_EHRPWM0		63
#define IRQ_DA8XX_EHRPWM0TZ		64
#define IRQ_DA8XX_EHRPWM1		65
#define IRQ_DA8XX_EHRPWM1TZ		66
#define IRQ_DA8XX_ECAP0			69
#define IRQ_DA8XX_ECAP1			70
#define IRQ_DA8XX_ECAP2			71
#define IRQ_DA8XX_ARMCLKSTOPREQ		90

/* DA830 specific interrupts */
#define IRQ_DA830_MPUERR		27
#define IRQ_DA830_IOPUERR		27
#define IRQ_DA830_BOOTCFGERR		27
#define IRQ_DA830_EHRPWM2		67
#define IRQ_DA830_EHRPWM2TZ		68
#define IRQ_DA830_EQEP0			72
#define IRQ_DA830_EQEP1			73
#define IRQ_DA830_T12CMPINT0_0		74
#define IRQ_DA830_T12CMPINT1_0		75
#define IRQ_DA830_T12CMPINT2_0		76
#define IRQ_DA830_T12CMPINT3_0		77
#define IRQ_DA830_T12CMPINT4_0		78
#define IRQ_DA830_T12CMPINT5_0		79
#define IRQ_DA830_T12CMPINT6_0		80
#define IRQ_DA830_T12CMPINT7_0		81
#define IRQ_DA830_T12CMPINT0_1		82
#define IRQ_DA830_T12CMPINT1_1		83
#define IRQ_DA830_T12CMPINT2_1		84
#define IRQ_DA830_T12CMPINT3_1		85
#define IRQ_DA830_T12CMPINT4_1		86
#define IRQ_DA830_T12CMPINT5_1		87
#define IRQ_DA830_T12CMPINT6_1		88
#define IRQ_DA830_T12CMPINT7_1		89

#define DA830_N_CP_INTC_IRQ		96

/* DA850 speicific interrupts */
#define IRQ_DA850_MPUADDRERR0		27
#define IRQ_DA850_MPUPROTERR0		27
#define IRQ_DA850_IOPUADDRERR0		27
#define IRQ_DA850_IOPUPROTERR0		27
#define IRQ_DA850_IOPUADDRERR1		27
#define IRQ_DA850_IOPUPROTERR1		27
#define IRQ_DA850_IOPUADDRERR2		27
#define IRQ_DA850_IOPUPROTERR2		27
#define IRQ_DA850_BOOTCFG_ADDR_ERR	27
#define IRQ_DA850_BOOTCFG_PROT_ERR	27
#define IRQ_DA850_MPUADDRERR1		27
#define IRQ_DA850_MPUPROTERR1		27
#define IRQ_DA850_IOPUADDRERR3		27
#define IRQ_DA850_IOPUPROTERR3		27
#define IRQ_DA850_IOPUADDRERR4		27
#define IRQ_DA850_IOPUPROTERR4		27
#define IRQ_DA850_IOPUADDRERR5		27
#define IRQ_DA850_IOPUPROTERR5		27
#define IRQ_DA850_MIOPU_BOOTCFG_ERR	27
#define IRQ_DA850_SATAINT		67
#define IRQ_DA850_TINT12_2		68
#define IRQ_DA850_TINT34_2		68
#define IRQ_DA850_TINTALL_2		68
#define IRQ_DA850_MMCSDINT0_1		72
#define IRQ_DA850_MMCSDINT1_1		73
#define IRQ_DA850_T12CMPINT0_2		74
#define IRQ_DA850_T12CMPINT1_2		75
#define IRQ_DA850_T12CMPINT2_2		76
#define IRQ_DA850_T12CMPINT3_2		77
#define IRQ_DA850_T12CMPINT4_2		78
#define IRQ_DA850_T12CMPINT5_2		79
#define IRQ_DA850_T12CMPINT6_2		80
#define IRQ_DA850_T12CMPINT7_2		81
#define IRQ_DA850_T12CMPINT0_3		82
#define IRQ_DA850_T12CMPINT1_3		83
#define IRQ_DA850_T12CMPINT2_3		84
#define IRQ_DA850_T12CMPINT3_3		85
#define IRQ_DA850_T12CMPINT4_3		86
#define IRQ_DA850_T12CMPINT5_3		87
#define IRQ_DA850_T12CMPINT6_3		88
#define IRQ_DA850_T12CMPINT7_3		89
#define IRQ_DA850_RPIINT		91
#define IRQ_DA850_VPIFINT		92
#define IRQ_DA850_CCINT1		93
#define IRQ_DA850_CCERRINT1		94
#define IRQ_DA850_TCERRINT2		95
#define IRQ_DA850_TINT12_3		96
#define IRQ_DA850_TINT34_3		96
#define IRQ_DA850_TINTALL_3		96
#define IRQ_DA850_MCBSP0RINT		97
#define IRQ_DA850_MCBSP0XINT		98
#define IRQ_DA850_MCBSP1RINT		99
#define IRQ_DA850_MCBSP1XINT		100

#define DA850_N_CP_INTC_IRQ		101

#endif /* __ASM_ARCH_IRQS_H */
