/* SPDX-License-Identifier: GPL-2.0
 *
 * Copyright 2020 HabanaLabs, Ltd.
 * All Rights Reserved.
 *
 */

#ifndef GAUDI2_REG_MAP_H_
#define GAUDI2_REG_MAP_H_

/*
 * PSOC scratch-pad registers
 */
#define mmHW_STATE				mmCPU_IF_KMD_HW_DIRTY_STATUS
#define mmPID_STATUS_REG			mmPSOC_GLOBAL_CONF_SCRATCHPAD_1
#define mmARM_STATUS_REG			mmPSOC_GLOBAL_CONF_SCRATCHPAD_2
#define mmGIC_TPC_QM_IRQ_CTRL_POLL_REG		mmPSOC_GLOBAL_CONF_SCRATCHPAD_3
#define mmGIC_MME_QM_IRQ_CTRL_POLL_REG		mmPSOC_GLOBAL_CONF_SCRATCHPAD_4
#define mmGIC_DMA_QM_IRQ_CTRL_POLL_REG		mmPSOC_GLOBAL_CONF_SCRATCHPAD_5
#define mmGIC_ROT_QM_IRQ_CTRL_POLL_REG		mmPSOC_GLOBAL_CONF_SCRATCHPAD_6
#define mmGIC_NIC_QM_IRQ_CTRL_POLL_REG		mmPSOC_GLOBAL_CONF_SCRATCHPAD_7
#define mmGIC_DMA_CR_IRQ_CTRL_POLL_REG		mmPSOC_GLOBAL_CONF_SCRATCHPAD_8
#define mmGIC_HOST_PI_UPD_IRQ_POLL_REG		mmPSOC_GLOBAL_CONF_SCRATCHPAD_9
#define mmGIC_HOST_HALT_IRQ_POLL_REG		mmPSOC_GLOBAL_CONF_SCRATCHPAD_10
#define mmGIC_HOST_INTS_IRQ_POLL_REG		mmPSOC_GLOBAL_CONF_SCRATCHPAD_11
#define mmGIC_HOST_SOFT_RST_IRQ_POLL_REG	mmPSOC_GLOBAL_CONF_SCRATCHPAD_12
#define mmCPU_RST_STATUS_TO_HOST		mmPSOC_GLOBAL_CONF_SCRATCHPAD_14
/*
 *  Single scratchpad register used for all ARCs to notify dccm queue full event to FW.
 *  So a new event would overwrite any unhandled previous event. In other words, incase
 *  of multiple events before previous ones are handled, last one would be considered.
 */
#define mmENGINE_ARC_IRQ_CTRL_POLL_REG		mmPSOC_GLOBAL_CONF_SCRATCHPAD_15
#define mmPID_CFG_REG				mmPSOC_GLOBAL_CONF_SCRATCHPAD_18
#define mmGIC_RAZWI_STATUS_REG			mmPSOC_GLOBAL_CONF_SCRATCHPAD_19
#define mmCPU_BOOT_DEV_STS0			mmPSOC_GLOBAL_CONF_SCRATCHPAD_20
#define mmCPU_BOOT_DEV_STS1			mmPSOC_GLOBAL_CONF_SCRATCHPAD_21
#define mmCPU_CMD_STATUS_TO_HOST		mmPSOC_GLOBAL_CONF_SCRATCHPAD_23
#define mmCPU_BOOT_ERR0				mmPSOC_GLOBAL_CONF_SCRATCHPAD_24
#define mmCPU_BOOT_ERR1				mmPSOC_GLOBAL_CONF_SCRATCHPAD_25
#define mmUPD_STS				mmPSOC_GLOBAL_CONF_SCRATCHPAD_26
#define mmUPD_CMD				mmPSOC_GLOBAL_CONF_SCRATCHPAD_27
#define mmPPBOOT_VER_OFFSET			mmPSOC_GLOBAL_CONF_SCRATCHPAD_28
#define mmRDWR_TEST				mmPSOC_GLOBAL_CONF_SCRATCHPAD_30
#define mmBTL_ID				mmPSOC_GLOBAL_CONF_SCRATCHPAD_31
#define mmRST_SRC				mmPSOC_GLOBAL_CONF_COLD_RST_FLOPS_0
#define mmCOLD_RST_DATA				mmPSOC_GLOBAL_CONF_COLD_RST_FLOPS_2
#define mmUPD_PENDING_STS			mmPSOC_GLOBAL_CONF_COLD_RST_FLOPS_3
#define mmPID_CMD_REQ_REG			mmPSOC_PID_PID_CMD_0
#define mmPID_CMD_REQ_REG_HI			mmPSOC_PID_PID_CMD_1
#define mmPID_CMD_RSP_REG			mmPSOC_PID_PID_CMD_2
#define mmPID_CMD_RSP_REG_HI			mmPSOC_PID_PID_CMD_3
#define mmPID_CMD_TELEMETRY_REG_0		mmPSOC_PID_PID_CMD_4
#define mmPID_CMD_TELEMETRY_REG_0_HI		mmPSOC_PID_PID_CMD_5
#define mmPID_CMD_TELEMETRY_REG_1		mmPSOC_PID_PID_CMD_6
#define mmPID_CMD_TELEMETRY_REG_1_HI		mmPSOC_PID_PID_CMD_7
#define mmWD_GPIO_OUTSET_REG			mmPSOC_GPIO3_OUTENSET
#define mmWD_GPIO_DATAOUT_REG			mmPSOC_GPIO3_DATAOUT
#define mmSTM_PROFILER_SPE_REG			mmPSOC_STM_STMSPER

#endif /* GAUDI2_REG_MAP_H_ */
