; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu -O2 \
; RUN:   -ppc-gpr-icmps=all -ppc-asm-full-reg-names -mcpu=pwr8 < %s | FileCheck %s \
; RUN:  --implicit-check-not cmpw --implicit-check-not cmpd --implicit-check-not cmpl \
; RUN:  --check-prefixes=CHECK,BE
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu -O2 \
; RUN:   -ppc-gpr-icmps=all -ppc-asm-full-reg-names -mcpu=pwr8 < %s | FileCheck %s \
; RUN:  --implicit-check-not cmpw --implicit-check-not cmpd --implicit-check-not cmpl \
; RUN:  --check-prefixes=CHECK,LE

@glob = local_unnamed_addr global i32 0, align 4

; Function Attrs: norecurse nounwind readnone
define signext i32 @test_ileui(i32 zeroext %a, i32 zeroext %b) {
; CHECK-LABEL: test_ileui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sub r3, r4, r3
; CHECK-NEXT:    not r3, r3
; CHECK-NEXT:    rldicl r3, r3, 1, 63
; CHECK-NEXT:    blr
entry:
  %cmp = icmp ule i32 %a, %b
  %sub = zext i1 %cmp to i32
  ret i32 %sub
}

; Function Attrs: norecurse nounwind readnone
define signext i32 @test_ileui_sext(i32 zeroext %a, i32 zeroext %b) {
; CHECK-LABEL: test_ileui_sext:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sub r3, r4, r3
; CHECK-NEXT:    rldicl r3, r3, 1, 63
; CHECK-NEXT:    addi r3, r3, -1
; CHECK-NEXT:    blr
entry:
  %cmp = icmp ule i32 %a, %b
  %sub = sext i1 %cmp to i32
  ret i32 %sub
}

; Function Attrs: norecurse nounwind readnone
define signext i32 @test_ileui_z(i32 zeroext %a) {
; CHECK-LABEL: test_ileui_z:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    blr
entry:
  %cmp = icmp eq i32 %a, 0
  %sub = zext i1 %cmp to i32
  ret i32 %sub
}

; Function Attrs: norecurse nounwind readnone
define signext i32 @test_ileui_sext_z(i32 zeroext %a) {
; CHECK-LABEL: test_ileui_sext_z:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cntlzw r3, r3
; CHECK-NEXT:    srwi r3, r3, 5
; CHECK-NEXT:    neg r3, r3
; CHECK-NEXT:    blr
entry:
  %cmp = icmp eq i32 %a, 0
  %sub = sext i1 %cmp to i32
  ret i32 %sub
}

; Function Attrs: norecurse nounwind
define void @test_ileui_store(i32 zeroext %a, i32 zeroext %b) {
; BE-LABEL: test_ileui_store:
; BE:       # %bb.0: # %entry
; BE-NEXT:    addis r5, r2, .LC0@toc@ha
; BE-NEXT:    sub r3, r4, r3
; BE-NEXT:    ld r4, .LC0@toc@l(r5)
; BE-NEXT:    not r3, r3
; BE-NEXT:    rldicl r3, r3, 1, 63
; BE-NEXT:    stw r3, 0(r4)
; BE-NEXT:    blr
;
; LE-LABEL: test_ileui_store:
; LE:       # %bb.0: # %entry
; LE-NEXT:    sub r3, r4, r3
; LE-NEXT:    addis r5, r2, glob@toc@ha
; LE-NEXT:    not r3, r3
; LE-NEXT:    rldicl r3, r3, 1, 63
; LE-NEXT:    stw r3, glob@toc@l(r5)
; LE-NEXT:    blr
entry:
  %cmp = icmp ule i32 %a, %b
  %sub = zext i1 %cmp to i32
  store i32 %sub, i32* @glob
  ret void
}

; Function Attrs: norecurse nounwind
define void @test_ileui_sext_store(i32 zeroext %a, i32 zeroext %b) {
; BE-LABEL: test_ileui_sext_store:
; BE:       # %bb.0: # %entry
; BE-NEXT:    addis r5, r2, .LC0@toc@ha
; BE-NEXT:    sub r3, r4, r3
; BE-NEXT:    ld r4, .LC0@toc@l(r5)
; BE-NEXT:    rldicl r3, r3, 1, 63
; BE-NEXT:    addi r3, r3, -1
; BE-NEXT:    stw r3, 0(r4)
; BE-NEXT:    blr
;
; LE-LABEL: test_ileui_sext_store:
; LE:       # %bb.0: # %entry
; LE-NEXT:    sub r3, r4, r3
; LE-NEXT:    addis r5, r2, glob@toc@ha
; LE-NEXT:    rldicl r3, r3, 1, 63
; LE-NEXT:    addi r3, r3, -1
; LE-NEXT:    stw r3, glob@toc@l(r5)
; LE-NEXT:    blr
entry:
  %cmp = icmp ule i32 %a, %b
  %sub = sext i1 %cmp to i32
  store i32 %sub, i32* @glob
  ret void
}

; Function Attrs: norecurse nounwind
define void @test_ileui_z_store(i32 zeroext %a) {
; BE-LABEL: test_ileui_z_store:
; BE:       # %bb.0: # %entry
; BE-NEXT:    addis r4, r2, .LC0@toc@ha
; BE-NEXT:    cntlzw r3, r3
; BE-NEXT:    ld r4, .LC0@toc@l(r4)
; BE-NEXT:    srwi r3, r3, 5
; BE-NEXT:    stw r3, 0(r4)
; BE-NEXT:    blr
;
; LE-LABEL: test_ileui_z_store:
; LE:       # %bb.0: # %entry
; LE-NEXT:    cntlzw r3, r3
; LE-NEXT:    addis r4, r2, glob@toc@ha
; LE-NEXT:    srwi r3, r3, 5
; LE-NEXT:    stw r3, glob@toc@l(r4)
; LE-NEXT:    blr
entry:
  %cmp = icmp eq i32 %a, 0
  %sub = zext i1 %cmp to i32
  store i32 %sub, i32* @glob
  ret void
}

; Function Attrs: norecurse nounwind
define void @test_ileui_sext_z_store(i32 zeroext %a) {
; BE-LABEL: test_ileui_sext_z_store:
; BE:       # %bb.0: # %entry
; BE-NEXT:    addis r4, r2, .LC0@toc@ha
; BE-NEXT:    cntlzw r3, r3
; BE-NEXT:    ld r4, .LC0@toc@l(r4)
; BE-NEXT:    srwi r3, r3, 5
; BE-NEXT:    neg r3, r3
; BE-NEXT:    stw r3, 0(r4)
; BE-NEXT:    blr
;
; LE-LABEL: test_ileui_sext_z_store:
; LE:       # %bb.0: # %entry
; LE-NEXT:    cntlzw r3, r3
; LE-NEXT:    addis r4, r2, glob@toc@ha
; LE-NEXT:    srwi r3, r3, 5
; LE-NEXT:    neg r3, r3
; LE-NEXT:    stw r3, glob@toc@l(r4)
; LE-NEXT:    blr
entry:
  %cmp = icmp eq i32 %a, 0
  %sub = sext i1 %cmp to i32
  store i32 %sub, i32* @glob
  ret void
}

