// RUN: llvm-mc -arch=amdgcn -mcpu=gfx900 -show-encoding %s | FileCheck %s

flat_load_ubyte v5, v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x40,0xdc,0x01,0x00,0x00,0x05]

flat_load_ubyte v255, v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x40,0xdc,0x01,0x00,0x00,0xff]

flat_load_ubyte v5, v[254:255] offset:4095
// CHECK: [0xff,0x0f,0x40,0xdc,0xfe,0x00,0x00,0x05]

flat_load_ubyte v5, v[1:2]
// CHECK: [0x00,0x00,0x40,0xdc,0x01,0x00,0x00,0x05]

flat_load_ubyte v5, v[1:2] offset:0
// CHECK: [0x00,0x00,0x40,0xdc,0x01,0x00,0x00,0x05]

flat_load_ubyte v5, v[1:2] offset:7
// CHECK: [0x07,0x00,0x40,0xdc,0x01,0x00,0x00,0x05]

flat_load_ubyte v5, v[1:2] offset:4095 glc
// CHECK: [0xff,0x0f,0x41,0xdc,0x01,0x00,0x00,0x05]

flat_load_ubyte v5, v[1:2] offset:4095 slc
// CHECK: [0xff,0x0f,0x42,0xdc,0x01,0x00,0x00,0x05]

flat_load_sbyte v5, v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x44,0xdc,0x01,0x00,0x00,0x05]

flat_load_sbyte v255, v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x44,0xdc,0x01,0x00,0x00,0xff]

flat_load_sbyte v5, v[254:255] offset:4095
// CHECK: [0xff,0x0f,0x44,0xdc,0xfe,0x00,0x00,0x05]

flat_load_sbyte v5, v[1:2]
// CHECK: [0x00,0x00,0x44,0xdc,0x01,0x00,0x00,0x05]

flat_load_sbyte v5, v[1:2] offset:0
// CHECK: [0x00,0x00,0x44,0xdc,0x01,0x00,0x00,0x05]

flat_load_sbyte v5, v[1:2] offset:7
// CHECK: [0x07,0x00,0x44,0xdc,0x01,0x00,0x00,0x05]

flat_load_sbyte v5, v[1:2] offset:4095 glc
// CHECK: [0xff,0x0f,0x45,0xdc,0x01,0x00,0x00,0x05]

flat_load_sbyte v5, v[1:2] offset:4095 slc
// CHECK: [0xff,0x0f,0x46,0xdc,0x01,0x00,0x00,0x05]

flat_load_ushort v5, v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x48,0xdc,0x01,0x00,0x00,0x05]

flat_load_ushort v255, v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x48,0xdc,0x01,0x00,0x00,0xff]

flat_load_ushort v5, v[254:255] offset:4095
// CHECK: [0xff,0x0f,0x48,0xdc,0xfe,0x00,0x00,0x05]

flat_load_ushort v5, v[1:2]
// CHECK: [0x00,0x00,0x48,0xdc,0x01,0x00,0x00,0x05]

flat_load_ushort v5, v[1:2] offset:0
// CHECK: [0x00,0x00,0x48,0xdc,0x01,0x00,0x00,0x05]

flat_load_ushort v5, v[1:2] offset:7
// CHECK: [0x07,0x00,0x48,0xdc,0x01,0x00,0x00,0x05]

flat_load_ushort v5, v[1:2] offset:4095 glc
// CHECK: [0xff,0x0f,0x49,0xdc,0x01,0x00,0x00,0x05]

flat_load_ushort v5, v[1:2] offset:4095 slc
// CHECK: [0xff,0x0f,0x4a,0xdc,0x01,0x00,0x00,0x05]

flat_load_sshort v5, v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x4c,0xdc,0x01,0x00,0x00,0x05]

flat_load_sshort v255, v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x4c,0xdc,0x01,0x00,0x00,0xff]

flat_load_sshort v5, v[254:255] offset:4095
// CHECK: [0xff,0x0f,0x4c,0xdc,0xfe,0x00,0x00,0x05]

flat_load_sshort v5, v[1:2]
// CHECK: [0x00,0x00,0x4c,0xdc,0x01,0x00,0x00,0x05]

flat_load_sshort v5, v[1:2] offset:0
// CHECK: [0x00,0x00,0x4c,0xdc,0x01,0x00,0x00,0x05]

flat_load_sshort v5, v[1:2] offset:7
// CHECK: [0x07,0x00,0x4c,0xdc,0x01,0x00,0x00,0x05]

flat_load_sshort v5, v[1:2] offset:4095 glc
// CHECK: [0xff,0x0f,0x4d,0xdc,0x01,0x00,0x00,0x05]

flat_load_sshort v5, v[1:2] offset:4095 slc
// CHECK: [0xff,0x0f,0x4e,0xdc,0x01,0x00,0x00,0x05]

flat_load_dword v5, v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x50,0xdc,0x01,0x00,0x00,0x05]

flat_load_dword v255, v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x50,0xdc,0x01,0x00,0x00,0xff]

flat_load_dword v5, v[254:255] offset:4095
// CHECK: [0xff,0x0f,0x50,0xdc,0xfe,0x00,0x00,0x05]

flat_load_dword v5, v[1:2]
// CHECK: [0x00,0x00,0x50,0xdc,0x01,0x00,0x00,0x05]

flat_load_dword v5, v[1:2] offset:0
// CHECK: [0x00,0x00,0x50,0xdc,0x01,0x00,0x00,0x05]

flat_load_dword v5, v[1:2] offset:7
// CHECK: [0x07,0x00,0x50,0xdc,0x01,0x00,0x00,0x05]

flat_load_dword v5, v[1:2] offset:4095 glc
// CHECK: [0xff,0x0f,0x51,0xdc,0x01,0x00,0x00,0x05]

flat_load_dword v5, v[1:2] offset:4095 slc
// CHECK: [0xff,0x0f,0x52,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx2 v[5:6], v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x54,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx2 v[254:255], v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x54,0xdc,0x01,0x00,0x00,0xfe]

flat_load_dwordx2 v[5:6], v[254:255] offset:4095
// CHECK: [0xff,0x0f,0x54,0xdc,0xfe,0x00,0x00,0x05]

flat_load_dwordx2 v[5:6], v[1:2]
// CHECK: [0x00,0x00,0x54,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx2 v[5:6], v[1:2] offset:0
// CHECK: [0x00,0x00,0x54,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx2 v[5:6], v[1:2] offset:7
// CHECK: [0x07,0x00,0x54,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx2 v[5:6], v[1:2] offset:4095 glc
// CHECK: [0xff,0x0f,0x55,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx2 v[5:6], v[1:2] offset:4095 slc
// CHECK: [0xff,0x0f,0x56,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx3 v[5:7], v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x58,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx3 v[253:255], v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x58,0xdc,0x01,0x00,0x00,0xfd]

flat_load_dwordx3 v[5:7], v[254:255] offset:4095
// CHECK: [0xff,0x0f,0x58,0xdc,0xfe,0x00,0x00,0x05]

flat_load_dwordx3 v[5:7], v[1:2]
// CHECK: [0x00,0x00,0x58,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx3 v[5:7], v[1:2] offset:0
// CHECK: [0x00,0x00,0x58,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx3 v[5:7], v[1:2] offset:7
// CHECK: [0x07,0x00,0x58,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx3 v[5:7], v[1:2] offset:4095 glc
// CHECK: [0xff,0x0f,0x59,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx3 v[5:7], v[1:2] offset:4095 slc
// CHECK: [0xff,0x0f,0x5a,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx4 v[5:8], v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x5c,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx4 v[252:255], v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x5c,0xdc,0x01,0x00,0x00,0xfc]

flat_load_dwordx4 v[5:8], v[254:255] offset:4095
// CHECK: [0xff,0x0f,0x5c,0xdc,0xfe,0x00,0x00,0x05]

flat_load_dwordx4 v[5:8], v[1:2]
// CHECK: [0x00,0x00,0x5c,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx4 v[5:8], v[1:2] offset:0
// CHECK: [0x00,0x00,0x5c,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx4 v[5:8], v[1:2] offset:7
// CHECK: [0x07,0x00,0x5c,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx4 v[5:8], v[1:2] offset:4095 glc
// CHECK: [0xff,0x0f,0x5d,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx4 v[5:8], v[1:2] offset:4095 slc
// CHECK: [0xff,0x0f,0x5e,0xdc,0x01,0x00,0x00,0x05]

flat_store_byte v[1:2], v2 offset:4095
// CHECK: [0xff,0x0f,0x60,0xdc,0x01,0x02,0x00,0x00]

flat_store_byte v[254:255], v2 offset:4095
// CHECK: [0xff,0x0f,0x60,0xdc,0xfe,0x02,0x00,0x00]

flat_store_byte v[1:2], v255 offset:4095
// CHECK: [0xff,0x0f,0x60,0xdc,0x01,0xff,0x00,0x00]

flat_store_byte v[1:2], v2
// CHECK: [0x00,0x00,0x60,0xdc,0x01,0x02,0x00,0x00]

flat_store_byte v[1:2], v2 offset:0
// CHECK: [0x00,0x00,0x60,0xdc,0x01,0x02,0x00,0x00]

flat_store_byte v[1:2], v2 offset:7
// CHECK: [0x07,0x00,0x60,0xdc,0x01,0x02,0x00,0x00]

flat_store_byte v[1:2], v2 offset:4095 glc
// CHECK: [0xff,0x0f,0x61,0xdc,0x01,0x02,0x00,0x00]

flat_store_byte v[1:2], v2 offset:4095 slc
// CHECK: [0xff,0x0f,0x62,0xdc,0x01,0x02,0x00,0x00]

flat_store_byte_d16_hi v[1:2], v2 offset:4095
// CHECK: [0xff,0x0f,0x64,0xdc,0x01,0x02,0x00,0x00]

flat_store_byte_d16_hi v[254:255], v2 offset:4095
// CHECK: [0xff,0x0f,0x64,0xdc,0xfe,0x02,0x00,0x00]

flat_store_byte_d16_hi v[1:2], v255 offset:4095
// CHECK: [0xff,0x0f,0x64,0xdc,0x01,0xff,0x00,0x00]

flat_store_byte_d16_hi v[1:2], v2
// CHECK: [0x00,0x00,0x64,0xdc,0x01,0x02,0x00,0x00]

flat_store_byte_d16_hi v[1:2], v2 offset:0
// CHECK: [0x00,0x00,0x64,0xdc,0x01,0x02,0x00,0x00]

flat_store_byte_d16_hi v[1:2], v2 offset:7
// CHECK: [0x07,0x00,0x64,0xdc,0x01,0x02,0x00,0x00]

flat_store_byte_d16_hi v[1:2], v2 offset:4095 glc
// CHECK: [0xff,0x0f,0x65,0xdc,0x01,0x02,0x00,0x00]

flat_store_byte_d16_hi v[1:2], v2 offset:4095 slc
// CHECK: [0xff,0x0f,0x66,0xdc,0x01,0x02,0x00,0x00]

flat_store_short v[1:2], v2 offset:4095
// CHECK: [0xff,0x0f,0x68,0xdc,0x01,0x02,0x00,0x00]

flat_store_short v[254:255], v2 offset:4095
// CHECK: [0xff,0x0f,0x68,0xdc,0xfe,0x02,0x00,0x00]

flat_store_short v[1:2], v255 offset:4095
// CHECK: [0xff,0x0f,0x68,0xdc,0x01,0xff,0x00,0x00]

flat_store_short v[1:2], v2
// CHECK: [0x00,0x00,0x68,0xdc,0x01,0x02,0x00,0x00]

flat_store_short v[1:2], v2 offset:0
// CHECK: [0x00,0x00,0x68,0xdc,0x01,0x02,0x00,0x00]

flat_store_short v[1:2], v2 offset:7
// CHECK: [0x07,0x00,0x68,0xdc,0x01,0x02,0x00,0x00]

flat_store_short v[1:2], v2 offset:4095 glc
// CHECK: [0xff,0x0f,0x69,0xdc,0x01,0x02,0x00,0x00]

flat_store_short v[1:2], v2 offset:4095 slc
// CHECK: [0xff,0x0f,0x6a,0xdc,0x01,0x02,0x00,0x00]

flat_store_short_d16_hi v[1:2], v2 offset:4095
// CHECK: [0xff,0x0f,0x6c,0xdc,0x01,0x02,0x00,0x00]

flat_store_short_d16_hi v[254:255], v2 offset:4095
// CHECK: [0xff,0x0f,0x6c,0xdc,0xfe,0x02,0x00,0x00]

flat_store_short_d16_hi v[1:2], v255 offset:4095
// CHECK: [0xff,0x0f,0x6c,0xdc,0x01,0xff,0x00,0x00]

flat_store_short_d16_hi v[1:2], v2
// CHECK: [0x00,0x00,0x6c,0xdc,0x01,0x02,0x00,0x00]

flat_store_short_d16_hi v[1:2], v2 offset:0
// CHECK: [0x00,0x00,0x6c,0xdc,0x01,0x02,0x00,0x00]

flat_store_short_d16_hi v[1:2], v2 offset:7
// CHECK: [0x07,0x00,0x6c,0xdc,0x01,0x02,0x00,0x00]

flat_store_short_d16_hi v[1:2], v2 offset:4095 glc
// CHECK: [0xff,0x0f,0x6d,0xdc,0x01,0x02,0x00,0x00]

flat_store_short_d16_hi v[1:2], v2 offset:4095 slc
// CHECK: [0xff,0x0f,0x6e,0xdc,0x01,0x02,0x00,0x00]

flat_store_dword v[1:2], v2 offset:4095
// CHECK: [0xff,0x0f,0x70,0xdc,0x01,0x02,0x00,0x00]

flat_store_dword v[254:255], v2 offset:4095
// CHECK: [0xff,0x0f,0x70,0xdc,0xfe,0x02,0x00,0x00]

flat_store_dword v[1:2], v255 offset:4095
// CHECK: [0xff,0x0f,0x70,0xdc,0x01,0xff,0x00,0x00]

flat_store_dword v[1:2], v2
// CHECK: [0x00,0x00,0x70,0xdc,0x01,0x02,0x00,0x00]

flat_store_dword v[1:2], v2 offset:0
// CHECK: [0x00,0x00,0x70,0xdc,0x01,0x02,0x00,0x00]

flat_store_dword v[1:2], v2 offset:7
// CHECK: [0x07,0x00,0x70,0xdc,0x01,0x02,0x00,0x00]

flat_store_dword v[1:2], v2 offset:4095 glc
// CHECK: [0xff,0x0f,0x71,0xdc,0x01,0x02,0x00,0x00]

flat_store_dword v[1:2], v2 offset:4095 slc
// CHECK: [0xff,0x0f,0x72,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx2 v[1:2], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0x74,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx2 v[254:255], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0x74,0xdc,0xfe,0x02,0x00,0x00]

flat_store_dwordx2 v[1:2], v[254:255] offset:4095
// CHECK: [0xff,0x0f,0x74,0xdc,0x01,0xfe,0x00,0x00]

flat_store_dwordx2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x74,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx2 v[1:2], v[2:3] offset:0
// CHECK: [0x00,0x00,0x74,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx2 v[1:2], v[2:3] offset:7
// CHECK: [0x07,0x00,0x74,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx2 v[1:2], v[2:3] offset:4095 glc
// CHECK: [0xff,0x0f,0x75,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx2 v[1:2], v[2:3] offset:4095 slc
// CHECK: [0xff,0x0f,0x76,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx3 v[1:2], v[2:4] offset:4095
// CHECK: [0xff,0x0f,0x78,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx3 v[254:255], v[2:4] offset:4095
// CHECK: [0xff,0x0f,0x78,0xdc,0xfe,0x02,0x00,0x00]

flat_store_dwordx3 v[1:2], v[253:255] offset:4095
// CHECK: [0xff,0x0f,0x78,0xdc,0x01,0xfd,0x00,0x00]

flat_store_dwordx3 v[1:2], v[2:4]
// CHECK: [0x00,0x00,0x78,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx3 v[1:2], v[2:4] offset:0
// CHECK: [0x00,0x00,0x78,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx3 v[1:2], v[2:4] offset:7
// CHECK: [0x07,0x00,0x78,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx3 v[1:2], v[2:4] offset:4095 glc
// CHECK: [0xff,0x0f,0x79,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx3 v[1:2], v[2:4] offset:4095 slc
// CHECK: [0xff,0x0f,0x7a,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx4 v[1:2], v[2:5] offset:4095
// CHECK: [0xff,0x0f,0x7c,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx4 v[254:255], v[2:5] offset:4095
// CHECK: [0xff,0x0f,0x7c,0xdc,0xfe,0x02,0x00,0x00]

flat_store_dwordx4 v[1:2], v[252:255] offset:4095
// CHECK: [0xff,0x0f,0x7c,0xdc,0x01,0xfc,0x00,0x00]

flat_store_dwordx4 v[1:2], v[2:5]
// CHECK: [0x00,0x00,0x7c,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx4 v[1:2], v[2:5] offset:0
// CHECK: [0x00,0x00,0x7c,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx4 v[1:2], v[2:5] offset:7
// CHECK: [0x07,0x00,0x7c,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx4 v[1:2], v[2:5] offset:4095 glc
// CHECK: [0xff,0x0f,0x7d,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx4 v[1:2], v[2:5] offset:4095 slc
// CHECK: [0xff,0x0f,0x7e,0xdc,0x01,0x02,0x00,0x00]

flat_load_ubyte_d16 v5, v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x80,0xdc,0x01,0x00,0x00,0x05]

flat_load_ubyte_d16 v255, v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x80,0xdc,0x01,0x00,0x00,0xff]

flat_load_ubyte_d16 v5, v[254:255] offset:4095
// CHECK: [0xff,0x0f,0x80,0xdc,0xfe,0x00,0x00,0x05]

flat_load_ubyte_d16 v5, v[1:2]
// CHECK: [0x00,0x00,0x80,0xdc,0x01,0x00,0x00,0x05]

flat_load_ubyte_d16 v5, v[1:2] offset:0
// CHECK: [0x00,0x00,0x80,0xdc,0x01,0x00,0x00,0x05]

flat_load_ubyte_d16 v5, v[1:2] offset:7
// CHECK: [0x07,0x00,0x80,0xdc,0x01,0x00,0x00,0x05]

flat_load_ubyte_d16 v5, v[1:2] offset:4095 glc
// CHECK: [0xff,0x0f,0x81,0xdc,0x01,0x00,0x00,0x05]

flat_load_ubyte_d16 v5, v[1:2] offset:4095 slc
// CHECK: [0xff,0x0f,0x82,0xdc,0x01,0x00,0x00,0x05]

flat_load_ubyte_d16_hi v5, v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x84,0xdc,0x01,0x00,0x00,0x05]

flat_load_ubyte_d16_hi v255, v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x84,0xdc,0x01,0x00,0x00,0xff]

flat_load_ubyte_d16_hi v5, v[254:255] offset:4095
// CHECK: [0xff,0x0f,0x84,0xdc,0xfe,0x00,0x00,0x05]

flat_load_ubyte_d16_hi v5, v[1:2]
// CHECK: [0x00,0x00,0x84,0xdc,0x01,0x00,0x00,0x05]

flat_load_ubyte_d16_hi v5, v[1:2] offset:0
// CHECK: [0x00,0x00,0x84,0xdc,0x01,0x00,0x00,0x05]

flat_load_ubyte_d16_hi v5, v[1:2] offset:7
// CHECK: [0x07,0x00,0x84,0xdc,0x01,0x00,0x00,0x05]

flat_load_ubyte_d16_hi v5, v[1:2] offset:4095 glc
// CHECK: [0xff,0x0f,0x85,0xdc,0x01,0x00,0x00,0x05]

flat_load_ubyte_d16_hi v5, v[1:2] offset:4095 slc
// CHECK: [0xff,0x0f,0x86,0xdc,0x01,0x00,0x00,0x05]

flat_load_sbyte_d16 v5, v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x88,0xdc,0x01,0x00,0x00,0x05]

flat_load_sbyte_d16 v255, v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x88,0xdc,0x01,0x00,0x00,0xff]

flat_load_sbyte_d16 v5, v[254:255] offset:4095
// CHECK: [0xff,0x0f,0x88,0xdc,0xfe,0x00,0x00,0x05]

flat_load_sbyte_d16 v5, v[1:2]
// CHECK: [0x00,0x00,0x88,0xdc,0x01,0x00,0x00,0x05]

flat_load_sbyte_d16 v5, v[1:2] offset:0
// CHECK: [0x00,0x00,0x88,0xdc,0x01,0x00,0x00,0x05]

flat_load_sbyte_d16 v5, v[1:2] offset:7
// CHECK: [0x07,0x00,0x88,0xdc,0x01,0x00,0x00,0x05]

flat_load_sbyte_d16 v5, v[1:2] offset:4095 glc
// CHECK: [0xff,0x0f,0x89,0xdc,0x01,0x00,0x00,0x05]

flat_load_sbyte_d16 v5, v[1:2] offset:4095 slc
// CHECK: [0xff,0x0f,0x8a,0xdc,0x01,0x00,0x00,0x05]

flat_load_sbyte_d16_hi v5, v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x8c,0xdc,0x01,0x00,0x00,0x05]

flat_load_sbyte_d16_hi v255, v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x8c,0xdc,0x01,0x00,0x00,0xff]

flat_load_sbyte_d16_hi v5, v[254:255] offset:4095
// CHECK: [0xff,0x0f,0x8c,0xdc,0xfe,0x00,0x00,0x05]

flat_load_sbyte_d16_hi v5, v[1:2]
// CHECK: [0x00,0x00,0x8c,0xdc,0x01,0x00,0x00,0x05]

flat_load_sbyte_d16_hi v5, v[1:2] offset:0
// CHECK: [0x00,0x00,0x8c,0xdc,0x01,0x00,0x00,0x05]

flat_load_sbyte_d16_hi v5, v[1:2] offset:7
// CHECK: [0x07,0x00,0x8c,0xdc,0x01,0x00,0x00,0x05]

flat_load_sbyte_d16_hi v5, v[1:2] offset:4095 glc
// CHECK: [0xff,0x0f,0x8d,0xdc,0x01,0x00,0x00,0x05]

flat_load_sbyte_d16_hi v5, v[1:2] offset:4095 slc
// CHECK: [0xff,0x0f,0x8e,0xdc,0x01,0x00,0x00,0x05]

flat_load_short_d16 v5, v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x90,0xdc,0x01,0x00,0x00,0x05]

flat_load_short_d16 v255, v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x90,0xdc,0x01,0x00,0x00,0xff]

flat_load_short_d16 v5, v[254:255] offset:4095
// CHECK: [0xff,0x0f,0x90,0xdc,0xfe,0x00,0x00,0x05]

flat_load_short_d16 v5, v[1:2]
// CHECK: [0x00,0x00,0x90,0xdc,0x01,0x00,0x00,0x05]

flat_load_short_d16 v5, v[1:2] offset:0
// CHECK: [0x00,0x00,0x90,0xdc,0x01,0x00,0x00,0x05]

flat_load_short_d16 v5, v[1:2] offset:7
// CHECK: [0x07,0x00,0x90,0xdc,0x01,0x00,0x00,0x05]

flat_load_short_d16 v5, v[1:2] offset:4095 glc
// CHECK: [0xff,0x0f,0x91,0xdc,0x01,0x00,0x00,0x05]

flat_load_short_d16 v5, v[1:2] offset:4095 slc
// CHECK: [0xff,0x0f,0x92,0xdc,0x01,0x00,0x00,0x05]

flat_load_short_d16_hi v5, v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x94,0xdc,0x01,0x00,0x00,0x05]

flat_load_short_d16_hi v255, v[1:2] offset:4095
// CHECK: [0xff,0x0f,0x94,0xdc,0x01,0x00,0x00,0xff]

flat_load_short_d16_hi v5, v[254:255] offset:4095
// CHECK: [0xff,0x0f,0x94,0xdc,0xfe,0x00,0x00,0x05]

flat_load_short_d16_hi v5, v[1:2]
// CHECK: [0x00,0x00,0x94,0xdc,0x01,0x00,0x00,0x05]

flat_load_short_d16_hi v5, v[1:2] offset:0
// CHECK: [0x00,0x00,0x94,0xdc,0x01,0x00,0x00,0x05]

flat_load_short_d16_hi v5, v[1:2] offset:7
// CHECK: [0x07,0x00,0x94,0xdc,0x01,0x00,0x00,0x05]

flat_load_short_d16_hi v5, v[1:2] offset:4095 glc
// CHECK: [0xff,0x0f,0x95,0xdc,0x01,0x00,0x00,0x05]

flat_load_short_d16_hi v5, v[1:2] offset:4095 slc
// CHECK: [0xff,0x0f,0x96,0xdc,0x01,0x00,0x00,0x05]

flat_atomic_swap v[1:2], v2 offset:4095
// CHECK: [0xff,0x0f,0x00,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_swap v[254:255], v2 offset:4095
// CHECK: [0xff,0x0f,0x00,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_swap v[1:2], v255 offset:4095
// CHECK: [0xff,0x0f,0x00,0xdd,0x01,0xff,0x00,0x00]

flat_atomic_swap v[1:2], v2
// CHECK: [0x00,0x00,0x00,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_swap v[1:2], v2 offset:0
// CHECK: [0x00,0x00,0x00,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_swap v[1:2], v2 offset:7
// CHECK: [0x07,0x00,0x00,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_swap v0, v[1:2], v2 offset:4095 glc
// CHECK: [0xff,0x0f,0x01,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_swap v[1:2], v2 offset:4095 slc
// CHECK: [0xff,0x0f,0x02,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_cmpswap v[1:2], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0x04,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_cmpswap v[254:255], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0x04,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_cmpswap v[1:2], v[254:255] offset:4095
// CHECK: [0xff,0x0f,0x04,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_cmpswap v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x04,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_cmpswap v[1:2], v[2:3] offset:0
// CHECK: [0x00,0x00,0x04,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_cmpswap v[1:2], v[2:3] offset:7
// CHECK: [0x07,0x00,0x04,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_cmpswap v0, v[1:2], v[2:3] offset:4095 glc
// CHECK: [0xff,0x0f,0x05,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_cmpswap v[1:2], v[2:3] offset:4095 slc
// CHECK: [0xff,0x0f,0x06,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_add v[1:2], v2 offset:4095
// CHECK: [0xff,0x0f,0x08,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_add v[254:255], v2 offset:4095
// CHECK: [0xff,0x0f,0x08,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_add v[1:2], v255 offset:4095
// CHECK: [0xff,0x0f,0x08,0xdd,0x01,0xff,0x00,0x00]

flat_atomic_add v[1:2], v2
// CHECK: [0x00,0x00,0x08,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_add v[1:2], v2 offset:0
// CHECK: [0x00,0x00,0x08,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_add v[1:2], v2 offset:7
// CHECK: [0x07,0x00,0x08,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_add v0, v[1:2], v2 offset:4095 glc
// CHECK: [0xff,0x0f,0x09,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_add v[1:2], v2 offset:4095 slc
// CHECK: [0xff,0x0f,0x0a,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_sub v[1:2], v2 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_sub v[254:255], v2 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_sub v[1:2], v255 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xdd,0x01,0xff,0x00,0x00]

flat_atomic_sub v[1:2], v2
// CHECK: [0x00,0x00,0x0c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_sub v[1:2], v2 offset:0
// CHECK: [0x00,0x00,0x0c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_sub v[1:2], v2 offset:7
// CHECK: [0x07,0x00,0x0c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_sub v0, v[1:2], v2 offset:4095 glc
// CHECK: [0xff,0x0f,0x0d,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_sub v[1:2], v2 offset:4095 slc
// CHECK: [0xff,0x0f,0x0e,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smin v[1:2], v2 offset:4095
// CHECK: [0xff,0x0f,0x10,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smin v[254:255], v2 offset:4095
// CHECK: [0xff,0x0f,0x10,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_smin v[1:2], v255 offset:4095
// CHECK: [0xff,0x0f,0x10,0xdd,0x01,0xff,0x00,0x00]

flat_atomic_smin v[1:2], v2
// CHECK: [0x00,0x00,0x10,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smin v[1:2], v2 offset:0
// CHECK: [0x00,0x00,0x10,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smin v[1:2], v2 offset:7
// CHECK: [0x07,0x00,0x10,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smin v0, v[1:2], v2 offset:4095 glc
// CHECK: [0xff,0x0f,0x11,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smin v[1:2], v2 offset:4095 slc
// CHECK: [0xff,0x0f,0x12,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umin v[1:2], v2 offset:4095
// CHECK: [0xff,0x0f,0x14,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umin v[254:255], v2 offset:4095
// CHECK: [0xff,0x0f,0x14,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_umin v[1:2], v255 offset:4095
// CHECK: [0xff,0x0f,0x14,0xdd,0x01,0xff,0x00,0x00]

flat_atomic_umin v[1:2], v2
// CHECK: [0x00,0x00,0x14,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umin v[1:2], v2 offset:0
// CHECK: [0x00,0x00,0x14,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umin v[1:2], v2 offset:7
// CHECK: [0x07,0x00,0x14,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umin v0, v[1:2], v2 offset:4095 glc
// CHECK: [0xff,0x0f,0x15,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umin v[1:2], v2 offset:4095 slc
// CHECK: [0xff,0x0f,0x16,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smax v[1:2], v2 offset:4095
// CHECK: [0xff,0x0f,0x18,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smax v[254:255], v2 offset:4095
// CHECK: [0xff,0x0f,0x18,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_smax v[1:2], v255 offset:4095
// CHECK: [0xff,0x0f,0x18,0xdd,0x01,0xff,0x00,0x00]

flat_atomic_smax v[1:2], v2
// CHECK: [0x00,0x00,0x18,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smax v[1:2], v2 offset:0
// CHECK: [0x00,0x00,0x18,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smax v[1:2], v2 offset:7
// CHECK: [0x07,0x00,0x18,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smax v0, v[1:2], v2 offset:4095 glc
// CHECK: [0xff,0x0f,0x19,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smax v[1:2], v2 offset:4095 slc
// CHECK: [0xff,0x0f,0x1a,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umax v[1:2], v2 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umax v[254:255], v2 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_umax v[1:2], v255 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xdd,0x01,0xff,0x00,0x00]

flat_atomic_umax v[1:2], v2
// CHECK: [0x00,0x00,0x1c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umax v[1:2], v2 offset:0
// CHECK: [0x00,0x00,0x1c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umax v[1:2], v2 offset:7
// CHECK: [0x07,0x00,0x1c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umax v0, v[1:2], v2 offset:4095 glc
// CHECK: [0xff,0x0f,0x1d,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umax v[1:2], v2 offset:4095 slc
// CHECK: [0xff,0x0f,0x1e,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_and v[1:2], v2 offset:4095
// CHECK: [0xff,0x0f,0x20,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_and v[254:255], v2 offset:4095
// CHECK: [0xff,0x0f,0x20,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_and v[1:2], v255 offset:4095
// CHECK: [0xff,0x0f,0x20,0xdd,0x01,0xff,0x00,0x00]

flat_atomic_and v[1:2], v2
// CHECK: [0x00,0x00,0x20,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_and v[1:2], v2 offset:0
// CHECK: [0x00,0x00,0x20,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_and v[1:2], v2 offset:7
// CHECK: [0x07,0x00,0x20,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_and v0, v[1:2], v2 offset:4095 glc
// CHECK: [0xff,0x0f,0x21,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_and v[1:2], v2 offset:4095 slc
// CHECK: [0xff,0x0f,0x22,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_or v[1:2], v2 offset:4095
// CHECK: [0xff,0x0f,0x24,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_or v[254:255], v2 offset:4095
// CHECK: [0xff,0x0f,0x24,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_or v[1:2], v255 offset:4095
// CHECK: [0xff,0x0f,0x24,0xdd,0x01,0xff,0x00,0x00]

flat_atomic_or v[1:2], v2
// CHECK: [0x00,0x00,0x24,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_or v[1:2], v2 offset:0
// CHECK: [0x00,0x00,0x24,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_or v[1:2], v2 offset:7
// CHECK: [0x07,0x00,0x24,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_or v0, v[1:2], v2 offset:4095 glc
// CHECK: [0xff,0x0f,0x25,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_or v[1:2], v2 offset:4095 slc
// CHECK: [0xff,0x0f,0x26,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_xor v[1:2], v2 offset:4095
// CHECK: [0xff,0x0f,0x28,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_xor v[254:255], v2 offset:4095
// CHECK: [0xff,0x0f,0x28,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_xor v[1:2], v255 offset:4095
// CHECK: [0xff,0x0f,0x28,0xdd,0x01,0xff,0x00,0x00]

flat_atomic_xor v[1:2], v2
// CHECK: [0x00,0x00,0x28,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_xor v[1:2], v2 offset:0
// CHECK: [0x00,0x00,0x28,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_xor v[1:2], v2 offset:7
// CHECK: [0x07,0x00,0x28,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_xor v0, v[1:2], v2 offset:4095 glc
// CHECK: [0xff,0x0f,0x29,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_xor v[1:2], v2 offset:4095 slc
// CHECK: [0xff,0x0f,0x2a,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_inc v[1:2], v2 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_inc v[254:255], v2 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_inc v[1:2], v255 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xdd,0x01,0xff,0x00,0x00]

flat_atomic_inc v[1:2], v2
// CHECK: [0x00,0x00,0x2c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_inc v[1:2], v2 offset:0
// CHECK: [0x00,0x00,0x2c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_inc v[1:2], v2 offset:7
// CHECK: [0x07,0x00,0x2c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_inc v0, v[1:2], v2 offset:4095 glc
// CHECK: [0xff,0x0f,0x2d,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_inc v[1:2], v2 offset:4095 slc
// CHECK: [0xff,0x0f,0x2e,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_dec v[1:2], v2 offset:4095
// CHECK: [0xff,0x0f,0x30,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_dec v[254:255], v2 offset:4095
// CHECK: [0xff,0x0f,0x30,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_dec v[1:2], v255 offset:4095
// CHECK: [0xff,0x0f,0x30,0xdd,0x01,0xff,0x00,0x00]

flat_atomic_dec v[1:2], v2
// CHECK: [0x00,0x00,0x30,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_dec v[1:2], v2 offset:0
// CHECK: [0x00,0x00,0x30,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_dec v[1:2], v2 offset:7
// CHECK: [0x07,0x00,0x30,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_dec v0, v[1:2], v2 offset:4095 glc
// CHECK: [0xff,0x0f,0x31,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_dec v[1:2], v2 offset:4095 slc
// CHECK: [0xff,0x0f,0x32,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_swap_x2 v[1:2], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0x80,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_swap_x2 v[254:255], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0x80,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_swap_x2 v[1:2], v[254:255] offset:4095
// CHECK: [0xff,0x0f,0x80,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_swap_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x80,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_swap_x2 v[1:2], v[2:3] offset:0
// CHECK: [0x00,0x00,0x80,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_swap_x2 v[1:2], v[2:3] offset:7
// CHECK: [0x07,0x00,0x80,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_swap_x2 v[0:1], v[1:2], v[2:3] offset:4095 glc
// CHECK: [0xff,0x0f,0x81,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_swap_x2 v[1:2], v[2:3] offset:4095 slc
// CHECK: [0xff,0x0f,0x82,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_cmpswap_x2 v[1:2], v[2:5] offset:4095
// CHECK: [0xff,0x0f,0x84,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_cmpswap_x2 v[254:255], v[2:5] offset:4095
// CHECK: [0xff,0x0f,0x84,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_cmpswap_x2 v[1:2], v[252:255] offset:4095
// CHECK: [0xff,0x0f,0x84,0xdd,0x01,0xfc,0x00,0x00]

flat_atomic_cmpswap_x2 v[1:2], v[2:5]
// CHECK: [0x00,0x00,0x84,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_cmpswap_x2 v[1:2], v[2:5] offset:0
// CHECK: [0x00,0x00,0x84,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_cmpswap_x2 v[1:2], v[2:5] offset:7
// CHECK: [0x07,0x00,0x84,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_cmpswap_x2 v[0:1], v[1:2], v[2:5] offset:4095 glc
// CHECK: [0xff,0x0f,0x85,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_cmpswap_x2 v[1:2], v[2:5] offset:4095 slc
// CHECK: [0xff,0x0f,0x86,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_add_x2 v[1:2], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0x88,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_add_x2 v[254:255], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0x88,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_add_x2 v[1:2], v[254:255] offset:4095
// CHECK: [0xff,0x0f,0x88,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_add_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x88,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_add_x2 v[1:2], v[2:3] offset:0
// CHECK: [0x00,0x00,0x88,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_add_x2 v[1:2], v[2:3] offset:7
// CHECK: [0x07,0x00,0x88,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_add_x2 v[0:1], v[1:2], v[2:3] offset:4095 glc
// CHECK: [0xff,0x0f,0x89,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_add_x2 v[1:2], v[2:3] offset:4095 slc
// CHECK: [0xff,0x0f,0x8a,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_sub_x2 v[1:2], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0x8c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_sub_x2 v[254:255], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0x8c,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_sub_x2 v[1:2], v[254:255] offset:4095
// CHECK: [0xff,0x0f,0x8c,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_sub_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x8c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_sub_x2 v[1:2], v[2:3] offset:0
// CHECK: [0x00,0x00,0x8c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_sub_x2 v[1:2], v[2:3] offset:7
// CHECK: [0x07,0x00,0x8c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_sub_x2 v[0:1], v[1:2], v[2:3] offset:4095 glc
// CHECK: [0xff,0x0f,0x8d,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_sub_x2 v[1:2], v[2:3] offset:4095 slc
// CHECK: [0xff,0x0f,0x8e,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smin_x2 v[1:2], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0x90,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smin_x2 v[254:255], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0x90,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_smin_x2 v[1:2], v[254:255] offset:4095
// CHECK: [0xff,0x0f,0x90,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_smin_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x90,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smin_x2 v[1:2], v[2:3] offset:0
// CHECK: [0x00,0x00,0x90,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smin_x2 v[1:2], v[2:3] offset:7
// CHECK: [0x07,0x00,0x90,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smin_x2 v[0:1], v[1:2], v[2:3] offset:4095 glc
// CHECK: [0xff,0x0f,0x91,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smin_x2 v[1:2], v[2:3] offset:4095 slc
// CHECK: [0xff,0x0f,0x92,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umin_x2 v[1:2], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0x94,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umin_x2 v[254:255], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0x94,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_umin_x2 v[1:2], v[254:255] offset:4095
// CHECK: [0xff,0x0f,0x94,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_umin_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x94,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umin_x2 v[1:2], v[2:3] offset:0
// CHECK: [0x00,0x00,0x94,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umin_x2 v[1:2], v[2:3] offset:7
// CHECK: [0x07,0x00,0x94,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umin_x2 v[0:1], v[1:2], v[2:3] offset:4095 glc
// CHECK: [0xff,0x0f,0x95,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umin_x2 v[1:2], v[2:3] offset:4095 slc
// CHECK: [0xff,0x0f,0x96,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smax_x2 v[1:2], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0x98,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smax_x2 v[254:255], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0x98,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_smax_x2 v[1:2], v[254:255] offset:4095
// CHECK: [0xff,0x0f,0x98,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_smax_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x98,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smax_x2 v[1:2], v[2:3] offset:0
// CHECK: [0x00,0x00,0x98,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smax_x2 v[1:2], v[2:3] offset:7
// CHECK: [0x07,0x00,0x98,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smax_x2 v[0:1], v[1:2], v[2:3] offset:4095 glc
// CHECK: [0xff,0x0f,0x99,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smax_x2 v[1:2], v[2:3] offset:4095 slc
// CHECK: [0xff,0x0f,0x9a,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umax_x2 v[1:2], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0x9c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umax_x2 v[254:255], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0x9c,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_umax_x2 v[1:2], v[254:255] offset:4095
// CHECK: [0xff,0x0f,0x9c,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_umax_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x9c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umax_x2 v[1:2], v[2:3] offset:0
// CHECK: [0x00,0x00,0x9c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umax_x2 v[1:2], v[2:3] offset:7
// CHECK: [0x07,0x00,0x9c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umax_x2 v[0:1], v[1:2], v[2:3] offset:4095 glc
// CHECK: [0xff,0x0f,0x9d,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umax_x2 v[1:2], v[2:3] offset:4095 slc
// CHECK: [0xff,0x0f,0x9e,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_and_x2 v[1:2], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0xa0,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_and_x2 v[254:255], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0xa0,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_and_x2 v[1:2], v[254:255] offset:4095
// CHECK: [0xff,0x0f,0xa0,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_and_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0xa0,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_and_x2 v[1:2], v[2:3] offset:0
// CHECK: [0x00,0x00,0xa0,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_and_x2 v[1:2], v[2:3] offset:7
// CHECK: [0x07,0x00,0xa0,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_and_x2 v[0:1], v[1:2], v[2:3] offset:4095 glc
// CHECK: [0xff,0x0f,0xa1,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_and_x2 v[1:2], v[2:3] offset:4095 slc
// CHECK: [0xff,0x0f,0xa2,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_or_x2 v[1:2], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0xa4,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_or_x2 v[254:255], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0xa4,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_or_x2 v[1:2], v[254:255] offset:4095
// CHECK: [0xff,0x0f,0xa4,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_or_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0xa4,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_or_x2 v[1:2], v[2:3] offset:0
// CHECK: [0x00,0x00,0xa4,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_or_x2 v[1:2], v[2:3] offset:7
// CHECK: [0x07,0x00,0xa4,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_or_x2 v[0:1], v[1:2], v[2:3] offset:4095 glc
// CHECK: [0xff,0x0f,0xa5,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_or_x2 v[1:2], v[2:3] offset:4095 slc
// CHECK: [0xff,0x0f,0xa6,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_xor_x2 v[1:2], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0xa8,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_xor_x2 v[254:255], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0xa8,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_xor_x2 v[1:2], v[254:255] offset:4095
// CHECK: [0xff,0x0f,0xa8,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_xor_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0xa8,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_xor_x2 v[1:2], v[2:3] offset:0
// CHECK: [0x00,0x00,0xa8,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_xor_x2 v[1:2], v[2:3] offset:7
// CHECK: [0x07,0x00,0xa8,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_xor_x2 v[0:1], v[1:2], v[2:3] offset:4095 glc
// CHECK: [0xff,0x0f,0xa9,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_xor_x2 v[1:2], v[2:3] offset:4095 slc
// CHECK: [0xff,0x0f,0xaa,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_inc_x2 v[1:2], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0xac,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_inc_x2 v[254:255], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0xac,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_inc_x2 v[1:2], v[254:255] offset:4095
// CHECK: [0xff,0x0f,0xac,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_inc_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0xac,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_inc_x2 v[1:2], v[2:3] offset:0
// CHECK: [0x00,0x00,0xac,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_inc_x2 v[1:2], v[2:3] offset:7
// CHECK: [0x07,0x00,0xac,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_inc_x2 v[0:1], v[1:2], v[2:3] offset:4095 glc
// CHECK: [0xff,0x0f,0xad,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_inc_x2 v[1:2], v[2:3] offset:4095 slc
// CHECK: [0xff,0x0f,0xae,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_dec_x2 v[1:2], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0xb0,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_dec_x2 v[254:255], v[2:3] offset:4095
// CHECK: [0xff,0x0f,0xb0,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_dec_x2 v[1:2], v[254:255] offset:4095
// CHECK: [0xff,0x0f,0xb0,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_dec_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0xb0,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_dec_x2 v[1:2], v[2:3] offset:0
// CHECK: [0x00,0x00,0xb0,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_dec_x2 v[1:2], v[2:3] offset:7
// CHECK: [0x07,0x00,0xb0,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_dec_x2 v[0:1], v[1:2], v[2:3] offset:4095 glc
// CHECK: [0xff,0x0f,0xb1,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_dec_x2 v[1:2], v[2:3] offset:4095 slc
// CHECK: [0xff,0x0f,0xb2,0xdd,0x01,0x02,0x00,0x00]

global_load_ubyte v5, v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x40,0xdc,0x01,0x00,0x04,0x05]

global_load_ubyte v255, v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x40,0xdc,0x01,0x00,0x04,0xff]

global_load_ubyte v5, v255, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x40,0xdc,0xff,0x00,0x04,0x05]

global_load_ubyte v5, v1, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x40,0xdc,0x01,0x00,0x06,0x05]

global_load_ubyte v5, v1, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x40,0xdc,0x01,0x00,0x64,0x05]

global_load_ubyte v5, v1, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x40,0xdc,0x01,0x00,0x66,0x05]

global_load_ubyte v5, v1, vcc offset:-1
// CHECK: [0xff,0x9f,0x40,0xdc,0x01,0x00,0x6a,0x05]

global_load_ubyte v5, v1, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x40,0xdc,0x01,0x00,0x7a,0x05]

global_load_ubyte v5, v[1:2], off offset:-1
// CHECK: [0xff,0x9f,0x40,0xdc,0x01,0x00,0x7f,0x05]

global_load_ubyte v5, v1, s[4:5]
// CHECK: [0x00,0x80,0x40,0xdc,0x01,0x00,0x04,0x05]

global_load_ubyte v5, v1, s[4:5] offset:0
// CHECK: [0x00,0x80,0x40,0xdc,0x01,0x00,0x04,0x05]

global_load_ubyte v5, v1, s[4:5] offset:4095
// CHECK: [0xff,0x8f,0x40,0xdc,0x01,0x00,0x04,0x05]

global_load_ubyte v5, v1, s[4:5] offset:-4096
// CHECK: [0x00,0x90,0x40,0xdc,0x01,0x00,0x04,0x05]

global_load_ubyte v5, v1, s[4:5] offset:-1 glc
// CHECK: [0xff,0x9f,0x41,0xdc,0x01,0x00,0x04,0x05]

global_load_ubyte v5, v1, s[4:5] offset:-1 slc
// CHECK: [0xff,0x9f,0x42,0xdc,0x01,0x00,0x04,0x05]

global_load_sbyte v5, v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x44,0xdc,0x01,0x00,0x04,0x05]

global_load_sbyte v255, v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x44,0xdc,0x01,0x00,0x04,0xff]

global_load_sbyte v5, v255, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x44,0xdc,0xff,0x00,0x04,0x05]

global_load_sbyte v5, v1, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x44,0xdc,0x01,0x00,0x06,0x05]

global_load_sbyte v5, v1, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x44,0xdc,0x01,0x00,0x64,0x05]

global_load_sbyte v5, v1, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x44,0xdc,0x01,0x00,0x66,0x05]

global_load_sbyte v5, v1, vcc offset:-1
// CHECK: [0xff,0x9f,0x44,0xdc,0x01,0x00,0x6a,0x05]

global_load_sbyte v5, v1, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x44,0xdc,0x01,0x00,0x7a,0x05]

global_load_sbyte v5, v[1:2], off offset:-1
// CHECK: [0xff,0x9f,0x44,0xdc,0x01,0x00,0x7f,0x05]

global_load_sbyte v5, v1, s[4:5]
// CHECK: [0x00,0x80,0x44,0xdc,0x01,0x00,0x04,0x05]

global_load_sbyte v5, v1, s[4:5] offset:0
// CHECK: [0x00,0x80,0x44,0xdc,0x01,0x00,0x04,0x05]

global_load_sbyte v5, v1, s[4:5] offset:4095
// CHECK: [0xff,0x8f,0x44,0xdc,0x01,0x00,0x04,0x05]

global_load_sbyte v5, v1, s[4:5] offset:-4096
// CHECK: [0x00,0x90,0x44,0xdc,0x01,0x00,0x04,0x05]

global_load_sbyte v5, v1, s[4:5] offset:-1 glc
// CHECK: [0xff,0x9f,0x45,0xdc,0x01,0x00,0x04,0x05]

global_load_sbyte v5, v1, s[4:5] offset:-1 slc
// CHECK: [0xff,0x9f,0x46,0xdc,0x01,0x00,0x04,0x05]

global_load_ushort v5, v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x48,0xdc,0x01,0x00,0x04,0x05]

global_load_ushort v255, v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x48,0xdc,0x01,0x00,0x04,0xff]

global_load_ushort v5, v255, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x48,0xdc,0xff,0x00,0x04,0x05]

global_load_ushort v5, v1, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x48,0xdc,0x01,0x00,0x06,0x05]

global_load_ushort v5, v1, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x48,0xdc,0x01,0x00,0x64,0x05]

global_load_ushort v5, v1, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x48,0xdc,0x01,0x00,0x66,0x05]

global_load_ushort v5, v1, vcc offset:-1
// CHECK: [0xff,0x9f,0x48,0xdc,0x01,0x00,0x6a,0x05]

global_load_ushort v5, v1, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x48,0xdc,0x01,0x00,0x7a,0x05]

global_load_ushort v5, v[1:2], off offset:-1
// CHECK: [0xff,0x9f,0x48,0xdc,0x01,0x00,0x7f,0x05]

global_load_ushort v5, v1, s[4:5]
// CHECK: [0x00,0x80,0x48,0xdc,0x01,0x00,0x04,0x05]

global_load_ushort v5, v1, s[4:5] offset:0
// CHECK: [0x00,0x80,0x48,0xdc,0x01,0x00,0x04,0x05]

global_load_ushort v5, v1, s[4:5] offset:4095
// CHECK: [0xff,0x8f,0x48,0xdc,0x01,0x00,0x04,0x05]

global_load_ushort v5, v1, s[4:5] offset:-4096
// CHECK: [0x00,0x90,0x48,0xdc,0x01,0x00,0x04,0x05]

global_load_ushort v5, v1, s[4:5] offset:-1 glc
// CHECK: [0xff,0x9f,0x49,0xdc,0x01,0x00,0x04,0x05]

global_load_ushort v5, v1, s[4:5] offset:-1 slc
// CHECK: [0xff,0x9f,0x4a,0xdc,0x01,0x00,0x04,0x05]

global_load_sshort v5, v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x4c,0xdc,0x01,0x00,0x04,0x05]

global_load_sshort v255, v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x4c,0xdc,0x01,0x00,0x04,0xff]

global_load_sshort v5, v255, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x4c,0xdc,0xff,0x00,0x04,0x05]

global_load_sshort v5, v1, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x4c,0xdc,0x01,0x00,0x06,0x05]

global_load_sshort v5, v1, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x4c,0xdc,0x01,0x00,0x64,0x05]

global_load_sshort v5, v1, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x4c,0xdc,0x01,0x00,0x66,0x05]

global_load_sshort v5, v1, vcc offset:-1
// CHECK: [0xff,0x9f,0x4c,0xdc,0x01,0x00,0x6a,0x05]

global_load_sshort v5, v1, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x4c,0xdc,0x01,0x00,0x7a,0x05]

global_load_sshort v5, v[1:2], off offset:-1
// CHECK: [0xff,0x9f,0x4c,0xdc,0x01,0x00,0x7f,0x05]

global_load_sshort v5, v1, s[4:5]
// CHECK: [0x00,0x80,0x4c,0xdc,0x01,0x00,0x04,0x05]

global_load_sshort v5, v1, s[4:5] offset:0
// CHECK: [0x00,0x80,0x4c,0xdc,0x01,0x00,0x04,0x05]

global_load_sshort v5, v1, s[4:5] offset:4095
// CHECK: [0xff,0x8f,0x4c,0xdc,0x01,0x00,0x04,0x05]

global_load_sshort v5, v1, s[4:5] offset:-4096
// CHECK: [0x00,0x90,0x4c,0xdc,0x01,0x00,0x04,0x05]

global_load_sshort v5, v1, s[4:5] offset:-1 glc
// CHECK: [0xff,0x9f,0x4d,0xdc,0x01,0x00,0x04,0x05]

global_load_sshort v5, v1, s[4:5] offset:-1 slc
// CHECK: [0xff,0x9f,0x4e,0xdc,0x01,0x00,0x04,0x05]

global_load_dword v5, v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x50,0xdc,0x01,0x00,0x04,0x05]

global_load_dword v255, v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x50,0xdc,0x01,0x00,0x04,0xff]

global_load_dword v5, v255, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x50,0xdc,0xff,0x00,0x04,0x05]

global_load_dword v5, v1, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x50,0xdc,0x01,0x00,0x06,0x05]

global_load_dword v5, v1, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x50,0xdc,0x01,0x00,0x64,0x05]

global_load_dword v5, v1, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x50,0xdc,0x01,0x00,0x66,0x05]

global_load_dword v5, v1, vcc offset:-1
// CHECK: [0xff,0x9f,0x50,0xdc,0x01,0x00,0x6a,0x05]

global_load_dword v5, v1, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x50,0xdc,0x01,0x00,0x7a,0x05]

global_load_dword v5, v[1:2], off offset:-1
// CHECK: [0xff,0x9f,0x50,0xdc,0x01,0x00,0x7f,0x05]

global_load_dword v5, v1, s[4:5]
// CHECK: [0x00,0x80,0x50,0xdc,0x01,0x00,0x04,0x05]

global_load_dword v5, v1, s[4:5] offset:0
// CHECK: [0x00,0x80,0x50,0xdc,0x01,0x00,0x04,0x05]

global_load_dword v5, v1, s[4:5] offset:4095
// CHECK: [0xff,0x8f,0x50,0xdc,0x01,0x00,0x04,0x05]

global_load_dword v5, v1, s[4:5] offset:-4096
// CHECK: [0x00,0x90,0x50,0xdc,0x01,0x00,0x04,0x05]

global_load_dword v5, v1, s[4:5] offset:-1 glc
// CHECK: [0xff,0x9f,0x51,0xdc,0x01,0x00,0x04,0x05]

global_load_dword v5, v1, s[4:5] offset:-1 slc
// CHECK: [0xff,0x9f,0x52,0xdc,0x01,0x00,0x04,0x05]

global_load_dwordx2 v[5:6], v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x54,0xdc,0x01,0x00,0x04,0x05]

global_load_dwordx2 v[254:255], v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x54,0xdc,0x01,0x00,0x04,0xfe]

global_load_dwordx2 v[5:6], v255, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x54,0xdc,0xff,0x00,0x04,0x05]

global_load_dwordx2 v[5:6], v1, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x54,0xdc,0x01,0x00,0x06,0x05]

global_load_dwordx2 v[5:6], v1, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x54,0xdc,0x01,0x00,0x64,0x05]

global_load_dwordx2 v[5:6], v1, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x54,0xdc,0x01,0x00,0x66,0x05]

global_load_dwordx2 v[5:6], v1, vcc offset:-1
// CHECK: [0xff,0x9f,0x54,0xdc,0x01,0x00,0x6a,0x05]

global_load_dwordx2 v[5:6], v1, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x54,0xdc,0x01,0x00,0x7a,0x05]

global_load_dwordx2 v[5:6], v[1:2], off offset:-1
// CHECK: [0xff,0x9f,0x54,0xdc,0x01,0x00,0x7f,0x05]

global_load_dwordx2 v[5:6], v1, s[4:5]
// CHECK: [0x00,0x80,0x54,0xdc,0x01,0x00,0x04,0x05]

global_load_dwordx2 v[5:6], v1, s[4:5] offset:0
// CHECK: [0x00,0x80,0x54,0xdc,0x01,0x00,0x04,0x05]

global_load_dwordx2 v[5:6], v1, s[4:5] offset:4095
// CHECK: [0xff,0x8f,0x54,0xdc,0x01,0x00,0x04,0x05]

global_load_dwordx2 v[5:6], v1, s[4:5] offset:-4096
// CHECK: [0x00,0x90,0x54,0xdc,0x01,0x00,0x04,0x05]

global_load_dwordx2 v[5:6], v1, s[4:5] offset:-1 glc
// CHECK: [0xff,0x9f,0x55,0xdc,0x01,0x00,0x04,0x05]

global_load_dwordx2 v[5:6], v1, s[4:5] offset:-1 slc
// CHECK: [0xff,0x9f,0x56,0xdc,0x01,0x00,0x04,0x05]

global_load_dwordx3 v[5:7], v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x58,0xdc,0x01,0x00,0x04,0x05]

global_load_dwordx3 v[253:255], v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x58,0xdc,0x01,0x00,0x04,0xfd]

global_load_dwordx3 v[5:7], v255, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x58,0xdc,0xff,0x00,0x04,0x05]

global_load_dwordx3 v[5:7], v1, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x58,0xdc,0x01,0x00,0x06,0x05]

global_load_dwordx3 v[5:7], v1, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x58,0xdc,0x01,0x00,0x64,0x05]

global_load_dwordx3 v[5:7], v1, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x58,0xdc,0x01,0x00,0x66,0x05]

global_load_dwordx3 v[5:7], v1, vcc offset:-1
// CHECK: [0xff,0x9f,0x58,0xdc,0x01,0x00,0x6a,0x05]

global_load_dwordx3 v[5:7], v1, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x58,0xdc,0x01,0x00,0x7a,0x05]

global_load_dwordx3 v[5:7], v[1:2], off offset:-1
// CHECK: [0xff,0x9f,0x58,0xdc,0x01,0x00,0x7f,0x05]

global_load_dwordx3 v[5:7], v1, s[4:5]
// CHECK: [0x00,0x80,0x58,0xdc,0x01,0x00,0x04,0x05]

global_load_dwordx3 v[5:7], v1, s[4:5] offset:0
// CHECK: [0x00,0x80,0x58,0xdc,0x01,0x00,0x04,0x05]

global_load_dwordx3 v[5:7], v1, s[4:5] offset:4095
// CHECK: [0xff,0x8f,0x58,0xdc,0x01,0x00,0x04,0x05]

global_load_dwordx3 v[5:7], v1, s[4:5] offset:-4096
// CHECK: [0x00,0x90,0x58,0xdc,0x01,0x00,0x04,0x05]

global_load_dwordx3 v[5:7], v1, s[4:5] offset:-1 glc
// CHECK: [0xff,0x9f,0x59,0xdc,0x01,0x00,0x04,0x05]

global_load_dwordx3 v[5:7], v1, s[4:5] offset:-1 slc
// CHECK: [0xff,0x9f,0x5a,0xdc,0x01,0x00,0x04,0x05]

global_load_dwordx4 v[5:8], v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x5c,0xdc,0x01,0x00,0x04,0x05]

global_load_dwordx4 v[252:255], v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x5c,0xdc,0x01,0x00,0x04,0xfc]

global_load_dwordx4 v[5:8], v255, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x5c,0xdc,0xff,0x00,0x04,0x05]

global_load_dwordx4 v[5:8], v1, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x5c,0xdc,0x01,0x00,0x06,0x05]

global_load_dwordx4 v[5:8], v1, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x5c,0xdc,0x01,0x00,0x64,0x05]

global_load_dwordx4 v[5:8], v1, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x5c,0xdc,0x01,0x00,0x66,0x05]

global_load_dwordx4 v[5:8], v1, vcc offset:-1
// CHECK: [0xff,0x9f,0x5c,0xdc,0x01,0x00,0x6a,0x05]

global_load_dwordx4 v[5:8], v1, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x5c,0xdc,0x01,0x00,0x7a,0x05]

global_load_dwordx4 v[5:8], v[1:2], off offset:-1
// CHECK: [0xff,0x9f,0x5c,0xdc,0x01,0x00,0x7f,0x05]

global_load_dwordx4 v[5:8], v1, s[4:5]
// CHECK: [0x00,0x80,0x5c,0xdc,0x01,0x00,0x04,0x05]

global_load_dwordx4 v[5:8], v1, s[4:5] offset:0
// CHECK: [0x00,0x80,0x5c,0xdc,0x01,0x00,0x04,0x05]

global_load_dwordx4 v[5:8], v1, s[4:5] offset:4095
// CHECK: [0xff,0x8f,0x5c,0xdc,0x01,0x00,0x04,0x05]

global_load_dwordx4 v[5:8], v1, s[4:5] offset:-4096
// CHECK: [0x00,0x90,0x5c,0xdc,0x01,0x00,0x04,0x05]

global_load_dwordx4 v[5:8], v1, s[4:5] offset:-1 glc
// CHECK: [0xff,0x9f,0x5d,0xdc,0x01,0x00,0x04,0x05]

global_load_dwordx4 v[5:8], v1, s[4:5] offset:-1 slc
// CHECK: [0xff,0x9f,0x5e,0xdc,0x01,0x00,0x04,0x05]

global_store_byte v1, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x60,0xdc,0x01,0x02,0x06,0x00]

global_store_byte v255, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x60,0xdc,0xff,0x02,0x06,0x00]

global_store_byte v1, v255, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x60,0xdc,0x01,0xff,0x06,0x00]

global_store_byte v1, v2, s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x60,0xdc,0x01,0x02,0x08,0x00]

global_store_byte v1, v2, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x60,0xdc,0x01,0x02,0x64,0x00]

global_store_byte v1, v2, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x60,0xdc,0x01,0x02,0x66,0x00]

global_store_byte v1, v2, vcc offset:-1
// CHECK: [0xff,0x9f,0x60,0xdc,0x01,0x02,0x6a,0x00]

global_store_byte v1, v2, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x60,0xdc,0x01,0x02,0x7a,0x00]

global_store_byte v[1:2], v2, off offset:-1
// CHECK: [0xff,0x9f,0x60,0xdc,0x01,0x02,0x7f,0x00]

global_store_byte v1, v2, s[6:7]
// CHECK: [0x00,0x80,0x60,0xdc,0x01,0x02,0x06,0x00]

global_store_byte v1, v2, s[6:7] offset:0
// CHECK: [0x00,0x80,0x60,0xdc,0x01,0x02,0x06,0x00]

global_store_byte v1, v2, s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x60,0xdc,0x01,0x02,0x06,0x00]

global_store_byte v1, v2, s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x60,0xdc,0x01,0x02,0x06,0x00]

global_store_byte v1, v2, s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x61,0xdc,0x01,0x02,0x06,0x00]

global_store_byte v1, v2, s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x62,0xdc,0x01,0x02,0x06,0x00]

global_store_byte_d16_hi v1, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x64,0xdc,0x01,0x02,0x06,0x00]

global_store_byte_d16_hi v255, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x64,0xdc,0xff,0x02,0x06,0x00]

global_store_byte_d16_hi v1, v255, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x64,0xdc,0x01,0xff,0x06,0x00]

global_store_byte_d16_hi v1, v2, s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x64,0xdc,0x01,0x02,0x08,0x00]

global_store_byte_d16_hi v1, v2, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x64,0xdc,0x01,0x02,0x64,0x00]

global_store_byte_d16_hi v1, v2, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x64,0xdc,0x01,0x02,0x66,0x00]

global_store_byte_d16_hi v1, v2, vcc offset:-1
// CHECK: [0xff,0x9f,0x64,0xdc,0x01,0x02,0x6a,0x00]

global_store_byte_d16_hi v1, v2, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x64,0xdc,0x01,0x02,0x7a,0x00]

global_store_byte_d16_hi v[1:2], v2, off offset:-1
// CHECK: [0xff,0x9f,0x64,0xdc,0x01,0x02,0x7f,0x00]

global_store_byte_d16_hi v1, v2, s[6:7]
// CHECK: [0x00,0x80,0x64,0xdc,0x01,0x02,0x06,0x00]

global_store_byte_d16_hi v1, v2, s[6:7] offset:0
// CHECK: [0x00,0x80,0x64,0xdc,0x01,0x02,0x06,0x00]

global_store_byte_d16_hi v1, v2, s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x64,0xdc,0x01,0x02,0x06,0x00]

global_store_byte_d16_hi v1, v2, s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x64,0xdc,0x01,0x02,0x06,0x00]

global_store_byte_d16_hi v1, v2, s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x65,0xdc,0x01,0x02,0x06,0x00]

global_store_byte_d16_hi v1, v2, s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x66,0xdc,0x01,0x02,0x06,0x00]

global_store_short v1, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x68,0xdc,0x01,0x02,0x06,0x00]

global_store_short v255, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x68,0xdc,0xff,0x02,0x06,0x00]

global_store_short v1, v255, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x68,0xdc,0x01,0xff,0x06,0x00]

global_store_short v1, v2, s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x68,0xdc,0x01,0x02,0x08,0x00]

global_store_short v1, v2, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x68,0xdc,0x01,0x02,0x64,0x00]

global_store_short v1, v2, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x68,0xdc,0x01,0x02,0x66,0x00]

global_store_short v1, v2, vcc offset:-1
// CHECK: [0xff,0x9f,0x68,0xdc,0x01,0x02,0x6a,0x00]

global_store_short v1, v2, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x68,0xdc,0x01,0x02,0x7a,0x00]

global_store_short v[1:2], v2, off offset:-1
// CHECK: [0xff,0x9f,0x68,0xdc,0x01,0x02,0x7f,0x00]

global_store_short v1, v2, s[6:7]
// CHECK: [0x00,0x80,0x68,0xdc,0x01,0x02,0x06,0x00]

global_store_short v1, v2, s[6:7] offset:0
// CHECK: [0x00,0x80,0x68,0xdc,0x01,0x02,0x06,0x00]

global_store_short v1, v2, s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x68,0xdc,0x01,0x02,0x06,0x00]

global_store_short v1, v2, s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x68,0xdc,0x01,0x02,0x06,0x00]

global_store_short v1, v2, s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x69,0xdc,0x01,0x02,0x06,0x00]

global_store_short v1, v2, s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x6a,0xdc,0x01,0x02,0x06,0x00]

global_store_short_d16_hi v1, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x6c,0xdc,0x01,0x02,0x06,0x00]

global_store_short_d16_hi v255, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x6c,0xdc,0xff,0x02,0x06,0x00]

global_store_short_d16_hi v1, v255, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x6c,0xdc,0x01,0xff,0x06,0x00]

global_store_short_d16_hi v1, v2, s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x6c,0xdc,0x01,0x02,0x08,0x00]

global_store_short_d16_hi v1, v2, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x6c,0xdc,0x01,0x02,0x64,0x00]

global_store_short_d16_hi v1, v2, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x6c,0xdc,0x01,0x02,0x66,0x00]

global_store_short_d16_hi v1, v2, vcc offset:-1
// CHECK: [0xff,0x9f,0x6c,0xdc,0x01,0x02,0x6a,0x00]

global_store_short_d16_hi v1, v2, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x6c,0xdc,0x01,0x02,0x7a,0x00]

global_store_short_d16_hi v[1:2], v2, off offset:-1
// CHECK: [0xff,0x9f,0x6c,0xdc,0x01,0x02,0x7f,0x00]

global_store_short_d16_hi v1, v2, s[6:7]
// CHECK: [0x00,0x80,0x6c,0xdc,0x01,0x02,0x06,0x00]

global_store_short_d16_hi v1, v2, s[6:7] offset:0
// CHECK: [0x00,0x80,0x6c,0xdc,0x01,0x02,0x06,0x00]

global_store_short_d16_hi v1, v2, s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x6c,0xdc,0x01,0x02,0x06,0x00]

global_store_short_d16_hi v1, v2, s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x6c,0xdc,0x01,0x02,0x06,0x00]

global_store_short_d16_hi v1, v2, s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x6d,0xdc,0x01,0x02,0x06,0x00]

global_store_short_d16_hi v1, v2, s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x6e,0xdc,0x01,0x02,0x06,0x00]

global_store_dword v1, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x70,0xdc,0x01,0x02,0x06,0x00]

global_store_dword v255, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x70,0xdc,0xff,0x02,0x06,0x00]

global_store_dword v1, v255, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x70,0xdc,0x01,0xff,0x06,0x00]

global_store_dword v1, v2, s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x70,0xdc,0x01,0x02,0x08,0x00]

global_store_dword v1, v2, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x70,0xdc,0x01,0x02,0x64,0x00]

global_store_dword v1, v2, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x70,0xdc,0x01,0x02,0x66,0x00]

global_store_dword v1, v2, vcc offset:-1
// CHECK: [0xff,0x9f,0x70,0xdc,0x01,0x02,0x6a,0x00]

global_store_dword v1, v2, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x70,0xdc,0x01,0x02,0x7a,0x00]

global_store_dword v[1:2], v2, off offset:-1
// CHECK: [0xff,0x9f,0x70,0xdc,0x01,0x02,0x7f,0x00]

global_store_dword v1, v2, s[6:7]
// CHECK: [0x00,0x80,0x70,0xdc,0x01,0x02,0x06,0x00]

global_store_dword v1, v2, s[6:7] offset:0
// CHECK: [0x00,0x80,0x70,0xdc,0x01,0x02,0x06,0x00]

global_store_dword v1, v2, s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x70,0xdc,0x01,0x02,0x06,0x00]

global_store_dword v1, v2, s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x70,0xdc,0x01,0x02,0x06,0x00]

global_store_dword v1, v2, s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x71,0xdc,0x01,0x02,0x06,0x00]

global_store_dword v1, v2, s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x72,0xdc,0x01,0x02,0x06,0x00]

global_store_dwordx2 v1, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x74,0xdc,0x01,0x02,0x06,0x00]

global_store_dwordx2 v255, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x74,0xdc,0xff,0x02,0x06,0x00]

global_store_dwordx2 v1, v[254:255], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x74,0xdc,0x01,0xfe,0x06,0x00]

global_store_dwordx2 v1, v[2:3], s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x74,0xdc,0x01,0x02,0x08,0x00]

global_store_dwordx2 v1, v[2:3], s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x74,0xdc,0x01,0x02,0x64,0x00]

global_store_dwordx2 v1, v[2:3], flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x74,0xdc,0x01,0x02,0x66,0x00]

global_store_dwordx2 v1, v[2:3], vcc offset:-1
// CHECK: [0xff,0x9f,0x74,0xdc,0x01,0x02,0x6a,0x00]

global_store_dwordx2 v1, v[2:3], ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x74,0xdc,0x01,0x02,0x7a,0x00]

global_store_dwordx2 v[1:2], v[2:3], off offset:-1
// CHECK: [0xff,0x9f,0x74,0xdc,0x01,0x02,0x7f,0x00]

global_store_dwordx2 v1, v[2:3], s[6:7]
// CHECK: [0x00,0x80,0x74,0xdc,0x01,0x02,0x06,0x00]

global_store_dwordx2 v1, v[2:3], s[6:7] offset:0
// CHECK: [0x00,0x80,0x74,0xdc,0x01,0x02,0x06,0x00]

global_store_dwordx2 v1, v[2:3], s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x74,0xdc,0x01,0x02,0x06,0x00]

global_store_dwordx2 v1, v[2:3], s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x74,0xdc,0x01,0x02,0x06,0x00]

global_store_dwordx2 v1, v[2:3], s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x75,0xdc,0x01,0x02,0x06,0x00]

global_store_dwordx2 v1, v[2:3], s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x76,0xdc,0x01,0x02,0x06,0x00]

global_store_dwordx3 v1, v[2:4], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x78,0xdc,0x01,0x02,0x06,0x00]

global_store_dwordx3 v255, v[2:4], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x78,0xdc,0xff,0x02,0x06,0x00]

global_store_dwordx3 v1, v[253:255], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x78,0xdc,0x01,0xfd,0x06,0x00]

global_store_dwordx3 v1, v[2:4], s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x78,0xdc,0x01,0x02,0x08,0x00]

global_store_dwordx3 v1, v[2:4], s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x78,0xdc,0x01,0x02,0x64,0x00]

global_store_dwordx3 v1, v[2:4], flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x78,0xdc,0x01,0x02,0x66,0x00]

global_store_dwordx3 v1, v[2:4], vcc offset:-1
// CHECK: [0xff,0x9f,0x78,0xdc,0x01,0x02,0x6a,0x00]

global_store_dwordx3 v1, v[2:4], ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x78,0xdc,0x01,0x02,0x7a,0x00]

global_store_dwordx3 v[1:2], v[2:4], off offset:-1
// CHECK: [0xff,0x9f,0x78,0xdc,0x01,0x02,0x7f,0x00]

global_store_dwordx3 v1, v[2:4], s[6:7]
// CHECK: [0x00,0x80,0x78,0xdc,0x01,0x02,0x06,0x00]

global_store_dwordx3 v1, v[2:4], s[6:7] offset:0
// CHECK: [0x00,0x80,0x78,0xdc,0x01,0x02,0x06,0x00]

global_store_dwordx3 v1, v[2:4], s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x78,0xdc,0x01,0x02,0x06,0x00]

global_store_dwordx3 v1, v[2:4], s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x78,0xdc,0x01,0x02,0x06,0x00]

global_store_dwordx3 v1, v[2:4], s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x79,0xdc,0x01,0x02,0x06,0x00]

global_store_dwordx3 v1, v[2:4], s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x7a,0xdc,0x01,0x02,0x06,0x00]

global_store_dwordx4 v1, v[2:5], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x7c,0xdc,0x01,0x02,0x06,0x00]

global_store_dwordx4 v255, v[2:5], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x7c,0xdc,0xff,0x02,0x06,0x00]

global_store_dwordx4 v1, v[252:255], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x7c,0xdc,0x01,0xfc,0x06,0x00]

global_store_dwordx4 v1, v[2:5], s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x7c,0xdc,0x01,0x02,0x08,0x00]

global_store_dwordx4 v1, v[2:5], s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x7c,0xdc,0x01,0x02,0x64,0x00]

global_store_dwordx4 v1, v[2:5], flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x7c,0xdc,0x01,0x02,0x66,0x00]

global_store_dwordx4 v1, v[2:5], vcc offset:-1
// CHECK: [0xff,0x9f,0x7c,0xdc,0x01,0x02,0x6a,0x00]

global_store_dwordx4 v1, v[2:5], ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x7c,0xdc,0x01,0x02,0x7a,0x00]

global_store_dwordx4 v[1:2], v[2:5], off offset:-1
// CHECK: [0xff,0x9f,0x7c,0xdc,0x01,0x02,0x7f,0x00]

global_store_dwordx4 v1, v[2:5], s[6:7]
// CHECK: [0x00,0x80,0x7c,0xdc,0x01,0x02,0x06,0x00]

global_store_dwordx4 v1, v[2:5], s[6:7] offset:0
// CHECK: [0x00,0x80,0x7c,0xdc,0x01,0x02,0x06,0x00]

global_store_dwordx4 v1, v[2:5], s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x7c,0xdc,0x01,0x02,0x06,0x00]

global_store_dwordx4 v1, v[2:5], s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x7c,0xdc,0x01,0x02,0x06,0x00]

global_store_dwordx4 v1, v[2:5], s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x7d,0xdc,0x01,0x02,0x06,0x00]

global_store_dwordx4 v1, v[2:5], s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x7e,0xdc,0x01,0x02,0x06,0x00]

global_load_ubyte_d16 v5, v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x80,0xdc,0x01,0x00,0x04,0x05]

global_load_ubyte_d16 v255, v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x80,0xdc,0x01,0x00,0x04,0xff]

global_load_ubyte_d16 v5, v255, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x80,0xdc,0xff,0x00,0x04,0x05]

global_load_ubyte_d16 v5, v1, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x80,0xdc,0x01,0x00,0x06,0x05]

global_load_ubyte_d16 v5, v1, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x80,0xdc,0x01,0x00,0x64,0x05]

global_load_ubyte_d16 v5, v1, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x80,0xdc,0x01,0x00,0x66,0x05]

global_load_ubyte_d16 v5, v1, vcc offset:-1
// CHECK: [0xff,0x9f,0x80,0xdc,0x01,0x00,0x6a,0x05]

global_load_ubyte_d16 v5, v1, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x80,0xdc,0x01,0x00,0x7a,0x05]

global_load_ubyte_d16 v5, v[1:2], off offset:-1
// CHECK: [0xff,0x9f,0x80,0xdc,0x01,0x00,0x7f,0x05]

global_load_ubyte_d16 v5, v1, s[4:5]
// CHECK: [0x00,0x80,0x80,0xdc,0x01,0x00,0x04,0x05]

global_load_ubyte_d16 v5, v1, s[4:5] offset:0
// CHECK: [0x00,0x80,0x80,0xdc,0x01,0x00,0x04,0x05]

global_load_ubyte_d16 v5, v1, s[4:5] offset:4095
// CHECK: [0xff,0x8f,0x80,0xdc,0x01,0x00,0x04,0x05]

global_load_ubyte_d16 v5, v1, s[4:5] offset:-4096
// CHECK: [0x00,0x90,0x80,0xdc,0x01,0x00,0x04,0x05]

global_load_ubyte_d16 v5, v1, s[4:5] offset:-1 glc
// CHECK: [0xff,0x9f,0x81,0xdc,0x01,0x00,0x04,0x05]

global_load_ubyte_d16 v5, v1, s[4:5] offset:-1 slc
// CHECK: [0xff,0x9f,0x82,0xdc,0x01,0x00,0x04,0x05]

global_load_ubyte_d16_hi v5, v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x84,0xdc,0x01,0x00,0x04,0x05]

global_load_ubyte_d16_hi v255, v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x84,0xdc,0x01,0x00,0x04,0xff]

global_load_ubyte_d16_hi v5, v255, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x84,0xdc,0xff,0x00,0x04,0x05]

global_load_ubyte_d16_hi v5, v1, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x84,0xdc,0x01,0x00,0x06,0x05]

global_load_ubyte_d16_hi v5, v1, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x84,0xdc,0x01,0x00,0x64,0x05]

global_load_ubyte_d16_hi v5, v1, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x84,0xdc,0x01,0x00,0x66,0x05]

global_load_ubyte_d16_hi v5, v1, vcc offset:-1
// CHECK: [0xff,0x9f,0x84,0xdc,0x01,0x00,0x6a,0x05]

global_load_ubyte_d16_hi v5, v1, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x84,0xdc,0x01,0x00,0x7a,0x05]

global_load_ubyte_d16_hi v5, v[1:2], off offset:-1
// CHECK: [0xff,0x9f,0x84,0xdc,0x01,0x00,0x7f,0x05]

global_load_ubyte_d16_hi v5, v1, s[4:5]
// CHECK: [0x00,0x80,0x84,0xdc,0x01,0x00,0x04,0x05]

global_load_ubyte_d16_hi v5, v1, s[4:5] offset:0
// CHECK: [0x00,0x80,0x84,0xdc,0x01,0x00,0x04,0x05]

global_load_ubyte_d16_hi v5, v1, s[4:5] offset:4095
// CHECK: [0xff,0x8f,0x84,0xdc,0x01,0x00,0x04,0x05]

global_load_ubyte_d16_hi v5, v1, s[4:5] offset:-4096
// CHECK: [0x00,0x90,0x84,0xdc,0x01,0x00,0x04,0x05]

global_load_ubyte_d16_hi v5, v1, s[4:5] offset:-1 glc
// CHECK: [0xff,0x9f,0x85,0xdc,0x01,0x00,0x04,0x05]

global_load_ubyte_d16_hi v5, v1, s[4:5] offset:-1 slc
// CHECK: [0xff,0x9f,0x86,0xdc,0x01,0x00,0x04,0x05]

global_load_sbyte_d16 v5, v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x88,0xdc,0x01,0x00,0x04,0x05]

global_load_sbyte_d16 v255, v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x88,0xdc,0x01,0x00,0x04,0xff]

global_load_sbyte_d16 v5, v255, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x88,0xdc,0xff,0x00,0x04,0x05]

global_load_sbyte_d16 v5, v1, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x88,0xdc,0x01,0x00,0x06,0x05]

global_load_sbyte_d16 v5, v1, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x88,0xdc,0x01,0x00,0x64,0x05]

global_load_sbyte_d16 v5, v1, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x88,0xdc,0x01,0x00,0x66,0x05]

global_load_sbyte_d16 v5, v1, vcc offset:-1
// CHECK: [0xff,0x9f,0x88,0xdc,0x01,0x00,0x6a,0x05]

global_load_sbyte_d16 v5, v1, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x88,0xdc,0x01,0x00,0x7a,0x05]

global_load_sbyte_d16 v5, v[1:2], off offset:-1
// CHECK: [0xff,0x9f,0x88,0xdc,0x01,0x00,0x7f,0x05]

global_load_sbyte_d16 v5, v1, s[4:5]
// CHECK: [0x00,0x80,0x88,0xdc,0x01,0x00,0x04,0x05]

global_load_sbyte_d16 v5, v1, s[4:5] offset:0
// CHECK: [0x00,0x80,0x88,0xdc,0x01,0x00,0x04,0x05]

global_load_sbyte_d16 v5, v1, s[4:5] offset:4095
// CHECK: [0xff,0x8f,0x88,0xdc,0x01,0x00,0x04,0x05]

global_load_sbyte_d16 v5, v1, s[4:5] offset:-4096
// CHECK: [0x00,0x90,0x88,0xdc,0x01,0x00,0x04,0x05]

global_load_sbyte_d16 v5, v1, s[4:5] offset:-1 glc
// CHECK: [0xff,0x9f,0x89,0xdc,0x01,0x00,0x04,0x05]

global_load_sbyte_d16 v5, v1, s[4:5] offset:-1 slc
// CHECK: [0xff,0x9f,0x8a,0xdc,0x01,0x00,0x04,0x05]

global_load_sbyte_d16_hi v5, v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x8c,0xdc,0x01,0x00,0x04,0x05]

global_load_sbyte_d16_hi v255, v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x8c,0xdc,0x01,0x00,0x04,0xff]

global_load_sbyte_d16_hi v5, v255, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x8c,0xdc,0xff,0x00,0x04,0x05]

global_load_sbyte_d16_hi v5, v1, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x8c,0xdc,0x01,0x00,0x06,0x05]

global_load_sbyte_d16_hi v5, v1, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x8c,0xdc,0x01,0x00,0x64,0x05]

global_load_sbyte_d16_hi v5, v1, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x8c,0xdc,0x01,0x00,0x66,0x05]

global_load_sbyte_d16_hi v5, v1, vcc offset:-1
// CHECK: [0xff,0x9f,0x8c,0xdc,0x01,0x00,0x6a,0x05]

global_load_sbyte_d16_hi v5, v1, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x8c,0xdc,0x01,0x00,0x7a,0x05]

global_load_sbyte_d16_hi v5, v[1:2], off offset:-1
// CHECK: [0xff,0x9f,0x8c,0xdc,0x01,0x00,0x7f,0x05]

global_load_sbyte_d16_hi v5, v1, s[4:5]
// CHECK: [0x00,0x80,0x8c,0xdc,0x01,0x00,0x04,0x05]

global_load_sbyte_d16_hi v5, v1, s[4:5] offset:0
// CHECK: [0x00,0x80,0x8c,0xdc,0x01,0x00,0x04,0x05]

global_load_sbyte_d16_hi v5, v1, s[4:5] offset:4095
// CHECK: [0xff,0x8f,0x8c,0xdc,0x01,0x00,0x04,0x05]

global_load_sbyte_d16_hi v5, v1, s[4:5] offset:-4096
// CHECK: [0x00,0x90,0x8c,0xdc,0x01,0x00,0x04,0x05]

global_load_sbyte_d16_hi v5, v1, s[4:5] offset:-1 glc
// CHECK: [0xff,0x9f,0x8d,0xdc,0x01,0x00,0x04,0x05]

global_load_sbyte_d16_hi v5, v1, s[4:5] offset:-1 slc
// CHECK: [0xff,0x9f,0x8e,0xdc,0x01,0x00,0x04,0x05]

global_load_short_d16 v5, v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x90,0xdc,0x01,0x00,0x04,0x05]

global_load_short_d16 v255, v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x90,0xdc,0x01,0x00,0x04,0xff]

global_load_short_d16 v5, v255, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x90,0xdc,0xff,0x00,0x04,0x05]

global_load_short_d16 v5, v1, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x90,0xdc,0x01,0x00,0x06,0x05]

global_load_short_d16 v5, v1, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x90,0xdc,0x01,0x00,0x64,0x05]

global_load_short_d16 v5, v1, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x90,0xdc,0x01,0x00,0x66,0x05]

global_load_short_d16 v5, v1, vcc offset:-1
// CHECK: [0xff,0x9f,0x90,0xdc,0x01,0x00,0x6a,0x05]

global_load_short_d16 v5, v1, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x90,0xdc,0x01,0x00,0x7a,0x05]

global_load_short_d16 v5, v[1:2], off offset:-1
// CHECK: [0xff,0x9f,0x90,0xdc,0x01,0x00,0x7f,0x05]

global_load_short_d16 v5, v1, s[4:5]
// CHECK: [0x00,0x80,0x90,0xdc,0x01,0x00,0x04,0x05]

global_load_short_d16 v5, v1, s[4:5] offset:0
// CHECK: [0x00,0x80,0x90,0xdc,0x01,0x00,0x04,0x05]

global_load_short_d16 v5, v1, s[4:5] offset:4095
// CHECK: [0xff,0x8f,0x90,0xdc,0x01,0x00,0x04,0x05]

global_load_short_d16 v5, v1, s[4:5] offset:-4096
// CHECK: [0x00,0x90,0x90,0xdc,0x01,0x00,0x04,0x05]

global_load_short_d16 v5, v1, s[4:5] offset:-1 glc
// CHECK: [0xff,0x9f,0x91,0xdc,0x01,0x00,0x04,0x05]

global_load_short_d16 v5, v1, s[4:5] offset:-1 slc
// CHECK: [0xff,0x9f,0x92,0xdc,0x01,0x00,0x04,0x05]

global_load_short_d16_hi v5, v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x94,0xdc,0x01,0x00,0x04,0x05]

global_load_short_d16_hi v255, v1, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x94,0xdc,0x01,0x00,0x04,0xff]

global_load_short_d16_hi v5, v255, s[4:5] offset:-1
// CHECK: [0xff,0x9f,0x94,0xdc,0xff,0x00,0x04,0x05]

global_load_short_d16_hi v5, v1, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x94,0xdc,0x01,0x00,0x06,0x05]

global_load_short_d16_hi v5, v1, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x94,0xdc,0x01,0x00,0x64,0x05]

global_load_short_d16_hi v5, v1, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x94,0xdc,0x01,0x00,0x66,0x05]

global_load_short_d16_hi v5, v1, vcc offset:-1
// CHECK: [0xff,0x9f,0x94,0xdc,0x01,0x00,0x6a,0x05]

global_load_short_d16_hi v5, v1, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x94,0xdc,0x01,0x00,0x7a,0x05]

global_load_short_d16_hi v5, v[1:2], off offset:-1
// CHECK: [0xff,0x9f,0x94,0xdc,0x01,0x00,0x7f,0x05]

global_load_short_d16_hi v5, v1, s[4:5]
// CHECK: [0x00,0x80,0x94,0xdc,0x01,0x00,0x04,0x05]

global_load_short_d16_hi v5, v1, s[4:5] offset:0
// CHECK: [0x00,0x80,0x94,0xdc,0x01,0x00,0x04,0x05]

global_load_short_d16_hi v5, v1, s[4:5] offset:4095
// CHECK: [0xff,0x8f,0x94,0xdc,0x01,0x00,0x04,0x05]

global_load_short_d16_hi v5, v1, s[4:5] offset:-4096
// CHECK: [0x00,0x90,0x94,0xdc,0x01,0x00,0x04,0x05]

global_load_short_d16_hi v5, v1, s[4:5] offset:-1 glc
// CHECK: [0xff,0x9f,0x95,0xdc,0x01,0x00,0x04,0x05]

global_load_short_d16_hi v5, v1, s[4:5] offset:-1 slc
// CHECK: [0xff,0x9f,0x96,0xdc,0x01,0x00,0x04,0x05]

global_atomic_swap v1, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x00,0xdd,0x01,0x02,0x06,0x00]

global_atomic_swap v255, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x00,0xdd,0xff,0x02,0x06,0x00]

global_atomic_swap v1, v255, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x00,0xdd,0x01,0xff,0x06,0x00]

global_atomic_swap v1, v2, s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x00,0xdd,0x01,0x02,0x08,0x00]

global_atomic_swap v1, v2, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x00,0xdd,0x01,0x02,0x64,0x00]

global_atomic_swap v1, v2, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x00,0xdd,0x01,0x02,0x66,0x00]

global_atomic_swap v1, v2, vcc offset:-1
// CHECK: [0xff,0x9f,0x00,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_swap v1, v2, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x00,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_swap v[1:2], v2, off offset:-1
// CHECK: [0xff,0x9f,0x00,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_swap v1, v2, s[6:7]
// CHECK: [0x00,0x80,0x00,0xdd,0x01,0x02,0x06,0x00]

global_atomic_swap v1, v2, s[6:7] offset:0
// CHECK: [0x00,0x80,0x00,0xdd,0x01,0x02,0x06,0x00]

global_atomic_swap v1, v2, s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x00,0xdd,0x01,0x02,0x06,0x00]

global_atomic_swap v1, v2, s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x00,0xdd,0x01,0x02,0x06,0x00]

global_atomic_swap v0, v1, v2, s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x01,0xdd,0x01,0x02,0x06,0x00]

global_atomic_swap v1, v2, s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x02,0xdd,0x01,0x02,0x06,0x00]

global_atomic_cmpswap v1, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x04,0xdd,0x01,0x02,0x06,0x00]

global_atomic_cmpswap v255, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x04,0xdd,0xff,0x02,0x06,0x00]

global_atomic_cmpswap v1, v[254:255], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x04,0xdd,0x01,0xfe,0x06,0x00]

global_atomic_cmpswap v1, v[2:3], s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x04,0xdd,0x01,0x02,0x08,0x00]

global_atomic_cmpswap v1, v[2:3], s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x04,0xdd,0x01,0x02,0x64,0x00]

global_atomic_cmpswap v1, v[2:3], flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x04,0xdd,0x01,0x02,0x66,0x00]

global_atomic_cmpswap v1, v[2:3], vcc offset:-1
// CHECK: [0xff,0x9f,0x04,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_cmpswap v1, v[2:3], ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x04,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_cmpswap v[1:2], v[2:3], off offset:-1
// CHECK: [0xff,0x9f,0x04,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_cmpswap v1, v[2:3], s[6:7]
// CHECK: [0x00,0x80,0x04,0xdd,0x01,0x02,0x06,0x00]

global_atomic_cmpswap v1, v[2:3], s[6:7] offset:0
// CHECK: [0x00,0x80,0x04,0xdd,0x01,0x02,0x06,0x00]

global_atomic_cmpswap v1, v[2:3], s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x04,0xdd,0x01,0x02,0x06,0x00]

global_atomic_cmpswap v1, v[2:3], s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x04,0xdd,0x01,0x02,0x06,0x00]

global_atomic_cmpswap v0, v1, v[2:3], s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x05,0xdd,0x01,0x02,0x06,0x00]

global_atomic_cmpswap v1, v[2:3], s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x06,0xdd,0x01,0x02,0x06,0x00]

global_atomic_add v1, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x08,0xdd,0x01,0x02,0x06,0x00]

global_atomic_add v255, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x08,0xdd,0xff,0x02,0x06,0x00]

global_atomic_add v1, v255, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x08,0xdd,0x01,0xff,0x06,0x00]

global_atomic_add v1, v2, s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x08,0xdd,0x01,0x02,0x08,0x00]

global_atomic_add v1, v2, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x08,0xdd,0x01,0x02,0x64,0x00]

global_atomic_add v1, v2, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x08,0xdd,0x01,0x02,0x66,0x00]

global_atomic_add v1, v2, vcc offset:-1
// CHECK: [0xff,0x9f,0x08,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_add v1, v2, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x08,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_add v[1:2], v2, off offset:-1
// CHECK: [0xff,0x9f,0x08,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_add v1, v2, s[6:7]
// CHECK: [0x00,0x80,0x08,0xdd,0x01,0x02,0x06,0x00]

global_atomic_add v1, v2, s[6:7] offset:0
// CHECK: [0x00,0x80,0x08,0xdd,0x01,0x02,0x06,0x00]

global_atomic_add v1, v2, s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x08,0xdd,0x01,0x02,0x06,0x00]

global_atomic_add v1, v2, s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x08,0xdd,0x01,0x02,0x06,0x00]

global_atomic_add v0, v1, v2, s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x09,0xdd,0x01,0x02,0x06,0x00]

global_atomic_add v1, v2, s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x0a,0xdd,0x01,0x02,0x06,0x00]

global_atomic_sub v1, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x0c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_sub v255, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x0c,0xdd,0xff,0x02,0x06,0x00]

global_atomic_sub v1, v255, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x0c,0xdd,0x01,0xff,0x06,0x00]

global_atomic_sub v1, v2, s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x0c,0xdd,0x01,0x02,0x08,0x00]

global_atomic_sub v1, v2, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x0c,0xdd,0x01,0x02,0x64,0x00]

global_atomic_sub v1, v2, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x0c,0xdd,0x01,0x02,0x66,0x00]

global_atomic_sub v1, v2, vcc offset:-1
// CHECK: [0xff,0x9f,0x0c,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_sub v1, v2, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x0c,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_sub v[1:2], v2, off offset:-1
// CHECK: [0xff,0x9f,0x0c,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_sub v1, v2, s[6:7]
// CHECK: [0x00,0x80,0x0c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_sub v1, v2, s[6:7] offset:0
// CHECK: [0x00,0x80,0x0c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_sub v1, v2, s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x0c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_sub v1, v2, s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x0c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_sub v0, v1, v2, s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x0d,0xdd,0x01,0x02,0x06,0x00]

global_atomic_sub v1, v2, s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x0e,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smin v1, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x10,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smin v255, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x10,0xdd,0xff,0x02,0x06,0x00]

global_atomic_smin v1, v255, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x10,0xdd,0x01,0xff,0x06,0x00]

global_atomic_smin v1, v2, s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x10,0xdd,0x01,0x02,0x08,0x00]

global_atomic_smin v1, v2, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x10,0xdd,0x01,0x02,0x64,0x00]

global_atomic_smin v1, v2, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x10,0xdd,0x01,0x02,0x66,0x00]

global_atomic_smin v1, v2, vcc offset:-1
// CHECK: [0xff,0x9f,0x10,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_smin v1, v2, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x10,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_smin v[1:2], v2, off offset:-1
// CHECK: [0xff,0x9f,0x10,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_smin v1, v2, s[6:7]
// CHECK: [0x00,0x80,0x10,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smin v1, v2, s[6:7] offset:0
// CHECK: [0x00,0x80,0x10,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smin v1, v2, s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x10,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smin v1, v2, s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x10,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smin v0, v1, v2, s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x11,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smin v1, v2, s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x12,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umin v1, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x14,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umin v255, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x14,0xdd,0xff,0x02,0x06,0x00]

global_atomic_umin v1, v255, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x14,0xdd,0x01,0xff,0x06,0x00]

global_atomic_umin v1, v2, s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x14,0xdd,0x01,0x02,0x08,0x00]

global_atomic_umin v1, v2, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x14,0xdd,0x01,0x02,0x64,0x00]

global_atomic_umin v1, v2, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x14,0xdd,0x01,0x02,0x66,0x00]

global_atomic_umin v1, v2, vcc offset:-1
// CHECK: [0xff,0x9f,0x14,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_umin v1, v2, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x14,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_umin v[1:2], v2, off offset:-1
// CHECK: [0xff,0x9f,0x14,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_umin v1, v2, s[6:7]
// CHECK: [0x00,0x80,0x14,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umin v1, v2, s[6:7] offset:0
// CHECK: [0x00,0x80,0x14,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umin v1, v2, s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x14,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umin v1, v2, s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x14,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umin v0, v1, v2, s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x15,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umin v1, v2, s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x16,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smax v1, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x18,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smax v255, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x18,0xdd,0xff,0x02,0x06,0x00]

global_atomic_smax v1, v255, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x18,0xdd,0x01,0xff,0x06,0x00]

global_atomic_smax v1, v2, s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x18,0xdd,0x01,0x02,0x08,0x00]

global_atomic_smax v1, v2, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x18,0xdd,0x01,0x02,0x64,0x00]

global_atomic_smax v1, v2, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x18,0xdd,0x01,0x02,0x66,0x00]

global_atomic_smax v1, v2, vcc offset:-1
// CHECK: [0xff,0x9f,0x18,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_smax v1, v2, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x18,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_smax v[1:2], v2, off offset:-1
// CHECK: [0xff,0x9f,0x18,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_smax v1, v2, s[6:7]
// CHECK: [0x00,0x80,0x18,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smax v1, v2, s[6:7] offset:0
// CHECK: [0x00,0x80,0x18,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smax v1, v2, s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x18,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smax v1, v2, s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x18,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smax v0, v1, v2, s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x19,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smax v1, v2, s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x1a,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umax v1, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x1c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umax v255, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x1c,0xdd,0xff,0x02,0x06,0x00]

global_atomic_umax v1, v255, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x1c,0xdd,0x01,0xff,0x06,0x00]

global_atomic_umax v1, v2, s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x1c,0xdd,0x01,0x02,0x08,0x00]

global_atomic_umax v1, v2, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x1c,0xdd,0x01,0x02,0x64,0x00]

global_atomic_umax v1, v2, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x1c,0xdd,0x01,0x02,0x66,0x00]

global_atomic_umax v1, v2, vcc offset:-1
// CHECK: [0xff,0x9f,0x1c,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_umax v1, v2, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x1c,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_umax v[1:2], v2, off offset:-1
// CHECK: [0xff,0x9f,0x1c,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_umax v1, v2, s[6:7]
// CHECK: [0x00,0x80,0x1c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umax v1, v2, s[6:7] offset:0
// CHECK: [0x00,0x80,0x1c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umax v1, v2, s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x1c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umax v1, v2, s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x1c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umax v0, v1, v2, s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x1d,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umax v1, v2, s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x1e,0xdd,0x01,0x02,0x06,0x00]

global_atomic_and v1, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x20,0xdd,0x01,0x02,0x06,0x00]

global_atomic_and v255, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x20,0xdd,0xff,0x02,0x06,0x00]

global_atomic_and v1, v255, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x20,0xdd,0x01,0xff,0x06,0x00]

global_atomic_and v1, v2, s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x20,0xdd,0x01,0x02,0x08,0x00]

global_atomic_and v1, v2, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x20,0xdd,0x01,0x02,0x64,0x00]

global_atomic_and v1, v2, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x20,0xdd,0x01,0x02,0x66,0x00]

global_atomic_and v1, v2, vcc offset:-1
// CHECK: [0xff,0x9f,0x20,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_and v1, v2, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x20,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_and v[1:2], v2, off offset:-1
// CHECK: [0xff,0x9f,0x20,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_and v1, v2, s[6:7]
// CHECK: [0x00,0x80,0x20,0xdd,0x01,0x02,0x06,0x00]

global_atomic_and v1, v2, s[6:7] offset:0
// CHECK: [0x00,0x80,0x20,0xdd,0x01,0x02,0x06,0x00]

global_atomic_and v1, v2, s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x20,0xdd,0x01,0x02,0x06,0x00]

global_atomic_and v1, v2, s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x20,0xdd,0x01,0x02,0x06,0x00]

global_atomic_and v0, v1, v2, s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x21,0xdd,0x01,0x02,0x06,0x00]

global_atomic_and v1, v2, s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x22,0xdd,0x01,0x02,0x06,0x00]

global_atomic_or v1, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x24,0xdd,0x01,0x02,0x06,0x00]

global_atomic_or v255, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x24,0xdd,0xff,0x02,0x06,0x00]

global_atomic_or v1, v255, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x24,0xdd,0x01,0xff,0x06,0x00]

global_atomic_or v1, v2, s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x24,0xdd,0x01,0x02,0x08,0x00]

global_atomic_or v1, v2, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x24,0xdd,0x01,0x02,0x64,0x00]

global_atomic_or v1, v2, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x24,0xdd,0x01,0x02,0x66,0x00]

global_atomic_or v1, v2, vcc offset:-1
// CHECK: [0xff,0x9f,0x24,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_or v1, v2, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x24,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_or v[1:2], v2, off offset:-1
// CHECK: [0xff,0x9f,0x24,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_or v1, v2, s[6:7]
// CHECK: [0x00,0x80,0x24,0xdd,0x01,0x02,0x06,0x00]

global_atomic_or v1, v2, s[6:7] offset:0
// CHECK: [0x00,0x80,0x24,0xdd,0x01,0x02,0x06,0x00]

global_atomic_or v1, v2, s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x24,0xdd,0x01,0x02,0x06,0x00]

global_atomic_or v1, v2, s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x24,0xdd,0x01,0x02,0x06,0x00]

global_atomic_or v0, v1, v2, s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x25,0xdd,0x01,0x02,0x06,0x00]

global_atomic_or v1, v2, s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x26,0xdd,0x01,0x02,0x06,0x00]

global_atomic_xor v1, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x28,0xdd,0x01,0x02,0x06,0x00]

global_atomic_xor v255, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x28,0xdd,0xff,0x02,0x06,0x00]

global_atomic_xor v1, v255, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x28,0xdd,0x01,0xff,0x06,0x00]

global_atomic_xor v1, v2, s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x28,0xdd,0x01,0x02,0x08,0x00]

global_atomic_xor v1, v2, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x28,0xdd,0x01,0x02,0x64,0x00]

global_atomic_xor v1, v2, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x28,0xdd,0x01,0x02,0x66,0x00]

global_atomic_xor v1, v2, vcc offset:-1
// CHECK: [0xff,0x9f,0x28,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_xor v1, v2, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x28,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_xor v[1:2], v2, off offset:-1
// CHECK: [0xff,0x9f,0x28,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_xor v1, v2, s[6:7]
// CHECK: [0x00,0x80,0x28,0xdd,0x01,0x02,0x06,0x00]

global_atomic_xor v1, v2, s[6:7] offset:0
// CHECK: [0x00,0x80,0x28,0xdd,0x01,0x02,0x06,0x00]

global_atomic_xor v1, v2, s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x28,0xdd,0x01,0x02,0x06,0x00]

global_atomic_xor v1, v2, s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x28,0xdd,0x01,0x02,0x06,0x00]

global_atomic_xor v0, v1, v2, s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x29,0xdd,0x01,0x02,0x06,0x00]

global_atomic_xor v1, v2, s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x2a,0xdd,0x01,0x02,0x06,0x00]

global_atomic_inc v1, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x2c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_inc v255, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x2c,0xdd,0xff,0x02,0x06,0x00]

global_atomic_inc v1, v255, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x2c,0xdd,0x01,0xff,0x06,0x00]

global_atomic_inc v1, v2, s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x2c,0xdd,0x01,0x02,0x08,0x00]

global_atomic_inc v1, v2, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x2c,0xdd,0x01,0x02,0x64,0x00]

global_atomic_inc v1, v2, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x2c,0xdd,0x01,0x02,0x66,0x00]

global_atomic_inc v1, v2, vcc offset:-1
// CHECK: [0xff,0x9f,0x2c,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_inc v1, v2, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x2c,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_inc v[1:2], v2, off offset:-1
// CHECK: [0xff,0x9f,0x2c,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_inc v1, v2, s[6:7]
// CHECK: [0x00,0x80,0x2c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_inc v1, v2, s[6:7] offset:0
// CHECK: [0x00,0x80,0x2c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_inc v1, v2, s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x2c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_inc v1, v2, s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x2c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_inc v0, v1, v2, s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x2d,0xdd,0x01,0x02,0x06,0x00]

global_atomic_inc v1, v2, s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x2e,0xdd,0x01,0x02,0x06,0x00]

global_atomic_dec v1, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x30,0xdd,0x01,0x02,0x06,0x00]

global_atomic_dec v255, v2, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x30,0xdd,0xff,0x02,0x06,0x00]

global_atomic_dec v1, v255, s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x30,0xdd,0x01,0xff,0x06,0x00]

global_atomic_dec v1, v2, s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x30,0xdd,0x01,0x02,0x08,0x00]

global_atomic_dec v1, v2, s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x30,0xdd,0x01,0x02,0x64,0x00]

global_atomic_dec v1, v2, flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x30,0xdd,0x01,0x02,0x66,0x00]

global_atomic_dec v1, v2, vcc offset:-1
// CHECK: [0xff,0x9f,0x30,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_dec v1, v2, ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x30,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_dec v[1:2], v2, off offset:-1
// CHECK: [0xff,0x9f,0x30,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_dec v1, v2, s[6:7]
// CHECK: [0x00,0x80,0x30,0xdd,0x01,0x02,0x06,0x00]

global_atomic_dec v1, v2, s[6:7] offset:0
// CHECK: [0x00,0x80,0x30,0xdd,0x01,0x02,0x06,0x00]

global_atomic_dec v1, v2, s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x30,0xdd,0x01,0x02,0x06,0x00]

global_atomic_dec v1, v2, s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x30,0xdd,0x01,0x02,0x06,0x00]

global_atomic_dec v0, v1, v2, s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x31,0xdd,0x01,0x02,0x06,0x00]

global_atomic_dec v1, v2, s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x32,0xdd,0x01,0x02,0x06,0x00]

global_atomic_swap_x2 v1, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x80,0xdd,0x01,0x02,0x06,0x00]

global_atomic_swap_x2 v255, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x80,0xdd,0xff,0x02,0x06,0x00]

global_atomic_swap_x2 v1, v[254:255], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x80,0xdd,0x01,0xfe,0x06,0x00]

global_atomic_swap_x2 v1, v[2:3], s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x80,0xdd,0x01,0x02,0x08,0x00]

global_atomic_swap_x2 v1, v[2:3], s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x80,0xdd,0x01,0x02,0x64,0x00]

global_atomic_swap_x2 v1, v[2:3], flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x80,0xdd,0x01,0x02,0x66,0x00]

global_atomic_swap_x2 v1, v[2:3], vcc offset:-1
// CHECK: [0xff,0x9f,0x80,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_swap_x2 v1, v[2:3], ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x80,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_swap_x2 v[1:2], v[2:3], off offset:-1
// CHECK: [0xff,0x9f,0x80,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_swap_x2 v1, v[2:3], s[6:7]
// CHECK: [0x00,0x80,0x80,0xdd,0x01,0x02,0x06,0x00]

global_atomic_swap_x2 v1, v[2:3], s[6:7] offset:0
// CHECK: [0x00,0x80,0x80,0xdd,0x01,0x02,0x06,0x00]

global_atomic_swap_x2 v1, v[2:3], s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x80,0xdd,0x01,0x02,0x06,0x00]

global_atomic_swap_x2 v1, v[2:3], s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x80,0xdd,0x01,0x02,0x06,0x00]

global_atomic_swap_x2 v[0:1], v1, v[2:3], s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x81,0xdd,0x01,0x02,0x06,0x00]

global_atomic_swap_x2 v1, v[2:3], s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x82,0xdd,0x01,0x02,0x06,0x00]

global_atomic_cmpswap_x2 v1, v[2:5], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x84,0xdd,0x01,0x02,0x06,0x00]

global_atomic_cmpswap_x2 v255, v[2:5], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x84,0xdd,0xff,0x02,0x06,0x00]

global_atomic_cmpswap_x2 v1, v[252:255], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x84,0xdd,0x01,0xfc,0x06,0x00]

global_atomic_cmpswap_x2 v1, v[2:5], s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x84,0xdd,0x01,0x02,0x08,0x00]

global_atomic_cmpswap_x2 v1, v[2:5], s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x84,0xdd,0x01,0x02,0x64,0x00]

global_atomic_cmpswap_x2 v1, v[2:5], flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x84,0xdd,0x01,0x02,0x66,0x00]

global_atomic_cmpswap_x2 v1, v[2:5], vcc offset:-1
// CHECK: [0xff,0x9f,0x84,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_cmpswap_x2 v1, v[2:5], ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x84,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_cmpswap_x2 v[1:2], v[2:5], off offset:-1
// CHECK: [0xff,0x9f,0x84,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_cmpswap_x2 v1, v[2:5], s[6:7]
// CHECK: [0x00,0x80,0x84,0xdd,0x01,0x02,0x06,0x00]

global_atomic_cmpswap_x2 v1, v[2:5], s[6:7] offset:0
// CHECK: [0x00,0x80,0x84,0xdd,0x01,0x02,0x06,0x00]

global_atomic_cmpswap_x2 v1, v[2:5], s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x84,0xdd,0x01,0x02,0x06,0x00]

global_atomic_cmpswap_x2 v1, v[2:5], s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x84,0xdd,0x01,0x02,0x06,0x00]

global_atomic_cmpswap_x2 v[0:1], v1, v[2:5], s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x85,0xdd,0x01,0x02,0x06,0x00]

global_atomic_cmpswap_x2 v1, v[2:5], s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x86,0xdd,0x01,0x02,0x06,0x00]

global_atomic_add_x2 v1, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x88,0xdd,0x01,0x02,0x06,0x00]

global_atomic_add_x2 v255, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x88,0xdd,0xff,0x02,0x06,0x00]

global_atomic_add_x2 v1, v[254:255], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x88,0xdd,0x01,0xfe,0x06,0x00]

global_atomic_add_x2 v1, v[2:3], s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x88,0xdd,0x01,0x02,0x08,0x00]

global_atomic_add_x2 v1, v[2:3], s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x88,0xdd,0x01,0x02,0x64,0x00]

global_atomic_add_x2 v1, v[2:3], flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x88,0xdd,0x01,0x02,0x66,0x00]

global_atomic_add_x2 v1, v[2:3], vcc offset:-1
// CHECK: [0xff,0x9f,0x88,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_add_x2 v1, v[2:3], ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x88,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_add_x2 v[1:2], v[2:3], off offset:-1
// CHECK: [0xff,0x9f,0x88,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_add_x2 v1, v[2:3], s[6:7]
// CHECK: [0x00,0x80,0x88,0xdd,0x01,0x02,0x06,0x00]

global_atomic_add_x2 v1, v[2:3], s[6:7] offset:0
// CHECK: [0x00,0x80,0x88,0xdd,0x01,0x02,0x06,0x00]

global_atomic_add_x2 v1, v[2:3], s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x88,0xdd,0x01,0x02,0x06,0x00]

global_atomic_add_x2 v1, v[2:3], s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x88,0xdd,0x01,0x02,0x06,0x00]

global_atomic_add_x2 v[0:1], v1, v[2:3], s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x89,0xdd,0x01,0x02,0x06,0x00]

global_atomic_add_x2 v1, v[2:3], s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x8a,0xdd,0x01,0x02,0x06,0x00]

global_atomic_sub_x2 v1, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x8c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_sub_x2 v255, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x8c,0xdd,0xff,0x02,0x06,0x00]

global_atomic_sub_x2 v1, v[254:255], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x8c,0xdd,0x01,0xfe,0x06,0x00]

global_atomic_sub_x2 v1, v[2:3], s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x8c,0xdd,0x01,0x02,0x08,0x00]

global_atomic_sub_x2 v1, v[2:3], s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x8c,0xdd,0x01,0x02,0x64,0x00]

global_atomic_sub_x2 v1, v[2:3], flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x8c,0xdd,0x01,0x02,0x66,0x00]

global_atomic_sub_x2 v1, v[2:3], vcc offset:-1
// CHECK: [0xff,0x9f,0x8c,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_sub_x2 v1, v[2:3], ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x8c,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_sub_x2 v[1:2], v[2:3], off offset:-1
// CHECK: [0xff,0x9f,0x8c,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_sub_x2 v1, v[2:3], s[6:7]
// CHECK: [0x00,0x80,0x8c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_sub_x2 v1, v[2:3], s[6:7] offset:0
// CHECK: [0x00,0x80,0x8c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_sub_x2 v1, v[2:3], s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x8c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_sub_x2 v1, v[2:3], s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x8c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_sub_x2 v[0:1], v1, v[2:3], s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x8d,0xdd,0x01,0x02,0x06,0x00]

global_atomic_sub_x2 v1, v[2:3], s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x8e,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smin_x2 v1, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x90,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smin_x2 v255, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x90,0xdd,0xff,0x02,0x06,0x00]

global_atomic_smin_x2 v1, v[254:255], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x90,0xdd,0x01,0xfe,0x06,0x00]

global_atomic_smin_x2 v1, v[2:3], s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x90,0xdd,0x01,0x02,0x08,0x00]

global_atomic_smin_x2 v1, v[2:3], s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x90,0xdd,0x01,0x02,0x64,0x00]

global_atomic_smin_x2 v1, v[2:3], flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x90,0xdd,0x01,0x02,0x66,0x00]

global_atomic_smin_x2 v1, v[2:3], vcc offset:-1
// CHECK: [0xff,0x9f,0x90,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_smin_x2 v1, v[2:3], ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x90,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_smin_x2 v[1:2], v[2:3], off offset:-1
// CHECK: [0xff,0x9f,0x90,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_smin_x2 v1, v[2:3], s[6:7]
// CHECK: [0x00,0x80,0x90,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smin_x2 v1, v[2:3], s[6:7] offset:0
// CHECK: [0x00,0x80,0x90,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smin_x2 v1, v[2:3], s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x90,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smin_x2 v1, v[2:3], s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x90,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smin_x2 v[0:1], v1, v[2:3], s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x91,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smin_x2 v1, v[2:3], s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x92,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umin_x2 v1, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x94,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umin_x2 v255, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x94,0xdd,0xff,0x02,0x06,0x00]

global_atomic_umin_x2 v1, v[254:255], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x94,0xdd,0x01,0xfe,0x06,0x00]

global_atomic_umin_x2 v1, v[2:3], s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x94,0xdd,0x01,0x02,0x08,0x00]

global_atomic_umin_x2 v1, v[2:3], s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x94,0xdd,0x01,0x02,0x64,0x00]

global_atomic_umin_x2 v1, v[2:3], flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x94,0xdd,0x01,0x02,0x66,0x00]

global_atomic_umin_x2 v1, v[2:3], vcc offset:-1
// CHECK: [0xff,0x9f,0x94,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_umin_x2 v1, v[2:3], ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x94,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_umin_x2 v[1:2], v[2:3], off offset:-1
// CHECK: [0xff,0x9f,0x94,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_umin_x2 v1, v[2:3], s[6:7]
// CHECK: [0x00,0x80,0x94,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umin_x2 v1, v[2:3], s[6:7] offset:0
// CHECK: [0x00,0x80,0x94,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umin_x2 v1, v[2:3], s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x94,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umin_x2 v1, v[2:3], s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x94,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umin_x2 v[0:1], v1, v[2:3], s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x95,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umin_x2 v1, v[2:3], s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x96,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smax_x2 v1, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x98,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smax_x2 v255, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x98,0xdd,0xff,0x02,0x06,0x00]

global_atomic_smax_x2 v1, v[254:255], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x98,0xdd,0x01,0xfe,0x06,0x00]

global_atomic_smax_x2 v1, v[2:3], s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x98,0xdd,0x01,0x02,0x08,0x00]

global_atomic_smax_x2 v1, v[2:3], s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x98,0xdd,0x01,0x02,0x64,0x00]

global_atomic_smax_x2 v1, v[2:3], flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x98,0xdd,0x01,0x02,0x66,0x00]

global_atomic_smax_x2 v1, v[2:3], vcc offset:-1
// CHECK: [0xff,0x9f,0x98,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_smax_x2 v1, v[2:3], ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x98,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_smax_x2 v[1:2], v[2:3], off offset:-1
// CHECK: [0xff,0x9f,0x98,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_smax_x2 v1, v[2:3], s[6:7]
// CHECK: [0x00,0x80,0x98,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smax_x2 v1, v[2:3], s[6:7] offset:0
// CHECK: [0x00,0x80,0x98,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smax_x2 v1, v[2:3], s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x98,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smax_x2 v1, v[2:3], s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x98,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smax_x2 v[0:1], v1, v[2:3], s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x99,0xdd,0x01,0x02,0x06,0x00]

global_atomic_smax_x2 v1, v[2:3], s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x9a,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umax_x2 v1, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x9c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umax_x2 v255, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x9c,0xdd,0xff,0x02,0x06,0x00]

global_atomic_umax_x2 v1, v[254:255], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0x9c,0xdd,0x01,0xfe,0x06,0x00]

global_atomic_umax_x2 v1, v[2:3], s[8:9] offset:-1
// CHECK: [0xff,0x9f,0x9c,0xdd,0x01,0x02,0x08,0x00]

global_atomic_umax_x2 v1, v[2:3], s[100:101] offset:-1
// CHECK: [0xff,0x9f,0x9c,0xdd,0x01,0x02,0x64,0x00]

global_atomic_umax_x2 v1, v[2:3], flat_scratch offset:-1
// CHECK: [0xff,0x9f,0x9c,0xdd,0x01,0x02,0x66,0x00]

global_atomic_umax_x2 v1, v[2:3], vcc offset:-1
// CHECK: [0xff,0x9f,0x9c,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_umax_x2 v1, v[2:3], ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0x9c,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_umax_x2 v[1:2], v[2:3], off offset:-1
// CHECK: [0xff,0x9f,0x9c,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_umax_x2 v1, v[2:3], s[6:7]
// CHECK: [0x00,0x80,0x9c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umax_x2 v1, v[2:3], s[6:7] offset:0
// CHECK: [0x00,0x80,0x9c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umax_x2 v1, v[2:3], s[6:7] offset:4095
// CHECK: [0xff,0x8f,0x9c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umax_x2 v1, v[2:3], s[6:7] offset:-4096
// CHECK: [0x00,0x90,0x9c,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umax_x2 v[0:1], v1, v[2:3], s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0x9d,0xdd,0x01,0x02,0x06,0x00]

global_atomic_umax_x2 v1, v[2:3], s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0x9e,0xdd,0x01,0x02,0x06,0x00]

global_atomic_and_x2 v1, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0xa0,0xdd,0x01,0x02,0x06,0x00]

global_atomic_and_x2 v255, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0xa0,0xdd,0xff,0x02,0x06,0x00]

global_atomic_and_x2 v1, v[254:255], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0xa0,0xdd,0x01,0xfe,0x06,0x00]

global_atomic_and_x2 v1, v[2:3], s[8:9] offset:-1
// CHECK: [0xff,0x9f,0xa0,0xdd,0x01,0x02,0x08,0x00]

global_atomic_and_x2 v1, v[2:3], s[100:101] offset:-1
// CHECK: [0xff,0x9f,0xa0,0xdd,0x01,0x02,0x64,0x00]

global_atomic_and_x2 v1, v[2:3], flat_scratch offset:-1
// CHECK: [0xff,0x9f,0xa0,0xdd,0x01,0x02,0x66,0x00]

global_atomic_and_x2 v1, v[2:3], vcc offset:-1
// CHECK: [0xff,0x9f,0xa0,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_and_x2 v1, v[2:3], ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0xa0,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_and_x2 v[1:2], v[2:3], off offset:-1
// CHECK: [0xff,0x9f,0xa0,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_and_x2 v1, v[2:3], s[6:7]
// CHECK: [0x00,0x80,0xa0,0xdd,0x01,0x02,0x06,0x00]

global_atomic_and_x2 v1, v[2:3], s[6:7] offset:0
// CHECK: [0x00,0x80,0xa0,0xdd,0x01,0x02,0x06,0x00]

global_atomic_and_x2 v1, v[2:3], s[6:7] offset:4095
// CHECK: [0xff,0x8f,0xa0,0xdd,0x01,0x02,0x06,0x00]

global_atomic_and_x2 v1, v[2:3], s[6:7] offset:-4096
// CHECK: [0x00,0x90,0xa0,0xdd,0x01,0x02,0x06,0x00]

global_atomic_and_x2 v[0:1], v1, v[2:3], s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0xa1,0xdd,0x01,0x02,0x06,0x00]

global_atomic_and_x2 v1, v[2:3], s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0xa2,0xdd,0x01,0x02,0x06,0x00]

global_atomic_or_x2 v1, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0xa4,0xdd,0x01,0x02,0x06,0x00]

global_atomic_or_x2 v255, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0xa4,0xdd,0xff,0x02,0x06,0x00]

global_atomic_or_x2 v1, v[254:255], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0xa4,0xdd,0x01,0xfe,0x06,0x00]

global_atomic_or_x2 v1, v[2:3], s[8:9] offset:-1
// CHECK: [0xff,0x9f,0xa4,0xdd,0x01,0x02,0x08,0x00]

global_atomic_or_x2 v1, v[2:3], s[100:101] offset:-1
// CHECK: [0xff,0x9f,0xa4,0xdd,0x01,0x02,0x64,0x00]

global_atomic_or_x2 v1, v[2:3], flat_scratch offset:-1
// CHECK: [0xff,0x9f,0xa4,0xdd,0x01,0x02,0x66,0x00]

global_atomic_or_x2 v1, v[2:3], vcc offset:-1
// CHECK: [0xff,0x9f,0xa4,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_or_x2 v1, v[2:3], ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0xa4,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_or_x2 v[1:2], v[2:3], off offset:-1
// CHECK: [0xff,0x9f,0xa4,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_or_x2 v1, v[2:3], s[6:7]
// CHECK: [0x00,0x80,0xa4,0xdd,0x01,0x02,0x06,0x00]

global_atomic_or_x2 v1, v[2:3], s[6:7] offset:0
// CHECK: [0x00,0x80,0xa4,0xdd,0x01,0x02,0x06,0x00]

global_atomic_or_x2 v1, v[2:3], s[6:7] offset:4095
// CHECK: [0xff,0x8f,0xa4,0xdd,0x01,0x02,0x06,0x00]

global_atomic_or_x2 v1, v[2:3], s[6:7] offset:-4096
// CHECK: [0x00,0x90,0xa4,0xdd,0x01,0x02,0x06,0x00]

global_atomic_or_x2 v[0:1], v1, v[2:3], s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0xa5,0xdd,0x01,0x02,0x06,0x00]

global_atomic_or_x2 v1, v[2:3], s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0xa6,0xdd,0x01,0x02,0x06,0x00]

global_atomic_xor_x2 v1, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0xa8,0xdd,0x01,0x02,0x06,0x00]

global_atomic_xor_x2 v255, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0xa8,0xdd,0xff,0x02,0x06,0x00]

global_atomic_xor_x2 v1, v[254:255], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0xa8,0xdd,0x01,0xfe,0x06,0x00]

global_atomic_xor_x2 v1, v[2:3], s[8:9] offset:-1
// CHECK: [0xff,0x9f,0xa8,0xdd,0x01,0x02,0x08,0x00]

global_atomic_xor_x2 v1, v[2:3], s[100:101] offset:-1
// CHECK: [0xff,0x9f,0xa8,0xdd,0x01,0x02,0x64,0x00]

global_atomic_xor_x2 v1, v[2:3], flat_scratch offset:-1
// CHECK: [0xff,0x9f,0xa8,0xdd,0x01,0x02,0x66,0x00]

global_atomic_xor_x2 v1, v[2:3], vcc offset:-1
// CHECK: [0xff,0x9f,0xa8,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_xor_x2 v1, v[2:3], ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0xa8,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_xor_x2 v[1:2], v[2:3], off offset:-1
// CHECK: [0xff,0x9f,0xa8,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_xor_x2 v1, v[2:3], s[6:7]
// CHECK: [0x00,0x80,0xa8,0xdd,0x01,0x02,0x06,0x00]

global_atomic_xor_x2 v1, v[2:3], s[6:7] offset:0
// CHECK: [0x00,0x80,0xa8,0xdd,0x01,0x02,0x06,0x00]

global_atomic_xor_x2 v1, v[2:3], s[6:7] offset:4095
// CHECK: [0xff,0x8f,0xa8,0xdd,0x01,0x02,0x06,0x00]

global_atomic_xor_x2 v1, v[2:3], s[6:7] offset:-4096
// CHECK: [0x00,0x90,0xa8,0xdd,0x01,0x02,0x06,0x00]

global_atomic_xor_x2 v[0:1], v1, v[2:3], s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0xa9,0xdd,0x01,0x02,0x06,0x00]

global_atomic_xor_x2 v1, v[2:3], s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0xaa,0xdd,0x01,0x02,0x06,0x00]

global_atomic_inc_x2 v1, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0xac,0xdd,0x01,0x02,0x06,0x00]

global_atomic_inc_x2 v255, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0xac,0xdd,0xff,0x02,0x06,0x00]

global_atomic_inc_x2 v1, v[254:255], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0xac,0xdd,0x01,0xfe,0x06,0x00]

global_atomic_inc_x2 v1, v[2:3], s[8:9] offset:-1
// CHECK: [0xff,0x9f,0xac,0xdd,0x01,0x02,0x08,0x00]

global_atomic_inc_x2 v1, v[2:3], s[100:101] offset:-1
// CHECK: [0xff,0x9f,0xac,0xdd,0x01,0x02,0x64,0x00]

global_atomic_inc_x2 v1, v[2:3], flat_scratch offset:-1
// CHECK: [0xff,0x9f,0xac,0xdd,0x01,0x02,0x66,0x00]

global_atomic_inc_x2 v1, v[2:3], vcc offset:-1
// CHECK: [0xff,0x9f,0xac,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_inc_x2 v1, v[2:3], ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0xac,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_inc_x2 v[1:2], v[2:3], off offset:-1
// CHECK: [0xff,0x9f,0xac,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_inc_x2 v1, v[2:3], s[6:7]
// CHECK: [0x00,0x80,0xac,0xdd,0x01,0x02,0x06,0x00]

global_atomic_inc_x2 v1, v[2:3], s[6:7] offset:0
// CHECK: [0x00,0x80,0xac,0xdd,0x01,0x02,0x06,0x00]

global_atomic_inc_x2 v1, v[2:3], s[6:7] offset:4095
// CHECK: [0xff,0x8f,0xac,0xdd,0x01,0x02,0x06,0x00]

global_atomic_inc_x2 v1, v[2:3], s[6:7] offset:-4096
// CHECK: [0x00,0x90,0xac,0xdd,0x01,0x02,0x06,0x00]

global_atomic_inc_x2 v[0:1], v1, v[2:3], s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0xad,0xdd,0x01,0x02,0x06,0x00]

global_atomic_inc_x2 v1, v[2:3], s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0xae,0xdd,0x01,0x02,0x06,0x00]

global_atomic_dec_x2 v1, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0xb0,0xdd,0x01,0x02,0x06,0x00]

global_atomic_dec_x2 v255, v[2:3], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0xb0,0xdd,0xff,0x02,0x06,0x00]

global_atomic_dec_x2 v1, v[254:255], s[6:7] offset:-1
// CHECK: [0xff,0x9f,0xb0,0xdd,0x01,0xfe,0x06,0x00]

global_atomic_dec_x2 v1, v[2:3], s[8:9] offset:-1
// CHECK: [0xff,0x9f,0xb0,0xdd,0x01,0x02,0x08,0x00]

global_atomic_dec_x2 v1, v[2:3], s[100:101] offset:-1
// CHECK: [0xff,0x9f,0xb0,0xdd,0x01,0x02,0x64,0x00]

global_atomic_dec_x2 v1, v[2:3], flat_scratch offset:-1
// CHECK: [0xff,0x9f,0xb0,0xdd,0x01,0x02,0x66,0x00]

global_atomic_dec_x2 v1, v[2:3], vcc offset:-1
// CHECK: [0xff,0x9f,0xb0,0xdd,0x01,0x02,0x6a,0x00]

global_atomic_dec_x2 v1, v[2:3], ttmp[14:15] offset:-1
// CHECK: [0xff,0x9f,0xb0,0xdd,0x01,0x02,0x7a,0x00]

global_atomic_dec_x2 v[1:2], v[2:3], off offset:-1
// CHECK: [0xff,0x9f,0xb0,0xdd,0x01,0x02,0x7f,0x00]

global_atomic_dec_x2 v1, v[2:3], s[6:7]
// CHECK: [0x00,0x80,0xb0,0xdd,0x01,0x02,0x06,0x00]

global_atomic_dec_x2 v1, v[2:3], s[6:7] offset:0
// CHECK: [0x00,0x80,0xb0,0xdd,0x01,0x02,0x06,0x00]

global_atomic_dec_x2 v1, v[2:3], s[6:7] offset:4095
// CHECK: [0xff,0x8f,0xb0,0xdd,0x01,0x02,0x06,0x00]

global_atomic_dec_x2 v1, v[2:3], s[6:7] offset:-4096
// CHECK: [0x00,0x90,0xb0,0xdd,0x01,0x02,0x06,0x00]

global_atomic_dec_x2 v[0:1], v1, v[2:3], s[6:7] offset:-1 glc
// CHECK: [0xff,0x9f,0xb1,0xdd,0x01,0x02,0x06,0x00]

global_atomic_dec_x2 v1, v[2:3], s[6:7] offset:-1 slc
// CHECK: [0xff,0x9f,0xb2,0xdd,0x01,0x02,0x06,0x00]

scratch_load_ubyte v5, off, s2 offset:-1
// CHECK: [0xff,0x5f,0x40,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ubyte v255, off, s2 offset:-1
// CHECK: [0xff,0x5f,0x40,0xdc,0x00,0x00,0x02,0xff]

scratch_load_ubyte v5, off, s101 offset:-1
// CHECK: [0xff,0x5f,0x40,0xdc,0x00,0x00,0x65,0x05]

scratch_load_ubyte v5, off, flat_scratch_lo offset:-1
// CHECK: [0xff,0x5f,0x40,0xdc,0x00,0x00,0x66,0x05]

scratch_load_ubyte v5, off, flat_scratch_hi offset:-1
// CHECK: [0xff,0x5f,0x40,0xdc,0x00,0x00,0x67,0x05]

scratch_load_ubyte v5, off, vcc_lo offset:-1
// CHECK: [0xff,0x5f,0x40,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_ubyte v5, off, vcc_hi offset:-1
// CHECK: [0xff,0x5f,0x40,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_ubyte v5, off, ttmp15 offset:-1
// CHECK: [0xff,0x5f,0x40,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_ubyte v5, v0, off offset:-1
// CHECK: [0xff,0x5f,0x40,0xdc,0x00,0x00,0x7f,0x05]

scratch_load_ubyte v5, off, s2
// CHECK: [0x00,0x40,0x40,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ubyte v5, off, s2 offset:0
// CHECK: [0x00,0x40,0x40,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ubyte v5, off, s2 offset:4095
// CHECK: [0xff,0x4f,0x40,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ubyte v5, off, s2 offset:-4096
// CHECK: [0x00,0x50,0x40,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ubyte v5, off, s2 offset:-1 glc
// CHECK: [0xff,0x5f,0x41,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ubyte v5, off, s2 offset:-1 slc
// CHECK: [0xff,0x5f,0x42,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sbyte v5, off, s2 offset:-1
// CHECK: [0xff,0x5f,0x44,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sbyte v255, off, s2 offset:-1
// CHECK: [0xff,0x5f,0x44,0xdc,0x00,0x00,0x02,0xff]

scratch_load_sbyte v5, off, s101 offset:-1
// CHECK: [0xff,0x5f,0x44,0xdc,0x00,0x00,0x65,0x05]

scratch_load_sbyte v5, off, flat_scratch_lo offset:-1
// CHECK: [0xff,0x5f,0x44,0xdc,0x00,0x00,0x66,0x05]

scratch_load_sbyte v5, off, flat_scratch_hi offset:-1
// CHECK: [0xff,0x5f,0x44,0xdc,0x00,0x00,0x67,0x05]

scratch_load_sbyte v5, off, vcc_lo offset:-1
// CHECK: [0xff,0x5f,0x44,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_sbyte v5, off, vcc_hi offset:-1
// CHECK: [0xff,0x5f,0x44,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_sbyte v5, off, ttmp15 offset:-1
// CHECK: [0xff,0x5f,0x44,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_sbyte v5, v0, off offset:-1
// CHECK: [0xff,0x5f,0x44,0xdc,0x00,0x00,0x7f,0x05]

scratch_load_sbyte v5, off, s2
// CHECK: [0x00,0x40,0x44,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sbyte v5, off, s2 offset:0
// CHECK: [0x00,0x40,0x44,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sbyte v5, off, s2 offset:4095
// CHECK: [0xff,0x4f,0x44,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sbyte v5, off, s2 offset:-4096
// CHECK: [0x00,0x50,0x44,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sbyte v5, off, s2 offset:-1 glc
// CHECK: [0xff,0x5f,0x45,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sbyte v5, off, s2 offset:-1 slc
// CHECK: [0xff,0x5f,0x46,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ushort v5, off, s2 offset:-1
// CHECK: [0xff,0x5f,0x48,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ushort v255, off, s2 offset:-1
// CHECK: [0xff,0x5f,0x48,0xdc,0x00,0x00,0x02,0xff]

scratch_load_ushort v5, off, s101 offset:-1
// CHECK: [0xff,0x5f,0x48,0xdc,0x00,0x00,0x65,0x05]

scratch_load_ushort v5, off, flat_scratch_lo offset:-1
// CHECK: [0xff,0x5f,0x48,0xdc,0x00,0x00,0x66,0x05]

scratch_load_ushort v5, off, flat_scratch_hi offset:-1
// CHECK: [0xff,0x5f,0x48,0xdc,0x00,0x00,0x67,0x05]

scratch_load_ushort v5, off, vcc_lo offset:-1
// CHECK: [0xff,0x5f,0x48,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_ushort v5, off, vcc_hi offset:-1
// CHECK: [0xff,0x5f,0x48,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_ushort v5, off, ttmp15 offset:-1
// CHECK: [0xff,0x5f,0x48,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_ushort v5, v0, off offset:-1
// CHECK: [0xff,0x5f,0x48,0xdc,0x00,0x00,0x7f,0x05]

scratch_load_ushort v5, off, s2
// CHECK: [0x00,0x40,0x48,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ushort v5, off, s2 offset:0
// CHECK: [0x00,0x40,0x48,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ushort v5, off, s2 offset:4095
// CHECK: [0xff,0x4f,0x48,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ushort v5, off, s2 offset:-4096
// CHECK: [0x00,0x50,0x48,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ushort v5, off, s2 offset:-1 glc
// CHECK: [0xff,0x5f,0x49,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ushort v5, off, s2 offset:-1 slc
// CHECK: [0xff,0x5f,0x4a,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sshort v5, off, s2 offset:-1
// CHECK: [0xff,0x5f,0x4c,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sshort v255, off, s2 offset:-1
// CHECK: [0xff,0x5f,0x4c,0xdc,0x00,0x00,0x02,0xff]

scratch_load_sshort v5, off, s101 offset:-1
// CHECK: [0xff,0x5f,0x4c,0xdc,0x00,0x00,0x65,0x05]

scratch_load_sshort v5, off, flat_scratch_lo offset:-1
// CHECK: [0xff,0x5f,0x4c,0xdc,0x00,0x00,0x66,0x05]

scratch_load_sshort v5, off, flat_scratch_hi offset:-1
// CHECK: [0xff,0x5f,0x4c,0xdc,0x00,0x00,0x67,0x05]

scratch_load_sshort v5, off, vcc_lo offset:-1
// CHECK: [0xff,0x5f,0x4c,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_sshort v5, off, vcc_hi offset:-1
// CHECK: [0xff,0x5f,0x4c,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_sshort v5, off, ttmp15 offset:-1
// CHECK: [0xff,0x5f,0x4c,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_sshort v5, v0, off offset:-1
// CHECK: [0xff,0x5f,0x4c,0xdc,0x00,0x00,0x7f,0x05]

scratch_load_sshort v5, off, s2
// CHECK: [0x00,0x40,0x4c,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sshort v5, off, s2 offset:0
// CHECK: [0x00,0x40,0x4c,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sshort v5, off, s2 offset:4095
// CHECK: [0xff,0x4f,0x4c,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sshort v5, off, s2 offset:-4096
// CHECK: [0x00,0x50,0x4c,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sshort v5, off, s2 offset:-1 glc
// CHECK: [0xff,0x5f,0x4d,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sshort v5, off, s2 offset:-1 slc
// CHECK: [0xff,0x5f,0x4e,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dword v5, off, s2 offset:-1
// CHECK: [0xff,0x5f,0x50,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dword v255, off, s2 offset:-1
// CHECK: [0xff,0x5f,0x50,0xdc,0x00,0x00,0x02,0xff]

scratch_load_dword v5, off, s101 offset:-1
// CHECK: [0xff,0x5f,0x50,0xdc,0x00,0x00,0x65,0x05]

scratch_load_dword v5, off, flat_scratch_lo offset:-1
// CHECK: [0xff,0x5f,0x50,0xdc,0x00,0x00,0x66,0x05]

scratch_load_dword v5, off, flat_scratch_hi offset:-1
// CHECK: [0xff,0x5f,0x50,0xdc,0x00,0x00,0x67,0x05]

scratch_load_dword v5, off, vcc_lo offset:-1
// CHECK: [0xff,0x5f,0x50,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_dword v5, off, vcc_hi offset:-1
// CHECK: [0xff,0x5f,0x50,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_dword v5, off, ttmp15 offset:-1
// CHECK: [0xff,0x5f,0x50,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_dword v5, v0, off offset:-1
// CHECK: [0xff,0x5f,0x50,0xdc,0x00,0x00,0x7f,0x05]

scratch_load_dword v5, off, s2
// CHECK: [0x00,0x40,0x50,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dword v5, off, s2 offset:0
// CHECK: [0x00,0x40,0x50,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dword v5, off, s2 offset:4095
// CHECK: [0xff,0x4f,0x50,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dword v5, off, s2 offset:-4096
// CHECK: [0x00,0x50,0x50,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dword v5, off, s2 offset:-1 glc
// CHECK: [0xff,0x5f,0x51,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dword v5, off, s2 offset:-1 slc
// CHECK: [0xff,0x5f,0x52,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dwordx2 v[5:6], off, s2 offset:-1
// CHECK: [0xff,0x5f,0x54,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dwordx2 v[254:255], off, s2 offset:-1
// CHECK: [0xff,0x5f,0x54,0xdc,0x00,0x00,0x02,0xfe]

scratch_load_dwordx2 v[5:6], off, s101 offset:-1
// CHECK: [0xff,0x5f,0x54,0xdc,0x00,0x00,0x65,0x05]

scratch_load_dwordx2 v[5:6], off, flat_scratch_lo offset:-1
// CHECK: [0xff,0x5f,0x54,0xdc,0x00,0x00,0x66,0x05]

scratch_load_dwordx2 v[5:6], off, flat_scratch_hi offset:-1
// CHECK: [0xff,0x5f,0x54,0xdc,0x00,0x00,0x67,0x05]

scratch_load_dwordx2 v[5:6], off, vcc_lo offset:-1
// CHECK: [0xff,0x5f,0x54,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_dwordx2 v[5:6], off, vcc_hi offset:-1
// CHECK: [0xff,0x5f,0x54,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_dwordx2 v[5:6], off, ttmp15 offset:-1
// CHECK: [0xff,0x5f,0x54,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_dwordx2 v[5:6], v0, off offset:-1
// CHECK: [0xff,0x5f,0x54,0xdc,0x00,0x00,0x7f,0x05]

scratch_load_dwordx2 v[5:6], off, s2
// CHECK: [0x00,0x40,0x54,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dwordx2 v[5:6], off, s2 offset:0
// CHECK: [0x00,0x40,0x54,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dwordx2 v[5:6], off, s2 offset:4095
// CHECK: [0xff,0x4f,0x54,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dwordx2 v[5:6], off, s2 offset:-4096
// CHECK: [0x00,0x50,0x54,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dwordx2 v[5:6], off, s2 offset:-1 glc
// CHECK: [0xff,0x5f,0x55,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dwordx2 v[5:6], off, s2 offset:-1 slc
// CHECK: [0xff,0x5f,0x56,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dwordx3 v[5:7], off, s2 offset:-1
// CHECK: [0xff,0x5f,0x58,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dwordx3 v[253:255], off, s2 offset:-1
// CHECK: [0xff,0x5f,0x58,0xdc,0x00,0x00,0x02,0xfd]

scratch_load_dwordx3 v[5:7], off, s101 offset:-1
// CHECK: [0xff,0x5f,0x58,0xdc,0x00,0x00,0x65,0x05]

scratch_load_dwordx3 v[5:7], off, flat_scratch_lo offset:-1
// CHECK: [0xff,0x5f,0x58,0xdc,0x00,0x00,0x66,0x05]

scratch_load_dwordx3 v[5:7], off, flat_scratch_hi offset:-1
// CHECK: [0xff,0x5f,0x58,0xdc,0x00,0x00,0x67,0x05]

scratch_load_dwordx3 v[5:7], off, vcc_lo offset:-1
// CHECK: [0xff,0x5f,0x58,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_dwordx3 v[5:7], off, vcc_hi offset:-1
// CHECK: [0xff,0x5f,0x58,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_dwordx3 v[5:7], off, ttmp15 offset:-1
// CHECK: [0xff,0x5f,0x58,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_dwordx3 v[5:7], v0, off offset:-1
// CHECK: [0xff,0x5f,0x58,0xdc,0x00,0x00,0x7f,0x05]

scratch_load_dwordx3 v[5:7], off, s2
// CHECK: [0x00,0x40,0x58,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dwordx3 v[5:7], off, s2 offset:0
// CHECK: [0x00,0x40,0x58,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dwordx3 v[5:7], off, s2 offset:4095
// CHECK: [0xff,0x4f,0x58,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dwordx3 v[5:7], off, s2 offset:-4096
// CHECK: [0x00,0x50,0x58,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dwordx3 v[5:7], off, s2 offset:-1 glc
// CHECK: [0xff,0x5f,0x59,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dwordx3 v[5:7], off, s2 offset:-1 slc
// CHECK: [0xff,0x5f,0x5a,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dwordx4 v[5:8], off, s2 offset:-1
// CHECK: [0xff,0x5f,0x5c,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dwordx4 v[252:255], off, s2 offset:-1
// CHECK: [0xff,0x5f,0x5c,0xdc,0x00,0x00,0x02,0xfc]

scratch_load_dwordx4 v[5:8], off, s101 offset:-1
// CHECK: [0xff,0x5f,0x5c,0xdc,0x00,0x00,0x65,0x05]

scratch_load_dwordx4 v[5:8], off, flat_scratch_lo offset:-1
// CHECK: [0xff,0x5f,0x5c,0xdc,0x00,0x00,0x66,0x05]

scratch_load_dwordx4 v[5:8], off, flat_scratch_hi offset:-1
// CHECK: [0xff,0x5f,0x5c,0xdc,0x00,0x00,0x67,0x05]

scratch_load_dwordx4 v[5:8], off, vcc_lo offset:-1
// CHECK: [0xff,0x5f,0x5c,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_dwordx4 v[5:8], off, vcc_hi offset:-1
// CHECK: [0xff,0x5f,0x5c,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_dwordx4 v[5:8], off, ttmp15 offset:-1
// CHECK: [0xff,0x5f,0x5c,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_dwordx4 v[5:8], v0, off offset:-1
// CHECK: [0xff,0x5f,0x5c,0xdc,0x00,0x00,0x7f,0x05]

scratch_load_dwordx4 v[5:8], off, s2
// CHECK: [0x00,0x40,0x5c,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dwordx4 v[5:8], off, s2 offset:0
// CHECK: [0x00,0x40,0x5c,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dwordx4 v[5:8], off, s2 offset:4095
// CHECK: [0xff,0x4f,0x5c,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dwordx4 v[5:8], off, s2 offset:-4096
// CHECK: [0x00,0x50,0x5c,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dwordx4 v[5:8], off, s2 offset:-1 glc
// CHECK: [0xff,0x5f,0x5d,0xdc,0x00,0x00,0x02,0x05]

scratch_load_dwordx4 v[5:8], off, s2 offset:-1 slc
// CHECK: [0xff,0x5f,0x5e,0xdc,0x00,0x00,0x02,0x05]

scratch_store_byte off, v2, s3 offset:-1
// CHECK: [0xff,0x5f,0x60,0xdc,0x00,0x02,0x03,0x00]

scratch_store_byte off, v255, s3 offset:-1
// CHECK: [0xff,0x5f,0x60,0xdc,0x00,0xff,0x03,0x00]

scratch_store_byte off, v2, s101 offset:-1
// CHECK: [0xff,0x5f,0x60,0xdc,0x00,0x02,0x65,0x00]

scratch_store_byte off, v2, flat_scratch_lo offset:-1
// CHECK: [0xff,0x5f,0x60,0xdc,0x00,0x02,0x66,0x00]

scratch_store_byte off, v2, flat_scratch_hi offset:-1
// CHECK: [0xff,0x5f,0x60,0xdc,0x00,0x02,0x67,0x00]

scratch_store_byte off, v2, vcc_lo offset:-1
// CHECK: [0xff,0x5f,0x60,0xdc,0x00,0x02,0x6a,0x00]

scratch_store_byte off, v2, vcc_hi offset:-1
// CHECK: [0xff,0x5f,0x60,0xdc,0x00,0x02,0x6b,0x00]

scratch_store_byte off, v2, ttmp15 offset:-1
// CHECK: [0xff,0x5f,0x60,0xdc,0x00,0x02,0x7b,0x00]

scratch_store_byte v0, v2, off offset:-1
// CHECK: [0xff,0x5f,0x60,0xdc,0x00,0x02,0x7f,0x00]

scratch_store_byte off, v2, s3
// CHECK: [0x00,0x40,0x60,0xdc,0x00,0x02,0x03,0x00]

scratch_store_byte off, v2, s3 offset:0
// CHECK: [0x00,0x40,0x60,0xdc,0x00,0x02,0x03,0x00]

scratch_store_byte off, v2, s3 offset:4095
// CHECK: [0xff,0x4f,0x60,0xdc,0x00,0x02,0x03,0x00]

scratch_store_byte off, v2, s3 offset:-4096
// CHECK: [0x00,0x50,0x60,0xdc,0x00,0x02,0x03,0x00]

scratch_store_byte off, v2, s3 offset:-1 glc
// CHECK: [0xff,0x5f,0x61,0xdc,0x00,0x02,0x03,0x00]

scratch_store_byte off, v2, s3 offset:-1 slc
// CHECK: [0xff,0x5f,0x62,0xdc,0x00,0x02,0x03,0x00]

scratch_store_byte_d16_hi off, v2, s3 offset:-1
// CHECK: [0xff,0x5f,0x64,0xdc,0x00,0x02,0x03,0x00]

scratch_store_byte_d16_hi off, v255, s3 offset:-1
// CHECK: [0xff,0x5f,0x64,0xdc,0x00,0xff,0x03,0x00]

scratch_store_byte_d16_hi off, v2, s101 offset:-1
// CHECK: [0xff,0x5f,0x64,0xdc,0x00,0x02,0x65,0x00]

scratch_store_byte_d16_hi off, v2, flat_scratch_lo offset:-1
// CHECK: [0xff,0x5f,0x64,0xdc,0x00,0x02,0x66,0x00]

scratch_store_byte_d16_hi off, v2, flat_scratch_hi offset:-1
// CHECK: [0xff,0x5f,0x64,0xdc,0x00,0x02,0x67,0x00]

scratch_store_byte_d16_hi off, v2, vcc_lo offset:-1
// CHECK: [0xff,0x5f,0x64,0xdc,0x00,0x02,0x6a,0x00]

scratch_store_byte_d16_hi off, v2, vcc_hi offset:-1
// CHECK: [0xff,0x5f,0x64,0xdc,0x00,0x02,0x6b,0x00]

scratch_store_byte_d16_hi off, v2, ttmp15 offset:-1
// CHECK: [0xff,0x5f,0x64,0xdc,0x00,0x02,0x7b,0x00]

scratch_store_byte_d16_hi v0, v2, off offset:-1
// CHECK: [0xff,0x5f,0x64,0xdc,0x00,0x02,0x7f,0x00]

scratch_store_byte_d16_hi off, v2, s3
// CHECK: [0x00,0x40,0x64,0xdc,0x00,0x02,0x03,0x00]

scratch_store_byte_d16_hi off, v2, s3 offset:0
// CHECK: [0x00,0x40,0x64,0xdc,0x00,0x02,0x03,0x00]

scratch_store_byte_d16_hi off, v2, s3 offset:4095
// CHECK: [0xff,0x4f,0x64,0xdc,0x00,0x02,0x03,0x00]

scratch_store_byte_d16_hi off, v2, s3 offset:-4096
// CHECK: [0x00,0x50,0x64,0xdc,0x00,0x02,0x03,0x00]

scratch_store_byte_d16_hi off, v2, s3 offset:-1 glc
// CHECK: [0xff,0x5f,0x65,0xdc,0x00,0x02,0x03,0x00]

scratch_store_byte_d16_hi off, v2, s3 offset:-1 slc
// CHECK: [0xff,0x5f,0x66,0xdc,0x00,0x02,0x03,0x00]

scratch_store_short off, v2, s3 offset:-1
// CHECK: [0xff,0x5f,0x68,0xdc,0x00,0x02,0x03,0x00]

scratch_store_short off, v255, s3 offset:-1
// CHECK: [0xff,0x5f,0x68,0xdc,0x00,0xff,0x03,0x00]

scratch_store_short off, v2, s101 offset:-1
// CHECK: [0xff,0x5f,0x68,0xdc,0x00,0x02,0x65,0x00]

scratch_store_short off, v2, flat_scratch_lo offset:-1
// CHECK: [0xff,0x5f,0x68,0xdc,0x00,0x02,0x66,0x00]

scratch_store_short off, v2, flat_scratch_hi offset:-1
// CHECK: [0xff,0x5f,0x68,0xdc,0x00,0x02,0x67,0x00]

scratch_store_short off, v2, vcc_lo offset:-1
// CHECK: [0xff,0x5f,0x68,0xdc,0x00,0x02,0x6a,0x00]

scratch_store_short off, v2, vcc_hi offset:-1
// CHECK: [0xff,0x5f,0x68,0xdc,0x00,0x02,0x6b,0x00]

scratch_store_short off, v2, ttmp15 offset:-1
// CHECK: [0xff,0x5f,0x68,0xdc,0x00,0x02,0x7b,0x00]

scratch_store_short v0, v2, off offset:-1
// CHECK: [0xff,0x5f,0x68,0xdc,0x00,0x02,0x7f,0x00]

scratch_store_short off, v2, s3
// CHECK: [0x00,0x40,0x68,0xdc,0x00,0x02,0x03,0x00]

scratch_store_short off, v2, s3 offset:0
// CHECK: [0x00,0x40,0x68,0xdc,0x00,0x02,0x03,0x00]

scratch_store_short off, v2, s3 offset:4095
// CHECK: [0xff,0x4f,0x68,0xdc,0x00,0x02,0x03,0x00]

scratch_store_short off, v2, s3 offset:-4096
// CHECK: [0x00,0x50,0x68,0xdc,0x00,0x02,0x03,0x00]

scratch_store_short off, v2, s3 offset:-1 glc
// CHECK: [0xff,0x5f,0x69,0xdc,0x00,0x02,0x03,0x00]

scratch_store_short off, v2, s3 offset:-1 slc
// CHECK: [0xff,0x5f,0x6a,0xdc,0x00,0x02,0x03,0x00]

scratch_store_short_d16_hi off, v2, s3 offset:-1
// CHECK: [0xff,0x5f,0x6c,0xdc,0x00,0x02,0x03,0x00]

scratch_store_short_d16_hi off, v255, s3 offset:-1
// CHECK: [0xff,0x5f,0x6c,0xdc,0x00,0xff,0x03,0x00]

scratch_store_short_d16_hi off, v2, s101 offset:-1
// CHECK: [0xff,0x5f,0x6c,0xdc,0x00,0x02,0x65,0x00]

scratch_store_short_d16_hi off, v2, flat_scratch_lo offset:-1
// CHECK: [0xff,0x5f,0x6c,0xdc,0x00,0x02,0x66,0x00]

scratch_store_short_d16_hi off, v2, flat_scratch_hi offset:-1
// CHECK: [0xff,0x5f,0x6c,0xdc,0x00,0x02,0x67,0x00]

scratch_store_short_d16_hi off, v2, vcc_lo offset:-1
// CHECK: [0xff,0x5f,0x6c,0xdc,0x00,0x02,0x6a,0x00]

scratch_store_short_d16_hi off, v2, vcc_hi offset:-1
// CHECK: [0xff,0x5f,0x6c,0xdc,0x00,0x02,0x6b,0x00]

scratch_store_short_d16_hi off, v2, ttmp15 offset:-1
// CHECK: [0xff,0x5f,0x6c,0xdc,0x00,0x02,0x7b,0x00]

scratch_store_short_d16_hi v0, v2, off offset:-1
// CHECK: [0xff,0x5f,0x6c,0xdc,0x00,0x02,0x7f,0x00]

scratch_store_short_d16_hi off, v2, s3
// CHECK: [0x00,0x40,0x6c,0xdc,0x00,0x02,0x03,0x00]

scratch_store_short_d16_hi off, v2, s3 offset:0
// CHECK: [0x00,0x40,0x6c,0xdc,0x00,0x02,0x03,0x00]

scratch_store_short_d16_hi off, v2, s3 offset:4095
// CHECK: [0xff,0x4f,0x6c,0xdc,0x00,0x02,0x03,0x00]

scratch_store_short_d16_hi off, v2, s3 offset:-4096
// CHECK: [0x00,0x50,0x6c,0xdc,0x00,0x02,0x03,0x00]

scratch_store_short_d16_hi off, v2, s3 offset:-1 glc
// CHECK: [0xff,0x5f,0x6d,0xdc,0x00,0x02,0x03,0x00]

scratch_store_short_d16_hi off, v2, s3 offset:-1 slc
// CHECK: [0xff,0x5f,0x6e,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dword off, v2, s3 offset:-1
// CHECK: [0xff,0x5f,0x70,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dword off, v255, s3 offset:-1
// CHECK: [0xff,0x5f,0x70,0xdc,0x00,0xff,0x03,0x00]

scratch_store_dword off, v2, s101 offset:-1
// CHECK: [0xff,0x5f,0x70,0xdc,0x00,0x02,0x65,0x00]

scratch_store_dword off, v2, flat_scratch_lo offset:-1
// CHECK: [0xff,0x5f,0x70,0xdc,0x00,0x02,0x66,0x00]

scratch_store_dword off, v2, flat_scratch_hi offset:-1
// CHECK: [0xff,0x5f,0x70,0xdc,0x00,0x02,0x67,0x00]

scratch_store_dword off, v2, vcc_lo offset:-1
// CHECK: [0xff,0x5f,0x70,0xdc,0x00,0x02,0x6a,0x00]

scratch_store_dword off, v2, vcc_hi offset:-1
// CHECK: [0xff,0x5f,0x70,0xdc,0x00,0x02,0x6b,0x00]

scratch_store_dword off, v2, ttmp15 offset:-1
// CHECK: [0xff,0x5f,0x70,0xdc,0x00,0x02,0x7b,0x00]

scratch_store_dword v0, v2, off offset:-1
// CHECK: [0xff,0x5f,0x70,0xdc,0x00,0x02,0x7f,0x00]

scratch_store_dword off, v2, s3
// CHECK: [0x00,0x40,0x70,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dword off, v2, s3 offset:0
// CHECK: [0x00,0x40,0x70,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dword off, v2, s3 offset:4095
// CHECK: [0xff,0x4f,0x70,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dword off, v2, s3 offset:-4096
// CHECK: [0x00,0x50,0x70,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dword off, v2, s3 offset:-1 glc
// CHECK: [0xff,0x5f,0x71,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dword off, v2, s3 offset:-1 slc
// CHECK: [0xff,0x5f,0x72,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dwordx2 off, v[2:3], s3 offset:-1
// CHECK: [0xff,0x5f,0x74,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dwordx2 off, v[254:255], s3 offset:-1
// CHECK: [0xff,0x5f,0x74,0xdc,0x00,0xfe,0x03,0x00]

scratch_store_dwordx2 off, v[2:3], s101 offset:-1
// CHECK: [0xff,0x5f,0x74,0xdc,0x00,0x02,0x65,0x00]

scratch_store_dwordx2 off, v[2:3], flat_scratch_lo offset:-1
// CHECK: [0xff,0x5f,0x74,0xdc,0x00,0x02,0x66,0x00]

scratch_store_dwordx2 off, v[2:3], flat_scratch_hi offset:-1
// CHECK: [0xff,0x5f,0x74,0xdc,0x00,0x02,0x67,0x00]

scratch_store_dwordx2 off, v[2:3], vcc_lo offset:-1
// CHECK: [0xff,0x5f,0x74,0xdc,0x00,0x02,0x6a,0x00]

scratch_store_dwordx2 off, v[2:3], vcc_hi offset:-1
// CHECK: [0xff,0x5f,0x74,0xdc,0x00,0x02,0x6b,0x00]

scratch_store_dwordx2 off, v[2:3], ttmp15 offset:-1
// CHECK: [0xff,0x5f,0x74,0xdc,0x00,0x02,0x7b,0x00]

scratch_store_dwordx2 v0, v[2:3], off offset:-1
// CHECK: [0xff,0x5f,0x74,0xdc,0x00,0x02,0x7f,0x00]

scratch_store_dwordx2 off, v[2:3], s3
// CHECK: [0x00,0x40,0x74,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dwordx2 off, v[2:3], s3 offset:0
// CHECK: [0x00,0x40,0x74,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dwordx2 off, v[2:3], s3 offset:4095
// CHECK: [0xff,0x4f,0x74,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dwordx2 off, v[2:3], s3 offset:-4096
// CHECK: [0x00,0x50,0x74,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dwordx2 off, v[2:3], s3 offset:-1 glc
// CHECK: [0xff,0x5f,0x75,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dwordx2 off, v[2:3], s3 offset:-1 slc
// CHECK: [0xff,0x5f,0x76,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dwordx3 off, v[2:4], s3 offset:-1
// CHECK: [0xff,0x5f,0x78,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dwordx3 off, v[253:255], s3 offset:-1
// CHECK: [0xff,0x5f,0x78,0xdc,0x00,0xfd,0x03,0x00]

scratch_store_dwordx3 off, v[2:4], s101 offset:-1
// CHECK: [0xff,0x5f,0x78,0xdc,0x00,0x02,0x65,0x00]

scratch_store_dwordx3 off, v[2:4], flat_scratch_lo offset:-1
// CHECK: [0xff,0x5f,0x78,0xdc,0x00,0x02,0x66,0x00]

scratch_store_dwordx3 off, v[2:4], flat_scratch_hi offset:-1
// CHECK: [0xff,0x5f,0x78,0xdc,0x00,0x02,0x67,0x00]

scratch_store_dwordx3 off, v[2:4], vcc_lo offset:-1
// CHECK: [0xff,0x5f,0x78,0xdc,0x00,0x02,0x6a,0x00]

scratch_store_dwordx3 off, v[2:4], vcc_hi offset:-1
// CHECK: [0xff,0x5f,0x78,0xdc,0x00,0x02,0x6b,0x00]

scratch_store_dwordx3 off, v[2:4], ttmp15 offset:-1
// CHECK: [0xff,0x5f,0x78,0xdc,0x00,0x02,0x7b,0x00]

scratch_store_dwordx3 v0, v[2:4], off offset:-1
// CHECK: [0xff,0x5f,0x78,0xdc,0x00,0x02,0x7f,0x00]

scratch_store_dwordx3 off, v[2:4], s3
// CHECK: [0x00,0x40,0x78,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dwordx3 off, v[2:4], s3 offset:0
// CHECK: [0x00,0x40,0x78,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dwordx3 off, v[2:4], s3 offset:4095
// CHECK: [0xff,0x4f,0x78,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dwordx3 off, v[2:4], s3 offset:-4096
// CHECK: [0x00,0x50,0x78,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dwordx3 off, v[2:4], s3 offset:-1 glc
// CHECK: [0xff,0x5f,0x79,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dwordx3 off, v[2:4], s3 offset:-1 slc
// CHECK: [0xff,0x5f,0x7a,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dwordx4 off, v[2:5], s3 offset:-1
// CHECK: [0xff,0x5f,0x7c,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dwordx4 off, v[252:255], s3 offset:-1
// CHECK: [0xff,0x5f,0x7c,0xdc,0x00,0xfc,0x03,0x00]

scratch_store_dwordx4 off, v[2:5], s101 offset:-1
// CHECK: [0xff,0x5f,0x7c,0xdc,0x00,0x02,0x65,0x00]

scratch_store_dwordx4 off, v[2:5], flat_scratch_lo offset:-1
// CHECK: [0xff,0x5f,0x7c,0xdc,0x00,0x02,0x66,0x00]

scratch_store_dwordx4 off, v[2:5], flat_scratch_hi offset:-1
// CHECK: [0xff,0x5f,0x7c,0xdc,0x00,0x02,0x67,0x00]

scratch_store_dwordx4 off, v[2:5], vcc_lo offset:-1
// CHECK: [0xff,0x5f,0x7c,0xdc,0x00,0x02,0x6a,0x00]

scratch_store_dwordx4 off, v[2:5], vcc_hi offset:-1
// CHECK: [0xff,0x5f,0x7c,0xdc,0x00,0x02,0x6b,0x00]

scratch_store_dwordx4 off, v[2:5], ttmp15 offset:-1
// CHECK: [0xff,0x5f,0x7c,0xdc,0x00,0x02,0x7b,0x00]

scratch_store_dwordx4 v0, v[2:5], off offset:-1
// CHECK: [0xff,0x5f,0x7c,0xdc,0x00,0x02,0x7f,0x00]

scratch_store_dwordx4 off, v[2:5], s3
// CHECK: [0x00,0x40,0x7c,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dwordx4 off, v[2:5], s3 offset:0
// CHECK: [0x00,0x40,0x7c,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dwordx4 off, v[2:5], s3 offset:4095
// CHECK: [0xff,0x4f,0x7c,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dwordx4 off, v[2:5], s3 offset:-4096
// CHECK: [0x00,0x50,0x7c,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dwordx4 off, v[2:5], s3 offset:-1 glc
// CHECK: [0xff,0x5f,0x7d,0xdc,0x00,0x02,0x03,0x00]

scratch_store_dwordx4 off, v[2:5], s3 offset:-1 slc
// CHECK: [0xff,0x5f,0x7e,0xdc,0x00,0x02,0x03,0x00]

scratch_load_ubyte_d16 v5, off, s2 offset:-1
// CHECK: [0xff,0x5f,0x80,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ubyte_d16 v255, off, s2 offset:-1
// CHECK: [0xff,0x5f,0x80,0xdc,0x00,0x00,0x02,0xff]

scratch_load_ubyte_d16 v5, off, s101 offset:-1
// CHECK: [0xff,0x5f,0x80,0xdc,0x00,0x00,0x65,0x05]

scratch_load_ubyte_d16 v5, off, flat_scratch_lo offset:-1
// CHECK: [0xff,0x5f,0x80,0xdc,0x00,0x00,0x66,0x05]

scratch_load_ubyte_d16 v5, off, flat_scratch_hi offset:-1
// CHECK: [0xff,0x5f,0x80,0xdc,0x00,0x00,0x67,0x05]

scratch_load_ubyte_d16 v5, off, vcc_lo offset:-1
// CHECK: [0xff,0x5f,0x80,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_ubyte_d16 v5, off, vcc_hi offset:-1
// CHECK: [0xff,0x5f,0x80,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_ubyte_d16 v5, off, ttmp15 offset:-1
// CHECK: [0xff,0x5f,0x80,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_ubyte_d16 v5, v0, off offset:-1
// CHECK: [0xff,0x5f,0x80,0xdc,0x00,0x00,0x7f,0x05]

scratch_load_ubyte_d16 v5, off, s2
// CHECK: [0x00,0x40,0x80,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ubyte_d16 v5, off, s2 offset:0
// CHECK: [0x00,0x40,0x80,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ubyte_d16 v5, off, s2 offset:4095
// CHECK: [0xff,0x4f,0x80,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ubyte_d16 v5, off, s2 offset:-4096
// CHECK: [0x00,0x50,0x80,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ubyte_d16 v5, off, s2 offset:-1 glc
// CHECK: [0xff,0x5f,0x81,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ubyte_d16 v5, off, s2 offset:-1 slc
// CHECK: [0xff,0x5f,0x82,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ubyte_d16_hi v5, off, s2 offset:-1
// CHECK: [0xff,0x5f,0x84,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ubyte_d16_hi v255, off, s2 offset:-1
// CHECK: [0xff,0x5f,0x84,0xdc,0x00,0x00,0x02,0xff]

scratch_load_ubyte_d16_hi v5, off, s101 offset:-1
// CHECK: [0xff,0x5f,0x84,0xdc,0x00,0x00,0x65,0x05]

scratch_load_ubyte_d16_hi v5, off, flat_scratch_lo offset:-1
// CHECK: [0xff,0x5f,0x84,0xdc,0x00,0x00,0x66,0x05]

scratch_load_ubyte_d16_hi v5, off, flat_scratch_hi offset:-1
// CHECK: [0xff,0x5f,0x84,0xdc,0x00,0x00,0x67,0x05]

scratch_load_ubyte_d16_hi v5, off, vcc_lo offset:-1
// CHECK: [0xff,0x5f,0x84,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_ubyte_d16_hi v5, off, vcc_hi offset:-1
// CHECK: [0xff,0x5f,0x84,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_ubyte_d16_hi v5, off, ttmp15 offset:-1
// CHECK: [0xff,0x5f,0x84,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_ubyte_d16_hi v5, v0, off offset:-1
// CHECK: [0xff,0x5f,0x84,0xdc,0x00,0x00,0x7f,0x05]

scratch_load_ubyte_d16_hi v5, off, s2
// CHECK: [0x00,0x40,0x84,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ubyte_d16_hi v5, off, s2 offset:0
// CHECK: [0x00,0x40,0x84,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ubyte_d16_hi v5, off, s2 offset:4095
// CHECK: [0xff,0x4f,0x84,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ubyte_d16_hi v5, off, s2 offset:-4096
// CHECK: [0x00,0x50,0x84,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ubyte_d16_hi v5, off, s2 offset:-1 glc
// CHECK: [0xff,0x5f,0x85,0xdc,0x00,0x00,0x02,0x05]

scratch_load_ubyte_d16_hi v5, off, s2 offset:-1 slc
// CHECK: [0xff,0x5f,0x86,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sbyte_d16 v5, off, s2 offset:-1
// CHECK: [0xff,0x5f,0x88,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sbyte_d16 v255, off, s2 offset:-1
// CHECK: [0xff,0x5f,0x88,0xdc,0x00,0x00,0x02,0xff]

scratch_load_sbyte_d16 v5, off, s101 offset:-1
// CHECK: [0xff,0x5f,0x88,0xdc,0x00,0x00,0x65,0x05]

scratch_load_sbyte_d16 v5, off, flat_scratch_lo offset:-1
// CHECK: [0xff,0x5f,0x88,0xdc,0x00,0x00,0x66,0x05]

scratch_load_sbyte_d16 v5, off, flat_scratch_hi offset:-1
// CHECK: [0xff,0x5f,0x88,0xdc,0x00,0x00,0x67,0x05]

scratch_load_sbyte_d16 v5, off, vcc_lo offset:-1
// CHECK: [0xff,0x5f,0x88,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_sbyte_d16 v5, off, vcc_hi offset:-1
// CHECK: [0xff,0x5f,0x88,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_sbyte_d16 v5, off, ttmp15 offset:-1
// CHECK: [0xff,0x5f,0x88,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_sbyte_d16 v5, v0, off offset:-1
// CHECK: [0xff,0x5f,0x88,0xdc,0x00,0x00,0x7f,0x05]

scratch_load_sbyte_d16 v5, off, s2
// CHECK: [0x00,0x40,0x88,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sbyte_d16 v5, off, s2 offset:0
// CHECK: [0x00,0x40,0x88,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sbyte_d16 v5, off, s2 offset:4095
// CHECK: [0xff,0x4f,0x88,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sbyte_d16 v5, off, s2 offset:-4096
// CHECK: [0x00,0x50,0x88,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sbyte_d16 v5, off, s2 offset:-1 glc
// CHECK: [0xff,0x5f,0x89,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sbyte_d16 v5, off, s2 offset:-1 slc
// CHECK: [0xff,0x5f,0x8a,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sbyte_d16_hi v5, off, s2 offset:-1
// CHECK: [0xff,0x5f,0x8c,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sbyte_d16_hi v255, off, s2 offset:-1
// CHECK: [0xff,0x5f,0x8c,0xdc,0x00,0x00,0x02,0xff]

scratch_load_sbyte_d16_hi v5, off, s101 offset:-1
// CHECK: [0xff,0x5f,0x8c,0xdc,0x00,0x00,0x65,0x05]

scratch_load_sbyte_d16_hi v5, off, flat_scratch_lo offset:-1
// CHECK: [0xff,0x5f,0x8c,0xdc,0x00,0x00,0x66,0x05]

scratch_load_sbyte_d16_hi v5, off, flat_scratch_hi offset:-1
// CHECK: [0xff,0x5f,0x8c,0xdc,0x00,0x00,0x67,0x05]

scratch_load_sbyte_d16_hi v5, off, vcc_lo offset:-1
// CHECK: [0xff,0x5f,0x8c,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_sbyte_d16_hi v5, off, vcc_hi offset:-1
// CHECK: [0xff,0x5f,0x8c,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_sbyte_d16_hi v5, off, ttmp15 offset:-1
// CHECK: [0xff,0x5f,0x8c,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_sbyte_d16_hi v5, v0, off offset:-1
// CHECK: [0xff,0x5f,0x8c,0xdc,0x00,0x00,0x7f,0x05]

scratch_load_sbyte_d16_hi v5, off, s2
// CHECK: [0x00,0x40,0x8c,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sbyte_d16_hi v5, off, s2 offset:0
// CHECK: [0x00,0x40,0x8c,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sbyte_d16_hi v5, off, s2 offset:4095
// CHECK: [0xff,0x4f,0x8c,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sbyte_d16_hi v5, off, s2 offset:-4096
// CHECK: [0x00,0x50,0x8c,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sbyte_d16_hi v5, off, s2 offset:-1 glc
// CHECK: [0xff,0x5f,0x8d,0xdc,0x00,0x00,0x02,0x05]

scratch_load_sbyte_d16_hi v5, off, s2 offset:-1 slc
// CHECK: [0xff,0x5f,0x8e,0xdc,0x00,0x00,0x02,0x05]

scratch_load_short_d16 v5, off, s2 offset:-1
// CHECK: [0xff,0x5f,0x90,0xdc,0x00,0x00,0x02,0x05]

scratch_load_short_d16 v255, off, s2 offset:-1
// CHECK: [0xff,0x5f,0x90,0xdc,0x00,0x00,0x02,0xff]

scratch_load_short_d16 v5, off, s101 offset:-1
// CHECK: [0xff,0x5f,0x90,0xdc,0x00,0x00,0x65,0x05]

scratch_load_short_d16 v5, off, flat_scratch_lo offset:-1
// CHECK: [0xff,0x5f,0x90,0xdc,0x00,0x00,0x66,0x05]

scratch_load_short_d16 v5, off, flat_scratch_hi offset:-1
// CHECK: [0xff,0x5f,0x90,0xdc,0x00,0x00,0x67,0x05]

scratch_load_short_d16 v5, off, vcc_lo offset:-1
// CHECK: [0xff,0x5f,0x90,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_short_d16 v5, off, vcc_hi offset:-1
// CHECK: [0xff,0x5f,0x90,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_short_d16 v5, off, ttmp15 offset:-1
// CHECK: [0xff,0x5f,0x90,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_short_d16 v5, v0, off offset:-1
// CHECK: [0xff,0x5f,0x90,0xdc,0x00,0x00,0x7f,0x05]

scratch_load_short_d16 v5, off, s2
// CHECK: [0x00,0x40,0x90,0xdc,0x00,0x00,0x02,0x05]

scratch_load_short_d16 v5, off, s2 offset:0
// CHECK: [0x00,0x40,0x90,0xdc,0x00,0x00,0x02,0x05]

scratch_load_short_d16 v5, off, s2 offset:4095
// CHECK: [0xff,0x4f,0x90,0xdc,0x00,0x00,0x02,0x05]

scratch_load_short_d16 v5, off, s2 offset:-4096
// CHECK: [0x00,0x50,0x90,0xdc,0x00,0x00,0x02,0x05]

scratch_load_short_d16 v5, off, s2 offset:-1 glc
// CHECK: [0xff,0x5f,0x91,0xdc,0x00,0x00,0x02,0x05]

scratch_load_short_d16 v5, off, s2 offset:-1 slc
// CHECK: [0xff,0x5f,0x92,0xdc,0x00,0x00,0x02,0x05]

scratch_load_short_d16_hi v5, off, s2 offset:-1
// CHECK: [0xff,0x5f,0x94,0xdc,0x00,0x00,0x02,0x05]

scratch_load_short_d16_hi v255, off, s2 offset:-1
// CHECK: [0xff,0x5f,0x94,0xdc,0x00,0x00,0x02,0xff]

scratch_load_short_d16_hi v5, off, s101 offset:-1
// CHECK: [0xff,0x5f,0x94,0xdc,0x00,0x00,0x65,0x05]

scratch_load_short_d16_hi v5, off, flat_scratch_lo offset:-1
// CHECK: [0xff,0x5f,0x94,0xdc,0x00,0x00,0x66,0x05]

scratch_load_short_d16_hi v5, off, flat_scratch_hi offset:-1
// CHECK: [0xff,0x5f,0x94,0xdc,0x00,0x00,0x67,0x05]

scratch_load_short_d16_hi v5, off, vcc_lo offset:-1
// CHECK: [0xff,0x5f,0x94,0xdc,0x00,0x00,0x6a,0x05]

scratch_load_short_d16_hi v5, off, vcc_hi offset:-1
// CHECK: [0xff,0x5f,0x94,0xdc,0x00,0x00,0x6b,0x05]

scratch_load_short_d16_hi v5, off, ttmp15 offset:-1
// CHECK: [0xff,0x5f,0x94,0xdc,0x00,0x00,0x7b,0x05]

scratch_load_short_d16_hi v5, v0, off offset:-1
// CHECK: [0xff,0x5f,0x94,0xdc,0x00,0x00,0x7f,0x05]

scratch_load_short_d16_hi v5, off, s2
// CHECK: [0x00,0x40,0x94,0xdc,0x00,0x00,0x02,0x05]

scratch_load_short_d16_hi v5, off, s2 offset:0
// CHECK: [0x00,0x40,0x94,0xdc,0x00,0x00,0x02,0x05]

scratch_load_short_d16_hi v5, off, s2 offset:4095
// CHECK: [0xff,0x4f,0x94,0xdc,0x00,0x00,0x02,0x05]

scratch_load_short_d16_hi v5, off, s2 offset:-4096
// CHECK: [0x00,0x50,0x94,0xdc,0x00,0x00,0x02,0x05]

scratch_load_short_d16_hi v5, off, s2 offset:-1 glc
// CHECK: [0xff,0x5f,0x95,0xdc,0x00,0x00,0x02,0x05]

scratch_load_short_d16_hi v5, off, s2 offset:-1 slc
// CHECK: [0xff,0x5f,0x96,0xdc,0x00,0x00,0x02,0x05]

global_load_dword v[2:3], off lds
// CHECK: [0x00,0xa0,0x50,0xdc,0x02,0x00,0x7f,0x00]

global_load_dword v[2:3], off offset:2048 lds
// CHECK: [0x00,0xa8,0x50,0xdc,0x02,0x00,0x7f,0x00]

global_load_ubyte v[2:3], off offset:2048 lds
// CHECK: [0x00,0xa8,0x40,0xdc,0x02,0x00,0x7f,0x00]

global_load_sbyte v[2:3], off offset:2048 lds
// CHECK: [0x00,0xa8,0x44,0xdc,0x02,0x00,0x7f,0x00]

global_load_ushort v[2:3], off offset:2048 lds
// CHECK: [0x00,0xa8,0x48,0xdc,0x02,0x00,0x7f,0x00]

global_load_sshort v[2:3], off offset:2048 lds
// CHECK: [0x00,0xa8,0x4c,0xdc,0x02,0x00,0x7f,0x00]

global_load_dword v2, s[4:5] offset:2048 lds
// CHECK: [0x00,0xa8,0x50,0xdc,0x02,0x00,0x04,0x00]

global_load_ubyte v2, s[4:5] offset:2048 lds
// CHECK: [0x00,0xa8,0x40,0xdc,0x02,0x00,0x04,0x00]

global_load_sbyte v2, s[4:5] offset:2048 lds
// CHECK: [0x00,0xa8,0x44,0xdc,0x02,0x00,0x04,0x00]

global_load_ushort v2, s[4:5] offset:2048 lds
// CHECK: [0x00,0xa8,0x48,0xdc,0x02,0x00,0x04,0x00]

global_load_sshort v2, s[4:5] offset:2048 lds
// CHECK: [0x00,0xa8,0x4c,0xdc,0x02,0x00,0x04,0x00]

scratch_load_dword v2, off lds
// CHECK: [0x00,0x60,0x50,0xdc,0x02,0x00,0x7f,0x00]

scratch_load_dword v2, off offset:2048 lds
// CHECK: [0x00,0x68,0x50,0xdc,0x02,0x00,0x7f,0x00]

scratch_load_dword v2, off offset:2048 lds
// CHECK: [0x00,0x68,0x50,0xdc,0x02,0x00,0x7f,0x00]

scratch_load_ubyte v2, off offset:2048 lds
// CHECK: [0x00,0x68,0x40,0xdc,0x02,0x00,0x7f,0x00]

scratch_load_sbyte v2, off offset:2048 lds
// CHECK: [0x00,0x68,0x44,0xdc,0x02,0x00,0x7f,0x00]

scratch_load_ushort v2, off offset:2048 lds
// CHECK: [0x00,0x68,0x48,0xdc,0x02,0x00,0x7f,0x00]

scratch_load_sshort v2, off offset:2048 lds
// CHECK: [0x00,0x68,0x4c,0xdc,0x02,0x00,0x7f,0x00]

scratch_load_dword off, s4 offset:2048 lds
// CHECK: [0x00,0x68,0x50,0xdc,0x00,0x00,0x04,0x00]

scratch_load_ubyte off, s4 offset:2048 lds
// CHECK: [0x00,0x68,0x40,0xdc,0x00,0x00,0x04,0x00]

scratch_load_sbyte off, s4 offset:2048 lds
// CHECK: [0x00,0x68,0x44,0xdc,0x00,0x00,0x04,0x00]

scratch_load_ushort off, s4 offset:2048 lds
// CHECK: [0x00,0x68,0x48,0xdc,0x00,0x00,0x04,0x00]

scratch_load_sshort off, s4 offset:2048 lds
// CHECK: [0x00,0x68,0x4c,0xdc,0x00,0x00,0x04,0x00]
