; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -global-isel -o - %s | FileCheck %s
target datalayout = "e-m:o-p270:32:32-p271:32:32-p272:64:64-i64:64-i128:128-n32:64-S128-Fn32"
target triple = "arm64-apple-macosx14.0.0"

%struct.S = type { ptr }

@str = global %struct.S zeroinitializer, align 8

; Checks that on Darwin we don't fold the global into the prfm instruction
; since ld64 doesn't support it.

define void @test() #0 {
; CHECK-LABEL: test:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:  Lloh0:
; CHECK-NEXT:    adrp x8, _str@PAGE
; CHECK-NEXT:  Lloh1:
; CHECK-NEXT:    add x8, x8, _str@PAGEOFF
; CHECK-NEXT:    prfm pldl1strm, [x8]
; CHECK-NEXT:    ret
; CHECK-NEXT:    .loh AdrpAdd Lloh0, Lloh1
entry:
  call void @llvm.prefetch.p0(ptr @str, i32 0, i32 0, i32 1)
  ret void
}

; Function Attrs: nocallback nofree nosync nounwind willreturn memory(argmem: readwrite, inaccessiblemem: readwrite)
declare void @llvm.prefetch.p0(ptr nocapture readonly, i32 immarg, i32 immarg, i32 immarg) #1

