; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -arm-parallel-dsp -mtriple=armv7-a -S %s -o - | FileCheck %s

define i32 @exchange_1(ptr %a, ptr %b, i32 %acc) {
; CHECK-LABEL: @exchange_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADDR_A_1:%.*]] = getelementptr i16, ptr [[A:%.*]], i32 1
; CHECK-NEXT:    [[ADDR_B_1:%.*]] = getelementptr i16, ptr [[B:%.*]], i32 1
; CHECK-NEXT:    [[LD_A_0:%.*]] = load i16, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i16
; CHECK-NEXT:    [[TMP3:%.*]] = sext i16 [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 16
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[TMP4]] to i16
; CHECK-NEXT:    [[TMP6:%.*]] = sext i16 [[TMP5]] to i32
; CHECK-NEXT:    [[SEXT_A_0:%.*]] = sext i16 [[LD_A_0]] to i32
; CHECK-NEXT:    [[LD_B_0:%.*]] = load i16, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP9:%.*]] = trunc i32 [[TMP8]] to i16
; CHECK-NEXT:    [[TMP10:%.*]] = call i32 @llvm.arm.smladx(i32 [[TMP1]], i32 [[TMP8]], i32 [[ACC:%.*]])
; CHECK-NEXT:    [[TMP11:%.*]] = sext i16 [[TMP9]] to i32
; CHECK-NEXT:    [[TMP12:%.*]] = lshr i32 [[TMP8]], 16
; CHECK-NEXT:    [[TMP13:%.*]] = trunc i32 [[TMP12]] to i16
; CHECK-NEXT:    [[TMP14:%.*]] = sext i16 [[TMP13]] to i32
; CHECK-NEXT:    [[LD_A_1:%.*]] = load i16, ptr [[ADDR_A_1]], align 2
; CHECK-NEXT:    [[LD_B_1:%.*]] = load i16, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[SEXT_A_1:%.*]] = sext i16 [[LD_A_1]] to i32
; CHECK-NEXT:    [[SEXT_B_1:%.*]] = sext i16 [[LD_B_1]] to i32
; CHECK-NEXT:    [[SEXT_B_0:%.*]] = sext i16 [[LD_B_0]] to i32
; CHECK-NEXT:    [[MUL_0:%.*]] = mul i32 [[TMP3]], [[TMP14]]
; CHECK-NEXT:    [[MUL_1:%.*]] = mul i32 [[TMP6]], [[TMP11]]
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[MUL_0]], [[MUL_1]]
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[ADD]], [[ACC]]
; CHECK-NEXT:    ret i32 [[TMP10]]
;
entry:
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %ld.a.1 = load i16, ptr %addr.a.1
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %mul.0 = mul i32 %sext.a.0, %sext.b.1
  %mul.1 = mul i32 %sext.a.1, %sext.b.0
  %add = add i32 %mul.0, %mul.1
  %res = add i32 %add, %acc
  ret i32 %res
}

define i32 @exchange_2(ptr %a, ptr %b, i32 %acc) {
; CHECK-LABEL: @exchange_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADDR_A_1:%.*]] = getelementptr i16, ptr [[A:%.*]], i32 1
; CHECK-NEXT:    [[ADDR_B_1:%.*]] = getelementptr i16, ptr [[B:%.*]], i32 1
; CHECK-NEXT:    [[LD_A_0:%.*]] = load i16, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i16
; CHECK-NEXT:    [[TMP3:%.*]] = sext i16 [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 16
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[TMP4]] to i16
; CHECK-NEXT:    [[TMP6:%.*]] = sext i16 [[TMP5]] to i32
; CHECK-NEXT:    [[SEXT_A_0:%.*]] = sext i16 [[LD_A_0]] to i32
; CHECK-NEXT:    [[LD_B_0:%.*]] = load i16, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP9:%.*]] = trunc i32 [[TMP8]] to i16
; CHECK-NEXT:    [[TMP10:%.*]] = call i32 @llvm.arm.smladx(i32 [[TMP1]], i32 [[TMP8]], i32 [[ACC:%.*]])
; CHECK-NEXT:    [[TMP11:%.*]] = sext i16 [[TMP9]] to i32
; CHECK-NEXT:    [[TMP12:%.*]] = lshr i32 [[TMP8]], 16
; CHECK-NEXT:    [[TMP13:%.*]] = trunc i32 [[TMP12]] to i16
; CHECK-NEXT:    [[TMP14:%.*]] = sext i16 [[TMP13]] to i32
; CHECK-NEXT:    [[LD_A_1:%.*]] = load i16, ptr [[ADDR_A_1]], align 2
; CHECK-NEXT:    [[LD_B_1:%.*]] = load i16, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[SEXT_A_1:%.*]] = sext i16 [[LD_A_1]] to i32
; CHECK-NEXT:    [[SEXT_B_1:%.*]] = sext i16 [[LD_B_1]] to i32
; CHECK-NEXT:    [[SEXT_B_0:%.*]] = sext i16 [[LD_B_0]] to i32
; CHECK-NEXT:    [[MUL_0:%.*]] = mul i32 [[TMP14]], [[TMP3]]
; CHECK-NEXT:    [[MUL_1:%.*]] = mul i32 [[TMP11]], [[TMP6]]
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[MUL_0]], [[MUL_1]]
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[ADD]], [[ACC]]
; CHECK-NEXT:    ret i32 [[TMP10]]
;
entry:
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %ld.a.1 = load i16, ptr %addr.a.1
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %mul.0 = mul i32 %sext.b.1, %sext.a.0
  %mul.1 = mul i32 %sext.b.0, %sext.a.1
  %add = add i32 %mul.0, %mul.1
  %res = add i32 %add, %acc
  ret i32 %res
}

define i32 @exchange_3(ptr %a, ptr %b, i32 %acc) {
; CHECK-LABEL: @exchange_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADDR_A_1:%.*]] = getelementptr i16, ptr [[A:%.*]], i32 1
; CHECK-NEXT:    [[ADDR_B_1:%.*]] = getelementptr i16, ptr [[B:%.*]], i32 1
; CHECK-NEXT:    [[LD_A_0:%.*]] = load i16, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i16
; CHECK-NEXT:    [[TMP3:%.*]] = sext i16 [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 16
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[TMP4]] to i16
; CHECK-NEXT:    [[TMP6:%.*]] = sext i16 [[TMP5]] to i32
; CHECK-NEXT:    [[SEXT_A_0:%.*]] = sext i16 [[LD_A_0]] to i32
; CHECK-NEXT:    [[LD_B_0:%.*]] = load i16, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP9:%.*]] = trunc i32 [[TMP8]] to i16
; CHECK-NEXT:    [[TMP10:%.*]] = call i32 @llvm.arm.smladx(i32 [[TMP8]], i32 [[TMP1]], i32 [[ACC:%.*]])
; CHECK-NEXT:    [[TMP11:%.*]] = sext i16 [[TMP9]] to i32
; CHECK-NEXT:    [[TMP12:%.*]] = lshr i32 [[TMP8]], 16
; CHECK-NEXT:    [[TMP13:%.*]] = trunc i32 [[TMP12]] to i16
; CHECK-NEXT:    [[TMP14:%.*]] = sext i16 [[TMP13]] to i32
; CHECK-NEXT:    [[LD_A_1:%.*]] = load i16, ptr [[ADDR_A_1]], align 2
; CHECK-NEXT:    [[LD_B_1:%.*]] = load i16, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[SEXT_A_1:%.*]] = sext i16 [[LD_A_1]] to i32
; CHECK-NEXT:    [[SEXT_B_1:%.*]] = sext i16 [[LD_B_1]] to i32
; CHECK-NEXT:    [[SEXT_B_0:%.*]] = sext i16 [[LD_B_0]] to i32
; CHECK-NEXT:    [[MUL_0:%.*]] = mul i32 [[TMP3]], [[TMP14]]
; CHECK-NEXT:    [[MUL_1:%.*]] = mul i32 [[TMP6]], [[TMP11]]
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[MUL_1]], [[MUL_0]]
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[ADD]], [[ACC]]
; CHECK-NEXT:    ret i32 [[TMP10]]
;
entry:
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %ld.a.1 = load i16, ptr %addr.a.1
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %mul.0 = mul i32 %sext.a.0, %sext.b.1
  %mul.1 = mul i32 %sext.a.1, %sext.b.0
  %add = add i32 %mul.1, %mul.0
  %res = add i32 %add, %acc
  ret i32 %res
}

define i32 @exchange_4(ptr %a, ptr %b, i32 %acc) {
; CHECK-LABEL: @exchange_4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADDR_A_1:%.*]] = getelementptr i16, ptr [[A:%.*]], i32 1
; CHECK-NEXT:    [[ADDR_B_1:%.*]] = getelementptr i16, ptr [[B:%.*]], i32 1
; CHECK-NEXT:    [[LD_A_0:%.*]] = load i16, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i16
; CHECK-NEXT:    [[TMP3:%.*]] = sext i16 [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 16
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[TMP4]] to i16
; CHECK-NEXT:    [[TMP6:%.*]] = sext i16 [[TMP5]] to i32
; CHECK-NEXT:    [[SEXT_A_0:%.*]] = sext i16 [[LD_A_0]] to i32
; CHECK-NEXT:    [[LD_B_0:%.*]] = load i16, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP9:%.*]] = trunc i32 [[TMP8]] to i16
; CHECK-NEXT:    [[TMP10:%.*]] = call i32 @llvm.arm.smladx(i32 [[TMP8]], i32 [[TMP1]], i32 [[ACC:%.*]])
; CHECK-NEXT:    [[TMP11:%.*]] = sext i16 [[TMP9]] to i32
; CHECK-NEXT:    [[TMP12:%.*]] = lshr i32 [[TMP8]], 16
; CHECK-NEXT:    [[TMP13:%.*]] = trunc i32 [[TMP12]] to i16
; CHECK-NEXT:    [[TMP14:%.*]] = sext i16 [[TMP13]] to i32
; CHECK-NEXT:    [[LD_A_1:%.*]] = load i16, ptr [[ADDR_A_1]], align 2
; CHECK-NEXT:    [[LD_B_1:%.*]] = load i16, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[SEXT_A_1:%.*]] = sext i16 [[LD_A_1]] to i32
; CHECK-NEXT:    [[SEXT_B_1:%.*]] = sext i16 [[LD_B_1]] to i32
; CHECK-NEXT:    [[SEXT_B_0:%.*]] = sext i16 [[LD_B_0]] to i32
; CHECK-NEXT:    [[MUL_0:%.*]] = mul i32 [[TMP14]], [[TMP3]]
; CHECK-NEXT:    [[MUL_1:%.*]] = mul i32 [[TMP11]], [[TMP6]]
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[MUL_1]], [[MUL_0]]
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[ADD]], [[ACC]]
; CHECK-NEXT:    ret i32 [[TMP10]]
;
entry:
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %ld.a.1 = load i16, ptr %addr.a.1
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %mul.0 = mul i32 %sext.b.1, %sext.a.0
  %mul.1 = mul i32 %sext.b.0, %sext.a.1
  %add = add i32 %mul.1, %mul.0
  %res = add i32 %add, %acc
  ret i32 %res
}

define i32 @exchange_multi_use_1(ptr %a, ptr %b, i32 %acc) {
; CHECK-LABEL: @exchange_multi_use_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADDR_A_1:%.*]] = getelementptr i16, ptr [[A:%.*]], i32 1
; CHECK-NEXT:    [[ADDR_B_1:%.*]] = getelementptr i16, ptr [[B:%.*]], i32 1
; CHECK-NEXT:    [[LD_A_0:%.*]] = load i16, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i16
; CHECK-NEXT:    [[TMP3:%.*]] = sext i16 [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 16
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[TMP4]] to i16
; CHECK-NEXT:    [[TMP6:%.*]] = sext i16 [[TMP5]] to i32
; CHECK-NEXT:    [[SEXT_A_0:%.*]] = sext i16 [[LD_A_0]] to i32
; CHECK-NEXT:    [[LD_B_0:%.*]] = load i16, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP9:%.*]] = trunc i32 [[TMP8]] to i16
; CHECK-NEXT:    [[TMP10:%.*]] = call i32 @llvm.arm.smladx(i32 [[TMP1]], i32 [[TMP8]], i32 [[ACC:%.*]])
; CHECK-NEXT:    [[TMP11:%.*]] = sext i16 [[TMP9]] to i32
; CHECK-NEXT:    [[TMP12:%.*]] = lshr i32 [[TMP8]], 16
; CHECK-NEXT:    [[TMP13:%.*]] = trunc i32 [[TMP12]] to i16
; CHECK-NEXT:    [[TMP14:%.*]] = sext i16 [[TMP13]] to i32
; CHECK-NEXT:    [[LD_A_1:%.*]] = load i16, ptr [[ADDR_A_1]], align 2
; CHECK-NEXT:    [[LD_B_1:%.*]] = load i16, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[SEXT_A_1:%.*]] = sext i16 [[LD_A_1]] to i32
; CHECK-NEXT:    [[SEXT_B_1:%.*]] = sext i16 [[LD_B_1]] to i32
; CHECK-NEXT:    [[SEXT_B_0:%.*]] = sext i16 [[LD_B_0]] to i32
; CHECK-NEXT:    [[MUL_0:%.*]] = mul i32 [[TMP3]], [[TMP14]]
; CHECK-NEXT:    [[MUL_1:%.*]] = mul i32 [[TMP6]], [[TMP11]]
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[MUL_0]], [[MUL_1]]
; CHECK-NEXT:    [[ADDR_A_2:%.*]] = getelementptr i16, ptr [[A]], i32 2
; CHECK-NEXT:    [[ADDR_A_3:%.*]] = getelementptr i16, ptr [[A]], i32 3
; CHECK-NEXT:    [[LD_A_2:%.*]] = load i16, ptr [[ADDR_A_2]], align 2
; CHECK-NEXT:    [[TMP16:%.*]] = load i32, ptr [[ADDR_A_2]], align 2
; CHECK-NEXT:    [[TMP17:%.*]] = trunc i32 [[TMP16]] to i16
; CHECK-NEXT:    [[TMP18:%.*]] = call i32 @llvm.arm.smlad(i32 [[TMP16]], i32 [[TMP8]], i32 [[TMP10]])
; CHECK-NEXT:    [[TMP19:%.*]] = sext i16 [[TMP17]] to i32
; CHECK-NEXT:    [[TMP20:%.*]] = lshr i32 [[TMP16]], 16
; CHECK-NEXT:    [[TMP21:%.*]] = trunc i32 [[TMP20]] to i16
; CHECK-NEXT:    [[TMP22:%.*]] = sext i16 [[TMP21]] to i32
; CHECK-NEXT:    [[LD_A_3:%.*]] = load i16, ptr [[ADDR_A_3]], align 2
; CHECK-NEXT:    [[SEXT_A_2:%.*]] = sext i16 [[LD_A_2]] to i32
; CHECK-NEXT:    [[SEXT_A_3:%.*]] = sext i16 [[LD_A_3]] to i32
; CHECK-NEXT:    [[MUL_2:%.*]] = mul i32 [[TMP22]], [[TMP14]]
; CHECK-NEXT:    [[MUL_3:%.*]] = mul i32 [[TMP19]], [[TMP11]]
; CHECK-NEXT:    [[ADD_1:%.*]] = add i32 [[MUL_2]], [[MUL_3]]
; CHECK-NEXT:    [[ADD_2:%.*]] = add i32 [[ADD]], [[ADD_1]]
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[ADD_2]], [[ACC]]
; CHECK-NEXT:    ret i32 [[TMP18]]
;
entry:
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %ld.a.1 = load i16, ptr %addr.a.1
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %mul.0 = mul i32 %sext.a.0, %sext.b.1
  %mul.1 = mul i32 %sext.a.1, %sext.b.0
  %add = add i32 %mul.0, %mul.1
  %addr.a.2 = getelementptr i16, ptr %a, i32 2
  %addr.a.3 = getelementptr i16, ptr %a, i32 3
  %ld.a.2 = load i16, ptr %addr.a.2
  %ld.a.3 = load i16, ptr %addr.a.3
  %sext.a.2 = sext i16 %ld.a.2 to i32
  %sext.a.3 = sext i16 %ld.a.3 to i32
  %mul.2 = mul i32 %sext.a.3, %sext.b.1
  %mul.3 = mul i32 %sext.a.2, %sext.b.0
  %add.1 = add i32 %mul.2, %mul.3
  %add.2 = add i32 %add, %add.1
  %res = add i32 %add.2, %acc
  ret i32 %res
}

define i64 @exchange_multi_use_64_1(ptr %a, ptr %b, i64 %acc) {
; CHECK-LABEL: @exchange_multi_use_64_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADDR_A_1:%.*]] = getelementptr i16, ptr [[A:%.*]], i32 1
; CHECK-NEXT:    [[ADDR_B_1:%.*]] = getelementptr i16, ptr [[B:%.*]], i32 1
; CHECK-NEXT:    [[LD_A_0:%.*]] = load i16, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i16
; CHECK-NEXT:    [[TMP3:%.*]] = sext i16 [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 16
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[TMP4]] to i16
; CHECK-NEXT:    [[TMP6:%.*]] = sext i16 [[TMP5]] to i32
; CHECK-NEXT:    [[SEXT_A_0:%.*]] = sext i16 [[LD_A_0]] to i32
; CHECK-NEXT:    [[LD_B_0:%.*]] = load i16, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP9:%.*]] = trunc i32 [[TMP8]] to i16
; CHECK-NEXT:    [[TMP10:%.*]] = call i64 @llvm.arm.smlaldx(i32 [[TMP1]], i32 [[TMP8]], i64 [[ACC:%.*]])
; CHECK-NEXT:    [[TMP11:%.*]] = sext i16 [[TMP9]] to i32
; CHECK-NEXT:    [[TMP12:%.*]] = lshr i32 [[TMP8]], 16
; CHECK-NEXT:    [[TMP13:%.*]] = trunc i32 [[TMP12]] to i16
; CHECK-NEXT:    [[TMP14:%.*]] = sext i16 [[TMP13]] to i32
; CHECK-NEXT:    [[LD_A_1:%.*]] = load i16, ptr [[ADDR_A_1]], align 2
; CHECK-NEXT:    [[LD_B_1:%.*]] = load i16, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[SEXT_A_1:%.*]] = sext i16 [[LD_A_1]] to i32
; CHECK-NEXT:    [[SEXT_B_1:%.*]] = sext i16 [[LD_B_1]] to i32
; CHECK-NEXT:    [[SEXT_B_0:%.*]] = sext i16 [[LD_B_0]] to i32
; CHECK-NEXT:    [[MUL_0:%.*]] = mul i32 [[TMP3]], [[TMP14]]
; CHECK-NEXT:    [[MUL_1:%.*]] = mul i32 [[TMP6]], [[TMP11]]
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[MUL_0]], [[MUL_1]]
; CHECK-NEXT:    [[ADDR_A_2:%.*]] = getelementptr i16, ptr [[A]], i32 2
; CHECK-NEXT:    [[ADDR_A_3:%.*]] = getelementptr i16, ptr [[A]], i32 3
; CHECK-NEXT:    [[LD_A_2:%.*]] = load i16, ptr [[ADDR_A_2]], align 2
; CHECK-NEXT:    [[TMP16:%.*]] = load i32, ptr [[ADDR_A_2]], align 2
; CHECK-NEXT:    [[TMP17:%.*]] = trunc i32 [[TMP16]] to i16
; CHECK-NEXT:    [[TMP18:%.*]] = call i64 @llvm.arm.smlald(i32 [[TMP16]], i32 [[TMP8]], i64 [[TMP10]])
; CHECK-NEXT:    [[TMP19:%.*]] = sext i16 [[TMP17]] to i32
; CHECK-NEXT:    [[TMP20:%.*]] = lshr i32 [[TMP16]], 16
; CHECK-NEXT:    [[TMP21:%.*]] = trunc i32 [[TMP20]] to i16
; CHECK-NEXT:    [[TMP22:%.*]] = sext i16 [[TMP21]] to i32
; CHECK-NEXT:    [[LD_A_3:%.*]] = load i16, ptr [[ADDR_A_3]], align 2
; CHECK-NEXT:    [[SEXT_A_2:%.*]] = sext i16 [[LD_A_2]] to i32
; CHECK-NEXT:    [[SEXT_A_3:%.*]] = sext i16 [[LD_A_3]] to i32
; CHECK-NEXT:    [[MUL_2:%.*]] = mul i32 [[TMP22]], [[TMP14]]
; CHECK-NEXT:    [[MUL_3:%.*]] = mul i32 [[TMP19]], [[TMP11]]
; CHECK-NEXT:    [[ADD_1:%.*]] = add i32 [[MUL_2]], [[MUL_3]]
; CHECK-NEXT:    [[ADD_2:%.*]] = add i32 [[ADD]], [[ADD_1]]
; CHECK-NEXT:    [[SEXT_ADD_2:%.*]] = sext i32 [[ADD_2]] to i64
; CHECK-NEXT:    [[RES:%.*]] = add i64 [[SEXT_ADD_2]], [[ACC]]
; CHECK-NEXT:    ret i64 [[TMP18]]
;
entry:
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %ld.a.1 = load i16, ptr %addr.a.1
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %mul.0 = mul i32 %sext.a.0, %sext.b.1
  %mul.1 = mul i32 %sext.a.1, %sext.b.0
  %add = add i32 %mul.0, %mul.1
  %addr.a.2 = getelementptr i16, ptr %a, i32 2
  %addr.a.3 = getelementptr i16, ptr %a, i32 3
  %ld.a.2 = load i16, ptr %addr.a.2
  %ld.a.3 = load i16, ptr %addr.a.3
  %sext.a.2 = sext i16 %ld.a.2 to i32
  %sext.a.3 = sext i16 %ld.a.3 to i32
  %mul.2 = mul i32 %sext.a.3, %sext.b.1
  %mul.3 = mul i32 %sext.a.2, %sext.b.0
  %add.1 = add i32 %mul.2, %mul.3
  %add.2 = add i32 %add, %add.1
  %sext.add.2 = sext i32 %add.2 to i64
  %res = add i64 %sext.add.2, %acc
  ret i64 %res
}

define i64 @exchange_multi_use_64_2(ptr %a, ptr %b, i64 %acc) {
; CHECK-LABEL: @exchange_multi_use_64_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADDR_A_1:%.*]] = getelementptr i16, ptr [[A:%.*]], i32 1
; CHECK-NEXT:    [[ADDR_B_1:%.*]] = getelementptr i16, ptr [[B:%.*]], i32 1
; CHECK-NEXT:    [[LD_A_0:%.*]] = load i16, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i16
; CHECK-NEXT:    [[TMP3:%.*]] = sext i16 [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 16
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[TMP4]] to i16
; CHECK-NEXT:    [[TMP6:%.*]] = sext i16 [[TMP5]] to i32
; CHECK-NEXT:    [[SEXT_A_0:%.*]] = sext i16 [[LD_A_0]] to i32
; CHECK-NEXT:    [[LD_B_0:%.*]] = load i16, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP9:%.*]] = trunc i32 [[TMP8]] to i16
; CHECK-NEXT:    [[TMP10:%.*]] = call i64 @llvm.arm.smlaldx(i32 [[TMP1]], i32 [[TMP8]], i64 [[ACC:%.*]])
; CHECK-NEXT:    [[TMP11:%.*]] = sext i16 [[TMP9]] to i32
; CHECK-NEXT:    [[TMP12:%.*]] = lshr i32 [[TMP8]], 16
; CHECK-NEXT:    [[TMP13:%.*]] = trunc i32 [[TMP12]] to i16
; CHECK-NEXT:    [[TMP14:%.*]] = sext i16 [[TMP13]] to i32
; CHECK-NEXT:    [[LD_A_1:%.*]] = load i16, ptr [[ADDR_A_1]], align 2
; CHECK-NEXT:    [[LD_B_1:%.*]] = load i16, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[SEXT_A_1:%.*]] = sext i16 [[LD_A_1]] to i32
; CHECK-NEXT:    [[SEXT_B_1:%.*]] = sext i16 [[LD_B_1]] to i32
; CHECK-NEXT:    [[SEXT_B_0:%.*]] = sext i16 [[LD_B_0]] to i32
; CHECK-NEXT:    [[MUL_0:%.*]] = mul i32 [[TMP3]], [[TMP14]]
; CHECK-NEXT:    [[MUL_1:%.*]] = mul i32 [[TMP6]], [[TMP11]]
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[MUL_0]], [[MUL_1]]
; CHECK-NEXT:    [[SEXT_ADD:%.*]] = sext i32 [[ADD]] to i64
; CHECK-NEXT:    [[ADDR_A_2:%.*]] = getelementptr i16, ptr [[A]], i32 2
; CHECK-NEXT:    [[ADDR_A_3:%.*]] = getelementptr i16, ptr [[A]], i32 3
; CHECK-NEXT:    [[LD_A_2:%.*]] = load i16, ptr [[ADDR_A_2]], align 2
; CHECK-NEXT:    [[TMP16:%.*]] = load i32, ptr [[ADDR_A_2]], align 2
; CHECK-NEXT:    [[TMP17:%.*]] = trunc i32 [[TMP16]] to i16
; CHECK-NEXT:    [[TMP18:%.*]] = call i64 @llvm.arm.smlald(i32 [[TMP16]], i32 [[TMP8]], i64 [[TMP10]])
; CHECK-NEXT:    [[TMP19:%.*]] = sext i16 [[TMP17]] to i32
; CHECK-NEXT:    [[TMP20:%.*]] = lshr i32 [[TMP16]], 16
; CHECK-NEXT:    [[TMP21:%.*]] = trunc i32 [[TMP20]] to i16
; CHECK-NEXT:    [[TMP22:%.*]] = sext i16 [[TMP21]] to i32
; CHECK-NEXT:    [[LD_A_3:%.*]] = load i16, ptr [[ADDR_A_3]], align 2
; CHECK-NEXT:    [[SEXT_A_2:%.*]] = sext i16 [[LD_A_2]] to i32
; CHECK-NEXT:    [[SEXT_A_3:%.*]] = sext i16 [[LD_A_3]] to i32
; CHECK-NEXT:    [[MUL_2:%.*]] = mul i32 [[TMP22]], [[TMP14]]
; CHECK-NEXT:    [[MUL_3:%.*]] = mul i32 [[TMP19]], [[TMP11]]
; CHECK-NEXT:    [[ADD_1:%.*]] = add i32 [[MUL_2]], [[MUL_3]]
; CHECK-NEXT:    [[SEXT_ADD_1:%.*]] = sext i32 [[ADD_1]] to i64
; CHECK-NEXT:    [[ADD_2:%.*]] = add i64 [[SEXT_ADD]], [[SEXT_ADD_1]]
; CHECK-NEXT:    [[RES:%.*]] = add i64 [[ADD_2]], [[ACC]]
; CHECK-NEXT:    ret i64 [[TMP18]]
;
entry:
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %ld.a.1 = load i16, ptr %addr.a.1
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %mul.0 = mul i32 %sext.a.0, %sext.b.1
  %mul.1 = mul i32 %sext.a.1, %sext.b.0
  %add = add i32 %mul.0, %mul.1
  %sext.add = sext i32 %add to i64
  %addr.a.2 = getelementptr i16, ptr %a, i32 2
  %addr.a.3 = getelementptr i16, ptr %a, i32 3
  %ld.a.2 = load i16, ptr %addr.a.2
  %ld.a.3 = load i16, ptr %addr.a.3
  %sext.a.2 = sext i16 %ld.a.2 to i32
  %sext.a.3 = sext i16 %ld.a.3 to i32
  %mul.2 = mul i32 %sext.a.3, %sext.b.1
  %mul.3 = mul i32 %sext.a.2, %sext.b.0
  %add.1 = add i32 %mul.2, %mul.3
  %sext.add.1 = sext i32 %add.1 to i64
  %add.2 = add i64 %sext.add, %sext.add.1
  %res = add i64 %add.2, %acc
  ret i64 %res
}

define i32 @exchange_multi_use_2(ptr %a, ptr %b, i32 %acc) {
; CHECK-LABEL: @exchange_multi_use_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADDR_A_1:%.*]] = getelementptr i16, ptr [[A:%.*]], i32 1
; CHECK-NEXT:    [[ADDR_B_1:%.*]] = getelementptr i16, ptr [[B:%.*]], i32 1
; CHECK-NEXT:    [[LD_A_0:%.*]] = load i16, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i16
; CHECK-NEXT:    [[TMP3:%.*]] = sext i16 [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 16
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[TMP4]] to i16
; CHECK-NEXT:    [[TMP6:%.*]] = sext i16 [[TMP5]] to i32
; CHECK-NEXT:    [[SEXT_A_0:%.*]] = sext i16 [[LD_A_0]] to i32
; CHECK-NEXT:    [[LD_B_0:%.*]] = load i16, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP9:%.*]] = trunc i32 [[TMP8]] to i16
; CHECK-NEXT:    [[TMP10:%.*]] = call i32 @llvm.arm.smlad(i32 [[TMP1]], i32 [[TMP8]], i32 [[ACC:%.*]])
; CHECK-NEXT:    [[TMP11:%.*]] = sext i16 [[TMP9]] to i32
; CHECK-NEXT:    [[TMP12:%.*]] = lshr i32 [[TMP8]], 16
; CHECK-NEXT:    [[TMP13:%.*]] = trunc i32 [[TMP12]] to i16
; CHECK-NEXT:    [[TMP14:%.*]] = sext i16 [[TMP13]] to i32
; CHECK-NEXT:    [[LD_A_1:%.*]] = load i16, ptr [[ADDR_A_1]], align 2
; CHECK-NEXT:    [[LD_B_1:%.*]] = load i16, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[SEXT_A_1:%.*]] = sext i16 [[LD_A_1]] to i32
; CHECK-NEXT:    [[SEXT_B_1:%.*]] = sext i16 [[LD_B_1]] to i32
; CHECK-NEXT:    [[SEXT_B_0:%.*]] = sext i16 [[LD_B_0]] to i32
; CHECK-NEXT:    [[MUL_0:%.*]] = mul i32 [[TMP3]], [[TMP11]]
; CHECK-NEXT:    [[MUL_1:%.*]] = mul i32 [[TMP6]], [[TMP14]]
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[MUL_0]], [[MUL_1]]
; CHECK-NEXT:    [[ADDR_A_2:%.*]] = getelementptr i16, ptr [[A]], i32 2
; CHECK-NEXT:    [[ADDR_A_3:%.*]] = getelementptr i16, ptr [[A]], i32 3
; CHECK-NEXT:    [[LD_A_2:%.*]] = load i16, ptr [[ADDR_A_2]], align 2
; CHECK-NEXT:    [[TMP16:%.*]] = load i32, ptr [[ADDR_A_2]], align 2
; CHECK-NEXT:    [[TMP17:%.*]] = trunc i32 [[TMP16]] to i16
; CHECK-NEXT:    [[TMP18:%.*]] = call i32 @llvm.arm.smladx(i32 [[TMP8]], i32 [[TMP16]], i32 [[TMP10]])
; CHECK-NEXT:    [[TMP19:%.*]] = sext i16 [[TMP17]] to i32
; CHECK-NEXT:    [[TMP20:%.*]] = lshr i32 [[TMP16]], 16
; CHECK-NEXT:    [[TMP21:%.*]] = trunc i32 [[TMP20]] to i16
; CHECK-NEXT:    [[TMP22:%.*]] = sext i16 [[TMP21]] to i32
; CHECK-NEXT:    [[LD_A_3:%.*]] = load i16, ptr [[ADDR_A_3]], align 2
; CHECK-NEXT:    [[SEXT_A_2:%.*]] = sext i16 [[LD_A_2]] to i32
; CHECK-NEXT:    [[SEXT_A_3:%.*]] = sext i16 [[LD_A_3]] to i32
; CHECK-NEXT:    [[MUL_2:%.*]] = mul i32 [[TMP11]], [[TMP22]]
; CHECK-NEXT:    [[MUL_3:%.*]] = mul i32 [[TMP14]], [[TMP19]]
; CHECK-NEXT:    [[ADD_1:%.*]] = add i32 [[MUL_2]], [[MUL_3]]
; CHECK-NEXT:    [[ADD_2:%.*]] = add i32 [[ADD]], [[ADD_1]]
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[ADD_2]], [[ACC]]
; CHECK-NEXT:    ret i32 [[TMP18]]
;
entry:
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %ld.a.1 = load i16, ptr %addr.a.1
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %mul.0 = mul i32 %sext.a.0, %sext.b.0
  %mul.1 = mul i32 %sext.a.1, %sext.b.1
  %add = add i32 %mul.0, %mul.1
  %addr.a.2 = getelementptr i16, ptr %a, i32 2
  %addr.a.3 = getelementptr i16, ptr %a, i32 3
  %ld.a.2 = load i16, ptr %addr.a.2
  %ld.a.3 = load i16, ptr %addr.a.3
  %sext.a.2 = sext i16 %ld.a.2 to i32
  %sext.a.3 = sext i16 %ld.a.3 to i32
  %mul.2 = mul i32 %sext.b.0, %sext.a.3
  %mul.3 = mul i32 %sext.b.1, %sext.a.2
  %add.1 = add i32 %mul.2, %mul.3
  %add.2 = add i32 %add, %add.1
  %res = add i32 %add.2, %acc
  ret i32 %res
}

; TODO: Why aren't two intrinsics generated?
define i32 @exchange_multi_use_3(ptr %a, ptr %b, i32 %acc) {
; CHECK-LABEL: @exchange_multi_use_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADDR_A_1:%.*]] = getelementptr i16, ptr [[A:%.*]], i32 1
; CHECK-NEXT:    [[ADDR_B_1:%.*]] = getelementptr i16, ptr [[B:%.*]], i32 1
; CHECK-NEXT:    [[LD_A_0:%.*]] = load i16, ptr [[A]], align 2
; CHECK-NEXT:    [[SEXT_A_0:%.*]] = sext i16 [[LD_A_0]] to i32
; CHECK-NEXT:    [[LD_B_0:%.*]] = load i16, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i16
; CHECK-NEXT:    [[TMP3:%.*]] = sext i16 [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 16
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[TMP4]] to i16
; CHECK-NEXT:    [[TMP6:%.*]] = sext i16 [[TMP5]] to i32
; CHECK-NEXT:    [[LD_A_1:%.*]] = load i16, ptr [[ADDR_A_1]], align 2
; CHECK-NEXT:    [[LD_B_1:%.*]] = load i16, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[SEXT_A_1:%.*]] = sext i16 [[LD_A_1]] to i32
; CHECK-NEXT:    [[SEXT_B_1:%.*]] = sext i16 [[LD_B_1]] to i32
; CHECK-NEXT:    [[SEXT_B_0:%.*]] = sext i16 [[LD_B_0]] to i32
; CHECK-NEXT:    [[ADDR_A_2:%.*]] = getelementptr i16, ptr [[A]], i32 2
; CHECK-NEXT:    [[ADDR_A_3:%.*]] = getelementptr i16, ptr [[A]], i32 3
; CHECK-NEXT:    [[LD_A_2:%.*]] = load i16, ptr [[ADDR_A_2]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[ADDR_A_2]], align 2
; CHECK-NEXT:    [[TMP9:%.*]] = trunc i32 [[TMP8]] to i16
; CHECK-NEXT:    [[TMP10:%.*]] = call i32 @llvm.arm.smladx(i32 [[TMP1]], i32 [[TMP8]], i32 0)
; CHECK-NEXT:    [[TMP11:%.*]] = sext i16 [[TMP9]] to i32
; CHECK-NEXT:    [[TMP12:%.*]] = lshr i32 [[TMP8]], 16
; CHECK-NEXT:    [[TMP13:%.*]] = trunc i32 [[TMP12]] to i16
; CHECK-NEXT:    [[TMP14:%.*]] = sext i16 [[TMP13]] to i32
; CHECK-NEXT:    [[LD_A_3:%.*]] = load i16, ptr [[ADDR_A_3]], align 2
; CHECK-NEXT:    [[SEXT_A_2:%.*]] = sext i16 [[LD_A_2]] to i32
; CHECK-NEXT:    [[SEXT_A_3:%.*]] = sext i16 [[LD_A_3]] to i32
; CHECK-NEXT:    [[MUL_2:%.*]] = mul i32 [[TMP3]], [[TMP14]]
; CHECK-NEXT:    [[MUL_3:%.*]] = mul i32 [[TMP6]], [[TMP11]]
; CHECK-NEXT:    [[MUL_0:%.*]] = mul i32 [[SEXT_A_0]], [[TMP3]]
; CHECK-NEXT:    [[MUL_1:%.*]] = mul i32 [[SEXT_A_1]], [[TMP6]]
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[MUL_0]], [[MUL_1]]
; CHECK-NEXT:    [[ADD_1:%.*]] = add i32 [[MUL_2]], [[MUL_3]]
; CHECK-NEXT:    [[SUB:%.*]] = sub i32 [[ADD]], [[TMP10]]
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[ACC:%.*]], [[SUB]]
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %ld.a.1 = load i16, ptr %addr.a.1
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %addr.a.2 = getelementptr i16, ptr %a, i32 2
  %addr.a.3 = getelementptr i16, ptr %a, i32 3
  %ld.a.2 = load i16, ptr %addr.a.2
  %ld.a.3 = load i16, ptr %addr.a.3
  %sext.a.2 = sext i16 %ld.a.2 to i32
  %sext.a.3 = sext i16 %ld.a.3 to i32
  %mul.2 = mul i32 %sext.b.0, %sext.a.3
  %mul.3 = mul i32 %sext.b.1, %sext.a.2
  %mul.0 = mul i32 %sext.a.0, %sext.b.0
  %mul.1 = mul i32 %sext.a.1, %sext.b.1
  %add = add i32 %mul.0, %mul.1
  %add.1 = add i32 %mul.2, %mul.3
  %sub = sub i32 %add, %add.1
  %res = add i32 %acc, %sub
  ret i32 %res
}

; TODO: Would it be better to generate a smlad and then sign extend it?
define i64 @exchange_multi_use_64_3(ptr %a, ptr %b, i64 %acc) {
; CHECK-LABEL: @exchange_multi_use_64_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADDR_A_1:%.*]] = getelementptr i16, ptr [[A:%.*]], i32 1
; CHECK-NEXT:    [[ADDR_B_1:%.*]] = getelementptr i16, ptr [[B:%.*]], i32 1
; CHECK-NEXT:    [[LD_A_0:%.*]] = load i16, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i16
; CHECK-NEXT:    [[TMP3:%.*]] = sext i16 [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 16
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[TMP4]] to i16
; CHECK-NEXT:    [[TMP6:%.*]] = sext i16 [[TMP5]] to i32
; CHECK-NEXT:    [[SEXT_A_0:%.*]] = sext i16 [[LD_A_0]] to i32
; CHECK-NEXT:    [[LD_B_0:%.*]] = load i16, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP9:%.*]] = trunc i32 [[TMP8]] to i16
; CHECK-NEXT:    [[TMP10:%.*]] = sext i16 [[TMP9]] to i32
; CHECK-NEXT:    [[TMP11:%.*]] = lshr i32 [[TMP8]], 16
; CHECK-NEXT:    [[TMP12:%.*]] = trunc i32 [[TMP11]] to i16
; CHECK-NEXT:    [[TMP13:%.*]] = sext i16 [[TMP12]] to i32
; CHECK-NEXT:    [[LD_A_1:%.*]] = load i16, ptr [[ADDR_A_1]], align 2
; CHECK-NEXT:    [[LD_B_1:%.*]] = load i16, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[SEXT_A_1:%.*]] = sext i16 [[LD_A_1]] to i32
; CHECK-NEXT:    [[SEXT_B_1:%.*]] = sext i16 [[LD_B_1]] to i32
; CHECK-NEXT:    [[SEXT_B_0:%.*]] = sext i16 [[LD_B_0]] to i32
; CHECK-NEXT:    [[ADDR_A_2:%.*]] = getelementptr i16, ptr [[A]], i32 2
; CHECK-NEXT:    [[ADDR_A_3:%.*]] = getelementptr i16, ptr [[A]], i32 3
; CHECK-NEXT:    [[LD_A_2:%.*]] = load i16, ptr [[ADDR_A_2]], align 2
; CHECK-NEXT:    [[TMP15:%.*]] = load i32, ptr [[ADDR_A_2]], align 2
; CHECK-NEXT:    [[TMP16:%.*]] = trunc i32 [[TMP15]] to i16
; CHECK-NEXT:    [[TMP17:%.*]] = call i64 @llvm.arm.smlaldx(i32 [[TMP8]], i32 [[TMP15]], i64 0)
; CHECK-NEXT:    [[TMP18:%.*]] = call i64 @llvm.arm.smlald(i32 [[TMP1]], i32 [[TMP8]], i64 [[TMP17]])
; CHECK-NEXT:    [[TMP19:%.*]] = sext i16 [[TMP16]] to i32
; CHECK-NEXT:    [[TMP20:%.*]] = lshr i32 [[TMP15]], 16
; CHECK-NEXT:    [[TMP21:%.*]] = trunc i32 [[TMP20]] to i16
; CHECK-NEXT:    [[TMP22:%.*]] = sext i16 [[TMP21]] to i32
; CHECK-NEXT:    [[LD_A_3:%.*]] = load i16, ptr [[ADDR_A_3]], align 2
; CHECK-NEXT:    [[SEXT_A_2:%.*]] = sext i16 [[LD_A_2]] to i32
; CHECK-NEXT:    [[SEXT_A_3:%.*]] = sext i16 [[LD_A_3]] to i32
; CHECK-NEXT:    [[MUL_2:%.*]] = mul i32 [[TMP10]], [[TMP22]]
; CHECK-NEXT:    [[MUL_3:%.*]] = mul i32 [[TMP13]], [[TMP19]]
; CHECK-NEXT:    [[MUL_0:%.*]] = mul i32 [[TMP3]], [[TMP10]]
; CHECK-NEXT:    [[MUL_1:%.*]] = mul i32 [[TMP6]], [[TMP13]]
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[MUL_0]], [[MUL_1]]
; CHECK-NEXT:    [[ADD_1:%.*]] = add i32 [[MUL_2]], [[MUL_3]]
; CHECK-NEXT:    [[SEXT_ADD:%.*]] = sext i32 [[ADD]] to i64
; CHECK-NEXT:    [[SEXT_ADD_1:%.*]] = sext i32 [[ADD_1]] to i64
; CHECK-NEXT:    [[ADD_2:%.*]] = add i64 [[SEXT_ADD]], [[SEXT_ADD_1]]
; CHECK-NEXT:    [[RES:%.*]] = sub i64 [[ACC:%.*]], [[TMP18]]
; CHECK-NEXT:    ret i64 [[RES]]
;
entry:
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %ld.a.1 = load i16, ptr %addr.a.1
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %addr.a.2 = getelementptr i16, ptr %a, i32 2
  %addr.a.3 = getelementptr i16, ptr %a, i32 3
  %ld.a.2 = load i16, ptr %addr.a.2
  %ld.a.3 = load i16, ptr %addr.a.3
  %sext.a.2 = sext i16 %ld.a.2 to i32
  %sext.a.3 = sext i16 %ld.a.3 to i32
  %mul.2 = mul i32 %sext.b.0, %sext.a.3
  %mul.3 = mul i32 %sext.b.1, %sext.a.2
  %mul.0 = mul i32 %sext.a.0, %sext.b.0
  %mul.1 = mul i32 %sext.a.1, %sext.b.1
  %add = add i32 %mul.0, %mul.1
  %add.1 = add i32 %mul.2, %mul.3
  %sext.add = sext i32 %add to i64
  %sext.add.1 = sext i32 %add.1 to i64
  %add.2 = add i64 %sext.add, %sext.add.1
  %res = sub i64 %acc, %add.2
  ret i64 %res
}

; TODO: Why isn't smladx generated too?
define i32 @exchange_multi_use_4(ptr %a, ptr %b, i32 %acc) {
; CHECK-LABEL: @exchange_multi_use_4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADDR_A_1:%.*]] = getelementptr i16, ptr [[A:%.*]], i32 1
; CHECK-NEXT:    [[ADDR_B_1:%.*]] = getelementptr i16, ptr [[B:%.*]], i32 1
; CHECK-NEXT:    [[LD_A_0:%.*]] = load i16, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i16
; CHECK-NEXT:    [[TMP3:%.*]] = sext i16 [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 16
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[TMP4]] to i16
; CHECK-NEXT:    [[TMP6:%.*]] = sext i16 [[TMP5]] to i32
; CHECK-NEXT:    [[SEXT_A_0:%.*]] = sext i16 [[LD_A_0]] to i32
; CHECK-NEXT:    [[LD_B_0:%.*]] = load i16, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP9:%.*]] = trunc i32 [[TMP8]] to i16
; CHECK-NEXT:    [[TMP10:%.*]] = call i32 @llvm.arm.smlad(i32 [[TMP1]], i32 [[TMP8]], i32 0)
; CHECK-NEXT:    [[TMP11:%.*]] = sext i16 [[TMP9]] to i32
; CHECK-NEXT:    [[TMP12:%.*]] = lshr i32 [[TMP8]], 16
; CHECK-NEXT:    [[TMP13:%.*]] = trunc i32 [[TMP12]] to i16
; CHECK-NEXT:    [[TMP14:%.*]] = sext i16 [[TMP13]] to i32
; CHECK-NEXT:    [[LD_A_1:%.*]] = load i16, ptr [[ADDR_A_1]], align 2
; CHECK-NEXT:    [[LD_B_1:%.*]] = load i16, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[SEXT_A_1:%.*]] = sext i16 [[LD_A_1]] to i32
; CHECK-NEXT:    [[SEXT_B_1:%.*]] = sext i16 [[LD_B_1]] to i32
; CHECK-NEXT:    [[SEXT_B_0:%.*]] = sext i16 [[LD_B_0]] to i32
; CHECK-NEXT:    [[ADDR_A_2:%.*]] = getelementptr i16, ptr [[A]], i32 2
; CHECK-NEXT:    [[ADDR_A_3:%.*]] = getelementptr i16, ptr [[A]], i32 3
; CHECK-NEXT:    [[LD_A_2:%.*]] = load i16, ptr [[ADDR_A_2]], align 2
; CHECK-NEXT:    [[LD_A_3:%.*]] = load i16, ptr [[ADDR_A_3]], align 2
; CHECK-NEXT:    [[SEXT_A_2:%.*]] = sext i16 [[LD_A_2]] to i32
; CHECK-NEXT:    [[SEXT_A_3:%.*]] = sext i16 [[LD_A_3]] to i32
; CHECK-NEXT:    [[MUL_2:%.*]] = mul i32 [[TMP11]], [[SEXT_A_3]]
; CHECK-NEXT:    [[MUL_3:%.*]] = mul i32 [[TMP14]], [[SEXT_A_2]]
; CHECK-NEXT:    [[MUL_0:%.*]] = mul i32 [[TMP3]], [[TMP11]]
; CHECK-NEXT:    [[MUL_1:%.*]] = mul i32 [[TMP6]], [[TMP14]]
; CHECK-NEXT:    [[ADD_1:%.*]] = add i32 [[MUL_2]], [[MUL_3]]
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[MUL_0]], [[MUL_1]]
; CHECK-NEXT:    [[SUB:%.*]] = sub i32 [[TMP10]], [[ADD_1]]
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[ACC:%.*]], [[SUB]]
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %ld.a.1 = load i16, ptr %addr.a.1
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %addr.a.2 = getelementptr i16, ptr %a, i32 2
  %addr.a.3 = getelementptr i16, ptr %a, i32 3
  %ld.a.2 = load i16, ptr %addr.a.2
  %ld.a.3 = load i16, ptr %addr.a.3
  %sext.a.2 = sext i16 %ld.a.2 to i32
  %sext.a.3 = sext i16 %ld.a.3 to i32
  %mul.2 = mul i32 %sext.b.0, %sext.a.3
  %mul.3 = mul i32 %sext.b.1, %sext.a.2
  %mul.0 = mul i32 %sext.a.0, %sext.b.0
  %mul.1 = mul i32 %sext.a.1, %sext.b.1
  %add.1 = add i32 %mul.2, %mul.3
  %add = add i32 %mul.0, %mul.1
  %sub = sub i32 %add, %add.1
  %res = add i32 %acc, %sub
  ret i32 %res
}

define i32 @exchange_swap(ptr %a, ptr %b, i32 %acc) {
; CHECK-LABEL: @exchange_swap(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADDR_A_1:%.*]] = getelementptr i16, ptr [[A:%.*]], i32 1
; CHECK-NEXT:    [[ADDR_B_1:%.*]] = getelementptr i16, ptr [[B:%.*]], i32 1
; CHECK-NEXT:    [[LD_A_0:%.*]] = load i16, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i16
; CHECK-NEXT:    [[TMP3:%.*]] = sext i16 [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 16
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[TMP4]] to i16
; CHECK-NEXT:    [[TMP6:%.*]] = sext i16 [[TMP5]] to i32
; CHECK-NEXT:    [[SEXT_A_0:%.*]] = sext i16 [[LD_A_0]] to i32
; CHECK-NEXT:    [[LD_B_0:%.*]] = load i16, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP9:%.*]] = trunc i32 [[TMP8]] to i16
; CHECK-NEXT:    [[TMP10:%.*]] = call i32 @llvm.arm.smladx(i32 [[TMP8]], i32 [[TMP1]], i32 [[ACC:%.*]])
; CHECK-NEXT:    [[TMP11:%.*]] = sext i16 [[TMP9]] to i32
; CHECK-NEXT:    [[TMP12:%.*]] = lshr i32 [[TMP8]], 16
; CHECK-NEXT:    [[TMP13:%.*]] = trunc i32 [[TMP12]] to i16
; CHECK-NEXT:    [[TMP14:%.*]] = sext i16 [[TMP13]] to i32
; CHECK-NEXT:    [[LD_A_1:%.*]] = load i16, ptr [[ADDR_A_1]], align 2
; CHECK-NEXT:    [[LD_B_1:%.*]] = load i16, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[SEXT_A_1:%.*]] = sext i16 [[LD_A_1]] to i32
; CHECK-NEXT:    [[SEXT_B_1:%.*]] = sext i16 [[LD_B_1]] to i32
; CHECK-NEXT:    [[SEXT_B_0:%.*]] = sext i16 [[LD_B_0]] to i32
; CHECK-NEXT:    [[MUL_0:%.*]] = mul i32 [[TMP6]], [[TMP11]]
; CHECK-NEXT:    [[MUL_1:%.*]] = mul i32 [[TMP3]], [[TMP14]]
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[MUL_0]], [[MUL_1]]
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[ADD]], [[ACC]]
; CHECK-NEXT:    ret i32 [[TMP10]]
;
entry:
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %ld.a.1 = load i16, ptr %addr.a.1
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %mul.0 = mul i32 %sext.a.1, %sext.b.0
  %mul.1 = mul i32 %sext.a.0, %sext.b.1
  %add = add i32 %mul.0, %mul.1
  %res = add i32 %add, %acc
  ret i32 %res
}

define i32 @exchange_swap_2(ptr %a, ptr %b, i32 %acc) {
; CHECK-LABEL: @exchange_swap_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADDR_A_1:%.*]] = getelementptr i16, ptr [[A:%.*]], i32 1
; CHECK-NEXT:    [[ADDR_B_1:%.*]] = getelementptr i16, ptr [[B:%.*]], i32 1
; CHECK-NEXT:    [[LD_A_0:%.*]] = load i16, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i16
; CHECK-NEXT:    [[TMP3:%.*]] = sext i16 [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 16
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[TMP4]] to i16
; CHECK-NEXT:    [[TMP6:%.*]] = sext i16 [[TMP5]] to i32
; CHECK-NEXT:    [[SEXT_A_0:%.*]] = sext i16 [[LD_A_0]] to i32
; CHECK-NEXT:    [[LD_B_0:%.*]] = load i16, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP9:%.*]] = trunc i32 [[TMP8]] to i16
; CHECK-NEXT:    [[TMP10:%.*]] = call i32 @llvm.arm.smladx(i32 [[TMP1]], i32 [[TMP8]], i32 [[ACC:%.*]])
; CHECK-NEXT:    [[TMP11:%.*]] = sext i16 [[TMP9]] to i32
; CHECK-NEXT:    [[TMP12:%.*]] = lshr i32 [[TMP8]], 16
; CHECK-NEXT:    [[TMP13:%.*]] = trunc i32 [[TMP12]] to i16
; CHECK-NEXT:    [[TMP14:%.*]] = sext i16 [[TMP13]] to i32
; CHECK-NEXT:    [[LD_A_1:%.*]] = load i16, ptr [[ADDR_A_1]], align 2
; CHECK-NEXT:    [[LD_B_1:%.*]] = load i16, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[SEXT_A_1:%.*]] = sext i16 [[LD_A_1]] to i32
; CHECK-NEXT:    [[SEXT_B_1:%.*]] = sext i16 [[LD_B_1]] to i32
; CHECK-NEXT:    [[SEXT_B_0:%.*]] = sext i16 [[LD_B_0]] to i32
; CHECK-NEXT:    [[MUL_0:%.*]] = mul i32 [[TMP6]], [[TMP11]]
; CHECK-NEXT:    [[MUL_1:%.*]] = mul i32 [[TMP3]], [[TMP14]]
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[MUL_1]], [[MUL_0]]
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[ADD]], [[ACC]]
; CHECK-NEXT:    ret i32 [[TMP10]]
;
entry:
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %ld.a.1 = load i16, ptr %addr.a.1
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %mul.0 = mul i32 %sext.a.1, %sext.b.0
  %mul.1 = mul i32 %sext.a.0, %sext.b.1
  %add = add i32 %mul.1, %mul.0
  %res = add i32 %add, %acc
  ret i32 %res
}

define i32 @exchange_swap_3(ptr %a, ptr %b, i32 %acc) {
; CHECK-LABEL: @exchange_swap_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADDR_A_1:%.*]] = getelementptr i16, ptr [[A:%.*]], i32 1
; CHECK-NEXT:    [[ADDR_B_1:%.*]] = getelementptr i16, ptr [[B:%.*]], i32 1
; CHECK-NEXT:    [[LD_A_0:%.*]] = load i16, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A]], align 2
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i32 [[TMP1]] to i16
; CHECK-NEXT:    [[TMP3:%.*]] = sext i16 [[TMP2]] to i32
; CHECK-NEXT:    [[TMP4:%.*]] = lshr i32 [[TMP1]], 16
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i32 [[TMP4]] to i16
; CHECK-NEXT:    [[TMP6:%.*]] = sext i16 [[TMP5]] to i32
; CHECK-NEXT:    [[SEXT_A_0:%.*]] = sext i16 [[LD_A_0]] to i32
; CHECK-NEXT:    [[LD_B_0:%.*]] = load i16, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[B]], align 2
; CHECK-NEXT:    [[TMP9:%.*]] = trunc i32 [[TMP8]] to i16
; CHECK-NEXT:    [[TMP10:%.*]] = call i32 @llvm.arm.smladx(i32 [[TMP1]], i32 [[TMP8]], i32 [[ACC:%.*]])
; CHECK-NEXT:    [[TMP11:%.*]] = sext i16 [[TMP9]] to i32
; CHECK-NEXT:    [[TMP12:%.*]] = lshr i32 [[TMP8]], 16
; CHECK-NEXT:    [[TMP13:%.*]] = trunc i32 [[TMP12]] to i16
; CHECK-NEXT:    [[TMP14:%.*]] = sext i16 [[TMP13]] to i32
; CHECK-NEXT:    [[LD_A_1:%.*]] = load i16, ptr [[ADDR_A_1]], align 2
; CHECK-NEXT:    [[LD_B_1:%.*]] = load i16, ptr [[ADDR_B_1]], align 2
; CHECK-NEXT:    [[SEXT_A_1:%.*]] = sext i16 [[LD_A_1]] to i32
; CHECK-NEXT:    [[SEXT_B_1:%.*]] = sext i16 [[LD_B_1]] to i32
; CHECK-NEXT:    [[SEXT_B_0:%.*]] = sext i16 [[LD_B_0]] to i32
; CHECK-NEXT:    [[MUL_0:%.*]] = mul i32 [[TMP11]], [[TMP6]]
; CHECK-NEXT:    [[MUL_1:%.*]] = mul i32 [[TMP14]], [[TMP3]]
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[MUL_1]], [[MUL_0]]
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[ADD]], [[ACC]]
; CHECK-NEXT:    ret i32 [[TMP10]]
;
entry:
  %addr.a.1 = getelementptr i16, ptr %a, i32 1
  %addr.b.1 = getelementptr i16, ptr %b, i32 1
  %ld.a.0 = load i16, ptr %a
  %sext.a.0 = sext i16 %ld.a.0 to i32
  %ld.b.0 = load i16, ptr %b
  %ld.a.1 = load i16, ptr %addr.a.1
  %ld.b.1 = load i16, ptr %addr.b.1
  %sext.a.1 = sext i16 %ld.a.1 to i32
  %sext.b.1 = sext i16 %ld.b.1 to i32
  %sext.b.0 = sext i16 %ld.b.0 to i32
  %mul.0 = mul i32 %sext.b.0, %sext.a.1
  %mul.1 = mul i32 %sext.b.1, %sext.a.0
  %add = add i32 %mul.1, %mul.0
  %res = add i32 %add, %acc
  ret i32 %res
}
