; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=hexagon < %s | FileCheck -check-prefix=BASE %s
; RUN: llc -mtriple=hexagon-unknown-linux-gnu < %s | FileCheck -check-prefix=GNU %s
; RUN: llc -mtriple=hexagon-unknown-linux-musl < %s | FileCheck -check-prefix=MUSL %s

define { half, half } @test_sincos_f16(half %a) #0 {
; BASE-LABEL: test_sincos_f16:
; BASE:       // %bb.0:
; BASE-NEXT:    {
; BASE-NEXT:     call __extendhfsf2
; BASE-NEXT:     memd(r29+#-16) = r17:16
; BASE-NEXT:     allocframe(#8)
; BASE-NEXT:    } // 8-byte Folded Spill
; BASE-NEXT:    {
; BASE-NEXT:     call sinf
; BASE-NEXT:     r16 = r0
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call __truncsfhf2
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call cosf
; BASE-NEXT:     r17 = r0
; BASE-NEXT:     r0 = r16
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call __truncsfhf2
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     r1:0 = combine(r0,r17)
; BASE-NEXT:     r17:16 = memd(r29+#0)
; BASE-NEXT:     dealloc_return
; BASE-NEXT:    } // 8-byte Folded Reload
;
; GNU-LABEL: test_sincos_f16:
; GNU:       // %bb.0:
; GNU-NEXT:    {
; GNU-NEXT:     call __extendhfsf2
; GNU-NEXT:     memd(r29+#-16) = r17:16
; GNU-NEXT:     allocframe(#16)
; GNU-NEXT:    } // 8-byte Folded Spill
; GNU-NEXT:    {
; GNU-NEXT:     call sincosf
; GNU-NEXT:     r1 = add(r29,#0)
; GNU-NEXT:     r2 = add(r29,#4)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     call __truncsfhf2
; GNU-NEXT:     r0 = memw(r29+#0)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     call __truncsfhf2
; GNU-NEXT:     r16 = r0
; GNU-NEXT:     r0 = memw(r29+#4)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     r1:0 = combine(r0,r16)
; GNU-NEXT:     r17:16 = memd(r29+#8)
; GNU-NEXT:     dealloc_return
; GNU-NEXT:    } // 8-byte Folded Reload
;
; MUSL-LABEL: test_sincos_f16:
; MUSL:       // %bb.0:
; MUSL-NEXT:    {
; MUSL-NEXT:     call __extendhfsf2
; MUSL-NEXT:     memd(r29+#-16) = r17:16
; MUSL-NEXT:     allocframe(#8)
; MUSL-NEXT:    } // 8-byte Folded Spill
; MUSL-NEXT:    {
; MUSL-NEXT:     call sinf
; MUSL-NEXT:     r16 = r0
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call __truncsfhf2
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call cosf
; MUSL-NEXT:     r17 = r0
; MUSL-NEXT:     r0 = r16
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call __truncsfhf2
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     r1:0 = combine(r0,r17)
; MUSL-NEXT:     r17:16 = memd(r29+#0)
; MUSL-NEXT:     dealloc_return
; MUSL-NEXT:    } // 8-byte Folded Reload
  %result = call { half, half } @llvm.sincos.f16(half %a)
  ret { half, half } %result
}

define half @test_sincos_f16_only_use_sin(half %a) #0 {
; BASE-LABEL: test_sincos_f16_only_use_sin:
; BASE:       // %bb.0:
; BASE-NEXT:    {
; BASE-NEXT:     call __extendhfsf2
; BASE-NEXT:     allocframe(r29,#0):raw
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call sinf
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call __truncsfhf2
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     r31:30 = dealloc_return(r30):raw
; BASE-NEXT:    }
;
; GNU-LABEL: test_sincos_f16_only_use_sin:
; GNU:       // %bb.0:
; GNU-NEXT:    {
; GNU-NEXT:     call __extendhfsf2
; GNU-NEXT:     allocframe(r29,#8):raw
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     call sincosf
; GNU-NEXT:     r1 = add(r29,#0)
; GNU-NEXT:     r2 = add(r29,#4)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     call __truncsfhf2
; GNU-NEXT:     r0 = memw(r29+#0)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     r31:30 = dealloc_return(r30):raw
; GNU-NEXT:    }
;
; MUSL-LABEL: test_sincos_f16_only_use_sin:
; MUSL:       // %bb.0:
; MUSL-NEXT:    {
; MUSL-NEXT:     call __extendhfsf2
; MUSL-NEXT:     allocframe(r29,#0):raw
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call sinf
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call __truncsfhf2
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     r31:30 = dealloc_return(r30):raw
; MUSL-NEXT:    }
  %result = call { half, half } @llvm.sincos.f16(half %a)
  %result.0 = extractvalue { half, half } %result, 0
  ret half %result.0
}

define half @test_sincos_f16_only_use_cos(half %a) #0 {
; BASE-LABEL: test_sincos_f16_only_use_cos:
; BASE:       // %bb.0:
; BASE-NEXT:    {
; BASE-NEXT:     call __extendhfsf2
; BASE-NEXT:     allocframe(r29,#0):raw
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call cosf
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call __truncsfhf2
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     r31:30 = dealloc_return(r30):raw
; BASE-NEXT:    }
;
; GNU-LABEL: test_sincos_f16_only_use_cos:
; GNU:       // %bb.0:
; GNU-NEXT:    {
; GNU-NEXT:     call __extendhfsf2
; GNU-NEXT:     allocframe(r29,#8):raw
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     call sincosf
; GNU-NEXT:     r1 = add(r29,#0)
; GNU-NEXT:     r2 = add(r29,#4)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     call __truncsfhf2
; GNU-NEXT:     r0 = memw(r29+#4)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     r31:30 = dealloc_return(r30):raw
; GNU-NEXT:    }
;
; MUSL-LABEL: test_sincos_f16_only_use_cos:
; MUSL:       // %bb.0:
; MUSL-NEXT:    {
; MUSL-NEXT:     call __extendhfsf2
; MUSL-NEXT:     allocframe(r29,#0):raw
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call cosf
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call __truncsfhf2
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     r31:30 = dealloc_return(r30):raw
; MUSL-NEXT:    }
  %result = call { half, half } @llvm.sincos.f16(half %a)
  %result.1 = extractvalue { half, half } %result, 1
  ret half %result.1
}

define { <2 x half>, <2 x half> } @test_sincos_v2f16(<2 x half> %a) #0 {
; BASE-LABEL: test_sincos_v2f16:
; BASE:       // %bb.0:
; BASE-NEXT:    {
; BASE-NEXT:     r17:16 = combine(r3,r0)
; BASE-NEXT:     r0 = r2
; BASE-NEXT:     memd(r29+#-16) = r17:16
; BASE-NEXT:     allocframe(#24)
; BASE-NEXT:    } // 8-byte Folded Spill
; BASE-NEXT:    {
; BASE-NEXT:     call __extendhfsf2
; BASE-NEXT:     memd(r29+#8) = r19:18
; BASE-NEXT:     memd(r29+#0) = r21:20
; BASE-NEXT:    } // 8-byte Folded Spill
; BASE-NEXT:    {
; BASE-NEXT:     call sinf
; BASE-NEXT:     r18 = r0
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call __truncsfhf2
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call __extendhfsf2
; BASE-NEXT:     r19 = r0
; BASE-NEXT:     r0 = r17
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call sinf
; BASE-NEXT:     r17 = r0
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call __truncsfhf2
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call cosf
; BASE-NEXT:     r20 = r0
; BASE-NEXT:     r0 = r18
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call __truncsfhf2
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call cosf
; BASE-NEXT:     r18 = r0
; BASE-NEXT:     r0 = r17
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call __truncsfhf2
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     memh(r16+#6) = r0
; BASE-NEXT:     memh(r16+#4) = r18
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     memh(r16+#2) = r20
; BASE-NEXT:     memh(r16+#0) = r19
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     r17:16 = memd(r29+#16)
; BASE-NEXT:     r19:18 = memd(r29+#8)
; BASE-NEXT:    } // 8-byte Folded Reload
; BASE-NEXT:    {
; BASE-NEXT:     r21:20 = memd(r29+#0)
; BASE-NEXT:     dealloc_return
; BASE-NEXT:    } // 8-byte Folded Reload
;
; GNU-LABEL: test_sincos_v2f16:
; GNU:       // %bb.0:
; GNU-NEXT:    {
; GNU-NEXT:     r17:16 = combine(r3,r0)
; GNU-NEXT:     r0 = r2
; GNU-NEXT:     memd(r29+#-16) = r17:16
; GNU-NEXT:     allocframe(#32)
; GNU-NEXT:    } // 8-byte Folded Spill
; GNU-NEXT:    {
; GNU-NEXT:     call __extendhfsf2
; GNU-NEXT:     memd(r29+#16) = r19:18
; GNU-NEXT:    } // 8-byte Folded Spill
; GNU-NEXT:    {
; GNU-NEXT:     call sincosf
; GNU-NEXT:     r1 = add(r29,#8)
; GNU-NEXT:     r2 = add(r29,#12)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     call __extendhfsf2
; GNU-NEXT:     r0 = r17
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     call sincosf
; GNU-NEXT:     r1 = add(r29,#0)
; GNU-NEXT:     r2 = add(r29,#4)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     call __truncsfhf2
; GNU-NEXT:     r0 = memw(r29+#8)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     call __truncsfhf2
; GNU-NEXT:     r17 = r0
; GNU-NEXT:     r0 = memw(r29+#0)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     call __truncsfhf2
; GNU-NEXT:     r18 = r0
; GNU-NEXT:     r0 = memw(r29+#12)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     call __truncsfhf2
; GNU-NEXT:     r19 = r0
; GNU-NEXT:     r0 = memw(r29+#4)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     memh(r16+#6) = r0
; GNU-NEXT:     memh(r16+#4) = r19
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     memh(r16+#2) = r18
; GNU-NEXT:     memh(r16+#0) = r17
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     r17:16 = memd(r29+#24)
; GNU-NEXT:     r19:18 = memd(r29+#16)
; GNU-NEXT:    } // 8-byte Folded Reload
; GNU-NEXT:    {
; GNU-NEXT:     r31:30 = dealloc_return(r30):raw
; GNU-NEXT:    }
;
; MUSL-LABEL: test_sincos_v2f16:
; MUSL:       // %bb.0:
; MUSL-NEXT:    {
; MUSL-NEXT:     r17:16 = combine(r3,r0)
; MUSL-NEXT:     r0 = r2
; MUSL-NEXT:     memd(r29+#-16) = r17:16
; MUSL-NEXT:     allocframe(#24)
; MUSL-NEXT:    } // 8-byte Folded Spill
; MUSL-NEXT:    {
; MUSL-NEXT:     call __extendhfsf2
; MUSL-NEXT:     memd(r29+#8) = r19:18
; MUSL-NEXT:     memd(r29+#0) = r21:20
; MUSL-NEXT:    } // 8-byte Folded Spill
; MUSL-NEXT:    {
; MUSL-NEXT:     call sinf
; MUSL-NEXT:     r18 = r0
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call __truncsfhf2
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call __extendhfsf2
; MUSL-NEXT:     r19 = r0
; MUSL-NEXT:     r0 = r17
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call sinf
; MUSL-NEXT:     r17 = r0
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call __truncsfhf2
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call cosf
; MUSL-NEXT:     r20 = r0
; MUSL-NEXT:     r0 = r18
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call __truncsfhf2
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call cosf
; MUSL-NEXT:     r18 = r0
; MUSL-NEXT:     r0 = r17
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call __truncsfhf2
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     memh(r16+#6) = r0
; MUSL-NEXT:     memh(r16+#4) = r18
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     memh(r16+#2) = r20
; MUSL-NEXT:     memh(r16+#0) = r19
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     r17:16 = memd(r29+#16)
; MUSL-NEXT:     r19:18 = memd(r29+#8)
; MUSL-NEXT:    } // 8-byte Folded Reload
; MUSL-NEXT:    {
; MUSL-NEXT:     r21:20 = memd(r29+#0)
; MUSL-NEXT:     dealloc_return
; MUSL-NEXT:    } // 8-byte Folded Reload
  %result = call { <2 x half>, <2 x half> } @llvm.sincos.v2f16(<2 x half> %a)
  ret { <2 x half>, <2 x half> } %result
}

define { float, float } @test_sincos_f32(float %a) #0 {
; BASE-LABEL: test_sincos_f32:
; BASE:       // %bb.0:
; BASE-NEXT:    {
; BASE-NEXT:     call sinf
; BASE-NEXT:     r16 = r0
; BASE-NEXT:     memd(r29+#-16) = r17:16
; BASE-NEXT:     allocframe(#8)
; BASE-NEXT:    } // 8-byte Folded Spill
; BASE-NEXT:    {
; BASE-NEXT:     call cosf
; BASE-NEXT:     r17 = r0
; BASE-NEXT:     r0 = r16
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     r1:0 = combine(r0,r17)
; BASE-NEXT:     r17:16 = memd(r29+#0)
; BASE-NEXT:     dealloc_return
; BASE-NEXT:    } // 8-byte Folded Reload
;
; GNU-LABEL: test_sincos_f32:
; GNU:       // %bb.0:
; GNU-NEXT:    {
; GNU-NEXT:     allocframe(r29,#8):raw
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     call sincosf
; GNU-NEXT:     r1 = add(r29,#0)
; GNU-NEXT:     r2 = add(r29,#4)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     r0 = memw(r29+#0)
; GNU-NEXT:     r1 = memw(r29+#4)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     r31:30 = dealloc_return(r30):raw
; GNU-NEXT:    }
;
; MUSL-LABEL: test_sincos_f32:
; MUSL:       // %bb.0:
; MUSL-NEXT:    {
; MUSL-NEXT:     call sinf
; MUSL-NEXT:     r16 = r0
; MUSL-NEXT:     memd(r29+#-16) = r17:16
; MUSL-NEXT:     allocframe(#8)
; MUSL-NEXT:    } // 8-byte Folded Spill
; MUSL-NEXT:    {
; MUSL-NEXT:     call cosf
; MUSL-NEXT:     r17 = r0
; MUSL-NEXT:     r0 = r16
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     r1:0 = combine(r0,r17)
; MUSL-NEXT:     r17:16 = memd(r29+#0)
; MUSL-NEXT:     dealloc_return
; MUSL-NEXT:    } // 8-byte Folded Reload
  %result = call { float, float } @llvm.sincos.f32(float %a)
  ret { float, float } %result
}

define { <2 x float>, <2 x float> } @test_sincos_v2f32(<2 x float> %a) #0 {
; CHECKR2-LABEL: test_sincos_v2f32:
; CHECKR2:       # %bb.0:
; CHECKR2-NEXT:    daddiu $sp, $sp, -32
; CHECKR2-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; CHECKR2-NEXT:    sd $16, 16($sp) # 8-byte Folded Spill
; CHECKR2-NEXT:    move $16, $4
; CHECKR2-NEXT:    dsrl $1, $4, 32
; CHECKR2-NEXT:    sll $1, $1, 0
; CHECKR2-NEXT:    mtc1 $1, $f12
; CHECKR2-NEXT:    daddiu $5, $sp, 12
; CHECKR2-NEXT:    jal sincosf
; CHECKR2-NEXT:    daddiu $6, $sp, 8
; CHECKR2-NEXT:    sll $1, $16, 0
; CHECKR2-NEXT:    mtc1 $1, $f12
; CHECKR2-NEXT:    daddiu $5, $sp, 4
; CHECKR2-NEXT:    jal sincosf
; CHECKR2-NEXT:    daddiu $6, $sp, 0
; CHECKR2-NEXT:    lwc1 $f0, 12($sp)
; CHECKR2-NEXT:    mfc1 $1, $f0
; CHECKR2-NEXT:    dsll $1, $1, 32
; CHECKR2-NEXT:    lwc1 $f0, 4($sp)
; CHECKR2-NEXT:    mfc1 $2, $f0
; CHECKR2-NEXT:    dext $2, $2, 0, 32
; CHECKR2-NEXT:    lwc1 $f0, 8($sp)
; CHECKR2-NEXT:    or $2, $2, $1
; CHECKR2-NEXT:    mfc1 $1, $f0
; CHECKR2-NEXT:    dsll $1, $1, 32
; CHECKR2-NEXT:    lwc1 $f0, 0($sp)
; CHECKR2-NEXT:    mfc1 $3, $f0
; CHECKR2-NEXT:    dext $3, $3, 0, 32
; CHECKR2-NEXT:    or $3, $3, $1
; CHECKR2-NEXT:    ld $16, 16($sp) # 8-byte Folded Reload
; CHECKR2-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; CHECKR2-NEXT:    jr $ra
; CHECKR2-NEXT:    daddiu $sp, $sp, 32
; BASE-LABEL: test_sincos_v2f32:
; BASE:       // %bb.0:
; BASE-NEXT:    {
; BASE-NEXT:     r17:16 = combine(r0,r2)
; BASE-NEXT:     r0 = r2
; BASE-NEXT:     memd(r29+#-16) = r17:16
; BASE-NEXT:     allocframe(#24)
; BASE-NEXT:    } // 8-byte Folded Spill
; BASE-NEXT:    {
; BASE-NEXT:     call sinf
; BASE-NEXT:     r18 = r3
; BASE-NEXT:     memd(r29+#8) = r19:18
; BASE-NEXT:     memd(r29+#0) = r21:20
; BASE-NEXT:    } // 8-byte Folded Spill
; BASE-NEXT:    {
; BASE-NEXT:     call sinf
; BASE-NEXT:     r19 = r0
; BASE-NEXT:     r0 = r18
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call cosf
; BASE-NEXT:     r20 = r0
; BASE-NEXT:     r0 = r16
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call cosf
; BASE-NEXT:     r16 = r0
; BASE-NEXT:     r0 = r18
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     r1:0 = combine(r0,r16)
; BASE-NEXT:     r3:2 = combine(r20,r19)
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     memd(r17+#8) = r1:0
; BASE-NEXT:     memd(r17+#0) = r3:2
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     r17:16 = memd(r29+#16)
; BASE-NEXT:     r19:18 = memd(r29+#8)
; BASE-NEXT:    } // 8-byte Folded Reload
; BASE-NEXT:    {
; BASE-NEXT:     r21:20 = memd(r29+#0)
; BASE-NEXT:     dealloc_return
; BASE-NEXT:    } // 8-byte Folded Reload
;
; GNU-LABEL: test_sincos_v2f32:
; GNU:       // %bb.0:
; GNU-NEXT:    {
; GNU-NEXT:     r17:16 = combine(r0,r2)
; GNU-NEXT:     r1 = add(r0,#4)
; GNU-NEXT:     memd(r29+#-16) = r17:16
; GNU-NEXT:     allocframe(#8)
; GNU-NEXT:    } // 8-byte Folded Spill
; GNU-NEXT:    {
; GNU-NEXT:     call sincosf
; GNU-NEXT:     r2 = add(r0,#12)
; GNU-NEXT:     r0 = r3
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     call sincosf
; GNU-NEXT:     r2 = add(r17,#8)
; GNU-NEXT:     r1:0 = combine(r17,r16)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     r17:16 = memd(r29+#0)
; GNU-NEXT:     dealloc_return
; GNU-NEXT:    } // 8-byte Folded Reload
;
; MUSL-LABEL: test_sincos_v2f32:
; MUSL:       // %bb.0:
; MUSL-NEXT:    {
; MUSL-NEXT:     r17:16 = combine(r0,r2)
; MUSL-NEXT:     r0 = r2
; MUSL-NEXT:     memd(r29+#-16) = r17:16
; MUSL-NEXT:     allocframe(#24)
; MUSL-NEXT:    } // 8-byte Folded Spill
; MUSL-NEXT:    {
; MUSL-NEXT:     call sinf
; MUSL-NEXT:     r18 = r3
; MUSL-NEXT:     memd(r29+#8) = r19:18
; MUSL-NEXT:     memd(r29+#0) = r21:20
; MUSL-NEXT:    } // 8-byte Folded Spill
; MUSL-NEXT:    {
; MUSL-NEXT:     call sinf
; MUSL-NEXT:     r19 = r0
; MUSL-NEXT:     r0 = r18
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call cosf
; MUSL-NEXT:     r20 = r0
; MUSL-NEXT:     r0 = r16
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call cosf
; MUSL-NEXT:     r16 = r0
; MUSL-NEXT:     r0 = r18
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     r1:0 = combine(r0,r16)
; MUSL-NEXT:     r3:2 = combine(r20,r19)
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     memd(r17+#8) = r1:0
; MUSL-NEXT:     memd(r17+#0) = r3:2
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     r17:16 = memd(r29+#16)
; MUSL-NEXT:     r19:18 = memd(r29+#8)
; MUSL-NEXT:    } // 8-byte Folded Reload
; MUSL-NEXT:    {
; MUSL-NEXT:     r21:20 = memd(r29+#0)
; MUSL-NEXT:     dealloc_return
; MUSL-NEXT:    } // 8-byte Folded Reload
  %result = call { <2 x float>, <2 x float> } @llvm.sincos.v2f32(<2 x float> %a)
  ret { <2 x float>, <2 x float> } %result
}

define { <3 x float>, <3 x float> } @test_sincos_v3f32(<3 x float> %a) #0 {
; CHECKR2-LABEL: test_sincos_v3f32:
; CHECKR2:       # %bb.0:
; CHECKR2-NEXT:    daddiu $sp, $sp, -48
; CHECKR2-NEXT:    sdc1 $f25, 40($sp) # 8-byte Folded Spill
; CHECKR2-NEXT:    sdc1 $f24, 32($sp) # 8-byte Folded Spill
; CHECKR2-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; CHECKR2-NEXT:    sd $16, 16($sp) # 8-byte Folded Spill
; CHECKR2-NEXT:    mov.s $f24, $f15
; CHECKR2-NEXT:    mov.s $f25, $f14
; CHECKR2-NEXT:    mov.s $f12, $f13
; CHECKR2-NEXT:    move $16, $4
; CHECKR2-NEXT:    daddiu $5, $sp, 4
; CHECKR2-NEXT:    jal sincosf
; CHECKR2-NEXT:    daddiu $6, $sp, 0
; CHECKR2-NEXT:    daddiu $5, $sp, 12
; CHECKR2-NEXT:    daddiu $6, $sp, 8
; CHECKR2-NEXT:    jal sincosf
; CHECKR2-NEXT:    mov.s $f12, $f25
; CHECKR2-NEXT:    daddiu $5, $16, 8
; CHECKR2-NEXT:    daddiu $6, $16, 24
; CHECKR2-NEXT:    jal sincosf
; CHECKR2-NEXT:    mov.s $f12, $f24
; CHECKR2-NEXT:    lwc1 $f0, 0($sp)
; CHECKR2-NEXT:    mfc1 $1, $f0
; CHECKR2-NEXT:    dsll $1, $1, 32
; CHECKR2-NEXT:    lwc1 $f0, 8($sp)
; CHECKR2-NEXT:    mfc1 $2, $f0
; CHECKR2-NEXT:    dext $2, $2, 0, 32
; CHECKR2-NEXT:    or $1, $2, $1
; CHECKR2-NEXT:    lwc1 $f0, 4($sp)
; CHECKR2-NEXT:    mfc1 $2, $f0
; CHECKR2-NEXT:    sd $1, 16($16)
; CHECKR2-NEXT:    dsll $1, $2, 32
; CHECKR2-NEXT:    lwc1 $f0, 12($sp)
; CHECKR2-NEXT:    mfc1 $2, $f0
; CHECKR2-NEXT:    dext $2, $2, 0, 32
; CHECKR2-NEXT:    or $1, $2, $1
; CHECKR2-NEXT:    sd $1, 0($16)
; CHECKR2-NEXT:    ld $16, 16($sp) # 8-byte Folded Reload
; CHECKR2-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; CHECKR2-NEXT:    ldc1 $f24, 32($sp) # 8-byte Folded Reload
; CHECKR2-NEXT:    ldc1 $f25, 40($sp) # 8-byte Folded Reload
; CHECKR2-NEXT:    jr $ra
; CHECKR2-NEXT:    daddiu $sp, $sp, 48
; BASE-LABEL: test_sincos_v3f32:
; BASE:       // %bb.0:
; BASE-NEXT:    {
; BASE-NEXT:     memd(r29+#-16) = r17:16
; BASE-NEXT:     allocframe(#32)
; BASE-NEXT:    } // 8-byte Folded Spill
; BASE-NEXT:    {
; BASE-NEXT:     r19:18 = combine(r0,r2)
; BASE-NEXT:     r0 = r2
; BASE-NEXT:     memd(r29+#16) = r19:18
; BASE-NEXT:     memd(r29+#8) = r21:20
; BASE-NEXT:    } // 8-byte Folded Spill
; BASE-NEXT:    {
; BASE-NEXT:     call sinf
; BASE-NEXT:     r21:20 = combine(r3,r4)
; BASE-NEXT:     memd(r29+#0) = r23:22
; BASE-NEXT:    } // 8-byte Folded Spill
; BASE-NEXT:    {
; BASE-NEXT:     call sinf
; BASE-NEXT:     r16 = r0
; BASE-NEXT:     r0 = r21
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call cosf
; BASE-NEXT:     r17 = r0
; BASE-NEXT:     r0 = r18
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call cosf
; BASE-NEXT:     r22 = r0
; BASE-NEXT:     r0 = r21
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call sinf
; BASE-NEXT:     r23 = r0
; BASE-NEXT:     r0 = r20
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call cosf
; BASE-NEXT:     r18 = r0
; BASE-NEXT:     r0 = r20
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     memw(r19+#24) = r0
; BASE-NEXT:     memd(r19+#16) = r23:22
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     memw(r19+#8) = r18
; BASE-NEXT:     memd(r19+#0) = r17:16
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     r17:16 = memd(r29+#24)
; BASE-NEXT:     r19:18 = memd(r29+#16)
; BASE-NEXT:    } // 8-byte Folded Reload
; BASE-NEXT:    {
; BASE-NEXT:     r21:20 = memd(r29+#8)
; BASE-NEXT:     r23:22 = memd(r29+#0)
; BASE-NEXT:    } // 8-byte Folded Reload
; BASE-NEXT:    {
; BASE-NEXT:     r31:30 = dealloc_return(r30):raw
; BASE-NEXT:    }
;
; GNU-LABEL: test_sincos_v3f32:
; GNU:       // %bb.0:
; GNU-NEXT:    {
; GNU-NEXT:     r17:16 = combine(r4,r0)
; GNU-NEXT:     r0 = r2
; GNU-NEXT:     memd(r29+#-16) = r17:16
; GNU-NEXT:     allocframe(#32)
; GNU-NEXT:    } // 8-byte Folded Spill
; GNU-NEXT:    {
; GNU-NEXT:     r2 = add(r29,#12)
; GNU-NEXT:     r18 = r3
; GNU-NEXT:     r1 = add(r29,#8)
; GNU-NEXT:     memd(r29+#16) = r19:18
; GNU-NEXT:    } // 8-byte Folded Spill
; GNU-NEXT:    {
; GNU-NEXT:     call sincosf
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     call sincosf
; GNU-NEXT:     r1 = add(r29,#0)
; GNU-NEXT:     r2 = add(r29,#4)
; GNU-NEXT:     r0 = r18
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     call sincosf
; GNU-NEXT:     r1 = add(r16,#8)
; GNU-NEXT:     r2 = add(r16,#24)
; GNU-NEXT:     r0 = r17
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     r0 = memw(r29+#8)
; GNU-NEXT:     r1 = memw(r29+#0)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     r2 = memw(r29+#12)
; GNU-NEXT:     r3 = memw(r29+#4)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     memd(r16+#16) = r3:2
; GNU-NEXT:     memd(r16+#0) = r1:0
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     r17:16 = memd(r29+#24)
; GNU-NEXT:     r19:18 = memd(r29+#16)
; GNU-NEXT:    } // 8-byte Folded Reload
; GNU-NEXT:    {
; GNU-NEXT:     r31:30 = dealloc_return(r30):raw
; GNU-NEXT:    }
;
; MUSL-LABEL: test_sincos_v3f32:
; MUSL:       // %bb.0:
; MUSL-NEXT:    {
; MUSL-NEXT:     memd(r29+#-16) = r17:16
; MUSL-NEXT:     allocframe(#32)
; MUSL-NEXT:    } // 8-byte Folded Spill
; MUSL-NEXT:    {
; MUSL-NEXT:     r19:18 = combine(r0,r2)
; MUSL-NEXT:     r0 = r2
; MUSL-NEXT:     memd(r29+#16) = r19:18
; MUSL-NEXT:     memd(r29+#8) = r21:20
; MUSL-NEXT:    } // 8-byte Folded Spill
; MUSL-NEXT:    {
; MUSL-NEXT:     call sinf
; MUSL-NEXT:     r21:20 = combine(r3,r4)
; MUSL-NEXT:     memd(r29+#0) = r23:22
; MUSL-NEXT:    } // 8-byte Folded Spill
; MUSL-NEXT:    {
; MUSL-NEXT:     call sinf
; MUSL-NEXT:     r16 = r0
; MUSL-NEXT:     r0 = r21
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call cosf
; MUSL-NEXT:     r17 = r0
; MUSL-NEXT:     r0 = r18
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call cosf
; MUSL-NEXT:     r22 = r0
; MUSL-NEXT:     r0 = r21
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call sinf
; MUSL-NEXT:     r23 = r0
; MUSL-NEXT:     r0 = r20
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call cosf
; MUSL-NEXT:     r18 = r0
; MUSL-NEXT:     r0 = r20
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     memw(r19+#24) = r0
; MUSL-NEXT:     memd(r19+#16) = r23:22
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     memw(r19+#8) = r18
; MUSL-NEXT:     memd(r19+#0) = r17:16
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     r17:16 = memd(r29+#24)
; MUSL-NEXT:     r19:18 = memd(r29+#16)
; MUSL-NEXT:    } // 8-byte Folded Reload
; MUSL-NEXT:    {
; MUSL-NEXT:     r21:20 = memd(r29+#8)
; MUSL-NEXT:     r23:22 = memd(r29+#0)
; MUSL-NEXT:    } // 8-byte Folded Reload
; MUSL-NEXT:    {
; MUSL-NEXT:     r31:30 = dealloc_return(r30):raw
; MUSL-NEXT:    }
  %result = call { <3 x float>, <3 x float> } @llvm.sincos.v3f32(<3 x float> %a)
  ret { <3 x float>, <3 x float> } %result
}

define { double, double } @test_sincos_f64(double %a) #0 {
; BASE-LABEL: test_sincos_f64:
; BASE:       // %bb.0:
; BASE-NEXT:    {
; BASE-NEXT:     r17:16 = combine(r3,r2)
; BASE-NEXT:     memd(r29+#-16) = r17:16
; BASE-NEXT:     allocframe(#24)
; BASE-NEXT:    } // 8-byte Folded Spill
; BASE-NEXT:    {
; BASE-NEXT:     r18 = r0
; BASE-NEXT:     r1:0 = combine(r3,r2)
; BASE-NEXT:     memd(r29+#8) = r19:18
; BASE-NEXT:     memd(r29+#0) = r21:20
; BASE-NEXT:    } // 8-byte Folded Spill
; BASE-NEXT:    {
; BASE-NEXT:     call sin
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call cos
; BASE-NEXT:     r21:20 = combine(r1,r0)
; BASE-NEXT:     r1:0 = combine(r17,r16)
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     memd(r18+#8) = r1:0
; BASE-NEXT:     memd(r18+#0) = r21:20
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     r17:16 = memd(r29+#16)
; BASE-NEXT:     r19:18 = memd(r29+#8)
; BASE-NEXT:    } // 8-byte Folded Reload
; BASE-NEXT:    {
; BASE-NEXT:     r21:20 = memd(r29+#0)
; BASE-NEXT:     dealloc_return
; BASE-NEXT:    } // 8-byte Folded Reload
;
; GNU-LABEL: test_sincos_f64:
; GNU:       // %bb.0:
; GNU-NEXT:    {
; GNU-NEXT:     r5:4 = combine(r3,r2)
; GNU-NEXT:     r3 = add(r0,#8)
; GNU-NEXT:     r2 = r0
; GNU-NEXT:     allocframe(#0)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     call sincos
; GNU-NEXT:     r1:0 = combine(r5,r4)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     r31:30 = dealloc_return(r30):raw
; GNU-NEXT:    }
;
; MUSL-LABEL: test_sincos_f64:
; MUSL:       // %bb.0:
; MUSL-NEXT:    {
; MUSL-NEXT:     r17:16 = combine(r3,r2)
; MUSL-NEXT:     memd(r29+#-16) = r17:16
; MUSL-NEXT:     allocframe(#24)
; MUSL-NEXT:    } // 8-byte Folded Spill
; MUSL-NEXT:    {
; MUSL-NEXT:     r18 = r0
; MUSL-NEXT:     r1:0 = combine(r3,r2)
; MUSL-NEXT:     memd(r29+#8) = r19:18
; MUSL-NEXT:     memd(r29+#0) = r21:20
; MUSL-NEXT:    } // 8-byte Folded Spill
; MUSL-NEXT:    {
; MUSL-NEXT:     call sin
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call cos
; MUSL-NEXT:     r21:20 = combine(r1,r0)
; MUSL-NEXT:     r1:0 = combine(r17,r16)
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     memd(r18+#8) = r1:0
; MUSL-NEXT:     memd(r18+#0) = r21:20
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     r17:16 = memd(r29+#16)
; MUSL-NEXT:     r19:18 = memd(r29+#8)
; MUSL-NEXT:    } // 8-byte Folded Reload
; MUSL-NEXT:    {
; MUSL-NEXT:     r21:20 = memd(r29+#0)
; MUSL-NEXT:     dealloc_return
; MUSL-NEXT:    } // 8-byte Folded Reload
  %result = call { double, double } @llvm.sincos.f64(double %a)
  ret { double, double } %result
}

define { <2 x double>, <2 x double> } @test_sincos_v2f64(<2 x double> %a) #0 {
; CHECKR2-LABEL: test_sincos_v2f64:
; CHECKR2:       # %bb.0:
; CHECKR2-NEXT:    addiu $sp, $sp, -32
; CHECKR2-NEXT:    sw $ra, 28($sp) # 4-byte Folded Spill
; CHECKR2-NEXT:    sw $18, 24($sp) # 4-byte Folded Spill
; CHECKR2-NEXT:    sw $17, 20($sp) # 4-byte Folded Spill
; CHECKR2-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; CHECKR2-NEXT:    move $16, $7
; CHECKR2-NEXT:    move $17, $6
; CHECKR2-NEXT:    move $18, $4
; CHECKR2-NEXT:    lw $1, 48($sp)
; CHECKR2-NEXT:    lw $2, 52($sp)
; CHECKR2-NEXT:    mtc1 $2, $f12
; CHECKR2-NEXT:    mthc1 $1, $f12
; CHECKR2-NEXT:    addiu $6, $4, 8
; CHECKR2-NEXT:    jal sincos
; CHECKR2-NEXT:    addiu $7, $4, 24
; CHECKR2-NEXT:    mtc1 $16, $f12
; CHECKR2-NEXT:    mthc1 $17, $f12
; CHECKR2-NEXT:    addiu $7, $18, 16
; CHECKR2-NEXT:    jal sincos
; CHECKR2-NEXT:    move $6, $18
; CHECKR2-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; CHECKR2-NEXT:    lw $17, 20($sp) # 4-byte Folded Reload
; CHECKR2-NEXT:    lw $18, 24($sp) # 4-byte Folded Reload
; CHECKR2-NEXT:    lw $ra, 28($sp) # 4-byte Folded Reload
; CHECKR2-NEXT:    jr $ra
; CHECKR2-NEXT:    addiu $sp, $sp, 32
; BASE-LABEL: test_sincos_v2f64:
; BASE:       // %bb.0:
; BASE-NEXT:    {
; BASE-NEXT:     r17:16 = combine(r3,r2)
; BASE-NEXT:     memd(r29+#-16) = r17:16
; BASE-NEXT:     allocframe(#40)
; BASE-NEXT:    } // 8-byte Folded Spill
; BASE-NEXT:    {
; BASE-NEXT:     r18 = r0
; BASE-NEXT:     r1:0 = combine(r3,r2)
; BASE-NEXT:     memd(r29+#24) = r19:18
; BASE-NEXT:     memd(r29+#16) = r21:20
; BASE-NEXT:    } // 8-byte Folded Spill
; BASE-NEXT:    {
; BASE-NEXT:     call sin
; BASE-NEXT:     r21:20 = combine(r5,r4)
; BASE-NEXT:     memd(r29+#8) = r23:22
; BASE-NEXT:     memd(r29+#0) = r25:24
; BASE-NEXT:    } // 8-byte Folded Spill
; BASE-NEXT:    {
; BASE-NEXT:     call sin
; BASE-NEXT:     r23:22 = combine(r1,r0)
; BASE-NEXT:     r1:0 = combine(r21,r20)
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call cos
; BASE-NEXT:     r25:24 = combine(r1,r0)
; BASE-NEXT:     r1:0 = combine(r17,r16)
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call cos
; BASE-NEXT:     r17:16 = combine(r1,r0)
; BASE-NEXT:     r1:0 = combine(r21,r20)
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     memd(r18+#16) = r17:16
; BASE-NEXT:     memd(r18+#24) = r1:0
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     memd(r18+#8) = r25:24
; BASE-NEXT:     memd(r18+#0) = r23:22
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     r17:16 = memd(r29+#32)
; BASE-NEXT:     r19:18 = memd(r29+#24)
; BASE-NEXT:    } // 8-byte Folded Reload
; BASE-NEXT:    {
; BASE-NEXT:     r21:20 = memd(r29+#16)
; BASE-NEXT:     r23:22 = memd(r29+#8)
; BASE-NEXT:    } // 8-byte Folded Reload
; BASE-NEXT:    {
; BASE-NEXT:     r25:24 = memd(r29+#0)
; BASE-NEXT:     r31:30 = dealloc_return(r30):raw
; BASE-NEXT:    } // 8-byte Folded Reload
;
; GNU-LABEL: test_sincos_v2f64:
; GNU:       // %bb.0:
; GNU-NEXT:    {
; GNU-NEXT:     r17:16 = combine(r3,r2)
; GNU-NEXT:     r2 = add(r0,#8)
; GNU-NEXT:     memd(r29+#-16) = r17:16
; GNU-NEXT:     allocframe(#16)
; GNU-NEXT:    } // 8-byte Folded Spill
; GNU-NEXT:    {
; GNU-NEXT:     r3 = add(r0,#24)
; GNU-NEXT:     r1:0 = combine(r5,r4)
; GNU-NEXT:     r18 = r0
; GNU-NEXT:     memd(r29+#0) = r19:18
; GNU-NEXT:    } // 8-byte Folded Spill
; GNU-NEXT:    {
; GNU-NEXT:     call sincos
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     call sincos
; GNU-NEXT:     r3 = add(r18,#16)
; GNU-NEXT:     r1:0 = combine(r17,r16)
; GNU-NEXT:     r2 = r18
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     r17:16 = memd(r29+#8)
; GNU-NEXT:     r19:18 = memd(r29+#0)
; GNU-NEXT:    } // 8-byte Folded Reload
; GNU-NEXT:    {
; GNU-NEXT:     r31:30 = dealloc_return(r30):raw
; GNU-NEXT:    }
;
; MUSL-LABEL: test_sincos_v2f64:
; MUSL:       // %bb.0:
; MUSL-NEXT:    {
; MUSL-NEXT:     r17:16 = combine(r3,r2)
; MUSL-NEXT:     memd(r29+#-16) = r17:16
; MUSL-NEXT:     allocframe(#40)
; MUSL-NEXT:    } // 8-byte Folded Spill
; MUSL-NEXT:    {
; MUSL-NEXT:     r18 = r0
; MUSL-NEXT:     r1:0 = combine(r3,r2)
; MUSL-NEXT:     memd(r29+#24) = r19:18
; MUSL-NEXT:     memd(r29+#16) = r21:20
; MUSL-NEXT:    } // 8-byte Folded Spill
; MUSL-NEXT:    {
; MUSL-NEXT:     call sin
; MUSL-NEXT:     r21:20 = combine(r5,r4)
; MUSL-NEXT:     memd(r29+#8) = r23:22
; MUSL-NEXT:     memd(r29+#0) = r25:24
; MUSL-NEXT:    } // 8-byte Folded Spill
; MUSL-NEXT:    {
; MUSL-NEXT:     call sin
; MUSL-NEXT:     r23:22 = combine(r1,r0)
; MUSL-NEXT:     r1:0 = combine(r21,r20)
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call cos
; MUSL-NEXT:     r25:24 = combine(r1,r0)
; MUSL-NEXT:     r1:0 = combine(r17,r16)
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call cos
; MUSL-NEXT:     r17:16 = combine(r1,r0)
; MUSL-NEXT:     r1:0 = combine(r21,r20)
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     memd(r18+#16) = r17:16
; MUSL-NEXT:     memd(r18+#24) = r1:0
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     memd(r18+#8) = r25:24
; MUSL-NEXT:     memd(r18+#0) = r23:22
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     r17:16 = memd(r29+#32)
; MUSL-NEXT:     r19:18 = memd(r29+#24)
; MUSL-NEXT:    } // 8-byte Folded Reload
; MUSL-NEXT:    {
; MUSL-NEXT:     r21:20 = memd(r29+#16)
; MUSL-NEXT:     r23:22 = memd(r29+#8)
; MUSL-NEXT:    } // 8-byte Folded Reload
; MUSL-NEXT:    {
; MUSL-NEXT:     r25:24 = memd(r29+#0)
; MUSL-NEXT:     r31:30 = dealloc_return(r30):raw
; MUSL-NEXT:    } // 8-byte Folded Reload
  %result = call { <2 x double>, <2 x double> } @llvm.sincos.v2f64(<2 x double> %a)
  ret { <2 x double>, <2 x double> } %result
}

define { fp128, fp128 } @test_sincos_f128(fp128 %a) #0 {
; BASE-LABEL: test_sincos_f128:
; BASE:       // %bb.0:
; BASE-NEXT:    {
; BASE-NEXT:     r17:16 = combine(r5,r4)
; BASE-NEXT:     memd(r29+#-16) = r17:16
; BASE-NEXT:     allocframe(#56)
; BASE-NEXT:    } // 8-byte Folded Spill
; BASE-NEXT:    {
; BASE-NEXT:     r20 = r0
; BASE-NEXT:     r0 = add(r29,#0)
; BASE-NEXT:     memd(r29+#32) = r21:20
; BASE-NEXT:     memd(r29+#40) = r19:18
; BASE-NEXT:    } // 8-byte Folded Spill
; BASE-NEXT:    {
; BASE-NEXT:     call sinl
; BASE-NEXT:     r19:18 = combine(r3,r2)
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call cosl
; BASE-NEXT:     r0 = add(r29,#16)
; BASE-NEXT:     r3:2 = combine(r19,r18)
; BASE-NEXT:     r5:4 = combine(r17,r16)
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     r1:0 = memd(r29+#0)
; BASE-NEXT:     r3:2 = memd(r29+#8)
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     r5:4 = memd(r29+#16)
; BASE-NEXT:     r7:6 = memd(r29+#24)
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     memd(r20+#24) = r7:6
; BASE-NEXT:     memd(r20+#16) = r5:4
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     memd(r20+#8) = r3:2
; BASE-NEXT:     memd(r20+#0) = r1:0
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     r17:16 = memd(r29+#48)
; BASE-NEXT:     r19:18 = memd(r29+#40)
; BASE-NEXT:    } // 8-byte Folded Reload
; BASE-NEXT:    {
; BASE-NEXT:     r21:20 = memd(r29+#32)
; BASE-NEXT:     dealloc_return
; BASE-NEXT:    } // 8-byte Folded Reload
;
; GNU-LABEL: test_sincos_f128:
; GNU:       // %bb.0:
; GNU-NEXT:    {
; GNU-NEXT:     r16 = r0
; GNU-NEXT:     memd(r29+#-16) = r17:16
; GNU-NEXT:     allocframe(#64)
; GNU-NEXT:    } // 8-byte Folded Spill
; GNU-NEXT:    {
; GNU-NEXT:     r0 = add(r29,#40)
; GNU-NEXT:     r7 = add(r29,#24)
; GNU-NEXT:     r6 = add(r29,#8)
; GNU-NEXT:     memw(r29+#4) = r7.new
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     call sincosl
; GNU-NEXT:     memw(r29+#0) = r6
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     r1:0 = memd(r29+#8)
; GNU-NEXT:     r3:2 = memd(r29+#16)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     r5:4 = memd(r29+#24)
; GNU-NEXT:     r7:6 = memd(r29+#32)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     memd(r16+#24) = r7:6
; GNU-NEXT:     memd(r16+#16) = r5:4
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     memd(r16+#8) = r3:2
; GNU-NEXT:     memd(r16+#0) = r1:0
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     r17:16 = memd(r29+#56)
; GNU-NEXT:     dealloc_return
; GNU-NEXT:    } // 8-byte Folded Reload
;
; MUSL-LABEL: test_sincos_f128:
; MUSL:       // %bb.0:
; MUSL-NEXT:    {
; MUSL-NEXT:     r17:16 = combine(r5,r4)
; MUSL-NEXT:     memd(r29+#-16) = r17:16
; MUSL-NEXT:     allocframe(#56)
; MUSL-NEXT:    } // 8-byte Folded Spill
; MUSL-NEXT:    {
; MUSL-NEXT:     r20 = r0
; MUSL-NEXT:     r0 = add(r29,#0)
; MUSL-NEXT:     memd(r29+#32) = r21:20
; MUSL-NEXT:     memd(r29+#40) = r19:18
; MUSL-NEXT:    } // 8-byte Folded Spill
; MUSL-NEXT:    {
; MUSL-NEXT:     call sinl
; MUSL-NEXT:     r19:18 = combine(r3,r2)
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call cosl
; MUSL-NEXT:     r0 = add(r29,#16)
; MUSL-NEXT:     r3:2 = combine(r19,r18)
; MUSL-NEXT:     r5:4 = combine(r17,r16)
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     r1:0 = memd(r29+#0)
; MUSL-NEXT:     r3:2 = memd(r29+#8)
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     r5:4 = memd(r29+#16)
; MUSL-NEXT:     r7:6 = memd(r29+#24)
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     memd(r20+#24) = r7:6
; MUSL-NEXT:     memd(r20+#16) = r5:4
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     memd(r20+#8) = r3:2
; MUSL-NEXT:     memd(r20+#0) = r1:0
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     r17:16 = memd(r29+#48)
; MUSL-NEXT:     r19:18 = memd(r29+#40)
; MUSL-NEXT:    } // 8-byte Folded Reload
; MUSL-NEXT:    {
; MUSL-NEXT:     r21:20 = memd(r29+#32)
; MUSL-NEXT:     dealloc_return
; MUSL-NEXT:    } // 8-byte Folded Reload
  %result = call { fp128, fp128 } @llvm.sincos.f128(fp128 %a)
  ret { fp128, fp128 } %result
}

define { <2 x fp128>, <2 x fp128> } @test_sincos_v2f128(<2 x fp128> %a) #0 {
; BASE-LABEL: test_sincos_v2f128:
; BASE:       // %bb.0:
; BASE-NEXT:    {
; BASE-NEXT:     r17:16 = combine(r5,r4)
; BASE-NEXT:     memd(r29+#-16) = r17:16
; BASE-NEXT:     allocframe(#104)
; BASE-NEXT:    } // 8-byte Folded Spill
; BASE-NEXT:    {
; BASE-NEXT:     r20 = r0
; BASE-NEXT:     r0 = add(r29,#32)
; BASE-NEXT:     memd(r29+#80) = r21:20
; BASE-NEXT:     memd(r29+#88) = r19:18
; BASE-NEXT:    } // 8-byte Folded Spill
; BASE-NEXT:    {
; BASE-NEXT:     r19:18 = combine(r3,r2)
; BASE-NEXT:     memd(r29+#72) = r23:22
; BASE-NEXT:     memd(r29+#64) = r25:24
; BASE-NEXT:    } // 8-byte Folded Spill
; BASE-NEXT:    {
; BASE-NEXT:     call sinl
; BASE-NEXT:     r23:22 = memd(r29+#112)
; BASE-NEXT:     r25:24 = memd(r29+#120)
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call sinl
; BASE-NEXT:     r0 = add(r29,#0)
; BASE-NEXT:     r3:2 = combine(r23,r22)
; BASE-NEXT:     r5:4 = combine(r25,r24)
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call cosl
; BASE-NEXT:     r0 = add(r29,#48)
; BASE-NEXT:     r3:2 = combine(r19,r18)
; BASE-NEXT:     r5:4 = combine(r17,r16)
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     call cosl
; BASE-NEXT:     r0 = add(r29,#16)
; BASE-NEXT:     r3:2 = combine(r23,r22)
; BASE-NEXT:     r5:4 = combine(r25,r24)
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     r1:0 = memd(r29+#32)
; BASE-NEXT:     r3:2 = memd(r29+#40)
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     r9:8 = memd(r29+#48)
; BASE-NEXT:     r15:14 = memd(r29+#24)
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     r5:4 = memd(r29+#0)
; BASE-NEXT:     r7:6 = memd(r29+#8)
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     r13:12 = memd(r29+#16)
; BASE-NEXT:     r11:10 = memd(r29+#56)
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     memd(r20+#56) = r15:14
; BASE-NEXT:     memd(r20+#48) = r13:12
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     memd(r20+#40) = r11:10
; BASE-NEXT:     memd(r20+#32) = r9:8
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     memd(r20+#24) = r7:6
; BASE-NEXT:     memd(r20+#16) = r5:4
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     memd(r20+#8) = r3:2
; BASE-NEXT:     memd(r20+#0) = r1:0
; BASE-NEXT:    }
; BASE-NEXT:    {
; BASE-NEXT:     r17:16 = memd(r29+#96)
; BASE-NEXT:     r19:18 = memd(r29+#88)
; BASE-NEXT:    } // 8-byte Folded Reload
; BASE-NEXT:    {
; BASE-NEXT:     r21:20 = memd(r29+#80)
; BASE-NEXT:     r23:22 = memd(r29+#72)
; BASE-NEXT:    } // 8-byte Folded Reload
; BASE-NEXT:    {
; BASE-NEXT:     r25:24 = memd(r29+#64)
; BASE-NEXT:     r31:30 = dealloc_return(r30):raw
; BASE-NEXT:    } // 8-byte Folded Reload
;
; GNU-LABEL: test_sincos_v2f128:
; GNU:       // %bb.0:
; GNU-NEXT:    {
; GNU-NEXT:     r16 = r0
; GNU-NEXT:     memd(r29+#-16) = r17:16
; GNU-NEXT:     allocframe(#128)
; GNU-NEXT:    } // 8-byte Folded Spill
; GNU-NEXT:    {
; GNU-NEXT:     r0 = add(r29,#88)
; GNU-NEXT:     r17 = r29
; GNU-NEXT:     memd(r29+#112) = r19:18
; GNU-NEXT:     memd(r29+#104) = r21:20
; GNU-NEXT:    } // 8-byte Folded Spill
; GNU-NEXT:    {
; GNU-NEXT:     r6 = add(r29,#56)
; GNU-NEXT:     r1 = add(r29,#72)
; GNU-NEXT:     r19:18 = memd(r29+#136)
; GNU-NEXT:     memw(r17+#0) = r6.new
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     call sincosl
; GNU-NEXT:     r21:20 = memd(r29+#144)
; GNU-NEXT:     memw(r17+#4) = r1
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     r0 = add(r29,#24)
; GNU-NEXT:     r3:2 = combine(r19,r18)
; GNU-NEXT:     r5:4 = combine(r21,r20)
; GNU-NEXT:     memw(r17+#4) = r0.new
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     call sincosl
; GNU-NEXT:     r0 = add(r29,#40)
; GNU-NEXT:     r1 = add(r29,#8)
; GNU-NEXT:     memw(r17+#0) = r1.new
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     r1:0 = memd(r29+#56)
; GNU-NEXT:     r3:2 = memd(r29+#64)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     r5:4 = memd(r29+#8)
; GNU-NEXT:     r7:6 = memd(r29+#16)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     r9:8 = memd(r29+#72)
; GNU-NEXT:     r13:12 = memd(r29+#24)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     r15:14 = memd(r29+#32)
; GNU-NEXT:     r11:10 = memd(r29+#80)
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     memd(r16+#56) = r15:14
; GNU-NEXT:     memd(r16+#48) = r13:12
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     memd(r16+#40) = r11:10
; GNU-NEXT:     memd(r16+#32) = r9:8
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     memd(r16+#24) = r7:6
; GNU-NEXT:     memd(r16+#16) = r5:4
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     memd(r16+#8) = r3:2
; GNU-NEXT:     memd(r16+#0) = r1:0
; GNU-NEXT:    }
; GNU-NEXT:    {
; GNU-NEXT:     r17:16 = memd(r29+#120)
; GNU-NEXT:     r19:18 = memd(r29+#112)
; GNU-NEXT:    } // 8-byte Folded Reload
; GNU-NEXT:    {
; GNU-NEXT:     r21:20 = memd(r29+#104)
; GNU-NEXT:     dealloc_return
; GNU-NEXT:    } // 8-byte Folded Reload
;
; MUSL-LABEL: test_sincos_v2f128:
; MUSL:       // %bb.0:
; MUSL-NEXT:    {
; MUSL-NEXT:     r17:16 = combine(r5,r4)
; MUSL-NEXT:     memd(r29+#-16) = r17:16
; MUSL-NEXT:     allocframe(#104)
; MUSL-NEXT:    } // 8-byte Folded Spill
; MUSL-NEXT:    {
; MUSL-NEXT:     r20 = r0
; MUSL-NEXT:     r0 = add(r29,#32)
; MUSL-NEXT:     memd(r29+#80) = r21:20
; MUSL-NEXT:     memd(r29+#88) = r19:18
; MUSL-NEXT:    } // 8-byte Folded Spill
; MUSL-NEXT:    {
; MUSL-NEXT:     r19:18 = combine(r3,r2)
; MUSL-NEXT:     memd(r29+#72) = r23:22
; MUSL-NEXT:     memd(r29+#64) = r25:24
; MUSL-NEXT:    } // 8-byte Folded Spill
; MUSL-NEXT:    {
; MUSL-NEXT:     call sinl
; MUSL-NEXT:     r23:22 = memd(r29+#112)
; MUSL-NEXT:     r25:24 = memd(r29+#120)
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call sinl
; MUSL-NEXT:     r0 = add(r29,#0)
; MUSL-NEXT:     r3:2 = combine(r23,r22)
; MUSL-NEXT:     r5:4 = combine(r25,r24)
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call cosl
; MUSL-NEXT:     r0 = add(r29,#48)
; MUSL-NEXT:     r3:2 = combine(r19,r18)
; MUSL-NEXT:     r5:4 = combine(r17,r16)
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     call cosl
; MUSL-NEXT:     r0 = add(r29,#16)
; MUSL-NEXT:     r3:2 = combine(r23,r22)
; MUSL-NEXT:     r5:4 = combine(r25,r24)
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     r1:0 = memd(r29+#32)
; MUSL-NEXT:     r3:2 = memd(r29+#40)
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     r9:8 = memd(r29+#48)
; MUSL-NEXT:     r15:14 = memd(r29+#24)
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     r5:4 = memd(r29+#0)
; MUSL-NEXT:     r7:6 = memd(r29+#8)
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     r13:12 = memd(r29+#16)
; MUSL-NEXT:     r11:10 = memd(r29+#56)
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     memd(r20+#56) = r15:14
; MUSL-NEXT:     memd(r20+#48) = r13:12
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     memd(r20+#40) = r11:10
; MUSL-NEXT:     memd(r20+#32) = r9:8
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     memd(r20+#24) = r7:6
; MUSL-NEXT:     memd(r20+#16) = r5:4
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     memd(r20+#8) = r3:2
; MUSL-NEXT:     memd(r20+#0) = r1:0
; MUSL-NEXT:    }
; MUSL-NEXT:    {
; MUSL-NEXT:     r17:16 = memd(r29+#96)
; MUSL-NEXT:     r19:18 = memd(r29+#88)
; MUSL-NEXT:    } // 8-byte Folded Reload
; MUSL-NEXT:    {
; MUSL-NEXT:     r21:20 = memd(r29+#80)
; MUSL-NEXT:     r23:22 = memd(r29+#72)
; MUSL-NEXT:    } // 8-byte Folded Reload
; MUSL-NEXT:    {
; MUSL-NEXT:     r25:24 = memd(r29+#64)
; MUSL-NEXT:     r31:30 = dealloc_return(r30):raw
; MUSL-NEXT:    } // 8-byte Folded Reload
  %result = call { <2 x fp128>, <2 x fp128> } @llvm.sincos.v2f128(<2 x fp128> %a)
  ret { <2 x fp128>, <2 x fp128> } %result
}

attributes #0 = { nounwind }
