; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=mipsisa32r6 < %s | FileCheck %s --check-prefix=MIPS32R6
; RUN: llc --mtriple=mips < %s | FileCheck %s --check-prefix=MIPS32R2
; RUN: llc --mtriple=mips64 < %s | FileCheck %s --check-prefix=MIPS64R2

declare float @llvm.fcanonicalize.f32(float)
declare double @llvm.fcanonicalize.f64(double)

define float @fcanonicalize_float(float %x) {
; MIPS32R6-LABEL: fcanonicalize_float:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    min.s $f0, $f12, $f12
;
; MIPS32R2-LABEL: fcanonicalize_float:
; MIPS32R2:       # %bb.0:
; MIPS32R2-NEXT:    mov.s $f0, $f12
; MIPS32R2-NEXT:    add.s $f1, $f12, $f12
; MIPS32R2-NEXT:    c.un.s $f12, $f12
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    movt.s $f0, $f1, $fcc0
;
; MIPS64R2-LABEL: fcanonicalize_float:
; MIPS64R2:       # %bb.0:
; MIPS64R2-NEXT:    mov.s $f0, $f12
; MIPS64R2-NEXT:    add.s $f1, $f12, $f12
; MIPS64R2-NEXT:    c.un.s $f12, $f12
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    movt.s $f0, $f1, $fcc0
  %z = call float @llvm.canonicalize.f32(float %x)
  ret float %z
}

define float @fcanonicalize_float_nnan(float %x) {
; MIPS32R6-LABEL: fcanonicalize_float_nnan:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    min.s $f0, $f12, $f12
;
; MIPS32R2-LABEL: fcanonicalize_float_nnan:
; MIPS32R2:       # %bb.0:
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    mov.s $f0, $f12
;
; MIPS64R2-LABEL: fcanonicalize_float_nnan:
; MIPS64R2:       # %bb.0:
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    mov.s $f0, $f12
  %z = call nnan float @llvm.canonicalize.f32(float %x)
  ret float %z
}


define double @fcanonicalize_double(double %x) {
; MIPS32R6-LABEL: fcanonicalize_double:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    min.d $f0, $f12, $f12
;
; MIPS32R2-LABEL: fcanonicalize_double:
; MIPS32R2:       # %bb.0:
; MIPS32R2-NEXT:    mov.d $f0, $f12
; MIPS32R2-NEXT:    add.d $f2, $f12, $f12
; MIPS32R2-NEXT:    c.un.d $f12, $f12
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    movt.d $f0, $f2, $fcc0
;
; MIPS64R2-LABEL: fcanonicalize_double:
; MIPS64R2:       # %bb.0:
; MIPS64R2-NEXT:    mov.d $f0, $f12
; MIPS64R2-NEXT:    add.d $f1, $f12, $f12
; MIPS64R2-NEXT:    c.un.d $f12, $f12
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    movt.d $f0, $f1, $fcc0
  %z = call double @llvm.canonicalize.f64(double %x)
  ret double %z
}

define double @fcanonicalize_double_nnan(double %x) {
; MIPS32R6-LABEL: fcanonicalize_double_nnan:
; MIPS32R6:       # %bb.0:
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    min.d $f0, $f12, $f12
;
; MIPS32R2-LABEL: fcanonicalize_double_nnan:
; MIPS32R2:       # %bb.0:
; MIPS32R2-NEXT:    jr $ra
; MIPS32R2-NEXT:    mov.d $f0, $f12
;
; MIPS64R2-LABEL: fcanonicalize_double_nnan:
; MIPS64R2:       # %bb.0:
; MIPS64R2-NEXT:    jr $ra
; MIPS64R2-NEXT:    mov.d $f0, $f12
  %z = call nnan double @llvm.canonicalize.f64(double %x)
  ret double %z
}

