; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mcpu=pwr8 -ppc-asm-full-reg-names --enable-unsafe-fp-math \
; RUN:   -verify-machineinstrs --enable-no-signed-zeros-fp-math \
; RUN:   --enable-no-nans-fp-math --enable-no-infs-fp-math \
; RUN:   -mtriple=powerpc64le-unknown-unknown < %s | FileCheck %s \
; RUN:   --check-prefix=FAST-P8
; RUN: llc -mcpu=pwr9 -ppc-asm-full-reg-names --enable-unsafe-fp-math \
; RUN:   -verify-machineinstrs --enable-no-signed-zeros-fp-math \
; RUN:   --enable-no-nans-fp-math --enable-no-infs-fp-math \
; RUN:   -mtriple=powerpc64le-unknown-unknown < %s | FileCheck %s \
; RUN:   --check-prefix=FAST-P9
; RUN: llc -mcpu=pwr8 -ppc-asm-full-reg-names -verify-machineinstrs \
; RUN:   -mtriple=powerpc64le-unknown-unknown < %s | FileCheck %s \
; RUN:   --check-prefix=NO-FAST-P8
; RUN: llc -mcpu=pwr9 -ppc-asm-full-reg-names -verify-machineinstrs \
; RUN:   -mtriple=powerpc64le-unknown-unknown < %s | FileCheck %s \
; RUN:   --check-prefix=NO-FAST-P9

; Test oeq
define float @select_oeq_float(float %a, float %b, float %c, float %d) {
; FAST-P8-LABEL: select_oeq_float:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    xssubsp f0, f2, f1
; FAST-P8-NEXT:    xssubsp f1, f1, f2
; FAST-P8-NEXT:    fsel f1, f1, f3, f4
; FAST-P8-NEXT:    fsel f1, f0, f1, f4
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: select_oeq_float:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    xssubsp f0, f2, f1
; FAST-P9-NEXT:    xssubsp f1, f1, f2
; FAST-P9-NEXT:    fsel f1, f1, f3, f4
; FAST-P9-NEXT:    fsel f1, f0, f1, f4
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: select_oeq_float:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    fcmpu cr0, f1, f2
; NO-FAST-P8-NEXT:    beq cr0, .LBB0_2
; NO-FAST-P8-NEXT:  # %bb.1: # %entry
; NO-FAST-P8-NEXT:    fmr f3, f4
; NO-FAST-P8-NEXT:  .LBB0_2: # %entry
; NO-FAST-P8-NEXT:    fmr f1, f3
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: select_oeq_float:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    fcmpu cr0, f1, f2
; NO-FAST-P9-NEXT:    beq cr0, .LBB0_2
; NO-FAST-P9-NEXT:  # %bb.1: # %entry
; NO-FAST-P9-NEXT:    fmr f3, f4
; NO-FAST-P9-NEXT:  .LBB0_2: # %entry
; NO-FAST-P9-NEXT:    fmr f1, f3
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp oeq float %a, %b
  %cond = select i1 %cmp, float %c, float %d
  ret float %cond
}

define double @select_oeq_double(double %a, double %b, double %c, double %d) {
; FAST-P8-LABEL: select_oeq_double:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    xssubdp f0, f1, f2
; FAST-P8-NEXT:    fsel f1, f0, f3, f4
; FAST-P8-NEXT:    xsnegdp f0, f0
; FAST-P8-NEXT:    fsel f1, f0, f1, f4
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: select_oeq_double:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    xssubdp f0, f1, f2
; FAST-P9-NEXT:    fsel f1, f0, f3, f4
; FAST-P9-NEXT:    xsnegdp f0, f0
; FAST-P9-NEXT:    fsel f1, f0, f1, f4
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: select_oeq_double:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    xscmpudp cr0, f1, f2
; NO-FAST-P8-NEXT:    beq cr0, .LBB1_2
; NO-FAST-P8-NEXT:  # %bb.1: # %entry
; NO-FAST-P8-NEXT:    fmr f3, f4
; NO-FAST-P8-NEXT:  .LBB1_2: # %entry
; NO-FAST-P8-NEXT:    fmr f1, f3
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: select_oeq_double:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    xscmpudp cr0, f1, f2
; NO-FAST-P9-NEXT:    beq cr0, .LBB1_2
; NO-FAST-P9-NEXT:  # %bb.1: # %entry
; NO-FAST-P9-NEXT:    fmr f3, f4
; NO-FAST-P9-NEXT:  .LBB1_2: # %entry
; NO-FAST-P9-NEXT:    fmr f1, f3
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp oeq double %a, %b
  %cond = select i1 %cmp, double %c, double %d
  ret double %cond
}

define float @select_fast_oeq_float(float %a, float %b, float %c, float %d) {
; FAST-P8-LABEL: select_fast_oeq_float:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    xssubsp f0, f2, f1
; FAST-P8-NEXT:    xssubsp f1, f1, f2
; FAST-P8-NEXT:    fsel f1, f1, f3, f4
; FAST-P8-NEXT:    fsel f1, f0, f1, f4
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: select_fast_oeq_float:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    xssubsp f0, f2, f1
; FAST-P9-NEXT:    xssubsp f1, f1, f2
; FAST-P9-NEXT:    fsel f1, f1, f3, f4
; FAST-P9-NEXT:    fsel f1, f0, f1, f4
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: select_fast_oeq_float:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    xssubsp f0, f2, f1
; NO-FAST-P8-NEXT:    xssubsp f1, f1, f2
; NO-FAST-P8-NEXT:    fsel f1, f1, f3, f4
; NO-FAST-P8-NEXT:    fsel f1, f0, f1, f4
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: select_fast_oeq_float:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    xssubsp f0, f2, f1
; NO-FAST-P9-NEXT:    xssubsp f1, f1, f2
; NO-FAST-P9-NEXT:    fsel f1, f1, f3, f4
; NO-FAST-P9-NEXT:    fsel f1, f0, f1, f4
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp nnan ninf nsz oeq float %a, %b
  %cond = select i1 %cmp, float %c, float %d
  ret float %cond
}

define double @select_fast_oeq_double(double %a, double %b, double %c, double %d) {
; FAST-P8-LABEL: select_fast_oeq_double:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    xssubdp f0, f1, f2
; FAST-P8-NEXT:    fsel f1, f0, f3, f4
; FAST-P8-NEXT:    xsnegdp f0, f0
; FAST-P8-NEXT:    fsel f1, f0, f1, f4
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: select_fast_oeq_double:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    xssubdp f0, f1, f2
; FAST-P9-NEXT:    fsel f1, f0, f3, f4
; FAST-P9-NEXT:    xsnegdp f0, f0
; FAST-P9-NEXT:    fsel f1, f0, f1, f4
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: select_fast_oeq_double:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    xssubdp f0, f1, f2
; NO-FAST-P8-NEXT:    fsel f1, f0, f3, f4
; NO-FAST-P8-NEXT:    xsnegdp f0, f0
; NO-FAST-P8-NEXT:    fsel f1, f0, f1, f4
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: select_fast_oeq_double:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    xssubdp f0, f1, f2
; NO-FAST-P9-NEXT:    fsel f1, f0, f3, f4
; NO-FAST-P9-NEXT:    xsnegdp f0, f0
; NO-FAST-P9-NEXT:    fsel f1, f0, f1, f4
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp nnan ninf nsz oeq double %a, %b
  %cond = select i1 %cmp, double %c, double %d
  ret double %cond
}


; Test one
define float @select_one_float(float %a, float %b, float %c, float %d) {
; FAST-P8-LABEL: select_one_float:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    xssubsp f0, f2, f1
; FAST-P8-NEXT:    xssubsp f1, f1, f2
; FAST-P8-NEXT:    fsel f1, f1, f4, f3
; FAST-P8-NEXT:    fsel f1, f0, f1, f3
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: select_one_float:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    xssubsp f0, f2, f1
; FAST-P9-NEXT:    xssubsp f1, f1, f2
; FAST-P9-NEXT:    fsel f1, f1, f4, f3
; FAST-P9-NEXT:    fsel f1, f0, f1, f3
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: select_one_float:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    fcmpu cr0, f1, f2
; NO-FAST-P8-NEXT:    crnor 4*cr5+lt, un, eq
; NO-FAST-P8-NEXT:    bc 12, 4*cr5+lt, .LBB4_2
; NO-FAST-P8-NEXT:  # %bb.1: # %entry
; NO-FAST-P8-NEXT:    fmr f3, f4
; NO-FAST-P8-NEXT:  .LBB4_2: # %entry
; NO-FAST-P8-NEXT:    fmr f1, f3
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: select_one_float:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    fcmpu cr0, f1, f2
; NO-FAST-P9-NEXT:    crnor 4*cr5+lt, un, eq
; NO-FAST-P9-NEXT:    bc 12, 4*cr5+lt, .LBB4_2
; NO-FAST-P9-NEXT:  # %bb.1: # %entry
; NO-FAST-P9-NEXT:    fmr f3, f4
; NO-FAST-P9-NEXT:  .LBB4_2: # %entry
; NO-FAST-P9-NEXT:    fmr f1, f3
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp one float %a, %b
  %cond = select i1 %cmp, float %c, float %d
  ret float %cond
}

define double @select_one_double(double %a, double %b, double %c, double %d) {
; FAST-P8-LABEL: select_one_double:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    xssubdp f0, f1, f2
; FAST-P8-NEXT:    fsel f1, f0, f4, f3
; FAST-P8-NEXT:    xsnegdp f0, f0
; FAST-P8-NEXT:    fsel f1, f0, f1, f3
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: select_one_double:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    xssubdp f0, f1, f2
; FAST-P9-NEXT:    fsel f1, f0, f4, f3
; FAST-P9-NEXT:    xsnegdp f0, f0
; FAST-P9-NEXT:    fsel f1, f0, f1, f3
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: select_one_double:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    fcmpu cr0, f1, f2
; NO-FAST-P8-NEXT:    crnor 4*cr5+lt, un, eq
; NO-FAST-P8-NEXT:    bc 12, 4*cr5+lt, .LBB5_2
; NO-FAST-P8-NEXT:  # %bb.1: # %entry
; NO-FAST-P8-NEXT:    fmr f3, f4
; NO-FAST-P8-NEXT:  .LBB5_2: # %entry
; NO-FAST-P8-NEXT:    fmr f1, f3
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: select_one_double:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    fcmpu cr0, f1, f2
; NO-FAST-P9-NEXT:    crnor 4*cr5+lt, un, eq
; NO-FAST-P9-NEXT:    bc 12, 4*cr5+lt, .LBB5_2
; NO-FAST-P9-NEXT:  # %bb.1: # %entry
; NO-FAST-P9-NEXT:    fmr f3, f4
; NO-FAST-P9-NEXT:  .LBB5_2: # %entry
; NO-FAST-P9-NEXT:    fmr f1, f3
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp one double %a, %b
  %cond = select i1 %cmp, double %c, double %d
  ret double %cond
}

define float @select_fast_one_float(float %a, float %b, float %c, float %d) {
; FAST-P8-LABEL: select_fast_one_float:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    xssubsp f0, f2, f1
; FAST-P8-NEXT:    xssubsp f1, f1, f2
; FAST-P8-NEXT:    fsel f1, f1, f4, f3
; FAST-P8-NEXT:    fsel f1, f0, f1, f3
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: select_fast_one_float:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    xssubsp f0, f2, f1
; FAST-P9-NEXT:    xssubsp f1, f1, f2
; FAST-P9-NEXT:    fsel f1, f1, f4, f3
; FAST-P9-NEXT:    fsel f1, f0, f1, f3
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: select_fast_one_float:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    xssubsp f0, f2, f1
; NO-FAST-P8-NEXT:    xssubsp f1, f1, f2
; NO-FAST-P8-NEXT:    fsel f1, f1, f4, f3
; NO-FAST-P8-NEXT:    fsel f1, f0, f1, f3
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: select_fast_one_float:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    xssubsp f0, f2, f1
; NO-FAST-P9-NEXT:    xssubsp f1, f1, f2
; NO-FAST-P9-NEXT:    fsel f1, f1, f4, f3
; NO-FAST-P9-NEXT:    fsel f1, f0, f1, f3
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp nnan ninf nsz one float %a, %b
  %cond = select i1 %cmp, float %c, float %d
  ret float %cond
}

define double @select_fast_one_double(double %a, double %b, double %c, double %d) {
; FAST-P8-LABEL: select_fast_one_double:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    xssubdp f0, f1, f2
; FAST-P8-NEXT:    fsel f1, f0, f4, f3
; FAST-P8-NEXT:    xsnegdp f0, f0
; FAST-P8-NEXT:    fsel f1, f0, f1, f3
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: select_fast_one_double:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    xssubdp f0, f1, f2
; FAST-P9-NEXT:    fsel f1, f0, f4, f3
; FAST-P9-NEXT:    xsnegdp f0, f0
; FAST-P9-NEXT:    fsel f1, f0, f1, f3
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: select_fast_one_double:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    xssubdp f0, f1, f2
; NO-FAST-P8-NEXT:    fsel f1, f0, f4, f3
; NO-FAST-P8-NEXT:    xsnegdp f0, f0
; NO-FAST-P8-NEXT:    fsel f1, f0, f1, f3
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: select_fast_one_double:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    xssubdp f0, f1, f2
; NO-FAST-P9-NEXT:    fsel f1, f0, f4, f3
; NO-FAST-P9-NEXT:    xsnegdp f0, f0
; NO-FAST-P9-NEXT:    fsel f1, f0, f1, f3
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp nnan ninf nsz one double %a, %b
  %cond = select i1 %cmp, double %c, double %d
  ret double %cond
}


; Test oge
define float @select_oge_float(float %a, float %b, float %c, float %d) {
; FAST-P8-LABEL: select_oge_float:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    xssubsp f0, f1, f2
; FAST-P8-NEXT:    fsel f1, f0, f3, f4
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: select_oge_float:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    xssubsp f0, f1, f2
; FAST-P9-NEXT:    fsel f1, f0, f3, f4
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: select_oge_float:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    fcmpu cr0, f1, f2
; NO-FAST-P8-NEXT:    crnor 4*cr5+lt, un, lt
; NO-FAST-P8-NEXT:    bc 12, 4*cr5+lt, .LBB8_2
; NO-FAST-P8-NEXT:  # %bb.1: # %entry
; NO-FAST-P8-NEXT:    fmr f3, f4
; NO-FAST-P8-NEXT:  .LBB8_2: # %entry
; NO-FAST-P8-NEXT:    fmr f1, f3
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: select_oge_float:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    fcmpu cr0, f1, f2
; NO-FAST-P9-NEXT:    crnor 4*cr5+lt, un, lt
; NO-FAST-P9-NEXT:    bc 12, 4*cr5+lt, .LBB8_2
; NO-FAST-P9-NEXT:  # %bb.1: # %entry
; NO-FAST-P9-NEXT:    fmr f3, f4
; NO-FAST-P9-NEXT:  .LBB8_2: # %entry
; NO-FAST-P9-NEXT:    fmr f1, f3
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp oge float %a, %b
  %cond = select i1 %cmp, float %c, float %d
  ret float %cond
}

define double @select_oge_double(double %a, double %b, double %c, double %d) {
; FAST-P8-LABEL: select_oge_double:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    xssubdp f0, f1, f2
; FAST-P8-NEXT:    fsel f1, f0, f3, f4
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: select_oge_double:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    xssubdp f0, f1, f2
; FAST-P9-NEXT:    fsel f1, f0, f3, f4
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: select_oge_double:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    fcmpu cr0, f1, f2
; NO-FAST-P8-NEXT:    crnor 4*cr5+lt, un, lt
; NO-FAST-P8-NEXT:    bc 12, 4*cr5+lt, .LBB9_2
; NO-FAST-P8-NEXT:  # %bb.1: # %entry
; NO-FAST-P8-NEXT:    fmr f3, f4
; NO-FAST-P8-NEXT:  .LBB9_2: # %entry
; NO-FAST-P8-NEXT:    fmr f1, f3
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: select_oge_double:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    fcmpu cr0, f1, f2
; NO-FAST-P9-NEXT:    crnor 4*cr5+lt, un, lt
; NO-FAST-P9-NEXT:    bc 12, 4*cr5+lt, .LBB9_2
; NO-FAST-P9-NEXT:  # %bb.1: # %entry
; NO-FAST-P9-NEXT:    fmr f3, f4
; NO-FAST-P9-NEXT:  .LBB9_2: # %entry
; NO-FAST-P9-NEXT:    fmr f1, f3
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp oge double %a, %b
  %cond = select i1 %cmp, double %c, double %d
  ret double %cond
}

define float @select_fast_oge_float(float %a, float %b, float %c, float %d) {
; FAST-P8-LABEL: select_fast_oge_float:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    xssubsp f0, f1, f2
; FAST-P8-NEXT:    fsel f1, f0, f3, f4
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: select_fast_oge_float:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    xssubsp f0, f1, f2
; FAST-P9-NEXT:    fsel f1, f0, f3, f4
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: select_fast_oge_float:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    xssubsp f0, f1, f2
; NO-FAST-P8-NEXT:    fsel f1, f0, f3, f4
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: select_fast_oge_float:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    xssubsp f0, f1, f2
; NO-FAST-P9-NEXT:    fsel f1, f0, f3, f4
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp nnan ninf nsz oge float %a, %b
  %cond = select i1 %cmp, float %c, float %d
  ret float %cond
}

define double @select_fast_oge_double(double %a, double %b, double %c, double %d) {
; FAST-P8-LABEL: select_fast_oge_double:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    xssubdp f0, f1, f2
; FAST-P8-NEXT:    fsel f1, f0, f3, f4
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: select_fast_oge_double:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    xssubdp f0, f1, f2
; FAST-P9-NEXT:    fsel f1, f0, f3, f4
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: select_fast_oge_double:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    xssubdp f0, f1, f2
; NO-FAST-P8-NEXT:    fsel f1, f0, f3, f4
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: select_fast_oge_double:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    xssubdp f0, f1, f2
; NO-FAST-P9-NEXT:    fsel f1, f0, f3, f4
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp nnan ninf nsz oge double %a, %b
  %cond = select i1 %cmp, double %c, double %d
  ret double %cond
}


; Test olt
define float @select_olt_float(float %a, float %b, float %c, float %d) {
; FAST-P8-LABEL: select_olt_float:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    xssubsp f0, f1, f2
; FAST-P8-NEXT:    fsel f1, f0, f4, f3
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: select_olt_float:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    xssubsp f0, f1, f2
; FAST-P9-NEXT:    fsel f1, f0, f4, f3
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: select_olt_float:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    fcmpu cr0, f1, f2
; NO-FAST-P8-NEXT:    blt cr0, .LBB12_2
; NO-FAST-P8-NEXT:  # %bb.1: # %entry
; NO-FAST-P8-NEXT:    fmr f3, f4
; NO-FAST-P8-NEXT:  .LBB12_2: # %entry
; NO-FAST-P8-NEXT:    fmr f1, f3
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: select_olt_float:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    fcmpu cr0, f1, f2
; NO-FAST-P9-NEXT:    blt cr0, .LBB12_2
; NO-FAST-P9-NEXT:  # %bb.1: # %entry
; NO-FAST-P9-NEXT:    fmr f3, f4
; NO-FAST-P9-NEXT:  .LBB12_2: # %entry
; NO-FAST-P9-NEXT:    fmr f1, f3
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp olt float %a, %b
  %cond = select i1 %cmp, float %c, float %d
  ret float %cond
}

define double @select_olt_double(double %a, double %b, double %c, double %d) {
; FAST-P8-LABEL: select_olt_double:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    xssubdp f0, f1, f2
; FAST-P8-NEXT:    fsel f1, f0, f4, f3
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: select_olt_double:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    xssubdp f0, f1, f2
; FAST-P9-NEXT:    fsel f1, f0, f4, f3
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: select_olt_double:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    xscmpudp cr0, f1, f2
; NO-FAST-P8-NEXT:    blt cr0, .LBB13_2
; NO-FAST-P8-NEXT:  # %bb.1: # %entry
; NO-FAST-P8-NEXT:    fmr f3, f4
; NO-FAST-P8-NEXT:  .LBB13_2: # %entry
; NO-FAST-P8-NEXT:    fmr f1, f3
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: select_olt_double:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    xscmpudp cr0, f1, f2
; NO-FAST-P9-NEXT:    blt cr0, .LBB13_2
; NO-FAST-P9-NEXT:  # %bb.1: # %entry
; NO-FAST-P9-NEXT:    fmr f3, f4
; NO-FAST-P9-NEXT:  .LBB13_2: # %entry
; NO-FAST-P9-NEXT:    fmr f1, f3
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp olt double %a, %b
  %cond = select i1 %cmp, double %c, double %d
  ret double %cond
}

define float @select_fast_olt_float(float %a, float %b, float %c, float %d) {
; FAST-P8-LABEL: select_fast_olt_float:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    xssubsp f0, f1, f2
; FAST-P8-NEXT:    fsel f1, f0, f4, f3
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: select_fast_olt_float:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    xssubsp f0, f1, f2
; FAST-P9-NEXT:    fsel f1, f0, f4, f3
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: select_fast_olt_float:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    xssubsp f0, f1, f2
; NO-FAST-P8-NEXT:    fsel f1, f0, f4, f3
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: select_fast_olt_float:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    xssubsp f0, f1, f2
; NO-FAST-P9-NEXT:    fsel f1, f0, f4, f3
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp ninf nnan nsz olt float %a, %b
  %cond = select i1 %cmp, float %c, float %d
  ret float %cond
}

define double @select_fast_olt_double(double %a, double %b, double %c, double %d) {
; FAST-P8-LABEL: select_fast_olt_double:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    xssubdp f0, f1, f2
; FAST-P8-NEXT:    fsel f1, f0, f4, f3
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: select_fast_olt_double:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    xssubdp f0, f1, f2
; FAST-P9-NEXT:    fsel f1, f0, f4, f3
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: select_fast_olt_double:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    xssubdp f0, f1, f2
; NO-FAST-P8-NEXT:    fsel f1, f0, f4, f3
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: select_fast_olt_double:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    xssubdp f0, f1, f2
; NO-FAST-P9-NEXT:    fsel f1, f0, f4, f3
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp nnan ninf nsz olt double %a, %b
  %cond = select i1 %cmp, double %c, double %d
  ret double %cond
}


; Test ogt
define float @select_ogt_float(float %a, float %b, float %c, float %d) {
; FAST-P8-LABEL: select_ogt_float:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    xssubsp f0, f2, f1
; FAST-P8-NEXT:    fsel f1, f0, f4, f3
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: select_ogt_float:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    xssubsp f0, f2, f1
; FAST-P9-NEXT:    fsel f1, f0, f4, f3
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: select_ogt_float:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    fcmpu cr0, f1, f2
; NO-FAST-P8-NEXT:    bgt cr0, .LBB16_2
; NO-FAST-P8-NEXT:  # %bb.1: # %entry
; NO-FAST-P8-NEXT:    fmr f3, f4
; NO-FAST-P8-NEXT:  .LBB16_2: # %entry
; NO-FAST-P8-NEXT:    fmr f1, f3
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: select_ogt_float:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    fcmpu cr0, f1, f2
; NO-FAST-P9-NEXT:    bgt cr0, .LBB16_2
; NO-FAST-P9-NEXT:  # %bb.1: # %entry
; NO-FAST-P9-NEXT:    fmr f3, f4
; NO-FAST-P9-NEXT:  .LBB16_2: # %entry
; NO-FAST-P9-NEXT:    fmr f1, f3
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp ogt float %a, %b
  %cond = select i1 %cmp, float %c, float %d
  ret float %cond
}

define double @select_ogt_double(double %a, double %b, double %c, double %d) {
; FAST-P8-LABEL: select_ogt_double:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    xssubdp f0, f2, f1
; FAST-P8-NEXT:    fsel f1, f0, f4, f3
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: select_ogt_double:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    xssubdp f0, f2, f1
; FAST-P9-NEXT:    fsel f1, f0, f4, f3
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: select_ogt_double:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    xscmpudp cr0, f1, f2
; NO-FAST-P8-NEXT:    bgt cr0, .LBB17_2
; NO-FAST-P8-NEXT:  # %bb.1: # %entry
; NO-FAST-P8-NEXT:    fmr f3, f4
; NO-FAST-P8-NEXT:  .LBB17_2: # %entry
; NO-FAST-P8-NEXT:    fmr f1, f3
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: select_ogt_double:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    xscmpudp cr0, f1, f2
; NO-FAST-P9-NEXT:    bgt cr0, .LBB17_2
; NO-FAST-P9-NEXT:  # %bb.1: # %entry
; NO-FAST-P9-NEXT:    fmr f3, f4
; NO-FAST-P9-NEXT:  .LBB17_2: # %entry
; NO-FAST-P9-NEXT:    fmr f1, f3
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp ogt double %a, %b
  %cond = select i1 %cmp, double %c, double %d
  ret double %cond
}

define float @select_fast_ogt_float(float %a, float %b, float %c, float %d) {
; FAST-P8-LABEL: select_fast_ogt_float:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    xssubsp f0, f2, f1
; FAST-P8-NEXT:    fsel f1, f0, f4, f3
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: select_fast_ogt_float:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    xssubsp f0, f2, f1
; FAST-P9-NEXT:    fsel f1, f0, f4, f3
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: select_fast_ogt_float:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    xssubsp f0, f2, f1
; NO-FAST-P8-NEXT:    fsel f1, f0, f4, f3
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: select_fast_ogt_float:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    xssubsp f0, f2, f1
; NO-FAST-P9-NEXT:    fsel f1, f0, f4, f3
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp nnan ninf nsz ogt float %a, %b
  %cond = select i1 %cmp, float %c, float %d
  ret float %cond
}

define double @select_fast_ogt_double(double %a, double %b, double %c, double %d) {
; FAST-P8-LABEL: select_fast_ogt_double:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    xssubdp f0, f2, f1
; FAST-P8-NEXT:    fsel f1, f0, f4, f3
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: select_fast_ogt_double:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    xssubdp f0, f2, f1
; FAST-P9-NEXT:    fsel f1, f0, f4, f3
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: select_fast_ogt_double:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    xssubdp f0, f2, f1
; NO-FAST-P8-NEXT:    fsel f1, f0, f4, f3
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: select_fast_ogt_double:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    xssubdp f0, f2, f1
; NO-FAST-P9-NEXT:    fsel f1, f0, f4, f3
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp nnan ninf nsz ogt double %a, %b
  %cond = select i1 %cmp, double %c, double %d
  ret double %cond
}


; Test ole
define float @select_ole_float(float %a, float %b, float %c, float %d) {
; FAST-P8-LABEL: select_ole_float:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    xssubsp f0, f2, f1
; FAST-P8-NEXT:    fsel f1, f0, f3, f4
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: select_ole_float:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    xssubsp f0, f2, f1
; FAST-P9-NEXT:    fsel f1, f0, f3, f4
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: select_ole_float:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    fcmpu cr0, f1, f2
; NO-FAST-P8-NEXT:    crnor 4*cr5+lt, un, gt
; NO-FAST-P8-NEXT:    bc 12, 4*cr5+lt, .LBB20_2
; NO-FAST-P8-NEXT:  # %bb.1: # %entry
; NO-FAST-P8-NEXT:    fmr f3, f4
; NO-FAST-P8-NEXT:  .LBB20_2: # %entry
; NO-FAST-P8-NEXT:    fmr f1, f3
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: select_ole_float:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    fcmpu cr0, f1, f2
; NO-FAST-P9-NEXT:    crnor 4*cr5+lt, un, gt
; NO-FAST-P9-NEXT:    bc 12, 4*cr5+lt, .LBB20_2
; NO-FAST-P9-NEXT:  # %bb.1: # %entry
; NO-FAST-P9-NEXT:    fmr f3, f4
; NO-FAST-P9-NEXT:  .LBB20_2: # %entry
; NO-FAST-P9-NEXT:    fmr f1, f3
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp ole float %a, %b
  %cond = select i1 %cmp, float %c, float %d
  ret float %cond
}

define double @select_ole_double(double %a, double %b, double %c, double %d) {
; FAST-P8-LABEL: select_ole_double:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    xssubdp f0, f2, f1
; FAST-P8-NEXT:    fsel f1, f0, f3, f4
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: select_ole_double:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    xssubdp f0, f2, f1
; FAST-P9-NEXT:    fsel f1, f0, f3, f4
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: select_ole_double:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    fcmpu cr0, f1, f2
; NO-FAST-P8-NEXT:    crnor 4*cr5+lt, un, gt
; NO-FAST-P8-NEXT:    bc 12, 4*cr5+lt, .LBB21_2
; NO-FAST-P8-NEXT:  # %bb.1: # %entry
; NO-FAST-P8-NEXT:    fmr f3, f4
; NO-FAST-P8-NEXT:  .LBB21_2: # %entry
; NO-FAST-P8-NEXT:    fmr f1, f3
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: select_ole_double:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    fcmpu cr0, f1, f2
; NO-FAST-P9-NEXT:    crnor 4*cr5+lt, un, gt
; NO-FAST-P9-NEXT:    bc 12, 4*cr5+lt, .LBB21_2
; NO-FAST-P9-NEXT:  # %bb.1: # %entry
; NO-FAST-P9-NEXT:    fmr f3, f4
; NO-FAST-P9-NEXT:  .LBB21_2: # %entry
; NO-FAST-P9-NEXT:    fmr f1, f3
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp ole double %a, %b
  %cond = select i1 %cmp, double %c, double %d
  ret double %cond
}

define float @select_fast_ole_float(float %a, float %b, float %c, float %d) {
; FAST-P8-LABEL: select_fast_ole_float:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    xssubsp f0, f2, f1
; FAST-P8-NEXT:    fsel f1, f0, f3, f4
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: select_fast_ole_float:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    xssubsp f0, f2, f1
; FAST-P9-NEXT:    fsel f1, f0, f3, f4
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: select_fast_ole_float:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    xssubsp f0, f2, f1
; NO-FAST-P8-NEXT:    fsel f1, f0, f3, f4
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: select_fast_ole_float:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    xssubsp f0, f2, f1
; NO-FAST-P9-NEXT:    fsel f1, f0, f3, f4
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp nnan ninf nsz ole float %a, %b
  %cond = select i1 %cmp, float %c, float %d
  ret float %cond
}

define double @select_fast_ole_double(double %a, double %b, double %c, double %d) {
; FAST-P8-LABEL: select_fast_ole_double:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    xssubdp f0, f2, f1
; FAST-P8-NEXT:    fsel f1, f0, f3, f4
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: select_fast_ole_double:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    xssubdp f0, f2, f1
; FAST-P9-NEXT:    fsel f1, f0, f3, f4
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: select_fast_ole_double:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    xssubdp f0, f2, f1
; NO-FAST-P8-NEXT:    fsel f1, f0, f3, f4
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: select_fast_ole_double:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    xssubdp f0, f2, f1
; NO-FAST-P9-NEXT:    fsel f1, f0, f3, f4
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp nnan ninf nsz ole double %a, %b
  %cond = select i1 %cmp, double %c, double %d
  ret double %cond
}

; Test RHS is 1.000000e+00
define double @onecmp1(double %a, double %y, double %z) {
; FAST-P8-LABEL: onecmp1:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    vspltisw v2, -1
; FAST-P8-NEXT:    xvcvsxwdp vs0, vs34
; FAST-P8-NEXT:    xsadddp f0, f1, f0
; FAST-P8-NEXT:    fsel f1, f0, f2, f3
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: onecmp1:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    vspltisw v2, -1
; FAST-P9-NEXT:    xvcvsxwdp vs0, vs34
; FAST-P9-NEXT:    xsadddp f0, f1, f0
; FAST-P9-NEXT:    fsel f1, f0, f2, f3
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: onecmp1:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    vspltisw v2, 1
; NO-FAST-P8-NEXT:    xvcvsxwdp vs0, vs34
; NO-FAST-P8-NEXT:    fcmpu cr0, f1, f0
; NO-FAST-P8-NEXT:    bc 12, lt, .LBB24_3
; NO-FAST-P8-NEXT:  # %bb.1: # %entry
; NO-FAST-P8-NEXT:    fcmpu cr0, f1, f1
; NO-FAST-P8-NEXT:    bc 12, un, .LBB24_3
; NO-FAST-P8-NEXT:  # %bb.2: # %entry
; NO-FAST-P8-NEXT:    fmr f3, f2
; NO-FAST-P8-NEXT:  .LBB24_3: # %entry
; NO-FAST-P8-NEXT:    fmr f1, f3
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: onecmp1:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    vspltisw v2, 1
; NO-FAST-P9-NEXT:    xvcvsxwdp vs0, vs34
; NO-FAST-P9-NEXT:    fcmpu cr0, f1, f0
; NO-FAST-P9-NEXT:    bc 12, lt, .LBB24_3
; NO-FAST-P9-NEXT:  # %bb.1: # %entry
; NO-FAST-P9-NEXT:    fcmpu cr0, f1, f1
; NO-FAST-P9-NEXT:    bc 12, un, .LBB24_3
; NO-FAST-P9-NEXT:  # %bb.2: # %entry
; NO-FAST-P9-NEXT:    fmr f3, f2
; NO-FAST-P9-NEXT:  .LBB24_3: # %entry
; NO-FAST-P9-NEXT:    fmr f1, f3
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp ult double %a, 1.000000e+00
  %z.y = select i1 %cmp, double %z, double %y
  ret double %z.y
}

define double @onecmp2(double %a, double %y, double %z) {
; FAST-P8-LABEL: onecmp2:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    vspltisw v2, 1
; FAST-P8-NEXT:    xvcvsxwdp vs0, vs34
; FAST-P8-NEXT:    xssubdp f0, f0, f1
; FAST-P8-NEXT:    fsel f1, f0, f3, f2
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: onecmp2:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    vspltisw v2, 1
; FAST-P9-NEXT:    xvcvsxwdp vs0, vs34
; FAST-P9-NEXT:    xssubdp f0, f0, f1
; FAST-P9-NEXT:    fsel f1, f0, f3, f2
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: onecmp2:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    vspltisw v2, 1
; NO-FAST-P8-NEXT:    xvcvsxwdp vs0, vs34
; NO-FAST-P8-NEXT:    xscmpudp cr0, f1, f0
; NO-FAST-P8-NEXT:    bgt cr0, .LBB25_2
; NO-FAST-P8-NEXT:  # %bb.1: # %entry
; NO-FAST-P8-NEXT:    fmr f2, f3
; NO-FAST-P8-NEXT:  .LBB25_2: # %entry
; NO-FAST-P8-NEXT:    fmr f1, f2
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: onecmp2:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    vspltisw v2, 1
; NO-FAST-P9-NEXT:    xvcvsxwdp vs0, vs34
; NO-FAST-P9-NEXT:    xscmpudp cr0, f1, f0
; NO-FAST-P9-NEXT:    bgt cr0, .LBB25_2
; NO-FAST-P9-NEXT:  # %bb.1: # %entry
; NO-FAST-P9-NEXT:    fmr f2, f3
; NO-FAST-P9-NEXT:  .LBB25_2: # %entry
; NO-FAST-P9-NEXT:    fmr f1, f2
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp ogt double %a, 1.000000e+00
  %y.z = select i1 %cmp, double %y, double %z
  ret double %y.z
}

define double @onecmp3(double %a, double %y, double %z) {
; FAST-P8-LABEL: onecmp3:
; FAST-P8:       # %bb.0: # %entry
; FAST-P8-NEXT:    vspltisw v2, -1
; FAST-P8-NEXT:    xvcvsxwdp vs0, vs34
; FAST-P8-NEXT:    xsadddp f0, f1, f0
; FAST-P8-NEXT:    fsel f1, f0, f2, f3
; FAST-P8-NEXT:    xsnegdp f0, f0
; FAST-P8-NEXT:    fsel f1, f0, f1, f3
; FAST-P8-NEXT:    blr
;
; FAST-P9-LABEL: onecmp3:
; FAST-P9:       # %bb.0: # %entry
; FAST-P9-NEXT:    vspltisw v2, -1
; FAST-P9-NEXT:    xvcvsxwdp vs0, vs34
; FAST-P9-NEXT:    xsadddp f0, f1, f0
; FAST-P9-NEXT:    fsel f1, f0, f2, f3
; FAST-P9-NEXT:    xsnegdp f0, f0
; FAST-P9-NEXT:    fsel f1, f0, f1, f3
; FAST-P9-NEXT:    blr
;
; NO-FAST-P8-LABEL: onecmp3:
; NO-FAST-P8:       # %bb.0: # %entry
; NO-FAST-P8-NEXT:    vspltisw v2, 1
; NO-FAST-P8-NEXT:    xvcvsxwdp vs0, vs34
; NO-FAST-P8-NEXT:    xscmpudp cr0, f1, f0
; NO-FAST-P8-NEXT:    beq cr0, .LBB26_2
; NO-FAST-P8-NEXT:  # %bb.1: # %entry
; NO-FAST-P8-NEXT:    fmr f2, f3
; NO-FAST-P8-NEXT:  .LBB26_2: # %entry
; NO-FAST-P8-NEXT:    fmr f1, f2
; NO-FAST-P8-NEXT:    blr
;
; NO-FAST-P9-LABEL: onecmp3:
; NO-FAST-P9:       # %bb.0: # %entry
; NO-FAST-P9-NEXT:    vspltisw v2, 1
; NO-FAST-P9-NEXT:    xvcvsxwdp vs0, vs34
; NO-FAST-P9-NEXT:    xscmpudp cr0, f1, f0
; NO-FAST-P9-NEXT:    beq cr0, .LBB26_2
; NO-FAST-P9-NEXT:  # %bb.1: # %entry
; NO-FAST-P9-NEXT:    fmr f2, f3
; NO-FAST-P9-NEXT:  .LBB26_2: # %entry
; NO-FAST-P9-NEXT:    fmr f1, f2
; NO-FAST-P9-NEXT:    blr
entry:
  %cmp = fcmp oeq double %a, 1.000000e+00
  %y.z = select i1 %cmp, double %y, double %z
  ret double %y.z
}
