; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-apple-darwin -mattr=avx,aes,pclmul | FileCheck %s --check-prefix=AVX
; RUN: llc < %s -mtriple=i686-apple-darwin -mattr=avx512vl,aes,pclmul | FileCheck %s --check-prefix=AVX512VL

define <2 x i64> @test_x86_aesni_aesdec(<2 x i64> %a0, <2 x i64> %a1) {
; AVX-LABEL: test_x86_aesni_aesdec:
; AVX:       ## BB#0:
; AVX-NEXT:    vaesdec %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_aesni_aesdec:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vaesdec %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x i64> @llvm.x86.aesni.aesdec(<2 x i64> %a0, <2 x i64> %a1) ; <<2 x i64>> [#uses=1]
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.aesni.aesdec(<2 x i64>, <2 x i64>) nounwind readnone


define <2 x i64> @test_x86_aesni_aesdeclast(<2 x i64> %a0, <2 x i64> %a1) {
; AVX-LABEL: test_x86_aesni_aesdeclast:
; AVX:       ## BB#0:
; AVX-NEXT:    vaesdeclast %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_aesni_aesdeclast:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vaesdeclast %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x i64> @llvm.x86.aesni.aesdeclast(<2 x i64> %a0, <2 x i64> %a1) ; <<2 x i64>> [#uses=1]
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.aesni.aesdeclast(<2 x i64>, <2 x i64>) nounwind readnone


define <2 x i64> @test_x86_aesni_aesenc(<2 x i64> %a0, <2 x i64> %a1) {
; AVX-LABEL: test_x86_aesni_aesenc:
; AVX:       ## BB#0:
; AVX-NEXT:    vaesenc %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_aesni_aesenc:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vaesenc %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x i64> @llvm.x86.aesni.aesenc(<2 x i64> %a0, <2 x i64> %a1) ; <<2 x i64>> [#uses=1]
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.aesni.aesenc(<2 x i64>, <2 x i64>) nounwind readnone


define <2 x i64> @test_x86_aesni_aesenclast(<2 x i64> %a0, <2 x i64> %a1) {
; AVX-LABEL: test_x86_aesni_aesenclast:
; AVX:       ## BB#0:
; AVX-NEXT:    vaesenclast %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_aesni_aesenclast:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vaesenclast %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x i64> @llvm.x86.aesni.aesenclast(<2 x i64> %a0, <2 x i64> %a1) ; <<2 x i64>> [#uses=1]
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.aesni.aesenclast(<2 x i64>, <2 x i64>) nounwind readnone


define <2 x i64> @test_x86_aesni_aesimc(<2 x i64> %a0) {
; AVX-LABEL: test_x86_aesni_aesimc:
; AVX:       ## BB#0:
; AVX-NEXT:    vaesimc %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_aesni_aesimc:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vaesimc %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x i64> @llvm.x86.aesni.aesimc(<2 x i64> %a0) ; <<2 x i64>> [#uses=1]
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.aesni.aesimc(<2 x i64>) nounwind readnone


define <2 x i64> @test_x86_aesni_aeskeygenassist(<2 x i64> %a0) {
; AVX-LABEL: test_x86_aesni_aeskeygenassist:
; AVX:       ## BB#0:
; AVX-NEXT:    vaeskeygenassist $7, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_aesni_aeskeygenassist:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vaeskeygenassist $7, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x i64> @llvm.x86.aesni.aeskeygenassist(<2 x i64> %a0, i8 7) ; <<2 x i64>> [#uses=1]
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.aesni.aeskeygenassist(<2 x i64>, i8) nounwind readnone


define <2 x double> @test_x86_sse2_add_sd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse2_add_sd:
; AVX:       ## BB#0:
; AVX-NEXT:    vaddsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_add_sd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vaddsd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse2.add.sd(<2 x double> %a0, <2 x double> %a1) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse2.add.sd(<2 x double>, <2 x double>) nounwind readnone


define <2 x double> @test_x86_sse2_cmp_pd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse2_cmp_pd:
; AVX:       ## BB#0:
; AVX-NEXT:    vcmpordpd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_cmp_pd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcmpordpd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse2.cmp.pd(<2 x double> %a0, <2 x double> %a1, i8 7) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse2.cmp.pd(<2 x double>, <2 x double>, i8) nounwind readnone


define <2 x double> @test_x86_sse2_cmp_sd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse2_cmp_sd:
; AVX:       ## BB#0:
; AVX-NEXT:    vcmpordsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_cmp_sd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcmpordsd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse2.cmp.sd(<2 x double> %a0, <2 x double> %a1, i8 7) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse2.cmp.sd(<2 x double>, <2 x double>, i8) nounwind readnone


define i32 @test_x86_sse2_comieq_sd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse2_comieq_sd:
; AVX:       ## BB#0:
; AVX-NEXT:    vcomisd %xmm1, %xmm0
; AVX-NEXT:    setnp %al
; AVX-NEXT:    sete %cl
; AVX-NEXT:    andb %al, %cl
; AVX-NEXT:    movzbl %cl, %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_comieq_sd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcomisd %xmm1, %xmm0
; AVX512VL-NEXT:    setnp %al
; AVX512VL-NEXT:    sete %cl
; AVX512VL-NEXT:    andb %al, %cl
; AVX512VL-NEXT:    movzbl %cl, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse2.comieq.sd(<2 x double> %a0, <2 x double> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse2.comieq.sd(<2 x double>, <2 x double>) nounwind readnone


define i32 @test_x86_sse2_comige_sd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse2_comige_sd:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vcomisd %xmm1, %xmm0
; AVX-NEXT:    setae %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_comige_sd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vcomisd %xmm1, %xmm0
; AVX512VL-NEXT:    setae %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse2.comige.sd(<2 x double> %a0, <2 x double> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse2.comige.sd(<2 x double>, <2 x double>) nounwind readnone


define i32 @test_x86_sse2_comigt_sd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse2_comigt_sd:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vcomisd %xmm1, %xmm0
; AVX-NEXT:    seta %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_comigt_sd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vcomisd %xmm1, %xmm0
; AVX512VL-NEXT:    seta %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse2.comigt.sd(<2 x double> %a0, <2 x double> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse2.comigt.sd(<2 x double>, <2 x double>) nounwind readnone


define i32 @test_x86_sse2_comile_sd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse2_comile_sd:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vcomisd %xmm0, %xmm1
; AVX-NEXT:    setae %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_comile_sd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vcomisd %xmm0, %xmm1
; AVX512VL-NEXT:    setae %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse2.comile.sd(<2 x double> %a0, <2 x double> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse2.comile.sd(<2 x double>, <2 x double>) nounwind readnone


define i32 @test_x86_sse2_comilt_sd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse2_comilt_sd:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vcomisd %xmm0, %xmm1
; AVX-NEXT:    seta %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_comilt_sd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vcomisd %xmm0, %xmm1
; AVX512VL-NEXT:    seta %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse2.comilt.sd(<2 x double> %a0, <2 x double> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse2.comilt.sd(<2 x double>, <2 x double>) nounwind readnone


define i32 @test_x86_sse2_comineq_sd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse2_comineq_sd:
; AVX:       ## BB#0:
; AVX-NEXT:    vcomisd %xmm1, %xmm0
; AVX-NEXT:    setp %al
; AVX-NEXT:    setne %cl
; AVX-NEXT:    orb %al, %cl
; AVX-NEXT:    movzbl %cl, %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_comineq_sd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcomisd %xmm1, %xmm0
; AVX512VL-NEXT:    setp %al
; AVX512VL-NEXT:    setne %cl
; AVX512VL-NEXT:    orb %al, %cl
; AVX512VL-NEXT:    movzbl %cl, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse2.comineq.sd(<2 x double> %a0, <2 x double> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse2.comineq.sd(<2 x double>, <2 x double>) nounwind readnone


define <4 x float> @test_x86_sse2_cvtdq2ps(<4 x i32> %a0) {
; AVX-LABEL: test_x86_sse2_cvtdq2ps:
; AVX:       ## BB#0:
; AVX-NEXT:    vcvtdq2ps %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_cvtdq2ps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcvtdq2ps %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse2.cvtdq2ps(<4 x i32> %a0) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse2.cvtdq2ps(<4 x i32>) nounwind readnone


define <4 x i32> @test_x86_sse2_cvtpd2dq(<2 x double> %a0) {
; AVX-LABEL: test_x86_sse2_cvtpd2dq:
; AVX:       ## BB#0:
; AVX-NEXT:    vcvtpd2dq %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_cvtpd2dq:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcvtpd2dq %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.sse2.cvtpd2dq(<2 x double> %a0) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.sse2.cvtpd2dq(<2 x double>) nounwind readnone


define <4 x float> @test_x86_sse2_cvtpd2ps(<2 x double> %a0) {
; AVX-LABEL: test_x86_sse2_cvtpd2ps:
; AVX:       ## BB#0:
; AVX-NEXT:    vcvtpd2ps %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_cvtpd2ps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcvtpd2ps %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse2.cvtpd2ps(<2 x double> %a0) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse2.cvtpd2ps(<2 x double>) nounwind readnone


define <4 x i32> @test_x86_sse2_cvtps2dq(<4 x float> %a0) {
; AVX-LABEL: test_x86_sse2_cvtps2dq:
; AVX:       ## BB#0:
; AVX-NEXT:    vcvtps2dq %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_cvtps2dq:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcvtps2dq %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.sse2.cvtps2dq(<4 x float> %a0) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.sse2.cvtps2dq(<4 x float>) nounwind readnone


define i32 @test_x86_sse2_cvtsd2si(<2 x double> %a0) {
; AVX-LABEL: test_x86_sse2_cvtsd2si:
; AVX:       ## BB#0:
; AVX-NEXT:    vcvtsd2si %xmm0, %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_cvtsd2si:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcvtsd2si %xmm0, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse2.cvtsd2si(<2 x double> %a0) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse2.cvtsd2si(<2 x double>) nounwind readnone


define <4 x float> @test_x86_sse2_cvtsd2ss(<4 x float> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse2_cvtsd2ss:
; AVX:       ## BB#0:
; AVX-NEXT:    vcvtsd2ss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_cvtsd2ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcvtsd2ss %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse2.cvtsd2ss(<4 x float> %a0, <2 x double> %a1) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse2.cvtsd2ss(<4 x float>, <2 x double>) nounwind readnone


define <2 x double> @test_x86_sse2_cvtsi2sd(<2 x double> %a0, i32 %a1) {
; AVX-LABEL: test_x86_sse2_cvtsi2sd:
; AVX:       ## BB#0:
; AVX-NEXT:    vcvtsi2sdl {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_cvtsi2sd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcvtsi2sdl {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse2.cvtsi2sd(<2 x double> %a0, i32 %a1) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse2.cvtsi2sd(<2 x double>, i32) nounwind readnone


define <2 x double> @test_x86_sse2_cvtss2sd(<2 x double> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse2_cvtss2sd:
; AVX:       ## BB#0:
; AVX-NEXT:    vcvtss2sd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_cvtss2sd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcvtss2sd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse2.cvtss2sd(<2 x double> %a0, <4 x float> %a1) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse2.cvtss2sd(<2 x double>, <4 x float>) nounwind readnone


define <4 x i32> @test_x86_sse2_cvttpd2dq(<2 x double> %a0) {
; AVX-LABEL: test_x86_sse2_cvttpd2dq:
; AVX:       ## BB#0:
; AVX-NEXT:    vcvttpd2dq %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_cvttpd2dq:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcvttpd2dq %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.sse2.cvttpd2dq(<2 x double> %a0) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.sse2.cvttpd2dq(<2 x double>) nounwind readnone


define <4 x i32> @test_x86_sse2_cvttps2dq(<4 x float> %a0) {
; AVX-LABEL: test_x86_sse2_cvttps2dq:
; AVX:       ## BB#0:
; AVX-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_cvttps2dq:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcvttps2dq %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.sse2.cvttps2dq(<4 x float> %a0) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.sse2.cvttps2dq(<4 x float>) nounwind readnone


define i32 @test_x86_sse2_cvttsd2si(<2 x double> %a0) {
; AVX-LABEL: test_x86_sse2_cvttsd2si:
; AVX:       ## BB#0:
; AVX-NEXT:    vcvttsd2si %xmm0, %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_cvttsd2si:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcvttsd2si %xmm0, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse2.cvttsd2si(<2 x double> %a0) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse2.cvttsd2si(<2 x double>) nounwind readnone


define <2 x double> @test_x86_sse2_div_sd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse2_div_sd:
; AVX:       ## BB#0:
; AVX-NEXT:    vdivsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_div_sd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vdivsd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse2.div.sd(<2 x double> %a0, <2 x double> %a1) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse2.div.sd(<2 x double>, <2 x double>) nounwind readnone



define <2 x double> @test_x86_sse2_max_pd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse2_max_pd:
; AVX:       ## BB#0:
; AVX-NEXT:    vmaxpd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_max_pd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vmaxpd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse2.max.pd(<2 x double> %a0, <2 x double> %a1) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse2.max.pd(<2 x double>, <2 x double>) nounwind readnone


define <2 x double> @test_x86_sse2_max_sd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse2_max_sd:
; AVX:       ## BB#0:
; AVX-NEXT:    vmaxsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_max_sd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vmaxsd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse2.max.sd(<2 x double> %a0, <2 x double> %a1) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse2.max.sd(<2 x double>, <2 x double>) nounwind readnone


define <2 x double> @test_x86_sse2_min_pd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse2_min_pd:
; AVX:       ## BB#0:
; AVX-NEXT:    vminpd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_min_pd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vminpd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse2.min.pd(<2 x double> %a0, <2 x double> %a1) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse2.min.pd(<2 x double>, <2 x double>) nounwind readnone


define <2 x double> @test_x86_sse2_min_sd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse2_min_sd:
; AVX:       ## BB#0:
; AVX-NEXT:    vminsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_min_sd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vminsd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse2.min.sd(<2 x double> %a0, <2 x double> %a1) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse2.min.sd(<2 x double>, <2 x double>) nounwind readnone


define i32 @test_x86_sse2_movmsk_pd(<2 x double> %a0) {
; AVX-LABEL: test_x86_sse2_movmsk_pd:
; AVX:       ## BB#0:
; AVX-NEXT:    vmovmskpd %xmm0, %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_movmsk_pd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vmovmskpd %xmm0, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse2.movmsk.pd(<2 x double> %a0) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse2.movmsk.pd(<2 x double>) nounwind readnone




define <2 x double> @test_x86_sse2_mul_sd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse2_mul_sd:
; AVX:       ## BB#0:
; AVX-NEXT:    vmulsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_mul_sd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vmulsd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse2.mul.sd(<2 x double> %a0, <2 x double> %a1) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse2.mul.sd(<2 x double>, <2 x double>) nounwind readnone


define <8 x i16> @test_x86_sse2_packssdw_128(<4 x i32> %a0, <4 x i32> %a1) {
; AVX-LABEL: test_x86_sse2_packssdw_128:
; AVX:       ## BB#0:
; AVX-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_packssdw_128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpackssdw %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse2.packssdw.128(<4 x i32> %a0, <4 x i32> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse2.packssdw.128(<4 x i32>, <4 x i32>) nounwind readnone


define <16 x i8> @test_x86_sse2_packsswb_128(<8 x i16> %a0, <8 x i16> %a1) {
; AVX-LABEL: test_x86_sse2_packsswb_128:
; AVX:       ## BB#0:
; AVX-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_packsswb_128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i8> @llvm.x86.sse2.packsswb.128(<8 x i16> %a0, <8 x i16> %a1) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.x86.sse2.packsswb.128(<8 x i16>, <8 x i16>) nounwind readnone


define <16 x i8> @test_x86_sse2_packuswb_128(<8 x i16> %a0, <8 x i16> %a1) {
; AVX-LABEL: test_x86_sse2_packuswb_128:
; AVX:       ## BB#0:
; AVX-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_packuswb_128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i8> @llvm.x86.sse2.packuswb.128(<8 x i16> %a0, <8 x i16> %a1) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.x86.sse2.packuswb.128(<8 x i16>, <8 x i16>) nounwind readnone


define <16 x i8> @test_x86_sse2_padds_b(<16 x i8> %a0, <16 x i8> %a1) {
; AVX-LABEL: test_x86_sse2_padds_b:
; AVX:       ## BB#0:
; AVX-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_padds_b:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpaddsb %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i8> @llvm.x86.sse2.padds.b(<16 x i8> %a0, <16 x i8> %a1) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.x86.sse2.padds.b(<16 x i8>, <16 x i8>) nounwind readnone


define <8 x i16> @test_x86_sse2_padds_w(<8 x i16> %a0, <8 x i16> %a1) {
; AVX-LABEL: test_x86_sse2_padds_w:
; AVX:       ## BB#0:
; AVX-NEXT:    vpaddsw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_padds_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpaddsw %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse2.padds.w(<8 x i16> %a0, <8 x i16> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse2.padds.w(<8 x i16>, <8 x i16>) nounwind readnone


define <16 x i8> @test_x86_sse2_paddus_b(<16 x i8> %a0, <16 x i8> %a1) {
; AVX-LABEL: test_x86_sse2_paddus_b:
; AVX:       ## BB#0:
; AVX-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_paddus_b:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i8> @llvm.x86.sse2.paddus.b(<16 x i8> %a0, <16 x i8> %a1) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.x86.sse2.paddus.b(<16 x i8>, <16 x i8>) nounwind readnone


define <8 x i16> @test_x86_sse2_paddus_w(<8 x i16> %a0, <8 x i16> %a1) {
; AVX-LABEL: test_x86_sse2_paddus_w:
; AVX:       ## BB#0:
; AVX-NEXT:    vpaddusw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_paddus_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpaddusw %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse2.paddus.w(<8 x i16> %a0, <8 x i16> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse2.paddus.w(<8 x i16>, <8 x i16>) nounwind readnone


define <16 x i8> @test_x86_sse2_pavg_b(<16 x i8> %a0, <16 x i8> %a1) {
; AVX-LABEL: test_x86_sse2_pavg_b:
; AVX:       ## BB#0:
; AVX-NEXT:    vpavgb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_pavg_b:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpavgb %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i8> @llvm.x86.sse2.pavg.b(<16 x i8> %a0, <16 x i8> %a1) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.x86.sse2.pavg.b(<16 x i8>, <16 x i8>) nounwind readnone


define <8 x i16> @test_x86_sse2_pavg_w(<8 x i16> %a0, <8 x i16> %a1) {
; AVX-LABEL: test_x86_sse2_pavg_w:
; AVX:       ## BB#0:
; AVX-NEXT:    vpavgw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_pavg_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpavgw %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse2.pavg.w(<8 x i16> %a0, <8 x i16> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse2.pavg.w(<8 x i16>, <8 x i16>) nounwind readnone


define <4 x i32> @test_x86_sse2_pmadd_wd(<8 x i16> %a0, <8 x i16> %a1) {
; AVX-LABEL: test_x86_sse2_pmadd_wd:
; AVX:       ## BB#0:
; AVX-NEXT:    vpmaddwd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_pmadd_wd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmaddwd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.sse2.pmadd.wd(<8 x i16> %a0, <8 x i16> %a1) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.sse2.pmadd.wd(<8 x i16>, <8 x i16>) nounwind readnone


define <8 x i16> @test_x86_sse2_pmaxs_w(<8 x i16> %a0, <8 x i16> %a1) {
; AVX-LABEL: test_x86_sse2_pmaxs_w:
; AVX:       ## BB#0:
; AVX-NEXT:    vpmaxsw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_pmaxs_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmaxsw %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse2.pmaxs.w(<8 x i16> %a0, <8 x i16> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse2.pmaxs.w(<8 x i16>, <8 x i16>) nounwind readnone


define <16 x i8> @test_x86_sse2_pmaxu_b(<16 x i8> %a0, <16 x i8> %a1) {
; AVX-LABEL: test_x86_sse2_pmaxu_b:
; AVX:       ## BB#0:
; AVX-NEXT:    vpmaxub %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_pmaxu_b:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmaxub %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i8> @llvm.x86.sse2.pmaxu.b(<16 x i8> %a0, <16 x i8> %a1) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.x86.sse2.pmaxu.b(<16 x i8>, <16 x i8>) nounwind readnone


define <8 x i16> @test_x86_sse2_pmins_w(<8 x i16> %a0, <8 x i16> %a1) {
; AVX-LABEL: test_x86_sse2_pmins_w:
; AVX:       ## BB#0:
; AVX-NEXT:    vpminsw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_pmins_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpminsw %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse2.pmins.w(<8 x i16> %a0, <8 x i16> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse2.pmins.w(<8 x i16>, <8 x i16>) nounwind readnone


define <16 x i8> @test_x86_sse2_pminu_b(<16 x i8> %a0, <16 x i8> %a1) {
; AVX-LABEL: test_x86_sse2_pminu_b:
; AVX:       ## BB#0:
; AVX-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_pminu_b:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i8> @llvm.x86.sse2.pminu.b(<16 x i8> %a0, <16 x i8> %a1) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.x86.sse2.pminu.b(<16 x i8>, <16 x i8>) nounwind readnone


define i32 @test_x86_sse2_pmovmskb_128(<16 x i8> %a0) {
; AVX-LABEL: test_x86_sse2_pmovmskb_128:
; AVX:       ## BB#0:
; AVX-NEXT:    vpmovmskb %xmm0, %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_pmovmskb_128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmovmskb %xmm0, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse2.pmovmskb.128(<16 x i8> %a0) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse2.pmovmskb.128(<16 x i8>) nounwind readnone


define <8 x i16> @test_x86_sse2_pmulh_w(<8 x i16> %a0, <8 x i16> %a1) {
; AVX-LABEL: test_x86_sse2_pmulh_w:
; AVX:       ## BB#0:
; AVX-NEXT:    vpmulhw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_pmulh_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmulhw %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse2.pmulh.w(<8 x i16> %a0, <8 x i16> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse2.pmulh.w(<8 x i16>, <8 x i16>) nounwind readnone


define <8 x i16> @test_x86_sse2_pmulhu_w(<8 x i16> %a0, <8 x i16> %a1) {
; AVX-LABEL: test_x86_sse2_pmulhu_w:
; AVX:       ## BB#0:
; AVX-NEXT:    vpmulhuw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_pmulhu_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmulhuw %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse2.pmulhu.w(<8 x i16> %a0, <8 x i16> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse2.pmulhu.w(<8 x i16>, <8 x i16>) nounwind readnone


define <2 x i64> @test_x86_sse2_pmulu_dq(<4 x i32> %a0, <4 x i32> %a1) {
; AVX-LABEL: test_x86_sse2_pmulu_dq:
; AVX:       ## BB#0:
; AVX-NEXT:    vpmuludq %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_pmulu_dq:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmuludq %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x i64> @llvm.x86.sse2.pmulu.dq(<4 x i32> %a0, <4 x i32> %a1) ; <<2 x i64>> [#uses=1]
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.sse2.pmulu.dq(<4 x i32>, <4 x i32>) nounwind readnone


define <2 x i64> @test_x86_sse2_psad_bw(<16 x i8> %a0, <16 x i8> %a1) {
; AVX-LABEL: test_x86_sse2_psad_bw:
; AVX:       ## BB#0:
; AVX-NEXT:    vpsadbw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_psad_bw:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsadbw %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x i64> @llvm.x86.sse2.psad.bw(<16 x i8> %a0, <16 x i8> %a1) ; <<2 x i64>> [#uses=1]
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.sse2.psad.bw(<16 x i8>, <16 x i8>) nounwind readnone


define <4 x i32> @test_x86_sse2_psll_d(<4 x i32> %a0, <4 x i32> %a1) {
; AVX-LABEL: test_x86_sse2_psll_d:
; AVX:       ## BB#0:
; AVX-NEXT:    vpslld %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_psll_d:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpslld %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.sse2.psll.d(<4 x i32> %a0, <4 x i32> %a1) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.sse2.psll.d(<4 x i32>, <4 x i32>) nounwind readnone


define <2 x i64> @test_x86_sse2_psll_q(<2 x i64> %a0, <2 x i64> %a1) {
; AVX-LABEL: test_x86_sse2_psll_q:
; AVX:       ## BB#0:
; AVX-NEXT:    vpsllq %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_psll_q:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsllq %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x i64> @llvm.x86.sse2.psll.q(<2 x i64> %a0, <2 x i64> %a1) ; <<2 x i64>> [#uses=1]
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.sse2.psll.q(<2 x i64>, <2 x i64>) nounwind readnone


define <8 x i16> @test_x86_sse2_psll_w(<8 x i16> %a0, <8 x i16> %a1) {
; AVX-LABEL: test_x86_sse2_psll_w:
; AVX:       ## BB#0:
; AVX-NEXT:    vpsllw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_psll_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsllw %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse2.psll.w(<8 x i16> %a0, <8 x i16> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse2.psll.w(<8 x i16>, <8 x i16>) nounwind readnone


define <4 x i32> @test_x86_sse2_pslli_d(<4 x i32> %a0) {
; AVX-LABEL: test_x86_sse2_pslli_d:
; AVX:       ## BB#0:
; AVX-NEXT:    vpslld $7, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_pslli_d:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpslld $7, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.sse2.pslli.d(<4 x i32> %a0, i32 7) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.sse2.pslli.d(<4 x i32>, i32) nounwind readnone


define <2 x i64> @test_x86_sse2_pslli_q(<2 x i64> %a0) {
; AVX-LABEL: test_x86_sse2_pslli_q:
; AVX:       ## BB#0:
; AVX-NEXT:    vpsllq $7, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_pslli_q:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsllq $7, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x i64> @llvm.x86.sse2.pslli.q(<2 x i64> %a0, i32 7) ; <<2 x i64>> [#uses=1]
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.sse2.pslli.q(<2 x i64>, i32) nounwind readnone


define <8 x i16> @test_x86_sse2_pslli_w(<8 x i16> %a0) {
; AVX-LABEL: test_x86_sse2_pslli_w:
; AVX:       ## BB#0:
; AVX-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_pslli_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse2.pslli.w(<8 x i16> %a0, i32 7) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse2.pslli.w(<8 x i16>, i32) nounwind readnone


define <4 x i32> @test_x86_sse2_psra_d(<4 x i32> %a0, <4 x i32> %a1) {
; AVX-LABEL: test_x86_sse2_psra_d:
; AVX:       ## BB#0:
; AVX-NEXT:    vpsrad %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_psra_d:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsrad %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.sse2.psra.d(<4 x i32> %a0, <4 x i32> %a1) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.sse2.psra.d(<4 x i32>, <4 x i32>) nounwind readnone


define <8 x i16> @test_x86_sse2_psra_w(<8 x i16> %a0, <8 x i16> %a1) {
; AVX-LABEL: test_x86_sse2_psra_w:
; AVX:       ## BB#0:
; AVX-NEXT:    vpsraw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_psra_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsraw %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse2.psra.w(<8 x i16> %a0, <8 x i16> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse2.psra.w(<8 x i16>, <8 x i16>) nounwind readnone


define <4 x i32> @test_x86_sse2_psrai_d(<4 x i32> %a0) {
; AVX-LABEL: test_x86_sse2_psrai_d:
; AVX:       ## BB#0:
; AVX-NEXT:    vpsrad $7, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_psrai_d:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsrad $7, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.sse2.psrai.d(<4 x i32> %a0, i32 7) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.sse2.psrai.d(<4 x i32>, i32) nounwind readnone


define <8 x i16> @test_x86_sse2_psrai_w(<8 x i16> %a0) {
; AVX-LABEL: test_x86_sse2_psrai_w:
; AVX:       ## BB#0:
; AVX-NEXT:    vpsraw $7, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_psrai_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsraw $7, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse2.psrai.w(<8 x i16> %a0, i32 7) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse2.psrai.w(<8 x i16>, i32) nounwind readnone


define <4 x i32> @test_x86_sse2_psrl_d(<4 x i32> %a0, <4 x i32> %a1) {
; AVX-LABEL: test_x86_sse2_psrl_d:
; AVX:       ## BB#0:
; AVX-NEXT:    vpsrld %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_psrl_d:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsrld %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.sse2.psrl.d(<4 x i32> %a0, <4 x i32> %a1) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.sse2.psrl.d(<4 x i32>, <4 x i32>) nounwind readnone


define <2 x i64> @test_x86_sse2_psrl_q(<2 x i64> %a0, <2 x i64> %a1) {
; AVX-LABEL: test_x86_sse2_psrl_q:
; AVX:       ## BB#0:
; AVX-NEXT:    vpsrlq %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_psrl_q:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsrlq %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x i64> @llvm.x86.sse2.psrl.q(<2 x i64> %a0, <2 x i64> %a1) ; <<2 x i64>> [#uses=1]
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.sse2.psrl.q(<2 x i64>, <2 x i64>) nounwind readnone


define <8 x i16> @test_x86_sse2_psrl_w(<8 x i16> %a0, <8 x i16> %a1) {
; AVX-LABEL: test_x86_sse2_psrl_w:
; AVX:       ## BB#0:
; AVX-NEXT:    vpsrlw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_psrl_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsrlw %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse2.psrl.w(<8 x i16> %a0, <8 x i16> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse2.psrl.w(<8 x i16>, <8 x i16>) nounwind readnone


define <4 x i32> @test_x86_sse2_psrli_d(<4 x i32> %a0) {
; AVX-LABEL: test_x86_sse2_psrli_d:
; AVX:       ## BB#0:
; AVX-NEXT:    vpsrld $7, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_psrli_d:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsrld $7, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.sse2.psrli.d(<4 x i32> %a0, i32 7) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.sse2.psrli.d(<4 x i32>, i32) nounwind readnone


define <2 x i64> @test_x86_sse2_psrli_q(<2 x i64> %a0) {
; AVX-LABEL: test_x86_sse2_psrli_q:
; AVX:       ## BB#0:
; AVX-NEXT:    vpsrlq $7, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_psrli_q:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsrlq $7, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x i64> @llvm.x86.sse2.psrli.q(<2 x i64> %a0, i32 7) ; <<2 x i64>> [#uses=1]
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.sse2.psrli.q(<2 x i64>, i32) nounwind readnone


define <8 x i16> @test_x86_sse2_psrli_w(<8 x i16> %a0) {
; AVX-LABEL: test_x86_sse2_psrli_w:
; AVX:       ## BB#0:
; AVX-NEXT:    vpsrlw $7, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_psrli_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsrlw $7, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse2.psrli.w(<8 x i16> %a0, i32 7) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse2.psrli.w(<8 x i16>, i32) nounwind readnone


define <16 x i8> @test_x86_sse2_psubs_b(<16 x i8> %a0, <16 x i8> %a1) {
; AVX-LABEL: test_x86_sse2_psubs_b:
; AVX:       ## BB#0:
; AVX-NEXT:    vpsubsb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_psubs_b:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsubsb %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i8> @llvm.x86.sse2.psubs.b(<16 x i8> %a0, <16 x i8> %a1) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.x86.sse2.psubs.b(<16 x i8>, <16 x i8>) nounwind readnone


define <8 x i16> @test_x86_sse2_psubs_w(<8 x i16> %a0, <8 x i16> %a1) {
; AVX-LABEL: test_x86_sse2_psubs_w:
; AVX:       ## BB#0:
; AVX-NEXT:    vpsubsw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_psubs_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsubsw %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse2.psubs.w(<8 x i16> %a0, <8 x i16> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse2.psubs.w(<8 x i16>, <8 x i16>) nounwind readnone


define <16 x i8> @test_x86_sse2_psubus_b(<16 x i8> %a0, <16 x i8> %a1) {
; AVX-LABEL: test_x86_sse2_psubus_b:
; AVX:       ## BB#0:
; AVX-NEXT:    vpsubusb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_psubus_b:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsubusb %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i8> @llvm.x86.sse2.psubus.b(<16 x i8> %a0, <16 x i8> %a1) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.x86.sse2.psubus.b(<16 x i8>, <16 x i8>) nounwind readnone


define <8 x i16> @test_x86_sse2_psubus_w(<8 x i16> %a0, <8 x i16> %a1) {
; AVX-LABEL: test_x86_sse2_psubus_w:
; AVX:       ## BB#0:
; AVX-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_psubus_w:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsubusw %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse2.psubus.w(<8 x i16> %a0, <8 x i16> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse2.psubus.w(<8 x i16>, <8 x i16>) nounwind readnone


define <2 x double> @test_x86_sse2_sqrt_pd(<2 x double> %a0) {
; AVX-LABEL: test_x86_sse2_sqrt_pd:
; AVX:       ## BB#0:
; AVX-NEXT:    vsqrtpd %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_sqrt_pd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vsqrtpd %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse2.sqrt.pd(<2 x double> %a0) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse2.sqrt.pd(<2 x double>) nounwind readnone


define <2 x double> @test_x86_sse2_sqrt_sd(<2 x double> %a0) {
; AVX-LABEL: test_x86_sse2_sqrt_sd:
; AVX:       ## BB#0:
; AVX-NEXT:    vsqrtsd %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_sqrt_sd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vsqrtsd %xmm0, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse2.sqrt.sd(<2 x double> %a0) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse2.sqrt.sd(<2 x double>) nounwind readnone


define <2 x double> @test_x86_sse2_sub_sd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse2_sub_sd:
; AVX:       ## BB#0:
; AVX-NEXT:    vsubsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_sub_sd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vsubsd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse2.sub.sd(<2 x double> %a0, <2 x double> %a1) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse2.sub.sd(<2 x double>, <2 x double>) nounwind readnone


define i32 @test_x86_sse2_ucomieq_sd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse2_ucomieq_sd:
; AVX:       ## BB#0:
; AVX-NEXT:    vucomisd %xmm1, %xmm0
; AVX-NEXT:    setnp %al
; AVX-NEXT:    sete %cl
; AVX-NEXT:    andb %al, %cl
; AVX-NEXT:    movzbl %cl, %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_ucomieq_sd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vucomisd %xmm1, %xmm0
; AVX512VL-NEXT:    setnp %al
; AVX512VL-NEXT:    sete %cl
; AVX512VL-NEXT:    andb %al, %cl
; AVX512VL-NEXT:    movzbl %cl, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse2.ucomieq.sd(<2 x double> %a0, <2 x double> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse2.ucomieq.sd(<2 x double>, <2 x double>) nounwind readnone


define i32 @test_x86_sse2_ucomige_sd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse2_ucomige_sd:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vucomisd %xmm1, %xmm0
; AVX-NEXT:    setae %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_ucomige_sd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vucomisd %xmm1, %xmm0
; AVX512VL-NEXT:    setae %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse2.ucomige.sd(<2 x double> %a0, <2 x double> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse2.ucomige.sd(<2 x double>, <2 x double>) nounwind readnone


define i32 @test_x86_sse2_ucomigt_sd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse2_ucomigt_sd:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vucomisd %xmm1, %xmm0
; AVX-NEXT:    seta %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_ucomigt_sd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vucomisd %xmm1, %xmm0
; AVX512VL-NEXT:    seta %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse2.ucomigt.sd(<2 x double> %a0, <2 x double> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse2.ucomigt.sd(<2 x double>, <2 x double>) nounwind readnone


define i32 @test_x86_sse2_ucomile_sd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse2_ucomile_sd:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vucomisd %xmm0, %xmm1
; AVX-NEXT:    setae %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_ucomile_sd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vucomisd %xmm0, %xmm1
; AVX512VL-NEXT:    setae %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse2.ucomile.sd(<2 x double> %a0, <2 x double> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse2.ucomile.sd(<2 x double>, <2 x double>) nounwind readnone


define i32 @test_x86_sse2_ucomilt_sd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse2_ucomilt_sd:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vucomisd %xmm0, %xmm1
; AVX-NEXT:    seta %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_ucomilt_sd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vucomisd %xmm0, %xmm1
; AVX512VL-NEXT:    seta %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse2.ucomilt.sd(<2 x double> %a0, <2 x double> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse2.ucomilt.sd(<2 x double>, <2 x double>) nounwind readnone


define i32 @test_x86_sse2_ucomineq_sd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse2_ucomineq_sd:
; AVX:       ## BB#0:
; AVX-NEXT:    vucomisd %xmm1, %xmm0
; AVX-NEXT:    setp %al
; AVX-NEXT:    setne %cl
; AVX-NEXT:    orb %al, %cl
; AVX-NEXT:    movzbl %cl, %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse2_ucomineq_sd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vucomisd %xmm1, %xmm0
; AVX512VL-NEXT:    setp %al
; AVX512VL-NEXT:    setne %cl
; AVX512VL-NEXT:    orb %al, %cl
; AVX512VL-NEXT:    movzbl %cl, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse2.ucomineq.sd(<2 x double> %a0, <2 x double> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse2.ucomineq.sd(<2 x double>, <2 x double>) nounwind readnone


define <2 x double> @test_x86_sse3_addsub_pd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse3_addsub_pd:
; AVX:       ## BB#0:
; AVX-NEXT:    vaddsubpd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse3_addsub_pd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vaddsubpd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse3.addsub.pd(<2 x double> %a0, <2 x double> %a1) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse3.addsub.pd(<2 x double>, <2 x double>) nounwind readnone


define <4 x float> @test_x86_sse3_addsub_ps(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse3_addsub_ps:
; AVX:       ## BB#0:
; AVX-NEXT:    vaddsubps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse3_addsub_ps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vaddsubps %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse3.addsub.ps(<4 x float> %a0, <4 x float> %a1) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse3.addsub.ps(<4 x float>, <4 x float>) nounwind readnone


define <2 x double> @test_x86_sse3_hadd_pd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse3_hadd_pd:
; AVX:       ## BB#0:
; AVX-NEXT:    vhaddpd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse3_hadd_pd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vhaddpd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse3.hadd.pd(<2 x double> %a0, <2 x double> %a1) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse3.hadd.pd(<2 x double>, <2 x double>) nounwind readnone


define <4 x float> @test_x86_sse3_hadd_ps(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse3_hadd_ps:
; AVX:       ## BB#0:
; AVX-NEXT:    vhaddps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse3_hadd_ps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vhaddps %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse3.hadd.ps(<4 x float> %a0, <4 x float> %a1) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse3.hadd.ps(<4 x float>, <4 x float>) nounwind readnone


define <2 x double> @test_x86_sse3_hsub_pd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse3_hsub_pd:
; AVX:       ## BB#0:
; AVX-NEXT:    vhsubpd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse3_hsub_pd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vhsubpd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse3.hsub.pd(<2 x double> %a0, <2 x double> %a1) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse3.hsub.pd(<2 x double>, <2 x double>) nounwind readnone


define <4 x float> @test_x86_sse3_hsub_ps(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse3_hsub_ps:
; AVX:       ## BB#0:
; AVX-NEXT:    vhsubps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse3_hsub_ps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vhsubps %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse3.hsub.ps(<4 x float> %a0, <4 x float> %a1) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse3.hsub.ps(<4 x float>, <4 x float>) nounwind readnone


define <16 x i8> @test_x86_sse3_ldu_dq(i8* %a0) {
; AVX-LABEL: test_x86_sse3_ldu_dq:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    vlddqu (%eax), %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse3_ldu_dq:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vlddqu (%eax), %xmm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i8> @llvm.x86.sse3.ldu.dq(i8* %a0) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.x86.sse3.ldu.dq(i8*) nounwind readonly


define <2 x double> @test_x86_sse41_blendvpd(<2 x double> %a0, <2 x double> %a1, <2 x double> %a2) {
; AVX-LABEL: test_x86_sse41_blendvpd:
; AVX:       ## BB#0:
; AVX-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_blendvpd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse41.blendvpd(<2 x double> %a0, <2 x double> %a1, <2 x double> %a2) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse41.blendvpd(<2 x double>, <2 x double>, <2 x double>) nounwind readnone


define <4 x float> @test_x86_sse41_blendvps(<4 x float> %a0, <4 x float> %a1, <4 x float> %a2) {
; AVX-LABEL: test_x86_sse41_blendvps:
; AVX:       ## BB#0:
; AVX-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_blendvps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse41.blendvps(<4 x float> %a0, <4 x float> %a1, <4 x float> %a2) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse41.blendvps(<4 x float>, <4 x float>, <4 x float>) nounwind readnone


define <2 x double> @test_x86_sse41_dppd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse41_dppd:
; AVX:       ## BB#0:
; AVX-NEXT:    vdppd $7, %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_dppd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vdppd $7, %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse41.dppd(<2 x double> %a0, <2 x double> %a1, i8 7) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse41.dppd(<2 x double>, <2 x double>, i8) nounwind readnone


define <4 x float> @test_x86_sse41_dpps(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse41_dpps:
; AVX:       ## BB#0:
; AVX-NEXT:    vdpps $7, %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_dpps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vdpps $7, %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse41.dpps(<4 x float> %a0, <4 x float> %a1, i8 7) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse41.dpps(<4 x float>, <4 x float>, i8) nounwind readnone


define <4 x float> @test_x86_sse41_insertps(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse41_insertps:
; AVX:       ## BB#0:
; AVX-NEXT:    vinsertps {{.*#+}} xmm0 = zero,xmm1[0],zero,xmm0[3]
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_insertps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = zero,xmm1[0],zero,xmm0[3]
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse41.insertps(<4 x float> %a0, <4 x float> %a1, i8 21) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse41.insertps(<4 x float>, <4 x float>, i8) nounwind readnone



define <8 x i16> @test_x86_sse41_mpsadbw(<16 x i8> %a0, <16 x i8> %a1) {
; AVX-LABEL: test_x86_sse41_mpsadbw:
; AVX:       ## BB#0:
; AVX-NEXT:    vmpsadbw $7, %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_mpsadbw:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vmpsadbw $7, %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse41.mpsadbw(<16 x i8> %a0, <16 x i8> %a1, i8 7) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse41.mpsadbw(<16 x i8>, <16 x i8>, i8) nounwind readnone


define <8 x i16> @test_x86_sse41_packusdw(<4 x i32> %a0, <4 x i32> %a1) {
; AVX-LABEL: test_x86_sse41_packusdw:
; AVX:       ## BB#0:
; AVX-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_packusdw:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse41.packusdw(<4 x i32> %a0, <4 x i32> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse41.packusdw(<4 x i32>, <4 x i32>) nounwind readnone


define <16 x i8> @test_x86_sse41_pblendvb(<16 x i8> %a0, <16 x i8> %a1, <16 x i8> %a2) {
; AVX-LABEL: test_x86_sse41_pblendvb:
; AVX:       ## BB#0:
; AVX-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_pblendvb:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i8> @llvm.x86.sse41.pblendvb(<16 x i8> %a0, <16 x i8> %a1, <16 x i8> %a2) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.x86.sse41.pblendvb(<16 x i8>, <16 x i8>, <16 x i8>) nounwind readnone


define <8 x i16> @test_x86_sse41_phminposuw(<8 x i16> %a0) {
; AVX-LABEL: test_x86_sse41_phminposuw:
; AVX:       ## BB#0:
; AVX-NEXT:    vphminposuw %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_phminposuw:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vphminposuw %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse41.phminposuw(<8 x i16> %a0) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse41.phminposuw(<8 x i16>) nounwind readnone


define <16 x i8> @test_x86_sse41_pmaxsb(<16 x i8> %a0, <16 x i8> %a1) {
; AVX-LABEL: test_x86_sse41_pmaxsb:
; AVX:       ## BB#0:
; AVX-NEXT:    vpmaxsb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_pmaxsb:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmaxsb %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i8> @llvm.x86.sse41.pmaxsb(<16 x i8> %a0, <16 x i8> %a1) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.x86.sse41.pmaxsb(<16 x i8>, <16 x i8>) nounwind readnone


define <4 x i32> @test_x86_sse41_pmaxsd(<4 x i32> %a0, <4 x i32> %a1) {
; AVX-LABEL: test_x86_sse41_pmaxsd:
; AVX:       ## BB#0:
; AVX-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_pmaxsd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.sse41.pmaxsd(<4 x i32> %a0, <4 x i32> %a1) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.sse41.pmaxsd(<4 x i32>, <4 x i32>) nounwind readnone


define <4 x i32> @test_x86_sse41_pmaxud(<4 x i32> %a0, <4 x i32> %a1) {
; AVX-LABEL: test_x86_sse41_pmaxud:
; AVX:       ## BB#0:
; AVX-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_pmaxud:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.sse41.pmaxud(<4 x i32> %a0, <4 x i32> %a1) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.sse41.pmaxud(<4 x i32>, <4 x i32>) nounwind readnone


define <8 x i16> @test_x86_sse41_pmaxuw(<8 x i16> %a0, <8 x i16> %a1) {
; AVX-LABEL: test_x86_sse41_pmaxuw:
; AVX:       ## BB#0:
; AVX-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_pmaxuw:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse41.pmaxuw(<8 x i16> %a0, <8 x i16> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse41.pmaxuw(<8 x i16>, <8 x i16>) nounwind readnone


define <16 x i8> @test_x86_sse41_pminsb(<16 x i8> %a0, <16 x i8> %a1) {
; AVX-LABEL: test_x86_sse41_pminsb:
; AVX:       ## BB#0:
; AVX-NEXT:    vpminsb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_pminsb:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpminsb %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i8> @llvm.x86.sse41.pminsb(<16 x i8> %a0, <16 x i8> %a1) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.x86.sse41.pminsb(<16 x i8>, <16 x i8>) nounwind readnone


define <4 x i32> @test_x86_sse41_pminsd(<4 x i32> %a0, <4 x i32> %a1) {
; AVX-LABEL: test_x86_sse41_pminsd:
; AVX:       ## BB#0:
; AVX-NEXT:    vpminsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_pminsd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpminsd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.sse41.pminsd(<4 x i32> %a0, <4 x i32> %a1) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.sse41.pminsd(<4 x i32>, <4 x i32>) nounwind readnone


define <4 x i32> @test_x86_sse41_pminud(<4 x i32> %a0, <4 x i32> %a1) {
; AVX-LABEL: test_x86_sse41_pminud:
; AVX:       ## BB#0:
; AVX-NEXT:    vpminud %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_pminud:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpminud %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.sse41.pminud(<4 x i32> %a0, <4 x i32> %a1) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.sse41.pminud(<4 x i32>, <4 x i32>) nounwind readnone


define <8 x i16> @test_x86_sse41_pminuw(<8 x i16> %a0, <8 x i16> %a1) {
; AVX-LABEL: test_x86_sse41_pminuw:
; AVX:       ## BB#0:
; AVX-NEXT:    vpminuw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_pminuw:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpminuw %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.sse41.pminuw(<8 x i16> %a0, <8 x i16> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.sse41.pminuw(<8 x i16>, <8 x i16>) nounwind readnone


define <2 x i64> @test_x86_sse41_pmuldq(<4 x i32> %a0, <4 x i32> %a1) {
; AVX-LABEL: test_x86_sse41_pmuldq:
; AVX:       ## BB#0:
; AVX-NEXT:    vpmuldq %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_pmuldq:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmuldq %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x i64> @llvm.x86.sse41.pmuldq(<4 x i32> %a0, <4 x i32> %a1) ; <<2 x i64>> [#uses=1]
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.sse41.pmuldq(<4 x i32>, <4 x i32>) nounwind readnone


define i32 @test_x86_sse41_ptestc(<2 x i64> %a0, <2 x i64> %a1) {
; AVX-LABEL: test_x86_sse41_ptestc:
; AVX:       ## BB#0:
; AVX-NEXT:    vptest %xmm1, %xmm0
; AVX-NEXT:    sbbl %eax, %eax
; AVX-NEXT:    andl $1, %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_ptestc:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vptest %xmm1, %xmm0
; AVX512VL-NEXT:    sbbl %eax, %eax
; AVX512VL-NEXT:    andl $1, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse41.ptestc(<2 x i64> %a0, <2 x i64> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse41.ptestc(<2 x i64>, <2 x i64>) nounwind readnone


define i32 @test_x86_sse41_ptestnzc(<2 x i64> %a0, <2 x i64> %a1) {
; AVX-LABEL: test_x86_sse41_ptestnzc:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vptest %xmm1, %xmm0
; AVX-NEXT:    seta %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_ptestnzc:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vptest %xmm1, %xmm0
; AVX512VL-NEXT:    seta %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse41.ptestnzc(<2 x i64> %a0, <2 x i64> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse41.ptestnzc(<2 x i64>, <2 x i64>) nounwind readnone


define i32 @test_x86_sse41_ptestz(<2 x i64> %a0, <2 x i64> %a1) {
; AVX-LABEL: test_x86_sse41_ptestz:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vptest %xmm1, %xmm0
; AVX-NEXT:    sete %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_ptestz:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vptest %xmm1, %xmm0
; AVX512VL-NEXT:    sete %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse41.ptestz(<2 x i64> %a0, <2 x i64> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse41.ptestz(<2 x i64>, <2 x i64>) nounwind readnone


define <2 x double> @test_x86_sse41_round_pd(<2 x double> %a0) {
; AVX-LABEL: test_x86_sse41_round_pd:
; AVX:       ## BB#0:
; AVX-NEXT:    vroundpd $7, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_round_pd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vroundpd $7, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse41.round.pd(<2 x double> %a0, i32 7) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse41.round.pd(<2 x double>, i32) nounwind readnone


define <4 x float> @test_x86_sse41_round_ps(<4 x float> %a0) {
; AVX-LABEL: test_x86_sse41_round_ps:
; AVX:       ## BB#0:
; AVX-NEXT:    vroundps $7, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_round_ps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vroundps $7, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse41.round.ps(<4 x float> %a0, i32 7) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse41.round.ps(<4 x float>, i32) nounwind readnone


define <2 x double> @test_x86_sse41_round_sd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_sse41_round_sd:
; AVX:       ## BB#0:
; AVX-NEXT:    vroundsd $7, %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_round_sd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vroundsd $7, %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.sse41.round.sd(<2 x double> %a0, <2 x double> %a1, i32 7) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.sse41.round.sd(<2 x double>, <2 x double>, i32) nounwind readnone


define <4 x float> @test_x86_sse41_round_ss(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse41_round_ss:
; AVX:       ## BB#0:
; AVX-NEXT:    vroundss $7, %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse41_round_ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vroundss $7, %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse41.round.ss(<4 x float> %a0, <4 x float> %a1, i32 7) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse41.round.ss(<4 x float>, <4 x float>, i32) nounwind readnone


define i32 @test_x86_sse42_pcmpestri128(<16 x i8> %a0, <16 x i8> %a2) {
; AVX-LABEL: test_x86_sse42_pcmpestri128:
; AVX:       ## BB#0:
; AVX-NEXT:    movl $7, %eax
; AVX-NEXT:    movl $7, %edx
; AVX-NEXT:    vpcmpestri $7, %xmm1, %xmm0
; AVX-NEXT:    movl %ecx, %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse42_pcmpestri128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl $7, %eax
; AVX512VL-NEXT:    movl $7, %edx
; AVX512VL-NEXT:    vpcmpestri $7, %xmm1, %xmm0
; AVX512VL-NEXT:    movl %ecx, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse42.pcmpestri128(<16 x i8> %a0, i32 7, <16 x i8> %a2, i32 7, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpestri128(<16 x i8>, i32, <16 x i8>, i32, i8) nounwind readnone


define i32 @test_x86_sse42_pcmpestri128_load(<16 x i8>* %a0, <16 x i8>* %a2) {
; AVX-LABEL: test_x86_sse42_pcmpestri128_load:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    vmovdqa (%eax), %xmm0
; AVX-NEXT:    movl $7, %eax
; AVX-NEXT:    movl $7, %edx
; AVX-NEXT:    vpcmpestri $7, (%ecx), %xmm0
; AVX-NEXT:    movl %ecx, %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse42_pcmpestri128_load:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vmovdqa64 (%eax), %xmm0
; AVX512VL-NEXT:    movl $7, %eax
; AVX512VL-NEXT:    movl $7, %edx
; AVX512VL-NEXT:    vpcmpestri $7, (%ecx), %xmm0
; AVX512VL-NEXT:    movl %ecx, %eax
; AVX512VL-NEXT:    retl
  %1 = load <16 x i8>, <16 x i8>* %a0
  %2 = load <16 x i8>, <16 x i8>* %a2
  %res = call i32 @llvm.x86.sse42.pcmpestri128(<16 x i8> %1, i32 7, <16 x i8> %2, i32 7, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}


define i32 @test_x86_sse42_pcmpestria128(<16 x i8> %a0, <16 x i8> %a2) nounwind {
; AVX-LABEL: test_x86_sse42_pcmpestria128:
; AVX:       ## BB#0:
; AVX-NEXT:    pushl %ebx
; AVX-NEXT:    movl $7, %eax
; AVX-NEXT:    movl $7, %edx
; AVX-NEXT:    xorl %ebx, %ebx
; AVX-NEXT:    vpcmpestri $7, %xmm1, %xmm0
; AVX-NEXT:    seta %bl
; AVX-NEXT:    movl %ebx, %eax
; AVX-NEXT:    popl %ebx
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse42_pcmpestria128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    pushl %ebx
; AVX512VL-NEXT:    movl $7, %eax
; AVX512VL-NEXT:    movl $7, %edx
; AVX512VL-NEXT:    xorl %ebx, %ebx
; AVX512VL-NEXT:    vpcmpestri $7, %xmm1, %xmm0
; AVX512VL-NEXT:    seta %bl
; AVX512VL-NEXT:    movl %ebx, %eax
; AVX512VL-NEXT:    popl %ebx
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse42.pcmpestria128(<16 x i8> %a0, i32 7, <16 x i8> %a2, i32 7, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpestria128(<16 x i8>, i32, <16 x i8>, i32, i8) nounwind readnone


define i32 @test_x86_sse42_pcmpestric128(<16 x i8> %a0, <16 x i8> %a2) {
; AVX-LABEL: test_x86_sse42_pcmpestric128:
; AVX:       ## BB#0:
; AVX-NEXT:    movl $7, %eax
; AVX-NEXT:    movl $7, %edx
; AVX-NEXT:    vpcmpestri $7, %xmm1, %xmm0
; AVX-NEXT:    sbbl %eax, %eax
; AVX-NEXT:    andl $1, %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse42_pcmpestric128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl $7, %eax
; AVX512VL-NEXT:    movl $7, %edx
; AVX512VL-NEXT:    vpcmpestri $7, %xmm1, %xmm0
; AVX512VL-NEXT:    sbbl %eax, %eax
; AVX512VL-NEXT:    andl $1, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse42.pcmpestric128(<16 x i8> %a0, i32 7, <16 x i8> %a2, i32 7, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpestric128(<16 x i8>, i32, <16 x i8>, i32, i8) nounwind readnone


define i32 @test_x86_sse42_pcmpestrio128(<16 x i8> %a0, <16 x i8> %a2) nounwind {
; AVX-LABEL: test_x86_sse42_pcmpestrio128:
; AVX:       ## BB#0:
; AVX-NEXT:    pushl %ebx
; AVX-NEXT:    movl $7, %eax
; AVX-NEXT:    movl $7, %edx
; AVX-NEXT:    xorl %ebx, %ebx
; AVX-NEXT:    vpcmpestri $7, %xmm1, %xmm0
; AVX-NEXT:    seto %bl
; AVX-NEXT:    movl %ebx, %eax
; AVX-NEXT:    popl %ebx
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse42_pcmpestrio128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    pushl %ebx
; AVX512VL-NEXT:    movl $7, %eax
; AVX512VL-NEXT:    movl $7, %edx
; AVX512VL-NEXT:    xorl %ebx, %ebx
; AVX512VL-NEXT:    vpcmpestri $7, %xmm1, %xmm0
; AVX512VL-NEXT:    seto %bl
; AVX512VL-NEXT:    movl %ebx, %eax
; AVX512VL-NEXT:    popl %ebx
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse42.pcmpestrio128(<16 x i8> %a0, i32 7, <16 x i8> %a2, i32 7, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpestrio128(<16 x i8>, i32, <16 x i8>, i32, i8) nounwind readnone


define i32 @test_x86_sse42_pcmpestris128(<16 x i8> %a0, <16 x i8> %a2) nounwind {
; AVX-LABEL: test_x86_sse42_pcmpestris128:
; AVX:       ## BB#0:
; AVX-NEXT:    pushl %ebx
; AVX-NEXT:    movl $7, %eax
; AVX-NEXT:    movl $7, %edx
; AVX-NEXT:    xorl %ebx, %ebx
; AVX-NEXT:    vpcmpestri $7, %xmm1, %xmm0
; AVX-NEXT:    sets %bl
; AVX-NEXT:    movl %ebx, %eax
; AVX-NEXT:    popl %ebx
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse42_pcmpestris128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    pushl %ebx
; AVX512VL-NEXT:    movl $7, %eax
; AVX512VL-NEXT:    movl $7, %edx
; AVX512VL-NEXT:    xorl %ebx, %ebx
; AVX512VL-NEXT:    vpcmpestri $7, %xmm1, %xmm0
; AVX512VL-NEXT:    sets %bl
; AVX512VL-NEXT:    movl %ebx, %eax
; AVX512VL-NEXT:    popl %ebx
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse42.pcmpestris128(<16 x i8> %a0, i32 7, <16 x i8> %a2, i32 7, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpestris128(<16 x i8>, i32, <16 x i8>, i32, i8) nounwind readnone


define i32 @test_x86_sse42_pcmpestriz128(<16 x i8> %a0, <16 x i8> %a2) nounwind {
; AVX-LABEL: test_x86_sse42_pcmpestriz128:
; AVX:       ## BB#0:
; AVX-NEXT:    pushl %ebx
; AVX-NEXT:    movl $7, %eax
; AVX-NEXT:    movl $7, %edx
; AVX-NEXT:    xorl %ebx, %ebx
; AVX-NEXT:    vpcmpestri $7, %xmm1, %xmm0
; AVX-NEXT:    sete %bl
; AVX-NEXT:    movl %ebx, %eax
; AVX-NEXT:    popl %ebx
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse42_pcmpestriz128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    pushl %ebx
; AVX512VL-NEXT:    movl $7, %eax
; AVX512VL-NEXT:    movl $7, %edx
; AVX512VL-NEXT:    xorl %ebx, %ebx
; AVX512VL-NEXT:    vpcmpestri $7, %xmm1, %xmm0
; AVX512VL-NEXT:    sete %bl
; AVX512VL-NEXT:    movl %ebx, %eax
; AVX512VL-NEXT:    popl %ebx
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse42.pcmpestriz128(<16 x i8> %a0, i32 7, <16 x i8> %a2, i32 7, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpestriz128(<16 x i8>, i32, <16 x i8>, i32, i8) nounwind readnone


define <16 x i8> @test_x86_sse42_pcmpestrm128(<16 x i8> %a0, <16 x i8> %a2) {
; AVX-LABEL: test_x86_sse42_pcmpestrm128:
; AVX:       ## BB#0:
; AVX-NEXT:    movl $7, %eax
; AVX-NEXT:    movl $7, %edx
; AVX-NEXT:    vpcmpestrm $7, %xmm1, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse42_pcmpestrm128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl $7, %eax
; AVX512VL-NEXT:    movl $7, %edx
; AVX512VL-NEXT:    vpcmpestrm $7, %xmm1, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i8> @llvm.x86.sse42.pcmpestrm128(<16 x i8> %a0, i32 7, <16 x i8> %a2, i32 7, i8 7) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.x86.sse42.pcmpestrm128(<16 x i8>, i32, <16 x i8>, i32, i8) nounwind readnone


define <16 x i8> @test_x86_sse42_pcmpestrm128_load(<16 x i8> %a0, <16 x i8>* %a2) {
; AVX-LABEL: test_x86_sse42_pcmpestrm128_load:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX-NEXT:    movl $7, %eax
; AVX-NEXT:    movl $7, %edx
; AVX-NEXT:    vpcmpestrm $7, (%ecx), %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse42_pcmpestrm128_load:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX512VL-NEXT:    movl $7, %eax
; AVX512VL-NEXT:    movl $7, %edx
; AVX512VL-NEXT:    vpcmpestrm $7, (%ecx), %xmm0
; AVX512VL-NEXT:    retl
  %1 = load <16 x i8>, <16 x i8>* %a2
  %res = call <16 x i8> @llvm.x86.sse42.pcmpestrm128(<16 x i8> %a0, i32 7, <16 x i8> %1, i32 7, i8 7) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}


define i32 @test_x86_sse42_pcmpistri128(<16 x i8> %a0, <16 x i8> %a1) {
; AVX-LABEL: test_x86_sse42_pcmpistri128:
; AVX:       ## BB#0:
; AVX-NEXT:    vpcmpistri $7, %xmm1, %xmm0
; AVX-NEXT:    movl %ecx, %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse42_pcmpistri128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpcmpistri $7, %xmm1, %xmm0
; AVX512VL-NEXT:    movl %ecx, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse42.pcmpistri128(<16 x i8> %a0, <16 x i8> %a1, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpistri128(<16 x i8>, <16 x i8>, i8) nounwind readnone


define i32 @test_x86_sse42_pcmpistri128_load(<16 x i8>* %a0, <16 x i8>* %a1) {
; AVX-LABEL: test_x86_sse42_pcmpistri128_load:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX-NEXT:    vmovdqa (%ecx), %xmm0
; AVX-NEXT:    vpcmpistri $7, (%eax), %xmm0
; AVX-NEXT:    movl %ecx, %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse42_pcmpistri128_load:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX512VL-NEXT:    vmovdqa64 (%ecx), %xmm0
; AVX512VL-NEXT:    vpcmpistri $7, (%eax), %xmm0
; AVX512VL-NEXT:    movl %ecx, %eax
; AVX512VL-NEXT:    retl
  %1 = load <16 x i8>, <16 x i8>* %a0
  %2 = load <16 x i8>, <16 x i8>* %a1
  %res = call i32 @llvm.x86.sse42.pcmpistri128(<16 x i8> %1, <16 x i8> %2, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}


define i32 @test_x86_sse42_pcmpistria128(<16 x i8> %a0, <16 x i8> %a1) {
; AVX-LABEL: test_x86_sse42_pcmpistria128:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vpcmpistri $7, %xmm1, %xmm0
; AVX-NEXT:    seta %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse42_pcmpistria128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vpcmpistri $7, %xmm1, %xmm0
; AVX512VL-NEXT:    seta %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse42.pcmpistria128(<16 x i8> %a0, <16 x i8> %a1, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpistria128(<16 x i8>, <16 x i8>, i8) nounwind readnone


define i32 @test_x86_sse42_pcmpistric128(<16 x i8> %a0, <16 x i8> %a1) {
; AVX-LABEL: test_x86_sse42_pcmpistric128:
; AVX:       ## BB#0:
; AVX-NEXT:    vpcmpistri $7, %xmm1, %xmm0
; AVX-NEXT:    sbbl %eax, %eax
; AVX-NEXT:    andl $1, %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse42_pcmpistric128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpcmpistri $7, %xmm1, %xmm0
; AVX512VL-NEXT:    sbbl %eax, %eax
; AVX512VL-NEXT:    andl $1, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse42.pcmpistric128(<16 x i8> %a0, <16 x i8> %a1, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpistric128(<16 x i8>, <16 x i8>, i8) nounwind readnone


define i32 @test_x86_sse42_pcmpistrio128(<16 x i8> %a0, <16 x i8> %a1) {
; AVX-LABEL: test_x86_sse42_pcmpistrio128:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vpcmpistri $7, %xmm1, %xmm0
; AVX-NEXT:    seto %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse42_pcmpistrio128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vpcmpistri $7, %xmm1, %xmm0
; AVX512VL-NEXT:    seto %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse42.pcmpistrio128(<16 x i8> %a0, <16 x i8> %a1, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpistrio128(<16 x i8>, <16 x i8>, i8) nounwind readnone


define i32 @test_x86_sse42_pcmpistris128(<16 x i8> %a0, <16 x i8> %a1) {
; AVX-LABEL: test_x86_sse42_pcmpistris128:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vpcmpistri $7, %xmm1, %xmm0
; AVX-NEXT:    sets %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse42_pcmpistris128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vpcmpistri $7, %xmm1, %xmm0
; AVX512VL-NEXT:    sets %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse42.pcmpistris128(<16 x i8> %a0, <16 x i8> %a1, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpistris128(<16 x i8>, <16 x i8>, i8) nounwind readnone


define i32 @test_x86_sse42_pcmpistriz128(<16 x i8> %a0, <16 x i8> %a1) {
; AVX-LABEL: test_x86_sse42_pcmpistriz128:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vpcmpistri $7, %xmm1, %xmm0
; AVX-NEXT:    sete %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse42_pcmpistriz128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vpcmpistri $7, %xmm1, %xmm0
; AVX512VL-NEXT:    sete %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse42.pcmpistriz128(<16 x i8> %a0, <16 x i8> %a1, i8 7) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse42.pcmpistriz128(<16 x i8>, <16 x i8>, i8) nounwind readnone


define <16 x i8> @test_x86_sse42_pcmpistrm128(<16 x i8> %a0, <16 x i8> %a1) {
; AVX-LABEL: test_x86_sse42_pcmpistrm128:
; AVX:       ## BB#0:
; AVX-NEXT:    vpcmpistrm $7, %xmm1, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse42_pcmpistrm128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpcmpistrm $7, %xmm1, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i8> @llvm.x86.sse42.pcmpistrm128(<16 x i8> %a0, <16 x i8> %a1, i8 7) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.x86.sse42.pcmpistrm128(<16 x i8>, <16 x i8>, i8) nounwind readnone


define <16 x i8> @test_x86_sse42_pcmpistrm128_load(<16 x i8> %a0, <16 x i8>* %a1) {
; AVX-LABEL: test_x86_sse42_pcmpistrm128_load:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    vpcmpistrm $7, (%eax), %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse42_pcmpistrm128_load:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vpcmpistrm $7, (%eax), %xmm0
; AVX512VL-NEXT:    retl
  %1 = load <16 x i8>, <16 x i8>* %a1
  %res = call <16 x i8> @llvm.x86.sse42.pcmpistrm128(<16 x i8> %a0, <16 x i8> %1, i8 7) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}


define <4 x float> @test_x86_sse_add_ss(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse_add_ss:
; AVX:       ## BB#0:
; AVX-NEXT:    vaddss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_add_ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vaddss %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse.add.ss(<4 x float> %a0, <4 x float> %a1) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse.add.ss(<4 x float>, <4 x float>) nounwind readnone


define <4 x float> @test_x86_sse_cmp_ps(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse_cmp_ps:
; AVX:       ## BB#0:
; AVX-NEXT:    vcmpordps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_cmp_ps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcmpordps %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse.cmp.ps(<4 x float> %a0, <4 x float> %a1, i8 7) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse.cmp.ps(<4 x float>, <4 x float>, i8) nounwind readnone


define <4 x float> @test_x86_sse_cmp_ss(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse_cmp_ss:
; AVX:       ## BB#0:
; AVX-NEXT:    vcmpordss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_cmp_ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcmpordss %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse.cmp.ss(<4 x float> %a0, <4 x float> %a1, i8 7) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse.cmp.ss(<4 x float>, <4 x float>, i8) nounwind readnone


define i32 @test_x86_sse_comieq_ss(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse_comieq_ss:
; AVX:       ## BB#0:
; AVX-NEXT:    vcomiss %xmm1, %xmm0
; AVX-NEXT:    setnp %al
; AVX-NEXT:    sete %cl
; AVX-NEXT:    andb %al, %cl
; AVX-NEXT:    movzbl %cl, %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_comieq_ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcomiss %xmm1, %xmm0
; AVX512VL-NEXT:    setnp %al
; AVX512VL-NEXT:    sete %cl
; AVX512VL-NEXT:    andb %al, %cl
; AVX512VL-NEXT:    movzbl %cl, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse.comieq.ss(<4 x float> %a0, <4 x float> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse.comieq.ss(<4 x float>, <4 x float>) nounwind readnone


define i32 @test_x86_sse_comige_ss(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse_comige_ss:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vcomiss %xmm1, %xmm0
; AVX-NEXT:    setae %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_comige_ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vcomiss %xmm1, %xmm0
; AVX512VL-NEXT:    setae %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse.comige.ss(<4 x float> %a0, <4 x float> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse.comige.ss(<4 x float>, <4 x float>) nounwind readnone


define i32 @test_x86_sse_comigt_ss(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse_comigt_ss:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vcomiss %xmm1, %xmm0
; AVX-NEXT:    seta %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_comigt_ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vcomiss %xmm1, %xmm0
; AVX512VL-NEXT:    seta %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse.comigt.ss(<4 x float> %a0, <4 x float> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse.comigt.ss(<4 x float>, <4 x float>) nounwind readnone


define i32 @test_x86_sse_comile_ss(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse_comile_ss:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vcomiss %xmm0, %xmm1
; AVX-NEXT:    setae %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_comile_ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vcomiss %xmm0, %xmm1
; AVX512VL-NEXT:    setae %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse.comile.ss(<4 x float> %a0, <4 x float> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse.comile.ss(<4 x float>, <4 x float>) nounwind readnone


define i32 @test_x86_sse_comilt_ss(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse_comilt_ss:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vcomiss %xmm0, %xmm1
; AVX-NEXT:    seta %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_comilt_ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vcomiss %xmm0, %xmm1
; AVX512VL-NEXT:    seta %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse.comilt.ss(<4 x float> %a0, <4 x float> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse.comilt.ss(<4 x float>, <4 x float>) nounwind readnone


define i32 @test_x86_sse_comineq_ss(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse_comineq_ss:
; AVX:       ## BB#0:
; AVX-NEXT:    vcomiss %xmm1, %xmm0
; AVX-NEXT:    setp %al
; AVX-NEXT:    setne %cl
; AVX-NEXT:    orb %al, %cl
; AVX-NEXT:    movzbl %cl, %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_comineq_ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcomiss %xmm1, %xmm0
; AVX512VL-NEXT:    setp %al
; AVX512VL-NEXT:    setne %cl
; AVX512VL-NEXT:    orb %al, %cl
; AVX512VL-NEXT:    movzbl %cl, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse.comineq.ss(<4 x float> %a0, <4 x float> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse.comineq.ss(<4 x float>, <4 x float>) nounwind readnone


define <4 x float> @test_x86_sse_cvtsi2ss(<4 x float> %a0) {
; AVX-LABEL: test_x86_sse_cvtsi2ss:
; AVX:       ## BB#0:
; AVX-NEXT:    movl $7, %eax
; AVX-NEXT:    vcvtsi2ssl %eax, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_cvtsi2ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl $7, %eax
; AVX512VL-NEXT:    vcvtsi2ssl %eax, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse.cvtsi2ss(<4 x float> %a0, i32 7) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse.cvtsi2ss(<4 x float>, i32) nounwind readnone


define i32 @test_x86_sse_cvtss2si(<4 x float> %a0) {
; AVX-LABEL: test_x86_sse_cvtss2si:
; AVX:       ## BB#0:
; AVX-NEXT:    vcvtss2si %xmm0, %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_cvtss2si:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcvtss2si %xmm0, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse.cvtss2si(<4 x float> %a0) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse.cvtss2si(<4 x float>) nounwind readnone


define i32 @test_x86_sse_cvttss2si(<4 x float> %a0) {
; AVX-LABEL: test_x86_sse_cvttss2si:
; AVX:       ## BB#0:
; AVX-NEXT:    vcvttss2si %xmm0, %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_cvttss2si:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcvttss2si %xmm0, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse.cvttss2si(<4 x float> %a0) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse.cvttss2si(<4 x float>) nounwind readnone


define <4 x float> @test_x86_sse_div_ss(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse_div_ss:
; AVX:       ## BB#0:
; AVX-NEXT:    vdivss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_div_ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vdivss %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse.div.ss(<4 x float> %a0, <4 x float> %a1) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse.div.ss(<4 x float>, <4 x float>) nounwind readnone


define void @test_x86_sse_ldmxcsr(i8* %a0) {
; AVX-LABEL: test_x86_sse_ldmxcsr:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    vldmxcsr (%eax)
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_ldmxcsr:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vldmxcsr (%eax)
; AVX512VL-NEXT:    retl
  call void @llvm.x86.sse.ldmxcsr(i8* %a0)
  ret void
}
declare void @llvm.x86.sse.ldmxcsr(i8*) nounwind



define <4 x float> @test_x86_sse_max_ps(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse_max_ps:
; AVX:       ## BB#0:
; AVX-NEXT:    vmaxps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_max_ps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vmaxps %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse.max.ps(<4 x float> %a0, <4 x float> %a1) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse.max.ps(<4 x float>, <4 x float>) nounwind readnone


define <4 x float> @test_x86_sse_max_ss(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse_max_ss:
; AVX:       ## BB#0:
; AVX-NEXT:    vmaxss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_max_ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vmaxss %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse.max.ss(<4 x float> %a0, <4 x float> %a1) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse.max.ss(<4 x float>, <4 x float>) nounwind readnone


define <4 x float> @test_x86_sse_min_ps(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse_min_ps:
; AVX:       ## BB#0:
; AVX-NEXT:    vminps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_min_ps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vminps %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse.min.ps(<4 x float> %a0, <4 x float> %a1) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse.min.ps(<4 x float>, <4 x float>) nounwind readnone


define <4 x float> @test_x86_sse_min_ss(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse_min_ss:
; AVX:       ## BB#0:
; AVX-NEXT:    vminss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_min_ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vminss %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse.min.ss(<4 x float> %a0, <4 x float> %a1) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse.min.ss(<4 x float>, <4 x float>) nounwind readnone


define i32 @test_x86_sse_movmsk_ps(<4 x float> %a0) {
; AVX-LABEL: test_x86_sse_movmsk_ps:
; AVX:       ## BB#0:
; AVX-NEXT:    vmovmskps %xmm0, %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_movmsk_ps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vmovmskps %xmm0, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse.movmsk.ps(<4 x float> %a0) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse.movmsk.ps(<4 x float>) nounwind readnone



define <4 x float> @test_x86_sse_mul_ss(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse_mul_ss:
; AVX:       ## BB#0:
; AVX-NEXT:    vmulss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_mul_ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vmulss %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse.mul.ss(<4 x float> %a0, <4 x float> %a1) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse.mul.ss(<4 x float>, <4 x float>) nounwind readnone


define <4 x float> @test_x86_sse_rcp_ps(<4 x float> %a0) {
; AVX-LABEL: test_x86_sse_rcp_ps:
; AVX:       ## BB#0:
; AVX-NEXT:    vrcpps %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_rcp_ps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vrcp14ps %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse.rcp.ps(<4 x float> %a0) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse.rcp.ps(<4 x float>) nounwind readnone


define <4 x float> @test_x86_sse_rcp_ss(<4 x float> %a0) {
; AVX-LABEL: test_x86_sse_rcp_ss:
; AVX:       ## BB#0:
; AVX-NEXT:    vrcpss %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_rcp_ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vrcpss %xmm0, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse.rcp.ss(<4 x float> %a0) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse.rcp.ss(<4 x float>) nounwind readnone


define <4 x float> @test_x86_sse_rsqrt_ps(<4 x float> %a0) {
; AVX-LABEL: test_x86_sse_rsqrt_ps:
; AVX:       ## BB#0:
; AVX-NEXT:    vrsqrtps %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_rsqrt_ps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vrsqrt14ps %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse.rsqrt.ps(<4 x float> %a0) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse.rsqrt.ps(<4 x float>) nounwind readnone


define <4 x float> @test_x86_sse_rsqrt_ss(<4 x float> %a0) {
; AVX-LABEL: test_x86_sse_rsqrt_ss:
; AVX:       ## BB#0:
; AVX-NEXT:    vrsqrtss %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_rsqrt_ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vrsqrtss %xmm0, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse.rsqrt.ss(<4 x float> %a0) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse.rsqrt.ss(<4 x float>) nounwind readnone


define <4 x float> @test_x86_sse_sqrt_ps(<4 x float> %a0) {
; AVX-LABEL: test_x86_sse_sqrt_ps:
; AVX:       ## BB#0:
; AVX-NEXT:    vsqrtps %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_sqrt_ps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vsqrtps %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse.sqrt.ps(<4 x float> %a0) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse.sqrt.ps(<4 x float>) nounwind readnone


define <4 x float> @test_x86_sse_sqrt_ss(<4 x float> %a0) {
; AVX-LABEL: test_x86_sse_sqrt_ss:
; AVX:       ## BB#0:
; AVX-NEXT:    vsqrtss %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_sqrt_ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vsqrtss %xmm0, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse.sqrt.ss(<4 x float> %a0) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse.sqrt.ss(<4 x float>) nounwind readnone


define void @test_x86_sse_stmxcsr(i8* %a0) {
; AVX-LABEL: test_x86_sse_stmxcsr:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    vstmxcsr (%eax)
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_stmxcsr:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vstmxcsr (%eax)
; AVX512VL-NEXT:    retl
  call void @llvm.x86.sse.stmxcsr(i8* %a0)
  ret void
}
declare void @llvm.x86.sse.stmxcsr(i8*) nounwind


define <4 x float> @test_x86_sse_sub_ss(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse_sub_ss:
; AVX:       ## BB#0:
; AVX-NEXT:    vsubss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_sub_ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vsubss %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.sse.sub.ss(<4 x float> %a0, <4 x float> %a1) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.sse.sub.ss(<4 x float>, <4 x float>) nounwind readnone


define i32 @test_x86_sse_ucomieq_ss(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse_ucomieq_ss:
; AVX:       ## BB#0:
; AVX-NEXT:    vucomiss %xmm1, %xmm0
; AVX-NEXT:    setnp %al
; AVX-NEXT:    sete %cl
; AVX-NEXT:    andb %al, %cl
; AVX-NEXT:    movzbl %cl, %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_ucomieq_ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vucomiss %xmm1, %xmm0
; AVX512VL-NEXT:    setnp %al
; AVX512VL-NEXT:    sete %cl
; AVX512VL-NEXT:    andb %al, %cl
; AVX512VL-NEXT:    movzbl %cl, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse.ucomieq.ss(<4 x float> %a0, <4 x float> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse.ucomieq.ss(<4 x float>, <4 x float>) nounwind readnone


define i32 @test_x86_sse_ucomige_ss(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse_ucomige_ss:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vucomiss %xmm1, %xmm0
; AVX-NEXT:    setae %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_ucomige_ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vucomiss %xmm1, %xmm0
; AVX512VL-NEXT:    setae %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse.ucomige.ss(<4 x float> %a0, <4 x float> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse.ucomige.ss(<4 x float>, <4 x float>) nounwind readnone


define i32 @test_x86_sse_ucomigt_ss(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse_ucomigt_ss:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vucomiss %xmm1, %xmm0
; AVX-NEXT:    seta %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_ucomigt_ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vucomiss %xmm1, %xmm0
; AVX512VL-NEXT:    seta %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse.ucomigt.ss(<4 x float> %a0, <4 x float> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse.ucomigt.ss(<4 x float>, <4 x float>) nounwind readnone


define i32 @test_x86_sse_ucomile_ss(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse_ucomile_ss:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vucomiss %xmm0, %xmm1
; AVX-NEXT:    setae %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_ucomile_ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vucomiss %xmm0, %xmm1
; AVX512VL-NEXT:    setae %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse.ucomile.ss(<4 x float> %a0, <4 x float> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse.ucomile.ss(<4 x float>, <4 x float>) nounwind readnone


define i32 @test_x86_sse_ucomilt_ss(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse_ucomilt_ss:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vucomiss %xmm0, %xmm1
; AVX-NEXT:    seta %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_ucomilt_ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vucomiss %xmm0, %xmm1
; AVX512VL-NEXT:    seta %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse.ucomilt.ss(<4 x float> %a0, <4 x float> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse.ucomilt.ss(<4 x float>, <4 x float>) nounwind readnone


define i32 @test_x86_sse_ucomineq_ss(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_sse_ucomineq_ss:
; AVX:       ## BB#0:
; AVX-NEXT:    vucomiss %xmm1, %xmm0
; AVX-NEXT:    setp %al
; AVX-NEXT:    setne %cl
; AVX-NEXT:    orb %al, %cl
; AVX-NEXT:    movzbl %cl, %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_sse_ucomineq_ss:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vucomiss %xmm1, %xmm0
; AVX512VL-NEXT:    setp %al
; AVX512VL-NEXT:    setne %cl
; AVX512VL-NEXT:    orb %al, %cl
; AVX512VL-NEXT:    movzbl %cl, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.sse.ucomineq.ss(<4 x float> %a0, <4 x float> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.sse.ucomineq.ss(<4 x float>, <4 x float>) nounwind readnone


define <16 x i8> @test_x86_ssse3_pabs_b_128(<16 x i8> %a0) {
; AVX-LABEL: test_x86_ssse3_pabs_b_128:
; AVX:       ## BB#0:
; AVX-NEXT:    vpabsb %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_ssse3_pabs_b_128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpabsb %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i8> @llvm.x86.ssse3.pabs.b.128(<16 x i8> %a0) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.x86.ssse3.pabs.b.128(<16 x i8>) nounwind readnone


define <4 x i32> @test_x86_ssse3_pabs_d_128(<4 x i32> %a0) {
; AVX-LABEL: test_x86_ssse3_pabs_d_128:
; AVX:       ## BB#0:
; AVX-NEXT:    vpabsd %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_ssse3_pabs_d_128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpabsd %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.ssse3.pabs.d.128(<4 x i32> %a0) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.ssse3.pabs.d.128(<4 x i32>) nounwind readnone


define <8 x i16> @test_x86_ssse3_pabs_w_128(<8 x i16> %a0) {
; AVX-LABEL: test_x86_ssse3_pabs_w_128:
; AVX:       ## BB#0:
; AVX-NEXT:    vpabsw %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_ssse3_pabs_w_128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpabsw %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.ssse3.pabs.w.128(<8 x i16> %a0) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.ssse3.pabs.w.128(<8 x i16>) nounwind readnone


define <4 x i32> @test_x86_ssse3_phadd_d_128(<4 x i32> %a0, <4 x i32> %a1) {
; AVX-LABEL: test_x86_ssse3_phadd_d_128:
; AVX:       ## BB#0:
; AVX-NEXT:    vphaddd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_ssse3_phadd_d_128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vphaddd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.ssse3.phadd.d.128(<4 x i32> %a0, <4 x i32> %a1) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.ssse3.phadd.d.128(<4 x i32>, <4 x i32>) nounwind readnone


define <8 x i16> @test_x86_ssse3_phadd_sw_128(<8 x i16> %a0, <8 x i16> %a1) {
; AVX-LABEL: test_x86_ssse3_phadd_sw_128:
; AVX:       ## BB#0:
; AVX-NEXT:    vphaddsw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_ssse3_phadd_sw_128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vphaddsw %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.ssse3.phadd.sw.128(<8 x i16> %a0, <8 x i16> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.ssse3.phadd.sw.128(<8 x i16>, <8 x i16>) nounwind readnone


define <8 x i16> @test_x86_ssse3_phadd_w_128(<8 x i16> %a0, <8 x i16> %a1) {
; AVX-LABEL: test_x86_ssse3_phadd_w_128:
; AVX:       ## BB#0:
; AVX-NEXT:    vphaddw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_ssse3_phadd_w_128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vphaddw %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.ssse3.phadd.w.128(<8 x i16> %a0, <8 x i16> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.ssse3.phadd.w.128(<8 x i16>, <8 x i16>) nounwind readnone


define <4 x i32> @test_x86_ssse3_phsub_d_128(<4 x i32> %a0, <4 x i32> %a1) {
; AVX-LABEL: test_x86_ssse3_phsub_d_128:
; AVX:       ## BB#0:
; AVX-NEXT:    vphsubd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_ssse3_phsub_d_128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vphsubd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.ssse3.phsub.d.128(<4 x i32> %a0, <4 x i32> %a1) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.ssse3.phsub.d.128(<4 x i32>, <4 x i32>) nounwind readnone


define <8 x i16> @test_x86_ssse3_phsub_sw_128(<8 x i16> %a0, <8 x i16> %a1) {
; AVX-LABEL: test_x86_ssse3_phsub_sw_128:
; AVX:       ## BB#0:
; AVX-NEXT:    vphsubsw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_ssse3_phsub_sw_128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vphsubsw %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.ssse3.phsub.sw.128(<8 x i16> %a0, <8 x i16> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.ssse3.phsub.sw.128(<8 x i16>, <8 x i16>) nounwind readnone


define <8 x i16> @test_x86_ssse3_phsub_w_128(<8 x i16> %a0, <8 x i16> %a1) {
; AVX-LABEL: test_x86_ssse3_phsub_w_128:
; AVX:       ## BB#0:
; AVX-NEXT:    vphsubw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_ssse3_phsub_w_128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vphsubw %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.ssse3.phsub.w.128(<8 x i16> %a0, <8 x i16> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.ssse3.phsub.w.128(<8 x i16>, <8 x i16>) nounwind readnone


define <8 x i16> @test_x86_ssse3_pmadd_ub_sw_128(<16 x i8> %a0, <16 x i8> %a1) {
; AVX-LABEL: test_x86_ssse3_pmadd_ub_sw_128:
; AVX:       ## BB#0:
; AVX-NEXT:    vpmaddubsw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_ssse3_pmadd_ub_sw_128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmaddubsw %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.ssse3.pmadd.ub.sw.128(<16 x i8> %a0, <16 x i8> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.ssse3.pmadd.ub.sw.128(<16 x i8>, <16 x i8>) nounwind readnone


define <8 x i16> @test_x86_ssse3_pmul_hr_sw_128(<8 x i16> %a0, <8 x i16> %a1) {
; AVX-LABEL: test_x86_ssse3_pmul_hr_sw_128:
; AVX:       ## BB#0:
; AVX-NEXT:    vpmulhrsw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_ssse3_pmul_hr_sw_128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpmulhrsw %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.ssse3.pmul.hr.sw.128(<8 x i16> %a0, <8 x i16> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.ssse3.pmul.hr.sw.128(<8 x i16>, <8 x i16>) nounwind readnone


define <16 x i8> @test_x86_ssse3_pshuf_b_128(<16 x i8> %a0, <16 x i8> %a1) {
; AVX-LABEL: test_x86_ssse3_pshuf_b_128:
; AVX:       ## BB#0:
; AVX-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_ssse3_pshuf_b_128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i8> @llvm.x86.ssse3.pshuf.b.128(<16 x i8> %a0, <16 x i8> %a1) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.x86.ssse3.pshuf.b.128(<16 x i8>, <16 x i8>) nounwind readnone


define <16 x i8> @test_x86_ssse3_psign_b_128(<16 x i8> %a0, <16 x i8> %a1) {
; AVX-LABEL: test_x86_ssse3_psign_b_128:
; AVX:       ## BB#0:
; AVX-NEXT:    vpsignb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_ssse3_psign_b_128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsignb %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <16 x i8> @llvm.x86.ssse3.psign.b.128(<16 x i8> %a0, <16 x i8> %a1) ; <<16 x i8>> [#uses=1]
  ret <16 x i8> %res
}
declare <16 x i8> @llvm.x86.ssse3.psign.b.128(<16 x i8>, <16 x i8>) nounwind readnone


define <4 x i32> @test_x86_ssse3_psign_d_128(<4 x i32> %a0, <4 x i32> %a1) {
; AVX-LABEL: test_x86_ssse3_psign_d_128:
; AVX:       ## BB#0:
; AVX-NEXT:    vpsignd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_ssse3_psign_d_128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsignd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.ssse3.psign.d.128(<4 x i32> %a0, <4 x i32> %a1) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.ssse3.psign.d.128(<4 x i32>, <4 x i32>) nounwind readnone


define <8 x i16> @test_x86_ssse3_psign_w_128(<8 x i16> %a0, <8 x i16> %a1) {
; AVX-LABEL: test_x86_ssse3_psign_w_128:
; AVX:       ## BB#0:
; AVX-NEXT:    vpsignw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_ssse3_psign_w_128:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpsignw %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i16> @llvm.x86.ssse3.psign.w.128(<8 x i16> %a0, <8 x i16> %a1) ; <<8 x i16>> [#uses=1]
  ret <8 x i16> %res
}
declare <8 x i16> @llvm.x86.ssse3.psign.w.128(<8 x i16>, <8 x i16>) nounwind readnone


define <4 x double> @test_x86_avx_addsub_pd_256(<4 x double> %a0, <4 x double> %a1) {
; AVX-LABEL: test_x86_avx_addsub_pd_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vaddsubpd %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_addsub_pd_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vaddsubpd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x double> @llvm.x86.avx.addsub.pd.256(<4 x double> %a0, <4 x double> %a1) ; <<4 x double>> [#uses=1]
  ret <4 x double> %res
}
declare <4 x double> @llvm.x86.avx.addsub.pd.256(<4 x double>, <4 x double>) nounwind readnone


define <8 x float> @test_x86_avx_addsub_ps_256(<8 x float> %a0, <8 x float> %a1) {
; AVX-LABEL: test_x86_avx_addsub_ps_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vaddsubps %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_addsub_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vaddsubps %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x float> @llvm.x86.avx.addsub.ps.256(<8 x float> %a0, <8 x float> %a1) ; <<8 x float>> [#uses=1]
  ret <8 x float> %res
}
declare <8 x float> @llvm.x86.avx.addsub.ps.256(<8 x float>, <8 x float>) nounwind readnone


define <4 x double> @test_x86_avx_blendv_pd_256(<4 x double> %a0, <4 x double> %a1, <4 x double> %a2) {
; AVX-LABEL: test_x86_avx_blendv_pd_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vblendvpd %ymm2, %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_blendv_pd_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vblendvpd %ymm2, %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x double> @llvm.x86.avx.blendv.pd.256(<4 x double> %a0, <4 x double> %a1, <4 x double> %a2) ; <<4 x double>> [#uses=1]
  ret <4 x double> %res
}
declare <4 x double> @llvm.x86.avx.blendv.pd.256(<4 x double>, <4 x double>, <4 x double>) nounwind readnone


define <8 x float> @test_x86_avx_blendv_ps_256(<8 x float> %a0, <8 x float> %a1, <8 x float> %a2) {
; AVX-LABEL: test_x86_avx_blendv_ps_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vblendvps %ymm2, %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_blendv_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vblendvps %ymm2, %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x float> @llvm.x86.avx.blendv.ps.256(<8 x float> %a0, <8 x float> %a1, <8 x float> %a2) ; <<8 x float>> [#uses=1]
  ret <8 x float> %res
}
declare <8 x float> @llvm.x86.avx.blendv.ps.256(<8 x float>, <8 x float>, <8 x float>) nounwind readnone


define <4 x double> @test_x86_avx_cmp_pd_256(<4 x double> %a0, <4 x double> %a1) {
; AVX-LABEL: test_x86_avx_cmp_pd_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vcmpordpd %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_cmp_pd_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcmpordpd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x double> @llvm.x86.avx.cmp.pd.256(<4 x double> %a0, <4 x double> %a1, i8 7) ; <<4 x double>> [#uses=1]
  ret <4 x double> %res
}
declare <4 x double> @llvm.x86.avx.cmp.pd.256(<4 x double>, <4 x double>, i8) nounwind readnone


define <8 x float> @test_x86_avx_cmp_ps_256(<8 x float> %a0, <8 x float> %a1) {
; AVX-LABEL: test_x86_avx_cmp_ps_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vcmpordps %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_cmp_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcmpordps %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a1, i8 7) ; <<8 x float>> [#uses=1]
  ret <8 x float> %res
}

define <8 x float> @test_x86_avx_cmp_ps_256_pseudo_op(<8 x float> %a0, <8 x float> %a1) {
; AVX-LABEL: test_x86_avx_cmp_ps_256_pseudo_op:
; AVX:       ## BB#0:
; AVX-NEXT:    vcmpeqps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpltps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpleps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpunordps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpneqps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpnltps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpnleps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpordps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpeq_uqps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpngeps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpngtps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpfalseps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpneq_oqps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpgeps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpgtps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmptrueps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpeq_osps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmplt_oqps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmple_oqps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpunord_sps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpneq_usps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpnlt_uqps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpnle_uqps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpord_sps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpeq_usps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpnge_uqps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpngt_uqps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpfalse_osps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpneq_osps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpge_oqps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmpgt_oqps %ymm1, %ymm0, %ymm1
; AVX-NEXT:    vcmptrue_usps %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_cmp_ps_256_pseudo_op:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcmpeqps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpltps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpleps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpunordps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpneqps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpnltps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpnleps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpordps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpeq_uqps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpngeps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpngtps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpfalseps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpneq_oqps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpgeps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpgtps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmptrueps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpeq_osps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmplt_oqps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmple_oqps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpunord_sps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpneq_usps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpnlt_uqps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpnle_uqps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpord_sps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpeq_usps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpnge_uqps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpngt_uqps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpfalse_osps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpneq_osps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpge_oqps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmpgt_oqps %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vcmptrue_usps %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %a2 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a1, i8 0) ; <<8 x float>> [#uses=1]
  %a3 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a2, i8 1) ; <<8 x float>> [#uses=1]
  %a4 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a3, i8 2) ; <<8 x float>> [#uses=1]
  %a5 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a4, i8 3) ; <<8 x float>> [#uses=1]
  %a6 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a5, i8 4) ; <<8 x float>> [#uses=1]
  %a7 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a6, i8 5) ; <<8 x float>> [#uses=1]
  %a8 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a7, i8 6) ; <<8 x float>> [#uses=1]
  %a9 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a8, i8 7) ; <<8 x float>> [#uses=1]
  %a10 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a9, i8 8) ; <<8 x float>> [#uses=1]
  %a11 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a10, i8 9) ; <<8 x float>> [#uses=1]
  %a12 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a11, i8 10) ; <<8 x float>> [#uses=1]
  %a13 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a12, i8 11) ; <<8 x float>> [#uses=1]
  %a14 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a13, i8 12) ; <<8 x float>> [#uses=1]
  %a15 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a14, i8 13) ; <<8 x float>> [#uses=1]
  %a16 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a15, i8 14) ; <<8 x float>> [#uses=1]
  %a17 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a16, i8 15) ; <<8 x float>> [#uses=1]
  %a18 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a17, i8 16) ; <<8 x float>> [#uses=1]
  %a19 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a18, i8 17) ; <<8 x float>> [#uses=1]
  %a20 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a19, i8 18) ; <<8 x float>> [#uses=1]
  %a21 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a20, i8 19) ; <<8 x float>> [#uses=1]
  %a22 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a21, i8 20) ; <<8 x float>> [#uses=1]
  %a23 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a22, i8 21) ; <<8 x float>> [#uses=1]
  %a24 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a23, i8 22) ; <<8 x float>> [#uses=1]
  %a25 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a24, i8 23) ; <<8 x float>> [#uses=1]
  %a26 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a25, i8 24) ; <<8 x float>> [#uses=1]
  %a27 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a26, i8 25) ; <<8 x float>> [#uses=1]
  %a28 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a27, i8 26) ; <<8 x float>> [#uses=1]
  %a29 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a28, i8 27) ; <<8 x float>> [#uses=1]
  %a30 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a29, i8 28) ; <<8 x float>> [#uses=1]
  %a31 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a30, i8 29) ; <<8 x float>> [#uses=1]
  %a32 = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a31, i8 30) ; <<8 x float>> [#uses=1]
  %res = call <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float> %a0, <8 x float> %a32, i8 31) ; <<8 x float>> [#uses=1]
  ret <8 x float> %res
}
declare <8 x float> @llvm.x86.avx.cmp.ps.256(<8 x float>, <8 x float>, i8) nounwind readnone


define <4 x float> @test_x86_avx_cvt_pd2_ps_256(<4 x double> %a0) {
; AVX-LABEL: test_x86_avx_cvt_pd2_ps_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vcvtpd2psy %ymm0, %xmm0
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_cvt_pd2_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcvtpd2psy %ymm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.avx.cvt.pd2.ps.256(<4 x double> %a0) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.avx.cvt.pd2.ps.256(<4 x double>) nounwind readnone


define <4 x i32> @test_x86_avx_cvt_pd2dq_256(<4 x double> %a0) {
; AVX-LABEL: test_x86_avx_cvt_pd2dq_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vcvtpd2dqy %ymm0, %xmm0
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_cvt_pd2dq_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcvtpd2dqy %ymm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.avx.cvt.pd2dq.256(<4 x double> %a0) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.avx.cvt.pd2dq.256(<4 x double>) nounwind readnone


define <8 x i32> @test_x86_avx_cvt_ps2dq_256(<8 x float> %a0) {
; AVX-LABEL: test_x86_avx_cvt_ps2dq_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vcvtps2dq %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_cvt_ps2dq_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcvtps2dq %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx.cvt.ps2dq.256(<8 x float> %a0) ; <<8 x i32>> [#uses=1]
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx.cvt.ps2dq.256(<8 x float>) nounwind readnone


define <8 x float> @test_x86_avx_cvtdq2_ps_256(<8 x i32> %a0) {
; AVX-LABEL: test_x86_avx_cvtdq2_ps_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_cvtdq2_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcvtdq2ps %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x float> @llvm.x86.avx.cvtdq2.ps.256(<8 x i32> %a0) ; <<8 x float>> [#uses=1]
  ret <8 x float> %res
}
declare <8 x float> @llvm.x86.avx.cvtdq2.ps.256(<8 x i32>) nounwind readnone


define <4 x i32> @test_x86_avx_cvtt_pd2dq_256(<4 x double> %a0) {
; AVX-LABEL: test_x86_avx_cvtt_pd2dq_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vcvttpd2dqy %ymm0, %xmm0
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_cvtt_pd2dq_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcvttpd2dqy %ymm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x i32> @llvm.x86.avx.cvtt.pd2dq.256(<4 x double> %a0) ; <<4 x i32>> [#uses=1]
  ret <4 x i32> %res
}
declare <4 x i32> @llvm.x86.avx.cvtt.pd2dq.256(<4 x double>) nounwind readnone


define <8 x i32> @test_x86_avx_cvtt_ps2dq_256(<8 x float> %a0) {
; AVX-LABEL: test_x86_avx_cvtt_ps2dq_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_cvtt_ps2dq_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vcvttps2dq %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx.cvtt.ps2dq.256(<8 x float> %a0) ; <<8 x i32>> [#uses=1]
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx.cvtt.ps2dq.256(<8 x float>) nounwind readnone


define <8 x float> @test_x86_avx_dp_ps_256(<8 x float> %a0, <8 x float> %a1) {
; AVX-LABEL: test_x86_avx_dp_ps_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vdpps $7, %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_dp_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vdpps $7, %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x float> @llvm.x86.avx.dp.ps.256(<8 x float> %a0, <8 x float> %a1, i8 7) ; <<8 x float>> [#uses=1]
  ret <8 x float> %res
}
declare <8 x float> @llvm.x86.avx.dp.ps.256(<8 x float>, <8 x float>, i8) nounwind readnone


define <4 x double> @test_x86_avx_hadd_pd_256(<4 x double> %a0, <4 x double> %a1) {
; AVX-LABEL: test_x86_avx_hadd_pd_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vhaddpd %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_hadd_pd_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vhaddpd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x double> @llvm.x86.avx.hadd.pd.256(<4 x double> %a0, <4 x double> %a1) ; <<4 x double>> [#uses=1]
  ret <4 x double> %res
}
declare <4 x double> @llvm.x86.avx.hadd.pd.256(<4 x double>, <4 x double>) nounwind readnone


define <8 x float> @test_x86_avx_hadd_ps_256(<8 x float> %a0, <8 x float> %a1) {
; AVX-LABEL: test_x86_avx_hadd_ps_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vhaddps %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_hadd_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vhaddps %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x float> @llvm.x86.avx.hadd.ps.256(<8 x float> %a0, <8 x float> %a1) ; <<8 x float>> [#uses=1]
  ret <8 x float> %res
}
declare <8 x float> @llvm.x86.avx.hadd.ps.256(<8 x float>, <8 x float>) nounwind readnone


define <4 x double> @test_x86_avx_hsub_pd_256(<4 x double> %a0, <4 x double> %a1) {
; AVX-LABEL: test_x86_avx_hsub_pd_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vhsubpd %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_hsub_pd_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vhsubpd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x double> @llvm.x86.avx.hsub.pd.256(<4 x double> %a0, <4 x double> %a1) ; <<4 x double>> [#uses=1]
  ret <4 x double> %res
}
declare <4 x double> @llvm.x86.avx.hsub.pd.256(<4 x double>, <4 x double>) nounwind readnone


define <8 x float> @test_x86_avx_hsub_ps_256(<8 x float> %a0, <8 x float> %a1) {
; AVX-LABEL: test_x86_avx_hsub_ps_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vhsubps %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_hsub_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vhsubps %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x float> @llvm.x86.avx.hsub.ps.256(<8 x float> %a0, <8 x float> %a1) ; <<8 x float>> [#uses=1]
  ret <8 x float> %res
}
declare <8 x float> @llvm.x86.avx.hsub.ps.256(<8 x float>, <8 x float>) nounwind readnone


define <32 x i8> @test_x86_avx_ldu_dq_256(i8* %a0) {
; AVX-LABEL: test_x86_avx_ldu_dq_256:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    vlddqu (%eax), %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_ldu_dq_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vlddqu (%eax), %ymm0
; AVX512VL-NEXT:    retl
  %res = call <32 x i8> @llvm.x86.avx.ldu.dq.256(i8* %a0) ; <<32 x i8>> [#uses=1]
  ret <32 x i8> %res
}
declare <32 x i8> @llvm.x86.avx.ldu.dq.256(i8*) nounwind readonly


define <2 x double> @test_x86_avx_maskload_pd(i8* %a0, <2 x i64> %mask) {
; AVX-LABEL: test_x86_avx_maskload_pd:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    vmaskmovpd (%eax), %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_maskload_pd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vmaskmovpd (%eax), %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.avx.maskload.pd(i8* %a0, <2 x i64> %mask) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.avx.maskload.pd(i8*, <2 x i64>) nounwind readonly


define <4 x double> @test_x86_avx_maskload_pd_256(i8* %a0, <4 x i64> %mask) {
; AVX-LABEL: test_x86_avx_maskload_pd_256:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    vmaskmovpd (%eax), %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_maskload_pd_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vmaskmovpd (%eax), %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x double> @llvm.x86.avx.maskload.pd.256(i8* %a0, <4 x i64> %mask) ; <<4 x double>> [#uses=1]
  ret <4 x double> %res
}
declare <4 x double> @llvm.x86.avx.maskload.pd.256(i8*, <4 x i64>) nounwind readonly


define <4 x float> @test_x86_avx_maskload_ps(i8* %a0, <4 x i32> %mask) {
; AVX-LABEL: test_x86_avx_maskload_ps:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    vmaskmovps (%eax), %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_maskload_ps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vmaskmovps (%eax), %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.avx.maskload.ps(i8* %a0, <4 x i32> %mask) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.avx.maskload.ps(i8*, <4 x i32>) nounwind readonly


define <8 x float> @test_x86_avx_maskload_ps_256(i8* %a0, <8 x i32> %mask) {
; AVX-LABEL: test_x86_avx_maskload_ps_256:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    vmaskmovps (%eax), %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_maskload_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vmaskmovps (%eax), %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x float> @llvm.x86.avx.maskload.ps.256(i8* %a0, <8 x i32> %mask) ; <<8 x float>> [#uses=1]
  ret <8 x float> %res
}
declare <8 x float> @llvm.x86.avx.maskload.ps.256(i8*, <8 x i32>) nounwind readonly


define void @test_x86_avx_maskstore_pd(i8* %a0, <2 x i64> %mask, <2 x double> %a2) {
; AVX-LABEL: test_x86_avx_maskstore_pd:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    vmaskmovpd %xmm1, %xmm0, (%eax)
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_maskstore_pd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vmaskmovpd %xmm1, %xmm0, (%eax)
; AVX512VL-NEXT:    retl
  call void @llvm.x86.avx.maskstore.pd(i8* %a0, <2 x i64> %mask, <2 x double> %a2)
  ret void
}
declare void @llvm.x86.avx.maskstore.pd(i8*, <2 x i64>, <2 x double>) nounwind


define void @test_x86_avx_maskstore_pd_256(i8* %a0, <4 x i64> %mask, <4 x double> %a2) {
; AVX-LABEL: test_x86_avx_maskstore_pd_256:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    vmaskmovpd %ymm1, %ymm0, (%eax)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_maskstore_pd_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vmaskmovpd %ymm1, %ymm0, (%eax)
; AVX512VL-NEXT:    retl
  call void @llvm.x86.avx.maskstore.pd.256(i8* %a0, <4 x i64> %mask, <4 x double> %a2)
  ret void
}
declare void @llvm.x86.avx.maskstore.pd.256(i8*, <4 x i64>, <4 x double>) nounwind


define void @test_x86_avx_maskstore_ps(i8* %a0, <4 x i32> %mask, <4 x float> %a2) {
; AVX-LABEL: test_x86_avx_maskstore_ps:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    vmaskmovps %xmm1, %xmm0, (%eax)
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_maskstore_ps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vmaskmovps %xmm1, %xmm0, (%eax)
; AVX512VL-NEXT:    retl
  call void @llvm.x86.avx.maskstore.ps(i8* %a0, <4 x i32> %mask, <4 x float> %a2)
  ret void
}
declare void @llvm.x86.avx.maskstore.ps(i8*, <4 x i32>, <4 x float>) nounwind


define void @test_x86_avx_maskstore_ps_256(i8* %a0, <8 x i32> %mask, <8 x float> %a2) {
; AVX-LABEL: test_x86_avx_maskstore_ps_256:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    vmaskmovps %ymm1, %ymm0, (%eax)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_maskstore_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vmaskmovps %ymm1, %ymm0, (%eax)
; AVX512VL-NEXT:    retl
  call void @llvm.x86.avx.maskstore.ps.256(i8* %a0, <8 x i32> %mask, <8 x float> %a2)
  ret void
}
declare void @llvm.x86.avx.maskstore.ps.256(i8*, <8 x i32>, <8 x float>) nounwind


define <4 x double> @test_x86_avx_max_pd_256(<4 x double> %a0, <4 x double> %a1) {
; AVX-LABEL: test_x86_avx_max_pd_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vmaxpd %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_max_pd_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vmaxpd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x double> @llvm.x86.avx.max.pd.256(<4 x double> %a0, <4 x double> %a1) ; <<4 x double>> [#uses=1]
  ret <4 x double> %res
}
declare <4 x double> @llvm.x86.avx.max.pd.256(<4 x double>, <4 x double>) nounwind readnone


define <8 x float> @test_x86_avx_max_ps_256(<8 x float> %a0, <8 x float> %a1) {
; AVX-LABEL: test_x86_avx_max_ps_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vmaxps %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_max_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vmaxps %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x float> @llvm.x86.avx.max.ps.256(<8 x float> %a0, <8 x float> %a1) ; <<8 x float>> [#uses=1]
  ret <8 x float> %res
}
declare <8 x float> @llvm.x86.avx.max.ps.256(<8 x float>, <8 x float>) nounwind readnone


define <4 x double> @test_x86_avx_min_pd_256(<4 x double> %a0, <4 x double> %a1) {
; AVX-LABEL: test_x86_avx_min_pd_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vminpd %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_min_pd_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vminpd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x double> @llvm.x86.avx.min.pd.256(<4 x double> %a0, <4 x double> %a1) ; <<4 x double>> [#uses=1]
  ret <4 x double> %res
}
declare <4 x double> @llvm.x86.avx.min.pd.256(<4 x double>, <4 x double>) nounwind readnone


define <8 x float> @test_x86_avx_min_ps_256(<8 x float> %a0, <8 x float> %a1) {
; AVX-LABEL: test_x86_avx_min_ps_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vminps %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_min_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vminps %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x float> @llvm.x86.avx.min.ps.256(<8 x float> %a0, <8 x float> %a1) ; <<8 x float>> [#uses=1]
  ret <8 x float> %res
}
declare <8 x float> @llvm.x86.avx.min.ps.256(<8 x float>, <8 x float>) nounwind readnone


define i32 @test_x86_avx_movmsk_pd_256(<4 x double> %a0) {
; AVX-LABEL: test_x86_avx_movmsk_pd_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vmovmskpd %ymm0, %eax
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_movmsk_pd_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vmovmskpd %ymm0, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.avx.movmsk.pd.256(<4 x double> %a0) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.avx.movmsk.pd.256(<4 x double>) nounwind readnone


define i32 @test_x86_avx_movmsk_ps_256(<8 x float> %a0) {
; AVX-LABEL: test_x86_avx_movmsk_ps_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vmovmskps %ymm0, %eax
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_movmsk_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vmovmskps %ymm0, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.avx.movmsk.ps.256(<8 x float> %a0) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.avx.movmsk.ps.256(<8 x float>) nounwind readnone







define i32 @test_x86_avx_ptestc_256(<4 x i64> %a0, <4 x i64> %a1) {
; AVX-LABEL: test_x86_avx_ptestc_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vptest %ymm1, %ymm0
; AVX-NEXT:    sbbl %eax, %eax
; AVX-NEXT:    andl $1, %eax
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_ptestc_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vptest %ymm1, %ymm0
; AVX512VL-NEXT:    sbbl %eax, %eax
; AVX512VL-NEXT:    andl $1, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.avx.ptestc.256(<4 x i64> %a0, <4 x i64> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.avx.ptestc.256(<4 x i64>, <4 x i64>) nounwind readnone


define i32 @test_x86_avx_ptestnzc_256(<4 x i64> %a0, <4 x i64> %a1) {
; AVX-LABEL: test_x86_avx_ptestnzc_256:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vptest %ymm1, %ymm0
; AVX-NEXT:    seta %al
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_ptestnzc_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vptest %ymm1, %ymm0
; AVX512VL-NEXT:    seta %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.avx.ptestnzc.256(<4 x i64> %a0, <4 x i64> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.avx.ptestnzc.256(<4 x i64>, <4 x i64>) nounwind readnone


define i32 @test_x86_avx_ptestz_256(<4 x i64> %a0, <4 x i64> %a1) {
; AVX-LABEL: test_x86_avx_ptestz_256:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vptest %ymm1, %ymm0
; AVX-NEXT:    sete %al
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_ptestz_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vptest %ymm1, %ymm0
; AVX512VL-NEXT:    sete %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.avx.ptestz.256(<4 x i64> %a0, <4 x i64> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.avx.ptestz.256(<4 x i64>, <4 x i64>) nounwind readnone


define <8 x float> @test_x86_avx_rcp_ps_256(<8 x float> %a0) {
; AVX-LABEL: test_x86_avx_rcp_ps_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vrcpps %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_rcp_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vrcp14ps %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x float> @llvm.x86.avx.rcp.ps.256(<8 x float> %a0) ; <<8 x float>> [#uses=1]
  ret <8 x float> %res
}
declare <8 x float> @llvm.x86.avx.rcp.ps.256(<8 x float>) nounwind readnone


define <4 x double> @test_x86_avx_round_pd_256(<4 x double> %a0) {
; AVX-LABEL: test_x86_avx_round_pd_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vroundpd $7, %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_round_pd_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vroundpd $7, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x double> @llvm.x86.avx.round.pd.256(<4 x double> %a0, i32 7) ; <<4 x double>> [#uses=1]
  ret <4 x double> %res
}
declare <4 x double> @llvm.x86.avx.round.pd.256(<4 x double>, i32) nounwind readnone


define <8 x float> @test_x86_avx_round_ps_256(<8 x float> %a0) {
; AVX-LABEL: test_x86_avx_round_ps_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vroundps $7, %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_round_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vroundps $7, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x float> @llvm.x86.avx.round.ps.256(<8 x float> %a0, i32 7) ; <<8 x float>> [#uses=1]
  ret <8 x float> %res
}
declare <8 x float> @llvm.x86.avx.round.ps.256(<8 x float>, i32) nounwind readnone


define <8 x float> @test_x86_avx_rsqrt_ps_256(<8 x float> %a0) {
; AVX-LABEL: test_x86_avx_rsqrt_ps_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vrsqrtps %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_rsqrt_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vrsqrt14ps %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x float> @llvm.x86.avx.rsqrt.ps.256(<8 x float> %a0) ; <<8 x float>> [#uses=1]
  ret <8 x float> %res
}
declare <8 x float> @llvm.x86.avx.rsqrt.ps.256(<8 x float>) nounwind readnone


define <4 x double> @test_x86_avx_sqrt_pd_256(<4 x double> %a0) {
; AVX-LABEL: test_x86_avx_sqrt_pd_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vsqrtpd %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_sqrt_pd_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vsqrtpd %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x double> @llvm.x86.avx.sqrt.pd.256(<4 x double> %a0) ; <<4 x double>> [#uses=1]
  ret <4 x double> %res
}
declare <4 x double> @llvm.x86.avx.sqrt.pd.256(<4 x double>) nounwind readnone


define <8 x float> @test_x86_avx_sqrt_ps_256(<8 x float> %a0) {
; AVX-LABEL: test_x86_avx_sqrt_ps_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vsqrtps %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_sqrt_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vsqrtps %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x float> @llvm.x86.avx.sqrt.ps.256(<8 x float> %a0) ; <<8 x float>> [#uses=1]
  ret <8 x float> %res
}
declare <8 x float> @llvm.x86.avx.sqrt.ps.256(<8 x float>) nounwind readnone


define <4 x double> @test_x86_avx_vbroadcastf128_pd_256(i8* %a0) {
; AVX-LABEL: test_x86_avx_vbroadcastf128_pd_256:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vbroadcastf128_pd_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; AVX512VL-NEXT:    retl
  %res = call <4 x double> @llvm.x86.avx.vbroadcastf128.pd.256(i8* %a0) ; <<4 x double>> [#uses=1]
  ret <4 x double> %res
}
declare <4 x double> @llvm.x86.avx.vbroadcastf128.pd.256(i8*) nounwind readonly


define <8 x float> @test_x86_avx_vbroadcastf128_ps_256(i8* %a0) {
; AVX-LABEL: test_x86_avx_vbroadcastf128_ps_256:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vbroadcastf128_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; AVX512VL-NEXT:    retl
  %res = call <8 x float> @llvm.x86.avx.vbroadcastf128.ps.256(i8* %a0) ; <<8 x float>> [#uses=1]
  ret <8 x float> %res
}
declare <8 x float> @llvm.x86.avx.vbroadcastf128.ps.256(i8*) nounwind readonly


define <4 x double> @test_x86_avx_vperm2f128_pd_256(<4 x double> %a0, <4 x double> %a1) {
; AVX-LABEL: test_x86_avx_vperm2f128_pd_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[2,3],ymm0[0,1]
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vperm2f128_pd_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[2,3],ymm0[0,1]
; AVX512VL-NEXT:    retl
  %res = call <4 x double> @llvm.x86.avx.vperm2f128.pd.256(<4 x double> %a0, <4 x double> %a1, i8 7) ; <<4 x double>> [#uses=1]
  ret <4 x double> %res
}
declare <4 x double> @llvm.x86.avx.vperm2f128.pd.256(<4 x double>, <4 x double>, i8) nounwind readnone


define <8 x float> @test_x86_avx_vperm2f128_ps_256(<8 x float> %a0, <8 x float> %a1) {
; AVX-LABEL: test_x86_avx_vperm2f128_ps_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[2,3],ymm0[0,1]
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vperm2f128_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[2,3],ymm0[0,1]
; AVX512VL-NEXT:    retl
  %res = call <8 x float> @llvm.x86.avx.vperm2f128.ps.256(<8 x float> %a0, <8 x float> %a1, i8 7) ; <<8 x float>> [#uses=1]
  ret <8 x float> %res
}
declare <8 x float> @llvm.x86.avx.vperm2f128.ps.256(<8 x float>, <8 x float>, i8) nounwind readnone


define <8 x i32> @test_x86_avx_vperm2f128_si_256(<8 x i32> %a0, <8 x i32> %a1) {
; AVX-LABEL: test_x86_avx_vperm2f128_si_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[2,3],ymm0[0,1]
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vperm2f128_si_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[2,3],ymm0[0,1]
; AVX512VL-NEXT:    retl
  %res = call <8 x i32> @llvm.x86.avx.vperm2f128.si.256(<8 x i32> %a0, <8 x i32> %a1, i8 7) ; <<8 x i32>> [#uses=1]
  ret <8 x i32> %res
}
declare <8 x i32> @llvm.x86.avx.vperm2f128.si.256(<8 x i32>, <8 x i32>, i8) nounwind readnone


define <2 x double> @test_x86_avx_vpermilvar_pd(<2 x double> %a0, <2 x i64> %a1) {
; AVX-LABEL: test_x86_avx_vpermilvar_pd:
; AVX:       ## BB#0:
; AVX-NEXT:    vpermilpd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vpermilvar_pd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpermilpd %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x double> @llvm.x86.avx.vpermilvar.pd(<2 x double> %a0, <2 x i64> %a1) ; <<2 x double>> [#uses=1]
  ret <2 x double> %res
}
declare <2 x double> @llvm.x86.avx.vpermilvar.pd(<2 x double>, <2 x i64>) nounwind readnone


define <4 x double> @test_x86_avx_vpermilvar_pd_256(<4 x double> %a0, <4 x i64> %a1) {
; AVX-LABEL: test_x86_avx_vpermilvar_pd_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vpermilpd %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vpermilvar_pd_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpermilpd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <4 x double> @llvm.x86.avx.vpermilvar.pd.256(<4 x double> %a0, <4 x i64> %a1) ; <<4 x double>> [#uses=1]
  ret <4 x double> %res
}
declare <4 x double> @llvm.x86.avx.vpermilvar.pd.256(<4 x double>, <4 x i64>) nounwind readnone

define <4 x double> @test_x86_avx_vpermilvar_pd_256_2(<4 x double> %a0) {
; AVX-LABEL: test_x86_avx_vpermilvar_pd_256_2:
; AVX:       ## BB#0:
; AVX-NEXT:    vpermilpd {{.*#+}} ymm0 = ymm0[1,0,2,3]
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vpermilvar_pd_256_2:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpermilpd {{.*#+}} ymm0 = ymm0[1,0,2,3]
; AVX512VL-NEXT:    retl
  %res = call <4 x double> @llvm.x86.avx.vpermilvar.pd.256(<4 x double> %a0, <4 x i64> <i64 2, i64 0, i64 0, i64 2>) ; <<4 x double>> [#uses=1]
  ret <4 x double> %res
}

define <4 x float> @test_x86_avx_vpermilvar_ps(<4 x float> %a0, <4 x i32> %a1) {
; AVX-LABEL: test_x86_avx_vpermilvar_ps:
; AVX:       ## BB#0:
; AVX-NEXT:    vpermilps %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vpermilvar_ps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpermilps %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <4 x float> @llvm.x86.avx.vpermilvar.ps(<4 x float> %a0, <4 x i32> %a1) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
define <4 x float> @test_x86_avx_vpermilvar_ps_load(<4 x float> %a0, <4 x i32>* %a1) {
; AVX-LABEL: test_x86_avx_vpermilvar_ps_load:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    vpermilps (%eax), %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vpermilvar_ps_load:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vpermilps (%eax), %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %a2 = load <4 x i32>, <4 x i32>* %a1
  %res = call <4 x float> @llvm.x86.avx.vpermilvar.ps(<4 x float> %a0, <4 x i32> %a2) ; <<4 x float>> [#uses=1]
  ret <4 x float> %res
}
declare <4 x float> @llvm.x86.avx.vpermilvar.ps(<4 x float>, <4 x i32>) nounwind readnone


define <8 x float> @test_x86_avx_vpermilvar_ps_256(<8 x float> %a0, <8 x i32> %a1) {
; AVX-LABEL: test_x86_avx_vpermilvar_ps_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vpermilps %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vpermilvar_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpermilps %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retl
  %res = call <8 x float> @llvm.x86.avx.vpermilvar.ps.256(<8 x float> %a0, <8 x i32> %a1) ; <<8 x float>> [#uses=1]
  ret <8 x float> %res
}
declare <8 x float> @llvm.x86.avx.vpermilvar.ps.256(<8 x float>, <8 x i32>) nounwind readnone


define i32 @test_x86_avx_vtestc_pd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_avx_vtestc_pd:
; AVX:       ## BB#0:
; AVX-NEXT:    vtestpd %xmm1, %xmm0
; AVX-NEXT:    sbbl %eax, %eax
; AVX-NEXT:    andl $1, %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vtestc_pd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vtestpd %xmm1, %xmm0
; AVX512VL-NEXT:    sbbl %eax, %eax
; AVX512VL-NEXT:    andl $1, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.avx.vtestc.pd(<2 x double> %a0, <2 x double> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.avx.vtestc.pd(<2 x double>, <2 x double>) nounwind readnone


define i32 @test_x86_avx_vtestc_pd_256(<4 x double> %a0, <4 x double> %a1) {
; AVX-LABEL: test_x86_avx_vtestc_pd_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vtestpd %ymm1, %ymm0
; AVX-NEXT:    sbbl %eax, %eax
; AVX-NEXT:    andl $1, %eax
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vtestc_pd_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vtestpd %ymm1, %ymm0
; AVX512VL-NEXT:    sbbl %eax, %eax
; AVX512VL-NEXT:    andl $1, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.avx.vtestc.pd.256(<4 x double> %a0, <4 x double> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.avx.vtestc.pd.256(<4 x double>, <4 x double>) nounwind readnone


define i32 @test_x86_avx_vtestc_ps(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_avx_vtestc_ps:
; AVX:       ## BB#0:
; AVX-NEXT:    vtestps %xmm1, %xmm0
; AVX-NEXT:    sbbl %eax, %eax
; AVX-NEXT:    andl $1, %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vtestc_ps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vtestps %xmm1, %xmm0
; AVX512VL-NEXT:    sbbl %eax, %eax
; AVX512VL-NEXT:    andl $1, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.avx.vtestc.ps(<4 x float> %a0, <4 x float> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.avx.vtestc.ps(<4 x float>, <4 x float>) nounwind readnone


define i32 @test_x86_avx_vtestc_ps_256(<8 x float> %a0, <8 x float> %a1) {
; AVX-LABEL: test_x86_avx_vtestc_ps_256:
; AVX:       ## BB#0:
; AVX-NEXT:    vtestps %ymm1, %ymm0
; AVX-NEXT:    sbbl %eax, %eax
; AVX-NEXT:    andl $1, %eax
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vtestc_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vtestps %ymm1, %ymm0
; AVX512VL-NEXT:    sbbl %eax, %eax
; AVX512VL-NEXT:    andl $1, %eax
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.avx.vtestc.ps.256(<8 x float> %a0, <8 x float> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.avx.vtestc.ps.256(<8 x float>, <8 x float>) nounwind readnone


define i32 @test_x86_avx_vtestnzc_pd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_avx_vtestnzc_pd:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vtestpd %xmm1, %xmm0
; AVX-NEXT:    seta %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vtestnzc_pd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vtestpd %xmm1, %xmm0
; AVX512VL-NEXT:    seta %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.avx.vtestnzc.pd(<2 x double> %a0, <2 x double> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.avx.vtestnzc.pd(<2 x double>, <2 x double>) nounwind readnone


define i32 @test_x86_avx_vtestnzc_pd_256(<4 x double> %a0, <4 x double> %a1) {
; AVX-LABEL: test_x86_avx_vtestnzc_pd_256:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vtestpd %ymm1, %ymm0
; AVX-NEXT:    seta %al
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vtestnzc_pd_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vtestpd %ymm1, %ymm0
; AVX512VL-NEXT:    seta %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.avx.vtestnzc.pd.256(<4 x double> %a0, <4 x double> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.avx.vtestnzc.pd.256(<4 x double>, <4 x double>) nounwind readnone


define i32 @test_x86_avx_vtestnzc_ps(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_avx_vtestnzc_ps:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vtestps %xmm1, %xmm0
; AVX-NEXT:    seta %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vtestnzc_ps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vtestps %xmm1, %xmm0
; AVX512VL-NEXT:    seta %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.avx.vtestnzc.ps(<4 x float> %a0, <4 x float> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.avx.vtestnzc.ps(<4 x float>, <4 x float>) nounwind readnone


define i32 @test_x86_avx_vtestnzc_ps_256(<8 x float> %a0, <8 x float> %a1) {
; AVX-LABEL: test_x86_avx_vtestnzc_ps_256:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vtestps %ymm1, %ymm0
; AVX-NEXT:    seta %al
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vtestnzc_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vtestps %ymm1, %ymm0
; AVX512VL-NEXT:    seta %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.avx.vtestnzc.ps.256(<8 x float> %a0, <8 x float> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.avx.vtestnzc.ps.256(<8 x float>, <8 x float>) nounwind readnone


define i32 @test_x86_avx_vtestz_pd(<2 x double> %a0, <2 x double> %a1) {
; AVX-LABEL: test_x86_avx_vtestz_pd:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vtestpd %xmm1, %xmm0
; AVX-NEXT:    sete %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vtestz_pd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vtestpd %xmm1, %xmm0
; AVX512VL-NEXT:    sete %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.avx.vtestz.pd(<2 x double> %a0, <2 x double> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.avx.vtestz.pd(<2 x double>, <2 x double>) nounwind readnone


define i32 @test_x86_avx_vtestz_pd_256(<4 x double> %a0, <4 x double> %a1) {
; AVX-LABEL: test_x86_avx_vtestz_pd_256:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vtestpd %ymm1, %ymm0
; AVX-NEXT:    sete %al
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vtestz_pd_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vtestpd %ymm1, %ymm0
; AVX512VL-NEXT:    sete %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.avx.vtestz.pd.256(<4 x double> %a0, <4 x double> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.avx.vtestz.pd.256(<4 x double>, <4 x double>) nounwind readnone


define i32 @test_x86_avx_vtestz_ps(<4 x float> %a0, <4 x float> %a1) {
; AVX-LABEL: test_x86_avx_vtestz_ps:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vtestps %xmm1, %xmm0
; AVX-NEXT:    sete %al
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vtestz_ps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vtestps %xmm1, %xmm0
; AVX512VL-NEXT:    sete %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.avx.vtestz.ps(<4 x float> %a0, <4 x float> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.avx.vtestz.ps(<4 x float>, <4 x float>) nounwind readnone


define i32 @test_x86_avx_vtestz_ps_256(<8 x float> %a0, <8 x float> %a1) {
; AVX-LABEL: test_x86_avx_vtestz_ps_256:
; AVX:       ## BB#0:
; AVX-NEXT:    xorl %eax, %eax
; AVX-NEXT:    vtestps %ymm1, %ymm0
; AVX-NEXT:    sete %al
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vtestz_ps_256:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    xorl %eax, %eax
; AVX512VL-NEXT:    vtestps %ymm1, %ymm0
; AVX512VL-NEXT:    sete %al
; AVX512VL-NEXT:    retl
  %res = call i32 @llvm.x86.avx.vtestz.ps.256(<8 x float> %a0, <8 x float> %a1) ; <i32> [#uses=1]
  ret i32 %res
}
declare i32 @llvm.x86.avx.vtestz.ps.256(<8 x float>, <8 x float>) nounwind readnone


define void @test_x86_avx_vzeroall() {
; AVX-LABEL: test_x86_avx_vzeroall:
; AVX:       ## BB#0:
; AVX-NEXT:    vzeroall
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vzeroall:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vzeroall
; AVX512VL-NEXT:    retl
  call void @llvm.x86.avx.vzeroall()
  ret void
}
declare void @llvm.x86.avx.vzeroall() nounwind


define void @test_x86_avx_vzeroupper() {
; AVX-LABEL: test_x86_avx_vzeroupper:
; AVX:       ## BB#0:
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_avx_vzeroupper:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retl
  call void @llvm.x86.avx.vzeroupper()
  ret void
}
declare void @llvm.x86.avx.vzeroupper() nounwind

; Make sure instructions with no AVX equivalents, but are associated with SSEX feature flags still work

define void @monitor(i8* %P, i32 %E, i32 %H) nounwind {
; AVX-LABEL: monitor:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    leal (%eax), %eax
; AVX-NEXT:    monitor
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: monitor:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %edx
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    leal (%eax), %eax
; AVX512VL-NEXT:    monitor
; AVX512VL-NEXT:    retl
  tail call void @llvm.x86.sse3.monitor(i8* %P, i32 %E, i32 %H)
  ret void
}
declare void @llvm.x86.sse3.monitor(i8*, i32, i32) nounwind

define void @mwait(i32 %E, i32 %H) nounwind {
; AVX-LABEL: mwait:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    mwait
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: mwait:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    mwait
; AVX512VL-NEXT:    retl
  tail call void @llvm.x86.sse3.mwait(i32 %E, i32 %H)
  ret void
}
declare void @llvm.x86.sse3.mwait(i32, i32) nounwind

define void @sfence() nounwind {
; AVX-LABEL: sfence:
; AVX:       ## BB#0:
; AVX-NEXT:    sfence
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: sfence:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    sfence
; AVX512VL-NEXT:    retl
  tail call void @llvm.x86.sse.sfence()
  ret void
}
declare void @llvm.x86.sse.sfence() nounwind

define void @lfence() nounwind {
; AVX-LABEL: lfence:
; AVX:       ## BB#0:
; AVX-NEXT:    lfence
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: lfence:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    lfence
; AVX512VL-NEXT:    retl
  tail call void @llvm.x86.sse2.lfence()
  ret void
}
declare void @llvm.x86.sse2.lfence() nounwind

define void @mfence() nounwind {
; AVX-LABEL: mfence:
; AVX:       ## BB#0:
; AVX-NEXT:    mfence
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: mfence:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    mfence
; AVX512VL-NEXT:    retl
  tail call void @llvm.x86.sse2.mfence()
  ret void
}
declare void @llvm.x86.sse2.mfence() nounwind

define void @clflush(i8* %p) nounwind {
; AVX-LABEL: clflush:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    clflush (%eax)
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: clflush:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    clflush (%eax)
; AVX512VL-NEXT:    retl
  tail call void @llvm.x86.sse2.clflush(i8* %p)
  ret void
}
declare void @llvm.x86.sse2.clflush(i8*) nounwind

define i32 @crc32_32_8(i32 %a, i8 %b) nounwind {
; AVX-LABEL: crc32_32_8:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    crc32b {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: crc32_32_8:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    crc32b {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    retl
  %tmp = call i32 @llvm.x86.sse42.crc32.32.8(i32 %a, i8 %b)
  ret i32 %tmp
}
declare i32 @llvm.x86.sse42.crc32.32.8(i32, i8) nounwind

define i32 @crc32_32_16(i32 %a, i16 %b) nounwind {
; AVX-LABEL: crc32_32_16:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    crc32w {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: crc32_32_16:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    crc32w {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    retl
  %tmp = call i32 @llvm.x86.sse42.crc32.32.16(i32 %a, i16 %b)
  ret i32 %tmp
}
declare i32 @llvm.x86.sse42.crc32.32.16(i32, i16) nounwind

define i32 @crc32_32_32(i32 %a, i32 %b) nounwind {
; AVX-LABEL: crc32_32_32:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    crc32l {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: crc32_32_32:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    crc32l {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    retl
  %tmp = call i32 @llvm.x86.sse42.crc32.32.32(i32 %a, i32 %b)
  ret i32 %tmp
}
declare i32 @llvm.x86.sse42.crc32.32.32(i32, i32) nounwind

define void @movnt_dq(i8* %p, <2 x i64> %a1) nounwind {
; AVX-LABEL: movnt_dq:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    vpaddq LCPI256_0, %xmm0, %xmm0
; AVX-NEXT:    vmovntdq %ymm0, (%eax)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: movnt_dq:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vpaddq LCPI256_0, %xmm0, %xmm0
; AVX512VL-NEXT:    vmovntdq %ymm0, (%eax)
; AVX512VL-NEXT:    retl
  %a2 = add <2 x i64> %a1, <i64 1, i64 1>
  %a3 = shufflevector <2 x i64> %a2, <2 x i64> undef, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  tail call void @llvm.x86.avx.movnt.dq.256(i8* %p, <4 x i64> %a3) nounwind
  ret void
}
declare void @llvm.x86.avx.movnt.dq.256(i8*, <4 x i64>) nounwind

define void @movnt_ps(i8* %p, <8 x float> %a) nounwind {
; AVX-LABEL: movnt_ps:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    vmovntps %ymm0, (%eax)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: movnt_ps:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vmovntps %ymm0, (%eax)
; AVX512VL-NEXT:    retl
  tail call void @llvm.x86.avx.movnt.ps.256(i8* %p, <8 x float> %a) nounwind
  ret void
}
declare void @llvm.x86.avx.movnt.ps.256(i8*, <8 x float>) nounwind

define void @movnt_pd(i8* %p, <4 x double> %a1) nounwind {
  ; add operation forces the execution domain.
; AVX-LABEL: movnt_pd:
; AVX:       ## BB#0:
; AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX-NEXT:    vxorpd %ymm1, %ymm1, %ymm1
; AVX-NEXT:    vaddpd %ymm1, %ymm0, %ymm0
; AVX-NEXT:    vmovntpd %ymm0, (%eax)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: movnt_pd:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; AVX512VL-NEXT:    vpxord %ymm1, %ymm1, %ymm1
; AVX512VL-NEXT:    vaddpd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vmovntpd %ymm0, (%eax)
; AVX512VL-NEXT:    retl
  %a2 = fadd <4 x double> %a1, <double 0x0, double 0x0, double 0x0, double 0x0>
  tail call void @llvm.x86.avx.movnt.pd.256(i8* %p, <4 x double> %a2) nounwind
  ret void
}
declare void @llvm.x86.avx.movnt.pd.256(i8*, <4 x double>) nounwind


; Check for pclmulqdq
define <2 x i64> @test_x86_pclmulqdq(<2 x i64> %a0, <2 x i64> %a1) {
; AVX-LABEL: test_x86_pclmulqdq:
; AVX:       ## BB#0:
; AVX-NEXT:    vpclmulqdq $0, %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retl
;
; AVX512VL-LABEL: test_x86_pclmulqdq:
; AVX512VL:       ## BB#0:
; AVX512VL-NEXT:    vpclmulqdq $0, %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retl
  %res = call <2 x i64> @llvm.x86.pclmulqdq(<2 x i64> %a0, <2 x i64> %a1, i8 0) ; <<2 x i64>> [#uses=1]
  ret <2 x i64> %res
}
declare <2 x i64> @llvm.x86.pclmulqdq(<2 x i64>, <2 x i64>, i8) nounwind readnone
