; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -mtriple=x86_64-unknown -basicaa -slp-vectorizer -S | FileCheck %s --check-prefix=CHECK --check-prefix=SSE
; RUN: opt < %s -mtriple=x86_64-unknown -mcpu=corei7-avx -basicaa -slp-vectorizer -S | FileCheck %s --check-prefix=CHECK --check-prefix=AVX
; RUN: opt < %s -mtriple=x86_64-unknown -mcpu=core-avx2 -basicaa -slp-vectorizer -S | FileCheck %s --check-prefix=CHECK --check-prefix=AVX
; RUN: opt < %s -mtriple=x86_64-unknown -mcpu=skx -basicaa -slp-vectorizer -S | FileCheck %s --check-prefix=CHECK --check-prefix=AVX

;
; 128-bit Vectors
;

define <2 x double> @buildvector_add_2f64(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: @buildvector_add_2f64(
; CHECK-NEXT:    [[TMP1:%.*]] = fadd <2 x double> %a, %b
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <2 x double> [[TMP1]], i32 0
; CHECK-NEXT:    [[R0:%.*]] = insertelement <2 x double> undef, double [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <2 x double> [[TMP1]], i32 1
; CHECK-NEXT:    [[R1:%.*]] = insertelement <2 x double> [[R0]], double [[TMP3]], i32 1
; CHECK-NEXT:    ret <2 x double> [[R1]]
;
  %a0 = extractelement <2 x double> %a, i32 0
  %a1 = extractelement <2 x double> %a, i32 1
  %b0 = extractelement <2 x double> %b, i32 0
  %b1 = extractelement <2 x double> %b, i32 1
  %c0 = fadd double %a0, %b0
  %c1 = fadd double %a1, %b1
  %r0 = insertelement <2 x double> undef, double %c0, i32 0
  %r1 = insertelement <2 x double> %r0,   double %c1, i32 1
  ret <2 x double> %r1
}

define <2 x double> @buildvector_sub_2f64(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: @buildvector_sub_2f64(
; CHECK-NEXT:    [[TMP1:%.*]] = fsub <2 x double> %a, %b
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <2 x double> [[TMP1]], i32 0
; CHECK-NEXT:    [[R0:%.*]] = insertelement <2 x double> undef, double [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <2 x double> [[TMP1]], i32 1
; CHECK-NEXT:    [[R1:%.*]] = insertelement <2 x double> [[R0]], double [[TMP3]], i32 1
; CHECK-NEXT:    ret <2 x double> [[R1]]
;
  %a0 = extractelement <2 x double> %a, i32 0
  %a1 = extractelement <2 x double> %a, i32 1
  %b0 = extractelement <2 x double> %b, i32 0
  %b1 = extractelement <2 x double> %b, i32 1
  %c0 = fsub double %a0, %b0
  %c1 = fsub double %a1, %b1
  %r0 = insertelement <2 x double> undef, double %c0, i32 0
  %r1 = insertelement <2 x double> %r0,   double %c1, i32 1
  ret <2 x double> %r1
}

define <2 x double> @buildvector_mul_2f64(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: @buildvector_mul_2f64(
; CHECK-NEXT:    [[TMP1:%.*]] = fmul <2 x double> %a, %b
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <2 x double> [[TMP1]], i32 0
; CHECK-NEXT:    [[R0:%.*]] = insertelement <2 x double> undef, double [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <2 x double> [[TMP1]], i32 1
; CHECK-NEXT:    [[R1:%.*]] = insertelement <2 x double> [[R0]], double [[TMP3]], i32 1
; CHECK-NEXT:    ret <2 x double> [[R1]]
;
  %a0 = extractelement <2 x double> %a, i32 0
  %a1 = extractelement <2 x double> %a, i32 1
  %b0 = extractelement <2 x double> %b, i32 0
  %b1 = extractelement <2 x double> %b, i32 1
  %c0 = fmul double %a0, %b0
  %c1 = fmul double %a1, %b1
  %r0 = insertelement <2 x double> undef, double %c0, i32 0
  %r1 = insertelement <2 x double> %r0,   double %c1, i32 1
  ret <2 x double> %r1
}

define <2 x double> @buildvector_div_2f64(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: @buildvector_div_2f64(
; CHECK-NEXT:    [[TMP1:%.*]] = fdiv <2 x double> %a, %b
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <2 x double> [[TMP1]], i32 0
; CHECK-NEXT:    [[R0:%.*]] = insertelement <2 x double> undef, double [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <2 x double> [[TMP1]], i32 1
; CHECK-NEXT:    [[R1:%.*]] = insertelement <2 x double> [[R0]], double [[TMP3]], i32 1
; CHECK-NEXT:    ret <2 x double> [[R1]]
;
  %a0 = extractelement <2 x double> %a, i32 0
  %a1 = extractelement <2 x double> %a, i32 1
  %b0 = extractelement <2 x double> %b, i32 0
  %b1 = extractelement <2 x double> %b, i32 1
  %c0 = fdiv double %a0, %b0
  %c1 = fdiv double %a1, %b1
  %r0 = insertelement <2 x double> undef, double %c0, i32 0
  %r1 = insertelement <2 x double> %r0,   double %c1, i32 1
  ret <2 x double> %r1
}

define <4 x float> @buildvector_add_4f32(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: @buildvector_add_4f32(
; CHECK-NEXT:    [[TMP1:%.*]] = fadd <4 x float> %a, %b
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <4 x float> [[TMP1]], i32 0
; CHECK-NEXT:    [[R0:%.*]] = insertelement <4 x float> undef, float [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <4 x float> [[TMP1]], i32 1
; CHECK-NEXT:    [[R1:%.*]] = insertelement <4 x float> [[R0]], float [[TMP3]], i32 1
; CHECK-NEXT:    [[TMP4:%.*]] = extractelement <4 x float> [[TMP1]], i32 2
; CHECK-NEXT:    [[R2:%.*]] = insertelement <4 x float> [[R1]], float [[TMP4]], i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <4 x float> [[TMP1]], i32 3
; CHECK-NEXT:    [[R3:%.*]] = insertelement <4 x float> [[R2]], float [[TMP5]], i32 3
; CHECK-NEXT:    ret <4 x float> [[R3]]
;
  %a0 = extractelement <4 x float> %a, i32 0
  %a1 = extractelement <4 x float> %a, i32 1
  %a2 = extractelement <4 x float> %a, i32 2
  %a3 = extractelement <4 x float> %a, i32 3
  %b0 = extractelement <4 x float> %b, i32 0
  %b1 = extractelement <4 x float> %b, i32 1
  %b2 = extractelement <4 x float> %b, i32 2
  %b3 = extractelement <4 x float> %b, i32 3
  %c0 = fadd float %a0, %b0
  %c1 = fadd float %a1, %b1
  %c2 = fadd float %a2, %b2
  %c3 = fadd float %a3, %b3
  %r0 = insertelement <4 x float> undef, float %c0, i32 0
  %r1 = insertelement <4 x float> %r0,   float %c1, i32 1
  %r2 = insertelement <4 x float> %r1,   float %c2, i32 2
  %r3 = insertelement <4 x float> %r2,   float %c3, i32 3
  ret <4 x float> %r3
}

define <4 x float> @buildvector_sub_4f32(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: @buildvector_sub_4f32(
; CHECK-NEXT:    [[TMP1:%.*]] = fsub <4 x float> %a, %b
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <4 x float> [[TMP1]], i32 0
; CHECK-NEXT:    [[R0:%.*]] = insertelement <4 x float> undef, float [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <4 x float> [[TMP1]], i32 1
; CHECK-NEXT:    [[R1:%.*]] = insertelement <4 x float> [[R0]], float [[TMP3]], i32 1
; CHECK-NEXT:    [[TMP4:%.*]] = extractelement <4 x float> [[TMP1]], i32 2
; CHECK-NEXT:    [[R2:%.*]] = insertelement <4 x float> [[R1]], float [[TMP4]], i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <4 x float> [[TMP1]], i32 3
; CHECK-NEXT:    [[R3:%.*]] = insertelement <4 x float> [[R2]], float [[TMP5]], i32 3
; CHECK-NEXT:    ret <4 x float> [[R3]]
;
  %a0 = extractelement <4 x float> %a, i32 0
  %a1 = extractelement <4 x float> %a, i32 1
  %a2 = extractelement <4 x float> %a, i32 2
  %a3 = extractelement <4 x float> %a, i32 3
  %b0 = extractelement <4 x float> %b, i32 0
  %b1 = extractelement <4 x float> %b, i32 1
  %b2 = extractelement <4 x float> %b, i32 2
  %b3 = extractelement <4 x float> %b, i32 3
  %c0 = fsub float %a0, %b0
  %c1 = fsub float %a1, %b1
  %c2 = fsub float %a2, %b2
  %c3 = fsub float %a3, %b3
  %r0 = insertelement <4 x float> undef, float %c0, i32 0
  %r1 = insertelement <4 x float> %r0,   float %c1, i32 1
  %r2 = insertelement <4 x float> %r1,   float %c2, i32 2
  %r3 = insertelement <4 x float> %r2,   float %c3, i32 3
  ret <4 x float> %r3
}

define <4 x float> @buildvector_mul_4f32(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: @buildvector_mul_4f32(
; CHECK-NEXT:    [[TMP1:%.*]] = fmul <4 x float> %a, %b
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <4 x float> [[TMP1]], i32 0
; CHECK-NEXT:    [[R0:%.*]] = insertelement <4 x float> undef, float [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <4 x float> [[TMP1]], i32 1
; CHECK-NEXT:    [[R1:%.*]] = insertelement <4 x float> [[R0]], float [[TMP3]], i32 1
; CHECK-NEXT:    [[TMP4:%.*]] = extractelement <4 x float> [[TMP1]], i32 2
; CHECK-NEXT:    [[R2:%.*]] = insertelement <4 x float> [[R1]], float [[TMP4]], i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <4 x float> [[TMP1]], i32 3
; CHECK-NEXT:    [[R3:%.*]] = insertelement <4 x float> [[R2]], float [[TMP5]], i32 3
; CHECK-NEXT:    ret <4 x float> [[R3]]
;
  %a0 = extractelement <4 x float> %a, i32 0
  %a1 = extractelement <4 x float> %a, i32 1
  %a2 = extractelement <4 x float> %a, i32 2
  %a3 = extractelement <4 x float> %a, i32 3
  %b0 = extractelement <4 x float> %b, i32 0
  %b1 = extractelement <4 x float> %b, i32 1
  %b2 = extractelement <4 x float> %b, i32 2
  %b3 = extractelement <4 x float> %b, i32 3
  %c0 = fmul float %a0, %b0
  %c1 = fmul float %a1, %b1
  %c2 = fmul float %a2, %b2
  %c3 = fmul float %a3, %b3
  %r0 = insertelement <4 x float> undef, float %c0, i32 0
  %r1 = insertelement <4 x float> %r0,   float %c1, i32 1
  %r2 = insertelement <4 x float> %r1,   float %c2, i32 2
  %r3 = insertelement <4 x float> %r2,   float %c3, i32 3
  ret <4 x float> %r3
}

define <4 x float> @buildvector_div_4f32(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: @buildvector_div_4f32(
; CHECK-NEXT:    [[TMP1:%.*]] = fdiv <4 x float> %a, %b
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <4 x float> [[TMP1]], i32 0
; CHECK-NEXT:    [[R0:%.*]] = insertelement <4 x float> undef, float [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <4 x float> [[TMP1]], i32 1
; CHECK-NEXT:    [[R1:%.*]] = insertelement <4 x float> [[R0]], float [[TMP3]], i32 1
; CHECK-NEXT:    [[TMP4:%.*]] = extractelement <4 x float> [[TMP1]], i32 2
; CHECK-NEXT:    [[R2:%.*]] = insertelement <4 x float> [[R1]], float [[TMP4]], i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <4 x float> [[TMP1]], i32 3
; CHECK-NEXT:    [[R3:%.*]] = insertelement <4 x float> [[R2]], float [[TMP5]], i32 3
; CHECK-NEXT:    ret <4 x float> [[R3]]
;
  %a0 = extractelement <4 x float> %a, i32 0
  %a1 = extractelement <4 x float> %a, i32 1
  %a2 = extractelement <4 x float> %a, i32 2
  %a3 = extractelement <4 x float> %a, i32 3
  %b0 = extractelement <4 x float> %b, i32 0
  %b1 = extractelement <4 x float> %b, i32 1
  %b2 = extractelement <4 x float> %b, i32 2
  %b3 = extractelement <4 x float> %b, i32 3
  %c0 = fdiv float %a0, %b0
  %c1 = fdiv float %a1, %b1
  %c2 = fdiv float %a2, %b2
  %c3 = fdiv float %a3, %b3
  %r0 = insertelement <4 x float> undef, float %c0, i32 0
  %r1 = insertelement <4 x float> %r0,   float %c1, i32 1
  %r2 = insertelement <4 x float> %r1,   float %c2, i32 2
  %r3 = insertelement <4 x float> %r2,   float %c3, i32 3
  ret <4 x float> %r3
}

;
; 256-bit Vectors
;

define <4 x double> @buildvector_add_4f64(<4 x double> %a, <4 x double> %b) {
; CHECK-LABEL: @buildvector_add_4f64(
; CHECK-NEXT:    [[TMP1:%.*]] = fadd <4 x double> %a, %b
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <4 x double> [[TMP1]], i32 0
; CHECK-NEXT:    [[R0:%.*]] = insertelement <4 x double> undef, double [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <4 x double> [[TMP1]], i32 1
; CHECK-NEXT:    [[R1:%.*]] = insertelement <4 x double> [[R0]], double [[TMP3]], i32 1
; CHECK-NEXT:    [[TMP4:%.*]] = extractelement <4 x double> [[TMP1]], i32 2
; CHECK-NEXT:    [[R2:%.*]] = insertelement <4 x double> [[R1]], double [[TMP4]], i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <4 x double> [[TMP1]], i32 3
; CHECK-NEXT:    [[R3:%.*]] = insertelement <4 x double> [[R2]], double [[TMP5]], i32 3
; CHECK-NEXT:    ret <4 x double> [[R3]]
;
  %a0 = extractelement <4 x double> %a, i32 0
  %a1 = extractelement <4 x double> %a, i32 1
  %a2 = extractelement <4 x double> %a, i32 2
  %a3 = extractelement <4 x double> %a, i32 3
  %b0 = extractelement <4 x double> %b, i32 0
  %b1 = extractelement <4 x double> %b, i32 1
  %b2 = extractelement <4 x double> %b, i32 2
  %b3 = extractelement <4 x double> %b, i32 3
  %c0 = fadd double %a0, %b0
  %c1 = fadd double %a1, %b1
  %c2 = fadd double %a2, %b2
  %c3 = fadd double %a3, %b3
  %r0 = insertelement <4 x double> undef, double %c0, i32 0
  %r1 = insertelement <4 x double> %r0,   double %c1, i32 1
  %r2 = insertelement <4 x double> %r1,   double %c2, i32 2
  %r3 = insertelement <4 x double> %r2,   double %c3, i32 3
  ret <4 x double> %r3
}

define <4 x double> @buildvector_sub_4f64(<4 x double> %a, <4 x double> %b) {
; CHECK-LABEL: @buildvector_sub_4f64(
; CHECK-NEXT:    [[TMP1:%.*]] = fsub <4 x double> %a, %b
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <4 x double> [[TMP1]], i32 0
; CHECK-NEXT:    [[R0:%.*]] = insertelement <4 x double> undef, double [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <4 x double> [[TMP1]], i32 1
; CHECK-NEXT:    [[R1:%.*]] = insertelement <4 x double> [[R0]], double [[TMP3]], i32 1
; CHECK-NEXT:    [[TMP4:%.*]] = extractelement <4 x double> [[TMP1]], i32 2
; CHECK-NEXT:    [[R2:%.*]] = insertelement <4 x double> [[R1]], double [[TMP4]], i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <4 x double> [[TMP1]], i32 3
; CHECK-NEXT:    [[R3:%.*]] = insertelement <4 x double> [[R2]], double [[TMP5]], i32 3
; CHECK-NEXT:    ret <4 x double> [[R3]]
;
  %a0 = extractelement <4 x double> %a, i32 0
  %a1 = extractelement <4 x double> %a, i32 1
  %a2 = extractelement <4 x double> %a, i32 2
  %a3 = extractelement <4 x double> %a, i32 3
  %b0 = extractelement <4 x double> %b, i32 0
  %b1 = extractelement <4 x double> %b, i32 1
  %b2 = extractelement <4 x double> %b, i32 2
  %b3 = extractelement <4 x double> %b, i32 3
  %c0 = fsub double %a0, %b0
  %c1 = fsub double %a1, %b1
  %c2 = fsub double %a2, %b2
  %c3 = fsub double %a3, %b3
  %r0 = insertelement <4 x double> undef, double %c0, i32 0
  %r1 = insertelement <4 x double> %r0,   double %c1, i32 1
  %r2 = insertelement <4 x double> %r1,   double %c2, i32 2
  %r3 = insertelement <4 x double> %r2,   double %c3, i32 3
  ret <4 x double> %r3
}

define <4 x double> @buildvector_mul_4f64(<4 x double> %a, <4 x double> %b) {
; CHECK-LABEL: @buildvector_mul_4f64(
; CHECK-NEXT:    [[TMP1:%.*]] = fmul <4 x double> %a, %b
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <4 x double> [[TMP1]], i32 0
; CHECK-NEXT:    [[R0:%.*]] = insertelement <4 x double> undef, double [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <4 x double> [[TMP1]], i32 1
; CHECK-NEXT:    [[R1:%.*]] = insertelement <4 x double> [[R0]], double [[TMP3]], i32 1
; CHECK-NEXT:    [[TMP4:%.*]] = extractelement <4 x double> [[TMP1]], i32 2
; CHECK-NEXT:    [[R2:%.*]] = insertelement <4 x double> [[R1]], double [[TMP4]], i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <4 x double> [[TMP1]], i32 3
; CHECK-NEXT:    [[R3:%.*]] = insertelement <4 x double> [[R2]], double [[TMP5]], i32 3
; CHECK-NEXT:    ret <4 x double> [[R3]]
;
  %a0 = extractelement <4 x double> %a, i32 0
  %a1 = extractelement <4 x double> %a, i32 1
  %a2 = extractelement <4 x double> %a, i32 2
  %a3 = extractelement <4 x double> %a, i32 3
  %b0 = extractelement <4 x double> %b, i32 0
  %b1 = extractelement <4 x double> %b, i32 1
  %b2 = extractelement <4 x double> %b, i32 2
  %b3 = extractelement <4 x double> %b, i32 3
  %c0 = fmul double %a0, %b0
  %c1 = fmul double %a1, %b1
  %c2 = fmul double %a2, %b2
  %c3 = fmul double %a3, %b3
  %r0 = insertelement <4 x double> undef, double %c0, i32 0
  %r1 = insertelement <4 x double> %r0,   double %c1, i32 1
  %r2 = insertelement <4 x double> %r1,   double %c2, i32 2
  %r3 = insertelement <4 x double> %r2,   double %c3, i32 3
  ret <4 x double> %r3
}

define <4 x double> @buildvector_div_4f64(<4 x double> %a, <4 x double> %b) {
; CHECK-LABEL: @buildvector_div_4f64(
; CHECK-NEXT:    [[TMP1:%.*]] = fdiv <4 x double> %a, %b
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <4 x double> [[TMP1]], i32 0
; CHECK-NEXT:    [[R0:%.*]] = insertelement <4 x double> undef, double [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <4 x double> [[TMP1]], i32 1
; CHECK-NEXT:    [[R1:%.*]] = insertelement <4 x double> [[R0]], double [[TMP3]], i32 1
; CHECK-NEXT:    [[TMP4:%.*]] = extractelement <4 x double> [[TMP1]], i32 2
; CHECK-NEXT:    [[R2:%.*]] = insertelement <4 x double> [[R1]], double [[TMP4]], i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <4 x double> [[TMP1]], i32 3
; CHECK-NEXT:    [[R3:%.*]] = insertelement <4 x double> [[R2]], double [[TMP5]], i32 3
; CHECK-NEXT:    ret <4 x double> [[R3]]
;
  %a0 = extractelement <4 x double> %a, i32 0
  %a1 = extractelement <4 x double> %a, i32 1
  %a2 = extractelement <4 x double> %a, i32 2
  %a3 = extractelement <4 x double> %a, i32 3
  %b0 = extractelement <4 x double> %b, i32 0
  %b1 = extractelement <4 x double> %b, i32 1
  %b2 = extractelement <4 x double> %b, i32 2
  %b3 = extractelement <4 x double> %b, i32 3
  %c0 = fdiv double %a0, %b0
  %c1 = fdiv double %a1, %b1
  %c2 = fdiv double %a2, %b2
  %c3 = fdiv double %a3, %b3
  %r0 = insertelement <4 x double> undef, double %c0, i32 0
  %r1 = insertelement <4 x double> %r0,   double %c1, i32 1
  %r2 = insertelement <4 x double> %r1,   double %c2, i32 2
  %r3 = insertelement <4 x double> %r2,   double %c3, i32 3
  ret <4 x double> %r3
}

define <8 x float> @buildvector_add_8f32(<8 x float> %a, <8 x float> %b) {
; CHECK-LABEL: @buildvector_add_8f32(
; CHECK-NEXT:    [[TMP1:%.*]] = fadd <8 x float> %a, %b
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <8 x float> [[TMP1]], i32 0
; CHECK-NEXT:    [[R0:%.*]] = insertelement <8 x float> undef, float [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <8 x float> [[TMP1]], i32 1
; CHECK-NEXT:    [[R1:%.*]] = insertelement <8 x float> [[R0]], float [[TMP3]], i32 1
; CHECK-NEXT:    [[TMP4:%.*]] = extractelement <8 x float> [[TMP1]], i32 2
; CHECK-NEXT:    [[R2:%.*]] = insertelement <8 x float> [[R1]], float [[TMP4]], i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <8 x float> [[TMP1]], i32 3
; CHECK-NEXT:    [[R3:%.*]] = insertelement <8 x float> [[R2]], float [[TMP5]], i32 3
; CHECK-NEXT:    [[TMP6:%.*]] = extractelement <8 x float> [[TMP1]], i32 4
; CHECK-NEXT:    [[R4:%.*]] = insertelement <8 x float> [[R3]], float [[TMP6]], i32 4
; CHECK-NEXT:    [[TMP7:%.*]] = extractelement <8 x float> [[TMP1]], i32 5
; CHECK-NEXT:    [[R5:%.*]] = insertelement <8 x float> [[R4]], float [[TMP7]], i32 5
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <8 x float> [[TMP1]], i32 6
; CHECK-NEXT:    [[R6:%.*]] = insertelement <8 x float> [[R5]], float [[TMP8]], i32 6
; CHECK-NEXT:    [[TMP9:%.*]] = extractelement <8 x float> [[TMP1]], i32 7
; CHECK-NEXT:    [[R7:%.*]] = insertelement <8 x float> [[R6]], float [[TMP9]], i32 7
; CHECK-NEXT:    ret <8 x float> [[R7]]
;
  %a0 = extractelement <8 x float> %a, i32 0
  %a1 = extractelement <8 x float> %a, i32 1
  %a2 = extractelement <8 x float> %a, i32 2
  %a3 = extractelement <8 x float> %a, i32 3
  %a4 = extractelement <8 x float> %a, i32 4
  %a5 = extractelement <8 x float> %a, i32 5
  %a6 = extractelement <8 x float> %a, i32 6
  %a7 = extractelement <8 x float> %a, i32 7
  %b0 = extractelement <8 x float> %b, i32 0
  %b1 = extractelement <8 x float> %b, i32 1
  %b2 = extractelement <8 x float> %b, i32 2
  %b3 = extractelement <8 x float> %b, i32 3
  %b4 = extractelement <8 x float> %b, i32 4
  %b5 = extractelement <8 x float> %b, i32 5
  %b6 = extractelement <8 x float> %b, i32 6
  %b7 = extractelement <8 x float> %b, i32 7
  %c0 = fadd float %a0, %b0
  %c1 = fadd float %a1, %b1
  %c2 = fadd float %a2, %b2
  %c3 = fadd float %a3, %b3
  %c4 = fadd float %a4, %b4
  %c5 = fadd float %a5, %b5
  %c6 = fadd float %a6, %b6
  %c7 = fadd float %a7, %b7
  %r0 = insertelement <8 x float> undef, float %c0, i32 0
  %r1 = insertelement <8 x float> %r0,   float %c1, i32 1
  %r2 = insertelement <8 x float> %r1,   float %c2, i32 2
  %r3 = insertelement <8 x float> %r2,   float %c3, i32 3
  %r4 = insertelement <8 x float> %r3,   float %c4, i32 4
  %r5 = insertelement <8 x float> %r4,   float %c5, i32 5
  %r6 = insertelement <8 x float> %r5,   float %c6, i32 6
  %r7 = insertelement <8 x float> %r6,   float %c7, i32 7
  ret <8 x float> %r7
}

define <8 x float> @buildvector_sub_8f32(<8 x float> %a, <8 x float> %b) {
; CHECK-LABEL: @buildvector_sub_8f32(
; CHECK-NEXT:    [[TMP1:%.*]] = fsub <8 x float> %a, %b
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <8 x float> [[TMP1]], i32 0
; CHECK-NEXT:    [[R0:%.*]] = insertelement <8 x float> undef, float [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <8 x float> [[TMP1]], i32 1
; CHECK-NEXT:    [[R1:%.*]] = insertelement <8 x float> [[R0]], float [[TMP3]], i32 1
; CHECK-NEXT:    [[TMP4:%.*]] = extractelement <8 x float> [[TMP1]], i32 2
; CHECK-NEXT:    [[R2:%.*]] = insertelement <8 x float> [[R1]], float [[TMP4]], i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <8 x float> [[TMP1]], i32 3
; CHECK-NEXT:    [[R3:%.*]] = insertelement <8 x float> [[R2]], float [[TMP5]], i32 3
; CHECK-NEXT:    [[TMP6:%.*]] = extractelement <8 x float> [[TMP1]], i32 4
; CHECK-NEXT:    [[R4:%.*]] = insertelement <8 x float> [[R3]], float [[TMP6]], i32 4
; CHECK-NEXT:    [[TMP7:%.*]] = extractelement <8 x float> [[TMP1]], i32 5
; CHECK-NEXT:    [[R5:%.*]] = insertelement <8 x float> [[R4]], float [[TMP7]], i32 5
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <8 x float> [[TMP1]], i32 6
; CHECK-NEXT:    [[R6:%.*]] = insertelement <8 x float> [[R5]], float [[TMP8]], i32 6
; CHECK-NEXT:    [[TMP9:%.*]] = extractelement <8 x float> [[TMP1]], i32 7
; CHECK-NEXT:    [[R7:%.*]] = insertelement <8 x float> [[R6]], float [[TMP9]], i32 7
; CHECK-NEXT:    ret <8 x float> [[R7]]
;
  %a0 = extractelement <8 x float> %a, i32 0
  %a1 = extractelement <8 x float> %a, i32 1
  %a2 = extractelement <8 x float> %a, i32 2
  %a3 = extractelement <8 x float> %a, i32 3
  %a4 = extractelement <8 x float> %a, i32 4
  %a5 = extractelement <8 x float> %a, i32 5
  %a6 = extractelement <8 x float> %a, i32 6
  %a7 = extractelement <8 x float> %a, i32 7
  %b0 = extractelement <8 x float> %b, i32 0
  %b1 = extractelement <8 x float> %b, i32 1
  %b2 = extractelement <8 x float> %b, i32 2
  %b3 = extractelement <8 x float> %b, i32 3
  %b4 = extractelement <8 x float> %b, i32 4
  %b5 = extractelement <8 x float> %b, i32 5
  %b6 = extractelement <8 x float> %b, i32 6
  %b7 = extractelement <8 x float> %b, i32 7
  %c0 = fsub float %a0, %b0
  %c1 = fsub float %a1, %b1
  %c2 = fsub float %a2, %b2
  %c3 = fsub float %a3, %b3
  %c4 = fsub float %a4, %b4
  %c5 = fsub float %a5, %b5
  %c6 = fsub float %a6, %b6
  %c7 = fsub float %a7, %b7
  %r0 = insertelement <8 x float> undef, float %c0, i32 0
  %r1 = insertelement <8 x float> %r0,   float %c1, i32 1
  %r2 = insertelement <8 x float> %r1,   float %c2, i32 2
  %r3 = insertelement <8 x float> %r2,   float %c3, i32 3
  %r4 = insertelement <8 x float> %r3,   float %c4, i32 4
  %r5 = insertelement <8 x float> %r4,   float %c5, i32 5
  %r6 = insertelement <8 x float> %r5,   float %c6, i32 6
  %r7 = insertelement <8 x float> %r6,   float %c7, i32 7
  ret <8 x float> %r7
}

define <8 x float> @buildvector_mul_8f32(<8 x float> %a, <8 x float> %b) {
; CHECK-LABEL: @buildvector_mul_8f32(
; CHECK-NEXT:    [[TMP1:%.*]] = fmul <8 x float> %a, %b
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <8 x float> [[TMP1]], i32 0
; CHECK-NEXT:    [[R0:%.*]] = insertelement <8 x float> undef, float [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <8 x float> [[TMP1]], i32 1
; CHECK-NEXT:    [[R1:%.*]] = insertelement <8 x float> [[R0]], float [[TMP3]], i32 1
; CHECK-NEXT:    [[TMP4:%.*]] = extractelement <8 x float> [[TMP1]], i32 2
; CHECK-NEXT:    [[R2:%.*]] = insertelement <8 x float> [[R1]], float [[TMP4]], i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <8 x float> [[TMP1]], i32 3
; CHECK-NEXT:    [[R3:%.*]] = insertelement <8 x float> [[R2]], float [[TMP5]], i32 3
; CHECK-NEXT:    [[TMP6:%.*]] = extractelement <8 x float> [[TMP1]], i32 4
; CHECK-NEXT:    [[R4:%.*]] = insertelement <8 x float> [[R3]], float [[TMP6]], i32 4
; CHECK-NEXT:    [[TMP7:%.*]] = extractelement <8 x float> [[TMP1]], i32 5
; CHECK-NEXT:    [[R5:%.*]] = insertelement <8 x float> [[R4]], float [[TMP7]], i32 5
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <8 x float> [[TMP1]], i32 6
; CHECK-NEXT:    [[R6:%.*]] = insertelement <8 x float> [[R5]], float [[TMP8]], i32 6
; CHECK-NEXT:    [[TMP9:%.*]] = extractelement <8 x float> [[TMP1]], i32 7
; CHECK-NEXT:    [[R7:%.*]] = insertelement <8 x float> [[R6]], float [[TMP9]], i32 7
; CHECK-NEXT:    ret <8 x float> [[R7]]
;
  %a0 = extractelement <8 x float> %a, i32 0
  %a1 = extractelement <8 x float> %a, i32 1
  %a2 = extractelement <8 x float> %a, i32 2
  %a3 = extractelement <8 x float> %a, i32 3
  %a4 = extractelement <8 x float> %a, i32 4
  %a5 = extractelement <8 x float> %a, i32 5
  %a6 = extractelement <8 x float> %a, i32 6
  %a7 = extractelement <8 x float> %a, i32 7
  %b0 = extractelement <8 x float> %b, i32 0
  %b1 = extractelement <8 x float> %b, i32 1
  %b2 = extractelement <8 x float> %b, i32 2
  %b3 = extractelement <8 x float> %b, i32 3
  %b4 = extractelement <8 x float> %b, i32 4
  %b5 = extractelement <8 x float> %b, i32 5
  %b6 = extractelement <8 x float> %b, i32 6
  %b7 = extractelement <8 x float> %b, i32 7
  %c0 = fmul float %a0, %b0
  %c1 = fmul float %a1, %b1
  %c2 = fmul float %a2, %b2
  %c3 = fmul float %a3, %b3
  %c4 = fmul float %a4, %b4
  %c5 = fmul float %a5, %b5
  %c6 = fmul float %a6, %b6
  %c7 = fmul float %a7, %b7
  %r0 = insertelement <8 x float> undef, float %c0, i32 0
  %r1 = insertelement <8 x float> %r0,   float %c1, i32 1
  %r2 = insertelement <8 x float> %r1,   float %c2, i32 2
  %r3 = insertelement <8 x float> %r2,   float %c3, i32 3
  %r4 = insertelement <8 x float> %r3,   float %c4, i32 4
  %r5 = insertelement <8 x float> %r4,   float %c5, i32 5
  %r6 = insertelement <8 x float> %r5,   float %c6, i32 6
  %r7 = insertelement <8 x float> %r6,   float %c7, i32 7
  ret <8 x float> %r7
}

define <8 x float> @buildvector_div_8f32(<8 x float> %a, <8 x float> %b) {
; CHECK-LABEL: @buildvector_div_8f32(
; CHECK-NEXT:    [[TMP1:%.*]] = fdiv <8 x float> %a, %b
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <8 x float> [[TMP1]], i32 0
; CHECK-NEXT:    [[R0:%.*]] = insertelement <8 x float> undef, float [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <8 x float> [[TMP1]], i32 1
; CHECK-NEXT:    [[R1:%.*]] = insertelement <8 x float> [[R0]], float [[TMP3]], i32 1
; CHECK-NEXT:    [[TMP4:%.*]] = extractelement <8 x float> [[TMP1]], i32 2
; CHECK-NEXT:    [[R2:%.*]] = insertelement <8 x float> [[R1]], float [[TMP4]], i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <8 x float> [[TMP1]], i32 3
; CHECK-NEXT:    [[R3:%.*]] = insertelement <8 x float> [[R2]], float [[TMP5]], i32 3
; CHECK-NEXT:    [[TMP6:%.*]] = extractelement <8 x float> [[TMP1]], i32 4
; CHECK-NEXT:    [[R4:%.*]] = insertelement <8 x float> [[R3]], float [[TMP6]], i32 4
; CHECK-NEXT:    [[TMP7:%.*]] = extractelement <8 x float> [[TMP1]], i32 5
; CHECK-NEXT:    [[R5:%.*]] = insertelement <8 x float> [[R4]], float [[TMP7]], i32 5
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <8 x float> [[TMP1]], i32 6
; CHECK-NEXT:    [[R6:%.*]] = insertelement <8 x float> [[R5]], float [[TMP8]], i32 6
; CHECK-NEXT:    [[TMP9:%.*]] = extractelement <8 x float> [[TMP1]], i32 7
; CHECK-NEXT:    [[R7:%.*]] = insertelement <8 x float> [[R6]], float [[TMP9]], i32 7
; CHECK-NEXT:    ret <8 x float> [[R7]]
;
  %a0 = extractelement <8 x float> %a, i32 0
  %a1 = extractelement <8 x float> %a, i32 1
  %a2 = extractelement <8 x float> %a, i32 2
  %a3 = extractelement <8 x float> %a, i32 3
  %a4 = extractelement <8 x float> %a, i32 4
  %a5 = extractelement <8 x float> %a, i32 5
  %a6 = extractelement <8 x float> %a, i32 6
  %a7 = extractelement <8 x float> %a, i32 7
  %b0 = extractelement <8 x float> %b, i32 0
  %b1 = extractelement <8 x float> %b, i32 1
  %b2 = extractelement <8 x float> %b, i32 2
  %b3 = extractelement <8 x float> %b, i32 3
  %b4 = extractelement <8 x float> %b, i32 4
  %b5 = extractelement <8 x float> %b, i32 5
  %b6 = extractelement <8 x float> %b, i32 6
  %b7 = extractelement <8 x float> %b, i32 7
  %c0 = fdiv float %a0, %b0
  %c1 = fdiv float %a1, %b1
  %c2 = fdiv float %a2, %b2
  %c3 = fdiv float %a3, %b3
  %c4 = fdiv float %a4, %b4
  %c5 = fdiv float %a5, %b5
  %c6 = fdiv float %a6, %b6
  %c7 = fdiv float %a7, %b7
  %r0 = insertelement <8 x float> undef, float %c0, i32 0
  %r1 = insertelement <8 x float> %r0,   float %c1, i32 1
  %r2 = insertelement <8 x float> %r1,   float %c2, i32 2
  %r3 = insertelement <8 x float> %r2,   float %c3, i32 3
  %r4 = insertelement <8 x float> %r3,   float %c4, i32 4
  %r5 = insertelement <8 x float> %r4,   float %c5, i32 5
  %r6 = insertelement <8 x float> %r5,   float %c6, i32 6
  %r7 = insertelement <8 x float> %r6,   float %c7, i32 7
  ret <8 x float> %r7
}

;
; 512-bit Vectors
;

define <8 x double> @buildvector_add_8f64(<8 x double> %a, <8 x double> %b) {
; CHECK-LABEL: @buildvector_add_8f64(
; CHECK-NEXT:    [[TMP1:%.*]] = fadd <8 x double> %a, %b
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <8 x double> [[TMP1]], i32 0
; CHECK-NEXT:    [[R0:%.*]] = insertelement <8 x double> undef, double [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <8 x double> [[TMP1]], i32 1
; CHECK-NEXT:    [[R1:%.*]] = insertelement <8 x double> [[R0]], double [[TMP3]], i32 1
; CHECK-NEXT:    [[TMP4:%.*]] = extractelement <8 x double> [[TMP1]], i32 2
; CHECK-NEXT:    [[R2:%.*]] = insertelement <8 x double> [[R1]], double [[TMP4]], i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <8 x double> [[TMP1]], i32 3
; CHECK-NEXT:    [[R3:%.*]] = insertelement <8 x double> [[R2]], double [[TMP5]], i32 3
; CHECK-NEXT:    [[TMP6:%.*]] = extractelement <8 x double> [[TMP1]], i32 4
; CHECK-NEXT:    [[R4:%.*]] = insertelement <8 x double> [[R3]], double [[TMP6]], i32 4
; CHECK-NEXT:    [[TMP7:%.*]] = extractelement <8 x double> [[TMP1]], i32 5
; CHECK-NEXT:    [[R5:%.*]] = insertelement <8 x double> [[R4]], double [[TMP7]], i32 5
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <8 x double> [[TMP1]], i32 6
; CHECK-NEXT:    [[R6:%.*]] = insertelement <8 x double> [[R5]], double [[TMP8]], i32 6
; CHECK-NEXT:    [[TMP9:%.*]] = extractelement <8 x double> [[TMP1]], i32 7
; CHECK-NEXT:    [[R7:%.*]] = insertelement <8 x double> [[R6]], double [[TMP9]], i32 7
; CHECK-NEXT:    ret <8 x double> [[R7]]
;
  %a0 = extractelement <8 x double> %a, i32 0
  %a1 = extractelement <8 x double> %a, i32 1
  %a2 = extractelement <8 x double> %a, i32 2
  %a3 = extractelement <8 x double> %a, i32 3
  %a4 = extractelement <8 x double> %a, i32 4
  %a5 = extractelement <8 x double> %a, i32 5
  %a6 = extractelement <8 x double> %a, i32 6
  %a7 = extractelement <8 x double> %a, i32 7
  %b0 = extractelement <8 x double> %b, i32 0
  %b1 = extractelement <8 x double> %b, i32 1
  %b2 = extractelement <8 x double> %b, i32 2
  %b3 = extractelement <8 x double> %b, i32 3
  %b4 = extractelement <8 x double> %b, i32 4
  %b5 = extractelement <8 x double> %b, i32 5
  %b6 = extractelement <8 x double> %b, i32 6
  %b7 = extractelement <8 x double> %b, i32 7
  %c0 = fadd double %a0, %b0
  %c1 = fadd double %a1, %b1
  %c2 = fadd double %a2, %b2
  %c3 = fadd double %a3, %b3
  %c4 = fadd double %a4, %b4
  %c5 = fadd double %a5, %b5
  %c6 = fadd double %a6, %b6
  %c7 = fadd double %a7, %b7
  %r0 = insertelement <8 x double> undef, double %c0, i32 0
  %r1 = insertelement <8 x double> %r0,   double %c1, i32 1
  %r2 = insertelement <8 x double> %r1,   double %c2, i32 2
  %r3 = insertelement <8 x double> %r2,   double %c3, i32 3
  %r4 = insertelement <8 x double> %r3,   double %c4, i32 4
  %r5 = insertelement <8 x double> %r4,   double %c5, i32 5
  %r6 = insertelement <8 x double> %r5,   double %c6, i32 6
  %r7 = insertelement <8 x double> %r6,   double %c7, i32 7
  ret <8 x double> %r7
}

define <8 x double> @buildvector_sub_8f64(<8 x double> %a, <8 x double> %b) {
; CHECK-LABEL: @buildvector_sub_8f64(
; CHECK-NEXT:    [[TMP1:%.*]] = fsub <8 x double> %a, %b
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <8 x double> [[TMP1]], i32 0
; CHECK-NEXT:    [[R0:%.*]] = insertelement <8 x double> undef, double [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <8 x double> [[TMP1]], i32 1
; CHECK-NEXT:    [[R1:%.*]] = insertelement <8 x double> [[R0]], double [[TMP3]], i32 1
; CHECK-NEXT:    [[TMP4:%.*]] = extractelement <8 x double> [[TMP1]], i32 2
; CHECK-NEXT:    [[R2:%.*]] = insertelement <8 x double> [[R1]], double [[TMP4]], i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <8 x double> [[TMP1]], i32 3
; CHECK-NEXT:    [[R3:%.*]] = insertelement <8 x double> [[R2]], double [[TMP5]], i32 3
; CHECK-NEXT:    [[TMP6:%.*]] = extractelement <8 x double> [[TMP1]], i32 4
; CHECK-NEXT:    [[R4:%.*]] = insertelement <8 x double> [[R3]], double [[TMP6]], i32 4
; CHECK-NEXT:    [[TMP7:%.*]] = extractelement <8 x double> [[TMP1]], i32 5
; CHECK-NEXT:    [[R5:%.*]] = insertelement <8 x double> [[R4]], double [[TMP7]], i32 5
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <8 x double> [[TMP1]], i32 6
; CHECK-NEXT:    [[R6:%.*]] = insertelement <8 x double> [[R5]], double [[TMP8]], i32 6
; CHECK-NEXT:    [[TMP9:%.*]] = extractelement <8 x double> [[TMP1]], i32 7
; CHECK-NEXT:    [[R7:%.*]] = insertelement <8 x double> [[R6]], double [[TMP9]], i32 7
; CHECK-NEXT:    ret <8 x double> [[R7]]
;
  %a0 = extractelement <8 x double> %a, i32 0
  %a1 = extractelement <8 x double> %a, i32 1
  %a2 = extractelement <8 x double> %a, i32 2
  %a3 = extractelement <8 x double> %a, i32 3
  %a4 = extractelement <8 x double> %a, i32 4
  %a5 = extractelement <8 x double> %a, i32 5
  %a6 = extractelement <8 x double> %a, i32 6
  %a7 = extractelement <8 x double> %a, i32 7
  %b0 = extractelement <8 x double> %b, i32 0
  %b1 = extractelement <8 x double> %b, i32 1
  %b2 = extractelement <8 x double> %b, i32 2
  %b3 = extractelement <8 x double> %b, i32 3
  %b4 = extractelement <8 x double> %b, i32 4
  %b5 = extractelement <8 x double> %b, i32 5
  %b6 = extractelement <8 x double> %b, i32 6
  %b7 = extractelement <8 x double> %b, i32 7
  %c0 = fsub double %a0, %b0
  %c1 = fsub double %a1, %b1
  %c2 = fsub double %a2, %b2
  %c3 = fsub double %a3, %b3
  %c4 = fsub double %a4, %b4
  %c5 = fsub double %a5, %b5
  %c6 = fsub double %a6, %b6
  %c7 = fsub double %a7, %b7
  %r0 = insertelement <8 x double> undef, double %c0, i32 0
  %r1 = insertelement <8 x double> %r0,   double %c1, i32 1
  %r2 = insertelement <8 x double> %r1,   double %c2, i32 2
  %r3 = insertelement <8 x double> %r2,   double %c3, i32 3
  %r4 = insertelement <8 x double> %r3,   double %c4, i32 4
  %r5 = insertelement <8 x double> %r4,   double %c5, i32 5
  %r6 = insertelement <8 x double> %r5,   double %c6, i32 6
  %r7 = insertelement <8 x double> %r6,   double %c7, i32 7
  ret <8 x double> %r7
}

define <8 x double> @buildvector_mul_8f64(<8 x double> %a, <8 x double> %b) {
; CHECK-LABEL: @buildvector_mul_8f64(
; CHECK-NEXT:    [[TMP1:%.*]] = fmul <8 x double> %a, %b
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <8 x double> [[TMP1]], i32 0
; CHECK-NEXT:    [[R0:%.*]] = insertelement <8 x double> undef, double [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <8 x double> [[TMP1]], i32 1
; CHECK-NEXT:    [[R1:%.*]] = insertelement <8 x double> [[R0]], double [[TMP3]], i32 1
; CHECK-NEXT:    [[TMP4:%.*]] = extractelement <8 x double> [[TMP1]], i32 2
; CHECK-NEXT:    [[R2:%.*]] = insertelement <8 x double> [[R1]], double [[TMP4]], i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <8 x double> [[TMP1]], i32 3
; CHECK-NEXT:    [[R3:%.*]] = insertelement <8 x double> [[R2]], double [[TMP5]], i32 3
; CHECK-NEXT:    [[TMP6:%.*]] = extractelement <8 x double> [[TMP1]], i32 4
; CHECK-NEXT:    [[R4:%.*]] = insertelement <8 x double> [[R3]], double [[TMP6]], i32 4
; CHECK-NEXT:    [[TMP7:%.*]] = extractelement <8 x double> [[TMP1]], i32 5
; CHECK-NEXT:    [[R5:%.*]] = insertelement <8 x double> [[R4]], double [[TMP7]], i32 5
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <8 x double> [[TMP1]], i32 6
; CHECK-NEXT:    [[R6:%.*]] = insertelement <8 x double> [[R5]], double [[TMP8]], i32 6
; CHECK-NEXT:    [[TMP9:%.*]] = extractelement <8 x double> [[TMP1]], i32 7
; CHECK-NEXT:    [[R7:%.*]] = insertelement <8 x double> [[R6]], double [[TMP9]], i32 7
; CHECK-NEXT:    ret <8 x double> [[R7]]
;
  %a0 = extractelement <8 x double> %a, i32 0
  %a1 = extractelement <8 x double> %a, i32 1
  %a2 = extractelement <8 x double> %a, i32 2
  %a3 = extractelement <8 x double> %a, i32 3
  %a4 = extractelement <8 x double> %a, i32 4
  %a5 = extractelement <8 x double> %a, i32 5
  %a6 = extractelement <8 x double> %a, i32 6
  %a7 = extractelement <8 x double> %a, i32 7
  %b0 = extractelement <8 x double> %b, i32 0
  %b1 = extractelement <8 x double> %b, i32 1
  %b2 = extractelement <8 x double> %b, i32 2
  %b3 = extractelement <8 x double> %b, i32 3
  %b4 = extractelement <8 x double> %b, i32 4
  %b5 = extractelement <8 x double> %b, i32 5
  %b6 = extractelement <8 x double> %b, i32 6
  %b7 = extractelement <8 x double> %b, i32 7
  %c0 = fmul double %a0, %b0
  %c1 = fmul double %a1, %b1
  %c2 = fmul double %a2, %b2
  %c3 = fmul double %a3, %b3
  %c4 = fmul double %a4, %b4
  %c5 = fmul double %a5, %b5
  %c6 = fmul double %a6, %b6
  %c7 = fmul double %a7, %b7
  %r0 = insertelement <8 x double> undef, double %c0, i32 0
  %r1 = insertelement <8 x double> %r0,   double %c1, i32 1
  %r2 = insertelement <8 x double> %r1,   double %c2, i32 2
  %r3 = insertelement <8 x double> %r2,   double %c3, i32 3
  %r4 = insertelement <8 x double> %r3,   double %c4, i32 4
  %r5 = insertelement <8 x double> %r4,   double %c5, i32 5
  %r6 = insertelement <8 x double> %r5,   double %c6, i32 6
  %r7 = insertelement <8 x double> %r6,   double %c7, i32 7
  ret <8 x double> %r7
}

define <8 x double> @buildvector_div_8f64(<8 x double> %a, <8 x double> %b) {
; CHECK-LABEL: @buildvector_div_8f64(
; CHECK-NEXT:    [[TMP1:%.*]] = fdiv <8 x double> %a, %b
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <8 x double> [[TMP1]], i32 0
; CHECK-NEXT:    [[R0:%.*]] = insertelement <8 x double> undef, double [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <8 x double> [[TMP1]], i32 1
; CHECK-NEXT:    [[R1:%.*]] = insertelement <8 x double> [[R0]], double [[TMP3]], i32 1
; CHECK-NEXT:    [[TMP4:%.*]] = extractelement <8 x double> [[TMP1]], i32 2
; CHECK-NEXT:    [[R2:%.*]] = insertelement <8 x double> [[R1]], double [[TMP4]], i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <8 x double> [[TMP1]], i32 3
; CHECK-NEXT:    [[R3:%.*]] = insertelement <8 x double> [[R2]], double [[TMP5]], i32 3
; CHECK-NEXT:    [[TMP6:%.*]] = extractelement <8 x double> [[TMP1]], i32 4
; CHECK-NEXT:    [[R4:%.*]] = insertelement <8 x double> [[R3]], double [[TMP6]], i32 4
; CHECK-NEXT:    [[TMP7:%.*]] = extractelement <8 x double> [[TMP1]], i32 5
; CHECK-NEXT:    [[R5:%.*]] = insertelement <8 x double> [[R4]], double [[TMP7]], i32 5
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <8 x double> [[TMP1]], i32 6
; CHECK-NEXT:    [[R6:%.*]] = insertelement <8 x double> [[R5]], double [[TMP8]], i32 6
; CHECK-NEXT:    [[TMP9:%.*]] = extractelement <8 x double> [[TMP1]], i32 7
; CHECK-NEXT:    [[R7:%.*]] = insertelement <8 x double> [[R6]], double [[TMP9]], i32 7
; CHECK-NEXT:    ret <8 x double> [[R7]]
;
  %a0 = extractelement <8 x double> %a, i32 0
  %a1 = extractelement <8 x double> %a, i32 1
  %a2 = extractelement <8 x double> %a, i32 2
  %a3 = extractelement <8 x double> %a, i32 3
  %a4 = extractelement <8 x double> %a, i32 4
  %a5 = extractelement <8 x double> %a, i32 5
  %a6 = extractelement <8 x double> %a, i32 6
  %a7 = extractelement <8 x double> %a, i32 7
  %b0 = extractelement <8 x double> %b, i32 0
  %b1 = extractelement <8 x double> %b, i32 1
  %b2 = extractelement <8 x double> %b, i32 2
  %b3 = extractelement <8 x double> %b, i32 3
  %b4 = extractelement <8 x double> %b, i32 4
  %b5 = extractelement <8 x double> %b, i32 5
  %b6 = extractelement <8 x double> %b, i32 6
  %b7 = extractelement <8 x double> %b, i32 7
  %c0 = fdiv double %a0, %b0
  %c1 = fdiv double %a1, %b1
  %c2 = fdiv double %a2, %b2
  %c3 = fdiv double %a3, %b3
  %c4 = fdiv double %a4, %b4
  %c5 = fdiv double %a5, %b5
  %c6 = fdiv double %a6, %b6
  %c7 = fdiv double %a7, %b7
  %r0 = insertelement <8 x double> undef, double %c0, i32 0
  %r1 = insertelement <8 x double> %r0,   double %c1, i32 1
  %r2 = insertelement <8 x double> %r1,   double %c2, i32 2
  %r3 = insertelement <8 x double> %r2,   double %c3, i32 3
  %r4 = insertelement <8 x double> %r3,   double %c4, i32 4
  %r5 = insertelement <8 x double> %r4,   double %c5, i32 5
  %r6 = insertelement <8 x double> %r5,   double %c6, i32 6
  %r7 = insertelement <8 x double> %r6,   double %c7, i32 7
  ret <8 x double> %r7
}

define <16 x float> @buildvector_add_16f32(<16 x float> %a, <16 x float> %b) {
; CHECK-LABEL: @buildvector_add_16f32(
; CHECK-NEXT:    [[TMP1:%.*]] = fadd <16 x float> %a, %b
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <16 x float> [[TMP1]], i32 0
; CHECK-NEXT:    [[R0:%.*]] = insertelement <16 x float> undef, float [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <16 x float> [[TMP1]], i32 1
; CHECK-NEXT:    [[R1:%.*]] = insertelement <16 x float> [[R0]], float [[TMP3]], i32 1
; CHECK-NEXT:    [[TMP4:%.*]] = extractelement <16 x float> [[TMP1]], i32 2
; CHECK-NEXT:    [[R2:%.*]] = insertelement <16 x float> [[R1]], float [[TMP4]], i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <16 x float> [[TMP1]], i32 3
; CHECK-NEXT:    [[R3:%.*]] = insertelement <16 x float> [[R2]], float [[TMP5]], i32 3
; CHECK-NEXT:    [[TMP6:%.*]] = extractelement <16 x float> [[TMP1]], i32 4
; CHECK-NEXT:    [[R4:%.*]] = insertelement <16 x float> [[R3]], float [[TMP6]], i32 4
; CHECK-NEXT:    [[TMP7:%.*]] = extractelement <16 x float> [[TMP1]], i32 5
; CHECK-NEXT:    [[R5:%.*]] = insertelement <16 x float> [[R4]], float [[TMP7]], i32 5
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <16 x float> [[TMP1]], i32 6
; CHECK-NEXT:    [[R6:%.*]] = insertelement <16 x float> [[R5]], float [[TMP8]], i32 6
; CHECK-NEXT:    [[TMP9:%.*]] = extractelement <16 x float> [[TMP1]], i32 7
; CHECK-NEXT:    [[R7:%.*]] = insertelement <16 x float> [[R6]], float [[TMP9]], i32 7
; CHECK-NEXT:    [[TMP10:%.*]] = extractelement <16 x float> [[TMP1]], i32 8
; CHECK-NEXT:    [[R8:%.*]] = insertelement <16 x float> [[R7]], float [[TMP10]], i32 8
; CHECK-NEXT:    [[TMP11:%.*]] = extractelement <16 x float> [[TMP1]], i32 9
; CHECK-NEXT:    [[R9:%.*]] = insertelement <16 x float> [[R8]], float [[TMP11]], i32 9
; CHECK-NEXT:    [[TMP12:%.*]] = extractelement <16 x float> [[TMP1]], i32 10
; CHECK-NEXT:    [[R10:%.*]] = insertelement <16 x float> [[R9]], float [[TMP12]], i32 10
; CHECK-NEXT:    [[TMP13:%.*]] = extractelement <16 x float> [[TMP1]], i32 11
; CHECK-NEXT:    [[R11:%.*]] = insertelement <16 x float> [[R10]], float [[TMP13]], i32 11
; CHECK-NEXT:    [[TMP14:%.*]] = extractelement <16 x float> [[TMP1]], i32 12
; CHECK-NEXT:    [[R12:%.*]] = insertelement <16 x float> [[R11]], float [[TMP14]], i32 12
; CHECK-NEXT:    [[TMP15:%.*]] = extractelement <16 x float> [[TMP1]], i32 13
; CHECK-NEXT:    [[R13:%.*]] = insertelement <16 x float> [[R12]], float [[TMP15]], i32 13
; CHECK-NEXT:    [[TMP16:%.*]] = extractelement <16 x float> [[TMP1]], i32 14
; CHECK-NEXT:    [[R14:%.*]] = insertelement <16 x float> [[R13]], float [[TMP16]], i32 14
; CHECK-NEXT:    [[TMP17:%.*]] = extractelement <16 x float> [[TMP1]], i32 15
; CHECK-NEXT:    [[R15:%.*]] = insertelement <16 x float> [[R14]], float [[TMP17]], i32 15
; CHECK-NEXT:    ret <16 x float> [[R15]]
;
  %a0  = extractelement <16 x float> %a, i32 0
  %a1  = extractelement <16 x float> %a, i32 1
  %a2  = extractelement <16 x float> %a, i32 2
  %a3  = extractelement <16 x float> %a, i32 3
  %a4  = extractelement <16 x float> %a, i32 4
  %a5  = extractelement <16 x float> %a, i32 5
  %a6  = extractelement <16 x float> %a, i32 6
  %a7  = extractelement <16 x float> %a, i32 7
  %a8  = extractelement <16 x float> %a, i32 8
  %a9  = extractelement <16 x float> %a, i32 9
  %a10 = extractelement <16 x float> %a, i32 10
  %a11 = extractelement <16 x float> %a, i32 11
  %a12 = extractelement <16 x float> %a, i32 12
  %a13 = extractelement <16 x float> %a, i32 13
  %a14 = extractelement <16 x float> %a, i32 14
  %a15 = extractelement <16 x float> %a, i32 15
  %b0  = extractelement <16 x float> %b, i32 0
  %b1  = extractelement <16 x float> %b, i32 1
  %b2  = extractelement <16 x float> %b, i32 2
  %b3  = extractelement <16 x float> %b, i32 3
  %b4  = extractelement <16 x float> %b, i32 4
  %b5  = extractelement <16 x float> %b, i32 5
  %b6  = extractelement <16 x float> %b, i32 6
  %b7  = extractelement <16 x float> %b, i32 7
  %b8  = extractelement <16 x float> %b, i32 8
  %b9  = extractelement <16 x float> %b, i32 9
  %b10 = extractelement <16 x float> %b, i32 10
  %b11 = extractelement <16 x float> %b, i32 11
  %b12 = extractelement <16 x float> %b, i32 12
  %b13 = extractelement <16 x float> %b, i32 13
  %b14 = extractelement <16 x float> %b, i32 14
  %b15 = extractelement <16 x float> %b, i32 15
  %c0  = fadd float %a0 , %b0
  %c1  = fadd float %a1 , %b1
  %c2  = fadd float %a2 , %b2
  %c3  = fadd float %a3 , %b3
  %c4  = fadd float %a4 , %b4
  %c5  = fadd float %a5 , %b5
  %c6  = fadd float %a6 , %b6
  %c7  = fadd float %a7 , %b7
  %c8  = fadd float %a8 , %b8
  %c9  = fadd float %a9 , %b9
  %c10 = fadd float %a10, %b10
  %c11 = fadd float %a11, %b11
  %c12 = fadd float %a12, %b12
  %c13 = fadd float %a13, %b13
  %c14 = fadd float %a14, %b14
  %c15 = fadd float %a15, %b15
  %r0  = insertelement <16 x float> undef, float %c0 , i32 0
  %r1  = insertelement <16 x float> %r0 ,  float %c1 , i32 1
  %r2  = insertelement <16 x float> %r1 ,  float %c2 , i32 2
  %r3  = insertelement <16 x float> %r2 ,  float %c3 , i32 3
  %r4  = insertelement <16 x float> %r3 ,  float %c4 , i32 4
  %r5  = insertelement <16 x float> %r4 ,  float %c5 , i32 5
  %r6  = insertelement <16 x float> %r5 ,  float %c6 , i32 6
  %r7  = insertelement <16 x float> %r6 ,  float %c7 , i32 7
  %r8  = insertelement <16 x float> %r7 ,  float %c8 , i32 8
  %r9  = insertelement <16 x float> %r8 ,  float %c9 , i32 9
  %r10 = insertelement <16 x float> %r9 ,  float %c10, i32 10
  %r11 = insertelement <16 x float> %r10,  float %c11, i32 11
  %r12 = insertelement <16 x float> %r11,  float %c12, i32 12
  %r13 = insertelement <16 x float> %r12,  float %c13, i32 13
  %r14 = insertelement <16 x float> %r13,  float %c14, i32 14
  %r15 = insertelement <16 x float> %r14,  float %c15, i32 15
  ret <16 x float> %r15
}

define <16 x float> @buildvector_sub_16f32(<16 x float> %a, <16 x float> %b) {
; CHECK-LABEL: @buildvector_sub_16f32(
; CHECK-NEXT:    [[TMP1:%.*]] = fsub <16 x float> %a, %b
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <16 x float> [[TMP1]], i32 0
; CHECK-NEXT:    [[R0:%.*]] = insertelement <16 x float> undef, float [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <16 x float> [[TMP1]], i32 1
; CHECK-NEXT:    [[R1:%.*]] = insertelement <16 x float> [[R0]], float [[TMP3]], i32 1
; CHECK-NEXT:    [[TMP4:%.*]] = extractelement <16 x float> [[TMP1]], i32 2
; CHECK-NEXT:    [[R2:%.*]] = insertelement <16 x float> [[R1]], float [[TMP4]], i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <16 x float> [[TMP1]], i32 3
; CHECK-NEXT:    [[R3:%.*]] = insertelement <16 x float> [[R2]], float [[TMP5]], i32 3
; CHECK-NEXT:    [[TMP6:%.*]] = extractelement <16 x float> [[TMP1]], i32 4
; CHECK-NEXT:    [[R4:%.*]] = insertelement <16 x float> [[R3]], float [[TMP6]], i32 4
; CHECK-NEXT:    [[TMP7:%.*]] = extractelement <16 x float> [[TMP1]], i32 5
; CHECK-NEXT:    [[R5:%.*]] = insertelement <16 x float> [[R4]], float [[TMP7]], i32 5
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <16 x float> [[TMP1]], i32 6
; CHECK-NEXT:    [[R6:%.*]] = insertelement <16 x float> [[R5]], float [[TMP8]], i32 6
; CHECK-NEXT:    [[TMP9:%.*]] = extractelement <16 x float> [[TMP1]], i32 7
; CHECK-NEXT:    [[R7:%.*]] = insertelement <16 x float> [[R6]], float [[TMP9]], i32 7
; CHECK-NEXT:    [[TMP10:%.*]] = extractelement <16 x float> [[TMP1]], i32 8
; CHECK-NEXT:    [[R8:%.*]] = insertelement <16 x float> [[R7]], float [[TMP10]], i32 8
; CHECK-NEXT:    [[TMP11:%.*]] = extractelement <16 x float> [[TMP1]], i32 9
; CHECK-NEXT:    [[R9:%.*]] = insertelement <16 x float> [[R8]], float [[TMP11]], i32 9
; CHECK-NEXT:    [[TMP12:%.*]] = extractelement <16 x float> [[TMP1]], i32 10
; CHECK-NEXT:    [[R10:%.*]] = insertelement <16 x float> [[R9]], float [[TMP12]], i32 10
; CHECK-NEXT:    [[TMP13:%.*]] = extractelement <16 x float> [[TMP1]], i32 11
; CHECK-NEXT:    [[R11:%.*]] = insertelement <16 x float> [[R10]], float [[TMP13]], i32 11
; CHECK-NEXT:    [[TMP14:%.*]] = extractelement <16 x float> [[TMP1]], i32 12
; CHECK-NEXT:    [[R12:%.*]] = insertelement <16 x float> [[R11]], float [[TMP14]], i32 12
; CHECK-NEXT:    [[TMP15:%.*]] = extractelement <16 x float> [[TMP1]], i32 13
; CHECK-NEXT:    [[R13:%.*]] = insertelement <16 x float> [[R12]], float [[TMP15]], i32 13
; CHECK-NEXT:    [[TMP16:%.*]] = extractelement <16 x float> [[TMP1]], i32 14
; CHECK-NEXT:    [[R14:%.*]] = insertelement <16 x float> [[R13]], float [[TMP16]], i32 14
; CHECK-NEXT:    [[TMP17:%.*]] = extractelement <16 x float> [[TMP1]], i32 15
; CHECK-NEXT:    [[R15:%.*]] = insertelement <16 x float> [[R14]], float [[TMP17]], i32 15
; CHECK-NEXT:    ret <16 x float> [[R15]]
;
  %a0  = extractelement <16 x float> %a, i32 0
  %a1  = extractelement <16 x float> %a, i32 1
  %a2  = extractelement <16 x float> %a, i32 2
  %a3  = extractelement <16 x float> %a, i32 3
  %a4  = extractelement <16 x float> %a, i32 4
  %a5  = extractelement <16 x float> %a, i32 5
  %a6  = extractelement <16 x float> %a, i32 6
  %a7  = extractelement <16 x float> %a, i32 7
  %a8  = extractelement <16 x float> %a, i32 8
  %a9  = extractelement <16 x float> %a, i32 9
  %a10 = extractelement <16 x float> %a, i32 10
  %a11 = extractelement <16 x float> %a, i32 11
  %a12 = extractelement <16 x float> %a, i32 12
  %a13 = extractelement <16 x float> %a, i32 13
  %a14 = extractelement <16 x float> %a, i32 14
  %a15 = extractelement <16 x float> %a, i32 15
  %b0  = extractelement <16 x float> %b, i32 0
  %b1  = extractelement <16 x float> %b, i32 1
  %b2  = extractelement <16 x float> %b, i32 2
  %b3  = extractelement <16 x float> %b, i32 3
  %b4  = extractelement <16 x float> %b, i32 4
  %b5  = extractelement <16 x float> %b, i32 5
  %b6  = extractelement <16 x float> %b, i32 6
  %b7  = extractelement <16 x float> %b, i32 7
  %b8  = extractelement <16 x float> %b, i32 8
  %b9  = extractelement <16 x float> %b, i32 9
  %b10 = extractelement <16 x float> %b, i32 10
  %b11 = extractelement <16 x float> %b, i32 11
  %b12 = extractelement <16 x float> %b, i32 12
  %b13 = extractelement <16 x float> %b, i32 13
  %b14 = extractelement <16 x float> %b, i32 14
  %b15 = extractelement <16 x float> %b, i32 15
  %c0  = fsub float %a0 , %b0
  %c1  = fsub float %a1 , %b1
  %c2  = fsub float %a2 , %b2
  %c3  = fsub float %a3 , %b3
  %c4  = fsub float %a4 , %b4
  %c5  = fsub float %a5 , %b5
  %c6  = fsub float %a6 , %b6
  %c7  = fsub float %a7 , %b7
  %c8  = fsub float %a8 , %b8
  %c9  = fsub float %a9 , %b9
  %c10 = fsub float %a10, %b10
  %c11 = fsub float %a11, %b11
  %c12 = fsub float %a12, %b12
  %c13 = fsub float %a13, %b13
  %c14 = fsub float %a14, %b14
  %c15 = fsub float %a15, %b15
  %r0  = insertelement <16 x float> undef, float %c0 , i32 0
  %r1  = insertelement <16 x float> %r0 ,  float %c1 , i32 1
  %r2  = insertelement <16 x float> %r1 ,  float %c2 , i32 2
  %r3  = insertelement <16 x float> %r2 ,  float %c3 , i32 3
  %r4  = insertelement <16 x float> %r3 ,  float %c4 , i32 4
  %r5  = insertelement <16 x float> %r4 ,  float %c5 , i32 5
  %r6  = insertelement <16 x float> %r5 ,  float %c6 , i32 6
  %r7  = insertelement <16 x float> %r6 ,  float %c7 , i32 7
  %r8  = insertelement <16 x float> %r7 ,  float %c8 , i32 8
  %r9  = insertelement <16 x float> %r8 ,  float %c9 , i32 9
  %r10 = insertelement <16 x float> %r9 ,  float %c10, i32 10
  %r11 = insertelement <16 x float> %r10,  float %c11, i32 11
  %r12 = insertelement <16 x float> %r11,  float %c12, i32 12
  %r13 = insertelement <16 x float> %r12,  float %c13, i32 13
  %r14 = insertelement <16 x float> %r13,  float %c14, i32 14
  %r15 = insertelement <16 x float> %r14,  float %c15, i32 15
  ret <16 x float> %r15
}

define <16 x float> @buildvector_mul_16f32(<16 x float> %a, <16 x float> %b) {
; CHECK-LABEL: @buildvector_mul_16f32(
; CHECK-NEXT:    [[TMP1:%.*]] = fmul <16 x float> %a, %b
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <16 x float> [[TMP1]], i32 0
; CHECK-NEXT:    [[R0:%.*]] = insertelement <16 x float> undef, float [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <16 x float> [[TMP1]], i32 1
; CHECK-NEXT:    [[R1:%.*]] = insertelement <16 x float> [[R0]], float [[TMP3]], i32 1
; CHECK-NEXT:    [[TMP4:%.*]] = extractelement <16 x float> [[TMP1]], i32 2
; CHECK-NEXT:    [[R2:%.*]] = insertelement <16 x float> [[R1]], float [[TMP4]], i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <16 x float> [[TMP1]], i32 3
; CHECK-NEXT:    [[R3:%.*]] = insertelement <16 x float> [[R2]], float [[TMP5]], i32 3
; CHECK-NEXT:    [[TMP6:%.*]] = extractelement <16 x float> [[TMP1]], i32 4
; CHECK-NEXT:    [[R4:%.*]] = insertelement <16 x float> [[R3]], float [[TMP6]], i32 4
; CHECK-NEXT:    [[TMP7:%.*]] = extractelement <16 x float> [[TMP1]], i32 5
; CHECK-NEXT:    [[R5:%.*]] = insertelement <16 x float> [[R4]], float [[TMP7]], i32 5
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <16 x float> [[TMP1]], i32 6
; CHECK-NEXT:    [[R6:%.*]] = insertelement <16 x float> [[R5]], float [[TMP8]], i32 6
; CHECK-NEXT:    [[TMP9:%.*]] = extractelement <16 x float> [[TMP1]], i32 7
; CHECK-NEXT:    [[R7:%.*]] = insertelement <16 x float> [[R6]], float [[TMP9]], i32 7
; CHECK-NEXT:    [[TMP10:%.*]] = extractelement <16 x float> [[TMP1]], i32 8
; CHECK-NEXT:    [[R8:%.*]] = insertelement <16 x float> [[R7]], float [[TMP10]], i32 8
; CHECK-NEXT:    [[TMP11:%.*]] = extractelement <16 x float> [[TMP1]], i32 9
; CHECK-NEXT:    [[R9:%.*]] = insertelement <16 x float> [[R8]], float [[TMP11]], i32 9
; CHECK-NEXT:    [[TMP12:%.*]] = extractelement <16 x float> [[TMP1]], i32 10
; CHECK-NEXT:    [[R10:%.*]] = insertelement <16 x float> [[R9]], float [[TMP12]], i32 10
; CHECK-NEXT:    [[TMP13:%.*]] = extractelement <16 x float> [[TMP1]], i32 11
; CHECK-NEXT:    [[R11:%.*]] = insertelement <16 x float> [[R10]], float [[TMP13]], i32 11
; CHECK-NEXT:    [[TMP14:%.*]] = extractelement <16 x float> [[TMP1]], i32 12
; CHECK-NEXT:    [[R12:%.*]] = insertelement <16 x float> [[R11]], float [[TMP14]], i32 12
; CHECK-NEXT:    [[TMP15:%.*]] = extractelement <16 x float> [[TMP1]], i32 13
; CHECK-NEXT:    [[R13:%.*]] = insertelement <16 x float> [[R12]], float [[TMP15]], i32 13
; CHECK-NEXT:    [[TMP16:%.*]] = extractelement <16 x float> [[TMP1]], i32 14
; CHECK-NEXT:    [[R14:%.*]] = insertelement <16 x float> [[R13]], float [[TMP16]], i32 14
; CHECK-NEXT:    [[TMP17:%.*]] = extractelement <16 x float> [[TMP1]], i32 15
; CHECK-NEXT:    [[R15:%.*]] = insertelement <16 x float> [[R14]], float [[TMP17]], i32 15
; CHECK-NEXT:    ret <16 x float> [[R15]]
;
  %a0  = extractelement <16 x float> %a, i32 0
  %a1  = extractelement <16 x float> %a, i32 1
  %a2  = extractelement <16 x float> %a, i32 2
  %a3  = extractelement <16 x float> %a, i32 3
  %a4  = extractelement <16 x float> %a, i32 4
  %a5  = extractelement <16 x float> %a, i32 5
  %a6  = extractelement <16 x float> %a, i32 6
  %a7  = extractelement <16 x float> %a, i32 7
  %a8  = extractelement <16 x float> %a, i32 8
  %a9  = extractelement <16 x float> %a, i32 9
  %a10 = extractelement <16 x float> %a, i32 10
  %a11 = extractelement <16 x float> %a, i32 11
  %a12 = extractelement <16 x float> %a, i32 12
  %a13 = extractelement <16 x float> %a, i32 13
  %a14 = extractelement <16 x float> %a, i32 14
  %a15 = extractelement <16 x float> %a, i32 15
  %b0  = extractelement <16 x float> %b, i32 0
  %b1  = extractelement <16 x float> %b, i32 1
  %b2  = extractelement <16 x float> %b, i32 2
  %b3  = extractelement <16 x float> %b, i32 3
  %b4  = extractelement <16 x float> %b, i32 4
  %b5  = extractelement <16 x float> %b, i32 5
  %b6  = extractelement <16 x float> %b, i32 6
  %b7  = extractelement <16 x float> %b, i32 7
  %b8  = extractelement <16 x float> %b, i32 8
  %b9  = extractelement <16 x float> %b, i32 9
  %b10 = extractelement <16 x float> %b, i32 10
  %b11 = extractelement <16 x float> %b, i32 11
  %b12 = extractelement <16 x float> %b, i32 12
  %b13 = extractelement <16 x float> %b, i32 13
  %b14 = extractelement <16 x float> %b, i32 14
  %b15 = extractelement <16 x float> %b, i32 15
  %c0  = fmul float %a0 , %b0
  %c1  = fmul float %a1 , %b1
  %c2  = fmul float %a2 , %b2
  %c3  = fmul float %a3 , %b3
  %c4  = fmul float %a4 , %b4
  %c5  = fmul float %a5 , %b5
  %c6  = fmul float %a6 , %b6
  %c7  = fmul float %a7 , %b7
  %c8  = fmul float %a8 , %b8
  %c9  = fmul float %a9 , %b9
  %c10 = fmul float %a10, %b10
  %c11 = fmul float %a11, %b11
  %c12 = fmul float %a12, %b12
  %c13 = fmul float %a13, %b13
  %c14 = fmul float %a14, %b14
  %c15 = fmul float %a15, %b15
  %r0  = insertelement <16 x float> undef, float %c0 , i32 0
  %r1  = insertelement <16 x float> %r0 ,  float %c1 , i32 1
  %r2  = insertelement <16 x float> %r1 ,  float %c2 , i32 2
  %r3  = insertelement <16 x float> %r2 ,  float %c3 , i32 3
  %r4  = insertelement <16 x float> %r3 ,  float %c4 , i32 4
  %r5  = insertelement <16 x float> %r4 ,  float %c5 , i32 5
  %r6  = insertelement <16 x float> %r5 ,  float %c6 , i32 6
  %r7  = insertelement <16 x float> %r6 ,  float %c7 , i32 7
  %r8  = insertelement <16 x float> %r7 ,  float %c8 , i32 8
  %r9  = insertelement <16 x float> %r8 ,  float %c9 , i32 9
  %r10 = insertelement <16 x float> %r9 ,  float %c10, i32 10
  %r11 = insertelement <16 x float> %r10,  float %c11, i32 11
  %r12 = insertelement <16 x float> %r11,  float %c12, i32 12
  %r13 = insertelement <16 x float> %r12,  float %c13, i32 13
  %r14 = insertelement <16 x float> %r13,  float %c14, i32 14
  %r15 = insertelement <16 x float> %r14,  float %c15, i32 15
  ret <16 x float> %r15
}

define <16 x float> @buildvector_div_16f32(<16 x float> %a, <16 x float> %b) {
; CHECK-LABEL: @buildvector_div_16f32(
; CHECK-NEXT:    [[TMP1:%.*]] = fdiv <16 x float> %a, %b
; CHECK-NEXT:    [[TMP2:%.*]] = extractelement <16 x float> [[TMP1]], i32 0
; CHECK-NEXT:    [[R0:%.*]] = insertelement <16 x float> undef, float [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = extractelement <16 x float> [[TMP1]], i32 1
; CHECK-NEXT:    [[R1:%.*]] = insertelement <16 x float> [[R0]], float [[TMP3]], i32 1
; CHECK-NEXT:    [[TMP4:%.*]] = extractelement <16 x float> [[TMP1]], i32 2
; CHECK-NEXT:    [[R2:%.*]] = insertelement <16 x float> [[R1]], float [[TMP4]], i32 2
; CHECK-NEXT:    [[TMP5:%.*]] = extractelement <16 x float> [[TMP1]], i32 3
; CHECK-NEXT:    [[R3:%.*]] = insertelement <16 x float> [[R2]], float [[TMP5]], i32 3
; CHECK-NEXT:    [[TMP6:%.*]] = extractelement <16 x float> [[TMP1]], i32 4
; CHECK-NEXT:    [[R4:%.*]] = insertelement <16 x float> [[R3]], float [[TMP6]], i32 4
; CHECK-NEXT:    [[TMP7:%.*]] = extractelement <16 x float> [[TMP1]], i32 5
; CHECK-NEXT:    [[R5:%.*]] = insertelement <16 x float> [[R4]], float [[TMP7]], i32 5
; CHECK-NEXT:    [[TMP8:%.*]] = extractelement <16 x float> [[TMP1]], i32 6
; CHECK-NEXT:    [[R6:%.*]] = insertelement <16 x float> [[R5]], float [[TMP8]], i32 6
; CHECK-NEXT:    [[TMP9:%.*]] = extractelement <16 x float> [[TMP1]], i32 7
; CHECK-NEXT:    [[R7:%.*]] = insertelement <16 x float> [[R6]], float [[TMP9]], i32 7
; CHECK-NEXT:    [[TMP10:%.*]] = extractelement <16 x float> [[TMP1]], i32 8
; CHECK-NEXT:    [[R8:%.*]] = insertelement <16 x float> [[R7]], float [[TMP10]], i32 8
; CHECK-NEXT:    [[TMP11:%.*]] = extractelement <16 x float> [[TMP1]], i32 9
; CHECK-NEXT:    [[R9:%.*]] = insertelement <16 x float> [[R8]], float [[TMP11]], i32 9
; CHECK-NEXT:    [[TMP12:%.*]] = extractelement <16 x float> [[TMP1]], i32 10
; CHECK-NEXT:    [[R10:%.*]] = insertelement <16 x float> [[R9]], float [[TMP12]], i32 10
; CHECK-NEXT:    [[TMP13:%.*]] = extractelement <16 x float> [[TMP1]], i32 11
; CHECK-NEXT:    [[R11:%.*]] = insertelement <16 x float> [[R10]], float [[TMP13]], i32 11
; CHECK-NEXT:    [[TMP14:%.*]] = extractelement <16 x float> [[TMP1]], i32 12
; CHECK-NEXT:    [[R12:%.*]] = insertelement <16 x float> [[R11]], float [[TMP14]], i32 12
; CHECK-NEXT:    [[TMP15:%.*]] = extractelement <16 x float> [[TMP1]], i32 13
; CHECK-NEXT:    [[R13:%.*]] = insertelement <16 x float> [[R12]], float [[TMP15]], i32 13
; CHECK-NEXT:    [[TMP16:%.*]] = extractelement <16 x float> [[TMP1]], i32 14
; CHECK-NEXT:    [[R14:%.*]] = insertelement <16 x float> [[R13]], float [[TMP16]], i32 14
; CHECK-NEXT:    [[TMP17:%.*]] = extractelement <16 x float> [[TMP1]], i32 15
; CHECK-NEXT:    [[R15:%.*]] = insertelement <16 x float> [[R14]], float [[TMP17]], i32 15
; CHECK-NEXT:    ret <16 x float> [[R15]]
;
  %a0  = extractelement <16 x float> %a, i32 0
  %a1  = extractelement <16 x float> %a, i32 1
  %a2  = extractelement <16 x float> %a, i32 2
  %a3  = extractelement <16 x float> %a, i32 3
  %a4  = extractelement <16 x float> %a, i32 4
  %a5  = extractelement <16 x float> %a, i32 5
  %a6  = extractelement <16 x float> %a, i32 6
  %a7  = extractelement <16 x float> %a, i32 7
  %a8  = extractelement <16 x float> %a, i32 8
  %a9  = extractelement <16 x float> %a, i32 9
  %a10 = extractelement <16 x float> %a, i32 10
  %a11 = extractelement <16 x float> %a, i32 11
  %a12 = extractelement <16 x float> %a, i32 12
  %a13 = extractelement <16 x float> %a, i32 13
  %a14 = extractelement <16 x float> %a, i32 14
  %a15 = extractelement <16 x float> %a, i32 15
  %b0  = extractelement <16 x float> %b, i32 0
  %b1  = extractelement <16 x float> %b, i32 1
  %b2  = extractelement <16 x float> %b, i32 2
  %b3  = extractelement <16 x float> %b, i32 3
  %b4  = extractelement <16 x float> %b, i32 4
  %b5  = extractelement <16 x float> %b, i32 5
  %b6  = extractelement <16 x float> %b, i32 6
  %b7  = extractelement <16 x float> %b, i32 7
  %b8  = extractelement <16 x float> %b, i32 8
  %b9  = extractelement <16 x float> %b, i32 9
  %b10 = extractelement <16 x float> %b, i32 10
  %b11 = extractelement <16 x float> %b, i32 11
  %b12 = extractelement <16 x float> %b, i32 12
  %b13 = extractelement <16 x float> %b, i32 13
  %b14 = extractelement <16 x float> %b, i32 14
  %b15 = extractelement <16 x float> %b, i32 15
  %c0  = fdiv float %a0 , %b0
  %c1  = fdiv float %a1 , %b1
  %c2  = fdiv float %a2 , %b2
  %c3  = fdiv float %a3 , %b3
  %c4  = fdiv float %a4 , %b4
  %c5  = fdiv float %a5 , %b5
  %c6  = fdiv float %a6 , %b6
  %c7  = fdiv float %a7 , %b7
  %c8  = fdiv float %a8 , %b8
  %c9  = fdiv float %a9 , %b9
  %c10 = fdiv float %a10, %b10
  %c11 = fdiv float %a11, %b11
  %c12 = fdiv float %a12, %b12
  %c13 = fdiv float %a13, %b13
  %c14 = fdiv float %a14, %b14
  %c15 = fdiv float %a15, %b15
  %r0  = insertelement <16 x float> undef, float %c0 , i32 0
  %r1  = insertelement <16 x float> %r0 ,  float %c1 , i32 1
  %r2  = insertelement <16 x float> %r1 ,  float %c2 , i32 2
  %r3  = insertelement <16 x float> %r2 ,  float %c3 , i32 3
  %r4  = insertelement <16 x float> %r3 ,  float %c4 , i32 4
  %r5  = insertelement <16 x float> %r4 ,  float %c5 , i32 5
  %r6  = insertelement <16 x float> %r5 ,  float %c6 , i32 6
  %r7  = insertelement <16 x float> %r6 ,  float %c7 , i32 7
  %r8  = insertelement <16 x float> %r7 ,  float %c8 , i32 8
  %r9  = insertelement <16 x float> %r8 ,  float %c9 , i32 9
  %r10 = insertelement <16 x float> %r9 ,  float %c10, i32 10
  %r11 = insertelement <16 x float> %r10,  float %c11, i32 11
  %r12 = insertelement <16 x float> %r11,  float %c12, i32 12
  %r13 = insertelement <16 x float> %r12,  float %c13, i32 13
  %r14 = insertelement <16 x float> %r13,  float %c14, i32 14
  %r15 = insertelement <16 x float> %r14,  float %c15, i32 15
  ret <16 x float> %r15
}
