; RUN:  llvm-dis < %s.bc| FileCheck %s

; TerminatorOperations.3.2.ll.bc was generated by passing this file to llvm-as-3.2.
; The test checks that LLVM does not misread terminator instructions from
; older bitcode files.

define i32 @condbr(i1 %cond){
entry:
; CHECK: br i1 %cond, label %TrueLabel, label %FalseLabel
  br i1 %cond, label %TrueLabel, label %FalseLabel
  
  TrueLabel:
  ret i32 1
  
  FalseLabel:
  ret i32 0
}

define i32 @uncondbr(){
entry:
; CHECK: br label %uncondLabel
  br label %uncondLabel
  
  uncondLabel:
  ret i32 1
}

define i32 @indirectbr(i8* %Addr){
entry:
; CHECK: indirectbr i8* %Addr, [label %bb1, label %bb2]
  indirectbr i8* %Addr, [ label %bb1, label %bb2 ]
  
  bb1:
  ret i32 1
  
  bb2:
  ret i32 0
}

define void @unreachable(){
entry:
; CHECK: unreachable
  unreachable
  
  ret void
}

define i32 @retInstr(){
entry:
; CHECK: ret i32 1 
  ret i32 1 
}

define void @retInstr2(){
entry:
; CHECK: ret void 
  ret void
}

define i32 @switchInstr(i32 %x){
entry:
; CHECK: switch i32 %x, label %label3 [
  switch i32 %x, label %label3 [
; CHECK-NEXT: i32 1, label %label1   
  i32 1, label %label1
; CHECK-NEXT: i32 2, label %label2  
  i32 2, label %label2
  ]
label1:
  ret i32 1
label2:
  ret i32 2
label3:
  ret i32 0
}

