; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown -mattr=+sse4.2   | FileCheck %s --check-prefix=X32
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+sse4.2 | FileCheck %s --check-prefix=X64

define float @extractFloat1() nounwind {
; X32-LABEL: extractFloat1:
; X32:       # %bb.0: # %entry
; X32-NEXT:    fld1
; X32-NEXT:    retl
;
; X64-LABEL: extractFloat1:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X64-NEXT:    retq
entry:
  %tmp0 = bitcast <1 x double> <double 0x000000003F800000> to <2 x float>
  %tmp1 = extractelement <2 x float> %tmp0, i32 0
  ret float %tmp1
}

define float @extractFloat2() nounwind {
; X32-LABEL: extractFloat2:
; X32:       # %bb.0: # %entry
; X32-NEXT:    fldz
; X32-NEXT:    retl
;
; X64-LABEL: extractFloat2:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorps %xmm0, %xmm0
; X64-NEXT:    retq
entry:
  %tmp4 = bitcast <1 x double> <double 0x000000003F800000> to <2 x float>
  %tmp5 = extractelement <2 x float> %tmp4, i32 1
  ret float %tmp5
}

define i32 @extractInt2() nounwind {
; X32-LABEL: extractInt2:
; X32:       # %bb.0: # %entry
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    retl
;
; X64-LABEL: extractInt2:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    retq
entry:
  %tmp4 = bitcast <1 x i64> <i64 256> to <2 x i32>
  %tmp5 = extractelement <2 x i32> %tmp4, i32 1
  ret i32 %tmp5
}

