/* Generated by GOB (v2.0.18)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 3 "loqui-receiver-ipmsg.gob"

/*
 * libloqui -- Chat/IM client library for GLib <http://launchpad.net/loqui/>
 * Copyright (C) 2004 Yoichi Imai <sunnyone41@gmail.com>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with the Gnome Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#line 29 "loqui-receiver-ipmsg.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 18

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "loqui-receiver-ipmsg.h"

#include "loqui-receiver-ipmsg-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 31 "loqui-receiver-ipmsg.gob"

#include <libloqui-intl.h>
#include "loqui-utils.h"

#include "loqui_user_ipmsg.h"
#include "ipmsg.h"
#include "loqui-account-ipmsg.h"
#include "loqui-sender-ipmsg.h"
#include "loqui-message-text.h"

#line 61 "loqui-receiver-ipmsg.c"

#line 42 "loqui-receiver-ipmsg.gob"

/* account: Loqui:Account */
#define SELF_GET_ACCOUNT(receiver) (LOQUI_RECEIVER(receiver)->account)
#define SELF_GET_SENDER_IPMSG(receiver) (LOQUI_SENDER_IPMSG(SELF_GET_ACCOUNT(receiver)->sender))

#line 69 "loqui-receiver-ipmsg.c"
/* self casting macros */
#define SELF(x) LOQUI_RECEIVER_IPMSG(x)
#define SELF_CONST(x) LOQUI_RECEIVER_IPMSG_CONST(x)
#define IS_SELF(x) LOQUI_IS_RECEIVER_IPMSG(x)
#define TYPE_SELF LOQUI_TYPE_RECEIVER_IPMSG
#define SELF_CLASS(x) LOQUI_RECEIVER_IPMSG_CLASS(x)

#define SELF_GET_CLASS(x) LOQUI_RECEIVER_IPMSG_GET_CLASS(x)

/* self typedefs */
typedef LoquiReceiverIPMsg Self;
typedef LoquiReceiverIPMsgClass SelfClass;

/* here are local prototypes */
#line 0 "loqui-receiver-ipmsg.gob"
static void loqui_receiver_ipmsg_init (LoquiReceiverIPMsg * o) G_GNUC_UNUSED;
#line 86 "loqui-receiver-ipmsg.c"
#line 0 "loqui-receiver-ipmsg.gob"
static void loqui_receiver_ipmsg_class_init (LoquiReceiverIPMsgClass * c) G_GNUC_UNUSED;
#line 89 "loqui-receiver-ipmsg.c"
#line 50 "loqui-receiver-ipmsg.gob"
static gboolean loqui_receiver_ipmsg_validate_and_warn_packet (LoquiReceiverIPMsg * self, IPMsgPacket * packet) G_GNUC_UNUSED;
#line 92 "loqui-receiver-ipmsg.c"
#line 76 "loqui-receiver-ipmsg.gob"
static void loqui_receiver_ipmsg_helper_update_user (LoquiReceiverIPMsg * self, LoquiUser * user, gboolean print_changes, const gchar * nick, gboolean is_away, const gchar * username, const gchar * hostname, const gchar * group_name) G_GNUC_UNUSED;
#line 95 "loqui-receiver-ipmsg.c"
#line 142 "loqui-receiver-ipmsg.gob"
static gboolean loqui_receiver_ipmsg_helper_br_command (LoquiReceiverIPMsg * self, IPMsgPacket * packet, gboolean print_changes) G_GNUC_UNUSED;
#line 98 "loqui-receiver-ipmsg.c"
#line 177 "loqui-receiver-ipmsg.gob"
static void loqui_receiver_ipmsg_command_br_entry (LoquiReceiverIPMsg * self, IPMsgPacket * packet) G_GNUC_UNUSED;
#line 101 "loqui-receiver-ipmsg.c"
#line 192 "loqui-receiver-ipmsg.gob"
static void loqui_receiver_ipmsg_command_ansentry (LoquiReceiverIPMsg * self, IPMsgPacket * packet) G_GNUC_UNUSED;
#line 104 "loqui-receiver-ipmsg.c"
#line 205 "loqui-receiver-ipmsg.gob"
static void loqui_receiver_ipmsg_command_br_absence (LoquiReceiverIPMsg * self, IPMsgPacket * packet) G_GNUC_UNUSED;
#line 107 "loqui-receiver-ipmsg.c"
#line 219 "loqui-receiver-ipmsg.gob"
static void loqui_receiver_ipmsg_command_br_exit (LoquiReceiverIPMsg * self, IPMsgPacket * packet) G_GNUC_UNUSED;
#line 110 "loqui-receiver-ipmsg.c"
#line 258 "loqui-receiver-ipmsg.gob"
static void loqui_receiver_ipmsg_command_sendmsg (LoquiReceiverIPMsg * self, IPMsgPacket * packet) G_GNUC_UNUSED;
#line 113 "loqui-receiver-ipmsg.c"
#line 314 "loqui-receiver-ipmsg.gob"
static void loqui_receiver_ipmsg_command_recvmsg (LoquiReceiverIPMsg * self, IPMsgPacket * packet) G_GNUC_UNUSED;
#line 116 "loqui-receiver-ipmsg.c"
#line 340 "loqui-receiver-ipmsg.gob"
static void loqui_receiver_ipmsg_command_getinfo (LoquiReceiverIPMsg * self, IPMsgPacket * packet) G_GNUC_UNUSED;
#line 119 "loqui-receiver-ipmsg.c"

/* pointer to the class of our parent */
static LoquiReceiverClass *parent_class = NULL;

/* Short form macros */
#define self_validate_and_warn_packet loqui_receiver_ipmsg_validate_and_warn_packet
#define self_helper_update_user loqui_receiver_ipmsg_helper_update_user
#define self_helper_br_command loqui_receiver_ipmsg_helper_br_command
#define self_command_br_entry loqui_receiver_ipmsg_command_br_entry
#define self_command_ansentry loqui_receiver_ipmsg_command_ansentry
#define self_command_br_absence loqui_receiver_ipmsg_command_br_absence
#define self_command_br_exit loqui_receiver_ipmsg_command_br_exit
#define self_command_sendmsg loqui_receiver_ipmsg_command_sendmsg
#define self_command_recvmsg loqui_receiver_ipmsg_command_recvmsg
#define self_command_getinfo loqui_receiver_ipmsg_command_getinfo
#define self_handle loqui_receiver_ipmsg_handle
#define self_new loqui_receiver_ipmsg_new
GType
loqui_receiver_ipmsg_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LoquiReceiverIPMsgClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) loqui_receiver_ipmsg_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LoquiReceiverIPMsg),
			0 /* n_preallocs */,
			(GInstanceInitFunc) loqui_receiver_ipmsg_init,
			NULL
		};

		type = g_type_register_static (LOQUI_TYPE_RECEIVER, "LoquiReceiverIPMsg", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LoquiReceiverIPMsg *)g_object_new(loqui_receiver_ipmsg_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LoquiReceiverIPMsg * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LoquiReceiverIPMsg *
GET_NEW_VARG (const char *first, ...)
{
	LoquiReceiverIPMsg *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LoquiReceiverIPMsg *)g_object_new_valist (loqui_receiver_ipmsg_get_type (), first, ap);
	va_end (ap);
	return ret;
}

static void 
loqui_receiver_ipmsg_init (LoquiReceiverIPMsg * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Loqui:Receiver:IPMsg::init"
}
#undef __GOB_FUNCTION__
static void 
loqui_receiver_ipmsg_class_init (LoquiReceiverIPMsgClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Loqui:Receiver:IPMsg::class_init"

	parent_class = g_type_class_ref (LOQUI_TYPE_RECEIVER);

}
#undef __GOB_FUNCTION__



#line 50 "loqui-receiver-ipmsg.gob"
static gboolean 
loqui_receiver_ipmsg_validate_and_warn_packet (LoquiReceiverIPMsg * self, IPMsgPacket * packet)
{
#line 201 "loqui-receiver-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Receiver:IPMsg::validate_and_warn_packet"
#line 50 "loqui-receiver-ipmsg.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 50 "loqui-receiver-ipmsg.gob"
	g_return_val_if_fail (LOQUI_IS_RECEIVER_IPMSG (self), (gboolean )0);
#line 207 "loqui-receiver-ipmsg.c"
{
#line 50 "loqui-receiver-ipmsg.gob"
	
		gchar *identifier;
		LoquiAccount *account;

		account = LOQUI_RECEIVER(self)->account;

		identifier = ipmsg_packet_get_identifier(packet);
		if (!identifier) {
			loqui_account_warning(account, _("Invalid IP address or port"));
			return FALSE;
		}
		if (!packet->username) {
			loqui_account_warning(account, _("Username is not set"));
			g_free(identifier);
			return FALSE;
		}
		if (!packet->hostname) {
			loqui_account_warning(account, _("Hostname is not set"));
			g_free(identifier);
			return FALSE;
		}

		g_free(identifier);
		return TRUE;
	}}
#line 235 "loqui-receiver-ipmsg.c"
#undef __GOB_FUNCTION__

#line 76 "loqui-receiver-ipmsg.gob"
static void 
loqui_receiver_ipmsg_helper_update_user (LoquiReceiverIPMsg * self, LoquiUser * user, gboolean print_changes, const gchar * nick, gboolean is_away, const gchar * username, const gchar * hostname, const gchar * group_name)
{
#line 242 "loqui-receiver-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Receiver:IPMsg::helper_update_user"
#line 76 "loqui-receiver-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 76 "loqui-receiver-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_RECEIVER_IPMSG (self));
#line 248 "loqui-receiver-ipmsg.c"
{
#line 78 "loqui-receiver-ipmsg.gob"
	
		LoquiAccount *account = SELF_GET_ACCOUNT(self);
		const gchar *tmp;
		gboolean old_is_away;

#define STR_DIFFERENT(ptr1, ptr2) (ptr1 != ptr2 && (ptr1 == NULL || ptr2 == NULL || strcmp(ptr1, ptr2) != 0))

		tmp = loqui_user_get_nick(user);
		if (STR_DIFFERENT(tmp, nick)) {
			if (print_changes)
				loqui_account_append_text_printf(account, NULL, LOQUI_TEXT_TYPE_INFO,
								 "*** %s is known as %s",
								 LOQUI_UTILS_EMPTY_IF_NULL(tmp),
								 LOQUI_UTILS_EMPTY_IF_NULL(nick));
			loqui_user_set_nick(user, nick);
		}

		old_is_away = (loqui_user_get_away(user) != LOQUI_AWAY_TYPE_ONLINE) ? TRUE : FALSE;
		if (old_is_away != is_away) {
			if (print_changes) {
				loqui_account_append_text_printf(account, NULL, LOQUI_TEXT_TYPE_INFO,
								 is_away ?
								  "*** %s has been marked as being away" : 
								  "*** %s is no longer marked as being away",
								 LOQUI_UTILS_EMPTY_IF_NULL(nick));
			}
			loqui_user_set_away(user, is_away ? LOQUI_AWAY_TYPE_AWAY : LOQUI_AWAY_TYPE_ONLINE);
		}
		    
		tmp = loqui_user_get_username(user);
		if (STR_DIFFERENT(tmp, username)) {
			if (print_changes)
				loqui_account_append_text_printf(account, NULL, LOQUI_TEXT_TYPE_INFO,
								 "*** %s's username has changed from %s to %s",
								 LOQUI_UTILS_EMPTY_IF_NULL(nick),
								 LOQUI_UTILS_EMPTY_IF_NULL(tmp),
								 LOQUI_UTILS_EMPTY_IF_NULL(username));
			loqui_user_set_username(user, username);
		}
		
		tmp = loqui_user_get_hostname(user);
		if (STR_DIFFERENT(tmp, hostname)) {
			if (print_changes)
				loqui_account_append_text_printf(account, NULL, LOQUI_TEXT_TYPE_INFO,
								 "*** %s's hostname has changed from %s to %s",
								 LOQUI_UTILS_EMPTY_IF_NULL(nick),
								 LOQUI_UTILS_EMPTY_IF_NULL(tmp),
								 LOQUI_UTILS_EMPTY_IF_NULL(hostname));
			loqui_user_set_hostname(user, hostname);
		}

		
		tmp = loqui_user_ipmsg_get_group_name(LOQUI_USER_IPMSG(user));
		if (STR_DIFFERENT(tmp, group_name)) {
			if (print_changes)
				loqui_account_append_text_printf(account, NULL, LOQUI_TEXT_TYPE_INFO,
								 "*** %s's group name has changed from %s to %s",
								 LOQUI_UTILS_EMPTY_IF_NULL(nick),
								 LOQUI_UTILS_EMPTY_IF_NULL(tmp),
								 LOQUI_UTILS_EMPTY_IF_NULL(group_name));
			loqui_user_ipmsg_set_group_name(LOQUI_USER_IPMSG(user), group_name);
		}
	}}
#line 314 "loqui-receiver-ipmsg.c"
#undef __GOB_FUNCTION__

#line 142 "loqui-receiver-ipmsg.gob"
static gboolean 
loqui_receiver_ipmsg_helper_br_command (LoquiReceiverIPMsg * self, IPMsgPacket * packet, gboolean print_changes)
{
#line 321 "loqui-receiver-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Receiver:IPMsg::helper_br_command"
#line 142 "loqui-receiver-ipmsg.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 142 "loqui-receiver-ipmsg.gob"
	g_return_val_if_fail (LOQUI_IS_RECEIVER_IPMSG (self), (gboolean )0);
#line 327 "loqui-receiver-ipmsg.c"
{
#line 142 "loqui-receiver-ipmsg.gob"
	
		LoquiAccount *account;
		LoquiUser *user;
		LoquiMember *member;
		gchar *ip_addr;
		gint port;
		gboolean is_add;

		account = SELF_GET_ACCOUNT(self);

		ip_addr = ipmsg_packet_get_ip_addr(packet);
		port = ipmsg_packet_get_port(packet);
		user = LOQUI_USER(loqui_account_ipmsg_fetch_user_by_pair(LOQUI_ACCOUNT_IPMSG(account), ip_addr, port));

		member = loqui_channel_entry_get_member_by_user(LOQUI_CHANNEL_ENTRY(account), user);
		is_add = (member == NULL) ? TRUE : FALSE;

		self_helper_update_user(self, user,
					print_changes && !is_add,
					packet->extra,
					packet->command_num & IPMSG_ABSENCEOPT ? TRUE : FALSE,
					packet->username, packet->hostname, packet->group_name);

		if (is_add) {
			member = loqui_member_new(user);
			loqui_channel_entry_add_member(LOQUI_CHANNEL_ENTRY(account), member);
			g_object_unref(member);
		}

		/* account has reference count */
		g_object_unref(user);

		return is_add;
	}}
#line 364 "loqui-receiver-ipmsg.c"
#undef __GOB_FUNCTION__

#line 177 "loqui-receiver-ipmsg.gob"
static void 
loqui_receiver_ipmsg_command_br_entry (LoquiReceiverIPMsg * self, IPMsgPacket * packet)
{
#line 371 "loqui-receiver-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Receiver:IPMsg::command_br_entry"
#line 177 "loqui-receiver-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 177 "loqui-receiver-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_RECEIVER_IPMSG (self));
#line 377 "loqui-receiver-ipmsg.c"
{
#line 177 "loqui-receiver-ipmsg.gob"
	
		if (!self_validate_and_warn_packet(self, packet))
			return;
		
		if (self_helper_br_command(self, packet, FALSE))
			loqui_account_append_text_printf(SELF_GET_ACCOUNT(self), NULL, LOQUI_TEXT_TYPE_INFO,
							 "*** %s (%s) (%s@%s) has appeared",
							 packet->extra,
							 LOQUI_UTILS_EMPTY_IF_NULL(packet->group_name),
							 packet->username,
							 packet->hostname);

		loqui_sender_ipmsg_ansentry(SELF_GET_SENDER_IPMSG(self));
	}}
#line 394 "loqui-receiver-ipmsg.c"
#undef __GOB_FUNCTION__

#line 192 "loqui-receiver-ipmsg.gob"
static void 
loqui_receiver_ipmsg_command_ansentry (LoquiReceiverIPMsg * self, IPMsgPacket * packet)
{
#line 401 "loqui-receiver-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Receiver:IPMsg::command_ansentry"
#line 192 "loqui-receiver-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 192 "loqui-receiver-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_RECEIVER_IPMSG (self));
#line 407 "loqui-receiver-ipmsg.c"
{
#line 192 "loqui-receiver-ipmsg.gob"
	
		if (!self_validate_and_warn_packet(self, packet))
			return;

		if (self_helper_br_command(self, packet, FALSE))
			loqui_account_append_text_printf(SELF_GET_ACCOUNT(self), NULL, LOQUI_TEXT_TYPE_INFO,
							 "*** %s (%s) (%s@%s) is here",
							 packet->extra,
							 LOQUI_UTILS_EMPTY_IF_NULL(packet->group_name),
							 packet->username,
							 packet->hostname);
	}}
#line 422 "loqui-receiver-ipmsg.c"
#undef __GOB_FUNCTION__

#line 205 "loqui-receiver-ipmsg.gob"
static void 
loqui_receiver_ipmsg_command_br_absence (LoquiReceiverIPMsg * self, IPMsgPacket * packet)
{
#line 429 "loqui-receiver-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Receiver:IPMsg::command_br_absence"
#line 205 "loqui-receiver-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 205 "loqui-receiver-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_RECEIVER_IPMSG (self));
#line 435 "loqui-receiver-ipmsg.c"
{
#line 205 "loqui-receiver-ipmsg.gob"
	
		if (!self_validate_and_warn_packet(self, packet))
			return;

		if (self_helper_br_command(self, packet, TRUE))
			loqui_account_append_text_printf(SELF_GET_ACCOUNT(self), NULL, LOQUI_TEXT_TYPE_INFO,
							 "*** %s (%s) (%s@%s) has already be here",
							 packet->extra,
							 LOQUI_UTILS_EMPTY_IF_NULL(packet->group_name),
							 packet->username,
							 packet->hostname);
		
	}}
#line 451 "loqui-receiver-ipmsg.c"
#undef __GOB_FUNCTION__

#line 219 "loqui-receiver-ipmsg.gob"
static void 
loqui_receiver_ipmsg_command_br_exit (LoquiReceiverIPMsg * self, IPMsgPacket * packet)
{
#line 458 "loqui-receiver-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Receiver:IPMsg::command_br_exit"
#line 219 "loqui-receiver-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 219 "loqui-receiver-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_RECEIVER_IPMSG (self));
#line 464 "loqui-receiver-ipmsg.c"
{
#line 219 "loqui-receiver-ipmsg.gob"
	
		LoquiAccount *account;
		LoquiUser *user;
		gchar *identifier;
		GList *list, *cur;
		gchar *tmp;

		account = SELF_GET_ACCOUNT(self);

		if (!self_validate_and_warn_packet(self, packet))
			return;

		identifier = ipmsg_packet_get_identifier(packet);

		if ((user = loqui_account_peek_user(account, identifier)) == NULL) {
			/* two BR_EXIT packet come from original IPMsg, so just ignore the packet */
			/* loqui_account_warning(account, _("The user '%s' exit, but he/she is not registered."), identifier); */
			g_free(identifier);
			return;
		}
		g_free(identifier);

		tmp = g_strdup_printf("*** %s (%s) (%s@%s) has quit",
				      loqui_user_get_nick(user),
				      LOQUI_UTILS_EMPTY_IF_NULL(loqui_user_ipmsg_get_group_name(LOQUI_USER_IPMSG(user))),
				      loqui_user_get_username(user),
				      loqui_user_get_hostname(user));

		loqui_account_remove_user_from_all(account, user, TRUE, &list);
		for (cur = list; cur != NULL; cur = cur->next) {
			if (LOQUI_IS_ACCOUNT(cur->data)) {
				loqui_account_append_text(cur->data, NULL, LOQUI_TEXT_TYPE_INFO, tmp);
			} else {
				loqui_channel_append_text(cur->data, LOQUI_TEXT_TYPE_INFO, tmp);
			}
		}
		g_free(tmp);
	}}
#line 505 "loqui-receiver-ipmsg.c"
#undef __GOB_FUNCTION__

#line 258 "loqui-receiver-ipmsg.gob"
static void 
loqui_receiver_ipmsg_command_sendmsg (LoquiReceiverIPMsg * self, IPMsgPacket * packet)
{
#line 512 "loqui-receiver-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Receiver:IPMsg::command_sendmsg"
#line 258 "loqui-receiver-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 258 "loqui-receiver-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_RECEIVER_IPMSG (self));
#line 518 "loqui-receiver-ipmsg.c"
{
#line 258 "loqui-receiver-ipmsg.gob"
	
		LoquiAccount *account;
		LoquiChannel *channel;
		LoquiMember *member;
		LoquiUser *user, *user_self;
		gchar *identifier;
		LoquiTextType text_type;

		if (!self_validate_and_warn_packet(self, packet))
			return;

		/* TODO: check broadcast flag and show the message to account buffer */

		account = SELF_GET_ACCOUNT(self);
		user_self = loqui_account_get_user_self(account);

		identifier = ipmsg_packet_get_identifier(packet);
		user = loqui_account_peek_user(account, identifier);
		channel = loqui_account_get_channel_by_identifier(account, identifier);

		if (channel == NULL && user != NULL) {
			/* FIXME: conflict with group name? */
			channel = loqui_account_open_private_talk(account, identifier, user);
		}

		text_type = packet->command_num & IPMSG_AUTORETOPT ? LOQUI_TEXT_TYPE_NOTICE : LOQUI_TEXT_TYPE_NORMAL;

		if (channel && user) {
			loqui_channel_append_remark(channel,
						    text_type,
						    user == user_self ? TRUE : FALSE,
						    loqui_user_get_nick(user),
						    packet->extra);
			
			if ((member = loqui_channel_entry_get_member_by_user(LOQUI_CHANNEL_ENTRY(channel), user)) != NULL) {
				loqui_member_set_last_message_time(member, time(NULL));
			}

		} else {
			gchar *str = ipmsg_packet_inspect(packet);
			loqui_account_warning(account, "An unrecognized user sent an message: %s", str);
			g_free(str);
			/* FIXME: the message by not registered user */
		}

		if (packet->command_num & IPMSG_SENDCHECKOPT &&
		    !(packet->command_num & IPMSG_BROADCASTOPT) &&
		    !(packet->command_num & IPMSG_AUTORETOPT)) {
			loqui_sender_ipmsg_send_recvmsg(SELF_GET_SENDER_IPMSG(self),
							packet->packet_num,
							packet->inetaddr);
		}

		g_free(identifier);
	}}
#line 576 "loqui-receiver-ipmsg.c"
#undef __GOB_FUNCTION__

#line 314 "loqui-receiver-ipmsg.gob"
static void 
loqui_receiver_ipmsg_command_recvmsg (LoquiReceiverIPMsg * self, IPMsgPacket * packet)
{
#line 583 "loqui-receiver-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Receiver:IPMsg::command_recvmsg"
#line 314 "loqui-receiver-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 314 "loqui-receiver-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_RECEIVER_IPMSG (self));
#line 589 "loqui-receiver-ipmsg.c"
{
#line 314 "loqui-receiver-ipmsg.gob"
	
		GList *cur;
		LoquiSenderIPMsg *sender;
		IPMsgPacket *sendmsg_packet;

		gint orig_command_num;

		orig_command_num = (gint) g_ascii_strtoull(packet->extra, NULL, 10);
		if (orig_command_num == 0) {
			loqui_account_warning(SELF_GET_ACCOUNT(self), "Invalid RECVMSG message.");
			return;
		}

		sender = SELF_GET_SENDER_IPMSG(self);
		for (cur = sender->retring_sendmsg_list; cur != NULL; cur = cur->next) {
			sendmsg_packet = cur->data;
			if (sendmsg_packet->packet_num == orig_command_num) {
				/* TODO: show an message to indicate to succeed to send */
				loqui_debug_puts("Sent successfully: %d", sendmsg_packet->packet_num);

				sender->retring_sendmsg_list = g_list_delete_link(sender->retring_sendmsg_list, cur);
				break;
			}
		}
	}}
#line 617 "loqui-receiver-ipmsg.c"
#undef __GOB_FUNCTION__

#line 340 "loqui-receiver-ipmsg.gob"
static void 
loqui_receiver_ipmsg_command_getinfo (LoquiReceiverIPMsg * self, IPMsgPacket * packet)
{
#line 624 "loqui-receiver-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Receiver:IPMsg::command_getinfo"
#line 340 "loqui-receiver-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 340 "loqui-receiver-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_RECEIVER_IPMSG (self));
#line 630 "loqui-receiver-ipmsg.c"
{
#line 340 "loqui-receiver-ipmsg.gob"
	
		LoquiSenderIPMsg *sender;
		gchar *identifier;
		LoquiUser *user;

		identifier = ipmsg_packet_get_identifier(packet);

		user = loqui_account_peek_user(SELF_GET_ACCOUNT(self), identifier);
		g_free(identifier);

		loqui_account_append_text_printf(SELF_GET_ACCOUNT(self), NULL, LOQUI_TEXT_TYPE_INFO,
						 "*** %s (%s@%s) requested version information",
						 user ? loqui_user_get_nick(user) : "?",
						 packet->username,
						 packet->hostname);
		sender = SELF_GET_SENDER_IPMSG(self);
		loqui_sender_ipmsg_sendinfo(sender, packet->inetaddr);
	}}
#line 651 "loqui-receiver-ipmsg.c"
#undef __GOB_FUNCTION__

#line 359 "loqui-receiver-ipmsg.gob"
void 
loqui_receiver_ipmsg_handle (LoquiReceiverIPMsg * self, IPMsgPacket * packet)
{
#line 658 "loqui-receiver-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Receiver:IPMsg::handle"
#line 359 "loqui-receiver-ipmsg.gob"
	g_return_if_fail (self != NULL);
#line 359 "loqui-receiver-ipmsg.gob"
	g_return_if_fail (LOQUI_IS_RECEIVER_IPMSG (self));
#line 359 "loqui-receiver-ipmsg.gob"
	g_return_if_fail (packet != NULL);
#line 359 "loqui-receiver-ipmsg.gob"
	g_return_if_fail (IS_IPMSG_PACKET (packet));
#line 668 "loqui-receiver-ipmsg.c"
{
#line 359 "loqui-receiver-ipmsg.gob"
	
		gchar *str;

		if (packet->version != 1) {
			loqui_account_warning(SELF_GET_ACCOUNT(self),
					      _("Only supports IPMessenger Protocol Version 1 (the message is version '%d')"), packet->version);
			return;
		}

		switch (IPMSG_GET_MODE(packet->command_num)) {
		case IPMSG_NOOPERATION:
			return;
		case IPMSG_BR_ENTRY:
			self_command_br_entry(self, packet);
			return;
		case IPMSG_BR_EXIT:
			self_command_br_exit(self, packet);
			return;
		case IPMSG_ANSENTRY:
			self_command_ansentry(self, packet);
			return;
		case IPMSG_BR_ABSENCE:
			self_command_br_absence(self, packet);
			return;
		case IPMSG_SENDMSG:
			self_command_sendmsg(self, packet);
			return;
		case IPMSG_RECVMSG:
			self_command_recvmsg(self, packet);
			return;
		case IPMSG_GETINFO:
			self_command_getinfo(self, packet);
			return;
		default:
			break;
		}

		str = ipmsg_packet_inspect(packet);
		loqui_account_append_text(SELF_GET_ACCOUNT(self), NULL, LOQUI_TEXT_TYPE_NORMAL, str);
		g_free(str);
	}}
#line 712 "loqui-receiver-ipmsg.c"
#undef __GOB_FUNCTION__

#line 401 "loqui-receiver-ipmsg.gob"
LoquiReceiverIPMsg * 
loqui_receiver_ipmsg_new (LoquiAccount * account)
{
#line 719 "loqui-receiver-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Receiver:IPMsg::new"
{
#line 402 "loqui-receiver-ipmsg.gob"
	
		Self *self;

		self = GET_NEW;
		LOQUI_RECEIVER(self)->account = account;
		
		return self;
	}}
#line 731 "loqui-receiver-ipmsg.c"
#undef __GOB_FUNCTION__
