/*
 * Copyright (C) 2023 Linux Studio Plugins Project <https://lsp-plug.in/>
 *           (C) 2023 Vladimir Sadovnikov <sadko4u@gmail.com>
 *
 * This file is part of lsp-plugin-fw
 * Created on: 10 апр. 2021 г.
 *
 * lsp-plugin-fw is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * lsp-plugin-fw is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with lsp-plugin-fw. If not, see <https://www.gnu.org/licenses/>.
 */

#include <private/ui/xml/NodeFactory.h>

namespace lsp
{
    namespace ui
    {
        namespace xml
        {
            NodeFactory *NodeFactory::pRoot      = NULL;

            NodeFactory::NodeFactory()
            {
                pNext   = pRoot;
                pRoot   = this;
            }

            NodeFactory::~NodeFactory()
            {
                pRoot   = NULL;
            }

            status_t NodeFactory::create(Node **child, UIContext *context, Node *parent, const LSPString *name)
            {
                return STATUS_NOT_FOUND;
            }

        } /* namespac xml */
    } /* namespace ui */
} /* namespace lsp */


