/*
 * Copyright (C) 2020 Linux Studio Plugins Project <https://lsp-plug.in/>
 *           (C) 2020 Vladimir Sadovnikov <sadko4u@gmail.com>
 *
 * This file is part of lsp-plugins
 * Created on: 08 апр. 2016 г.
 *
 * lsp-plugins is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * lsp-plugins is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with lsp-plugins. If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef GENERATED_ISO226_FLETCHER_MUNSON_H_
#define GENERATED_ISO226_FLETCHER_MUNSON_H_

#include <generated/iso226/defs.h>

namespace lsp
{
    static const float fletcher_munson_curve_0_phons[1383] =
    {
        -23.83, -23.87, -23.89, -23.96, -24.03,
        -24.13, -24.17, -24.26, -24.29, -24.40, -24.46, -24.54, -24.60, -24.67, -24.72,
        -24.83, -24.88, -24.92, -24.97, -25.01, -25.11, -25.15, -25.21, -25.31, -25.37,
        -25.42, -25.47, -25.52, -25.56, -25.67, -25.79, -25.90, -25.99, -26.09, -26.19,
        -26.21, -26.30, -26.36, -26.44, -26.51, -26.59, -26.65, -26.73, -26.84, -26.83,
        -26.88, -27.06, -27.09, -27.15, -27.17, -27.26, -27.35, -27.39, -27.46, -27.51,
        -27.56, -27.63, -27.68, -27.76, -27.86, -27.88, -27.98, -27.98, -28.04, -28.08,
        -28.13, -28.19, -28.25, -28.36, -28.38, -28.48, -28.54, -28.59, -28.69, -28.75,
        -28.82, -28.94, -28.96, -29.06, -29.18, -29.17, -29.26, -29.35, -29.45, -29.55,
        -29.54, -29.64, -29.73, -29.80, -29.85, -29.89, -29.94, -29.98, -30.04, -30.07,
        -30.17, -30.18, -30.28, -30.33, -30.38, -30.44, -30.49, -30.56, -30.65, -30.73,
        -30.76, -30.88, -30.96, -31.00, -31.10, -31.14, -31.21, -31.31, -31.33, -31.42,
        -31.52, -31.54, -31.60, -31.68, -31.78, -31.77, -31.85, -31.97, -31.99, -32.14,
        -32.27, -32.32, -32.40, -32.54, -32.67, -32.71, -32.81, -32.86, -32.91, -32.97,
        -33.03, -33.09, -33.14, -33.19, -33.25, -33.33, -33.36, -33.46, -33.51, -33.55,
        -33.62, -33.69, -33.76, -33.86, -33.97, -34.10, -34.17, -34.24, -34.35, -34.43,
        -34.52, -34.61, -34.66, -34.77, -34.79, -34.90, -35.01, -35.11, -35.19, -35.29,
        -35.33, -35.37, -35.42, -35.52, -35.59, -35.66, -35.74, -35.80, -35.90, -36.01,
        -36.09, -36.17, -36.21, -36.30, -36.39, -36.46, -36.56, -36.65, -36.63, -36.69,
        -36.77, -36.86, -36.88, -36.98, -37.10, -37.20, -37.27, -37.34, -37.47, -37.61,
        -37.65, -37.78, -37.90, -38.03, -38.15, -38.26, -38.38, -38.51, -38.61, -38.71,
        -38.80, -38.86, -38.90, -38.99, -39.07, -39.09, -39.16, -39.25, -39.31, -39.30,
        -39.37, -39.46, -39.56, -39.56, -39.69, -39.82, -39.92, -39.95, -40.01, -40.07,
        -40.13, -40.22, -40.31, -40.43, -40.50, -40.61, -40.67, -40.78, -40.88, -40.96,
        -41.08, -41.19, -41.25, -41.35, -41.48, -41.58, -41.74, -41.84, -41.95, -42.06,
        -42.17, -42.28, -42.39, -42.50, -42.61, -42.71, -42.82, -42.92, -43.04, -43.17,
        -43.26, -43.37, -43.47, -43.48, -43.56, -43.66, -43.67, -43.76, -43.87, -43.98,
        -44.09, -44.19, -44.31, -44.43, -44.54, -44.65, -44.77, -44.89, -45.00, -45.10,
        -45.14, -45.20, -45.32, -45.42, -45.42, -45.52, -45.63, -45.75, -45.87, -45.97,
        -46.06, -46.20, -46.30, -46.39, -46.46, -46.53, -46.60, -46.69, -46.81, -46.91,
        -47.02, -47.12, -47.17, -47.28, -47.37, -47.47, -47.56, -47.61, -47.67, -47.76,
        -47.76, -47.80, -47.87, -47.93, -48.04, -48.15, -48.26, -48.36, -48.42, -48.54,
        -48.63, -48.63, -48.70, -48.75, -48.73, -48.83, -48.91, -48.87, -48.94, -49.04,
        -49.13, -49.16, -49.28, -49.42, -49.53, -49.67, -49.80, -49.86, -49.93, -50.00,
        -50.12, -50.18, -50.23, -50.38, -50.44, -50.50, -50.61, -50.68, -50.76, -50.89,
        -50.95, -50.99, -51.03, -51.12, -51.17, -51.22, -51.30, -51.42, -51.50, -51.58,
        -51.63, -51.74, -51.83, -51.94, -52.03, -52.13, -52.18, -52.28, -52.38, -52.50,
        -52.63, -52.73, -52.83, -52.93, -53.04, -53.15, -53.27, -53.37, -53.47, -53.57,
        -53.67, -53.80, -53.90, -54.00, -54.10, -54.22, -54.32, -54.42, -54.55, -54.67,
        -54.78, -54.88, -54.98, -55.08, -55.08, -55.18, -55.28, -55.37, -55.37, -55.47,
        -55.57, -55.68, -55.79, -55.90, -56.02, -56.12, -56.24, -56.33, -56.38, -56.47,
        -56.46, -56.55, -56.60, -56.60, -56.74, -56.81, -56.87, -56.93, -56.99, -57.03,
        -57.13, -57.28, -57.40, -57.50, -57.56, -57.66, -57.76, -57.82, -57.82, -57.91,
        -57.98, -58.06, -58.15, -58.22, -58.32, -58.43, -58.54, -58.65, -58.76, -58.87,
        -58.97, -59.07, -59.18, -59.29, -59.40, -59.52, -59.62, -59.61, -59.71, -59.79,
        -59.82, -59.91, -60.01, -60.11, -60.14, -60.22, -60.28, -60.38, -60.49, -60.62,
        -60.74, -60.88, -61.02, -61.15, -61.25, -61.35, -61.42, -61.52, -61.62, -61.71,
        -61.80, -61.90, -62.00, -62.10, -62.20, -62.31, -62.43, -62.55, -62.70, -62.79,
        -62.91, -63.02, -63.12, -63.22, -63.28, -63.35, -63.48, -63.55, -63.61, -63.72,
        -63.84, -63.91, -64.01, -64.12, -64.21, -64.29, -64.40, -64.48, -64.59, -64.70,
        -64.81, -64.90, -64.99, -65.09, -65.18, -65.27, -65.36, -65.45, -65.54, -65.63,
        -65.71, -65.80, -65.88, -65.98, -66.08, -66.16, -66.25, -66.32, -66.39, -66.44,
        -66.41, -66.48, -66.54, -66.60, -66.68, -66.69, -66.70, -66.77, -66.86, -66.95,
        -67.02, -67.11, -67.20, -67.28, -67.38, -67.48, -67.57, -67.65, -67.72, -67.80,
        -67.89, -67.98, -68.08, -68.16, -68.23, -68.30, -68.37, -68.44, -68.50, -68.59,
        -68.63, -68.67, -68.77, -68.84, -68.93, -69.00, -69.09, -69.20, -69.32, -69.44,
        -69.55, -69.65, -69.74, -69.84, -69.92, -69.99, -70.07, -70.15, -70.22, -70.29,
        -70.36, -70.46, -70.54, -70.60, -70.67, -70.75, -70.84, -70.94, -71.05, -71.16,
        -71.26, -71.37, -71.47, -71.58, -71.69, -71.81, -71.92, -72.01, -72.11, -72.18,
        -72.27, -72.38, -72.47, -72.54, -72.61, -72.71, -72.79, -72.88, -72.96, -73.04,
        -73.13, -73.23, -73.32, -73.39, -73.48, -73.58, -73.68, -73.78, -73.89, -74.01,
        -74.10, -74.19, -74.29, -74.39, -74.44, -74.49, -74.56, -74.65, -74.72, -74.78,
        -74.85, -74.96, -75.07, -75.18, -75.29, -75.40, -75.49, -75.56, -75.64, -75.71,
        -75.81, -75.90, -76.00, -76.09, -76.18, -76.24, -76.31, -76.39, -76.47, -76.55,
        -76.63, -76.69, -76.77, -76.85, -76.94, -77.00, -77.07, -77.13, -77.23, -77.31,
        -77.37, -77.42, -77.50, -77.57, -77.63, -77.70, -77.79, -77.85, -77.92, -77.98,
        -78.07, -78.15, -78.20, -78.26, -78.35, -78.43, -78.50, -78.55, -78.63, -78.76,
        -78.85, -78.92, -78.97, -79.04, -79.15, -79.25, -79.30, -79.34, -79.42, -79.50,
        -79.60, -79.69, -79.74, -79.82, -79.89, -79.96, -80.01, -80.06, -80.10, -80.15,
        -80.20, -80.26, -80.33, -80.39, -80.45, -80.52, -80.58, -80.63, -80.71, -80.77,
        -80.86, -80.93, -81.00, -81.04, -81.12, -81.17, -81.25, -81.33, -81.38, -81.46,
        -81.47, -81.48, -81.56, -81.57, -81.64, -81.74, -81.83, -81.90, -81.97, -82.04,
        -82.04, -82.11, -82.13, -82.15, -82.23, -82.25, -82.33, -82.36, -82.43, -82.51,
        -82.57, -82.66, -82.67, -82.75, -82.76, -82.77, -82.76, -82.76, -82.76, -82.79,
        -82.78, -82.78, -82.80, -82.83, -82.87, -82.91, -82.94, -83.00, -83.01, -83.01,
        -83.09, -83.13, -83.18, -83.21, -83.21, -83.25, -83.33, -83.38, -83.38, -83.38,
        -83.38, -83.38, -83.37, -83.37, -83.37, -83.36, -83.36, -83.36, -83.36, -83.36,
        -83.36, -83.36, -83.36, -83.36, -83.36, -83.36, -83.36, -83.34, -83.27, -83.25,
        -83.18, -83.18, -83.12, -83.12, -83.12, -83.11, -83.11, -83.10, -83.10, -83.10,
        -83.10, -83.11, -83.15, -83.15, -83.15, -83.14, -83.09, -83.04, -83.03, -82.95,
        -82.91, -82.87, -82.81, -82.79, -82.80, -82.78, -82.76, -82.76, -82.70, -82.68,
        -82.68, -82.68, -82.68, -82.68, -82.69, -82.69, -82.69, -82.60, -82.58, -82.58,
        -82.58, -82.48, -82.48, -82.48, -82.48, -82.48, -82.48, -82.47, -82.47, -82.47,
        -82.47, -82.42, -82.37, -82.36, -82.27, -82.26, -82.27, -82.27, -82.34, -82.36,
        -82.43, -82.44, -82.44, -82.44, -82.44, -82.44, -82.44, -82.45, -82.45, -82.46,
        -82.55, -82.50, -82.50, -82.59, -82.55, -82.55, -82.60, -82.60, -82.60, -82.61,
        -82.66, -82.69, -82.71, -82.71, -82.70, -82.69, -82.68, -82.71, -82.73, -82.70,
        -82.71, -82.73, -82.76, -82.80, -82.78, -82.75, -82.77, -82.74, -82.72, -82.78,
        -82.80, -82.88, -82.91, -82.96, -82.98, -83.05, -83.06, -83.14, -83.14, -83.20,
        -83.22, -83.22, -83.30, -83.26, -83.22, -83.24, -83.28, -83.37, -83.37, -83.41,
        -83.46, -83.46, -83.53, -83.46, -83.53, -83.55, -83.58, -83.55, -83.62, -83.62,
        -83.71, -83.71, -83.74, -83.80, -83.80, -83.82, -83.78, -83.82, -83.85, -83.86,
        -83.91, -83.95, -84.03, -84.05, -84.04, -84.06, -84.12, -84.17, -84.16, -84.19,
        -84.23, -84.28, -84.34, -84.38, -84.43, -84.41, -84.44, -84.48, -84.59, -84.64,
        -84.71, -84.75, -84.81, -84.87, -84.90, -84.92, -84.89, -84.97, -84.91, -84.97,
        -84.95, -84.96, -85.00, -84.97, -85.01, -84.97, -85.02, -85.06, -85.13, -85.16,
        -85.25, -85.27, -85.35, -85.39, -85.44, -85.44, -85.44, -85.51, -85.47, -85.52,
        -85.58, -85.66, -85.70, -85.74, -85.81, -85.83, -85.81, -85.77, -85.81, -85.80,
        -85.88, -85.91, -85.92, -85.97, -85.99, -85.99, -86.01, -86.04, -86.04, -86.11,
        -86.13, -86.13, -86.16, -86.16, -86.19, -86.25, -86.34, -86.39, -86.40, -86.39,
        -86.37, -86.35, -86.30, -86.32, -86.28, -86.31, -86.31, -86.33, -86.41, -86.40,
        -86.44, -86.45, -86.46, -86.41, -86.38, -86.39, -86.31, -86.24, -86.30, -86.27,
        -86.24, -86.23, -86.19, -86.13, -86.13, -86.15, -86.14, -86.21, -86.17, -86.22,
        -86.25, -86.22, -86.22, -86.17, -86.11, -86.12, -86.06, -86.04, -86.02, -85.98,
        -85.96, -85.96, -85.97, -85.95, -85.94, -85.92, -85.89, -85.89, -85.86, -85.82,
        -85.82, -85.78, -85.72, -85.71, -85.62, -85.57, -85.51, -85.46, -85.46, -85.46,
        -85.46, -85.46, -85.46, -85.45, -85.35, -85.35, -85.35, -85.20, -85.16, -85.10,
        -85.04, -85.01, -85.01, -85.01, -85.01, -85.01, -85.01, -85.01, -85.01, -85.00,
        -84.88, -84.81, -84.78, -84.68, -84.61, -84.55, -84.51, -84.50, -84.43, -84.46,
        -84.45, -84.45, -84.45, -84.41, -84.40, -84.40, -84.40, -84.40, -84.35, -84.34,
        -84.32, -84.31, -84.30, -84.27, -84.26, -84.21, -84.18, -84.15, -84.13, -84.12,
        -84.07, -84.03, -84.00, -84.02, -84.07, -84.06, -84.05, -84.02, -84.08, -84.13,
        -84.10, -84.10, -84.05, -84.08, -84.08, -84.13, -84.14, -84.15, -84.12, -84.06,
        -84.06, -84.11, -84.16, -84.19, -84.23, -84.26, -84.26, -84.38, -84.35, -84.35,
        -84.35, -84.34, -84.42, -84.39, -84.43, -84.51, -84.49, -84.51, -84.57, -84.74,
        -84.83, -84.82, -84.90, -84.96, -85.02, -85.18, -85.27, -85.24, -85.27, -85.39,
        -85.39, -85.33, -85.31, -85.37, -85.47, -85.54, -85.55, -85.56, -85.67, -85.78,
        -85.88, -85.90, -85.91, -85.98, -86.04, -86.02, -85.96, -85.99, -86.00, -86.03,
        -86.09, -86.03, -86.04, -86.05, -86.32, -86.27, -86.23, -86.22, -86.55, -86.57,
        -86.59, -86.60, -86.61, -86.65, -86.69, -86.67, -86.59, -86.60, -86.64, -86.64,
        -86.64, -86.66, -86.61, -86.57, -86.52, -86.52, -86.51, -86.43, -86.42, -86.44,
        -86.42, -86.35, -86.31, -86.24, -86.21, -86.17, -86.14, -86.10, -86.02, -85.99,
        -85.91, -85.89, -85.89, -85.91, -85.91, -85.84, -85.82, -85.79, -85.78, -85.74,
        -85.79, -85.80, -85.75, -85.69, -85.68, -85.64, -85.65, -85.68, -85.62, -85.58,
        -85.57, -85.55, -85.51, -85.43, -85.47, -85.39, -85.41, -85.42, -85.42, -85.42,
        -85.41, -85.40, -85.36, -85.31, -85.27, -85.24, -85.24, -85.23, -85.18, -85.14,
        -85.09, -85.14, -85.15, -85.18, -85.26, -85.26, -85.26, -85.26, -85.25, -85.25,
        -85.19, -85.19, -85.14, -85.14, -85.15, -85.15, -85.17, -85.17, -85.18, -85.17,
        -85.19, -85.20, -85.22, -85.25, -85.26, -85.27, -85.27, -85.25, -85.25, -85.24,
        -85.23, -85.22, -85.22, -85.20, -85.20, -85.18, -85.15, -85.15, -85.13, -85.07,
        -85.01, -84.98, -84.95, -85.00, -84.98, -84.98, -84.96, -84.91, -84.96, -84.96,
        -84.92, -84.84, -84.88, -84.80, -84.82, -84.79, -84.79, -84.74, -84.73, -84.72,
        -84.69, -84.65, -84.59, -84.52, -84.48, -84.46, -84.49, -84.46, -84.44, -84.48,
        -84.52, -84.46, -84.43, -84.32, -84.22, -84.17, -84.13, -84.09, -83.96, -83.90,
        -83.86, -83.84, -83.80, -83.72, -83.63, -83.63, -83.60, -83.59, -83.63, -83.55,
        -83.44, -83.41, -83.28, -83.23, -83.20, -83.16, -83.10, -83.06, -82.94, -82.97,
        -83.02, -82.94, -82.83, -82.77, -82.68, -82.63, -82.55, -82.49, -82.45, -82.47,
        -82.38, -82.35, -82.37, -82.36, -82.33, -82.19, -82.11, -82.01, -81.92, -81.84,
        -81.76, -81.63, -81.60, -81.49, -81.43, -81.34, -81.29, -81.25
    };

    static const float fletcher_munson_curve_10_phons[1383] =
    {
        -19.50, -19.53, -19.55, -19.62, -19.69,
        -19.80, -19.83, -19.92, -19.94, -20.04, -20.08, -20.18, -20.22, -20.27, -20.31,
        -20.38, -20.42, -20.47, -20.52, -20.55, -20.61, -20.66, -20.71, -20.81, -20.87,
        -20.93, -20.97, -21.04, -21.09, -21.18, -21.29, -21.37, -21.46, -21.53, -21.63,
        -21.62, -21.73, -21.81, -21.87, -21.93, -22.00, -22.06, -22.11, -22.18, -22.19,
        -22.26, -22.40, -22.42, -22.50, -22.53, -22.62, -22.69, -22.75, -22.82, -22.88,
        -22.93, -22.99, -23.05, -23.12, -23.23, -23.25, -23.35, -23.35, -23.36, -23.40,
        -23.45, -23.50, -23.52, -23.61, -23.62, -23.72, -23.77, -23.81, -23.90, -23.92,
        -23.98, -24.09, -24.10, -24.15, -24.27, -24.24, -24.30, -24.40, -24.47, -24.55,
        -24.54, -24.61, -24.71, -24.79, -24.81, -24.85, -24.89, -24.94, -24.99, -25.03,
        -25.11, -25.11, -25.18, -25.23, -25.28, -25.34, -25.40, -25.47, -25.56, -25.64,
        -25.64, -25.74, -25.79, -25.83, -25.92, -25.96, -26.02, -26.09, -26.09, -26.18,
        -26.28, -26.29, -26.32, -26.37, -26.46, -26.45, -26.51, -26.62, -26.62, -26.73,
        -26.85, -26.87, -26.93, -27.05, -27.17, -27.19, -27.28, -27.32, -27.36, -27.41,
        -27.47, -27.52, -27.56, -27.61, -27.67, -27.74, -27.76, -27.87, -27.91, -27.96,
        -28.04, -28.11, -28.19, -28.29, -28.39, -28.51, -28.57, -28.62, -28.71, -28.75,
        -28.82, -28.90, -28.95, -29.06, -29.07, -29.14, -29.25, -29.32, -29.42, -29.50,
        -29.54, -29.59, -29.65, -29.72, -29.76, -29.84, -29.91, -29.95, -30.03, -30.12,
        -30.19, -30.28, -30.30, -30.37, -30.46, -30.55, -30.65, -30.73, -30.69, -30.77,
        -30.85, -30.93, -30.93, -31.02, -31.12, -31.21, -31.26, -31.31, -31.41, -31.52,
        -31.55, -31.65, -31.76, -31.90, -32.01, -32.11, -32.22, -32.33, -32.42, -32.50,
        -32.60, -32.66, -32.69, -32.79, -32.89, -32.90, -32.97, -33.07, -33.13, -33.12,
        -33.20, -33.29, -33.39, -33.37, -33.47, -33.57, -33.66, -33.68, -33.73, -33.79,
        -33.81, -33.89, -33.95, -34.05, -34.10, -34.20, -34.25, -34.36, -34.44, -34.48,
        -34.58, -34.67, -34.71, -34.80, -34.90, -34.99, -35.13, -35.22, -35.32, -35.42,
        -35.53, -35.64, -35.73, -35.83, -35.93, -36.03, -36.14, -36.23, -36.34, -36.45,
        -36.54, -36.65, -36.74, -36.76, -36.83, -36.91, -36.91, -36.99, -37.09, -37.19,
        -37.30, -37.39, -37.49, -37.58, -37.68, -37.78, -37.89, -37.99, -38.08, -38.15,
        -38.19, -38.25, -38.36, -38.44, -38.44, -38.53, -38.64, -38.73, -38.83, -38.93,
        -39.00, -39.13, -39.22, -39.31, -39.38, -39.46, -39.55, -39.63, -39.77, -39.87,
        -39.99, -40.10, -40.14, -40.24, -40.29, -40.38, -40.46, -40.50, -40.53, -40.62,
        -40.62, -40.66, -40.71, -40.75, -40.85, -40.96, -41.06, -41.16, -41.24, -41.34,
        -41.42, -41.42, -41.50, -41.57, -41.56, -41.62, -41.70, -41.68, -41.76, -41.87,
        -41.93, -41.96, -42.07, -42.19, -42.29, -42.40, -42.49, -42.56, -42.63, -42.70,
        -42.79, -42.85, -42.88, -43.00, -43.06, -43.11, -43.21, -43.29, -43.39, -43.50,
        -43.56, -43.61, -43.67, -43.78, -43.82, -43.86, -43.94, -44.02, -44.08, -44.13,
        -44.18, -44.25, -44.33, -44.42, -44.51, -44.60, -44.64, -44.74, -44.84, -44.95,
        -45.06, -45.16, -45.25, -45.35, -45.46, -45.55, -45.63, -45.73, -45.79, -45.87,
        -45.95, -46.06, -46.14, -46.20, -46.28, -46.39, -46.46, -46.54, -46.66, -46.75,
        -46.85, -46.94, -47.03, -47.12, -47.11, -47.21, -47.31, -47.37, -47.37, -47.47,
        -47.55, -47.65, -47.75, -47.85, -47.94, -48.04, -48.15, -48.25, -48.32, -48.42,
        -48.40, -48.47, -48.54, -48.54, -48.67, -48.73, -48.77, -48.85, -48.92, -48.97,
        -49.06, -49.16, -49.26, -49.35, -49.39, -49.49, -49.59, -49.64, -49.65, -49.74,
        -49.82, -49.90, -49.96, -50.02, -50.12, -50.22, -50.29, -50.38, -50.48, -50.59,
        -50.68, -50.78, -50.89, -50.98, -51.09, -51.22, -51.31, -51.31, -51.41, -51.48,
        -51.52, -51.62, -51.72, -51.77, -51.83, -51.92, -52.00, -52.08, -52.16, -52.27,
        -52.38, -52.50, -52.57, -52.69, -52.79, -52.89, -52.96, -53.04, -53.12, -53.22,
        -53.32, -53.41, -53.50, -53.58, -53.67, -53.77, -53.88, -53.99, -54.14, -54.23,
        -54.35, -54.46, -54.56, -54.65, -54.71, -54.77, -54.88, -54.95, -54.99, -55.10,
        -55.20, -55.26, -55.34, -55.43, -55.53, -55.61, -55.70, -55.79, -55.91, -56.02,
        -56.12, -56.17, -56.25, -56.35, -56.44, -56.49, -56.59, -56.68, -56.75, -56.82,
        -56.91, -57.00, -57.05, -57.14, -57.24, -57.33, -57.38, -57.46, -57.54, -57.61,
        -57.59, -57.64, -57.71, -57.78, -57.87, -57.89, -57.89, -57.97, -58.06, -58.15,
        -58.24, -58.34, -58.43, -58.52, -58.61, -58.68, -58.75, -58.82, -58.89, -58.96,
        -59.05, -59.14, -59.20, -59.30, -59.39, -59.47, -59.55, -59.64, -59.73, -59.83,
        -59.88, -59.90, -60.00, -60.07, -60.12, -60.21, -60.30, -60.36, -60.46, -60.57,
        -60.67, -60.76, -60.84, -60.91, -60.99, -61.08, -61.17, -61.25, -61.30, -61.37,
        -61.46, -61.55, -61.63, -61.68, -61.76, -61.84, -61.94, -62.01, -62.11, -62.21,
        -62.31, -62.42, -62.52, -62.62, -62.70, -62.80, -62.88, -62.96, -63.02, -63.09,
        -63.16, -63.25, -63.32, -63.40, -63.48, -63.55, -63.64, -63.73, -63.82, -63.91,
        -63.98, -64.05, -64.12, -64.20, -64.28, -64.36, -64.45, -64.53, -64.60, -64.72,
        -64.81, -64.90, -64.97, -65.05, -65.12, -65.18, -65.23, -65.30, -65.37, -65.44,
        -65.48, -65.58, -65.68, -65.79, -65.87, -65.99, -66.10, -66.18, -66.27, -66.33,
        -66.38, -66.47, -66.53, -66.60, -66.69, -66.74, -66.82, -66.91, -66.99, -67.06,
        -67.15, -67.21, -67.27, -67.36, -67.43, -67.48, -67.56, -67.59, -67.68, -67.77,
        -67.82, -67.87, -67.93, -67.99, -68.07, -68.12, -68.20, -68.27, -68.36, -68.40,
        -68.48, -68.55, -68.61, -68.67, -68.73, -68.80, -68.86, -68.91, -68.97, -69.07,
        -69.15, -69.19, -69.25, -69.29, -69.39, -69.47, -69.51, -69.54, -69.60, -69.66,
        -69.74, -69.81, -69.85, -69.92, -69.98, -70.04, -70.09, -70.13, -70.18, -70.23,
        -70.27, -70.35, -70.40, -70.46, -70.53, -70.57, -70.65, -70.67, -70.76, -70.80,
        -70.86, -70.92, -70.97, -71.00, -71.06, -71.09, -71.17, -71.22, -71.29, -71.33,
        -71.38, -71.41, -71.47, -71.48, -71.54, -71.59, -71.66, -71.70, -71.77, -71.81,
        -71.83, -71.89, -71.91, -71.95, -72.00, -72.05, -72.10, -72.13, -72.20, -72.26,
        -72.30, -72.40, -72.40, -72.47, -72.49, -72.51, -72.53, -72.55, -72.56, -72.59,
        -72.59, -72.59, -72.64, -72.66, -72.68, -72.75, -72.77, -72.85, -72.85, -72.88,
        -72.95, -73.01, -73.06, -73.11, -73.12, -73.14, -73.17, -73.20, -73.22, -73.25,
        -73.25, -73.29, -73.28, -73.28, -73.28, -73.28, -73.27, -73.27, -73.27, -73.27,
        -73.27, -73.27, -73.27, -73.27, -73.27, -73.27, -73.27, -73.26, -73.22, -73.21,
        -73.18, -73.18, -73.12, -73.12, -73.12, -73.11, -73.11, -73.10, -73.10, -73.10,
        -73.10, -73.11, -73.15, -73.15, -73.15, -73.12, -73.09, -73.05, -73.03, -72.99,
        -72.96, -72.92, -72.88, -72.83, -72.81, -72.79, -72.77, -72.77, -72.71, -72.69,
        -72.68, -72.67, -72.66, -72.66, -72.67, -72.66, -72.66, -72.57, -72.55, -72.57,
        -72.58, -72.48, -72.46, -72.45, -72.46, -72.46, -72.46, -72.47, -72.47, -72.47,
        -72.47, -72.42, -72.37, -72.37, -72.27, -72.26, -72.27, -72.27, -72.30, -72.31,
        -72.35, -72.38, -72.39, -72.42, -72.45, -72.45, -72.45, -72.45, -72.45, -72.45,
        -72.50, -72.45, -72.47, -72.55, -72.51, -72.53, -72.60, -72.60, -72.60, -72.61,
        -72.63, -72.64, -72.67, -72.68, -72.67, -72.69, -72.68, -72.71, -72.74, -72.72,
        -72.74, -72.77, -72.80, -72.83, -72.79, -72.78, -72.81, -72.79, -72.77, -72.82,
        -72.84, -72.90, -72.94, -72.97, -73.00, -73.07, -73.08, -73.14, -73.14, -73.17,
        -73.22, -73.22, -73.26, -73.21, -73.23, -73.22, -73.26, -73.32, -73.39, -73.43,
        -73.46, -73.49, -73.54, -73.45, -73.49, -73.55, -73.53, -73.49, -73.54, -73.57,
        -73.62, -73.64, -73.68, -73.71, -73.73, -73.73, -73.70, -73.73, -73.76, -73.76,
        -73.81, -73.85, -73.92, -73.95, -73.92, -73.95, -74.02, -74.07, -74.07, -74.08,
        -74.10, -74.14, -74.17, -74.21, -74.23, -74.19, -74.20, -74.24, -74.29, -74.34,
        -74.39, -74.43, -74.47, -74.54, -74.57, -74.59, -74.55, -74.63, -74.58, -74.63,
        -74.62, -74.63, -74.67, -74.64, -74.67, -74.61, -74.66, -74.69, -74.73, -74.75,
        -74.81, -74.85, -74.89, -74.92, -74.98, -74.95, -74.97, -75.01, -74.98, -75.02,
        -75.07, -75.14, -75.18, -75.23, -75.26, -75.28, -75.24, -75.25, -75.26, -75.24,
        -75.28, -75.33, -75.33, -75.37, -75.39, -75.37, -75.41, -75.43, -75.43, -75.51,
        -75.53, -75.53, -75.56, -75.54, -75.53, -75.56, -75.63, -75.66, -75.64, -75.62,
        -75.60, -75.57, -75.52, -75.50, -75.46, -75.48, -75.45, -75.47, -75.51, -75.48,
        -75.47, -75.45, -75.46, -75.38, -75.40, -75.37, -75.28, -75.19, -75.23, -75.19,
        -75.12, -75.12, -75.07, -75.01, -75.01, -75.00, -74.99, -75.03, -74.99, -75.01,
        -75.07, -75.01, -75.02, -74.99, -74.93, -74.93, -74.87, -74.84, -74.83, -74.79,
        -74.75, -74.77, -74.76, -74.76, -74.73, -74.71, -74.70, -74.69, -74.65, -74.60,
        -74.60, -74.56, -74.50, -74.49, -74.40, -74.36, -74.30, -74.24, -74.25, -74.26,
        -74.26, -74.25, -74.25, -74.25, -74.15, -74.15, -74.14, -74.01, -73.99, -73.96,
        -73.95, -73.93, -73.93, -73.93, -73.93, -73.91, -73.91, -73.91, -73.91, -73.91,
        -73.83, -73.76, -73.74, -73.68, -73.60, -73.57, -73.55, -73.55, -73.50, -73.47,
        -73.47, -73.46, -73.42, -73.40, -73.40, -73.39, -73.39, -73.39, -73.37, -73.34,
        -73.29, -73.27, -73.28, -73.24, -73.23, -73.19, -73.15, -73.14, -73.12, -73.10,
        -73.08, -73.05, -73.02, -73.04, -73.05, -73.03, -73.03, -73.00, -73.05, -73.06,
        -73.05, -73.04, -72.99, -73.04, -73.02, -73.03, -73.04, -73.04, -72.99, -72.94,
        -72.94, -72.96, -73.03, -73.05, -73.08, -73.08, -73.08, -73.21, -73.16, -73.13,
        -73.11, -73.09, -73.18, -73.16, -73.16, -73.23, -73.25, -73.28, -73.34, -73.50,
        -73.60, -73.58, -73.67, -73.69, -73.74, -73.88, -73.96, -73.94, -73.98, -74.10,
        -74.10, -74.07, -74.04, -74.11, -74.19, -74.25, -74.26, -74.31, -74.42, -74.53,
        -74.62, -74.61, -74.68, -74.75, -74.74, -74.68, -74.59, -74.68, -74.74, -74.77,
        -74.85, -74.78, -74.80, -74.81, -75.09, -75.03, -74.96, -74.96, -75.28, -75.27,
        -75.27, -75.30, -75.31, -75.38, -75.41, -75.39, -75.35, -75.37, -75.42, -75.43,
        -75.42, -75.48, -75.43, -75.40, -75.38, -75.36, -75.33, -75.26, -75.26, -75.28,
        -75.25, -75.19, -75.17, -75.11, -75.08, -75.05, -75.04, -74.99, -74.92, -74.91,
        -74.85, -74.83, -74.84, -74.85, -74.86, -74.81, -74.83, -74.82, -74.82, -74.80,
        -74.85, -74.84, -74.79, -74.73, -74.72, -74.69, -74.69, -74.71, -74.66, -74.63,
        -74.61, -74.57, -74.52, -74.47, -74.52, -74.46, -74.47, -74.51, -74.49, -74.49,
        -74.47, -74.45, -74.41, -74.37, -74.33, -74.32, -74.32, -74.28, -74.24, -74.22,
        -74.16, -74.23, -74.24, -74.27, -74.34, -74.34, -74.32, -74.30, -74.27, -74.25,
        -74.22, -74.23, -74.22, -74.23, -74.24, -74.22, -74.21, -74.19, -74.17, -74.17,
        -74.19, -74.21, -74.23, -74.26, -74.27, -74.27, -74.27, -74.26, -74.26, -74.26,
        -74.25, -74.25, -74.25, -74.24, -74.24, -74.24, -74.23, -74.22, -74.24, -74.21,
        -74.20, -74.19, -74.16, -74.22, -74.21, -74.23, -74.25, -74.23, -74.28, -74.28,
        -74.27, -74.22, -74.27, -74.22, -74.25, -74.26, -74.24, -74.21, -74.23, -74.25,
        -74.24, -74.19, -74.14, -74.08, -74.06, -74.08, -74.11, -74.09, -74.09, -74.13,
        -74.17, -74.10, -74.08, -74.02, -73.96, -73.94, -73.88, -73.86, -73.75, -73.72,
        -73.67, -73.65, -73.62, -73.53, -73.44, -73.47, -73.45, -73.47, -73.53, -73.49,
        -73.37, -73.35, -73.25, -73.21, -73.14, -73.09, -73.02, -73.01, -72.89, -72.90,
        -72.93, -72.86, -72.78, -72.73, -72.66, -72.57, -72.50, -72.48, -72.46, -72.46,
        -72.39, -72.32, -72.36, -72.34, -72.29, -72.15, -72.09, -72.01, -71.91, -71.87,
        -71.76, -71.64, -71.63, -71.51, -71.45, -71.39, -71.37, -71.36
    };

    static const float fletcher_munson_curve_20_phons[1383] =
    {
        -15.16, -15.20, -15.20, -15.27, -15.35,
        -15.46, -15.49, -15.57, -15.59, -15.68, -15.70, -15.81, -15.85, -15.88, -15.90,
        -15.93, -15.97, -16.01, -16.07, -16.09, -16.11, -16.16, -16.22, -16.31, -16.38,
        -16.43, -16.47, -16.57, -16.61, -16.69, -16.79, -16.84, -16.93, -16.98, -17.06,
        -17.03, -17.16, -17.26, -17.31, -17.36, -17.41, -17.46, -17.49, -17.52, -17.54,
        -17.64, -17.75, -17.75, -17.85, -17.90, -17.98, -18.04, -18.11, -18.18, -18.26,
        -18.30, -18.36, -18.41, -18.49, -18.60, -18.62, -18.73, -18.72, -18.68, -18.71,
        -18.76, -18.80, -18.80, -18.86, -18.86, -18.95, -19.00, -19.04, -19.11, -19.10,
        -19.15, -19.24, -19.24, -19.24, -19.35, -19.30, -19.35, -19.45, -19.49, -19.55,
        -19.54, -19.59, -19.69, -19.78, -19.78, -19.81, -19.85, -19.90, -19.95, -19.98,
        -20.04, -20.04, -20.09, -20.14, -20.18, -20.24, -20.31, -20.38, -20.46, -20.54,
        -20.52, -20.60, -20.63, -20.65, -20.75, -20.78, -20.84, -20.87, -20.86, -20.95,
        -21.04, -21.04, -21.04, -21.07, -21.14, -21.13, -21.18, -21.27, -21.25, -21.32,
        -21.42, -21.42, -21.47, -21.57, -21.66, -21.66, -21.75, -21.77, -21.82, -21.85,
        -21.92, -21.94, -21.99, -22.04, -22.09, -22.16, -22.17, -22.27, -22.32, -22.37,
        -22.46, -22.52, -22.62, -22.72, -22.82, -22.91, -22.98, -23.01, -23.08, -23.07,
        -23.12, -23.20, -23.24, -23.34, -23.35, -23.39, -23.48, -23.54, -23.64, -23.71,
        -23.75, -23.81, -23.89, -23.92, -23.94, -24.01, -24.09, -24.11, -24.17, -24.24,
        -24.30, -24.38, -24.39, -24.44, -24.54, -24.64, -24.73, -24.80, -24.74, -24.84,
        -24.93, -24.99, -24.99, -25.05, -25.14, -25.22, -25.25, -25.28, -25.36, -25.44,
        -25.45, -25.53, -25.62, -25.76, -25.87, -25.96, -26.06, -26.16, -26.23, -26.28,
        -26.39, -26.46, -26.49, -26.59, -26.70, -26.71, -26.79, -26.89, -26.94, -26.94,
        -27.03, -27.12, -27.21, -27.18, -27.25, -27.32, -27.39, -27.40, -27.45, -27.50,
        -27.49, -27.55, -27.59, -27.68, -27.71, -27.80, -27.84, -27.95, -28.01, -28.00,
        -28.07, -28.14, -28.18, -28.25, -28.33, -28.39, -28.52, -28.60, -28.70, -28.79,
        -28.89, -28.99, -29.07, -29.16, -29.24, -29.34, -29.45, -29.55, -29.64, -29.74,
        -29.82, -29.93, -30.02, -30.03, -30.09, -30.16, -30.15, -30.21, -30.31, -30.40,
        -30.51, -30.59, -30.66, -30.74, -30.81, -30.90, -31.01, -31.10, -31.16, -31.21,
        -31.24, -31.30, -31.40, -31.46, -31.45, -31.54, -31.64, -31.71, -31.79, -31.88,
        -31.95, -32.07, -32.15, -32.23, -32.31, -32.40, -32.49, -32.58, -32.73, -32.82,
        -32.96, -33.09, -33.12, -33.20, -33.20, -33.29, -33.36, -33.40, -33.40, -33.49,
        -33.48, -33.53, -33.56, -33.58, -33.66, -33.77, -33.86, -33.96, -34.05, -34.14,
        -34.21, -34.21, -34.30, -34.39, -34.39, -34.42, -34.50, -34.50, -34.59, -34.69,
        -34.74, -34.75, -34.85, -34.95, -35.04, -35.14, -35.19, -35.25, -35.34, -35.40,
        -35.46, -35.52, -35.53, -35.63, -35.67, -35.72, -35.81, -35.91, -36.01, -36.11,
        -36.17, -36.23, -36.30, -36.43, -36.47, -36.50, -36.58, -36.62, -36.67, -36.69,
        -36.73, -36.76, -36.84, -36.91, -36.99, -37.07, -37.10, -37.19, -37.29, -37.40,
        -37.50, -37.58, -37.68, -37.78, -37.87, -37.95, -37.99, -38.08, -38.12, -38.17,
        -38.22, -38.32, -38.37, -38.40, -38.46, -38.56, -38.61, -38.66, -38.77, -38.83,
        -38.92, -39.01, -39.09, -39.15, -39.13, -39.23, -39.34, -39.36, -39.37, -39.47,
        -39.52, -39.62, -39.71, -39.79, -39.87, -39.96, -40.07, -40.16, -40.26, -40.36,
        -40.34, -40.39, -40.48, -40.48, -40.60, -40.65, -40.68, -40.76, -40.86, -40.91,
        -40.98, -41.04, -41.12, -41.20, -41.23, -41.32, -41.41, -41.47, -41.49, -41.58,
        -41.67, -41.73, -41.77, -41.82, -41.91, -42.01, -42.04, -42.11, -42.20, -42.31,
        -42.39, -42.49, -42.59, -42.68, -42.78, -42.91, -43.01, -43.01, -43.11, -43.16,
        -43.21, -43.32, -43.42, -43.44, -43.52, -43.63, -43.72, -43.78, -43.83, -43.93,
        -44.02, -44.11, -44.13, -44.23, -44.32, -44.42, -44.50, -44.56, -44.63, -44.73,
        -44.83, -44.92, -45.00, -45.07, -45.13, -45.23, -45.32, -45.43, -45.58, -45.67,
        -45.79, -45.91, -45.99, -46.08, -46.14, -46.19, -46.28, -46.34, -46.38, -46.47,
        -46.56, -46.62, -46.67, -46.75, -46.84, -46.92, -47.00, -47.10, -47.24, -47.34,
        -47.43, -47.43, -47.52, -47.62, -47.70, -47.72, -47.82, -47.91, -47.96, -48.01,
        -48.11, -48.21, -48.21, -48.31, -48.40, -48.49, -48.52, -48.59, -48.69, -48.77,
        -48.77, -48.81, -48.88, -48.97, -49.06, -49.09, -49.08, -49.17, -49.26, -49.35,
        -49.46, -49.57, -49.66, -49.75, -49.83, -49.88, -49.93, -49.99, -50.07, -50.11,
        -50.22, -50.30, -50.33, -50.44, -50.55, -50.65, -50.74, -50.84, -50.96, -51.07,
        -51.13, -51.14, -51.24, -51.31, -51.32, -51.42, -51.51, -51.53, -51.61, -51.70,
        -51.79, -51.87, -51.93, -51.98, -52.07, -52.16, -52.26, -52.35, -52.38, -52.46,
        -52.56, -52.65, -52.73, -52.75, -52.85, -52.94, -53.03, -53.08, -53.18, -53.27,
        -53.37, -53.47, -53.56, -53.65, -53.71, -53.80, -53.83, -53.91, -53.93, -54.00,
        -54.05, -54.12, -54.17, -54.26, -54.35, -54.40, -54.48, -54.58, -54.68, -54.78,
        -54.82, -54.88, -54.93, -55.00, -55.07, -55.13, -55.22, -55.28, -55.32, -55.42,
        -55.52, -55.60, -55.65, -55.71, -55.79, -55.86, -55.90, -55.94, -56.02, -56.09,
        -56.10, -56.19, -56.30, -56.40, -56.45, -56.57, -56.71, -56.79, -56.89, -56.94,
        -56.95, -57.04, -57.05, -57.10, -57.19, -57.24, -57.34, -57.43, -57.51, -57.58,
        -57.67, -57.73, -57.77, -57.86, -57.91, -57.95, -58.04, -58.06, -58.14, -58.23,
        -58.27, -58.32, -58.37, -58.41, -58.50, -58.54, -58.61, -58.70, -58.80, -58.81,
        -58.89, -58.95, -59.02, -59.07, -59.12, -59.17, -59.22, -59.26, -59.31, -59.38,
        -59.45, -59.45, -59.53, -59.54, -59.63, -59.69, -59.71, -59.73, -59.78, -59.82,
        -59.88, -59.92, -59.97, -60.02, -60.08, -60.12, -60.17, -60.21, -60.25, -60.30,
        -60.35, -60.44, -60.47, -60.53, -60.61, -60.63, -60.71, -60.72, -60.80, -60.82,
        -60.87, -60.91, -60.95, -60.95, -61.00, -61.01, -61.10, -61.10, -61.19, -61.19,
        -61.29, -61.34, -61.38, -61.38, -61.44, -61.44, -61.49, -61.50, -61.58, -61.58,
        -61.63, -61.67, -61.69, -61.76, -61.78, -61.86, -61.87, -61.89, -61.97, -62.01,
        -62.03, -62.14, -62.12, -62.19, -62.21, -62.26, -62.30, -62.35, -62.35, -62.39,
        -62.41, -62.40, -62.48, -62.48, -62.49, -62.59, -62.60, -62.70, -62.69, -62.75,
        -62.81, -62.90, -62.95, -63.01, -63.03, -63.02, -63.02, -63.02, -63.06, -63.11,
        -63.11, -63.20, -63.19, -63.19, -63.19, -63.19, -63.19, -63.18, -63.18, -63.18,
        -63.18, -63.18, -63.18, -63.18, -63.18, -63.18, -63.18, -63.18, -63.18, -63.18,
        -63.18, -63.18, -63.13, -63.12, -63.12, -63.11, -63.11, -63.11, -63.11, -63.11,
        -63.10, -63.11, -63.16, -63.15, -63.15, -63.10, -63.10, -63.05, -63.03, -63.03,
        -63.01, -62.97, -62.95, -62.87, -62.83, -62.80, -62.78, -62.77, -62.72, -62.69,
        -62.68, -62.66, -62.65, -62.65, -62.64, -62.63, -62.64, -62.54, -62.53, -62.56,
        -62.58, -62.47, -62.44, -62.43, -62.44, -62.45, -62.44, -62.47, -62.47, -62.47,
        -62.47, -62.42, -62.37, -62.37, -62.27, -62.27, -62.27, -62.27, -62.26, -62.26,
        -62.26, -62.31, -62.33, -62.40, -62.45, -62.45, -62.45, -62.45, -62.45, -62.45,
        -62.46, -62.41, -62.43, -62.51, -62.47, -62.51, -62.61, -62.61, -62.61, -62.61,
        -62.61, -62.59, -62.64, -62.65, -62.64, -62.69, -62.68, -62.71, -62.76, -62.74,
        -62.77, -62.82, -62.84, -62.86, -62.81, -62.81, -62.84, -62.83, -62.83, -62.85,
        -62.89, -62.93, -62.97, -62.99, -63.02, -63.08, -63.10, -63.14, -63.14, -63.14,
        -63.22, -63.22, -63.22, -63.16, -63.25, -63.20, -63.23, -63.28, -63.41, -63.46,
        -63.46, -63.52, -63.54, -63.45, -63.45, -63.54, -63.49, -63.43, -63.47, -63.52,
        -63.53, -63.57, -63.62, -63.62, -63.66, -63.64, -63.61, -63.64, -63.66, -63.66,
        -63.71, -63.76, -63.81, -63.85, -63.81, -63.84, -63.93, -63.97, -63.97, -63.97,
        -63.97, -64.00, -64.01, -64.04, -64.04, -63.97, -63.96, -63.99, -64.00, -64.04,
        -64.07, -64.11, -64.13, -64.21, -64.23, -64.25, -64.20, -64.29, -64.25, -64.29,
        -64.29, -64.29, -64.34, -64.32, -64.32, -64.24, -64.31, -64.32, -64.32, -64.33,
        -64.37, -64.43, -64.43, -64.45, -64.52, -64.46, -64.50, -64.52, -64.49, -64.51,
        -64.56, -64.62, -64.66, -64.71, -64.72, -64.72, -64.68, -64.72, -64.72, -64.68,
        -64.68, -64.76, -64.74, -64.77, -64.79, -64.76, -64.81, -64.81, -64.82, -64.92,
        -64.94, -64.93, -64.95, -64.92, -64.88, -64.88, -64.91, -64.93, -64.87, -64.86,
        -64.83, -64.79, -64.74, -64.68, -64.64, -64.64, -64.59, -64.62, -64.61, -64.55,
        -64.50, -64.46, -64.45, -64.36, -64.42, -64.35, -64.25, -64.15, -64.16, -64.10,
        -64.00, -64.00, -63.95, -63.90, -63.90, -63.84, -63.84, -63.84, -63.81, -63.80,
        -63.89, -63.80, -63.81, -63.80, -63.75, -63.75, -63.68, -63.64, -63.64, -63.59,
        -63.55, -63.57, -63.56, -63.56, -63.53, -63.50, -63.50, -63.48, -63.44, -63.39,
        -63.38, -63.34, -63.28, -63.28, -63.18, -63.15, -63.09, -63.03, -63.04, -63.06,
        -63.06, -63.05, -63.05, -63.05, -62.94, -62.94, -62.94, -62.82, -62.81, -62.82,
        -62.86, -62.86, -62.86, -62.86, -62.86, -62.82, -62.82, -62.82, -62.82, -62.82,
        -62.78, -62.71, -62.71, -62.67, -62.60, -62.59, -62.59, -62.59, -62.57, -62.49,
        -62.49, -62.47, -62.39, -62.39, -62.39, -62.39, -62.39, -62.39, -62.39, -62.35,
        -62.26, -62.24, -62.25, -62.21, -62.21, -62.17, -62.13, -62.14, -62.11, -62.09,
        -62.09, -62.07, -62.04, -62.05, -62.02, -62.00, -62.01, -61.99, -62.02, -61.99,
        -62.00, -61.98, -61.94, -61.99, -61.95, -61.92, -61.94, -61.92, -61.86, -61.81,
        -61.81, -61.82, -61.89, -61.91, -61.94, -61.90, -61.91, -62.03, -61.97, -61.91,
        -61.86, -61.83, -61.93, -61.93, -61.89, -61.95, -62.02, -62.05, -62.11, -62.27,
        -62.36, -62.34, -62.44, -62.43, -62.46, -62.58, -62.65, -62.64, -62.68, -62.81,
        -62.81, -62.82, -62.78, -62.86, -62.92, -62.97, -62.98, -63.05, -63.17, -63.28,
        -63.36, -63.31, -63.45, -63.52, -63.44, -63.34, -63.23, -63.37, -63.49, -63.51,
        -63.61, -63.53, -63.56, -63.57, -63.87, -63.78, -63.69, -63.70, -64.01, -63.96,
        -63.96, -64.00, -64.00, -64.10, -64.13, -64.11, -64.10, -64.15, -64.20, -64.22,
        -64.20, -64.29, -64.24, -64.24, -64.24, -64.19, -64.14, -64.10, -64.10, -64.11,
        -64.09, -64.02, -64.04, -63.99, -63.95, -63.93, -63.93, -63.88, -63.81, -63.83,
        -63.78, -63.77, -63.79, -63.78, -63.82, -63.79, -63.83, -63.85, -63.86, -63.85,
        -63.91, -63.88, -63.83, -63.78, -63.77, -63.75, -63.73, -63.74, -63.71, -63.68,
        -63.64, -63.59, -63.52, -63.50, -63.56, -63.53, -63.54, -63.61, -63.57, -63.56,
        -63.53, -63.50, -63.47, -63.44, -63.40, -63.40, -63.40, -63.33, -63.30, -63.30,
        -63.22, -63.31, -63.32, -63.36, -63.43, -63.43, -63.38, -63.34, -63.29, -63.24,
        -63.25, -63.27, -63.30, -63.32, -63.32, -63.28, -63.25, -63.21, -63.17, -63.17,
        -63.20, -63.22, -63.24, -63.27, -63.27, -63.28, -63.28, -63.27, -63.27, -63.27,
        -63.27, -63.27, -63.27, -63.28, -63.29, -63.29, -63.30, -63.30, -63.35, -63.35,
        -63.39, -63.39, -63.38, -63.44, -63.44, -63.49, -63.54, -63.55, -63.60, -63.60,
        -63.62, -63.61, -63.67, -63.64, -63.69, -63.72, -63.69, -63.68, -63.73, -63.78,
        -63.79, -63.74, -63.69, -63.65, -63.64, -63.69, -63.74, -63.73, -63.73, -63.79,
        -63.81, -63.75, -63.72, -63.72, -63.70, -63.71, -63.64, -63.63, -63.54, -63.53,
        -63.49, -63.46, -63.43, -63.35, -63.25, -63.32, -63.29, -63.34, -63.43, -63.43,
        -63.29, -63.30, -63.21, -63.18, -63.08, -63.01, -62.95, -62.96, -62.84, -62.83,
        -62.84, -62.79, -62.72, -62.69, -62.64, -62.50, -62.45, -62.46, -62.47, -62.45,
        -62.39, -62.30, -62.34, -62.33, -62.25, -62.11, -62.06, -62.01, -61.90, -61.89,
        -61.77, -61.65, -61.65, -61.54, -61.47, -61.44, -61.46, -61.48
    };

    static const float fletcher_munson_curve_30_phons[1383] =
    {
        -12.16, -12.18, -12.19, -12.23, -12.29,
        -12.38, -12.41, -12.47, -12.48, -12.57, -12.59, -12.66, -12.68, -12.72, -12.75,
        -12.75, -12.79, -12.79, -12.85, -12.88, -12.91, -12.94, -12.99, -13.03, -13.07,
        -13.10, -13.12, -13.19, -13.21, -13.25, -13.31, -13.33, -13.39, -13.44, -13.50,
        -13.48, -13.58, -13.65, -13.70, -13.75, -13.80, -13.82, -13.84, -13.90, -13.91,
        -13.99, -14.09, -14.10, -14.17, -14.22, -14.29, -14.34, -14.41, -14.48, -14.54,
        -14.57, -14.64, -14.69, -14.77, -14.84, -14.84, -14.94, -14.90, -14.89, -14.92,
        -14.93, -14.97, -14.97, -15.02, -15.02, -15.11, -15.12, -15.16, -15.24, -15.25,
        -15.26, -15.36, -15.36, -15.37, -15.47, -15.44, -15.51, -15.59, -15.63, -15.71,
        -15.71, -15.78, -15.84, -15.93, -15.95, -15.99, -16.02, -16.06, -16.11, -16.15,
        -16.20, -16.20, -16.23, -16.28, -16.30, -16.33, -16.38, -16.41, -16.49, -16.52,
        -16.52, -16.58, -16.61, -16.61, -16.69, -16.71, -16.78, -16.84, -16.80, -16.88,
        -16.98, -16.98, -16.99, -17.01, -17.10, -17.09, -17.14, -17.23, -17.20, -17.28,
        -17.38, -17.40, -17.44, -17.52, -17.60, -17.60, -17.69, -17.72, -17.77, -17.77,
        -17.82, -17.86, -17.90, -17.94, -17.96, -18.03, -18.05, -18.15, -18.17, -18.22,
        -18.31, -18.38, -18.46, -18.56, -18.65, -18.71, -18.78, -18.80, -18.84, -18.85,
        -18.89, -18.93, -18.97, -19.03, -19.03, -19.09, -19.16, -19.23, -19.33, -19.41,
        -19.46, -19.52, -19.60, -19.66, -19.69, -19.76, -19.83, -19.85, -19.90, -19.97,
        -20.02, -20.07, -20.10, -20.15, -20.22, -20.32, -20.40, -20.46, -20.42, -20.50,
        -20.57, -20.65, -20.64, -20.68, -20.78, -20.87, -20.87, -20.90, -20.99, -21.04,
        -21.05, -21.12, -21.22, -21.30, -21.40, -21.49, -21.55, -21.64, -21.70, -21.75,
        -21.85, -21.89, -21.91, -22.00, -22.08, -22.08, -22.15, -22.23, -22.28, -22.28,
        -22.37, -22.42, -22.51, -22.49, -22.57, -22.62, -22.69, -22.70, -22.74, -22.79,
        -22.77, -22.83, -22.86, -22.95, -22.97, -23.02, -23.05, -23.14, -23.20, -23.19,
        -23.25, -23.32, -23.33, -23.38, -23.46, -23.51, -23.64, -23.72, -23.79, -23.89,
        -23.98, -24.08, -24.15, -24.24, -24.33, -24.42, -24.51, -24.60, -24.66, -24.76,
        -24.84, -24.91, -24.99, -25.00, -25.06, -25.13, -25.13, -25.21, -25.31, -25.41,
        -25.53, -25.61, -25.71, -25.79, -25.85, -25.92, -26.02, -26.08, -26.16, -26.21,
        -26.21, -26.27, -26.37, -26.43, -26.42, -26.50, -26.60, -26.68, -26.77, -26.83,
        -26.90, -27.01, -27.08, -27.17, -27.23, -27.31, -27.40, -27.47, -27.59, -27.69,
        -27.81, -27.92, -27.93, -28.01, -28.02, -28.10, -28.18, -28.21, -28.22, -28.28,
        -28.27, -28.28, -28.31, -28.30, -28.39, -28.49, -28.54, -28.64, -28.73, -28.81,
        -28.88, -28.87, -28.96, -29.02, -29.01, -29.04, -29.11, -29.11, -29.17, -29.27,
        -29.33, -29.34, -29.44, -29.54, -29.63, -29.70, -29.76, -29.82, -29.89, -29.94,
        -30.01, -30.05, -30.05, -30.13, -30.16, -30.17, -30.27, -30.36, -30.42, -30.49,
        -30.53, -30.54, -30.59, -30.70, -30.73, -30.75, -30.82, -30.88, -30.92, -30.95,
        -31.00, -31.01, -31.09, -31.15, -31.22, -31.27, -31.28, -31.35, -31.42, -31.53,
        -31.63, -31.69, -31.79, -31.89, -31.99, -32.07, -32.14, -32.23, -32.28, -32.32,
        -32.39, -32.48, -32.52, -32.59, -32.65, -32.71, -32.79, -32.84, -32.92, -32.98,
        -33.05, -33.12, -33.18, -33.24, -33.20, -33.28, -33.36, -33.38, -33.38, -33.46,
        -33.52, -33.59, -33.66, -33.73, -33.82, -33.90, -33.98, -34.06, -34.17, -34.25,
        -34.23, -34.28, -34.36, -34.34, -34.44, -34.51, -34.53, -34.60, -34.67, -34.73,
        -34.79, -34.85, -34.93, -35.00, -35.03, -35.11, -35.20, -35.26, -35.26, -35.35,
        -35.46, -35.53, -35.60, -35.65, -35.71, -35.80, -35.86, -35.92, -35.99, -36.07,
        -36.14, -36.21, -36.29, -36.38, -36.47, -36.56, -36.64, -36.64, -36.73, -36.79,
        -36.82, -36.92, -36.99, -37.04, -37.13, -37.20, -37.28, -37.36, -37.41, -37.49,
        -37.58, -37.65, -37.69, -37.79, -37.86, -37.94, -38.02, -38.07, -38.13, -38.20,
        -38.28, -38.35, -38.43, -38.48, -38.55, -38.63, -38.70, -38.78, -38.91, -38.98,
        -39.07, -39.17, -39.23, -39.30, -39.33, -39.36, -39.44, -39.45, -39.48, -39.53,
        -39.59, -39.63, -39.68, -39.74, -39.81, -39.90, -39.99, -40.08, -40.16, -40.26,
        -40.33, -40.35, -40.42, -40.50, -40.57, -40.60, -40.69, -40.77, -40.82, -40.86,
        -40.95, -41.01, -41.04, -41.12, -41.19, -41.26, -41.29, -41.36, -41.43, -41.51,
        -41.47, -41.53, -41.60, -41.67, -41.74, -41.75, -41.75, -41.84, -41.90, -41.98,
        -42.05, -42.15, -42.23, -42.30, -42.37, -42.43, -42.48, -42.54, -42.60, -42.65,
        -42.73, -42.80, -42.84, -42.93, -43.03, -43.10, -43.18, -43.25, -43.34, -43.42,
        -43.47, -43.51, -43.59, -43.64, -43.67, -43.75, -43.84, -43.89, -43.94, -44.03,
        -44.12, -44.17, -44.24, -44.29, -44.33, -44.42, -44.48, -44.55, -44.59, -44.65,
        -44.72, -44.77, -44.86, -44.87, -44.97, -45.04, -45.09, -45.16, -45.21, -45.30,
        -45.35, -45.45, -45.50, -45.57, -45.63, -45.70, -45.74, -45.82, -45.84, -45.92,
        -45.96, -46.04, -46.11, -46.16, -46.25, -46.32, -46.39, -46.46, -46.53, -46.58,
        -46.62, -46.68, -46.74, -46.80, -46.87, -46.94, -47.00, -47.08, -47.14, -47.22,
        -47.30, -47.38, -47.45, -47.51, -47.57, -47.62, -47.65, -47.70, -47.75, -47.81,
        -47.83, -47.91, -47.99, -48.06, -48.12, -48.21, -48.31, -48.39, -48.49, -48.54,
        -48.59, -48.67, -48.72, -48.78, -48.83, -48.89, -48.96, -49.01, -49.09, -49.13,
        -49.22, -49.25, -49.32, -49.37, -49.43, -49.47, -49.55, -49.58, -49.63, -49.69,
        -49.77, -49.80, -49.83, -49.89, -49.94, -49.98, -50.05, -50.09, -50.17, -50.20,
        -50.24, -50.27, -50.35, -50.37, -50.40, -50.43, -50.50, -50.52, -50.58, -50.65,
        -50.70, -50.73, -50.77, -50.82, -50.88, -50.94, -50.97, -50.97, -50.99, -51.06,
        -51.09, -51.11, -51.15, -51.20, -51.24, -51.26, -51.33, -51.35, -51.39, -51.44,
        -51.46, -51.51, -51.53, -51.56, -51.61, -51.62, -51.67, -51.68, -51.74, -51.75,
        -51.78, -51.82, -51.84, -51.83, -51.87, -51.87, -51.92, -51.92, -51.97, -51.97,
        -52.06, -52.09, -52.11, -52.12, -52.19, -52.20, -52.22, -52.22, -52.26, -52.26,
        -52.29, -52.31, -52.32, -52.36, -52.37, -52.41, -52.42, -52.43, -52.48, -52.51,
        -52.53, -52.60, -52.57, -52.61, -52.63, -52.65, -52.67, -52.69, -52.69, -52.71,
        -52.70, -52.70, -52.73, -52.73, -52.74, -52.80, -52.81, -52.86, -52.85, -52.89,
        -52.96, -53.02, -53.08, -53.12, -53.13, -53.13, -53.13, -53.14, -53.16, -53.19,
        -53.20, -53.24, -53.26, -53.26, -53.26, -53.26, -53.27, -53.27, -53.27, -53.27,
        -53.27, -53.28, -53.27, -53.25, -53.25, -53.23, -53.23, -53.23, -53.20, -53.20,
        -53.18, -53.18, -53.13, -53.12, -53.12, -53.11, -53.11, -53.11, -53.11, -53.11,
        -53.10, -53.11, -53.13, -53.13, -53.13, -53.08, -53.05, -53.02, -53.01, -53.01,
        -52.98, -52.95, -52.93, -52.89, -52.89, -52.86, -52.84, -52.87, -52.81, -52.78,
        -52.77, -52.77, -52.76, -52.76, -52.76, -52.75, -52.77, -52.67, -52.65, -52.66,
        -52.67, -52.57, -52.56, -52.55, -52.56, -52.57, -52.57, -52.59, -52.59, -52.57,
        -52.57, -52.51, -52.45, -52.46, -52.36, -52.36, -52.36, -52.36, -52.36, -52.36,
        -52.36, -52.38, -52.37, -52.36, -52.37, -52.36, -52.36, -52.36, -52.36, -52.36,
        -52.37, -52.32, -52.33, -52.37, -52.33, -52.35, -52.42, -52.42, -52.42, -52.42,
        -52.42, -52.41, -52.42, -52.42, -52.41, -52.42, -52.41, -52.42, -52.44, -52.42,
        -52.43, -52.45, -52.46, -52.47, -52.42, -52.39, -52.41, -52.38, -52.35, -52.36,
        -52.37, -52.38, -52.39, -52.40, -52.42, -52.45, -52.46, -52.48, -52.48, -52.48,
        -52.52, -52.52, -52.51, -52.47, -52.47, -52.42, -52.44, -52.49, -52.57, -52.62,
        -52.64, -52.67, -52.68, -52.58, -52.60, -52.67, -52.63, -52.61, -52.63, -52.66,
        -52.68, -52.70, -52.73, -52.75, -52.79, -52.77, -52.74, -52.77, -52.77, -52.77,
        -52.81, -52.83, -52.89, -52.92, -52.88, -52.91, -52.99, -53.04, -53.01, -53.03,
        -53.03, -53.09, -53.10, -53.11, -53.12, -53.05, -53.02, -53.08, -53.09, -53.16,
        -53.19, -53.23, -53.26, -53.33, -53.35, -53.34, -53.33, -53.38, -53.32, -53.38,
        -53.35, -53.36, -53.39, -53.35, -53.38, -53.31, -53.35, -53.36, -53.36, -53.37,
        -53.39, -53.42, -53.43, -53.44, -53.50, -53.45, -53.46, -53.49, -53.47, -53.51,
        -53.58, -53.63, -53.68, -53.73, -53.76, -53.78, -53.76, -53.78, -53.78, -53.77,
        -53.77, -53.80, -53.78, -53.79, -53.79, -53.75, -53.79, -53.79, -53.77, -53.85,
        -53.84, -53.84, -53.87, -53.83, -53.79, -53.79, -53.80, -53.85, -53.82, -53.82,
        -53.78, -53.75, -53.70, -53.65, -53.61, -53.61, -53.56, -53.57, -53.57, -53.51,
        -53.47, -53.43, -53.40, -53.31, -53.32, -53.23, -53.13, -53.03, -53.04, -52.98,
        -52.88, -52.88, -52.83, -52.78, -52.78, -52.72, -52.70, -52.70, -52.65, -52.64,
        -52.68, -52.59, -52.64, -52.62, -52.57, -52.56, -52.50, -52.50, -52.48, -52.43,
        -52.38, -52.39, -52.37, -52.35, -52.32, -52.29, -52.27, -52.25, -52.20, -52.16,
        -52.15, -52.11, -52.05, -52.04, -51.95, -51.91, -51.85, -51.79, -51.80, -51.81,
        -51.81, -51.80, -51.81, -51.82, -51.72, -51.72, -51.71, -51.60, -51.60, -51.60,
        -51.62, -51.61, -51.62, -51.62, -51.63, -51.61, -51.60, -51.60, -51.60, -51.59,
        -51.55, -51.48, -51.48, -51.44, -51.36, -51.34, -51.36, -51.35, -51.35, -51.30,
        -51.30, -51.29, -51.25, -51.25, -51.25, -51.23, -51.23, -51.23, -51.21, -51.16,
        -51.12, -51.12, -51.14, -51.11, -51.10, -51.07, -51.05, -51.06, -51.04, -51.02,
        -50.99, -50.97, -50.96, -50.96, -50.95, -50.93, -50.94, -50.91, -50.93, -50.92,
        -50.94, -50.95, -50.93, -50.98, -50.96, -50.95, -50.97, -50.96, -50.90, -50.85,
        -50.84, -50.85, -50.90, -50.89, -50.91, -50.89, -50.88, -51.02, -50.97, -50.93,
        -50.89, -50.84, -51.02, -51.00, -50.99, -51.06, -51.08, -51.09, -51.11, -51.24,
        -51.27, -51.22, -51.29, -51.33, -51.40, -51.52, -51.60, -51.61, -51.68, -51.82,
        -51.85, -51.86, -51.83, -51.90, -51.94, -51.97, -52.00, -52.03, -52.10, -52.18,
        -52.27, -52.15, -52.26, -52.31, -52.28, -52.20, -52.13, -52.22, -52.32, -52.33,
        -52.39, -52.35, -52.39, -52.41, -52.68, -52.60, -52.53, -52.53, -52.85, -52.80,
        -52.79, -52.82, -52.86, -52.92, -52.97, -52.96, -52.94, -52.94, -52.99, -52.97,
        -52.95, -52.99, -52.92, -52.92, -52.94, -52.94, -52.91, -52.89, -52.89, -52.92,
        -52.90, -52.85, -52.85, -52.80, -52.76, -52.74, -52.74, -52.70, -52.64, -52.62,
        -52.60, -52.56, -52.58, -52.55, -52.58, -52.53, -52.58, -52.55, -52.56, -52.55,
        -52.59, -52.57, -52.55, -52.48, -52.49, -52.47, -52.48, -52.51, -52.47, -52.43,
        -52.39, -52.34, -52.30, -52.25, -52.30, -52.25, -52.26, -52.31, -52.28, -52.26,
        -52.23, -52.21, -52.19, -52.17, -52.15, -52.13, -52.12, -52.09, -52.07, -52.06,
        -52.01, -52.09, -52.09, -52.10, -52.15, -52.13, -52.08, -52.06, -52.03, -52.01,
        -52.02, -52.04, -52.07, -52.08, -52.07, -52.03, -52.00, -51.96, -51.94, -51.94,
        -51.96, -51.99, -52.01, -52.04, -52.04, -52.04, -52.04, -52.04, -52.04, -52.04,
        -52.04, -52.06, -52.09, -52.12, -52.15, -52.15, -52.16, -52.16, -52.18, -52.18,
        -52.21, -52.21, -52.20, -52.26, -52.26, -52.30, -52.36, -52.36, -52.41, -52.40,
        -52.42, -52.41, -52.49, -52.48, -52.54, -52.57, -52.57, -52.55, -52.60, -52.65,
        -52.67, -52.67, -52.66, -52.63, -52.64, -52.68, -52.73, -52.70, -52.71, -52.79,
        -52.82, -52.78, -52.75, -52.72, -52.72, -52.75, -52.71, -52.69, -52.61, -52.58,
        -52.53, -52.51, -52.50, -52.45, -52.38, -52.45, -52.45, -52.50, -52.56, -52.53,
        -52.47, -52.47, -52.38, -52.34, -52.27, -52.23, -52.21, -52.18, -52.09, -52.10,
        -52.13, -52.06, -52.00, -51.96, -51.90, -51.82, -51.74, -51.75, -51.78, -51.78,
        -51.76, -51.70, -51.71, -51.66, -51.61, -51.54, -51.49, -51.46, -51.38, -51.36,
        -51.26, -51.14, -51.09, -50.97, -50.93, -50.87, -50.84, -50.86
    };

    static const float fletcher_munson_curve_40_phons[1383] =
    {
        -9.16, -9.17, -9.18, -9.19, -9.22,
        -9.30, -9.32, -9.37, -9.37, -9.46, -9.48, -9.50, -9.51, -9.56, -9.61,
        -9.58, -9.62, -9.58, -9.63, -9.67, -9.71, -9.72, -9.77, -9.75, -9.76,
        -9.76, -9.76, -9.81, -9.80, -9.81, -9.83, -9.81, -9.85, -9.90, -9.94,
        -9.94, -10.00, -10.05, -10.10, -10.15, -10.19, -10.18, -10.20, -10.28, -10.28,
        -10.34, -10.44, -10.44, -10.50, -10.55, -10.60, -10.64, -10.71, -10.78, -10.83,
        -10.84, -10.92, -10.97, -11.04, -11.08, -11.05, -11.15, -11.08, -11.10, -11.12,
        -11.10, -11.13, -11.14, -11.18, -11.18, -11.28, -11.24, -11.28, -11.38, -11.40,
        -11.38, -11.48, -11.48, -11.50, -11.58, -11.58, -11.68, -11.73, -11.78, -11.88,
        -11.88, -11.97, -11.98, -12.08, -12.11, -12.17, -12.19, -12.22, -12.28, -12.33,
        -12.37, -12.37, -12.38, -12.42, -12.42, -12.42, -12.46, -12.44, -12.52, -12.51,
        -12.52, -12.57, -12.58, -12.58, -12.63, -12.65, -12.71, -12.80, -12.74, -12.82,
        -12.91, -12.91, -12.95, -12.96, -13.06, -13.05, -13.10, -13.18, -13.15, -13.24,
        -13.34, -13.37, -13.42, -13.48, -13.54, -13.54, -13.62, -13.67, -13.72, -13.69,
        -13.72, -13.77, -13.81, -13.84, -13.83, -13.90, -13.92, -14.02, -14.01, -14.07,
        -14.16, -14.23, -14.31, -14.41, -14.47, -14.52, -14.57, -14.58, -14.61, -14.63,
        -14.66, -14.66, -14.69, -14.73, -14.72, -14.80, -14.83, -14.92, -15.01, -15.11,
        -15.17, -15.23, -15.30, -15.39, -15.44, -15.51, -15.57, -15.59, -15.63, -15.70,
        -15.74, -15.75, -15.81, -15.87, -15.90, -16.00, -16.06, -16.11, -16.11, -16.16,
        -16.21, -16.31, -16.29, -16.32, -16.42, -16.51, -16.49, -16.52, -16.61, -16.64,
        -16.64, -16.72, -16.81, -16.84, -16.92, -17.01, -17.04, -17.12, -17.17, -17.23,
        -17.31, -17.32, -17.32, -17.41, -17.46, -17.44, -17.52, -17.57, -17.62, -17.62,
        -17.71, -17.73, -17.81, -17.81, -17.89, -17.91, -17.98, -18.00, -18.04, -18.07,
        -18.04, -18.12, -18.14, -18.23, -18.23, -18.24, -18.26, -18.32, -18.39, -18.38,
        -18.43, -18.50, -18.48, -18.52, -18.58, -18.63, -18.77, -18.84, -18.88, -18.98,
        -19.08, -19.17, -19.23, -19.33, -19.42, -19.50, -19.58, -19.65, -19.68, -19.78,
        -19.86, -19.89, -19.97, -19.97, -20.02, -20.11, -20.11, -20.21, -20.31, -20.41,
        -20.55, -20.63, -20.75, -20.84, -20.89, -20.95, -21.04, -21.06, -21.16, -21.21,
        -21.19, -21.25, -21.35, -21.40, -21.39, -21.45, -21.55, -21.64, -21.74, -21.78,
        -21.86, -21.96, -22.01, -22.11, -22.15, -22.21, -22.31, -22.37, -22.46, -22.56,
        -22.65, -22.75, -22.74, -22.83, -22.84, -22.92, -23.00, -23.03, -23.05, -23.08,
        -23.06, -23.03, -23.06, -23.03, -23.12, -23.21, -23.22, -23.32, -23.41, -23.49,
        -23.56, -23.54, -23.62, -23.66, -23.62, -23.67, -23.72, -23.72, -23.75, -23.84,
        -23.92, -23.93, -24.03, -24.13, -24.22, -24.27, -24.33, -24.39, -24.43, -24.49,
        -24.56, -24.58, -24.57, -24.63, -24.66, -24.62, -24.72, -24.80, -24.83, -24.88,
        -24.89, -24.84, -24.87, -24.97, -25.00, -24.99, -25.07, -25.13, -25.18, -25.22,
        -25.27, -25.27, -25.35, -25.39, -25.44, -25.47, -25.46, -25.50, -25.56, -25.66,
        -25.76, -25.80, -25.90, -25.99, -26.10, -26.19, -26.30, -26.39, -26.44, -26.48,
        -26.57, -26.65, -26.68, -26.77, -26.84, -26.87, -26.96, -27.01, -27.08, -27.12,
        -27.18, -27.23, -27.28, -27.33, -27.27, -27.33, -27.38, -27.41, -27.38, -27.45,
        -27.51, -27.57, -27.62, -27.67, -27.77, -27.83, -27.89, -27.97, -28.07, -28.15,
        -28.12, -28.16, -28.24, -28.19, -28.28, -28.37, -28.39, -28.43, -28.49, -28.54,
        -28.60, -28.66, -28.73, -28.80, -28.83, -28.91, -28.98, -29.05, -29.04, -29.13,
        -29.25, -29.34, -29.42, -29.47, -29.51, -29.59, -29.68, -29.73, -29.78, -29.83,
        -29.88, -29.93, -29.99, -30.08, -30.15, -30.20, -30.27, -30.27, -30.36, -30.41,
        -30.43, -30.51, -30.55, -30.65, -30.74, -30.78, -30.84, -30.95, -30.99, -31.05,
        -31.14, -31.19, -31.25, -31.35, -31.40, -31.46, -31.55, -31.57, -31.63, -31.67,
        -31.74, -31.77, -31.86, -31.89, -31.98, -32.03, -32.08, -32.14, -32.24, -32.30,
        -32.34, -32.43, -32.47, -32.52, -32.53, -32.52, -32.59, -32.56, -32.58, -32.59,
        -32.63, -32.65, -32.69, -32.73, -32.78, -32.88, -32.97, -33.07, -33.08, -33.18,
        -33.23, -33.27, -33.32, -33.38, -33.43, -33.49, -33.56, -33.62, -33.67, -33.72,
        -33.78, -33.82, -33.87, -33.92, -33.97, -34.02, -34.07, -34.12, -34.17, -34.25,
        -34.17, -34.26, -34.32, -34.37, -34.42, -34.42, -34.42, -34.51, -34.54, -34.62,
        -34.65, -34.73, -34.79, -34.86, -34.91, -34.98, -35.03, -35.09, -35.14, -35.18,
        -35.24, -35.29, -35.35, -35.42, -35.51, -35.56, -35.63, -35.67, -35.72, -35.78,
        -35.81, -35.89, -35.93, -35.98, -36.02, -36.08, -36.17, -36.25, -36.27, -36.36,
        -36.45, -36.47, -36.54, -36.59, -36.59, -36.68, -36.69, -36.74, -36.79, -36.84,
        -36.89, -36.90, -36.99, -37.00, -37.09, -37.14, -37.15, -37.24, -37.25, -37.33,
        -37.34, -37.43, -37.44, -37.49, -37.55, -37.60, -37.65, -37.73, -37.76, -37.85,
        -37.87, -37.96, -38.04, -38.06, -38.16, -38.25, -38.29, -38.33, -38.38, -38.38,
        -38.42, -38.48, -38.54, -38.61, -38.68, -38.74, -38.78, -38.87, -38.96, -39.02,
        -39.08, -39.17, -39.24, -39.31, -39.35, -39.38, -39.40, -39.45, -39.49, -39.52,
        -39.56, -39.62, -39.68, -39.73, -39.79, -39.85, -39.91, -39.99, -40.09, -40.15,
        -40.23, -40.31, -40.39, -40.46, -40.48, -40.54, -40.58, -40.60, -40.67, -40.68,
        -40.77, -40.78, -40.87, -40.88, -40.94, -40.98, -41.06, -41.11, -41.11, -41.15,
        -41.27, -41.29, -41.29, -41.38, -41.38, -41.42, -41.48, -41.48, -41.54, -41.59,
        -41.59, -41.59, -41.68, -41.68, -41.68, -41.69, -41.78, -41.78, -41.84, -41.91,
        -41.96, -42.01, -42.01, -42.10, -42.14, -42.19, -42.23, -42.20, -42.20, -42.29,
        -42.30, -42.30, -42.32, -42.39, -42.40, -42.41, -42.49, -42.49, -42.54, -42.58,
        -42.58, -42.58, -42.59, -42.60, -42.60, -42.62, -42.63, -42.64, -42.68, -42.69,
        -42.70, -42.73, -42.74, -42.71, -42.73, -42.74, -42.75, -42.75, -42.75, -42.75,
        -42.83, -42.84, -42.84, -42.85, -42.95, -42.95, -42.95, -42.95, -42.95, -42.95,
        -42.95, -42.95, -42.95, -42.95, -42.96, -42.96, -42.97, -42.98, -42.98, -43.01,
        -43.03, -43.05, -43.03, -43.04, -43.04, -43.04, -43.03, -43.03, -43.03, -43.03,
        -43.00, -42.99, -42.98, -42.98, -42.99, -43.00, -43.01, -43.02, -43.01, -43.03,
        -43.12, -43.13, -43.22, -43.22, -43.24, -43.24, -43.25, -43.25, -43.25, -43.27,
        -43.28, -43.29, -43.32, -43.33, -43.33, -43.34, -43.36, -43.36, -43.36, -43.36,
        -43.36, -43.37, -43.36, -43.32, -43.32, -43.28, -43.28, -43.28, -43.22, -43.22,
        -43.18, -43.18, -43.13, -43.12, -43.12, -43.11, -43.11, -43.11, -43.11, -43.11,
        -43.10, -43.11, -43.11, -43.11, -43.11, -43.05, -43.01, -43.00, -42.99, -42.99,
        -42.96, -42.93, -42.91, -42.92, -42.96, -42.93, -42.91, -42.96, -42.90, -42.87,
        -42.87, -42.87, -42.87, -42.87, -42.87, -42.88, -42.90, -42.80, -42.77, -42.77,
        -42.77, -42.67, -42.68, -42.67, -42.67, -42.69, -42.70, -42.72, -42.71, -42.66,
        -42.66, -42.60, -42.53, -42.55, -42.45, -42.45, -42.45, -42.45, -42.45, -42.45,
        -42.45, -42.45, -42.40, -42.32, -42.29, -42.26, -42.26, -42.26, -42.26, -42.27,
        -42.28, -42.23, -42.22, -42.23, -42.19, -42.19, -42.24, -42.24, -42.24, -42.24,
        -42.24, -42.23, -42.20, -42.19, -42.18, -42.15, -42.13, -42.13, -42.12, -42.10,
        -42.09, -42.09, -42.08, -42.08, -42.03, -41.98, -41.98, -41.93, -41.87, -41.87,
        -41.85, -41.84, -41.82, -41.81, -41.82, -41.82, -41.82, -41.82, -41.82, -41.83,
        -41.82, -41.81, -41.81, -41.79, -41.70, -41.64, -41.64, -41.69, -41.73, -41.79,
        -41.82, -41.82, -41.81, -41.71, -41.76, -41.80, -41.77, -41.79, -41.79, -41.80,
        -41.83, -41.83, -41.83, -41.88, -41.92, -41.90, -41.87, -41.91, -41.88, -41.88,
        -41.90, -41.90, -41.98, -41.98, -41.96, -41.97, -42.06, -42.10, -42.06, -42.09,
        -42.09, -42.18, -42.18, -42.18, -42.21, -42.13, -42.08, -42.16, -42.18, -42.28,
        -42.30, -42.35, -42.39, -42.44, -42.48, -42.43, -42.46, -42.47, -42.39, -42.46,
        -42.41, -42.42, -42.45, -42.38, -42.45, -42.38, -42.39, -42.40, -42.40, -42.41,
        -42.42, -42.42, -42.42, -42.42, -42.47, -42.45, -42.42, -42.46, -42.46, -42.50,
        -42.59, -42.65, -42.70, -42.74, -42.80, -42.85, -42.85, -42.85, -42.85, -42.85,
        -42.86, -42.85, -42.82, -42.82, -42.78, -42.74, -42.77, -42.76, -42.72, -42.77,
        -42.73, -42.74, -42.78, -42.73, -42.70, -42.69, -42.70, -42.78, -42.77, -42.78,
        -42.72, -42.71, -42.65, -42.62, -42.58, -42.58, -42.53, -42.53, -42.54, -42.48,
        -42.45, -42.40, -42.35, -42.25, -42.22, -42.12, -42.01, -41.92, -41.92, -41.86,
        -41.77, -41.76, -41.71, -41.66, -41.66, -41.60, -41.56, -41.56, -41.49, -41.47,
        -41.47, -41.39, -41.47, -41.44, -41.38, -41.37, -41.31, -41.36, -41.31, -41.26,
        -41.22, -41.20, -41.17, -41.15, -41.11, -41.08, -41.04, -41.02, -40.97, -40.93,
        -40.92, -40.88, -40.82, -40.81, -40.72, -40.67, -40.61, -40.56, -40.56, -40.56,
        -40.56, -40.56, -40.57, -40.59, -40.50, -40.49, -40.49, -40.39, -40.39, -40.39,
        -40.38, -40.36, -40.37, -40.39, -40.39, -40.39, -40.38, -40.38, -40.39, -40.37,
        -40.32, -40.25, -40.24, -40.20, -40.13, -40.08, -40.12, -40.12, -40.12, -40.11,
        -40.11, -40.11, -40.11, -40.11, -40.11, -40.06, -40.07, -40.06, -40.04, -39.98,
        -39.98, -39.99, -40.02, -40.00, -39.98, -39.97, -39.96, -39.98, -39.97, -39.94,
        -39.88, -39.87, -39.89, -39.87, -39.87, -39.86, -39.87, -39.84, -39.83, -39.86,
        -39.87, -39.92, -39.92, -39.97, -39.97, -39.97, -40.01, -39.99, -39.95, -39.89,
        -39.86, -39.87, -39.90, -39.88, -39.89, -39.87, -39.86, -40.00, -39.98, -39.96,
        -39.92, -39.86, -40.10, -40.08, -40.09, -40.17, -40.14, -40.14, -40.11, -40.22,
        -40.17, -40.10, -40.15, -40.24, -40.34, -40.46, -40.56, -40.58, -40.69, -40.84,
        -40.88, -40.90, -40.88, -40.94, -40.96, -40.98, -41.02, -41.00, -41.03, -41.08,
        -41.17, -40.98, -41.08, -41.10, -41.11, -41.06, -41.03, -41.08, -41.16, -41.14,
        -41.17, -41.18, -41.21, -41.24, -41.49, -41.41, -41.36, -41.36, -41.68, -41.63,
        -41.63, -41.63, -41.72, -41.73, -41.82, -41.82, -41.77, -41.73, -41.77, -41.73,
        -41.70, -41.69, -41.60, -41.61, -41.64, -41.68, -41.68, -41.68, -41.69, -41.73,
        -41.71, -41.68, -41.67, -41.61, -41.57, -41.55, -41.55, -41.52, -41.47, -41.41,
        -41.41, -41.35, -41.37, -41.32, -41.35, -41.28, -41.32, -41.25, -41.25, -41.25,
        -41.27, -41.27, -41.27, -41.17, -41.22, -41.19, -41.22, -41.27, -41.23, -41.18,
        -41.13, -41.08, -41.08, -41.00, -41.05, -40.97, -40.99, -41.01, -40.99, -40.96,
        -40.93, -40.93, -40.92, -40.90, -40.90, -40.87, -40.84, -40.84, -40.84, -40.82,
        -40.80, -40.86, -40.86, -40.85, -40.87, -40.83, -40.78, -40.78, -40.78, -40.78,
        -40.78, -40.81, -40.83, -40.85, -40.81, -40.77, -40.74, -40.70, -40.71, -40.71,
        -40.73, -40.76, -40.78, -40.80, -40.81, -40.81, -40.81, -40.81, -40.81, -40.81,
        -40.81, -40.85, -40.90, -40.95, -41.00, -41.01, -41.02, -41.02, -41.02, -41.02,
        -41.02, -41.02, -41.02, -41.07, -41.07, -41.12, -41.17, -41.17, -41.22, -41.21,
        -41.21, -41.22, -41.30, -41.33, -41.39, -41.42, -41.44, -41.42, -41.47, -41.52,
        -41.55, -41.60, -41.62, -41.61, -41.64, -41.68, -41.73, -41.67, -41.68, -41.78,
        -41.83, -41.81, -41.78, -41.73, -41.73, -41.79, -41.77, -41.76, -41.67, -41.63,
        -41.58, -41.57, -41.56, -41.55, -41.52, -41.58, -41.60, -41.67, -41.68, -41.64,
        -41.65, -41.65, -41.55, -41.49, -41.46, -41.46, -41.46, -41.40, -41.33, -41.36,
        -41.42, -41.32, -41.27, -41.23, -41.16, -41.13, -41.02, -41.04, -41.10, -41.12,
        -41.12, -41.10, -41.07, -41.00, -40.97, -40.97, -40.93, -40.91, -40.86, -40.83,
        -40.76, -40.63, -40.53, -40.40, -40.38, -40.30, -40.23, -40.24
    };

    static const float fletcher_munson_curve_50_phons[1383] =
    {
        -7.17, -7.18, -7.19, -7.21, -7.21,
        -7.29, -7.31, -7.33, -7.34, -7.43, -7.40, -7.45, -7.47, -7.49, -7.53,
        -7.54, -7.55, -7.54, -7.60, -7.61, -7.64, -7.64, -7.67, -7.65, -7.65,
        -7.66, -7.64, -7.68, -7.66, -7.67, -7.67, -7.66, -7.68, -7.70, -7.77,
        -7.75, -7.81, -7.85, -7.89, -7.91, -7.98, -7.97, -7.96, -8.03, -8.03,
        -8.06, -8.15, -8.14, -8.21, -8.22, -8.28, -8.31, -8.36, -8.41, -8.46,
        -8.47, -8.53, -8.57, -8.64, -8.69, -8.67, -8.75, -8.67, -8.69, -8.68,
        -8.67, -8.69, -8.68, -8.74, -8.72, -8.79, -8.77, -8.79, -8.87, -8.90,
        -8.89, -8.97, -8.95, -8.98, -9.07, -9.05, -9.12, -9.17, -9.23, -9.30,
        -9.27, -9.35, -9.38, -9.45, -9.47, -9.53, -9.53, -9.55, -9.59, -9.61,
        -9.67, -9.65, -9.68, -9.70, -9.70, -9.70, -9.72, -9.75, -9.79, -9.81,
        -9.78, -9.83, -9.84, -9.82, -9.87, -9.87, -9.93, -9.99, -9.95, -10.03,
        -10.10, -10.08, -10.10, -10.11, -10.19, -10.16, -10.20, -10.26, -10.23, -10.30,
        -10.37, -10.38, -10.41, -10.47, -10.52, -10.50, -10.56, -10.59, -10.61, -10.59,
        -10.61, -10.67, -10.69, -10.70, -10.72, -10.80, -10.80, -10.87, -10.87, -10.89,
        -10.97, -11.00, -11.07, -11.14, -11.20, -11.25, -11.28, -11.29, -11.32, -11.34,
        -11.35, -11.37, -11.38, -11.43, -11.41, -11.47, -11.49, -11.58, -11.65, -11.73,
        -11.78, -11.81, -11.88, -11.94, -11.97, -12.04, -12.09, -12.10, -12.14, -12.19,
        -12.23, -12.26, -12.29, -12.34, -12.39, -12.47, -12.52, -12.59, -12.56, -12.62,
        -12.68, -12.75, -12.73, -12.76, -12.86, -12.93, -12.93, -12.93, -13.01, -13.05,
        -13.03, -13.09, -13.17, -13.20, -13.28, -13.34, -13.38, -13.44, -13.48, -13.55,
        -13.59, -13.61, -13.60, -13.67, -13.76, -13.75, -13.78, -13.85, -13.88, -13.85,
        -13.92, -13.93, -13.99, -13.97, -14.01, -14.07, -14.10, -14.09, -14.11, -14.12,
        -14.11, -14.17, -14.17, -14.25, -14.24, -14.27, -14.26, -14.31, -14.35, -14.34,
        -14.38, -14.42, -14.43, -14.44, -14.51, -14.54, -14.66, -14.73, -14.77, -14.84,
        -14.92, -15.00, -15.05, -15.13, -15.20, -15.26, -15.34, -15.39, -15.43, -15.51,
        -15.55, -15.62, -15.66, -15.64, -15.68, -15.75, -15.73, -15.80, -15.88, -15.96,
        -16.08, -16.13, -16.23, -16.28, -16.33, -16.38, -16.48, -16.49, -16.59, -16.62,
        -16.62, -16.65, -16.74, -16.78, -16.76, -16.80, -16.89, -16.95, -17.04, -17.08,
        -17.15, -17.25, -17.31, -17.38, -17.40, -17.48, -17.54, -17.57, -17.66, -17.71,
        -17.78, -17.85, -17.83, -17.90, -17.91, -17.96, -18.03, -18.03, -18.04, -18.08,
        -18.04, -18.03, -18.02, -18.02, -18.08, -18.17, -18.18, -18.27, -18.33, -18.41,
        -18.45, -18.44, -18.50, -18.54, -18.51, -18.56, -18.61, -18.58, -18.62, -18.73,
        -18.79, -18.79, -18.88, -18.97, -19.02, -19.09, -19.12, -19.19, -19.23, -19.25,
        -19.34, -19.34, -19.30, -19.38, -19.37, -19.34, -19.42, -19.49, -19.53, -19.58,
        -19.60, -19.56, -19.57, -19.65, -19.64, -19.65, -19.70, -19.73, -19.75, -19.80,
        -19.82, -19.81, -19.84, -19.91, -19.94, -19.96, -19.96, -19.98, -20.03, -20.11,
        -20.20, -20.25, -20.33, -20.40, -20.49, -20.55, -20.65, -20.70, -20.73, -20.75,
        -20.80, -20.89, -20.90, -20.95, -20.98, -21.03, -21.10, -21.15, -21.23, -21.27,
        -21.33, -21.36, -21.42, -21.46, -21.38, -21.43, -21.47, -21.49, -21.44, -21.50,
        -21.55, -21.60, -21.66, -21.69, -21.79, -21.82, -21.90, -21.94, -22.04, -22.11,
        -22.04, -22.06, -22.10, -22.03, -22.09, -22.16, -22.18, -22.23, -22.30, -22.33,
        -22.39, -22.44, -22.50, -22.55, -22.53, -22.59, -22.65, -22.68, -22.66, -22.73,
        -22.79, -22.83, -22.92, -22.93, -22.95, -23.02, -23.08, -23.11, -23.16, -23.21,
        -23.24, -23.29, -23.34, -23.39, -23.46, -23.50, -23.53, -23.49, -23.54, -23.57,
        -23.57, -23.63, -23.67, -23.75, -23.80, -23.87, -23.90, -24.01, -24.03, -24.11,
        -24.16, -24.21, -24.26, -24.35, -24.39, -24.45, -24.52, -24.58, -24.63, -24.67,
        -24.74, -24.78, -24.85, -24.90, -24.97, -25.02, -25.07, -25.13, -25.23, -25.26,
        -25.33, -25.38, -25.42, -25.46, -25.46, -25.48, -25.52, -25.52, -25.51, -25.54,
        -25.57, -25.57, -25.62, -25.65, -25.68, -25.73, -25.80, -25.86, -25.92, -25.99,
        -26.01, -26.04, -26.06, -26.11, -26.17, -26.20, -26.28, -26.31, -26.36, -26.39,
        -26.47, -26.49, -26.52, -26.58, -26.62, -26.65, -26.69, -26.72, -26.78, -26.81,
        -26.74, -26.80, -26.85, -26.87, -26.90, -26.85, -26.82, -26.91, -26.93, -26.97,
        -26.99, -27.08, -27.11, -27.14, -27.17, -27.21, -27.23, -27.26, -27.28, -27.31,
        -27.39, -27.42, -27.46, -27.54, -27.59, -27.62, -27.66, -27.68, -27.70, -27.78,
        -27.80, -27.83, -27.90, -27.92, -27.94, -28.01, -28.06, -28.12, -28.16, -28.21,
        -28.26, -28.27, -28.30, -28.32, -28.33, -28.37, -28.43, -28.45, -28.50, -28.55,
        -28.59, -28.61, -28.66, -28.69, -28.76, -28.78, -28.80, -28.86, -28.89, -28.93,
        -28.95, -29.03, -29.04, -29.07, -29.14, -29.17, -29.25, -29.32, -29.35, -29.42,
        -29.48, -29.53, -29.58, -29.59, -29.68, -29.73, -29.75, -29.77, -29.80, -29.80,
        -29.82, -29.88, -29.93, -29.98, -30.02, -30.10, -30.13, -30.18, -30.22, -30.30,
        -30.33, -30.38, -30.42, -30.50, -30.52, -30.52, -30.52, -30.60, -30.61, -30.62,
        -30.63, -30.70, -30.75, -30.78, -30.82, -30.90, -30.93, -30.97, -31.07, -31.11,
        -31.17, -31.21, -31.30, -31.33, -31.35, -31.40, -31.45, -31.46, -31.50, -31.53,
        -31.59, -31.60, -31.65, -31.66, -31.70, -31.72, -31.77, -31.81, -31.81, -31.82,
        -31.87, -31.88, -31.88, -31.93, -31.93, -32.00, -32.03, -32.03, -32.11, -32.14,
        -32.14, -32.14, -32.18, -32.18, -32.18, -32.19, -32.23, -32.23, -32.27, -32.32,
        -32.35, -32.37, -32.37, -32.42, -32.46, -32.49, -32.50, -32.47, -32.47, -32.52,
        -32.57, -32.57, -32.58, -32.62, -32.67, -32.68, -32.72, -32.72, -32.74, -32.76,
        -32.76, -32.76, -32.77, -32.77, -32.79, -32.81, -32.82, -32.82, -32.86, -32.88,
        -32.90, -32.92, -32.92, -32.89, -32.92, -32.93, -32.95, -32.95, -32.95, -32.95,
        -33.02, -33.03, -33.03, -33.03, -33.13, -33.13, -33.13, -33.13, -33.13, -33.13,
        -33.13, -33.13, -33.13, -33.14, -33.19, -33.19, -33.22, -33.25, -33.25, -33.29,
        -33.30, -33.33, -33.31, -33.33, -33.33, -33.33, -33.33, -33.33, -33.33, -33.33,
        -33.30, -33.29, -33.26, -33.26, -33.27, -33.28, -33.29, -33.29, -33.29, -33.28,
        -33.36, -33.38, -33.42, -33.41, -33.40, -33.38, -33.39, -33.39, -33.39, -33.39,
        -33.38, -33.38, -33.37, -33.37, -33.37, -33.36, -33.36, -33.37, -33.37, -33.36,
        -33.37, -33.37, -33.36, -33.34, -33.34, -33.32, -33.32, -33.32, -33.27, -33.27,
        -33.25, -33.25, -33.19, -33.17, -33.16, -33.13, -33.13, -33.11, -33.11, -33.11,
        -33.10, -33.11, -33.13, -33.11, -33.11, -33.05, -33.03, -33.00, -32.99, -32.98,
        -32.94, -32.86, -32.84, -32.83, -32.85, -32.82, -32.80, -32.82, -32.76, -32.78,
        -32.78, -32.81, -32.81, -32.81, -32.81, -32.81, -32.82, -32.72, -32.68, -32.68,
        -32.69, -32.60, -32.60, -32.60, -32.59, -32.60, -32.61, -32.60, -32.59, -32.57,
        -32.56, -32.51, -32.45, -32.46, -32.36, -32.36, -32.36, -32.36, -32.36, -32.36,
        -32.36, -32.36, -32.33, -32.29, -32.28, -32.26, -32.26, -32.26, -32.26, -32.27,
        -32.32, -32.27, -32.27, -32.32, -32.28, -32.28, -32.33, -32.33, -32.33, -32.33,
        -32.33, -32.32, -32.29, -32.28, -32.27, -32.24, -32.23, -32.23, -32.21, -32.19,
        -32.18, -32.18, -32.17, -32.17, -32.13, -32.07, -32.07, -32.02, -31.96, -31.96,
        -31.96, -31.97, -31.96, -31.92, -31.91, -31.91, -31.91, -31.91, -31.89, -31.88,
        -31.86, -31.85, -31.85, -31.81, -31.72, -31.65, -31.64, -31.66, -31.68, -31.71,
        -31.73, -31.73, -31.72, -31.62, -31.64, -31.67, -31.62, -31.61, -31.61, -31.61,
        -31.63, -31.63, -31.63, -31.65, -31.67, -31.63, -31.58, -31.59, -31.56, -31.53,
        -31.54, -31.53, -31.57, -31.57, -31.51, -31.52, -31.56, -31.58, -31.53, -31.52,
        -31.52, -31.57, -31.57, -31.56, -31.57, -31.49, -31.44, -31.48, -31.49, -31.54,
        -31.55, -31.57, -31.59, -31.62, -31.62, -31.56, -31.56, -31.57, -31.50, -31.55,
        -31.50, -31.48, -31.50, -31.46, -31.49, -31.41, -31.42, -31.47, -31.47, -31.50,
        -31.53, -31.53, -31.56, -31.56, -31.58, -31.53, -31.50, -31.54, -31.53, -31.54,
        -31.59, -31.67, -31.69, -31.72, -31.77, -31.82, -31.81, -31.82, -31.82, -31.84,
        -31.85, -31.84, -31.84, -31.86, -31.83, -31.79, -31.83, -31.82, -31.79, -31.84,
        -31.82, -31.81, -31.86, -31.82, -31.80, -31.82, -31.85, -31.89, -31.89, -31.89,
        -31.83, -31.83, -31.78, -31.73, -31.71, -31.71, -31.68, -31.69, -31.72, -31.66,
        -31.65, -31.63, -31.59, -31.52, -31.50, -31.44, -31.35, -31.26, -31.28, -31.23,
        -31.13, -31.12, -31.07, -31.02, -31.02, -30.96, -30.94, -30.97, -30.92, -30.92,
        -30.95, -30.88, -30.95, -30.93, -30.88, -30.87, -30.81, -30.81, -30.76, -30.71,
        -30.67, -30.68, -30.67, -30.66, -30.66, -30.62, -30.58, -30.56, -30.52, -30.47,
        -30.46, -30.42, -30.36, -30.35, -30.26, -30.22, -30.15, -30.10, -30.10, -30.10,
        -30.10, -30.10, -30.11, -30.11, -30.02, -30.01, -30.01, -29.92, -29.93, -29.93,
        -29.93, -29.92, -29.93, -29.94, -29.94, -29.94, -29.93, -29.93, -29.94, -29.92,
        -29.88, -29.81, -29.80, -29.76, -29.66, -29.63, -29.63, -29.62, -29.62, -29.59,
        -29.58, -29.56, -29.56, -29.56, -29.56, -29.54, -29.54, -29.54, -29.52, -29.50,
        -29.50, -29.51, -29.54, -29.53, -29.52, -29.52, -29.52, -29.51, -29.49, -29.46,
        -29.41, -29.41, -29.43, -29.41, -29.42, -29.40, -29.41, -29.40, -29.42, -29.41,
        -29.42, -29.47, -29.47, -29.51, -29.49, -29.49, -29.51, -29.47, -29.43, -29.38,
        -29.36, -29.37, -29.39, -29.38, -29.38, -29.37, -29.38, -29.49, -29.47, -29.45,
        -29.43, -29.40, -29.60, -29.60, -29.60, -29.59, -29.53, -29.53, -29.52, -29.61,
        -29.60, -29.55, -29.58, -29.64, -29.73, -29.89, -29.92, -29.90, -29.97, -30.10,
        -30.13, -30.10, -30.02, -30.08, -30.12, -30.13, -30.14, -30.11, -30.17, -30.24,
        -30.26, -30.21, -30.26, -30.27, -30.29, -30.25, -30.24, -30.28, -30.33, -30.29,
        -30.30, -30.28, -30.30, -30.31, -30.56, -30.50, -30.45, -30.45, -30.79, -30.74,
        -30.72, -30.71, -30.79, -30.83, -30.89, -30.87, -30.84, -30.82, -30.85, -30.81,
        -30.80, -30.82, -30.75, -30.76, -30.77, -30.79, -30.77, -30.77, -30.80, -30.84,
        -30.84, -30.82, -30.82, -30.78, -30.75, -30.74, -30.76, -30.72, -30.70, -30.68,
        -30.65, -30.64, -30.66, -30.61, -30.67, -30.62, -30.66, -30.63, -30.66, -30.68,
        -30.74, -30.77, -30.77, -30.69, -30.69, -30.69, -30.72, -30.77, -30.75, -30.70,
        -30.67, -30.65, -30.65, -30.61, -30.68, -30.62, -30.64, -30.69, -30.68, -30.67,
        -30.67, -30.67, -30.66, -30.65, -30.66, -30.65, -30.64, -30.63, -30.63, -30.62,
        -30.62, -30.70, -30.72, -30.73, -30.78, -30.76, -30.73, -30.73, -30.73, -30.73,
        -30.74, -30.76, -30.79, -30.80, -30.79, -30.77, -30.76, -30.74, -30.75, -30.75,
        -30.78, -30.80, -30.82, -30.85, -30.85, -30.86, -30.85, -30.85, -30.85, -30.85,
        -30.85, -30.88, -30.90, -30.95, -31.00, -31.03, -31.06, -31.06, -31.06, -31.06,
        -31.06, -31.06, -31.06, -31.11, -31.11, -31.14, -31.19, -31.19, -31.23, -31.20,
        -31.22, -31.23, -31.28, -31.30, -31.35, -31.37, -31.37, -31.32, -31.37, -31.42,
        -31.44, -31.46, -31.46, -31.42, -31.43, -31.47, -31.54, -31.49, -31.48, -31.57,
        -31.60, -31.58, -31.55, -31.53, -31.53, -31.57, -31.52, -31.51, -31.42, -31.38,
        -31.32, -31.34, -31.32, -31.32, -31.27, -31.31, -31.34, -31.41, -31.40, -31.35,
        -31.35, -31.35, -31.25, -31.20, -31.12, -31.11, -31.11, -31.07, -30.98, -31.00,
        -31.05, -30.99, -30.96, -30.93, -30.88, -30.85, -30.76, -30.78, -30.82, -30.82,
        -30.80, -30.81, -30.77, -30.70, -30.68, -30.66, -30.63, -30.59, -30.52, -30.49,
        -30.40, -30.28, -30.23, -30.10, -30.06, -30.02, -29.97, -29.99
    };

    static const float fletcher_munson_curve_60_phons[1383] =
    {
        -5.17, -5.20, -5.20, -5.24, -5.20,
        -5.28, -5.29, -5.30, -5.31, -5.40, -5.33, -5.40, -5.44, -5.42, -5.45,
        -5.51, -5.48, -5.51, -5.57, -5.54, -5.57, -5.56, -5.57, -5.56, -5.54,
        -5.56, -5.52, -5.56, -5.52, -5.53, -5.51, -5.51, -5.52, -5.51, -5.60,
        -5.57, -5.62, -5.66, -5.67, -5.68, -5.77, -5.77, -5.72, -5.77, -5.78,
        -5.78, -5.86, -5.83, -5.92, -5.89, -5.96, -5.99, -6.01, -6.04, -6.09,
        -6.09, -6.15, -6.17, -6.25, -6.29, -6.29, -6.35, -6.25, -6.29, -6.25,
        -6.25, -6.25, -6.23, -6.29, -6.25, -6.30, -6.30, -6.31, -6.36, -6.40,
        -6.40, -6.46, -6.42, -6.46, -6.55, -6.51, -6.56, -6.61, -6.67, -6.72,
        -6.67, -6.72, -6.77, -6.83, -6.82, -6.88, -6.87, -6.88, -6.89, -6.88,
        -6.98, -6.93, -6.98, -6.99, -6.99, -6.99, -6.98, -7.05, -7.07, -7.10,
        -7.04, -7.09, -7.10, -7.06, -7.12, -7.08, -7.14, -7.19, -7.16, -7.24,
        -7.30, -7.25, -7.25, -7.26, -7.32, -7.27, -7.30, -7.34, -7.30, -7.35,
        -7.40, -7.39, -7.40, -7.46, -7.50, -7.46, -7.49, -7.51, -7.51, -7.48,
        -7.51, -7.56, -7.56, -7.57, -7.61, -7.69, -7.67, -7.72, -7.72, -7.72,
        -7.77, -7.77, -7.82, -7.88, -7.93, -7.98, -7.99, -7.99, -8.03, -8.05,
        -8.04, -8.08, -8.06, -8.14, -8.10, -8.14, -8.15, -8.24, -8.28, -8.35,
        -8.40, -8.38, -8.45, -8.50, -8.51, -8.58, -8.61, -8.61, -8.65, -8.69,
        -8.72, -8.76, -8.78, -8.82, -8.87, -8.93, -8.98, -9.07, -9.01, -9.08,
        -9.14, -9.19, -9.18, -9.21, -9.29, -9.34, -9.36, -9.35, -9.40, -9.45,
        -9.43, -9.46, -9.52, -9.56, -9.65, -9.66, -9.71, -9.77, -9.79, -9.87,
        -9.87, -9.89, -9.88, -9.93, -10.05, -10.05, -10.04, -10.13, -10.14, -10.09,
        -10.13, -10.14, -10.18, -10.13, -10.14, -10.23, -10.22, -10.19, -10.19, -10.17,
        -10.18, -10.23, -10.20, -10.28, -10.26, -10.30, -10.27, -10.29, -10.31, -10.30,
        -10.34, -10.34, -10.37, -10.35, -10.43, -10.45, -10.56, -10.61, -10.66, -10.71,
        -10.76, -10.82, -10.87, -10.93, -10.98, -11.03, -11.11, -11.13, -11.18, -11.24,
        -11.24, -11.34, -11.34, -11.32, -11.34, -11.39, -11.35, -11.39, -11.45, -11.50,
        -11.60, -11.63, -11.71, -11.71, -11.76, -11.82, -11.92, -11.92, -12.02, -12.03,
        -12.06, -12.04, -12.13, -12.16, -12.13, -12.15, -12.23, -12.26, -12.34, -12.39,
        -12.45, -12.55, -12.60, -12.66, -12.66, -12.74, -12.76, -12.76, -12.86, -12.87,
        -12.91, -12.96, -12.92, -12.97, -12.98, -13.00, -13.06, -13.03, -13.04, -13.08,
        -13.03, -13.02, -12.99, -13.02, -13.04, -13.12, -13.14, -13.22, -13.25, -13.33,
        -13.35, -13.33, -13.38, -13.42, -13.39, -13.44, -13.49, -13.45, -13.50, -13.62,
        -13.65, -13.65, -13.73, -13.81, -13.82, -13.91, -13.92, -13.99, -14.02, -14.02,
        -14.11, -14.09, -14.04, -14.12, -14.07, -14.07, -14.12, -14.18, -14.23, -14.29,
        -14.32, -14.28, -14.27, -14.33, -14.28, -14.30, -14.34, -14.34, -14.33, -14.39,
        -14.36, -14.34, -14.34, -14.44, -14.44, -14.45, -14.46, -14.45, -14.50, -14.57,
        -14.64, -14.70, -14.76, -14.81, -14.88, -14.92, -15.01, -15.02, -15.02, -15.02,
        -15.02, -15.12, -15.12, -15.12, -15.12, -15.20, -15.23, -15.28, -15.39, -15.42,
        -15.49, -15.49, -15.56, -15.59, -15.49, -15.53, -15.57, -15.57, -15.49, -15.55,
        -15.60, -15.64, -15.70, -15.72, -15.80, -15.81, -15.91, -15.91, -16.01, -16.06,
        -15.97, -15.96, -15.96, -15.87, -15.90, -15.95, -15.98, -16.02, -16.11, -16.13,
        -16.17, -16.22, -16.26, -16.29, -16.23, -16.28, -16.33, -16.31, -16.28, -16.33,
        -16.33, -16.33, -16.41, -16.39, -16.38, -16.44, -16.49, -16.49, -16.54, -16.59,
        -16.59, -16.65, -16.70, -16.70, -16.77, -16.80, -16.80, -16.71, -16.73, -16.72,
        -16.72, -16.75, -16.80, -16.85, -16.86, -16.96, -16.96, -17.06, -17.07, -17.17,
        -17.17, -17.23, -17.28, -17.35, -17.38, -17.45, -17.48, -17.58, -17.64, -17.68,
        -17.75, -17.79, -17.85, -17.91, -17.96, -18.01, -18.06, -18.12, -18.22, -18.23,
        -18.32, -18.32, -18.36, -18.41, -18.39, -18.43, -18.46, -18.49, -18.43, -18.49,
        -18.52, -18.49, -18.56, -18.57, -18.58, -18.58, -18.62, -18.65, -18.75, -18.80,
        -18.80, -18.80, -18.80, -18.85, -18.90, -18.91, -19.00, -19.01, -19.04, -19.06,
        -19.16, -19.17, -19.18, -19.23, -19.27, -19.27, -19.31, -19.33, -19.38, -19.37,
        -19.31, -19.34, -19.38, -19.38, -19.37, -19.28, -19.22, -19.32, -19.32, -19.32,
        -19.33, -19.43, -19.43, -19.43, -19.43, -19.43, -19.43, -19.43, -19.43, -19.44,
        -19.53, -19.54, -19.58, -19.66, -19.68, -19.69, -19.69, -19.69, -19.69, -19.79,
        -19.78, -19.77, -19.86, -19.86, -19.86, -19.95, -19.96, -19.99, -20.06, -20.06,
        -20.06, -20.06, -20.06, -20.06, -20.06, -20.06, -20.16, -20.16, -20.21, -20.27,
        -20.29, -20.32, -20.33, -20.39, -20.43, -20.43, -20.46, -20.48, -20.52, -20.53,
        -20.56, -20.62, -20.64, -20.65, -20.74, -20.75, -20.84, -20.90, -20.95, -21.00,
        -21.09, -21.11, -21.11, -21.12, -21.21, -21.21, -21.21, -21.21, -21.21, -21.21,
        -21.21, -21.28, -21.32, -21.35, -21.37, -21.47, -21.48, -21.48, -21.48, -21.59,
        -21.59, -21.59, -21.60, -21.69, -21.68, -21.66, -21.64, -21.74, -21.73, -21.71,
        -21.70, -21.78, -21.82, -21.83, -21.84, -21.95, -21.95, -21.95, -22.05, -22.06,
        -22.11, -22.11, -22.21, -22.21, -22.22, -22.26, -22.31, -22.32, -22.33, -22.37,
        -22.41, -22.42, -22.43, -22.44, -22.45, -22.47, -22.48, -22.51, -22.51, -22.49,
        -22.48, -22.47, -22.47, -22.47, -22.48, -22.58, -22.58, -22.58, -22.68, -22.68,
        -22.68, -22.68, -22.68, -22.68, -22.69, -22.69, -22.69, -22.69, -22.69, -22.73,
        -22.74, -22.74, -22.74, -22.74, -22.78, -22.79, -22.77, -22.75, -22.74, -22.76,
        -22.85, -22.84, -22.84, -22.85, -22.94, -22.95, -22.95, -22.95, -22.95, -22.95,
        -22.95, -22.95, -22.95, -22.95, -22.97, -23.00, -23.00, -23.00, -23.05, -23.08,
        -23.10, -23.11, -23.10, -23.08, -23.10, -23.11, -23.16, -23.16, -23.16, -23.16,
        -23.21, -23.21, -23.21, -23.21, -23.31, -23.32, -23.32, -23.32, -23.32, -23.32,
        -23.32, -23.32, -23.32, -23.33, -23.42, -23.42, -23.47, -23.53, -23.53, -23.56,
        -23.58, -23.60, -23.58, -23.63, -23.63, -23.63, -23.63, -23.63, -23.63, -23.62,
        -23.59, -23.59, -23.53, -23.53, -23.54, -23.55, -23.56, -23.57, -23.56, -23.53,
        -23.60, -23.63, -23.63, -23.61, -23.55, -23.53, -23.53, -23.53, -23.53, -23.51,
        -23.49, -23.47, -23.42, -23.42, -23.42, -23.37, -23.37, -23.37, -23.37, -23.37,
        -23.37, -23.37, -23.37, -23.37, -23.37, -23.37, -23.37, -23.37, -23.32, -23.32,
        -23.32, -23.32, -23.26, -23.21, -23.21, -23.16, -23.16, -23.11, -23.11, -23.11,
        -23.10, -23.11, -23.16, -23.11, -23.11, -23.05, -23.05, -23.00, -22.99, -22.98,
        -22.91, -22.79, -22.77, -22.73, -22.73, -22.70, -22.68, -22.68, -22.62, -22.69,
        -22.69, -22.74, -22.74, -22.74, -22.74, -22.74, -22.74, -22.64, -22.60, -22.60,
        -22.61, -22.52, -22.53, -22.52, -22.51, -22.51, -22.51, -22.49, -22.47, -22.47,
        -22.47, -22.41, -22.36, -22.37, -22.27, -22.27, -22.28, -22.27, -22.27, -22.26,
        -22.26, -22.26, -22.26, -22.26, -22.26, -22.26, -22.26, -22.26, -22.26, -22.27,
        -22.36, -22.32, -22.32, -22.41, -22.37, -22.37, -22.42, -22.42, -22.42, -22.42,
        -22.42, -22.41, -22.38, -22.37, -22.37, -22.33, -22.32, -22.32, -22.31, -22.28,
        -22.27, -22.27, -22.27, -22.26, -22.22, -22.16, -22.16, -22.11, -22.05, -22.06,
        -22.08, -22.11, -22.10, -22.03, -22.00, -22.00, -22.00, -22.00, -21.95, -21.93,
        -21.90, -21.90, -21.89, -21.84, -21.74, -21.66, -21.64, -21.64, -21.63, -21.63,
        -21.63, -21.63, -21.63, -21.53, -21.53, -21.53, -21.48, -21.42, -21.42, -21.42,
        -21.42, -21.42, -21.42, -21.42, -21.42, -21.36, -21.28, -21.27, -21.24, -21.19,
        -21.17, -21.16, -21.16, -21.16, -21.07, -21.06, -21.06, -21.05, -21.00, -20.95,
        -20.95, -20.95, -20.95, -20.95, -20.93, -20.85, -20.80, -20.79, -20.79, -20.79,
        -20.79, -20.79, -20.79, -20.79, -20.77, -20.70, -20.67, -20.68, -20.62, -20.64,
        -20.58, -20.53, -20.55, -20.53, -20.53, -20.45, -20.44, -20.53, -20.53, -20.58,
        -20.63, -20.64, -20.69, -20.69, -20.69, -20.62, -20.58, -20.63, -20.59, -20.58,
        -20.59, -20.69, -20.69, -20.69, -20.75, -20.79, -20.78, -20.79, -20.79, -20.82,
        -20.85, -20.84, -20.86, -20.90, -20.87, -20.83, -20.89, -20.89, -20.85, -20.92,
        -20.91, -20.87, -20.95, -20.91, -20.91, -20.95, -21.00, -21.00, -21.01, -21.00,
        -20.94, -20.96, -20.91, -20.85, -20.83, -20.85, -20.82, -20.84, -20.91, -20.85,
        -20.85, -20.85, -20.83, -20.79, -20.77, -20.76, -20.69, -20.60, -20.64, -20.61,
        -20.49, -20.48, -20.43, -20.37, -20.37, -20.32, -20.32, -20.37, -20.34, -20.38,
        -20.42, -20.38, -20.43, -20.43, -20.37, -20.37, -20.31, -20.26, -20.22, -20.17,
        -20.12, -20.16, -20.17, -20.18, -20.20, -20.16, -20.12, -20.11, -20.06, -20.01,
        -20.00, -19.96, -19.90, -19.90, -19.80, -19.76, -19.69, -19.64, -19.64, -19.64,
        -19.64, -19.64, -19.64, -19.63, -19.54, -19.53, -19.53, -19.44, -19.47, -19.48,
        -19.48, -19.48, -19.48, -19.48, -19.48, -19.48, -19.48, -19.48, -19.48, -19.48,
        -19.44, -19.37, -19.36, -19.32, -19.19, -19.17, -19.13, -19.12, -19.12, -19.06,
        -19.05, -19.01, -19.01, -19.01, -19.01, -19.01, -19.01, -19.01, -19.01, -19.01,
        -19.01, -19.03, -19.06, -19.06, -19.06, -19.06, -19.07, -19.04, -19.01, -18.99,
        -18.94, -18.96, -18.98, -18.96, -18.98, -18.95, -18.95, -18.97, -19.01, -18.97,
        -18.96, -19.01, -19.01, -19.06, -19.01, -19.01, -19.00, -18.95, -18.91, -18.86,
        -18.86, -18.87, -18.88, -18.88, -18.87, -18.86, -18.90, -18.98, -18.97, -18.94,
        -18.94, -18.94, -19.10, -19.11, -19.12, -19.02, -18.91, -18.91, -18.93, -18.99,
        -19.03, -19.00, -19.00, -19.05, -19.13, -19.31, -19.28, -19.22, -19.25, -19.36,
        -19.38, -19.29, -19.16, -19.21, -19.29, -19.27, -19.26, -19.22, -19.31, -19.40,
        -19.36, -19.43, -19.43, -19.45, -19.46, -19.45, -19.44, -19.47, -19.50, -19.44,
        -19.43, -19.39, -19.39, -19.37, -19.63, -19.59, -19.54, -19.54, -19.90, -19.85,
        -19.80, -19.79, -19.87, -19.93, -19.95, -19.92, -19.90, -19.91, -19.92, -19.90,
        -19.90, -19.95, -19.90, -19.90, -19.90, -19.90, -19.86, -19.86, -19.91, -19.95,
        -19.98, -19.96, -19.98, -19.95, -19.92, -19.92, -19.96, -19.93, -19.92, -19.95,
        -19.90, -19.93, -19.94, -19.90, -19.98, -19.95, -19.99, -20.02, -20.07, -20.11,
        -20.21, -20.26, -20.27, -20.21, -20.17, -20.19, -20.22, -20.27, -20.27, -20.22,
        -20.22, -20.22, -20.22, -20.22, -20.31, -20.27, -20.30, -20.38, -20.38, -20.38,
        -20.40, -20.42, -20.41, -20.41, -20.42, -20.43, -20.43, -20.43, -20.43, -20.42,
        -20.43, -20.53, -20.58, -20.61, -20.69, -20.69, -20.69, -20.69, -20.68, -20.68,
        -20.69, -20.71, -20.74, -20.76, -20.76, -20.77, -20.79, -20.79, -20.79, -20.80,
        -20.82, -20.84, -20.87, -20.89, -20.90, -20.90, -20.90, -20.90, -20.90, -20.90,
        -20.90, -20.90, -20.90, -20.95, -21.00, -21.05, -21.11, -21.11, -21.11, -21.11,
        -21.11, -21.11, -21.11, -21.16, -21.16, -21.16, -21.21, -21.21, -21.25, -21.20,
        -21.23, -21.24, -21.25, -21.27, -21.31, -21.31, -21.29, -21.22, -21.27, -21.32,
        -21.33, -21.32, -21.31, -21.23, -21.23, -21.27, -21.35, -21.30, -21.27, -21.35,
        -21.37, -21.35, -21.32, -21.32, -21.32, -21.34, -21.27, -21.25, -21.17, -21.12,
        -21.07, -21.10, -21.08, -21.09, -21.02, -21.04, -21.08, -21.14, -21.12, -21.05,
        -21.05, -21.05, -20.96, -20.91, -20.79, -20.77, -20.76, -20.73, -20.62, -20.63,
        -20.69, -20.65, -20.64, -20.63, -20.59, -20.57, -20.50, -20.51, -20.55, -20.53,
        -20.48, -20.51, -20.48, -20.40, -20.38, -20.36, -20.33, -20.27, -20.18, -20.16,
        -20.03, -19.93, -19.93, -19.81, -19.75, -19.75, -19.72, -19.75
    };

    static const float fletcher_munson_curve_70_phons[1383] =
    {
        -2.92, -2.94, -2.94, -2.96, -2.94,
        -2.98, -2.99, -3.00, -3.00, -3.05, -3.01, -3.05, -3.07, -3.06, -3.08,
        -3.12, -3.10, -3.12, -3.15, -3.13, -3.15, -3.15, -3.15, -3.14, -3.13,
        -3.14, -3.12, -3.14, -3.12, -3.13, -3.12, -3.12, -3.12, -3.12, -3.17,
        -3.15, -3.18, -3.20, -3.21, -3.21, -3.26, -3.26, -3.23, -3.26, -3.26,
        -3.27, -3.31, -3.30, -3.35, -3.33, -3.37, -3.38, -3.40, -3.41, -3.44,
        -3.44, -3.48, -3.49, -3.53, -3.56, -3.56, -3.59, -3.54, -3.56, -3.53,
        -3.53, -3.53, -3.52, -3.56, -3.53, -3.56, -3.56, -3.57, -3.59, -3.62,
        -3.62, -3.65, -3.63, -3.65, -3.70, -3.68, -3.71, -3.74, -3.77, -3.80,
        -3.77, -3.80, -3.83, -3.86, -3.86, -3.89, -3.89, -3.89, -3.90, -3.89,
        -3.94, -3.92, -3.95, -3.95, -3.95, -3.95, -3.94, -3.98, -4.00, -4.02,
        -3.98, -4.01, -4.01, -3.99, -4.03, -4.00, -4.04, -4.06, -4.04, -4.09,
        -4.12, -4.10, -4.10, -4.10, -4.14, -4.11, -4.13, -4.15, -4.13, -4.16,
        -4.18, -4.18, -4.18, -4.21, -4.24, -4.22, -4.23, -4.24, -4.24, -4.23,
        -4.24, -4.27, -4.27, -4.28, -4.30, -4.35, -4.33, -4.36, -4.36, -4.36,
        -4.39, -4.39, -4.42, -4.45, -4.48, -4.51, -4.52, -4.52, -4.54, -4.55,
        -4.55, -4.57, -4.56, -4.60, -4.58, -4.60, -4.61, -4.66, -4.68, -4.72,
        -4.75, -4.74, -4.78, -4.80, -4.81, -4.85, -4.87, -4.87, -4.89, -4.91,
        -4.93, -4.95, -4.96, -4.98, -5.01, -5.05, -5.08, -5.13, -5.09, -5.13,
        -5.17, -5.19, -5.19, -5.21, -5.25, -5.28, -5.29, -5.28, -5.31, -5.34,
        -5.33, -5.35, -5.38, -5.40, -5.45, -5.46, -5.49, -5.52, -5.53, -5.58,
        -5.58, -5.59, -5.58, -5.61, -5.68, -5.68, -5.67, -5.73, -5.73, -5.70,
        -5.73, -5.73, -5.75, -5.73, -5.73, -5.78, -5.78, -5.76, -5.76, -5.75,
        -5.76, -5.78, -5.76, -5.81, -5.80, -5.82, -5.80, -5.82, -5.83, -5.82,
        -5.85, -5.84, -5.86, -5.85, -5.90, -5.91, -5.97, -6.00, -6.03, -6.05,
        -6.08, -6.11, -6.14, -6.18, -6.20, -6.23, -6.28, -6.29, -6.32, -6.35,
        -6.35, -6.41, -6.41, -6.40, -6.41, -6.44, -6.41, -6.44, -6.47, -6.50,
        -6.56, -6.57, -6.62, -6.62, -6.65, -6.68, -6.74, -6.74, -6.80, -6.80,
        -6.81, -6.81, -6.86, -6.87, -6.86, -6.87, -6.91, -6.93, -6.97, -7.00,
        -7.04, -7.09, -7.12, -7.15, -7.15, -7.20, -7.21, -7.21, -7.27, -7.27,
        -7.29, -7.33, -7.30, -7.33, -7.33, -7.35, -7.38, -7.37, -7.37, -7.39,
        -7.36, -7.36, -7.34, -7.36, -7.37, -7.42, -7.43, -7.47, -7.49, -7.54,
        -7.54, -7.54, -7.56, -7.59, -7.57, -7.60, -7.63, -7.60, -7.63, -7.70,
        -7.72, -7.72, -7.76, -7.80, -7.81, -7.86, -7.87, -7.91, -7.92, -7.93,
        -7.98, -7.96, -7.93, -7.98, -7.95, -7.95, -7.98, -8.01, -8.04, -8.08,
        -8.09, -8.07, -8.06, -8.10, -8.07, -8.08, -8.10, -8.10, -8.10, -8.13,
        -8.12, -8.11, -8.11, -8.16, -8.16, -8.17, -8.17, -8.17, -8.20, -8.23,
        -8.28, -8.31, -8.34, -8.37, -8.41, -8.43, -8.48, -8.49, -8.49, -8.49,
        -8.49, -8.55, -8.55, -8.55, -8.55, -8.59, -8.61, -8.64, -8.70, -8.72,
        -8.75, -8.76, -8.79, -8.81, -8.76, -8.78, -8.80, -8.80, -8.76, -8.79,
        -8.82, -8.84, -8.87, -8.88, -8.93, -8.93, -8.99, -8.99, -9.05, -9.08,
        -9.03, -9.02, -9.02, -8.97, -8.99, -9.01, -9.03, -9.05, -9.11, -9.11,
        -9.14, -9.17, -9.19, -9.21, -9.17, -9.20, -9.23, -9.22, -9.20, -9.23,
        -9.23, -9.23, -9.28, -9.26, -9.26, -9.29, -9.32, -9.32, -9.35, -9.38,
        -9.38, -9.41, -9.44, -9.44, -9.48, -9.50, -9.50, -9.44, -9.46, -9.45,
        -9.45, -9.47, -9.50, -9.53, -9.53, -9.59, -9.59, -9.64, -9.65, -9.70,
        -9.71, -9.74, -9.76, -9.81, -9.82, -9.86, -9.88, -9.94, -9.97, -9.99,
        -10.03, -10.06, -10.09, -10.12, -10.15, -10.18, -10.21, -10.24, -10.30, -10.30,
        -10.36, -10.36, -10.38, -10.40, -10.40, -10.42, -10.43, -10.45, -10.42, -10.45,
        -10.47, -10.45, -10.49, -10.50, -10.50, -10.50, -10.53, -10.54, -10.60, -10.63,
        -10.63, -10.63, -10.63, -10.66, -10.68, -10.69, -10.74, -10.74, -10.76, -10.78,
        -10.83, -10.83, -10.84, -10.87, -10.89, -10.89, -10.92, -10.92, -10.95, -10.95,
        -10.92, -10.93, -10.95, -10.95, -10.95, -10.89, -10.87, -10.92, -10.92, -10.92,
        -10.93, -10.98, -10.98, -10.98, -10.98, -10.98, -10.98, -10.98, -10.98, -10.99,
        -11.04, -11.04, -11.07, -11.11, -11.12, -11.13, -11.13, -11.13, -11.13, -11.19,
        -11.18, -11.17, -11.23, -11.22, -11.22, -11.28, -11.28, -11.30, -11.34, -11.34,
        -11.34, -11.34, -11.34, -11.34, -11.34, -11.34, -11.40, -11.40, -11.42, -11.46,
        -11.47, -11.49, -11.49, -11.52, -11.55, -11.55, -11.56, -11.58, -11.60, -11.61,
        -11.62, -11.66, -11.66, -11.67, -11.72, -11.73, -11.78, -11.81, -11.84, -11.87,
        -11.92, -11.93, -11.93, -11.94, -11.99, -11.99, -11.99, -11.99, -11.99, -11.99,
        -11.99, -12.03, -12.05, -12.07, -12.08, -12.14, -12.14, -12.14, -12.14, -12.20,
        -12.20, -12.20, -12.21, -12.26, -12.25, -12.24, -12.23, -12.29, -12.28, -12.27,
        -12.27, -12.31, -12.33, -12.34, -12.35, -12.40, -12.41, -12.41, -12.46, -12.47,
        -12.50, -12.50, -12.55, -12.55, -12.56, -12.58, -12.61, -12.61, -12.62, -12.64,
        -12.67, -12.67, -12.68, -12.68, -12.69, -12.70, -12.71, -12.72, -12.72, -12.71,
        -12.70, -12.70, -12.70, -12.70, -12.71, -12.76, -12.76, -12.76, -12.82, -12.82,
        -12.82, -12.82, -12.82, -12.82, -12.82, -12.82, -12.83, -12.82, -12.82, -12.85,
        -12.85, -12.85, -12.85, -12.85, -12.87, -12.88, -12.87, -12.86, -12.86, -12.86,
        -12.91, -12.91, -12.91, -12.91, -12.97, -12.97, -12.97, -12.97, -12.97, -12.97,
        -12.97, -12.97, -12.97, -12.97, -12.98, -13.00, -13.00, -13.00, -13.03, -13.04,
        -13.06, -13.06, -13.05, -13.04, -13.06, -13.06, -13.09, -13.09, -13.09, -13.09,
        -13.12, -13.12, -13.12, -13.12, -13.18, -13.18, -13.18, -13.18, -13.18, -13.18,
        -13.18, -13.18, -13.18, -13.19, -13.24, -13.24, -13.27, -13.30, -13.30, -13.32,
        -13.33, -13.34, -13.33, -13.36, -13.36, -13.36, -13.36, -13.35, -13.35, -13.35,
        -13.33, -13.33, -13.30, -13.30, -13.31, -13.31, -13.32, -13.32, -13.32, -13.30,
        -13.34, -13.36, -13.36, -13.34, -13.31, -13.30, -13.30, -13.30, -13.30, -13.29,
        -13.28, -13.27, -13.24, -13.24, -13.24, -13.21, -13.21, -13.21, -13.21, -13.21,
        -13.21, -13.21, -13.21, -13.21, -13.21, -13.21, -13.21, -13.21, -13.18, -13.18,
        -13.18, -13.18, -13.15, -13.12, -13.12, -13.09, -13.09, -13.06, -13.06, -13.06,
        -13.06, -13.06, -13.09, -13.06, -13.06, -13.03, -13.03, -13.00, -12.99, -12.99,
        -12.95, -12.88, -12.87, -12.85, -12.85, -12.83, -12.82, -12.82, -12.79, -12.82,
        -12.82, -12.85, -12.85, -12.85, -12.85, -12.85, -12.85, -12.80, -12.77, -12.77,
        -12.78, -12.73, -12.73, -12.73, -12.72, -12.72, -12.72, -12.71, -12.70, -12.70,
        -12.70, -12.67, -12.64, -12.64, -12.59, -12.59, -12.59, -12.59, -12.58, -12.58,
        -12.58, -12.58, -12.58, -12.58, -12.58, -12.58, -12.58, -12.58, -12.58, -12.59,
        -12.64, -12.61, -12.62, -12.67, -12.65, -12.64, -12.67, -12.67, -12.67, -12.67,
        -12.67, -12.67, -12.65, -12.65, -12.64, -12.62, -12.61, -12.61, -12.61, -12.59,
        -12.59, -12.59, -12.58, -12.58, -12.56, -12.53, -12.53, -12.50, -12.47, -12.47,
        -12.48, -12.49, -12.49, -12.45, -12.44, -12.44, -12.44, -12.43, -12.41, -12.40,
        -12.38, -12.38, -12.37, -12.34, -12.29, -12.24, -12.23, -12.23, -12.23, -12.23,
        -12.23, -12.23, -12.22, -12.17, -12.17, -12.17, -12.14, -12.11, -12.11, -12.11,
        -12.11, -12.11, -12.11, -12.11, -12.10, -12.07, -12.03, -12.02, -12.00, -11.98,
        -11.97, -11.96, -11.96, -11.96, -11.91, -11.90, -11.90, -11.90, -11.87, -11.84,
        -11.84, -11.84, -11.84, -11.84, -11.83, -11.78, -11.76, -11.75, -11.75, -11.75,
        -11.75, -11.75, -11.75, -11.75, -11.74, -11.70, -11.68, -11.69, -11.66, -11.66,
        -11.63, -11.61, -11.62, -11.60, -11.60, -11.56, -11.55, -11.60, -11.61, -11.63,
        -11.66, -11.67, -11.69, -11.69, -11.69, -11.66, -11.63, -11.66, -11.64, -11.63,
        -11.64, -11.69, -11.69, -11.69, -11.73, -11.75, -11.74, -11.75, -11.75, -11.77,
        -11.78, -11.78, -11.79, -11.81, -11.79, -11.77, -11.81, -11.81, -11.79, -11.82,
        -11.82, -11.80, -11.84, -11.82, -11.82, -11.84, -11.87, -11.87, -11.87, -11.87,
        -11.84, -11.85, -11.82, -11.78, -11.77, -11.78, -11.77, -11.78, -11.82, -11.79,
        -11.78, -11.79, -11.77, -11.75, -11.74, -11.73, -11.69, -11.64, -11.66, -11.65,
        -11.58, -11.58, -11.55, -11.52, -11.52, -11.48, -11.49, -11.51, -11.50, -11.52,
        -11.54, -11.52, -11.55, -11.55, -11.52, -11.51, -11.48, -11.45, -11.43, -11.40,
        -11.37, -11.39, -11.40, -11.41, -11.42, -11.40, -11.37, -11.36, -11.34, -11.31,
        -11.31, -11.28, -11.25, -11.25, -11.19, -11.17, -11.13, -11.10, -11.10, -11.10,
        -11.10, -11.10, -11.10, -11.10, -11.04, -11.04, -11.04, -10.99, -11.01, -11.01,
        -11.01, -11.01, -11.01, -11.01, -11.01, -11.01, -11.01, -11.01, -11.01, -11.01,
        -10.99, -10.95, -10.94, -10.92, -10.85, -10.84, -10.82, -10.80, -10.80, -10.78,
        -10.77, -10.75, -10.75, -10.75, -10.75, -10.75, -10.75, -10.75, -10.75, -10.75,
        -10.75, -10.75, -10.77, -10.77, -10.77, -10.77, -10.78, -10.76, -10.75, -10.73,
        -10.71, -10.71, -10.73, -10.71, -10.73, -10.71, -10.71, -10.72, -10.74, -10.72,
        -10.72, -10.74, -10.74, -10.77, -10.75, -10.75, -10.74, -10.71, -10.69, -10.66,
        -10.66, -10.66, -10.67, -10.67, -10.66, -10.66, -10.68, -10.73, -10.72, -10.71,
        -10.71, -10.71, -10.79, -10.80, -10.80, -10.75, -10.69, -10.69, -10.70, -10.73,
        -10.76, -10.74, -10.74, -10.77, -10.81, -10.92, -10.90, -10.86, -10.88, -10.94,
        -10.95, -10.90, -10.83, -10.86, -10.90, -10.89, -10.89, -10.86, -10.92, -10.96,
        -10.94, -10.98, -10.98, -10.99, -11.00, -10.99, -10.99, -11.01, -11.02, -10.99,
        -10.98, -10.96, -10.96, -10.95, -11.09, -11.07, -11.04, -11.04, -11.25, -11.22,
        -11.19, -11.19, -11.23, -11.26, -11.28, -11.26, -11.25, -11.26, -11.26, -11.25,
        -11.25, -11.28, -11.25, -11.25, -11.25, -11.25, -11.23, -11.23, -11.25, -11.28,
        -11.29, -11.28, -11.29, -11.28, -11.26, -11.26, -11.28, -11.27, -11.26, -11.28,
        -11.25, -11.27, -11.27, -11.25, -11.29, -11.28, -11.30, -11.31, -11.34, -11.37,
        -11.42, -11.45, -11.45, -11.42, -11.40, -11.41, -11.43, -11.45, -11.45, -11.43,
        -11.43, -11.43, -11.43, -11.43, -11.48, -11.46, -11.47, -11.52, -11.52, -11.52,
        -11.53, -11.54, -11.54, -11.53, -11.54, -11.55, -11.55, -11.55, -11.55, -11.54,
        -11.55, -11.60, -11.63, -11.65, -11.69, -11.69, -11.69, -11.69, -11.69, -11.69,
        -11.69, -11.71, -11.72, -11.73, -11.74, -11.74, -11.75, -11.75, -11.75, -11.75,
        -11.77, -11.78, -11.79, -11.81, -11.81, -11.81, -11.81, -11.81, -11.81, -11.81,
        -11.81, -11.81, -11.81, -11.84, -11.87, -11.90, -11.93, -11.93, -11.93, -11.93,
        -11.93, -11.93, -11.93, -11.96, -11.96, -11.96, -11.99, -11.99, -12.01, -11.98,
        -12.00, -12.01, -12.01, -12.02, -12.05, -12.05, -12.04, -12.00, -12.02, -12.05,
        -12.06, -12.05, -12.04, -12.00, -12.00, -12.02, -12.07, -12.04, -12.02, -12.07,
        -12.08, -12.07, -12.05, -12.05, -12.05, -12.06, -12.02, -12.01, -11.96, -11.94,
        -11.91, -11.93, -11.91, -11.92, -11.88, -11.89, -11.92, -11.95, -11.94, -11.90,
        -11.90, -11.90, -11.85, -11.82, -11.75, -11.74, -11.73, -11.72, -11.66, -11.66,
        -11.69, -11.67, -11.67, -11.66, -11.64, -11.63, -11.59, -11.59, -11.61, -11.60,
        -11.58, -11.59, -11.57, -11.53, -11.52, -11.51, -11.49, -11.46, -11.41, -11.39,
        -11.32, -11.26, -11.27, -11.20, -11.16, -11.16, -11.15, -11.16
    };

    static const float fletcher_munson_curve_80_phons[1383] =
    {
        -0.67, -0.68, -0.68, -0.68, -0.68,
        -0.69, -0.69, -0.69, -0.69, -0.70, -0.69, -0.70, -0.71, -0.71, -0.71,
        -0.72, -0.71, -0.72, -0.73, -0.72, -0.73, -0.73, -0.73, -0.73, -0.72,
        -0.73, -0.72, -0.72, -0.72, -0.72, -0.72, -0.72, -0.72, -0.72, -0.73,
        -0.73, -0.73, -0.74, -0.74, -0.74, -0.75, -0.75, -0.75, -0.75, -0.75,
        -0.75, -0.76, -0.76, -0.77, -0.77, -0.78, -0.78, -0.78, -0.79, -0.79,
        -0.79, -0.80, -0.80, -0.81, -0.82, -0.82, -0.83, -0.82, -0.82, -0.82,
        -0.82, -0.82, -0.81, -0.82, -0.82, -0.82, -0.82, -0.82, -0.83, -0.84,
        -0.84, -0.84, -0.84, -0.84, -0.85, -0.85, -0.86, -0.86, -0.87, -0.88,
        -0.87, -0.88, -0.88, -0.89, -0.89, -0.90, -0.90, -0.90, -0.90, -0.90,
        -0.91, -0.90, -0.91, -0.91, -0.91, -0.91, -0.91, -0.92, -0.92, -0.93,
        -0.92, -0.92, -0.93, -0.92, -0.93, -0.92, -0.93, -0.94, -0.93, -0.94,
        -0.95, -0.95, -0.95, -0.95, -0.96, -0.95, -0.95, -0.96, -0.95, -0.96,
        -0.97, -0.96, -0.97, -0.97, -0.98, -0.97, -0.98, -0.98, -0.98, -0.98,
        -0.98, -0.99, -0.99, -0.99, -0.99, -1.00, -1.00, -1.01, -1.01, -1.01,
        -1.01, -1.01, -1.02, -1.03, -1.03, -1.04, -1.04, -1.04, -1.05, -1.05,
        -1.05, -1.05, -1.05, -1.06, -1.06, -1.06, -1.06, -1.08, -1.08, -1.09,
        -1.10, -1.09, -1.10, -1.11, -1.11, -1.12, -1.12, -1.12, -1.13, -1.13,
        -1.14, -1.14, -1.14, -1.15, -1.16, -1.16, -1.17, -1.18, -1.18, -1.18,
        -1.19, -1.20, -1.20, -1.20, -1.21, -1.22, -1.22, -1.22, -1.23, -1.23,
        -1.23, -1.23, -1.24, -1.25, -1.26, -1.26, -1.27, -1.27, -1.28, -1.29,
        -1.29, -1.29, -1.29, -1.30, -1.31, -1.31, -1.31, -1.32, -1.32, -1.32,
        -1.32, -1.32, -1.33, -1.32, -1.32, -1.33, -1.33, -1.33, -1.33, -1.33,
        -1.33, -1.33, -1.33, -1.34, -1.34, -1.34, -1.34, -1.34, -1.34, -1.34,
        -1.35, -1.35, -1.35, -1.35, -1.36, -1.36, -1.38, -1.38, -1.39, -1.40,
        -1.40, -1.41, -1.42, -1.43, -1.43, -1.44, -1.45, -1.45, -1.46, -1.47,
        -1.47, -1.48, -1.48, -1.48, -1.48, -1.49, -1.48, -1.49, -1.49, -1.50,
        -1.51, -1.52, -1.53, -1.53, -1.53, -1.54, -1.55, -1.56, -1.57, -1.57,
        -1.57, -1.57, -1.58, -1.59, -1.58, -1.58, -1.60, -1.60, -1.61, -1.62,
        -1.62, -1.64, -1.64, -1.65, -1.65, -1.66, -1.66, -1.66, -1.68, -1.68,
        -1.68, -1.69, -1.69, -1.69, -1.69, -1.70, -1.70, -1.70, -1.70, -1.71,
        -1.70, -1.70, -1.69, -1.70, -1.70, -1.71, -1.71, -1.72, -1.73, -1.74,
        -1.74, -1.74, -1.74, -1.75, -1.75, -1.75, -1.76, -1.75, -1.76, -1.78,
        -1.78, -1.78, -1.79, -1.80, -1.80, -1.81, -1.82, -1.83, -1.83, -1.83,
        -1.84, -1.84, -1.83, -1.84, -1.84, -1.83, -1.84, -1.85, -1.86, -1.86,
        -1.87, -1.86, -1.86, -1.87, -1.86, -1.87, -1.87, -1.87, -1.87, -1.88,
        -1.87, -1.87, -1.87, -1.88, -1.88, -1.89, -1.89, -1.89, -1.89, -1.90,
        -1.91, -1.92, -1.92, -1.93, -1.94, -1.95, -1.96, -1.96, -1.96, -1.96,
        -1.96, -1.97, -1.97, -1.97, -1.97, -1.98, -1.99, -1.99, -2.01, -2.01,
        -2.02, -2.02, -2.03, -2.03, -2.02, -2.03, -2.03, -2.03, -2.02, -2.03,
        -2.03, -2.04, -2.05, -2.05, -2.06, -2.06, -2.07, -2.08, -2.09, -2.10,
        -2.08, -2.08, -2.08, -2.07, -2.07, -2.08, -2.08, -2.09, -2.10, -2.10,
        -2.11, -2.12, -2.12, -2.13, -2.12, -2.12, -2.13, -2.13, -2.12, -2.13,
        -2.13, -2.13, -2.14, -2.14, -2.14, -2.14, -2.15, -2.15, -2.16, -2.16,
        -2.16, -2.17, -2.18, -2.18, -2.19, -2.19, -2.19, -2.18, -2.18, -2.18,
        -2.18, -2.19, -2.19, -2.20, -2.20, -2.21, -2.21, -2.23, -2.23, -2.24,
        -2.24, -2.25, -2.25, -2.26, -2.27, -2.28, -2.28, -2.29, -2.30, -2.31,
        -2.31, -2.32, -2.33, -2.34, -2.34, -2.35, -2.36, -2.36, -2.38, -2.38,
        -2.39, -2.39, -2.40, -2.40, -2.40, -2.40, -2.41, -2.41, -2.40, -2.41,
        -2.42, -2.41, -2.42, -2.42, -2.42, -2.42, -2.43, -2.43, -2.45, -2.45,
        -2.45, -2.45, -2.45, -2.46, -2.47, -2.47, -2.48, -2.48, -2.48, -2.49,
        -2.50, -2.50, -2.50, -2.51, -2.51, -2.51, -2.52, -2.52, -2.53, -2.53,
        -2.52, -2.52, -2.53, -2.53, -2.53, -2.51, -2.51, -2.52, -2.52, -2.52,
        -2.52, -2.53, -2.53, -2.53, -2.53, -2.53, -2.53, -2.53, -2.53, -2.54,
        -2.55, -2.55, -2.55, -2.56, -2.57, -2.57, -2.57, -2.57, -2.57, -2.58,
        -2.58, -2.58, -2.59, -2.59, -2.59, -2.60, -2.60, -2.61, -2.62, -2.62,
        -2.62, -2.62, -2.62, -2.62, -2.62, -2.62, -2.63, -2.63, -2.64, -2.64,
        -2.65, -2.65, -2.65, -2.66, -2.66, -2.66, -2.67, -2.67, -2.68, -2.68,
        -2.68, -2.69, -2.69, -2.69, -2.71, -2.71, -2.72, -2.73, -2.73, -2.74,
        -2.75, -2.75, -2.75, -2.75, -2.77, -2.77, -2.77, -2.77, -2.77, -2.77,
        -2.77, -2.78, -2.78, -2.78, -2.79, -2.80, -2.80, -2.80, -2.80, -2.82,
        -2.82, -2.82, -2.82, -2.83, -2.83, -2.83, -2.82, -2.84, -2.83, -2.83,
        -2.83, -2.84, -2.85, -2.85, -2.85, -2.86, -2.86, -2.86, -2.88, -2.88,
        -2.88, -2.88, -2.90, -2.90, -2.90, -2.90, -2.91, -2.91, -2.91, -2.92,
        -2.92, -2.92, -2.93, -2.93, -2.93, -2.93, -2.93, -2.94, -2.94, -2.93,
        -2.93, -2.93, -2.93, -2.93, -2.93, -2.94, -2.95, -2.95, -2.96, -2.96,
        -2.96, -2.96, -2.96, -2.96, -2.96, -2.96, -2.96, -2.96, -2.96, -2.97,
        -2.97, -2.97, -2.97, -2.97, -2.97, -2.97, -2.97, -2.97, -2.97, -2.97,
        -2.98, -2.98, -2.98, -2.98, -2.99, -2.99, -2.99, -2.99, -2.99, -2.99,
        -2.99, -2.99, -2.99, -2.99, -3.00, -3.00, -3.00, -3.00, -3.01, -3.01,
        -3.01, -3.01, -3.01, -3.01, -3.01, -3.01, -3.02, -3.02, -3.02, -3.02,
        -3.03, -3.03, -3.03, -3.03, -3.04, -3.04, -3.04, -3.04, -3.04, -3.04,
        -3.04, -3.04, -3.04, -3.04, -3.05, -3.05, -3.06, -3.07, -3.07, -3.07,
        -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08,
        -3.08, -3.08, -3.07, -3.07, -3.07, -3.07, -3.07, -3.07, -3.07, -3.07,
        -3.08, -3.08, -3.08, -3.08, -3.07, -3.07, -3.07, -3.07, -3.07, -3.07,
        -3.06, -3.06, -3.05, -3.05, -3.05, -3.05, -3.05, -3.05, -3.05, -3.05,
        -3.05, -3.05, -3.05, -3.05, -3.05, -3.05, -3.05, -3.05, -3.04, -3.04,
        -3.04, -3.04, -3.03, -3.03, -3.03, -3.02, -3.02, -3.01, -3.01, -3.01,
        -3.01, -3.01, -3.02, -3.01, -3.01, -3.01, -3.01, -3.00, -3.00, -3.00,
        -2.99, -2.97, -2.97, -2.97, -2.96, -2.96, -2.96, -2.96, -2.95, -2.96,
        -2.96, -2.97, -2.97, -2.97, -2.97, -2.97, -2.97, -2.95, -2.95, -2.95,
        -2.95, -2.94, -2.94, -2.94, -2.94, -2.94, -2.94, -2.93, -2.93, -2.93,
        -2.93, -2.92, -2.92, -2.92, -2.91, -2.90, -2.91, -2.90, -2.90, -2.90,
        -2.90, -2.90, -2.90, -2.90, -2.90, -2.90, -2.90, -2.90, -2.90, -2.90,
        -2.92, -2.91, -2.91, -2.92, -2.92, -2.92, -2.92, -2.92, -2.92, -2.92,
        -2.92, -2.92, -2.92, -2.92, -2.92, -2.91, -2.91, -2.91, -2.91, -2.91,
        -2.90, -2.90, -2.90, -2.90, -2.90, -2.89, -2.89, -2.88, -2.88, -2.88,
        -2.88, -2.88, -2.88, -2.87, -2.87, -2.87, -2.87, -2.87, -2.86, -2.86,
        -2.86, -2.86, -2.86, -2.85, -2.84, -2.82, -2.82, -2.82, -2.82, -2.82,
        -2.82, -2.82, -2.82, -2.81, -2.81, -2.81, -2.80, -2.79, -2.79, -2.79,
        -2.79, -2.79, -2.79, -2.79, -2.79, -2.79, -2.78, -2.77, -2.77, -2.76,
        -2.76, -2.76, -2.76, -2.76, -2.75, -2.75, -2.75, -2.75, -2.74, -2.73,
        -2.73, -2.73, -2.73, -2.73, -2.73, -2.72, -2.71, -2.71, -2.71, -2.71,
        -2.71, -2.71, -2.71, -2.71, -2.71, -2.70, -2.70, -2.70, -2.69, -2.69,
        -2.68, -2.68, -2.68, -2.68, -2.68, -2.67, -2.67, -2.68, -2.68, -2.68,
        -2.69, -2.69, -2.70, -2.70, -2.70, -2.69, -2.68, -2.69, -2.69, -2.68,
        -2.69, -2.70, -2.70, -2.70, -2.71, -2.71, -2.71, -2.71, -2.71, -2.72,
        -2.72, -2.72, -2.72, -2.73, -2.72, -2.72, -2.73, -2.72, -2.72, -2.73,
        -2.73, -2.72, -2.73, -2.73, -2.73, -2.73, -2.74, -2.74, -2.74, -2.74,
        -2.73, -2.73, -2.73, -2.72, -2.72, -2.72, -2.72, -2.72, -2.73, -2.72,
        -2.72, -2.72, -2.72, -2.71, -2.71, -2.71, -2.70, -2.69, -2.69, -2.69,
        -2.67, -2.67, -2.67, -2.66, -2.66, -2.65, -2.65, -2.66, -2.65, -2.66,
        -2.66, -2.66, -2.66, -2.66, -2.66, -2.66, -2.65, -2.64, -2.64, -2.63,
        -2.62, -2.63, -2.63, -2.63, -2.63, -2.63, -2.62, -2.62, -2.62, -2.61,
        -2.61, -2.60, -2.60, -2.60, -2.58, -2.58, -2.57, -2.56, -2.56, -2.56,
        -2.56, -2.56, -2.56, -2.56, -2.55, -2.55, -2.55, -2.54, -2.54, -2.54,
        -2.54, -2.54, -2.54, -2.54, -2.54, -2.54, -2.54, -2.54, -2.54, -2.54,
        -2.54, -2.53, -2.53, -2.52, -2.50, -2.50, -2.50, -2.49, -2.49, -2.49,
        -2.48, -2.48, -2.48, -2.48, -2.48, -2.48, -2.48, -2.48, -2.48, -2.48,
        -2.48, -2.48, -2.49, -2.49, -2.49, -2.49, -2.49, -2.48, -2.48, -2.48,
        -2.47, -2.47, -2.48, -2.47, -2.48, -2.47, -2.47, -2.47, -2.48, -2.47,
        -2.47, -2.48, -2.48, -2.49, -2.48, -2.48, -2.48, -2.47, -2.47, -2.46,
        -2.46, -2.46, -2.46, -2.46, -2.46, -2.46, -2.47, -2.48, -2.47, -2.47,
        -2.47, -2.47, -2.49, -2.49, -2.49, -2.48, -2.47, -2.47, -2.47, -2.48,
        -2.48, -2.48, -2.48, -2.49, -2.49, -2.52, -2.52, -2.51, -2.51, -2.53,
        -2.53, -2.52, -2.50, -2.51, -2.52, -2.51, -2.51, -2.51, -2.52, -2.53,
        -2.52, -2.53, -2.53, -2.54, -2.54, -2.54, -2.54, -2.54, -2.54, -2.54,
        -2.53, -2.53, -2.53, -2.53, -2.56, -2.56, -2.55, -2.55, -2.60, -2.59,
        -2.58, -2.58, -2.59, -2.60, -2.60, -2.60, -2.60, -2.60, -2.60, -2.60,
        -2.60, -2.60, -2.60, -2.60, -2.60, -2.60, -2.59, -2.59, -2.60, -2.60,
        -2.61, -2.60, -2.61, -2.60, -2.60, -2.60, -2.60, -2.60, -2.60, -2.60,
        -2.60, -2.60, -2.60, -2.60, -2.61, -2.60, -2.61, -2.61, -2.62, -2.62,
        -2.64, -2.64, -2.64, -2.64, -2.63, -2.63, -2.64, -2.64, -2.64, -2.64,
        -2.64, -2.64, -2.64, -2.64, -2.65, -2.64, -2.65, -2.66, -2.66, -2.66,
        -2.66, -2.66, -2.66, -2.66, -2.66, -2.66, -2.66, -2.66, -2.66, -2.66,
        -2.67, -2.68, -2.68, -2.69, -2.70, -2.70, -2.70, -2.70, -2.70, -2.70,
        -2.70, -2.70, -2.71, -2.71, -2.71, -2.71, -2.71, -2.71, -2.71, -2.71,
        -2.72, -2.72, -2.72, -2.73, -2.73, -2.73, -2.73, -2.73, -2.73, -2.73,
        -2.73, -2.73, -2.73, -2.73, -2.74, -2.75, -2.75, -2.75, -2.75, -2.75,
        -2.75, -2.75, -2.75, -2.76, -2.76, -2.76, -2.77, -2.77, -2.77, -2.77,
        -2.77, -2.77, -2.77, -2.77, -2.78, -2.78, -2.78, -2.77, -2.77, -2.78,
        -2.78, -2.78, -2.78, -2.77, -2.77, -2.77, -2.79, -2.78, -2.77, -2.79,
        -2.79, -2.78, -2.78, -2.78, -2.78, -2.78, -2.77, -2.77, -2.76, -2.76,
        -2.75, -2.75, -2.75, -2.75, -2.74, -2.74, -2.75, -2.76, -2.75, -2.75,
        -2.75, -2.75, -2.73, -2.73, -2.71, -2.71, -2.71, -2.70, -2.69, -2.69,
        -2.70, -2.69, -2.69, -2.69, -2.69, -2.68, -2.67, -2.67, -2.68, -2.68,
        -2.67, -2.68, -2.67, -2.66, -2.66, -2.66, -2.65, -2.64, -2.63, -2.63,
        -2.61, -2.60, -2.60, -2.58, -2.58, -2.58, -2.57, -2.58
    };

    static const float fletcher_munson_curve_90_phons[1383] =
    {
        1.57, 1.58, 1.58, 1.59, 1.58,
        1.61, 1.61, 1.61, 1.62, 1.64, 1.62, 1.64, 1.66, 1.65, 1.66,
        1.68, 1.67, 1.68, 1.69, 1.69, 1.69, 1.69, 1.69, 1.69, 1.69,
        1.69, 1.68, 1.69, 1.68, 1.68, 1.68, 1.68, 1.68, 1.68, 1.70,
        1.69, 1.71, 1.72, 1.73, 1.73, 1.75, 1.75, 1.74, 1.76, 1.76,
        1.76, 1.78, 1.78, 1.80, 1.79, 1.81, 1.82, 1.83, 1.84, 1.85,
        1.85, 1.87, 1.88, 1.90, 1.92, 1.91, 1.93, 1.90, 1.91, 1.90,
        1.90, 1.90, 1.89, 1.91, 1.90, 1.92, 1.92, 1.92, 1.93, 1.95,
        1.95, 1.96, 1.95, 1.97, 1.99, 1.98, 2.00, 2.01, 2.03, 2.04,
        2.03, 2.05, 2.06, 2.08, 2.08, 2.09, 2.09, 2.09, 2.10, 2.09,
        2.12, 2.11, 2.12, 2.13, 2.13, 2.13, 2.12, 2.15, 2.15, 2.16,
        2.14, 2.16, 2.16, 2.15, 2.17, 2.16, 2.17, 2.19, 2.18, 2.20,
        2.22, 2.21, 2.21, 2.21, 2.23, 2.21, 2.22, 2.24, 2.22, 2.24,
        2.25, 2.25, 2.25, 2.27, 2.28, 2.27, 2.28, 2.28, 2.29, 2.28,
        2.29, 2.30, 2.30, 2.30, 2.32, 2.34, 2.33, 2.35, 2.35, 2.35,
        2.37, 2.37, 2.38, 2.40, 2.41, 2.43, 2.43, 2.43, 2.44, 2.45,
        2.45, 2.46, 2.45, 2.48, 2.46, 2.48, 2.48, 2.51, 2.52, 2.54,
        2.56, 2.55, 2.57, 2.59, 2.59, 2.61, 2.62, 2.62, 2.63, 2.65,
        2.66, 2.67, 2.67, 2.68, 2.70, 2.72, 2.73, 2.76, 2.74, 2.76,
        2.78, 2.80, 2.79, 2.80, 2.83, 2.84, 2.85, 2.85, 2.86, 2.88,
        2.87, 2.88, 2.90, 2.91, 2.94, 2.94, 2.96, 2.97, 2.98, 3.00,
        3.00, 3.01, 3.01, 3.02, 3.06, 3.06, 3.05, 3.08, 3.09, 3.07,
        3.08, 3.08, 3.10, 3.08, 3.09, 3.11, 3.11, 3.10, 3.10, 3.10,
        3.10, 3.11, 3.10, 3.13, 3.12, 3.13, 3.12, 3.13, 3.14, 3.13,
        3.15, 3.15, 3.16, 3.15, 3.17, 3.18, 3.21, 3.23, 3.24, 3.26,
        3.28, 3.29, 3.31, 3.33, 3.34, 3.36, 3.38, 3.39, 3.40, 3.42,
        3.42, 3.45, 3.45, 3.44, 3.45, 3.47, 3.45, 3.47, 3.49, 3.50,
        3.53, 3.54, 3.56, 3.57, 3.58, 3.60, 3.63, 3.63, 3.66, 3.66,
        3.67, 3.67, 3.69, 3.70, 3.69, 3.70, 3.72, 3.73, 3.76, 3.77,
        3.79, 3.82, 3.84, 3.85, 3.85, 3.88, 3.88, 3.88, 3.91, 3.92,
        3.93, 3.95, 3.93, 3.95, 3.95, 3.96, 3.98, 3.97, 3.97, 3.98,
        3.96, 3.96, 3.95, 3.96, 3.97, 3.99, 4.00, 4.02, 4.03, 4.06,
        4.06, 4.06, 4.07, 4.09, 4.08, 4.09, 4.11, 4.09, 4.11, 4.15,
        4.15, 4.16, 4.18, 4.20, 4.20, 4.23, 4.24, 4.26, 4.27, 4.27,
        4.29, 4.29, 4.27, 4.30, 4.28, 4.28, 4.30, 4.31, 4.33, 4.35,
        4.36, 4.35, 4.34, 4.36, 4.35, 4.35, 4.36, 4.36, 4.36, 4.38,
        4.37, 4.37, 4.37, 4.39, 4.39, 4.40, 4.40, 4.40, 4.41, 4.43,
        4.46, 4.48, 4.49, 4.51, 4.53, 4.54, 4.57, 4.57, 4.57, 4.57,
        4.57, 4.60, 4.60, 4.60, 4.60, 4.63, 4.64, 4.65, 4.68, 4.69,
        4.71, 4.72, 4.74, 4.75, 4.72, 4.73, 4.74, 4.74, 4.72, 4.73,
        4.75, 4.76, 4.78, 4.78, 4.81, 4.81, 4.84, 4.84, 4.87, 4.89,
        4.86, 4.86, 4.86, 4.83, 4.84, 4.85, 4.86, 4.87, 4.90, 4.91,
        4.92, 4.94, 4.95, 4.96, 4.94, 4.95, 4.97, 4.96, 4.95, 4.97,
        4.97, 4.97, 4.99, 4.99, 4.99, 5.00, 5.02, 5.02, 5.03, 5.05,
        5.05, 5.07, 5.08, 5.08, 5.11, 5.11, 5.11, 5.08, 5.09, 5.09,
        5.09, 5.10, 5.11, 5.13, 5.13, 5.16, 5.16, 5.19, 5.20, 5.23,
        5.23, 5.24, 5.26, 5.28, 5.29, 5.31, 5.32, 5.35, 5.37, 5.38,
        5.40, 5.41, 5.43, 5.45, 5.47, 5.48, 5.50, 5.52, 5.55, 5.55,
        5.58, 5.58, 5.59, 5.60, 5.60, 5.61, 5.62, 5.63, 5.61, 5.63,
        5.64, 5.63, 5.65, 5.65, 5.65, 5.66, 5.67, 5.68, 5.71, 5.72,
        5.72, 5.72, 5.72, 5.74, 5.75, 5.75, 5.78, 5.79, 5.80, 5.80,
        5.83, 5.83, 5.84, 5.85, 5.87, 5.87, 5.88, 5.88, 5.90, 5.89,
        5.88, 5.89, 5.90, 5.90, 5.89, 5.87, 5.85, 5.88, 5.88, 5.88,
        5.88, 5.91, 5.91, 5.91, 5.91, 5.91, 5.91, 5.91, 5.91, 5.92,
        5.94, 5.95, 5.96, 5.98, 5.99, 5.99, 5.99, 5.99, 5.99, 6.02,
        6.02, 6.02, 6.04, 6.04, 6.04, 6.07, 6.07, 6.09, 6.10, 6.10,
        6.10, 6.11, 6.11, 6.11, 6.11, 6.11, 6.14, 6.14, 6.15, 6.17,
        6.17, 6.18, 6.19, 6.20, 6.22, 6.22, 6.23, 6.23, 6.25, 6.25,
        6.26, 6.28, 6.28, 6.29, 6.31, 6.31, 6.34, 6.36, 6.38, 6.39,
        6.42, 6.42, 6.42, 6.43, 6.46, 6.46, 6.46, 6.46, 6.46, 6.46,
        6.46, 6.48, 6.49, 6.50, 6.50, 6.53, 6.54, 6.54, 6.54, 6.57,
        6.57, 6.57, 6.57, 6.60, 6.60, 6.59, 6.59, 6.62, 6.61, 6.61,
        6.61, 6.63, 6.64, 6.64, 6.65, 6.68, 6.68, 6.68, 6.71, 6.71,
        6.73, 6.73, 6.76, 6.76, 6.76, 6.78, 6.79, 6.79, 6.80, 6.81,
        6.82, 6.82, 6.83, 6.83, 6.83, 6.84, 6.84, 6.85, 6.85, 6.85,
        6.84, 6.84, 6.84, 6.84, 6.84, 6.87, 6.87, 6.87, 6.90, 6.90,
        6.90, 6.90, 6.90, 6.90, 6.90, 6.91, 6.91, 6.90, 6.91, 6.92,
        6.92, 6.92, 6.92, 6.92, 6.93, 6.94, 6.93, 6.92, 6.92, 6.93,
        6.95, 6.95, 6.95, 6.95, 6.98, 6.98, 6.98, 6.98, 6.98, 6.98,
        6.98, 6.98, 6.98, 6.98, 6.99, 7.00, 7.00, 7.00, 7.01, 7.02,
        7.03, 7.03, 7.03, 7.02, 7.03, 7.03, 7.05, 7.05, 7.05, 7.05,
        7.06, 7.06, 7.06, 7.06, 7.10, 7.10, 7.10, 7.10, 7.10, 7.10,
        7.10, 7.10, 7.10, 7.10, 7.13, 7.13, 7.14, 7.16, 7.16, 7.17,
        7.18, 7.18, 7.18, 7.19, 7.19, 7.19, 7.19, 7.19, 7.19, 7.19,
        7.18, 7.18, 7.16, 7.16, 7.16, 7.17, 7.17, 7.17, 7.17, 7.16,
        7.18, 7.19, 7.19, 7.18, 7.17, 7.16, 7.16, 7.16, 7.16, 7.16,
        7.15, 7.14, 7.13, 7.13, 7.13, 7.11, 7.11, 7.11, 7.11, 7.11,
        7.11, 7.11, 7.11, 7.11, 7.11, 7.11, 7.11, 7.11, 7.10, 7.10,
        7.10, 7.10, 7.08, 7.06, 7.06, 7.05, 7.05, 7.03, 7.03, 7.03,
        7.03, 7.03, 7.05, 7.03, 7.03, 7.02, 7.02, 7.00, 7.00, 6.99,
        6.97, 6.94, 6.93, 6.92, 6.92, 6.91, 6.90, 6.90, 6.89, 6.91,
        6.90, 6.92, 6.92, 6.92, 6.92, 6.92, 6.92, 6.89, 6.88, 6.88,
        6.88, 6.86, 6.86, 6.85, 6.85, 6.85, 6.85, 6.84, 6.84, 6.84,
        6.84, 6.82, 6.81, 6.81, 6.78, 6.78, 6.78, 6.78, 6.78, 6.78,
        6.78, 6.78, 6.78, 6.78, 6.78, 6.78, 6.78, 6.78, 6.78, 6.78,
        6.81, 6.79, 6.79, 6.82, 6.81, 6.81, 6.82, 6.82, 6.82, 6.82,
        6.82, 6.82, 6.81, 6.81, 6.81, 6.80, 6.79, 6.79, 6.79, 6.78,
        6.78, 6.78, 6.78, 6.78, 6.76, 6.74, 6.74, 6.73, 6.71, 6.71,
        6.72, 6.73, 6.73, 6.70, 6.70, 6.70, 6.70, 6.69, 6.68, 6.68,
        6.67, 6.66, 6.66, 6.65, 6.62, 6.59, 6.58, 6.58, 6.58, 6.58,
        6.58, 6.58, 6.58, 6.55, 6.55, 6.55, 6.54, 6.52, 6.52, 6.52,
        6.52, 6.52, 6.52, 6.52, 6.52, 6.50, 6.48, 6.47, 6.46, 6.45,
        6.44, 6.44, 6.44, 6.44, 6.41, 6.41, 6.41, 6.41, 6.39, 6.38,
        6.38, 6.38, 6.38, 6.38, 6.37, 6.34, 6.33, 6.33, 6.33, 6.33,
        6.33, 6.33, 6.33, 6.33, 6.32, 6.30, 6.29, 6.29, 6.28, 6.28,
        6.26, 6.25, 6.26, 6.25, 6.25, 6.22, 6.22, 6.25, 6.25, 6.26,
        6.28, 6.28, 6.30, 6.30, 6.30, 6.28, 6.26, 6.28, 6.27, 6.26,
        6.27, 6.30, 6.30, 6.30, 6.31, 6.33, 6.32, 6.33, 6.33, 6.34,
        6.34, 6.34, 6.35, 6.36, 6.35, 6.34, 6.36, 6.36, 6.35, 6.37,
        6.36, 6.35, 6.38, 6.36, 6.36, 6.38, 6.39, 6.39, 6.39, 6.39,
        6.37, 6.38, 6.36, 6.34, 6.34, 6.34, 6.34, 6.34, 6.36, 6.35,
        6.34, 6.35, 6.34, 6.33, 6.32, 6.32, 6.30, 6.27, 6.28, 6.27,
        6.24, 6.23, 6.22, 6.20, 6.20, 6.18, 6.18, 6.20, 6.19, 6.20,
        6.21, 6.20, 6.22, 6.22, 6.20, 6.20, 6.18, 6.17, 6.15, 6.14,
        6.12, 6.14, 6.14, 6.14, 6.15, 6.14, 6.12, 6.12, 6.10, 6.09,
        6.09, 6.08, 6.06, 6.06, 6.03, 6.01, 5.99, 5.98, 5.98, 5.98,
        5.98, 5.98, 5.98, 5.98, 5.95, 5.95, 5.94, 5.92, 5.93, 5.93,
        5.93, 5.93, 5.93, 5.93, 5.93, 5.93, 5.93, 5.93, 5.93, 5.93,
        5.92, 5.90, 5.89, 5.88, 5.84, 5.84, 5.82, 5.82, 5.82, 5.80,
        5.80, 5.79, 5.79, 5.79, 5.79, 5.79, 5.79, 5.79, 5.79, 5.79,
        5.79, 5.79, 5.80, 5.80, 5.80, 5.80, 5.80, 5.79, 5.79, 5.78,
        5.76, 5.77, 5.78, 5.77, 5.78, 5.77, 5.77, 5.77, 5.79, 5.77,
        5.77, 5.79, 5.79, 5.80, 5.79, 5.79, 5.78, 5.77, 5.75, 5.74,
        5.74, 5.74, 5.75, 5.75, 5.74, 5.74, 5.75, 5.78, 5.77, 5.77,
        5.77, 5.77, 5.81, 5.82, 5.82, 5.79, 5.76, 5.76, 5.76, 5.78,
        5.79, 5.78, 5.78, 5.80, 5.82, 5.88, 5.87, 5.85, 5.86, 5.89,
        5.90, 5.87, 5.83, 5.85, 5.87, 5.87, 5.86, 5.85, 5.88, 5.90,
        5.89, 5.91, 5.91, 5.92, 5.92, 5.92, 5.92, 5.93, 5.93, 5.92,
        5.91, 5.90, 5.90, 5.90, 5.97, 5.96, 5.95, 5.95, 6.06, 6.04,
        6.03, 6.02, 6.05, 6.06, 6.07, 6.06, 6.06, 6.06, 6.06, 6.06,
        6.06, 6.07, 6.06, 6.06, 6.06, 6.06, 6.04, 6.04, 6.06, 6.07,
        6.08, 6.07, 6.08, 6.07, 6.06, 6.06, 6.08, 6.07, 6.06, 6.07,
        6.06, 6.07, 6.07, 6.06, 6.08, 6.07, 6.09, 6.09, 6.11, 6.12,
        6.15, 6.17, 6.17, 6.15, 6.14, 6.14, 6.15, 6.17, 6.17, 6.15,
        6.15, 6.15, 6.15, 6.16, 6.18, 6.17, 6.18, 6.20, 6.20, 6.20,
        6.21, 6.21, 6.21, 6.21, 6.22, 6.22, 6.22, 6.22, 6.22, 6.21,
        6.22, 6.25, 6.26, 6.27, 6.30, 6.30, 6.30, 6.30, 6.30, 6.30,
        6.30, 6.30, 6.31, 6.32, 6.32, 6.32, 6.33, 6.33, 6.33, 6.33,
        6.34, 6.34, 6.35, 6.36, 6.36, 6.36, 6.36, 6.36, 6.36, 6.36,
        6.36, 6.36, 6.36, 6.38, 6.39, 6.41, 6.42, 6.42, 6.42, 6.42,
        6.42, 6.42, 6.42, 6.44, 6.44, 6.44, 6.46, 6.46, 6.47, 6.45,
        6.46, 6.47, 6.47, 6.47, 6.49, 6.49, 6.48, 6.46, 6.47, 6.49,
        6.49, 6.49, 6.49, 6.46, 6.46, 6.47, 6.50, 6.48, 6.47, 6.50,
        6.50, 6.50, 6.49, 6.49, 6.49, 6.49, 6.47, 6.47, 6.44, 6.43,
        6.41, 6.42, 6.41, 6.42, 6.40, 6.40, 6.42, 6.44, 6.43, 6.41,
        6.41, 6.41, 6.38, 6.36, 6.33, 6.32, 6.32, 6.31, 6.28, 6.28,
        6.30, 6.29, 6.28, 6.28, 6.27, 6.26, 6.24, 6.24, 6.25, 6.25,
        6.23, 6.24, 6.23, 6.21, 6.20, 6.20, 6.19, 6.17, 6.14, 6.14,
        6.10, 6.07, 6.07, 6.03, 6.01, 6.01, 6.00, 6.01
    };

    static const float * const fletcher_munson_curves[] =
    {
        fletcher_munson_curve_0_phons,
        fletcher_munson_curve_10_phons,
        fletcher_munson_curve_20_phons,
        fletcher_munson_curve_30_phons,
        fletcher_munson_curve_40_phons,
        fletcher_munson_curve_50_phons,
        fletcher_munson_curve_60_phons,
        fletcher_munson_curve_70_phons,
        fletcher_munson_curve_80_phons,
        fletcher_munson_curve_90_phons
    };

    static const freq_curve_t fletcher_munson_curve =
    {
        24.85, // fmin
        16075.11, // fmax
        0.00, // amin
        90.00, // amax
        1383, // hdots
        10, // curves
        fletcher_munson_curves // curve data
    };
}

#endif /* GENERATED_ISO226_FLETCHER_MUNSON_H_ */
