<?php
/*
# Copyright 2004, Revolution Linux Inc., Nicolas Dufresne
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
	$first_start = FALSE;
	if (!is_readable("util/config.php") || !filesize("util/config.php")) {
		$first_start = TRUE;
	} else {
		$file_stat=lstat("util/config.php");
		$size=$file_stat["size"];
		if ($size == 0) {
			$first_start = TRUE;
		}
	}
	require_once 'util/functions.php';
	require_once 'util/SessionData.php';
	if($CONFIG['first_setup_lock']== "FALSE")
		$first_start = TRUE;
	if ($first_start) {
		require_once "util/setup.php";
		die();
	}
	require_once "util/".$CONFIG['auth_name'].".php";
	// Be sure HTTPS is in use
	if ($CONFIG['use_https']=="true" && !use_https()) die(getMessage('need_https'));

	// Removing previous session
	session_start();
	session_unset();
	session_destroy();
	// Making sure session ID is not a user choice one
	unset($_GET['PHPSESSID']);
	unset($_POST['PHPSESSID']);
	unset($_COOKIE['PHPSESSID']);

	if (isset($_POST['loginSubmit']) || $CONFIG['auth_name']=="EmptyAuth") {
		$auth = new Auth($_POST['login'],$_POST['password']);
		if ($error = $auth->authenticate())
			$ERRORS[] = $error;
		else {
			session_start();
			$_SESSION['auth_state'] = true;
			$_SESSION['groups'] = $auth->getUserData();
			if($CONFIG['auth_name'] == "EmptyAuth"){
				$_SESSION['userRole']="Superadmin";
			}else{
				$_SESSION['userRole']=getUserRole($auth->getUserData());
			}

			ltsp_goto('admin.php');
			die(getMessage('good_login'));
		}
	}

	// Print standard header
	printHead('admin_title');

	// Print page
	include "util/loginView.php";
?>
