# Lua HyperLogLog Module

## Overview
HyperLogLog is an algorithm for the count-distinct problem, approximating the
number of distinct elements in a multiset (the cardinality).

## Module

### Example Usage
```lua
require "hyperloglog"

local hll = hyperloglog.new()
hll:add("test")
local estimate = hll:count()
-- estimate == 1

```

### Functions

#### new
```lua
require "hyperloglog"
local hll = hyperloglog.new()
```

Import Lua _hyperloglog_ via the Lua 'require' function. The module is
globally registered and returned by the require function. The _new_ function
takes no arguments and returns a hyperloglog userdata object.

#### version
```lua
local v = hyperloglog.version()
-- v == "0.1.0"
```

Returns a string with the running version of hyperloglog.

*Arguments*
- none

*Return*
- Semantic version string

#### count
```lua
local estimate = hyperloglog.count(hll, hll1, ... hlln)
```

Returns the approximated number of distinct items in the merged set.

*Arguments*
- hyperloglog (userdata) - Two or more hyperloglog userdata objects.

*Return*
- estimate (number) - count of distinct items.


### Methods

#### add
```lua
local altered = hll:add(key)
```

Adds an item to the hyperloglog.

*Arguments*
- key (string/number) The item key to add to the hyperloglog.

*Return*
- True if the estimate was altered, false if it remains unchanged.

#### merge
```lua
hll:merge(hll1)
```

Merges the provided hyperloglog into the current object.

*Arguments*
- hyperloglog (userdata) A single hyperloglog object to be merged.

*Return*
- self (userdata)

#### count
```lua
local estimate = hll:count()
```

Returns the approximated number of distinct items in the set.

*Arguments*
- none

*Return*
- estimate (number) - count of distinct items.

#### clear
```lua
hll:clear()
```

Resets the hyperloglog to an empty set.

*Arguments*
- none

*Return*
- none

#### fromstring
```lua
hll:fromstring(str)
```

Loads the tostring() representation back into a hyperloglog user data object.

*Arguments*
- hll_str (string) - hyperloglog representation generated by tostring()

*Return*
- none
