//
//  Lynkeos
//  $Id: MyImageListEnumerator.m,v 1.5 2005/01/27 23:07:03 j-etienne Exp $
//
//  Created by Jean-Etienne LAMIAUD on Sun Nov 30 2003.
//  Copyright (c) 2003-2005. Jean-Etienne LAMIAUD
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

#import "MyImageList.h"

@implementation MyImageListEnumerator

- (id) initWithImageList :(NSArray*)list startAt:(id)item
              directSense:(BOOL)direct
{
   [super init];

   _lock = [[NSRecursiveLock alloc] init];

   _itemList = [list retain];
   _listSize = [list count];
   _step = (direct ? 1 : -1);
   if ( item != nil )
   {
      if ( [item isMemberOfClass: [MyMovieImage class]] )
      {
         _currentMovie = [item getParent];
         _movieSize = [_currentMovie numberOfImages];
         _itemIndex = [list indexOfObject:_currentMovie];
         _movieIndex = [_currentMovie indexOfImage:item]+_step;
         if ( (_step > 0 && _movieIndex >= _movieSize) || 
               (_step < 0 && _movieIndex < 0) )
               _itemIndex += _step;
      }
      else if ( [item isMemberOfClass: [MyMovie class]] )
      {
         _currentMovie = item;
         _movieSize = [_currentMovie numberOfImages];
         _itemIndex = [list indexOfObject:_currentMovie];
         _movieIndex = (direct ? 0 : -1);
      }
      else
      {
         _currentMovie = nil;
         _movieSize = 0;
         _itemIndex = [list indexOfObject:item]+_step;
         _movieIndex = 0;            
      }
   }
   else
   {
      _currentMovie = nil;
      _movieSize = 0;
      _itemIndex = (direct ? 0 : _listSize-1);
      _movieIndex = 0;
   }

   return( self );
}

- (id) initWithImageList :(NSArray*)list
{
   return( [self initWithImageList:list startAt:nil directSense:YES] );
}

- (void) dealloc
{
   [_lock release];
   [_itemList release];
   [super dealloc];
}

- (NSArray *) allObjects
{
   NSMutableArray *array = [NSArray array];
   id item;

   [_lock lock];

   while ( (item = [self nextObject]) != nil )
      [array addObject:item];

   [_lock unlock];
   
   return( array );
}

- (id) nextObject
{
   id item = nil;

   [_lock lock];
   
   while ( item == nil &&
           ( ( _step > 0 && _itemIndex < _listSize) || 
             ( _step < 0 && _itemIndex >= 0) ) )
   {
      // Look for an image item (inside a movie or self contained)
      if ( _currentMovie == nil ||
           (_step > 0 && _movieIndex >= _movieSize) || 
           (_step < 0 && _movieIndex < 0) )
      {
         item = [_itemList objectAtIndex:_itemIndex];
         if ( [item isMemberOfClass: [MyMovie class]] )
         {
            _movieSize = [item numberOfImages];
            _currentMovie = item;
            item = nil;
            _movieIndex = (_step > 0 ? 0 : _movieSize-1);
         }
         else
            _itemIndex += _step;
      }

      if ( _currentMovie != nil )
      {
         if ( (_step > 0 && _movieIndex < _movieSize) || 
            (_step < 0 && _movieIndex >= 0) )
         {
            item = [_currentMovie getMovieImageAtIndex:_movieIndex];
            _movieIndex += _step;
         }
         if ( (_step > 0 && _movieIndex >= _movieSize) || 
              (_step < 0 && _movieIndex < 0) )
            _itemIndex += _step;
      }
   }

   [_lock unlock];
   
   return( item );
}

@end
