//
//  Lynkeos
//  $Id: MyObjectImageList.h,v 1.1 2004/08/09 22:39:11 j-etienne Exp $
//
//  Created by Jean-Etienne LAMIAUD on Wed Sep 24 2003.
//  Copyright (c) 2003-2004. Jean-Etienne LAMIAUD
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

#ifndef __MYOBJECTIMAGELIST_H
#define __MYOBJECTIMAGELIST_H

#ifdef GNUSTEP
#else
#import <Cocoa/Cocoa.h>
#endif

#include "MyImageList.h"

@class MyImageListData;	// Compatibility with V0 file format */

// The image list being processed
@interface MyObjectImageList : MyImageList
{
@private
   // Align data
   MyImageListItem*	_referenceItem;
   MyIntegerPoint       _searchSquareOrigin;
   u_short		_searchSquareSide;
   // Analyze data
   MyIntegerPoint       _analyzeSquareOrigin;
   u_short		_analyzeSquareSide;
   double		_minQuality, _maxQuality;
   double		_selectThreshold;
   // Stack data
   u_short		_sizeFactor;
   MyIntegerRect        _cropRectangle;
   // Process data
   double		_dRadius, _dThreshold;
   double		_uRadius, _uGain;
}

// Read accessors
   // Align data
- (MyImageListItem*) referenceItem;
- (MyIntegerPoint) searchSquareOrigin ;
- (u_short) searchSquareSide ;
   // Analyze data
- (MyIntegerPoint) analyzeSquareOrigin ;
- (u_short) analyzeSquareSide ;
- (double) minQuality ;
- (double) maxQuality ;
- (double) qualityThreshold ;
   // Stack data
- (MyIntegerRect) cropRectangle ;
- (u_short) sizeFactor;
   // Process data
- (double) dRadius;
- (double) dThreshold;
- (double) uRadius;
- (double) uGain;

// Write accessors (returns YES if object was changed
   // Align data
- (BOOL) setReferenceItem :(MyImageListItem*)item ;
- (BOOL) setSearchSquareOrigin :(MyIntegerPoint)o ;
- (BOOL) setSearchSquareSide :(u_short)side;
   // Analyze data
- (BOOL) setAnalyzeSquareOrigin :(MyIntegerPoint)o ;
- (BOOL) setAnalyzeSquareSide : (u_short)side ;
- (BOOL) setMinQuality :(double)q ;
- (BOOL) setMaxQuality :(double)q ;
- (BOOL) setSelectThreshold :(double) t ;
   // Stack data
- (BOOL) setCropRectangle :(MyIntegerRect)rect ;
- (BOOL) setSizeFactor :(u_short)sf ;
   // Process data
- (BOOL) setProcessParameters :(double)dRadius :(double)dThreshold
                              :(double)uRadius :(double)uGain ;

// Actions
   // Analyze data
- (BOOL) updateMinMaxQuality ;
- (BOOL) autoSelect :(double)selectThreshold;

// Initializers and constructors
- (id) initWithImageListData :(MyImageListData*)data ;

@end

#endif
