# $Id: Graph.pm,v 1.3 2013/07/17 18:31:46 tom Exp $

package Cdk::Graph;

@ISA = qw (Cdk);

#
# This creates a new Graph object.
#
sub new {
    my $type   = shift;
    my %params = @_;
    my $self   = {};
    my $name   = "${type}::new";

    # Retain the type of the object.
    $self->{'Type'} = $type;

    # Set up the parameters passed in.
    my $xtitle = Cdk::checkReq( $name, "Xtitle", $params{'Xtitle'} );
    my $ytitle = Cdk::checkReq( $name, "ytitle", $params{'Ytitle'} );
    my $height = Cdk::checkReq( $name, "Height", $params{'Height'} );
    my $width  = Cdk::checkReq( $name, "Width",  $params{'Width'} );
    my $title = Cdk::checkDef( $name, "Title", $params{'Title'}, "" );
    my $xpos  = Cdk::checkDef( $name, "Xpos",  $params{'Xpos'},  "CENTER" );
    my $ypos  = Cdk::checkDef( $name, "Ypos",  $params{'Ypos'},  "CENTER" );

    # Create the thing.
    $self->{'Me'} =
      Cdk::Graph::New( $title, $xtitle, $ytitle, $height, $width, $xpos,
        $ypos );
    bless $self;
}

#
# This sets several parameters of the widget.
#
sub set {
    my $self   = shift;
    my %params = @_;
    my $name   = "$self->{'Type'}::set";

    #
    # Check the parameters sent in.
    #
    if ( defined $params{'Values'} ) {
        my $startAtZero = $params{'StartAtZero'} || 1;
        Cdk::Graph::SetValues( $self->{'Me'}, $params{'Values'}, $startAtZero );
    }
    if ( defined $params{'GraphChars'} ) {
        Cdk::Graph::SetCharacters( $self->{'Me'}, $params{'GraphChars'} );
    }
    if ( defined $params{'DisplayType'} ) {
        Cdk::Graph::SetDisplayType( $self->{'Me'}, $params{'DisplayType'} );
    }
    if ( defined $params{'ULChar'} ) {
        Cdk::Graph::SetULChar( $self->{'Me'}, $params{'ULChar'} );
    }
    if ( defined $params{'URChar'} ) {
        Cdk::Graph::SetURChar( $self->{'Me'}, $params{'URChar'} );
    }
    if ( defined $params{'LLChar'} ) {
        Cdk::Graph::SetLLChar( $self->{'Me'}, $params{'LLChar'} );
    }
    if ( defined $params{'LRChar'} ) {
        Cdk::Graph::SetLRChar( $self->{'Me'}, $params{'LRChar'} );
    }
    if ( defined $params{'VChar'} ) {
        Cdk::Graph::SetVerticalChar( $self->{'Me'}, $params{'VChar'} );
    }
    if ( defined $params{'HChar'} ) {
        Cdk::Graph::SetHorizontalChar( $self->{'Me'}, $params{'HChar'} );
    }
    if ( defined $params{'BoxAttribute'} ) {
        Cdk::Graph::SetBoxAttribute( $self->{'Me'}, $params{'BoxAttribute'} );
    }
    if ( defined $params{'BGColor'} ) {
        Cdk::Graph::SetBackgroundColor( $self->{'Me'}, $params{'BGColor'} );
    }
    if ( defined $params{'Box'} ) {
        Cdk::Graph::SetBox( $self->{'Me'}, $params{'Box'} );
    }
}

#
# This draws the object.
#
sub draw {
    my $self   = shift;
    my %params = @_;
    my $name   = "$self->{'Type'}::draw";

    # Set up the parameters passed in.
    my $box = Cdk::checkDef( $name, "Box", $params{'Box'}, "FALSE" );

    # Draw the object.
    Cdk::Graph::Draw( $self->{'Me'}, $box );
    return 1;
}

#
# This erases the object.
#
sub erase {
    my $self = shift;
    Cdk::Graph::Erase( $self->{'Me'} );
}

#
# This function raises the object.
#
sub raise {
    my $self = shift;
    Cdk::Graph::Raise( $self->{'Me'} );
}

#
# This function lowers the object.
#
sub lower {
    my $self = shift;
    Cdk::Graph::Lower( $self->{'Me'} );
}

#
# This function registers the object.
#
sub register {
    my $self = shift;
    Cdk::Graph::Register( $self->{'Me'} );
}

#
# This function unregisters the object.
#
sub unregister {
    my $self = shift;
    Cdk::Graph::Unregister( $self->{'Me'} );
}

#
# This function returns the pointer to the window.
#
sub getwin {
    my $self = shift;
    Cdk::Graph::GetWindow( $self->{'Me'} );
}

1;
